#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
/*
 * DDBalance.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbrpc/DDSketch.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct DDBalanceWorkload : TestWorkload {
	static constexpr auto NAME = "DDBalance";
	int actorsPerClient, nodesPerActor, moversPerClient, currentbin, binCount, writesPerTransaction,
	    keySpaceDriftFactor;
	double testDuration, warmingDelay, transactionsPerSecond;
	bool discardEdgeMeasurements;

	std::vector<Future<Void>> clients;
	PerfIntCounter bin_shifts, operations, retries;
	DDSketch<double> latencies;

	DDBalanceWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), bin_shifts("Bin_Shifts"), operations("Operations"), retries("Retries"), latencies() {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		binCount = getOption(options, "binCount"_sr, 1000);
		writesPerTransaction = getOption(options, "writesPerTransaction"_sr, 1);
		keySpaceDriftFactor = getOption(options, "keySpaceDriftFactor"_sr, 1);
		moversPerClient = std::max(getOption(options, "moversPerClient"_sr, 10), 1);
		actorsPerClient = std::max(getOption(options, "actorsPerClient"_sr, 100), 1);
		int nodes = getOption(options, "nodes"_sr, 10000);
		discardEdgeMeasurements = getOption(options, "discardEdgeMeasurements"_sr, true);
		warmingDelay = getOption(options, "warmingDelay"_sr, 0.0);
		transactionsPerSecond =
		    getOption(options, "transactionsPerSecond"_sr, 5000.0) / (clientCount * moversPerClient);

		nodesPerActor = nodes / (actorsPerClient * clientCount);

		currentbin = deterministicRandom()->randomInt(0, binCount);
	}

	Future<Void> setup(Database const& cx) override { return ddbalanceSetup(cx, this); }

	Future<Void> start(Database const& cx) override { return _start(cx, this); }

																#line 63 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 61 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
template <class _startActor>
															#line 61 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
class _startActorState {
															#line 69 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
public:
															#line 61 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	_startActorState(Database const& cx,DDBalanceWorkload* const& self) 
															#line 61 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
															#line 61 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		 : cx(cx),
															#line 61 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   self(self)
															#line 78 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 62 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			for(int c = 0;c < self->moversPerClient;c++) {
															#line 63 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
				self->clients.push_back(timeout(self->ddBalanceMover(cx, self, c), self->testDuration, Void()));
															#line 95 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			}
															#line 64 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(self->clients);
															#line 64 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 101 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 64 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 106 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 65 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 129 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 65 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 141 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 61 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	Database cx;
															#line 61 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	DDBalanceWorkload* self;
															#line 228 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 61 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 233 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4881464651179649792UL, 14018757044336755712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 61 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	_startActor(Database const& cx,DDBalanceWorkload* const& self) 
															#line 250 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 61 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, DDBalanceWorkload* const& self ) {
															#line 61 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 282 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
}

#line 67 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"

	Future<bool> check(Database const& cx) override {
		bool ok = true;
		for (int i = 0; i < clients.size(); i++)
			if (clients[i].isError())
				ok = false;
		clients.clear();
		return ok;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		double duration = testDuration * (discardEdgeMeasurements ? 0.75 : 1.0);
		m.emplace_back("Operations/sec", operations.getValue() / duration, Averaged::False);
		m.push_back(operations.getMetric());
		m.push_back(retries.getMetric());
		m.push_back(bin_shifts.getMetric());
		m.emplace_back("Mean Latency (ms)", 1000 * latencies.mean(), Averaged::True);
		m.emplace_back("Median Latency (ms, averaged)", 1000 * latencies.median(), Averaged::True);
		m.emplace_back("90% Latency (ms, averaged)", 1000 * latencies.percentile(0.90), Averaged::True);
		m.emplace_back("98% Latency (ms, averaged)", 1000 * latencies.percentile(0.98), Averaged::True);
	}

	Key key(int bin, int n, int actorid, int clientid) {
		return StringRef(format("%08x%08x%08x%08x", bin, n, actorid, clientid));
	}

	Value value(int n) { return doubleToTestKey(n); }

																#line 314 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
// This generated class is to be used only via setKeyIfNotPresent()
															#line 95 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
template <class SetKeyIfNotPresentActor>
															#line 95 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
class SetKeyIfNotPresentActorState {
															#line 320 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
public:
															#line 95 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	SetKeyIfNotPresentActorState(Transaction* const& tr,Key const& key,Value const& val) 
															#line 95 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
															#line 95 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		 : tr(tr),
															#line 95 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   key(key),
															#line 95 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   val(val)
															#line 331 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
	{
		fdb_probe_actor_create("setKeyIfNotPresent", reinterpret_cast<unsigned long>(this));

	}
	~SetKeyIfNotPresentActorState() 
	{
		fdb_probe_actor_destroy("setKeyIfNotPresent", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 96 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(key);
															#line 96 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			if (static_cast<SetKeyIfNotPresentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 348 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetKeyIfNotPresentActor*>(this)->actor_wait_state = 1;
															#line 96 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetKeyIfNotPresentActor, 0, Optional<Value> >*>(static_cast<SetKeyIfNotPresentActor*>(this)));
															#line 353 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetKeyIfNotPresentActorState();
		static_cast<SetKeyIfNotPresentActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& f,int loopDepth) 
	{
															#line 97 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (!f.present())
															#line 376 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		{
															#line 98 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			tr->set(key, val);
															#line 380 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		}
															#line 99 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (!static_cast<SetKeyIfNotPresentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetKeyIfNotPresentActorState(); static_cast<SetKeyIfNotPresentActor*>(this)->destroy(); return 0; }
															#line 384 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		new (&static_cast<SetKeyIfNotPresentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetKeyIfNotPresentActorState();
		static_cast<SetKeyIfNotPresentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && f,int loopDepth) 
	{
															#line 97 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (!f.present())
															#line 396 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		{
															#line 98 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			tr->set(key, val);
															#line 400 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		}
															#line 99 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (!static_cast<SetKeyIfNotPresentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetKeyIfNotPresentActorState(); static_cast<SetKeyIfNotPresentActor*>(this)->destroy(); return 0; }
															#line 404 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		new (&static_cast<SetKeyIfNotPresentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetKeyIfNotPresentActorState();
		static_cast<SetKeyIfNotPresentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& f,int loopDepth) 
	{
		loopDepth = a_body1cont1(f, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && f,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetKeyIfNotPresentActor*>(this)->actor_wait_state > 0) static_cast<SetKeyIfNotPresentActor*>(this)->actor_wait_state = 0;
		static_cast<SetKeyIfNotPresentActor*>(this)->ActorCallback< SetKeyIfNotPresentActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< SetKeyIfNotPresentActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("setKeyIfNotPresent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeyIfNotPresentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeyIfNotPresent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetKeyIfNotPresentActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("setKeyIfNotPresent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeyIfNotPresentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeyIfNotPresent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetKeyIfNotPresentActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("setKeyIfNotPresent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeyIfNotPresentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeyIfNotPresent", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 95 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	Transaction* tr;
															#line 95 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	Key key;
															#line 95 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	Value val;
															#line 493 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
};
// This generated class is to be used only via setKeyIfNotPresent()
															#line 95 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
class SetKeyIfNotPresentActor final : public Actor<Void>, public ActorCallback< SetKeyIfNotPresentActor, 0, Optional<Value> >, public FastAllocated<SetKeyIfNotPresentActor>, public SetKeyIfNotPresentActorState<SetKeyIfNotPresentActor> {
															#line 498 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
public:
	using FastAllocated<SetKeyIfNotPresentActor>::operator new;
	using FastAllocated<SetKeyIfNotPresentActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10665696795277828608UL, 10196676485574108160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetKeyIfNotPresentActor, 0, Optional<Value> >;
															#line 95 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	SetKeyIfNotPresentActor(Transaction* const& tr,Key const& key,Value const& val) 
															#line 515 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		 : Actor<Void>(),
		   SetKeyIfNotPresentActorState<SetKeyIfNotPresentActor>(tr, key, val),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setKeyIfNotPresent", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9481824364476568064UL, 8823576212778222592UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeyIfNotPresentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setKeyIfNotPresent");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setKeyIfNotPresent", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetKeyIfNotPresentActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 95 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
[[nodiscard]] Future<Void> setKeyIfNotPresent( Transaction* const& tr, Key const& key, Value const& val ) {
															#line 95 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	return Future<Void>(new SetKeyIfNotPresentActor(tr, key, val));
															#line 547 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
}

#line 101 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"

																#line 552 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
// This generated class is to be used only via ddbalanceSetupRange()
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
template <class DdbalanceSetupRangeActor>
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
class DdbalanceSetupRangeActorState {
															#line 558 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
public:
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	DdbalanceSetupRangeActorState(Database const& cx,DDBalanceWorkload* const& self,int const& begin,int const& end) 
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		 : cx(cx),
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   self(self),
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   begin(begin),
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   end(end),
															#line 103 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   tr(cx)
															#line 573 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
	{
		fdb_probe_actor_create("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this));

	}
	~DdbalanceSetupRangeActorState() 
	{
		fdb_probe_actor_destroy("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 104 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			;
															#line 588 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DdbalanceSetupRangeActorState();
		static_cast<DdbalanceSetupRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 120 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (!static_cast<DdbalanceSetupRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DdbalanceSetupRangeActorState(); static_cast<DdbalanceSetupRangeActor*>(this)->destroy(); return 0; }
															#line 611 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		new (&static_cast<DdbalanceSetupRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DdbalanceSetupRangeActorState();
		static_cast<DdbalanceSetupRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 106 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			std::vector<Future<Void>> setActors;
															#line 107 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			for(int n = begin;n < end;n++) {
															#line 108 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
				int objectnum = n / self->moversPerClient;
															#line 109 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
				int moverid = n % self->moversPerClient;
															#line 110 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
				setActors.push_back(self->setKeyIfNotPresent( &tr, self->key(self->currentbin, objectnum, moverid, self->clientId), self->value(objectnum)));
															#line 639 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			}
															#line 113 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(setActors);
															#line 113 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			if (static_cast<DdbalanceSetupRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 645 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DdbalanceSetupRangeActor*>(this)->actor_wait_state = 1;
															#line 113 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DdbalanceSetupRangeActor, 0, Void >*>(static_cast<DdbalanceSetupRangeActor*>(this)));
															#line 650 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 117 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 117 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			if (static_cast<DdbalanceSetupRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 687 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DdbalanceSetupRangeActor*>(this)->actor_wait_state = 3;
															#line 117 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DdbalanceSetupRangeActor, 2, Void >*>(static_cast<DdbalanceSetupRangeActor*>(this)));
															#line 692 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 114 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 114 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (static_cast<DdbalanceSetupRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 709 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DdbalanceSetupRangeActor*>(this)->actor_wait_state = 2;
															#line 114 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DdbalanceSetupRangeActor, 1, Void >*>(static_cast<DdbalanceSetupRangeActor*>(this)));
															#line 714 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 114 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 114 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (static_cast<DdbalanceSetupRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 725 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DdbalanceSetupRangeActor*>(this)->actor_wait_state = 2;
															#line 114 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DdbalanceSetupRangeActor, 1, Void >*>(static_cast<DdbalanceSetupRangeActor*>(this)));
															#line 730 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DdbalanceSetupRangeActor*>(this)->actor_wait_state > 0) static_cast<DdbalanceSetupRangeActor*>(this)->actor_wait_state = 0;
		static_cast<DdbalanceSetupRangeActor*>(this)->ActorCallback< DdbalanceSetupRangeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DdbalanceSetupRangeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdbalanceSetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DdbalanceSetupRangeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdbalanceSetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DdbalanceSetupRangeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdbalanceSetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DdbalanceSetupRangeActor*>(this)->actor_wait_state > 0) static_cast<DdbalanceSetupRangeActor*>(this)->actor_wait_state = 0;
		static_cast<DdbalanceSetupRangeActor*>(this)->ActorCallback< DdbalanceSetupRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DdbalanceSetupRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdbalanceSetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DdbalanceSetupRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdbalanceSetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DdbalanceSetupRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdbalanceSetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DdbalanceSetupRangeActor*>(this)->actor_wait_state > 0) static_cast<DdbalanceSetupRangeActor*>(this)->actor_wait_state = 0;
		static_cast<DdbalanceSetupRangeActor*>(this)->ActorCallback< DdbalanceSetupRangeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DdbalanceSetupRangeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdbalanceSetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DdbalanceSetupRangeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdbalanceSetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DdbalanceSetupRangeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdbalanceSetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	Database cx;
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	DDBalanceWorkload* self;
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	int begin;
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	int end;
															#line 103 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	Transaction tr;
															#line 994 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
};
// This generated class is to be used only via ddbalanceSetupRange()
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
class DdbalanceSetupRangeActor final : public Actor<Void>, public ActorCallback< DdbalanceSetupRangeActor, 0, Void >, public ActorCallback< DdbalanceSetupRangeActor, 1, Void >, public ActorCallback< DdbalanceSetupRangeActor, 2, Void >, public FastAllocated<DdbalanceSetupRangeActor>, public DdbalanceSetupRangeActorState<DdbalanceSetupRangeActor> {
															#line 999 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
public:
	using FastAllocated<DdbalanceSetupRangeActor>::operator new;
	using FastAllocated<DdbalanceSetupRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11309412348606348032UL, 6293139204804627200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DdbalanceSetupRangeActor, 0, Void >;
friend struct ActorCallback< DdbalanceSetupRangeActor, 1, Void >;
friend struct ActorCallback< DdbalanceSetupRangeActor, 2, Void >;
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	DdbalanceSetupRangeActor(Database const& cx,DDBalanceWorkload* const& self,int const& begin,int const& end) 
															#line 1018 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		 : Actor<Void>(),
		   DdbalanceSetupRangeActorState<DdbalanceSetupRangeActor>(cx, self, begin, end),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8310473395280534784UL, 8764176234599798528UL);
		ActorExecutionContextHelper __helper(static_cast<DdbalanceSetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ddbalanceSetupRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ddbalanceSetupRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DdbalanceSetupRangeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DdbalanceSetupRangeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DdbalanceSetupRangeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
[[nodiscard]] Future<Void> ddbalanceSetupRange( Database const& cx, DDBalanceWorkload* const& self, int const& begin, int const& end ) {
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	return Future<Void>(new DdbalanceSetupRangeActor(cx, self, begin, end));
															#line 1052 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
}

#line 122 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"

																#line 1057 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
// This generated class is to be used only via ddbalanceSetup()
															#line 123 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
template <class DdbalanceSetupActor>
															#line 123 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
class DdbalanceSetupActorState {
															#line 1063 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
public:
															#line 123 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	DdbalanceSetupActorState(Database const& cx,DDBalanceWorkload* const& self) 
															#line 123 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
															#line 123 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		 : cx(cx),
															#line 123 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   self(self),
															#line 124 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   i(),
															#line 125 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   order()
															#line 1076 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
	{
		fdb_probe_actor_create("ddbalanceSetup", reinterpret_cast<unsigned long>(this));

	}
	~DdbalanceSetupActorState() 
	{
		fdb_probe_actor_destroy("ddbalanceSetup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 127 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			for(int o = 0;o <= self->nodesPerActor * self->actorsPerClient / 10;o++) {
															#line 128 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
				order.push_back(o * 10);
															#line 1093 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			}
															#line 130 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			deterministicRandom()->randomShuffle(order);
															#line 131 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			i = 0;
															#line 1099 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DdbalanceSetupActorState();
		static_cast<DdbalanceSetupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 140 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (self->warmingDelay > 0)
															#line 1122 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		{
															#line 141 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			StrictFuture<Void> __when_expr_1 = timeout(databaseWarmer(cx), self->warmingDelay, Void());
															#line 141 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			if (static_cast<DdbalanceSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1128 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DdbalanceSetupActor*>(this)->actor_wait_state = 2;
															#line 141 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DdbalanceSetupActor, 1, Void >*>(static_cast<DdbalanceSetupActor*>(this)));
															#line 1133 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 131 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (!(i < order.size()))
															#line 1154 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 132 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		std::vector<Future<Void>> fs;
															#line 133 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		for(int j = 0;j < 100 && i < order.size();j++) {
															#line 134 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			fs.push_back(self->ddbalanceSetupRange(cx, self, order[i], order[i] + 10));
															#line 135 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			i++;
															#line 1166 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		}
															#line 137 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		StrictFuture<Void> __when_expr_0 = waitForAll(fs);
															#line 137 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (static_cast<DdbalanceSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1172 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DdbalanceSetupActor*>(this)->actor_wait_state = 1;
															#line 137 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DdbalanceSetupActor, 0, Void >*>(static_cast<DdbalanceSetupActor*>(this)));
															#line 1177 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DdbalanceSetupActor*>(this)->actor_wait_state > 0) static_cast<DdbalanceSetupActor*>(this)->actor_wait_state = 0;
		static_cast<DdbalanceSetupActor*>(this)->ActorCallback< DdbalanceSetupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DdbalanceSetupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ddbalanceSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdbalanceSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddbalanceSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DdbalanceSetupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ddbalanceSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdbalanceSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddbalanceSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DdbalanceSetupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ddbalanceSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdbalanceSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddbalanceSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 144 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (!static_cast<DdbalanceSetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DdbalanceSetupActorState(); static_cast<DdbalanceSetupActor*>(this)->destroy(); return 0; }
															#line 1286 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		new (&static_cast<DdbalanceSetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DdbalanceSetupActorState();
		static_cast<DdbalanceSetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DdbalanceSetupActor*>(this)->actor_wait_state > 0) static_cast<DdbalanceSetupActor*>(this)->actor_wait_state = 0;
		static_cast<DdbalanceSetupActor*>(this)->ActorCallback< DdbalanceSetupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DdbalanceSetupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ddbalanceSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdbalanceSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddbalanceSetup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DdbalanceSetupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ddbalanceSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdbalanceSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddbalanceSetup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DdbalanceSetupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ddbalanceSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdbalanceSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddbalanceSetup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 123 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	Database cx;
															#line 123 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	DDBalanceWorkload* self;
															#line 124 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	int i;
															#line 125 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	std::vector<int> order;
															#line 1389 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
};
// This generated class is to be used only via ddbalanceSetup()
															#line 123 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
class DdbalanceSetupActor final : public Actor<Void>, public ActorCallback< DdbalanceSetupActor, 0, Void >, public ActorCallback< DdbalanceSetupActor, 1, Void >, public FastAllocated<DdbalanceSetupActor>, public DdbalanceSetupActorState<DdbalanceSetupActor> {
															#line 1394 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
public:
	using FastAllocated<DdbalanceSetupActor>::operator new;
	using FastAllocated<DdbalanceSetupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14619776058058793472UL, 9235789439781472000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DdbalanceSetupActor, 0, Void >;
friend struct ActorCallback< DdbalanceSetupActor, 1, Void >;
															#line 123 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	DdbalanceSetupActor(Database const& cx,DDBalanceWorkload* const& self) 
															#line 1412 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		 : Actor<Void>(),
		   DdbalanceSetupActorState<DdbalanceSetupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ddbalanceSetup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16026216197317374208UL, 10820995974537011712UL);
		ActorExecutionContextHelper __helper(static_cast<DdbalanceSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ddbalanceSetup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ddbalanceSetup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DdbalanceSetupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DdbalanceSetupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 123 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
[[nodiscard]] Future<Void> ddbalanceSetup( Database const& cx, DDBalanceWorkload* const& self ) {
															#line 123 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	return Future<Void>(new DdbalanceSetupActor(cx, self));
															#line 1445 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
}

#line 146 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"

	bool shouldRecord(double clientBegin) {
		double n = now();
		return !discardEdgeMeasurements ||
		       (n > (clientBegin + testDuration * 0.125) && n < (clientBegin + testDuration * 0.875));
	}

																#line 1456 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
// This generated class is to be used only via ddBalanceWorker()
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
template <class DdBalanceWorkerActor>
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
class DdBalanceWorkerActorState {
															#line 1462 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
public:
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	DdBalanceWorkerActorState(Database const& cx,DDBalanceWorkload* const& self,int const& moverId,int const& sourceBin,int const& destinationBin,int const& begin,int const& end,double const& clientBegin,double* const& lastTime,double const& delay) 
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		 : cx(cx),
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   self(self),
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   moverId(moverId),
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   sourceBin(sourceBin),
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   destinationBin(destinationBin),
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   begin(begin),
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   end(end),
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   clientBegin(clientBegin),
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   lastTime(lastTime),
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   delay(delay),
															#line 163 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   i(),
															#line 164 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   j(),
															#line 165 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   moves(),
															#line 166 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   maxMovedAmount(0)
															#line 1495 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
	{
		fdb_probe_actor_create("ddBalanceWorker", reinterpret_cast<unsigned long>(this));

	}
	~DdBalanceWorkerActorState() 
	{
		fdb_probe_actor_destroy("ddBalanceWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 167 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			i = begin;
															#line 1510 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DdBalanceWorkerActorState();
		static_cast<DdBalanceWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 212 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (maxMovedAmount < end - begin)
															#line 1533 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		{
															#line 213 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			TraceEvent(SevError, "LostKeys") .detail("MaxMoved", maxMovedAmount) .detail("ShouldHaveMoved", end - begin) .detail("ClientId", self->clientId) .detail("MoverId", moverId) .detail("CurrentBin", sourceBin) .detail("NextBin", destinationBin);
															#line 220 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			ASSERT(false);
															#line 1539 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		}
															#line 223 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (!static_cast<DdBalanceWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DdBalanceWorkerActorState(); static_cast<DdBalanceWorkerActor*>(this)->destroy(); return 0; }
															#line 1543 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		new (&static_cast<DdBalanceWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DdBalanceWorkerActorState();
		static_cast<DdBalanceWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 167 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (!(i < end))
															#line 1562 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 168 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(lastTime, delay);
															#line 168 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (static_cast<DdBalanceWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1570 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DdBalanceWorkerActor*>(this)->actor_wait_state = 1;
															#line 168 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DdBalanceWorkerActor, 0, Void >*>(static_cast<DdBalanceWorkerActor*>(this)));
															#line 1575 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 169 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		tstart = now();
															#line 170 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		tr = Transaction(cx);
															#line 171 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		;
															#line 1601 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 169 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		tstart = now();
															#line 170 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		tr = Transaction(cx);
															#line 171 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		;
															#line 1614 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DdBalanceWorkerActor*>(this)->actor_wait_state > 0) static_cast<DdBalanceWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<DdBalanceWorkerActor*>(this)->ActorCallback< DdBalanceWorkerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DdBalanceWorkerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdBalanceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DdBalanceWorkerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdBalanceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DdBalanceWorkerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdBalanceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 204 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		tr = Transaction();
															#line 205 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (self->shouldRecord(clientBegin))
															#line 1700 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		{
															#line 206 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			self->operations += 3 * moves;
															#line 207 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			double latency = now() - tstart;
															#line 208 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			self->latencies.addSample(latency);
															#line 1708 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 172 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		startvalue = i;
															#line 173 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		moves = 0;
															#line 1727 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		try {
															#line 175 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			j = 0;
															#line 1731 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 197 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 197 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			if (static_cast<DdBalanceWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1768 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<DdBalanceWorkerActor*>(this)->actor_wait_state = 4;
															#line 197 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DdBalanceWorkerActor, 3, Void >*>(static_cast<DdBalanceWorkerActor*>(this)));
															#line 1773 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(int loopDepth) 
	{
															#line 194 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 194 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (static_cast<DdBalanceWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1790 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DdBalanceWorkerActor*>(this)->actor_wait_state = 3;
															#line 194 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DdBalanceWorkerActor, 2, Void >*>(static_cast<DdBalanceWorkerActor*>(this)));
															#line 1795 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 175 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (!(i < end && j < self->writesPerTransaction))
															#line 1811 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 176 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		myKey = self->key(sourceBin, i, moverId, self->clientId);
															#line 177 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		nextKey = self->key(destinationBin, i, moverId, self->clientId);
															#line 178 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		moves++;
															#line 179 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		i++;
															#line 181 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(myKey);
															#line 181 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (static_cast<DdBalanceWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1827 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DdBalanceWorkerActor*>(this)->actor_wait_state = 2;
															#line 181 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DdBalanceWorkerActor, 1, Optional<Value> >*>(static_cast<DdBalanceWorkerActor*>(this)));
															#line 1832 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1cont1(Optional<Value> const& f,int loopDepth) 
	{
															#line 182 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (f.present())
															#line 1854 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		{
															#line 183 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			maxMovedAmount++;
															#line 184 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			tr.set(nextKey, f.get());
															#line 185 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			tr.clear(myKey);
															#line 1862 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		}
		else
		{
															#line 187 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			TraceEvent("KeyNotPresent") .detail("ClientId", self->clientId) .detail("MoverId", moverId) .detail("CurrentBin", sourceBin) .detail("NextBin", destinationBin);
															#line 1868 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		}
															#line 175 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		j++;
															#line 1872 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1cont1(Optional<Value> && f,int loopDepth) 
	{
															#line 182 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (f.present())
															#line 1881 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		{
															#line 183 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			maxMovedAmount++;
															#line 184 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			tr.set(nextKey, f.get());
															#line 185 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			tr.clear(myKey);
															#line 1889 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		}
		else
		{
															#line 187 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			TraceEvent("KeyNotPresent") .detail("ClientId", self->clientId) .detail("MoverId", moverId) .detail("CurrentBin", sourceBin) .detail("NextBin", destinationBin);
															#line 1895 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		}
															#line 175 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		j++;
															#line 1899 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1when1(Optional<Value> const& f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1cont1(f, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1when1(Optional<Value> && f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1cont1(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DdBalanceWorkerActor*>(this)->actor_wait_state > 0) static_cast<DdBalanceWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<DdBalanceWorkerActor*>(this)->ActorCallback< DdBalanceWorkerActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< DdBalanceWorkerActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdBalanceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DdBalanceWorkerActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdBalanceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DdBalanceWorkerActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdBalanceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DdBalanceWorkerActor*>(this)->actor_wait_state > 0) static_cast<DdBalanceWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<DdBalanceWorkerActor*>(this)->ActorCallback< DdBalanceWorkerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DdBalanceWorkerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdBalanceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DdBalanceWorkerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdBalanceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DdBalanceWorkerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdBalanceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 198 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (self->shouldRecord(clientBegin))
															#line 2070 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		{
															#line 199 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			++self->retries;
															#line 2074 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		}
															#line 200 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		i = startvalue;
															#line 2078 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 198 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (self->shouldRecord(clientBegin))
															#line 2087 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		{
															#line 199 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			++self->retries;
															#line 2091 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		}
															#line 200 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		i = startvalue;
															#line 2095 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DdBalanceWorkerActor*>(this)->actor_wait_state > 0) static_cast<DdBalanceWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<DdBalanceWorkerActor*>(this)->ActorCallback< DdBalanceWorkerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DdBalanceWorkerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdBalanceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DdBalanceWorkerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdBalanceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DdBalanceWorkerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdBalanceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddBalanceWorker", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	Database cx;
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	DDBalanceWorkload* self;
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	int moverId;
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	int sourceBin;
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	int destinationBin;
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	int begin;
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	int end;
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	double clientBegin;
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	double* lastTime;
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	double delay;
															#line 163 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	int i;
															#line 164 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	int j;
															#line 165 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	int moves;
															#line 166 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	int maxMovedAmount;
															#line 169 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	double tstart;
															#line 170 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	Transaction tr;
															#line 172 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	int startvalue;
															#line 176 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	Key myKey;
															#line 177 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	Key nextKey;
															#line 2213 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
};
// This generated class is to be used only via ddBalanceWorker()
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
class DdBalanceWorkerActor final : public Actor<Void>, public ActorCallback< DdBalanceWorkerActor, 0, Void >, public ActorCallback< DdBalanceWorkerActor, 1, Optional<Value> >, public ActorCallback< DdBalanceWorkerActor, 2, Void >, public ActorCallback< DdBalanceWorkerActor, 3, Void >, public FastAllocated<DdBalanceWorkerActor>, public DdBalanceWorkerActorState<DdBalanceWorkerActor> {
															#line 2218 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
public:
	using FastAllocated<DdBalanceWorkerActor>::operator new;
	using FastAllocated<DdBalanceWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10525331642584005376UL, 16378071329109662208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DdBalanceWorkerActor, 0, Void >;
friend struct ActorCallback< DdBalanceWorkerActor, 1, Optional<Value> >;
friend struct ActorCallback< DdBalanceWorkerActor, 2, Void >;
friend struct ActorCallback< DdBalanceWorkerActor, 3, Void >;
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	DdBalanceWorkerActor(Database const& cx,DDBalanceWorkload* const& self,int const& moverId,int const& sourceBin,int const& destinationBin,int const& begin,int const& end,double const& clientBegin,double* const& lastTime,double const& delay) 
															#line 2238 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		 : Actor<Void>(),
		   DdBalanceWorkerActorState<DdBalanceWorkerActor>(cx, self, moverId, sourceBin, destinationBin, begin, end, clientBegin, lastTime, delay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ddBalanceWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12855387109218875904UL, 7532035201507371264UL);
		ActorExecutionContextHelper __helper(static_cast<DdBalanceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ddBalanceWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ddBalanceWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DdBalanceWorkerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DdBalanceWorkerActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DdBalanceWorkerActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DdBalanceWorkerActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
[[nodiscard]] Future<Void> ddBalanceWorker( Database const& cx, DDBalanceWorkload* const& self, int const& moverId, int const& sourceBin, int const& destinationBin, int const& begin, int const& end, double const& clientBegin, double* const& lastTime, double const& delay ) {
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	return Future<Void>(new DdBalanceWorkerActor(cx, self, moverId, sourceBin, destinationBin, begin, end, clientBegin, lastTime, delay));
															#line 2273 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
}

#line 225 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"

																#line 2278 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
// This generated class is to be used only via ddBalanceMover()
															#line 226 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
template <class DdBalanceMoverActor>
															#line 226 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
class DdBalanceMoverActorState {
															#line 2284 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
public:
															#line 226 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	DdBalanceMoverActorState(Database const& cx,DDBalanceWorkload* const& self,int const& moverId) 
															#line 226 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
															#line 226 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		 : cx(cx),
															#line 226 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   self(self),
															#line 226 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   moverId(moverId),
															#line 227 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   currentBin(self->currentbin),
															#line 228 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   nextBin(0),
															#line 229 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   key_space_drift(0),
															#line 231 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   clientBegin(now()),
															#line 232 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		   lastTime(now())
															#line 2305 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
	{
		fdb_probe_actor_create("ddBalanceMover", reinterpret_cast<unsigned long>(this));

	}
	~DdBalanceMoverActorState() 
	{
		fdb_probe_actor_destroy("ddBalanceMover", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 234 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			;
															#line 2320 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DdBalanceMoverActorState();
		static_cast<DdBalanceMoverActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 235 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		nextBin = deterministicRandom()->randomInt(key_space_drift, self->binCount + key_space_drift);
															#line 236 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		for(;nextBin == currentBin;) {
															#line 237 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			nextBin = deterministicRandom()->randomInt(key_space_drift, self->binCount + key_space_drift);
															#line 2354 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		}
															#line 239 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		std::vector<Future<Void>> fs;
															#line 240 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		fs.reserve(self->actorsPerClient / self->moversPerClient);
															#line 241 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		for(int i = 0;i < self->actorsPerClient / self->moversPerClient;i++) {
															#line 242 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
			fs.push_back(self->ddBalanceWorker(cx, self, moverId, currentBin, nextBin, i * self->nodesPerActor, (i + 1) * self->nodesPerActor, clientBegin, &lastTime, 1.0 / self->transactionsPerSecond));
															#line 2364 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		}
															#line 252 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		StrictFuture<Void> __when_expr_0 = waitForAll(fs);
															#line 252 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		if (static_cast<DdBalanceMoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2370 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DdBalanceMoverActor*>(this)->actor_wait_state = 1;
															#line 252 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DdBalanceMoverActor, 0, Void >*>(static_cast<DdBalanceMoverActor*>(this)));
															#line 2375 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 254 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		currentBin = nextBin;
															#line 255 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		key_space_drift += self->keySpaceDriftFactor;
															#line 256 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		++self->bin_shifts;
															#line 2388 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 254 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		currentBin = nextBin;
															#line 255 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		key_space_drift += self->keySpaceDriftFactor;
															#line 256 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
		++self->bin_shifts;
															#line 2401 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DdBalanceMoverActor*>(this)->actor_wait_state > 0) static_cast<DdBalanceMoverActor*>(this)->actor_wait_state = 0;
		static_cast<DdBalanceMoverActor*>(this)->ActorCallback< DdBalanceMoverActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DdBalanceMoverActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ddBalanceMover", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdBalanceMoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddBalanceMover", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DdBalanceMoverActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ddBalanceMover", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdBalanceMoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddBalanceMover", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DdBalanceMoverActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ddBalanceMover", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdBalanceMoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddBalanceMover", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 226 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	Database cx;
															#line 226 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	DDBalanceWorkload* self;
															#line 226 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	int moverId;
															#line 227 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	int currentBin;
															#line 228 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	int nextBin;
															#line 229 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	int key_space_drift;
															#line 231 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	double clientBegin;
															#line 232 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	double lastTime;
															#line 2497 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
};
// This generated class is to be used only via ddBalanceMover()
															#line 226 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
class DdBalanceMoverActor final : public Actor<Void>, public ActorCallback< DdBalanceMoverActor, 0, Void >, public FastAllocated<DdBalanceMoverActor>, public DdBalanceMoverActorState<DdBalanceMoverActor> {
															#line 2502 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
public:
	using FastAllocated<DdBalanceMoverActor>::operator new;
	using FastAllocated<DdBalanceMoverActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17212119599220462848UL, 15210040105166598656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DdBalanceMoverActor, 0, Void >;
															#line 226 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	DdBalanceMoverActor(Database const& cx,DDBalanceWorkload* const& self,int const& moverId) 
															#line 2519 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
		 : Actor<Void>(),
		   DdBalanceMoverActorState<DdBalanceMoverActor>(cx, self, moverId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ddBalanceMover", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(265056402002825216UL, 7353858679644316160UL);
		ActorExecutionContextHelper __helper(static_cast<DdBalanceMoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ddBalanceMover");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ddBalanceMover", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DdBalanceMoverActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 226 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
[[nodiscard]] Future<Void> ddBalanceMover( Database const& cx, DDBalanceWorkload* const& self, int const& moverId ) {
															#line 226 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
	return Future<Void>(new DdBalanceMoverActor(cx, self, moverId));
															#line 2551 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDBalance.actor.g.cpp"
}

#line 259 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/workloads/DDBalance.actor.cpp"
};

WorkloadFactory<DDBalanceWorkload> DDBalanceWorkloadFactory;
