#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
/*
 * RestoreCommon.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This file implements the functions defined in RestoreCommon.actor.h
// The functions in this file are copied from BackupAgent

#include "fdbserver/RestoreCommon.actor.h"

// Backup agent header
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/MutationList.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"

#include "flow/actorcompiler.h" // This must be the last #include.

// Split RestoreConfigFR defined in FileBackupAgent.actor.cpp to declaration in Restore.actor.h and implementation in
// RestoreCommon.actor.cpp

KeyBackedProperty<ERestoreState> RestoreConfigFR::stateEnum() {
	return configSpace.pack(__FUNCTION__sr);
}
Future<StringRef> RestoreConfigFR::stateText(Reference<ReadYourWritesTransaction> tr) {
	return map(stateEnum().getD(tr), [](ERestoreState s) -> StringRef { return FileBackupAgent::restoreStateText(s); });
}
KeyBackedProperty<Key> RestoreConfigFR::addPrefix() {
	return configSpace.pack(__FUNCTION__sr);
}
KeyBackedProperty<Key> RestoreConfigFR::removePrefix() {
	return configSpace.pack(__FUNCTION__sr);
}
// XXX: Remove restoreRange() once it is safe to remove. It has been changed to restoreRanges
KeyBackedProperty<KeyRange> RestoreConfigFR::restoreRange() {
	return configSpace.pack(__FUNCTION__sr);
}
KeyBackedProperty<std::vector<KeyRange>> RestoreConfigFR::restoreRanges() {
	return configSpace.pack(__FUNCTION__sr);
}
KeyBackedProperty<Key> RestoreConfigFR::batchFuture() {
	return configSpace.pack(__FUNCTION__sr);
}
KeyBackedProperty<Version> RestoreConfigFR::restoreVersion() {
	return configSpace.pack(__FUNCTION__sr);
}

KeyBackedProperty<Reference<IBackupContainer>> RestoreConfigFR::sourceContainer() {
	return configSpace.pack(__FUNCTION__sr);
}
// Get the source container as a bare URL, without creating a container instance
KeyBackedProperty<Value> RestoreConfigFR::sourceContainerURL() {
	return configSpace.pack("sourceContainer"_sr);
}

// Total bytes written by all log and range restore tasks.
KeyBackedBinaryValue<int64_t> RestoreConfigFR::bytesWritten() {
	return configSpace.pack(__FUNCTION__sr);
}
// File blocks that have had tasks created for them by the Dispatch task
KeyBackedBinaryValue<int64_t> RestoreConfigFR::filesBlocksDispatched() {
	return configSpace.pack(__FUNCTION__sr);
}
// File blocks whose tasks have finished
KeyBackedBinaryValue<int64_t> RestoreConfigFR::fileBlocksFinished() {
	return configSpace.pack(__FUNCTION__sr);
}
// Total number of files in the fileMap
KeyBackedBinaryValue<int64_t> RestoreConfigFR::fileCount() {
	return configSpace.pack(__FUNCTION__sr);
}
// Total number of file blocks in the fileMap
KeyBackedBinaryValue<int64_t> RestoreConfigFR::fileBlockCount() {
	return configSpace.pack(__FUNCTION__sr);
}

Future<std::vector<KeyRange>> RestoreConfigFR::getRestoreRangesOrDefault(Reference<ReadYourWritesTransaction> tr) {
	return getRestoreRangesOrDefault_impl(this, tr);
}

															#line 101 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
// This generated class is to be used only via getRestoreRangesOrDefault_impl()
															#line 99 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
template <class RestoreConfigFR_GetRestoreRangesOrDefault_implActor>
															#line 99 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
class RestoreConfigFR_GetRestoreRangesOrDefault_implActorState {
															#line 107 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
public:
															#line 99 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	RestoreConfigFR_GetRestoreRangesOrDefault_implActorState(RestoreConfigFR* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 99 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
															#line 99 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		 : self(self),
															#line 99 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		   tr(tr)
															#line 116 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
	{
		fdb_probe_actor_create("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this));

	}
	~RestoreConfigFR_GetRestoreRangesOrDefault_implActorState() 
	{
		fdb_probe_actor_destroy("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			StrictFuture<std::vector<KeyRange>> __when_expr_0 = self->restoreRanges().getD(tr);
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			if (static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 133 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 1;
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreConfigFR_GetRestoreRangesOrDefault_implActor, 0, std::vector<KeyRange> >*>(static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)));
															#line 138 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreConfigFR_GetRestoreRangesOrDefault_implActorState();
		static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 103 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		if (ranges.empty())
															#line 161 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		{
															#line 104 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			StrictFuture<KeyRange> __when_expr_1 = self->restoreRange().getD(tr);
															#line 104 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			if (static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 167 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 2;
															#line 104 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RestoreConfigFR_GetRestoreRangesOrDefault_implActor, 1, KeyRange >*>(static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)));
															#line 172 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(std::vector<KeyRange> const& __ranges,int loopDepth) 
	{
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		ranges = __ranges;
															#line 186 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<KeyRange> && __ranges,int loopDepth) 
	{
		ranges = std::move(__ranges);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state > 0) static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->ActorCallback< RestoreConfigFR_GetRestoreRangesOrDefault_implActor, 0, std::vector<KeyRange> >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreConfigFR_GetRestoreRangesOrDefault_implActor, 0, std::vector<KeyRange> >*,std::vector<KeyRange> const& value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreConfigFR_GetRestoreRangesOrDefault_implActor, 0, std::vector<KeyRange> >*,std::vector<KeyRange> && value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreConfigFR_GetRestoreRangesOrDefault_implActor, 0, std::vector<KeyRange> >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 107 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		if (!static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->SAV<std::vector<KeyRange>>::futures) { (void)(ranges); this->~RestoreConfigFR_GetRestoreRangesOrDefault_implActorState(); static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->destroy(); return 0; }
															#line 265 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		new (&static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->SAV< std::vector<KeyRange> >::value()) std::vector<KeyRange>(std::move(ranges)); // state_var_RVO
		this->~RestoreConfigFR_GetRestoreRangesOrDefault_implActorState();
		static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 105 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		ranges.push_back(range);
															#line 277 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(KeyRange const& __range,int loopDepth) 
	{
															#line 104 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		range = __range;
															#line 286 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(KeyRange && __range,int loopDepth) 
	{
		range = std::move(__range);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state > 0) static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->ActorCallback< RestoreConfigFR_GetRestoreRangesOrDefault_implActor, 1, KeyRange >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreConfigFR_GetRestoreRangesOrDefault_implActor, 1, KeyRange >*,KeyRange const& value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RestoreConfigFR_GetRestoreRangesOrDefault_implActor, 1, KeyRange >*,KeyRange && value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RestoreConfigFR_GetRestoreRangesOrDefault_implActor, 1, KeyRange >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 99 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	RestoreConfigFR* self;
															#line 99 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 102 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	std::vector<KeyRange> ranges;
															#line 104 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	KeyRange range;
															#line 369 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
};
// This generated class is to be used only via getRestoreRangesOrDefault_impl()
															#line 99 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
class RestoreConfigFR_GetRestoreRangesOrDefault_implActor final : public Actor<std::vector<KeyRange>>, public ActorCallback< RestoreConfigFR_GetRestoreRangesOrDefault_implActor, 0, std::vector<KeyRange> >, public ActorCallback< RestoreConfigFR_GetRestoreRangesOrDefault_implActor, 1, KeyRange >, public FastAllocated<RestoreConfigFR_GetRestoreRangesOrDefault_implActor>, public RestoreConfigFR_GetRestoreRangesOrDefault_implActorState<RestoreConfigFR_GetRestoreRangesOrDefault_implActor> {
															#line 374 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
public:
	using FastAllocated<RestoreConfigFR_GetRestoreRangesOrDefault_implActor>::operator new;
	using FastAllocated<RestoreConfigFR_GetRestoreRangesOrDefault_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16705827521910176000UL, 15350996282939099392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<KeyRange>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreConfigFR_GetRestoreRangesOrDefault_implActor, 0, std::vector<KeyRange> >;
friend struct ActorCallback< RestoreConfigFR_GetRestoreRangesOrDefault_implActor, 1, KeyRange >;
															#line 99 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	RestoreConfigFR_GetRestoreRangesOrDefault_implActor(RestoreConfigFR* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 392 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		 : Actor<std::vector<KeyRange>>(),
		   RestoreConfigFR_GetRestoreRangesOrDefault_implActorState<RestoreConfigFR_GetRestoreRangesOrDefault_implActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6585458574248329728UL, 500110213929794304UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfigFR_GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRestoreRangesOrDefault_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreConfigFR_GetRestoreRangesOrDefault_implActor, 0, std::vector<KeyRange> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RestoreConfigFR_GetRestoreRangesOrDefault_implActor, 1, KeyRange >*)0, actor_cancelled()); break;
		}

	}
};
															#line 99 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
[[nodiscard]] Future<std::vector<KeyRange>> RestoreConfigFR::getRestoreRangesOrDefault_impl( RestoreConfigFR* const& self, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 99 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	return Future<std::vector<KeyRange>>(new RestoreConfigFR_GetRestoreRangesOrDefault_implActor(self, tr));
															#line 425 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
}

#line 109 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"

KeyBackedSet<RestoreConfigFR::RestoreFile> RestoreConfigFR::fileSet() {
	return configSpace.pack(__FUNCTION__sr);
}

Future<bool> RestoreConfigFR::isRunnable(Reference<ReadYourWritesTransaction> tr) {
	return map(stateEnum().getD(tr), [](ERestoreState s) -> bool {
		return s != ERestoreState::ABORTED && s != ERestoreState::COMPLETED && s != ERestoreState::UNINITIALIZED;
	});
}

Future<Void> RestoreConfigFR::logError(Database cx, Error e, std::string const& details, void* taskInstance) {
	if (!uid.isValid()) {
		TraceEvent(SevError, "FileRestoreErrorNoUID").error(e).detail("Description", details);
		return Void();
	}
	TraceEvent t(SevWarn, "FileRestoreError");
	t.error(e).detail("RestoreUID", uid).detail("Description", details).detail("TaskInstance", (uint64_t)taskInstance);
	// key_not_found could happen
	if (e.code() == error_code_key_not_found)
		t.backtrace();

	return updateErrorInfo(cx, e, details);
}

Key RestoreConfigFR::mutationLogPrefix() {
	return uidPrefixKey(applyLogKeys.begin, uid);
}

Key RestoreConfigFR::applyMutationsMapPrefix() {
	return uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid);
}

															#line 462 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
// This generated class is to be used only via getApplyVersionLag_impl()
															#line 142 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
template <class RestoreConfigFR_GetApplyVersionLag_implActor>
															#line 142 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
class RestoreConfigFR_GetApplyVersionLag_implActorState {
															#line 468 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
public:
															#line 142 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	RestoreConfigFR_GetApplyVersionLag_implActorState(Reference<ReadYourWritesTransaction> const& tr,UID const& uid) 
															#line 142 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
															#line 142 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		 : tr(tr),
															#line 142 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		   uid(uid),
															#line 144 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		   beginVal(tr->get(uidPrefixKey(applyMutationsBeginRange.begin, uid), Snapshot::True)),
															#line 145 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		   endVal(tr->get(uidPrefixKey(applyMutationsEndRange.begin, uid), Snapshot::True))
															#line 481 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
	{
		fdb_probe_actor_create("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this));

	}
	~RestoreConfigFR_GetApplyVersionLag_implActorState() 
	{
		fdb_probe_actor_destroy("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 146 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(beginVal) && success(endVal);
															#line 146 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			if (static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 498 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->actor_wait_state = 1;
															#line 146 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreConfigFR_GetApplyVersionLag_implActor, 0, Void >*>(static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)));
															#line 503 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreConfigFR_GetApplyVersionLag_implActorState();
		static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 148 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		if (!beginVal.get().present() || !endVal.get().present())
															#line 526 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		{
															#line 149 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			if (!static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(0); this->~RestoreConfigFR_GetApplyVersionLag_implActorState(); static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 530 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			new (&static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(0);
			this->~RestoreConfigFR_GetApplyVersionLag_implActorState();
			static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 151 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		Version beginVersion = BinaryReader::fromStringRef<Version>(beginVal.get().get(), Unversioned());
															#line 152 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		Version endVersion = BinaryReader::fromStringRef<Version>(endVal.get().get(), Unversioned());
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		if (!static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(endVersion - beginVersion); this->~RestoreConfigFR_GetApplyVersionLag_implActorState(); static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 542 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		new (&static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(endVersion - beginVersion);
		this->~RestoreConfigFR_GetApplyVersionLag_implActorState();
		static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 148 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		if (!beginVal.get().present() || !endVal.get().present())
															#line 554 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		{
															#line 149 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			if (!static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(0); this->~RestoreConfigFR_GetApplyVersionLag_implActorState(); static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 558 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			new (&static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(0);
			this->~RestoreConfigFR_GetApplyVersionLag_implActorState();
			static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 151 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		Version beginVersion = BinaryReader::fromStringRef<Version>(beginVal.get().get(), Unversioned());
															#line 152 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		Version endVersion = BinaryReader::fromStringRef<Version>(endVal.get().get(), Unversioned());
															#line 153 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		if (!static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(endVersion - beginVersion); this->~RestoreConfigFR_GetApplyVersionLag_implActorState(); static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 570 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		new (&static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(endVersion - beginVersion);
		this->~RestoreConfigFR_GetApplyVersionLag_implActorState();
		static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->actor_wait_state > 0) static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->ActorCallback< RestoreConfigFR_GetApplyVersionLag_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreConfigFR_GetApplyVersionLag_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreConfigFR_GetApplyVersionLag_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreConfigFR_GetApplyVersionLag_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 142 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 142 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	UID uid;
															#line 144 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Future<Optional<Value>> beginVal;
															#line 145 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Future<Optional<Value>> endVal;
															#line 661 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
};
// This generated class is to be used only via getApplyVersionLag_impl()
															#line 142 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
class RestoreConfigFR_GetApplyVersionLag_implActor final : public Actor<int64_t>, public ActorCallback< RestoreConfigFR_GetApplyVersionLag_implActor, 0, Void >, public FastAllocated<RestoreConfigFR_GetApplyVersionLag_implActor>, public RestoreConfigFR_GetApplyVersionLag_implActorState<RestoreConfigFR_GetApplyVersionLag_implActor> {
															#line 666 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
public:
	using FastAllocated<RestoreConfigFR_GetApplyVersionLag_implActor>::operator new;
	using FastAllocated<RestoreConfigFR_GetApplyVersionLag_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1745019013866383104UL, 8228800788016791296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreConfigFR_GetApplyVersionLag_implActor, 0, Void >;
															#line 142 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	RestoreConfigFR_GetApplyVersionLag_implActor(Reference<ReadYourWritesTransaction> const& tr,UID const& uid) 
															#line 683 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		 : Actor<int64_t>(),
		   RestoreConfigFR_GetApplyVersionLag_implActorState<RestoreConfigFR_GetApplyVersionLag_implActor>(tr, uid),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12571594790723314944UL, 15339460590443948800UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfigFR_GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getApplyVersionLag_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreConfigFR_GetApplyVersionLag_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 142 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
[[nodiscard]] Future<int64_t> RestoreConfigFR::getApplyVersionLag_impl( Reference<ReadYourWritesTransaction> const& tr, UID const& uid ) {
															#line 142 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	return Future<int64_t>(new RestoreConfigFR_GetApplyVersionLag_implActor(tr, uid));
															#line 715 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
}

#line 155 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"

Future<int64_t> RestoreConfigFR::getApplyVersionLag(Reference<ReadYourWritesTransaction> tr) {
	return getApplyVersionLag_impl(tr, uid);
}

void RestoreConfigFR::initApplyMutations(Reference<ReadYourWritesTransaction> tr, Key addPrefix, Key removePrefix) {
	// Set these because they have to match the applyMutations values.
	this->addPrefix().set(tr, addPrefix);
	this->removePrefix().set(tr, removePrefix);

	clearApplyMutationsKeys(tr);

	// Initialize add/remove prefix, range version map count and set the map's start key to InvalidVersion
	tr->set(uidPrefixKey(applyMutationsAddPrefixRange.begin, uid), addPrefix);
	tr->set(uidPrefixKey(applyMutationsRemovePrefixRange.begin, uid), removePrefix);
	int64_t startCount = 0;
	tr->set(uidPrefixKey(applyMutationsKeyVersionCountRange.begin, uid), StringRef((uint8_t*)&startCount, 8));
	Key mapStart = uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid);
	tr->set(mapStart, BinaryWriter::toValue<Version>(invalidVersion, Unversioned()));
}

void RestoreConfigFR::clearApplyMutationsKeys(Reference<ReadYourWritesTransaction> tr) {
	tr->setOption(FDBTransactionOptions::COMMIT_ON_FIRST_PROXY);

	// Clear add/remove prefix keys
	tr->clear(uidPrefixKey(applyMutationsAddPrefixRange.begin, uid));
	tr->clear(uidPrefixKey(applyMutationsRemovePrefixRange.begin, uid));

	// Clear range version map and count key
	tr->clear(uidPrefixKey(applyMutationsKeyVersionCountRange.begin, uid));
	Key mapStart = uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid);
	tr->clear(KeyRangeRef(mapStart, strinc(mapStart)));

	// Clear any loaded mutations that have not yet been applied
	Key mutationPrefix = mutationLogPrefix();
	tr->clear(KeyRangeRef(mutationPrefix, strinc(mutationPrefix)));

	// Clear end and begin versions (intentionally in this order)
	tr->clear(uidPrefixKey(applyMutationsEndRange.begin, uid));
	tr->clear(uidPrefixKey(applyMutationsBeginRange.begin, uid));
}

void RestoreConfigFR::setApplyBeginVersion(Reference<ReadYourWritesTransaction> tr, Version ver) {
	tr->set(uidPrefixKey(applyMutationsBeginRange.begin, uid), BinaryWriter::toValue(ver, Unversioned()));
}

void RestoreConfigFR::setApplyEndVersion(Reference<ReadYourWritesTransaction> tr, Version ver) {
	tr->set(uidPrefixKey(applyMutationsEndRange.begin, uid), BinaryWriter::toValue(ver, Unversioned()));
}

Future<Version> RestoreConfigFR::getApplyEndVersion(Reference<ReadYourWritesTransaction> tr) {
	return map(tr->get(uidPrefixKey(applyMutationsEndRange.begin, uid)), [=](Optional<Value> const& value) -> Version {
		return value.present() ? BinaryReader::fromStringRef<Version>(value.get(), Unversioned()) : 0;
	});
}

// Meng: Change RestoreConfigFR to Reference<RestoreConfigFR> because FastRestore pass the Reference<RestoreConfigFR>
// around
															#line 777 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
// This generated class is to be used only via getProgress_impl()
															#line 213 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
template <class RestoreConfigFR_GetProgress_implActor>
															#line 213 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
class RestoreConfigFR_GetProgress_implActorState {
															#line 783 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
public:
															#line 213 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	RestoreConfigFR_GetProgress_implActorState(Reference<RestoreConfigFR> const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 213 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
															#line 213 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		 : restore(restore),
															#line 213 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		   tr(tr)
															#line 792 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
	{
		fdb_probe_actor_create("getProgress_impl", reinterpret_cast<unsigned long>(this));

	}
	~RestoreConfigFR_GetProgress_implActorState() 
	{
		fdb_probe_actor_destroy("getProgress_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 215 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 216 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 218 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			fileCount = restore->fileCount().getD(tr);
															#line 219 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			fileBlockCount = restore->fileBlockCount().getD(tr);
															#line 220 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			fileBlocksDispatched = restore->filesBlocksDispatched().getD(tr);
															#line 221 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			fileBlocksFinished = restore->fileBlocksFinished().getD(tr);
															#line 222 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			bytesWritten = restore->bytesWritten().getD(tr);
															#line 223 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			status = restore->stateText(tr);
															#line 224 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			lag = restore->getApplyVersionLag(tr);
															#line 225 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			tag = restore->tag().getD(tr);
															#line 226 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			lastError = restore->lastError().getD(tr);
															#line 229 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			uid = restore->getUid();
															#line 230 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(fileCount) && success(fileBlockCount) && success(fileBlocksDispatched) && success(fileBlocksFinished) && success(bytesWritten) && success(status) && success(lag) && success(tag) && success(lastError);
															#line 230 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			if (static_cast<RestoreConfigFR_GetProgress_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 833 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RestoreConfigFR_GetProgress_implActor*>(this)->actor_wait_state = 1;
															#line 230 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreConfigFR_GetProgress_implActor, 0, Void >*>(static_cast<RestoreConfigFR_GetProgress_implActor*>(this)));
															#line 838 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreConfigFR_GetProgress_implActorState();
		static_cast<RestoreConfigFR_GetProgress_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 234 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		std::string errstr = "None";
															#line 235 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		if (lastError.get().second != 0)
															#line 863 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		{
															#line 236 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			errstr = format("'%s' %llds ago.\n", lastError.get().first.c_str(), (tr->getReadVersion().get() - lastError.get().second) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND);
															#line 867 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		}
															#line 240 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		TraceEvent("FileRestoreProgress") .detail("RestoreUID", uid) .detail("Tag", tag.get()) .detail("State", status.get().toString()) .detail("FileCount", fileCount.get()) .detail("FileBlocksFinished", fileBlocksFinished.get()) .detail("FileBlocksTotal", fileBlockCount.get()) .detail("FileBlocksInProgress", fileBlocksDispatched.get() - fileBlocksFinished.get()) .detail("BytesWritten", bytesWritten.get()) .detail("ApplyLag", lag.get()) .detail("TaskInstance", THIS_ADDR) .backtrace();
															#line 253 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		if (!static_cast<RestoreConfigFR_GetProgress_implActor*>(this)->SAV<std::string>::futures) { (void)(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str())); this->~RestoreConfigFR_GetProgress_implActorState(); static_cast<RestoreConfigFR_GetProgress_implActor*>(this)->destroy(); return 0; }
															#line 873 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		new (&static_cast<RestoreConfigFR_GetProgress_implActor*>(this)->SAV< std::string >::value()) std::string(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str()));
		this->~RestoreConfigFR_GetProgress_implActorState();
		static_cast<RestoreConfigFR_GetProgress_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 234 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		std::string errstr = "None";
															#line 235 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		if (lastError.get().second != 0)
															#line 887 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		{
															#line 236 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			errstr = format("'%s' %llds ago.\n", lastError.get().first.c_str(), (tr->getReadVersion().get() - lastError.get().second) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND);
															#line 891 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		}
															#line 240 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		TraceEvent("FileRestoreProgress") .detail("RestoreUID", uid) .detail("Tag", tag.get()) .detail("State", status.get().toString()) .detail("FileCount", fileCount.get()) .detail("FileBlocksFinished", fileBlocksFinished.get()) .detail("FileBlocksTotal", fileBlockCount.get()) .detail("FileBlocksInProgress", fileBlocksDispatched.get() - fileBlocksFinished.get()) .detail("BytesWritten", bytesWritten.get()) .detail("ApplyLag", lag.get()) .detail("TaskInstance", THIS_ADDR) .backtrace();
															#line 253 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		if (!static_cast<RestoreConfigFR_GetProgress_implActor*>(this)->SAV<std::string>::futures) { (void)(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str())); this->~RestoreConfigFR_GetProgress_implActorState(); static_cast<RestoreConfigFR_GetProgress_implActor*>(this)->destroy(); return 0; }
															#line 897 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		new (&static_cast<RestoreConfigFR_GetProgress_implActor*>(this)->SAV< std::string >::value()) std::string(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str()));
		this->~RestoreConfigFR_GetProgress_implActorState();
		static_cast<RestoreConfigFR_GetProgress_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreConfigFR_GetProgress_implActor*>(this)->actor_wait_state > 0) static_cast<RestoreConfigFR_GetProgress_implActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreConfigFR_GetProgress_implActor*>(this)->ActorCallback< RestoreConfigFR_GetProgress_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreConfigFR_GetProgress_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfigFR_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreConfigFR_GetProgress_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfigFR_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreConfigFR_GetProgress_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfigFR_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 213 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Reference<RestoreConfigFR> restore;
															#line 213 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 218 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Future<int64_t> fileCount;
															#line 219 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Future<int64_t> fileBlockCount;
															#line 220 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Future<int64_t> fileBlocksDispatched;
															#line 221 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Future<int64_t> fileBlocksFinished;
															#line 222 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Future<int64_t> bytesWritten;
															#line 223 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Future<StringRef> status;
															#line 224 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Future<Version> lag;
															#line 225 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Future<std::string> tag;
															#line 226 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Future<std::pair<std::string, Version>> lastError;
															#line 229 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	UID uid;
															#line 1004 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
};
// This generated class is to be used only via getProgress_impl()
															#line 213 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
class RestoreConfigFR_GetProgress_implActor final : public Actor<std::string>, public ActorCallback< RestoreConfigFR_GetProgress_implActor, 0, Void >, public FastAllocated<RestoreConfigFR_GetProgress_implActor>, public RestoreConfigFR_GetProgress_implActorState<RestoreConfigFR_GetProgress_implActor> {
															#line 1009 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
public:
	using FastAllocated<RestoreConfigFR_GetProgress_implActor>::operator new;
	using FastAllocated<RestoreConfigFR_GetProgress_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5774596463099469312UL, 10090309450179593216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreConfigFR_GetProgress_implActor, 0, Void >;
															#line 213 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	RestoreConfigFR_GetProgress_implActor(Reference<RestoreConfigFR> const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 1026 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		 : Actor<std::string>(),
		   RestoreConfigFR_GetProgress_implActorState<RestoreConfigFR_GetProgress_implActor>(restore, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6968936805171587328UL, 13259314682365345536UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfigFR_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getProgress_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreConfigFR_GetProgress_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 213 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
[[nodiscard]] Future<std::string> RestoreConfigFR::getProgress_impl( Reference<RestoreConfigFR> const& restore, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 213 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	return Future<std::string>(new RestoreConfigFR_GetProgress_implActor(restore, tr));
															#line 1058 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
}

#line 266 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
Future<std::string> RestoreConfigFR::getProgress(Reference<ReadYourWritesTransaction> tr) {
	Reference<RestoreConfigFR> restore = Reference<RestoreConfigFR>(this);
	return getProgress_impl(restore, tr);
}

// Meng: Change RestoreConfigFR to Reference<RestoreConfigFR>
															#line 1068 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
// This generated class is to be used only via getFullStatus_impl()
															#line 272 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
template <class RestoreConfigFR_GetFullStatus_implActor>
															#line 272 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
class RestoreConfigFR_GetFullStatus_implActorState {
															#line 1074 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
public:
															#line 272 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	RestoreConfigFR_GetFullStatus_implActorState(Reference<RestoreConfigFR> const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 272 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
															#line 272 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		 : restore(restore),
															#line 272 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		   tr(tr)
															#line 1083 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
	{
		fdb_probe_actor_create("getFullStatus_impl", reinterpret_cast<unsigned long>(this));

	}
	~RestoreConfigFR_GetFullStatus_implActorState() 
	{
		fdb_probe_actor_destroy("getFullStatus_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 274 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 275 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 277 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			ranges = restore->getRestoreRangesOrDefault(tr);
															#line 278 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			addPrefix = restore->addPrefix().getD(tr);
															#line 279 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			removePrefix = restore->removePrefix().getD(tr);
															#line 280 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			url = restore->sourceContainerURL().getD(tr);
															#line 281 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			restoreVersion = restore->restoreVersion().getD(tr);
															#line 282 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			progress = restore->getProgress(tr);
															#line 285 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(ranges) && success(addPrefix) && success(removePrefix) && success(url) && success(restoreVersion) && success(progress);
															#line 285 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			if (static_cast<RestoreConfigFR_GetFullStatus_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1116 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RestoreConfigFR_GetFullStatus_implActor*>(this)->actor_wait_state = 1;
															#line 285 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreConfigFR_GetFullStatus_implActor, 0, Void >*>(static_cast<RestoreConfigFR_GetFullStatus_implActor*>(this)));
															#line 1121 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreConfigFR_GetFullStatus_implActorState();
		static_cast<RestoreConfigFR_GetFullStatus_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 288 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		std::string returnStr;
															#line 289 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		returnStr = format("%s  URL: %s", progress.get().c_str(), url.get().toString().c_str());
															#line 290 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		for( auto& range : ranges.get() ) {
															#line 291 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			returnStr += format("  Range: '%s'-'%s'", printable(range.begin).c_str(), printable(range.end).c_str());
															#line 1150 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		}
															#line 293 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		returnStr += format("  AddPrefix: '%s'  RemovePrefix: '%s'  Version: %lld", printable(addPrefix.get()).c_str(), printable(removePrefix.get()).c_str(), restoreVersion.get());
															#line 297 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		if (!static_cast<RestoreConfigFR_GetFullStatus_implActor*>(this)->SAV<std::string>::futures) { (void)(returnStr); this->~RestoreConfigFR_GetFullStatus_implActorState(); static_cast<RestoreConfigFR_GetFullStatus_implActor*>(this)->destroy(); return 0; }
															#line 1156 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		new (&static_cast<RestoreConfigFR_GetFullStatus_implActor*>(this)->SAV< std::string >::value()) std::string(returnStr);
		this->~RestoreConfigFR_GetFullStatus_implActorState();
		static_cast<RestoreConfigFR_GetFullStatus_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 288 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		std::string returnStr;
															#line 289 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		returnStr = format("%s  URL: %s", progress.get().c_str(), url.get().toString().c_str());
															#line 290 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		for( auto& range : ranges.get() ) {
															#line 291 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			returnStr += format("  Range: '%s'-'%s'", printable(range.begin).c_str(), printable(range.end).c_str());
															#line 1174 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		}
															#line 293 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		returnStr += format("  AddPrefix: '%s'  RemovePrefix: '%s'  Version: %lld", printable(addPrefix.get()).c_str(), printable(removePrefix.get()).c_str(), restoreVersion.get());
															#line 297 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		if (!static_cast<RestoreConfigFR_GetFullStatus_implActor*>(this)->SAV<std::string>::futures) { (void)(returnStr); this->~RestoreConfigFR_GetFullStatus_implActorState(); static_cast<RestoreConfigFR_GetFullStatus_implActor*>(this)->destroy(); return 0; }
															#line 1180 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		new (&static_cast<RestoreConfigFR_GetFullStatus_implActor*>(this)->SAV< std::string >::value()) std::string(returnStr);
		this->~RestoreConfigFR_GetFullStatus_implActorState();
		static_cast<RestoreConfigFR_GetFullStatus_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreConfigFR_GetFullStatus_implActor*>(this)->actor_wait_state > 0) static_cast<RestoreConfigFR_GetFullStatus_implActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreConfigFR_GetFullStatus_implActor*>(this)->ActorCallback< RestoreConfigFR_GetFullStatus_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreConfigFR_GetFullStatus_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfigFR_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreConfigFR_GetFullStatus_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfigFR_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreConfigFR_GetFullStatus_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfigFR_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 272 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Reference<RestoreConfigFR> restore;
															#line 272 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 277 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Future<std::vector<KeyRange>> ranges;
															#line 278 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Future<Key> addPrefix;
															#line 279 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Future<Key> removePrefix;
															#line 280 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Future<Key> url;
															#line 281 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Future<Version> restoreVersion;
															#line 282 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Future<std::string> progress;
															#line 1279 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
};
// This generated class is to be used only via getFullStatus_impl()
															#line 272 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
class RestoreConfigFR_GetFullStatus_implActor final : public Actor<std::string>, public ActorCallback< RestoreConfigFR_GetFullStatus_implActor, 0, Void >, public FastAllocated<RestoreConfigFR_GetFullStatus_implActor>, public RestoreConfigFR_GetFullStatus_implActorState<RestoreConfigFR_GetFullStatus_implActor> {
															#line 1284 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
public:
	using FastAllocated<RestoreConfigFR_GetFullStatus_implActor>::operator new;
	using FastAllocated<RestoreConfigFR_GetFullStatus_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2978922446363403776UL, 9382325872720809216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreConfigFR_GetFullStatus_implActor, 0, Void >;
															#line 272 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	RestoreConfigFR_GetFullStatus_implActor(Reference<RestoreConfigFR> const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 1301 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		 : Actor<std::string>(),
		   RestoreConfigFR_GetFullStatus_implActorState<RestoreConfigFR_GetFullStatus_implActor>(restore, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18076918428222944256UL, 3893606322026492160UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfigFR_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getFullStatus_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreConfigFR_GetFullStatus_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 272 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
[[nodiscard]] Future<std::string> RestoreConfigFR::getFullStatus_impl( Reference<RestoreConfigFR> const& restore, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 272 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	return Future<std::string>(new RestoreConfigFR_GetFullStatus_implActor(restore, tr));
															#line 1333 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
}

#line 299 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
Future<std::string> RestoreConfigFR::getFullStatus(Reference<ReadYourWritesTransaction> tr) {
	Reference<RestoreConfigFR> restore = Reference<RestoreConfigFR>(this);
	return getFullStatus_impl(restore, tr);
}

std::string RestoreConfigFR::toString() {
	std::stringstream ss;
	ss << "uid:" << uid.toString() << " prefix:" << subspace.key().contents().toString();
	return ss.str();
}

// parallelFileRestore is copied from FileBackupAgent.actor.cpp for the same reason as RestoreConfigFR is copied
// The implementation of parallelFileRestore is copied from FileBackupAgent.actor.cpp
// parallelFileRestore is copied from FileBackupAgent.actor.cpp for the same reason as RestoreConfigFR is copied
namespace parallelFileRestore {

															#line 1353 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
// This generated class is to be used only via decodeLogFileBlock()
															#line 315 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
template <class DecodeLogFileBlockActor>
															#line 315 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
class DecodeLogFileBlockActorState {
															#line 1359 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
public:
															#line 315 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	DecodeLogFileBlockActorState(Reference<IAsyncFile> const& file,int64_t const& offset,int const& len) 
															#line 315 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
															#line 315 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		 : file(file),
															#line 315 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		   offset(offset),
															#line 315 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		   len(len),
															#line 318 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		   buf(makeString(len))
															#line 1372 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
	{
		fdb_probe_actor_create("decodeLogFileBlock", reinterpret_cast<unsigned long>(this));

	}
	~DecodeLogFileBlockActorState() 
	{
		fdb_probe_actor_destroy("decodeLogFileBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 319 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			StrictFuture<int> __when_expr_0 = file->read(mutateString(buf), len, offset);
															#line 319 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			if (static_cast<DecodeLogFileBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1389 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DecodeLogFileBlockActor*>(this)->actor_wait_state = 1;
															#line 319 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DecodeLogFileBlockActor, 0, int >*>(static_cast<DecodeLogFileBlockActor*>(this)));
															#line 1394 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DecodeLogFileBlockActorState();
		static_cast<DecodeLogFileBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& rLen,int loopDepth) 
	{
															#line 320 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		if (rLen != len)
															#line 1417 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		{
															#line 321 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 1421 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		}
															#line 323 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		simulateBlobFailure();
															#line 325 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		Standalone<VectorRef<KeyValueRef>> results({}, buf.arena());
															#line 326 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		reader = StringRefReader(buf, restore_corrupted_data());
															#line 1429 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		try {
															#line 330 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			if (reader.consume<int32_t>() != BACKUP_AGENT_MLOG_VERSION)
															#line 1433 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			{
															#line 331 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
				return a_body1cont1Catch1(restore_unsupported_file_version(), loopDepth);
															#line 1437 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			}
															#line 334 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			for(;1;) {
															#line 336 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
				if (reader.eof() || *reader.rptr == 0xFF)
															#line 1443 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
				{
					break;
				}
															#line 340 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
				uint32_t kLen = reader.consumeNetworkUInt32();
															#line 341 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
				const uint8_t* k = reader.consume(kLen);
															#line 342 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
				uint32_t vLen = reader.consumeNetworkUInt32();
															#line 343 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
				const uint8_t* v = reader.consume(vLen);
															#line 345 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
				results.push_back(results.arena(), KeyValueRef(KeyRef(k, kLen), ValueRef(v, vLen)));
															#line 1457 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			}
															#line 349 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			for( auto b : reader.remainder() ) {
															#line 350 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
				if (b != 0xFF)
															#line 1463 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
				{
															#line 351 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
					return a_body1cont1Catch1(restore_corrupted_data_padding(), loopDepth);
															#line 1467 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
				}
			}
															#line 353 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			if (!static_cast<DecodeLogFileBlockActor*>(this)->SAV<Standalone<VectorRef<KeyValueRef>>>::futures) { (void)(results); this->~DecodeLogFileBlockActorState(); static_cast<DecodeLogFileBlockActor*>(this)->destroy(); return 0; }
															#line 1472 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			new (&static_cast<DecodeLogFileBlockActor*>(this)->SAV< Standalone<VectorRef<KeyValueRef>> >::value()) Standalone<VectorRef<KeyValueRef>>(results);
			this->~DecodeLogFileBlockActorState();
			static_cast<DecodeLogFileBlockActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(int && rLen,int loopDepth) 
	{
															#line 320 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		if (rLen != len)
															#line 1490 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		{
															#line 321 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 1494 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		}
															#line 323 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		simulateBlobFailure();
															#line 325 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		Standalone<VectorRef<KeyValueRef>> results({}, buf.arena());
															#line 326 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
		reader = StringRefReader(buf, restore_corrupted_data());
															#line 1502 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		try {
															#line 330 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			if (reader.consume<int32_t>() != BACKUP_AGENT_MLOG_VERSION)
															#line 1506 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			{
															#line 331 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
				return a_body1cont1Catch1(restore_unsupported_file_version(), loopDepth);
															#line 1510 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			}
															#line 334 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			for(;1;) {
															#line 336 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
				if (reader.eof() || *reader.rptr == 0xFF)
															#line 1516 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
				{
					break;
				}
															#line 340 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
				uint32_t kLen = reader.consumeNetworkUInt32();
															#line 341 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
				const uint8_t* k = reader.consume(kLen);
															#line 342 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
				uint32_t vLen = reader.consumeNetworkUInt32();
															#line 343 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
				const uint8_t* v = reader.consume(vLen);
															#line 345 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
				results.push_back(results.arena(), KeyValueRef(KeyRef(k, kLen), ValueRef(v, vLen)));
															#line 1530 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			}
															#line 349 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			for( auto b : reader.remainder() ) {
															#line 350 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
				if (b != 0xFF)
															#line 1536 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
				{
															#line 351 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
					return a_body1cont1Catch1(restore_corrupted_data_padding(), loopDepth);
															#line 1540 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
				}
			}
															#line 353 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			if (!static_cast<DecodeLogFileBlockActor*>(this)->SAV<Standalone<VectorRef<KeyValueRef>>>::futures) { (void)(results); this->~DecodeLogFileBlockActorState(); static_cast<DecodeLogFileBlockActor*>(this)->destroy(); return 0; }
															#line 1545 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
			new (&static_cast<DecodeLogFileBlockActor*>(this)->SAV< Standalone<VectorRef<KeyValueRef>> >::value()) Standalone<VectorRef<KeyValueRef>>(results);
			this->~DecodeLogFileBlockActorState();
			static_cast<DecodeLogFileBlockActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(int const& rLen,int loopDepth) 
	{
		loopDepth = a_body1cont1(rLen, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && rLen,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(rLen), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DecodeLogFileBlockActor*>(this)->actor_wait_state > 0) static_cast<DecodeLogFileBlockActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeLogFileBlockActor*>(this)->ActorCallback< DecodeLogFileBlockActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeLogFileBlockActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("decodeLogFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeLogFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DecodeLogFileBlockActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("decodeLogFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeLogFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DecodeLogFileBlockActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("decodeLogFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeLogFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 356 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			TraceEvent(SevError, "FileRestoreCorruptLogFileBlock") .error(e) .detail("Filename", file->getFilename()) .detail("BlockOffset", offset) .detail("BlockLen", len) .detail("ErrorRelativeOffset", reader.rptr - buf.begin()) .detail("ErrorAbsoluteOffset", reader.rptr - buf.begin() + offset);
															#line 363 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1641 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 315 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Reference<IAsyncFile> file;
															#line 315 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	int64_t offset;
															#line 315 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	int len;
															#line 318 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	Standalone<StringRef> buf;
															#line 326 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	StringRefReader reader;
															#line 1661 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
};
// This generated class is to be used only via decodeLogFileBlock()
															#line 315 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
class DecodeLogFileBlockActor final : public Actor<Standalone<VectorRef<KeyValueRef>>>, public ActorCallback< DecodeLogFileBlockActor, 0, int >, public FastAllocated<DecodeLogFileBlockActor>, public DecodeLogFileBlockActorState<DecodeLogFileBlockActor> {
															#line 1666 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
public:
	using FastAllocated<DecodeLogFileBlockActor>::operator new;
	using FastAllocated<DecodeLogFileBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7888758524817088512UL, 5239128569556507904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyValueRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DecodeLogFileBlockActor, 0, int >;
															#line 315 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	DecodeLogFileBlockActor(Reference<IAsyncFile> const& file,int64_t const& offset,int const& len) 
															#line 1683 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
		 : Actor<Standalone<VectorRef<KeyValueRef>>>(),
		   DecodeLogFileBlockActorState<DecodeLogFileBlockActor>(file, offset, len),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("decodeLogFileBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9445653568159503360UL, 13331370641466175744UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("decodeLogFileBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("decodeLogFileBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DecodeLogFileBlockActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 315 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<KeyValueRef>>> decodeLogFileBlock( Reference<IAsyncFile> const& file, int64_t const& offset, int const& len ) {
															#line 315 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"
	return Future<Standalone<VectorRef<KeyValueRef>>>(new DecodeLogFileBlockActor(file, offset, len));
															#line 1715 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreCommon.actor.g.cpp"
}

#line 366 "/codebuild/output/src1395902572/src/github.com/apple/foundationdb/fdbserver/RestoreCommon.actor.cpp"

} // namespace parallelFileRestore
