#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
/*
 * RYWDisable.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct RYWDisableWorkload : TestWorkload {
	static constexpr auto NAME = "RYWDisable";

	int nodes, keyBytes;
	double testDuration;
	std::vector<Future<Void>> clients;

	RYWDisableWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		testDuration = getOption(options, "testDuration"_sr, 600.0);
		nodes = getOption(options, "nodes"_sr, 100);
		keyBytes = std::max(getOption(options, "keyBytes"_sr, 16), 16);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (clientId == 0)
			return _start(cx, this);
		return Void();
	}

																#line 50 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 48 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
template <class _startActor>
															#line 48 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
class _startActorState {
															#line 56 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
public:
															#line 48 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
	_startActorState(Database const& cx,RYWDisableWorkload* const& self) 
															#line 48 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
															#line 48 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
		 : cx(cx),
															#line 48 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
		   self(self),
															#line 49 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
		   testStart(now())
															#line 67 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 51 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
			;
															#line 82 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 52 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 53 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
		;
															#line 114 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 56 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
			opType = deterministicRandom()->randomInt(0, 4);
															#line 57 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
			shouldError = true;
															#line 59 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
			if (opType == 0)
															#line 141 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
			{
															#line 61 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
				tr.set(self->keyForIndex(deterministicRandom()->randomInt(0, self->nodes)), StringRef());
															#line 145 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
				loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);
			}
			else
			{
															#line 62 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
				if (opType == 1)
															#line 152 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
				{
															#line 64 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
					Future<Optional<Value>> _ = tr.get(self->keyForIndex(deterministicRandom()->randomInt(0, self->nodes)));
															#line 156 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
					loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);
				}
				else
				{
															#line 66 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
					if (opType == 2)
															#line 163 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
					{
															#line 68 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
						StrictFuture<Void> __when_expr_0 = success(tr.get(self->keyForIndex(deterministicRandom()->randomInt(0, self->nodes))));
															#line 68 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
						if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 169 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
						if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
						static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 68 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
						__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 174 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 71 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
						shouldError = false;
															#line 181 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
						loopDepth = a_body1loopBody1loopBody1cont6(loopDepth);
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 95 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 95 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 221 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 95 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 226 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
		try {
															#line 76 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_YOUR_WRITES_DISABLE);
															#line 77 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
			if (shouldError)
															#line 244 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
			{
															#line 78 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
				ASSERT(false);
															#line 248 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1loopBody1loopBody1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont9(int loopDepth) 
	{
															#line 85 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.1);
															#line 85 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 365 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont9when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 85 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 370 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 80 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
			if (!shouldError)
															#line 380 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
			{
															#line 81 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
				ASSERT(false);
															#line 384 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
			}
															#line 82 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
			ASSERT(e.code() == error_code_client_invalid_operation);
															#line 388 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopBody1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont12(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1loopBody1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont13(Void const& _,int loopDepth) 
	{
															#line 87 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
		if (now() - testStart > self->testDuration)
															#line 416 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
		{
															#line 88 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
			if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 420 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
			new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_startActorState();
			static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 90 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
		if (deterministicRandom()->random01() < 0.5)
															#line 428 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 93 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
		tr.reset();
															#line 434 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont13cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont13(Void && _,int loopDepth) 
	{
															#line 87 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
		if (now() - testStart > self->testDuration)
															#line 443 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
		{
															#line 88 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
			if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 447 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
			new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_startActorState();
			static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 90 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
		if (deterministicRandom()->random01() < 0.5)
															#line 455 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 93 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
		tr.reset();
															#line 461 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont13cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont13cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 48 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
	Database cx;
															#line 48 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
	RYWDisableWorkload* self;
															#line 49 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
	double testStart;
															#line 52 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 56 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
	int opType;
															#line 57 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
	bool shouldError;
															#line 653 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 48 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 658 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1091049358426599168UL, 491973690908339200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
															#line 48 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
	_startActor(Database const& cx,RYWDisableWorkload* const& self) 
															#line 677 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 48 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, RYWDisableWorkload* const& self ) {
															#line 48 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 711 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RYWDisable.actor.g.cpp.py_gen"
}

#line 100 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/RYWDisable.actor.cpp"

	Future<bool> check(Database const& cx) override {
		bool ok = true;
		for (int i = 0; i < clients.size(); i++)
			if (clients[i].isError())
				ok = false;
		clients.clear();
		return ok;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {}

	Key keyForIndex(uint64_t index) {
		Key result = makeString(keyBytes);
		uint8_t* data = mutateString(result);
		memset(data, '.', keyBytes);

		double d = double(index) / nodes;
		emplaceIndex(data, 0, *(int64_t*)&d);

		return result;
	}
};

WorkloadFactory<RYWDisableWorkload> RYWDisableWorkloadFactory;
