#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
/*
 * Performance.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/QuietDatabase.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// TODO: explain purpose of this workload. Obviously simulation is aimed at correctness,
// not performance, so a workload literally named Performance has some explaining to do.
struct PerformanceWorkload : TestWorkload {
	static constexpr auto NAME = "Performance";

	Value probeWorkload;
	Standalone<VectorRef<KeyValueRef>> savedOptions;

	std::vector<PerfMetric> metrics;
	std::vector<TesterInterface> testers;
	PerfMetric latencyBaseline, latencySaturation;
	PerfMetric maxAchievedTPS;

	PerformanceWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		probeWorkload = getOption(options, "probeWorkload"_sr, "ReadWrite"_sr);

		// "Consume" all options and save for later tests
		for (int i = 0; i < options.size(); i++) {
			if (options[i].value.size()) {
				savedOptions.push_back_deep(savedOptions.arena(), KeyValueRef(options[i].key, options[i].value));
				printf("saved option (%d): '%s'='%s'\n",
				       i,
				       printable(options[i].key).c_str(),
				       printable(options[i].value).c_str());
				options[i].value = ""_sr;
			}
		}
		printf("saved %d options\n", savedOptions.size());
	}

	Future<Void> setup(Database const& cx) override {
		if (!clientId)
			return _setup(cx, this);
		return Void();
	}

	Future<Void> start(Database const& cx) override {
		if (!clientId)
			return _start(cx, this);
		return Void();
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {
		for (int i = 0; i < metrics.size(); i++)
			m.push_back(metrics[i]);
		if (!clientId) {
			m.emplace_back("Baseline Latency (average, ms)", latencyBaseline.value(), Averaged::False);
			m.emplace_back("Saturation Transactions/sec", maxAchievedTPS.value(), Averaged::False);
			m.emplace_back("Saturation Median Latency (average, ms)", latencySaturation.value(), Averaged::False);
		}
	}

	Standalone<VectorRef<VectorRef<KeyValueRef>>> getOpts(double transactionsPerSecond) {
		Standalone<VectorRef<KeyValueRef>> options;
		Standalone<VectorRef<VectorRef<KeyValueRef>>> opts;
		options.push_back_deep(options.arena(), KeyValueRef("testName"_sr, probeWorkload));
		options.push_back_deep(options.arena(),
		                       KeyValueRef("transactionsPerSecond"_sr, format("%f", transactionsPerSecond)));
		for (int i = 0; i < savedOptions.size(); i++) {
			options.push_back_deep(options.arena(), savedOptions[i]);
			printf("option [%d]: '%s'='%s'\n",
			       i,
			       printable(savedOptions[i].key).c_str(),
			       printable(savedOptions[i].value).c_str());
		}
		opts.push_back_deep(opts.arena(), options);
		return opts;
	}

	void logOptions(Standalone<VectorRef<VectorRef<KeyValueRef>>> options) {
		TraceEvent start("PerformaceSetupStarting");
		for (int i = 0; i < options.size(); i++) {
			for (int j = 0; j < options[i].size(); j++) {
				start.detail(format("Option-%d-%d", i, j).c_str(),
				             printable(options[i][j].key) + "=" + printable(options[i][j].value));
			}
		}
	}

	// FIXME: does not use testers which are recruited on workers
																#line 111 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
// This generated class is to be used only via getTesters()
															#line 109 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
template <class GetTestersActor>
															#line 109 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
class GetTestersActorState {
															#line 117 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
public:
															#line 109 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	GetTestersActorState(PerformanceWorkload* const& self) 
															#line 109 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
															#line 109 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		 : self(self),
															#line 110 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		   workers()
															#line 126 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getTesters", reinterpret_cast<unsigned long>(this));

	}
	~GetTestersActorState() 
	{
		fdb_probe_actor_destroy("getTesters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 112 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			;
															#line 141 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTestersActorState();
		static_cast<GetTestersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 125 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		std::vector<TesterInterface> ts;
															#line 126 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		ts.reserve(workers.size());
															#line 127 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		for(int i = 0;i < workers.size();i++) {
															#line 128 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			ts.push_back(workers[i].interf.testerInterface);
															#line 170 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		}
															#line 129 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		if (!static_cast<GetTestersActor*>(this)->SAV<std::vector<TesterInterface>>::futures) { (void)(ts); this->~GetTestersActorState(); static_cast<GetTestersActor*>(this)->destroy(); return 0; }
															#line 174 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		new (&static_cast<GetTestersActor*>(this)->SAV< std::vector<TesterInterface> >::value()) std::vector<TesterInterface>(ts);
		this->~GetTestersActorState();
		static_cast<GetTestersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 115 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = brokenPromiseToNever(self->dbInfo->get().clusterInterface.getWorkers.getReply(GetWorkersRequest( GetWorkersRequest::TESTER_CLASS_ONLY | GetWorkersRequest::NON_EXCLUDED_PROCESSES_ONLY)));
															#line 113 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		if (static_cast<GetTestersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 195 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 121 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->dbInfo->onChange();
															#line 199 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<GetTestersActor*>(this)->actor_wait_state = 1;
															#line 115 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >*>(static_cast<GetTestersActor*>(this)));
															#line 121 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTestersActor, 1, Void >*>(static_cast<GetTestersActor*>(this)));
															#line 206 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<WorkerDetails> const& w,int loopDepth) 
	{
															#line 118 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		workers = w;
															#line 234 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<WorkerDetails> && w,int loopDepth) 
	{
															#line 118 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		workers = w;
															#line 243 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTestersActor*>(this)->actor_wait_state > 0) static_cast<GetTestersActor*>(this)->actor_wait_state = 0;
		static_cast<GetTestersActor*>(this)->ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >::remove();
		static_cast<GetTestersActor*>(this)->ActorCallback< GetTestersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetTestersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 109 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	PerformanceWorkload* self;
															#line 110 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 385 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getTesters()
															#line 109 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
class GetTestersActor final : public Actor<std::vector<TesterInterface>>, public ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >, public ActorCallback< GetTestersActor, 1, Void >, public FastAllocated<GetTestersActor>, public GetTestersActorState<GetTestersActor> {
															#line 390 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetTestersActor>::operator new;
	using FastAllocated<GetTestersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16424595987361552384UL, 3103310390643306240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<TesterInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< GetTestersActor, 1, Void >;
															#line 109 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	GetTestersActor(PerformanceWorkload* const& self) 
															#line 408 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		 : Actor<std::vector<TesterInterface>>(),
		   GetTestersActorState<GetTestersActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12020919305826439936UL, 12275217311193987072UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTesters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 109 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
[[nodiscard]] Future<std::vector<TesterInterface>> getTesters( PerformanceWorkload* const& self ) {
															#line 109 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	return Future<std::vector<TesterInterface>>(new GetTestersActor(self));
															#line 440 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
}

#line 131 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"

																#line 445 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
// This generated class is to be used only via _setup()
															#line 132 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
template <class _setupActor>
															#line 132 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
class _setupActorState {
															#line 451 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
public:
															#line 132 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	_setupActorState(Database const& cx,PerformanceWorkload* const& self) 
															#line 132 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
															#line 132 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		 : cx(cx),
															#line 132 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		   self(self),
															#line 133 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		   options(self->getOpts(1000.0))
															#line 462 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 134 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			self->logOptions(options);
															#line 136 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			StrictFuture<std::vector<TesterInterface>> __when_expr_0 = self->getTesters(self);
															#line 136 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 481 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 136 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, std::vector<TesterInterface> >*>(static_cast<_setupActor*>(this)));
															#line 486 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<TesterInterface> const& testers,int loopDepth) 
	{
															#line 137 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		self->testers = testers;
															#line 139 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		TestSpec spec("PerformanceSetup"_sr, false, false);
															#line 140 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		spec.options = options;
															#line 141 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		spec.phases = TestWorkload::SETUP;
															#line 142 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		StrictFuture<DistributedTestResults> __when_expr_1 = runWorkload(cx, testers, spec);
															#line 142 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 519 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 142 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, DistributedTestResults >*>(static_cast<_setupActor*>(this)));
															#line 524 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<TesterInterface> && testers,int loopDepth) 
	{
															#line 137 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		self->testers = testers;
															#line 139 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		TestSpec spec("PerformanceSetup"_sr, false, false);
															#line 140 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		spec.options = options;
															#line 141 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		spec.phases = TestWorkload::SETUP;
															#line 142 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		StrictFuture<DistributedTestResults> __when_expr_1 = runWorkload(cx, testers, spec);
															#line 142 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 543 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 142 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, DistributedTestResults >*>(static_cast<_setupActor*>(this)));
															#line 548 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<TesterInterface> const& testers,int loopDepth) 
	{
		loopDepth = a_body1cont1(testers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<TesterInterface> && testers,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(testers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, std::vector<TesterInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, std::vector<TesterInterface> >*,std::vector<TesterInterface> const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, std::vector<TesterInterface> >*,std::vector<TesterInterface> && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, std::vector<TesterInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(DistributedTestResults const& results,int loopDepth) 
	{
															#line 144 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 632 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(DistributedTestResults && results,int loopDepth) 
	{
															#line 144 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 644 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(DistributedTestResults const& results,int loopDepth) 
	{
		loopDepth = a_body1cont2(results, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(DistributedTestResults && results,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, DistributedTestResults >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, DistributedTestResults >*,DistributedTestResults const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, DistributedTestResults >*,DistributedTestResults && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, DistributedTestResults >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 132 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	Database cx;
															#line 132 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	PerformanceWorkload* self;
															#line 133 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	Standalone<VectorRef<VectorRef<KeyValueRef>>> options;
															#line 733 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _setup()
															#line 132 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, std::vector<TesterInterface> >, public ActorCallback< _setupActor, 1, DistributedTestResults >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 738 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12624440353606001920UL, 12423951458895889664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, std::vector<TesterInterface> >;
friend struct ActorCallback< _setupActor, 1, DistributedTestResults >;
															#line 132 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	_setupActor(Database const& cx,PerformanceWorkload* const& self) 
															#line 756 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, std::vector<TesterInterface> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, DistributedTestResults >*)0, actor_cancelled()); break;
		}

	}
};
															#line 132 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, PerformanceWorkload* const& self ) {
															#line 132 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 789 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
}

#line 146 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"

	PerfMetric getNamedMetric(std::string name, std::vector<PerfMetric> metrics) {
		for (int i = 0; i < metrics.size(); i++) {
			if (metrics[i].name() == name) {
				return metrics[i];
			}
		}
		return PerfMetric();
	}

																#line 803 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
// This generated class is to be used only via getSaturation()
															#line 156 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
template <class GetSaturationActor>
															#line 156 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
class GetSaturationActorState {
															#line 809 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
public:
															#line 156 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	GetSaturationActorState(Database const& cx,PerformanceWorkload* const& self) 
															#line 156 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
															#line 156 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		 : cx(cx),
															#line 156 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		   self(self),
															#line 157 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		   tps(400),
															#line 158 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		   reported(false),
															#line 159 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		   retry(false),
															#line 160 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		   multiplier(2.0)
															#line 826 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getSaturation", reinterpret_cast<unsigned long>(this));

	}
	~GetSaturationActorState() 
	{
		fdb_probe_actor_destroy("getSaturation", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 162 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			;
															#line 841 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetSaturationActorState();
		static_cast<GetSaturationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 222 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		if (!static_cast<GetSaturationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetSaturationActorState(); static_cast<GetSaturationActor*>(this)->destroy(); return 0; }
															#line 864 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		new (&static_cast<GetSaturationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetSaturationActorState();
		static_cast<GetSaturationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 163 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		Standalone<VectorRef<VectorRef<KeyValueRef>>> options = self->getOpts(tps);
															#line 164 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		TraceEvent start("PerformaceProbeStarting");
															#line 165 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		start.detail("RateTarget", tps);
															#line 166 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		for(int i = 0;i < options.size();i++) {
															#line 167 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			for(int j = 0;j < options[i].size();j++) {
															#line 168 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
				start.detail(format("Option-%d-%d", i, j).c_str(), printable(options[i][j].key) + "=" + printable(options[i][j].value));
															#line 893 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
			}
		}
															#line 172 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		results = DistributedTestResults();
															#line 898 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		try {
															#line 174 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			TestSpec spec("PerformanceRun"_sr, false, false);
															#line 175 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			spec.phases = TestWorkload::EXECUTION | TestWorkload::METRICS;
															#line 176 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			spec.options = options;
															#line 177 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			StrictFuture<DistributedTestResults> __when_expr_0 = runWorkload(cx, self->testers, spec);
															#line 177 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			if (static_cast<GetSaturationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 910 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetSaturationActor*>(this)->actor_wait_state = 1;
															#line 177 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetSaturationActor, 0, DistributedTestResults >*>(static_cast<GetSaturationActor*>(this)));
															#line 915 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 185 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		PerfMetric tpsMetric = self->getNamedMetric("Transactions/sec", results.metrics);
															#line 186 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		PerfMetric latencyMetric = self->getNamedMetric("Median Latency (ms, averaged)", results.metrics);
															#line 188 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		logMetrics(results.metrics);
															#line 190 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		if (!reported || self->latencyBaseline.value() > latencyMetric.value())
															#line 949 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		{
															#line 191 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			self->latencyBaseline = latencyMetric;
															#line 953 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		}
															#line 192 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		if (!reported || self->maxAchievedTPS.value() < tpsMetric.value())
															#line 957 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		{
															#line 193 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			self->maxAchievedTPS = tpsMetric;
															#line 194 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			self->latencySaturation = latencyMetric;
															#line 195 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			self->metrics = results.metrics;
															#line 965 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		}
															#line 197 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		reported = true;
															#line 199 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		TraceEvent evt("PerformanceProbeComplete");
															#line 200 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		evt.detail("RateTarget", tps) .detail("AchievedRate", tpsMetric.value()) .detail("Multiplier", multiplier) .detail("Retry", retry);
															#line 204 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		if (tpsMetric.value() < (tps * .95) - 100)
															#line 975 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		{
															#line 205 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			evt.detail("LimitReached", 1);
															#line 206 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			if (!retry)
															#line 981 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
			{
															#line 207 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
				retry = true;
															#line 985 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
			}
			else
			{
															#line 208 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
				if (multiplier < 2.0)
															#line 991 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
				{
															#line 209 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
					evt.detail("Saturation", "final");
															#line 210 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
					if (!static_cast<GetSaturationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetSaturationActorState(); static_cast<GetSaturationActor*>(this)->destroy(); return 0; }
															#line 997 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
					new (&static_cast<GetSaturationActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetSaturationActorState();
					static_cast<GetSaturationActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 212 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
					tps /= 2;
															#line 213 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
					multiplier = 1.189;
															#line 214 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
					retry = false;
															#line 1011 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
				}
			}
		}
		else
		{
															#line 217 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			retry = false;
															#line 1019 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		}
															#line 219 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		tps *= retry ? 1.0 : multiplier;
															#line 1023 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 180 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			TraceEvent("PerformanceRunError") .errorUnsuppressed(e) .detail("Workload", printable(self->probeWorkload));
															#line 1033 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(DistributedTestResults const& r,int loopDepth) 
	{
															#line 178 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		results = r;
															#line 1048 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(DistributedTestResults && r,int loopDepth) 
	{
															#line 178 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		results = r;
															#line 1057 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(DistributedTestResults const& r,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(r, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(DistributedTestResults && r,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetSaturationActor*>(this)->actor_wait_state > 0) static_cast<GetSaturationActor*>(this)->actor_wait_state = 0;
		static_cast<GetSaturationActor*>(this)->ActorCallback< GetSaturationActor, 0, DistributedTestResults >::remove();

	}
	void a_callback_fire(ActorCallback< GetSaturationActor, 0, DistributedTestResults >*,DistributedTestResults const& value) 
	{
		fdb_probe_actor_enter("getSaturation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSaturationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSaturation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetSaturationActor, 0, DistributedTestResults >*,DistributedTestResults && value) 
	{
		fdb_probe_actor_enter("getSaturation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSaturationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSaturation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetSaturationActor, 0, DistributedTestResults >*,Error err) 
	{
		fdb_probe_actor_enter("getSaturation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSaturationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSaturation", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 156 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	Database cx;
															#line 156 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	PerformanceWorkload* self;
															#line 157 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	double tps;
															#line 158 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	bool reported;
															#line 159 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	bool retry;
															#line 160 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	double multiplier;
															#line 172 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	DistributedTestResults results;
															#line 1164 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getSaturation()
															#line 156 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
class GetSaturationActor final : public Actor<Void>, public ActorCallback< GetSaturationActor, 0, DistributedTestResults >, public FastAllocated<GetSaturationActor>, public GetSaturationActorState<GetSaturationActor> {
															#line 1169 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetSaturationActor>::operator new;
	using FastAllocated<GetSaturationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8785017521961338624UL, 5228460555135936768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetSaturationActor, 0, DistributedTestResults >;
															#line 156 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	GetSaturationActor(Database const& cx,PerformanceWorkload* const& self) 
															#line 1186 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetSaturationActorState<GetSaturationActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getSaturation", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11415780605773075712UL, 5303044689184922112UL);
		ActorExecutionContextHelper __helper(static_cast<GetSaturationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getSaturation");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getSaturation", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetSaturationActor, 0, DistributedTestResults >*)0, actor_cancelled()); break;
		}

	}
};
															#line 156 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
[[nodiscard]] Future<Void> getSaturation( Database const& cx, PerformanceWorkload* const& self ) {
															#line 156 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	return Future<Void>(new GetSaturationActor(cx, self));
															#line 1218 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
}

#line 224 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"

																#line 1223 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 225 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
template <class _startActor>
															#line 225 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
class _startActorState {
															#line 1229 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
public:
															#line 225 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	_startActorState(Database const& cx,PerformanceWorkload* const& self) 
															#line 225 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
															#line 225 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		 : cx(cx),
															#line 225 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		   self(self)
															#line 1238 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 226 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->getSaturation(cx, self);
															#line 226 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1255 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 226 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1260 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 227 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		TraceEvent("PerformanceSaturation") .detail("SaturationRate", self->maxAchievedTPS.value()) .detail("SaturationLatency", self->latencySaturation.value());
															#line 230 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1285 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 227 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		TraceEvent("PerformanceSaturation") .detail("SaturationRate", self->maxAchievedTPS.value()) .detail("SaturationLatency", self->latencySaturation.value());
															#line 230 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1299 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 225 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	Database cx;
															#line 225 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	PerformanceWorkload* self;
															#line 1386 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 225 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1391 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13826934829585636352UL, 12579281832264974080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 225 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	_startActor(Database const& cx,PerformanceWorkload* const& self) 
															#line 1408 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 225 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, PerformanceWorkload* const& self ) {
															#line 225 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 1440 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Performance.actor.g.cpp.py_gen"
}

#line 232 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbserver/workloads/Performance.actor.cpp"
};

WorkloadFactory<PerformanceWorkload> PerformanceWorkloadFactory;
