#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
/*
 * ProfileCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "boost/lexical_cast.hpp"

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/GlobalConfig.actor.h"
#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/Tuple.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

															#line 40 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via profileCommandActor()
															#line 38 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
template <class ProfileCommandActorActor>
															#line 38 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
class ProfileCommandActorActorState {
															#line 46 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
public:
															#line 38 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
	ProfileCommandActorActorState(Database const& db,Reference<ITransaction> const& tr,std::vector<StringRef> const& tokens,bool const& intrans) 
															#line 38 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
															#line 38 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
		 : db(db),
															#line 38 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
		   tr(tr),
															#line 38 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
		   tokens(tokens),
															#line 38 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
		   intrans(intrans),
															#line 42 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
		   result(true)
															#line 61 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("profileCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~ProfileCommandActorActorState() 
	{
		fdb_probe_actor_destroy("profileCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 43 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			if (tokens.size() == 1)
															#line 76 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
			{
															#line 44 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				printUsage(tokens[0]);
															#line 45 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				result = false;
															#line 82 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
				loopDepth = a_body1cont1(loopDepth);
			}
			else
			{
															#line 46 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				if (tokencmp(tokens[1], "client"))
															#line 89 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
				{
															#line 47 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					if (tokens.size() == 2)
															#line 93 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
					{
															#line 48 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
						fprintf(stderr, "ERROR: Usage: profile client <get|set>\n");
															#line 49 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
						if (!static_cast<ProfileCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ProfileCommandActorActorState(); static_cast<ProfileCommandActorActor*>(this)->destroy(); return 0; }
															#line 99 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
						new (&static_cast<ProfileCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
						this->~ProfileCommandActorActorState();
						static_cast<ProfileCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 51 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					StrictFuture<Void> __when_expr_0 = db->globalConfig->onInitialized();
															#line 51 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					if (static_cast<ProfileCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 109 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<ProfileCommandActorActor*>(this)->actor_wait_state = 1;
															#line 51 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProfileCommandActorActor, 0, Void >*>(static_cast<ProfileCommandActorActor*>(this)));
															#line 114 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 112 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					if (tokencmp(tokens[1], "list"))
															#line 121 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
					{
															#line 113 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
						if (tokens.size() != 2)
															#line 125 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
						{
															#line 114 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
							fprintf(stderr, "ERROR: Usage: profile list\n");
															#line 115 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
							if (!static_cast<ProfileCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ProfileCommandActorActorState(); static_cast<ProfileCommandActorActor*>(this)->destroy(); return 0; }
															#line 131 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
							new (&static_cast<ProfileCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
							this->~ProfileCommandActorActorState();
							static_cast<ProfileCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 118 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
						kvsFuture = tr->getRange( KeyRangeRef("\xff\xff/worker_interfaces/"_sr, "\xff\xff/worker_interfaces0"_sr), CLIENT_KNOBS->TOO_MANY);
															#line 120 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
						StrictFuture<RangeResult> __when_expr_2 = safeThreadFutureToFuture(kvsFuture);
															#line 120 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
						if (static_cast<ProfileCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 143 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
						if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when2(__when_expr_2.get(), loopDepth); };
						static_cast<ProfileCommandActorActor*>(this)->actor_wait_state = 3;
															#line 120 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
						__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ProfileCommandActorActor, 2, RangeResult >*>(static_cast<ProfileCommandActorActor*>(this)));
															#line 148 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 128 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
						fprintf(stderr, "ERROR: Unknown type: %s\n", printable(tokens[1]).c_str());
															#line 129 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
						result = false;
															#line 157 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
						loopDepth = a_body1cont23(loopDepth);
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProfileCommandActorActorState();
		static_cast<ProfileCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 131 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
		if (!static_cast<ProfileCommandActorActor*>(this)->SAV<bool>::futures) { (void)(result); this->~ProfileCommandActorActorState(); static_cast<ProfileCommandActorActor*>(this)->destroy(); return 0; }
															#line 183 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
		new (&static_cast<ProfileCommandActorActor*>(this)->SAV< bool >::value()) bool(std::move(result)); // state_var_RVO
		this->~ProfileCommandActorActorState();
		static_cast<ProfileCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 52 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
		if (tokencmp(tokens[2], "get"))
															#line 201 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
		{
															#line 53 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			if (tokens.size() != 3)
															#line 205 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
			{
															#line 54 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				fprintf(stderr, "ERROR: Additional arguments to `get` are not supported.\n");
															#line 55 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				if (!static_cast<ProfileCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ProfileCommandActorActorState(); static_cast<ProfileCommandActorActor*>(this)->destroy(); return 0; }
															#line 211 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
				new (&static_cast<ProfileCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~ProfileCommandActorActorState();
				static_cast<ProfileCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 57 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			std::string sampleRateStr = "default";
															#line 58 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			std::string sizeLimitStr = "default";
															#line 59 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			const double sampleRateDbl = db->globalConfig->get<double>(fdbClientInfoTxnSampleRate, std::numeric_limits<double>::infinity());
															#line 61 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			if (!std::isinf(sampleRateDbl))
															#line 225 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
			{
															#line 62 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				sampleRateStr = std::to_string(sampleRateDbl);
															#line 229 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
			}
															#line 64 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			const int64_t sizeLimit = db->globalConfig->get<int64_t>(fdbClientInfoTxnSizeLimit, -1);
															#line 65 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			if (sizeLimit != -1)
															#line 235 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
			{
															#line 66 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				sizeLimitStr = boost::lexical_cast<std::string>(sizeLimit);
															#line 239 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
			}
															#line 68 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			printf("Client profiling rate is set to %s and size limit is set to %s.\n", sampleRateStr.c_str(), sizeLimitStr.c_str());
															#line 243 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
			loopDepth = a_body1cont6(loopDepth);
		}
		else
		{
															#line 71 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			if (tokencmp(tokens[2], "set"))
															#line 250 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
			{
															#line 72 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				if (tokens.size() != 5)
															#line 254 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
				{
															#line 73 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					fprintf(stderr, "ERROR: Usage: profile client set <RATE|default> <SIZE|default>\n");
															#line 74 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					if (!static_cast<ProfileCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ProfileCommandActorActorState(); static_cast<ProfileCommandActorActor*>(this)->destroy(); return 0; }
															#line 260 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
					new (&static_cast<ProfileCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
					this->~ProfileCommandActorActorState();
					static_cast<ProfileCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 76 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				double sampleRate;
															#line 77 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				if (tokencmp(tokens[3], "default"))
															#line 270 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
				{
															#line 78 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					sampleRate = std::numeric_limits<double>::infinity();
															#line 274 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
				}
				else
				{
															#line 80 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					char* end;
															#line 81 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					sampleRate = std::strtod((const char*)tokens[3].begin(), &end);
															#line 82 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					if (!std::isspace(*end))
															#line 284 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
					{
															#line 83 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
						fprintf(stderr, "ERROR: %s failed to parse.\n", printable(tokens[3]).c_str());
															#line 84 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
						if (!static_cast<ProfileCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ProfileCommandActorActorState(); static_cast<ProfileCommandActorActor*>(this)->destroy(); return 0; }
															#line 290 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
						new (&static_cast<ProfileCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
						this->~ProfileCommandActorActorState();
						static_cast<ProfileCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
															#line 87 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				int64_t sizeLimit;
															#line 88 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				if (tokencmp(tokens[4], "default"))
															#line 301 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
				{
															#line 89 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					sizeLimit = -1;
															#line 305 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
				}
				else
				{
															#line 91 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					Optional<uint64_t> parsed = parse_with_suffix(tokens[4].toString());
															#line 92 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					if (parsed.present())
															#line 313 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
					{
															#line 93 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
						sizeLimit = parsed.get();
															#line 317 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
					}
					else
					{
															#line 95 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
						fprintf(stderr, "ERROR: `%s` failed to parse.\n", printable(tokens[4]).c_str());
															#line 96 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
						if (!static_cast<ProfileCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ProfileCommandActorActorState(); static_cast<ProfileCommandActorActor*>(this)->destroy(); return 0; }
															#line 325 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
						new (&static_cast<ProfileCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
						this->~ProfileCommandActorActorState();
						static_cast<ProfileCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
															#line 100 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				Tuple rate = Tuple::makeTuple(sampleRate);
															#line 101 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				Tuple size = Tuple::makeTuple(sizeLimit);
															#line 102 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 103 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				tr->set(GlobalConfig::prefixedKey(fdbClientInfoTxnSampleRate), rate.pack());
															#line 104 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				tr->set(GlobalConfig::prefixedKey(fdbClientInfoTxnSizeLimit), size.pack());
															#line 105 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				if (!intrans)
															#line 344 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
				{
															#line 106 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 106 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					if (static_cast<ProfileCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 350 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont4when1(__when_expr_1.get(), loopDepth); };
					static_cast<ProfileCommandActorActor*>(this)->actor_wait_state = 2;
															#line 106 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProfileCommandActorActor, 1, Void >*>(static_cast<ProfileCommandActorActor*>(this)));
															#line 355 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont12(loopDepth);
				}
			}
			else
			{
															#line 109 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				fprintf(stderr, "ERROR: Unknown action: %s\n", printable(tokens[2]).c_str());
															#line 110 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				result = false;
															#line 369 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
				loopDepth = a_body1cont11(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 52 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
		if (tokencmp(tokens[2], "get"))
															#line 380 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
		{
															#line 53 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			if (tokens.size() != 3)
															#line 384 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
			{
															#line 54 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				fprintf(stderr, "ERROR: Additional arguments to `get` are not supported.\n");
															#line 55 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				if (!static_cast<ProfileCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ProfileCommandActorActorState(); static_cast<ProfileCommandActorActor*>(this)->destroy(); return 0; }
															#line 390 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
				new (&static_cast<ProfileCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~ProfileCommandActorActorState();
				static_cast<ProfileCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 57 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			std::string sampleRateStr = "default";
															#line 58 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			std::string sizeLimitStr = "default";
															#line 59 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			const double sampleRateDbl = db->globalConfig->get<double>(fdbClientInfoTxnSampleRate, std::numeric_limits<double>::infinity());
															#line 61 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			if (!std::isinf(sampleRateDbl))
															#line 404 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
			{
															#line 62 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				sampleRateStr = std::to_string(sampleRateDbl);
															#line 408 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
			}
															#line 64 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			const int64_t sizeLimit = db->globalConfig->get<int64_t>(fdbClientInfoTxnSizeLimit, -1);
															#line 65 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			if (sizeLimit != -1)
															#line 414 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
			{
															#line 66 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				sizeLimitStr = boost::lexical_cast<std::string>(sizeLimit);
															#line 418 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
			}
															#line 68 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			printf("Client profiling rate is set to %s and size limit is set to %s.\n", sampleRateStr.c_str(), sizeLimitStr.c_str());
															#line 422 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
			loopDepth = a_body1cont6(loopDepth);
		}
		else
		{
															#line 71 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			if (tokencmp(tokens[2], "set"))
															#line 429 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
			{
															#line 72 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				if (tokens.size() != 5)
															#line 433 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
				{
															#line 73 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					fprintf(stderr, "ERROR: Usage: profile client set <RATE|default> <SIZE|default>\n");
															#line 74 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					if (!static_cast<ProfileCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ProfileCommandActorActorState(); static_cast<ProfileCommandActorActor*>(this)->destroy(); return 0; }
															#line 439 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
					new (&static_cast<ProfileCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
					this->~ProfileCommandActorActorState();
					static_cast<ProfileCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 76 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				double sampleRate;
															#line 77 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				if (tokencmp(tokens[3], "default"))
															#line 449 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
				{
															#line 78 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					sampleRate = std::numeric_limits<double>::infinity();
															#line 453 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
				}
				else
				{
															#line 80 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					char* end;
															#line 81 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					sampleRate = std::strtod((const char*)tokens[3].begin(), &end);
															#line 82 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					if (!std::isspace(*end))
															#line 463 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
					{
															#line 83 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
						fprintf(stderr, "ERROR: %s failed to parse.\n", printable(tokens[3]).c_str());
															#line 84 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
						if (!static_cast<ProfileCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ProfileCommandActorActorState(); static_cast<ProfileCommandActorActor*>(this)->destroy(); return 0; }
															#line 469 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
						new (&static_cast<ProfileCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
						this->~ProfileCommandActorActorState();
						static_cast<ProfileCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
															#line 87 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				int64_t sizeLimit;
															#line 88 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				if (tokencmp(tokens[4], "default"))
															#line 480 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
				{
															#line 89 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					sizeLimit = -1;
															#line 484 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
				}
				else
				{
															#line 91 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					Optional<uint64_t> parsed = parse_with_suffix(tokens[4].toString());
															#line 92 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					if (parsed.present())
															#line 492 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
					{
															#line 93 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
						sizeLimit = parsed.get();
															#line 496 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
					}
					else
					{
															#line 95 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
						fprintf(stderr, "ERROR: `%s` failed to parse.\n", printable(tokens[4]).c_str());
															#line 96 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
						if (!static_cast<ProfileCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ProfileCommandActorActorState(); static_cast<ProfileCommandActorActor*>(this)->destroy(); return 0; }
															#line 504 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
						new (&static_cast<ProfileCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
						this->~ProfileCommandActorActorState();
						static_cast<ProfileCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
															#line 100 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				Tuple rate = Tuple::makeTuple(sampleRate);
															#line 101 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				Tuple size = Tuple::makeTuple(sizeLimit);
															#line 102 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 103 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				tr->set(GlobalConfig::prefixedKey(fdbClientInfoTxnSampleRate), rate.pack());
															#line 104 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				tr->set(GlobalConfig::prefixedKey(fdbClientInfoTxnSizeLimit), size.pack());
															#line 105 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				if (!intrans)
															#line 523 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
				{
															#line 106 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 106 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					if (static_cast<ProfileCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 529 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont4when1(__when_expr_1.get(), loopDepth); };
					static_cast<ProfileCommandActorActor*>(this)->actor_wait_state = 2;
															#line 106 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProfileCommandActorActor, 1, Void >*>(static_cast<ProfileCommandActorActor*>(this)));
															#line 534 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont12(loopDepth);
				}
			}
			else
			{
															#line 109 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				fprintf(stderr, "ERROR: Unknown action: %s\n", printable(tokens[2]).c_str());
															#line 110 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
				result = false;
															#line 548 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
				loopDepth = a_body1cont11(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProfileCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ProfileCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ProfileCommandActorActor*>(this)->ActorCallback< ProfileCommandActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProfileCommandActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("profileCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProfileCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("profileCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProfileCommandActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("profileCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProfileCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("profileCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProfileCommandActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("profileCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProfileCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("profileCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont21(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont21(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont21(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont21(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProfileCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ProfileCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ProfileCommandActorActor*>(this)->ActorCallback< ProfileCommandActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProfileCommandActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("profileCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProfileCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("profileCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProfileCommandActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("profileCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProfileCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("profileCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProfileCommandActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("profileCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProfileCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("profileCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont23(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont24(RangeResult const& kvs,int loopDepth) 
	{
															#line 121 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
		ASSERT(!kvs.more);
															#line 122 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
		for( const auto& pair : kvs ) {
															#line 123 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			auto ip_port = (pair.key.endsWith(":tls"_sr) ? pair.key.removeSuffix(":tls"_sr) : pair.key) .removePrefix("\xff\xff/worker_interfaces/"_sr);
															#line 125 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			printf("%s\n", printable(ip_port).c_str());
															#line 751 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont23(loopDepth);

		return loopDepth;
	}
	int a_body1cont24(RangeResult && kvs,int loopDepth) 
	{
															#line 121 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
		ASSERT(!kvs.more);
															#line 122 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
		for( const auto& pair : kvs ) {
															#line 123 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			auto ip_port = (pair.key.endsWith(":tls"_sr) ? pair.key.removeSuffix(":tls"_sr) : pair.key) .removePrefix("\xff\xff/worker_interfaces/"_sr);
															#line 125 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
			printf("%s\n", printable(ip_port).c_str());
															#line 767 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont23(loopDepth);

		return loopDepth;
	}
	int a_body1when2(RangeResult const& kvs,int loopDepth) 
	{
		loopDepth = a_body1cont24(kvs, loopDepth);

		return loopDepth;
	}
	int a_body1when2(RangeResult && kvs,int loopDepth) 
	{
		loopDepth = a_body1cont24(std::move(kvs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ProfileCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ProfileCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ProfileCommandActorActor*>(this)->ActorCallback< ProfileCommandActorActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ProfileCommandActorActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("profileCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProfileCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("profileCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ProfileCommandActorActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("profileCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProfileCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("profileCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ProfileCommandActorActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("profileCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProfileCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("profileCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 38 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
	Database db;
															#line 38 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 38 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 38 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
	bool intrans;
															#line 42 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
	bool result;
															#line 118 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
	ThreadFuture<RangeResult> kvsFuture;
															#line 860 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via profileCommandActor()
															#line 38 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
class ProfileCommandActorActor final : public Actor<bool>, public ActorCallback< ProfileCommandActorActor, 0, Void >, public ActorCallback< ProfileCommandActorActor, 1, Void >, public ActorCallback< ProfileCommandActorActor, 2, RangeResult >, public FastAllocated<ProfileCommandActorActor>, public ProfileCommandActorActorState<ProfileCommandActorActor> {
															#line 865 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<ProfileCommandActorActor>::operator new;
	using FastAllocated<ProfileCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10422047638674521600UL, 8322922011165430784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProfileCommandActorActor, 0, Void >;
friend struct ActorCallback< ProfileCommandActorActor, 1, Void >;
friend struct ActorCallback< ProfileCommandActorActor, 2, RangeResult >;
															#line 38 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
	ProfileCommandActorActor(Database const& db,Reference<ITransaction> const& tr,std::vector<StringRef> const& tokens,bool const& intrans) 
															#line 884 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   ProfileCommandActorActorState<ProfileCommandActorActor>(db, tr, tokens, intrans),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("profileCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7814037025155383296UL, 4084660296965118720UL);
		ActorExecutionContextHelper __helper(static_cast<ProfileCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("profileCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("profileCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProfileCommandActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ProfileCommandActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ProfileCommandActorActor, 2, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 38 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
[[nodiscard]] Future<bool> profileCommandActor( Database const& db, Reference<ITransaction> const& tr, std::vector<StringRef> const& tokens, bool const& intrans ) {
															#line 38 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"
	return Future<bool>(new ProfileCommandActorActor(db, tr, tokens, intrans));
															#line 918 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/build_output/fdbcli/ProfileCommand.actor.g.cpp.py_gen"
}

#line 133 "/codebuild/output/src1842299838/src/github.com/apple/foundationdb/fdbcli/ProfileCommand.actor.cpp"

CommandFactory profileFactory("profile",
                              CommandHelp("profile <client|list> <action> <ARGS>",
                                          "namespace for all the profiling-related commands.",
                                          "Different types support different actions.  Run `profile` to get a list of "
                                          "types, and iteratively explore the help.\n"));
} // namespace fdb_cli
