#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
/*
 * CreateMetacluster.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_CREATEMETACLUSTER_ACTOR_G_H)
#define METACLUSTER_CREATEMETACLUSTER_ACTOR_G_H
#include "metacluster/CreateMetacluster.actor.g.h"
#elif !defined(METACLUSTER_CREATEMETACLUSTER_ACTOR_H)
#define METACLUSTER_CREATEMETACLUSTER_ACTOR_H

#include "fdbclient/Tenant.h"
#include "fdbclient/TenantManagement.actor.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "metacluster/MetaclusterInternal.actor.h"
#include "metacluster/MetaclusterTypes.h"

#include "flow/actorcompiler.h" // has to be last include

namespace metacluster::internal {

															#line 42 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
// This generated class is to be used only via getClusterConfiguredTenantMode()
															#line 40 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
template <class Transaction, class GetClusterConfiguredTenantModeActor>
															#line 40 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
class GetClusterConfiguredTenantModeActorState {
															#line 48 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
public:
															#line 40 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
	GetClusterConfiguredTenantModeActorState(Transaction const& tr) 
															#line 40 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
															#line 40 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		 : tr(tr),
															#line 42 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		   tenantModeFuture(tr->get(tenantModeConfKey))
															#line 57 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
	{
		fdb_probe_actor_create("getClusterConfiguredTenantMode", reinterpret_cast<unsigned long>(this));

	}
	~GetClusterConfiguredTenantModeActorState() 
	{
		fdb_probe_actor_destroy("getClusterConfiguredTenantMode", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 44 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			StrictFuture<Optional<Value>> __when_expr_0 = safeThreadFutureToFuture(tenantModeFuture);
															#line 44 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			if (static_cast<GetClusterConfiguredTenantModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 74 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetClusterConfiguredTenantModeActor*>(this)->actor_wait_state = 1;
															#line 44 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetClusterConfiguredTenantModeActor, 0, Optional<Value> >*>(static_cast<GetClusterConfiguredTenantModeActor*>(this)));
															#line 79 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetClusterConfiguredTenantModeActorState();
		static_cast<GetClusterConfiguredTenantModeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& tenantModeValue,int loopDepth) 
	{
															#line 45 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		if (!static_cast<GetClusterConfiguredTenantModeActor*>(this)->SAV<TenantMode>::futures) { (void)(TenantMode::fromValue(tenantModeValue.castTo<ValueRef>())); this->~GetClusterConfiguredTenantModeActorState(); static_cast<GetClusterConfiguredTenantModeActor*>(this)->destroy(); return 0; }
															#line 102 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		new (&static_cast<GetClusterConfiguredTenantModeActor*>(this)->SAV< TenantMode >::value()) TenantMode(TenantMode::fromValue(tenantModeValue.castTo<ValueRef>()));
		this->~GetClusterConfiguredTenantModeActorState();
		static_cast<GetClusterConfiguredTenantModeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && tenantModeValue,int loopDepth) 
	{
															#line 45 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		if (!static_cast<GetClusterConfiguredTenantModeActor*>(this)->SAV<TenantMode>::futures) { (void)(TenantMode::fromValue(tenantModeValue.castTo<ValueRef>())); this->~GetClusterConfiguredTenantModeActorState(); static_cast<GetClusterConfiguredTenantModeActor*>(this)->destroy(); return 0; }
															#line 114 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		new (&static_cast<GetClusterConfiguredTenantModeActor*>(this)->SAV< TenantMode >::value()) TenantMode(TenantMode::fromValue(tenantModeValue.castTo<ValueRef>()));
		this->~GetClusterConfiguredTenantModeActorState();
		static_cast<GetClusterConfiguredTenantModeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& tenantModeValue,int loopDepth) 
	{
		loopDepth = a_body1cont1(tenantModeValue, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && tenantModeValue,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tenantModeValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetClusterConfiguredTenantModeActor*>(this)->actor_wait_state > 0) static_cast<GetClusterConfiguredTenantModeActor*>(this)->actor_wait_state = 0;
		static_cast<GetClusterConfiguredTenantModeActor*>(this)->ActorCallback< GetClusterConfiguredTenantModeActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetClusterConfiguredTenantModeActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getClusterConfiguredTenantMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterConfiguredTenantModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getClusterConfiguredTenantMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetClusterConfiguredTenantModeActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getClusterConfiguredTenantMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterConfiguredTenantModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getClusterConfiguredTenantMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetClusterConfiguredTenantModeActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getClusterConfiguredTenantMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterConfiguredTenantModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getClusterConfiguredTenantMode", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 40 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
	Transaction tr;
															#line 42 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
	typename transaction_future_type<Transaction, Optional<Value>>::type tenantModeFuture;
															#line 201 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
};
// This generated class is to be used only via getClusterConfiguredTenantMode()
															#line 40 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
template <class Transaction>
															#line 40 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
class GetClusterConfiguredTenantModeActor final : public Actor<TenantMode>, public ActorCallback< GetClusterConfiguredTenantModeActor<Transaction>, 0, Optional<Value> >, public FastAllocated<GetClusterConfiguredTenantModeActor<Transaction>>, public GetClusterConfiguredTenantModeActorState<Transaction, GetClusterConfiguredTenantModeActor<Transaction>> {
															#line 208 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
public:
	using FastAllocated<GetClusterConfiguredTenantModeActor<Transaction>>::operator new;
	using FastAllocated<GetClusterConfiguredTenantModeActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11495028555723718912UL, 12831202127859929856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<TenantMode>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetClusterConfiguredTenantModeActor<Transaction>, 0, Optional<Value> >;
															#line 40 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
	GetClusterConfiguredTenantModeActor(Transaction const& tr) 
															#line 225 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		 : Actor<TenantMode>(),
		   GetClusterConfiguredTenantModeActorState<Transaction, GetClusterConfiguredTenantModeActor<Transaction>>(tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getClusterConfiguredTenantMode", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14547437467466124032UL, 13026153538175903744UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterConfiguredTenantModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getClusterConfiguredTenantMode");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getClusterConfiguredTenantMode", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetClusterConfiguredTenantModeActor<Transaction>, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 40 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
template <class Transaction>
															#line 40 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
[[nodiscard]] Future<TenantMode> getClusterConfiguredTenantMode( Transaction const& tr ) {
															#line 40 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
	return Future<TenantMode>(new GetClusterConfiguredTenantModeActor<Transaction>(tr));
															#line 259 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
}

#line 47 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"

} // namespace metacluster::internal

namespace metacluster {

															#line 268 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
// This generated class is to be used only via createMetacluster()
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
template <class DB, class CreateMetaclusterActor>
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
class CreateMetaclusterActorState {
															#line 274 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
public:
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
	CreateMetaclusterActorState(Reference<DB> const& db,ClusterName const& name,int64_t const& tenantIdPrefix,bool const& enableTenantModeCheck) 
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		 : db(db),
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		   name(name),
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		   tenantIdPrefix(tenantIdPrefix),
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		   enableTenantModeCheck(enableTenantModeCheck),
															#line 57 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		   tr(db->createTransaction()),
															#line 58 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		   metaclusterUid()
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
	{
		fdb_probe_actor_create("createMetacluster", reinterpret_cast<unsigned long>(this));

	}
	~CreateMetaclusterActorState() 
	{
		fdb_probe_actor_destroy("createMetacluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 59 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			ASSERT(tenantIdPrefix >= TenantAPI::TENANT_ID_PREFIX_MIN_VALUE && tenantIdPrefix <= TenantAPI::TENANT_ID_PREFIX_MAX_VALUE);
															#line 62 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			if (name.startsWith("\xff"_sr))
															#line 308 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
			{
															#line 63 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
				CODE_PROBE(true, "Create metacluster with invalid name");
															#line 64 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
				return a_body1Catch1(invalid_cluster_name(), loopDepth);
															#line 314 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
			}
															#line 67 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			;
															#line 318 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateMetaclusterActorState();
		static_cast<CreateMetaclusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 121 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		TraceEvent("CreatedMetacluster").detail("Name", name).detail("Prefix", tenantIdPrefix);
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		if (!static_cast<CreateMetaclusterActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~CreateMetaclusterActorState(); static_cast<CreateMetaclusterActor*>(this)->destroy(); return 0; }
															#line 343 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		new (&static_cast<CreateMetaclusterActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~CreateMetaclusterActorState();
		static_cast<CreateMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 69 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 71 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			metaclusterRegistrationFuture = metadata::metaclusterRegistration().get(tr);
															#line 74 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			metaclusterEmptinessCheck = internal::managementClusterCheckEmpty(tr);
															#line 75 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			tenantModeFuture = enableTenantModeCheck ? internal::getClusterConfiguredTenantMode(tr) : Future<TenantMode>(TenantMode::DISABLED);
															#line 79 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_0 = metaclusterRegistrationFuture;
															#line 79 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 373 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 1;
															#line 79 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateMetaclusterActor, 0, Optional<MetaclusterRegistrationEntry> >*>(static_cast<CreateMetaclusterActor*>(this)));
															#line 378 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 114 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			CODE_PROBE(e.code() == error_code_cluster_not_empty, "Create metacluster on non-empty cluster", probe::decoration::rare);
															#line 117 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			StrictFuture<Void> __when_expr_4 = safeThreadFutureToFuture(tr->onError(e));
															#line 117 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 417 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 5;
															#line 117 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CreateMetaclusterActor, 4, Void >*>(static_cast<CreateMetaclusterActor*>(this)));
															#line 422 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<MetaclusterRegistrationEntry> const& existingRegistration,int loopDepth) 
	{
															#line 80 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		if (existingRegistration.present())
															#line 437 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		{
															#line 81 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			if (metaclusterUid.present() && metaclusterUid.get() == existingRegistration.get().metaclusterId)
															#line 441 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
			{
															#line 82 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
				CODE_PROBE(true, "Create metacluster already succeeded");
															#line 83 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
				if (!static_cast<CreateMetaclusterActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~CreateMetaclusterActorState(); static_cast<CreateMetaclusterActor*>(this)->destroy(); return 0; }
															#line 447 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
				new (&static_cast<CreateMetaclusterActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
				this->~CreateMetaclusterActorState();
				static_cast<CreateMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 85 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
				CODE_PROBE(true, "Metacluster already registered");
															#line 86 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
				if (!static_cast<CreateMetaclusterActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(fmt::format("cluster is already registered as a {} named `{}'", existingRegistration.get().clusterType == ClusterType::METACLUSTER_DATA ? "data cluster" : "metacluster", printable(existingRegistration.get().name))); this->~CreateMetaclusterActorState(); static_cast<CreateMetaclusterActor*>(this)->destroy(); return 0; }
															#line 459 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
				new (&static_cast<CreateMetaclusterActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(fmt::format("cluster is already registered as a {} named `{}'", existingRegistration.get().clusterType == ClusterType::METACLUSTER_DATA ? "data cluster" : "metacluster", printable(existingRegistration.get().name)));
				this->~CreateMetaclusterActorState();
				static_cast<CreateMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		StrictFuture<Void> __when_expr_1 = metaclusterEmptinessCheck;
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 470 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 2;
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateMetaclusterActor, 1, Void >*>(static_cast<CreateMetaclusterActor*>(this)));
															#line 475 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<MetaclusterRegistrationEntry> && existingRegistration,int loopDepth) 
	{
															#line 80 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		if (existingRegistration.present())
															#line 484 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		{
															#line 81 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			if (metaclusterUid.present() && metaclusterUid.get() == existingRegistration.get().metaclusterId)
															#line 488 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
			{
															#line 82 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
				CODE_PROBE(true, "Create metacluster already succeeded");
															#line 83 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
				if (!static_cast<CreateMetaclusterActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~CreateMetaclusterActorState(); static_cast<CreateMetaclusterActor*>(this)->destroy(); return 0; }
															#line 494 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
				new (&static_cast<CreateMetaclusterActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
				this->~CreateMetaclusterActorState();
				static_cast<CreateMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 85 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
				CODE_PROBE(true, "Metacluster already registered");
															#line 86 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
				if (!static_cast<CreateMetaclusterActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(fmt::format("cluster is already registered as a {} named `{}'", existingRegistration.get().clusterType == ClusterType::METACLUSTER_DATA ? "data cluster" : "metacluster", printable(existingRegistration.get().name))); this->~CreateMetaclusterActorState(); static_cast<CreateMetaclusterActor*>(this)->destroy(); return 0; }
															#line 506 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
				new (&static_cast<CreateMetaclusterActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(fmt::format("cluster is already registered as a {} named `{}'", existingRegistration.get().clusterType == ClusterType::METACLUSTER_DATA ? "data cluster" : "metacluster", printable(existingRegistration.get().name)));
				this->~CreateMetaclusterActorState();
				static_cast<CreateMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		StrictFuture<Void> __when_expr_1 = metaclusterEmptinessCheck;
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 517 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 2;
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateMetaclusterActor, 1, Void >*>(static_cast<CreateMetaclusterActor*>(this)));
															#line 522 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<MetaclusterRegistrationEntry> const& existingRegistration,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(existingRegistration, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<MetaclusterRegistrationEntry> && existingRegistration,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(existingRegistration), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<CreateMetaclusterActor*>(this)->ActorCallback< CreateMetaclusterActor, 0, Optional<MetaclusterRegistrationEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateMetaclusterActor, 0, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> const& value) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateMetaclusterActor, 0, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> && value) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateMetaclusterActor, 0, Optional<MetaclusterRegistrationEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 95 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		StrictFuture<TenantMode> __when_expr_2 = tenantModeFuture;
															#line 95 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 608 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 3;
															#line 95 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateMetaclusterActor, 2, TenantMode >*>(static_cast<CreateMetaclusterActor*>(this)));
															#line 613 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 95 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		StrictFuture<TenantMode> __when_expr_2 = tenantModeFuture;
															#line 95 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 624 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 3;
															#line 95 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateMetaclusterActor, 2, TenantMode >*>(static_cast<CreateMetaclusterActor*>(this)));
															#line 629 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<CreateMetaclusterActor*>(this)->ActorCallback< CreateMetaclusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateMetaclusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateMetaclusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateMetaclusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(TenantMode const& tenantMode,int loopDepth) 
	{
															#line 96 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		if (tenantMode != TenantMode::DISABLED)
															#line 713 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		{
															#line 97 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			CODE_PROBE(true, "Create metacluster with invalid tenant mode", probe::decoration::rare);
															#line 98 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			if (!static_cast<CreateMetaclusterActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(fmt::format("cluster is configured with tenant mode `{}' when tenants should be disabled", tenantMode.toString())); this->~CreateMetaclusterActorState(); static_cast<CreateMetaclusterActor*>(this)->destroy(); return 0; }
															#line 719 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
			new (&static_cast<CreateMetaclusterActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(fmt::format("cluster is configured with tenant mode `{}' when tenants should be disabled", tenantMode.toString()));
			this->~CreateMetaclusterActorState();
			static_cast<CreateMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 102 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		if (!metaclusterUid.present())
															#line 727 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		{
															#line 103 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			metaclusterUid = deterministicRandom()->randomUniqueID();
															#line 731 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		}
															#line 106 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		metadata::metaclusterRegistration().set( tr, MetaclusterRegistrationEntry(name, metaclusterUid.get(), MetaclusterVersion::V1));
															#line 109 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		TenantMetadata::tenantIdPrefix().set(tr, tenantIdPrefix);
															#line 111 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		StrictFuture<Void> __when_expr_3 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 111 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 741 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_3.get(), loopDepth); };
		static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 4;
															#line 111 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateMetaclusterActor, 3, Void >*>(static_cast<CreateMetaclusterActor*>(this)));
															#line 746 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(TenantMode && tenantMode,int loopDepth) 
	{
															#line 96 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		if (tenantMode != TenantMode::DISABLED)
															#line 755 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		{
															#line 97 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			CODE_PROBE(true, "Create metacluster with invalid tenant mode", probe::decoration::rare);
															#line 98 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			if (!static_cast<CreateMetaclusterActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(fmt::format("cluster is configured with tenant mode `{}' when tenants should be disabled", tenantMode.toString())); this->~CreateMetaclusterActorState(); static_cast<CreateMetaclusterActor*>(this)->destroy(); return 0; }
															#line 761 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
			new (&static_cast<CreateMetaclusterActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(fmt::format("cluster is configured with tenant mode `{}' when tenants should be disabled", tenantMode.toString()));
			this->~CreateMetaclusterActorState();
			static_cast<CreateMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 102 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		if (!metaclusterUid.present())
															#line 769 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		{
															#line 103 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
			metaclusterUid = deterministicRandom()->randomUniqueID();
															#line 773 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		}
															#line 106 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		metadata::metaclusterRegistration().set( tr, MetaclusterRegistrationEntry(name, metaclusterUid.get(), MetaclusterVersion::V1));
															#line 109 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		TenantMetadata::tenantIdPrefix().set(tr, tenantIdPrefix);
															#line 111 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		StrictFuture<Void> __when_expr_3 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 111 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 783 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_3.get(), loopDepth); };
		static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 4;
															#line 111 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateMetaclusterActor, 3, Void >*>(static_cast<CreateMetaclusterActor*>(this)));
															#line 788 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(TenantMode const& tenantMode,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(tenantMode, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(TenantMode && tenantMode,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(tenantMode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<CreateMetaclusterActor*>(this)->ActorCallback< CreateMetaclusterActor, 2, TenantMode >::remove();

	}
	void a_callback_fire(ActorCallback< CreateMetaclusterActor, 2, TenantMode >*,TenantMode const& value) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CreateMetaclusterActor, 2, TenantMode >*,TenantMode && value) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CreateMetaclusterActor, 2, TenantMode >*,Error err) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<CreateMetaclusterActor*>(this)->ActorCallback< CreateMetaclusterActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateMetaclusterActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CreateMetaclusterActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CreateMetaclusterActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<CreateMetaclusterActor*>(this)->ActorCallback< CreateMetaclusterActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateMetaclusterActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CreateMetaclusterActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CreateMetaclusterActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
	Reference<DB> db;
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
	ClusterName name;
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
	int64_t tenantIdPrefix;
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
	bool enableTenantModeCheck;
															#line 57 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 58 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
	Optional<UID> metaclusterUid;
															#line 71 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
	Future<Optional<MetaclusterRegistrationEntry>> metaclusterRegistrationFuture;
															#line 74 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
	Future<Void> metaclusterEmptinessCheck;
															#line 75 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
	Future<TenantMode> tenantModeFuture;
															#line 1060 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
};
// This generated class is to be used only via createMetacluster()
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
template <class DB>
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
class CreateMetaclusterActor final : public Actor<Optional<std::string>>, public ActorCallback< CreateMetaclusterActor<DB>, 0, Optional<MetaclusterRegistrationEntry> >, public ActorCallback< CreateMetaclusterActor<DB>, 1, Void >, public ActorCallback< CreateMetaclusterActor<DB>, 2, TenantMode >, public ActorCallback< CreateMetaclusterActor<DB>, 3, Void >, public ActorCallback< CreateMetaclusterActor<DB>, 4, Void >, public FastAllocated<CreateMetaclusterActor<DB>>, public CreateMetaclusterActorState<DB, CreateMetaclusterActor<DB>> {
															#line 1067 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
public:
	using FastAllocated<CreateMetaclusterActor<DB>>::operator new;
	using FastAllocated<CreateMetaclusterActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6501680590258506752UL, 4145844411485951488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateMetaclusterActor<DB>, 0, Optional<MetaclusterRegistrationEntry> >;
friend struct ActorCallback< CreateMetaclusterActor<DB>, 1, Void >;
friend struct ActorCallback< CreateMetaclusterActor<DB>, 2, TenantMode >;
friend struct ActorCallback< CreateMetaclusterActor<DB>, 3, Void >;
friend struct ActorCallback< CreateMetaclusterActor<DB>, 4, Void >;
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
	CreateMetaclusterActor(Reference<DB> const& db,ClusterName const& name,int64_t const& tenantIdPrefix,bool const& enableTenantModeCheck) 
															#line 1088 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
		 : Actor<Optional<std::string>>(),
		   CreateMetaclusterActorState<DB, CreateMetaclusterActor<DB>>(db, name, tenantIdPrefix, enableTenantModeCheck),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9165621760296402688UL, 14508341675007748352UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createMetacluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateMetaclusterActor<DB>, 0, Optional<MetaclusterRegistrationEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateMetaclusterActor<DB>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CreateMetaclusterActor<DB>, 2, TenantMode >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CreateMetaclusterActor<DB>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CreateMetaclusterActor<DB>, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
template <class DB>
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
[[nodiscard]] Future<Optional<std::string>> createMetacluster( Reference<DB> const& db, ClusterName const& name, int64_t const& tenantIdPrefix, bool const& enableTenantModeCheck ) {
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
	return Future<Optional<std::string>>(new CreateMetaclusterActor<DB>(db, name, tenantIdPrefix, enableTenantModeCheck));
															#line 1126 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateMetacluster.actor.g.h"
}

#line 125 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateMetacluster.actor.h"
} // namespace metacluster

#include "flow/unactorcompiler.h"
#endif