#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
/*
 * WatchAndWait.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct WatchAndWaitWorkload : TestWorkload {
	static constexpr auto NAME = "WatchAndWait";

	uint64_t nodeCount, watchCount;
	int64_t nodePrefix;
	int keyBytes;
	double testDuration;
	bool triggerWatches;
	std::vector<Future<Void>> clients;
	PerfIntCounter triggers, retries;

	WatchAndWaitWorkload(WorkloadContext const& wcx) : TestWorkload(wcx), triggers("Triggers"), retries("Retries") {
		testDuration = getOption(options, "testDuration"_sr, 600.0);
		watchCount = getOption(options, "watchCount"_sr, (uint64_t)10000);
		nodeCount = getOption(options, "nodeCount"_sr, (uint64_t)100000);
		nodePrefix = getOption(options, "nodePrefix"_sr, (int64_t)-1);
		keyBytes = std::max(getOption(options, "keyBytes"_sr, 16), 4);
		triggerWatches = getOption(options, "triggerWatches"_sr, false);

		if (watchCount > nodeCount) {
			watchCount = nodeCount;
		}
		if (nodePrefix > 0) {
			keyBytes += 16;
		}

		if (!triggerWatches) {
			keyBytes++; // watches are on different keys than the ones being modified by the workload
		}
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override { return _start(cx, this); }

	Key keyForIndex(uint64_t index) const {
		Key result = makeString(keyBytes);
		uint8_t* data = mutateString(result);
		memset(data, '.', keyBytes);

		int idx = 0;
		if (nodePrefix > 0) {
			emplaceIndex(data, 0, nodePrefix);
			idx += 16;
		}

		double d = double(index) / nodeCount;
		emplaceIndex(data, idx, *(int64_t*)&d);

		return result;
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {
		double duration = testDuration;
		m.emplace_back("Triggers/sec", triggers.getValue() / duration, Averaged::False);
		m.push_back(triggers.getMetric());
		m.push_back(retries.getMetric());
	}

																#line 91 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 89 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
template <class _startActor>
															#line 89 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
class _startActorState {
															#line 97 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
public:
															#line 89 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
	_startActorState(Database const& cx,WatchAndWaitWorkload* const& self) 
															#line 89 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
															#line 89 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
		 : cx(cx),
															#line 89 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
		   self(self),
															#line 90 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
		   watches()
															#line 108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 91 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
			uint64_t endNode = (self->nodeCount * (self->clientId + 1)) / self->clientCount;
															#line 92 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
			uint64_t startNode = (self->nodeCount * self->clientId) / self->clientCount;
															#line 93 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
			uint64_t NodesPerWatch = self->nodeCount / self->watchCount;
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
			TraceEvent("WatchAndWaitExpect") .detail("Duration", self->testDuration) .detail("ExpectedCount", (endNode - startNode) / NodesPerWatch) .detail("End", endNode) .detail("Start", startNode) .detail("Npw", NodesPerWatch);
															#line 100 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
			for(uint64_t i = startNode;i < endNode;i += NodesPerWatch) {
															#line 101 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
				watches.push_back(self->watchAndWait(cx, self, i));
															#line 133 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
			}
															#line 103 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->testDuration);
															#line 103 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 139 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 103 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 144 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
		TraceEvent("WatchAndWaitEnd").detail("Duration", self->testDuration);
															#line 105 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 169 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
		TraceEvent("WatchAndWaitEnd").detail("Duration", self->testDuration);
															#line 105 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 183 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 89 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
	Database cx;
															#line 89 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
	WatchAndWaitWorkload* self;
															#line 90 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
	std::vector<Future<Void>> watches;
															#line 272 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 89 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 277 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(302645115380654080UL, 9334412087066561536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 89 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
	_startActor(Database const& cx,WatchAndWaitWorkload* const& self) 
															#line 294 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 89 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, WatchAndWaitWorkload* const& self ) {
															#line 89 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 326 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
}

#line 107 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"

																#line 331 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
// This generated class is to be used only via watchAndWait()
															#line 108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
template <class WatchAndWaitActor>
															#line 108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
class WatchAndWaitActorState {
															#line 337 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
public:
															#line 108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
	WatchAndWaitActorState(Database const& cx,WatchAndWaitWorkload* const& self,int const& index) 
															#line 108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
															#line 108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
		 : cx(cx),
															#line 108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
		   self(self),
															#line 108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
		   index(index)
															#line 348 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
	{
		fdb_probe_actor_create("watchAndWait", reinterpret_cast<unsigned long>(this));

	}
	~WatchAndWaitActorState() 
	{
		fdb_probe_actor_destroy("watchAndWait", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 110 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
				tr = ReadYourWritesTransaction(cx);
															#line 111 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
				;
															#line 366 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatchAndWaitActorState();
		static_cast<WatchAndWaitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 124 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
			TraceEvent(SevError, "WatchAndWaitError").error(e);
															#line 125 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 398 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 112 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
		cx->maxOutstandingWatches = 1e6;
															#line 419 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
		try {
															#line 114 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
			watch = tr.watch(self->keyForIndex(index));
															#line 115 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 115 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
			if (static_cast<WatchAndWaitActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 427 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WatchAndWaitActor*>(this)->actor_wait_state = 1;
															#line 115 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatchAndWaitActor, 0, Void >*>(static_cast<WatchAndWaitActor*>(this)));
															#line 432 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 119 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
			++self->retries;
															#line 120 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 120 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
			if (static_cast<WatchAndWaitActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 458 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<WatchAndWaitActor*>(this)->actor_wait_state = 3;
															#line 120 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WatchAndWaitActor, 2, Void >*>(static_cast<WatchAndWaitActor*>(this)));
															#line 463 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
		StrictFuture<Void> __when_expr_1 = watch;
															#line 116 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
		if (static_cast<WatchAndWaitActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 480 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WatchAndWaitActor*>(this)->actor_wait_state = 2;
															#line 116 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatchAndWaitActor, 1, Void >*>(static_cast<WatchAndWaitActor*>(this)));
															#line 485 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
		StrictFuture<Void> __when_expr_1 = watch;
															#line 116 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
		if (static_cast<WatchAndWaitActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 496 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WatchAndWaitActor*>(this)->actor_wait_state = 2;
															#line 116 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatchAndWaitActor, 1, Void >*>(static_cast<WatchAndWaitActor*>(this)));
															#line 501 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatchAndWaitActor*>(this)->actor_wait_state > 0) static_cast<WatchAndWaitActor*>(this)->actor_wait_state = 0;
		static_cast<WatchAndWaitActor*>(this)->ActorCallback< WatchAndWaitActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchAndWaitActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchAndWait", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndWaitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndWait", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchAndWaitActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchAndWait", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndWaitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndWait", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatchAndWaitActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchAndWait", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndWaitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndWait", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 117 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
		++self->triggers;
															#line 585 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 117 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
		++self->triggers;
															#line 594 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WatchAndWaitActor*>(this)->actor_wait_state > 0) static_cast<WatchAndWaitActor*>(this)->actor_wait_state = 0;
		static_cast<WatchAndWaitActor*>(this)->ActorCallback< WatchAndWaitActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchAndWaitActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchAndWait", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndWaitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndWait", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WatchAndWaitActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchAndWait", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndWaitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndWait", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WatchAndWaitActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchAndWait", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndWaitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndWait", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WatchAndWaitActor*>(this)->actor_wait_state > 0) static_cast<WatchAndWaitActor*>(this)->actor_wait_state = 0;
		static_cast<WatchAndWaitActor*>(this)->ActorCallback< WatchAndWaitActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchAndWaitActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchAndWait", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndWaitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndWait", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WatchAndWaitActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchAndWait", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndWaitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndWait", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WatchAndWaitActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchAndWait", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndWaitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndWait", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
	Database cx;
															#line 108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
	WatchAndWaitWorkload* self;
															#line 108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
	int index;
															#line 110 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 114 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
	Future<Void> watch;
															#line 784 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
};
// This generated class is to be used only via watchAndWait()
															#line 108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
class WatchAndWaitActor final : public Actor<Void>, public ActorCallback< WatchAndWaitActor, 0, Void >, public ActorCallback< WatchAndWaitActor, 1, Void >, public ActorCallback< WatchAndWaitActor, 2, Void >, public FastAllocated<WatchAndWaitActor>, public WatchAndWaitActorState<WatchAndWaitActor> {
															#line 789 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
public:
	using FastAllocated<WatchAndWaitActor>::operator new;
	using FastAllocated<WatchAndWaitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1911855546331986688UL, 5754445722234205440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WatchAndWaitActor, 0, Void >;
friend struct ActorCallback< WatchAndWaitActor, 1, Void >;
friend struct ActorCallback< WatchAndWaitActor, 2, Void >;
															#line 108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
	WatchAndWaitActor(Database const& cx,WatchAndWaitWorkload* const& self,int const& index) 
															#line 808 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
		 : Actor<Void>(),
		   WatchAndWaitActorState<WatchAndWaitActor>(cx, self, index),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("watchAndWait", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(146159071549014272UL, 58117540069422080UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndWaitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("watchAndWait");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("watchAndWait", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WatchAndWaitActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WatchAndWaitActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WatchAndWaitActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
[[nodiscard]] Future<Void> watchAndWait( Database const& cx, WatchAndWaitWorkload* const& self, int const& index ) {
															#line 108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
	return Future<Void>(new WatchAndWaitActor(cx, self, index));
															#line 842 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WatchAndWait.actor.g.cpp"
}

#line 128 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/WatchAndWait.actor.cpp"
};

WorkloadFactory<WatchAndWaitWorkload> WatchAndWaitWorkloadFactory;
