#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
/*
 * StorageCorruptionBug.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/StorageCorruptionBug.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "flow/ProcessEvents.h"

#include "flow/actorcompiler.h" // has to be last include

namespace {

struct StorageCorruptionWorkload : TestWorkload {
	constexpr static auto NAME = "StorageCorruption";
	using Self = StorageCorruptionWorkload;
	std::shared_ptr<StorageCorruptionBug> bug;
	SimBugInjector bugInjector;
	double testDuration;

	StorageCorruptionWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		bugInjector.enable();
		bug = bugInjector.enable<StorageCorruptionBug>(StorageCorruptionBugID());
		bugInjector.disable();
		bug->corruptionProbability = getOption(options, "corruptionProbability"_sr, 0.001);
		testDuration = getOption(options, "testDuration"_sr, 60.0);
	}

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override { out.insert("all"); }

																#line 49 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageCorruption.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 47 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
template <class _startActor>
															#line 47 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
class _startActorState {
															#line 55 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageCorruption.actor.g.cpp"
public:
															#line 47 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
	_startActorState(Self* const& self,Database const& cx) 
															#line 47 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
															#line 47 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		 : self(self),
															#line 47 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		   cx(cx)
															#line 64 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageCorruption.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 48 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(setDDMode(cx, 0));
															#line 48 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 81 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageCorruption.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 48 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 86 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageCorruption.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 49 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		self->bugInjector.enable();
															#line 50 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(self->testDuration);
															#line 50 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 113 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageCorruption.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 50 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 118 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageCorruption.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 49 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		self->bugInjector.enable();
															#line 50 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(self->testDuration);
															#line 50 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 131 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageCorruption.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 50 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 136 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageCorruption.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 51 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		self->bug->corruptionProbability = 0.0;
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		TraceEvent("CorruptionInjections").detail("NumCorruptions", self->bug->numHits()).log();
															#line 53 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		self->bugInjector.disable();
															#line 54 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		ProcessEvents::uncancellableEvent("ConsistencyCheckFailure"_sr, [](StringRef, std::any const& data, Error const&) { if (std::any_cast<BaseTraceEvent*>(data)->getSeverity() == SevError) { TraceEvent("NegativeTestSuccess"); } });
															#line 60 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		StrictFuture<Void> __when_expr_2 = success(setDDMode(cx, 1));
															#line 60 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 230 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageCorruption.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 60 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 235 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageCorruption.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 51 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		self->bug->corruptionProbability = 0.0;
															#line 52 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		TraceEvent("CorruptionInjections").detail("NumCorruptions", self->bug->numHits()).log();
															#line 53 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		self->bugInjector.disable();
															#line 54 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		ProcessEvents::uncancellableEvent("ConsistencyCheckFailure"_sr, [](StringRef, std::any const& data, Error const&) { if (std::any_cast<BaseTraceEvent*>(data)->getSeverity() == SevError) { TraceEvent("NegativeTestSuccess"); } });
															#line 60 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		StrictFuture<Void> __when_expr_2 = success(setDDMode(cx, 1));
															#line 60 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 254 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageCorruption.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 60 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 259 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageCorruption.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 61 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 343 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageCorruption.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 61 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 355 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageCorruption.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 47 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
	Self* self;
															#line 47 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
	Database cx;
															#line 442 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageCorruption.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 47 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 447 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageCorruption.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14567928669228982016UL, 18405637127712563712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
															#line 47 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
	_startActor(Self* const& self,Database const& cx) 
															#line 466 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageCorruption.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 47 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
[[nodiscard]] static Future<Void> _start( Self* const& self, Database const& cx ) {
															#line 47 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 500 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageCorruption.actor.g.cpp"
}

#line 63 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/StorageCorruption.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (clientId != 0) {
			return Void();
		}
		return _start(this, cx->clone());
	}
	Future<bool> check(Database const& cx) override { return true; }

private:
	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<StorageCorruptionWorkload> factory;

} // namespace