#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
/*
 * GetEstimatedRangeSize.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cstring>

#include "fdbrpc/TenantName.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"

#include "flow/Error.h"
#include "flow/Trace.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct GetEstimatedRangeSizeWorkload : TestWorkload {
	static constexpr auto NAME = "GetEstimatedRangeSize";
	int nodeCount;
	double testDuration;
	Key keyPrefix;
	bool hasTenant;
	Optional<TenantName> tenantName;
	Optional<Reference<Tenant>> tenant;
	bool checkOnly;

	GetEstimatedRangeSizeWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		nodeCount = getOption(options, "nodeCount"_sr, 10000);
		keyPrefix = unprintable(getOption(options, "keyPrefix"_sr, ""_sr).toString());
		hasTenant = hasOption(options, "tenant"_sr);
		tenantName = hasTenant ? getOption(options, "tenant"_sr, "DefaultNeverUsed"_sr) : Optional<TenantName>();
		checkOnly = getOption(options, "checkOnly"_sr, false);
	}

	Future<Void> setup(Database const& cx) override {
		if (checkOnly) {
			return Void();
		}
		// The following call to bulkSetup() assumes that we have a valid tenant.
		ASSERT(hasTenant);
		tenant = makeReference<Tenant>(cx, tenantName.get());
		// Use default values for arguments between (and including) postSetupWarming and endNodeIdx params.
		return bulkSetup(cx,
		                 this,
		                 nodeCount,
		                 Promise<double>(),
		                 true,
		                 0.0,
		                 1e12,
		                 std::vector<uint64_t>(),
		                 Promise<std::vector<std::pair<uint64_t, double>>>(),
		                 0,
		                 0.1,
		                 0,
		                 0,
		                 { tenant.get() });
	}

	Future<Void> start(Database const& cx) override {
		if (clientId > 0) {
			return Void();
		}
		return checkSize(this, cx);
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

	Key keyForIndex(int n) { return key(n); }
	Key key(int n) { return doubleToTestKey((double)n / nodeCount, keyPrefix); }
	Value value(int n) { return doubleToTestKey(n, keyPrefix); }
	int fromValue(const ValueRef& v) { return testKeyToDouble(v, keyPrefix); }
	Standalone<KeyValueRef> operator()(int n) { return KeyValueRef(key(n), value((n + 1) % nodeCount)); }

																#line 96 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
// This generated class is to be used only via checkSize()
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
template <class CheckSizeActor>
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
class CheckSizeActorState {
															#line 102 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
public:
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
	CheckSizeActorState(GetEstimatedRangeSizeWorkload* const& self,Database const& cx) 
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
		 : self(self),
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
		   cx(cx)
															#line 111 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
	{
		fdb_probe_actor_create("checkSize", reinterpret_cast<unsigned long>(this));

	}
	~CheckSizeActorState() 
	{
		fdb_probe_actor_destroy("checkSize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 95 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
			StrictFuture<int64_t> __when_expr_0 = getSize(self, cx);
															#line 95 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
			if (static_cast<CheckSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 128 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckSizeActor*>(this)->actor_wait_state = 1;
															#line 95 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckSizeActor, 0, int64_t >*>(static_cast<CheckSizeActor*>(this)));
															#line 133 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckSizeActorState();
		static_cast<CheckSizeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 96 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
		ASSERT(sizeIsAsExpected(self, size));
															#line 97 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
		if (!static_cast<CheckSizeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckSizeActorState(); static_cast<CheckSizeActor*>(this)->destroy(); return 0; }
															#line 158 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
		new (&static_cast<CheckSizeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckSizeActorState();
		static_cast<CheckSizeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int64_t const& __size,int loopDepth) 
	{
															#line 95 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
		size = __size;
															#line 170 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t && __size,int loopDepth) 
	{
		size = std::move(__size);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckSizeActor*>(this)->actor_wait_state > 0) static_cast<CheckSizeActor*>(this)->actor_wait_state = 0;
		static_cast<CheckSizeActor*>(this)->ActorCallback< CheckSizeActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CheckSizeActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("checkSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckSizeActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("checkSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckSizeActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("checkSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkSize", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
	GetEstimatedRangeSizeWorkload* self;
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
	Database cx;
															#line 95 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
	int64_t size;
															#line 251 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
};
// This generated class is to be used only via checkSize()
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
class CheckSizeActor final : public Actor<Void>, public ActorCallback< CheckSizeActor, 0, int64_t >, public FastAllocated<CheckSizeActor>, public CheckSizeActorState<CheckSizeActor> {
															#line 256 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
public:
	using FastAllocated<CheckSizeActor>::operator new;
	using FastAllocated<CheckSizeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10763748184654196992UL, 8937239466989396224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckSizeActor, 0, int64_t >;
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
	CheckSizeActor(GetEstimatedRangeSizeWorkload* const& self,Database const& cx) 
															#line 273 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
		 : Actor<Void>(),
		   CheckSizeActorState<CheckSizeActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkSize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15913520412225927424UL, 6185147614440343808UL);
		ActorExecutionContextHelper __helper(static_cast<CheckSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkSize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkSize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckSizeActor, 0, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
[[nodiscard]] static Future<Void> checkSize( GetEstimatedRangeSizeWorkload* const& self, Database const& cx ) {
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
	return Future<Void>(new CheckSizeActor(self, cx));
															#line 305 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
}

#line 99 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"

	static bool sizeIsAsExpected(GetEstimatedRangeSizeWorkload* self, int64_t size) {
		int nodeSize = self->key(0).size() + self->value(0).size();
		// We use a wide range to avoid flakiness because the underlying function
		// is making an estimation.
		return size > self->nodeCount * nodeSize / 2 && size < self->nodeCount * nodeSize * 5;
	}

																#line 317 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
// This generated class is to be used only via getSize()
															#line 107 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
template <class GetSizeActor>
															#line 107 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
class GetSizeActorState {
															#line 323 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
public:
															#line 107 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
	GetSizeActorState(GetEstimatedRangeSizeWorkload* const& self,Database const& cx) 
															#line 107 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
															#line 107 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
		 : self(self),
															#line 107 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
		   cx(cx),
															#line 108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
		   tr(cx, self->tenant),
															#line 109 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
		   totalDelay(0.0)
															#line 336 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
	{
		fdb_probe_actor_create("getSize", reinterpret_cast<unsigned long>(this));

	}
	~GetSizeActorState() 
	{
		fdb_probe_actor_destroy("getSize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 110 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
			TraceEvent(SevDebug, "GetSizeStart").detail("Tenant", self->tenant);
															#line 112 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
			;
															#line 353 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetSizeActorState();
		static_cast<GetSizeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 114 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
			StrictFuture<int64_t> __when_expr_0 = tr.getEstimatedRangeSizeBytes(normalKeys);
															#line 114 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
			if (static_cast<GetSizeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 386 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetSizeActor*>(this)->actor_wait_state = 1;
															#line 114 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetSizeActor, 0, int64_t >*>(static_cast<GetSizeActor*>(this)));
															#line 391 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
			TraceEvent(SevDebug, "GetSizeError").errorUnsuppressed(e).detail("Tenant", self->tenant);
															#line 124 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 124 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
			if (static_cast<GetSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 417 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetSizeActor*>(this)->actor_wait_state = 3;
															#line 124 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetSizeActor, 2, Void >*>(static_cast<GetSizeActor*>(this)));
															#line 422 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 115 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
		TraceEvent(SevDebug, "GetSizeResult").detail("Tenant", self->tenant).detail("Size", size);
															#line 116 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
		if (!sizeIsAsExpected(self, size) && totalDelay < 300.0)
															#line 439 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
		{
															#line 117 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
			totalDelay += 5.0;
															#line 118 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(5.0);
															#line 118 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
			if (static_cast<GetSizeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 447 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetSizeActor*>(this)->actor_wait_state = 2;
															#line 118 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetSizeActor, 1, Void >*>(static_cast<GetSizeActor*>(this)));
															#line 452 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 120 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
			if (!static_cast<GetSizeActor*>(this)->SAV<int64_t>::futures) { (void)(size); this->~GetSizeActorState(); static_cast<GetSizeActor*>(this)->destroy(); return 0; }
															#line 459 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
			new (&static_cast<GetSizeActor*>(this)->SAV< int64_t >::value()) int64_t(std::move(size)); // state_var_RVO
			this->~GetSizeActorState();
			static_cast<GetSizeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t const& __size,int loopDepth) 
	{
															#line 114 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
		size = __size;
															#line 472 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t && __size,int loopDepth) 
	{
		size = std::move(__size);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetSizeActor*>(this)->actor_wait_state > 0) static_cast<GetSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSizeActor*>(this)->ActorCallback< GetSizeActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< GetSizeActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetSizeActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetSizeActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetSizeActor*>(this)->actor_wait_state > 0) static_cast<GetSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSizeActor*>(this)->ActorCallback< GetSizeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSizeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetSizeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetSizeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetSizeActor*>(this)->actor_wait_state > 0) static_cast<GetSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSizeActor*>(this)->ActorCallback< GetSizeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSizeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetSizeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetSizeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 107 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
	GetEstimatedRangeSizeWorkload* self;
															#line 107 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
	Database cx;
															#line 108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 109 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
	double totalDelay;
															#line 114 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
	int64_t size;
															#line 750 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
};
// This generated class is to be used only via getSize()
															#line 107 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
class GetSizeActor final : public Actor<int64_t>, public ActorCallback< GetSizeActor, 0, int64_t >, public ActorCallback< GetSizeActor, 1, Void >, public ActorCallback< GetSizeActor, 2, Void >, public FastAllocated<GetSizeActor>, public GetSizeActorState<GetSizeActor> {
															#line 755 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
public:
	using FastAllocated<GetSizeActor>::operator new;
	using FastAllocated<GetSizeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4277891052220371456UL, 17592847883010975744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetSizeActor, 0, int64_t >;
friend struct ActorCallback< GetSizeActor, 1, Void >;
friend struct ActorCallback< GetSizeActor, 2, Void >;
															#line 107 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
	GetSizeActor(GetEstimatedRangeSizeWorkload* const& self,Database const& cx) 
															#line 774 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetSizeActorState<GetSizeActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4272503028879048960UL, 8207068131534081792UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getSize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetSizeActor, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetSizeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetSizeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 107 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
[[nodiscard]] static Future<int64_t> getSize( GetEstimatedRangeSizeWorkload* const& self, Database const& cx ) {
															#line 107 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
	return Future<int64_t>(new GetSizeActor(self, cx));
															#line 808 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetEstimatedRangeSize.actor.g.cpp"
}

#line 128 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/workloads/GetEstimatedRangeSize.actor.cpp"
};

WorkloadFactory<GetEstimatedRangeSizeWorkload> GetEstimatedRangeSizeWorkloadFactory;
