#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
/*
 * FDBExecHelper.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_WIN32) && !defined(__APPLE__) && !defined(__INTEL_COMPILER)
#ifndef BOOST_SYSTEM_NO_LIB
#define BOOST_SYSTEM_NO_LIB
#endif
#ifndef BOOST_DATE_TIME_NO_LIB
#define BOOST_DATE_TIME_NO_LIB
#endif
#ifndef BOOST_REGEX_NO_LIB
#define BOOST_REGEX_NO_LIB
#endif
#include <boost/process.hpp>
#endif
#include <boost/algorithm/string.hpp>

#include "flow/TLSConfig.actor.h"
#include "flow/Trace.h"
#include "flow/Platform.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"
#include "flow/network.h"
#include "fdbrpc/FlowProcess.actor.h"
#include "fdbrpc/Net2FileSystem.h"
#include "fdbrpc/simulator.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "fdbrpc/WellKnownEndpoints.h"
#include "fdbclient/versions.h"
#include "fdbserver/CoroFlow.h"
#include "fdbserver/FDBExecHelper.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/RemoteIKeyValueStore.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

ExecCmdValueString::ExecCmdValueString(StringRef pCmdValueString) {
	cmdValueString = pCmdValueString;
	parseCmdValue();
}

void ExecCmdValueString::setCmdValueString(StringRef pCmdValueString) {
	// reset everything
	binaryPath = StringRef();

	// set the new cmdValueString
	cmdValueString = pCmdValueString;

	// parse it out
	parseCmdValue();
}

StringRef ExecCmdValueString::getCmdValueString() const {
	return cmdValueString.toString();
}

StringRef ExecCmdValueString::getBinaryPath() const {
	return binaryPath;
}

VectorRef<StringRef> ExecCmdValueString::getBinaryArgs() const {
	return binaryArgs;
}

void ExecCmdValueString::parseCmdValue() {
	StringRef param = this->cmdValueString;
	// get the binary path
	this->binaryPath = param.eat(" "_sr);

	// no arguments provided
	if (param == StringRef()) {
		return;
	}

	// extract the arguments
	while (param != StringRef()) {
		StringRef token = param.eat(" "_sr);
		this->binaryArgs.push_back(this->binaryArgs.arena(), token);
	}
	return;
}

void ExecCmdValueString::dbgPrint() const {
	auto te = TraceEvent("ExecCmdValueString");

	te.detail("CmdValueString", cmdValueString.toString());
	te.detail("BinaryPath", binaryPath.toString());

	int i = 0;
	for (auto elem : binaryArgs) {
		te.detail(format("Arg", ++i).c_str(), elem.toString());
	}
	return;
}

															#line 115 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
namespace {
// This generated class is to be used only via destroyChildProcess()
															#line 113 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
template <class DestroyChildProcessActor>
															#line 113 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
class DestroyChildProcessActorState {
															#line 122 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
public:
															#line 113 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	DestroyChildProcessActorState(Future<Void> const& parentSSClosed,ISimulator::ProcessInfo* const& childInfo,std::string const& message) 
															#line 113 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
															#line 113 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		 : parentSSClosed(parentSSClosed),
															#line 113 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   childInfo(childInfo),
															#line 113 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   message(message)
															#line 133 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
	{
		fdb_probe_actor_create("destroyChildProcess", reinterpret_cast<unsigned long>(this));

	}
	~DestroyChildProcessActorState() 
	{
		fdb_probe_actor_destroy("destroyChildProcess", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 115 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			StrictFuture<Void> __when_expr_0 = parentSSClosed;
															#line 115 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 150 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			static_cast<DestroyChildProcessActor*>(this)->actor_wait_state = 1;
															#line 115 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DestroyChildProcessActor, 0, Void >*>(static_cast<DestroyChildProcessActor*>(this)));
															#line 154 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<DestroyChildProcessActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		TraceEvent(SevDebug, message.c_str()).log();
															#line 118 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		g_simulator->destroyProcess(childInfo);
															#line 120 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		FlowTransport::transport().resetConnection(childInfo->address);
															#line 180 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		TraceEvent(SevDebug, message.c_str()).log();
															#line 118 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		g_simulator->destroyProcess(childInfo);
															#line 120 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		FlowTransport::transport().resetConnection(childInfo->address);
															#line 193 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DestroyChildProcessActor*>(this)->actor_wait_state > 0) static_cast<DestroyChildProcessActor*>(this)->actor_wait_state = 0;
		static_cast<DestroyChildProcessActor*>(this)->ActorCallback< DestroyChildProcessActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DestroyChildProcessActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("destroyChildProcess", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyChildProcessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyChildProcess", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DestroyChildProcessActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("destroyChildProcess", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyChildProcessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyChildProcess", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DestroyChildProcessActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("destroyChildProcess", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyChildProcessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyChildProcess", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 113 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		delete static_cast<DestroyChildProcessActor*>(this);
															#line 277 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		return 0;

		return loopDepth;
	}
															#line 113 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	Future<Void> parentSSClosed;
															#line 113 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	ISimulator::ProcessInfo* childInfo;
															#line 113 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	std::string message;
															#line 288 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
};
// This generated class is to be used only via destroyChildProcess()
															#line 113 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
class DestroyChildProcessActor final : public Actor<void>, public ActorCallback< DestroyChildProcessActor, 0, Void >, public FastAllocated<DestroyChildProcessActor>, public DestroyChildProcessActorState<DestroyChildProcessActor> {
															#line 293 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
public:
	using FastAllocated<DestroyChildProcessActor>::operator new;
	using FastAllocated<DestroyChildProcessActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14605844901321349376UL, 82446154654382336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< DestroyChildProcessActor, 0, Void >;
															#line 113 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	DestroyChildProcessActor(Future<Void> const& parentSSClosed,ISimulator::ProcessInfo* const& childInfo,std::string const& message) 
															#line 310 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		 : Actor<void>(),
		   DestroyChildProcessActorState<DestroyChildProcessActor>(parentSSClosed, childInfo, message),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("destroyChildProcess", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11099848636901712640UL, 2267395971217340928UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyChildProcessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("destroyChildProcess");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("destroyChildProcess", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 113 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
void destroyChildProcess( Future<Void> const& parentSSClosed, ISimulator::ProcessInfo* const& childInfo, std::string const& message ) {
															#line 113 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	new DestroyChildProcessActor(parentSSClosed, childInfo, message);
															#line 334 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
}

#line 122 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"

															#line 339 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
namespace {
// This generated class is to be used only via spawnSimulated()
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
template <class SpawnSimulatedActor>
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
class SpawnSimulatedActorState {
															#line 346 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
public:
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	SpawnSimulatedActorState(std::vector<std::string> const& paramList,double const& maxWaitTime,bool const& isSync,double const& maxSimDelayTime,IClosable* const& parent) 
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		 : paramList(paramList),
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   maxWaitTime(maxWaitTime),
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   isSync(isSync),
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   maxSimDelayTime(maxSimDelayTime),
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   parent(parent),
															#line 128 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   self(g_simulator->getCurrentProcess()),
															#line 129 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   child(),
															#line 131 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   role(),
															#line 132 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   addr(),
															#line 133 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   flowProcessName(),
															#line 134 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   parentProcessEndpoint(),
															#line 135 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   i(0)
															#line 375 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
	{
		fdb_probe_actor_create("spawnSimulated", reinterpret_cast<unsigned long>(this));

	}
	~SpawnSimulatedActorState() 
	{
		fdb_probe_actor_destroy("spawnSimulated", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 137 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			;
															#line 390 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SpawnSimulatedActorState();
		static_cast<SpawnSimulatedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 169 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		result = 0;
															#line 170 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		child = g_simulator->newProcess( "remote flow process", self->address.ip, 0, self->address.isTLS(), self->addresses.secondaryAddress.present() ? 2 : 1, self->locality, ProcessClass(ProcessClass::UnsetClass, ProcessClass::AutoSource), self->dataFolder.c_str(), self->coordinationFolder.c_str(), self->protocolVersion, false);
															#line 182 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		StrictFuture<Void> __when_expr_0 = g_simulator->onProcess(child);
															#line 182 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (static_cast<SpawnSimulatedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 419 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1cont1when1(__when_expr_0.get(), loopDepth); };
		static_cast<SpawnSimulatedActor*>(this)->actor_wait_state = 1;
															#line 182 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SpawnSimulatedActor, 0, Void >*>(static_cast<SpawnSimulatedActor*>(this)));
															#line 424 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 137 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (!(i < paramList.size()))
															#line 440 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 138 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (paramList.size() > i + 1)
															#line 446 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		{
															#line 140 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			if (paramList[i] == "-r")
															#line 450 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			{
															#line 141 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				role = paramList[i + 1];
															#line 454 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				loopDepth = a_body1loopBody1cont3(loopDepth);
			}
			else
			{
															#line 142 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				if (paramList[i] == "-p" || paramList[i] == "--public_address")
															#line 461 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				{
															#line 143 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
					addr = paramList[i + 1];
															#line 465 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
					loopDepth = a_body1loopBody1cont5(loopDepth);
				}
				else
				{
															#line 144 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
					if (paramList[i] == "--process-name")
															#line 472 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
					{
															#line 145 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
						flowProcessName = paramList[i + 1];
															#line 476 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
						loopDepth = a_body1loopBody1cont7(loopDepth);
					}
					else
					{
															#line 146 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
						if (paramList[i] == "--process-endpoint")
															#line 483 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
						{
															#line 147 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
							addressArray = std::vector<std::string>();
															#line 148 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
							boost::split(addressArray, paramList[i + 1], [](char c) { return c == ','; });
															#line 149 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
							if (addressArray.size() != 3)
															#line 491 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
							{
															#line 150 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
								std::cerr << "Invalid argument, expected 3 elements in --process-endpoint got " << addressArray.size() << std::endl;
															#line 152 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
								flushAndExit(FDB_EXIT_ERROR);
															#line 497 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
							}
							try {
															#line 155 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
								auto addr = NetworkAddress::parse(addressArray[0]);
															#line 156 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
								uint64_t fst = std::stoul(addressArray[1]);
															#line 157 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
								uint64_t snd = std::stoul(addressArray[2]);
															#line 158 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
								UID token(fst, snd);
															#line 159 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
								NetworkAddressList l;
															#line 160 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
								l.address = addr;
															#line 161 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
								parentProcessEndpoint = Endpoint(l, token);
															#line 514 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
								loopDepth = a_body1loopBody1cont13(loopDepth);
							}
							catch (Error& error) {
								loopDepth = a_body1loopBody1Catch1(error, loopDepth);
							} catch (...) {
								loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
							}
						}
						else
						{
							loopDepth = a_body1loopBody1cont9(loopDepth);
						}
					}
				}
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 137 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		i++;
															#line 555 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 163 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			std::cerr << "Could not parse network address " << addressArray[0] << std::endl;
															#line 164 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			flushAndExit(FDB_EXIT_ERROR);
															#line 597 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			loopDepth = a_body1loopBody1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont13(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 183 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		onShutdown = child->onShutdown();
															#line 184 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		parentShutdown = self->onShutdown();
															#line 185 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		flowProcessF = Future<Void>();
															#line 629 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		try {
															#line 188 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			TraceEvent(SevDebug, "SpawnedChildProcess") .detail("Child", child->toString()) .detail("Parent", self->toString());
															#line 191 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			std::string role = "";
															#line 192 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			std::string addr = "";
															#line 193 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			for(int i = 0;i < paramList.size();i++) {
															#line 194 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				if (paramList.size() > i + 1 && paramList[i] == "-r")
															#line 641 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				{
															#line 195 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
					role = paramList[i + 1];
															#line 645 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				}
			}
															#line 198 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			if (role == "flowprocess" && !parentShutdown.isReady())
															#line 650 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			{
															#line 199 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				self->childs.push_back(child);
															#line 200 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				parentSSClosed = parent->onClosed();
															#line 201 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				FlowTransport::createInstance(false, 1, WLTOKEN_RESERVED_COUNT);
															#line 202 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				FlowTransport::transport().bind(child->address, child->address);
															#line 203 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				Sim2FileSystem::newFileSystem();
															#line 204 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				ProcessFactory<KeyValueStoreProcess>(flowProcessName.c_str());
															#line 205 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				flowProcessF = runFlowProcess(flowProcessName, parentProcessEndpoint);
															#line 208 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				StrictFuture<Void> __when_expr_1 = flowProcessF;
															#line 207 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				if (static_cast<SpawnSimulatedActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 670 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont2Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 214 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				StrictFuture<Void> __when_expr_2 = success(onShutdown);
															#line 674 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when2(__when_expr_2.get(), loopDepth); };
															#line 220 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				StrictFuture<Void> __when_expr_3 = success(parentShutdown);
															#line 678 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when3(__when_expr_3.get(), loopDepth); };
				static_cast<SpawnSimulatedActor*>(this)->actor_wait_state = 2;
															#line 208 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SpawnSimulatedActor, 1, Void >*>(static_cast<SpawnSimulatedActor*>(this)));
															#line 214 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SpawnSimulatedActor, 2, Void >*>(static_cast<SpawnSimulatedActor*>(this)));
															#line 220 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SpawnSimulatedActor, 3, Void >*>(static_cast<SpawnSimulatedActor*>(this)));
															#line 687 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 226 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				ASSERT(false);
															#line 694 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				loopDepth = a_body1cont4(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 183 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		onShutdown = child->onShutdown();
															#line 184 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		parentShutdown = self->onShutdown();
															#line 185 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		flowProcessF = Future<Void>();
															#line 714 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		try {
															#line 188 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			TraceEvent(SevDebug, "SpawnedChildProcess") .detail("Child", child->toString()) .detail("Parent", self->toString());
															#line 191 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			std::string role = "";
															#line 192 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			std::string addr = "";
															#line 193 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			for(int i = 0;i < paramList.size();i++) {
															#line 194 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				if (paramList.size() > i + 1 && paramList[i] == "-r")
															#line 726 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				{
															#line 195 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
					role = paramList[i + 1];
															#line 730 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				}
			}
															#line 198 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			if (role == "flowprocess" && !parentShutdown.isReady())
															#line 735 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			{
															#line 199 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				self->childs.push_back(child);
															#line 200 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				parentSSClosed = parent->onClosed();
															#line 201 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				FlowTransport::createInstance(false, 1, WLTOKEN_RESERVED_COUNT);
															#line 202 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				FlowTransport::transport().bind(child->address, child->address);
															#line 203 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				Sim2FileSystem::newFileSystem();
															#line 204 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				ProcessFactory<KeyValueStoreProcess>(flowProcessName.c_str());
															#line 205 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				flowProcessF = runFlowProcess(flowProcessName, parentProcessEndpoint);
															#line 208 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				StrictFuture<Void> __when_expr_1 = flowProcessF;
															#line 207 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				if (static_cast<SpawnSimulatedActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 755 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont2Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 214 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				StrictFuture<Void> __when_expr_2 = success(onShutdown);
															#line 759 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when2(__when_expr_2.get(), loopDepth); };
															#line 220 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				StrictFuture<Void> __when_expr_3 = success(parentShutdown);
															#line 763 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when3(__when_expr_3.get(), loopDepth); };
				static_cast<SpawnSimulatedActor*>(this)->actor_wait_state = 2;
															#line 208 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SpawnSimulatedActor, 1, Void >*>(static_cast<SpawnSimulatedActor*>(this)));
															#line 214 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SpawnSimulatedActor, 2, Void >*>(static_cast<SpawnSimulatedActor*>(this)));
															#line 220 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SpawnSimulatedActor, 3, Void >*>(static_cast<SpawnSimulatedActor*>(this)));
															#line 772 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 226 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				ASSERT(false);
															#line 779 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				loopDepth = a_body1cont4(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SpawnSimulatedActor*>(this)->actor_wait_state > 0) static_cast<SpawnSimulatedActor*>(this)->actor_wait_state = 0;
		static_cast<SpawnSimulatedActor*>(this)->ActorCallback< SpawnSimulatedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SpawnSimulatedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("spawnSimulated", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnSimulatedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnSimulated", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SpawnSimulatedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("spawnSimulated", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnSimulatedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnSimulated", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SpawnSimulatedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("spawnSimulated", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnSimulatedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnSimulated", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 233 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (!static_cast<SpawnSimulatedActor*>(this)->SAV<int>::futures) { (void)(result); this->~SpawnSimulatedActorState(); static_cast<SpawnSimulatedActor*>(this)->destroy(); return 0; }
															#line 870 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		new (&static_cast<SpawnSimulatedActor*>(this)->SAV< int >::value()) int(std::move(result)); // state_var_RVO
		this->~SpawnSimulatedActorState();
		static_cast<SpawnSimulatedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 229 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			TraceEvent(SevError, "RemoteIKVSDied").errorUnsuppressed(e);
															#line 230 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			result = -1;
															#line 885 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
															#line 209 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		TraceEvent(SevDebug, "ChildProcessKilled").log();
															#line 210 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		StrictFuture<Void> __when_expr_4 = g_simulator->onProcess(self);
															#line 210 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (static_cast<SpawnSimulatedActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 916 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2when1when1(__when_expr_4.get(), loopDepth); };
		static_cast<SpawnSimulatedActor*>(this)->actor_wait_state = 3;
															#line 210 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< SpawnSimulatedActor, 4, Void >*>(static_cast<SpawnSimulatedActor*>(this)));
															#line 921 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
															#line 209 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		TraceEvent(SevDebug, "ChildProcessKilled").log();
															#line 210 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		StrictFuture<Void> __when_expr_4 = g_simulator->onProcess(self);
															#line 210 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (static_cast<SpawnSimulatedActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 934 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2when1when1(__when_expr_4.get(), loopDepth); };
		static_cast<SpawnSimulatedActor*>(this)->actor_wait_state = 3;
															#line 210 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< SpawnSimulatedActor, 4, Void >*>(static_cast<SpawnSimulatedActor*>(this)));
															#line 939 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when2(Void const& _,int loopDepth) 
	{
															#line 215 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		ASSERT(false);
															#line 948 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when2(Void && _,int loopDepth) 
	{
															#line 215 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		ASSERT(false);
															#line 957 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when3(Void const& _,int loopDepth) 
	{
															#line 221 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		ASSERT(false);
															#line 966 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when3(Void && _,int loopDepth) 
	{
															#line 221 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		ASSERT(false);
															#line 975 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SpawnSimulatedActor*>(this)->actor_wait_state > 0) static_cast<SpawnSimulatedActor*>(this)->actor_wait_state = 0;
		static_cast<SpawnSimulatedActor*>(this)->ActorCallback< SpawnSimulatedActor, 1, Void >::remove();
		static_cast<SpawnSimulatedActor*>(this)->ActorCallback< SpawnSimulatedActor, 2, Void >::remove();
		static_cast<SpawnSimulatedActor*>(this)->ActorCallback< SpawnSimulatedActor, 3, Void >::remove();

	}
	int a_body1cont2when1cont1(Void const& _,int loopDepth) 
	{
															#line 211 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		TraceEvent(SevDebug, "BackOnParentProcess").detail("Result", std::to_string(result));
															#line 212 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		destroyChildProcess(parentSSClosed, child, "StorageServerReceivedClosedMessage");
															#line 994 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1cont1(Void && _,int loopDepth) 
	{
															#line 211 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		TraceEvent(SevDebug, "BackOnParentProcess").detail("Result", std::to_string(result));
															#line 212 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		destroyChildProcess(parentSSClosed, child, "StorageServerReceivedClosedMessage");
															#line 1005 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2when1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2when1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SpawnSimulatedActor*>(this)->actor_wait_state > 0) static_cast<SpawnSimulatedActor*>(this)->actor_wait_state = 0;
		static_cast<SpawnSimulatedActor*>(this)->ActorCallback< SpawnSimulatedActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SpawnSimulatedActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("spawnSimulated", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnSimulatedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnSimulated", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< SpawnSimulatedActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("spawnSimulated", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnSimulatedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnSimulated", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< SpawnSimulatedActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("spawnSimulated", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnSimulatedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnSimulated", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< SpawnSimulatedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("spawnSimulated", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnSimulatedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnSimulated", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SpawnSimulatedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("spawnSimulated", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnSimulatedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnSimulated", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SpawnSimulatedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("spawnSimulated", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnSimulatedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnSimulated", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SpawnSimulatedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("spawnSimulated", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnSimulatedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnSimulated", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SpawnSimulatedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("spawnSimulated", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnSimulatedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnSimulated", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SpawnSimulatedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("spawnSimulated", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnSimulatedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnSimulated", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SpawnSimulatedActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("spawnSimulated", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnSimulatedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when3(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnSimulated", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SpawnSimulatedActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("spawnSimulated", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnSimulatedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnSimulated", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SpawnSimulatedActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("spawnSimulated", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnSimulatedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnSimulated", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	std::vector<std::string> paramList;
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	double maxWaitTime;
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	bool isSync;
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	double maxSimDelayTime;
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	IClosable* parent;
															#line 128 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	ISimulator::ProcessInfo* self;
															#line 129 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	ISimulator::ProcessInfo* child;
															#line 131 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	std::string role;
															#line 132 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	std::string addr;
															#line 133 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	std::string flowProcessName;
															#line 134 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	Endpoint parentProcessEndpoint;
															#line 135 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	int i;
															#line 147 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	std::vector<std::string> addressArray;
															#line 169 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	int result;
															#line 183 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	Future<ISimulator::KillType> onShutdown;
															#line 184 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	Future<ISimulator::KillType> parentShutdown;
															#line 185 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	Future<Void> flowProcessF;
															#line 200 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	Future<Void> parentSSClosed;
															#line 1305 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
};
// This generated class is to be used only via spawnSimulated()
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
class SpawnSimulatedActor final : public Actor<int>, public ActorCallback< SpawnSimulatedActor, 0, Void >, public ActorCallback< SpawnSimulatedActor, 1, Void >, public ActorCallback< SpawnSimulatedActor, 4, Void >, public ActorCallback< SpawnSimulatedActor, 2, Void >, public ActorCallback< SpawnSimulatedActor, 3, Void >, public FastAllocated<SpawnSimulatedActor>, public SpawnSimulatedActorState<SpawnSimulatedActor> {
															#line 1310 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
public:
	using FastAllocated<SpawnSimulatedActor>::operator new;
	using FastAllocated<SpawnSimulatedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10799105271177159168UL, 8564254784165137152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SpawnSimulatedActor, 0, Void >;
friend struct ActorCallback< SpawnSimulatedActor, 1, Void >;
friend struct ActorCallback< SpawnSimulatedActor, 4, Void >;
friend struct ActorCallback< SpawnSimulatedActor, 2, Void >;
friend struct ActorCallback< SpawnSimulatedActor, 3, Void >;
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	SpawnSimulatedActor(std::vector<std::string> const& paramList,double const& maxWaitTime,bool const& isSync,double const& maxSimDelayTime,IClosable* const& parent) 
															#line 1331 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		 : Actor<int>(),
		   SpawnSimulatedActorState<SpawnSimulatedActor>(paramList, maxWaitTime, isSync, maxSimDelayTime, parent),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("spawnSimulated", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6640743676545880320UL, 8627573994539351808UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnSimulatedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("spawnSimulated");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("spawnSimulated", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SpawnSimulatedActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SpawnSimulatedActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SpawnSimulatedActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
[[nodiscard]] Future<int> spawnSimulated( std::vector<std::string> const& paramList, double const& maxWaitTime, bool const& isSync, double const& maxSimDelayTime, IClosable* const& parent ) {
															#line 123 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	return Future<int>(new SpawnSimulatedActor(paramList, maxWaitTime, isSync, maxSimDelayTime, parent));
															#line 1366 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
}

#line 235 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"

#if defined(_WIN32) || defined(__APPLE__) || defined(__INTEL_COMPILER)
															#line 1372 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
namespace {
// This generated class is to be used only via spawnProcess()
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
template <class SpawnProcessActor>
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
class SpawnProcessActorState {
															#line 1379 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
public:
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	SpawnProcessActorState(std::string const& binPath,std::vector<std::string> const& paramList,double const& maxWaitTime,bool const& isSync,double const& maxSimDelayTime,IClosable* const& parent) 
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		 : binPath(binPath),
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   paramList(paramList),
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   maxWaitTime(maxWaitTime),
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   isSync(isSync),
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   maxSimDelayTime(maxSimDelayTime),
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   parent(parent)
															#line 1396 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
	{
		fdb_probe_actor_create("spawnProcess", reinterpret_cast<unsigned long>(this));

	}
	~SpawnProcessActorState() 
	{
		fdb_probe_actor_destroy("spawnProcess", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 243 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			if (g_network->isSimulated() && getExecPath() == binPath)
															#line 1411 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			{
															#line 244 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				StrictFuture<int> __when_expr_0 = spawnSimulated(paramList, maxWaitTime, isSync, maxSimDelayTime, parent);
															#line 244 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				if (static_cast<SpawnProcessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1417 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<SpawnProcessActor*>(this)->actor_wait_state = 1;
															#line 244 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SpawnProcessActor, 0, int >*>(static_cast<SpawnProcessActor*>(this)));
															#line 1422 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SpawnProcessActorState();
		static_cast<SpawnProcessActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 247 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.0);
															#line 247 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (static_cast<SpawnProcessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1452 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SpawnProcessActor*>(this)->actor_wait_state = 2;
															#line 247 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SpawnProcessActor, 1, Void >*>(static_cast<SpawnProcessActor*>(this)));
															#line 1457 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int const& res,int loopDepth) 
	{
															#line 245 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (!static_cast<SpawnProcessActor*>(this)->SAV<int>::futures) { (void)(res); this->~SpawnProcessActorState(); static_cast<SpawnProcessActor*>(this)->destroy(); return 0; }
															#line 1466 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		new (&static_cast<SpawnProcessActor*>(this)->SAV< int >::value()) int(res);
		this->~SpawnProcessActorState();
		static_cast<SpawnProcessActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int && res,int loopDepth) 
	{
															#line 245 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (!static_cast<SpawnProcessActor*>(this)->SAV<int>::futures) { (void)(res); this->~SpawnProcessActorState(); static_cast<SpawnProcessActor*>(this)->destroy(); return 0; }
															#line 1478 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		new (&static_cast<SpawnProcessActor*>(this)->SAV< int >::value()) int(res);
		this->~SpawnProcessActorState();
		static_cast<SpawnProcessActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int const& res,int loopDepth) 
	{
		loopDepth = a_body1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && res,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SpawnProcessActor*>(this)->actor_wait_state > 0) static_cast<SpawnProcessActor*>(this)->actor_wait_state = 0;
		static_cast<SpawnProcessActor*>(this)->ActorCallback< SpawnProcessActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< SpawnProcessActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("spawnProcess", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnProcessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnProcess", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SpawnProcessActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("spawnProcess", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnProcessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnProcess", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SpawnProcessActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("spawnProcess", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnProcessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnProcess", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 248 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (!static_cast<SpawnProcessActor*>(this)->SAV<int>::futures) { (void)(0); this->~SpawnProcessActorState(); static_cast<SpawnProcessActor*>(this)->destroy(); return 0; }
															#line 1565 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		new (&static_cast<SpawnProcessActor*>(this)->SAV< int >::value()) int(0);
		this->~SpawnProcessActorState();
		static_cast<SpawnProcessActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 248 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (!static_cast<SpawnProcessActor*>(this)->SAV<int>::futures) { (void)(0); this->~SpawnProcessActorState(); static_cast<SpawnProcessActor*>(this)->destroy(); return 0; }
															#line 1577 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		new (&static_cast<SpawnProcessActor*>(this)->SAV< int >::value()) int(0);
		this->~SpawnProcessActorState();
		static_cast<SpawnProcessActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SpawnProcessActor*>(this)->actor_wait_state > 0) static_cast<SpawnProcessActor*>(this)->actor_wait_state = 0;
		static_cast<SpawnProcessActor*>(this)->ActorCallback< SpawnProcessActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SpawnProcessActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("spawnProcess", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnProcessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnProcess", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SpawnProcessActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("spawnProcess", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnProcessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnProcess", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SpawnProcessActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("spawnProcess", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnProcessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnProcess", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	std::string binPath;
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	std::vector<std::string> paramList;
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	double maxWaitTime;
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	bool isSync;
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	double maxSimDelayTime;
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	IClosable* parent;
															#line 1672 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
};
// This generated class is to be used only via spawnProcess()
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
class SpawnProcessActor final : public Actor<int>, public ActorCallback< SpawnProcessActor, 0, int >, public ActorCallback< SpawnProcessActor, 1, Void >, public FastAllocated<SpawnProcessActor>, public SpawnProcessActorState<SpawnProcessActor> {
															#line 1677 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
public:
	using FastAllocated<SpawnProcessActor>::operator new;
	using FastAllocated<SpawnProcessActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9408052343414200576UL, 2299829792175860224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SpawnProcessActor, 0, int >;
friend struct ActorCallback< SpawnProcessActor, 1, Void >;
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	SpawnProcessActor(std::string const& binPath,std::vector<std::string> const& paramList,double const& maxWaitTime,bool const& isSync,double const& maxSimDelayTime,IClosable* const& parent) 
															#line 1695 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		 : Actor<int>(),
		   SpawnProcessActorState<SpawnProcessActor>(binPath, paramList, maxWaitTime, isSync, maxSimDelayTime, parent),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("spawnProcess", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7218473969155683840UL, 10493693113340444416UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnProcessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("spawnProcess");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("spawnProcess", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SpawnProcessActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SpawnProcessActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
[[nodiscard]] Future<int> spawnProcess( std::string const& binPath, std::vector<std::string> const& paramList, double const& maxWaitTime, bool const& isSync, double const& maxSimDelayTime, IClosable* const& parent ) {
															#line 237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	return Future<int>(new SpawnProcessActor(binPath, paramList, maxWaitTime, isSync, maxSimDelayTime, parent));
															#line 1729 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
}

#line 250 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
#else

static auto fork_child(const std::string& path, std::vector<char*>& paramList) {
	int pipefd[2];
	if (pipe(pipefd) != 0) {
		return std::make_pair(-1, Optional<int>{});
	}
	auto readFD = pipefd[0];
	auto writeFD = pipefd[1];
	pid_t pid = fork();
	if (pid == -1) {
		close(readFD);
		close(writeFD);
		return std::make_pair(-1, Optional<int>{});
	}
	if (pid == 0) {
		close(readFD);
		dup2(writeFD, 1); // stdout
		dup2(writeFD, 2); // stderr
		close(writeFD);
		execv(&path[0], &paramList[0]);
		_exit(EXIT_FAILURE);
	}
	close(writeFD);
	return std::make_pair(pid, Optional<int>{ readFD });
}

static void setupTraceWithOutput(TraceEvent& event, size_t bytesRead, char* outputBuffer) {
	// get some errors printed for spawned process
	std::cout << "Output bytesRead: " << bytesRead << std::endl;
	std::cout << "output buffer: " << std::string_view(outputBuffer, bytesRead) << std::endl;
	if (bytesRead == 0)
		return;
	ASSERT(bytesRead <= SERVER_KNOBS->MAX_FORKED_PROCESS_OUTPUT);
	auto extraBytesNeeded = std::max<int>(bytesRead - event.getMaxFieldLength(), 0);
	event.setMaxFieldLength(event.getMaxFieldLength() + extraBytesNeeded);
	event.setMaxEventLength(event.getMaxEventLength() + extraBytesNeeded);
	outputBuffer[bytesRead - 1] = '\0';
	event.detail("Output", std::string(outputBuffer));
}

															#line 1774 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
namespace {
// This generated class is to be used only via spawnProcess()
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
template <class SpawnProcessActor1>
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
class SpawnProcessActor1State {
															#line 1781 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
public:
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	SpawnProcessActor1State(std::string const& path,std::vector<std::string> const& args,double const& maxWaitTime,bool const& isSync,double const& maxSimDelayTime,IClosable* const& parent) 
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		 : path(path),
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   args(args),
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   maxWaitTime(maxWaitTime),
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   isSync(isSync),
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   maxSimDelayTime(maxSimDelayTime),
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   parent(parent)
															#line 1798 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
	{
		fdb_probe_actor_create("spawnProcess", reinterpret_cast<unsigned long>(this));

	}
	~SpawnProcessActor1State() 
	{
		fdb_probe_actor_destroy("spawnProcess", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 297 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			if (g_network->isSimulated() && getExecPath() == path)
															#line 1813 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			{
															#line 298 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				StrictFuture<int> __when_expr_0 = spawnSimulated(args, maxWaitTime, isSync, maxSimDelayTime, parent);
															#line 298 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				if (static_cast<SpawnProcessActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1819 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<SpawnProcessActor1*>(this)->actor_wait_state = 1;
															#line 298 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SpawnProcessActor1, 0, int >*>(static_cast<SpawnProcessActor1*>(this)));
															#line 1824 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SpawnProcessActor1State();
		static_cast<SpawnProcessActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 303 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (!isSync && g_network->isSimulated())
															#line 1852 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		{
															#line 304 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			double snapDelay = std::max(maxSimDelayTime - 1, 0.0);
															#line 306 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			snapDelay += deterministicRandom()->random01();
															#line 307 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			TraceEvent("SnapDelaySpawnProcess").detail("SnapDelay", snapDelay);
															#line 308 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(snapDelay);
															#line 308 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			if (static_cast<SpawnProcessActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1864 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SpawnProcessActor1*>(this)->actor_wait_state = 2;
															#line 308 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SpawnProcessActor1, 1, Void >*>(static_cast<SpawnProcessActor1*>(this)));
															#line 1869 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int const& res,int loopDepth) 
	{
															#line 299 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (!static_cast<SpawnProcessActor1*>(this)->SAV<int>::futures) { (void)(res); this->~SpawnProcessActor1State(); static_cast<SpawnProcessActor1*>(this)->destroy(); return 0; }
															#line 1883 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		new (&static_cast<SpawnProcessActor1*>(this)->SAV< int >::value()) int(res);
		this->~SpawnProcessActor1State();
		static_cast<SpawnProcessActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int && res,int loopDepth) 
	{
															#line 299 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (!static_cast<SpawnProcessActor1*>(this)->SAV<int>::futures) { (void)(res); this->~SpawnProcessActor1State(); static_cast<SpawnProcessActor1*>(this)->destroy(); return 0; }
															#line 1895 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		new (&static_cast<SpawnProcessActor1*>(this)->SAV< int >::value()) int(res);
		this->~SpawnProcessActor1State();
		static_cast<SpawnProcessActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int const& res,int loopDepth) 
	{
		loopDepth = a_body1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && res,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SpawnProcessActor1*>(this)->actor_wait_state > 0) static_cast<SpawnProcessActor1*>(this)->actor_wait_state = 0;
		static_cast<SpawnProcessActor1*>(this)->ActorCallback< SpawnProcessActor1, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< SpawnProcessActor1, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("spawnProcess", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnProcessActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnProcess", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SpawnProcessActor1, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("spawnProcess", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnProcessActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnProcess", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SpawnProcessActor1, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("spawnProcess", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnProcessActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnProcess", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 311 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		std::vector<char*> paramList;
															#line 312 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		paramList.reserve(args.size());
															#line 313 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		for(int i = 0;i < args.size();i++) {
															#line 314 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			paramList.push_back(&args[i][0]);
															#line 1988 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		}
															#line 316 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		paramList.push_back(nullptr);
															#line 318 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		allArgs = std::string();
															#line 319 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		for(int i = 0;i < args.size();i++) {
															#line 320 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			if (i > 0)
															#line 1998 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			{
															#line 321 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				allArgs += " ";
															#line 2002 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			}
															#line 322 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			allArgs += args[i];
															#line 2006 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		}
															#line 325 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		pidAndReadFD = fork_child(path, paramList);
															#line 326 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		pid = pidAndReadFD.first;
															#line 327 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		readFD = pidAndReadFD.second;
															#line 328 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (pid == -1)
															#line 2016 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		{
															#line 329 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			TraceEvent(SevWarnAlways, "SpawnProcessFailure") .detail("Reason", "Command failed to spawn") .detail("Cmd", path) .detail("Args", allArgs);
															#line 333 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			if (!static_cast<SpawnProcessActor1*>(this)->SAV<int>::futures) { (void)(-1); this->~SpawnProcessActor1State(); static_cast<SpawnProcessActor1*>(this)->destroy(); return 0; }
															#line 2022 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			new (&static_cast<SpawnProcessActor1*>(this)->SAV< int >::value()) int(-1);
			this->~SpawnProcessActor1State();
			static_cast<SpawnProcessActor1*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 334 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			if (pid > 0)
															#line 2032 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			{
															#line 335 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				status = -1;
															#line 336 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				runTime = 0;
															#line 337 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				arena = Arena();
															#line 338 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				outputBuffer = new (arena) char[SERVER_KNOBS->MAX_FORKED_PROCESS_OUTPUT];
															#line 339 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				bytesRead = 0;
															#line 340 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				int flags = fcntl(readFD.get(), F_GETFL, 0);
															#line 341 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				fcntl(readFD.get(), F_SETFL, flags | O_NONBLOCK);
															#line 342 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				;
															#line 2050 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				loopDepth = a_body1cont4loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1cont11(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SpawnProcessActor1*>(this)->actor_wait_state > 0) static_cast<SpawnProcessActor1*>(this)->actor_wait_state = 0;
		static_cast<SpawnProcessActor1*>(this)->ActorCallback< SpawnProcessActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SpawnProcessActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("spawnProcess", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnProcessActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnProcess", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SpawnProcessActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("spawnProcess", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnProcessActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnProcess", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SpawnProcessActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("spawnProcess", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnProcessActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnProcess", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 402 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (!static_cast<SpawnProcessActor1*>(this)->SAV<int>::futures) { (void)(-1); this->~SpawnProcessActor1State(); static_cast<SpawnProcessActor1*>(this)->destroy(); return 0; }
															#line 2152 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		new (&static_cast<SpawnProcessActor1*>(this)->SAV< int >::value()) int(-1);
		this->~SpawnProcessActor1State();
		static_cast<SpawnProcessActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 343 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (maxWaitTime >= 0 && runTime > maxWaitTime)
															#line 2177 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		{
															#line 346 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			TraceEvent(SevWarnAlways, "SpawnProcessFailure") .detail("Reason", "Command failed, timeout") .detail("Cmd", path) .detail("Args", allArgs);
															#line 350 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			if (!static_cast<SpawnProcessActor1*>(this)->SAV<int>::futures) { (void)(-1); this->~SpawnProcessActor1State(); static_cast<SpawnProcessActor1*>(this)->destroy(); return 0; }
															#line 2183 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			new (&static_cast<SpawnProcessActor1*>(this)->SAV< int >::value()) int(-1);
			this->~SpawnProcessActor1State();
			static_cast<SpawnProcessActor1*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 352 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		int err = waitpid(pid, &status, WNOHANG);
															#line 353 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		for(;;) {
															#line 354 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			int bytes = read(readFD.get(), &outputBuffer[bytesRead], SERVER_KNOBS->MAX_FORKED_PROCESS_OUTPUT - bytesRead);
															#line 356 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			if (bytes < 0 && errno == EAGAIN)
															#line 2197 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			{
				break;
			}
			else
			{
															#line 358 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				if (bytes < 0)
															#line 2205 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				{
															#line 359 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
					return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 2209 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				}
				else
				{
															#line 360 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
					if (bytes == 0)
															#line 2215 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
					{
						break;
					}
				}
			}
															#line 362 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			bytesRead += bytes;
															#line 2223 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		}
															#line 364 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (err < 0)
															#line 2227 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		{
															#line 365 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			TraceEvent event(SevWarnAlways, "SpawnProcessFailure");
															#line 366 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			setupTraceWithOutput(event, bytesRead, outputBuffer);
															#line 367 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			event.detail("Reason", "Command failed") .detail("Cmd", path) .detail("Args", allArgs) .detail("Errno", WIFEXITED(status) ? WEXITSTATUS(status) : -1);
															#line 371 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			if (!static_cast<SpawnProcessActor1*>(this)->SAV<int>::futures) { (void)(-1); this->~SpawnProcessActor1State(); static_cast<SpawnProcessActor1*>(this)->destroy(); return 0; }
															#line 2237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			new (&static_cast<SpawnProcessActor1*>(this)->SAV< int >::value()) int(-1);
			this->~SpawnProcessActor1State();
			static_cast<SpawnProcessActor1*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 372 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			if (err == 0)
															#line 2247 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			{
															#line 374 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				if (isSync || g_network->isSimulated())
															#line 2251 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				{
															#line 376 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
					threadSleep(0.1);
															#line 2255 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
					loopDepth = a_body1cont4loopBody1cont11(loopDepth);
				}
				else
				{
															#line 379 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
					StrictFuture<Void> __when_expr_2 = delay(0.1);
															#line 379 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
					if (static_cast<SpawnProcessActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2264 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_2.get(), loopDepth); };
					static_cast<SpawnProcessActor1*>(this)->actor_wait_state = 3;
															#line 379 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SpawnProcessActor1, 2, Void >*>(static_cast<SpawnProcessActor1*>(this)));
															#line 2269 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
					loopDepth = 0;
				}
			}
			else
			{
															#line 384 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				if (!(WIFEXITED(status) && WEXITSTATUS(status) == 0))
															#line 2277 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				{
															#line 385 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
					TraceEvent event(SevWarnAlways, "SpawnProcessFailure");
															#line 386 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
					setupTraceWithOutput(event, bytesRead, outputBuffer);
															#line 387 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
					event.detail("Reason", "Command failed") .detail("Cmd", path) .detail("Args", allArgs) .detail("Errno", WIFEXITED(status) ? WEXITSTATUS(status) : -1);
															#line 391 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
					if (!static_cast<SpawnProcessActor1*>(this)->SAV<int>::futures) { (void)(WIFEXITED(status) ? WEXITSTATUS(status) : -1); this->~SpawnProcessActor1State(); static_cast<SpawnProcessActor1*>(this)->destroy(); return 0; }
															#line 2287 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
					new (&static_cast<SpawnProcessActor1*>(this)->SAV< int >::value()) int(WIFEXITED(status) ? WEXITSTATUS(status) : -1);
					this->~SpawnProcessActor1State();
					static_cast<SpawnProcessActor1*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 393 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				TraceEvent event("SpawnProcessCommandStatus");
															#line 394 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				setupTraceWithOutput(event, bytesRead, outputBuffer);
															#line 395 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				event.detail("Cmd", path) .detail("Args", allArgs) .detail("Errno", WIFEXITED(status) ? WEXITSTATUS(status) : 0);
															#line 398 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				if (!static_cast<SpawnProcessActor1*>(this)->SAV<int>::futures) { (void)(0); this->~SpawnProcessActor1State(); static_cast<SpawnProcessActor1*>(this)->destroy(); return 0; }
															#line 2301 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				new (&static_cast<SpawnProcessActor1*>(this)->SAV< int >::value()) int(0);
				this->~SpawnProcessActor1State();
				static_cast<SpawnProcessActor1*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont10(int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont11(int loopDepth) 
	{
															#line 381 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		runTime += 0.1;
															#line 2327 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SpawnProcessActor1*>(this)->actor_wait_state > 0) static_cast<SpawnProcessActor1*>(this)->actor_wait_state = 0;
		static_cast<SpawnProcessActor1*>(this)->ActorCallback< SpawnProcessActor1, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SpawnProcessActor1, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("spawnProcess", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnProcessActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnProcess", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SpawnProcessActor1, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("spawnProcess", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnProcessActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnProcess", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SpawnProcessActor1, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("spawnProcess", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnProcessActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("spawnProcess", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	std::string path;
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	std::vector<std::string> args;
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	double maxWaitTime;
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	bool isSync;
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	double maxSimDelayTime;
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	IClosable* parent;
															#line 318 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	std::string allArgs;
															#line 325 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	std::pair<pid_t, Optional<int>> pidAndReadFD;
															#line 326 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	pid_t pid;
															#line 327 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	Optional<int> readFD;
															#line 335 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	int status;
															#line 336 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	double runTime;
															#line 337 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	Arena arena;
															#line 338 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	char* outputBuffer;
															#line 339 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	size_t bytesRead;
															#line 2449 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
};
// This generated class is to be used only via spawnProcess()
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
class SpawnProcessActor1 final : public Actor<int>, public ActorCallback< SpawnProcessActor1, 0, int >, public ActorCallback< SpawnProcessActor1, 1, Void >, public ActorCallback< SpawnProcessActor1, 2, Void >, public FastAllocated<SpawnProcessActor1>, public SpawnProcessActor1State<SpawnProcessActor1> {
															#line 2454 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
public:
	using FastAllocated<SpawnProcessActor1>::operator new;
	using FastAllocated<SpawnProcessActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9408052343414200576UL, 2299829792175860224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SpawnProcessActor1, 0, int >;
friend struct ActorCallback< SpawnProcessActor1, 1, Void >;
friend struct ActorCallback< SpawnProcessActor1, 2, Void >;
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	SpawnProcessActor1(std::string const& path,std::vector<std::string> const& args,double const& maxWaitTime,bool const& isSync,double const& maxSimDelayTime,IClosable* const& parent) 
															#line 2473 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		 : Actor<int>(),
		   SpawnProcessActor1State<SpawnProcessActor1>(path, args, maxWaitTime, isSync, maxSimDelayTime, parent),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("spawnProcess", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8184754589868997888UL, 10907563490126028032UL);
		ActorExecutionContextHelper __helper(static_cast<SpawnProcessActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("spawnProcess");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("spawnProcess", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SpawnProcessActor1, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SpawnProcessActor1, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SpawnProcessActor1, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
[[nodiscard]] Future<int> spawnProcess( std::string const& path, std::vector<std::string> const& args, double const& maxWaitTime, bool const& isSync, double const& maxSimDelayTime, IClosable* const& parent ) {
															#line 291 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	return Future<int>(new SpawnProcessActor1(path, args, maxWaitTime, isSync, maxSimDelayTime, parent));
															#line 2508 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
}

#line 404 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
#endif

															#line 2514 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
namespace {
// This generated class is to be used only via execHelper()
															#line 406 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
template <class ExecHelperActor>
															#line 406 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
class ExecHelperActorState {
															#line 2521 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
public:
															#line 406 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	ExecHelperActorState(ExecCmdValueString* const& execArg,UID const& snapUID,std::string const& folder,std::string const& role) 
															#line 406 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
															#line 406 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		 : execArg(execArg),
															#line 406 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   snapUID(snapUID),
															#line 406 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   folder(folder),
															#line 406 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   role(role),
															#line 407 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   uidStr(snapUID.toString()),
															#line 408 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   err(0),
															#line 409 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   cmdErr(),
															#line 410 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		   maxWaitTime(SERVER_KNOBS->SNAP_CREATE_MAX_TIMEOUT)
															#line 2542 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
	{
		fdb_probe_actor_create("execHelper", reinterpret_cast<unsigned long>(this));

	}
	~ExecHelperActorState() 
	{
		fdb_probe_actor_destroy("execHelper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 411 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			if (!g_network->isSimulated())
															#line 2557 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			{
															#line 413 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				auto snapBin = execArg->getBinaryPath();
															#line 414 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				std::vector<std::string> paramList;
															#line 415 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				paramList.push_back(snapBin.toString());
															#line 417 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				auto listArgs = execArg->getBinaryArgs();
															#line 418 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				for( auto elem : listArgs ) {
															#line 419 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
					paramList.push_back(elem.toString());
															#line 2571 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				}
															#line 422 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				paramList.push_back("--path");
															#line 423 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				paramList.push_back(folder);
															#line 424 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				const char* version = FDB_VT_VERSION;
															#line 425 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				paramList.push_back("--version");
															#line 426 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				paramList.push_back(version);
															#line 427 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				paramList.push_back("--role");
															#line 428 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				paramList.push_back(role);
															#line 429 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				paramList.push_back("--uid");
															#line 430 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				paramList.push_back(uidStr.toString());
															#line 431 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				cmdErr = spawnProcess(snapBin.toString(), paramList, maxWaitTime, false , 0);
															#line 432 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				StrictFuture<Void> __when_expr_0 = success(cmdErr);
															#line 432 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				if (static_cast<ExecHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2597 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ExecHelperActor*>(this)->actor_wait_state = 1;
															#line 432 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExecHelperActor, 0, Void >*>(static_cast<ExecHelperActor*>(this)));
															#line 2602 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 436 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				folderFrom = folder + "/.";
															#line 437 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				folderTo = folder + "-snap-" + uidStr.toString() + "-" + role;
															#line 438 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				std::vector<std::string> paramList;
															#line 439 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				std::string mkdirBin = "/bin/mkdir";
															#line 440 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				paramList.push_back(mkdirBin);
															#line 441 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				paramList.push_back(folderTo);
															#line 442 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				cmdErr = spawnProcess(mkdirBin, paramList, maxWaitTime, false , 10.0);
															#line 443 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				StrictFuture<Void> __when_expr_1 = success(cmdErr);
															#line 443 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				if (static_cast<ExecHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2625 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<ExecHelperActor*>(this)->actor_wait_state = 2;
															#line 443 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExecHelperActor, 1, Void >*>(static_cast<ExecHelperActor*>(this)));
															#line 2630 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExecHelperActorState();
		static_cast<ExecHelperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 457 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (!static_cast<ExecHelperActor*>(this)->SAV<int>::futures) { (void)(err); this->~ExecHelperActorState(); static_cast<ExecHelperActor*>(this)->destroy(); return 0; }
															#line 2654 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		new (&static_cast<ExecHelperActor*>(this)->SAV< int >::value()) int(std::move(err)); // state_var_RVO
		this->~ExecHelperActorState();
		static_cast<ExecHelperActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 433 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		err = cmdErr.get();
															#line 2666 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 433 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		err = cmdErr.get();
															#line 2675 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExecHelperActor*>(this)->actor_wait_state > 0) static_cast<ExecHelperActor*>(this)->actor_wait_state = 0;
		static_cast<ExecHelperActor*>(this)->ActorCallback< ExecHelperActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExecHelperActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("execHelper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExecHelperActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("execHelper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExecHelperActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("execHelper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExecHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 444 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		err = cmdErr.get();
															#line 445 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (err == 0)
															#line 2761 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		{
															#line 446 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			std::vector<std::string> paramList;
															#line 447 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			std::string cpBin = "/bin/cp";
															#line 448 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			paramList.push_back(cpBin);
															#line 449 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			paramList.push_back("-a");
															#line 450 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			paramList.push_back(folderFrom);
															#line 451 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			paramList.push_back(folderTo);
															#line 452 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			cmdErr = spawnProcess(cpBin, paramList, maxWaitTime, true , 1.0);
															#line 453 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			StrictFuture<Void> __when_expr_2 = success(cmdErr);
															#line 453 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			if (static_cast<ExecHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2781 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
			static_cast<ExecHelperActor*>(this)->actor_wait_state = 3;
															#line 453 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExecHelperActor, 2, Void >*>(static_cast<ExecHelperActor*>(this)));
															#line 2786 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 444 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		err = cmdErr.get();
															#line 445 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		if (err == 0)
															#line 2802 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		{
															#line 446 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			std::vector<std::string> paramList;
															#line 447 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			std::string cpBin = "/bin/cp";
															#line 448 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			paramList.push_back(cpBin);
															#line 449 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			paramList.push_back("-a");
															#line 450 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			paramList.push_back(folderFrom);
															#line 451 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			paramList.push_back(folderTo);
															#line 452 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			cmdErr = spawnProcess(cpBin, paramList, maxWaitTime, true , 1.0);
															#line 453 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			StrictFuture<Void> __when_expr_2 = success(cmdErr);
															#line 453 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			if (static_cast<ExecHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2822 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
			static_cast<ExecHelperActor*>(this)->actor_wait_state = 3;
															#line 453 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExecHelperActor, 2, Void >*>(static_cast<ExecHelperActor*>(this)));
															#line 2827 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExecHelperActor*>(this)->actor_wait_state > 0) static_cast<ExecHelperActor*>(this)->actor_wait_state = 0;
		static_cast<ExecHelperActor*>(this)->ActorCallback< ExecHelperActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExecHelperActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("execHelper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execHelper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExecHelperActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("execHelper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execHelper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExecHelperActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("execHelper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExecHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execHelper", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 454 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		err = cmdErr.get();
															#line 2922 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 454 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
		err = cmdErr.get();
															#line 2931 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ExecHelperActor*>(this)->actor_wait_state > 0) static_cast<ExecHelperActor*>(this)->actor_wait_state = 0;
		static_cast<ExecHelperActor*>(this)->ActorCallback< ExecHelperActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExecHelperActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("execHelper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execHelper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ExecHelperActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("execHelper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execHelper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ExecHelperActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("execHelper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExecHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execHelper", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 406 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	ExecCmdValueString* execArg;
															#line 406 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	UID snapUID;
															#line 406 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	std::string folder;
															#line 406 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	std::string role;
															#line 407 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	Standalone<StringRef> uidStr;
															#line 408 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	int err;
															#line 409 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	Future<int> cmdErr;
															#line 410 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	double maxWaitTime;
															#line 436 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	std::string folderFrom;
															#line 437 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	std::string folderTo;
															#line 3031 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
};
// This generated class is to be used only via execHelper()
															#line 406 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
class ExecHelperActor final : public Actor<int>, public ActorCallback< ExecHelperActor, 0, Void >, public ActorCallback< ExecHelperActor, 1, Void >, public ActorCallback< ExecHelperActor, 2, Void >, public FastAllocated<ExecHelperActor>, public ExecHelperActorState<ExecHelperActor> {
															#line 3036 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
public:
	using FastAllocated<ExecHelperActor>::operator new;
	using FastAllocated<ExecHelperActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16394272757029379072UL, 16210325798258633728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExecHelperActor, 0, Void >;
friend struct ActorCallback< ExecHelperActor, 1, Void >;
friend struct ActorCallback< ExecHelperActor, 2, Void >;
															#line 406 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	ExecHelperActor(ExecCmdValueString* const& execArg,UID const& snapUID,std::string const& folder,std::string const& role) 
															#line 3055 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
		 : Actor<int>(),
		   ExecHelperActorState<ExecHelperActor>(execArg, snapUID, folder, role),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("execHelper", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1882703822349747712UL, 13825192957967985408UL);
		ActorExecutionContextHelper __helper(static_cast<ExecHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("execHelper");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("execHelper", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExecHelperActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExecHelperActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ExecHelperActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 406 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
[[nodiscard]] Future<int> execHelper( ExecCmdValueString* const& execArg, UID const& snapUID, std::string const& folder, std::string const& role ) {
															#line 406 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"
	return Future<int>(new ExecHelperActor(execArg, snapUID, folder, role));
															#line 3090 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbserver/FDBExecHelper.actor.g.cpp"
}

#line 459 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbserver/FDBExecHelper.actor.cpp"

struct StorageVersionInfo {
	Version version;
	Version durableVersion;
};

// storage nodes get snapshotted through the worker interface which does not have context about version information,
// following info is gathered at worker level to facilitate printing of version info during storage snapshots.
typedef std::map<UID, StorageVersionInfo> UidStorageVersionInfo;

std::map<NetworkAddress, UidStorageVersionInfo> workerStorageVersionInfo;

void setDataVersion(UID uid, Version version) {
	NetworkAddress addr = g_network->getLocalAddress();
	workerStorageVersionInfo[addr][uid].version = version;
}

void setDataDurableVersion(UID uid, Version durableVersion) {
	NetworkAddress addr = g_network->getLocalAddress();
	workerStorageVersionInfo[addr][uid].durableVersion = durableVersion;
}

void printStorageVersionInfo() {
	NetworkAddress addr = g_network->getLocalAddress();
	for (auto itr = workerStorageVersionInfo[addr].begin(); itr != workerStorageVersionInfo[addr].end(); itr++) {
		TraceEvent("StorageVersionInfo")
		    .detail("UID", itr->first)
		    .detail("Version", itr->second.version)
		    .detail("DurableVersion", itr->second.durableVersion);
	}
}
