#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
/*
 * VersionEpochCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "boost/lexical_cast.hpp"

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/IClientApi.h"
#include "fdbclient/ManagementAPI.actor.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

const KeyRef versionEpochSpecialKey = "\xff\xff/management/version_epoch"_sr;

struct VersionInfo {
	int64_t version;
	int64_t expectedVersion;
};

															#line 44 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
// This generated class is to be used only via getVersionInfo()
															#line 42 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
template <class GetVersionInfoActor>
															#line 42 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
class GetVersionInfoActorState {
															#line 50 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
public:
															#line 42 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	GetVersionInfoActorState(Reference<IDatabase> const& db) 
															#line 42 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
															#line 42 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		 : db(db),
															#line 43 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 59 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("getVersionInfo", reinterpret_cast<unsigned long>(this));

	}
	~GetVersionInfoActorState() 
	{
		fdb_probe_actor_destroy("getVersionInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 44 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			;
															#line 74 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetVersionInfoActorState();
		static_cast<GetVersionInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 46 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 47 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			StrictFuture<Version> __when_expr_0 = safeThreadFutureToFuture(tr->getReadVersion());
															#line 47 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (static_cast<GetVersionInfoActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 109 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetVersionInfoActor*>(this)->actor_wait_state = 1;
															#line 47 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetVersionInfoActor, 0, Version >*>(static_cast<GetVersionInfoActor*>(this)));
															#line 114 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 57 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 57 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (static_cast<GetVersionInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 138 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetVersionInfoActor*>(this)->actor_wait_state = 3;
															#line 57 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetVersionInfoActor, 2, Void >*>(static_cast<GetVersionInfoActor*>(this)));
															#line 143 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 48 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		versionEpochValFuture = tr->get(versionEpochKey);
															#line 49 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = safeThreadFutureToFuture(versionEpochValFuture);
															#line 49 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (static_cast<GetVersionInfoActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 162 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetVersionInfoActor*>(this)->actor_wait_state = 2;
															#line 49 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetVersionInfoActor, 1, Optional<Value> >*>(static_cast<GetVersionInfoActor*>(this)));
															#line 167 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& __rv,int loopDepth) 
	{
															#line 47 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		rv = __rv;
															#line 176 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && __rv,int loopDepth) 
	{
		rv = std::move(__rv);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetVersionInfoActor*>(this)->actor_wait_state > 0) static_cast<GetVersionInfoActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionInfoActor*>(this)->ActorCallback< GetVersionInfoActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionInfoActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getVersionInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetVersionInfoActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getVersionInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetVersionInfoActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getVersionInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Optional<Value> const& versionEpochVal,int loopDepth) 
	{
															#line 50 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (!versionEpochVal.present())
															#line 255 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		{
															#line 51 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (!static_cast<GetVersionInfoActor*>(this)->SAV<Optional<VersionInfo>>::futures) { (void)(Optional<VersionInfo>()); this->~GetVersionInfoActorState(); static_cast<GetVersionInfoActor*>(this)->destroy(); return 0; }
															#line 259 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			new (&static_cast<GetVersionInfoActor*>(this)->SAV< Optional<VersionInfo> >::value()) Optional<VersionInfo>(Optional<VersionInfo>());
			this->~GetVersionInfoActorState();
			static_cast<GetVersionInfoActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 53 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		int64_t versionEpoch = BinaryReader::fromStringRef<int64_t>(versionEpochVal.get(), Unversioned());
															#line 54 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		int64_t expected = g_network->timer() * CLIENT_KNOBS->CORE_VERSIONSPERSECOND - versionEpoch;
															#line 55 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (!static_cast<GetVersionInfoActor*>(this)->SAV<Optional<VersionInfo>>::futures) { (void)(VersionInfo{ rv, expected }); this->~GetVersionInfoActorState(); static_cast<GetVersionInfoActor*>(this)->destroy(); return 0; }
															#line 271 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		new (&static_cast<GetVersionInfoActor*>(this)->SAV< Optional<VersionInfo> >::value()) Optional<VersionInfo>(VersionInfo{ rv, expected });
		this->~GetVersionInfoActorState();
		static_cast<GetVersionInfoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> && versionEpochVal,int loopDepth) 
	{
															#line 50 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (!versionEpochVal.present())
															#line 283 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		{
															#line 51 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (!static_cast<GetVersionInfoActor*>(this)->SAV<Optional<VersionInfo>>::futures) { (void)(Optional<VersionInfo>()); this->~GetVersionInfoActorState(); static_cast<GetVersionInfoActor*>(this)->destroy(); return 0; }
															#line 287 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			new (&static_cast<GetVersionInfoActor*>(this)->SAV< Optional<VersionInfo> >::value()) Optional<VersionInfo>(Optional<VersionInfo>());
			this->~GetVersionInfoActorState();
			static_cast<GetVersionInfoActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 53 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		int64_t versionEpoch = BinaryReader::fromStringRef<int64_t>(versionEpochVal.get(), Unversioned());
															#line 54 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		int64_t expected = g_network->timer() * CLIENT_KNOBS->CORE_VERSIONSPERSECOND - versionEpoch;
															#line 55 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (!static_cast<GetVersionInfoActor*>(this)->SAV<Optional<VersionInfo>>::futures) { (void)(VersionInfo{ rv, expected }); this->~GetVersionInfoActorState(); static_cast<GetVersionInfoActor*>(this)->destroy(); return 0; }
															#line 299 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		new (&static_cast<GetVersionInfoActor*>(this)->SAV< Optional<VersionInfo> >::value()) Optional<VersionInfo>(VersionInfo{ rv, expected });
		this->~GetVersionInfoActorState();
		static_cast<GetVersionInfoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> const& versionEpochVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(versionEpochVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> && versionEpochVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(versionEpochVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetVersionInfoActor*>(this)->actor_wait_state > 0) static_cast<GetVersionInfoActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionInfoActor*>(this)->ActorCallback< GetVersionInfoActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionInfoActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getVersionInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetVersionInfoActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getVersionInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetVersionInfoActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getVersionInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetVersionInfoActor*>(this)->actor_wait_state > 0) static_cast<GetVersionInfoActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionInfoActor*>(this)->ActorCallback< GetVersionInfoActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionInfoActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getVersionInfo", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionInfo", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetVersionInfoActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getVersionInfo", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionInfo", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetVersionInfoActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getVersionInfo", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionInfo", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 42 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 43 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 47 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	Version rv;
															#line 48 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	ThreadFuture<Optional<Value>> versionEpochValFuture;
															#line 477 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
};
// This generated class is to be used only via getVersionInfo()
															#line 42 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
class GetVersionInfoActor final : public Actor<Optional<VersionInfo>>, public ActorCallback< GetVersionInfoActor, 0, Version >, public ActorCallback< GetVersionInfoActor, 1, Optional<Value> >, public ActorCallback< GetVersionInfoActor, 2, Void >, public FastAllocated<GetVersionInfoActor>, public GetVersionInfoActorState<GetVersionInfoActor> {
															#line 482 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
public:
	using FastAllocated<GetVersionInfoActor>::operator new;
	using FastAllocated<GetVersionInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12679525334407022336UL, 3083082872908436224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<VersionInfo>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetVersionInfoActor, 0, Version >;
friend struct ActorCallback< GetVersionInfoActor, 1, Optional<Value> >;
friend struct ActorCallback< GetVersionInfoActor, 2, Void >;
															#line 42 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	GetVersionInfoActor(Reference<IDatabase> const& db) 
															#line 501 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		 : Actor<Optional<VersionInfo>>(),
		   GetVersionInfoActorState<GetVersionInfoActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getVersionInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3635557255591054336UL, 8683522357850957824UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getVersionInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getVersionInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetVersionInfoActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetVersionInfoActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetVersionInfoActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 42 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
[[nodiscard]] static Future<Optional<VersionInfo>> getVersionInfo( Reference<IDatabase> const& db ) {
															#line 42 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	return Future<Optional<VersionInfo>>(new GetVersionInfoActor(db));
															#line 535 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
}

#line 61 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"

															#line 540 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
// This generated class is to be used only via getVersionEpoch()
															#line 62 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
template <class GetVersionEpochActor>
															#line 62 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
class GetVersionEpochActorState {
															#line 546 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
public:
															#line 62 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	GetVersionEpochActorState(Reference<ITransaction> const& tr) 
															#line 62 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
															#line 62 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		 : tr(tr)
															#line 553 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("getVersionEpoch", reinterpret_cast<unsigned long>(this));

	}
	~GetVersionEpochActorState() 
	{
		fdb_probe_actor_destroy("getVersionEpoch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 63 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			;
															#line 568 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetVersionEpochActorState();
		static_cast<GetVersionEpochActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 65 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			versionEpochValFuture = tr->get(versionEpochSpecialKey);
															#line 66 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = safeThreadFutureToFuture(versionEpochValFuture);
															#line 66 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (static_cast<GetVersionEpochActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 603 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetVersionEpochActor*>(this)->actor_wait_state = 1;
															#line 66 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetVersionEpochActor, 0, Optional<Value> >*>(static_cast<GetVersionEpochActor*>(this)));
															#line 608 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 70 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 70 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (static_cast<GetVersionEpochActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 632 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetVersionEpochActor*>(this)->actor_wait_state = 2;
															#line 70 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetVersionEpochActor, 1, Void >*>(static_cast<GetVersionEpochActor*>(this)));
															#line 637 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& versionEpochVal,int loopDepth) 
	{
															#line 67 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (!static_cast<GetVersionEpochActor*>(this)->SAV<Optional<int64_t>>::futures) { (void)(versionEpochVal.present() ? boost::lexical_cast<int64_t>(versionEpochVal.get().toString()) : Optional<int64_t>()); this->~GetVersionEpochActorState(); static_cast<GetVersionEpochActor*>(this)->destroy(); return 0; }
															#line 652 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		new (&static_cast<GetVersionEpochActor*>(this)->SAV< Optional<int64_t> >::value()) Optional<int64_t>(versionEpochVal.present() ? boost::lexical_cast<int64_t>(versionEpochVal.get().toString()) : Optional<int64_t>());
		this->~GetVersionEpochActorState();
		static_cast<GetVersionEpochActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && versionEpochVal,int loopDepth) 
	{
															#line 67 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (!static_cast<GetVersionEpochActor*>(this)->SAV<Optional<int64_t>>::futures) { (void)(versionEpochVal.present() ? boost::lexical_cast<int64_t>(versionEpochVal.get().toString()) : Optional<int64_t>()); this->~GetVersionEpochActorState(); static_cast<GetVersionEpochActor*>(this)->destroy(); return 0; }
															#line 664 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		new (&static_cast<GetVersionEpochActor*>(this)->SAV< Optional<int64_t> >::value()) Optional<int64_t>(versionEpochVal.present() ? boost::lexical_cast<int64_t>(versionEpochVal.get().toString()) : Optional<int64_t>());
		this->~GetVersionEpochActorState();
		static_cast<GetVersionEpochActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& versionEpochVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(versionEpochVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && versionEpochVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(versionEpochVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetVersionEpochActor*>(this)->actor_wait_state > 0) static_cast<GetVersionEpochActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionEpochActor*>(this)->ActorCallback< GetVersionEpochActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionEpochActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getVersionEpoch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionEpoch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetVersionEpochActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getVersionEpoch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionEpoch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetVersionEpochActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getVersionEpoch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionEpoch", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetVersionEpochActor*>(this)->actor_wait_state > 0) static_cast<GetVersionEpochActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionEpochActor*>(this)->ActorCallback< GetVersionEpochActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionEpochActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getVersionEpoch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionEpoch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetVersionEpochActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getVersionEpoch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionEpoch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetVersionEpochActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getVersionEpoch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionEpoch", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 62 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 65 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	ThreadFuture<Optional<Value>> versionEpochValFuture;
															#line 838 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
};
// This generated class is to be used only via getVersionEpoch()
															#line 62 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
class GetVersionEpochActor final : public Actor<Optional<int64_t>>, public ActorCallback< GetVersionEpochActor, 0, Optional<Value> >, public ActorCallback< GetVersionEpochActor, 1, Void >, public FastAllocated<GetVersionEpochActor>, public GetVersionEpochActorState<GetVersionEpochActor> {
															#line 843 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
public:
	using FastAllocated<GetVersionEpochActor>::operator new;
	using FastAllocated<GetVersionEpochActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10506759167487775232UL, 11450873976679010304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<int64_t>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetVersionEpochActor, 0, Optional<Value> >;
friend struct ActorCallback< GetVersionEpochActor, 1, Void >;
															#line 62 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	GetVersionEpochActor(Reference<ITransaction> const& tr) 
															#line 861 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		 : Actor<Optional<int64_t>>(),
		   GetVersionEpochActorState<GetVersionEpochActor>(tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getVersionEpoch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2685741545284971264UL, 8920196585197214976UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getVersionEpoch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getVersionEpoch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetVersionEpochActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetVersionEpochActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 62 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
[[nodiscard]] static Future<Optional<int64_t>> getVersionEpoch( Reference<ITransaction> const& tr ) {
															#line 62 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	return Future<Optional<int64_t>>(new GetVersionEpochActor(tr));
															#line 894 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
}

#line 74 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"

															#line 899 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
// This generated class is to be used only via versionEpochCommandActor()
															#line 75 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
template <class VersionEpochCommandActorActor>
															#line 75 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
class VersionEpochCommandActorActorState {
															#line 905 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
public:
															#line 75 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	VersionEpochCommandActorActorState(Reference<IDatabase> const& db,Database const& cx,std::vector<StringRef> const& tokens) 
															#line 75 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
															#line 75 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		 : db(db),
															#line 75 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		   cx(cx),
															#line 75 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		   tokens(tokens)
															#line 916 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("versionEpochCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~VersionEpochCommandActorActorState() 
	{
		fdb_probe_actor_destroy("versionEpochCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 76 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (tokens.size() <= 3)
															#line 931 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			{
															#line 77 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
				tr = db->createTransaction();
															#line 78 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
				if (tokens.size() == 1)
															#line 937 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
				{
															#line 79 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
					StrictFuture<Optional<VersionInfo>> __when_expr_0 = getVersionInfo(db);
															#line 79 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
					if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 943 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 1;
															#line 79 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VersionEpochCommandActorActor, 0, Optional<VersionInfo> >*>(static_cast<VersionEpochCommandActorActor*>(this)));
															#line 948 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 89 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
					if (tokens.size() == 2 && tokencmp(tokens[1], "get"))
															#line 955 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
					{
															#line 90 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
						StrictFuture<Optional<int64_t>> __when_expr_1 = getVersionEpoch(db->createTransaction());
															#line 90 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
						if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 961 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
						if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
						static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 2;
															#line 90 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
						__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VersionEpochCommandActorActor, 1, Optional<int64_t> >*>(static_cast<VersionEpochCommandActorActor*>(this)));
															#line 966 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 97 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
						if (tokens.size() == 2 && tokencmp(tokens[1], "disable"))
															#line 973 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
						{
															#line 101 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
							;
															#line 977 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
							loopDepth = a_body1loopHead1(loopDepth);
						}
						else
						{
															#line 115 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
							if ((tokens.size() == 2 && tokencmp(tokens[1], "enable")) || (tokens.size() == 3 && tokencmp(tokens[1], "set")))
															#line 984 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
							{
															#line 117 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
								v = int64_t();
															#line 118 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
								if (tokens.size() == 3)
															#line 990 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
								{
															#line 119 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
									int n = 0;
															#line 120 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
									if (sscanf(tokens[2].toString().c_str(), "%" SCNd64 "%n", &v, &n) != 1 || n != tokens[2].size())
															#line 996 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
									{
															#line 121 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
										printUsage(tokens[0]);
															#line 122 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
										if (!static_cast<VersionEpochCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~VersionEpochCommandActorActorState(); static_cast<VersionEpochCommandActorActor*>(this)->destroy(); return 0; }
															#line 1002 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
										new (&static_cast<VersionEpochCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
										this->~VersionEpochCommandActorActorState();
										static_cast<VersionEpochCommandActorActor*>(this)->finishSendAndDelPromiseRef();
										return 0;
									}
								}
								else
								{
															#line 125 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
									v = 0;
															#line 1013 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
								}
															#line 128 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
								;
															#line 1017 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
								loopDepth = a_body1loopHead2(loopDepth);
							}
							else
							{
															#line 144 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
								if (tokens.size() == 2 && tokencmp(tokens[1], "commit"))
															#line 1024 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
								{
															#line 145 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
									StrictFuture<Optional<VersionInfo>> __when_expr_8 = getVersionInfo(db);
															#line 145 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
									if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1030 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
									if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1when3(__when_expr_8.get(), loopDepth); };
									static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 9;
															#line 145 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
									__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< VersionEpochCommandActorActor, 8, Optional<VersionInfo> >*>(static_cast<VersionEpochCommandActorActor*>(this)));
															#line 1035 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
									loopDepth = 0;
								}
								else
								{
									loopDepth = a_body1cont19(loopDepth);
								}
							}
						}
					}
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~VersionEpochCommandActorActorState();
		static_cast<VersionEpochCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 155 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		printUsage(tokens[0]);
															#line 156 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (!static_cast<VersionEpochCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~VersionEpochCommandActorActorState(); static_cast<VersionEpochCommandActorActor*>(this)->destroy(); return 0; }
															#line 1074 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		new (&static_cast<VersionEpochCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
		this->~VersionEpochCommandActorActorState();
		static_cast<VersionEpochCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Optional<VersionInfo> const& versionInfo,int loopDepth) 
	{
															#line 80 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (versionInfo.present())
															#line 1092 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		{
															#line 81 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			int64_t diff = versionInfo.get().expectedVersion - versionInfo.get().version;
															#line 82 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			printf("Version:    %" PRId64 "\n", versionInfo.get().version);
															#line 83 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			printf("Expected:   %" PRId64 "\n", versionInfo.get().expectedVersion);
															#line 84 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			printf("Difference: %" PRId64 " (%.2fs)\n", diff, 1.0 * diff / CLIENT_KNOBS->VERSIONS_PER_SECOND);
															#line 1102 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		}
		else
		{
															#line 86 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			printf("Version epoch is unset\n");
															#line 1108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		}
															#line 88 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (!static_cast<VersionEpochCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~VersionEpochCommandActorActorState(); static_cast<VersionEpochCommandActorActor*>(this)->destroy(); return 0; }
															#line 1112 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		new (&static_cast<VersionEpochCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~VersionEpochCommandActorActorState();
		static_cast<VersionEpochCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Optional<VersionInfo> && versionInfo,int loopDepth) 
	{
															#line 80 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (versionInfo.present())
															#line 1124 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		{
															#line 81 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			int64_t diff = versionInfo.get().expectedVersion - versionInfo.get().version;
															#line 82 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			printf("Version:    %" PRId64 "\n", versionInfo.get().version);
															#line 83 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			printf("Expected:   %" PRId64 "\n", versionInfo.get().expectedVersion);
															#line 84 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			printf("Difference: %" PRId64 " (%.2fs)\n", diff, 1.0 * diff / CLIENT_KNOBS->VERSIONS_PER_SECOND);
															#line 1134 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		}
		else
		{
															#line 86 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			printf("Version epoch is unset\n");
															#line 1140 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		}
															#line 88 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (!static_cast<VersionEpochCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~VersionEpochCommandActorActorState(); static_cast<VersionEpochCommandActorActor*>(this)->destroy(); return 0; }
															#line 1144 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		new (&static_cast<VersionEpochCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~VersionEpochCommandActorActorState();
		static_cast<VersionEpochCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<VersionInfo> const& versionInfo,int loopDepth) 
	{
		loopDepth = a_body1cont3(versionInfo, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<VersionInfo> && versionInfo,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(versionInfo), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state > 0) static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<VersionEpochCommandActorActor*>(this)->ActorCallback< VersionEpochCommandActorActor, 0, Optional<VersionInfo> >::remove();

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 0, Optional<VersionInfo> >*,Optional<VersionInfo> const& value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 0, Optional<VersionInfo> >*,Optional<VersionInfo> && value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VersionEpochCommandActorActor, 0, Optional<VersionInfo> >*,Error err) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Optional<int64_t> const& versionEpoch,int loopDepth) 
	{
															#line 91 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (versionEpoch.present())
															#line 1237 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		{
															#line 92 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			printf("Current version epoch is %" PRId64 "\n", versionEpoch.get());
															#line 1241 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		}
		else
		{
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			printf("Version epoch is unset\n");
															#line 1247 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		}
															#line 96 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (!static_cast<VersionEpochCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~VersionEpochCommandActorActorState(); static_cast<VersionEpochCommandActorActor*>(this)->destroy(); return 0; }
															#line 1251 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		new (&static_cast<VersionEpochCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~VersionEpochCommandActorActorState();
		static_cast<VersionEpochCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Optional<int64_t> && versionEpoch,int loopDepth) 
	{
															#line 91 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (versionEpoch.present())
															#line 1263 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		{
															#line 92 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			printf("Current version epoch is %" PRId64 "\n", versionEpoch.get());
															#line 1267 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		}
		else
		{
															#line 94 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			printf("Version epoch is unset\n");
															#line 1273 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		}
															#line 96 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (!static_cast<VersionEpochCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~VersionEpochCommandActorActorState(); static_cast<VersionEpochCommandActorActor*>(this)->destroy(); return 0; }
															#line 1277 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		new (&static_cast<VersionEpochCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~VersionEpochCommandActorActorState();
		static_cast<VersionEpochCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Optional<int64_t> const& versionEpoch,int loopDepth) 
	{
		loopDepth = a_body1cont8(versionEpoch, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Optional<int64_t> && versionEpoch,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(versionEpoch), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state > 0) static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<VersionEpochCommandActorActor*>(this)->ActorCallback< VersionEpochCommandActorActor, 1, Optional<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 1, Optional<int64_t> >*,Optional<int64_t> const& value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 1, Optional<int64_t> >*,Optional<int64_t> && value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< VersionEpochCommandActorActor, 1, Optional<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont12(int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 103 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 104 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			StrictFuture<Optional<int64_t>> __when_expr_2 = getVersionEpoch(db->createTransaction());
															#line 104 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1382 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 3;
															#line 104 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< VersionEpochCommandActorActor, 2, Optional<int64_t> >*>(static_cast<VersionEpochCommandActorActor*>(this)));
															#line 1387 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 112 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			StrictFuture<Void> __when_expr_4 = safeThreadFutureToFuture(tr->onError(e));
															#line 112 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1411 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 5;
															#line 112 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< VersionEpochCommandActorActor, 4, Void >*>(static_cast<VersionEpochCommandActorActor*>(this)));
															#line 1416 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<int64_t> const& versionEpoch,int loopDepth) 
	{
															#line 105 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (!versionEpoch.present())
															#line 1431 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		{
															#line 106 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (!static_cast<VersionEpochCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~VersionEpochCommandActorActorState(); static_cast<VersionEpochCommandActorActor*>(this)->destroy(); return 0; }
															#line 1435 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			new (&static_cast<VersionEpochCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
			this->~VersionEpochCommandActorActorState();
			static_cast<VersionEpochCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			tr->clear(versionEpochSpecialKey);
															#line 109 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			StrictFuture<Void> __when_expr_3 = safeThreadFutureToFuture(tr->commit());
															#line 109 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1449 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
			static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 4;
															#line 109 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< VersionEpochCommandActorActor, 3, Void >*>(static_cast<VersionEpochCommandActorActor*>(this)));
															#line 1454 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<int64_t> && versionEpoch,int loopDepth) 
	{
															#line 105 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (!versionEpoch.present())
															#line 1464 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		{
															#line 106 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (!static_cast<VersionEpochCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~VersionEpochCommandActorActorState(); static_cast<VersionEpochCommandActorActor*>(this)->destroy(); return 0; }
															#line 1468 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			new (&static_cast<VersionEpochCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
			this->~VersionEpochCommandActorActorState();
			static_cast<VersionEpochCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 108 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			tr->clear(versionEpochSpecialKey);
															#line 109 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			StrictFuture<Void> __when_expr_3 = safeThreadFutureToFuture(tr->commit());
															#line 109 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1482 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
			static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 4;
															#line 109 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< VersionEpochCommandActorActor, 3, Void >*>(static_cast<VersionEpochCommandActorActor*>(this)));
															#line 1487 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<int64_t> const& versionEpoch,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(versionEpoch, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<int64_t> && versionEpoch,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(versionEpoch), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state > 0) static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<VersionEpochCommandActorActor*>(this)->ActorCallback< VersionEpochCommandActorActor, 2, Optional<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 2, Optional<int64_t> >*,Optional<int64_t> const& value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 2, Optional<int64_t> >*,Optional<int64_t> && value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< VersionEpochCommandActorActor, 2, Optional<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state > 0) static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<VersionEpochCommandActorActor*>(this)->ActorCallback< VersionEpochCommandActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< VersionEpochCommandActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state > 0) static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<VersionEpochCommandActorActor*>(this)->ActorCallback< VersionEpochCommandActorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< VersionEpochCommandActorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont14(int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead2(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2(int loopDepth) 
	{
		try {
															#line 130 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 131 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			StrictFuture<Optional<int64_t>> __when_expr_5 = getVersionEpoch(tr);
															#line 131 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody2Catch1(actor_cancelled(), loopDepth);
															#line 1783 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody2Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody2when1(__when_expr_5.get(), loopDepth); };
			static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 6;
															#line 131 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< VersionEpochCommandActorActor, 5, Optional<int64_t> >*>(static_cast<VersionEpochCommandActorActor*>(this)));
															#line 1788 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody2cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead2(0);

		return loopDepth;
	}
	int a_body1loopBody2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 141 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			StrictFuture<Void> __when_expr_7 = safeThreadFutureToFuture(tr->onError(e));
															#line 141 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1812 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody2Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 8;
															#line 141 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< VersionEpochCommandActorActor, 7, Void >*>(static_cast<VersionEpochCommandActorActor*>(this)));
															#line 1817 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody2cont2(Optional<int64_t> const& versionEpoch,int loopDepth) 
	{
															#line 132 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (!versionEpoch.present() || (versionEpoch.get() != v && tokens.size() == 3))
															#line 1832 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		{
															#line 133 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			tr->set(versionEpochSpecialKey, BinaryWriter::toValue(v, Unversioned()));
															#line 134 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			StrictFuture<Void> __when_expr_6 = safeThreadFutureToFuture(tr->commit());
															#line 134 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody2Catch1(actor_cancelled(), loopDepth);
															#line 1840 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody2Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody2cont2when1(__when_expr_6.get(), loopDepth); };
			static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 7;
															#line 134 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< VersionEpochCommandActorActor, 6, Void >*>(static_cast<VersionEpochCommandActorActor*>(this)));
															#line 1845 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 136 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			printf("Version epoch enabled. Run `versionepoch commit` to irreversibly jump to the target " "version\n");
															#line 138 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (!static_cast<VersionEpochCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~VersionEpochCommandActorActorState(); static_cast<VersionEpochCommandActorActor*>(this)->destroy(); return 0; }
															#line 1854 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			new (&static_cast<VersionEpochCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
			this->~VersionEpochCommandActorActorState();
			static_cast<VersionEpochCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody2cont2(Optional<int64_t> && versionEpoch,int loopDepth) 
	{
															#line 132 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (!versionEpoch.present() || (versionEpoch.get() != v && tokens.size() == 3))
															#line 1867 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		{
															#line 133 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			tr->set(versionEpochSpecialKey, BinaryWriter::toValue(v, Unversioned()));
															#line 134 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			StrictFuture<Void> __when_expr_6 = safeThreadFutureToFuture(tr->commit());
															#line 134 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody2Catch1(actor_cancelled(), loopDepth);
															#line 1875 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody2Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody2cont2when1(__when_expr_6.get(), loopDepth); };
			static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 7;
															#line 134 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< VersionEpochCommandActorActor, 6, Void >*>(static_cast<VersionEpochCommandActorActor*>(this)));
															#line 1880 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 136 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			printf("Version epoch enabled. Run `versionepoch commit` to irreversibly jump to the target " "version\n");
															#line 138 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (!static_cast<VersionEpochCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~VersionEpochCommandActorActorState(); static_cast<VersionEpochCommandActorActor*>(this)->destroy(); return 0; }
															#line 1889 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			new (&static_cast<VersionEpochCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
			this->~VersionEpochCommandActorActorState();
			static_cast<VersionEpochCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody2when1(Optional<int64_t> const& versionEpoch,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont2(versionEpoch, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2when1(Optional<int64_t> && versionEpoch,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont2(std::move(versionEpoch), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state > 0) static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<VersionEpochCommandActorActor*>(this)->ActorCallback< VersionEpochCommandActorActor, 5, Optional<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 5, Optional<int64_t> >*,Optional<int64_t> const& value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 5, Optional<int64_t> >*,Optional<int64_t> && value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< VersionEpochCommandActorActor, 5, Optional<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody2cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state > 0) static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<VersionEpochCommandActorActor*>(this)->ActorCallback< VersionEpochCommandActorActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody2cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody2cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< VersionEpochCommandActorActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody2cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody2cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody2Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state > 0) static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<VersionEpochCommandActorActor*>(this)->ActorCallback< VersionEpochCommandActorActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody2Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody2Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< VersionEpochCommandActorActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont19(int loopDepth) 
	{
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont20(Optional<VersionInfo> const& versionInfo,int loopDepth) 
	{
															#line 146 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (versionInfo.present())
															#line 2176 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		{
															#line 147 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			StrictFuture<Void> __when_expr_9 = advanceVersion(cx, versionInfo.get().expectedVersion);
															#line 147 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2182 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont20when1(__when_expr_9.get(), loopDepth); };
			static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 10;
															#line 147 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< VersionEpochCommandActorActor, 9, Void >*>(static_cast<VersionEpochCommandActorActor*>(this)));
															#line 2187 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 149 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			printf("Must set the version epoch before committing it (see `versionepoch enable`)\n");
															#line 2194 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			loopDepth = a_body1cont20cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont20(Optional<VersionInfo> && versionInfo,int loopDepth) 
	{
															#line 146 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (versionInfo.present())
															#line 2204 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		{
															#line 147 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			StrictFuture<Void> __when_expr_9 = advanceVersion(cx, versionInfo.get().expectedVersion);
															#line 147 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2210 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont20when1(__when_expr_9.get(), loopDepth); };
			static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 10;
															#line 147 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< VersionEpochCommandActorActor, 9, Void >*>(static_cast<VersionEpochCommandActorActor*>(this)));
															#line 2215 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 149 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
			printf("Must set the version epoch before committing it (see `versionepoch enable`)\n");
															#line 2222 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
			loopDepth = a_body1cont20cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when3(Optional<VersionInfo> const& versionInfo,int loopDepth) 
	{
		loopDepth = a_body1cont20(versionInfo, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Optional<VersionInfo> && versionInfo,int loopDepth) 
	{
		loopDepth = a_body1cont20(std::move(versionInfo), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state > 0) static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<VersionEpochCommandActorActor*>(this)->ActorCallback< VersionEpochCommandActorActor, 8, Optional<VersionInfo> >::remove();

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 8, Optional<VersionInfo> >*,Optional<VersionInfo> const& value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 8, Optional<VersionInfo> >*,Optional<VersionInfo> && value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< VersionEpochCommandActorActor, 8, Optional<VersionInfo> >*,Error err) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont20cont1(int loopDepth) 
	{
															#line 151 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
		if (!static_cast<VersionEpochCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~VersionEpochCommandActorActorState(); static_cast<VersionEpochCommandActorActor*>(this)->destroy(); return 0; }
															#line 2307 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		new (&static_cast<VersionEpochCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~VersionEpochCommandActorActorState();
		static_cast<VersionEpochCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont20cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont20cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont20cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont20cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont20when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont20cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont20when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont20cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state > 0) static_cast<VersionEpochCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<VersionEpochCommandActorActor*>(this)->ActorCallback< VersionEpochCommandActorActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont20when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< VersionEpochCommandActorActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont20when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< VersionEpochCommandActorActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 75 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 75 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	Database cx;
															#line 75 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 77 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 117 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	int64_t v;
															#line 2412 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
};
// This generated class is to be used only via versionEpochCommandActor()
															#line 75 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
class VersionEpochCommandActorActor final : public Actor<bool>, public ActorCallback< VersionEpochCommandActorActor, 0, Optional<VersionInfo> >, public ActorCallback< VersionEpochCommandActorActor, 1, Optional<int64_t> >, public ActorCallback< VersionEpochCommandActorActor, 2, Optional<int64_t> >, public ActorCallback< VersionEpochCommandActorActor, 3, Void >, public ActorCallback< VersionEpochCommandActorActor, 4, Void >, public ActorCallback< VersionEpochCommandActorActor, 5, Optional<int64_t> >, public ActorCallback< VersionEpochCommandActorActor, 6, Void >, public ActorCallback< VersionEpochCommandActorActor, 7, Void >, public ActorCallback< VersionEpochCommandActorActor, 8, Optional<VersionInfo> >, public ActorCallback< VersionEpochCommandActorActor, 9, Void >, public FastAllocated<VersionEpochCommandActorActor>, public VersionEpochCommandActorActorState<VersionEpochCommandActorActor> {
															#line 2417 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
public:
	using FastAllocated<VersionEpochCommandActorActor>::operator new;
	using FastAllocated<VersionEpochCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1064907001563864320UL, 12905485755969039872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< VersionEpochCommandActorActor, 0, Optional<VersionInfo> >;
friend struct ActorCallback< VersionEpochCommandActorActor, 1, Optional<int64_t> >;
friend struct ActorCallback< VersionEpochCommandActorActor, 2, Optional<int64_t> >;
friend struct ActorCallback< VersionEpochCommandActorActor, 3, Void >;
friend struct ActorCallback< VersionEpochCommandActorActor, 4, Void >;
friend struct ActorCallback< VersionEpochCommandActorActor, 5, Optional<int64_t> >;
friend struct ActorCallback< VersionEpochCommandActorActor, 6, Void >;
friend struct ActorCallback< VersionEpochCommandActorActor, 7, Void >;
friend struct ActorCallback< VersionEpochCommandActorActor, 8, Optional<VersionInfo> >;
friend struct ActorCallback< VersionEpochCommandActorActor, 9, Void >;
															#line 75 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	VersionEpochCommandActorActor(Reference<IDatabase> const& db,Database const& cx,std::vector<StringRef> const& tokens) 
															#line 2443 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
		 : Actor<bool>(),
		   VersionEpochCommandActorActorState<VersionEpochCommandActorActor>(db, cx, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18268446732730566912UL, 6346463548780853248UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("versionEpochCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("versionEpochCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< VersionEpochCommandActorActor, 0, Optional<VersionInfo> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< VersionEpochCommandActorActor, 1, Optional<int64_t> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< VersionEpochCommandActorActor, 2, Optional<int64_t> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< VersionEpochCommandActorActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< VersionEpochCommandActorActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< VersionEpochCommandActorActor, 5, Optional<int64_t> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< VersionEpochCommandActorActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< VersionEpochCommandActorActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< VersionEpochCommandActorActor, 8, Optional<VersionInfo> >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< VersionEpochCommandActorActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 75 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
[[nodiscard]] Future<bool> versionEpochCommandActor( Reference<IDatabase> const& db, Database const& cx, std::vector<StringRef> const& tokens ) {
															#line 75 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"
	return Future<bool>(new VersionEpochCommandActorActor(db, cx, tokens));
															#line 2484 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/build_output/fdbcli/VersionEpochCommand.actor.g.cpp"
}

#line 158 "/codebuild/output/src17799134/src/github.com/apple/foundationdb/fdbcli/VersionEpochCommand.actor.cpp"

CommandFactory versionEpochFactory(
    "versionepoch",
    CommandHelp("versionepoch [<enable|commit|get|set|disable> [EPOCH]]",
                "Read or write the version epoch",
                "If no arguments are specified, reports the offset between the expected version "
                "and the actual version. Otherwise, enables, disables, or commits the version epoch. "
                "Setting the version epoch can be irreversible since it can cause a large version jump. "
                "Thus, the version epoch must first by enabled with the enable or set command. This "
                "causes a recovery. Once the version epoch has been set, versions may be given out at "
                "a faster or slower rate to attempt to match the actual version to the expected version, "
                "based on the version epoch. After setting the version, run the commit command to perform "
                "a one time jump to the expected version. This is useful when there is a very large gap "
                "between the current version and the expected version. Note that once a version jump has "
                "occurred, it cannot be undone. Run this command without any arguments to see the current "
                "and expected version."));
} // namespace fdb_cli
