#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
/*
 * Throughput.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbrpc/DDSketch.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/ActorCollection.h"
#include "fdbrpc/Smoother.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct ITransactor : ReferenceCounted<ITransactor> {
	struct Stats {
		int64_t reads, writes, retries, transactions;
		double totalLatency, grvLatency, rowReadLatency, commitLatency;
		Stats()
		  : reads(0), writes(0), retries(0), transactions(0), totalLatency(0), grvLatency(0), rowReadLatency(0),
		    commitLatency(0) {}
		void operator+=(Stats const& s) {
			reads += s.reads;
			writes += s.writes;
			retries += s.retries;
			transactions += s.transactions;
			totalLatency += s.totalLatency;
			grvLatency += s.grvLatency;
			rowReadLatency += s.rowReadLatency;
			commitLatency += s.commitLatency;
		}
	};

	virtual Future<Void> doTransaction(Database const&, Stats* stats) = 0;
	virtual ~ITransactor() {}
};

struct RWTransactor : ITransactor {
	int reads, writes;
	int minValueBytes, maxValueBytes;
	std::string valueString;
	int keyCount, keyBytes;
	double zeroPaddingRatio;

	RWTransactor(int reads,
	             int writes,
	             int keyCount,
	             int keyBytes,
	             int minValueBytes,
	             int maxValueBytes,
	             double zeroPaddingRatio)
	  : reads(reads), writes(writes), minValueBytes(minValueBytes), maxValueBytes(maxValueBytes), keyCount(keyCount),
	    keyBytes(keyBytes), zeroPaddingRatio(zeroPaddingRatio) {
		ASSERT(minValueBytes <= maxValueBytes);
	}

	Key randomKey() {
		Key result = makeString(keyBytes);
		uint8_t* data = mutateString(result);
		memset(data, '.', keyBytes);

		double d = double(deterministicRandom()->randomInt(0, keyCount)) / keyCount;
		emplaceIndex(data, 0, *(int64_t*)&d);

		return result;
	}

	Value randomValue() {
		int length = deterministicRandom()->randomInt(minValueBytes, maxValueBytes + 1);
		int zeroPadding = static_cast<int>(zeroPaddingRatio * length);
		if (zeroPadding > length) {
			zeroPadding = length;
		}
		valueString = deterministicRandom()->randomAlphaNumeric(length);
		for (int i = 0; i < zeroPadding; ++i) {
			valueString[i] = '\0';
		}
		return StringRef((uint8_t*)valueString.c_str(), length);
	};

	Future<Void> doTransaction(Database const& db, Stats* stats) override {
		return rwTransaction(db, Reference<RWTransactor>::addRef(this), stats);
	}

																#line 102 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
// This generated class is to be used only via getLatency()
															#line 100 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
template <class GetLatencyActor>
															#line 100 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
class GetLatencyActorState {
															#line 108 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
public:
															#line 100 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	GetLatencyActorState(Future<Optional<Value>> const& f,double* const& t) 
															#line 100 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
															#line 100 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		 : f(f),
															#line 100 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		   t(t)
															#line 117 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
	{
		fdb_probe_actor_create("getLatency", reinterpret_cast<unsigned long>(this));

	}
	~GetLatencyActorState() 
	{
		fdb_probe_actor_destroy("getLatency", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 101 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = f;
															#line 101 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			if (static_cast<GetLatencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 134 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetLatencyActor*>(this)->actor_wait_state = 1;
															#line 101 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetLatencyActor, 0, Optional<Value> >*>(static_cast<GetLatencyActor*>(this)));
															#line 139 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetLatencyActorState();
		static_cast<GetLatencyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& v,int loopDepth) 
	{
															#line 102 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		*t += now();
															#line 103 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		if (!static_cast<GetLatencyActor*>(this)->SAV<Optional<Value>>::futures) { (void)(v); this->~GetLatencyActorState(); static_cast<GetLatencyActor*>(this)->destroy(); return 0; }
															#line 164 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		new (&static_cast<GetLatencyActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(v);
		this->~GetLatencyActorState();
		static_cast<GetLatencyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && v,int loopDepth) 
	{
															#line 102 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		*t += now();
															#line 103 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		if (!static_cast<GetLatencyActor*>(this)->SAV<Optional<Value>>::futures) { (void)(v); this->~GetLatencyActorState(); static_cast<GetLatencyActor*>(this)->destroy(); return 0; }
															#line 178 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		new (&static_cast<GetLatencyActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(v);
		this->~GetLatencyActorState();
		static_cast<GetLatencyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1cont1(v, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetLatencyActor*>(this)->actor_wait_state > 0) static_cast<GetLatencyActor*>(this)->actor_wait_state = 0;
		static_cast<GetLatencyActor*>(this)->ActorCallback< GetLatencyActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetLatencyActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getLatency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetLatencyActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getLatency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetLatencyActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getLatency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatency", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 100 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	Future<Optional<Value>> f;
															#line 100 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	double* t;
															#line 265 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
};
// This generated class is to be used only via getLatency()
															#line 100 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
class GetLatencyActor final : public Actor<Optional<Value>>, public ActorCallback< GetLatencyActor, 0, Optional<Value> >, public FastAllocated<GetLatencyActor>, public GetLatencyActorState<GetLatencyActor> {
															#line 270 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
public:
	using FastAllocated<GetLatencyActor>::operator new;
	using FastAllocated<GetLatencyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16517027991624117248UL, 3137061452772284672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetLatencyActor, 0, Optional<Value> >;
															#line 100 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	GetLatencyActor(Future<Optional<Value>> const& f,double* const& t) 
															#line 287 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		 : Actor<Optional<Value>>(),
		   GetLatencyActorState<GetLatencyActor>(f, t),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getLatency", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2645634590207226368UL, 11644588457737770240UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getLatency");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getLatency", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetLatencyActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 100 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
[[nodiscard]] static Future<Optional<Value>> getLatency( Future<Optional<Value>> const& f, double* const& t ) {
															#line 100 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	return Future<Optional<Value>>(new GetLatencyActor(f, t));
															#line 319 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
}

#line 105 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"

																#line 324 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
// This generated class is to be used only via rwTransaction()
															#line 106 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
template <class RwTransactionActor>
															#line 106 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
class RwTransactionActorState {
															#line 330 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
public:
															#line 106 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	RwTransactionActorState(Database const& db,Reference<RWTransactor> const& self,Stats* const& stats) 
															#line 106 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
															#line 106 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		 : db(db),
															#line 106 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		   self(self),
															#line 106 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		   stats(stats),
															#line 107 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		   keys(),
															#line 108 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		   values(),
															#line 109 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		   tr(db)
															#line 347 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
	{
		fdb_probe_actor_create("rwTransaction", reinterpret_cast<unsigned long>(this));

	}
	~RwTransactionActorState() 
	{
		fdb_probe_actor_destroy("rwTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 111 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			for(int op = 0;op < self->reads || op < self->writes;op++) {
															#line 112 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
				keys.push_back(self->randomKey());
															#line 364 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
			}
															#line 113 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			values.reserve(self->writes);
															#line 114 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			for(int op = 0;op < self->writes;op++) {
															#line 115 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
				values.push_back(self->randomValue());
															#line 372 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
			}
															#line 117 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			;
															#line 376 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RwTransactionActorState();
		static_cast<RwTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 147 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		if (!static_cast<RwTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RwTransactionActorState(); static_cast<RwTransactionActor*>(this)->destroy(); return 0; }
															#line 399 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		new (&static_cast<RwTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RwTransactionActorState();
		static_cast<RwTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 119 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			t_start = now();
															#line 120 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(tr.getReadVersion());
															#line 120 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			if (static_cast<RwTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 423 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RwTransactionActor*>(this)->actor_wait_state = 1;
															#line 120 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RwTransactionActor, 0, Void >*>(static_cast<RwTransactionActor*>(this)));
															#line 428 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 142 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 142 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			if (static_cast<RwTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 465 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<RwTransactionActor*>(this)->actor_wait_state = 4;
															#line 142 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RwTransactionActor, 3, Void >*>(static_cast<RwTransactionActor*>(this)));
															#line 470 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 121 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		t_rv = now();
															#line 122 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		rrLatency = -t_rv * self->reads;
															#line 124 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		reads = std::vector<Future<Optional<Value>>>();
															#line 125 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		reads.reserve(self->reads);
															#line 126 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		for(int i = 0;i < self->reads;i++) {
															#line 127 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			reads.push_back(getLatency(tr.get(keys[i]), &rrLatency));
															#line 495 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		}
															#line 128 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(reads);
															#line 128 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		if (static_cast<RwTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 501 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RwTransactionActor*>(this)->actor_wait_state = 2;
															#line 128 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RwTransactionActor, 1, Void >*>(static_cast<RwTransactionActor*>(this)));
															#line 506 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 121 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		t_rv = now();
															#line 122 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		rrLatency = -t_rv * self->reads;
															#line 124 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		reads = std::vector<Future<Optional<Value>>>();
															#line 125 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		reads.reserve(self->reads);
															#line 126 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		for(int i = 0;i < self->reads;i++) {
															#line 127 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			reads.push_back(getLatency(tr.get(keys[i]), &rrLatency));
															#line 525 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		}
															#line 128 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(reads);
															#line 128 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		if (static_cast<RwTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 531 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RwTransactionActor*>(this)->actor_wait_state = 2;
															#line 128 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RwTransactionActor, 1, Void >*>(static_cast<RwTransactionActor*>(this)));
															#line 536 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RwTransactionActor*>(this)->actor_wait_state > 0) static_cast<RwTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RwTransactionActor*>(this)->ActorCallback< RwTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RwTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rwTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RwTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rwTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RwTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rwTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RwTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rwTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RwTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rwTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RwTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rwTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		for(int i = 0;i < self->writes;i++) {
															#line 130 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			tr.set(keys[i], values[i]);
															#line 622 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		}
															#line 131 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		t_beforeCommit = now();
															#line 132 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 132 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		if (static_cast<RwTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 630 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<RwTransactionActor*>(this)->actor_wait_state = 3;
															#line 132 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RwTransactionActor, 2, Void >*>(static_cast<RwTransactionActor*>(this)));
															#line 635 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		for(int i = 0;i < self->writes;i++) {
															#line 130 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			tr.set(keys[i], values[i]);
															#line 646 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		}
															#line 131 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		t_beforeCommit = now();
															#line 132 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 132 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		if (static_cast<RwTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 654 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<RwTransactionActor*>(this)->actor_wait_state = 3;
															#line 132 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RwTransactionActor, 2, Void >*>(static_cast<RwTransactionActor*>(this)));
															#line 659 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RwTransactionActor*>(this)->actor_wait_state > 0) static_cast<RwTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RwTransactionActor*>(this)->ActorCallback< RwTransactionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RwTransactionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rwTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RwTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rwTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RwTransactionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rwTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RwTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rwTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RwTransactionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rwTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RwTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rwTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 134 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		stats->transactions++;
															#line 135 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		stats->reads += self->reads;
															#line 136 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		stats->writes += self->writes;
															#line 137 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		stats->grvLatency += t_rv - t_start;
															#line 138 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		stats->commitLatency += now() - t_beforeCommit;
															#line 139 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		stats->rowReadLatency += rrLatency / self->reads;
															#line 753 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 134 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		stats->transactions++;
															#line 135 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		stats->reads += self->reads;
															#line 136 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		stats->writes += self->writes;
															#line 137 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		stats->grvLatency += t_rv - t_start;
															#line 138 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		stats->commitLatency += now() - t_beforeCommit;
															#line 139 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		stats->rowReadLatency += rrLatency / self->reads;
															#line 772 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RwTransactionActor*>(this)->actor_wait_state > 0) static_cast<RwTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RwTransactionActor*>(this)->ActorCallback< RwTransactionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RwTransactionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rwTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RwTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rwTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RwTransactionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rwTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RwTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rwTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RwTransactionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rwTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RwTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rwTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		stats->retries++;
															#line 856 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		stats->retries++;
															#line 865 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RwTransactionActor*>(this)->actor_wait_state > 0) static_cast<RwTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RwTransactionActor*>(this)->ActorCallback< RwTransactionActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RwTransactionActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rwTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RwTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rwTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RwTransactionActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rwTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RwTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rwTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RwTransactionActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rwTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RwTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rwTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 106 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	Database db;
															#line 106 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	Reference<RWTransactor> self;
															#line 106 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	Stats* stats;
															#line 107 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	std::vector<Key> keys;
															#line 108 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	std::vector<Value> values;
															#line 109 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	Transaction tr;
															#line 119 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	double t_start;
															#line 121 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	double t_rv;
															#line 122 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	double rrLatency;
															#line 124 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	std::vector<Future<Optional<Value>>> reads;
															#line 131 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	double t_beforeCommit;
															#line 967 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
};
// This generated class is to be used only via rwTransaction()
															#line 106 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
class RwTransactionActor final : public Actor<Void>, public ActorCallback< RwTransactionActor, 0, Void >, public ActorCallback< RwTransactionActor, 1, Void >, public ActorCallback< RwTransactionActor, 2, Void >, public ActorCallback< RwTransactionActor, 3, Void >, public FastAllocated<RwTransactionActor>, public RwTransactionActorState<RwTransactionActor> {
															#line 972 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
public:
	using FastAllocated<RwTransactionActor>::operator new;
	using FastAllocated<RwTransactionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4399070010426351360UL, 1743983999396103424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RwTransactionActor, 0, Void >;
friend struct ActorCallback< RwTransactionActor, 1, Void >;
friend struct ActorCallback< RwTransactionActor, 2, Void >;
friend struct ActorCallback< RwTransactionActor, 3, Void >;
															#line 106 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	RwTransactionActor(Database const& db,Reference<RWTransactor> const& self,Stats* const& stats) 
															#line 992 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		 : Actor<Void>(),
		   RwTransactionActorState<RwTransactionActor>(db, self, stats),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rwTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2853720081497447168UL, 5633734644255401984UL);
		ActorExecutionContextHelper __helper(static_cast<RwTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rwTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rwTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RwTransactionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RwTransactionActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RwTransactionActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RwTransactionActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 106 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
[[nodiscard]] static Future<Void> rwTransaction( Database const& db, Reference<RWTransactor> const& self, Stats* const& stats ) {
															#line 106 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	return Future<Void>(new RwTransactionActor(db, self, stats));
															#line 1027 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
}

#line 149 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
};

struct ABTransactor : ITransactor {
	Reference<ITransactor> a, b;
	double alpha; // 0.0 = all a, 1.0 = all b

	ABTransactor(double alpha, Reference<ITransactor> a, Reference<ITransactor> b) : a(a), b(b), alpha(alpha) {}

	Future<Void> doTransaction(Database const& db, Stats* stats) override {
		return deterministicRandom()->random01() >= alpha ? a->doTransaction(db, stats) : b->doTransaction(db, stats);
	}
};

struct SweepTransactor : ITransactor {
	// Runs a linearly-changing workload that changes from A-type to B-type over
	//    the specified duration--the timer starts at the first transaction.
	Reference<ITransactor> a, b;
	double startTime;
	double startDelay;
	double duration;

	SweepTransactor(double duration, double startDelay, Reference<ITransactor> a, Reference<ITransactor> b)
	  : a(a), b(b), startTime(-1), startDelay(startDelay), duration(duration) {}

	Future<Void> doTransaction(Database const& db, Stats* stats) override {
		if (startTime == -1)
			startTime = now() + startDelay;

		double alpha;
		double n = now();
		if (n < startTime)
			alpha = 0;
		else if (n > startTime + duration)
			alpha = 1;
		else
			alpha = (n - startTime) / duration;

		return deterministicRandom()->random01() >= alpha ? a->doTransaction(db, stats) : b->doTransaction(db, stats);
	}
};

struct IMeasurer : ReferenceCounted<IMeasurer> {
	// This could be an ITransactor, but then it needs an actor to wait for the transaction to actually finish
	virtual Future<Void> start() { return Void(); }
	virtual void addTransaction(ITransactor::Stats* stats, double now) = 0;
	virtual void getMetrics(std::vector<PerfMetric>& m) = 0;
	IMeasurer& operator=(IMeasurer const&) {
		return *this;
	} // allow copy operator for non-reference counted instances of subclasses

	virtual ~IMeasurer() {}
};

struct MeasureSinglePeriod : IMeasurer {
	double delay, duration;
	double startT;

	DDSketch<double> totalLatency, grvLatency, rowReadLatency, commitLatency;
	ITransactor::Stats stats; // totalled over the period

	MeasureSinglePeriod(double delay, double duration)
	  : delay(delay), duration(duration), totalLatency(), grvLatency(), rowReadLatency(), commitLatency() {}

	Future<Void> start() override {
		startT = now();
		return Void();
	}
	void addTransaction(ITransactor::Stats* st, double now) override {
		if (!(now >= startT + delay && now < startT + delay + duration))
			return;

		totalLatency.addSample(st->totalLatency);
		grvLatency.addSample(st->grvLatency);
		rowReadLatency.addSample(st->rowReadLatency);

		if (st->commitLatency > 0) {
			commitLatency.addSample(st->commitLatency);
		}

		stats += *st;
	}
	void getMetrics(std::vector<PerfMetric>& m) override {
		double measureDuration = duration;
		m.emplace_back("Transactions/sec", stats.transactions / measureDuration, Averaged::False);
		m.emplace_back("Retries/sec", stats.retries / measureDuration, Averaged::False);
		m.emplace_back("Operations/sec", (stats.reads + stats.writes) / measureDuration, Averaged::False);
		m.emplace_back("Read rows/sec", stats.reads / measureDuration, Averaged::False);
		m.emplace_back("Write rows/sec", stats.writes / measureDuration, Averaged::False);

		m.emplace_back("Mean Latency (ms)", 1000 * totalLatency.mean(), Averaged::True);
		m.emplace_back("Median Latency (ms, averaged)", 1000 * totalLatency.median(), Averaged::True);
		m.emplace_back("90% Latency (ms, averaged)", 1000 * totalLatency.percentile(0.90), Averaged::True);
		m.emplace_back("98% Latency (ms, averaged)", 1000 * totalLatency.percentile(0.98), Averaged::True);

		m.emplace_back("Mean Row Read Latency (ms)", 1000 * rowReadLatency.mean(), Averaged::True);
		m.emplace_back("Median Row Read Latency (ms, averaged)", 1000 * rowReadLatency.median(), Averaged::True);
		m.emplace_back("Mean GRV Latency (ms)", 1000 * grvLatency.mean(), Averaged::True);
		m.emplace_back("Median GRV Latency (ms, averaged)", 1000 * grvLatency.median(), Averaged::True);
		m.emplace_back("Mean Commit Latency (ms)", 1000 * commitLatency.mean(), Averaged::True);
		m.emplace_back("Median Commit Latency (ms, averaged)", 1000 * commitLatency.median(), Averaged::True);
	}
};

struct MeasurePeriodically : IMeasurer {
	double period;
	std::set<std::string> includeMetrics;
	MeasureSinglePeriod msp, msp0;
	std::vector<PerfMetric> accumulatedMetrics;

	MeasurePeriodically(double period, std::set<std::string> includeMetrics)
	  : period(period), includeMetrics(includeMetrics), msp(0, period), msp0(0, period) {}

	Future<Void> start() override {
		msp.start();
		return periodicActor(this);
	}
	void addTransaction(ITransactor::Stats* st, double now) override { msp.addTransaction(st, now); }
	void getMetrics(std::vector<PerfMetric>& m) override {
		m.insert(m.end(), accumulatedMetrics.begin(), accumulatedMetrics.end());
	}
	void nextPeriod(double t) {
		// output stats
		std::string prefix = format("T=%04.0fs:", t);
		std::vector<PerfMetric> m;
		msp.getMetrics(m);
		for (auto i = m.begin(); i != m.end(); ++i)
			if (includeMetrics.contains(i->name())) {
				accumulatedMetrics.push_back(i->withPrefix(prefix));
			}

		// reset stats
		msp = msp0;
		msp.start();
	}

																#line 1166 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
// This generated class is to be used only via periodicActor()
															#line 284 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
template <class PeriodicActorActor>
															#line 284 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
class PeriodicActorActorState {
															#line 1172 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
public:
															#line 284 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	PeriodicActorActorState(MeasurePeriodically* const& self) 
															#line 284 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
															#line 284 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		 : self(self),
															#line 285 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		   startT(now()),
															#line 286 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		   elapsed(0)
															#line 1183 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
	{
		fdb_probe_actor_create("periodicActor", reinterpret_cast<unsigned long>(this));

	}
	~PeriodicActorActorState() 
	{
		fdb_probe_actor_destroy("periodicActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 287 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			;
															#line 1198 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PeriodicActorActorState();
		static_cast<PeriodicActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 288 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		elapsed += self->period;
															#line 289 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delayUntil(startT + elapsed);
															#line 289 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		if (static_cast<PeriodicActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1232 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<PeriodicActorActor*>(this)->actor_wait_state = 1;
															#line 289 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PeriodicActorActor, 0, Void >*>(static_cast<PeriodicActorActor*>(this)));
															#line 1237 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 290 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		self->nextPeriod(elapsed);
															#line 1246 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 290 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		self->nextPeriod(elapsed);
															#line 1255 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PeriodicActorActor*>(this)->actor_wait_state > 0) static_cast<PeriodicActorActor*>(this)->actor_wait_state = 0;
		static_cast<PeriodicActorActor*>(this)->ActorCallback< PeriodicActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PeriodicActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("periodicActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("periodicActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PeriodicActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("periodicActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("periodicActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PeriodicActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("periodicActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("periodicActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 284 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	MeasurePeriodically* self;
															#line 285 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	double startT;
															#line 286 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	double elapsed;
															#line 1341 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
};
// This generated class is to be used only via periodicActor()
															#line 284 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
class PeriodicActorActor final : public Actor<Void>, public ActorCallback< PeriodicActorActor, 0, Void >, public FastAllocated<PeriodicActorActor>, public PeriodicActorActorState<PeriodicActorActor> {
															#line 1346 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
public:
	using FastAllocated<PeriodicActorActor>::operator new;
	using FastAllocated<PeriodicActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1496269233335276288UL, 15808896610184583424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PeriodicActorActor, 0, Void >;
															#line 284 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	PeriodicActorActor(MeasurePeriodically* const& self) 
															#line 1363 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		 : Actor<Void>(),
		   PeriodicActorActorState<PeriodicActorActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("periodicActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12886730425996967680UL, 4184832608190916864UL);
		ActorExecutionContextHelper __helper(static_cast<PeriodicActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("periodicActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("periodicActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PeriodicActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 284 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
[[nodiscard]] static Future<Void> periodicActor( MeasurePeriodically* const& self ) {
															#line 284 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	return Future<Void>(new PeriodicActorActor(self));
															#line 1395 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
}

#line 293 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
};

struct MeasureMulti : IMeasurer {
	std::vector<Reference<IMeasurer>> ms;
	Future<Void> start() override {
		std::vector<Future<Void>> s;
		for (auto m = ms.begin(); m != ms.end(); ++m)
			s.push_back((*m)->start());
		return waitForAll(s);
	}
	void addTransaction(ITransactor::Stats* stats, double now) override {
		for (auto m = ms.begin(); m != ms.end(); ++m)
			(*m)->addTransaction(stats, now);
	}
	void getMetrics(std::vector<PerfMetric>& metrics) override {
		for (auto m = ms.begin(); m != ms.end(); ++m)
			(*m)->getMetrics(metrics);
	}
};

struct ThroughputWorkload : TestWorkload {
	static constexpr auto NAME = "Throughput";

	double targetLatency, testDuration, Pgain, Igain;
	Reference<ITransactor> op;
	Reference<IMeasurer> measurer;

	int activeActors;
	double totalLatencyIntegral, totalTransactionsIntegral, startT;

	ThroughputWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), activeActors(0), totalLatencyIntegral(0), totalTransactionsIntegral(0) {
		auto multi = makeReference<MeasureMulti>();
		measurer = multi;

		targetLatency = getOption(options, "targetLatency"_sr, 0.05);

		int keyCount = getOption(options, "nodeCount"_sr, (uint64_t)100000);
		int keyBytes = std::max(getOption(options, "keyBytes"_sr, 16), 16);
		int maxValueBytes = getOption(options, "valueBytes"_sr, 100);
		int minValueBytes = getOption(options, "minValueBytes"_sr, maxValueBytes);
		double sweepDuration = getOption(options, "sweepDuration"_sr, 0);
		double sweepDelay = getOption(options, "sweepDelay"_sr, 0);
		double zeroPaddingRatio = getOption(options, "zeroPaddingRatio"_sr, 0.15);

		auto AType = Reference<ITransactor>(new RWTransactor(getOption(options, "readsPerTransactionA"_sr, 10),
		                                                     getOption(options, "writesPerTransactionA"_sr, 0),
		                                                     keyCount,
		                                                     keyBytes,
		                                                     minValueBytes,
		                                                     maxValueBytes,
		                                                     zeroPaddingRatio));
		auto BType = Reference<ITransactor>(new RWTransactor(getOption(options, "readsPerTransactionB"_sr, 5),
		                                                     getOption(options, "writesPerTransactionB"_sr, 5),
		                                                     keyCount,
		                                                     keyBytes,
		                                                     minValueBytes,
		                                                     maxValueBytes,
		                                                     zeroPaddingRatio));

		if (sweepDuration > 0) {
			op = Reference<ITransactor>(new SweepTransactor(sweepDuration, sweepDelay, AType, BType));
		} else {
			op = Reference<ITransactor>(new ABTransactor(getOption(options, "alpha"_sr, 0.1), AType, BType));
		}

		double measureDelay = getOption(options, "measureDelay"_sr, 50.0);
		double measureDuration = getOption(options, "measureDuration"_sr, 10.0);
		multi->ms.push_back(Reference<IMeasurer>(new MeasureSinglePeriod(measureDelay, measureDuration)));

		double measurePeriod = getOption(options, "measurePeriod"_sr, 0.0);
		std::vector<std::string> periodicMetrics =
		    getOption(options, "measurePeriodicMetrics"_sr, std::vector<std::string>());
		if (measurePeriod) {
			ASSERT(periodicMetrics.size() != 0);
			multi->ms.push_back(Reference<IMeasurer>(new MeasurePeriodically(
			    measurePeriod, std::set<std::string>(periodicMetrics.begin(), periodicMetrics.end()))));
		}

		Pgain = getOption(options, "ProportionalGain"_sr, 0.1);
		Igain = getOption(options, "IntegralGain"_sr, 0.005);

		testDuration = measureDelay + measureDuration;
		// testDuration = getOption( options, "testDuration"_sr, measureDelay + measureDuration );
	}

	Future<Void> setup(Database const& cx) override {
		return Void(); // No setup for now - use a separate workload to do setup
	}

	Future<Void> start(Database const& cx) override {
		startT = now();
		PromiseStream<Future<Void>> add;
		Future<Void> ac = actorCollection(add.getFuture(), &activeActors);
		Future<Void> r = timeout(measurer->start() && ac, testDuration, Void());
		ASSERT(!ac.isReady()); // ... because else the following line would create an unbreakable reference cycle
		add.send(throughputActor(cx, this, add));
		return r;
	}

	Future<bool> check(Database const& cx) override { return true; }

																#line 1501 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
// This generated class is to be used only via throughputActor()
															#line 395 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
template <class ThroughputActorActor>
															#line 395 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
class ThroughputActorActorState {
															#line 1507 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
public:
															#line 395 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	ThroughputActorActorState(Database const& db,ThroughputWorkload* const& self,PromiseStream<Future<Void>> const& add) 
															#line 395 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
															#line 395 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		 : db(db),
															#line 395 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		   self(self),
															#line 395 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		   add(add),
															#line 396 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		   before(now()),
															#line 397 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		   stats()
															#line 1522 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
	{
		fdb_probe_actor_create("throughputActor", reinterpret_cast<unsigned long>(this));

	}
	~ThroughputActorActorState() 
	{
		fdb_probe_actor_destroy("throughputActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 398 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->op->doTransaction(db, &stats);
															#line 398 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			if (static_cast<ThroughputActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1539 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ThroughputActorActor*>(this)->actor_wait_state = 1;
															#line 398 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ThroughputActorActor, 0, Void >*>(static_cast<ThroughputActorActor*>(this)));
															#line 1544 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ThroughputActorActorState();
		static_cast<ThroughputActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 399 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		after = now();
															#line 401 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.0);
															#line 401 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		if (static_cast<ThroughputActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1571 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ThroughputActorActor*>(this)->actor_wait_state = 2;
															#line 401 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ThroughputActorActor, 1, Void >*>(static_cast<ThroughputActorActor*>(this)));
															#line 1576 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 399 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		after = now();
															#line 401 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.0);
															#line 401 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		if (static_cast<ThroughputActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1589 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ThroughputActorActor*>(this)->actor_wait_state = 2;
															#line 401 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ThroughputActorActor, 1, Void >*>(static_cast<ThroughputActorActor*>(this)));
															#line 1594 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ThroughputActorActor*>(this)->actor_wait_state > 0) static_cast<ThroughputActorActor*>(this)->actor_wait_state = 0;
		static_cast<ThroughputActorActor*>(this)->ActorCallback< ThroughputActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ThroughputActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("throughputActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThroughputActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throughputActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ThroughputActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("throughputActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThroughputActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throughputActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ThroughputActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("throughputActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ThroughputActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throughputActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 402 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		stats.totalLatency = after - before;
															#line 403 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		self->measurer->addTransaction(&stats, after);
															#line 405 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		self->totalLatencyIntegral += after - before;
															#line 406 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		self->totalTransactionsIntegral += 1;
															#line 408 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		double error = after - before - self->targetLatency;
															#line 411 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		double ierror = (self->totalLatencyIntegral - self->totalTransactionsIntegral * self->targetLatency) / self->totalTransactionsIntegral * (after - self->startT);
															#line 414 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		double desiredSuccessors = 1 - (error * self->Pgain + ierror * self->Igain) / self->targetLatency;
															#line 420 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		desiredSuccessors = std::min(desiredSuccessors, 2.0);
															#line 424 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		int successors = deterministicRandom()->random01() + desiredSuccessors;
															#line 425 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		if (successors < 1 && self->activeActors <= 1)
															#line 1696 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		{
															#line 426 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			successors = 1;
															#line 1700 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		}
															#line 427 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		if (successors > 1 && self->activeActors >= 200000)
															#line 1704 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		{
															#line 428 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			successors = 1;
															#line 1708 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		}
															#line 429 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		for(int s = 0;s < successors;s++) {
															#line 430 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			add.send(throughputActor(db, self, add));
															#line 1714 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		}
															#line 431 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		if (!static_cast<ThroughputActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ThroughputActorActorState(); static_cast<ThroughputActorActor*>(this)->destroy(); return 0; }
															#line 1718 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		new (&static_cast<ThroughputActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ThroughputActorActorState();
		static_cast<ThroughputActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 402 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		stats.totalLatency = after - before;
															#line 403 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		self->measurer->addTransaction(&stats, after);
															#line 405 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		self->totalLatencyIntegral += after - before;
															#line 406 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		self->totalTransactionsIntegral += 1;
															#line 408 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		double error = after - before - self->targetLatency;
															#line 411 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		double ierror = (self->totalLatencyIntegral - self->totalTransactionsIntegral * self->targetLatency) / self->totalTransactionsIntegral * (after - self->startT);
															#line 414 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		double desiredSuccessors = 1 - (error * self->Pgain + ierror * self->Igain) / self->targetLatency;
															#line 420 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		desiredSuccessors = std::min(desiredSuccessors, 2.0);
															#line 424 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		int successors = deterministicRandom()->random01() + desiredSuccessors;
															#line 425 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		if (successors < 1 && self->activeActors <= 1)
															#line 1748 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		{
															#line 426 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			successors = 1;
															#line 1752 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		}
															#line 427 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		if (successors > 1 && self->activeActors >= 200000)
															#line 1756 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		{
															#line 428 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			successors = 1;
															#line 1760 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		}
															#line 429 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		for(int s = 0;s < successors;s++) {
															#line 430 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
			add.send(throughputActor(db, self, add));
															#line 1766 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		}
															#line 431 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
		if (!static_cast<ThroughputActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ThroughputActorActorState(); static_cast<ThroughputActorActor*>(this)->destroy(); return 0; }
															#line 1770 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		new (&static_cast<ThroughputActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ThroughputActorActorState();
		static_cast<ThroughputActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ThroughputActorActor*>(this)->actor_wait_state > 0) static_cast<ThroughputActorActor*>(this)->actor_wait_state = 0;
		static_cast<ThroughputActorActor*>(this)->ActorCallback< ThroughputActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ThroughputActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("throughputActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThroughputActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throughputActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ThroughputActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("throughputActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThroughputActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throughputActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ThroughputActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("throughputActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ThroughputActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throughputActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 395 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	Database db;
															#line 395 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	ThroughputWorkload* self;
															#line 395 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	PromiseStream<Future<Void>> add;
															#line 396 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	double before;
															#line 397 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	ITransactor::Stats stats;
															#line 399 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	double after;
															#line 1865 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
};
// This generated class is to be used only via throughputActor()
															#line 395 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
class ThroughputActorActor final : public Actor<Void>, public ActorCallback< ThroughputActorActor, 0, Void >, public ActorCallback< ThroughputActorActor, 1, Void >, public FastAllocated<ThroughputActorActor>, public ThroughputActorActorState<ThroughputActorActor> {
															#line 1870 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
public:
	using FastAllocated<ThroughputActorActor>::operator new;
	using FastAllocated<ThroughputActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1306384427329777664UL, 13063963080940029184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ThroughputActorActor, 0, Void >;
friend struct ActorCallback< ThroughputActorActor, 1, Void >;
															#line 395 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	ThroughputActorActor(Database const& db,ThroughputWorkload* const& self,PromiseStream<Future<Void>> const& add) 
															#line 1888 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
		 : Actor<Void>(),
		   ThroughputActorActorState<ThroughputActorActor>(db, self, add),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("throughputActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13275353383824699904UL, 4544161923322073856UL);
		ActorExecutionContextHelper __helper(static_cast<ThroughputActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("throughputActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("throughputActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ThroughputActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ThroughputActorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 395 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
[[nodiscard]] static Future<Void> throughputActor( Database const& db, ThroughputWorkload* const& self, PromiseStream<Future<Void>> const& add ) {
															#line 395 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"
	return Future<Void>(new ThroughputActorActor(db, self, add));
															#line 1921 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Throughput.actor.g.cpp"
}

#line 433 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/Throughput.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override { measurer->getMetrics(m); }
};
WorkloadFactory<ThroughputWorkload> ThroughputWorkloadFactory;
