#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
/*
 *PhysicalShardMove.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/IKeyValueStore.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/ServerCheckpoint.actor.h"
#include "fdbserver/MoveKeys.actor.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/flow.h"
#include <cstdint>
#include <limits>

#include "flow/actorcompiler.h" // This must be the last #include.

namespace {
std::string printValue(const ErrorOr<Optional<Value>>& value) {
	if (value.isError()) {
		return value.getError().name();
	}
	return value.get().present() ? value.get().get().toString() : "Value Not Found.";
}
} // namespace

struct SSCheckpointRestoreWorkload : TestWorkload {
	static constexpr auto NAME = "SSCheckpointRestoreWorkload";
	const bool enabled;
	bool pass;

	SSCheckpointRestoreWorkload(WorkloadContext const& wcx) : TestWorkload(wcx), enabled(!clientId), pass(true) {}

	void validationFailed(ErrorOr<Optional<Value>> expectedValue, ErrorOr<Optional<Value>> actualValue) {
		TraceEvent(SevError, "TestFailed")
		    .detail("ExpectedValue", printValue(expectedValue))
		    .detail("ActualValue", printValue(actualValue));
		pass = false;
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (!enabled) {
			return Void();
		}
		return _start(this, cx);
	}

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert("RandomMoveKeys");
		out.insert("Attrition");
	}

																#line 77 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 75 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
template <class _startActor>
															#line 75 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
class _startActorState {
															#line 83 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
public:
															#line 75 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	_startActorState(SSCheckpointRestoreWorkload* const& self,Database const& cx) 
															#line 75 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
															#line 75 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		 : self(self),
															#line 75 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		   cx(cx),
															#line 76 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		   key("TestKey"_sr),
															#line 77 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		   endKey("TestKey0"_sr),
															#line 78 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		   oldValue("TestValue"_sr),
															#line 79 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		   testRange(KeyRangeRef(key, endKey)),
															#line 80 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		   records()
															#line 102 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 82 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			TraceEvent("TestCheckpointRestoreBegin");
															#line 83 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(setDDMode(cx, 0));
															#line 83 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 121 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 83 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 126 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 84 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		StrictFuture<Version> __when_expr_1 = self->writeAndVerify(self, cx, key, oldValue);
															#line 84 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 151 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 84 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Version >*>(static_cast<_startActor*>(this)));
															#line 156 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 84 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		StrictFuture<Version> __when_expr_1 = self->writeAndVerify(self, cx, key, oldValue);
															#line 84 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 167 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 84 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Version >*>(static_cast<_startActor*>(this)));
															#line 172 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 86 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		TraceEvent("TestCreatingCheckpoint").detail("Range", testRange);
															#line 88 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		tr = Transaction(cx);
															#line 89 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		format = DataMoveRocksCF;
															#line 90 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		dataMoveId = newDataMoveId(deterministicRandom()->randomUInt64(), AssignEmptyRange(false), deterministicRandom()->random01() < SERVER_KNOBS->DD_PHYSICAL_SHARD_MOVE_PROBABILITY ? DataMoveType::PHYSICAL : DataMoveType::LOGICAL, DataMovementReason::TEAM_HEALTHY, UnassignShard(false));
															#line 98 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		;
															#line 264 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Version const& __version,int loopDepth) 
	{
															#line 84 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		version = __version;
															#line 273 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Version && __version,int loopDepth) 
	{
		version = std::move(__version);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 111 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		TraceEvent("TestCheckpointCreated") .detail("Range", testRange) .detail("Version", version) .detail("DataMoveID", dataMoveId);
															#line 117 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		;
															#line 354 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 100 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 101 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 102 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			StrictFuture<Void> __when_expr_2 = createCheckpoint(&tr, { testRange }, format, dataMoveId);
															#line 102 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 377 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 102 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 382 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 107 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 107 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 419 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 107 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 424 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 103 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr.commit();
															#line 103 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 441 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 103 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 446 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 103 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr.commit();
															#line 103 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 457 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 103 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 462 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		version = tr.getCommittedVersion();
															#line 546 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		version = tr.getCommittedVersion();
															#line 555 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 134 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		TraceEvent("TestCheckpointFetched").detail("Range", testRange).detail("Version", version);
															#line 136 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		pwd = platform::getWorkingDirectory();
															#line 137 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		folder = pwd + "/checkpoints";
															#line 138 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		platform::eraseDirectoryRecursive(folder);
															#line 139 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		ASSERT(platform::createDirectory(folder));
															#line 142 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		fetchedCheckpoints = std::vector<CheckpointMetaData>();
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		it = records.begin();
															#line 144 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		;
															#line 740 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 118 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		records.clear();
															#line 756 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		try {
															#line 120 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			StrictFuture<Void> __when_expr_5 = store(records, getCheckpointMetaData(cx, { testRange }, version, format, Optional<UID>(dataMoveId)));
															#line 120 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 762 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont3loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont3loopBody1when1(__when_expr_5.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 120 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 767 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 124 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			TraceEvent("TestFetchCheckpointMetadataError") .errorUnsuppressed(e) .detail("Range", testRange) .detail("Version", version);
															#line 130 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			ASSERT(e.code() != error_code_checkpoint_not_found);
															#line 804 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = a_body1cont3loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 161 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		rocksDBTestDir = "rocksdb-kvstore-test-db";
															#line 162 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		platform::eraseDirectoryRecursive(rocksDBTestDir);
															#line 165 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		kvStore = keyValueStoreRocksDB( rocksDBTestDir, deterministicRandom()->randomUniqueID(), KeyValueStoreType::SSD_ROCKSDB_V1);
															#line 167 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		StrictFuture<Void> __when_expr_8 = kvStore->init();
															#line 167 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 914 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont5when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 167 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 919 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 144 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		if (!(it != records.end()))
															#line 935 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 145 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		;
															#line 941 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
															#line 144 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		++it;
															#line 963 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1(int loopDepth) 
	{
															#line 146 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		TraceEvent("TestFetchingCheckpoint").detail("Checkpoint", it->second.toString());
															#line 979 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		try {
															#line 148 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			StrictFuture<CheckpointMetaData> __when_expr_6 = fetchCheckpoint(cx, it->second, folder);
															#line 148 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont4loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 985 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont4loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont4loopBody1loopBody1when1(__when_expr_6.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 148 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, CheckpointMetaData >*>(static_cast<_startActor*>(this)));
															#line 990 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont4loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont4loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont4loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 153 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			TraceEvent("TestFetchCheckpointError") .errorUnsuppressed(e) .detail("Checkpoint", it->second.toString());
															#line 156 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			StrictFuture<Void> __when_expr_7 = delay(1);
															#line 156 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1029 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1cont4loopBody1loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 156 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 1034 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 149 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		fetchedCheckpoints.push_back(record);
															#line 150 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		TraceEvent("TestCheckpointFetched").detail("Checkpoint", record.toString());
															#line 1051 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		return a_body1cont4loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1when1(CheckpointMetaData const& __record,int loopDepth) 
	{
															#line 148 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		record = __record;
															#line 1060 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1when1(CheckpointMetaData && __record,int loopDepth) 
	{
		record = std::move(__record);
		loopDepth = a_body1cont4loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, CheckpointMetaData >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, CheckpointMetaData >*,CheckpointMetaData const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, CheckpointMetaData >*,CheckpointMetaData && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, CheckpointMetaData >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont4loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont4loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont4loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		try {
															#line 169 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			StrictFuture<Void> __when_expr_9 = kvStore->restore(fetchedCheckpoints);
															#line 169 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont6Catch1(actor_cancelled(), loopDepth);
															#line 1229 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont6Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont6when1(__when_expr_9.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 169 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 1234 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont6Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		try {
															#line 169 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			StrictFuture<Void> __when_expr_9 = kvStore->restore(fetchedCheckpoints);
															#line 169 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont6Catch1(actor_cancelled(), loopDepth);
															#line 1252 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont6Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont6when1(__when_expr_9.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 169 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 1257 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont6Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 176 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		tr.reset();
															#line 177 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		res = RangeResult();
															#line 178 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		;
															#line 1351 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		loopDepth = a_body1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 171 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			TraceEvent(SevError, "TestRestoreCheckpointError").errorUnsuppressed(e);
															#line 1361 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont6Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
															#line 188 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		StrictFuture<RangeResult> __when_expr_12 = kvStore->readRange(testRange);
															#line 188 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1478 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont10when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 188 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 1483 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1(int loopDepth) 
	{
		try {
															#line 180 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 181 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			StrictFuture<Void> __when_expr_10 = store(res, tr.getRange(KeyRangeRef(key, endKey), CLIENT_KNOBS->TOO_MANY));
															#line 181 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont7loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1504 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont7loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont7loopBody1when1(__when_expr_10.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 181 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 1509 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7break1(int loopDepth) 
	{
		try {
			return a_body1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 184 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			StrictFuture<Void> __when_expr_11 = tr.onError(e);
															#line 184 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1546 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1Catch1when1(__when_expr_11.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 184 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 1551 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont7break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont7loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont7break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont7loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont7loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont7loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont7loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont10cont1(RangeResult const& kvRange,int loopDepth) 
	{
															#line 189 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		ASSERT(res.size() == kvRange.size());
															#line 190 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		for(int i = 0;i < res.size();++i) {
															#line 191 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			ASSERT(res[i] == kvRange[i]);
															#line 1744 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		}
															#line 194 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		Future<Void> close = kvStore->onClosed();
															#line 195 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		kvStore->dispose();
															#line 196 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		StrictFuture<Void> __when_expr_13 = close;
															#line 196 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1754 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_13.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 196 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 1759 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1(RangeResult && kvRange,int loopDepth) 
	{
															#line 189 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		ASSERT(res.size() == kvRange.size());
															#line 190 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		for(int i = 0;i < res.size();++i) {
															#line 191 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			ASSERT(res[i] == kvRange[i]);
															#line 1772 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		}
															#line 194 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		Future<Void> close = kvStore->onClosed();
															#line 195 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		kvStore->dispose();
															#line 196 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		StrictFuture<Void> __when_expr_13 = close;
															#line 196 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1782 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_13.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 196 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 1787 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10when1(RangeResult const& kvRange,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(kvRange, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(RangeResult && kvRange,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(kvRange), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 12, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 12, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _startActor, 12, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _startActor, 12, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont10cont2(Void const& _,int loopDepth) 
	{
		{
															#line 199 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			StrictFuture<int> __when_expr_14 = setDDMode(cx, 1);
															#line 199 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1874 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont10cont2when1(__when_expr_14.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 199 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, int >*>(static_cast<_startActor*>(this)));
															#line 1879 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont2(Void && _,int loopDepth) 
	{
		{
															#line 199 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			StrictFuture<int> __when_expr_14 = setDDMode(cx, 1);
															#line 199 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1892 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont10cont2when1(__when_expr_14.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 199 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, int >*>(static_cast<_startActor*>(this)));
															#line 1897 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _startActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont10cont4(int loopDepth) 
	{
															#line 202 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1982 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont5(int const& ignore,int loopDepth) 
	{
															#line 200 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		(void)ignore;
															#line 1994 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		loopDepth = a_body1cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont5(int && ignore,int loopDepth) 
	{
															#line 200 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		(void)ignore;
															#line 2003 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		loopDepth = a_body1cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2when1(int const& ignore,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(ignore, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2when1(int && ignore,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(std::move(ignore), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 14, int >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 14, int >*,int const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< _startActor, 14, int >*,int && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< _startActor, 14, int >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
															#line 75 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	SSCheckpointRestoreWorkload* self;
															#line 75 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	Database cx;
															#line 76 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	Key key;
															#line 77 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	Key endKey;
															#line 78 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	Value oldValue;
															#line 79 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	KeyRange testRange;
															#line 80 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	std::vector<std::pair<KeyRange, CheckpointMetaData>> records;
															#line 84 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	Version version;
															#line 88 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	Transaction tr;
															#line 89 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	CheckpointFormat format;
															#line 90 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	UID dataMoveId;
															#line 136 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	std::string pwd;
															#line 137 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	std::string folder;
															#line 142 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	std::vector<CheckpointMetaData> fetchedCheckpoints;
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	std::vector<std::pair<KeyRange, CheckpointMetaData>>::iterator it;
															#line 148 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	CheckpointMetaData record;
															#line 161 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	std::string rocksDBTestDir;
															#line 165 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	IKeyValueStore* kvStore;
															#line 177 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	RangeResult res;
															#line 2121 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 75 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Version >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, CheckpointMetaData >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, Void >, public ActorCallback< _startActor, 10, Void >, public ActorCallback< _startActor, 11, Void >, public ActorCallback< _startActor, 12, RangeResult >, public ActorCallback< _startActor, 13, Void >, public ActorCallback< _startActor, 14, int >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 2126 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7925466936301327872UL, 5269721185044577792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Version >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, CheckpointMetaData >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, Void >;
friend struct ActorCallback< _startActor, 10, Void >;
friend struct ActorCallback< _startActor, 11, Void >;
friend struct ActorCallback< _startActor, 12, RangeResult >;
friend struct ActorCallback< _startActor, 13, Void >;
friend struct ActorCallback< _startActor, 14, int >;
															#line 75 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	_startActor(SSCheckpointRestoreWorkload* const& self,Database const& cx) 
															#line 2157 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, CheckpointMetaData >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _startActor, 12, RangeResult >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _startActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< _startActor, 14, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 75 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
[[nodiscard]] Future<Void> _start( SSCheckpointRestoreWorkload* const& self, Database const& cx ) {
															#line 75 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 2203 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
}

#line 204 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"

																#line 2208 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
// This generated class is to be used only via readAndVerify()
															#line 205 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
template <class ReadAndVerifyActor>
															#line 205 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
class ReadAndVerifyActorState {
															#line 2214 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
public:
															#line 205 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	ReadAndVerifyActorState(SSCheckpointRestoreWorkload* const& self,Database const& cx,Key const& key,ErrorOr<Optional<Value>> const& expectedValue) 
															#line 205 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
															#line 205 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		 : self(self),
															#line 205 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		   cx(cx),
															#line 205 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		   key(key),
															#line 205 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		   expectedValue(expectedValue),
															#line 209 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		   tr(cx)
															#line 2229 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
	{
		fdb_probe_actor_create("readAndVerify", reinterpret_cast<unsigned long>(this));

	}
	~ReadAndVerifyActorState() 
	{
		fdb_probe_actor_destroy("readAndVerify", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 211 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			;
															#line 2244 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadAndVerifyActorState();
		static_cast<ReadAndVerifyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 227 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		if (!static_cast<ReadAndVerifyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadAndVerifyActorState(); static_cast<ReadAndVerifyActor*>(this)->destroy(); return 0; }
															#line 2267 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		new (&static_cast<ReadAndVerifyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadAndVerifyActorState();
		static_cast<ReadAndVerifyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 213 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = timeoutError(tr.get(key), 30.0);
															#line 213 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			if (static_cast<ReadAndVerifyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2289 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadAndVerifyActor*>(this)->actor_wait_state = 1;
															#line 213 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadAndVerifyActor, 0, Optional<Value> >*>(static_cast<ReadAndVerifyActor*>(this)));
															#line 2294 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 220 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			if (expectedValue.isError() && expectedValue.getError().code() == e.code())
															#line 2329 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 223 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 223 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			if (static_cast<ReadAndVerifyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2337 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadAndVerifyActor*>(this)->actor_wait_state = 2;
															#line 223 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadAndVerifyActor, 1, Void >*>(static_cast<ReadAndVerifyActor*>(this)));
															#line 2342 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 214 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		const bool equal = !expectedValue.isError() && res == expectedValue.get();
															#line 215 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		if (!equal)
															#line 2359 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		{
															#line 216 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			self->validationFailed(expectedValue, ErrorOr<Optional<Value>>(res));
															#line 2363 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& __res,int loopDepth) 
	{
															#line 213 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		res = __res;
															#line 2373 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && __res,int loopDepth) 
	{
		res = std::move(__res);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadAndVerifyActor*>(this)->actor_wait_state > 0) static_cast<ReadAndVerifyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadAndVerifyActor*>(this)->ActorCallback< ReadAndVerifyActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadAndVerifyActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadAndVerifyActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadAndVerifyActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadAndVerifyActor*>(this)->actor_wait_state > 0) static_cast<ReadAndVerifyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadAndVerifyActor*>(this)->ActorCallback< ReadAndVerifyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadAndVerifyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadAndVerifyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadAndVerifyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 205 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	SSCheckpointRestoreWorkload* self;
															#line 205 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	Database cx;
															#line 205 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	Key key;
															#line 205 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	ErrorOr<Optional<Value>> expectedValue;
															#line 209 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	Transaction tr;
															#line 213 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	Optional<Value> res;
															#line 2547 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
};
// This generated class is to be used only via readAndVerify()
															#line 205 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
class ReadAndVerifyActor final : public Actor<Void>, public ActorCallback< ReadAndVerifyActor, 0, Optional<Value> >, public ActorCallback< ReadAndVerifyActor, 1, Void >, public FastAllocated<ReadAndVerifyActor>, public ReadAndVerifyActorState<ReadAndVerifyActor> {
															#line 2552 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
public:
	using FastAllocated<ReadAndVerifyActor>::operator new;
	using FastAllocated<ReadAndVerifyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7733932348758070528UL, 15375468830597787136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadAndVerifyActor, 0, Optional<Value> >;
friend struct ActorCallback< ReadAndVerifyActor, 1, Void >;
															#line 205 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	ReadAndVerifyActor(SSCheckpointRestoreWorkload* const& self,Database const& cx,Key const& key,ErrorOr<Optional<Value>> const& expectedValue) 
															#line 2570 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		 : Actor<Void>(),
		   ReadAndVerifyActorState<ReadAndVerifyActor>(self, cx, key, expectedValue),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3184544065301379584UL, 344653789742809600UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readAndVerify");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadAndVerifyActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadAndVerifyActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 205 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
[[nodiscard]] Future<Void> readAndVerify( SSCheckpointRestoreWorkload* const& self, Database const& cx, Key const& key, ErrorOr<Optional<Value>> const& expectedValue ) {
															#line 205 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	return Future<Void>(new ReadAndVerifyActor(self, cx, key, expectedValue));
															#line 2603 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
}

#line 229 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"

																#line 2608 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
// This generated class is to be used only via writeAndVerify()
															#line 230 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
template <class WriteAndVerifyActor>
															#line 230 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
class WriteAndVerifyActorState {
															#line 2614 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
public:
															#line 230 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	WriteAndVerifyActorState(SSCheckpointRestoreWorkload* const& self,Database const& cx,Key const& key,Optional<Value> const& value) 
															#line 230 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
															#line 230 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		 : self(self),
															#line 230 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		   cx(cx),
															#line 230 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		   key(key),
															#line 230 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		   value(value),
															#line 234 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		   tr(cx),
															#line 235 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		   version()
															#line 2631 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
	{
		fdb_probe_actor_create("writeAndVerify", reinterpret_cast<unsigned long>(this));

	}
	~WriteAndVerifyActorState() 
	{
		fdb_probe_actor_destroy("writeAndVerify", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 236 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			;
															#line 2646 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteAndVerifyActorState();
		static_cast<WriteAndVerifyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 251 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->readAndVerify(self, cx, key, value);
															#line 251 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		if (static_cast<WriteAndVerifyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2671 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteAndVerifyActor*>(this)->actor_wait_state = 3;
															#line 251 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyActor, 2, Void >*>(static_cast<WriteAndVerifyActor*>(this)));
															#line 2676 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 238 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			if (value.present())
															#line 2693 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			{
															#line 239 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
				tr.set(key, value.get());
															#line 2697 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			}
			else
			{
															#line 241 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
				tr.clear(key);
															#line 2703 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			}
															#line 243 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeoutError(tr.commit(), 30.0);
															#line 243 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			if (static_cast<WriteAndVerifyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2709 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteAndVerifyActor*>(this)->actor_wait_state = 1;
															#line 243 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyActor, 0, Void >*>(static_cast<WriteAndVerifyActor*>(this)));
															#line 2714 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 247 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 247 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			if (static_cast<WriteAndVerifyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2751 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WriteAndVerifyActor*>(this)->actor_wait_state = 2;
															#line 247 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyActor, 1, Void >*>(static_cast<WriteAndVerifyActor*>(this)));
															#line 2756 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 244 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		version = tr.getCommittedVersion();
															#line 2771 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 244 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		version = tr.getCommittedVersion();
															#line 2780 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteAndVerifyActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyActor*>(this)->ActorCallback< WriteAndVerifyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteAndVerifyActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyActor*>(this)->ActorCallback< WriteAndVerifyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 253 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		if (!static_cast<WriteAndVerifyActor*>(this)->SAV<Version>::futures) { (void)(version); this->~WriteAndVerifyActorState(); static_cast<WriteAndVerifyActor*>(this)->destroy(); return 0; }
															#line 2951 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		new (&static_cast<WriteAndVerifyActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~WriteAndVerifyActorState();
		static_cast<WriteAndVerifyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 253 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
		if (!static_cast<WriteAndVerifyActor*>(this)->SAV<Version>::futures) { (void)(version); this->~WriteAndVerifyActorState(); static_cast<WriteAndVerifyActor*>(this)->destroy(); return 0; }
															#line 2963 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		new (&static_cast<WriteAndVerifyActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~WriteAndVerifyActorState();
		static_cast<WriteAndVerifyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteAndVerifyActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyActor*>(this)->ActorCallback< WriteAndVerifyActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 230 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	SSCheckpointRestoreWorkload* self;
															#line 230 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	Database cx;
															#line 230 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	Key key;
															#line 230 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	Optional<Value> value;
															#line 234 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	Transaction tr;
															#line 235 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	Version version;
															#line 3058 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
};
// This generated class is to be used only via writeAndVerify()
															#line 230 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
class WriteAndVerifyActor final : public Actor<Version>, public ActorCallback< WriteAndVerifyActor, 0, Void >, public ActorCallback< WriteAndVerifyActor, 1, Void >, public ActorCallback< WriteAndVerifyActor, 2, Void >, public FastAllocated<WriteAndVerifyActor>, public WriteAndVerifyActorState<WriteAndVerifyActor> {
															#line 3063 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
public:
	using FastAllocated<WriteAndVerifyActor>::operator new;
	using FastAllocated<WriteAndVerifyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(921575537034792192UL, 2510996509458112256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteAndVerifyActor, 0, Void >;
friend struct ActorCallback< WriteAndVerifyActor, 1, Void >;
friend struct ActorCallback< WriteAndVerifyActor, 2, Void >;
															#line 230 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	WriteAndVerifyActor(SSCheckpointRestoreWorkload* const& self,Database const& cx,Key const& key,Optional<Value> const& value) 
															#line 3082 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
		 : Actor<Version>(),
		   WriteAndVerifyActorState<WriteAndVerifyActor>(self, cx, key, value),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3594513465819686400UL, 13554697269594140416UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeAndVerify");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteAndVerifyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteAndVerifyActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteAndVerifyActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 230 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
[[nodiscard]] Future<Version> writeAndVerify( SSCheckpointRestoreWorkload* const& self, Database const& cx, Key const& key, Optional<Value> const& value ) {
															#line 230 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"
	return Future<Version>(new WriteAndVerifyActor(self, cx, key, value));
															#line 3116 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.g.cpp"
}

#line 255 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/StorageServerCheckpointRestoreTest.actor.cpp"

	Future<bool> check(Database const& cx) override { return pass; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<SSCheckpointRestoreWorkload> SSCheckpointRestoreWorkloadFactory;