#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
/*
 * LocalRatekeeper.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBTypes.h"
#include "fdbserver/workloads/workloads.actor.h"
#include <fdbserver/Knobs.h>
#include <flow/actorcompiler.h>

namespace {

															#line 30 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
// This generated class is to be used only via getRandomStorage()
															#line 28 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
template <class GetRandomStorageActor>
															#line 28 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
class GetRandomStorageActorState {
															#line 36 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
public:
															#line 28 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	GetRandomStorageActorState(Database const& cx) 
															#line 28 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
															#line 28 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		 : cx(cx),
															#line 29 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		   tr(cx)
															#line 45 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
	{
		fdb_probe_actor_create("getRandomStorage", reinterpret_cast<unsigned long>(this));

	}
	~GetRandomStorageActorState() 
	{
		fdb_probe_actor_destroy("getRandomStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 30 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			;
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRandomStorageActorState();
		static_cast<GetRandomStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 32 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			tr.reset();
															#line 33 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 34 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 34 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			if (static_cast<GetRandomStorageActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 97 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetRandomStorageActor*>(this)->actor_wait_state = 1;
															#line 34 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRandomStorageActor, 0, RangeResult >*>(static_cast<GetRandomStorageActor*>(this)));
															#line 102 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 42 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 42 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			if (static_cast<GetRandomStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 126 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetRandomStorageActor*>(this)->actor_wait_state = 3;
															#line 42 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRandomStorageActor, 2, Void >*>(static_cast<GetRandomStorageActor*>(this)));
															#line 131 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& range,int loopDepth) 
	{
															#line 35 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		if (range.size() > 0)
															#line 146 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		{
															#line 36 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			auto idx = deterministicRandom()->randomInt(0, range.size());
															#line 37 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			if (!static_cast<GetRandomStorageActor*>(this)->SAV<StorageServerInterface>::futures) { (void)(decodeServerListValue(range[idx].value)); this->~GetRandomStorageActorState(); static_cast<GetRandomStorageActor*>(this)->destroy(); return 0; }
															#line 152 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			new (&static_cast<GetRandomStorageActor*>(this)->SAV< StorageServerInterface >::value()) StorageServerInterface(decodeServerListValue(range[idx].value));
			this->~GetRandomStorageActorState();
			static_cast<GetRandomStorageActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 39 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 39 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			if (static_cast<GetRandomStorageActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 164 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetRandomStorageActor*>(this)->actor_wait_state = 2;
															#line 39 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRandomStorageActor, 1, Void >*>(static_cast<GetRandomStorageActor*>(this)));
															#line 169 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && range,int loopDepth) 
	{
															#line 35 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		if (range.size() > 0)
															#line 179 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		{
															#line 36 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			auto idx = deterministicRandom()->randomInt(0, range.size());
															#line 37 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			if (!static_cast<GetRandomStorageActor*>(this)->SAV<StorageServerInterface>::futures) { (void)(decodeServerListValue(range[idx].value)); this->~GetRandomStorageActorState(); static_cast<GetRandomStorageActor*>(this)->destroy(); return 0; }
															#line 185 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			new (&static_cast<GetRandomStorageActor*>(this)->SAV< StorageServerInterface >::value()) StorageServerInterface(decodeServerListValue(range[idx].value));
			this->~GetRandomStorageActorState();
			static_cast<GetRandomStorageActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 39 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 39 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			if (static_cast<GetRandomStorageActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 197 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetRandomStorageActor*>(this)->actor_wait_state = 2;
															#line 39 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRandomStorageActor, 1, Void >*>(static_cast<GetRandomStorageActor*>(this)));
															#line 202 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(range, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRandomStorageActor*>(this)->actor_wait_state > 0) static_cast<GetRandomStorageActor*>(this)->actor_wait_state = 0;
		static_cast<GetRandomStorageActor*>(this)->ActorCallback< GetRandomStorageActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetRandomStorageActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getRandomStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRandomStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRandomStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRandomStorageActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getRandomStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRandomStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRandomStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRandomStorageActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getRandomStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRandomStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRandomStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRandomStorageActor*>(this)->actor_wait_state > 0) static_cast<GetRandomStorageActor*>(this)->actor_wait_state = 0;
		static_cast<GetRandomStorageActor*>(this)->ActorCallback< GetRandomStorageActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRandomStorageActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRandomStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRandomStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRandomStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRandomStorageActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRandomStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRandomStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRandomStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRandomStorageActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRandomStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRandomStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRandomStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRandomStorageActor*>(this)->actor_wait_state > 0) static_cast<GetRandomStorageActor*>(this)->actor_wait_state = 0;
		static_cast<GetRandomStorageActor*>(this)->ActorCallback< GetRandomStorageActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRandomStorageActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRandomStorage", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRandomStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRandomStorage", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRandomStorageActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRandomStorage", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRandomStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRandomStorage", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRandomStorageActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRandomStorage", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRandomStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRandomStorage", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 28 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	Database cx;
															#line 29 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	Transaction tr;
															#line 480 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
};
// This generated class is to be used only via getRandomStorage()
															#line 28 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
class GetRandomStorageActor final : public Actor<StorageServerInterface>, public ActorCallback< GetRandomStorageActor, 0, RangeResult >, public ActorCallback< GetRandomStorageActor, 1, Void >, public ActorCallback< GetRandomStorageActor, 2, Void >, public FastAllocated<GetRandomStorageActor>, public GetRandomStorageActorState<GetRandomStorageActor> {
															#line 485 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
public:
	using FastAllocated<GetRandomStorageActor>::operator new;
	using FastAllocated<GetRandomStorageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10028377580687848960UL, 6760013647754463744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<StorageServerInterface>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRandomStorageActor, 0, RangeResult >;
friend struct ActorCallback< GetRandomStorageActor, 1, Void >;
friend struct ActorCallback< GetRandomStorageActor, 2, Void >;
															#line 28 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	GetRandomStorageActor(Database const& cx) 
															#line 504 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		 : Actor<StorageServerInterface>(),
		   GetRandomStorageActorState<GetRandomStorageActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRandomStorage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14482013366386697984UL, 6768320964134621696UL);
		ActorExecutionContextHelper __helper(static_cast<GetRandomStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRandomStorage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRandomStorage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRandomStorageActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRandomStorageActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRandomStorageActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 28 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
[[nodiscard]] Future<StorageServerInterface> getRandomStorage( Database const& cx ) {
															#line 28 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	return Future<StorageServerInterface>(new GetRandomStorageActor(cx));
															#line 538 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
}

#line 46 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"

struct LocalRatekeeperWorkload : TestWorkload {
	static constexpr auto NAME = "LocalRatekeeper";

	double startAfter = 0.0;
	double blockWritesFor;
	bool testFailed = false;

	LocalRatekeeperWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		startAfter = getOption(options, "startAfter"_sr, startAfter);
		blockWritesFor = getOption(
		    options, "blockWritesFor"_sr, double(SERVER_KNOBS->STORAGE_DURABILITY_LAG_HARD_MAX) / double(1e6));
	}

																#line 556 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
// This generated class is to be used only via testStorage()
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
template <class TestStorageActor>
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
class TestStorageActorState {
															#line 562 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
public:
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	TestStorageActorState(LocalRatekeeperWorkload* const& self,Database const& cx,StorageServerInterface const& ssi) 
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		 : self(self),
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		   cx(cx),
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		   ssi(ssi),
															#line 61 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		   tr(cx),
															#line 62 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		   requests()
															#line 577 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
	{
		fdb_probe_actor_create("testStorage", reinterpret_cast<unsigned long>(this));

	}
	~TestStorageActorState() 
	{
		fdb_probe_actor_destroy("testStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 63 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			requests.reserve(100);
															#line 64 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			;
															#line 594 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestStorageActorState();
		static_cast<TestStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 65 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		StrictFuture<StorageQueuingMetricsReply> __when_expr_0 = brokenPromiseToNever(ssi.getQueuingMetrics.getReply(StorageQueuingMetricsRequest{}));
															#line 65 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		if (static_cast<TestStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 626 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TestStorageActor*>(this)->actor_wait_state = 1;
															#line 65 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestStorageActor, 0, StorageQueuingMetricsReply >*>(static_cast<TestStorageActor*>(this)));
															#line 631 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 67 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		auto durabilityLag = metrics.version - metrics.durableVersion;
															#line 68 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		double expectedRateLimit = 1.0;
															#line 69 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		if (durabilityLag >= SERVER_KNOBS->STORAGE_DURABILITY_LAG_HARD_MAX)
															#line 644 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		{
															#line 70 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			expectedRateLimit = 0.0;
															#line 648 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		}
		else
		{
															#line 71 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			if (durabilityLag > SERVER_KNOBS->STORAGE_DURABILITY_LAG_SOFT_MAX)
															#line 654 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			{
															#line 72 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
				expectedRateLimit = 1.0 - double(durabilityLag - SERVER_KNOBS->STORAGE_DURABILITY_LAG_SOFT_MAX) / double(SERVER_KNOBS->STORAGE_DURABILITY_LAG_HARD_MAX - SERVER_KNOBS->STORAGE_DURABILITY_LAG_SOFT_MAX);
															#line 658 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			}
		}
															#line 76 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		if (expectedRateLimit < metrics.localRateLimit - 0.01 || expectedRateLimit > metrics.localRateLimit + 0.01)
															#line 663 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		{
															#line 78 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			self->testFailed = true;
															#line 79 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			TraceEvent(SevError, "StorageRateLimitTooFarOff") .detail("Storage", ssi.id()) .detail("Expected", expectedRateLimit) .detail("Actual", metrics.localRateLimit);
															#line 669 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		}
															#line 84 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		tr.reset();
															#line 85 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		readVersion = invalidVersion;
															#line 86 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		;
															#line 677 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(StorageQueuingMetricsReply const& __metrics,int loopDepth) 
	{
															#line 65 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		metrics = __metrics;
															#line 686 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(StorageQueuingMetricsReply && __metrics,int loopDepth) 
	{
		metrics = std::move(__metrics);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestStorageActor*>(this)->actor_wait_state > 0) static_cast<TestStorageActor*>(this)->actor_wait_state = 0;
		static_cast<TestStorageActor*>(this)->ActorCallback< TestStorageActor, 0, StorageQueuingMetricsReply >::remove();

	}
	void a_callback_fire(ActorCallback< TestStorageActor, 0, StorageQueuingMetricsReply >*,StorageQueuingMetricsReply const& value) 
	{
		fdb_probe_actor_enter("testStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestStorageActor, 0, StorageQueuingMetricsReply >*,StorageQueuingMetricsReply && value) 
	{
		fdb_probe_actor_enter("testStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestStorageActor, 0, StorageQueuingMetricsReply >*,Error err) 
	{
		fdb_probe_actor_enter("testStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 95 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		requests.clear();
															#line 97 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		for(int i = 0;i < 100;++i) {
															#line 98 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			GetValueRequest req;
															#line 99 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			req.version = readVersion;
															#line 101 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			req.key = "/lkfs"_sr;
															#line 102 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			requests.emplace_back(brokenPromiseToNever(ssi.getValue.getReply(req)));
															#line 775 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		}
															#line 104 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAllReady(requests);
															#line 104 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		if (static_cast<TestStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 781 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestStorageActor*>(this)->actor_wait_state = 4;
															#line 104 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestStorageActor, 3, Void >*>(static_cast<TestStorageActor*>(this)));
															#line 786 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 88 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			StrictFuture<Version> __when_expr_1 = tr.getReadVersion();
															#line 88 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			if (static_cast<TestStorageActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 805 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestStorageActor*>(this)->actor_wait_state = 2;
															#line 88 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestStorageActor, 1, Version >*>(static_cast<TestStorageActor*>(this)));
															#line 810 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 92 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 92 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			if (static_cast<TestStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 847 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestStorageActor*>(this)->actor_wait_state = 3;
															#line 92 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestStorageActor, 2, Void >*>(static_cast<TestStorageActor*>(this)));
															#line 852 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Version const& v,int loopDepth) 
	{
															#line 89 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		readVersion = v;
															#line 867 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Version && v,int loopDepth) 
	{
															#line 89 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		readVersion = v;
															#line 876 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestStorageActor*>(this)->actor_wait_state > 0) static_cast<TestStorageActor*>(this)->actor_wait_state = 0;
		static_cast<TestStorageActor*>(this)->ActorCallback< TestStorageActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< TestStorageActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("testStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestStorageActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("testStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestStorageActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("testStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestStorageActor*>(this)->actor_wait_state > 0) static_cast<TestStorageActor*>(this)->actor_wait_state = 0;
		static_cast<TestStorageActor*>(this)->ActorCallback< TestStorageActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestStorageActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testStorage", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testStorage", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestStorageActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testStorage", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testStorage", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestStorageActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testStorage", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testStorage", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 105 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		int failedRequests = 0;
															#line 106 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		int errors = 0;
															#line 107 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		for( const auto& resp : requests ) {
															#line 108 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			if (resp.isError())
															#line 1053 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			{
															#line 109 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
				self->testFailed = true;
															#line 110 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
				++errors;
															#line 111 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
				TraceEvent(SevError, "LoadBalancedResponseReturnedError").error(resp.getError());
															#line 1061 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			}
			else
			{
															#line 112 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
				if (resp.get().error.present() && resp.get().error.get().code() == error_code_future_version)
															#line 1067 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
				{
															#line 113 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
					++failedRequests;
															#line 1071 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
				}
			}
															#line 115 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			if (errors > 9)
															#line 1076 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			{
				break;
			}
		}
															#line 119 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		TraceEvent("RejectedVersions").detail("NumRejected", failedRequests);
															#line 120 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		if (self->testFailed)
															#line 1085 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		{
															#line 121 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			if (!static_cast<TestStorageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestStorageActorState(); static_cast<TestStorageActor*>(this)->destroy(); return 0; }
															#line 1089 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			new (&static_cast<TestStorageActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TestStorageActorState();
			static_cast<TestStorageActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 123 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(5.0);
															#line 123 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		if (static_cast<TestStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1099 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestStorageActor*>(this)->actor_wait_state = 5;
															#line 123 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestStorageActor, 4, Void >*>(static_cast<TestStorageActor*>(this)));
															#line 1104 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 105 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		int failedRequests = 0;
															#line 106 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		int errors = 0;
															#line 107 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		for( const auto& resp : requests ) {
															#line 108 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			if (resp.isError())
															#line 1119 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			{
															#line 109 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
				self->testFailed = true;
															#line 110 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
				++errors;
															#line 111 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
				TraceEvent(SevError, "LoadBalancedResponseReturnedError").error(resp.getError());
															#line 1127 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			}
			else
			{
															#line 112 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
				if (resp.get().error.present() && resp.get().error.get().code() == error_code_future_version)
															#line 1133 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
				{
															#line 113 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
					++failedRequests;
															#line 1137 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
				}
			}
															#line 115 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			if (errors > 9)
															#line 1142 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			{
				break;
			}
		}
															#line 119 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		TraceEvent("RejectedVersions").detail("NumRejected", failedRequests);
															#line 120 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		if (self->testFailed)
															#line 1151 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		{
															#line 121 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			if (!static_cast<TestStorageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestStorageActorState(); static_cast<TestStorageActor*>(this)->destroy(); return 0; }
															#line 1155 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			new (&static_cast<TestStorageActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TestStorageActorState();
			static_cast<TestStorageActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 123 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(5.0);
															#line 123 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		if (static_cast<TestStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1165 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestStorageActor*>(this)->actor_wait_state = 5;
															#line 123 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestStorageActor, 4, Void >*>(static_cast<TestStorageActor*>(this)));
															#line 1170 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestStorageActor*>(this)->actor_wait_state > 0) static_cast<TestStorageActor*>(this)->actor_wait_state = 0;
		static_cast<TestStorageActor*>(this)->ActorCallback< TestStorageActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestStorageActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testStorage", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testStorage", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestStorageActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testStorage", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testStorage", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestStorageActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testStorage", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testStorage", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestStorageActor*>(this)->actor_wait_state > 0) static_cast<TestStorageActor*>(this)->actor_wait_state = 0;
		static_cast<TestStorageActor*>(this)->ActorCallback< TestStorageActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestStorageActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testStorage", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testStorage", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestStorageActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testStorage", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testStorage", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestStorageActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testStorage", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testStorage", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	LocalRatekeeperWorkload* self;
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	Database cx;
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	StorageServerInterface ssi;
															#line 61 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	Transaction tr;
															#line 62 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	std::vector<Future<GetValueReply>> requests;
															#line 65 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	StorageQueuingMetricsReply metrics;
															#line 85 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	Version readVersion;
															#line 1351 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
};
// This generated class is to be used only via testStorage()
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
class TestStorageActor final : public Actor<Void>, public ActorCallback< TestStorageActor, 0, StorageQueuingMetricsReply >, public ActorCallback< TestStorageActor, 1, Version >, public ActorCallback< TestStorageActor, 2, Void >, public ActorCallback< TestStorageActor, 3, Void >, public ActorCallback< TestStorageActor, 4, Void >, public FastAllocated<TestStorageActor>, public TestStorageActorState<TestStorageActor> {
															#line 1356 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
public:
	using FastAllocated<TestStorageActor>::operator new;
	using FastAllocated<TestStorageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5317326056686153472UL, 12421561253363476480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestStorageActor, 0, StorageQueuingMetricsReply >;
friend struct ActorCallback< TestStorageActor, 1, Version >;
friend struct ActorCallback< TestStorageActor, 2, Void >;
friend struct ActorCallback< TestStorageActor, 3, Void >;
friend struct ActorCallback< TestStorageActor, 4, Void >;
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	TestStorageActor(LocalRatekeeperWorkload* const& self,Database const& cx,StorageServerInterface const& ssi) 
															#line 1377 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		 : Actor<Void>(),
		   TestStorageActorState<TestStorageActor>(self, cx, ssi),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testStorage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1387241558033657856UL, 15194289430957800704UL);
		ActorExecutionContextHelper __helper(static_cast<TestStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testStorage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testStorage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestStorageActor, 0, StorageQueuingMetricsReply >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestStorageActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestStorageActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestStorageActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestStorageActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
[[nodiscard]] static Future<Void> testStorage( LocalRatekeeperWorkload* const& self, Database const& cx, StorageServerInterface const& ssi ) {
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	return Future<Void>(new TestStorageActor(self, cx, ssi));
															#line 1413 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
}

#line 126 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"

																#line 1418 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 127 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
template <class _startActor>
															#line 127 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
class _startActorState {
															#line 1424 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
public:
															#line 127 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	_startActorState(LocalRatekeeperWorkload* const& self,Database const& cx) 
															#line 127 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
															#line 127 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		 : self(self),
															#line 127 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		   cx(cx)
															#line 1433 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 128 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->startAfter);
															#line 128 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1450 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 128 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1455 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		StrictFuture<StorageServerInterface> __when_expr_1 = getRandomStorage(cx);
															#line 129 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1480 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 129 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, StorageServerInterface >*>(static_cast<_startActor*>(this)));
															#line 1485 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		StrictFuture<StorageServerInterface> __when_expr_1 = getRandomStorage(cx);
															#line 129 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1496 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 129 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, StorageServerInterface >*>(static_cast<_startActor*>(this)));
															#line 1501 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 130 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		g_simulator->disableFor(format("%s/updateStorage", ssi.id().toString().c_str()), now() + self->blockWritesFor);
															#line 131 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		done = delay(self->blockWritesFor);
															#line 133 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(double(SERVER_KNOBS->STORAGE_DURABILITY_LAG_SOFT_MAX / 1e6));
															#line 133 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1591 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 133 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1596 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(StorageServerInterface const& __ssi,int loopDepth) 
	{
															#line 129 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		ssi = __ssi;
															#line 1605 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(StorageServerInterface && __ssi,int loopDepth) 
	{
		ssi = std::move(__ssi);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, StorageServerInterface >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, StorageServerInterface >*,StorageServerInterface const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, StorageServerInterface >*,StorageServerInterface && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, StorageServerInterface >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 134 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_3 = testStorage(self, cx, ssi) || done;
															#line 134 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1686 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 134 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1691 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 134 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_3 = testStorage(self, cx, ssi) || done;
															#line 134 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1702 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 134 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1707 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 135 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1791 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 135 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1803 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 127 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	LocalRatekeeperWorkload* self;
															#line 127 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	Database cx;
															#line 129 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	StorageServerInterface ssi;
															#line 131 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	Future<Void> done;
															#line 1894 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 127 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, StorageServerInterface >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1899 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5725513366047581440UL, 16995027332737438464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, StorageServerInterface >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
															#line 127 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	_startActor(LocalRatekeeperWorkload* const& self,Database const& cx) 
															#line 1919 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, StorageServerInterface >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 127 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
[[nodiscard]] static Future<Void> _start( LocalRatekeeperWorkload* const& self, Database const& cx ) {
															#line 127 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 1954 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LocalRatekeeper.actor.g.cpp"
}

#line 137 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/workloads/LocalRatekeeper.actor.cpp"

	Future<Void> start(Database const& cx) override {
		// we run this only on one client
		if (clientId != 0 || !g_network->isSimulated()) {
			return Void();
		}
		return _start(this, cx);
	}
	Future<bool> check(Database const& cx) override { return !testFailed; }
	void getMetrics(std::vector<PerfMetric>& m) override {}
};

} // namespace

WorkloadFactory<LocalRatekeeperWorkload> LocalRatekeeperWorkloadFactory;
