#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
/*
 * TagPartitionedLogSystemRecoveryTests.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/TagPartitionedLogSystem.actor.h"
#include "flow/UnitTest.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace {

Reference<LogSet> makeSingleLogSet(const std::vector<TLogInterface>& tlogs, bool isLocal = true) {
	Reference<LogSet> logSet = makeReference<LogSet>();
	logSet->isLocal = isLocal;
	for (const auto& tlog : tlogs) {
		logSet->logServers.push_back(
		    makeReference<AsyncVar<OptionalInterface<TLogInterface>>>(OptionalInterface<TLogInterface>(tlog)));
	}
	return logSet;
}

std::tuple<int, std::vector<TLogLockResult>, bool> makeLogGroupResults(
    int replicationFactor,
    const std::vector<std::vector<UnknownCommittedVersions>>& perTLogUCV,
    const std::vector<TLogInterface>& tlogs,
    bool nonAvailableTLogsCompletePolicy = true,
    const std::vector<Version>& knownCommitted = {}) {
	std::vector<TLogLockResult> lockResults;
	lockResults.reserve(tlogs.size());
	for (int i = 0; i < tlogs.size(); ++i) {
		TLogLockResult result;
		result.logId = tlogs[i].id();
		result.knownCommittedVersion = (i < knownCommitted.size()) ? knownCommitted[i] : 0;
		for (const auto& ucv : perTLogUCV[i]) {
			result.unknownCommittedVersions.push_back(ucv);
		}
		lockResults.push_back(result);
	}
	return std::make_tuple(replicationFactor, std::move(lockResults), nonAvailableTLogsCompletePolicy);
}

} // namespace

															#line 62 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase60()
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase60Actor>
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase60ActorState {
															#line 69 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase60ActorState(UnitTestParameters const& params) 
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 76 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase60", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase60ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase60", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 61 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 91 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 62 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase60Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase60ActorState(); static_cast<FlowTestCase60Actor*>(this)->destroy(); return 0; }
															#line 95 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase60Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase60ActorState();
				static_cast<FlowTestCase60Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 68 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 69 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogA(locality);
															#line 70 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogB(locality);
															#line 71 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ tlogA, tlogB }) };
															#line 73 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv(110, 100, std::vector<uint16_t>{ 0, 1 });
															#line 74 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults(2, { { ucv }, { ucv } }, { tlogA, tlogB }, true, { 100, 100 });
															#line 76 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 90;
															#line 77 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 78 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 79 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 80 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 82 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 100)
															#line 125 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 83 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "SimpleTestMaxKCVFailed").detail("Expected", 100).detail("Got", maxKCV);
															#line 129 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 85 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 100);
															#line 87 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 110)
															#line 135 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 88 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "SimpleTestRecoverVersionFailed").detail("Expected", 110).detail("Got", recoverVersion);
															#line 139 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 90 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 110);
															#line 91 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase60Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase60ActorState(); static_cast<FlowTestCase60Actor*>(this)->destroy(); return 0; }
															#line 145 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase60Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase60ActorState();
			static_cast<FlowTestCase60Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase60ActorState();
		static_cast<FlowTestCase60Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 169 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase60()
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase60Actor final : public Actor<Void>, public FastAllocated<FlowTestCase60Actor>, public FlowTestCase60ActorState<FlowTestCase60Actor> {
															#line 174 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase60Actor>::operator new;
	using FastAllocated<FlowTestCase60Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13732450834995050240UL, 6901945286620881408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase60Actor(UnitTestParameters const& params) 
															#line 190 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase60ActorState<FlowTestCase60Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase60", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(581146440781332992UL, 16303371015218125056UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase60Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase60");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase60", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase60( UnitTestParameters const& params ) {
															#line 60 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase60Actor(params));
															#line 222 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase60, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/Simple")

#line 93 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"

															#line 228 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase94()
															#line 94 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase94Actor>
															#line 94 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase94ActorState {
															#line 235 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 94 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase94ActorState(UnitTestParameters const& params) 
															#line 94 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 94 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 242 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase94", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase94ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase94", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 95 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 257 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 96 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase94Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase94ActorState(); static_cast<FlowTestCase94Actor*>(this)->destroy(); return 0; }
															#line 261 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase94Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase94ActorState();
				static_cast<FlowTestCase94Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 100 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 101 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogA(locality);
															#line 102 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogB(locality);
															#line 103 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ tlogA, tlogB }) };
															#line 105 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults(2, { {}, {} }, { tlogA, tlogB }, true, { 80, 90 });
															#line 107 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 70;
															#line 108 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 109 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 110 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 111 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 113 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 90)
															#line 289 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 114 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "FallbackTestMaxKCVFailed").detail("Expected", 90).detail("Got", maxKCV);
															#line 293 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 116 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 90);
															#line 118 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 90)
															#line 299 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 119 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "FallbackTestRecoverVersionFailed").detail("Expected", 90).detail("Got", recoverVersion);
															#line 303 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 121 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 90);
															#line 122 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase94Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase94ActorState(); static_cast<FlowTestCase94Actor*>(this)->destroy(); return 0; }
															#line 309 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase94Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase94ActorState();
			static_cast<FlowTestCase94Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase94ActorState();
		static_cast<FlowTestCase94Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 94 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 333 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase94()
															#line 94 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase94Actor final : public Actor<Void>, public FastAllocated<FlowTestCase94Actor>, public FlowTestCase94ActorState<FlowTestCase94Actor> {
															#line 338 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase94Actor>::operator new;
	using FastAllocated<FlowTestCase94Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9286984144463696896UL, 15402876463217458176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 94 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase94Actor(UnitTestParameters const& params) 
															#line 354 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase94ActorState<FlowTestCase94Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase94", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7160343916971339008UL, 16531539115448735232UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase94Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase94");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase94", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 94 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase94( UnitTestParameters const& params ) {
															#line 94 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase94Actor(params));
															#line 386 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase94, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/FallbackToMaxKCV")

#line 124 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"

															#line 392 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase125()
															#line 125 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase125Actor>
															#line 125 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase125ActorState {
															#line 399 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 125 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase125ActorState(UnitTestParameters const& params) 
															#line 125 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 125 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 406 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase125", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase125ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase125", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 126 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 421 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 127 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase125Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase125ActorState(); static_cast<FlowTestCase125Actor*>(this)->destroy(); return 0; }
															#line 425 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase125Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase125ActorState();
				static_cast<FlowTestCase125Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 131 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 132 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogA(locality);
															#line 133 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogB(locality);
															#line 134 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ tlogA, tlogB }) };
															#line 136 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv(110, 100, std::vector<uint16_t>{ 0, 1 });
															#line 137 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucvLate(120, 110, std::vector<uint16_t>{ 0, 1 });
															#line 139 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults(2, { { ucv, ucvLate }, { ucv } }, { tlogA, tlogB }, true, { 100, 100 });
															#line 141 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 90;
															#line 142 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 144 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 145 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 147 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 100)
															#line 457 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 148 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "MissingDeliveryTestMaxKCVFailed").detail("Expected", 100).detail("Got", maxKCV);
															#line 461 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 150 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 100);
															#line 153 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 110)
															#line 467 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 154 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "MissingDeliveryTestRecoverVersionFailed") .detail("Expected", 110) .detail("Got", recoverVersion) .detail("Reason", "tlogB did not receive version 120");
															#line 471 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 159 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 110);
															#line 160 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase125Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase125ActorState(); static_cast<FlowTestCase125Actor*>(this)->destroy(); return 0; }
															#line 477 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase125Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase125ActorState();
			static_cast<FlowTestCase125Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase125ActorState();
		static_cast<FlowTestCase125Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 125 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 501 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase125()
															#line 125 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase125Actor final : public Actor<Void>, public FastAllocated<FlowTestCase125Actor>, public FlowTestCase125ActorState<FlowTestCase125Actor> {
															#line 506 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase125Actor>::operator new;
	using FastAllocated<FlowTestCase125Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7540566449666730496UL, 1134428213341060864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 125 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase125Actor(UnitTestParameters const& params) 
															#line 522 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase125ActorState<FlowTestCase125Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase125", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7999563576076191488UL, 16039155595118015744UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase125Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase125");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase125", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 125 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase125( UnitTestParameters const& params ) {
															#line 125 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase125Actor(params));
															#line 554 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase125, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/HaltOnMissingDelivery")

#line 162 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"

															#line 560 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase163()
															#line 163 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase163Actor>
															#line 163 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase163ActorState {
															#line 567 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 163 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase163ActorState(UnitTestParameters const& params) 
															#line 163 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 163 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 574 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase163", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase163ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase163", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 164 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 589 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 165 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase163Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase163ActorState(); static_cast<FlowTestCase163Actor*>(this)->destroy(); return 0; }
															#line 593 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase163Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase163ActorState();
				static_cast<FlowTestCase163Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 169 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 170 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogA(locality);
															#line 171 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogB(locality);
															#line 172 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ tlogA, tlogB }) };
															#line 174 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv(110, 100, std::vector<uint16_t>{ 0, 1 });
															#line 175 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv2(120, 110, std::vector<uint16_t>{ 0, 1 });
															#line 178 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults(2, { { ucv, ucv2 }, { ucv } }, { tlogA, tlogB }, true, { 100, 100 });
															#line 180 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 90;
															#line 181 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 182 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 183 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 184 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 186 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 100)
															#line 625 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 187 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "PolicyNotSatisfiedTestMaxKCVFailed").detail("Expected", 100).detail("Got", maxKCV);
															#line 629 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 189 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 100);
															#line 191 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 110)
															#line 635 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 192 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "PolicyNotSatisfiedTestRecoverVersionFailed") .detail("Expected", 110) .detail("Got", recoverVersion) .detail("Reason", "Version 120 sent to both tLogs but only received by 1 (RF=2)");
															#line 639 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 197 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 110);
															#line 198 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase163Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase163ActorState(); static_cast<FlowTestCase163Actor*>(this)->destroy(); return 0; }
															#line 645 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase163Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase163ActorState();
			static_cast<FlowTestCase163Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase163ActorState();
		static_cast<FlowTestCase163Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 163 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 669 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase163()
															#line 163 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase163Actor final : public Actor<Void>, public FastAllocated<FlowTestCase163Actor>, public FlowTestCase163ActorState<FlowTestCase163Actor> {
															#line 674 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase163Actor>::operator new;
	using FastAllocated<FlowTestCase163Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9924032867027323136UL, 8068862704447922432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 163 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase163Actor(UnitTestParameters const& params) 
															#line 690 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase163ActorState<FlowTestCase163Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase163", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12050036035296398592UL, 4823101645924892928UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase163Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase163");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase163", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 163 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase163( UnitTestParameters const& params ) {
															#line 163 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase163Actor(params));
															#line 722 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase163, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/PolicyNotSatisfied")

#line 200 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"

															#line 728 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase201()
															#line 201 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase201Actor>
															#line 201 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase201ActorState {
															#line 735 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 201 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase201ActorState(UnitTestParameters const& params) 
															#line 201 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 201 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 742 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase201", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase201ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase201", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 202 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 757 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 203 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase201Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase201ActorState(); static_cast<FlowTestCase201Actor*>(this)->destroy(); return 0; }
															#line 761 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase201Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase201ActorState();
				static_cast<FlowTestCase201Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 207 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 208 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogA(locality);
															#line 209 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogB(locality);
															#line 210 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ tlogA, tlogB }) };
															#line 212 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv(95, 90, std::vector<uint16_t>{ 0, 1 });
															#line 213 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults(2, { { ucv }, { ucv } }, { tlogA, tlogB }, true, { 90, 90 });
															#line 215 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 80;
															#line 216 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 217 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 218 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 219 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 221 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 90)
															#line 791 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 222 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "MinDVRespectedTestMaxKCVFailed").detail("Expected", 90).detail("Got", maxKCV);
															#line 795 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 224 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 90);
															#line 226 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 95)
															#line 801 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 227 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "MinDVRespectedTestRecoverVersionFailed") .detail("Expected", 95) .detail("Got", recoverVersion) .detail("MinDV", minDV) .detail("MaxKCV", maxKCV);
															#line 805 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 233 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 95);
															#line 234 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase201Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase201ActorState(); static_cast<FlowTestCase201Actor*>(this)->destroy(); return 0; }
															#line 811 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase201Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase201ActorState();
			static_cast<FlowTestCase201Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase201ActorState();
		static_cast<FlowTestCase201Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 201 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 835 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase201()
															#line 201 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase201Actor final : public Actor<Void>, public FastAllocated<FlowTestCase201Actor>, public FlowTestCase201ActorState<FlowTestCase201Actor> {
															#line 840 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase201Actor>::operator new;
	using FastAllocated<FlowTestCase201Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5421583696553037056UL, 16950320696338766848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 201 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase201Actor(UnitTestParameters const& params) 
															#line 856 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase201ActorState<FlowTestCase201Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase201", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7267332707161508096UL, 679722651989966848UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase201Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase201");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase201", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 201 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase201( UnitTestParameters const& params ) {
															#line 201 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase201Actor(params));
															#line 888 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase201, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/MinDVRespected")

#line 236 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"

															#line 894 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase237()
															#line 237 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase237Actor>
															#line 237 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase237ActorState {
															#line 901 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 237 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase237ActorState(UnitTestParameters const& params) 
															#line 237 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 237 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 908 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase237", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase237ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase237", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 238 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 923 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 239 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase237Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase237ActorState(); static_cast<FlowTestCase237Actor*>(this)->destroy(); return 0; }
															#line 927 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase237Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase237ActorState();
				static_cast<FlowTestCase237Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 243 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 244 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogA(locality);
															#line 245 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogB(locality);
															#line 246 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ tlogA, tlogB }) };
															#line 249 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv110(110, 100, std::vector<uint16_t>{ 0, 1 });
															#line 250 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv120(120, 115, std::vector<uint16_t>{ 0, 1 });
															#line 251 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults(2, { { ucv110, ucv120 }, { ucv110, ucv120 } }, { tlogA, tlogB }, true, { 100, 100 });
															#line 254 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 90;
															#line 255 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 256 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 257 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 258 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 260 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 100)
															#line 959 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 261 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "BrokenChainTestMaxKCVFailed").detail("Expected", 100).detail("Got", maxKCV);
															#line 963 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 263 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 100);
															#line 266 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 110)
															#line 969 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 267 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "BrokenChainTestRecoverVersionFailed") .detail("Expected", 110) .detail("Got", recoverVersion) .detail("Reason", "Version 120 has prevVersion=115, expected 110");
															#line 973 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 272 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 110);
															#line 273 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase237Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase237ActorState(); static_cast<FlowTestCase237Actor*>(this)->destroy(); return 0; }
															#line 979 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase237Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase237ActorState();
			static_cast<FlowTestCase237Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase237ActorState();
		static_cast<FlowTestCase237Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 237 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 1003 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase237()
															#line 237 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase237Actor final : public Actor<Void>, public FastAllocated<FlowTestCase237Actor>, public FlowTestCase237ActorState<FlowTestCase237Actor> {
															#line 1008 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase237Actor>::operator new;
	using FastAllocated<FlowTestCase237Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6502216627574582272UL, 13484413865806560000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 237 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase237Actor(UnitTestParameters const& params) 
															#line 1024 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase237ActorState<FlowTestCase237Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase237", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11954795935256850176UL, 7856017942059194112UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase237Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase237");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase237", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 237 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase237( UnitTestParameters const& params ) {
															#line 237 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase237Actor(params));
															#line 1056 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase237, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/BrokenChain")

#line 275 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"

															#line 1062 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase276()
															#line 276 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase276Actor>
															#line 276 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase276ActorState {
															#line 1069 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 276 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase276ActorState(UnitTestParameters const& params) 
															#line 276 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 276 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 1076 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase276", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase276ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase276", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 277 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 1091 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 278 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase276Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase276ActorState(); static_cast<FlowTestCase276Actor*>(this)->destroy(); return 0; }
															#line 1095 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase276Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase276ActorState();
				static_cast<FlowTestCase276Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 282 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 283 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface primary1(locality), primary2(locality);
															#line 284 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface satellite1(locality), satellite2(locality);
															#line 287 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ primary1, primary2 }, true), makeSingleLogSet({ satellite1, satellite2 }, false) };
															#line 291 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv(110, 100, std::vector<uint16_t>{ 0, 1 });
															#line 292 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults(2, { { ucv }, { ucv } }, { primary1, primary2 }, true, { 100, 100 });
															#line 294 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 90;
															#line 295 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 296 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 297 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 298 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 300 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 100)
															#line 1125 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 301 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "MultipleLogSetsTestMaxKCVFailed").detail("Expected", 100).detail("Got", maxKCV);
															#line 1129 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 303 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 100);
															#line 305 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 110)
															#line 1135 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 306 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "MultipleLogSetsTestRecoverVersionFailed") .detail("Expected", 110) .detail("Got", recoverVersion) .detail("NumLogSets", logServers.size());
															#line 1139 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 311 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 110);
															#line 312 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase276Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase276ActorState(); static_cast<FlowTestCase276Actor*>(this)->destroy(); return 0; }
															#line 1145 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase276Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase276ActorState();
			static_cast<FlowTestCase276Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase276ActorState();
		static_cast<FlowTestCase276Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 276 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 1169 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase276()
															#line 276 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase276Actor final : public Actor<Void>, public FastAllocated<FlowTestCase276Actor>, public FlowTestCase276ActorState<FlowTestCase276Actor> {
															#line 1174 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase276Actor>::operator new;
	using FastAllocated<FlowTestCase276Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7078235005606217984UL, 9061639531201947648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 276 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase276Actor(UnitTestParameters const& params) 
															#line 1190 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase276ActorState<FlowTestCase276Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase276", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9781068012537641216UL, 16734461310843978496UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase276Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase276");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase276", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 276 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase276( UnitTestParameters const& params ) {
															#line 276 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase276Actor(params));
															#line 1222 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase276, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/MultipleLogSets")

#line 314 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"

															#line 1228 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase315()
															#line 315 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase315Actor>
															#line 315 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase315ActorState {
															#line 1235 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 315 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase315ActorState(UnitTestParameters const& params) 
															#line 315 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 315 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 1242 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase315", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase315ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase315", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 316 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 1257 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 317 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase315Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase315ActorState(); static_cast<FlowTestCase315Actor*>(this)->destroy(); return 0; }
															#line 1261 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase315Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase315ActorState();
				static_cast<FlowTestCase315Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 321 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 322 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogA(locality), tlogB(locality), tlogC(locality);
															#line 323 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ tlogA, tlogB, tlogC }) };
															#line 326 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv110(110, 100, std::vector<uint16_t>{ 0, 1, 2 });
															#line 327 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv120(120, 110, std::vector<uint16_t>{ 0, 1, 2 });
															#line 329 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults( 3, { { ucv110, ucv120 }, { ucv110, ucv120 }, { ucv110 } }, { tlogA, tlogB, tlogC }, false, { 100, 100, 100 });
															#line 332 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 90;
															#line 333 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 334 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 335 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 336 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 338 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 100)
															#line 1291 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 339 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "PartialAvailabilityTestMaxKCVFailed").detail("Expected", 100).detail("Got", maxKCV);
															#line 1295 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 341 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 100);
															#line 344 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 110)
															#line 1301 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 345 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "PartialAvailabilityTestRecoverVersionFailed") .detail("Expected", 110) .detail("Got", recoverVersion) .detail("Reason", "Only 2 of 3 tLogs received version 120 (RF=3)");
															#line 1305 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 350 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 110);
															#line 351 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase315Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase315ActorState(); static_cast<FlowTestCase315Actor*>(this)->destroy(); return 0; }
															#line 1311 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase315Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase315ActorState();
			static_cast<FlowTestCase315Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase315ActorState();
		static_cast<FlowTestCase315Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 315 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 1335 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase315()
															#line 315 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase315Actor final : public Actor<Void>, public FastAllocated<FlowTestCase315Actor>, public FlowTestCase315ActorState<FlowTestCase315Actor> {
															#line 1340 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase315Actor>::operator new;
	using FastAllocated<FlowTestCase315Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2136556466779998976UL, 8980595631916518912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 315 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase315Actor(UnitTestParameters const& params) 
															#line 1356 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase315ActorState<FlowTestCase315Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase315", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8691705209224595968UL, 12806436817554523648UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase315Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase315");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase315", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 315 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase315( UnitTestParameters const& params ) {
															#line 315 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase315Actor(params));
															#line 1388 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase315, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/PartialAvailabilityPolicyFail")

#line 353 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"

															#line 1394 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase354()
															#line 354 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase354Actor>
															#line 354 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase354ActorState {
															#line 1401 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 354 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase354ActorState(UnitTestParameters const& params) 
															#line 354 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 354 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 1408 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase354", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase354ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase354", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 355 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 1423 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 356 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase354Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase354ActorState(); static_cast<FlowTestCase354Actor*>(this)->destroy(); return 0; }
															#line 1427 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase354Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase354ActorState();
				static_cast<FlowTestCase354Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 360 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 361 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogA(locality);
															#line 362 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogB(locality);
															#line 363 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ tlogA, tlogB }) };
															#line 366 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv80(80, 70, std::vector<uint16_t>{ 0, 1 });
															#line 367 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults(2, { { ucv80 }, { ucv80 } }, { tlogA, tlogB }, true, { 100, 100 });
															#line 369 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 90;
															#line 370 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 371 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 372 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 373 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 375 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 100)
															#line 1457 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 376 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "VersionsBelowMaxKCVTestMaxKCVFailed").detail("Expected", 100).detail("Got", maxKCV);
															#line 1461 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 378 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 100);
															#line 381 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 100)
															#line 1467 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 382 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "VersionsBelowMaxKCVTestRecoverVersionFailed") .detail("Expected", 100) .detail("Got", recoverVersion) .detail("Reason", "All UCVs below maxKCV should be filtered");
															#line 1471 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 387 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 100);
															#line 388 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase354Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase354ActorState(); static_cast<FlowTestCase354Actor*>(this)->destroy(); return 0; }
															#line 1477 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase354Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase354ActorState();
			static_cast<FlowTestCase354Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase354ActorState();
		static_cast<FlowTestCase354Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 354 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 1501 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase354()
															#line 354 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase354Actor final : public Actor<Void>, public FastAllocated<FlowTestCase354Actor>, public FlowTestCase354ActorState<FlowTestCase354Actor> {
															#line 1506 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase354Actor>::operator new;
	using FastAllocated<FlowTestCase354Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14560011469649000960UL, 5166695345504283904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 354 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase354Actor(UnitTestParameters const& params) 
															#line 1522 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase354ActorState<FlowTestCase354Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase354", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13732710272036525824UL, 9408936190713591552UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase354Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase354");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase354", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 354 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase354( UnitTestParameters const& params ) {
															#line 354 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase354Actor(params));
															#line 1554 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase354, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/VersionsBelowMaxKCV")

#line 390 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"

															#line 1560 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase391()
															#line 391 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase391Actor>
															#line 391 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase391ActorState {
															#line 1567 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 391 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase391ActorState(UnitTestParameters const& params) 
															#line 391 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 391 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 1574 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase391", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase391ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase391", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 392 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 1589 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 393 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase391Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase391ActorState(); static_cast<FlowTestCase391Actor*>(this)->destroy(); return 0; }
															#line 1593 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase391Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase391ActorState();
				static_cast<FlowTestCase391Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 399 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 400 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogA(locality);
															#line 401 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogB(locality);
															#line 402 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ tlogA, tlogB }) };
															#line 412 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv110(110, 100, std::vector<uint16_t>{ 0, 1 });
															#line 414 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv115(115, 110, std::vector<uint16_t>{ 0 });
															#line 416 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv120(120, 115, std::vector<uint16_t>{ 0, 1 });
															#line 417 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv125(125, 120, std::vector<uint16_t>{ 0 });
															#line 421 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults( 2, { { ucv110, ucv115, ucv120, ucv125 }, { ucv110, ucv120 } }, { tlogA, tlogB }, true, { 100, 100 });
															#line 424 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 90;
															#line 425 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 426 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 427 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 428 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 430 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 100)
															#line 1629 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 431 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "RandomVersionsPartialDeliveryTestMaxKCVFailed") .detail("Expected", 100) .detail("Got", maxKCV);
															#line 1633 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 435 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 100);
															#line 441 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 110)
															#line 1639 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 442 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "RandomVersionsPartialDeliveryTestRecoverVersionFailed") .detail("Expected", 110) .detail("Got", recoverVersion) .detail("Reason", "Version 115 received by only tlogA (subset), breaks recovery before 120. " "Missing versions (112, 118) also demonstrate gaps in the range.");
															#line 1643 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 449 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 110);
															#line 450 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase391Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase391ActorState(); static_cast<FlowTestCase391Actor*>(this)->destroy(); return 0; }
															#line 1649 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase391Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase391ActorState();
			static_cast<FlowTestCase391Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase391ActorState();
		static_cast<FlowTestCase391Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 391 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 1673 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase391()
															#line 391 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase391Actor final : public Actor<Void>, public FastAllocated<FlowTestCase391Actor>, public FlowTestCase391ActorState<FlowTestCase391Actor> {
															#line 1678 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase391Actor>::operator new;
	using FastAllocated<FlowTestCase391Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7539427490390735872UL, 18206413302671594496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 391 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase391Actor(UnitTestParameters const& params) 
															#line 1694 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase391ActorState<FlowTestCase391Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase391", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12248051868039835904UL, 155506184027778560UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase391Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase391");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase391", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 391 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase391( UnitTestParameters const& params ) {
															#line 391 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase391Actor(params));
															#line 1726 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase391, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/RandomVersionsPartialDelivery")

#line 452 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
