#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
/*
 * GenericManagementAPI.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(FDBCLIENT_GENERIC_MANAGEMENT_API_ACTOR_G_H)
#define FDBCLIENT_GENERIC_MANAGEMENT_API_ACTOR_G_H
#include "fdbclient/GenericManagementAPI.actor.g.h"
#elif !defined(FDBCLIENT_GENERIC_MANAGEMENT_API_ACTOR_H)
#define FDBCLIENT_GENERIC_MANAGEMENT_API_ACTOR_H

/* This file defines "management" interfaces that have been templated to support both IClientAPI
and Native version of databases, transactions, etc., and includes functions for performing cluster
management tasks. It isn't exposed to C clients or anywhere outside our code base and doesn't need
to be versioned. It doesn't do anything you can't do with the standard API and some knowledge of
the contents of the system key space.
*/

#include <string>
#include <map>
#include "fdbclient/ClientBooleanParams.h"
#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/Status.h"
#include "fdbclient/Subspace.h"
#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/MetaclusterRegistration.h"
#include "fdbclient/Status.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/StorageWiggleMetrics.actor.h"
#include "flow/actorcompiler.h" // has to be last include

// ConfigurationResult enumerates normal outcomes of changeConfig() and various error
// conditions specific to it.  changeConfig may also throw an Error to report other problems.
enum class ConfigurationResult {
	NO_OPTIONS_PROVIDED,
	CONFLICTING_OPTIONS,
	UNKNOWN_OPTION,
	INCOMPLETE_CONFIGURATION,
	INVALID_CONFIGURATION,
	STORAGE_MIGRATION_DISABLED,
	DATABASE_ALREADY_CREATED,
	DATABASE_CREATED,
	DATABASE_UNAVAILABLE,
	STORAGE_IN_UNKNOWN_DCID,
	REGION_NOT_FULLY_REPLICATED,
	MULTIPLE_ACTIVE_REGIONS,
	REGIONS_CHANGED,
	NOT_ENOUGH_WORKERS,
	REGION_REPLICATION_MISMATCH,
	DCID_MISSING,
	LOCKED_NOT_NEW,
	SUCCESS_WARN_PPW_GRADUAL,
	SUCCESS,
	SUCCESS_WARN_SHARDED_ROCKSDB_EXPERIMENTAL,
	DATABASE_CREATED_WARN_SHARDED_ROCKSDB_EXPERIMENTAL,
	DATABASE_IS_REGISTERED,
	ENCRYPTION_AT_REST_MODE_ALREADY_SET,
	INVALID_STORAGE_TYPE
};

enum class CoordinatorsResult {
	INVALID_NETWORK_ADDRESSES,
	SAME_NETWORK_ADDRESSES,
	NOT_COORDINATORS, // FIXME: not detected
	DATABASE_UNREACHABLE, // FIXME: not detected
	BAD_DATABASE_STATE,
	COORDINATOR_UNREACHABLE,
	NOT_ENOUGH_MACHINES,
	SUCCESS
};

struct ConfigureAutoResult {
	std::map<NetworkAddress, ProcessClass> address_class;
	int32_t processes;
	int32_t machines;

	std::string old_replication;
	int32_t old_commit_proxies;
	int32_t old_grv_proxies;
	int32_t old_resolvers;
	int32_t old_logs;
	int32_t old_processes_with_transaction;
	int32_t old_machines_with_transaction;

	std::string auto_replication;
	int32_t auto_commit_proxies;
	int32_t auto_grv_proxies;
	int32_t auto_resolvers;
	int32_t auto_logs;
	int32_t auto_processes_with_transaction;
	int32_t auto_machines_with_transaction;

	int32_t desired_commit_proxies;
	int32_t desired_grv_proxies;
	int32_t desired_resolvers;
	int32_t desired_logs;

	ConfigureAutoResult()
	  : processes(-1), machines(-1), old_commit_proxies(-1), old_grv_proxies(-1), old_resolvers(-1), old_logs(-1),
	    old_processes_with_transaction(-1), old_machines_with_transaction(-1), auto_commit_proxies(-1),
	    auto_grv_proxies(-1), auto_resolvers(-1), auto_logs(-1), auto_processes_with_transaction(-1),
	    auto_machines_with_transaction(-1), desired_commit_proxies(-1), desired_grv_proxies(-1), desired_resolvers(-1),
	    desired_logs(-1) {}

	bool isValid() const { return processes != -1; }
};

ConfigurationResult buildConfiguration(
    std::vector<StringRef> const& modeTokens,
    std::map<std::string, std::string>& outConf); // Accepts a vector of configuration tokens
ConfigurationResult buildConfiguration(
    std::string const& modeString,
    std::map<std::string, std::string>& outConf); // Accepts tokens separated by spaces in a single string

bool isCompleteConfiguration(std::map<std::string, std::string> const& options);

ConfigureAutoResult parseConfig(StatusObject const& status);

bool isEncryptionAtRestModeConfigValid(Optional<DatabaseConfiguration> oldConfiguration,
                                       std::map<std::string, std::string> newConfig,
                                       bool creating);
bool isTenantModeModeConfigValid(DatabaseConfiguration oldConfiguration, DatabaseConfiguration newConfiguration);

// Management API written in template code to support both IClientAPI and NativeAPI
namespace ManagementAPI {

															#line 145 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
// This generated class is to be used only via changeCachedRange()
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB, class ChangeCachedRangeActor>
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class ChangeCachedRangeActorState {
															#line 151 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
public:
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	ChangeCachedRangeActorState(Reference<DB> const& db,KeyRangeRef const& range,bool const& add) 
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		 : db(db),
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   range(range),
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   add(add),
															#line 145 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   tr(db->createTransaction()),
															#line 146 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   sysRange(KeyRangeRef(storageCacheKey(range.begin), storageCacheKey(range.end))),
															#line 147 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   sysRangeClear(KeyRangeRef(storageCacheKey(range.begin), keyAfter(storageCacheKey(range.end)))),
															#line 148 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   privateRange(KeyRangeRef(cacheKeysKey(0, range.begin), cacheKeysKey(0, range.end))),
															#line 149 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   trueValue(storageCacheValue(std::vector<uint16_t>{ 0 })),
															#line 150 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   falseValue(storageCacheValue(std::vector<uint16_t>{}))
															#line 174 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
	{
		fdb_probe_actor_create("changeCachedRange", reinterpret_cast<unsigned long>(this));

	}
	~ChangeCachedRangeActorState() 
	{
		fdb_probe_actor_destroy("changeCachedRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 151 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			;
															#line 189 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeCachedRangeActorState();
		static_cast<ChangeCachedRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 152 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 153 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 221 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		try {
															#line 155 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->clear(sysRangeClear);
															#line 156 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->clear(privateRange);
															#line 157 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->addReadConflictRange(privateRange);
															#line 159 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			previousFuture = tr->getRange(KeyRangeRef(storageCachePrefix, sysRange.begin), 1, Snapshot::False, Reverse::True);
															#line 161 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<RangeResult> __when_expr_0 = safeThreadFutureToFuture(previousFuture);
															#line 161 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 235 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state = 1;
															#line 161 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeCachedRangeActor, 0, RangeResult >*>(static_cast<ChangeCachedRangeActor*>(this)));
															#line 240 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 197 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			err = e;
															#line 198 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Void> __when_expr_3 = safeThreadFutureToFuture(tr->onError(e));
															#line 198 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 266 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state = 4;
															#line 198 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangeCachedRangeActor, 3, Void >*>(static_cast<ChangeCachedRangeActor*>(this)));
															#line 271 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& previous,int loopDepth) 
	{
															#line 162 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		bool prevIsCached = false;
															#line 163 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!previous.empty())
															#line 288 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 164 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::vector<uint16_t> prevVal;
															#line 165 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			decodeStorageCacheValue(previous[0].value, prevVal);
															#line 166 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			prevIsCached = !prevVal.empty();
															#line 296 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 168 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (prevIsCached && !add)
															#line 300 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 170 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(sysRange.begin, falseValue);
															#line 171 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(privateRange.begin, serverKeysFalse);
															#line 306 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
		else
		{
															#line 172 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!prevIsCached && add)
															#line 312 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 174 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(sysRange.begin, trueValue);
															#line 175 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(privateRange.begin, serverKeysTrue);
															#line 318 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 178 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		afterFuture = tr->getRange(KeyRangeRef(sysRange.end, storageCacheKeys.end), 1, Snapshot::False, Reverse::False);
															#line 180 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<RangeResult> __when_expr_1 = safeThreadFutureToFuture(afterFuture);
															#line 180 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 327 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state = 2;
															#line 180 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeCachedRangeActor, 1, RangeResult >*>(static_cast<ChangeCachedRangeActor*>(this)));
															#line 332 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && previous,int loopDepth) 
	{
															#line 162 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		bool prevIsCached = false;
															#line 163 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!previous.empty())
															#line 343 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 164 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::vector<uint16_t> prevVal;
															#line 165 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			decodeStorageCacheValue(previous[0].value, prevVal);
															#line 166 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			prevIsCached = !prevVal.empty();
															#line 351 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 168 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (prevIsCached && !add)
															#line 355 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 170 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(sysRange.begin, falseValue);
															#line 171 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(privateRange.begin, serverKeysFalse);
															#line 361 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
		else
		{
															#line 172 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!prevIsCached && add)
															#line 367 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 174 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(sysRange.begin, trueValue);
															#line 175 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(privateRange.begin, serverKeysTrue);
															#line 373 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 178 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		afterFuture = tr->getRange(KeyRangeRef(sysRange.end, storageCacheKeys.end), 1, Snapshot::False, Reverse::False);
															#line 180 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<RangeResult> __when_expr_1 = safeThreadFutureToFuture(afterFuture);
															#line 180 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 382 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state = 2;
															#line 180 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeCachedRangeActor, 1, RangeResult >*>(static_cast<ChangeCachedRangeActor*>(this)));
															#line 387 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& previous,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(previous, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && previous,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(previous), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state > 0) static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeCachedRangeActor*>(this)->ActorCallback< ChangeCachedRangeActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeCachedRangeActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("changeCachedRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCachedRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCachedRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeCachedRangeActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("changeCachedRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCachedRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCachedRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeCachedRangeActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("changeCachedRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCachedRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCachedRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& after,int loopDepth) 
	{
															#line 181 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		bool afterIsCached = false;
															#line 182 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!after.empty())
															#line 473 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 183 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::vector<uint16_t> afterVal;
															#line 184 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			decodeStorageCacheValue(after[0].value, afterVal);
															#line 185 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			afterIsCached = afterVal.empty();
															#line 481 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 187 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (afterIsCached && !add)
															#line 485 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 188 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(sysRange.end, trueValue);
															#line 189 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(privateRange.end, serverKeysTrue);
															#line 491 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
		else
		{
															#line 190 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!afterIsCached && add)
															#line 497 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 191 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(sysRange.end, falseValue);
															#line 192 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(privateRange.end, serverKeysFalse);
															#line 503 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 194 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->commit());
															#line 194 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 510 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state = 3;
															#line 194 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeCachedRangeActor, 2, Void >*>(static_cast<ChangeCachedRangeActor*>(this)));
															#line 515 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && after,int loopDepth) 
	{
															#line 181 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		bool afterIsCached = false;
															#line 182 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!after.empty())
															#line 526 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 183 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::vector<uint16_t> afterVal;
															#line 184 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			decodeStorageCacheValue(after[0].value, afterVal);
															#line 185 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			afterIsCached = afterVal.empty();
															#line 534 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 187 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (afterIsCached && !add)
															#line 538 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 188 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(sysRange.end, trueValue);
															#line 189 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(privateRange.end, serverKeysTrue);
															#line 544 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
		else
		{
															#line 190 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!afterIsCached && add)
															#line 550 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 191 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(sysRange.end, falseValue);
															#line 192 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(privateRange.end, serverKeysFalse);
															#line 556 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 194 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->commit());
															#line 194 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 563 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state = 3;
															#line 194 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeCachedRangeActor, 2, Void >*>(static_cast<ChangeCachedRangeActor*>(this)));
															#line 568 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& after,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(after, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && after,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(after), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state > 0) static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeCachedRangeActor*>(this)->ActorCallback< ChangeCachedRangeActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeCachedRangeActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("changeCachedRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCachedRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCachedRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeCachedRangeActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("changeCachedRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCachedRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCachedRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeCachedRangeActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("changeCachedRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCachedRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCachedRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 195 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!static_cast<ChangeCachedRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeCachedRangeActorState(); static_cast<ChangeCachedRangeActor*>(this)->destroy(); return 0; }
															#line 652 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		new (&static_cast<ChangeCachedRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeCachedRangeActorState();
		static_cast<ChangeCachedRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 195 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!static_cast<ChangeCachedRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeCachedRangeActorState(); static_cast<ChangeCachedRangeActor*>(this)->destroy(); return 0; }
															#line 664 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		new (&static_cast<ChangeCachedRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeCachedRangeActorState();
		static_cast<ChangeCachedRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state > 0) static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeCachedRangeActor*>(this)->ActorCallback< ChangeCachedRangeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeCachedRangeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeCachedRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCachedRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCachedRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangeCachedRangeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeCachedRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCachedRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCachedRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangeCachedRangeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeCachedRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCachedRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCachedRange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 199 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		TraceEvent(SevDebug, "ChangeCachedRangeError").error(err);
															#line 751 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 199 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		TraceEvent(SevDebug, "ChangeCachedRangeError").error(err);
															#line 760 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state > 0) static_cast<ChangeCachedRangeActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeCachedRangeActor*>(this)->ActorCallback< ChangeCachedRangeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeCachedRangeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeCachedRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCachedRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCachedRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ChangeCachedRangeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeCachedRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCachedRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCachedRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ChangeCachedRangeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeCachedRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCachedRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCachedRange", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Reference<DB> db;
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	KeyRangeRef range;
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	bool add;
															#line 145 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 146 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	KeyRange sysRange;
															#line 147 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	KeyRange sysRangeClear;
															#line 148 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	KeyRange privateRange;
															#line 149 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Value trueValue;
															#line 150 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Value falseValue;
															#line 159 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> previousFuture;
															#line 178 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> afterFuture;
															#line 197 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Error err;
															#line 864 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
};
// This generated class is to be used only via changeCachedRange()
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB>
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class ChangeCachedRangeActor final : public Actor<Void>, public ActorCallback< ChangeCachedRangeActor<DB>, 0, RangeResult >, public ActorCallback< ChangeCachedRangeActor<DB>, 1, RangeResult >, public ActorCallback< ChangeCachedRangeActor<DB>, 2, Void >, public ActorCallback< ChangeCachedRangeActor<DB>, 3, Void >, public FastAllocated<ChangeCachedRangeActor<DB>>, public ChangeCachedRangeActorState<DB, ChangeCachedRangeActor<DB>> {
															#line 871 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
public:
	using FastAllocated<ChangeCachedRangeActor<DB>>::operator new;
	using FastAllocated<ChangeCachedRangeActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14111508557931039744UL, 11335377787255407872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeCachedRangeActor<DB>, 0, RangeResult >;
friend struct ActorCallback< ChangeCachedRangeActor<DB>, 1, RangeResult >;
friend struct ActorCallback< ChangeCachedRangeActor<DB>, 2, Void >;
friend struct ActorCallback< ChangeCachedRangeActor<DB>, 3, Void >;
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	ChangeCachedRangeActor(Reference<DB> const& db,KeyRangeRef const& range,bool const& add) 
															#line 891 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		 : Actor<Void>(),
		   ChangeCachedRangeActorState<DB, ChangeCachedRangeActor<DB>>(db, range, add),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeCachedRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12750184594942221824UL, 16608424142473833216UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCachedRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeCachedRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeCachedRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeCachedRangeActor<DB>, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeCachedRangeActor<DB>, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangeCachedRangeActor<DB>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ChangeCachedRangeActor<DB>, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB>
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
[[nodiscard]] Future<Void> changeCachedRange( Reference<DB> const& db, KeyRangeRef const& range, bool const& add ) {
															#line 143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	return Future<Void>(new ChangeCachedRangeActor<DB>(db, range, add));
															#line 928 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
}

#line 203 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"

template <class DB>
Future<Void> addCachedRange(Reference<DB> db, KeyRangeRef range) {
	return changeCachedRange(db, range, true);
}

template <class DB>
Future<Void> removeCachedRange(Reference<DB> db, KeyRangeRef range) {
	return changeCachedRange(db, range, false);
}

															#line 943 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
// This generated class is to be used only via getWorkers()
															#line 214 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class Tr, class GetWorkersActor>
															#line 214 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class GetWorkersActorState {
															#line 949 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
public:
															#line 214 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	GetWorkersActorState(Reference<Tr> const& tr,typename Tr::template FutureT<RangeResult> const& processClassesF,typename Tr::template FutureT<RangeResult> const& processDataF) 
															#line 214 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
															#line 214 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		 : tr(tr),
															#line 214 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   processClassesF(processClassesF),
															#line 214 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   processDataF(processDataF)
															#line 960 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
	{
		fdb_probe_actor_create("getWorkers", reinterpret_cast<unsigned long>(this));

	}
	~GetWorkersActorState() 
	{
		fdb_probe_actor_destroy("getWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 219 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			processClassesF = tr->getRange(processClassKeys, CLIENT_KNOBS->TOO_MANY);
															#line 220 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			processDataF = tr->getRange(workerListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 221 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			processClasses = safeThreadFutureToFuture(processClassesF);
															#line 222 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			processData = safeThreadFutureToFuture(processDataF);
															#line 224 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Void> __when_expr_0 = success(processClasses) && success(processData);
															#line 224 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<GetWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 985 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetWorkersActor*>(this)->actor_wait_state = 1;
															#line 224 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetWorkersActor, 0, Void >*>(static_cast<GetWorkersActor*>(this)));
															#line 990 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetWorkersActorState();
		static_cast<GetWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 225 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!processClasses.get().more && processClasses.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 226 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!processData.get().more && processData.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 228 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::map<Optional<Standalone<StringRef>>, ProcessClass> id_class;
															#line 229 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for(int i = 0;i < processClasses.get().size();i++) {
															#line 230 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			id_class[decodeProcessClassKey(processClasses.get()[i].key)] = decodeProcessClassValue(processClasses.get()[i].value);
															#line 1021 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 234 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::vector<ProcessData> results;
															#line 236 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for(int i = 0;i < processData.get().size();i++) {
															#line 237 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ProcessData data = decodeWorkerListValue(processData.get()[i].value);
															#line 238 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ProcessClass processClass = id_class[data.locality.processId()];
															#line 240 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (processClass.classSource() == ProcessClass::DBSource || data.processClass.classType() == ProcessClass::UnsetClass)
															#line 1033 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 242 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				data.processClass = processClass;
															#line 1037 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
															#line 244 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (data.processClass.classType() != ProcessClass::TesterClass)
															#line 1041 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 245 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				results.push_back(data);
															#line 1045 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 248 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!static_cast<GetWorkersActor*>(this)->SAV<std::vector<ProcessData>>::futures) { (void)(results); this->~GetWorkersActorState(); static_cast<GetWorkersActor*>(this)->destroy(); return 0; }
															#line 1050 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		new (&static_cast<GetWorkersActor*>(this)->SAV< std::vector<ProcessData> >::value()) std::vector<ProcessData>(results);
		this->~GetWorkersActorState();
		static_cast<GetWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 225 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!processClasses.get().more && processClasses.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 226 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!processData.get().more && processData.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 228 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::map<Optional<Standalone<StringRef>>, ProcessClass> id_class;
															#line 229 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for(int i = 0;i < processClasses.get().size();i++) {
															#line 230 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			id_class[decodeProcessClassKey(processClasses.get()[i].key)] = decodeProcessClassValue(processClasses.get()[i].value);
															#line 1070 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 234 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::vector<ProcessData> results;
															#line 236 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for(int i = 0;i < processData.get().size();i++) {
															#line 237 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ProcessData data = decodeWorkerListValue(processData.get()[i].value);
															#line 238 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ProcessClass processClass = id_class[data.locality.processId()];
															#line 240 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (processClass.classSource() == ProcessClass::DBSource || data.processClass.classType() == ProcessClass::UnsetClass)
															#line 1082 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 242 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				data.processClass = processClass;
															#line 1086 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
															#line 244 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (data.processClass.classType() != ProcessClass::TesterClass)
															#line 1090 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 245 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				results.push_back(data);
															#line 1094 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 248 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!static_cast<GetWorkersActor*>(this)->SAV<std::vector<ProcessData>>::futures) { (void)(results); this->~GetWorkersActorState(); static_cast<GetWorkersActor*>(this)->destroy(); return 0; }
															#line 1099 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		new (&static_cast<GetWorkersActor*>(this)->SAV< std::vector<ProcessData> >::value()) std::vector<ProcessData>(results);
		this->~GetWorkersActorState();
		static_cast<GetWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetWorkersActor*>(this)->ActorCallback< GetWorkersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetWorkersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetWorkersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetWorkersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 214 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Reference<Tr> tr;
															#line 214 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename Tr::template FutureT<RangeResult> processClassesF;
															#line 214 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename Tr::template FutureT<RangeResult> processDataF;
															#line 221 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<RangeResult> processClasses;
															#line 222 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<RangeResult> processData;
															#line 1192 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
};
// This generated class is to be used only via getWorkers()
															#line 214 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class Tr>
															#line 214 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class GetWorkersActor final : public Actor<std::vector<ProcessData>>, public ActorCallback< GetWorkersActor<Tr>, 0, Void >, public FastAllocated<GetWorkersActor<Tr>>, public GetWorkersActorState<Tr, GetWorkersActor<Tr>> {
															#line 1199 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
public:
	using FastAllocated<GetWorkersActor<Tr>>::operator new;
	using FastAllocated<GetWorkersActor<Tr>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13674478850358682112UL, 8655021942892422912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<ProcessData>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetWorkersActor<Tr>, 0, Void >;
															#line 214 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	GetWorkersActor(Reference<Tr> const& tr,typename Tr::template FutureT<RangeResult> const& processClassesF,typename Tr::template FutureT<RangeResult> const& processDataF) 
															#line 1216 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		 : Actor<std::vector<ProcessData>>(),
		   GetWorkersActorState<Tr, GetWorkersActor<Tr>>(tr, processClassesF, processDataF),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14779239272732970240UL, 16642038601798370048UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetWorkersActor<Tr>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 214 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class Tr>
															#line 214 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
[[nodiscard]] Future<std::vector<ProcessData>> getWorkers( Reference<Tr> const& tr, typename Tr::template FutureT<RangeResult> const& processClassesF, typename Tr::template FutureT<RangeResult> const& processDataF ) {
															#line 214 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	return Future<std::vector<ProcessData>>(new GetWorkersActor<Tr>(tr, processClassesF, processDataF));
															#line 1250 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
}

#line 250 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"

// All versions of changeConfig apply the given set of configuration tokens to the database, and return a
// ConfigurationResult (or error).

// Accepts a full configuration in key/value format (from buildConfiguration)
															#line 1259 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
// This generated class is to be used only via changeConfig()
															#line 255 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB, class ChangeConfigActor>
															#line 255 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class ChangeConfigActorState {
															#line 1265 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
public:
															#line 255 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	ChangeConfigActorState(Reference<DB> const& db,std::map<std::string, std::string> const& m,bool const& force) 
															#line 255 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
															#line 255 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		 : db(db),
															#line 255 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   m(m),
															#line 255 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   force(force),
															#line 257 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   initIdKey("\xff/init_id"_sr),
															#line 258 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   tr(db->createTransaction())
															#line 1280 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
	{
		fdb_probe_actor_create("changeConfig", reinterpret_cast<unsigned long>(this));

	}
	~ChangeConfigActorState() 
	{
		fdb_probe_actor_destroy("changeConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 260 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!m.size())
															#line 1295 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 261 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NO_OPTIONS_PROVIDED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1299 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NO_OPTIONS_PROVIDED);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 265 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::string initKey = configKeysPrefix.toString() + "initialized";
															#line 266 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			creating = m.count(initKey) != 0;
															#line 267 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			locked = Optional<UID>();
															#line 1311 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 269 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				auto iter = m.find(databaseLockedKey.toString());
															#line 270 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (iter != m.end())
															#line 1317 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 271 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!creating)
															#line 1321 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					{
															#line 272 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::LOCKED_NOT_NEW); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1325 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
						new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::LOCKED_NOT_NEW);
						this->~ChangeConfigActorState();
						static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 274 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					locked = UID::fromString(iter->second);
															#line 275 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					m.erase(iter);
															#line 1335 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
			}
															#line 278 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (creating)
															#line 1340 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 279 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				m[initIdKey.toString()] = deterministicRandom()->randomUniqueID().toString();
															#line 280 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!isCompleteConfiguration(m))
															#line 1346 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 281 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INCOMPLETE_CONFIGURATION); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1350 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INCOMPLETE_CONFIGURATION);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 283 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!isEncryptionAtRestModeConfigValid(Optional<DatabaseConfiguration>(), m, creating))
															#line 1358 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 284 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INVALID_CONFIGURATION); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1362 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INVALID_CONFIGURATION);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
			else
			{
															#line 286 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (m.count(encryptionAtRestModeConfKey.toString()) != 0)
															#line 1373 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 288 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::ENCRYPTION_AT_REST_MODE_ALREADY_SET); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1377 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::ENCRYPTION_AT_REST_MODE_ALREADY_SET);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 291 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tooLong = delay(60);
															#line 292 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			versionKey = BinaryWriter::toValue(deterministicRandom()->randomUniqueID(), Unversioned());
															#line 293 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldReplicationUsesDcId = false;
															#line 296 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			resetPPWStats = false;
															#line 297 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			warnPPWGradual = false;
															#line 298 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			warnShardedRocksDBIsExperimental = false;
															#line 300 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			;
															#line 1398 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeConfigActorState();
		static_cast<ChangeConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 579 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (warnPPWGradual)
															#line 1421 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 580 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::SUCCESS_WARN_PPW_GRADUAL); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1425 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::SUCCESS_WARN_PPW_GRADUAL);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 581 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (warnShardedRocksDBIsExperimental)
															#line 1435 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 582 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::SUCCESS_WARN_SHARDED_ROCKSDB_EXPERIMENTAL); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1439 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::SUCCESS_WARN_SHARDED_ROCKSDB_EXPERIMENTAL);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 584 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::SUCCESS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1449 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::SUCCESS);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 302 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 303 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 304 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 305 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::USE_PROVISIONAL_PROXIES);
															#line 307 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!creating && !force)
															#line 1479 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 308 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				fConfigF = tr->getRange(configKeys, CLIENT_KNOBS->TOO_MANY);
															#line 310 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				fConfig = safeThreadFutureToFuture(fConfigF);
															#line 311 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				processClassesF = typename DB::TransactionT::template FutureT<RangeResult>();
															#line 312 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				processDataF = typename DB::TransactionT::template FutureT<RangeResult>();
															#line 313 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				fWorkers = getWorkers(tr, processClassesF, processDataF);
															#line 314 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				StrictFuture<Void> __when_expr_0 = success(fConfig) || tooLong;
															#line 314 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1495 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ChangeConfigActor*>(this)->actor_wait_state = 1;
															#line 314 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 0, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 1500 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 549 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			e1 = Error(e);
															#line 550 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if ((e.code() == error_code_not_committed || e.code() == error_code_transaction_too_old) && creating)
															#line 1542 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 553 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->reset();
															#line 554 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				;
															#line 1548 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				loopDepth = a_body1loopBody1Catch1loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 507 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (creating)
															#line 1568 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 508 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::INITIALIZE_NEW_DATABASE);
															#line 509 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->addReadConflictRange(singleKeyRange(initIdKey));
															#line 1574 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
		else
		{
															#line 510 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (m.size())
															#line 1580 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 513 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->setOption(FDBTransactionOptions::CAUSAL_WRITE_RISKY);
															#line 514 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->addReadConflictRange(singleKeyRange(m.begin()->first));
															#line 1586 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 517 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (locked.present())
															#line 1591 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 518 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ASSERT(creating);
															#line 519 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->atomicOp(databaseLockedKey, BinaryWriter::toValue(locked.get(), Unversioned()) .withPrefix("0123456789"_sr) .withSuffix("\x00\x00\x00\x00"_sr), MutationRef::SetVersionstampedValue);
															#line 1597 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 526 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for(auto i = m.begin();i != m.end();++i) {
															#line 527 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(StringRef(i->first), StringRef(i->second));
															#line 528 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (i->first == perpetualStorageWiggleKey)
															#line 1605 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 529 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (i->second == "0")
															#line 1609 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 530 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					resetPPWStats = true;
															#line 1613 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
				else
				{
															#line 531 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (i->first == "1")
															#line 1619 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					{
															#line 532 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						resetPPWStats = false;
															#line 1623 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					}
				}
			}
		}
															#line 537 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!creating && resetPPWStats)
															#line 1630 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 538 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			wiggleData = StorageWiggleData();
															#line 539 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Void> __when_expr_6 = wiggleData.resetStorageWiggleMetrics(tr, PrimaryRegion(true));
															#line 539 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1638 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
			static_cast<ChangeConfigActor*>(this)->actor_wait_state = 7;
															#line 539 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 6, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 1643 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont24(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 316 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fConfig.isReady())
															#line 1657 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 317 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1661 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 320 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (fConfig.isReady())
															#line 1669 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 321 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ASSERT(fConfig.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 322 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldConfig = DatabaseConfiguration();
															#line 323 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldConfig.fromKeyValues((VectorRef<KeyValueRef>)fConfig.get());
															#line 324 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			newConfig = oldConfig;
															#line 325 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto kv : m ) {
															#line 326 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				newConfig.set(kv.first, kv.second);
															#line 1683 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
															#line 328 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!newConfig.isValid() || !isEncryptionAtRestModeConfigValid(oldConfig, m, creating) || !isTenantModeModeConfigValid(oldConfig, newConfig))
															#line 1687 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 330 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INVALID_CONFIGURATION); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1691 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INVALID_CONFIGURATION);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 333 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (newConfig.tLogPolicy->attributeKeys().count("dcid") && newConfig.regions.size() > 0)
															#line 1699 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 334 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::REGION_REPLICATION_MISMATCH); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1703 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::REGION_REPLICATION_MISMATCH);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 337 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldReplicationUsesDcId = oldReplicationUsesDcId || oldConfig.tLogPolicy->attributeKeys().count("dcid");
															#line 340 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (oldConfig.usableRegions != newConfig.usableRegions)
															#line 1713 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 342 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				std::map<Key, int32_t> dcId_priority;
															#line 343 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				for( auto& it : newConfig.regions ) {
															#line 344 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					dcId_priority[it.dcId] = it.priority;
															#line 1721 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
															#line 346 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				for( auto& it : oldConfig.regions ) {
															#line 347 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!dcId_priority.count(it.dcId) || dcId_priority[it.dcId] != it.priority)
															#line 1727 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					{
															#line 348 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::REGIONS_CHANGED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1731 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
						new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::REGIONS_CHANGED);
						this->~ChangeConfigActorState();
						static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
															#line 353 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				int activeRegionCount = 0;
															#line 354 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				for( auto& it : newConfig.regions ) {
															#line 355 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (it.priority >= 0)
															#line 1744 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					{
															#line 356 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						activeRegionCount++;
															#line 1748 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					}
				}
															#line 359 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (activeRegionCount > 1)
															#line 1753 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 360 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::MULTIPLE_ACTIVE_REGIONS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1757 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::MULTIPLE_ACTIVE_REGIONS);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 364 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			fServerListF = tr->getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 366 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			fServerList = (newConfig.regions.size()) ? safeThreadFutureToFuture(fServerListF) : Future<RangeResult>();
															#line 369 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (newConfig.usableRegions == 2)
															#line 1770 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 370 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (oldReplicationUsesDcId)
															#line 1774 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 371 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					fLocalityListF = tr->getRange(tagLocalityListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 373 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					fLocalityList = safeThreadFutureToFuture(fLocalityListF);
															#line 374 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					StrictFuture<Void> __when_expr_1 = success(fLocalityList) || tooLong;
															#line 374 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1784 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
					static_cast<ChangeConfigActor*>(this)->actor_wait_state = 2;
															#line 374 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 1, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 1789 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					loopDepth = 0;
				}
				else
				{
															#line 396 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					replicasFuturesF = std::vector<typename DB::TransactionT::template FutureT<Optional<Value>>>();
															#line 398 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					replicasFutures = std::vector<Future<Optional<Value>>>();
															#line 399 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					for( auto& it : newConfig.regions ) {
															#line 400 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (it.priority >= 0)
															#line 1802 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
						{
															#line 401 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
							replicasFuturesF.push_back(tr->get(datacenterReplicasKeyFor(it.dcId)));
															#line 402 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
							replicasFutures.push_back(safeThreadFutureToFuture(replicasFuturesF.back()));
															#line 1808 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
						}
					}
															#line 405 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					StrictFuture<Void> __when_expr_2 = waitForAll(replicasFutures) || tooLong;
															#line 405 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1815 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when2(__when_expr_2.get(), loopDepth); };
					static_cast<ChangeConfigActor*>(this)->actor_wait_state = 3;
															#line 405 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 2, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 1820 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					loopDepth = 0;
				}
			}
			else
			{
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 316 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fConfig.isReady())
															#line 1840 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 317 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1844 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 320 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (fConfig.isReady())
															#line 1852 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 321 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			ASSERT(fConfig.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 322 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldConfig = DatabaseConfiguration();
															#line 323 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldConfig.fromKeyValues((VectorRef<KeyValueRef>)fConfig.get());
															#line 324 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			newConfig = oldConfig;
															#line 325 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto kv : m ) {
															#line 326 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				newConfig.set(kv.first, kv.second);
															#line 1866 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
															#line 328 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!newConfig.isValid() || !isEncryptionAtRestModeConfigValid(oldConfig, m, creating) || !isTenantModeModeConfigValid(oldConfig, newConfig))
															#line 1870 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 330 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INVALID_CONFIGURATION); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1874 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INVALID_CONFIGURATION);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 333 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (newConfig.tLogPolicy->attributeKeys().count("dcid") && newConfig.regions.size() > 0)
															#line 1882 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 334 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::REGION_REPLICATION_MISMATCH); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1886 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::REGION_REPLICATION_MISMATCH);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 337 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			oldReplicationUsesDcId = oldReplicationUsesDcId || oldConfig.tLogPolicy->attributeKeys().count("dcid");
															#line 340 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (oldConfig.usableRegions != newConfig.usableRegions)
															#line 1896 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 342 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				std::map<Key, int32_t> dcId_priority;
															#line 343 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				for( auto& it : newConfig.regions ) {
															#line 344 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					dcId_priority[it.dcId] = it.priority;
															#line 1904 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
															#line 346 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				for( auto& it : oldConfig.regions ) {
															#line 347 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!dcId_priority.count(it.dcId) || dcId_priority[it.dcId] != it.priority)
															#line 1910 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					{
															#line 348 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::REGIONS_CHANGED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1914 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
						new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::REGIONS_CHANGED);
						this->~ChangeConfigActorState();
						static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
															#line 353 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				int activeRegionCount = 0;
															#line 354 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				for( auto& it : newConfig.regions ) {
															#line 355 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (it.priority >= 0)
															#line 1927 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					{
															#line 356 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						activeRegionCount++;
															#line 1931 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					}
				}
															#line 359 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (activeRegionCount > 1)
															#line 1936 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 360 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::MULTIPLE_ACTIVE_REGIONS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 1940 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::MULTIPLE_ACTIVE_REGIONS);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 364 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			fServerListF = tr->getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 366 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			fServerList = (newConfig.regions.size()) ? safeThreadFutureToFuture(fServerListF) : Future<RangeResult>();
															#line 369 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (newConfig.usableRegions == 2)
															#line 1953 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 370 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (oldReplicationUsesDcId)
															#line 1957 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 371 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					fLocalityListF = tr->getRange(tagLocalityListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 373 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					fLocalityList = safeThreadFutureToFuture(fLocalityListF);
															#line 374 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					StrictFuture<Void> __when_expr_1 = success(fLocalityList) || tooLong;
															#line 374 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1967 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
					static_cast<ChangeConfigActor*>(this)->actor_wait_state = 2;
															#line 374 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 1, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 1972 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					loopDepth = 0;
				}
				else
				{
															#line 396 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					replicasFuturesF = std::vector<typename DB::TransactionT::template FutureT<Optional<Value>>>();
															#line 398 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					replicasFutures = std::vector<Future<Optional<Value>>>();
															#line 399 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					for( auto& it : newConfig.regions ) {
															#line 400 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (it.priority >= 0)
															#line 1985 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
						{
															#line 401 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
							replicasFuturesF.push_back(tr->get(datacenterReplicasKeyFor(it.dcId)));
															#line 402 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
							replicasFutures.push_back(safeThreadFutureToFuture(replicasFuturesF.back()));
															#line 1991 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
						}
					}
															#line 405 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					StrictFuture<Void> __when_expr_2 = waitForAll(replicasFutures) || tooLong;
															#line 405 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1998 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when2(__when_expr_2.get(), loopDepth); };
					static_cast<ChangeConfigActor*>(this)->actor_wait_state = 3;
															#line 405 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 2, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 2003 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					loopDepth = 0;
				}
			}
			else
			{
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 418 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (newConfig.regions.size())
															#line 2104 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 420 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Void> __when_expr_3 = success(fServerList) || tooLong;
															#line 420 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2110 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
			static_cast<ChangeConfigActor*>(this)->actor_wait_state = 4;
															#line 420 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 3, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 2115 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont22(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont17(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont18(Void const& _,int loopDepth) 
	{
															#line 375 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fLocalityList.isReady())
															#line 2135 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 376 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2139 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 378 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		RangeResult localityList = fLocalityList.get();
															#line 379 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!localityList.more && localityList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 381 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::set<Key> localityDcIds;
															#line 382 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& s : localityList ) {
															#line 383 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			auto dc = decodeTagLocalityListKey(s.key);
															#line 384 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (dc.present())
															#line 2157 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 385 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				localityDcIds.insert(dc.get());
															#line 2161 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 389 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : newConfig.regions ) {
															#line 390 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (localityDcIds.count(it.dcId) == 0)
															#line 2168 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 391 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DCID_MISSING); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2172 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DCID_MISSING);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		loopDepth = a_body1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont18(Void && _,int loopDepth) 
	{
															#line 375 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fLocalityList.isReady())
															#line 2187 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 376 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2191 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 378 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		RangeResult localityList = fLocalityList.get();
															#line 379 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!localityList.more && localityList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 381 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::set<Key> localityDcIds;
															#line 382 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& s : localityList ) {
															#line 383 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			auto dc = decodeTagLocalityListKey(s.key);
															#line 384 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (dc.present())
															#line 2209 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 385 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				localityDcIds.insert(dc.get());
															#line 2213 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 389 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : newConfig.regions ) {
															#line 390 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (localityDcIds.count(it.dcId) == 0)
															#line 2220 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 391 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DCID_MISSING); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2224 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DCID_MISSING);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		loopDepth = a_body1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont18(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont18(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont19(Void const& _,int loopDepth) 
	{
															#line 407 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : replicasFutures ) {
															#line 408 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!it.isReady())
															#line 2316 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 409 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2320 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 411 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!it.get().present())
															#line 2328 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 412 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::REGION_NOT_FULLY_REPLICATED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2332 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::REGION_NOT_FULLY_REPLICATED);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		loopDepth = a_body1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19(Void && _,int loopDepth) 
	{
															#line 407 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : replicasFutures ) {
															#line 408 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!it.isReady())
															#line 2349 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 409 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2353 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 411 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!it.get().present())
															#line 2361 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 412 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::REGION_NOT_FULLY_REPLICATED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2365 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::REGION_NOT_FULLY_REPLICATED);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		loopDepth = a_body1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont22(int loopDepth) 
	{
															#line 443 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_4 = success(fWorkers) || tooLong;
															#line 443 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2457 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont22when1(__when_expr_4.get(), loopDepth); };
		static_cast<ChangeConfigActor*>(this)->actor_wait_state = 5;
															#line 443 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 4, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 2462 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont23(Void const& _,int loopDepth) 
	{
															#line 421 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fServerList.isReady())
															#line 2471 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 422 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2475 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 424 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		RangeResult serverList = fServerList.get();
															#line 425 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 427 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::set<Key> newDcIds;
															#line 428 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : newConfig.regions ) {
															#line 429 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			newDcIds.insert(it.dcId);
															#line 2491 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 431 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::set<Optional<Key>> missingDcIds;
															#line 432 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& s : serverList ) {
															#line 433 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			auto ssi = decodeServerListValue(s.value);
															#line 434 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!ssi.locality.dcId().present() || !newDcIds.count(ssi.locality.dcId().get()))
															#line 2501 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 435 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				missingDcIds.insert(ssi.locality.dcId());
															#line 2505 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 438 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (missingDcIds.size() > (oldReplicationUsesDcId ? 1 : 0))
															#line 2510 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 439 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::STORAGE_IN_UNKNOWN_DCID); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2514 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::STORAGE_IN_UNKNOWN_DCID);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont22(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont23(Void && _,int loopDepth) 
	{
															#line 421 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fServerList.isReady())
															#line 2528 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 422 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2532 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 424 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		RangeResult serverList = fServerList.get();
															#line 425 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 427 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::set<Key> newDcIds;
															#line 428 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : newConfig.regions ) {
															#line 429 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			newDcIds.insert(it.dcId);
															#line 2548 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 431 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::set<Optional<Key>> missingDcIds;
															#line 432 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& s : serverList ) {
															#line 433 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			auto ssi = decodeServerListValue(s.value);
															#line 434 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!ssi.locality.dcId().present() || !newDcIds.count(ssi.locality.dcId().get()))
															#line 2558 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 435 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				missingDcIds.insert(ssi.locality.dcId());
															#line 2562 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 438 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (missingDcIds.size() > (oldReplicationUsesDcId ? 1 : 0))
															#line 2567 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 439 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::STORAGE_IN_UNKNOWN_DCID); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2571 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::STORAGE_IN_UNKNOWN_DCID);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont22(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont23(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont23(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont22cont1(Void const& _,int loopDepth) 
	{
															#line 444 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fWorkers.isReady())
															#line 2660 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 445 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2664 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 448 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (newConfig.regions.size())
															#line 2672 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 449 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::map<Optional<Key>, std::set<Optional<Key>>> dcId_zoneIds;
															#line 450 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& it : fWorkers.get() ) {
															#line 451 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (it.processClass.machineClassFitness(ProcessClass::Storage) <= ProcessClass::WorstFit)
															#line 2680 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 452 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					dcId_zoneIds[it.locality.dcId()].insert(it.locality.zoneId());
															#line 2684 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
			}
															#line 455 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& region : newConfig.regions ) {
															#line 456 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (dcId_zoneIds[region.dcId].size() < std::max(newConfig.storageTeamSize, newConfig.tLogReplicationFactor))
															#line 2691 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 458 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NOT_ENOUGH_WORKERS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2695 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NOT_ENOUGH_WORKERS);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 460 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (region.satelliteTLogReplicationFactor > 0 && region.priority >= 0)
															#line 2703 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 461 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					int totalSatelliteProcesses = 0;
															#line 462 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					for( auto& sat : region.satellites ) {
															#line 463 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						totalSatelliteProcesses += dcId_zoneIds[sat.dcId].size();
															#line 2711 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					}
															#line 465 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (totalSatelliteProcesses < region.satelliteTLogReplicationFactor)
															#line 2715 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					{
															#line 466 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NOT_ENOUGH_WORKERS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2719 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
						new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NOT_ENOUGH_WORKERS);
						this->~ChangeConfigActorState();
						static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
		}
		else
		{
															#line 471 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::set<Optional<Key>> zoneIds;
															#line 472 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& it : fWorkers.get() ) {
															#line 473 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (it.processClass.machineClassFitness(ProcessClass::Storage) <= ProcessClass::WorstFit)
															#line 2736 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 474 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					zoneIds.insert(it.locality.zoneId());
															#line 2740 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
			}
															#line 477 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (zoneIds.size() < std::max(newConfig.storageTeamSize, newConfig.tLogReplicationFactor))
															#line 2745 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 478 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NOT_ENOUGH_WORKERS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2749 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NOT_ENOUGH_WORKERS);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 482 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!newConfig.storageServerStoreType.isValid() || !newConfig.tLogDataStoreType.isValid())
															#line 2758 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 483 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INVALID_STORAGE_TYPE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2762 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INVALID_STORAGE_TYPE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 486 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (newConfig.storageServerStoreType != oldConfig.storageServerStoreType && newConfig.storageMigrationType == StorageMigrationType::DISABLED)
															#line 2770 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 488 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::STORAGE_MIGRATION_DISABLED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2774 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::STORAGE_MIGRATION_DISABLED);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 489 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (newConfig.storageMigrationType == StorageMigrationType::GRADUAL && newConfig.perpetualStorageWiggleSpeed == 0)
															#line 2784 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 491 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				warnPPWGradual = true;
															#line 2788 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
			else
			{
															#line 492 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (newConfig.storageServerStoreType != oldConfig.storageServerStoreType && newConfig.storageServerStoreType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
															#line 2794 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 494 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					warnShardedRocksDBIsExperimental = true;
															#line 2798 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
			}
		}
															#line 497 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (newConfig.tenantMode != oldConfig.tenantMode)
															#line 2804 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 498 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_5 = metacluster::metadata::metaclusterRegistration().get(tr);
															#line 498 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2810 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont22cont1when1(__when_expr_5.get(), loopDepth); };
			static_cast<ChangeConfigActor*>(this)->actor_wait_state = 6;
															#line 498 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 5, Optional<MetaclusterRegistrationEntry> >*>(static_cast<ChangeConfigActor*>(this)));
															#line 2815 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont22cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont22cont1(Void && _,int loopDepth) 
	{
															#line 444 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!fWorkers.isReady())
															#line 2829 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 445 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_UNAVAILABLE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2833 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_UNAVAILABLE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 448 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (newConfig.regions.size())
															#line 2841 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 449 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::map<Optional<Key>, std::set<Optional<Key>>> dcId_zoneIds;
															#line 450 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& it : fWorkers.get() ) {
															#line 451 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (it.processClass.machineClassFitness(ProcessClass::Storage) <= ProcessClass::WorstFit)
															#line 2849 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 452 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					dcId_zoneIds[it.locality.dcId()].insert(it.locality.zoneId());
															#line 2853 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
			}
															#line 455 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& region : newConfig.regions ) {
															#line 456 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (dcId_zoneIds[region.dcId].size() < std::max(newConfig.storageTeamSize, newConfig.tLogReplicationFactor))
															#line 2860 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 458 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NOT_ENOUGH_WORKERS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2864 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NOT_ENOUGH_WORKERS);
					this->~ChangeConfigActorState();
					static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 460 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (region.satelliteTLogReplicationFactor > 0 && region.priority >= 0)
															#line 2872 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 461 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					int totalSatelliteProcesses = 0;
															#line 462 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					for( auto& sat : region.satellites ) {
															#line 463 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						totalSatelliteProcesses += dcId_zoneIds[sat.dcId].size();
															#line 2880 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					}
															#line 465 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					if (totalSatelliteProcesses < region.satelliteTLogReplicationFactor)
															#line 2884 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
					{
															#line 466 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
						if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NOT_ENOUGH_WORKERS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2888 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
						new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NOT_ENOUGH_WORKERS);
						this->~ChangeConfigActorState();
						static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
		}
		else
		{
															#line 471 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::set<Optional<Key>> zoneIds;
															#line 472 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& it : fWorkers.get() ) {
															#line 473 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (it.processClass.machineClassFitness(ProcessClass::Storage) <= ProcessClass::WorstFit)
															#line 2905 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 474 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					zoneIds.insert(it.locality.zoneId());
															#line 2909 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
			}
															#line 477 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (zoneIds.size() < std::max(newConfig.storageTeamSize, newConfig.tLogReplicationFactor))
															#line 2914 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 478 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::NOT_ENOUGH_WORKERS); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2918 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::NOT_ENOUGH_WORKERS);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 482 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!newConfig.storageServerStoreType.isValid() || !newConfig.tLogDataStoreType.isValid())
															#line 2927 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 483 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INVALID_STORAGE_TYPE); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2931 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INVALID_STORAGE_TYPE);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 486 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (newConfig.storageServerStoreType != oldConfig.storageServerStoreType && newConfig.storageMigrationType == StorageMigrationType::DISABLED)
															#line 2939 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 488 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::STORAGE_MIGRATION_DISABLED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 2943 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::STORAGE_MIGRATION_DISABLED);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 489 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (newConfig.storageMigrationType == StorageMigrationType::GRADUAL && newConfig.perpetualStorageWiggleSpeed == 0)
															#line 2953 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 491 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				warnPPWGradual = true;
															#line 2957 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
			else
			{
															#line 492 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (newConfig.storageServerStoreType != oldConfig.storageServerStoreType && newConfig.storageServerStoreType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
															#line 2963 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				{
															#line 494 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
					warnShardedRocksDBIsExperimental = true;
															#line 2967 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				}
			}
		}
															#line 497 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (newConfig.tenantMode != oldConfig.tenantMode)
															#line 2973 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 498 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_5 = metacluster::metadata::metaclusterRegistration().get(tr);
															#line 498 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2979 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont22cont1when1(__when_expr_5.get(), loopDepth); };
			static_cast<ChangeConfigActor*>(this)->actor_wait_state = 6;
															#line 498 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 5, Optional<MetaclusterRegistrationEntry> >*>(static_cast<ChangeConfigActor*>(this)));
															#line 2984 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont22cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont22when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont22cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont22when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont22cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont22when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont22when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont22cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont22cont22(Optional<MetaclusterRegistrationEntry> const& metaclusterRegistration,int loopDepth) 
	{
															#line 500 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (metaclusterRegistration.present())
															#line 3079 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 501 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			CODE_PROBE(true, "Attempt to change tenant mode in a metacluster", probe::decoration::rare);
															#line 502 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_IS_REGISTERED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 3085 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_IS_REGISTERED);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont22cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont22cont22(Optional<MetaclusterRegistrationEntry> && metaclusterRegistration,int loopDepth) 
	{
															#line 500 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (metaclusterRegistration.present())
															#line 3099 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 501 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			CODE_PROBE(true, "Attempt to change tenant mode in a metacluster", probe::decoration::rare);
															#line 502 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_IS_REGISTERED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 3105 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_IS_REGISTERED);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont22cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont22cont1when1(Optional<MetaclusterRegistrationEntry> const& metaclusterRegistration,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont22cont22(metaclusterRegistration, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont22cont1when1(Optional<MetaclusterRegistrationEntry> && metaclusterRegistration,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont22cont22(std::move(metaclusterRegistration), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 5, Optional<MetaclusterRegistrationEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 5, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont22cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 5, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont22cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 5, Optional<MetaclusterRegistrationEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont24(int loopDepth) 
	{
															#line 543 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->addReadConflictRange(singleKeyRange(moveKeysLockOwnerKey));
															#line 544 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->set(moveKeysLockOwnerKey, versionKey);
															#line 546 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_8 = safeThreadFutureToFuture(tr->commit());
															#line 546 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3200 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1cont24when1(__when_expr_8.get(), loopDepth); };
		static_cast<ChangeConfigActor*>(this)->actor_wait_state = 9;
															#line 546 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 8, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 3205 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont34(Void const& _,int loopDepth) 
	{
															#line 540 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_7 = wiggleData.resetStorageWiggleMetrics(tr, PrimaryRegion(false));
															#line 540 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3216 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont34when1(__when_expr_7.get(), loopDepth); };
		static_cast<ChangeConfigActor*>(this)->actor_wait_state = 8;
															#line 540 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 7, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 3221 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont34(Void && _,int loopDepth) 
	{
															#line 540 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_7 = wiggleData.resetStorageWiggleMetrics(tr, PrimaryRegion(false));
															#line 540 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3232 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont34when1(__when_expr_7.get(), loopDepth); };
		static_cast<ChangeConfigActor*>(this)->actor_wait_state = 8;
															#line 540 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 7, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 3237 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont34(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont34(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont34cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont24(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont34cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont24(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont34when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont34cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont34when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont34cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont34when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont34when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont24cont1(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont24cont1(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont24when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont24cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont24when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont24cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont24when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont24when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 575 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_11 = safeThreadFutureToFuture(tr->onError(e1));
															#line 575 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3497 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_11.get(), loopDepth); };
		static_cast<ChangeConfigActor*>(this)->actor_wait_state = 12;
															#line 575 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 11, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 3502 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1Catch1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1(int loopDepth) 
	{
		try {
															#line 556 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 557 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 558 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 559 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::USE_PROVISIONAL_PROXIES);
															#line 561 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			vF = tr->get(initIdKey);
															#line 562 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Optional<Value>> __when_expr_9 = safeThreadFutureToFuture(vF);
															#line 562 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3531 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1loopBody1Catch1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1loopBody1Catch1loopBody1when1(__when_expr_9.get(), loopDepth); };
			static_cast<ChangeConfigActor*>(this)->actor_wait_state = 10;
															#line 562 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 9, Optional<Value> >*>(static_cast<ChangeConfigActor*>(this)));
															#line 3536 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1Catch1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1Catch1(const Error& e2,int loopDepth=0) 
	{
		try {
															#line 571 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Void> __when_expr_10 = safeThreadFutureToFuture(tr->onError(e2));
															#line 571 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<ChangeConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3560 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1Catch1loopBody1Catch1when1(__when_expr_10.get(), loopDepth); };
			static_cast<ChangeConfigActor*>(this)->actor_wait_state = 11;
															#line 571 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigActor, 10, Void >*>(static_cast<ChangeConfigActor*>(this)));
															#line 3565 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont2(Optional<Value> const& v,int loopDepth) 
	{
															#line 563 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (v != m[initIdKey.toString()])
															#line 3580 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 564 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_ALREADY_CREATED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 3584 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_ALREADY_CREATED);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 565 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (m[configKeysPrefix.toString() + "storage_engine"] == std::to_string(KeyValueStoreType::SSD_SHARDED_ROCKSDB))
															#line 3594 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 567 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_CREATED_WARN_SHARDED_ROCKSDB_EXPERIMENTAL); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 3598 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_CREATED_WARN_SHARDED_ROCKSDB_EXPERIMENTAL);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 569 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_CREATED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 3608 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_CREATED);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont2(Optional<Value> && v,int loopDepth) 
	{
															#line 563 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (v != m[initIdKey.toString()])
															#line 3622 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 564 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_ALREADY_CREATED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 3626 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_ALREADY_CREATED);
			this->~ChangeConfigActorState();
			static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 565 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (m[configKeysPrefix.toString() + "storage_engine"] == std::to_string(KeyValueStoreType::SSD_SHARDED_ROCKSDB))
															#line 3636 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 567 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_CREATED_WARN_SHARDED_ROCKSDB_EXPERIMENTAL); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 3640 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_CREATED_WARN_SHARDED_ROCKSDB_EXPERIMENTAL);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 569 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<ChangeConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::DATABASE_CREATED); this->~ChangeConfigActorState(); static_cast<ChangeConfigActor*>(this)->destroy(); return 0; }
															#line 3650 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<ChangeConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::DATABASE_CREATED);
				this->~ChangeConfigActorState();
				static_cast<ChangeConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 9, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 9, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 9, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 9, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1Catch1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1Catch1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1Catch1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<ChangeConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigActor*>(this)->ActorCallback< ChangeConfigActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< ChangeConfigActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< ChangeConfigActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 255 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Reference<DB> db;
															#line 255 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	std::map<std::string, std::string> m;
															#line 255 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	bool force;
															#line 257 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	StringRef initIdKey;
															#line 258 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 266 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	bool creating;
															#line 267 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Optional<UID> locked;
															#line 291 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<Void> tooLong;
															#line 292 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Key versionKey;
															#line 293 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	bool oldReplicationUsesDcId;
															#line 296 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	bool resetPPWStats;
															#line 297 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	bool warnPPWGradual;
															#line 298 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	bool warnShardedRocksDBIsExperimental;
															#line 308 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> fConfigF;
															#line 310 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<RangeResult> fConfig;
															#line 311 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> processClassesF;
															#line 312 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> processDataF;
															#line 313 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<std::vector<ProcessData>> fWorkers;
															#line 322 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	DatabaseConfiguration oldConfig;
															#line 324 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	DatabaseConfiguration newConfig;
															#line 364 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> fServerListF;
															#line 366 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<RangeResult> fServerList;
															#line 371 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> fLocalityListF;
															#line 373 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Future<RangeResult> fLocalityList;
															#line 396 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	std::vector<typename DB::TransactionT::template FutureT<Optional<Value>>> replicasFuturesF;
															#line 398 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	std::vector<Future<Optional<Value>>> replicasFutures;
															#line 538 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	StorageWiggleData wiggleData;
															#line 549 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Error e1;
															#line 561 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<Optional<Value>> vF;
															#line 3967 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
};
// This generated class is to be used only via changeConfig()
															#line 255 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB>
															#line 255 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class ChangeConfigActor final : public Actor<ConfigurationResult>, public ActorCallback< ChangeConfigActor<DB>, 0, Void >, public ActorCallback< ChangeConfigActor<DB>, 1, Void >, public ActorCallback< ChangeConfigActor<DB>, 2, Void >, public ActorCallback< ChangeConfigActor<DB>, 3, Void >, public ActorCallback< ChangeConfigActor<DB>, 4, Void >, public ActorCallback< ChangeConfigActor<DB>, 5, Optional<MetaclusterRegistrationEntry> >, public ActorCallback< ChangeConfigActor<DB>, 6, Void >, public ActorCallback< ChangeConfigActor<DB>, 7, Void >, public ActorCallback< ChangeConfigActor<DB>, 8, Void >, public ActorCallback< ChangeConfigActor<DB>, 9, Optional<Value> >, public ActorCallback< ChangeConfigActor<DB>, 10, Void >, public ActorCallback< ChangeConfigActor<DB>, 11, Void >, public FastAllocated<ChangeConfigActor<DB>>, public ChangeConfigActorState<DB, ChangeConfigActor<DB>> {
															#line 3974 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
public:
	using FastAllocated<ChangeConfigActor<DB>>::operator new;
	using FastAllocated<ChangeConfigActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5779682323217641472UL, 14198175485470519808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ConfigurationResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeConfigActor<DB>, 0, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 1, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 2, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 3, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 4, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 5, Optional<MetaclusterRegistrationEntry> >;
friend struct ActorCallback< ChangeConfigActor<DB>, 6, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 7, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 8, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 9, Optional<Value> >;
friend struct ActorCallback< ChangeConfigActor<DB>, 10, Void >;
friend struct ActorCallback< ChangeConfigActor<DB>, 11, Void >;
															#line 255 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	ChangeConfigActor(Reference<DB> const& db,std::map<std::string, std::string> const& m,bool const& force) 
															#line 4002 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		 : Actor<ConfigurationResult>(),
		   ChangeConfigActorState<DB, ChangeConfigActor<DB>>(db, m, force),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6578240440549909504UL, 3862103298456711424UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 5, Optional<MetaclusterRegistrationEntry> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 9, Optional<Value> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< ChangeConfigActor<DB>, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 255 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB>
															#line 255 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
[[nodiscard]] Future<ConfigurationResult> changeConfig( Reference<DB> const& db, std::map<std::string, std::string> const& m, bool const& force ) {
															#line 255 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	return Future<ConfigurationResult>(new ChangeConfigActor<DB>(db, m, force));
															#line 4047 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
}

#line 587 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"

															#line 4052 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
// This generated class is to be used only via autoConfig()
															#line 588 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB, class AutoConfigActor>
															#line 588 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class AutoConfigActorState {
															#line 4058 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
public:
															#line 588 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	AutoConfigActorState(Reference<DB> const& db,ConfigureAutoResult const& conf) 
															#line 588 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
															#line 588 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		 : db(db),
															#line 588 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   conf(conf),
															#line 590 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   tr(db->createTransaction()),
															#line 591 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		   versionKey(BinaryWriter::toValue(deterministicRandom()->randomUniqueID(), Unversioned()))
															#line 4071 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
	{
		fdb_probe_actor_create("autoConfig", reinterpret_cast<unsigned long>(this));

	}
	~AutoConfigActorState() 
	{
		fdb_probe_actor_destroy("autoConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 593 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (!conf.address_class.size())
															#line 4086 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 594 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<AutoConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::INCOMPLETE_CONFIGURATION); this->~AutoConfigActorState(); static_cast<AutoConfigActor*>(this)->destroy(); return 0; }
															#line 4090 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<AutoConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::INCOMPLETE_CONFIGURATION);
				this->~AutoConfigActorState();
				static_cast<AutoConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 596 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			;
															#line 4098 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AutoConfigActorState();
		static_cast<AutoConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 598 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 599 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 600 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 601 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->setOption(FDBTransactionOptions::USE_PROVISIONAL_PROXIES);
															#line 603 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			processClassesF = typename DB::TransactionT::template FutureT<RangeResult>();
															#line 604 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			processDataF = typename DB::TransactionT::template FutureT<RangeResult>();
															#line 605 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<std::vector<ProcessData>> __when_expr_0 = getWorkers(tr, processClassesF, processDataF);
															#line 605 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<AutoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4143 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AutoConfigActor*>(this)->actor_wait_state = 1;
															#line 605 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AutoConfigActor, 0, std::vector<ProcessData> >*>(static_cast<AutoConfigActor*>(this)));
															#line 4148 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 652 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 652 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (static_cast<AutoConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4172 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<AutoConfigActor*>(this)->actor_wait_state = 3;
															#line 652 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AutoConfigActor, 2, Void >*>(static_cast<AutoConfigActor*>(this)));
															#line 4177 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<ProcessData> const& workers,int loopDepth) 
	{
															#line 606 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::map<NetworkAddress, Optional<Standalone<StringRef>>> address_processId;
															#line 607 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& w : workers ) {
															#line 608 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			address_processId[w.address] = w.locality.processId();
															#line 4196 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 611 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : conf.address_class ) {
															#line 612 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (it.second.classSource() == ProcessClass::CommandLineSource)
															#line 4202 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 613 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->clear(processClassKeyFor(address_processId[it.first].get()));
															#line 4206 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
			else
			{
															#line 615 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(processClassKeyFor(address_processId[it.first].get()), processClassValue(it.second));
															#line 4212 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 619 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.address_class.size())
															#line 4217 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 620 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(processClassChangeKey, deterministicRandom()->randomUniqueID().toString());
															#line 4221 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 622 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_logs != conf.old_logs)
															#line 4225 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 623 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_logs", format("%d", conf.auto_logs));
															#line 4229 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 625 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_commit_proxies != conf.old_commit_proxies)
															#line 4233 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 626 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_commit_proxies", format("%d", conf.auto_commit_proxies));
															#line 4237 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 628 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_grv_proxies != conf.old_grv_proxies)
															#line 4241 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 629 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_grv_proxies", format("%d", conf.auto_grv_proxies));
															#line 4245 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 631 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_resolvers != conf.old_resolvers)
															#line 4249 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 632 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_resolvers", format("%d", conf.auto_resolvers));
															#line 4253 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 634 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_replication != conf.old_replication)
															#line 4257 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 635 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::vector<StringRef> modes;
															#line 636 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			modes.push_back(conf.auto_replication);
															#line 637 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::map<std::string, std::string> m;
															#line 638 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			auto r = buildConfiguration(modes, m);
															#line 639 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (r != ConfigurationResult::SUCCESS)
															#line 4269 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 640 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<AutoConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(r); this->~AutoConfigActorState(); static_cast<AutoConfigActor*>(this)->destroy(); return 0; }
															#line 4273 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<AutoConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(r);
				this->~AutoConfigActorState();
				static_cast<AutoConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 642 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& kv : m ) {
															#line 643 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(kv.first, kv.second);
															#line 4283 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 646 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->addReadConflictRange(singleKeyRange(moveKeysLockOwnerKey));
															#line 647 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->set(moveKeysLockOwnerKey, versionKey);
															#line 649 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 649 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<AutoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4294 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<AutoConfigActor*>(this)->actor_wait_state = 2;
															#line 649 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AutoConfigActor, 1, Void >*>(static_cast<AutoConfigActor*>(this)));
															#line 4299 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<ProcessData> && workers,int loopDepth) 
	{
															#line 606 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		std::map<NetworkAddress, Optional<Standalone<StringRef>>> address_processId;
															#line 607 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& w : workers ) {
															#line 608 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			address_processId[w.address] = w.locality.processId();
															#line 4312 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 611 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		for( auto& it : conf.address_class ) {
															#line 612 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (it.second.classSource() == ProcessClass::CommandLineSource)
															#line 4318 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 613 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->clear(processClassKeyFor(address_processId[it.first].get()));
															#line 4322 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
			else
			{
															#line 615 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(processClassKeyFor(address_processId[it.first].get()), processClassValue(it.second));
															#line 4328 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 619 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.address_class.size())
															#line 4333 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 620 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(processClassChangeKey, deterministicRandom()->randomUniqueID().toString());
															#line 4337 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 622 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_logs != conf.old_logs)
															#line 4341 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 623 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_logs", format("%d", conf.auto_logs));
															#line 4345 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 625 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_commit_proxies != conf.old_commit_proxies)
															#line 4349 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 626 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_commit_proxies", format("%d", conf.auto_commit_proxies));
															#line 4353 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 628 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_grv_proxies != conf.old_grv_proxies)
															#line 4357 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 629 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_grv_proxies", format("%d", conf.auto_grv_proxies));
															#line 4361 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 631 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_resolvers != conf.old_resolvers)
															#line 4365 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 632 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			tr->set(configKeysPrefix.toString() + "auto_resolvers", format("%d", conf.auto_resolvers));
															#line 4369 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		}
															#line 634 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (conf.auto_replication != conf.old_replication)
															#line 4373 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		{
															#line 635 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::vector<StringRef> modes;
															#line 636 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			modes.push_back(conf.auto_replication);
															#line 637 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			std::map<std::string, std::string> m;
															#line 638 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			auto r = buildConfiguration(modes, m);
															#line 639 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			if (r != ConfigurationResult::SUCCESS)
															#line 4385 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			{
															#line 640 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				if (!static_cast<AutoConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(r); this->~AutoConfigActorState(); static_cast<AutoConfigActor*>(this)->destroy(); return 0; }
															#line 4389 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
				new (&static_cast<AutoConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(r);
				this->~AutoConfigActorState();
				static_cast<AutoConfigActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 642 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
			for( auto& kv : m ) {
															#line 643 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
				tr->set(kv.first, kv.second);
															#line 4399 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
			}
		}
															#line 646 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->addReadConflictRange(singleKeyRange(moveKeysLockOwnerKey));
															#line 647 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		tr->set(moveKeysLockOwnerKey, versionKey);
															#line 649 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 649 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (static_cast<AutoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4410 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<AutoConfigActor*>(this)->actor_wait_state = 2;
															#line 649 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AutoConfigActor, 1, Void >*>(static_cast<AutoConfigActor*>(this)));
															#line 4415 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<ProcessData> const& workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(workers, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<ProcessData> && workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AutoConfigActor*>(this)->actor_wait_state > 0) static_cast<AutoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<AutoConfigActor*>(this)->ActorCallback< AutoConfigActor, 0, std::vector<ProcessData> >::remove();

	}
	void a_callback_fire(ActorCallback< AutoConfigActor, 0, std::vector<ProcessData> >*,std::vector<ProcessData> const& value) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AutoConfigActor, 0, std::vector<ProcessData> >*,std::vector<ProcessData> && value) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AutoConfigActor, 0, std::vector<ProcessData> >*,Error err) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 650 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!static_cast<AutoConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::SUCCESS); this->~AutoConfigActorState(); static_cast<AutoConfigActor*>(this)->destroy(); return 0; }
															#line 4499 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		new (&static_cast<AutoConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::SUCCESS);
		this->~AutoConfigActorState();
		static_cast<AutoConfigActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 650 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
		if (!static_cast<AutoConfigActor*>(this)->SAV<ConfigurationResult>::futures) { (void)(ConfigurationResult::SUCCESS); this->~AutoConfigActorState(); static_cast<AutoConfigActor*>(this)->destroy(); return 0; }
															#line 4511 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		new (&static_cast<AutoConfigActor*>(this)->SAV< ConfigurationResult >::value()) ConfigurationResult(ConfigurationResult::SUCCESS);
		this->~AutoConfigActorState();
		static_cast<AutoConfigActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AutoConfigActor*>(this)->actor_wait_state > 0) static_cast<AutoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<AutoConfigActor*>(this)->ActorCallback< AutoConfigActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AutoConfigActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AutoConfigActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AutoConfigActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AutoConfigActor*>(this)->actor_wait_state > 0) static_cast<AutoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<AutoConfigActor*>(this)->ActorCallback< AutoConfigActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AutoConfigActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AutoConfigActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AutoConfigActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 588 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Reference<DB> db;
															#line 588 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	ConfigureAutoResult conf;
															#line 590 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 591 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	Key versionKey;
															#line 603 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> processClassesF;
															#line 604 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	typename DB::TransactionT::template FutureT<RangeResult> processDataF;
															#line 4693 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
};
// This generated class is to be used only via autoConfig()
															#line 588 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB>
															#line 588 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
class AutoConfigActor final : public Actor<ConfigurationResult>, public ActorCallback< AutoConfigActor<DB>, 0, std::vector<ProcessData> >, public ActorCallback< AutoConfigActor<DB>, 1, Void >, public ActorCallback< AutoConfigActor<DB>, 2, Void >, public FastAllocated<AutoConfigActor<DB>>, public AutoConfigActorState<DB, AutoConfigActor<DB>> {
															#line 4700 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
public:
	using FastAllocated<AutoConfigActor<DB>>::operator new;
	using FastAllocated<AutoConfigActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12121224576050295808UL, 186713656121124608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ConfigurationResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AutoConfigActor<DB>, 0, std::vector<ProcessData> >;
friend struct ActorCallback< AutoConfigActor<DB>, 1, Void >;
friend struct ActorCallback< AutoConfigActor<DB>, 2, Void >;
															#line 588 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	AutoConfigActor(Reference<DB> const& db,ConfigureAutoResult const& conf) 
															#line 4719 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
		 : Actor<ConfigurationResult>(),
		   AutoConfigActorState<DB, AutoConfigActor<DB>>(db, conf),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("autoConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(851761084017320448UL, 5414860964962561792UL);
		ActorExecutionContextHelper __helper(static_cast<AutoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("autoConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("autoConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AutoConfigActor<DB>, 0, std::vector<ProcessData> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AutoConfigActor<DB>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AutoConfigActor<DB>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 588 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
template <class DB>
															#line 588 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
[[nodiscard]] Future<ConfigurationResult> autoConfig( Reference<DB> const& db, ConfigureAutoResult const& conf ) {
															#line 588 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"
	return Future<ConfigurationResult>(new AutoConfigActor<DB>(db, conf));
															#line 4755 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GenericManagementAPI.actor.g.h"
}

#line 656 "/codebuild/output/src3072233060/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GenericManagementAPI.actor.h"

// Accepts tokens separated by spaces in a single string
template <class DB>
Future<ConfigurationResult> changeConfig(Reference<DB> db, std::string const& modes, bool force) {
	TraceEvent("ChangeConfig").detail("Mode", modes);
	std::map<std::string, std::string> m;
	auto r = buildConfiguration(modes, m);
	if (r != ConfigurationResult::SUCCESS)
		return r;
	return changeConfig(db, m, force);
}

// Accepts a vector of configuration tokens
template <class DB>
Future<ConfigurationResult> changeConfig(Reference<DB> db,
                                         std::vector<StringRef> const& modes,
                                         Optional<ConfigureAutoResult> const& conf,
                                         bool force) {
	if (modes.size() && modes[0] == "auto"_sr && conf.present()) {
		return autoConfig(db, conf.get());
	}

	std::map<std::string, std::string> m;
	auto r = buildConfiguration(modes, m);
	if (r != ConfigurationResult::SUCCESS)
		return r;
	return changeConfig(db, m, force);
}

// return the corresponding error message for the CoordinatorsResult
// used by special keys and fdbcli
std::string generateErrorMessage(const CoordinatorsResult& res);

} // namespace ManagementAPI

#include "flow/unactorcompiler.h"
#endif
