/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JNIUtil {
    private static final String SEPARATOR = "/";
    private static final String LOADABLE_PREFIX = "FDB_LIBRARY_PATH_";
    private static final String TEMPFILE_PREFIX = "fdbjni";
    private static final String TEMPFILE_SUFFIX = ".library";

    static void loadLibrary(String string) throws UnsatisfiedLinkError {
        File file;
        Object object;
        if (string == null) {
            throw new NullPointerException("Library name must not be null");
        }
        String string2 = null;
        try {
            object = LOADABLE_PREFIX + string.toUpperCase();
            string2 = System.getProperty((String)object);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string2 != null) {
            System.load(string2);
            return;
        }
        object = JNIUtil.getRunningOS();
        String string3 = JNIUtil.getPath((OS)object, string);
        if (((OS)object).getName().equals("linux") && !string3.endsWith(".so") || ((OS)object).getName().equals("windows") && !string3.endsWith(".dll") || ((OS)object).getName().equals("osx") && !string3.endsWith(".jnilib") && !string3.endsWith(".dylib")) {
            throw new IllegalStateException("OS sanity check failed. System property os.name reports " + ((OS)object).getName() + " but System.mapLibraryName is looking for " + JNIUtil.getLibName(string));
        }
        try {
            file = JNIUtil.exportResource(string3, string);
        }
        catch (IOException iOException) {
            throw new UnsatisfiedLinkError(iOException.getMessage());
        }
        String string4 = file.getAbsolutePath();
        System.load(string4);
        if (((OS)object).canDeleteEager) {
            try {
                file.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static File exportLibrary(String string) throws IOException {
        OS oS = JNIUtil.getRunningOS();
        String string2 = JNIUtil.getPath(oS, string);
        return JNIUtil.exportResource(string2, string);
    }

    private static String getPath(OS oS, String string) {
        return "/lib/" + oS.getName() + SEPARATOR + oS.getArch() + SEPARATOR + JNIUtil.getLibName(string);
    }

    private static File exportResource(String string, String string2) throws IOException {
        InputStream inputStream = JNIUtil.class.getResourceAsStream(string);
        if (inputStream == null) {
            throw new IllegalStateException("Embedded library jar:" + string + " not found");
        }
        File file = JNIUtil.saveStreamAsTempFile(inputStream, string2);
        return file;
    }

    private static File saveStreamAsTempFile(InputStream inputStream, String string) throws IOException {
        File file = File.createTempFile(string.length() > 0 ? string : TEMPFILE_PREFIX, TEMPFILE_SUFFIX);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        JNIUtil.copyStream(inputStream, fileOutputStream);
        fileOutputStream.flush();
        fileOutputStream.close();
        file.deleteOnExit();
        return file;
    }

    private static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    private static String getLibName(String string) {
        String string2 = System.mapLibraryName(string);
        if (string2.endsWith(".dylib")) {
            string2 = string2.replace("dylib", "jnilib");
        }
        return string2;
    }

    private static OS getRunningOS() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch");
        if (!(string2.equals("amd64") || string2.equals("x86_64") || string2.equals("aarch64") || string2.equals("ppc64le"))) {
            throw new IllegalStateException("Unknown or unsupported arch: " + string2);
        }
        if (string.startsWith("windows")) {
            return new OS("windows", string2, false);
        }
        if (string.startsWith("linux")) {
            return new OS("linux", string2, true);
        }
        if (string.startsWith("mac") || string.startsWith("darwin")) {
            return new OS("osx", string2, true);
        }
        throw new IllegalStateException("Unknown or unsupported OS: " + string);
    }

    private JNIUtil() {
    }

    private static class OS {
        private final String name;
        private final String arch;
        private final boolean canDeleteEager;

        OS(String string, String string2, boolean bl) {
            this.name = string;
            this.arch = string2;
            this.canDeleteEager = bl;
        }

        public String getName() {
            return this.name;
        }

        public String getArch() {
            return this.arch;
        }
    }
}

