#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
/*
 * MetaclusterMetrics.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/DatabaseContext.h"
#include "fdbclient/ReadYourWrites.h"

#include "metacluster/Metacluster.h"
#include "metacluster/MetaclusterMetrics.h"

#include "flow/actorcompiler.h" // has to be last include

namespace metacluster {
namespace internal {
															#line 33 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterMetrics.actor.g.cpp"
// This generated class is to be used only via getMetaclusterMetricsImpl()
															#line 31 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
template <class GetMetaclusterMetricsImplActor>
															#line 31 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
class GetMetaclusterMetricsImplActorState {
															#line 39 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterMetrics.actor.g.cpp"
public:
															#line 31 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
	GetMetaclusterMetricsImplActorState(Database const& db) 
															#line 31 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
															#line 31 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		 : db(db),
															#line 32 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		   tr(db->createTransaction())
															#line 48 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterMetrics.actor.g.cpp"
	{
		fdb_probe_actor_create("getMetaclusterMetricsImpl", reinterpret_cast<unsigned long>(this));

	}
	~GetMetaclusterMetricsImplActorState() 
	{
		fdb_probe_actor_destroy("getMetaclusterMetricsImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 33 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
			;
															#line 63 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterMetrics.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetMetaclusterMetricsImplActorState();
		static_cast<GetMetaclusterMetricsImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 35 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 36 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
			clusters = std::map<ClusterName, DataClusterMetadata>();
															#line 37 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
			tenantCount = int64_t();
															#line 38 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(clusters, metacluster::listClustersTransaction(tr, ""_sr, "\xff"_sr, CLIENT_KNOBS->MAX_DATA_CLUSTERS)) && store(tenantCount, metacluster::metadata::management::tenantMetadata().tenantCount.getD(tr, Snapshot::False, 0));
															#line 38 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
			if (static_cast<GetMetaclusterMetricsImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterMetrics.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetMetaclusterMetricsImplActor*>(this)->actor_wait_state = 1;
															#line 38 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetMetaclusterMetricsImplActor, 0, Void >*>(static_cast<GetMetaclusterMetricsImplActor*>(this)));
															#line 107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterMetrics.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 61 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
			TraceEvent("MetaclusterUpdaterError").error(e);
															#line 62 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
			if (e.code() == error_code_unsupported_metacluster_version)
															#line 131 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterMetrics.actor.g.cpp"
			{
															#line 63 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
				TraceEvent(SevWarnAlways, "MetaclusterMetricsFailure").error(e);
															#line 64 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
				MetaclusterMetrics metrics;
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
				metrics.error = e.what();
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
				if (!static_cast<GetMetaclusterMetricsImplActor*>(this)->SAV<MetaclusterMetrics>::futures) { (void)(metrics); this->~GetMetaclusterMetricsImplActorState(); static_cast<GetMetaclusterMetricsImplActor*>(this)->destroy(); return 0; }
															#line 141 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterMetrics.actor.g.cpp"
				new (&static_cast<GetMetaclusterMetricsImplActor*>(this)->SAV< MetaclusterMetrics >::value()) MetaclusterMetrics(metrics);
				this->~GetMetaclusterMetricsImplActorState();
				static_cast<GetMetaclusterMetricsImplActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
			if (static_cast<GetMetaclusterMetricsImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 151 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterMetrics.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetMetaclusterMetricsImplActor*>(this)->actor_wait_state = 2;
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetMetaclusterMetricsImplActor, 1, Void >*>(static_cast<GetMetaclusterMetricsImplActor*>(this)));
															#line 156 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterMetrics.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 43 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		capacityNumbers = util::metaclusterCapacity(clusters);
															#line 45 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		MetaclusterMetrics metrics;
															#line 46 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		metrics.numTenants = tenantCount;
															#line 47 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		metrics.numDataClusters = clusters.size();
															#line 48 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		metrics.tenantGroupCapacity = capacityNumbers.first.numTenantGroups;
															#line 49 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		metrics.tenantGroupsAllocated = capacityNumbers.second.numTenantGroups;
															#line 51 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		TraceEvent("MetaclusterCapacity") .detail("TotalTenants", metrics.numTenants) .detail("DataClusters", metrics.numDataClusters) .detail("TenantGroupCapacity", metrics.tenantGroupCapacity) .detail("TenantGroupsAllocated", metrics.tenantGroupsAllocated);
															#line 57 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		CODE_PROBE(true, "Got metacluster metrics");
															#line 59 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		if (!static_cast<GetMetaclusterMetricsImplActor*>(this)->SAV<MetaclusterMetrics>::futures) { (void)(metrics); this->~GetMetaclusterMetricsImplActorState(); static_cast<GetMetaclusterMetricsImplActor*>(this)->destroy(); return 0; }
															#line 187 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterMetrics.actor.g.cpp"
		new (&static_cast<GetMetaclusterMetricsImplActor*>(this)->SAV< MetaclusterMetrics >::value()) MetaclusterMetrics(metrics);
		this->~GetMetaclusterMetricsImplActorState();
		static_cast<GetMetaclusterMetricsImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 43 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		capacityNumbers = util::metaclusterCapacity(clusters);
															#line 45 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		MetaclusterMetrics metrics;
															#line 46 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		metrics.numTenants = tenantCount;
															#line 47 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		metrics.numDataClusters = clusters.size();
															#line 48 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		metrics.tenantGroupCapacity = capacityNumbers.first.numTenantGroups;
															#line 49 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		metrics.tenantGroupsAllocated = capacityNumbers.second.numTenantGroups;
															#line 51 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		TraceEvent("MetaclusterCapacity") .detail("TotalTenants", metrics.numTenants) .detail("DataClusters", metrics.numDataClusters) .detail("TenantGroupCapacity", metrics.tenantGroupCapacity) .detail("TenantGroupsAllocated", metrics.tenantGroupsAllocated);
															#line 57 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		CODE_PROBE(true, "Got metacluster metrics");
															#line 59 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
		if (!static_cast<GetMetaclusterMetricsImplActor*>(this)->SAV<MetaclusterMetrics>::futures) { (void)(metrics); this->~GetMetaclusterMetricsImplActorState(); static_cast<GetMetaclusterMetricsImplActor*>(this)->destroy(); return 0; }
															#line 215 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterMetrics.actor.g.cpp"
		new (&static_cast<GetMetaclusterMetricsImplActor*>(this)->SAV< MetaclusterMetrics >::value()) MetaclusterMetrics(metrics);
		this->~GetMetaclusterMetricsImplActorState();
		static_cast<GetMetaclusterMetricsImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetMetaclusterMetricsImplActor*>(this)->actor_wait_state > 0) static_cast<GetMetaclusterMetricsImplActor*>(this)->actor_wait_state = 0;
		static_cast<GetMetaclusterMetricsImplActor*>(this)->ActorCallback< GetMetaclusterMetricsImplActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetMetaclusterMetricsImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getMetaclusterMetricsImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMetaclusterMetricsImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMetaclusterMetricsImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetMetaclusterMetricsImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getMetaclusterMetricsImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMetaclusterMetricsImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMetaclusterMetricsImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetMetaclusterMetricsImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getMetaclusterMetricsImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMetaclusterMetricsImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMetaclusterMetricsImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetMetaclusterMetricsImplActor*>(this)->actor_wait_state > 0) static_cast<GetMetaclusterMetricsImplActor*>(this)->actor_wait_state = 0;
		static_cast<GetMetaclusterMetricsImplActor*>(this)->ActorCallback< GetMetaclusterMetricsImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetMetaclusterMetricsImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getMetaclusterMetricsImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMetaclusterMetricsImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMetaclusterMetricsImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetMetaclusterMetricsImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getMetaclusterMetricsImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMetaclusterMetricsImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMetaclusterMetricsImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetMetaclusterMetricsImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getMetaclusterMetricsImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMetaclusterMetricsImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMetaclusterMetricsImpl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 31 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
	Database db;
															#line 32 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 36 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
	std::map<ClusterName, DataClusterMetadata> clusters;
															#line 37 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
	int64_t tenantCount;
															#line 43 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
	std::pair<ClusterUsage, ClusterUsage> capacityNumbers;
															#line 395 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterMetrics.actor.g.cpp"
};
// This generated class is to be used only via getMetaclusterMetricsImpl()
															#line 31 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
class GetMetaclusterMetricsImplActor final : public Actor<MetaclusterMetrics>, public ActorCallback< GetMetaclusterMetricsImplActor, 0, Void >, public ActorCallback< GetMetaclusterMetricsImplActor, 1, Void >, public FastAllocated<GetMetaclusterMetricsImplActor>, public GetMetaclusterMetricsImplActorState<GetMetaclusterMetricsImplActor> {
															#line 400 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterMetrics.actor.g.cpp"
public:
	using FastAllocated<GetMetaclusterMetricsImplActor>::operator new;
	using FastAllocated<GetMetaclusterMetricsImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12281607516558765824UL, 9746870988881829376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<MetaclusterMetrics>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetMetaclusterMetricsImplActor, 0, Void >;
friend struct ActorCallback< GetMetaclusterMetricsImplActor, 1, Void >;
															#line 31 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
	GetMetaclusterMetricsImplActor(Database const& db) 
															#line 418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterMetrics.actor.g.cpp"
		 : Actor<MetaclusterMetrics>(),
		   GetMetaclusterMetricsImplActorState<GetMetaclusterMetricsImplActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getMetaclusterMetricsImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7438463677088083968UL, 14360379984392425472UL);
		ActorExecutionContextHelper __helper(static_cast<GetMetaclusterMetricsImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getMetaclusterMetricsImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getMetaclusterMetricsImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetMetaclusterMetricsImplActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetMetaclusterMetricsImplActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 31 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
[[nodiscard]] Future<MetaclusterMetrics> getMetaclusterMetricsImpl( Database const& db ) {
															#line 31 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
	return Future<MetaclusterMetrics>(new GetMetaclusterMetricsImplActor(db));
															#line 451 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterMetrics.actor.g.cpp"
}

#line 73 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/metacluster/MetaclusterMetrics.actor.cpp"
} // namespace internal

Future<MetaclusterMetrics> MetaclusterMetrics::getMetaclusterMetrics(Database db) {
	return internal::getMetaclusterMetricsImpl(db);
}
} // namespace metacluster
