#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
/*
 * genericactors.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

// When actually compiled (NO_INTELLISENSE), include the generated version of this file.  In intellisense use the source
// version.
#include "flow/Error.h"
#include "flow/FastRef.h"
#include "flow/TaskPriority.h"
#include "flow/network.h"
#include "flow/swift_support.h"
#include <utility>
#include <functional>
#include <unordered_set>
#if defined(NO_INTELLISENSE) && !defined(FLOW_GENERICACTORS_ACTOR_G_H)
#define FLOW_GENERICACTORS_ACTOR_G_H
#include "flow/genericactors.actor.g.h"
#elif !defined(GENERICACTORS_ACTOR_H)
#define GENERICACTORS_ACTOR_H

#include <list>
#include <utility>

#include "flow/flow.h"
#include "flow/CoroUtils.h"
#include "flow/Knobs.h"
#include "flow/Util.h"
#include "flow/IndexedSet.h"
#include "flow/actorcompiler.h" // This must be the last #include.

#ifdef _MSC_VER
#pragma warning(disable : 4355) // 'this' : used in base member initializer list
#endif

															#line 55 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via traceAfter()
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X, class TraceAfterActor>
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TraceAfterActorState {
															#line 62 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TraceAfterActorState(Future<T> const& what,const char* const& type,const char* const& key,X const& value,bool const& traceErrors = false) 
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   type(type),
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   key(key),
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   value(value),
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   traceErrors(traceErrors)
															#line 77 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("traceAfter", reinterpret_cast<unsigned long>(this));

	}
	~TraceAfterActorState() 
	{
		fdb_probe_actor_destroy("traceAfter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 56 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = what;
															#line 56 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<TraceAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 95 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TraceAfterActor*>(this)->actor_wait_state = 1;
															#line 56 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TraceAfterActor, 0, T >*>(static_cast<TraceAfterActor*>(this)));
															#line 100 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TraceAfterActorState();
		static_cast<TraceAfterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 60 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (traceErrors)
															#line 130 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 61 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				TraceEvent(type).errorUnsuppressed(e).detail(key, value);
															#line 134 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 62 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 138 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& val,int loopDepth) 
	{
															#line 57 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		TraceEvent(type).detail(key, value);
															#line 58 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TraceAfterActor*>(this)->SAV<T>::futures) { (void)(val); this->~TraceAfterActorState(); static_cast<TraceAfterActor*>(this)->destroy(); return 0; }
															#line 154 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TraceAfterActor*>(this)->SAV< T >::value()) T(val);
		this->~TraceAfterActorState();
		static_cast<TraceAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && val,int loopDepth) 
	{
															#line 57 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		TraceEvent(type).detail(key, value);
															#line 58 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TraceAfterActor*>(this)->SAV<T>::futures) { (void)(val); this->~TraceAfterActorState(); static_cast<TraceAfterActor*>(this)->destroy(); return 0; }
															#line 168 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TraceAfterActor*>(this)->SAV< T >::value()) T(val);
		this->~TraceAfterActorState();
		static_cast<TraceAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
		loopDepth = a_body1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TraceAfterActor*>(this)->actor_wait_state > 0) static_cast<TraceAfterActor*>(this)->actor_wait_state = 0;
		static_cast<TraceAfterActor*>(this)->ActorCallback< TraceAfterActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< TraceAfterActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("traceAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TraceAfterActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("traceAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TraceAfterActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("traceAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TraceAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceAfter", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	const char* type;
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	const char* key;
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	X value;
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	bool traceErrors;
															#line 261 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via traceAfter()
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X>
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TraceAfterActor final : public Actor<T>, public ActorCallback< TraceAfterActor<T, X>, 0, T >, public FastAllocated<TraceAfterActor<T, X>>, public TraceAfterActorState<T, X, TraceAfterActor<T, X>> {
															#line 268 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TraceAfterActor<T, X>>::operator new;
	using FastAllocated<TraceAfterActor<T, X>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13542047691356987904UL, 8890941338133285120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TraceAfterActor<T, X>, 0, T >;
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TraceAfterActor(Future<T> const& what,const char* const& type,const char* const& key,X const& value,bool const& traceErrors = false) 
															#line 285 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   TraceAfterActorState<T, X, TraceAfterActor<T, X>>(what, type, key, value, traceErrors),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("traceAfter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1345027834026654720UL, 9550825359764015360UL);
		ActorExecutionContextHelper __helper(static_cast<TraceAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("traceAfter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("traceAfter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TraceAfterActor<T, X>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X>
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> traceAfter( Future<T> const& what, const char* const& type, const char* const& key, X const& value, bool const& traceErrors = false ) {
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new TraceAfterActor<T, X>(what, type, key, value, traceErrors));
															#line 320 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 325 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via traceAfterCall()
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X, class TraceAfterCallActor>
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TraceAfterCallActorState {
															#line 332 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TraceAfterCallActorState(Future<T> const& what,const char* const& type,const char* const& key,X const& func,bool const& traceErrors = false) 
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   type(type),
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   key(key),
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   func(func),
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   traceErrors(traceErrors)
															#line 347 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("traceAfterCall", reinterpret_cast<unsigned long>(this));

	}
	~TraceAfterCallActorState() 
	{
		fdb_probe_actor_destroy("traceAfterCall", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = what;
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<TraceAfterCallActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 365 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TraceAfterCallActor*>(this)->actor_wait_state = 1;
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TraceAfterCallActor, 0, T >*>(static_cast<TraceAfterCallActor*>(this)));
															#line 370 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TraceAfterCallActorState();
		static_cast<TraceAfterCallActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 77 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (traceErrors)
															#line 400 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 78 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				TraceEvent(type).errorUnsuppressed(e);
															#line 404 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 79 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		try {
															#line 71 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			TraceEvent(type).detail(key, func(val));
															#line 423 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(T const& __val,int loopDepth) 
	{
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		val = __val;
															#line 438 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && __val,int loopDepth) 
	{
		val = std::move(__val);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TraceAfterCallActor*>(this)->actor_wait_state > 0) static_cast<TraceAfterCallActor*>(this)->actor_wait_state = 0;
		static_cast<TraceAfterCallActor*>(this)->ActorCallback< TraceAfterCallActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< TraceAfterCallActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("traceAfterCall", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceAfterCallActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceAfterCall", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TraceAfterCallActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("traceAfterCall", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceAfterCallActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceAfterCall", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TraceAfterCallActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("traceAfterCall", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TraceAfterCallActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceAfterCall", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 75 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TraceAfterCallActor*>(this)->SAV<T>::futures) { (void)(val); this->~TraceAfterCallActorState(); static_cast<TraceAfterCallActor*>(this)->destroy(); return 0; }
															#line 517 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TraceAfterCallActor*>(this)->SAV< T >::value()) T(std::move(val)); // state_var_RVO
		this->~TraceAfterCallActorState();
		static_cast<TraceAfterCallActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 73 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			TraceEvent(SevError, "TraceAfterCallError").error(e);
															#line 530 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	const char* type;
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	const char* key;
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	X func;
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	bool traceErrors;
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T val;
															#line 566 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via traceAfterCall()
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X>
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TraceAfterCallActor final : public Actor<T>, public ActorCallback< TraceAfterCallActor<T, X>, 0, T >, public FastAllocated<TraceAfterCallActor<T, X>>, public TraceAfterCallActorState<T, X, TraceAfterCallActor<T, X>> {
															#line 573 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TraceAfterCallActor<T, X>>::operator new;
	using FastAllocated<TraceAfterCallActor<T, X>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1183972414750198784UL, 16032634157139215872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TraceAfterCallActor<T, X>, 0, T >;
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TraceAfterCallActor(Future<T> const& what,const char* const& type,const char* const& key,X const& func,bool const& traceErrors = false) 
															#line 590 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   TraceAfterCallActorState<T, X, TraceAfterCallActor<T, X>>(what, type, key, func, traceErrors),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("traceAfterCall", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3779267792497716480UL, 9186379876595564288UL);
		ActorExecutionContextHelper __helper(static_cast<TraceAfterCallActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("traceAfterCall");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("traceAfterCall", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TraceAfterCallActor<T, X>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X>
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> traceAfterCall( Future<T> const& what, const char* const& type, const char* const& key, X const& func, bool const& traceErrors = false ) {
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new TraceAfterCallActor<T, X>(what, type, key, func, traceErrors));
															#line 625 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 82 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 630 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via stopAfter()
															#line 83 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class StopAfterActor>
															#line 83 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class StopAfterActorState {
															#line 637 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 83 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	StopAfterActorState(Future<T> const& what) 
															#line 83 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 83 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 85 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   ret(T())
															#line 646 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("stopAfter", reinterpret_cast<unsigned long>(this));

	}
	~StopAfterActorState() 
	{
		fdb_probe_actor_destroy("stopAfter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 87 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = what;
															#line 87 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<StopAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 664 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<StopAfterActor*>(this)->actor_wait_state = 1;
															#line 87 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StopAfterActor, 0, T >*>(static_cast<StopAfterActor*>(this)));
															#line 669 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StopAfterActorState();
		static_cast<StopAfterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 98 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		g_network->stop();
															#line 99 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<StopAfterActor*>(this)->SAV<Optional<T>>::futures) { (void)(ret); this->~StopAfterActorState(); static_cast<StopAfterActor*>(this)->destroy(); return 0; }
															#line 700 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<StopAfterActor*>(this)->SAV< Optional<T> >::value()) Optional<T>(std::move(ret)); // state_var_RVO
		this->~StopAfterActorState();
		static_cast<StopAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 90 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			bool ok = e.code() == error_code_please_reboot || e.code() == error_code_please_reboot_delete || e.code() == error_code_actor_cancelled || e.code() == error_code_local_config_changed;
															#line 92 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			TraceEvent(ok ? SevInfo : SevError, "StopAfterError").error(e);
															#line 93 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (!ok)
															#line 717 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 94 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				fprintf(stderr, "Fatal Error: %s\n", e.what());
															#line 95 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				ret = Optional<T>();
															#line 723 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		ret = Optional<T>(_);
															#line 739 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(T && _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		ret = Optional<T>(_);
															#line 748 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StopAfterActor*>(this)->actor_wait_state > 0) static_cast<StopAfterActor*>(this)->actor_wait_state = 0;
		static_cast<StopAfterActor*>(this)->ActorCallback< StopAfterActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< StopAfterActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("stopAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StopAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StopAfterActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("stopAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StopAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StopAfterActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("stopAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StopAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 83 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 85 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Optional<T> ret;
															#line 845 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via stopAfter()
															#line 83 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 83 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class StopAfterActor final : public Actor<Optional<T>>, public ActorCallback< StopAfterActor<T>, 0, T >, public FastAllocated<StopAfterActor<T>>, public StopAfterActorState<T, StopAfterActor<T>> {
															#line 852 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<StopAfterActor<T>>::operator new;
	using FastAllocated<StopAfterActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8139533114865308416UL, 6497137025410766592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<T>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StopAfterActor<T>, 0, T >;
															#line 83 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	StopAfterActor(Future<T> const& what) 
															#line 869 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Optional<T>>(),
		   StopAfterActorState<T, StopAfterActor<T>>(what),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("stopAfter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18375464497900749312UL, 15065832257037953024UL);
		ActorExecutionContextHelper __helper(static_cast<StopAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("stopAfter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("stopAfter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StopAfterActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 83 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 83 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Optional<T>> stopAfter( Future<T> const& what ) {
															#line 83 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Optional<T>>(new StopAfterActor<T>(what));
															#line 904 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 101 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

template <class T>
T sorted(T range) {
	std::sort(range.begin(), range.end());
	return range;
}

template <class T>
std::vector<T> parseStringToVector(std::string str, char delim) {
	std::vector<T> result;
	std::stringstream stream(str);
	std::string token;
	while (stream.good()) {
		getline(stream, token, delim);
		std::istringstream tokenStream(token);
		T item;
		tokenStream >> item;
		result.push_back(item);
	}
	return result;
}

template <class T>
std::unordered_set<T> parseStringToUnorderedSet(std::string str, char delim) {
	std::unordered_set<T> result;
	std::stringstream stream(str);
	std::string token;
	while (stream.good()) {
		getline(stream, token, delim);
		std::istringstream tokenStream(token);
		T item;
		tokenStream >> item;
		result.emplace(item);
	}
	return result;
}

template <class T>
ErrorOr<T> errorOr(T t) {
	return ErrorOr<T>(t);
}

															#line 950 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via errorOr()
															#line 143 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class ErrorOrActor>
															#line 143 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ErrorOrActorState {
															#line 957 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 143 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ErrorOrActorState(Future<T> const& f) 
															#line 143 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 143 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : f(f)
															#line 964 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("errorOr", reinterpret_cast<unsigned long>(this));

	}
	~ErrorOrActorState() 
	{
		fdb_probe_actor_destroy("errorOr", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 146 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = f;
															#line 146 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<ErrorOrActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 982 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ErrorOrActor*>(this)->actor_wait_state = 1;
															#line 146 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ErrorOrActor, 0, T >*>(static_cast<ErrorOrActor*>(this)));
															#line 987 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ErrorOrActorState();
		static_cast<ErrorOrActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 149 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (!static_cast<ErrorOrActor*>(this)->SAV<ErrorOr<T>>::futures) { (void)(ErrorOr<T>(e)); this->~ErrorOrActorState(); static_cast<ErrorOrActor*>(this)->destroy(); return 0; }
															#line 1017 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			new (&static_cast<ErrorOrActor*>(this)->SAV< ErrorOr<T> >::value()) ErrorOr<T>(ErrorOr<T>(e));
			this->~ErrorOrActorState();
			static_cast<ErrorOrActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& t,int loopDepth) 
	{
															#line 147 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ErrorOrActor*>(this)->SAV<ErrorOr<T>>::futures) { (void)(ErrorOr<T>(t)); this->~ErrorOrActorState(); static_cast<ErrorOrActor*>(this)->destroy(); return 0; }
															#line 1035 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ErrorOrActor*>(this)->SAV< ErrorOr<T> >::value()) ErrorOr<T>(ErrorOr<T>(t));
		this->~ErrorOrActorState();
		static_cast<ErrorOrActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && t,int loopDepth) 
	{
															#line 147 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ErrorOrActor*>(this)->SAV<ErrorOr<T>>::futures) { (void)(ErrorOr<T>(t)); this->~ErrorOrActorState(); static_cast<ErrorOrActor*>(this)->destroy(); return 0; }
															#line 1047 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ErrorOrActor*>(this)->SAV< ErrorOr<T> >::value()) ErrorOr<T>(ErrorOr<T>(t));
		this->~ErrorOrActorState();
		static_cast<ErrorOrActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ErrorOrActor*>(this)->actor_wait_state > 0) static_cast<ErrorOrActor*>(this)->actor_wait_state = 0;
		static_cast<ErrorOrActor*>(this)->ActorCallback< ErrorOrActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< ErrorOrActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("errorOr", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ErrorOrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("errorOr", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ErrorOrActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("errorOr", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ErrorOrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("errorOr", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ErrorOrActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("errorOr", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ErrorOrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("errorOr", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 143 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> f;
															#line 1132 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via errorOr()
															#line 143 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 143 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ErrorOrActor final : public Actor<ErrorOr<T>>, public ActorCallback< ErrorOrActor<T>, 0, T >, public FastAllocated<ErrorOrActor<T>>, public ErrorOrActorState<T, ErrorOrActor<T>> {
															#line 1139 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ErrorOrActor<T>>::operator new;
	using FastAllocated<ErrorOrActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2115882937375581440UL, 13387737463603134464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ErrorOr<T>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ErrorOrActor<T>, 0, T >;
															#line 143 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ErrorOrActor(Future<T> const& f) 
															#line 1156 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<ErrorOr<T>>(),
		   ErrorOrActorState<T, ErrorOrActor<T>>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("errorOr", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11716412140799802112UL, 5954230370677982464UL);
		ActorExecutionContextHelper __helper(static_cast<ErrorOrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("errorOr");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("errorOr", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ErrorOrActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 143 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 143 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<ErrorOr<T>> errorOr( Future<T> const& f ) {
															#line 143 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<ErrorOr<T>>(new ErrorOrActor<T>(f));
															#line 1191 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 152 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 1196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via throwErrorOr()
															#line 153 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class ThrowErrorOrActor>
															#line 153 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ThrowErrorOrActorState {
															#line 1203 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 153 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ThrowErrorOrActorState(Future<ErrorOr<T>> const& f) 
															#line 153 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 153 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : f(f)
															#line 1210 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("throwErrorOr", reinterpret_cast<unsigned long>(this));

	}
	~ThrowErrorOrActorState() 
	{
		fdb_probe_actor_destroy("throwErrorOr", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<ErrorOr<T>> __when_expr_0 = f;
															#line 155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<ThrowErrorOrActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1227 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ThrowErrorOrActor*>(this)->actor_wait_state = 1;
															#line 155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ThrowErrorOrActor, 0, ErrorOr<T> >*>(static_cast<ThrowErrorOrActor*>(this)));
															#line 1232 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ThrowErrorOrActorState();
		static_cast<ThrowErrorOrActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<T> const& t,int loopDepth) 
	{
															#line 156 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (t.isError())
															#line 1255 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 157 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(t.getError(), loopDepth);
															#line 1259 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 158 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ThrowErrorOrActor*>(this)->SAV<T>::futures) { (void)(t.get()); this->~ThrowErrorOrActorState(); static_cast<ThrowErrorOrActor*>(this)->destroy(); return 0; }
															#line 1263 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ThrowErrorOrActor*>(this)->SAV< T >::value()) T(t.get());
		this->~ThrowErrorOrActorState();
		static_cast<ThrowErrorOrActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<T> && t,int loopDepth) 
	{
															#line 156 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (t.isError())
															#line 1275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 157 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(t.getError(), loopDepth);
															#line 1279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 158 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ThrowErrorOrActor*>(this)->SAV<T>::futures) { (void)(t.get()); this->~ThrowErrorOrActorState(); static_cast<ThrowErrorOrActor*>(this)->destroy(); return 0; }
															#line 1283 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ThrowErrorOrActor*>(this)->SAV< T >::value()) T(t.get());
		this->~ThrowErrorOrActorState();
		static_cast<ThrowErrorOrActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<T> const& t,int loopDepth) 
	{
		loopDepth = a_body1cont1(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<T> && t,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ThrowErrorOrActor*>(this)->actor_wait_state > 0) static_cast<ThrowErrorOrActor*>(this)->actor_wait_state = 0;
		static_cast<ThrowErrorOrActor*>(this)->ActorCallback< ThrowErrorOrActor, 0, ErrorOr<T> >::remove();

	}
	void a_callback_fire(ActorCallback< ThrowErrorOrActor, 0, ErrorOr<T> >*,ErrorOr<T> const& value) 
	{
		fdb_probe_actor_enter("throwErrorOr", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrowErrorOrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throwErrorOr", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ThrowErrorOrActor, 0, ErrorOr<T> >*,ErrorOr<T> && value) 
	{
		fdb_probe_actor_enter("throwErrorOr", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThrowErrorOrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throwErrorOr", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ThrowErrorOrActor, 0, ErrorOr<T> >*,Error err) 
	{
		fdb_probe_actor_enter("throwErrorOr", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ThrowErrorOrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throwErrorOr", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 153 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<ErrorOr<T>> f;
															#line 1368 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via throwErrorOr()
															#line 153 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 153 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ThrowErrorOrActor final : public Actor<T>, public ActorCallback< ThrowErrorOrActor<T>, 0, ErrorOr<T> >, public FastAllocated<ThrowErrorOrActor<T>>, public ThrowErrorOrActorState<T, ThrowErrorOrActor<T>> {
															#line 1375 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ThrowErrorOrActor<T>>::operator new;
	using FastAllocated<ThrowErrorOrActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12273044438618898688UL, 3518211473877738240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ThrowErrorOrActor<T>, 0, ErrorOr<T> >;
															#line 153 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ThrowErrorOrActor(Future<ErrorOr<T>> const& f) 
															#line 1392 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   ThrowErrorOrActorState<T, ThrowErrorOrActor<T>>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("throwErrorOr", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2769770343984196352UL, 5857954321368918784UL);
		ActorExecutionContextHelper __helper(static_cast<ThrowErrorOrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("throwErrorOr");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("throwErrorOr", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ThrowErrorOrActor<T>, 0, ErrorOr<T> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 153 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 153 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> throwErrorOr( Future<ErrorOr<T>> const& f ) {
															#line 153 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new ThrowErrorOrActor<T>(f));
															#line 1427 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 160 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 1432 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via transformErrors()
															#line 161 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TransformErrorsActor>
															#line 161 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TransformErrorsActorState {
															#line 1439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 161 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TransformErrorsActorState(Future<T> const& f,Error const& err) 
															#line 161 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 161 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : f(f),
															#line 161 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   err(err)
															#line 1448 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("transformErrors", reinterpret_cast<unsigned long>(this));

	}
	~TransformErrorsActorState() 
	{
		fdb_probe_actor_destroy("transformErrors", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 164 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = f;
															#line 164 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<TransformErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1466 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TransformErrorsActor*>(this)->actor_wait_state = 1;
															#line 164 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TransformErrorsActor, 0, T >*>(static_cast<TransformErrorsActor*>(this)));
															#line 1471 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TransformErrorsActorState();
		static_cast<TransformErrorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 167 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_actor_cancelled)
															#line 1501 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 168 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(e, loopDepth);
															#line 1505 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 169 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(err, loopDepth);
															#line 1509 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& t,int loopDepth) 
	{
															#line 165 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TransformErrorsActor*>(this)->SAV<T>::futures) { (void)(t); this->~TransformErrorsActorState(); static_cast<TransformErrorsActor*>(this)->destroy(); return 0; }
															#line 1523 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TransformErrorsActor*>(this)->SAV< T >::value()) T(t);
		this->~TransformErrorsActorState();
		static_cast<TransformErrorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && t,int loopDepth) 
	{
															#line 165 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TransformErrorsActor*>(this)->SAV<T>::futures) { (void)(t); this->~TransformErrorsActorState(); static_cast<TransformErrorsActor*>(this)->destroy(); return 0; }
															#line 1535 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TransformErrorsActor*>(this)->SAV< T >::value()) T(t);
		this->~TransformErrorsActorState();
		static_cast<TransformErrorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TransformErrorsActor*>(this)->actor_wait_state > 0) static_cast<TransformErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TransformErrorsActor*>(this)->ActorCallback< TransformErrorsActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< TransformErrorsActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("transformErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransformErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transformErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TransformErrorsActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("transformErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransformErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transformErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TransformErrorsActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("transformErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransformErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transformErrors", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 161 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> f;
															#line 161 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Error err;
															#line 1622 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via transformErrors()
															#line 161 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 161 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TransformErrorsActor final : public Actor<T>, public ActorCallback< TransformErrorsActor<T>, 0, T >, public FastAllocated<TransformErrorsActor<T>>, public TransformErrorsActorState<T, TransformErrorsActor<T>> {
															#line 1629 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TransformErrorsActor<T>>::operator new;
	using FastAllocated<TransformErrorsActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5482408607096776192UL, 3652780385273582592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TransformErrorsActor<T>, 0, T >;
															#line 161 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TransformErrorsActor(Future<T> const& f,Error const& err) 
															#line 1646 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   TransformErrorsActorState<T, TransformErrorsActor<T>>(f, err),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("transformErrors", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11657275394851593984UL, 6624815060724573696UL);
		ActorExecutionContextHelper __helper(static_cast<TransformErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("transformErrors");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("transformErrors", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TransformErrorsActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 161 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 161 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> transformErrors( Future<T> const& f, Error const& err ) {
															#line 161 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new TransformErrorsActor<T>(f, err));
															#line 1681 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 172 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 1686 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via transformError()
															#line 173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TransformErrorActor>
															#line 173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TransformErrorActorState {
															#line 1693 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TransformErrorActorState(Future<T> const& f,Error const& inErr,Error const& outErr) 
															#line 173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : f(f),
															#line 173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   inErr(inErr),
															#line 173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   outErr(outErr)
															#line 1704 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("transformError", reinterpret_cast<unsigned long>(this));

	}
	~TransformErrorActorState() 
	{
		fdb_probe_actor_destroy("transformError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 176 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = f;
															#line 176 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<TransformErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1722 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TransformErrorActor*>(this)->actor_wait_state = 1;
															#line 176 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TransformErrorActor, 0, T >*>(static_cast<TransformErrorActor*>(this)));
															#line 1727 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TransformErrorActorState();
		static_cast<TransformErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 179 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == inErr.code())
															#line 1757 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 180 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(outErr, loopDepth);
															#line 1761 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 181 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 1765 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& t,int loopDepth) 
	{
															#line 177 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TransformErrorActor*>(this)->SAV<T>::futures) { (void)(t); this->~TransformErrorActorState(); static_cast<TransformErrorActor*>(this)->destroy(); return 0; }
															#line 1779 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TransformErrorActor*>(this)->SAV< T >::value()) T(t);
		this->~TransformErrorActorState();
		static_cast<TransformErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && t,int loopDepth) 
	{
															#line 177 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TransformErrorActor*>(this)->SAV<T>::futures) { (void)(t); this->~TransformErrorActorState(); static_cast<TransformErrorActor*>(this)->destroy(); return 0; }
															#line 1791 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TransformErrorActor*>(this)->SAV< T >::value()) T(t);
		this->~TransformErrorActorState();
		static_cast<TransformErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TransformErrorActor*>(this)->actor_wait_state > 0) static_cast<TransformErrorActor*>(this)->actor_wait_state = 0;
		static_cast<TransformErrorActor*>(this)->ActorCallback< TransformErrorActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< TransformErrorActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("transformError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransformErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transformError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TransformErrorActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("transformError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransformErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transformError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TransformErrorActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("transformError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransformErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transformError", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> f;
															#line 173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Error inErr;
															#line 173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Error outErr;
															#line 1880 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via transformError()
															#line 173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TransformErrorActor final : public Actor<T>, public ActorCallback< TransformErrorActor<T>, 0, T >, public FastAllocated<TransformErrorActor<T>>, public TransformErrorActorState<T, TransformErrorActor<T>> {
															#line 1887 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TransformErrorActor<T>>::operator new;
	using FastAllocated<TransformErrorActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1594245976876762112UL, 18377021677829898240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TransformErrorActor<T>, 0, T >;
															#line 173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TransformErrorActor(Future<T> const& f,Error const& inErr,Error const& outErr) 
															#line 1904 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   TransformErrorActorState<T, TransformErrorActor<T>>(f, inErr, outErr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("transformError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9980958667131008256UL, 637528603381318400UL);
		ActorExecutionContextHelper __helper(static_cast<TransformErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("transformError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("transformError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TransformErrorActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> transformError( Future<T> const& f, Error const& inErr, Error const& outErr ) {
															#line 173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new TransformErrorActor<T>(f, inErr, outErr));
															#line 1939 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 184 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Note that the RequestStream<T> version of forwardPromise doesn't exist, because what to do with errors?

															#line 1946 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via forwardEvent()
															#line 187 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class ForwardEventActor>
															#line 187 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardEventActorState {
															#line 1953 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 187 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardEventActorState(Event* const& ev,Future<T> const& input) 
															#line 187 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 187 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : ev(ev),
															#line 187 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   input(input)
															#line 1962 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("forwardEvent", reinterpret_cast<unsigned long>(this));

	}
	~ForwardEventActorState() 
	{
		fdb_probe_actor_destroy("forwardEvent", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 190 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = input;
															#line 190 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1980 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				static_cast<ForwardEventActor*>(this)->actor_wait_state = 1;
															#line 190 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ForwardEventActor, 0, T >*>(static_cast<ForwardEventActor*>(this)));
															#line 1984 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<ForwardEventActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 193 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		ev->set();
															#line 2012 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& value,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(T && value,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& value,int loopDepth) 
	{
		loopDepth = a_body1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && value,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForwardEventActor*>(this)->actor_wait_state > 0) static_cast<ForwardEventActor*>(this)->actor_wait_state = 0;
		static_cast<ForwardEventActor*>(this)->ActorCallback< ForwardEventActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< ForwardEventActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("forwardEvent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardEventActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardEvent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ForwardEventActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("forwardEvent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardEventActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardEvent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ForwardEventActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("forwardEvent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardEventActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardEvent", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 187 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		delete static_cast<ForwardEventActor*>(this);
															#line 2134 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		return 0;

		return loopDepth;
	}
															#line 187 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Event* ev;
															#line 187 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> input;
															#line 2143 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via forwardEvent()
															#line 187 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 187 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardEventActor final : public Actor<void>, public ActorCallback< ForwardEventActor<T>, 0, T >, public FastAllocated<ForwardEventActor<T>>, public ForwardEventActorState<T, ForwardEventActor<T>> {
															#line 2150 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ForwardEventActor<T>>::operator new;
	using FastAllocated<ForwardEventActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8332377668098762496UL, 5788909690104936448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< ForwardEventActor<T>, 0, T >;
															#line 187 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardEventActor(Event* const& ev,Future<T> const& input) 
															#line 2167 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<void>(),
		   ForwardEventActorState<T, ForwardEventActor<T>>(ev, input),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("forwardEvent", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6200645388654390528UL, 9166489727541313536UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardEventActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forwardEvent");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forwardEvent", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 187 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 187 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
void forwardEvent( Event* const& ev, Future<T> const& input ) {
															#line 187 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	new ForwardEventActor<T>(ev, input);
															#line 2193 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 2198 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via forwardEvent()
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class ForwardEventActor1>
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardEventActor1State {
															#line 2205 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardEventActor1State(Event* const& ev,T* const& t,Error* const& err,FutureStream<T> const& input) 
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : ev(ev),
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   t(t),
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   err(err),
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   input(input)
															#line 2218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("forwardEvent", reinterpret_cast<unsigned long>(this));

	}
	~ForwardEventActor1State() 
	{
		fdb_probe_actor_destroy("forwardEvent", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 199 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				FutureStream<T> __when_expr_0 = input;
															#line 199 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.pop(), loopDepth); };
															#line 2236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				static_cast<ForwardEventActor1*>(this)->actor_wait_state = 1;
															#line 199 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ForwardEventActor1, 0, T >*>(static_cast<ForwardEventActor1*>(this)));
															#line 2240 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<ForwardEventActor1*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 203 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			*err = e;
															#line 204 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			ev->set();
															#line 2277 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& value,int loopDepth) 
	{
															#line 200 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		*t = std::move(value);
															#line 201 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		ev->set();
															#line 2294 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(T && value,int loopDepth) 
	{
															#line 200 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		*t = std::move(value);
															#line 201 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		ev->set();
															#line 2305 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& value,int loopDepth) 
	{
		loopDepth = a_body1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && value,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForwardEventActor1*>(this)->actor_wait_state > 0) static_cast<ForwardEventActor1*>(this)->actor_wait_state = 0;
		static_cast<ForwardEventActor1*>(this)->ActorSingleCallback< ForwardEventActor1, 0, T >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ForwardEventActor1, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("forwardEvent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardEventActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardEvent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ForwardEventActor1, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("forwardEvent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardEventActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardEvent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ForwardEventActor1, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("forwardEvent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardEventActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardEvent", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		delete static_cast<ForwardEventActor1*>(this);
															#line 2402 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		return 0;

		return loopDepth;
	}
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Event* ev;
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T* t;
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Error* err;
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FutureStream<T> input;
															#line 2415 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via forwardEvent()
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardEventActor1 final : public Actor<void>, public ActorSingleCallback< ForwardEventActor1<T>, 0, T >, public FastAllocated<ForwardEventActor1<T>>, public ForwardEventActor1State<T, ForwardEventActor1<T>> {
															#line 2422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ForwardEventActor1<T>>::operator new;
	using FastAllocated<ForwardEventActor1<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8332377668098762496UL, 5788909690104936448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ForwardEventActor1<T>, 0, T >;
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardEventActor1(Event* const& ev,T* const& t,Error* const& err,FutureStream<T> const& input) 
															#line 2439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<void>(),
		   ForwardEventActor1State<T, ForwardEventActor1<T>>(ev, t, err, input),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("forwardEvent", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14562188606497896192UL, 2586663270842488832UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardEventActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forwardEvent");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forwardEvent", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
void forwardEvent( Event* const& ev, T* const& t, Error* const& err, FutureStream<T> const& input ) {
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	new ForwardEventActor1<T>(ev, t, err, input);
															#line 2465 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 207 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 2470 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via waitForAllReady()
															#line 208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class WaitForAllReadyActor>
															#line 208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class WaitForAllReadyActorState {
															#line 2477 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	WaitForAllReadyActorState(std::vector<Future<T>> const& results) 
															#line 208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : results(results),
															#line 210 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   i(0)
															#line 2486 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("waitForAllReady", reinterpret_cast<unsigned long>(this));

	}
	~WaitForAllReadyActorState() 
	{
		fdb_probe_actor_destroy("waitForAllReady", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 211 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 2501 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForAllReadyActorState();
		static_cast<WaitForAllReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (i == results.size())
															#line 2531 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 213 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (!static_cast<WaitForAllReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForAllReadyActorState(); static_cast<WaitForAllReadyActor*>(this)->destroy(); return 0; }
															#line 2535 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			new (&static_cast<WaitForAllReadyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitForAllReadyActorState();
			static_cast<WaitForAllReadyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		try {
															#line 215 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = results[i];
															#line 215 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<WaitForAllReadyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2546 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitForAllReadyActor*>(this)->actor_wait_state = 1;
															#line 215 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForAllReadyActor, 0, T >*>(static_cast<WaitForAllReadyActor*>(this)));
															#line 2551 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 219 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		i++;
															#line 2566 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& __current_error,int loopDepth=0) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(T const& t,int loopDepth) 
	{
															#line 216 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		(void)t;
															#line 2588 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(T && t,int loopDepth) 
	{
															#line 216 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		(void)t;
															#line 2597 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(t, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForAllReadyActor*>(this)->actor_wait_state > 0) static_cast<WaitForAllReadyActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForAllReadyActor*>(this)->ActorCallback< WaitForAllReadyActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForAllReadyActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("waitForAllReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForAllReadyActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("waitForAllReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForAllReadyActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("waitForAllReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllReady", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	std::vector<Future<T>> results;
															#line 210 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	int i;
															#line 2694 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via waitForAllReady()
															#line 208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class WaitForAllReadyActor final : public Actor<Void>, public ActorCallback< WaitForAllReadyActor<T>, 0, T >, public FastAllocated<WaitForAllReadyActor<T>>, public WaitForAllReadyActorState<T, WaitForAllReadyActor<T>> {
															#line 2701 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<WaitForAllReadyActor<T>>::operator new;
	using FastAllocated<WaitForAllReadyActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16971470385763315456UL, 12990621058959133952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForAllReadyActor<T>, 0, T >;
															#line 208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	WaitForAllReadyActor(std::vector<Future<T>> const& results) 
															#line 2718 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   WaitForAllReadyActorState<T, WaitForAllReadyActor<T>>(results),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForAllReady", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10563470008250428928UL, 627497100362957824UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForAllReady");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForAllReady", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForAllReadyActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> waitForAllReady( std::vector<Future<T>> const& results ) {
															#line 208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new WaitForAllReadyActor<T>(results));
															#line 2753 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 222 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 2758 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via timeout()
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TimeoutActor>
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TimeoutActorState {
															#line 2765 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TimeoutActorState(Future<T> const& what,double const& time,T const& timedoutValue,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   time(time),
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   timedoutValue(timedoutValue),
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   taskID(taskID)
															#line 2778 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("timeout", reinterpret_cast<unsigned long>(this));

	}
	~TimeoutActorState() 
	{
		fdb_probe_actor_destroy("timeout", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 225 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			Future<Void> end = delay(time, taskID);
															#line 227 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = what;
															#line 226 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<TimeoutActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2797 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 230 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = end;
															#line 2801 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<TimeoutActor*>(this)->actor_wait_state = 1;
															#line 227 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TimeoutActor, 0, T >*>(static_cast<TimeoutActor*>(this)));
															#line 230 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TimeoutActor, 1, Void >*>(static_cast<TimeoutActor*>(this)));
															#line 2808 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TimeoutActorState();
		static_cast<TimeoutActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
															#line 228 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutActor*>(this)->SAV<T>::futures) { (void)(t); this->~TimeoutActorState(); static_cast<TimeoutActor*>(this)->destroy(); return 0; }
															#line 2831 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutActor*>(this)->SAV< T >::value()) T(t);
		this->~TimeoutActorState();
		static_cast<TimeoutActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
															#line 228 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutActor*>(this)->SAV<T>::futures) { (void)(t); this->~TimeoutActorState(); static_cast<TimeoutActor*>(this)->destroy(); return 0; }
															#line 2843 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutActor*>(this)->SAV< T >::value()) T(t);
		this->~TimeoutActorState();
		static_cast<TimeoutActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 231 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutActor*>(this)->SAV<T>::futures) { (void)(timedoutValue); this->~TimeoutActorState(); static_cast<TimeoutActor*>(this)->destroy(); return 0; }
															#line 2855 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutActor*>(this)->SAV< T >::value()) T(std::move(timedoutValue)); // state_var_RVO
		this->~TimeoutActorState();
		static_cast<TimeoutActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 231 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutActor*>(this)->SAV<T>::futures) { (void)(timedoutValue); this->~TimeoutActorState(); static_cast<TimeoutActor*>(this)->destroy(); return 0; }
															#line 2867 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutActor*>(this)->SAV< T >::value()) T(std::move(timedoutValue)); // state_var_RVO
		this->~TimeoutActorState();
		static_cast<TimeoutActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TimeoutActor*>(this)->actor_wait_state > 0) static_cast<TimeoutActor*>(this)->actor_wait_state = 0;
		static_cast<TimeoutActor*>(this)->ActorCallback< TimeoutActor, 0, T >::remove();
		static_cast<TimeoutActor*>(this)->ActorCallback< TimeoutActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeoutActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeoutActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TimeoutActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeoutActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TimeoutActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TimeoutActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double time;
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T timedoutValue;
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TaskPriority taskID;
															#line 3004 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via timeout()
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TimeoutActor final : public Actor<T>, public ActorCallback< TimeoutActor<T>, 0, T >, public ActorCallback< TimeoutActor<T>, 1, Void >, public FastAllocated<TimeoutActor<T>>, public TimeoutActorState<T, TimeoutActor<T>> {
															#line 3011 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TimeoutActor<T>>::operator new;
	using FastAllocated<TimeoutActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10164005925088870144UL, 13045905541788456448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TimeoutActor<T>, 0, T >;
friend struct ActorCallback< TimeoutActor<T>, 1, Void >;
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TimeoutActor(Future<T> const& what,double const& time,T const& timedoutValue,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 3029 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   TimeoutActorState<T, TimeoutActor<T>>(what, time, timedoutValue, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13051185860954458624UL, 15486350049698238976UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("timeout");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TimeoutActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> timeout( Future<T> const& what, double const& time, T const& timedoutValue, TaskPriority const& taskID = TaskPriority::DefaultDelay ) {
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new TimeoutActor<T>(what, time, timedoutValue, taskID));
															#line 3064 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 235 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 3069 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via timeout()
															#line 236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TimeoutActor1>
															#line 236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TimeoutActor1State {
															#line 3076 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TimeoutActor1State(Future<T> const& what,double const& time) 
															#line 236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   time(time)
															#line 3085 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("timeout", reinterpret_cast<unsigned long>(this));

	}
	~TimeoutActor1State() 
	{
		fdb_probe_actor_destroy("timeout", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 238 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			Future<Void> end = delay(time);
															#line 240 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = what;
															#line 239 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<TimeoutActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3104 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 243 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = end;
															#line 3108 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<TimeoutActor1*>(this)->actor_wait_state = 1;
															#line 240 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TimeoutActor1, 0, T >*>(static_cast<TimeoutActor1*>(this)));
															#line 243 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TimeoutActor1, 1, Void >*>(static_cast<TimeoutActor1*>(this)));
															#line 3115 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TimeoutActor1State();
		static_cast<TimeoutActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
															#line 241 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutActor1*>(this)->SAV<Optional<T>>::futures) { (void)(t); this->~TimeoutActor1State(); static_cast<TimeoutActor1*>(this)->destroy(); return 0; }
															#line 3138 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutActor1*>(this)->SAV< Optional<T> >::value()) Optional<T>(t);
		this->~TimeoutActor1State();
		static_cast<TimeoutActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
															#line 241 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutActor1*>(this)->SAV<Optional<T>>::futures) { (void)(t); this->~TimeoutActor1State(); static_cast<TimeoutActor1*>(this)->destroy(); return 0; }
															#line 3150 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutActor1*>(this)->SAV< Optional<T> >::value()) Optional<T>(t);
		this->~TimeoutActor1State();
		static_cast<TimeoutActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 244 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutActor1*>(this)->SAV<Optional<T>>::futures) { (void)(Optional<T>()); this->~TimeoutActor1State(); static_cast<TimeoutActor1*>(this)->destroy(); return 0; }
															#line 3162 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutActor1*>(this)->SAV< Optional<T> >::value()) Optional<T>(Optional<T>());
		this->~TimeoutActor1State();
		static_cast<TimeoutActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 244 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutActor1*>(this)->SAV<Optional<T>>::futures) { (void)(Optional<T>()); this->~TimeoutActor1State(); static_cast<TimeoutActor1*>(this)->destroy(); return 0; }
															#line 3174 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutActor1*>(this)->SAV< Optional<T> >::value()) Optional<T>(Optional<T>());
		this->~TimeoutActor1State();
		static_cast<TimeoutActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TimeoutActor1*>(this)->actor_wait_state > 0) static_cast<TimeoutActor1*>(this)->actor_wait_state = 0;
		static_cast<TimeoutActor1*>(this)->ActorCallback< TimeoutActor1, 0, T >::remove();
		static_cast<TimeoutActor1*>(this)->ActorCallback< TimeoutActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeoutActor1, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeoutActor1, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TimeoutActor1, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeoutActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TimeoutActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TimeoutActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double time;
															#line 3307 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via timeout()
															#line 236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TimeoutActor1 final : public Actor<Optional<T>>, public ActorCallback< TimeoutActor1<T>, 0, T >, public ActorCallback< TimeoutActor1<T>, 1, Void >, public FastAllocated<TimeoutActor1<T>>, public TimeoutActor1State<T, TimeoutActor1<T>> {
															#line 3314 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TimeoutActor1<T>>::operator new;
	using FastAllocated<TimeoutActor1<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10164005925088870144UL, 13045905541788456448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<T>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TimeoutActor1<T>, 0, T >;
friend struct ActorCallback< TimeoutActor1<T>, 1, Void >;
															#line 236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TimeoutActor1(Future<T> const& what,double const& time) 
															#line 3332 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Optional<T>>(),
		   TimeoutActor1State<T, TimeoutActor1<T>>(what, time),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("timeout", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7560104613500780800UL, 5405592158884213248UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("timeout");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("timeout", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TimeoutActor1<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Optional<T>> timeout( Future<T> const& what, double const& time ) {
															#line 236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Optional<T>>(new TimeoutActor1<T>(what, time));
															#line 3367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 248 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 3372 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via timeoutError()
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TimeoutErrorActor>
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TimeoutErrorActorState {
															#line 3379 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TimeoutErrorActorState(Future<T> const& what,double const& time,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   time(time),
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   taskID(taskID)
															#line 3390 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("timeoutError", reinterpret_cast<unsigned long>(this));

	}
	~TimeoutErrorActorState() 
	{
		fdb_probe_actor_destroy("timeoutError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 251 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			Future<Void> end = delay(time, taskID);
															#line 253 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = what;
															#line 252 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<TimeoutErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3409 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 256 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = end;
															#line 3413 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<TimeoutErrorActor*>(this)->actor_wait_state = 1;
															#line 253 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TimeoutErrorActor, 0, T >*>(static_cast<TimeoutErrorActor*>(this)));
															#line 256 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TimeoutErrorActor, 1, Void >*>(static_cast<TimeoutErrorActor*>(this)));
															#line 3420 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TimeoutErrorActorState();
		static_cast<TimeoutErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
															#line 254 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutErrorActor*>(this)->SAV<T>::futures) { (void)(t); this->~TimeoutErrorActorState(); static_cast<TimeoutErrorActor*>(this)->destroy(); return 0; }
															#line 3443 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutErrorActor*>(this)->SAV< T >::value()) T(t);
		this->~TimeoutErrorActorState();
		static_cast<TimeoutErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
															#line 254 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutErrorActor*>(this)->SAV<T>::futures) { (void)(t); this->~TimeoutErrorActorState(); static_cast<TimeoutErrorActor*>(this)->destroy(); return 0; }
															#line 3455 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutErrorActor*>(this)->SAV< T >::value()) T(t);
		this->~TimeoutErrorActorState();
		static_cast<TimeoutErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 257 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(timed_out(), loopDepth);
															#line 3467 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 257 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(timed_out(), loopDepth);
															#line 3475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TimeoutErrorActor*>(this)->actor_wait_state > 0) static_cast<TimeoutErrorActor*>(this)->actor_wait_state = 0;
		static_cast<TimeoutErrorActor*>(this)->ActorCallback< TimeoutErrorActor, 0, T >::remove();
		static_cast<TimeoutErrorActor*>(this)->ActorCallback< TimeoutErrorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeoutErrorActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("timeoutError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeoutErrorActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("timeoutError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TimeoutErrorActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("timeoutError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeoutErrorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeoutError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TimeoutErrorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeoutError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TimeoutErrorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeoutError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutError", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double time;
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TaskPriority taskID;
															#line 3606 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via timeoutError()
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TimeoutErrorActor final : public Actor<T>, public ActorCallback< TimeoutErrorActor<T>, 0, T >, public ActorCallback< TimeoutErrorActor<T>, 1, Void >, public FastAllocated<TimeoutErrorActor<T>>, public TimeoutErrorActorState<T, TimeoutErrorActor<T>> {
															#line 3613 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TimeoutErrorActor<T>>::operator new;
	using FastAllocated<TimeoutErrorActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(813453222535463680UL, 13966081594961450752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TimeoutErrorActor<T>, 0, T >;
friend struct ActorCallback< TimeoutErrorActor<T>, 1, Void >;
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TimeoutErrorActor(Future<T> const& what,double const& time,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 3631 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   TimeoutErrorActorState<T, TimeoutErrorActor<T>>(what, time, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("timeoutError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(778417935462168064UL, 640599530370607360UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("timeoutError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("timeoutError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TimeoutErrorActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> timeoutError( Future<T> const& what, double const& time, TaskPriority const& taskID = TaskPriority::DefaultDelay ) {
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new TimeoutErrorActor<T>(what, time, taskID));
															#line 3666 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 261 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 3671 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via delayed()
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class DelayedActor>
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DelayedActorState {
															#line 3678 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DelayedActorState(Future<T> const& what,double const& time = 0.0,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   time(time),
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   taskID(taskID)
															#line 3689 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("delayed", reinterpret_cast<unsigned long>(this));

	}
	~DelayedActorState() 
	{
		fdb_probe_actor_destroy("delayed", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 265 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = what;
															#line 265 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<DelayedActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3707 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DelayedActor*>(this)->actor_wait_state = 1;
															#line 265 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DelayedActor, 0, T >*>(static_cast<DelayedActor*>(this)));
															#line 3712 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DelayedActorState();
		static_cast<DelayedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			err = e;
															#line 270 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_2 = delay(time, taskID);
															#line 270 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<DelayedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3746 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_2.get(), loopDepth); };
			static_cast<DelayedActor*>(this)->actor_wait_state = 3;
															#line 270 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DelayedActor, 2, Void >*>(static_cast<DelayedActor*>(this)));
															#line 3751 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 266 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = delay(time, taskID);
															#line 266 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<DelayedActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3768 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DelayedActor*>(this)->actor_wait_state = 2;
															#line 266 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DelayedActor, 1, Void >*>(static_cast<DelayedActor*>(this)));
															#line 3773 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& __t,int loopDepth) 
	{
															#line 265 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		t = __t;
															#line 3782 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && __t,int loopDepth) 
	{
		t = std::move(__t);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DelayedActor*>(this)->actor_wait_state > 0) static_cast<DelayedActor*>(this)->actor_wait_state = 0;
		static_cast<DelayedActor*>(this)->ActorCallback< DelayedActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< DelayedActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DelayedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DelayedActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DelayedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DelayedActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DelayedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 267 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<DelayedActor*>(this)->SAV<T>::futures) { (void)(t); this->~DelayedActorState(); static_cast<DelayedActor*>(this)->destroy(); return 0; }
															#line 3861 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<DelayedActor*>(this)->SAV< T >::value()) T(std::move(t)); // state_var_RVO
		this->~DelayedActorState();
		static_cast<DelayedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 267 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<DelayedActor*>(this)->SAV<T>::futures) { (void)(t); this->~DelayedActorState(); static_cast<DelayedActor*>(this)->destroy(); return 0; }
															#line 3873 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<DelayedActor*>(this)->SAV< T >::value()) T(std::move(t)); // state_var_RVO
		this->~DelayedActorState();
		static_cast<DelayedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DelayedActor*>(this)->actor_wait_state > 0) static_cast<DelayedActor*>(this)->actor_wait_state = 0;
		static_cast<DelayedActor*>(this)->ActorCallback< DelayedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DelayedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DelayedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DelayedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DelayedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DelayedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DelayedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
															#line 271 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(err, loopDepth);
															#line 3960 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
															#line 271 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(err, loopDepth);
															#line 3968 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DelayedActor*>(this)->actor_wait_state > 0) static_cast<DelayedActor*>(this)->actor_wait_state = 0;
		static_cast<DelayedActor*>(this)->ActorCallback< DelayedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DelayedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DelayedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DelayedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DelayedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DelayedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DelayedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double time;
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TaskPriority taskID;
															#line 265 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T t;
															#line 269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Error err;
															#line 4057 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via delayed()
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DelayedActor final : public Actor<T>, public ActorCallback< DelayedActor<T>, 0, T >, public ActorCallback< DelayedActor<T>, 1, Void >, public ActorCallback< DelayedActor<T>, 2, Void >, public FastAllocated<DelayedActor<T>>, public DelayedActorState<T, DelayedActor<T>> {
															#line 4064 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<DelayedActor<T>>::operator new;
	using FastAllocated<DelayedActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14151301506491350784UL, 15923131542681473024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DelayedActor<T>, 0, T >;
friend struct ActorCallback< DelayedActor<T>, 1, Void >;
friend struct ActorCallback< DelayedActor<T>, 2, Void >;
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DelayedActor(Future<T> const& what,double const& time = 0.0,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 4083 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   DelayedActorState<T, DelayedActor<T>>(what, time, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("delayed", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14478744964553408000UL, 13433997968188451584UL);
		ActorExecutionContextHelper __helper(static_cast<DelayedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("delayed");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("delayed", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DelayedActor<T>, 0, T >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DelayedActor<T>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DelayedActor<T>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> delayed( Future<T> const& what, double const& time = 0.0, TaskPriority const& taskID = TaskPriority::DefaultDelay ) {
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new DelayedActor<T>(what, time, taskID));
															#line 4120 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 274 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 4125 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via trigger()
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func, class TriggerActor>
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TriggerActorState {
															#line 4132 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TriggerActorState(Func const& what,Future<Void> const& signal) 
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   signal(signal)
															#line 4141 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("trigger", reinterpret_cast<unsigned long>(this));

	}
	~TriggerActorState() 
	{
		fdb_probe_actor_destroy("trigger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 277 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = signal;
															#line 277 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<TriggerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4158 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TriggerActor*>(this)->actor_wait_state = 1;
															#line 277 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TriggerActor, 0, Void >*>(static_cast<TriggerActor*>(this)));
															#line 4163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TriggerActorState();
		static_cast<TriggerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 278 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		what();
															#line 279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TriggerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TriggerActorState(); static_cast<TriggerActor*>(this)->destroy(); return 0; }
															#line 4188 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TriggerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TriggerActorState();
		static_cast<TriggerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 278 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		what();
															#line 279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TriggerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TriggerActorState(); static_cast<TriggerActor*>(this)->destroy(); return 0; }
															#line 4202 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TriggerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TriggerActorState();
		static_cast<TriggerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TriggerActor*>(this)->actor_wait_state > 0) static_cast<TriggerActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerActor*>(this)->ActorCallback< TriggerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trigger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trigger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TriggerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trigger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trigger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TriggerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trigger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trigger", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Func what;
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> signal;
															#line 4289 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via trigger()
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func>
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TriggerActor final : public Actor<Void>, public ActorCallback< TriggerActor<Func>, 0, Void >, public FastAllocated<TriggerActor<Func>>, public TriggerActorState<Func, TriggerActor<Func>> {
															#line 4296 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TriggerActor<Func>>::operator new;
	using FastAllocated<TriggerActor<Func>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5427162005618654720UL, 11148903742148797184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TriggerActor<Func>, 0, Void >;
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TriggerActor(Func const& what,Future<Void> const& signal) 
															#line 4313 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   TriggerActorState<Func, TriggerActor<Func>>(what, signal),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trigger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13374690680355781632UL, 17606309391711693824UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trigger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trigger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TriggerActor<Func>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func>
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> trigger( Func const& what, Future<Void> const& signal ) {
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new TriggerActor<Func>(what, signal));
															#line 4348 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 281 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 4353 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via triggerOnError()
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func, class TriggerOnErrorActor>
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TriggerOnErrorActorState {
															#line 4360 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TriggerOnErrorActorState(Func const& what,Future<Void> const& signal) 
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   signal(signal)
															#line 4369 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("triggerOnError", reinterpret_cast<unsigned long>(this));

	}
	~TriggerOnErrorActorState() 
	{
		fdb_probe_actor_destroy("triggerOnError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 285 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<Void> __when_expr_0 = signal;
															#line 285 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<TriggerOnErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4387 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TriggerOnErrorActor*>(this)->actor_wait_state = 1;
															#line 285 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TriggerOnErrorActor, 0, Void >*>(static_cast<TriggerOnErrorActor*>(this)));
															#line 4392 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TriggerOnErrorActorState();
		static_cast<TriggerOnErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 290 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TriggerOnErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TriggerOnErrorActorState(); static_cast<TriggerOnErrorActor*>(this)->destroy(); return 0; }
															#line 4421 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TriggerOnErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TriggerOnErrorActorState();
		static_cast<TriggerOnErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 287 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			what();
															#line 4434 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TriggerOnErrorActor*>(this)->actor_wait_state > 0) static_cast<TriggerOnErrorActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerOnErrorActor*>(this)->ActorCallback< TriggerOnErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerOnErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("triggerOnError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerOnErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerOnError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TriggerOnErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("triggerOnError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerOnErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerOnError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TriggerOnErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("triggerOnError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerOnErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerOnError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Func what;
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> signal;
															#line 4549 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via triggerOnError()
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func>
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TriggerOnErrorActor final : public Actor<Void>, public ActorCallback< TriggerOnErrorActor<Func>, 0, Void >, public FastAllocated<TriggerOnErrorActor<Func>>, public TriggerOnErrorActorState<Func, TriggerOnErrorActor<Func>> {
															#line 4556 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TriggerOnErrorActor<Func>>::operator new;
	using FastAllocated<TriggerOnErrorActor<Func>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7028809828571445504UL, 3681229920758843392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TriggerOnErrorActor<Func>, 0, Void >;
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TriggerOnErrorActor(Func const& what,Future<Void> const& signal) 
															#line 4573 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   TriggerOnErrorActorState<Func, TriggerOnErrorActor<Func>>(what, signal),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("triggerOnError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12265882325865047296UL, 1649008332912012032UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerOnErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("triggerOnError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("triggerOnError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TriggerOnErrorActor<Func>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func>
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> triggerOnError( Func const& what, Future<Void> const& signal ) {
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new TriggerOnErrorActor<Func>(what, signal));
															#line 4608 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 292 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Waits for a future to complete and cannot be cancelled
// Most situations will use the overload below, which does not require a promise
															#line 4615 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via uncancellable()
															#line 295 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class UncancellableActor>
															#line 295 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class UncancellableActorState {
															#line 4622 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 295 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	UncancellableActorState(Future<T> const& what,Promise<T> const& result) 
															#line 295 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 295 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 295 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   result(result)
															#line 4631 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("uncancellable", reinterpret_cast<unsigned long>(this));

	}
	~UncancellableActorState() 
	{
		fdb_probe_actor_destroy("uncancellable", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 298 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = what;
															#line 298 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 4649 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				static_cast<UncancellableActor*>(this)->actor_wait_state = 1;
															#line 298 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UncancellableActor, 0, T >*>(static_cast<UncancellableActor*>(this)));
															#line 4653 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<UncancellableActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 301 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			result.sendError(e);
															#line 4688 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& val,int loopDepth) 
	{
															#line 299 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		result.send(val);
															#line 4703 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(T && val,int loopDepth) 
	{
															#line 299 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		result.send(val);
															#line 4712 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
		loopDepth = a_body1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UncancellableActor*>(this)->actor_wait_state > 0) static_cast<UncancellableActor*>(this)->actor_wait_state = 0;
		static_cast<UncancellableActor*>(this)->ActorCallback< UncancellableActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< UncancellableActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("uncancellable", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UncancellableActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uncancellable", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UncancellableActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("uncancellable", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UncancellableActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uncancellable", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UncancellableActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("uncancellable", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UncancellableActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uncancellable", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 295 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		delete static_cast<UncancellableActor*>(this);
															#line 4809 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		return 0;

		return loopDepth;
	}
															#line 295 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 295 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Promise<T> result;
															#line 4818 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via uncancellable()
															#line 295 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 295 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class UncancellableActor final : public Actor<void>, public ActorCallback< UncancellableActor<T>, 0, T >, public FastAllocated<UncancellableActor<T>>, public UncancellableActorState<T, UncancellableActor<T>> {
															#line 4825 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<UncancellableActor<T>>::operator new;
	using FastAllocated<UncancellableActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2091324047047237888UL, 8458171498001425664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< UncancellableActor<T>, 0, T >;
															#line 295 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	UncancellableActor(Future<T> const& what,Promise<T> const& result) 
															#line 4842 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<void>(),
		   UncancellableActorState<T, UncancellableActor<T>>(what, result),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("uncancellable", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16931823273241732096UL, 18269465193061821184UL);
		ActorExecutionContextHelper __helper(static_cast<UncancellableActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("uncancellable");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("uncancellable", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 295 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 295 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
void uncancellable( Future<T> const& what, Promise<T> const& result ) {
															#line 295 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	new UncancellableActor<T>(what, result);
															#line 4868 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 304 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Waits for a future to complete and cannot be cancelled
															#line 4874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via uncancellable()
															#line 306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class UncancellableActor1>
															#line 306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class UncancellableActor1State {
															#line 4881 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	UncancellableActor1State(Future<T> const& what) 
															#line 306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what)
															#line 4888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("uncancellable", reinterpret_cast<unsigned long>(this));

	}
	~UncancellableActor1State() 
	{
		fdb_probe_actor_destroy("uncancellable", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 308 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			Promise<T> resultPromise;
															#line 309 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			Future<T> result = resultPromise.getFuture();
															#line 311 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			uncancellable(what, resultPromise);
															#line 312 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = result;
															#line 312 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<UncancellableActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4911 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UncancellableActor1*>(this)->actor_wait_state = 1;
															#line 312 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UncancellableActor1, 0, T >*>(static_cast<UncancellableActor1*>(this)));
															#line 4916 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UncancellableActor1State();
		static_cast<UncancellableActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& val,int loopDepth) 
	{
															#line 314 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<UncancellableActor1*>(this)->SAV<T>::futures) { (void)(val); this->~UncancellableActor1State(); static_cast<UncancellableActor1*>(this)->destroy(); return 0; }
															#line 4939 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<UncancellableActor1*>(this)->SAV< T >::value()) T(val);
		this->~UncancellableActor1State();
		static_cast<UncancellableActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(T && val,int loopDepth) 
	{
															#line 314 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<UncancellableActor1*>(this)->SAV<T>::futures) { (void)(val); this->~UncancellableActor1State(); static_cast<UncancellableActor1*>(this)->destroy(); return 0; }
															#line 4951 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<UncancellableActor1*>(this)->SAV< T >::value()) T(val);
		this->~UncancellableActor1State();
		static_cast<UncancellableActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UncancellableActor1*>(this)->actor_wait_state > 0) static_cast<UncancellableActor1*>(this)->actor_wait_state = 0;
		static_cast<UncancellableActor1*>(this)->ActorCallback< UncancellableActor1, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< UncancellableActor1, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("uncancellable", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UncancellableActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uncancellable", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UncancellableActor1, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("uncancellable", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UncancellableActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uncancellable", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UncancellableActor1, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("uncancellable", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UncancellableActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uncancellable", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 5036 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via uncancellable()
															#line 306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class UncancellableActor1 final : public Actor<T>, public ActorCallback< UncancellableActor1<T>, 0, T >, public FastAllocated<UncancellableActor1<T>>, public UncancellableActor1State<T, UncancellableActor1<T>> {
															#line 5043 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<UncancellableActor1<T>>::operator new;
	using FastAllocated<UncancellableActor1<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2091324047047237888UL, 8458171498001425664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UncancellableActor1<T>, 0, T >;
															#line 306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	UncancellableActor1(Future<T> const& what) 
															#line 5060 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   UncancellableActor1State<T, UncancellableActor1<T>>(what),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("uncancellable", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13985797382347265536UL, 8827939613289801216UL);
		ActorExecutionContextHelper __helper(static_cast<UncancellableActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("uncancellable");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("uncancellable", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UncancellableActor1<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
Future<T> uncancellable( Future<T> const& what ) {
															#line 306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new UncancellableActor1<T>(what));
															#line 5095 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 316 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Holds onto an object until a future either completes or is cancelled
// Used to prevent the object from being reclaimed
//
// NOTE: the order of the arguments is important. The arguments will be destructed in
// reverse order, and we need the object to be destructed last.
															#line 5105 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via holdWhile()
															#line 322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X, class HoldWhileActor>
															#line 322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class HoldWhileActorState {
															#line 5112 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	HoldWhileActorState(X const& object,Future<T> const& what) 
															#line 322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : object(object),
															#line 322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   what(what)
															#line 5121 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("holdWhile", reinterpret_cast<unsigned long>(this));

	}
	~HoldWhileActorState() 
	{
		fdb_probe_actor_destroy("holdWhile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 324 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = what;
															#line 324 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<HoldWhileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5138 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HoldWhileActor*>(this)->actor_wait_state = 1;
															#line 324 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HoldWhileActor, 0, T >*>(static_cast<HoldWhileActor*>(this)));
															#line 5143 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HoldWhileActorState();
		static_cast<HoldWhileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& val,int loopDepth) 
	{
															#line 325 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<HoldWhileActor*>(this)->SAV<T>::futures) { (void)(val); this->~HoldWhileActorState(); static_cast<HoldWhileActor*>(this)->destroy(); return 0; }
															#line 5166 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<HoldWhileActor*>(this)->SAV< T >::value()) T(val);
		this->~HoldWhileActorState();
		static_cast<HoldWhileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(T && val,int loopDepth) 
	{
															#line 325 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<HoldWhileActor*>(this)->SAV<T>::futures) { (void)(val); this->~HoldWhileActorState(); static_cast<HoldWhileActor*>(this)->destroy(); return 0; }
															#line 5178 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<HoldWhileActor*>(this)->SAV< T >::value()) T(val);
		this->~HoldWhileActorState();
		static_cast<HoldWhileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HoldWhileActor*>(this)->actor_wait_state > 0) static_cast<HoldWhileActor*>(this)->actor_wait_state = 0;
		static_cast<HoldWhileActor*>(this)->ActorCallback< HoldWhileActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< HoldWhileActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("holdWhile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HoldWhileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("holdWhile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HoldWhileActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("holdWhile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HoldWhileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("holdWhile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HoldWhileActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("holdWhile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HoldWhileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("holdWhile", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	X object;
															#line 322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 5265 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via holdWhile()
															#line 322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X>
															#line 322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class HoldWhileActor final : public Actor<T>, public ActorCallback< HoldWhileActor<T, X>, 0, T >, public FastAllocated<HoldWhileActor<T, X>>, public HoldWhileActorState<T, X, HoldWhileActor<T, X>> {
															#line 5272 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<HoldWhileActor<T, X>>::operator new;
	using FastAllocated<HoldWhileActor<T, X>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2505762193534296576UL, 9641456004341541632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HoldWhileActor<T, X>, 0, T >;
															#line 322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	HoldWhileActor(X const& object,Future<T> const& what) 
															#line 5289 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   HoldWhileActorState<T, X, HoldWhileActor<T, X>>(object, what),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("holdWhile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4521267774877520128UL, 244137019803584000UL);
		ActorExecutionContextHelper __helper(static_cast<HoldWhileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("holdWhile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("holdWhile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HoldWhileActor<T, X>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X>
															#line 322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> holdWhile( X const& object, Future<T> const& what ) {
															#line 322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new HoldWhileActor<T, X>(object, what));
															#line 5324 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 327 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 5329 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via holdWhileVoid()
															#line 328 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X, class HoldWhileVoidActor>
															#line 328 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class HoldWhileVoidActorState {
															#line 5336 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 328 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	HoldWhileVoidActorState(X const& object,Future<T> const& what) 
															#line 328 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 328 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : object(object),
															#line 328 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   what(what)
															#line 5345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("holdWhileVoid", reinterpret_cast<unsigned long>(this));

	}
	~HoldWhileVoidActorState() 
	{
		fdb_probe_actor_destroy("holdWhileVoid", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 330 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = what;
															#line 330 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<HoldWhileVoidActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HoldWhileVoidActor*>(this)->actor_wait_state = 1;
															#line 330 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HoldWhileVoidActor, 0, T >*>(static_cast<HoldWhileVoidActor*>(this)));
															#line 5367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HoldWhileVoidActorState();
		static_cast<HoldWhileVoidActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& val,int loopDepth) 
	{
															#line 331 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<HoldWhileVoidActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HoldWhileVoidActorState(); static_cast<HoldWhileVoidActor*>(this)->destroy(); return 0; }
															#line 5390 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<HoldWhileVoidActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HoldWhileVoidActorState();
		static_cast<HoldWhileVoidActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(T && val,int loopDepth) 
	{
															#line 331 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<HoldWhileVoidActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HoldWhileVoidActorState(); static_cast<HoldWhileVoidActor*>(this)->destroy(); return 0; }
															#line 5402 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<HoldWhileVoidActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HoldWhileVoidActorState();
		static_cast<HoldWhileVoidActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HoldWhileVoidActor*>(this)->actor_wait_state > 0) static_cast<HoldWhileVoidActor*>(this)->actor_wait_state = 0;
		static_cast<HoldWhileVoidActor*>(this)->ActorCallback< HoldWhileVoidActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< HoldWhileVoidActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("holdWhileVoid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HoldWhileVoidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("holdWhileVoid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HoldWhileVoidActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("holdWhileVoid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HoldWhileVoidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("holdWhileVoid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HoldWhileVoidActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("holdWhileVoid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HoldWhileVoidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("holdWhileVoid", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 328 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	X object;
															#line 328 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 5489 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via holdWhileVoid()
															#line 328 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X>
															#line 328 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class HoldWhileVoidActor final : public Actor<Void>, public ActorCallback< HoldWhileVoidActor<T, X>, 0, T >, public FastAllocated<HoldWhileVoidActor<T, X>>, public HoldWhileVoidActorState<T, X, HoldWhileVoidActor<T, X>> {
															#line 5496 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<HoldWhileVoidActor<T, X>>::operator new;
	using FastAllocated<HoldWhileVoidActor<T, X>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16086268815956402176UL, 12656744526393957120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HoldWhileVoidActor<T, X>, 0, T >;
															#line 328 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	HoldWhileVoidActor(X const& object,Future<T> const& what) 
															#line 5513 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   HoldWhileVoidActorState<T, X, HoldWhileVoidActor<T, X>>(object, what),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("holdWhileVoid", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7538540040531603712UL, 16752633301447762176UL);
		ActorExecutionContextHelper __helper(static_cast<HoldWhileVoidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("holdWhileVoid");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("holdWhileVoid", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HoldWhileVoidActor<T, X>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 328 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class X>
															#line 328 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> holdWhileVoid( X const& object, Future<T> const& what ) {
															#line 328 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new HoldWhileVoidActor<T, X>(object, what));
															#line 5548 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 333 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Assign the future value of what to out
template <class T, class X>
[[nodiscard]] Future<Void> store(X& out, Future<T> what) {
	return map(what, [&out](T const& v) {
		out = v;
		return Void();
	});
}

#if false
// NOTE: Think twice whether create a new struct for a complex return type is better before using tuple.
// If we just use the return type once, is it worth to create a new struct?
// And enable the unit test in genericactors.actor.cpp
template <class A, class... Bs>
Future<Void> storeTuple(Future<std::tuple<A, Bs...>> what, A& a, Bs&... b) {
	return map(what, [&](std::tuple<A, Bs...> const& v) {
		std::tie(a, b...) = v;
		return Void();
	});
}
#endif

template <class T>
Future<Void> storeOrThrow(T& out, Future<Optional<T>> what, Error e = key_not_found()) {
	return map(what, [&out, e](Optional<T> const& o) {
		if (!o.present())
			throw e;
		out = o.get();
		return Void();
	});
}

// Waits for a future to be ready, and then applies an asynchronous function to it.
															#line 5586 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via mapAsync()
															#line 367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F, class MapAsyncActor>
															#line 367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class MapAsyncActorState {
															#line 5593 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	MapAsyncActorState(Future<T> const& what,F const& actorFunc) 
															#line 367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   actorFunc(actorFunc)
															#line 5602 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("mapAsync", reinterpret_cast<unsigned long>(this));

	}
	~MapAsyncActorState() 
	{
		fdb_probe_actor_destroy("mapAsync", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 369 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = what;
															#line 369 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<MapAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5619 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MapAsyncActor*>(this)->actor_wait_state = 1;
															#line 369 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MapAsyncActor, 0, T >*>(static_cast<MapAsyncActor*>(this)));
															#line 5624 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MapAsyncActorState();
		static_cast<MapAsyncActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& val,int loopDepth) 
	{
															#line 370 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<decltype(std::declval<F>()(std::declval<T>()).getValue())> __when_expr_1 = actorFunc(val);
															#line 370 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<MapAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5649 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MapAsyncActor*>(this)->actor_wait_state = 2;
															#line 370 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MapAsyncActor, 1, decltype(std::declval<F>()(std::declval<T>()).getValue()) >*>(static_cast<MapAsyncActor*>(this)));
															#line 5654 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T && val,int loopDepth) 
	{
															#line 370 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<decltype(std::declval<F>()(std::declval<T>()).getValue())> __when_expr_1 = actorFunc(val);
															#line 370 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<MapAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5665 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MapAsyncActor*>(this)->actor_wait_state = 2;
															#line 370 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MapAsyncActor, 1, decltype(std::declval<F>()(std::declval<T>()).getValue()) >*>(static_cast<MapAsyncActor*>(this)));
															#line 5670 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MapAsyncActor*>(this)->actor_wait_state > 0) static_cast<MapAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<MapAsyncActor*>(this)->ActorCallback< MapAsyncActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< MapAsyncActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MapAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MapAsyncActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MapAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MapAsyncActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MapAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(decltype(std::declval<F>()(std::declval<T>()).getValue()) const& ret,int loopDepth) 
	{
															#line 371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<MapAsyncActor*>(this)->SAV<decltype(std::declval<F>()(std::declval<T>()).getValue())>::futures) { (void)(ret); this->~MapAsyncActorState(); static_cast<MapAsyncActor*>(this)->destroy(); return 0; }
															#line 5754 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<MapAsyncActor*>(this)->SAV< decltype(std::declval<F>()(std::declval<T>()).getValue()) >::value()) decltype(std::declval<F>()(std::declval<T>()).getValue())(ret);
		this->~MapAsyncActorState();
		static_cast<MapAsyncActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(decltype(std::declval<F>()(std::declval<T>()).getValue()) && ret,int loopDepth) 
	{
															#line 371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<MapAsyncActor*>(this)->SAV<decltype(std::declval<F>()(std::declval<T>()).getValue())>::futures) { (void)(ret); this->~MapAsyncActorState(); static_cast<MapAsyncActor*>(this)->destroy(); return 0; }
															#line 5766 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<MapAsyncActor*>(this)->SAV< decltype(std::declval<F>()(std::declval<T>()).getValue()) >::value()) decltype(std::declval<F>()(std::declval<T>()).getValue())(ret);
		this->~MapAsyncActorState();
		static_cast<MapAsyncActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(decltype(std::declval<F>()(std::declval<T>()).getValue()) const& ret,int loopDepth) 
	{
		loopDepth = a_body1cont2(ret, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(decltype(std::declval<F>()(std::declval<T>()).getValue()) && ret,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(ret), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MapAsyncActor*>(this)->actor_wait_state > 0) static_cast<MapAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<MapAsyncActor*>(this)->ActorCallback< MapAsyncActor, 1, decltype(std::declval<F>()(std::declval<T>()).getValue()) >::remove();

	}
	void a_callback_fire(ActorCallback< MapAsyncActor, 1, decltype(std::declval<F>()(std::declval<T>()).getValue()) >*,decltype(std::declval<F>()(std::declval<T>()).getValue()) const& value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MapAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MapAsyncActor, 1, decltype(std::declval<F>()(std::declval<T>()).getValue()) >*,decltype(std::declval<F>()(std::declval<T>()).getValue()) && value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MapAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MapAsyncActor, 1, decltype(std::declval<F>()(std::declval<T>()).getValue()) >*,Error err) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MapAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	F actorFunc;
															#line 5853 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via mapAsync()
															#line 367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class MapAsyncActor final : public Actor<decltype(std::declval<F>()(std::declval<T>()).getValue())>, public ActorCallback< MapAsyncActor<T, F>, 0, T >, public ActorCallback< MapAsyncActor<T, F>, 1, decltype(std::declval<F>()(std::declval<T>()).getValue()) >, public FastAllocated<MapAsyncActor<T, F>>, public MapAsyncActorState<T, F, MapAsyncActor<T, F>> {
															#line 5860 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<MapAsyncActor<T, F>>::operator new;
	using FastAllocated<MapAsyncActor<T, F>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3802309433402475520UL, 7448658935582319104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<decltype(std::declval<F>()(std::declval<T>()).getValue())>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MapAsyncActor<T, F>, 0, T >;
friend struct ActorCallback< MapAsyncActor<T, F>, 1, decltype(std::declval<F>()(std::declval<T>()).getValue()) >;
															#line 367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	MapAsyncActor(Future<T> const& what,F const& actorFunc) 
															#line 5878 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<decltype(std::declval<F>()(std::declval<T>()).getValue())>(),
		   MapAsyncActorState<T, F, MapAsyncActor<T, F>>(what, actorFunc),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1996485458833146880UL, 14068918914659627520UL);
		ActorExecutionContextHelper __helper(static_cast<MapAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("mapAsync");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MapAsyncActor<T, F>, 0, T >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MapAsyncActor<T, F>, 1, decltype(std::declval<F>()(std::declval<T>()).getValue()) >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<decltype(std::declval<F>()(std::declval<T>()).getValue())> mapAsync( Future<T> const& what, F const& actorFunc ) {
															#line 367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<decltype(std::declval<F>()(std::declval<T>()).getValue())>(new MapAsyncActor<T, F>(what, actorFunc));
															#line 5914 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 373 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// maps a vector of futures with an asynchronous function
template <class T, class F>
auto mapAsync(std::vector<Future<T>> const& what, F const& actorFunc) {
	std::vector<std::invoke_result_t<F, T>> ret;
	ret.reserve(what.size());
	for (const auto& f : what)
		ret.push_back(mapAsync(f, actorFunc));
	return ret;
}

// maps a stream with an asynchronous function
															#line 5930 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via mapAsync()
															#line 385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F, class U, class MapAsyncActor1>
															#line 385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class MapAsyncActor1State {
															#line 5937 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	MapAsyncActor1State(FutureStream<T> const& input,F const& actorFunc,PromiseStream<U> const& output) 
															#line 385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : input(input),
															#line 385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   actorFunc(actorFunc),
															#line 385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   output(output),
															#line 387 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   futures()
															#line 5950 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("mapAsync", reinterpret_cast<unsigned long>(this));

	}
	~MapAsyncActor1State() 
	{
		fdb_probe_actor_destroy("mapAsync", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 389 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 5965 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MapAsyncActor1State();
		static_cast<MapAsyncActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 410 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		;
															#line 5988 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 392 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			FutureStream<T> __when_expr_0 = input;
															#line 391 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<MapAsyncActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6007 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 395 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<U> __when_expr_1 = futures.size() == 0 ? Never() : futures.front();
															#line 6011 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<MapAsyncActor1*>(this)->actor_wait_state = 1;
															#line 392 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< MapAsyncActor1, 0, T >*>(static_cast<MapAsyncActor1*>(this)));
															#line 395 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MapAsyncActor1, 1, U >*>(static_cast<MapAsyncActor1*>(this)));
															#line 6018 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 401 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_end_of_stream)
															#line 6053 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 404 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				output.sendError(e);
															#line 405 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 6063 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T const& nextInput,int loopDepth) 
	{
															#line 393 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.push_back(actorFunc(nextInput));
															#line 6084 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T && nextInput,int loopDepth) 
	{
															#line 393 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.push_back(actorFunc(nextInput));
															#line 6093 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(U const& nextOutput,int loopDepth) 
	{
															#line 396 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(nextOutput);
															#line 397 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.pop_front();
															#line 6104 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(U && nextOutput,int loopDepth) 
	{
															#line 396 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(nextOutput);
															#line 397 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.pop_front();
															#line 6115 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MapAsyncActor1*>(this)->actor_wait_state > 0) static_cast<MapAsyncActor1*>(this)->actor_wait_state = 0;
		static_cast<MapAsyncActor1*>(this)->ActorSingleCallback< MapAsyncActor1, 0, T >::remove();
		static_cast<MapAsyncActor1*>(this)->ActorCallback< MapAsyncActor1, 1, U >::remove();

	}
	void a_callback_fire(ActorSingleCallback< MapAsyncActor1, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MapAsyncActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< MapAsyncActor1, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MapAsyncActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< MapAsyncActor1, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MapAsyncActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MapAsyncActor1, 1, U >*,U const& value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MapAsyncActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MapAsyncActor1, 1, U >*,U && value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MapAsyncActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MapAsyncActor1, 1, U >*,Error err) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MapAsyncActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 416 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.sendError(end_of_stream());
															#line 418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<MapAsyncActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MapAsyncActor1State(); static_cast<MapAsyncActor1*>(this)->destroy(); return 0; }
															#line 6260 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<MapAsyncActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~MapAsyncActor1State();
		static_cast<MapAsyncActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 410 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!(futures.size()))
															#line 6279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 411 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<U> __when_expr_2 = futures.front();
															#line 411 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<MapAsyncActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6287 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<MapAsyncActor1*>(this)->actor_wait_state = 2;
															#line 411 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MapAsyncActor1, 2, U >*>(static_cast<MapAsyncActor1*>(this)));
															#line 6292 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(U const& nextOutput,int loopDepth) 
	{
															#line 412 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(nextOutput);
															#line 413 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.pop_front();
															#line 6316 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(U && nextOutput,int loopDepth) 
	{
															#line 412 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(nextOutput);
															#line 413 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.pop_front();
															#line 6327 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(U const& nextOutput,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(nextOutput, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(U && nextOutput,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(nextOutput), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MapAsyncActor1*>(this)->actor_wait_state > 0) static_cast<MapAsyncActor1*>(this)->actor_wait_state = 0;
		static_cast<MapAsyncActor1*>(this)->ActorCallback< MapAsyncActor1, 2, U >::remove();

	}
	void a_callback_fire(ActorCallback< MapAsyncActor1, 2, U >*,U const& value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MapAsyncActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MapAsyncActor1, 2, U >*,U && value) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MapAsyncActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MapAsyncActor1, 2, U >*,Error err) 
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MapAsyncActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FutureStream<T> input;
															#line 385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	F actorFunc;
															#line 385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<U> output;
															#line 387 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Deque<Future<U>> futures;
															#line 6415 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via mapAsync()
															#line 385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F, class U>
															#line 385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class MapAsyncActor1 final : public Actor<Void>, public ActorSingleCallback< MapAsyncActor1<T, F, U>, 0, T >, public ActorCallback< MapAsyncActor1<T, F, U>, 1, U >, public ActorCallback< MapAsyncActor1<T, F, U>, 2, U >, public FastAllocated<MapAsyncActor1<T, F, U>>, public MapAsyncActor1State<T, F, U, MapAsyncActor1<T, F, U>> {
															#line 6422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<MapAsyncActor1<T, F, U>>::operator new;
	using FastAllocated<MapAsyncActor1<T, F, U>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3802309433402475520UL, 7448658935582319104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< MapAsyncActor1<T, F, U>, 0, T >;
friend struct ActorCallback< MapAsyncActor1<T, F, U>, 1, U >;
friend struct ActorCallback< MapAsyncActor1<T, F, U>, 2, U >;
															#line 385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	MapAsyncActor1(FutureStream<T> const& input,F const& actorFunc,PromiseStream<U> const& output) 
															#line 6441 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   MapAsyncActor1State<T, F, U, MapAsyncActor1<T, F, U>>(input, actorFunc, output),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("mapAsync", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11521843967510462208UL, 16241305626006140672UL);
		ActorExecutionContextHelper __helper(static_cast<MapAsyncActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("mapAsync");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("mapAsync", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< MapAsyncActor1<T, F, U>, 0, T >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MapAsyncActor1<T, F, U>, 2, U >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F, class U>
															#line 385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> mapAsync( FutureStream<T> const& input, F const& actorFunc, PromiseStream<U> const& output ) {
															#line 385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new MapAsyncActor1<T, F, U>(input, actorFunc, output));
															#line 6477 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 420 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Waits for a future to be ready, and then applies a function to it.
															#line 6483 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via map()
															#line 422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F, class MapActor>
															#line 422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class MapActorState {
															#line 6490 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	MapActorState(Future<T> const& what,F const& func) 
															#line 422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   func(func)
															#line 6499 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("map", reinterpret_cast<unsigned long>(this));

	}
	~MapActorState() 
	{
		fdb_probe_actor_destroy("map", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 424 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = what;
															#line 424 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<MapActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6516 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MapActor*>(this)->actor_wait_state = 1;
															#line 424 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MapActor, 0, T >*>(static_cast<MapActor*>(this)));
															#line 6521 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MapActorState();
		static_cast<MapActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& val,int loopDepth) 
	{
															#line 425 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<MapActor*>(this)->SAV<std::invoke_result_t<F, T>>::futures) { (void)(func(val)); this->~MapActorState(); static_cast<MapActor*>(this)->destroy(); return 0; }
															#line 6544 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<MapActor*>(this)->SAV< std::invoke_result_t<F, T> >::value()) std::invoke_result_t<F, T>(func(val));
		this->~MapActorState();
		static_cast<MapActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(T && val,int loopDepth) 
	{
															#line 425 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<MapActor*>(this)->SAV<std::invoke_result_t<F, T>>::futures) { (void)(func(val)); this->~MapActorState(); static_cast<MapActor*>(this)->destroy(); return 0; }
															#line 6556 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<MapActor*>(this)->SAV< std::invoke_result_t<F, T> >::value()) std::invoke_result_t<F, T>(func(val));
		this->~MapActorState();
		static_cast<MapActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MapActor*>(this)->actor_wait_state > 0) static_cast<MapActor*>(this)->actor_wait_state = 0;
		static_cast<MapActor*>(this)->ActorCallback< MapActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< MapActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("map", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("map", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MapActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("map", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("map", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MapActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("map", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("map", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	F func;
															#line 6643 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via map()
															#line 422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class MapActor final : public Actor<std::invoke_result_t<F, T>>, public ActorCallback< MapActor<T, F>, 0, T >, public FastAllocated<MapActor<T, F>>, public MapActorState<T, F, MapActor<T, F>> {
															#line 6650 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<MapActor<T, F>>::operator new;
	using FastAllocated<MapActor<T, F>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14552257127371352320UL, 14991246894646914304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::invoke_result_t<F, T>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MapActor<T, F>, 0, T >;
															#line 422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	MapActor(Future<T> const& what,F const& func) 
															#line 6667 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<std::invoke_result_t<F, T>>(),
		   MapActorState<T, F, MapActor<T, F>>(what, func),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("map", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12390511040070023168UL, 10073700351581680896UL);
		ActorExecutionContextHelper __helper(static_cast<MapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("map");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("map", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MapActor<T, F>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<std::invoke_result_t<F, T>> map( Future<T> const& what, F const& func ) {
															#line 422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<std::invoke_result_t<F, T>>(new MapActor<T, F>(what, func));
															#line 6702 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 427 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// maps a vector of futures
template <class T, class F>
auto map(std::vector<Future<T>> const& what, F const& func) {
	std::vector<Future<std::invoke_result_t<F, T>>> ret;
	ret.reserve(what.size());
	for (const auto& f : what)
		ret.push_back(map(f, func));
	return ret;
}

// maps a stream
															#line 6718 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via map()
															#line 439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F, class MapActor1>
															#line 439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class MapActor1State {
															#line 6725 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	MapActor1State(FutureStream<T> const& input,F const& func,PromiseStream<std::invoke_result_t<F, T>> const& output) 
															#line 439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : input(input),
															#line 439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   func(func),
															#line 439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   output(output)
															#line 6736 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("map", reinterpret_cast<unsigned long>(this));

	}
	~MapActor1State() 
	{
		fdb_probe_actor_destroy("map", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 441 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 6751 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MapActor1State();
		static_cast<MapActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 453 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.sendError(end_of_stream());
															#line 455 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<MapActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MapActor1State(); static_cast<MapActor1*>(this)->destroy(); return 0; }
															#line 6776 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<MapActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~MapActor1State();
		static_cast<MapActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 443 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			FutureStream<T> __when_expr_0 = input;
															#line 443 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<MapActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6798 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<MapActor1*>(this)->actor_wait_state = 1;
															#line 443 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< MapActor1, 0, T >*>(static_cast<MapActor1*>(this)));
															#line 6803 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 446 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_end_of_stream)
															#line 6838 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 6846 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(T const& nextInput,int loopDepth) 
	{
															#line 444 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(func(nextInput));
															#line 6861 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(T && nextInput,int loopDepth) 
	{
															#line 444 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(func(nextInput));
															#line 6870 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T const& nextInput,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(nextInput, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T && nextInput,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(nextInput), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MapActor1*>(this)->actor_wait_state > 0) static_cast<MapActor1*>(this)->actor_wait_state = 0;
		static_cast<MapActor1*>(this)->ActorSingleCallback< MapActor1, 0, T >::remove();

	}
	void a_callback_fire(ActorSingleCallback< MapActor1, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("map", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MapActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("map", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< MapActor1, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("map", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MapActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("map", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< MapActor1, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("map", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MapActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("map", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FutureStream<T> input;
															#line 439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	F func;
															#line 439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<std::invoke_result_t<F, T>> output;
															#line 6969 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via map()
															#line 439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class MapActor1 final : public Actor<Void>, public ActorSingleCallback< MapActor1<T, F>, 0, T >, public FastAllocated<MapActor1<T, F>>, public MapActor1State<T, F, MapActor1<T, F>> {
															#line 6976 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<MapActor1<T, F>>::operator new;
	using FastAllocated<MapActor1<T, F>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14552257127371352320UL, 14991246894646914304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< MapActor1<T, F>, 0, T >;
															#line 439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	MapActor1(FutureStream<T> const& input,F const& func,PromiseStream<std::invoke_result_t<F, T>> const& output) 
															#line 6993 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   MapActor1State<T, F, MapActor1<T, F>>(input, func, output),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("map", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13260455609048177152UL, 7454665086589192704UL);
		ActorExecutionContextHelper __helper(static_cast<MapActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("map");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("map", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< MapActor1<T, F>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> map( FutureStream<T> const& input, F const& func, PromiseStream<std::invoke_result_t<F, T>> const& output ) {
															#line 439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new MapActor1<T, F>(input, func, output));
															#line 7028 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 457 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// X + Y will wait for X, then wait for and return the result of Y
															#line 7034 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via operatorPlus()
															#line 459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class A, class B, class OperatorPlusActor>
															#line 459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class OperatorPlusActorState {
															#line 7041 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	OperatorPlusActorState(Future<A> const& a,Future<B> const& b) 
															#line 459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : a(a),
															#line 459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   b(b)
															#line 7050 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("operatorPlus", reinterpret_cast<unsigned long>(this));

	}
	~OperatorPlusActorState() 
	{
		fdb_probe_actor_destroy("operatorPlus", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 461 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<A> __when_expr_0 = a;
															#line 461 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<OperatorPlusActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7067 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<OperatorPlusActor*>(this)->actor_wait_state = 1;
															#line 461 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OperatorPlusActor, 0, A >*>(static_cast<OperatorPlusActor*>(this)));
															#line 7072 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OperatorPlusActorState();
		static_cast<OperatorPlusActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(A const& resultA,int loopDepth) 
	{
															#line 462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		(void)resultA;
															#line 463 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<B> __when_expr_1 = b;
															#line 463 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<OperatorPlusActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7099 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<OperatorPlusActor*>(this)->actor_wait_state = 2;
															#line 463 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OperatorPlusActor, 1, B >*>(static_cast<OperatorPlusActor*>(this)));
															#line 7104 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(A && resultA,int loopDepth) 
	{
															#line 462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		(void)resultA;
															#line 463 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<B> __when_expr_1 = b;
															#line 463 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<OperatorPlusActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7117 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<OperatorPlusActor*>(this)->actor_wait_state = 2;
															#line 463 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OperatorPlusActor, 1, B >*>(static_cast<OperatorPlusActor*>(this)));
															#line 7122 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(A const& resultA,int loopDepth) 
	{
		loopDepth = a_body1cont1(resultA, loopDepth);

		return loopDepth;
	}
	int a_body1when1(A && resultA,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(resultA), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OperatorPlusActor*>(this)->actor_wait_state > 0) static_cast<OperatorPlusActor*>(this)->actor_wait_state = 0;
		static_cast<OperatorPlusActor*>(this)->ActorCallback< OperatorPlusActor, 0, A >::remove();

	}
	void a_callback_fire(ActorCallback< OperatorPlusActor, 0, A >*,A const& value) 
	{
		fdb_probe_actor_enter("operatorPlus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OperatorPlusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operatorPlus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OperatorPlusActor, 0, A >*,A && value) 
	{
		fdb_probe_actor_enter("operatorPlus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OperatorPlusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operatorPlus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OperatorPlusActor, 0, A >*,Error err) 
	{
		fdb_probe_actor_enter("operatorPlus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OperatorPlusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operatorPlus", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(B const& resultB,int loopDepth) 
	{
															#line 464 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<OperatorPlusActor*>(this)->SAV<B>::futures) { (void)(resultB); this->~OperatorPlusActorState(); static_cast<OperatorPlusActor*>(this)->destroy(); return 0; }
															#line 7206 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<OperatorPlusActor*>(this)->SAV< B >::value()) B(resultB);
		this->~OperatorPlusActorState();
		static_cast<OperatorPlusActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(B && resultB,int loopDepth) 
	{
															#line 464 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<OperatorPlusActor*>(this)->SAV<B>::futures) { (void)(resultB); this->~OperatorPlusActorState(); static_cast<OperatorPlusActor*>(this)->destroy(); return 0; }
															#line 7218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<OperatorPlusActor*>(this)->SAV< B >::value()) B(resultB);
		this->~OperatorPlusActorState();
		static_cast<OperatorPlusActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(B const& resultB,int loopDepth) 
	{
		loopDepth = a_body1cont2(resultB, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(B && resultB,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(resultB), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<OperatorPlusActor*>(this)->actor_wait_state > 0) static_cast<OperatorPlusActor*>(this)->actor_wait_state = 0;
		static_cast<OperatorPlusActor*>(this)->ActorCallback< OperatorPlusActor, 1, B >::remove();

	}
	void a_callback_fire(ActorCallback< OperatorPlusActor, 1, B >*,B const& value) 
	{
		fdb_probe_actor_enter("operatorPlus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OperatorPlusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operatorPlus", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< OperatorPlusActor, 1, B >*,B && value) 
	{
		fdb_probe_actor_enter("operatorPlus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OperatorPlusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operatorPlus", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< OperatorPlusActor, 1, B >*,Error err) 
	{
		fdb_probe_actor_enter("operatorPlus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OperatorPlusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("operatorPlus", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<A> a;
															#line 459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<B> b;
															#line 7305 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via operatorPlus()
															#line 459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class A, class B>
															#line 459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class OperatorPlusActor final : public Actor<B>, public ActorCallback< OperatorPlusActor<A, B>, 0, A >, public ActorCallback< OperatorPlusActor<A, B>, 1, B >, public FastAllocated<OperatorPlusActor<A, B>>, public OperatorPlusActorState<A, B, OperatorPlusActor<A, B>> {
															#line 7312 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<OperatorPlusActor<A, B>>::operator new;
	using FastAllocated<OperatorPlusActor<A, B>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17737657042915482880UL, 1965607946398705152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<B>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OperatorPlusActor<A, B>, 0, A >;
friend struct ActorCallback< OperatorPlusActor<A, B>, 1, B >;
															#line 459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	OperatorPlusActor(Future<A> const& a,Future<B> const& b) 
															#line 7330 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<B>(),
		   OperatorPlusActorState<A, B, OperatorPlusActor<A, B>>(a, b),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("operatorPlus", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7932176911111902464UL, 12071714722581229056UL);
		ActorExecutionContextHelper __helper(static_cast<OperatorPlusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("operatorPlus");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("operatorPlus", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OperatorPlusActor<A, B>, 0, A >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< OperatorPlusActor<A, B>, 1, B >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class A, class B>
															#line 459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<B> operatorPlus( Future<A> const& a, Future<B> const& b ) {
															#line 459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<B>(new OperatorPlusActor<A, B>(a, b));
															#line 7366 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 466 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

template <class A, class B>
Future<B> operator+(Future<A> a, Future<B> b) {
	return operatorPlus(a, b);
}

// Returns if the future returns true, otherwise waits forever.
															#line 7377 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
[[nodiscard]] Future<Void> returnIfTrue( Future<bool> const& f );

#line 474 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Returns if the future, when waited on and then evaluated with the predicate, returns true, otherwise waits forever
template <class T, class F>
Future<Void> returnIfTrue(Future<T> what, F pred) {
	return returnIfTrue(map(what, pred));
}

// filters a stream
															#line 7389 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via filter()
															#line 482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F, class FilterActor>
															#line 482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class FilterActorState {
															#line 7396 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FilterActorState(FutureStream<T> const& input,F const& pred,PromiseStream<T> const& output) 
															#line 482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : input(input),
															#line 482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   pred(pred),
															#line 482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   output(output)
															#line 7407 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("filter", reinterpret_cast<unsigned long>(this));

	}
	~FilterActorState() 
	{
		fdb_probe_actor_destroy("filter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 484 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 7422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FilterActorState();
		static_cast<FilterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 497 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.sendError(end_of_stream());
															#line 499 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<FilterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FilterActorState(); static_cast<FilterActor*>(this)->destroy(); return 0; }
															#line 7447 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<FilterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FilterActorState();
		static_cast<FilterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 486 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			FutureStream<T> __when_expr_0 = input;
															#line 486 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<FilterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<FilterActor*>(this)->actor_wait_state = 1;
															#line 486 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< FilterActor, 0, T >*>(static_cast<FilterActor*>(this)));
															#line 7474 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 490 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_end_of_stream)
															#line 7509 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 493 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 7517 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(T const& nextInput,int loopDepth) 
	{
															#line 487 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (pred(nextInput))
															#line 7532 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 488 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.send(nextInput);
															#line 7536 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(T && nextInput,int loopDepth) 
	{
															#line 487 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (pred(nextInput))
															#line 7546 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 488 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.send(nextInput);
															#line 7550 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T const& nextInput,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(nextInput, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T && nextInput,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(nextInput), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FilterActor*>(this)->actor_wait_state > 0) static_cast<FilterActor*>(this)->actor_wait_state = 0;
		static_cast<FilterActor*>(this)->ActorSingleCallback< FilterActor, 0, T >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FilterActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("filter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("filter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< FilterActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("filter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("filter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< FilterActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("filter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("filter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FutureStream<T> input;
															#line 482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	F pred;
															#line 482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<T> output;
															#line 7650 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via filter()
															#line 482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class FilterActor final : public Actor<Void>, public ActorSingleCallback< FilterActor<T, F>, 0, T >, public FastAllocated<FilterActor<T, F>>, public FilterActorState<T, F, FilterActor<T, F>> {
															#line 7657 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<FilterActor<T, F>>::operator new;
	using FastAllocated<FilterActor<T, F>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11221088010963377664UL, 14917507553836308480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< FilterActor<T, F>, 0, T >;
															#line 482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FilterActor(FutureStream<T> const& input,F const& pred,PromiseStream<T> const& output) 
															#line 7674 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   FilterActorState<T, F, FilterActor<T, F>>(input, pred, output),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("filter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10068160600145463552UL, 10966321519488972800UL);
		ActorExecutionContextHelper __helper(static_cast<FilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("filter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("filter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< FilterActor<T, F>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> filter( FutureStream<T> const& input, F const& pred, PromiseStream<T> const& output ) {
															#line 482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new FilterActor<T, F>(input, pred, output));
															#line 7709 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 501 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// filters a stream asynchronously
															#line 7715 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via asyncFilter()
															#line 503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F, class AsyncFilterActor>
															#line 503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class AsyncFilterActorState {
															#line 7722 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	AsyncFilterActorState(FutureStream<T> const& input,F const& actorPred,PromiseStream<T> const& output) 
															#line 503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : input(input),
															#line 503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   actorPred(actorPred),
															#line 503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   output(output),
															#line 505 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   futures(),
															#line 506 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   p()
															#line 7737 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("asyncFilter", reinterpret_cast<unsigned long>(this));

	}
	~AsyncFilterActorState() 
	{
		fdb_probe_actor_destroy("asyncFilter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 508 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 7752 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AsyncFilterActorState();
		static_cast<AsyncFilterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 529 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		;
															#line 7775 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 511 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			FutureStream<T> __when_expr_0 = input;
															#line 510 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<AsyncFilterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7794 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 514 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<bool> __when_expr_1 = futures.size() == 0 ? Never() : futures.front().second;
															#line 7798 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<AsyncFilterActor*>(this)->actor_wait_state = 1;
															#line 511 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< AsyncFilterActor, 0, T >*>(static_cast<AsyncFilterActor*>(this)));
															#line 514 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AsyncFilterActor, 1, bool >*>(static_cast<AsyncFilterActor*>(this)));
															#line 7805 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 521 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_end_of_stream)
															#line 7840 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 524 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 7848 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T const& nextInput,int loopDepth) 
	{
															#line 512 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.emplace_back(nextInput, actorPred(nextInput));
															#line 7869 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(T && nextInput,int loopDepth) 
	{
															#line 512 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.emplace_back(nextInput, actorPred(nextInput));
															#line 7878 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(bool const& pass,int loopDepth) 
	{
															#line 515 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (pass)
															#line 7887 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 516 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.send(futures.front().first);
															#line 7891 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 517 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.pop_front();
															#line 7895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(bool && pass,int loopDepth) 
	{
															#line 515 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (pass)
															#line 7904 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 516 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.send(futures.front().first);
															#line 7908 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 517 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.pop_front();
															#line 7912 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AsyncFilterActor*>(this)->actor_wait_state > 0) static_cast<AsyncFilterActor*>(this)->actor_wait_state = 0;
		static_cast<AsyncFilterActor*>(this)->ActorSingleCallback< AsyncFilterActor, 0, T >::remove();
		static_cast<AsyncFilterActor*>(this)->ActorCallback< AsyncFilterActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorSingleCallback< AsyncFilterActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AsyncFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< AsyncFilterActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AsyncFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< AsyncFilterActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AsyncFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AsyncFilterActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AsyncFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AsyncFilterActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AsyncFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AsyncFilterActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AsyncFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 537 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.sendError(end_of_stream());
															#line 539 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<AsyncFilterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AsyncFilterActorState(); static_cast<AsyncFilterActor*>(this)->destroy(); return 0; }
															#line 8057 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<AsyncFilterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AsyncFilterActorState();
		static_cast<AsyncFilterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 529 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!(futures.size()))
															#line 8076 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 530 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		p = futures.front();
															#line 531 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<bool> __when_expr_2 = p.second;
															#line 531 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<AsyncFilterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8086 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<AsyncFilterActor*>(this)->actor_wait_state = 2;
															#line 531 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AsyncFilterActor, 2, bool >*>(static_cast<AsyncFilterActor*>(this)));
															#line 8091 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(bool const& pass,int loopDepth) 
	{
															#line 532 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (pass)
															#line 8113 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 533 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.send(p.first);
															#line 8117 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 534 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.pop_front();
															#line 8121 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(bool && pass,int loopDepth) 
	{
															#line 532 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (pass)
															#line 8130 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 533 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.send(p.first);
															#line 8134 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 534 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		futures.pop_front();
															#line 8138 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(bool const& pass,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(pass, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(bool && pass,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(pass), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AsyncFilterActor*>(this)->actor_wait_state > 0) static_cast<AsyncFilterActor*>(this)->actor_wait_state = 0;
		static_cast<AsyncFilterActor*>(this)->ActorCallback< AsyncFilterActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< AsyncFilterActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AsyncFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AsyncFilterActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AsyncFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AsyncFilterActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AsyncFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FutureStream<T> input;
															#line 503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	F actorPred;
															#line 503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<T> output;
															#line 505 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Deque<std::pair<T, Future<bool>>> futures;
															#line 506 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	std::pair<T, Future<bool>> p;
															#line 8228 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via asyncFilter()
															#line 503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class AsyncFilterActor final : public Actor<Void>, public ActorSingleCallback< AsyncFilterActor<T, F>, 0, T >, public ActorCallback< AsyncFilterActor<T, F>, 1, bool >, public ActorCallback< AsyncFilterActor<T, F>, 2, bool >, public FastAllocated<AsyncFilterActor<T, F>>, public AsyncFilterActorState<T, F, AsyncFilterActor<T, F>> {
															#line 8235 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<AsyncFilterActor<T, F>>::operator new;
	using FastAllocated<AsyncFilterActor<T, F>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17933104555036353024UL, 7006876445509557760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< AsyncFilterActor<T, F>, 0, T >;
friend struct ActorCallback< AsyncFilterActor<T, F>, 1, bool >;
friend struct ActorCallback< AsyncFilterActor<T, F>, 2, bool >;
															#line 503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	AsyncFilterActor(FutureStream<T> const& input,F const& actorPred,PromiseStream<T> const& output) 
															#line 8254 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   AsyncFilterActorState<T, F, AsyncFilterActor<T, F>>(input, actorPred, output),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("asyncFilter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13878357602307046912UL, 4375813513290487552UL);
		ActorExecutionContextHelper __helper(static_cast<AsyncFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("asyncFilter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("asyncFilter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< AsyncFilterActor<T, F>, 0, T >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AsyncFilterActor<T, F>, 2, bool >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class F>
															#line 503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> asyncFilter( FutureStream<T> const& input, F const& actorPred, PromiseStream<T> const& output ) {
															#line 503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new AsyncFilterActor<T, F>(input, actorPred, output));
															#line 8290 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 541 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

template <class T>
struct WorkerCache {
	// SOMEDAY: Would we do better to use "unreliable" (at most once) transport for the initialize requests and get rid
	// of this? It doesn't provide true at most once behavior because things are removed from the cache after they have
	// terminated.
	bool exists(UID id) { return id_interface.count(id) != 0; }
	void set(UID id, const Future<T>& onReady) {
		ASSERT(!exists(id));
		id_interface[id] = onReady;
	}
	Future<T> get(UID id) {
		ASSERT(exists(id));
		return id_interface[id];
	}

	Future<Void> removeOnReady(UID id, Future<Void> const& ready) { return removeOnReady(this, id, ready); }

private:
																#line 8313 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
// This generated class is to be used only via removeOnReady()
															#line 560 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class RemoveOnReadyActor>
															#line 560 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class RemoveOnReadyActorState {
															#line 8319 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 560 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	RemoveOnReadyActorState(WorkerCache* const& self,UID const& id,Future<Void> const& ready) 
															#line 560 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 560 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : self(self),
															#line 560 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   id(id),
															#line 560 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   ready(ready)
															#line 8330 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("removeOnReady", reinterpret_cast<unsigned long>(this));

	}
	~RemoveOnReadyActorState() 
	{
		fdb_probe_actor_destroy("removeOnReady", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 562 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<Void> __when_expr_0 = ready;
															#line 562 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<RemoveOnReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8348 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RemoveOnReadyActor*>(this)->actor_wait_state = 1;
															#line 562 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RemoveOnReadyActor, 0, Void >*>(static_cast<RemoveOnReadyActor*>(this)));
															#line 8353 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RemoveOnReadyActorState();
		static_cast<RemoveOnReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 566 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			self->id_interface.erase(id);
															#line 567 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 8385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 563 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		self->id_interface.erase(id);
															#line 564 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<RemoveOnReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveOnReadyActorState(); static_cast<RemoveOnReadyActor*>(this)->destroy(); return 0; }
															#line 8401 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<RemoveOnReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RemoveOnReadyActorState();
		static_cast<RemoveOnReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 563 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		self->id_interface.erase(id);
															#line 564 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<RemoveOnReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveOnReadyActorState(); static_cast<RemoveOnReadyActor*>(this)->destroy(); return 0; }
															#line 8415 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<RemoveOnReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RemoveOnReadyActorState();
		static_cast<RemoveOnReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RemoveOnReadyActor*>(this)->actor_wait_state > 0) static_cast<RemoveOnReadyActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveOnReadyActor*>(this)->ActorCallback< RemoveOnReadyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveOnReadyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("removeOnReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveOnReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeOnReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RemoveOnReadyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("removeOnReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveOnReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeOnReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RemoveOnReadyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("removeOnReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveOnReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeOnReady", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 560 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	WorkerCache* self;
															#line 560 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	UID id;
															#line 560 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> ready;
															#line 8504 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via removeOnReady()
															#line 560 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class RemoveOnReadyActor final : public Actor<Void>, public ActorCallback< RemoveOnReadyActor, 0, Void >, public FastAllocated<RemoveOnReadyActor>, public RemoveOnReadyActorState<RemoveOnReadyActor> {
															#line 8509 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<RemoveOnReadyActor>::operator new;
	using FastAllocated<RemoveOnReadyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5730845767799489536UL, 4201132437267988224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RemoveOnReadyActor, 0, Void >;
															#line 560 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	RemoveOnReadyActor(WorkerCache* const& self,UID const& id,Future<Void> const& ready) 
															#line 8526 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   RemoveOnReadyActorState<RemoveOnReadyActor>(self, id, ready),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("removeOnReady", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4271278137371060736UL, 14669009522706832128UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveOnReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("removeOnReady");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("removeOnReady", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RemoveOnReadyActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 560 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] static Future<Void> removeOnReady( WorkerCache* const& self, UID const& id, Future<Void> const& ready ) {
															#line 560 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new RemoveOnReadyActor(self, id, ready));
															#line 8558 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 570 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

	std::map<UID, Future<T>> id_interface;
};

template <class K, class V>
class AsyncMap : NonCopyable {
public:
	// Represents a complete function from keys to values (K -> V)
	// All values not explicitly inserted map to V()
	// If this isn't appropriate, use V=Optional<X>

	AsyncMap() : defaultValue(), destructing(false) {}

	virtual ~AsyncMap() {
		destructing = true;
		items.clear();
	}

	void set(K const& k, V const& v) {
		auto& i = items[k];
		if (i.value != v)
			setUnconditional(k, v, i);
	}
	void setUnconditional(K const& k, V const& v) { setUnconditional(k, v, items[k]); }

	void sendError(K const& begin, K const& end, Error const& e) {
		if (begin >= end)
			return;
		std::vector<Promise<Void>> ps = swapRangePromises(items.lower_bound(begin), items.lower_bound(end));
		sendError(ps, e);
	}

	void triggerAll() {
		std::vector<Promise<Void>> ps = swapRangePromises(items.begin(), items.end());
		send(ps);
	}

	void triggerRange(K const& begin, K const& end) {
		if (begin >= end)
			return;
		std::vector<Promise<Void>> ps = swapRangePromises(items.lower_bound(begin), items.lower_bound(end));
		send(ps);
	}

	void trigger(K const& key) {
		if (items.count(key) != 0) {
			auto& i = items[key];
			Promise<Void> trigger;
			i.change.swap(trigger);
			Promise<Void> noDestroy = trigger; // See explanation of noDestroy in setUnconditional()

			if (i.value == defaultValue)
				items.erase(key);

			trigger.send(Void());
		}
	}
	void clear(K const& k) { set(k, V()); }
	V const& get(K const& k) const {
		auto it = items.find(k);
		if (it != items.end())
			return it->second.value;
		else
			return defaultValue;
	}
	int count(K const& k) const {
		auto it = items.find(k);
		if (it != items.end())
			return 1;
		return 0;
	}
	virtual Future<Void> onChange(K const& k) { // throws broken_promise if this is destroyed
		auto& item = items[k];
		if (item.value == defaultValue)
			return destroyOnCancel(this, k, item.change.getFuture());
		return item.change.getFuture();
	}
	std::vector<K> getKeys() const {
		std::vector<K> keys;
		keys.reserve(items.size());
		for (auto i = items.begin(); i != items.end(); ++i)
			keys.push_back(i->first);
		return keys;
	}
	void resetNoWaiting() {
		for (auto i = items.begin(); i != items.end(); ++i)
			ASSERT(i->second.change.getFuture().getFutureReferenceCount() == 1);
		items.clear();
	}

protected:
	// Invariant: Every item in the map either has value!=defaultValue xor a destroyOnCancel actor waiting on
	// change.getFuture()
	struct P {
		V value;
		Promise<Void> change;
		P() : value() {}
	};
	std::map<K, P> items;
	const V defaultValue;
	bool destructing;

	template <typename Iterator>
	std::vector<Promise<Void>> swapRangePromises(Iterator begin, Iterator end) {
		std::vector<Promise<Void>> ps;
		for (auto it = begin; it != end; ++it) {
			ps.resize(ps.size() + 1);
			ps.back().swap(it->second.change);
		}
		return ps;
	}

	// ps can't be a reference. See explanation of noDestroy in setUnconditional()
	void send(std::vector<Promise<Void>> ps) {
		for (auto& p : ps) {
			p.send(Void());
		}
	}

	// ps can't be a reference. See explanation of noDestroy in setUnconditional()
	void sendError(std::vector<Promise<Void>> ps, Error const& e) {
		for (auto& p : ps) {
			p.sendError(e);
		}
	}

	void setUnconditional(K const& k, V const& v, P& i) {
		Promise<Void> trigger;
		i.change.swap(trigger);
		Promise<Void> noDestroy =
		    trigger; // The send(Void()) or even V::operator= could cause destroyOnCancel,
		             // which could undo the change to i.value here.  Keeping the promise reference count >= 2
		             // prevents destroyOnCancel from erasing anything from the map.
		if (v == defaultValue) {
			items.erase(k);
		} else {
			i.value = v;
		}

		trigger.send(Void());
	}

																#line 8704 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
// This generated class is to be used only via destroyOnCancel()
															#line 712 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class DestroyOnCancelActor>
															#line 712 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DestroyOnCancelActorState {
															#line 8710 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 712 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DestroyOnCancelActorState(AsyncMap* const& self,K const& key,Future<Void> const& change) 
															#line 712 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 712 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : self(self),
															#line 712 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   key(key),
															#line 712 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   change(change)
															#line 8721 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("destroyOnCancel", reinterpret_cast<unsigned long>(this));

	}
	~DestroyOnCancelActorState() 
	{
		fdb_probe_actor_destroy("destroyOnCancel", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 714 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<Void> __when_expr_0 = change;
															#line 714 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<DestroyOnCancelActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8739 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DestroyOnCancelActor*>(this)->actor_wait_state = 1;
															#line 714 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DestroyOnCancelActor, 0, Void >*>(static_cast<DestroyOnCancelActor*>(this)));
															#line 8744 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DestroyOnCancelActorState();
		static_cast<DestroyOnCancelActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 717 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_actor_cancelled && !self->destructing && change.getFutureReferenceCount() == 1 && change.getPromiseReferenceCount() == 1)
															#line 8774 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 719 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (EXPENSIVE_VALIDATION)
															#line 8778 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				{
															#line 720 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
					auto& p = self->items[key];
															#line 721 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
					ASSERT(p.change.getFuture() == change);
															#line 8784 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				}
															#line 723 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				self->items.erase(key);
															#line 8788 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 725 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 8792 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 715 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<DestroyOnCancelActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DestroyOnCancelActorState(); static_cast<DestroyOnCancelActor*>(this)->destroy(); return 0; }
															#line 8806 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<DestroyOnCancelActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DestroyOnCancelActorState();
		static_cast<DestroyOnCancelActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 715 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<DestroyOnCancelActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DestroyOnCancelActorState(); static_cast<DestroyOnCancelActor*>(this)->destroy(); return 0; }
															#line 8818 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<DestroyOnCancelActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DestroyOnCancelActorState();
		static_cast<DestroyOnCancelActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DestroyOnCancelActor*>(this)->actor_wait_state > 0) static_cast<DestroyOnCancelActor*>(this)->actor_wait_state = 0;
		static_cast<DestroyOnCancelActor*>(this)->ActorCallback< DestroyOnCancelActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DestroyOnCancelActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("destroyOnCancel", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyOnCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyOnCancel", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DestroyOnCancelActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("destroyOnCancel", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyOnCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyOnCancel", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DestroyOnCancelActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("destroyOnCancel", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyOnCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroyOnCancel", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 712 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	AsyncMap* self;
															#line 712 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	K key;
															#line 712 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> change;
															#line 8907 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via destroyOnCancel()
															#line 712 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DestroyOnCancelActor final : public Actor<Void>, public ActorCallback< DestroyOnCancelActor, 0, Void >, public FastAllocated<DestroyOnCancelActor>, public DestroyOnCancelActorState<DestroyOnCancelActor> {
															#line 8912 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<DestroyOnCancelActor>::operator new;
	using FastAllocated<DestroyOnCancelActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12185037500427117056UL, 10669523488166614528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DestroyOnCancelActor, 0, Void >;
															#line 712 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DestroyOnCancelActor(AsyncMap* const& self,K const& key,Future<Void> const& change) 
															#line 8929 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   DestroyOnCancelActorState<DestroyOnCancelActor>(self, key, change),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("destroyOnCancel", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3306109439013010944UL, 15621614171885355520UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyOnCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("destroyOnCancel");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("destroyOnCancel", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DestroyOnCancelActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 712 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> destroyOnCancel( AsyncMap* const& self, K const& key, Future<Void> const& change ) {
															#line 712 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new DestroyOnCancelActor(self, key, change));
															#line 8961 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 728 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
};

template <class V>
class ReferencedObject : NonCopyable, public ReferenceCounted<ReferencedObject<V>> {
public:
	ReferencedObject() : value() {}
	ReferencedObject(V const& v) : value(v) {}
	ReferencedObject(V&& v) : value(std::move(v)) {}
	ReferencedObject(ReferencedObject&& r) : value(std::move(r.value)) {}

	void operator=(ReferencedObject&& r) { value = std::move(r.value); }

	V const& get() const { return value; }

	V& mutate() { return value; }

	void set(V const& v) { value = v; }

	void set(V&& v) { value = std::move(v); }

	static Reference<ReferencedObject<V>> from(V const& v) { return makeReference<ReferencedObject<V>>(v); }

	static Reference<ReferencedObject<V>> from(V&& v) { return makeReference<ReferencedObject<V>>(std::move(v)); }

private:
	V value;
};

// FIXME(swift): Remove once https://github.com/apple/swift/issues/61620 is fixed.
#define SWIFT_CXX_REF_ASYNCVAR                                                                                         \
	__attribute__((swift_attr("import_reference"))) __attribute__((swift_attr("retain:immortal")))                     \
	__attribute__((swift_attr("release:immortal")))
// // TODO(swift): https://github.com/apple/swift/issues/62456 can't support retain/release funcs that are templates
// themselves
//    __attribute__((swift_attr("retain:addref_AsyncVar")))   \
//    __attribute__((swift_attr("release:delref_AsyncVar")))

template <class V>
class SWIFT_CXX_REF_ASYNCVAR AsyncVar : NonCopyable, public ReferenceCounted<AsyncVar<V>> {
public:
	AsyncVar() : value() {}
	AsyncVar(V const& v) : value(v) {}
	AsyncVar(AsyncVar&& av) : value(std::move(av.value)), nextChange(std::move(av.nextChange)) {}
	void operator=(AsyncVar&& av) {
		value = std::move(av.value);
		nextChange = std::move(av.nextChange);
	}

	V const& get() const { return value; }
	V getCopy() const __attribute__((swift_attr("import_unsafe"))) { return value; }
	Future<Void> onChange() const { return nextChange.getFuture(); }
	void set(V const& v) {
		if (v != value)
			setUnconditional(v);
	}
	void setUnconditional(V const& v) {
		Promise<Void> t;
		this->nextChange.swap(t);
		this->value = v;
		t.send(Void());
	}
	void trigger() {
		Promise<Void> t;
		this->nextChange.swap(t);
		t.send(Void());
	}

private:
	V value;
	Promise<Void> nextChange;
};

class AsyncTrigger : NonCopyable {
public:
	AsyncTrigger() {}
	AsyncTrigger(AsyncTrigger&& at) : v(std::move(at.v)) {}
	void operator=(AsyncTrigger&& at) { v = std::move(at.v); }
	Future<Void> onTrigger() const { return v.onChange(); }
	void trigger() { v.trigger(); }

private:
	AsyncVar<Void> v;
};

// Binds an AsyncTrigger object to an AsyncVar, so when the AsyncVar changes
// the AsyncTrigger is triggered.
															#line 9051 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via forward()
															#line 814 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class ForwardActor>
															#line 814 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardActorState {
															#line 9058 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 814 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardActorState(Reference<AsyncVar<T> const> const& from,AsyncTrigger* const& to) 
															#line 814 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 814 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : from(from),
															#line 814 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   to(to)
															#line 9067 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("forward", reinterpret_cast<unsigned long>(this));

	}
	~ForwardActorState() 
	{
		fdb_probe_actor_destroy("forward", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 816 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 9082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ForwardActorState();
		static_cast<ForwardActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 817 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_0 = from->onChange();
															#line 817 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<ForwardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9114 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ForwardActor*>(this)->actor_wait_state = 1;
															#line 817 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ForwardActor, 0, Void >*>(static_cast<ForwardActor*>(this)));
															#line 9119 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 818 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		to->trigger();
															#line 9128 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 818 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		to->trigger();
															#line 9137 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForwardActor*>(this)->actor_wait_state > 0) static_cast<ForwardActor*>(this)->actor_wait_state = 0;
		static_cast<ForwardActor*>(this)->ActorCallback< ForwardActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ForwardActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("forward", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ForwardActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("forward", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ForwardActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("forward", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forward", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 814 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Reference<AsyncVar<T> const> from;
															#line 814 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	AsyncTrigger* to;
															#line 9221 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via forward()
															#line 814 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 814 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardActor final : public Actor<Void>, public ActorCallback< ForwardActor<T>, 0, Void >, public FastAllocated<ForwardActor<T>>, public ForwardActorState<T, ForwardActor<T>> {
															#line 9228 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ForwardActor<T>>::operator new;
	using FastAllocated<ForwardActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13793337294807763200UL, 7293843552080384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ForwardActor<T>, 0, Void >;
															#line 814 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardActor(Reference<AsyncVar<T> const> const& from,AsyncTrigger* const& to) 
															#line 9245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   ForwardActorState<T, ForwardActor<T>>(from, to),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("forward", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8245280572221998592UL, 11353959039738441216UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forward");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forward", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ForwardActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 814 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 814 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> forward( Reference<AsyncVar<T> const> const& from, AsyncTrigger* const& to ) {
															#line 814 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new ForwardActor<T>(from, to));
															#line 9280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 821 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

class Debouncer : NonCopyable {
public:
	explicit Debouncer(double delay) { worker = debounceWorker(this, delay); }
	Debouncer(Debouncer&& at) = default;
	Debouncer& operator=(Debouncer&& at) = default;
	Future<Void> onTrigger() { return output.onChange(); }
	void trigger() { input.setUnconditional(Void()); }

private:
	AsyncVar<Void> input;
	AsyncVar<Void> output;
	Future<Void> worker;

																#line 9298 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
// This generated class is to be used only via debounceWorker()
															#line 835 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class DebounceWorkerActor>
															#line 835 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DebounceWorkerActorState {
															#line 9304 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 835 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DebounceWorkerActorState(Debouncer* const& self,double const& bounceTime) 
															#line 835 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 835 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : self(self),
															#line 835 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   bounceTime(bounceTime)
															#line 9313 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("debounceWorker", reinterpret_cast<unsigned long>(this));

	}
	~DebounceWorkerActorState() 
	{
		fdb_probe_actor_destroy("debounceWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 836 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 9328 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DebounceWorkerActorState();
		static_cast<DebounceWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 837 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_0 = self->input.onChange();
															#line 837 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<DebounceWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9360 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DebounceWorkerActor*>(this)->actor_wait_state = 1;
															#line 837 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DebounceWorkerActor, 0, Void >*>(static_cast<DebounceWorkerActor*>(this)));
															#line 9365 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 838 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		;
															#line 9374 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 838 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		;
															#line 9383 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DebounceWorkerActor*>(this)->actor_wait_state > 0) static_cast<DebounceWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<DebounceWorkerActor*>(this)->ActorCallback< DebounceWorkerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DebounceWorkerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DebounceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DebounceWorkerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DebounceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DebounceWorkerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DebounceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 846 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		self->output.setUnconditional(Void());
															#line 9467 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 840 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = self->input.onChange();
															#line 839 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<DebounceWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 9485 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 841 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_2 = delay(bounceTime);
															#line 9489 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
		static_cast<DebounceWorkerActor*>(this)->actor_wait_state = 2;
															#line 840 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DebounceWorkerActor, 1, Void >*>(static_cast<DebounceWorkerActor*>(this)));
															#line 841 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DebounceWorkerActor, 2, Void >*>(static_cast<DebounceWorkerActor*>(this)));
															#line 9496 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DebounceWorkerActor*>(this)->actor_wait_state > 0) static_cast<DebounceWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<DebounceWorkerActor*>(this)->ActorCallback< DebounceWorkerActor, 1, Void >::remove();
		static_cast<DebounceWorkerActor*>(this)->ActorCallback< DebounceWorkerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DebounceWorkerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DebounceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DebounceWorkerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DebounceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DebounceWorkerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DebounceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DebounceWorkerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DebounceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DebounceWorkerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DebounceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DebounceWorkerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DebounceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 835 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Debouncer* self;
															#line 835 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double bounceTime;
															#line 9669 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via debounceWorker()
															#line 835 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DebounceWorkerActor final : public Actor<Void>, public ActorCallback< DebounceWorkerActor, 0, Void >, public ActorCallback< DebounceWorkerActor, 1, Void >, public ActorCallback< DebounceWorkerActor, 2, Void >, public FastAllocated<DebounceWorkerActor>, public DebounceWorkerActorState<DebounceWorkerActor> {
															#line 9674 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<DebounceWorkerActor>::operator new;
	using FastAllocated<DebounceWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1904877577424811008UL, 6787954402303132928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DebounceWorkerActor, 0, Void >;
friend struct ActorCallback< DebounceWorkerActor, 1, Void >;
friend struct ActorCallback< DebounceWorkerActor, 2, Void >;
															#line 835 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DebounceWorkerActor(Debouncer* const& self,double const& bounceTime) 
															#line 9693 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   DebounceWorkerActorState<DebounceWorkerActor>(self, bounceTime),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("debounceWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3033202529816868352UL, 12951201835907995392UL);
		ActorExecutionContextHelper __helper(static_cast<DebounceWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("debounceWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("debounceWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DebounceWorkerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DebounceWorkerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 835 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> debounceWorker( Debouncer* const& self, double const& bounceTime ) {
															#line 835 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new DebounceWorkerActor(self, bounceTime));
															#line 9726 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 849 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
};

															#line 9732 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via asyncDeserialize()
															#line 851 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class AsyncDeserializeActor>
															#line 851 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class AsyncDeserializeActorState {
															#line 9739 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 851 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	AsyncDeserializeActorState(Reference<AsyncVar<Standalone<StringRef>>> const& input,Reference<AsyncVar<Optional<T>>> const& output) 
															#line 851 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 851 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : input(input),
															#line 851 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   output(output)
															#line 9748 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("asyncDeserialize", reinterpret_cast<unsigned long>(this));

	}
	~AsyncDeserializeActorState() 
	{
		fdb_probe_actor_destroy("asyncDeserialize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 854 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 9763 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AsyncDeserializeActorState();
		static_cast<AsyncDeserializeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 855 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (input->get().size())
															#line 9793 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 856 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			ObjectReader reader(input->get().begin(), IncludeVersion());
															#line 857 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			T res;
															#line 858 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			reader.deserialize(res);
															#line 859 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output->set(res);
															#line 9803 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		else
		{
															#line 861 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output->set(Optional<T>());
															#line 9809 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 862 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_0 = input->onChange();
															#line 862 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<AsyncDeserializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9815 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<AsyncDeserializeActor*>(this)->actor_wait_state = 1;
															#line 862 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AsyncDeserializeActor, 0, Void >*>(static_cast<AsyncDeserializeActor*>(this)));
															#line 9820 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AsyncDeserializeActor*>(this)->actor_wait_state > 0) static_cast<AsyncDeserializeActor*>(this)->actor_wait_state = 0;
		static_cast<AsyncDeserializeActor*>(this)->ActorCallback< AsyncDeserializeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AsyncDeserializeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("asyncDeserialize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AsyncDeserializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncDeserialize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AsyncDeserializeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("asyncDeserialize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AsyncDeserializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncDeserialize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AsyncDeserializeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("asyncDeserialize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AsyncDeserializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("asyncDeserialize", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 851 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Reference<AsyncVar<Standalone<StringRef>>> input;
															#line 851 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Reference<AsyncVar<Optional<T>>> output;
															#line 9916 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via asyncDeserialize()
															#line 851 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 851 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class AsyncDeserializeActor final : public Actor<Void>, public ActorCallback< AsyncDeserializeActor<T>, 0, Void >, public FastAllocated<AsyncDeserializeActor<T>>, public AsyncDeserializeActorState<T, AsyncDeserializeActor<T>> {
															#line 9923 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<AsyncDeserializeActor<T>>::operator new;
	using FastAllocated<AsyncDeserializeActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10953363219946422528UL, 9723254676337205248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AsyncDeserializeActor<T>, 0, Void >;
															#line 851 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	AsyncDeserializeActor(Reference<AsyncVar<Standalone<StringRef>>> const& input,Reference<AsyncVar<Optional<T>>> const& output) 
															#line 9940 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   AsyncDeserializeActorState<T, AsyncDeserializeActor<T>>(input, output),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("asyncDeserialize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8880724784580520704UL, 13500823833316833536UL);
		ActorExecutionContextHelper __helper(static_cast<AsyncDeserializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("asyncDeserialize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("asyncDeserialize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AsyncDeserializeActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 851 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 851 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> asyncDeserialize( Reference<AsyncVar<Standalone<StringRef>>> const& input, Reference<AsyncVar<Optional<T>>> const& output ) {
															#line 851 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new AsyncDeserializeActor<T>(input, output));
															#line 9975 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 865 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 9980 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via forwardVector()
															#line 866 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class V, class T, class ForwardVectorActor>
															#line 866 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardVectorActorState {
															#line 9987 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 866 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardVectorActorState(Future<V> const& values,std::vector<Promise<T>> const& out) 
															#line 866 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 866 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : values(values),
															#line 866 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   out(out)
															#line 9996 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("forwardVector", reinterpret_cast<unsigned long>(this));

	}
	~ForwardVectorActorState() 
	{
		fdb_probe_actor_destroy("forwardVector", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 868 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<V> __when_expr_0 = values;
															#line 868 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 10013 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			static_cast<ForwardVectorActor*>(this)->actor_wait_state = 1;
															#line 868 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ForwardVectorActor, 0, V >*>(static_cast<ForwardVectorActor*>(this)));
															#line 10017 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<ForwardVectorActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(V const& in,int loopDepth) 
	{
															#line 869 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		ASSERT(in.size() == out.size());
															#line 870 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		for(int i = 0;i < out.size();i++) {
															#line 871 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			out[i].send(in[i]);
															#line 10043 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(V && in,int loopDepth) 
	{
															#line 869 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		ASSERT(in.size() == out.size());
															#line 870 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		for(int i = 0;i < out.size();i++) {
															#line 871 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			out[i].send(in[i]);
															#line 10057 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(V const& in,int loopDepth) 
	{
		loopDepth = a_body1cont1(in, loopDepth);

		return loopDepth;
	}
	int a_body1when1(V && in,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(in), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForwardVectorActor*>(this)->actor_wait_state > 0) static_cast<ForwardVectorActor*>(this)->actor_wait_state = 0;
		static_cast<ForwardVectorActor*>(this)->ActorCallback< ForwardVectorActor, 0, V >::remove();

	}
	void a_callback_fire(ActorCallback< ForwardVectorActor, 0, V >*,V const& value) 
	{
		fdb_probe_actor_enter("forwardVector", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardVectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardVector", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ForwardVectorActor, 0, V >*,V && value) 
	{
		fdb_probe_actor_enter("forwardVector", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardVectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardVector", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ForwardVectorActor, 0, V >*,Error err) 
	{
		fdb_probe_actor_enter("forwardVector", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardVectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardVector", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 866 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		delete static_cast<ForwardVectorActor*>(this);
															#line 10142 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		return 0;

		return loopDepth;
	}
															#line 866 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<V> values;
															#line 866 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	std::vector<Promise<T>> out;
															#line 10151 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via forwardVector()
															#line 866 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class V, class T>
															#line 866 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardVectorActor final : public Actor<void>, public ActorCallback< ForwardVectorActor<V, T>, 0, V >, public FastAllocated<ForwardVectorActor<V, T>>, public ForwardVectorActorState<V, T, ForwardVectorActor<V, T>> {
															#line 10158 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ForwardVectorActor<V, T>>::operator new;
	using FastAllocated<ForwardVectorActor<V, T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16930355806765303808UL, 10042814269952539648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< ForwardVectorActor<V, T>, 0, V >;
															#line 866 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardVectorActor(Future<V> const& values,std::vector<Promise<T>> const& out) 
															#line 10175 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<void>(),
		   ForwardVectorActorState<V, T, ForwardVectorActor<V, T>>(values, out),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("forwardVector", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(442187572750428416UL, 9524158148023462400UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardVectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forwardVector");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forwardVector", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 866 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class V, class T>
															#line 866 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
void forwardVector( Future<V> const& values, std::vector<Promise<T>> const& out ) {
															#line 866 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	new ForwardVectorActor<V, T>(values, out);
															#line 10201 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 873 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 10206 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via delayedAsyncVar()
															#line 874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class DelayedAsyncVarActor>
															#line 874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DelayedAsyncVarActorState {
															#line 10213 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DelayedAsyncVarActorState(Reference<AsyncVar<T>> const& in,Reference<AsyncVar<T>> const& out,double const& time) 
															#line 874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : in(in),
															#line 874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   out(out),
															#line 874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   time(time)
															#line 10224 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("delayedAsyncVar", reinterpret_cast<unsigned long>(this));

	}
	~DelayedAsyncVarActorState() 
	{
		fdb_probe_actor_destroy("delayedAsyncVar", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 877 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				;
															#line 10240 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DelayedAsyncVarActorState();
		static_cast<DelayedAsyncVarActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 883 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			out->set(in->get());
															#line 884 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 10272 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 878 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_0 = delay(time);
															#line 878 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10295 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state = 1;
															#line 878 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DelayedAsyncVarActor, 0, Void >*>(static_cast<DelayedAsyncVarActor*>(this)));
															#line 10300 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 879 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		out->set(in->get());
															#line 880 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = in->onChange();
															#line 880 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10313 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state = 2;
															#line 880 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DelayedAsyncVarActor, 1, Void >*>(static_cast<DelayedAsyncVarActor*>(this)));
															#line 10318 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 879 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		out->set(in->get());
															#line 880 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = in->onChange();
															#line 880 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10331 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state = 2;
															#line 880 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DelayedAsyncVarActor, 1, Void >*>(static_cast<DelayedAsyncVarActor*>(this)));
															#line 10336 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state > 0) static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state = 0;
		static_cast<DelayedAsyncVarActor*>(this)->ActorCallback< DelayedAsyncVarActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DelayedAsyncVarActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DelayedAsyncVarActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DelayedAsyncVarActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DelayedAsyncVarActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DelayedAsyncVarActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DelayedAsyncVarActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state > 0) static_cast<DelayedAsyncVarActor*>(this)->actor_wait_state = 0;
		static_cast<DelayedAsyncVarActor*>(this)->ActorCallback< DelayedAsyncVarActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DelayedAsyncVarActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DelayedAsyncVarActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DelayedAsyncVarActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DelayedAsyncVarActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DelayedAsyncVarActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DelayedAsyncVarActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("delayedAsyncVar", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Reference<AsyncVar<T>> in;
															#line 874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Reference<AsyncVar<T>> out;
															#line 874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double time;
															#line 10509 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via delayedAsyncVar()
															#line 874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DelayedAsyncVarActor final : public Actor<Void>, public ActorCallback< DelayedAsyncVarActor<T>, 0, Void >, public ActorCallback< DelayedAsyncVarActor<T>, 1, Void >, public FastAllocated<DelayedAsyncVarActor<T>>, public DelayedAsyncVarActorState<T, DelayedAsyncVarActor<T>> {
															#line 10516 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<DelayedAsyncVarActor<T>>::operator new;
	using FastAllocated<DelayedAsyncVarActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(767980570052890368UL, 17683888426259509760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DelayedAsyncVarActor<T>, 0, Void >;
friend struct ActorCallback< DelayedAsyncVarActor<T>, 1, Void >;
															#line 874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DelayedAsyncVarActor(Reference<AsyncVar<T>> const& in,Reference<AsyncVar<T>> const& out,double const& time) 
															#line 10534 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   DelayedAsyncVarActorState<T, DelayedAsyncVarActor<T>>(in, out, time),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("delayedAsyncVar", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(186058093137053440UL, 6426008344032713216UL);
		ActorExecutionContextHelper __helper(static_cast<DelayedAsyncVarActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("delayedAsyncVar");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("delayedAsyncVar", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DelayedAsyncVarActor<T>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DelayedAsyncVarActor<T>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> delayedAsyncVar( Reference<AsyncVar<T>> const& in, Reference<AsyncVar<T>> const& out, double const& time ) {
															#line 874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new DelayedAsyncVarActor<T>(in, out, time));
															#line 10570 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 887 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 10575 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via setAfter()
															#line 888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class SetAfterActor>
															#line 888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class SetAfterActorState {
															#line 10582 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	SetAfterActorState(Reference<AsyncVar<T>> const& var,double const& time,T const& val) 
															#line 888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : var(var),
															#line 888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   time(time),
															#line 888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   val(val)
															#line 10593 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("setAfter", reinterpret_cast<unsigned long>(this));

	}
	~SetAfterActorState() 
	{
		fdb_probe_actor_destroy("setAfter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 890 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = delay(time);
															#line 890 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<SetAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10610 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetAfterActor*>(this)->actor_wait_state = 1;
															#line 890 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetAfterActor, 0, Void >*>(static_cast<SetAfterActor*>(this)));
															#line 10615 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetAfterActorState();
		static_cast<SetAfterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 891 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		var->set(val);
															#line 892 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<SetAfterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetAfterActorState(); static_cast<SetAfterActor*>(this)->destroy(); return 0; }
															#line 10640 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<SetAfterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetAfterActorState();
		static_cast<SetAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 891 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		var->set(val);
															#line 892 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<SetAfterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetAfterActorState(); static_cast<SetAfterActor*>(this)->destroy(); return 0; }
															#line 10654 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<SetAfterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetAfterActorState();
		static_cast<SetAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetAfterActor*>(this)->actor_wait_state > 0) static_cast<SetAfterActor*>(this)->actor_wait_state = 0;
		static_cast<SetAfterActor*>(this)->ActorCallback< SetAfterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetAfterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetAfterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetAfterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setAfter", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Reference<AsyncVar<T>> var;
															#line 888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double time;
															#line 888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T val;
															#line 10743 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via setAfter()
															#line 888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class SetAfterActor final : public Actor<Void>, public ActorCallback< SetAfterActor<T>, 0, Void >, public FastAllocated<SetAfterActor<T>>, public SetAfterActorState<T, SetAfterActor<T>> {
															#line 10750 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<SetAfterActor<T>>::operator new;
	using FastAllocated<SetAfterActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13673055555334486272UL, 13046400995120317440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetAfterActor<T>, 0, Void >;
															#line 888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	SetAfterActor(Reference<AsyncVar<T>> const& var,double const& time,T const& val) 
															#line 10767 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   SetAfterActorState<T, SetAfterActor<T>>(var, time, val),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setAfter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17789322467368306944UL, 3985877205555243520UL);
		ActorExecutionContextHelper __helper(static_cast<SetAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setAfter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setAfter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetAfterActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> setAfter( Reference<AsyncVar<T>> const& var, double const& time, T const& val ) {
															#line 888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new SetAfterActor<T>(var, time, val));
															#line 10802 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 894 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 10807 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via resetAfter()
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class ResetAfterActor>
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ResetAfterActorState {
															#line 10814 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ResetAfterActorState(Reference<AsyncVar<T>> const& var,double const& time,T const& val,int const& warningLimit = -1,double const& warningResetDelay = 0,const char* const& context = nullptr) 
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : var(var),
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   time(time),
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   val(val),
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   warningLimit(warningLimit),
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   warningResetDelay(warningResetDelay),
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   context(context),
															#line 902 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   isEqual(var->get() == val),
															#line 903 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   resetDelay(isEqual ? Never() : delay(time)),
															#line 904 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   resetCount(0),
															#line 905 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   lastReset(now())
															#line 10839 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("resetAfter", reinterpret_cast<unsigned long>(this));

	}
	~ResetAfterActorState() 
	{
		fdb_probe_actor_destroy("resetAfter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 906 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 10854 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ResetAfterActorState();
		static_cast<ResetAfterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 908 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_0 = resetDelay;
															#line 907 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<ResetAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10886 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 923 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = var->onChange();
															#line 10890 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<ResetAfterActor*>(this)->actor_wait_state = 1;
															#line 908 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ResetAfterActor, 0, Void >*>(static_cast<ResetAfterActor*>(this)));
															#line 923 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ResetAfterActor, 1, Void >*>(static_cast<ResetAfterActor*>(this)));
															#line 10897 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 925 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (isEqual && var->get() != val)
															#line 10906 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 926 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			isEqual = false;
															#line 927 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			resetDelay = delay(time);
															#line 10912 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 929 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!isEqual && var->get() == val)
															#line 10916 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 930 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			isEqual = true;
															#line 931 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			resetDelay = Never();
															#line 10922 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 909 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		var->set(val);
															#line 910 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (now() - lastReset > warningResetDelay)
															#line 10934 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 911 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			resetCount = 0;
															#line 10938 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 913 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		resetCount++;
															#line 914 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (context && warningLimit >= 0 && resetCount > warningLimit)
															#line 10944 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 915 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			TraceEvent(SevWarnAlways, context) .detail("ResetCount", resetCount) .detail("LastReset", now() - lastReset);
															#line 10948 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 919 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		lastReset = now();
															#line 920 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		isEqual = true;
															#line 921 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		resetDelay = Never();
															#line 10956 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 909 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		var->set(val);
															#line 910 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (now() - lastReset > warningResetDelay)
															#line 10967 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 911 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			resetCount = 0;
															#line 10971 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 913 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		resetCount++;
															#line 914 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (context && warningLimit >= 0 && resetCount > warningLimit)
															#line 10977 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 915 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			TraceEvent(SevWarnAlways, context) .detail("ResetCount", resetCount) .detail("LastReset", now() - lastReset);
															#line 10981 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 919 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		lastReset = now();
															#line 920 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		isEqual = true;
															#line 921 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		resetDelay = Never();
															#line 10989 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ResetAfterActor*>(this)->actor_wait_state > 0) static_cast<ResetAfterActor*>(this)->actor_wait_state = 0;
		static_cast<ResetAfterActor*>(this)->ActorCallback< ResetAfterActor, 0, Void >::remove();
		static_cast<ResetAfterActor*>(this)->ActorCallback< ResetAfterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResetAfterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resetAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ResetAfterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resetAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ResetAfterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resetAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResetAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ResetAfterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resetAfter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetAfter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ResetAfterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resetAfter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetAfter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ResetAfterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resetAfter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResetAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetAfter", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Reference<AsyncVar<T>> var;
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double time;
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T val;
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	int warningLimit;
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double warningResetDelay;
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	const char* context;
															#line 902 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	bool isEqual;
															#line 903 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> resetDelay;
															#line 904 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	int resetCount;
															#line 905 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double lastReset;
															#line 11147 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via resetAfter()
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ResetAfterActor final : public Actor<Void>, public ActorCallback< ResetAfterActor<T>, 0, Void >, public ActorCallback< ResetAfterActor<T>, 1, Void >, public FastAllocated<ResetAfterActor<T>>, public ResetAfterActorState<T, ResetAfterActor<T>> {
															#line 11154 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ResetAfterActor<T>>::operator new;
	using FastAllocated<ResetAfterActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13615360063519281408UL, 15931029729522695424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ResetAfterActor<T>, 0, Void >;
friend struct ActorCallback< ResetAfterActor<T>, 1, Void >;
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ResetAfterActor(Reference<AsyncVar<T>> const& var,double const& time,T const& val,int const& warningLimit = -1,double const& warningResetDelay = 0,const char* const& context = nullptr) 
															#line 11172 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   ResetAfterActorState<T, ResetAfterActor<T>>(var, time, val, warningLimit, warningResetDelay, context),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("resetAfter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3617812349498570496UL, 3760078300196401408UL);
		ActorExecutionContextHelper __helper(static_cast<ResetAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("resetAfter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("resetAfter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ResetAfterActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> resetAfter( Reference<AsyncVar<T>> const& var, double const& time, T const& val, int const& warningLimit = -1, double const& warningResetDelay = 0, const char* const& context = nullptr ) {
															#line 895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new ResetAfterActor<T>(var, time, val, warningLimit, warningResetDelay, context));
															#line 11207 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 935 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 11212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via setWhenDoneOrError()
															#line 936 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class SetWhenDoneOrErrorActor>
															#line 936 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class SetWhenDoneOrErrorActorState {
															#line 11219 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 936 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	SetWhenDoneOrErrorActorState(Future<Void> const& condition,Reference<AsyncVar<T>> const& var,T const& val) 
															#line 936 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 936 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : condition(condition),
															#line 936 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   var(var),
															#line 936 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   val(val)
															#line 11230 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("setWhenDoneOrError", reinterpret_cast<unsigned long>(this));

	}
	~SetWhenDoneOrErrorActorState() 
	{
		fdb_probe_actor_destroy("setWhenDoneOrError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 939 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<Void> __when_expr_0 = condition;
															#line 939 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<SetWhenDoneOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 11248 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<SetWhenDoneOrErrorActor*>(this)->actor_wait_state = 1;
															#line 939 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetWhenDoneOrErrorActor, 0, Void >*>(static_cast<SetWhenDoneOrErrorActor*>(this)));
															#line 11253 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetWhenDoneOrErrorActorState();
		static_cast<SetWhenDoneOrErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 944 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		var->set(val);
															#line 945 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<SetWhenDoneOrErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetWhenDoneOrErrorActorState(); static_cast<SetWhenDoneOrErrorActor*>(this)->destroy(); return 0; }
															#line 11284 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<SetWhenDoneOrErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetWhenDoneOrErrorActorState();
		static_cast<SetWhenDoneOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 941 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_actor_cancelled)
															#line 11297 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 942 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(e, loopDepth);
															#line 11301 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetWhenDoneOrErrorActor*>(this)->actor_wait_state > 0) static_cast<SetWhenDoneOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<SetWhenDoneOrErrorActor*>(this)->ActorCallback< SetWhenDoneOrErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetWhenDoneOrErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setWhenDoneOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetWhenDoneOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setWhenDoneOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetWhenDoneOrErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setWhenDoneOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetWhenDoneOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setWhenDoneOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetWhenDoneOrErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setWhenDoneOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetWhenDoneOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setWhenDoneOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 936 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> condition;
															#line 936 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Reference<AsyncVar<T>> var;
															#line 936 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T val;
															#line 11419 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via setWhenDoneOrError()
															#line 936 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 936 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class SetWhenDoneOrErrorActor final : public Actor<Void>, public ActorCallback< SetWhenDoneOrErrorActor<T>, 0, Void >, public FastAllocated<SetWhenDoneOrErrorActor<T>>, public SetWhenDoneOrErrorActorState<T, SetWhenDoneOrErrorActor<T>> {
															#line 11426 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<SetWhenDoneOrErrorActor<T>>::operator new;
	using FastAllocated<SetWhenDoneOrErrorActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15986892137436399616UL, 3553096878390369536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetWhenDoneOrErrorActor<T>, 0, Void >;
															#line 936 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	SetWhenDoneOrErrorActor(Future<Void> const& condition,Reference<AsyncVar<T>> const& var,T const& val) 
															#line 11443 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   SetWhenDoneOrErrorActorState<T, SetWhenDoneOrErrorActor<T>>(condition, var, val),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setWhenDoneOrError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(867440015705595392UL, 14281962565306802176UL);
		ActorExecutionContextHelper __helper(static_cast<SetWhenDoneOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setWhenDoneOrError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setWhenDoneOrError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetWhenDoneOrErrorActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 936 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 936 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> setWhenDoneOrError( Future<Void> const& condition, Reference<AsyncVar<T>> const& var, T const& val ) {
															#line 936 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new SetWhenDoneOrErrorActor<T>(condition, var, val));
															#line 11478 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 947 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 11483 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
[[nodiscard]] Future<Void> lowPriorityDelay( double const& waitTime );

#line 949 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Delay after condition is cleared (i.e. equal to false).
// If during delay, condition changes to true, wait till condition become false again, and repeat.
															#line 11490 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
[[nodiscard]] Future<Void> delayAfterCleared( Reference<AsyncVar<bool>> const& condition, double const& time, TaskPriority const& taskID = TaskPriority::DefaultDelay );

#line 955 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Same as delayAfterCleared, but use lowPriorityDelay.
															#line 11496 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
[[nodiscard]] Future<Void> lowPriorityDelayAfterCleared( Reference<AsyncVar<bool>> const& condition, double const& time );

#line 958 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Similar to timeoutError, but does not throw timed_out if condition is true.
// Once condition becomes false again, reset the timer (e.g. if time is 10s, wait for 10s again before throwing
// timed_out, if condition remains to be false).
															#line 11504 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via timeoutErrorIfCleared()
															#line 962 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TimeoutErrorIfClearedActor>
															#line 962 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TimeoutErrorIfClearedActorState {
															#line 11511 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 962 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TimeoutErrorIfClearedActorState(Future<T> const& what,Reference<AsyncVar<bool>> const& condition,double const& time,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 962 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 962 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 962 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   condition(condition),
															#line 962 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   time(time),
															#line 962 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   taskID(taskID)
															#line 11524 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("timeoutErrorIfCleared", reinterpret_cast<unsigned long>(this));

	}
	~TimeoutErrorIfClearedActorState() 
	{
		fdb_probe_actor_destroy("timeoutErrorIfCleared", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 968 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = what;
															#line 967 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<TimeoutErrorIfClearedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11541 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 971 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = delayAfterCleared(condition, time, taskID);
															#line 11545 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<TimeoutErrorIfClearedActor*>(this)->actor_wait_state = 1;
															#line 968 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TimeoutErrorIfClearedActor, 0, T >*>(static_cast<TimeoutErrorIfClearedActor*>(this)));
															#line 971 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TimeoutErrorIfClearedActor, 1, Void >*>(static_cast<TimeoutErrorIfClearedActor*>(this)));
															#line 11552 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TimeoutErrorIfClearedActorState();
		static_cast<TimeoutErrorIfClearedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
															#line 969 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutErrorIfClearedActor*>(this)->SAV<T>::futures) { (void)(t); this->~TimeoutErrorIfClearedActorState(); static_cast<TimeoutErrorIfClearedActor*>(this)->destroy(); return 0; }
															#line 11575 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutErrorIfClearedActor*>(this)->SAV< T >::value()) T(t);
		this->~TimeoutErrorIfClearedActorState();
		static_cast<TimeoutErrorIfClearedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
															#line 969 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TimeoutErrorIfClearedActor*>(this)->SAV<T>::futures) { (void)(t); this->~TimeoutErrorIfClearedActorState(); static_cast<TimeoutErrorIfClearedActor*>(this)->destroy(); return 0; }
															#line 11587 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TimeoutErrorIfClearedActor*>(this)->SAV< T >::value()) T(t);
		this->~TimeoutErrorIfClearedActorState();
		static_cast<TimeoutErrorIfClearedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 972 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(timed_out(), loopDepth);
															#line 11599 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 972 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(timed_out(), loopDepth);
															#line 11607 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TimeoutErrorIfClearedActor*>(this)->actor_wait_state > 0) static_cast<TimeoutErrorIfClearedActor*>(this)->actor_wait_state = 0;
		static_cast<TimeoutErrorIfClearedActor*>(this)->ActorCallback< TimeoutErrorIfClearedActor, 0, T >::remove();
		static_cast<TimeoutErrorIfClearedActor*>(this)->ActorCallback< TimeoutErrorIfClearedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeoutErrorIfClearedActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("timeoutErrorIfCleared", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutErrorIfClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutErrorIfCleared", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeoutErrorIfClearedActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("timeoutErrorIfCleared", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutErrorIfClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutErrorIfCleared", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TimeoutErrorIfClearedActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("timeoutErrorIfCleared", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutErrorIfClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutErrorIfCleared", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeoutErrorIfClearedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeoutErrorIfCleared", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutErrorIfClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutErrorIfCleared", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TimeoutErrorIfClearedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeoutErrorIfCleared", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutErrorIfClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutErrorIfCleared", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TimeoutErrorIfClearedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeoutErrorIfCleared", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutErrorIfClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeoutErrorIfCleared", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 962 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> what;
															#line 962 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Reference<AsyncVar<bool>> condition;
															#line 962 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double time;
															#line 962 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TaskPriority taskID;
															#line 11740 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via timeoutErrorIfCleared()
															#line 962 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 962 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TimeoutErrorIfClearedActor final : public Actor<T>, public ActorCallback< TimeoutErrorIfClearedActor<T>, 0, T >, public ActorCallback< TimeoutErrorIfClearedActor<T>, 1, Void >, public FastAllocated<TimeoutErrorIfClearedActor<T>>, public TimeoutErrorIfClearedActorState<T, TimeoutErrorIfClearedActor<T>> {
															#line 11747 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TimeoutErrorIfClearedActor<T>>::operator new;
	using FastAllocated<TimeoutErrorIfClearedActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12419917935974750208UL, 13244723752831557120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TimeoutErrorIfClearedActor<T>, 0, T >;
friend struct ActorCallback< TimeoutErrorIfClearedActor<T>, 1, Void >;
															#line 962 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TimeoutErrorIfClearedActor(Future<T> const& what,Reference<AsyncVar<bool>> const& condition,double const& time,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 11765 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   TimeoutErrorIfClearedActorState<T, TimeoutErrorIfClearedActor<T>>(what, condition, time, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("timeoutErrorIfCleared", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13766359157345727744UL, 5577040220185098496UL);
		ActorExecutionContextHelper __helper(static_cast<TimeoutErrorIfClearedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("timeoutErrorIfCleared");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("timeoutErrorIfCleared", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TimeoutErrorIfClearedActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 962 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 962 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> timeoutErrorIfCleared( Future<T> const& what, Reference<AsyncVar<bool>> const& condition, double const& time, TaskPriority const& taskID = TaskPriority::DefaultDelay ) {
															#line 962 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new TimeoutErrorIfClearedActor<T>(what, condition, time, taskID));
															#line 11800 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 976 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

Future<bool> allTrue(const std::vector<Future<bool>>& all);
Future<Void> anyTrue(std::vector<Reference<AsyncVar<bool>>> const& input, Reference<AsyncVar<bool>> const& output);
Future<Void> cancelOnly(std::vector<Future<Void>> const& futures);
Future<Void> timeoutWarningCollector(FutureStream<Void> const& input,
                                     double const& logDelay,
                                     const char* const& context,
                                     UID const& id);
															#line 11812 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
[[nodiscard]] Future<bool> quorumEqualsTrue( std::vector<Future<bool>> const& futures, int const& required );

#line 985 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 11817 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via streamHelper()
															#line 986 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class StreamHelperActor>
															#line 986 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class StreamHelperActorState {
															#line 11824 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 986 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	StreamHelperActorState(PromiseStream<T> const& output,PromiseStream<Error> const& errors,Future<T> const& input) 
															#line 986 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 986 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : output(output),
															#line 986 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   errors(errors),
															#line 986 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   input(input)
															#line 11835 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("streamHelper", reinterpret_cast<unsigned long>(this));

	}
	~StreamHelperActorState() 
	{
		fdb_probe_actor_destroy("streamHelper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 989 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = input;
															#line 989 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<StreamHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 11853 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<StreamHelperActor*>(this)->actor_wait_state = 1;
															#line 989 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StreamHelperActor, 0, T >*>(static_cast<StreamHelperActor*>(this)));
															#line 11858 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StreamHelperActorState();
		static_cast<StreamHelperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 996 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<StreamHelperActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StreamHelperActorState(); static_cast<StreamHelperActor*>(this)->destroy(); return 0; }
															#line 11887 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<StreamHelperActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StreamHelperActorState();
		static_cast<StreamHelperActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 992 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_actor_cancelled)
															#line 11900 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 993 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(e, loopDepth);
															#line 11904 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 994 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			errors.send(e);
															#line 11908 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& value,int loopDepth) 
	{
															#line 990 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(value);
															#line 11923 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(T && value,int loopDepth) 
	{
															#line 990 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.send(value);
															#line 11932 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& value,int loopDepth) 
	{
		loopDepth = a_body1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && value,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StreamHelperActor*>(this)->actor_wait_state > 0) static_cast<StreamHelperActor*>(this)->actor_wait_state = 0;
		static_cast<StreamHelperActor*>(this)->ActorCallback< StreamHelperActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< StreamHelperActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("streamHelper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StreamHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StreamHelperActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("streamHelper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StreamHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StreamHelperActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("streamHelper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StreamHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 986 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<T> output;
															#line 986 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<Error> errors;
															#line 986 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> input;
															#line 12031 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via streamHelper()
															#line 986 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 986 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class StreamHelperActor final : public Actor<Void>, public ActorCallback< StreamHelperActor<T>, 0, T >, public FastAllocated<StreamHelperActor<T>>, public StreamHelperActorState<T, StreamHelperActor<T>> {
															#line 12038 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<StreamHelperActor<T>>::operator new;
	using FastAllocated<StreamHelperActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16674759456094899968UL, 918892128489458944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StreamHelperActor<T>, 0, T >;
															#line 986 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	StreamHelperActor(PromiseStream<T> const& output,PromiseStream<Error> const& errors,Future<T> const& input) 
															#line 12055 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   StreamHelperActorState<T, StreamHelperActor<T>>(output, errors, input),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("streamHelper", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16076362173234148352UL, 13548850868885335808UL);
		ActorExecutionContextHelper __helper(static_cast<StreamHelperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("streamHelper");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("streamHelper", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StreamHelperActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 986 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 986 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> streamHelper( PromiseStream<T> const& output, PromiseStream<Error> const& errors, Future<T> const& input ) {
															#line 986 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new StreamHelperActor<T>(output, errors, input));
															#line 12090 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 998 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

template <class T>
Future<Void> makeStream(const std::vector<Future<T>>& futures, PromiseStream<T>& stream, PromiseStream<Error>& errors) {
	std::vector<Future<Void>> forwarders;
	forwarders.reserve(futures.size());
	for (int f = 0; f < futures.size(); f++)
		forwarders.push_back(streamHelper(stream, errors, futures[f]));
	return cancelOnly(forwarders);
}

template <class T>
class QuorumCallback;

template <class T>
struct Quorum final : SAV<Void> {
	int antiQuorum;
	int count;

	static inline int sizeFor(int count) { return sizeof(Quorum<T>) + sizeof(QuorumCallback<T>) * count; }

	void destroy() override {
		int size = sizeFor(this->count);
		this->~Quorum();
		freeFast(size, this);
	}
	void cancel() override {
		int cancelled_callbacks = 0;
		for (int i = 0; i < count; i++)
			if (callbacks()[i].next) {
				callbacks()[i].remove();
				callbacks()[i].next = 0;
				++cancelled_callbacks;
			}
		if (canBeSet())
			sendError(actor_cancelled());
		for (int i = 0; i < cancelled_callbacks; i++)
			delPromiseRef();
	}
	explicit Quorum(int quorum, int count) : SAV<Void>(1, count), antiQuorum(count - quorum + 1), count(count) {
		if (!quorum)
			this->send(Void());
	}
	void oneSuccess() {
		if (getPromiseReferenceCount() == antiQuorum && canBeSet())
			this->sendAndDelPromiseRef(Void());
		else
			delPromiseRef();
	}
	void oneError(Error err) {
		if (canBeSet())
			this->sendErrorAndDelPromiseRef(err);
		else
			delPromiseRef();
	}

	QuorumCallback<T>* callbacks() { return (QuorumCallback<T>*)(this + 1); }
};

template <class T>
class QuorumCallback : public Callback<T> {
public:
	void fire(const T& value) override {
		Callback<T>::remove();
		Callback<T>::next = 0;
		head->oneSuccess();
	}
	void error(Error error) override {
		Callback<T>::remove();
		Callback<T>::next = 0;
		head->oneError(error);
	}

private:
	template <class U>
	friend Future<Void> quorum(const Future<U>* pItems, int itemCount, int n);
	Quorum<T>* head;
	QuorumCallback() = default;
	QuorumCallback(Future<T> future, Quorum<T>* head) : head(head) { future.addCallbackAndClear(this); }
};

template <class T>
Future<Void> quorum(const Future<T>* pItems, int itemCount, int n) {
	ASSERT(n >= 0 && n <= itemCount);

	int size = Quorum<T>::sizeFor(itemCount);
	Quorum<T>* q = new (allocateFast(size)) Quorum<T>(n, itemCount);

	QuorumCallback<T>* nextCallback = q->callbacks();
	for (int i = 0; i < itemCount; ++i) {
		auto& r = pItems[i];
		if (r.isReady()) {
			new (nextCallback) QuorumCallback<T>();
			nextCallback->next = 0;
			if (r.isError())
				q->oneError(r.getError());
			else
				q->oneSuccess();
		} else
			new (nextCallback) QuorumCallback<T>(r, q);
		++nextCallback;
	}
	return Future<Void>(q);
}

template <class T>
Future<Void> quorum(std::vector<Future<T>> const& results, int n) {
	return quorum(&results.front(), results.size(), n);
}

															#line 12203 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via smartQuorum()
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class SmartQuorumActor>
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class SmartQuorumActorState {
															#line 12210 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	SmartQuorumActorState(std::vector<Future<T>> const& results,int const& required,double const& extraSeconds,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : results(results),
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   required(required),
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   extraSeconds(extraSeconds),
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   taskID(taskID)
															#line 12223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("smartQuorum", reinterpret_cast<unsigned long>(this));

	}
	~SmartQuorumActorState() 
	{
		fdb_probe_actor_destroy("smartQuorum", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1112 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (results.empty() && required == 0)
															#line 12238 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 1113 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (!static_cast<SmartQuorumActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SmartQuorumActorState(); static_cast<SmartQuorumActor*>(this)->destroy(); return 0; }
															#line 12242 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				new (&static_cast<SmartQuorumActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~SmartQuorumActorState();
				static_cast<SmartQuorumActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1114 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = quorum(results, required);
															#line 1114 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<SmartQuorumActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12252 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SmartQuorumActor*>(this)->actor_wait_state = 1;
															#line 1114 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SmartQuorumActor, 0, Void >*>(static_cast<SmartQuorumActor*>(this)));
															#line 12257 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SmartQuorumActorState();
		static_cast<SmartQuorumActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1116 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = quorum(results, (int)results.size());
															#line 1115 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<SmartQuorumActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 1119 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_2 = delay(extraSeconds, taskID);
															#line 12286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
		static_cast<SmartQuorumActor*>(this)->actor_wait_state = 2;
															#line 1116 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SmartQuorumActor, 1, Void >*>(static_cast<SmartQuorumActor*>(this)));
															#line 1119 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SmartQuorumActor, 2, Void >*>(static_cast<SmartQuorumActor*>(this)));
															#line 12293 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1116 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = quorum(results, (int)results.size());
															#line 1115 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<SmartQuorumActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12304 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 1119 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_2 = delay(extraSeconds, taskID);
															#line 12308 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
		static_cast<SmartQuorumActor*>(this)->actor_wait_state = 2;
															#line 1116 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SmartQuorumActor, 1, Void >*>(static_cast<SmartQuorumActor*>(this)));
															#line 1119 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SmartQuorumActor, 2, Void >*>(static_cast<SmartQuorumActor*>(this)));
															#line 12315 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SmartQuorumActor*>(this)->actor_wait_state > 0) static_cast<SmartQuorumActor*>(this)->actor_wait_state = 0;
		static_cast<SmartQuorumActor*>(this)->ActorCallback< SmartQuorumActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SmartQuorumActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SmartQuorumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SmartQuorumActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SmartQuorumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SmartQuorumActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SmartQuorumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
															#line 1117 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<SmartQuorumActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SmartQuorumActorState(); static_cast<SmartQuorumActor*>(this)->destroy(); return 0; }
															#line 12399 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<SmartQuorumActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SmartQuorumActorState();
		static_cast<SmartQuorumActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
															#line 1117 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<SmartQuorumActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SmartQuorumActorState(); static_cast<SmartQuorumActor*>(this)->destroy(); return 0; }
															#line 12411 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<SmartQuorumActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SmartQuorumActorState();
		static_cast<SmartQuorumActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when2(Void const& _,int loopDepth) 
	{
															#line 1120 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<SmartQuorumActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SmartQuorumActorState(); static_cast<SmartQuorumActor*>(this)->destroy(); return 0; }
															#line 12423 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<SmartQuorumActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SmartQuorumActorState();
		static_cast<SmartQuorumActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when2(Void && _,int loopDepth) 
	{
															#line 1120 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<SmartQuorumActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SmartQuorumActorState(); static_cast<SmartQuorumActor*>(this)->destroy(); return 0; }
															#line 12435 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<SmartQuorumActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SmartQuorumActorState();
		static_cast<SmartQuorumActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SmartQuorumActor*>(this)->actor_wait_state > 0) static_cast<SmartQuorumActor*>(this)->actor_wait_state = 0;
		static_cast<SmartQuorumActor*>(this)->ActorCallback< SmartQuorumActor, 1, Void >::remove();
		static_cast<SmartQuorumActor*>(this)->ActorCallback< SmartQuorumActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SmartQuorumActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SmartQuorumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SmartQuorumActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SmartQuorumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SmartQuorumActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SmartQuorumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SmartQuorumActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SmartQuorumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SmartQuorumActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SmartQuorumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SmartQuorumActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SmartQuorumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	std::vector<Future<T>> results;
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	int required;
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double extraSeconds;
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TaskPriority taskID;
															#line 12572 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via smartQuorum()
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class SmartQuorumActor final : public Actor<Void>, public ActorCallback< SmartQuorumActor<T>, 0, Void >, public ActorCallback< SmartQuorumActor<T>, 1, Void >, public ActorCallback< SmartQuorumActor<T>, 2, Void >, public FastAllocated<SmartQuorumActor<T>>, public SmartQuorumActorState<T, SmartQuorumActor<T>> {
															#line 12579 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<SmartQuorumActor<T>>::operator new;
	using FastAllocated<SmartQuorumActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9923658067529569024UL, 16587334033662782208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SmartQuorumActor<T>, 0, Void >;
friend struct ActorCallback< SmartQuorumActor<T>, 1, Void >;
friend struct ActorCallback< SmartQuorumActor<T>, 2, Void >;
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	SmartQuorumActor(std::vector<Future<T>> const& results,int const& required,double const& extraSeconds,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 12598 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   SmartQuorumActorState<T, SmartQuorumActor<T>>(results, required, extraSeconds, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("smartQuorum", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13724542587795787264UL, 12905642504240907264UL);
		ActorExecutionContextHelper __helper(static_cast<SmartQuorumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("smartQuorum");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("smartQuorum", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SmartQuorumActor<T>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SmartQuorumActor<T>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> smartQuorum( std::vector<Future<T>> const& results, int const& required, double const& extraSeconds, TaskPriority const& taskID = TaskPriority::DefaultDelay ) {
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new SmartQuorumActor<T>(results, required, extraSeconds, taskID));
															#line 12634 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1124 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

template <class T>
Future<Void> waitForAll(std::vector<Future<T>> const& results) {
	if (results.empty())
		return Void();
	return quorum(results, (int)results.size());
}

// Wait for all futures in results to be ready and then throw the first (in execution order) error
// if any of them resulted in an error.
template <class T>
Future<Void> waitForAllReadyThenThrow(std::vector<Future<T>> const& results) {
	Future<Void> f = waitForAll(results);
	Future<Void> fReady = waitForAllReady(results);
	return fReady + f;
}

template <class T>
Future<Void> waitForAny(std::vector<Future<T>> const& results) {
	if (results.empty())
		return Void();
	return quorum(results, 1);
}

															#line 12662 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
[[nodiscard]] Future<Void> waitForMost( std::vector<Future<ErrorOr<Void>>> const& futures, int const& faultTolerance, Error const& e, double const& waitMultiplierForSlowFutures = 1.0 );

#line 1152 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 12667 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
[[nodiscard]] Future<bool> shortCircuitAny( std::vector<Future<bool>> const& f );

#line 1154 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 12672 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via getAll()
															#line 1155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class GetAllActor>
															#line 1155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class GetAllActorState {
															#line 12679 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	GetAllActorState(std::vector<Future<T>> const& input) 
															#line 1155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : input(input)
															#line 12686 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("getAll", reinterpret_cast<unsigned long>(this));

	}
	~GetAllActorState() 
	{
		fdb_probe_actor_destroy("getAll", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1157 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (input.empty())
															#line 12701 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 1158 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (!static_cast<GetAllActor*>(this)->SAV<std::vector<T>>::futures) { (void)(std::vector<T>()); this->~GetAllActorState(); static_cast<GetAllActor*>(this)->destroy(); return 0; }
															#line 12705 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				new (&static_cast<GetAllActor*>(this)->SAV< std::vector<T> >::value()) std::vector<T>(std::vector<T>());
				this->~GetAllActorState();
				static_cast<GetAllActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = quorum(input, input.size());
															#line 1159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<GetAllActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12715 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetAllActor*>(this)->actor_wait_state = 1;
															#line 1159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAllActor, 0, Void >*>(static_cast<GetAllActor*>(this)));
															#line 12720 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAllActorState();
		static_cast<GetAllActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1161 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		std::vector<T> output;
															#line 1162 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.reserve(input.size());
															#line 1163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		for(int i = 0;i < input.size();i++) {
															#line 1164 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.push_back(input[i].get());
															#line 12749 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 1165 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<GetAllActor*>(this)->SAV<std::vector<T>>::futures) { (void)(output); this->~GetAllActorState(); static_cast<GetAllActor*>(this)->destroy(); return 0; }
															#line 12753 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<GetAllActor*>(this)->SAV< std::vector<T> >::value()) std::vector<T>(output);
		this->~GetAllActorState();
		static_cast<GetAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1161 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		std::vector<T> output;
															#line 1162 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.reserve(input.size());
															#line 1163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		for(int i = 0;i < input.size();i++) {
															#line 1164 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.push_back(input[i].get());
															#line 12771 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 1165 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<GetAllActor*>(this)->SAV<std::vector<T>>::futures) { (void)(output); this->~GetAllActorState(); static_cast<GetAllActor*>(this)->destroy(); return 0; }
															#line 12775 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<GetAllActor*>(this)->SAV< std::vector<T> >::value()) std::vector<T>(output);
		this->~GetAllActorState();
		static_cast<GetAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAllActor*>(this)->actor_wait_state > 0) static_cast<GetAllActor*>(this)->actor_wait_state = 0;
		static_cast<GetAllActor*>(this)->ActorCallback< GetAllActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAllActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAllActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAllActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAll", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	std::vector<Future<T>> input;
															#line 12860 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via getAll()
															#line 1155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class GetAllActor final : public Actor<std::vector<T>>, public ActorCallback< GetAllActor<T>, 0, Void >, public FastAllocated<GetAllActor<T>>, public GetAllActorState<T, GetAllActor<T>> {
															#line 12867 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<GetAllActor<T>>::operator new;
	using FastAllocated<GetAllActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11218219384274905088UL, 10161954239925092096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<T>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAllActor<T>, 0, Void >;
															#line 1155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	GetAllActor(std::vector<Future<T>> const& input) 
															#line 12884 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<std::vector<T>>(),
		   GetAllActorState<T, GetAllActor<T>>(input),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAll", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16361995107014370816UL, 2714745357278614528UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAll");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAll", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAllActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<std::vector<T>> getAll( std::vector<Future<T>> const& input ) {
															#line 1155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<std::vector<T>>(new GetAllActor<T>(input));
															#line 12919 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1167 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 12924 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via appendAll()
															#line 1168 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class AppendAllActor>
															#line 1168 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class AppendAllActorState {
															#line 12931 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1168 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	AppendAllActorState(std::vector<Future<std::vector<T>>> const& input) 
															#line 1168 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1168 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : input(input)
															#line 12938 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("appendAll", reinterpret_cast<unsigned long>(this));

	}
	~AppendAllActorState() 
	{
		fdb_probe_actor_destroy("appendAll", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1170 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = quorum(input, input.size());
															#line 1170 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<AppendAllActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12955 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AppendAllActor*>(this)->actor_wait_state = 1;
															#line 1170 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AppendAllActor, 0, Void >*>(static_cast<AppendAllActor*>(this)));
															#line 12960 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AppendAllActorState();
		static_cast<AppendAllActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1172 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		std::vector<T> output;
															#line 1173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		size_t sz = 0;
															#line 1174 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		for( const auto& f : input ) {
															#line 1175 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			sz += f.get().size();
															#line 12989 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 1177 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.reserve(sz);
															#line 1179 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		for(int i = 0;i < input.size();i++) {
															#line 1180 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			auto const& r = input[i].get();
															#line 1181 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.insert(output.end(), r.begin(), r.end());
															#line 12999 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 1183 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<AppendAllActor*>(this)->SAV<std::vector<T>>::futures) { (void)(output); this->~AppendAllActorState(); static_cast<AppendAllActor*>(this)->destroy(); return 0; }
															#line 13003 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<AppendAllActor*>(this)->SAV< std::vector<T> >::value()) std::vector<T>(output);
		this->~AppendAllActorState();
		static_cast<AppendAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1172 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		std::vector<T> output;
															#line 1173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		size_t sz = 0;
															#line 1174 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		for( const auto& f : input ) {
															#line 1175 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			sz += f.get().size();
															#line 13021 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 1177 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		output.reserve(sz);
															#line 1179 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		for(int i = 0;i < input.size();i++) {
															#line 1180 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			auto const& r = input[i].get();
															#line 1181 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.insert(output.end(), r.begin(), r.end());
															#line 13031 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
															#line 1183 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<AppendAllActor*>(this)->SAV<std::vector<T>>::futures) { (void)(output); this->~AppendAllActorState(); static_cast<AppendAllActor*>(this)->destroy(); return 0; }
															#line 13035 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<AppendAllActor*>(this)->SAV< std::vector<T> >::value()) std::vector<T>(output);
		this->~AppendAllActorState();
		static_cast<AppendAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AppendAllActor*>(this)->actor_wait_state > 0) static_cast<AppendAllActor*>(this)->actor_wait_state = 0;
		static_cast<AppendAllActor*>(this)->ActorCallback< AppendAllActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AppendAllActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("appendAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AppendAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("appendAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AppendAllActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("appendAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AppendAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("appendAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AppendAllActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("appendAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AppendAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("appendAll", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1168 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	std::vector<Future<std::vector<T>>> input;
															#line 13120 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via appendAll()
															#line 1168 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1168 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class AppendAllActor final : public Actor<std::vector<T>>, public ActorCallback< AppendAllActor<T>, 0, Void >, public FastAllocated<AppendAllActor<T>>, public AppendAllActorState<T, AppendAllActor<T>> {
															#line 13127 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<AppendAllActor<T>>::operator new;
	using FastAllocated<AppendAllActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17663171797748561408UL, 17464805610470436864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<T>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AppendAllActor<T>, 0, Void >;
															#line 1168 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	AppendAllActor(std::vector<Future<std::vector<T>>> const& input) 
															#line 13144 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<std::vector<T>>(),
		   AppendAllActorState<T, AppendAllActor<T>>(input),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("appendAll", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12820898808668760320UL, 11580523994196116992UL);
		ActorExecutionContextHelper __helper(static_cast<AppendAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("appendAll");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("appendAll", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AppendAllActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1168 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1168 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<std::vector<T>> appendAll( std::vector<Future<std::vector<T>>> const& input ) {
															#line 1168 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<std::vector<T>>(new AppendAllActor<T>(input));
															#line 13179 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1185 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 13184 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via onEqual()
															#line 1186 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class OnEqualActor>
															#line 1186 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class OnEqualActorState {
															#line 13191 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1186 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	OnEqualActorState(Future<T> const& in,T const& equalTo) 
															#line 1186 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1186 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : in(in),
															#line 1186 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   equalTo(equalTo)
															#line 13200 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("onEqual", reinterpret_cast<unsigned long>(this));

	}
	~OnEqualActorState() 
	{
		fdb_probe_actor_destroy("onEqual", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1188 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = in;
															#line 1188 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<OnEqualActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13217 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<OnEqualActor*>(this)->actor_wait_state = 1;
															#line 1188 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OnEqualActor, 0, T >*>(static_cast<OnEqualActor*>(this)));
															#line 13222 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OnEqualActorState();
		static_cast<OnEqualActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& t,int loopDepth) 
	{
															#line 1189 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (t == equalTo)
															#line 13245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 1190 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (!static_cast<OnEqualActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OnEqualActorState(); static_cast<OnEqualActor*>(this)->destroy(); return 0; }
															#line 13249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			new (&static_cast<OnEqualActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~OnEqualActorState();
			static_cast<OnEqualActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1191 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = Never();
															#line 1191 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<OnEqualActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13259 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<OnEqualActor*>(this)->actor_wait_state = 2;
															#line 1191 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OnEqualActor, 1, Void >*>(static_cast<OnEqualActor*>(this)));
															#line 13264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T && t,int loopDepth) 
	{
															#line 1189 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (t == equalTo)
															#line 13273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 1190 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (!static_cast<OnEqualActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OnEqualActorState(); static_cast<OnEqualActor*>(this)->destroy(); return 0; }
															#line 13277 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			new (&static_cast<OnEqualActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~OnEqualActorState();
			static_cast<OnEqualActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1191 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_1 = Never();
															#line 1191 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<OnEqualActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13287 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<OnEqualActor*>(this)->actor_wait_state = 2;
															#line 1191 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OnEqualActor, 1, Void >*>(static_cast<OnEqualActor*>(this)));
															#line 13292 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont1(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OnEqualActor*>(this)->actor_wait_state > 0) static_cast<OnEqualActor*>(this)->actor_wait_state = 0;
		static_cast<OnEqualActor*>(this)->ActorCallback< OnEqualActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< OnEqualActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("onEqual", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnEqualActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onEqual", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OnEqualActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("onEqual", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnEqualActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onEqual", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OnEqualActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("onEqual", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OnEqualActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onEqual", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1192 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 13376 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1192 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 13384 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<OnEqualActor*>(this)->actor_wait_state > 0) static_cast<OnEqualActor*>(this)->actor_wait_state = 0;
		static_cast<OnEqualActor*>(this)->ActorCallback< OnEqualActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OnEqualActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("onEqual", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnEqualActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onEqual", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< OnEqualActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("onEqual", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnEqualActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onEqual", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< OnEqualActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("onEqual", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OnEqualActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onEqual", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1186 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> in;
															#line 1186 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T equalTo;
															#line 13467 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via onEqual()
															#line 1186 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1186 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class OnEqualActor final : public Actor<Void>, public ActorCallback< OnEqualActor<T>, 0, T >, public ActorCallback< OnEqualActor<T>, 1, Void >, public FastAllocated<OnEqualActor<T>>, public OnEqualActorState<T, OnEqualActor<T>> {
															#line 13474 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<OnEqualActor<T>>::operator new;
	using FastAllocated<OnEqualActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17499212931383119104UL, 8505013384552511488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OnEqualActor<T>, 0, T >;
friend struct ActorCallback< OnEqualActor<T>, 1, Void >;
															#line 1186 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	OnEqualActor(Future<T> const& in,T const& equalTo) 
															#line 13492 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   OnEqualActorState<T, OnEqualActor<T>>(in, equalTo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("onEqual", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16353451186205296128UL, 1171592687792352512UL);
		ActorExecutionContextHelper __helper(static_cast<OnEqualActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("onEqual");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("onEqual", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OnEqualActor<T>, 0, T >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< OnEqualActor<T>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1186 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1186 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> onEqual( Future<T> const& in, T const& equalTo ) {
															#line 1186 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new OnEqualActor<T>(in, equalTo));
															#line 13528 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1194 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 13533 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via success()
															#line 1195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class SuccessActor>
															#line 1195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class SuccessActorState {
															#line 13540 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	SuccessActorState(Future<T> const& of) 
															#line 1195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : of(of)
															#line 13547 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("success", reinterpret_cast<unsigned long>(this));

	}
	~SuccessActorState() 
	{
		fdb_probe_actor_destroy("success", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1197 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = of;
															#line 1197 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<SuccessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13564 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SuccessActor*>(this)->actor_wait_state = 1;
															#line 1197 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SuccessActor, 0, T >*>(static_cast<SuccessActor*>(this)));
															#line 13569 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SuccessActorState();
		static_cast<SuccessActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& t,int loopDepth) 
	{
															#line 1198 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		(void)t;
															#line 1199 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<SuccessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SuccessActorState(); static_cast<SuccessActor*>(this)->destroy(); return 0; }
															#line 13594 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<SuccessActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SuccessActorState();
		static_cast<SuccessActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(T && t,int loopDepth) 
	{
															#line 1198 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		(void)t;
															#line 1199 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<SuccessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SuccessActorState(); static_cast<SuccessActor*>(this)->destroy(); return 0; }
															#line 13608 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<SuccessActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SuccessActorState();
		static_cast<SuccessActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont1(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SuccessActor*>(this)->actor_wait_state > 0) static_cast<SuccessActor*>(this)->actor_wait_state = 0;
		static_cast<SuccessActor*>(this)->ActorCallback< SuccessActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< SuccessActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("success", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SuccessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("success", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SuccessActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("success", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SuccessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("success", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SuccessActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("success", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SuccessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("success", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> of;
															#line 13693 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via success()
															#line 1195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class SuccessActor final : public Actor<Void>, public ActorCallback< SuccessActor<T>, 0, T >, public FastAllocated<SuccessActor<T>>, public SuccessActorState<T, SuccessActor<T>> {
															#line 13700 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<SuccessActor<T>>::operator new;
	using FastAllocated<SuccessActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7431995669114423552UL, 7479448353428147968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SuccessActor<T>, 0, T >;
															#line 1195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	SuccessActor(Future<T> const& of) 
															#line 13717 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   SuccessActorState<T, SuccessActor<T>>(of),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("success", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16758655978909564416UL, 7854398836592254464UL);
		ActorExecutionContextHelper __helper(static_cast<SuccessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("success");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("success", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SuccessActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> success( Future<T> const& of ) {
															#line 1195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new SuccessActor<T>(of));
															#line 13752 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1201 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 13757 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via ready()
															#line 1202 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class ReadyActor>
															#line 1202 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ReadyActorState {
															#line 13764 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1202 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ReadyActorState(Future<T> const& f) 
															#line 1202 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1202 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : f(f)
															#line 13771 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("ready", reinterpret_cast<unsigned long>(this));

	}
	~ReadyActorState() 
	{
		fdb_probe_actor_destroy("ready", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1205 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = f;
															#line 1205 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<ReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13789 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadyActor*>(this)->actor_wait_state = 1;
															#line 1205 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadyActor, 0, T >*>(static_cast<ReadyActor*>(this)));
															#line 13794 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadyActorState();
		static_cast<ReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1209 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadyActorState(); static_cast<ReadyActor*>(this)->destroy(); return 0; }
															#line 13823 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadyActorState();
		static_cast<ReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& t,int loopDepth) 
	{
															#line 1206 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		(void)t;
															#line 13848 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(T && t,int loopDepth) 
	{
															#line 1206 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		(void)t;
															#line 13857 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadyActor*>(this)->actor_wait_state > 0) static_cast<ReadyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadyActor*>(this)->ActorCallback< ReadyActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< ReadyActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadyActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadyActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1202 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> f;
															#line 13952 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via ready()
															#line 1202 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1202 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ReadyActor final : public Actor<Void>, public ActorCallback< ReadyActor<T>, 0, T >, public FastAllocated<ReadyActor<T>>, public ReadyActorState<T, ReadyActor<T>> {
															#line 13959 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ReadyActor<T>>::operator new;
	using FastAllocated<ReadyActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17121753037657436928UL, 3085825721296213248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadyActor<T>, 0, T >;
															#line 1202 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ReadyActor(Future<T> const& f) 
															#line 13976 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   ReadyActorState<T, ReadyActor<T>>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6752898665744590080UL, 7355650981969264640UL);
		ActorExecutionContextHelper __helper(static_cast<ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ready");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadyActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1202 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1202 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> ready( Future<T> const& f ) {
															#line 1202 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new ReadyActor<T>(f));
															#line 14011 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1211 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 14016 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via waitAndForward()
															#line 1212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class WaitAndForwardActor>
															#line 1212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class WaitAndForwardActorState {
															#line 14023 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	WaitAndForwardActorState(FutureStream<T> const& input) 
															#line 1212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : input(input)
															#line 14030 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("waitAndForward", reinterpret_cast<unsigned long>(this));

	}
	~WaitAndForwardActorState() 
	{
		fdb_probe_actor_destroy("waitAndForward", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1214 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			FutureStream<T> __when_expr_0 = input;
															#line 1214 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<WaitAndForwardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14047 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<WaitAndForwardActor*>(this)->actor_wait_state = 1;
															#line 1214 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< WaitAndForwardActor, 0, T >*>(static_cast<WaitAndForwardActor*>(this)));
															#line 14052 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitAndForwardActorState();
		static_cast<WaitAndForwardActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& output,int loopDepth) 
	{
															#line 1215 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<WaitAndForwardActor*>(this)->SAV<T>::futures) { (void)(output); this->~WaitAndForwardActorState(); static_cast<WaitAndForwardActor*>(this)->destroy(); return 0; }
															#line 14075 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<WaitAndForwardActor*>(this)->SAV< T >::value()) T(output);
		this->~WaitAndForwardActorState();
		static_cast<WaitAndForwardActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(T && output,int loopDepth) 
	{
															#line 1215 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<WaitAndForwardActor*>(this)->SAV<T>::futures) { (void)(output); this->~WaitAndForwardActorState(); static_cast<WaitAndForwardActor*>(this)->destroy(); return 0; }
															#line 14087 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<WaitAndForwardActor*>(this)->SAV< T >::value()) T(output);
		this->~WaitAndForwardActorState();
		static_cast<WaitAndForwardActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& output,int loopDepth) 
	{
		loopDepth = a_body1cont1(output, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && output,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(output), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitAndForwardActor*>(this)->actor_wait_state > 0) static_cast<WaitAndForwardActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAndForwardActor*>(this)->ActorSingleCallback< WaitAndForwardActor, 0, T >::remove();

	}
	void a_callback_fire(ActorSingleCallback< WaitAndForwardActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("waitAndForward", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndForwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndForward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< WaitAndForwardActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("waitAndForward", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndForwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndForward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< WaitAndForwardActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("waitAndForward", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndForwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndForward", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FutureStream<T> input;
															#line 14172 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via waitAndForward()
															#line 1212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class WaitAndForwardActor final : public Actor<T>, public ActorSingleCallback< WaitAndForwardActor<T>, 0, T >, public FastAllocated<WaitAndForwardActor<T>>, public WaitAndForwardActorState<T, WaitAndForwardActor<T>> {
															#line 14179 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<WaitAndForwardActor<T>>::operator new;
	using FastAllocated<WaitAndForwardActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8264524610520886016UL, 353936307584086016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< WaitAndForwardActor<T>, 0, T >;
															#line 1212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	WaitAndForwardActor(FutureStream<T> const& input) 
															#line 14196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   WaitAndForwardActorState<T, WaitAndForwardActor<T>>(input),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitAndForward", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15555080135405258752UL, 15302585867342871040UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndForwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitAndForward");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitAndForward", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< WaitAndForwardActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> waitAndForward( FutureStream<T> const& input ) {
															#line 1212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new WaitAndForwardActor<T>(input));
															#line 14231 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1217 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 14236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via reportErrorsExcept()
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class ReportErrorsExceptActor>
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ReportErrorsExceptActorState {
															#line 14243 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ReportErrorsExceptActorState(Future<T> const& in,const char* const& context,UID const& id,std::set<int> const* const& pExceptErrors) 
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : in(in),
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   context(context),
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   id(id),
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   pExceptErrors(pExceptErrors)
															#line 14256 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("reportErrorsExcept", reinterpret_cast<unsigned long>(this));

	}
	~ReportErrorsExceptActorState() 
	{
		fdb_probe_actor_destroy("reportErrorsExcept", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1221 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = in;
															#line 1221 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<ReportErrorsExceptActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 14274 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReportErrorsExceptActor*>(this)->actor_wait_state = 1;
															#line 1221 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReportErrorsExceptActor, 0, T >*>(static_cast<ReportErrorsExceptActor*>(this)));
															#line 14279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReportErrorsExceptActorState();
		static_cast<ReportErrorsExceptActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1224 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() != error_code_actor_cancelled && (!pExceptErrors || !pExceptErrors->count(e.code())))
															#line 14309 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 1225 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				TraceEvent(SevError, context, id).error(e);
															#line 14313 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 1226 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 14317 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& t,int loopDepth) 
	{
															#line 1222 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ReportErrorsExceptActor*>(this)->SAV<T>::futures) { (void)(t); this->~ReportErrorsExceptActorState(); static_cast<ReportErrorsExceptActor*>(this)->destroy(); return 0; }
															#line 14331 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ReportErrorsExceptActor*>(this)->SAV< T >::value()) T(t);
		this->~ReportErrorsExceptActorState();
		static_cast<ReportErrorsExceptActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && t,int loopDepth) 
	{
															#line 1222 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ReportErrorsExceptActor*>(this)->SAV<T>::futures) { (void)(t); this->~ReportErrorsExceptActorState(); static_cast<ReportErrorsExceptActor*>(this)->destroy(); return 0; }
															#line 14343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ReportErrorsExceptActor*>(this)->SAV< T >::value()) T(t);
		this->~ReportErrorsExceptActorState();
		static_cast<ReportErrorsExceptActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReportErrorsExceptActor*>(this)->actor_wait_state > 0) static_cast<ReportErrorsExceptActor*>(this)->actor_wait_state = 0;
		static_cast<ReportErrorsExceptActor*>(this)->ActorCallback< ReportErrorsExceptActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< ReportErrorsExceptActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("reportErrorsExcept", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportErrorsExceptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportErrorsExcept", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReportErrorsExceptActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("reportErrorsExcept", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportErrorsExceptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportErrorsExcept", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReportErrorsExceptActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("reportErrorsExcept", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReportErrorsExceptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportErrorsExcept", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> in;
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	const char* context;
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	UID id;
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	std::set<int> const* pExceptErrors;
															#line 14434 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via reportErrorsExcept()
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ReportErrorsExceptActor final : public Actor<T>, public ActorCallback< ReportErrorsExceptActor<T>, 0, T >, public FastAllocated<ReportErrorsExceptActor<T>>, public ReportErrorsExceptActorState<T, ReportErrorsExceptActor<T>> {
															#line 14441 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ReportErrorsExceptActor<T>>::operator new;
	using FastAllocated<ReportErrorsExceptActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9715769857771498496UL, 11724053023888108032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReportErrorsExceptActor<T>, 0, T >;
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ReportErrorsExceptActor(Future<T> const& in,const char* const& context,UID const& id,std::set<int> const* const& pExceptErrors) 
															#line 14458 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   ReportErrorsExceptActorState<T, ReportErrorsExceptActor<T>>(in, context, id, pExceptErrors),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("reportErrorsExcept", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12609635902940358912UL, 5678186634594409472UL);
		ActorExecutionContextHelper __helper(static_cast<ReportErrorsExceptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("reportErrorsExcept");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("reportErrorsExcept", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReportErrorsExceptActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> reportErrorsExcept( Future<T> const& in, const char* const& context, UID const& id, std::set<int> const* const& pExceptErrors ) {
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new ReportErrorsExceptActor<T>(in, context, id, pExceptErrors));
															#line 14493 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1229 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

template <class T>
Future<T> reportErrors(Future<T> const& in, const char* context, UID id = UID()) {
	return reportErrorsExcept(in, context, id, nullptr);
}

															#line 14503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via require()
															#line 1235 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class RequireActor>
															#line 1235 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class RequireActorState {
															#line 14510 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1235 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	RequireActorState(Future<Optional<T>> const& in,int const& errorCode) 
															#line 1235 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1235 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : in(in),
															#line 1235 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   errorCode(errorCode)
															#line 14519 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("require", reinterpret_cast<unsigned long>(this));

	}
	~RequireActorState() 
	{
		fdb_probe_actor_destroy("require", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1237 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Optional<T>> __when_expr_0 = in;
															#line 1237 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<RequireActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14536 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RequireActor*>(this)->actor_wait_state = 1;
															#line 1237 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RequireActor, 0, Optional<T> >*>(static_cast<RequireActor*>(this)));
															#line 14541 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RequireActorState();
		static_cast<RequireActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<T> const& o,int loopDepth) 
	{
															#line 1238 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (o.present())
															#line 14564 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 1239 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (!static_cast<RequireActor*>(this)->SAV<T>::futures) { (void)(o.get()); this->~RequireActorState(); static_cast<RequireActor*>(this)->destroy(); return 0; }
															#line 14568 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			new (&static_cast<RequireActor*>(this)->SAV< T >::value()) T(o.get());
			this->~RequireActorState();
			static_cast<RequireActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 1241 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(Error(errorCode), loopDepth);
															#line 14578 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}

		return loopDepth;
	}
	int a_body1cont1(Optional<T> && o,int loopDepth) 
	{
															#line 1238 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (o.present())
															#line 14587 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 1239 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (!static_cast<RequireActor*>(this)->SAV<T>::futures) { (void)(o.get()); this->~RequireActorState(); static_cast<RequireActor*>(this)->destroy(); return 0; }
															#line 14591 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			new (&static_cast<RequireActor*>(this)->SAV< T >::value()) T(o.get());
			this->~RequireActorState();
			static_cast<RequireActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 1241 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(Error(errorCode), loopDepth);
															#line 14601 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}

		return loopDepth;
	}
	int a_body1when1(Optional<T> const& o,int loopDepth) 
	{
		loopDepth = a_body1cont1(o, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<T> && o,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(o), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RequireActor*>(this)->actor_wait_state > 0) static_cast<RequireActor*>(this)->actor_wait_state = 0;
		static_cast<RequireActor*>(this)->ActorCallback< RequireActor, 0, Optional<T> >::remove();

	}
	void a_callback_fire(ActorCallback< RequireActor, 0, Optional<T> >*,Optional<T> const& value) 
	{
		fdb_probe_actor_enter("require", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequireActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("require", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RequireActor, 0, Optional<T> >*,Optional<T> && value) 
	{
		fdb_probe_actor_enter("require", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequireActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("require", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RequireActor, 0, Optional<T> >*,Error err) 
	{
		fdb_probe_actor_enter("require", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RequireActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("require", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1235 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Optional<T>> in;
															#line 1235 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	int errorCode;
															#line 14685 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via require()
															#line 1235 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1235 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class RequireActor final : public Actor<T>, public ActorCallback< RequireActor<T>, 0, Optional<T> >, public FastAllocated<RequireActor<T>>, public RequireActorState<T, RequireActor<T>> {
															#line 14692 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<RequireActor<T>>::operator new;
	using FastAllocated<RequireActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15636422738380192256UL, 14492298501461416960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RequireActor<T>, 0, Optional<T> >;
															#line 1235 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	RequireActor(Future<Optional<T>> const& in,int const& errorCode) 
															#line 14709 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   RequireActorState<T, RequireActor<T>>(in, errorCode),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("require", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3343251532829389312UL, 5021012167124320256UL);
		ActorExecutionContextHelper __helper(static_cast<RequireActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("require");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("require", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RequireActor<T>, 0, Optional<T> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1235 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1235 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> require( Future<Optional<T>> const& in, int const& errorCode ) {
															#line 1235 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new RequireActor<T>(in, errorCode));
															#line 14744 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1244 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 14749 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via waitForFirst()
															#line 1245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class WaitForFirstActor>
															#line 1245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class WaitForFirstActorState {
															#line 14756 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	WaitForFirstActorState(std::vector<Future<T>> const& items) 
															#line 1245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : items(items),
															#line 1247 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   resultStream(),
															#line 1248 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   errorStream(),
															#line 1250 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   forCancellation(makeStream(items, resultStream, errorStream)),
															#line 1252 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   resultFutureStream(resultStream.getFuture()),
															#line 1253 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   errorFutureStream(errorStream.getFuture())
															#line 14773 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("waitForFirst", reinterpret_cast<unsigned long>(this));

	}
	~WaitForFirstActorState() 
	{
		fdb_probe_actor_destroy("waitForFirst", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1256 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			FutureStream<T> __when_expr_0 = resultFutureStream;
															#line 1255 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<WaitForFirstActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14790 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.pop(), loopDepth); };
															#line 1260 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			FutureStream<Error> __when_expr_1 = errorFutureStream;
															#line 14794 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.pop(), loopDepth); };
			static_cast<WaitForFirstActor*>(this)->actor_wait_state = 1;
															#line 1256 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< WaitForFirstActor, 0, T >*>(static_cast<WaitForFirstActor*>(this)));
															#line 1260 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< WaitForFirstActor, 1, Error >*>(static_cast<WaitForFirstActor*>(this)));
															#line 14801 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForFirstActorState();
		static_cast<WaitForFirstActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
															#line 1257 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		forCancellation = Future<Void>();
															#line 1258 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<WaitForFirstActor*>(this)->SAV<T>::futures) { (void)(val); this->~WaitForFirstActorState(); static_cast<WaitForFirstActor*>(this)->destroy(); return 0; }
															#line 14826 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<WaitForFirstActor*>(this)->SAV< T >::value()) T(val);
		this->~WaitForFirstActorState();
		static_cast<WaitForFirstActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
															#line 1257 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		forCancellation = Future<Void>();
															#line 1258 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<WaitForFirstActor*>(this)->SAV<T>::futures) { (void)(val); this->~WaitForFirstActorState(); static_cast<WaitForFirstActor*>(this)->destroy(); return 0; }
															#line 14840 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<WaitForFirstActor*>(this)->SAV< T >::value()) T(val);
		this->~WaitForFirstActorState();
		static_cast<WaitForFirstActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Error const& e,int loopDepth) 
	{
															#line 1261 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		forCancellation = Future<Void>();
															#line 1262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(e, loopDepth);
															#line 14854 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1when2(Error && e,int loopDepth) 
	{
															#line 1261 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		forCancellation = Future<Void>();
															#line 1262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(e, loopDepth);
															#line 14864 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForFirstActor*>(this)->actor_wait_state > 0) static_cast<WaitForFirstActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForFirstActor*>(this)->ActorSingleCallback< WaitForFirstActor, 0, T >::remove();
		static_cast<WaitForFirstActor*>(this)->ActorSingleCallback< WaitForFirstActor, 1, Error >::remove();

	}
	void a_callback_fire(ActorSingleCallback< WaitForFirstActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("waitForFirst", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForFirstActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForFirst", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< WaitForFirstActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("waitForFirst", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForFirstActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForFirst", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< WaitForFirstActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("waitForFirst", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForFirstActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForFirst", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< WaitForFirstActor, 1, Error >*,Error const& value) 
	{
		fdb_probe_actor_enter("waitForFirst", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForFirstActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForFirst", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< WaitForFirstActor, 1, Error >*,Error && value) 
	{
		fdb_probe_actor_enter("waitForFirst", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForFirstActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForFirst", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< WaitForFirstActor, 1, Error >*,Error err) 
	{
		fdb_probe_actor_enter("waitForFirst", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForFirstActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForFirst", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	std::vector<Future<T>> items;
															#line 1247 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<T> resultStream;
															#line 1248 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<Error> errorStream;
															#line 1250 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> forCancellation;
															#line 1252 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FutureStream<T> resultFutureStream;
															#line 1253 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	FutureStream<Error> errorFutureStream;
															#line 15001 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via waitForFirst()
															#line 1245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class WaitForFirstActor final : public Actor<T>, public ActorSingleCallback< WaitForFirstActor<T>, 0, T >, public ActorSingleCallback< WaitForFirstActor<T>, 1, Error >, public FastAllocated<WaitForFirstActor<T>>, public WaitForFirstActorState<T, WaitForFirstActor<T>> {
															#line 15008 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<WaitForFirstActor<T>>::operator new;
	using FastAllocated<WaitForFirstActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5858582152480899072UL, 10874185787290967296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< WaitForFirstActor<T>, 0, T >;
friend struct ActorSingleCallback< WaitForFirstActor<T>, 1, Error >;
															#line 1245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	WaitForFirstActor(std::vector<Future<T>> const& items) 
															#line 15026 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   WaitForFirstActorState<T, WaitForFirstActor<T>>(items),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForFirst", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14058904249989961216UL, 7523893242501514752UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForFirstActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForFirst");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForFirst", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< WaitForFirstActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> waitForFirst( std::vector<Future<T>> const& items ) {
															#line 1245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new WaitForFirstActor<T>(items));
															#line 15061 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1266 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 15066 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via tag()
															#line 1267 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TagActor>
															#line 1267 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagActorState {
															#line 15073 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1267 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagActorState(Future<Void> const& future,T const& what) 
															#line 1267 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1267 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : future(future),
															#line 1267 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   what(what)
															#line 15082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("tag", reinterpret_cast<unsigned long>(this));

	}
	~TagActorState() 
	{
		fdb_probe_actor_destroy("tag", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = future;
															#line 1269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<TagActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15099 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TagActor*>(this)->actor_wait_state = 1;
															#line 1269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagActor, 0, Void >*>(static_cast<TagActor*>(this)));
															#line 15104 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagActorState();
		static_cast<TagActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1270 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TagActor*>(this)->SAV<T>::futures) { (void)(what); this->~TagActorState(); static_cast<TagActor*>(this)->destroy(); return 0; }
															#line 15127 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TagActor*>(this)->SAV< T >::value()) T(std::move(what)); // state_var_RVO
		this->~TagActorState();
		static_cast<TagActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1270 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TagActor*>(this)->SAV<T>::futures) { (void)(what); this->~TagActorState(); static_cast<TagActor*>(this)->destroy(); return 0; }
															#line 15139 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TagActor*>(this)->SAV< T >::value()) T(std::move(what)); // state_var_RVO
		this->~TagActorState();
		static_cast<TagActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagActor*>(this)->actor_wait_state > 0) static_cast<TagActor*>(this)->actor_wait_state = 0;
		static_cast<TagActor*>(this)->ActorCallback< TagActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tag", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1267 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> future;
															#line 1267 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T what;
															#line 15226 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via tag()
															#line 1267 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1267 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagActor final : public Actor<T>, public ActorCallback< TagActor<T>, 0, Void >, public FastAllocated<TagActor<T>>, public TagActorState<T, TagActor<T>> {
															#line 15233 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TagActor<T>>::operator new;
	using FastAllocated<TagActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(379210393013784320UL, 12306202951991101952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagActor<T>, 0, Void >;
															#line 1267 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagActor(Future<Void> const& future,T const& what) 
															#line 15250 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   TagActorState<T, TagActor<T>>(future, what),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tag", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6074264639100469760UL, 11102663212846449920UL);
		ActorExecutionContextHelper __helper(static_cast<TagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tag");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tag", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1267 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1267 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> tag( Future<Void> const& future, T const& what ) {
															#line 1267 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new TagActor<T>(future, what));
															#line 15285 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1272 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 15290 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via tag()
															#line 1273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TagActor1>
															#line 1273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagActor1State {
															#line 15297 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagActor1State(Future<Void> const& future,T const& what,PromiseStream<T> const& stream) 
															#line 1273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : future(future),
															#line 1273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   what(what),
															#line 1273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   stream(stream)
															#line 15308 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("tag", reinterpret_cast<unsigned long>(this));

	}
	~TagActor1State() 
	{
		fdb_probe_actor_destroy("tag", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = future;
															#line 1275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<TagActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15325 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TagActor1*>(this)->actor_wait_state = 1;
															#line 1275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagActor1, 0, Void >*>(static_cast<TagActor1*>(this)));
															#line 15330 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagActor1State();
		static_cast<TagActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1276 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		stream.send(what);
															#line 1277 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TagActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TagActor1State(); static_cast<TagActor1*>(this)->destroy(); return 0; }
															#line 15355 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TagActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~TagActor1State();
		static_cast<TagActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1276 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		stream.send(what);
															#line 1277 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<TagActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TagActor1State(); static_cast<TagActor1*>(this)->destroy(); return 0; }
															#line 15369 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<TagActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~TagActor1State();
		static_cast<TagActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagActor1*>(this)->actor_wait_state > 0) static_cast<TagActor1*>(this)->actor_wait_state = 0;
		static_cast<TagActor1*>(this)->ActorCallback< TagActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tag", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> future;
															#line 1273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T what;
															#line 1273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<T> stream;
															#line 15458 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via tag()
															#line 1273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagActor1 final : public Actor<Void>, public ActorCallback< TagActor1<T>, 0, Void >, public FastAllocated<TagActor1<T>>, public TagActor1State<T, TagActor1<T>> {
															#line 15465 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TagActor1<T>>::operator new;
	using FastAllocated<TagActor1<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(379210393013784320UL, 12306202951991101952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagActor1<T>, 0, Void >;
															#line 1273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagActor1(Future<Void> const& future,T const& what,PromiseStream<T> const& stream) 
															#line 15482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   TagActor1State<T, TagActor1<T>>(future, what, stream),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tag", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2683904013079911936UL, 8793601520481839616UL);
		ActorExecutionContextHelper __helper(static_cast<TagActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tag");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tag", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagActor1<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> tag( Future<Void> const& future, T const& what, PromiseStream<T> const& stream ) {
															#line 1273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new TagActor1<T>(future, what, stream));
															#line 15517 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 15522 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via tagError()
															#line 1280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TagErrorActor>
															#line 1280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagErrorActorState {
															#line 15529 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagErrorActorState(Future<Void> const& future,Error const& e) 
															#line 1280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : future(future),
															#line 1280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   e(e)
															#line 15538 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("tagError", reinterpret_cast<unsigned long>(this));

	}
	~TagErrorActorState() 
	{
		fdb_probe_actor_destroy("tagError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = future;
															#line 1282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<TagErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15555 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TagErrorActor*>(this)->actor_wait_state = 1;
															#line 1282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagErrorActor, 0, Void >*>(static_cast<TagErrorActor*>(this)));
															#line 15560 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagErrorActorState();
		static_cast<TagErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1283 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(e, loopDepth);
															#line 15583 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1283 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(e, loopDepth);
															#line 15591 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagErrorActor*>(this)->actor_wait_state > 0) static_cast<TagErrorActor*>(this)->actor_wait_state = 0;
		static_cast<TagErrorActor*>(this)->ActorCallback< TagErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tagError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tagError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tagError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagError", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> future;
															#line 1280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Error e;
															#line 15674 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via tagError()
															#line 1280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagErrorActor final : public Actor<T>, public ActorCallback< TagErrorActor<T>, 0, Void >, public FastAllocated<TagErrorActor<T>>, public TagErrorActorState<T, TagErrorActor<T>> {
															#line 15681 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TagErrorActor<T>>::operator new;
	using FastAllocated<TagErrorActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16586007911899495680UL, 7120901949508572160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagErrorActor<T>, 0, Void >;
															#line 1280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagErrorActor(Future<Void> const& future,Error const& e) 
															#line 15698 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   TagErrorActorState<T, TagErrorActor<T>>(future, e),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tagError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11378414421076206080UL, 1160010013487977472UL);
		ActorExecutionContextHelper __helper(static_cast<TagErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tagError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tagError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagErrorActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> tagError( Future<Void> const& future, Error const& e ) {
															#line 1280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new TagErrorActor<T>(future, e));
															#line 15733 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1285 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 15738 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via detach()
															#line 1286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class DetachActor>
															#line 1286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DetachActorState {
															#line 15745 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DetachActorState(Future<T> const& f) 
															#line 1286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : f(f)
															#line 15752 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("detach", reinterpret_cast<unsigned long>(this));

	}
	~DetachActorState() 
	{
		fdb_probe_actor_destroy("detach", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1288 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = f;
															#line 1288 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<DetachActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15769 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DetachActor*>(this)->actor_wait_state = 1;
															#line 1288 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DetachActor, 0, T >*>(static_cast<DetachActor*>(this)));
															#line 15774 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DetachActorState();
		static_cast<DetachActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(T const& x,int loopDepth) 
	{
															#line 1289 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<DetachActor*>(this)->SAV<T>::futures) { (void)(x); this->~DetachActorState(); static_cast<DetachActor*>(this)->destroy(); return 0; }
															#line 15797 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<DetachActor*>(this)->SAV< T >::value()) T(x);
		this->~DetachActorState();
		static_cast<DetachActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(T && x,int loopDepth) 
	{
															#line 1289 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<DetachActor*>(this)->SAV<T>::futures) { (void)(x); this->~DetachActorState(); static_cast<DetachActor*>(this)->destroy(); return 0; }
															#line 15809 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<DetachActor*>(this)->SAV< T >::value()) T(x);
		this->~DetachActorState();
		static_cast<DetachActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& x,int loopDepth) 
	{
		loopDepth = a_body1cont1(x, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && x,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(x), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DetachActor*>(this)->actor_wait_state > 0) static_cast<DetachActor*>(this)->actor_wait_state = 0;
		static_cast<DetachActor*>(this)->ActorCallback< DetachActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< DetachActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("detach", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DetachActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("detach", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DetachActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("detach", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DetachActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("detach", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DetachActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("detach", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DetachActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("detach", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> f;
															#line 15894 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via detach()
															#line 1286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class DetachActor final : public Actor<T>, public ActorCallback< DetachActor<T>, 0, T >, public FastAllocated<DetachActor<T>>, public DetachActorState<T, DetachActor<T>> {
															#line 15901 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<DetachActor<T>>::operator new;
	using FastAllocated<DetachActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12858783931565413120UL, 4207942066575910400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DetachActor<T>, 0, T >;
															#line 1286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	DetachActor(Future<T> const& f) 
															#line 15918 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   DetachActorState<T, DetachActor<T>>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("detach", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7649208278263481856UL, 1919194672671098624UL);
		ActorExecutionContextHelper __helper(static_cast<DetachActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("detach");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("detach", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DetachActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> detach( Future<T> const& f ) {
															#line 1286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new DetachActor<T>(f));
															#line 15953 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1291 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// If the future is ready, yields and returns. Otherwise, returns when future is set.
template <class T>
Future<T> orYield(Future<T> f) {
	if (f.isReady()) {
		if (f.isError())
			return tagError<T>(yield(), f.getError());
		else
			return tag(yield(), f.get());
	} else
		return f;
}

Future<Void> orYield(Future<Void> f);

															#line 15972 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via chooseActor()
															#line 1306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class ChooseActorActor>
															#line 1306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ChooseActorActorState {
															#line 15979 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ChooseActorActorState(Future<T> const& lhs,Future<T> const& rhs) 
															#line 1306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : lhs(lhs),
															#line 1306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   rhs(rhs)
															#line 15988 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("chooseActor", reinterpret_cast<unsigned long>(this));

	}
	~ChooseActorActorState() 
	{
		fdb_probe_actor_destroy("chooseActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1309 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = lhs;
															#line 1308 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<ChooseActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16005 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1312 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_1 = rhs;
															#line 16009 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<ChooseActorActor*>(this)->actor_wait_state = 1;
															#line 1309 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChooseActorActor, 0, T >*>(static_cast<ChooseActorActor*>(this)));
															#line 1312 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChooseActorActor, 1, T >*>(static_cast<ChooseActorActor*>(this)));
															#line 16016 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChooseActorActorState();
		static_cast<ChooseActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
															#line 1310 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ChooseActorActor*>(this)->SAV<T>::futures) { (void)(t); this->~ChooseActorActorState(); static_cast<ChooseActorActor*>(this)->destroy(); return 0; }
															#line 16039 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ChooseActorActor*>(this)->SAV< T >::value()) T(t);
		this->~ChooseActorActorState();
		static_cast<ChooseActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
															#line 1310 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ChooseActorActor*>(this)->SAV<T>::futures) { (void)(t); this->~ChooseActorActorState(); static_cast<ChooseActorActor*>(this)->destroy(); return 0; }
															#line 16051 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ChooseActorActor*>(this)->SAV< T >::value()) T(t);
		this->~ChooseActorActorState();
		static_cast<ChooseActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(T const& t,int loopDepth) 
	{
															#line 1313 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ChooseActorActor*>(this)->SAV<T>::futures) { (void)(t); this->~ChooseActorActorState(); static_cast<ChooseActorActor*>(this)->destroy(); return 0; }
															#line 16063 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ChooseActorActor*>(this)->SAV< T >::value()) T(t);
		this->~ChooseActorActorState();
		static_cast<ChooseActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(T && t,int loopDepth) 
	{
															#line 1313 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ChooseActorActor*>(this)->SAV<T>::futures) { (void)(t); this->~ChooseActorActorState(); static_cast<ChooseActorActor*>(this)->destroy(); return 0; }
															#line 16075 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ChooseActorActor*>(this)->SAV< T >::value()) T(t);
		this->~ChooseActorActorState();
		static_cast<ChooseActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChooseActorActor*>(this)->actor_wait_state > 0) static_cast<ChooseActorActor*>(this)->actor_wait_state = 0;
		static_cast<ChooseActorActor*>(this)->ActorCallback< ChooseActorActor, 0, T >::remove();
		static_cast<ChooseActorActor*>(this)->ActorCallback< ChooseActorActor, 1, T >::remove();

	}
	void a_callback_fire(ActorCallback< ChooseActorActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("chooseActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChooseActorActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("chooseActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChooseActorActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("chooseActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChooseActorActor, 1, T >*,T const& value) 
	{
		fdb_probe_actor_enter("chooseActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChooseActorActor, 1, T >*,T && value) 
	{
		fdb_probe_actor_enter("chooseActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChooseActorActor, 1, T >*,Error err) 
	{
		fdb_probe_actor_enter("chooseActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> lhs;
															#line 1306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> rhs;
															#line 16208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via chooseActor()
															#line 1306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ChooseActorActor final : public Actor<T>, public ActorCallback< ChooseActorActor<T>, 0, T >, public ActorCallback< ChooseActorActor<T>, 1, T >, public FastAllocated<ChooseActorActor<T>>, public ChooseActorActorState<T, ChooseActorActor<T>> {
															#line 16215 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ChooseActorActor<T>>::operator new;
	using FastAllocated<ChooseActorActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10001281160685536256UL, 15682213087112138240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChooseActorActor<T>, 0, T >;
friend struct ActorCallback< ChooseActorActor<T>, 1, T >;
															#line 1306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ChooseActorActor(Future<T> const& lhs,Future<T> const& rhs) 
															#line 16233 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   ChooseActorActorState<T, ChooseActorActor<T>>(lhs, rhs),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("chooseActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3951223725334214400UL, 8219181030228943104UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("chooseActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("chooseActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChooseActorActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> chooseActor( Future<T> const& lhs, Future<T> const& rhs ) {
															#line 1306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new ChooseActorActor<T>(lhs, rhs));
															#line 16268 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1317 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// set && set -> set
// error && x -> error
// all others -> unset
inline Future<Void> operator&&(Future<Void> const& lhs, Future<Void> const& rhs) {
	if (lhs.isReady()) {
		if (lhs.isError())
			return lhs;
		else
			return rhs;
	}
	if (rhs.isReady()) {
		if (rhs.isError())
			return rhs;
		else
			return lhs;
	}

	Future<Void> x[] = { lhs, rhs };
	return quorum(x, 2, 2);
}

// error || unset -> error
// unset || unset -> unset
// all others -> set
inline Future<Void> operator||(Future<Void> const& lhs, Future<Void> const& rhs) {
	if (lhs.isReady()) {
		if (lhs.isError())
			return lhs;
		if (rhs.isReady())
			return rhs;
		return lhs;
	}

	return chooseActor(lhs, rhs);
}

															#line 16309 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via joinWith()
															#line 1354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class JoinWithActor>
															#line 1354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class JoinWithActorState {
															#line 16316 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	JoinWithActorState(Future<T> const& f,Future<Void> const& other) 
															#line 1354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : f(f),
															#line 1354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   other(other)
															#line 16325 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("joinWith", reinterpret_cast<unsigned long>(this));

	}
	~JoinWithActorState() 
	{
		fdb_probe_actor_destroy("joinWith", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1356 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = other;
															#line 1356 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<JoinWithActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16342 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<JoinWithActor*>(this)->actor_wait_state = 1;
															#line 1356 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< JoinWithActor, 0, Void >*>(static_cast<JoinWithActor*>(this)));
															#line 16347 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~JoinWithActorState();
		static_cast<JoinWithActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<T> __when_expr_1 = f;
															#line 1357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<JoinWithActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16372 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<JoinWithActor*>(this)->actor_wait_state = 2;
															#line 1357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< JoinWithActor, 1, T >*>(static_cast<JoinWithActor*>(this)));
															#line 16377 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<T> __when_expr_1 = f;
															#line 1357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<JoinWithActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16388 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<JoinWithActor*>(this)->actor_wait_state = 2;
															#line 1357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< JoinWithActor, 1, T >*>(static_cast<JoinWithActor*>(this)));
															#line 16393 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<JoinWithActor*>(this)->actor_wait_state > 0) static_cast<JoinWithActor*>(this)->actor_wait_state = 0;
		static_cast<JoinWithActor*>(this)->ActorCallback< JoinWithActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< JoinWithActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("joinWith", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<JoinWithActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("joinWith", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< JoinWithActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("joinWith", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<JoinWithActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("joinWith", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< JoinWithActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("joinWith", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<JoinWithActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("joinWith", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(T const& t,int loopDepth) 
	{
															#line 1358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<JoinWithActor*>(this)->SAV<T>::futures) { (void)(t); this->~JoinWithActorState(); static_cast<JoinWithActor*>(this)->destroy(); return 0; }
															#line 16477 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<JoinWithActor*>(this)->SAV< T >::value()) T(t);
		this->~JoinWithActorState();
		static_cast<JoinWithActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && t,int loopDepth) 
	{
															#line 1358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<JoinWithActor*>(this)->SAV<T>::futures) { (void)(t); this->~JoinWithActorState(); static_cast<JoinWithActor*>(this)->destroy(); return 0; }
															#line 16489 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<JoinWithActor*>(this)->SAV< T >::value()) T(t);
		this->~JoinWithActorState();
		static_cast<JoinWithActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<JoinWithActor*>(this)->actor_wait_state > 0) static_cast<JoinWithActor*>(this)->actor_wait_state = 0;
		static_cast<JoinWithActor*>(this)->ActorCallback< JoinWithActor, 1, T >::remove();

	}
	void a_callback_fire(ActorCallback< JoinWithActor, 1, T >*,T const& value) 
	{
		fdb_probe_actor_enter("joinWith", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<JoinWithActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("joinWith", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< JoinWithActor, 1, T >*,T && value) 
	{
		fdb_probe_actor_enter("joinWith", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<JoinWithActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("joinWith", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< JoinWithActor, 1, T >*,Error err) 
	{
		fdb_probe_actor_enter("joinWith", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<JoinWithActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("joinWith", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> f;
															#line 1354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> other;
															#line 16576 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via joinWith()
															#line 1354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class JoinWithActor final : public Actor<T>, public ActorCallback< JoinWithActor<T>, 0, Void >, public ActorCallback< JoinWithActor<T>, 1, T >, public FastAllocated<JoinWithActor<T>>, public JoinWithActorState<T, JoinWithActor<T>> {
															#line 16583 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<JoinWithActor<T>>::operator new;
	using FastAllocated<JoinWithActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11250119344954890752UL, 11841550137395630080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< JoinWithActor<T>, 0, Void >;
friend struct ActorCallback< JoinWithActor<T>, 1, T >;
															#line 1354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	JoinWithActor(Future<T> const& f,Future<Void> const& other) 
															#line 16601 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   JoinWithActorState<T, JoinWithActor<T>>(f, other),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("joinWith", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12766439481480399360UL, 5505299843723195904UL);
		ActorExecutionContextHelper __helper(static_cast<JoinWithActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("joinWith");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("joinWith", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< JoinWithActor<T>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< JoinWithActor<T>, 1, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> joinWith( Future<T> const& f, Future<Void> const& other ) {
															#line 1354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new JoinWithActor<T>(f, other));
															#line 16637 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1360 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// wait <interval> then call what() in a loop forever
															#line 16643 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via recurring()
															#line 1362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func, class RecurringActor>
															#line 1362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class RecurringActorState {
															#line 16650 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	RecurringActorState(Func const& what,double const& interval,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 1362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : what(what),
															#line 1362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   interval(interval),
															#line 1362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   taskID(taskID)
															#line 16661 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("recurring", reinterpret_cast<unsigned long>(this));

	}
	~RecurringActorState() 
	{
		fdb_probe_actor_destroy("recurring", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1364 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 16676 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecurringActorState();
		static_cast<RecurringActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1365 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_0 = delay(interval, taskID);
															#line 1364 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<RecurringActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16708 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RecurringActor*>(this)->actor_wait_state = 1;
															#line 1365 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecurringActor, 0, Void >*>(static_cast<RecurringActor*>(this)));
															#line 16713 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1366 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		what();
															#line 16728 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1366 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		what();
															#line 16737 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecurringActor*>(this)->actor_wait_state > 0) static_cast<RecurringActor*>(this)->actor_wait_state = 0;
		static_cast<RecurringActor*>(this)->ActorCallback< RecurringActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecurringActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recurring", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurring", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecurringActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recurring", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurring", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecurringActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recurring", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurring", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Func what;
															#line 1362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double interval;
															#line 1362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TaskPriority taskID;
															#line 16811 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via recurring()
															#line 1362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func>
															#line 1362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class RecurringActor final : public Actor<Void>, public ActorCallback< RecurringActor<Func>, 0, Void >, public FastAllocated<RecurringActor<Func>>, public RecurringActorState<Func, RecurringActor<Func>> {
															#line 16818 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<RecurringActor<Func>>::operator new;
	using FastAllocated<RecurringActor<Func>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3111427738137824768UL, 775471538643095040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecurringActor<Func>, 0, Void >;
															#line 1362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	RecurringActor(Func const& what,double const& interval,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 16835 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   RecurringActorState<Func, RecurringActor<Func>>(what, interval, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recurring", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17537664105049190144UL, 15623275426293941504UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recurring");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recurring", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecurringActor<Func>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func>
															#line 1362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> recurring( Func const& what, double const& interval, TaskPriority const& taskID = TaskPriority::DefaultDelay ) {
															#line 1362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new RecurringActor<Func>(what, interval, taskID));
															#line 16870 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1370 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 16875 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via checkUntil()
															#line 1371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func, class CheckUntilActor>
															#line 1371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class CheckUntilActorState {
															#line 16882 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	CheckUntilActorState(double const& checkInterval,Func const& f,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 1371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : checkInterval(checkInterval),
															#line 1371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   f(f),
															#line 1371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   taskID(taskID)
															#line 16893 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("checkUntil", reinterpret_cast<unsigned long>(this));

	}
	~CheckUntilActorState() 
	{
		fdb_probe_actor_destroy("checkUntil", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1373 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			;
															#line 16908 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckUntilActorState();
		static_cast<CheckUntilActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1374 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		StrictFuture<Void> __when_expr_0 = delay(checkInterval, taskID);
															#line 1374 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (static_cast<CheckUntilActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16940 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CheckUntilActor*>(this)->actor_wait_state = 1;
															#line 1374 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckUntilActor, 0, Void >*>(static_cast<CheckUntilActor*>(this)));
															#line 16945 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1375 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (f())
															#line 16954 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 1376 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (!static_cast<CheckUntilActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckUntilActorState(); static_cast<CheckUntilActor*>(this)->destroy(); return 0; }
															#line 16958 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			new (&static_cast<CheckUntilActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckUntilActorState();
			static_cast<CheckUntilActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1375 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (f())
															#line 16972 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 1376 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (!static_cast<CheckUntilActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckUntilActorState(); static_cast<CheckUntilActor*>(this)->destroy(); return 0; }
															#line 16976 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			new (&static_cast<CheckUntilActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckUntilActorState();
			static_cast<CheckUntilActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckUntilActor*>(this)->actor_wait_state > 0) static_cast<CheckUntilActor*>(this)->actor_wait_state = 0;
		static_cast<CheckUntilActor*>(this)->ActorCallback< CheckUntilActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckUntilActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkUntil", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUntilActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUntil", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckUntilActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkUntil", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUntilActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUntil", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckUntilActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkUntil", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUntilActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUntil", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double checkInterval;
															#line 1371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Func f;
															#line 1371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TaskPriority taskID;
															#line 17067 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via checkUntil()
															#line 1371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func>
															#line 1371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class CheckUntilActor final : public Actor<Void>, public ActorCallback< CheckUntilActor<Func>, 0, Void >, public FastAllocated<CheckUntilActor<Func>>, public CheckUntilActorState<Func, CheckUntilActor<Func>> {
															#line 17074 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<CheckUntilActor<Func>>::operator new;
	using FastAllocated<CheckUntilActor<Func>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2532779073772119552UL, 7310843645616536576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckUntilActor<Func>, 0, Void >;
															#line 1371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	CheckUntilActor(double const& checkInterval,Func const& f,TaskPriority const& taskID = TaskPriority::DefaultDelay) 
															#line 17091 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   CheckUntilActorState<Func, CheckUntilActor<Func>>(checkInterval, f, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkUntil", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3726734547380598272UL, 1424042254037488128UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUntilActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkUntil");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkUntil", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckUntilActor<Func>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class Func>
															#line 1371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> checkUntil( double const& checkInterval, Func const& f, TaskPriority const& taskID = TaskPriority::DefaultDelay ) {
															#line 1371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new CheckUntilActor<Func>(checkInterval, f, taskID));
															#line 17126 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1379 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// Invoke actorFunc() forever in a loop
// At least wait<interval> between two actor functor invocations
															#line 17133 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via recurringAsync()
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class F, class RecurringAsyncActor>
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class RecurringAsyncActorState {
															#line 17140 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	RecurringAsyncActorState(F const& actorFunc,double const& interval,bool const& absoluteIntervalDelay,double const& initialDelay,TaskPriority const& taskID = TaskPriority::DefaultDelay,bool const& jittered = false) 
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : actorFunc(actorFunc),
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   interval(interval),
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   absoluteIntervalDelay(absoluteIntervalDelay),
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   initialDelay(initialDelay),
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   taskID(taskID),
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   jittered(jittered)
															#line 17157 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("recurringAsync", reinterpret_cast<unsigned long>(this));

	}
	~RecurringAsyncActorState() 
	{
		fdb_probe_actor_destroy("recurringAsync", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1395 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = delay(initialDelay);
															#line 1395 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17174 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 1;
															#line 1395 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecurringAsyncActor, 0, Void >*>(static_cast<RecurringAsyncActor*>(this)));
															#line 17179 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecurringAsyncActorState();
		static_cast<RecurringAsyncActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1397 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		val = Future<Void>();
															#line 1399 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		;
															#line 17204 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1397 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		val = Future<Void>();
															#line 1399 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		;
															#line 17215 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state > 0) static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RecurringAsyncActor*>(this)->ActorCallback< RecurringAsyncActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecurringAsyncActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1400 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		val = actorFunc();
															#line 1402 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (absoluteIntervalDelay)
															#line 17308 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 1403 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = val;
															#line 1403 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17314 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 2;
															#line 1403 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RecurringAsyncActor, 1, Void >*>(static_cast<RecurringAsyncActor*>(this)));
															#line 17319 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 1414 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (jittered)
															#line 17326 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 1415 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<Void> __when_expr_4 = val && delayJittered(interval);
															#line 1415 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17332 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_4.get(), loopDepth); };
				static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 5;
															#line 1415 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RecurringAsyncActor, 4, Void >*>(static_cast<RecurringAsyncActor*>(this)));
															#line 17337 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			else
			{
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<Void> __when_expr_5 = val && delay(interval);
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17346 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when3(__when_expr_5.get(), loopDepth); };
				static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 6;
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RecurringAsyncActor, 5, Void >*>(static_cast<RecurringAsyncActor*>(this)));
															#line 17351 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1405 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (jittered)
															#line 17368 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 1406 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_2 = delayJittered(interval);
															#line 1406 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17374 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 3;
															#line 1406 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecurringAsyncActor, 2, Void >*>(static_cast<RecurringAsyncActor*>(this)));
															#line 17379 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 1408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_3 = delay(interval);
															#line 1408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17388 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2when2(__when_expr_3.get(), loopDepth); };
			static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 4;
															#line 1408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RecurringAsyncActor, 3, Void >*>(static_cast<RecurringAsyncActor*>(this)));
															#line 17393 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1405 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (jittered)
															#line 17403 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		{
															#line 1406 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_2 = delayJittered(interval);
															#line 1406 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17409 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 3;
															#line 1406 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecurringAsyncActor, 2, Void >*>(static_cast<RecurringAsyncActor*>(this)));
															#line 17414 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 1408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_3 = delay(interval);
															#line 1408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17423 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2when2(__when_expr_3.get(), loopDepth); };
			static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 4;
															#line 1408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RecurringAsyncActor, 3, Void >*>(static_cast<RecurringAsyncActor*>(this)));
															#line 17428 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state > 0) static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RecurringAsyncActor*>(this)->ActorCallback< RecurringAsyncActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RecurringAsyncActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state > 0) static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RecurringAsyncActor*>(this)->ActorCallback< RecurringAsyncActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RecurringAsyncActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state > 0) static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RecurringAsyncActor*>(this)->ActorCallback< RecurringAsyncActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RecurringAsyncActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state > 0) static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RecurringAsyncActor*>(this)->ActorCallback< RecurringAsyncActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RecurringAsyncActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RecurringAsyncActor*>(this)->actor_wait_state > 0) static_cast<RecurringAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RecurringAsyncActor*>(this)->ActorCallback< RecurringAsyncActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RecurringAsyncActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RecurringAsyncActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	F actorFunc;
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double interval;
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	bool absoluteIntervalDelay;
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	double initialDelay;
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TaskPriority taskID;
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	bool jittered;
															#line 1397 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> val;
															#line 17883 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via recurringAsync()
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class F>
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class RecurringAsyncActor final : public Actor<Void>, public ActorCallback< RecurringAsyncActor<F>, 0, Void >, public ActorCallback< RecurringAsyncActor<F>, 1, Void >, public ActorCallback< RecurringAsyncActor<F>, 2, Void >, public ActorCallback< RecurringAsyncActor<F>, 3, Void >, public ActorCallback< RecurringAsyncActor<F>, 4, Void >, public ActorCallback< RecurringAsyncActor<F>, 5, Void >, public FastAllocated<RecurringAsyncActor<F>>, public RecurringAsyncActorState<F, RecurringAsyncActor<F>> {
															#line 17890 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<RecurringAsyncActor<F>>::operator new;
	using FastAllocated<RecurringAsyncActor<F>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4236020594053434624UL, 6425204368792848128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecurringAsyncActor<F>, 0, Void >;
friend struct ActorCallback< RecurringAsyncActor<F>, 1, Void >;
friend struct ActorCallback< RecurringAsyncActor<F>, 2, Void >;
friend struct ActorCallback< RecurringAsyncActor<F>, 3, Void >;
friend struct ActorCallback< RecurringAsyncActor<F>, 4, Void >;
friend struct ActorCallback< RecurringAsyncActor<F>, 5, Void >;
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	RecurringAsyncActor(F const& actorFunc,double const& interval,bool const& absoluteIntervalDelay,double const& initialDelay,TaskPriority const& taskID = TaskPriority::DefaultDelay,bool const& jittered = false) 
															#line 17912 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<Void>(),
		   RecurringAsyncActorState<F, RecurringAsyncActor<F>>(actorFunc, interval, absoluteIntervalDelay, initialDelay, taskID, jittered),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recurringAsync", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3697511342910172928UL, 10359590383790180096UL);
		ActorExecutionContextHelper __helper(static_cast<RecurringAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recurringAsync");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recurringAsync", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecurringAsyncActor<F>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RecurringAsyncActor<F>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RecurringAsyncActor<F>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RecurringAsyncActor<F>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RecurringAsyncActor<F>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RecurringAsyncActor<F>, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class F>
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<Void> recurringAsync( F const& actorFunc, double const& interval, bool const& absoluteIntervalDelay, double const& initialDelay, TaskPriority const& taskID = TaskPriority::DefaultDelay, bool const& jittered = false ) {
															#line 1382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<Void>(new RecurringAsyncActor<F>(actorFunc, interval, absoluteIntervalDelay, initialDelay, taskID, jittered));
															#line 17952 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 17957 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via brokenPromiseToNever()
															#line 1423 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class BrokenPromiseToNeverActor>
															#line 1423 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class BrokenPromiseToNeverActorState {
															#line 17964 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1423 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	BrokenPromiseToNeverActorState(Future<T> const& in) 
															#line 1423 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1423 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : in(in)
															#line 17971 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("brokenPromiseToNever", reinterpret_cast<unsigned long>(this));

	}
	~BrokenPromiseToNeverActorState() 
	{
		fdb_probe_actor_destroy("brokenPromiseToNever", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1426 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = in;
															#line 1426 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<BrokenPromiseToNeverActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 17989 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BrokenPromiseToNeverActor*>(this)->actor_wait_state = 1;
															#line 1426 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BrokenPromiseToNeverActor, 0, T >*>(static_cast<BrokenPromiseToNeverActor*>(this)));
															#line 17994 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BrokenPromiseToNeverActorState();
		static_cast<BrokenPromiseToNeverActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1429 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() != error_code_broken_promise)
															#line 18024 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 1430 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(e, loopDepth);
															#line 18028 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 1431 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = Never();
															#line 1431 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<BrokenPromiseToNeverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18034 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_1.get(), loopDepth); };
			static_cast<BrokenPromiseToNeverActor*>(this)->actor_wait_state = 2;
															#line 1431 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BrokenPromiseToNeverActor, 1, Void >*>(static_cast<BrokenPromiseToNeverActor*>(this)));
															#line 18039 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& t,int loopDepth) 
	{
															#line 1427 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<BrokenPromiseToNeverActor*>(this)->SAV<T>::futures) { (void)(t); this->~BrokenPromiseToNeverActorState(); static_cast<BrokenPromiseToNeverActor*>(this)->destroy(); return 0; }
															#line 18054 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<BrokenPromiseToNeverActor*>(this)->SAV< T >::value()) T(t);
		this->~BrokenPromiseToNeverActorState();
		static_cast<BrokenPromiseToNeverActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && t,int loopDepth) 
	{
															#line 1427 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<BrokenPromiseToNeverActor*>(this)->SAV<T>::futures) { (void)(t); this->~BrokenPromiseToNeverActorState(); static_cast<BrokenPromiseToNeverActor*>(this)->destroy(); return 0; }
															#line 18066 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<BrokenPromiseToNeverActor*>(this)->SAV< T >::value()) T(t);
		this->~BrokenPromiseToNeverActorState();
		static_cast<BrokenPromiseToNeverActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BrokenPromiseToNeverActor*>(this)->actor_wait_state > 0) static_cast<BrokenPromiseToNeverActor*>(this)->actor_wait_state = 0;
		static_cast<BrokenPromiseToNeverActor*>(this)->ActorCallback< BrokenPromiseToNeverActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< BrokenPromiseToNeverActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BrokenPromiseToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BrokenPromiseToNeverActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BrokenPromiseToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BrokenPromiseToNeverActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BrokenPromiseToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
															#line 1432 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 18153 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
															#line 1432 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 18161 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BrokenPromiseToNeverActor*>(this)->actor_wait_state > 0) static_cast<BrokenPromiseToNeverActor*>(this)->actor_wait_state = 0;
		static_cast<BrokenPromiseToNeverActor*>(this)->ActorCallback< BrokenPromiseToNeverActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BrokenPromiseToNeverActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BrokenPromiseToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BrokenPromiseToNeverActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BrokenPromiseToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BrokenPromiseToNeverActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BrokenPromiseToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1423 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> in;
															#line 18242 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via brokenPromiseToNever()
															#line 1423 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1423 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class BrokenPromiseToNeverActor final : public Actor<T>, public ActorCallback< BrokenPromiseToNeverActor<T>, 0, T >, public ActorCallback< BrokenPromiseToNeverActor<T>, 1, Void >, public FastAllocated<BrokenPromiseToNeverActor<T>>, public BrokenPromiseToNeverActorState<T, BrokenPromiseToNeverActor<T>> {
															#line 18249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<BrokenPromiseToNeverActor<T>>::operator new;
	using FastAllocated<BrokenPromiseToNeverActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4131593623157210880UL, 1388069510416474368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BrokenPromiseToNeverActor<T>, 0, T >;
friend struct ActorCallback< BrokenPromiseToNeverActor<T>, 1, Void >;
															#line 1423 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	BrokenPromiseToNeverActor(Future<T> const& in) 
															#line 18267 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   BrokenPromiseToNeverActorState<T, BrokenPromiseToNeverActor<T>>(in),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6020187088966151168UL, 5859802100040342784UL);
		ActorExecutionContextHelper __helper(static_cast<BrokenPromiseToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("brokenPromiseToNever");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("brokenPromiseToNever", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BrokenPromiseToNeverActor<T>, 0, T >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BrokenPromiseToNeverActor<T>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1423 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1423 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> brokenPromiseToNever( Future<T> const& in ) {
															#line 1423 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new BrokenPromiseToNeverActor<T>(in));
															#line 18303 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1435 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 18308 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via brokenPromiseToMaybeDelivered()
															#line 1436 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class BrokenPromiseToMaybeDeliveredActor>
															#line 1436 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class BrokenPromiseToMaybeDeliveredActorState {
															#line 18315 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1436 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	BrokenPromiseToMaybeDeliveredActorState(Future<T> const& in) 
															#line 1436 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1436 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : in(in)
															#line 18322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this));

	}
	~BrokenPromiseToMaybeDeliveredActorState() 
	{
		fdb_probe_actor_destroy("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = in;
															#line 1439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 18340 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->actor_wait_state = 1;
															#line 1439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BrokenPromiseToMaybeDeliveredActor, 0, T >*>(static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)));
															#line 18345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BrokenPromiseToMaybeDeliveredActorState();
		static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1442 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (e.code() == error_code_broken_promise)
															#line 18375 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			{
															#line 1443 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				return a_body1Catch1(request_maybe_delivered(), loopDepth);
															#line 18379 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			}
															#line 1445 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 18383 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& t,int loopDepth) 
	{
															#line 1440 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->SAV<T>::futures) { (void)(t); this->~BrokenPromiseToMaybeDeliveredActorState(); static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->destroy(); return 0; }
															#line 18397 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->SAV< T >::value()) T(t);
		this->~BrokenPromiseToMaybeDeliveredActorState();
		static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && t,int loopDepth) 
	{
															#line 1440 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->SAV<T>::futures) { (void)(t); this->~BrokenPromiseToMaybeDeliveredActorState(); static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->destroy(); return 0; }
															#line 18409 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->SAV< T >::value()) T(t);
		this->~BrokenPromiseToMaybeDeliveredActorState();
		static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->actor_wait_state > 0) static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->actor_wait_state = 0;
		static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->ActorCallback< BrokenPromiseToMaybeDeliveredActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< BrokenPromiseToMaybeDeliveredActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BrokenPromiseToMaybeDeliveredActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BrokenPromiseToMaybeDeliveredActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1436 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> in;
															#line 18494 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via brokenPromiseToMaybeDelivered()
															#line 1436 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1436 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class BrokenPromiseToMaybeDeliveredActor final : public Actor<T>, public ActorCallback< BrokenPromiseToMaybeDeliveredActor<T>, 0, T >, public FastAllocated<BrokenPromiseToMaybeDeliveredActor<T>>, public BrokenPromiseToMaybeDeliveredActorState<T, BrokenPromiseToMaybeDeliveredActor<T>> {
															#line 18501 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<BrokenPromiseToMaybeDeliveredActor<T>>::operator new;
	using FastAllocated<BrokenPromiseToMaybeDeliveredActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12243937286155042304UL, 1350179637943470336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BrokenPromiseToMaybeDeliveredActor<T>, 0, T >;
															#line 1436 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	BrokenPromiseToMaybeDeliveredActor(Future<T> const& in) 
															#line 18518 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   BrokenPromiseToMaybeDeliveredActorState<T, BrokenPromiseToMaybeDeliveredActor<T>>(in),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13077679040336365824UL, 12545640751545721088UL);
		ActorExecutionContextHelper __helper(static_cast<BrokenPromiseToMaybeDeliveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("brokenPromiseToMaybeDelivered");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("brokenPromiseToMaybeDelivered", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BrokenPromiseToMaybeDeliveredActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1436 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1436 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> brokenPromiseToMaybeDelivered( Future<T> const& in ) {
															#line 1436 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new BrokenPromiseToMaybeDeliveredActor<T>(in));
															#line 18553 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1448 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 18558 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via tagAndForward()
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class U, class TagAndForwardActor>
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagAndForwardActorState {
															#line 18565 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagAndForwardActorState(Promise<T>* const& pOutputPromise,U const& value,Future<Void> const& signal) 
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : pOutputPromise(pOutputPromise),
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   value(value),
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   signal(signal),
															#line 1451 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   out(std::move(*pOutputPromise))
															#line 18578 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("tagAndForward", reinterpret_cast<unsigned long>(this));

	}
	~TagAndForwardActorState() 
	{
		fdb_probe_actor_destroy("tagAndForward", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1452 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = signal;
															#line 1452 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 18595 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			static_cast<TagAndForwardActor*>(this)->actor_wait_state = 1;
															#line 1452 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagAndForwardActor, 0, Void >*>(static_cast<TagAndForwardActor*>(this)));
															#line 18599 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<TagAndForwardActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1453 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		out.send(std::move(value));
															#line 18621 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1453 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		out.send(std::move(value));
															#line 18630 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagAndForwardActor*>(this)->actor_wait_state > 0) static_cast<TagAndForwardActor*>(this)->actor_wait_state = 0;
		static_cast<TagAndForwardActor*>(this)->ActorCallback< TagAndForwardActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagAndForwardActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tagAndForward", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagAndForwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagAndForwardActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tagAndForward", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagAndForwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagAndForwardActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tagAndForward", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagAndForwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForward", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		delete static_cast<TagAndForwardActor*>(this);
															#line 18714 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		return 0;

		return loopDepth;
	}
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Promise<T>* pOutputPromise;
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	U value;
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> signal;
															#line 1451 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Promise<T> out;
															#line 18727 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via tagAndForward()
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class U>
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagAndForwardActor final : public Actor<void>, public ActorCallback< TagAndForwardActor<T, U>, 0, Void >, public FastAllocated<TagAndForwardActor<T, U>>, public TagAndForwardActorState<T, U, TagAndForwardActor<T, U>> {
															#line 18734 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TagAndForwardActor<T, U>>::operator new;
	using FastAllocated<TagAndForwardActor<T, U>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3792499563208043776UL, 16769956219672708608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< TagAndForwardActor<T, U>, 0, Void >;
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagAndForwardActor(Promise<T>* const& pOutputPromise,U const& value,Future<Void> const& signal) 
															#line 18751 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<void>(),
		   TagAndForwardActorState<T, U, TagAndForwardActor<T, U>>(pOutputPromise, value, signal),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tagAndForward", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14651556149279548928UL, 10927429797465589760UL);
		ActorExecutionContextHelper __helper(static_cast<TagAndForwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tagAndForward");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tagAndForward", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class U>
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
void tagAndForward( Promise<T>* const& pOutputPromise, U const& value, Future<Void> const& signal ) {
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	new TagAndForwardActor<T, U>(pOutputPromise, value, signal);
															#line 18777 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1455 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 18782 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via tagAndForward()
															#line 1456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TagAndForwardActor1>
															#line 1456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagAndForwardActor1State {
															#line 18789 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagAndForwardActor1State(PromiseStream<T>* const& pOutput,T const& value,Future<Void> const& signal) 
															#line 1456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : pOutput(pOutput),
															#line 1456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   value(value),
															#line 1456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   signal(signal)
															#line 18800 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("tagAndForward", reinterpret_cast<unsigned long>(this));

	}
	~TagAndForwardActor1State() 
	{
		fdb_probe_actor_destroy("tagAndForward", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1458 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = signal;
															#line 1458 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 18817 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			static_cast<TagAndForwardActor1*>(this)->actor_wait_state = 1;
															#line 1458 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagAndForwardActor1, 0, Void >*>(static_cast<TagAndForwardActor1*>(this)));
															#line 18821 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<TagAndForwardActor1*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		pOutput->send(std::move(value));
															#line 18843 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		pOutput->send(std::move(value));
															#line 18852 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagAndForwardActor1*>(this)->actor_wait_state > 0) static_cast<TagAndForwardActor1*>(this)->actor_wait_state = 0;
		static_cast<TagAndForwardActor1*>(this)->ActorCallback< TagAndForwardActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagAndForwardActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tagAndForward", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagAndForwardActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagAndForwardActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tagAndForward", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagAndForwardActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagAndForwardActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tagAndForward", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagAndForwardActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForward", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		delete static_cast<TagAndForwardActor1*>(this);
															#line 18936 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		return 0;

		return loopDepth;
	}
															#line 1456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<T>* pOutput;
															#line 1456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	T value;
															#line 1456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> signal;
															#line 18947 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via tagAndForward()
															#line 1456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagAndForwardActor1 final : public Actor<void>, public ActorCallback< TagAndForwardActor1<T>, 0, Void >, public FastAllocated<TagAndForwardActor1<T>>, public TagAndForwardActor1State<T, TagAndForwardActor1<T>> {
															#line 18954 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TagAndForwardActor1<T>>::operator new;
	using FastAllocated<TagAndForwardActor1<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3792499563208043776UL, 16769956219672708608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< TagAndForwardActor1<T>, 0, Void >;
															#line 1456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagAndForwardActor1(PromiseStream<T>* const& pOutput,T const& value,Future<Void> const& signal) 
															#line 18971 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<void>(),
		   TagAndForwardActor1State<T, TagAndForwardActor1<T>>(pOutput, value, signal),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tagAndForward", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8459484032539578624UL, 15900337457436081664UL);
		ActorExecutionContextHelper __helper(static_cast<TagAndForwardActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tagAndForward");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tagAndForward", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 1456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
void tagAndForward( PromiseStream<T>* const& pOutput, T const& value, Future<Void> const& signal ) {
															#line 1456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	new TagAndForwardActor1<T>(pOutput, value, signal);
															#line 18997 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1461 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 19002 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via tagAndForwardError()
															#line 1462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TagAndForwardErrorActor>
															#line 1462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagAndForwardErrorActorState {
															#line 19009 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagAndForwardErrorActorState(Promise<T>* const& pOutputPromise,Error const& value,Future<Void> const& signal) 
															#line 1462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : pOutputPromise(pOutputPromise),
															#line 1462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   value(value),
															#line 1462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   signal(signal),
															#line 1464 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   out(std::move(*pOutputPromise))
															#line 19022 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("tagAndForwardError", reinterpret_cast<unsigned long>(this));

	}
	~TagAndForwardErrorActorState() 
	{
		fdb_probe_actor_destroy("tagAndForwardError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1465 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = signal;
															#line 1465 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 19039 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			static_cast<TagAndForwardErrorActor*>(this)->actor_wait_state = 1;
															#line 1465 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagAndForwardErrorActor, 0, Void >*>(static_cast<TagAndForwardErrorActor*>(this)));
															#line 19043 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<TagAndForwardErrorActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1466 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		out.sendError(value);
															#line 19065 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1466 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		out.sendError(value);
															#line 19074 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagAndForwardErrorActor*>(this)->actor_wait_state > 0) static_cast<TagAndForwardErrorActor*>(this)->actor_wait_state = 0;
		static_cast<TagAndForwardErrorActor*>(this)->ActorCallback< TagAndForwardErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagAndForwardErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagAndForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagAndForwardErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagAndForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagAndForwardErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagAndForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		delete static_cast<TagAndForwardErrorActor*>(this);
															#line 19158 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		return 0;

		return loopDepth;
	}
															#line 1462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Promise<T>* pOutputPromise;
															#line 1462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Error value;
															#line 1462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> signal;
															#line 1464 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Promise<T> out;
															#line 19171 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via tagAndForwardError()
															#line 1462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagAndForwardErrorActor final : public Actor<void>, public ActorCallback< TagAndForwardErrorActor<T>, 0, Void >, public FastAllocated<TagAndForwardErrorActor<T>>, public TagAndForwardErrorActorState<T, TagAndForwardErrorActor<T>> {
															#line 19178 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TagAndForwardErrorActor<T>>::operator new;
	using FastAllocated<TagAndForwardErrorActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10276284979099295232UL, 1654913213659849984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< TagAndForwardErrorActor<T>, 0, Void >;
															#line 1462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagAndForwardErrorActor(Promise<T>* const& pOutputPromise,Error const& value,Future<Void> const& signal) 
															#line 19195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<void>(),
		   TagAndForwardErrorActorState<T, TagAndForwardErrorActor<T>>(pOutputPromise, value, signal),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tagAndForwardError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3151343297505891328UL, 15752123845492404480UL);
		ActorExecutionContextHelper __helper(static_cast<TagAndForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tagAndForwardError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tagAndForwardError", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 1462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
void tagAndForwardError( Promise<T>* const& pOutputPromise, Error const& value, Future<Void> const& signal ) {
															#line 1462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	new TagAndForwardErrorActor<T>(pOutputPromise, value, signal);
															#line 19221 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1468 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 19226 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via tagAndForwardError()
															#line 1469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class TagAndForwardErrorActor1>
															#line 1469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagAndForwardErrorActor1State {
															#line 19233 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagAndForwardErrorActor1State(PromiseStream<T>* const& pOutput,Error const& value,Future<Void> const& signal) 
															#line 1469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : pOutput(pOutput),
															#line 1469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   value(value),
															#line 1469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   signal(signal)
															#line 19244 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("tagAndForwardError", reinterpret_cast<unsigned long>(this));

	}
	~TagAndForwardErrorActor1State() 
	{
		fdb_probe_actor_destroy("tagAndForwardError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1471 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_0 = signal;
															#line 1471 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 19261 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			static_cast<TagAndForwardErrorActor1*>(this)->actor_wait_state = 1;
															#line 1471 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagAndForwardErrorActor1, 0, Void >*>(static_cast<TagAndForwardErrorActor1*>(this)));
															#line 19265 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<TagAndForwardErrorActor1*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1472 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		pOutput->sendError(value);
															#line 19287 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1472 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		pOutput->sendError(value);
															#line 19296 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagAndForwardErrorActor1*>(this)->actor_wait_state > 0) static_cast<TagAndForwardErrorActor1*>(this)->actor_wait_state = 0;
		static_cast<TagAndForwardErrorActor1*>(this)->ActorCallback< TagAndForwardErrorActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagAndForwardErrorActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagAndForwardErrorActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagAndForwardErrorActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagAndForwardErrorActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagAndForwardErrorActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagAndForwardErrorActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tagAndForwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		delete static_cast<TagAndForwardErrorActor1*>(this);
															#line 19380 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		return 0;

		return loopDepth;
	}
															#line 1469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<T>* pOutput;
															#line 1469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Error value;
															#line 1469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> signal;
															#line 19391 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via tagAndForwardError()
															#line 1469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TagAndForwardErrorActor1 final : public Actor<void>, public ActorCallback< TagAndForwardErrorActor1<T>, 0, Void >, public FastAllocated<TagAndForwardErrorActor1<T>>, public TagAndForwardErrorActor1State<T, TagAndForwardErrorActor1<T>> {
															#line 19398 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<TagAndForwardErrorActor1<T>>::operator new;
	using FastAllocated<TagAndForwardErrorActor1<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10276284979099295232UL, 1654913213659849984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< TagAndForwardErrorActor1<T>, 0, Void >;
															#line 1469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TagAndForwardErrorActor1(PromiseStream<T>* const& pOutput,Error const& value,Future<Void> const& signal) 
															#line 19415 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<void>(),
		   TagAndForwardErrorActor1State<T, TagAndForwardErrorActor1<T>>(pOutput, value, signal),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tagAndForwardError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15803124157335763968UL, 10169567429264438272UL);
		ActorExecutionContextHelper __helper(static_cast<TagAndForwardErrorActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tagAndForwardError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tagAndForwardError", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 1469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
void tagAndForwardError( PromiseStream<T>* const& pOutput, Error const& value, Future<Void> const& signal ) {
															#line 1469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	new TagAndForwardErrorActor1<T>(pOutput, value, signal);
															#line 19441 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1474 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

															#line 19446 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via waitOrError()
															#line 1475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class WaitOrErrorActor>
															#line 1475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class WaitOrErrorActorState {
															#line 19453 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	WaitOrErrorActorState(Future<T> const& f,Future<Void> const& errorSignal) 
															#line 1475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : f(f),
															#line 1475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   errorSignal(errorSignal)
															#line 19462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("waitOrError", reinterpret_cast<unsigned long>(this));

	}
	~WaitOrErrorActorState() 
	{
		fdb_probe_actor_destroy("waitOrError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1478 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<T> __when_expr_0 = f;
															#line 1477 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			if (static_cast<WaitOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19479 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1481 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			StrictFuture<Void> __when_expr_1 = errorSignal;
															#line 19483 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<WaitOrErrorActor*>(this)->actor_wait_state = 1;
															#line 1478 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitOrErrorActor, 0, T >*>(static_cast<WaitOrErrorActor*>(this)));
															#line 1481 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitOrErrorActor, 1, Void >*>(static_cast<WaitOrErrorActor*>(this)));
															#line 19490 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitOrErrorActorState();
		static_cast<WaitOrErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
															#line 1479 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<WaitOrErrorActor*>(this)->SAV<T>::futures) { (void)(val); this->~WaitOrErrorActorState(); static_cast<WaitOrErrorActor*>(this)->destroy(); return 0; }
															#line 19513 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<WaitOrErrorActor*>(this)->SAV< T >::value()) T(val);
		this->~WaitOrErrorActorState();
		static_cast<WaitOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
															#line 1479 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<WaitOrErrorActor*>(this)->SAV<T>::futures) { (void)(val); this->~WaitOrErrorActorState(); static_cast<WaitOrErrorActor*>(this)->destroy(); return 0; }
															#line 19525 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<WaitOrErrorActor*>(this)->SAV< T >::value()) T(val);
		this->~WaitOrErrorActorState();
		static_cast<WaitOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 1482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		ASSERT(false);
															#line 1483 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 19539 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 1482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		ASSERT(false);
															#line 1483 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 19549 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitOrErrorActor*>(this)->ActorCallback< WaitOrErrorActor, 0, T >::remove();
		static_cast<WaitOrErrorActor*>(this)->ActorCallback< WaitOrErrorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitOrErrorActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("waitOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitOrErrorActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("waitOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitOrErrorActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("waitOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitOrErrorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitOrErrorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitOrErrorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOrError", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> f;
															#line 1475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<Void> errorSignal;
															#line 19678 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via waitOrError()
															#line 1475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class WaitOrErrorActor final : public Actor<T>, public ActorCallback< WaitOrErrorActor<T>, 0, T >, public ActorCallback< WaitOrErrorActor<T>, 1, Void >, public FastAllocated<WaitOrErrorActor<T>>, public WaitOrErrorActorState<T, WaitOrErrorActor<T>> {
															#line 19685 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<WaitOrErrorActor<T>>::operator new;
	using FastAllocated<WaitOrErrorActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15874936972499888640UL, 16251074787364137984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitOrErrorActor<T>, 0, T >;
friend struct ActorCallback< WaitOrErrorActor<T>, 1, Void >;
															#line 1475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	WaitOrErrorActor(Future<T> const& f,Future<Void> const& errorSignal) 
															#line 19703 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   WaitOrErrorActorState<T, WaitOrErrorActor<T>>(f, errorSignal),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitOrError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(79762681131002880UL, 13836279391833512448UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitOrError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitOrError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitOrErrorActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T>
															#line 1475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> waitOrError( Future<T> const& f, Future<Void> const& errorSignal ) {
															#line 1475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new WaitOrErrorActor<T>(f, errorSignal));
															#line 19738 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1487 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

// A simple counter designed to track an ongoing count of something, such as how many actors are in a critical section,
// how many bytes are currently being processed, etc... Can be explicitly released idempotently, or will automatically
// release when destructed to handle actor ending or errors.
// Can be used for any type T so long as it has += and -= operators.

// Usage Example: tracking number of actors in code section
// ActiveCounter<int> counter;
//
//   state ActiveCounter::Releaser tracker = counter.take(1);
//   wait(perform my operation);
//   tracker.release();

template <class T>
struct ActiveCounter {
	struct Releaser : NonCopyable {
		ActiveCounter<T>* parent;
		T delta;
		std::function<void()> releaseCallback;

		Releaser() : parent(nullptr) {}
		Releaser(ActiveCounter<T>* parent, T delta, std::function<void()> releaseCallback)
		  : parent(parent), delta(delta), releaseCallback(releaseCallback) {
			parent->counter += delta;
		}
		Releaser(Releaser&& r) noexcept : parent(r.parent), delta(r.delta), releaseCallback(r.releaseCallback) {
			r.parent = nullptr;
		}
		void operator=(Releaser&& r) {
			release();
			parent = r.parent;
			delta = r.delta;
			releaseCallback = r.releaseCallback;
			r.parent = nullptr;
		}

		void release() {
			if (parent) {
				parent->counter -= delta;
				parent = nullptr;
				if (releaseCallback) {
					releaseCallback();
				}
			}
		}

		~Releaser() { release(); }
	};

	T counter;

	ActiveCounter(T initialValue) : counter(initialValue) {}

	T getValue() { return counter; }

	Releaser take(T delta, std::function<void()> releaseCallback = {}) {
		return Releaser(this, delta, releaseCallback);
	}
};

// A low-overhead FIFO mutex made with no internal queue structure (no list, deque, vector, etc)
// The lock is implemented as a Promise<Void>, which is returned to callers in a convenient wrapper
// called Lock.
//
// The default behavior is that if a Lock is dropped without error or release, existing and future
// waiters will see a broken_promise exception.
//
// If hangOnDroppedMutex is true, then if a Lock is dropped without error or release, existing and
// future waiters will never be signaled or see an error, equivalent to waiting on Never().
//
// Usage:
//   Lock lock = wait(mutex.take());
//   lock.release();  // Next waiter will get the lock, OR
//   lock.error(e);   // Next waiter will get e, future waiters will see broken_promise
//   lock = Lock();   // Or let Lock and any copies go out of scope.  All waiters will see broken_promise.
struct FlowMutex {
	FlowMutex(bool hangOnDroppedMutex = false) : hangOnDroppedMutex(hangOnDroppedMutex) { lastPromise.send(Void()); }

	bool available() const { return lastPromise.isSet(); }

	struct Lock {
		void release() { promise.send(Void()); }

		void error(Error e = broken_promise()) { promise.sendError(e); }

		// This is exposed in case the caller wants to use/copy it directly
		Promise<Void> promise;
	};

	Future<Lock> take() {
		Lock newLock;
		Future<Lock> f = lastPromise.isSet() ? newLock : tag(lastPromise.getFuture(), newLock);
		lastPromise = newLock.promise;
		if (hangOnDroppedMutex) {
			return brokenPromiseToNever(f);
		}
		return f;
	}

private:
	bool hangOnDroppedMutex;
	Promise<Void> lastPromise;
};

															#line 19846 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
namespace {
// This generated class is to be used only via forwardErrors()
															#line 1591 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class V, class ForwardErrorsActor>
															#line 1591 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardErrorsActorState {
															#line 19853 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1591 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardErrorsActorState(Future<T> const& f,PromiseStream<V> const& output) 
															#line 1591 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1591 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : f(f),
															#line 1591 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   output(output)
															#line 19862 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("forwardErrors", reinterpret_cast<unsigned long>(this));

	}
	~ForwardErrorsActorState() 
	{
		fdb_probe_actor_destroy("forwardErrors", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1594 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<T> __when_expr_0 = f;
															#line 1594 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<ForwardErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 19880 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ForwardErrorsActor*>(this)->actor_wait_state = 1;
															#line 1594 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ForwardErrorsActor, 0, T >*>(static_cast<ForwardErrorsActor*>(this)));
															#line 19885 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ForwardErrorsActorState();
		static_cast<ForwardErrorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1597 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			output.sendError(e);
															#line 1598 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 19917 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& val,int loopDepth) 
	{
															#line 1595 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ForwardErrorsActor*>(this)->SAV<T>::futures) { (void)(val); this->~ForwardErrorsActorState(); static_cast<ForwardErrorsActor*>(this)->destroy(); return 0; }
															#line 19931 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ForwardErrorsActor*>(this)->SAV< T >::value()) T(val);
		this->~ForwardErrorsActorState();
		static_cast<ForwardErrorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && val,int loopDepth) 
	{
															#line 1595 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		if (!static_cast<ForwardErrorsActor*>(this)->SAV<T>::futures) { (void)(val); this->~ForwardErrorsActorState(); static_cast<ForwardErrorsActor*>(this)->destroy(); return 0; }
															#line 19943 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		new (&static_cast<ForwardErrorsActor*>(this)->SAV< T >::value()) T(val);
		this->~ForwardErrorsActorState();
		static_cast<ForwardErrorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& val,int loopDepth) 
	{
		loopDepth = a_body1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && val,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForwardErrorsActor*>(this)->actor_wait_state > 0) static_cast<ForwardErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<ForwardErrorsActor*>(this)->ActorCallback< ForwardErrorsActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< ForwardErrorsActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("forwardErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ForwardErrorsActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("forwardErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ForwardErrorsActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("forwardErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardErrors", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1591 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	Future<T> f;
															#line 1591 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	PromiseStream<V> output;
															#line 20030 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
};
// This generated class is to be used only via forwardErrors()
															#line 1591 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class V>
															#line 1591 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class ForwardErrorsActor final : public Actor<T>, public ActorCallback< ForwardErrorsActor<T, V>, 0, T >, public FastAllocated<ForwardErrorsActor<T, V>>, public ForwardErrorsActorState<T, V, ForwardErrorsActor<T, V>> {
															#line 20037 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
	using FastAllocated<ForwardErrorsActor<T, V>>::operator new;
	using FastAllocated<ForwardErrorsActor<T, V>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12090188285208799744UL, 4702610419996290048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ForwardErrorsActor<T, V>, 0, T >;
															#line 1591 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	ForwardErrorsActor(Future<T> const& f,PromiseStream<V> const& output) 
															#line 20054 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
		 : Actor<T>(),
		   ForwardErrorsActorState<T, V, ForwardErrorsActor<T, V>>(f, output),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("forwardErrors", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4115760443657310976UL, 9191871435056424192UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forwardErrors");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forwardErrors", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ForwardErrorsActor<T, V>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1591 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class T, class V>
															#line 1591 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
[[nodiscard]] Future<T> forwardErrors( Future<T> const& f, PromiseStream<V> const& output ) {
															#line 1591 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	return Future<T>(new ForwardErrorsActor<T, V>(f, output));
															#line 20089 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
}

#line 1601 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"

struct FlowLock : NonCopyable, public ReferenceCounted<FlowLock> {
	// FlowLock implements a nonblocking critical section: there can be only a limited number of clients executing code
	// between wait(take()) and release(). Not thread safe. take() returns only when the number of holders of the lock
	// is fewer than the number of permits, and release() makes the caller no longer a holder of the lock. release()
	// only runs waiting take()rs after the caller wait()s

	struct Releaser : NonCopyable {
		FlowLock* lock;
		int remaining;
		Releaser() : lock(0), remaining(0) {}
		Releaser(FlowLock& lock, int64_t amount = 1) : lock(&lock), remaining(amount) {}
		Releaser(Releaser&& r) noexcept : lock(r.lock), remaining(r.remaining) { r.remaining = 0; }
		void operator=(Releaser&& r) {
			if (remaining)
				lock->release(remaining);
			lock = r.lock;
			remaining = r.remaining;
			r.remaining = 0;
		}

		void release(int64_t amount = -1) {
			if (amount == -1 || amount > remaining)
				amount = remaining;

			if (remaining)
				lock->release(amount);
			remaining -= amount;
		}

		~Releaser() {
			if (remaining)
				lock->release(remaining);
		}
	};

	FlowLock() : permits(1), active(0) {}
	explicit FlowLock(int64_t permits) : permits(permits), active(0) {}

	Future<Void> take(TaskPriority taskID = TaskPriority::DefaultYield, int64_t amount = 1) {
		if (active + amount <= permits || active == 0) {
			active += amount;
			return safeYieldActor(this, taskID, amount);
		}
		return takeActor(this, taskID, amount);
	}
	void release(int64_t amount = 1) {
		ASSERT((active > 0 || amount == 0) && active - amount >= 0);
		active -= amount;

		while (!takers.empty()) {
			if (active + takers.begin()->second <= permits || active == 0) {
				std::pair<Promise<Void>, int64_t> next = std::move(*takers.begin());
				active += next.second;
				takers.pop_front();
				next.first.send(Void());
			} else {
				break;
			}
		}
	}

	Future<Void> releaseWhen(Future<Void> const& signal, int amount = 1) {
		return releaseWhenActor(this, signal, amount);
	}

	// returns when any permits are available, having taken as many as possible up to the given amount, and modifies
	// amount to the number of permits taken
	Future<Void> takeUpTo(int64_t& amount) { return takeMoreActor(this, &amount); }

	int64_t available() const { return permits - active; }
	int64_t activePermits() const { return active; }
	int waiters() const { return takers.size(); }

	// Try to send error to all current and future waiters
	// Only works if broken_on_destruct.canBeSet()
	void kill(Error e = broken_promise()) {
		if (broken_on_destruct.canBeSet()) {
			auto local = broken_on_destruct;
			// It could be the case that calling broken_on_destruct destroys this FlowLock
			local.sendError(e);
		}
	}

private:
	std::list<std::pair<Promise<Void>, int64_t>> takers;
	const int64_t permits;
	int64_t active;
	Promise<Void> broken_on_destruct;

																#line 20183 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
// This generated class is to be used only via takeActor()
															#line 1691 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
template <class TakeActorActor>
															#line 1691 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
class TakeActorActorState {
															#line 20189 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
public:
															#line 1691 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
	TakeActorActorState(FlowLock* const& lock,TaskPriority const& taskID,int64_t const& amount) 
															#line 1691 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
															#line 1691 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		 : lock(lock),
															#line 1691 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   taskID(taskID),
															#line 1691 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   amount(amount),
															#line 1692 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
		   it(lock->takers.emplace(lock->takers.end(), Promise<Void>(), amount))
															#line 20202 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
	{
		fdb_probe_actor_create("takeActor", reinterpret_cast<unsigned long>(this));

	}
	~TakeActorActorState() 
	{
		fdb_probe_actor_destroy("takeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1696 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				StrictFuture<Void> __when_expr_0 = it->first.getFuture();
															#line 1696 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				if (static_cast<TakeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 20220 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/flow/include/flow/genericactors.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TakeActorActor*>(this)->actor_wait_state = 1;
															#line 1696 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/flow/include/flow/genericactors.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TakeActorActor, 0, Void >*>(static_cast<TakeAc