#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDReadWrite.actor.cpp"
/*
 * MockDDReadWrite.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/workloads/MockDDTest.h"
#include "fdbserver/MockDataDistributor.h"
#include "fdbserver/DDTxnProcessor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

class MockDDReadWriteWorkload : public MockDDTestWorkload {
public:
	static constexpr auto NAME = "MockDDReadWrite";
	Reference<DDSharedContext> ddcx;
	Reference<DDMockTxnProcessor> mock;
	MockDataDistributor dataDistributor;
	ActorCollection actors;

	// --- test configs ---

	explicit MockDDReadWriteWorkload(WorkloadContext const& wcx)
	  : MockDDTestWorkload(wcx),
	    ddcx(makeReference<DDSharedContext>(
	        DataDistributorInterface(LocalityData(), deterministicRandom()->randomUniqueID()))) {}

	Future<Void> setup(Database const& cx) override {
		if (!enabled)
			return Void();
		MockDDTestWorkload::setup(cx);
		// populate sharedMgs before run DD
		populateMgs();
		// sharedMgs->addStoragePerProcess();
		mock = makeReference<DDMockTxnProcessor>(sharedMgs);
		return Void();
	}

	Future<Void> start(Database const& cx) override {
		if (!enabled)
			return Void();

		// start mock servers
		actors.add(waitForAll(sharedMgs->runAllMockServers()));
		// start data distributor
		actors.add(dataDistributor.run(ddcx, mock));

		return delay(testDuration);
	}

	Future<bool> check(Database const& cx) override {
		if (!enabled)
			return true;
		return true;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<MockDDReadWriteWorkload> MockDDReadWriteWorkload;