#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
/*
 * ExclusionTracker.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

// When actually compiled (NO_INTELLISENSE), include the generated version of this file.  In intellisense use the source
// version.
#if defined(NO_INTELLISENSE) && !defined(EXCLUSION_TRACKER_ACTOR_G_H)
#define EXCLUSION_TRACKER_ACTOR_G_H
#include "fdbserver/ExclusionTracker.actor.g.h"
#elif !defined(EXCLUSION_TRACKER_ACTOR_H)
#define EXCLUSION_TRACKER_ACTOR_H

#include <set>
#include "flow/flow.h"
#include "flow/Trace.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct ExclusionTracker {
	std::set<AddressExclusion> excluded;
	std::set<AddressExclusion> failed;

	AsyncTrigger changed;

	Database db;
	Future<Void> trackerFuture;

	ExclusionTracker() {}
	ExclusionTracker(Database db) : db(db) { trackerFuture = tracker(this); }

	bool isFailedOrExcluded(NetworkAddress addr) {
		AddressExclusion addrExclusion(addr.ip, addr.port);
		return excluded.contains(addrExclusion) || failed.contains(addrExclusion);
	}

																#line 57 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
// This generated class is to be used only via tracker()
															#line 55 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
template <class TrackerActor>
															#line 55 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
class TrackerActorState {
															#line 63 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
public:
															#line 55 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	TrackerActorState(ExclusionTracker* const& self) 
															#line 55 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
															#line 55 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		 : self(self),
															#line 57 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		   tr(self->db)
															#line 72 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
	{
		fdb_probe_actor_create("tracker", reinterpret_cast<unsigned long>(this));

	}
	~TrackerActorState() 
	{
		fdb_probe_actor_destroy("tracker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 58 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			;
															#line 87 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TrackerActorState();
		static_cast<TrackerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 60 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 61 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 62 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 63 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			fresultsExclude = tr.getRange(excludedServersKeys, CLIENT_KNOBS->TOO_MANY);
															#line 64 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			fresultsFailed = tr.getRange(failedServersKeys, CLIENT_KNOBS->TOO_MANY);
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			flocalitiesExclude = tr.getRange(excludedLocalityKeys, CLIENT_KNOBS->TOO_MANY);
															#line 67 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			flocalitiesFailed = tr.getRange(failedLocalityKeys, CLIENT_KNOBS->TOO_MANY);
															#line 68 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			fworkers = getWorkers(&tr.getTransaction());
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			StrictFuture<Void> __when_expr_0 = success(fresultsExclude) && success(fresultsFailed) && success(flocalitiesExclude) && success(flocalitiesFailed);
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			if (static_cast<TrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 136 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TrackerActor*>(this)->actor_wait_state = 1;
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TrackerActor, 0, Void >*>(static_cast<TrackerActor*>(this)));
															#line 141 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 144 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			TraceEvent("ExclusionTrackerError").error(e);
															#line 145 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 145 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			if (static_cast<TrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 167 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<TrackerActor*>(this)->actor_wait_state = 5;
															#line 145 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TrackerActor, 4, Void >*>(static_cast<TrackerActor*>(this)));
															#line 172 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 72 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		excludedResults = fresultsExclude.get();
															#line 73 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		ASSERT(!excludedResults.more && excludedResults.size() < CLIENT_KNOBS->TOO_MANY);
															#line 75 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		failedResults = fresultsFailed.get();
															#line 76 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		ASSERT(!failedResults.more && failedResults.size() < CLIENT_KNOBS->TOO_MANY);
															#line 78 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		excludedLocalityResults = flocalitiesExclude.get();
															#line 79 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		ASSERT(!excludedLocalityResults.more && excludedLocalityResults.size() < CLIENT_KNOBS->TOO_MANY);
															#line 81 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		failedLocalityResults = flocalitiesFailed.get();
															#line 82 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		ASSERT(!failedLocalityResults.more && failedLocalityResults.size() < CLIENT_KNOBS->TOO_MANY);
															#line 84 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		newExcluded = std::set<AddressExclusion>();
															#line 85 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		newFailed = std::set<AddressExclusion>();
															#line 86 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		for( const auto& r : excludedResults ) {
															#line 87 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			AddressExclusion addr = decodeExcludedServersKey(r.key);
															#line 88 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			if (addr.isValid())
															#line 211 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			{
															#line 89 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				newExcluded.insert(addr);
															#line 215 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			}
		}
															#line 92 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		for( const auto& r : failedResults ) {
															#line 93 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			AddressExclusion addr = decodeFailedServersKey(r.key);
															#line 94 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			if (addr.isValid())
															#line 224 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			{
															#line 95 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				newFailed.insert(addr);
															#line 228 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			}
		}
															#line 99 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		StrictFuture<Void> __when_expr_1 = success(fworkers);
															#line 99 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (static_cast<TrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 235 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackerActor*>(this)->actor_wait_state = 2;
															#line 99 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackerActor, 1, Void >*>(static_cast<TrackerActor*>(this)));
															#line 240 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 72 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		excludedResults = fresultsExclude.get();
															#line 73 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		ASSERT(!excludedResults.more && excludedResults.size() < CLIENT_KNOBS->TOO_MANY);
															#line 75 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		failedResults = fresultsFailed.get();
															#line 76 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		ASSERT(!failedResults.more && failedResults.size() < CLIENT_KNOBS->TOO_MANY);
															#line 78 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		excludedLocalityResults = flocalitiesExclude.get();
															#line 79 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		ASSERT(!excludedLocalityResults.more && excludedLocalityResults.size() < CLIENT_KNOBS->TOO_MANY);
															#line 81 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		failedLocalityResults = flocalitiesFailed.get();
															#line 82 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		ASSERT(!failedLocalityResults.more && failedLocalityResults.size() < CLIENT_KNOBS->TOO_MANY);
															#line 84 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		newExcluded = std::set<AddressExclusion>();
															#line 85 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		newFailed = std::set<AddressExclusion>();
															#line 86 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		for( const auto& r : excludedResults ) {
															#line 87 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			AddressExclusion addr = decodeExcludedServersKey(r.key);
															#line 88 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			if (addr.isValid())
															#line 273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			{
															#line 89 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				newExcluded.insert(addr);
															#line 277 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			}
		}
															#line 92 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		for( const auto& r : failedResults ) {
															#line 93 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			AddressExclusion addr = decodeFailedServersKey(r.key);
															#line 94 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			if (addr.isValid())
															#line 286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			{
															#line 95 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				newFailed.insert(addr);
															#line 290 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			}
		}
															#line 99 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		StrictFuture<Void> __when_expr_1 = success(fworkers);
															#line 99 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (static_cast<TrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 297 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackerActor*>(this)->actor_wait_state = 2;
															#line 99 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackerActor, 1, Void >*>(static_cast<TrackerActor*>(this)));
															#line 302 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TrackerActor*>(this)->actor_wait_state > 0) static_cast<TrackerActor*>(this)->actor_wait_state = 0;
		static_cast<TrackerActor*>(this)->ActorCallback< TrackerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TrackerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TrackerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 100 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		std::vector<ProcessData> workers = fworkers.get();
															#line 101 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		for( const auto& r : excludedLocalityResults ) {
															#line 102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			std::string locality = decodeExcludedLocalityKey(r.key);
															#line 103 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			std::set<AddressExclusion> localityExcludedAddresses = getAddressesByLocality(workers, locality);
															#line 104 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			newExcluded.insert(localityExcludedAddresses.begin(), localityExcludedAddresses.end());
															#line 105 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			if (localityExcludedAddresses.empty())
															#line 396 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			{
															#line 106 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				TraceEvent(SevWarn, "ExclusionTrackerLocalityNotFound").detail("Locality", locality);
															#line 400 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			}
		}
															#line 109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		for( const auto& r : failedLocalityResults ) {
															#line 110 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			std::string locality = decodeFailedLocalityKey(r.key);
															#line 111 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			std::set<AddressExclusion> localityFailedAddresses = getAddressesByLocality(workers, locality);
															#line 112 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			newFailed.insert(localityFailedAddresses.begin(), localityFailedAddresses.end());
															#line 113 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			if (localityFailedAddresses.empty())
															#line 413 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			{
															#line 114 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				TraceEvent(SevWarn, "ExclusionTrackerFailedLocalityNotFound").detail("Locality", locality);
															#line 417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			}
		}
															#line 118 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		bool foundChange = false;
															#line 119 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (self->excluded != newExcluded)
															#line 424 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		{
															#line 120 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			self->excluded = newExcluded;
															#line 121 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			foundChange = true;
															#line 430 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 123 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (self->failed != newFailed)
															#line 434 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		{
															#line 124 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			self->failed = newFailed;
															#line 125 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			foundChange = true;
															#line 440 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 128 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (foundChange)
															#line 444 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		{
															#line 129 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			self->changed.trigger();
															#line 448 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 132 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		watchFuture = tr.watch(excludedServersVersionKey) || tr.watch(failedServersVersionKey) || tr.watch(excludedLocalityVersionKey) || tr.watch(failedLocalityVersionKey);
															#line 135 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 135 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (static_cast<TrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TrackerActor*>(this)->actor_wait_state = 3;
															#line 135 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TrackerActor, 2, Void >*>(static_cast<TrackerActor*>(this)));
															#line 461 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 100 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		std::vector<ProcessData> workers = fworkers.get();
															#line 101 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		for( const auto& r : excludedLocalityResults ) {
															#line 102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			std::string locality = decodeExcludedLocalityKey(r.key);
															#line 103 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			std::set<AddressExclusion> localityExcludedAddresses = getAddressesByLocality(workers, locality);
															#line 104 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			newExcluded.insert(localityExcludedAddresses.begin(), localityExcludedAddresses.end());
															#line 105 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			if (localityExcludedAddresses.empty())
															#line 480 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			{
															#line 106 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				TraceEvent(SevWarn, "ExclusionTrackerLocalityNotFound").detail("Locality", locality);
															#line 484 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			}
		}
															#line 109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		for( const auto& r : failedLocalityResults ) {
															#line 110 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			std::string locality = decodeFailedLocalityKey(r.key);
															#line 111 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			std::set<AddressExclusion> localityFailedAddresses = getAddressesByLocality(workers, locality);
															#line 112 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			newFailed.insert(localityFailedAddresses.begin(), localityFailedAddresses.end());
															#line 113 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			if (localityFailedAddresses.empty())
															#line 497 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			{
															#line 114 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				TraceEvent(SevWarn, "ExclusionTrackerFailedLocalityNotFound").detail("Locality", locality);
															#line 501 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			}
		}
															#line 118 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		bool foundChange = false;
															#line 119 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (self->excluded != newExcluded)
															#line 508 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		{
															#line 120 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			self->excluded = newExcluded;
															#line 121 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			foundChange = true;
															#line 514 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 123 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (self->failed != newFailed)
															#line 518 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		{
															#line 124 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			self->failed = newFailed;
															#line 125 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			foundChange = true;
															#line 524 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 128 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (foundChange)
															#line 528 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		{
															#line 129 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			self->changed.trigger();
															#line 532 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 132 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		watchFuture = tr.watch(excludedServersVersionKey) || tr.watch(failedServersVersionKey) || tr.watch(excludedLocalityVersionKey) || tr.watch(failedLocalityVersionKey);
															#line 135 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 135 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (static_cast<TrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 540 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TrackerActor*>(this)->actor_wait_state = 3;
															#line 135 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TrackerActor, 2, Void >*>(static_cast<TrackerActor*>(this)));
															#line 545 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TrackerActor*>(this)->actor_wait_state > 0) static_cast<TrackerActor*>(this)->actor_wait_state = 0;
		static_cast<TrackerActor*>(this)->ActorCallback< TrackerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TrackerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TrackerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 136 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (excludedLocalityResults.size() > 0 || failedLocalityResults.size() > 0)
															#line 629 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		{
															#line 139 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			watchFuture = watchFuture || delay(10.0);
															#line 633 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 141 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		StrictFuture<Void> __when_expr_3 = watchFuture;
															#line 141 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (static_cast<TrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 639 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<TrackerActor*>(this)->actor_wait_state = 4;
															#line 141 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TrackerActor, 3, Void >*>(static_cast<TrackerActor*>(this)));
															#line 644 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 136 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (excludedLocalityResults.size() > 0 || failedLocalityResults.size() > 0)
															#line 653 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		{
															#line 139 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			watchFuture = watchFuture || delay(10.0);
															#line 657 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 141 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		StrictFuture<Void> __when_expr_3 = watchFuture;
															#line 141 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (static_cast<TrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 663 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<TrackerActor*>(this)->actor_wait_state = 4;
															#line 141 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TrackerActor, 3, Void >*>(static_cast<TrackerActor*>(this)));
															#line 668 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TrackerActor*>(this)->actor_wait_state > 0) static_cast<TrackerActor*>(this)->actor_wait_state = 0;
		static_cast<TrackerActor*>(this)->ActorCallback< TrackerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TrackerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TrackerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont16(Void const& _,int loopDepth) 
	{
															#line 142 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		tr.reset();
															#line 752 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		loopDepth = a_body1loopBody1cont16cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont16(Void && _,int loopDepth) 
	{
															#line 142 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		tr.reset();
															#line 761 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		loopDepth = a_body1loopBody1cont16cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TrackerActor*>(this)->actor_wait_state > 0) static_cast<TrackerActor*>(this)->actor_wait_state = 0;
		static_cast<TrackerActor*>(this)->ActorCallback< TrackerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TrackerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TrackerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont16cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TrackerActor*>(this)->actor_wait_state > 0) static_cast<TrackerActor*>(this)->actor_wait_state = 0;
		static_cast<TrackerActor*>(this)->ActorCallback< TrackerActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackerActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TrackerActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TrackerActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 55 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	ExclusionTracker* self;
															#line 57 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	ReadYourWritesTransaction tr;
															#line 63 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	Future<RangeResult> fresultsExclude;
															#line 64 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	Future<RangeResult> fresultsFailed;
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	Future<RangeResult> flocalitiesExclude;
															#line 67 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	Future<RangeResult> flocalitiesFailed;
															#line 68 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	Future<std::vector<ProcessData>> fworkers;
															#line 72 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	RangeResult excludedResults;
															#line 75 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	RangeResult failedResults;
															#line 78 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	RangeResult excludedLocalityResults;
															#line 81 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	RangeResult failedLocalityResults;
															#line 84 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	std::set<AddressExclusion> newExcluded;
															#line 85 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	std::set<AddressExclusion> newFailed;
															#line 132 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	Future<Void> watchFuture;
															#line 969 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
};
// This generated class is to be used only via tracker()
															#line 55 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
class TrackerActor final : public Actor<Void>, public ActorCallback< TrackerActor, 0, Void >, public ActorCallback< TrackerActor, 1, Void >, public ActorCallback< TrackerActor, 2, Void >, public ActorCallback< TrackerActor, 3, Void >, public ActorCallback< TrackerActor, 4, Void >, public FastAllocated<TrackerActor>, public TrackerActorState<TrackerActor> {
															#line 974 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
public:
	using FastAllocated<TrackerActor>::operator new;
	using FastAllocated<TrackerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4438188369684834816UL, 16981055057775694592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TrackerActor, 0, Void >;
friend struct ActorCallback< TrackerActor, 1, Void >;
friend struct ActorCallback< TrackerActor, 2, Void >;
friend struct ActorCallback< TrackerActor, 3, Void >;
friend struct ActorCallback< TrackerActor, 4, Void >;
															#line 55 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	TrackerActor(ExclusionTracker* const& self) 
															#line 995 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		 : Actor<Void>(),
		   TrackerActorState<TrackerActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16871199721278967296UL, 2007396679958793216UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tracker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TrackerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TrackerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TrackerActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TrackerActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TrackerActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 55 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
[[nodiscard]] static Future<Void> tracker( ExclusionTracker* const& self ) {
															#line 55 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	return Future<Void>(new TrackerActor(self));
															#line 1031 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
}

#line 149 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
};

#include "flow/unactorcompiler.h"
#endif