#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"
/*
 * BlobGranuleServerCommon.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if defined(NO_INTELLISENSE) && !defined(FDBSERVER_BLOBGRANULESERVERCOMMON_ACTOR_G_H)
#define FDBSERVER_BLOBGRANULESERVERCOMMON_ACTOR_G_H
#include "fdbserver/BlobGranuleServerCommon.actor.g.h"
#elif !defined(FDBSERVER_BLOBGRANULESERVERCOMMON_ACTOR_H)
#define FDBSERVER_BLOBGRANULESERVERCOMMON_ACTOR_H

#pragma once

#include "fdbclient/BlobConnectionProvider.h"
#include "fdbclient/BlobGranuleCommon.h"
#include "fdbclient/BlobRestoreCommon.h"
#include "fdbclient/CommitTransaction.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/Tenant.h"

#include "fdbserver/ServerDBInfo.h"
#include "fdbserver/Knobs.h"
#include "flow/flow.h"

#include "flow/actorcompiler.h" // has to be last include

// Stores info about a file in blob storage
struct BlobFileIndex {
	Version version;
	std::string filename;
	int64_t offset;
	int64_t length;
	int64_t fullFileLength;
	int64_t logicalSize;
	Optional<BlobGranuleCipherKeysMeta> cipherKeysMeta;

	BlobFileIndex() {}

	BlobFileIndex(Version version,
	              std::string filename,
	              int64_t offset,
	              int64_t length,
	              int64_t fullFileLength,
	              int64_t logicalSize)
	  : version(version), filename(filename), offset(offset), length(length), fullFileLength(fullFileLength),
	    logicalSize(logicalSize) {}

	BlobFileIndex(Version version,
	              std::string filename,
	              int64_t offset,
	              int64_t length,
	              int64_t fullFileLength,
	              int64_t logicalSize,
	              Optional<BlobGranuleCipherKeysMeta> ciphKeysMeta)
	  : version(version), filename(filename), offset(offset), length(length), fullFileLength(fullFileLength),
	    logicalSize(logicalSize), cipherKeysMeta(ciphKeysMeta) {}

	// compare on version
	bool operator<(const BlobFileIndex& r) const { return version < r.version; }
};

// FIXME: initialize these to smaller default sizes to save a bit of memory,
// particularly snapshotFiles Stores the files that comprise a blob granule
struct GranuleFiles {
	std::vector<BlobFileIndex> snapshotFiles;
	std::vector<BlobFileIndex> deltaFiles;

	void getFiles(Version beginVersion,
	              Version readVersion,
	              bool canCollapse,
	              BlobGranuleChunkRef& chunk,
	              Arena& replyArena,
	              int64_t& deltaBytesCounter,
	              bool summarize) const;
};

// serialize change feed key as UID bytes, to use 16 bytes on disk
Key granuleIDToCFKey(UID granuleID);

// parse change feed key back to UID, to be human-readable
UID cfKeyToGranuleID(Key cfKey);

class Transaction;
															#line 101 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] Future<Optional<GranuleHistory>> getLatestGranuleHistory( Transaction* const& tr, KeyRange const& range );

#line 100 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"
															#line 105 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] Future<Void> readGranuleFiles( Transaction* const& tr, Key* const& startKey, Key const& endKey, GranuleFiles* const& files, UID const& granuleID );

#line 101 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"

															#line 110 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] Future<GranuleFiles> loadHistoryFiles( Database const& cx, UID const& granuleID );

#line 103 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"

enum ForcedPurgeState { NonePurged, SomePurged, AllPurged };
															#line 116 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] Future<ForcedPurgeState> getForcePurgedState( Transaction* const& tr, KeyRange const& keyRange );

#line 106 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"

// TODO: versioned like SS has?
struct GranuleTenantData : NonCopyable, ReferenceCounted<GranuleTenantData> {
	TenantMapEntry entry;
	Reference<BlobConnectionProvider> bstore;
	bool startedLoadingBStore = false;
	Promise<Void> bstoreLoaded;

	GranuleTenantData() {}
	GranuleTenantData(TenantMapEntry entry) : entry(entry) {}

	void updateBStore(const BlobMetadataDetailsRef& metadata) {
		ASSERT(startedLoadingBStore);
		if (bstoreLoaded.canBeSet()) {
			// new
			bstore = BlobConnectionProvider::newBlobConnectionProvider(metadata);
			bstoreLoaded.send(Void());
		} else {
			// update existing
			bstore->update(metadata);
		}
	}
};

// TODO: add refreshing
struct BGTenantMap {
public:
	void addTenants(std::vector<std::pair<int64_t, TenantMapEntry>>);
	void removeTenants(std::vector<int64_t> tenantIds);

	Optional<TenantMapEntry> getTenantById(int64_t id);
	Future<Reference<GranuleTenantData>> getDataForGranule(const KeyRangeRef& keyRange);

	KeyRangeMap<Reference<GranuleTenantData>> tenantData;
	std::unordered_map<int64_t, TenantMapEntry> tenantInfoById;
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
	PromiseStream<Future<Void>> addActor;

	BGTenantMap() {}
	explicit BGTenantMap(const Reference<AsyncVar<ServerDBInfo> const> dbInfo) : dbInfo(dbInfo) {
		collection = actorCollection(addActor.getFuture());
	}

private:
	Future<Void> collection;
};

															#line 167 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] Future<Void> loadBGTenantMap( BGTenantMap* const& tenantData, Transaction* const& tr );

#line 154 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"
															#line 171 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] Future<Reference<BlobConnectionProvider>> loadBStoreForTenant( BGTenantMap* const& tenantData, KeyRange const& keyRange );

#line 155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"

// Defines granule info that interests full restore
struct BlobGranuleRestoreVersion {
	// Two constructors required by VectorRef
	BlobGranuleRestoreVersion() {}
	BlobGranuleRestoreVersion(Arena& a, const BlobGranuleRestoreVersion& copyFrom)
	  : granuleID(copyFrom.granuleID), keyRange(a, copyFrom.keyRange), version(copyFrom.version),
	    sizeInBytes(copyFrom.sizeInBytes) {}

	UID granuleID;
	KeyRangeRef keyRange;
	Version version;
	int64_t sizeInBytes;
};

// Defines a vector for BlobGranuleVersion
typedef Standalone<VectorRef<BlobGranuleRestoreVersion>> BlobGranuleRestoreVersionVector;

															#line 193 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] Future<int64_t> dumpManifest( Database const& db, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, Reference<BlobConnectionProvider> const& blobConn, int64_t const& epoch, int64_t const& seqNo, bool const& encryptionEnabled );

#line 179 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"
															#line 197 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] Future<Void> loadManifest( Database const& db, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, Reference<BlobConnectionProvider> const& blobConn );

#line 182 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"
															#line 201 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] Future<Void> printRestoreSummary( Database const& db, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, Reference<BlobConnectionProvider> const& blobConn );

#line 185 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"
															#line 205 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] Future<BlobGranuleRestoreVersionVector> listBlobGranules( Database const& db, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, Reference<BlobConnectionProvider> const& blobConn );

#line 188 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"
															#line 209 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] Future<int64_t> lastBlobEpoc( Database const& db, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, Reference<BlobConnectionProvider> const& blobConn );

#line 191 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"

															#line 214 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] Future<Version> getManifestVersion( Database const& db );

#line 193 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"

class BlobRestoreController : public ReferenceCounted<BlobRestoreController> {
public:
	BlobRestoreController() {}
	BlobRestoreController(Database db, KeyRangeRef range) : db_(db), range_(range) {}

																#line 224 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] static Future<bool> isRestoring( Reference<BlobRestoreController> const& self );
template <class> friend class BlobRestoreController_IsRestoringActorState;

#line 200 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"
																#line 229 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] static Future<BlobRestorePhase> currentPhase( Reference<BlobRestoreController> const& self );
template <class> friend class BlobRestoreController_CurrentPhaseActorState;

#line 201 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"
																#line 234 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] static Future<Void> onPhaseChange( Reference<BlobRestoreController> const& self, BlobRestorePhase const& expectedPhase );
template <class> friend class BlobRestoreController_OnPhaseChangeActorState;

#line 202 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"
																#line 239 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] static Future<Version> getTargetVersion( Reference<BlobRestoreController> const& self, Version const& defaultVersion );
template <class> friend class BlobRestoreController_GetTargetVersionActorState;

#line 203 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"
																#line 244 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] static Future<Void> setPhase( Reference<BlobRestoreController> const& self, BlobRestorePhase const& newPhase, Optional<UID> const& expectedOwner );
template <class> friend class BlobRestoreController_SetPhaseActorState;

#line 206 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"
																#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] static Future<Void> setError( Reference<BlobRestoreController> const& self, std::string const& errorMessage );
template <class> friend class BlobRestoreController_SetErrorActorState;

#line 207 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"
																#line 254 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] static Future<Void> setProgress( Reference<BlobRestoreController> const& self, int const& progress, UID const& blobMigratorId );
template <class> friend class BlobRestoreController_SetProgressActorState;

#line 208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"
																#line 259 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.g.h"
[[nodiscard]] static Future<Void> setLockOwner( Reference<BlobRestoreController> const& self, UID const& migratorId );
template <class> friend class BlobRestoreController_SetLockOwnerActorState;

#line 209 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleServerCommon.actor.h"

private:
	Database db_;
	Standalone<KeyRangeRef> range_;
};

Future<BlobGranuleCipherKeysCtx> getGranuleCipherKeysFromKeysMeta(Reference<AsyncVar<ServerDBInfo> const> dbInfo,
                                                                  BlobGranuleCipherKeysMeta cipherKeysMeta,
                                                                  Arena* arena);
#include "flow/unactorcompiler.h"

#endif
