#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
/*
 * ClusterRecovery.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <utility>

#include "fdbclient/FDBTypes.h"
#include "fdbclient/MetaclusterRegistration.h"
#include "fdbrpc/sim_validation.h"
#include "fdbserver/ApplyMetadataMutation.h"
#include "fdbserver/BackupProgress.actor.h"
#include "fdbserver/ClusterRecovery.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/MasterInterface.h"
#include "fdbserver/WaitFailure.h"
#include "flow/ProtocolVersion.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace {
EncryptionAtRestMode getEncryptionAtRest(DatabaseConfiguration config) {
	TraceEvent(SevDebug, "CREncryptionAtRestMode").detail("Mode", config.encryptionAtRestMode.toString());
	return config.encryptionAtRestMode;
}
} // namespace

static std::set<int> const& normalClusterRecoveryErrors() {
	static std::set<int> s;
	if (s.empty()) {
		s.insert(error_code_operation_failed);
		s.insert(error_code_tlog_stopped);
		s.insert(error_code_tlog_failed);
		s.insert(error_code_commit_proxy_failed);
		s.insert(error_code_grv_proxy_failed);
		s.insert(error_code_resolver_failed);
		s.insert(error_code_backup_worker_failed);
		s.insert(error_code_recruitment_failed);
		s.insert(error_code_no_more_servers);
		s.insert(error_code_cluster_recovery_failed);
		s.insert(error_code_coordinated_state_conflict);
		s.insert(error_code_master_max_versions_in_flight);
		s.insert(error_code_worker_removed);
		s.insert(error_code_new_coordinators_timed_out);
		s.insert(error_code_broken_promise);
	}
	return s;
}

															#line 67 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via recoveryTerminateOnConflict()
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class RecoveryTerminateOnConflictActor>
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecoveryTerminateOnConflictActorState {
															#line 74 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecoveryTerminateOnConflictActorState(UID const& dbgid,Promise<Void> const& fullyRecovered,Future<Void> const& onConflict,Future<Void> const& switchedState) 
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : dbgid(dbgid),
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   fullyRecovered(fullyRecovered),
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   onConflict(onConflict),
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   switchedState(switchedState)
															#line 87 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this));

	}
	~RecoveryTerminateOnConflictActorState() 
	{
		fdb_probe_actor_destroy("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 70 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = onConflict;
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<RecoveryTerminateOnConflictActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 104 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 78 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_1 = switchedState;
															#line 108 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<RecoveryTerminateOnConflictActor*>(this)->actor_wait_state = 1;
															#line 70 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecoveryTerminateOnConflictActor, 0, Void >*>(static_cast<RecoveryTerminateOnConflictActor*>(this)));
															#line 78 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RecoveryTerminateOnConflictActor, 1, Void >*>(static_cast<RecoveryTerminateOnConflictActor*>(this)));
															#line 115 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecoveryTerminateOnConflictActorState();
		static_cast<RecoveryTerminateOnConflictActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
															#line 71 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!fullyRecovered.isSet())
															#line 138 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 72 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("RecoveryTerminated", dbgid).detail("Reason", "Conflict");
															#line 73 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "Coordinated state conflict, recovery terminating");
															#line 74 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(worker_removed(), loopDepth);
															#line 146 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 76 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<RecoveryTerminateOnConflictActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecoveryTerminateOnConflictActorState(); static_cast<RecoveryTerminateOnConflictActor*>(this)->destroy(); return 0; }
															#line 150 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<RecoveryTerminateOnConflictActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecoveryTerminateOnConflictActorState();
		static_cast<RecoveryTerminateOnConflictActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
															#line 71 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!fullyRecovered.isSet())
															#line 162 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 72 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("RecoveryTerminated", dbgid).detail("Reason", "Conflict");
															#line 73 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "Coordinated state conflict, recovery terminating");
															#line 74 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(worker_removed(), loopDepth);
															#line 170 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 76 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<RecoveryTerminateOnConflictActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecoveryTerminateOnConflictActorState(); static_cast<RecoveryTerminateOnConflictActor*>(this)->destroy(); return 0; }
															#line 174 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<RecoveryTerminateOnConflictActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecoveryTerminateOnConflictActorState();
		static_cast<RecoveryTerminateOnConflictActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 79 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<RecoveryTerminateOnConflictActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecoveryTerminateOnConflictActorState(); static_cast<RecoveryTerminateOnConflictActor*>(this)->destroy(); return 0; }
															#line 186 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<RecoveryTerminateOnConflictActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecoveryTerminateOnConflictActorState();
		static_cast<RecoveryTerminateOnConflictActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 79 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<RecoveryTerminateOnConflictActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecoveryTerminateOnConflictActorState(); static_cast<RecoveryTerminateOnConflictActor*>(this)->destroy(); return 0; }
															#line 198 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<RecoveryTerminateOnConflictActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecoveryTerminateOnConflictActorState();
		static_cast<RecoveryTerminateOnConflictActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecoveryTerminateOnConflictActor*>(this)->actor_wait_state > 0) static_cast<RecoveryTerminateOnConflictActor*>(this)->actor_wait_state = 0;
		static_cast<RecoveryTerminateOnConflictActor*>(this)->ActorCallback< RecoveryTerminateOnConflictActor, 0, Void >::remove();
		static_cast<RecoveryTerminateOnConflictActor*>(this)->ActorCallback< RecoveryTerminateOnConflictActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecoveryTerminateOnConflictActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryTerminateOnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecoveryTerminateOnConflictActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryTerminateOnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecoveryTerminateOnConflictActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryTerminateOnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecoveryTerminateOnConflictActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryTerminateOnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RecoveryTerminateOnConflictActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryTerminateOnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RecoveryTerminateOnConflictActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryTerminateOnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	UID dbgid;
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Promise<Void> fullyRecovered;
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> onConflict;
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> switchedState;
															#line 335 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via recoveryTerminateOnConflict()
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecoveryTerminateOnConflictActor final : public Actor<Void>, public ActorCallback< RecoveryTerminateOnConflictActor, 0, Void >, public ActorCallback< RecoveryTerminateOnConflictActor, 1, Void >, public FastAllocated<RecoveryTerminateOnConflictActor>, public RecoveryTerminateOnConflictActorState<RecoveryTerminateOnConflictActor> {
															#line 340 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<RecoveryTerminateOnConflictActor>::operator new;
	using FastAllocated<RecoveryTerminateOnConflictActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10396252585003475712UL, 1925889319697154304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecoveryTerminateOnConflictActor, 0, Void >;
friend struct ActorCallback< RecoveryTerminateOnConflictActor, 1, Void >;
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecoveryTerminateOnConflictActor(UID const& dbgid,Promise<Void> const& fullyRecovered,Future<Void> const& onConflict,Future<Void> const& switchedState) 
															#line 358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   RecoveryTerminateOnConflictActorState<RecoveryTerminateOnConflictActor>(dbgid, fullyRecovered, onConflict, switchedState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3494608132086867968UL, 16817190675191708928UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryTerminateOnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recoveryTerminateOnConflict");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recoveryTerminateOnConflict", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecoveryTerminateOnConflictActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> recoveryTerminateOnConflict( UID const& dbgid, Promise<Void> const& fullyRecovered, Future<Void> const& onConflict, Future<Void> const& switchedState ) {
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new RecoveryTerminateOnConflictActor(dbgid, fullyRecovered, onConflict, switchedState));
															#line 391 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 83 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 396 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via recruitNewMaster()
															#line 84 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class RecruitNewMasterActor>
															#line 84 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecruitNewMasterActorState {
															#line 403 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 84 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitNewMasterActorState(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,MasterInterface* const& newMaster) 
															#line 84 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 84 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : cluster(cluster),
															#line 84 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   db(db),
															#line 84 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   newMaster(newMaster),
															#line 87 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   fNewMaster(),
															#line 88 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   masterWorker()
															#line 418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("recruitNewMaster", reinterpret_cast<unsigned long>(this));

	}
	~RecruitNewMasterActorState() 
	{
		fdb_probe_actor_destroy("recruitNewMaster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 90 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 433 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecruitNewMasterActorState();
		static_cast<RecruitNewMasterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 94 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::map<Optional<Standalone<StringRef>>, int> id_used;
															#line 95 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		id_used[cluster->clusterControllerProcessId]++;
															#line 96 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		masterWorker = cluster->getWorkerForRoleInDatacenter( cluster->clusterControllerDcId, ProcessClass::Master, ProcessClass::NeverAssign, db->config, id_used);
															#line 98 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if ((masterWorker.worker.processClass.machineClassFitness(ProcessClass::Master) > SERVER_KNOBS->EXPECTED_MASTER_FITNESS || masterWorker.worker.interf.locality.processId() == cluster->clusterControllerProcessId) && !cluster->goodRecruitmentTime.isReady())
															#line 469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("RecruitNewMaster", cluster->id) .detail("Fitness", masterWorker.worker.processClass.machineClassFitness(ProcessClass::Master));
															#line 104 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 104 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<RecruitNewMasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 477 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RecruitNewMasterActor*>(this)->actor_wait_state = 1;
															#line 104 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecruitNewMasterActor, 0, Void >*>(static_cast<RecruitNewMasterActor*>(this)));
															#line 482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		RecruitMasterRequest rmq;
															#line 108 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		rmq.lifetime = db->serverInfo->get().masterLifetime;
															#line 109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		rmq.forceRecovery = db->forceRecovery;
															#line 111 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		cluster->masterProcessId = masterWorker.worker.interf.locality.processId();
															#line 112 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		cluster->db.unfinishedRecoveries++;
															#line 113 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		fNewMaster = masterWorker.worker.interf.master.tryGetReply(rmq);
															#line 114 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = ready(fNewMaster) || db->forceMasterFailure.onTrigger();
															#line 114 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitNewMasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 510 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RecruitNewMasterActor*>(this)->actor_wait_state = 2;
															#line 114 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RecruitNewMasterActor, 1, Void >*>(static_cast<RecruitNewMasterActor*>(this)));
															#line 515 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecruitNewMasterActor*>(this)->actor_wait_state > 0) static_cast<RecruitNewMasterActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitNewMasterActor*>(this)->ActorCallback< RecruitNewMasterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitNewMasterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecruitNewMasterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecruitNewMasterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 115 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (fNewMaster.isReady() && fNewMaster.get().present())
															#line 611 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 116 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("RecruitNewMaster", cluster->id).detail("Recruited", fNewMaster.get().get().id());
															#line 119 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("RecruitedMasterWorker", cluster->id) .detail("Address", fNewMaster.get().get().address()) .trackLatest(cluster->recruitedMasterWorkerEventHolder->trackingKey);
															#line 123 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			*newMaster = fNewMaster.get().get();
															#line 125 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<RecruitNewMasterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecruitNewMasterActorState(); static_cast<RecruitNewMasterActor*>(this)->destroy(); return 0; }
															#line 621 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<RecruitNewMasterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RecruitNewMasterActorState();
			static_cast<RecruitNewMasterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 127 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "clusterWatchDatabase() !newMaster.present()");
															#line 128 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->MASTER_SPIN_DELAY);
															#line 128 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<RecruitNewMasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 635 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<RecruitNewMasterActor*>(this)->actor_wait_state = 3;
															#line 128 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecruitNewMasterActor, 2, Void >*>(static_cast<RecruitNewMasterActor*>(this)));
															#line 640 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 115 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (fNewMaster.isReady() && fNewMaster.get().present())
															#line 650 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 116 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("RecruitNewMaster", cluster->id).detail("Recruited", fNewMaster.get().get().id());
															#line 119 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("RecruitedMasterWorker", cluster->id) .detail("Address", fNewMaster.get().get().address()) .trackLatest(cluster->recruitedMasterWorkerEventHolder->trackingKey);
															#line 123 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			*newMaster = fNewMaster.get().get();
															#line 125 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<RecruitNewMasterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecruitNewMasterActorState(); static_cast<RecruitNewMasterActor*>(this)->destroy(); return 0; }
															#line 660 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<RecruitNewMasterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RecruitNewMasterActorState();
			static_cast<RecruitNewMasterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 127 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "clusterWatchDatabase() !newMaster.present()");
															#line 128 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->MASTER_SPIN_DELAY);
															#line 128 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<RecruitNewMasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 674 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<RecruitNewMasterActor*>(this)->actor_wait_state = 3;
															#line 128 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecruitNewMasterActor, 2, Void >*>(static_cast<RecruitNewMasterActor*>(this)));
															#line 679 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RecruitNewMasterActor*>(this)->actor_wait_state > 0) static_cast<RecruitNewMasterActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitNewMasterActor*>(this)->ActorCallback< RecruitNewMasterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitNewMasterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RecruitNewMasterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RecruitNewMasterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RecruitNewMasterActor*>(this)->actor_wait_state > 0) static_cast<RecruitNewMasterActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitNewMasterActor*>(this)->ActorCallback< RecruitNewMasterActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitNewMasterActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RecruitNewMasterActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RecruitNewMasterActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 84 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterControllerData* cluster;
															#line 84 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 84 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	MasterInterface* newMaster;
															#line 87 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<ErrorOr<MasterInterface>> fNewMaster;
															#line 88 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	WorkerFitnessInfo masterWorker;
															#line 863 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via recruitNewMaster()
															#line 84 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecruitNewMasterActor final : public Actor<Void>, public ActorCallback< RecruitNewMasterActor, 0, Void >, public ActorCallback< RecruitNewMasterActor, 1, Void >, public ActorCallback< RecruitNewMasterActor, 2, Void >, public FastAllocated<RecruitNewMasterActor>, public RecruitNewMasterActorState<RecruitNewMasterActor> {
															#line 868 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<RecruitNewMasterActor>::operator new;
	using FastAllocated<RecruitNewMasterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7937874789726732032UL, 8633038650878302720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecruitNewMasterActor, 0, Void >;
friend struct ActorCallback< RecruitNewMasterActor, 1, Void >;
friend struct ActorCallback< RecruitNewMasterActor, 2, Void >;
															#line 84 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitNewMasterActor(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,MasterInterface* const& newMaster) 
															#line 887 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   RecruitNewMasterActorState<RecruitNewMasterActor>(cluster, db, newMaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recruitNewMaster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3732730840550338304UL, 7033732201624115456UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitNewMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recruitNewMaster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recruitNewMaster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecruitNewMasterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RecruitNewMasterActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RecruitNewMasterActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 84 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> recruitNewMaster( ClusterControllerData* const& cluster, ClusterControllerData::DBInfo* const& db, MasterInterface* const& newMaster ) {
															#line 84 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new RecruitNewMasterActor(cluster, db, newMaster));
															#line 922 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 132 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 927 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via clusterRecruitFromConfiguration()
															#line 133 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class ClusterRecruitFromConfigurationActor>
															#line 133 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ClusterRecruitFromConfigurationActorState {
															#line 934 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 133 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterRecruitFromConfigurationActorState(ClusterControllerData* const& self,Reference<RecruitWorkersInfo> const& req) 
															#line 133 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 133 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 133 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   req(req)
															#line 943 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this));

	}
	~ClusterRecruitFromConfigurationActorState() 
	{
		fdb_probe_actor_destroy("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 135 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "ClusterController RecruitTLogsRequest");
															#line 136 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 960 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterRecruitFromConfigurationActorState();
		static_cast<ClusterRecruitFromConfigurationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 138 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req->rep = self->findWorkersForConfiguration(req->req);
															#line 139 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<ClusterRecruitFromConfigurationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClusterRecruitFromConfigurationActorState(); static_cast<ClusterRecruitFromConfigurationActor*>(this)->destroy(); return 0; }
															#line 993 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<ClusterRecruitFromConfigurationActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ClusterRecruitFromConfigurationActorState();
			static_cast<ClusterRecruitFromConfigurationActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = lowPriorityDelay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1013 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state = 3;
															#line 159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClusterRecruitFromConfigurationActor, 2, Void >*>(static_cast<ClusterRecruitFromConfigurationActor*>(this)));
															#line 1018 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 141 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (e.code() == error_code_no_more_servers && self->goodRecruitmentTime.isReady())
															#line 1028 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 142 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->outstandingRecruitmentRequests.push_back(req);
															#line 143 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent(SevWarn, "RecruitFromConfigurationNotAvailable", self->id).error(e);
															#line 144 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Void> __when_expr_0 = req->waitForCompletion.onTrigger();
															#line 144 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1038 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state = 1;
															#line 144 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterRecruitFromConfigurationActor, 0, Void >*>(static_cast<ClusterRecruitFromConfigurationActor*>(this)));
															#line 1043 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 146 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (e.code() == error_code_operation_failed || e.code() == error_code_no_more_servers)
															#line 1050 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 148 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent("RecruitFromConfigurationRetry", self->id) .error(e) .detail("GoodRecruitmentTimeReady", self->goodRecruitmentTime.isReady());
															#line 151 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					;
															#line 1056 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					loopDepth = a_body1loopBody1Catch1loopHead1(loopDepth);
				}
				else
				{
															#line 155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent(SevError, "RecruitFromConfigurationError", self->id).error(e);
															#line 156 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1065 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
															#line 145 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<ClusterRecruitFromConfigurationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClusterRecruitFromConfigurationActorState(); static_cast<ClusterRecruitFromConfigurationActor*>(this)->destroy(); return 0; }
															#line 1087 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<ClusterRecruitFromConfigurationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClusterRecruitFromConfigurationActorState();
		static_cast<ClusterRecruitFromConfigurationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
															#line 145 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<ClusterRecruitFromConfigurationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClusterRecruitFromConfigurationActorState(); static_cast<ClusterRecruitFromConfigurationActor*>(this)->destroy(); return 0; }
															#line 1099 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<ClusterRecruitFromConfigurationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClusterRecruitFromConfigurationActorState();
		static_cast<ClusterRecruitFromConfigurationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecruitFromConfigurationActor*>(this)->ActorCallback< ClusterRecruitFromConfigurationActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecruitFromConfigurationActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterRecruitFromConfigurationActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterRecruitFromConfigurationActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1Catch1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1(int loopDepth) 
	{
															#line 151 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!(!self->goodRecruitmentTime.isReady()))
															#line 1205 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
			return a_body1loopBody1Catch1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 152 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = lowPriorityDelay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 152 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1213 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1Catch1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state = 2;
															#line 152 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterRecruitFromConfigurationActor, 1, Void >*>(static_cast<ClusterRecruitFromConfigurationActor*>(this)));
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1Catch1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1Catch1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1Catch1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecruitFromConfigurationActor*>(this)->ActorCallback< ClusterRecruitFromConfigurationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecruitFromConfigurationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterRecruitFromConfigurationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterRecruitFromConfigurationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecruitFromConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecruitFromConfigurationActor*>(this)->ActorCallback< ClusterRecruitFromConfigurationActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecruitFromConfigurationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClusterRecruitFromConfigurationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClusterRecruitFromConfigurationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 133 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterControllerData* self;
															#line 133 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<RecruitWorkersInfo> req;
															#line 1414 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via clusterRecruitFromConfiguration()
															#line 133 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ClusterRecruitFromConfigurationActor final : public Actor<Void>, public ActorCallback< ClusterRecruitFromConfigurationActor, 0, Void >, public ActorCallback< ClusterRecruitFromConfigurationActor, 1, Void >, public ActorCallback< ClusterRecruitFromConfigurationActor, 2, Void >, public FastAllocated<ClusterRecruitFromConfigurationActor>, public ClusterRecruitFromConfigurationActorState<ClusterRecruitFromConfigurationActor> {
															#line 1419 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<ClusterRecruitFromConfigurationActor>::operator new;
	using FastAllocated<ClusterRecruitFromConfigurationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5428630969251899392UL, 13125016146650845440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterRecruitFromConfigurationActor, 0, Void >;
friend struct ActorCallback< ClusterRecruitFromConfigurationActor, 1, Void >;
friend struct ActorCallback< ClusterRecruitFromConfigurationActor, 2, Void >;
															#line 133 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterRecruitFromConfigurationActor(ClusterControllerData* const& self,Reference<RecruitWorkersInfo> const& req) 
															#line 1438 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   ClusterRecruitFromConfigurationActorState<ClusterRecruitFromConfigurationActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12674343851221204992UL, 6486113992575869184UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterRecruitFromConfiguration");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterRecruitFromConfiguration", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterRecruitFromConfigurationActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClusterRecruitFromConfigurationActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClusterRecruitFromConfigurationActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 133 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> clusterRecruitFromConfiguration( ClusterControllerData* const& self, Reference<RecruitWorkersInfo> const& req ) {
															#line 133 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new ClusterRecruitFromConfigurationActor(self, req));
															#line 1473 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 162 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 1478 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via clusterRecruitRemoteFromConfiguration()
															#line 163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class ClusterRecruitRemoteFromConfigurationActor>
															#line 163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ClusterRecruitRemoteFromConfigurationActorState {
															#line 1485 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterRecruitRemoteFromConfigurationActorState(ClusterControllerData* const& self,Reference<RecruitRemoteWorkersInfo> const& req) 
															#line 163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   req(req)
															#line 1494 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this));

	}
	~ClusterRecruitRemoteFromConfigurationActorState() 
	{
		fdb_probe_actor_destroy("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 167 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "ClusterController RecruitTLogsRequest Remote");
															#line 168 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 1511 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterRecruitRemoteFromConfigurationActorState();
		static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 170 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			auto rep = self->findRemoteWorkersForConfiguration(req->req);
															#line 171 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->SAV<RecruitRemoteFromConfigurationReply>::futures) { (void)(rep); this->~ClusterRecruitRemoteFromConfigurationActorState(); static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->destroy(); return 0; }
															#line 1544 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->SAV< RecruitRemoteFromConfigurationReply >::value()) RecruitRemoteFromConfigurationReply(rep);
			this->~ClusterRecruitRemoteFromConfigurationActorState();
			static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 191 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = lowPriorityDelay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 191 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1564 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state = 3;
															#line 191 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 2, Void >*>(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)));
															#line 1569 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (e.code() == error_code_no_more_servers && self->goodRemoteRecruitmentTime.isReady())
															#line 1579 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 174 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->outstandingRemoteRecruitmentRequests.push_back(req);
															#line 175 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent(SevWarn, "RecruitRemoteFromConfigurationNotAvailable", self->id).error(e);
															#line 176 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Void> __when_expr_0 = req->waitForCompletion.onTrigger();
															#line 176 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1589 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state = 1;
															#line 176 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 0, Void >*>(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)));
															#line 1594 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 178 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (e.code() == error_code_operation_failed || e.code() == error_code_no_more_servers)
															#line 1601 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 180 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent("RecruitRemoteFromConfigurationRetry", self->id) .error(e) .detail("GoodRecruitmentTimeReady", self->goodRemoteRecruitmentTime.isReady());
															#line 183 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					;
															#line 1607 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					loopDepth = a_body1loopBody1Catch1loopHead1(loopDepth);
				}
				else
				{
															#line 187 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent(SevError, "RecruitRemoteFromConfigurationError", self->id).error(e);
															#line 188 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1616 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
															#line 177 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->SAV<RecruitRemoteFromConfigurationReply>::futures) { (void)(req->rep); this->~ClusterRecruitRemoteFromConfigurationActorState(); static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->destroy(); return 0; }
															#line 1638 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->SAV< RecruitRemoteFromConfigurationReply >::value()) RecruitRemoteFromConfigurationReply(req->rep);
		this->~ClusterRecruitRemoteFromConfigurationActorState();
		static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
															#line 177 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->SAV<RecruitRemoteFromConfigurationReply>::futures) { (void)(req->rep); this->~ClusterRecruitRemoteFromConfigurationActorState(); static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->destroy(); return 0; }
															#line 1650 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->SAV< RecruitRemoteFromConfigurationReply >::value()) RecruitRemoteFromConfigurationReply(req->rep);
		this->~ClusterRecruitRemoteFromConfigurationActorState();
		static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1Catch1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1(int loopDepth) 
	{
															#line 183 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!(!self->goodRemoteRecruitmentTime.isReady()))
															#line 1756 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
			return a_body1loopBody1Catch1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 184 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = lowPriorityDelay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 184 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1764 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1Catch1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state = 2;
															#line 184 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 1, Void >*>(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)));
															#line 1769 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1Catch1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1Catch1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1Catch1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterControllerData* self;
															#line 163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<RecruitRemoteWorkersInfo> req;
															#line 1965 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via clusterRecruitRemoteFromConfiguration()
															#line 163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ClusterRecruitRemoteFromConfigurationActor final : public Actor<RecruitRemoteFromConfigurationReply>, public ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 0, Void >, public ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 1, Void >, public ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 2, Void >, public FastAllocated<ClusterRecruitRemoteFromConfigurationActor>, public ClusterRecruitRemoteFromConfigurationActorState<ClusterRecruitRemoteFromConfigurationActor> {
															#line 1970 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<ClusterRecruitRemoteFromConfigurationActor>::operator new;
	using FastAllocated<ClusterRecruitRemoteFromConfigurationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15104348363791426816UL, 365821362330595072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RecruitRemoteFromConfigurationReply>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 0, Void >;
friend struct ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 1, Void >;
friend struct ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 2, Void >;
															#line 163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterRecruitRemoteFromConfigurationActor(ClusterControllerData* const& self,Reference<RecruitRemoteWorkersInfo> const& req) 
															#line 1989 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<RecruitRemoteFromConfigurationReply>(),
		   ClusterRecruitRemoteFromConfigurationActorState<ClusterRecruitRemoteFromConfigurationActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(345303134791771392UL, 3493563476356565248UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecruitRemoteFromConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterRecruitRemoteFromConfiguration");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterRecruitRemoteFromConfiguration", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClusterRecruitRemoteFromConfigurationActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<RecruitRemoteFromConfigurationReply> clusterRecruitRemoteFromConfiguration( ClusterControllerData* const& self, Reference<RecruitRemoteWorkersInfo> const& req ) {
															#line 163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<RecruitRemoteFromConfigurationReply>(new ClusterRecruitRemoteFromConfigurationActor(self, req));
															#line 2024 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 194 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 2029 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via newCommitProxies()
															#line 195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class NewCommitProxiesActor>
															#line 195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewCommitProxiesActorState {
															#line 2036 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewCommitProxiesActorState(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recr) 
															#line 195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   recr(recr)
															#line 2045 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("newCommitProxies", reinterpret_cast<unsigned long>(this));

	}
	~NewCommitProxiesActorState() 
	{
		fdb_probe_actor_destroy("newCommitProxies", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			std::vector<Future<CommitProxyInterface>> initializationReplies;
															#line 197 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for(int i = 0;i < recr.commitProxies.size();i++) {
															#line 198 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				InitializeCommitProxyRequest req;
															#line 199 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.master = self->masterInterface;
															#line 200 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.masterLifetime = self->masterLifetime;
															#line 201 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.recoveryCount = self->cstate.myDBState.recoveryCount + 1;
															#line 202 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.recoveryTransactionVersion = self->recoveryTransactionVersion;
															#line 203 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.firstProxy = i == 0;
															#line 204 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.encryptMode = getEncryptionAtRest(self->configuration);
															#line 205 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.commitProxyIndex = i;
															#line 206 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent("CommitProxyReplies", self->dbgid) .detail("WorkerID", recr.commitProxies[i].id()) .detail("RecoveryTxnVersion", self->recoveryTransactionVersion) .detail("EncryptMode", req.encryptMode.toString()) .detail("FirstProxy", req.firstProxy ? "True" : "False") .detail("CommitProxyIndex", req.commitProxyIndex);
															#line 212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				initializationReplies.push_back( transformErrors(throwErrorOr(recr.commitProxies[i].commitProxy.getReplyUnlessFailedFor( req, SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), commit_proxy_failed()));
															#line 2082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<std::vector<CommitProxyInterface>> __when_expr_0 = getAll(initializationReplies);
															#line 218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<NewCommitProxiesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2088 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<NewCommitProxiesActor*>(this)->actor_wait_state = 1;
															#line 218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewCommitProxiesActor, 0, std::vector<CommitProxyInterface> >*>(static_cast<NewCommitProxiesActor*>(this)));
															#line 2093 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewCommitProxiesActorState();
		static_cast<NewCommitProxiesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<CommitProxyInterface> const& newRecruits,int loopDepth) 
	{
															#line 219 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("CommitProxyInitializationComplete", self->dbgid).log();
															#line 221 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->commitProxies = newRecruits;
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<NewCommitProxiesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewCommitProxiesActorState(); static_cast<NewCommitProxiesActor*>(this)->destroy(); return 0; }
															#line 2120 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<NewCommitProxiesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewCommitProxiesActorState();
		static_cast<NewCommitProxiesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<CommitProxyInterface> && newRecruits,int loopDepth) 
	{
															#line 219 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("CommitProxyInitializationComplete", self->dbgid).log();
															#line 221 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->commitProxies = newRecruits;
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<NewCommitProxiesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewCommitProxiesActorState(); static_cast<NewCommitProxiesActor*>(this)->destroy(); return 0; }
															#line 2136 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<NewCommitProxiesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewCommitProxiesActorState();
		static_cast<NewCommitProxiesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<CommitProxyInterface> const& newRecruits,int loopDepth) 
	{
		loopDepth = a_body1cont1(newRecruits, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<CommitProxyInterface> && newRecruits,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(newRecruits), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewCommitProxiesActor*>(this)->actor_wait_state > 0) static_cast<NewCommitProxiesActor*>(this)->actor_wait_state = 0;
		static_cast<NewCommitProxiesActor*>(this)->ActorCallback< NewCommitProxiesActor, 0, std::vector<CommitProxyInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< NewCommitProxiesActor, 0, std::vector<CommitProxyInterface> >*,std::vector<CommitProxyInterface> const& value) 
	{
		fdb_probe_actor_enter("newCommitProxies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewCommitProxiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newCommitProxies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewCommitProxiesActor, 0, std::vector<CommitProxyInterface> >*,std::vector<CommitProxyInterface> && value) 
	{
		fdb_probe_actor_enter("newCommitProxies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewCommitProxiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newCommitProxies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewCommitProxiesActor, 0, std::vector<CommitProxyInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("newCommitProxies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewCommitProxiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newCommitProxies", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitFromConfigurationReply recr;
															#line 2223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via newCommitProxies()
															#line 195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewCommitProxiesActor final : public Actor<Void>, public ActorCallback< NewCommitProxiesActor, 0, std::vector<CommitProxyInterface> >, public FastAllocated<NewCommitProxiesActor>, public NewCommitProxiesActorState<NewCommitProxiesActor> {
															#line 2228 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<NewCommitProxiesActor>::operator new;
	using FastAllocated<NewCommitProxiesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4049938661994468352UL, 9332596546631738368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewCommitProxiesActor, 0, std::vector<CommitProxyInterface> >;
															#line 195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewCommitProxiesActor(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recr) 
															#line 2245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   NewCommitProxiesActorState<NewCommitProxiesActor>(self, recr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newCommitProxies", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11322762972454658304UL, 4353504431684175360UL);
		ActorExecutionContextHelper __helper(static_cast<NewCommitProxiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newCommitProxies");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newCommitProxies", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewCommitProxiesActor, 0, std::vector<CommitProxyInterface> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> newCommitProxies( Reference<ClusterRecoveryData> const& self, RecruitFromConfigurationReply const& recr ) {
															#line 195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new NewCommitProxiesActor(self, recr));
															#line 2278 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 225 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 2283 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via newGrvProxies()
															#line 226 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class NewGrvProxiesActor>
															#line 226 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewGrvProxiesActorState {
															#line 2290 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 226 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewGrvProxiesActorState(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recr) 
															#line 226 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 226 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 226 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   recr(recr)
															#line 2299 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("newGrvProxies", reinterpret_cast<unsigned long>(this));

	}
	~NewGrvProxiesActorState() 
	{
		fdb_probe_actor_destroy("newGrvProxies", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 227 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			std::vector<Future<GrvProxyInterface>> initializationReplies;
															#line 228 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for(int i = 0;i < recr.grvProxies.size();i++) {
															#line 229 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				InitializeGrvProxyRequest req;
															#line 230 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.master = self->masterInterface;
															#line 231 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.masterLifetime = self->masterLifetime;
															#line 232 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.recoveryCount = self->cstate.myDBState.recoveryCount + 1;
															#line 233 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent("GrvProxyReplies", self->dbgid).detail("WorkerID", recr.grvProxies[i].id());
															#line 234 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				initializationReplies.push_back( transformErrors(throwErrorOr(recr.grvProxies[i].grvProxy.getReplyUnlessFailedFor( req, SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), grv_proxy_failed()));
															#line 2328 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 240 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<std::vector<GrvProxyInterface>> __when_expr_0 = getAll(initializationReplies);
															#line 240 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<NewGrvProxiesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2334 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<NewGrvProxiesActor*>(this)->actor_wait_state = 1;
															#line 240 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewGrvProxiesActor, 0, std::vector<GrvProxyInterface> >*>(static_cast<NewGrvProxiesActor*>(this)));
															#line 2339 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewGrvProxiesActorState();
		static_cast<NewGrvProxiesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<GrvProxyInterface> const& newRecruits,int loopDepth) 
	{
															#line 241 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("GrvProxyInitializationComplete", self->dbgid).log();
															#line 242 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->grvProxies = newRecruits;
															#line 243 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<NewGrvProxiesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewGrvProxiesActorState(); static_cast<NewGrvProxiesActor*>(this)->destroy(); return 0; }
															#line 2366 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<NewGrvProxiesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewGrvProxiesActorState();
		static_cast<NewGrvProxiesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<GrvProxyInterface> && newRecruits,int loopDepth) 
	{
															#line 241 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("GrvProxyInitializationComplete", self->dbgid).log();
															#line 242 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->grvProxies = newRecruits;
															#line 243 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<NewGrvProxiesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewGrvProxiesActorState(); static_cast<NewGrvProxiesActor*>(this)->destroy(); return 0; }
															#line 2382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<NewGrvProxiesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewGrvProxiesActorState();
		static_cast<NewGrvProxiesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<GrvProxyInterface> const& newRecruits,int loopDepth) 
	{
		loopDepth = a_body1cont1(newRecruits, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<GrvProxyInterface> && newRecruits,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(newRecruits), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewGrvProxiesActor*>(this)->actor_wait_state > 0) static_cast<NewGrvProxiesActor*>(this)->actor_wait_state = 0;
		static_cast<NewGrvProxiesActor*>(this)->ActorCallback< NewGrvProxiesActor, 0, std::vector<GrvProxyInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< NewGrvProxiesActor, 0, std::vector<GrvProxyInterface> >*,std::vector<GrvProxyInterface> const& value) 
	{
		fdb_probe_actor_enter("newGrvProxies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewGrvProxiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newGrvProxies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewGrvProxiesActor, 0, std::vector<GrvProxyInterface> >*,std::vector<GrvProxyInterface> && value) 
	{
		fdb_probe_actor_enter("newGrvProxies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewGrvProxiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newGrvProxies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewGrvProxiesActor, 0, std::vector<GrvProxyInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("newGrvProxies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewGrvProxiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newGrvProxies", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 226 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 226 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitFromConfigurationReply recr;
															#line 2469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via newGrvProxies()
															#line 226 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewGrvProxiesActor final : public Actor<Void>, public ActorCallback< NewGrvProxiesActor, 0, std::vector<GrvProxyInterface> >, public FastAllocated<NewGrvProxiesActor>, public NewGrvProxiesActorState<NewGrvProxiesActor> {
															#line 2474 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<NewGrvProxiesActor>::operator new;
	using FastAllocated<NewGrvProxiesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9533887369692468736UL, 1992967894862640384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewGrvProxiesActor, 0, std::vector<GrvProxyInterface> >;
															#line 226 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewGrvProxiesActor(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recr) 
															#line 2491 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   NewGrvProxiesActorState<NewGrvProxiesActor>(self, recr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newGrvProxies", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11438231847512378624UL, 17857379825113892352UL);
		ActorExecutionContextHelper __helper(static_cast<NewGrvProxiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newGrvProxies");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newGrvProxies", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewGrvProxiesActor, 0, std::vector<GrvProxyInterface> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 226 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> newGrvProxies( Reference<ClusterRecoveryData> const& self, RecruitFromConfigurationReply const& recr ) {
															#line 226 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new NewGrvProxiesActor(self, recr));
															#line 2524 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 2529 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via newResolvers()
															#line 246 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class NewResolversActor>
															#line 246 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewResolversActorState {
															#line 2536 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 246 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewResolversActorState(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recr) 
															#line 246 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 246 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 246 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   recr(recr)
															#line 2545 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("newResolvers", reinterpret_cast<unsigned long>(this));

	}
	~NewResolversActorState() 
	{
		fdb_probe_actor_destroy("newResolvers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 247 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			std::vector<Future<ResolverInterface>> initializationReplies;
															#line 248 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for(int i = 0;i < recr.resolvers.size();i++) {
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				InitializeResolverRequest req;
															#line 250 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.masterLifetime = self->masterLifetime;
															#line 251 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.recoveryCount = self->cstate.myDBState.recoveryCount + 1;
															#line 252 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.commitProxyCount = recr.commitProxies.size();
															#line 253 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.resolverCount = recr.resolvers.size();
															#line 254 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.encryptMode = getEncryptionAtRest(self->configuration);
															#line 255 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent("ResolverReplies", self->dbgid).detail("WorkerID", recr.resolvers[i].id());
															#line 256 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				initializationReplies.push_back( transformErrors(throwErrorOr(recr.resolvers[i].resolver.getReplyUnlessFailedFor( req, SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), resolver_failed()));
															#line 2578 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<std::vector<ResolverInterface>> __when_expr_0 = getAll(initializationReplies);
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<NewResolversActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2584 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<NewResolversActor*>(this)->actor_wait_state = 1;
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewResolversActor, 0, std::vector<ResolverInterface> >*>(static_cast<NewResolversActor*>(this)));
															#line 2589 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewResolversActorState();
		static_cast<NewResolversActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ResolverInterface> const& newRecruits,int loopDepth) 
	{
															#line 263 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("ResolverInitializationComplete", self->dbgid).log();
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->resolvers = newRecruits;
															#line 266 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<NewResolversActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewResolversActorState(); static_cast<NewResolversActor*>(this)->destroy(); return 0; }
															#line 2616 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<NewResolversActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewResolversActorState();
		static_cast<NewResolversActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ResolverInterface> && newRecruits,int loopDepth) 
	{
															#line 263 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("ResolverInitializationComplete", self->dbgid).log();
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->resolvers = newRecruits;
															#line 266 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<NewResolversActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewResolversActorState(); static_cast<NewResolversActor*>(this)->destroy(); return 0; }
															#line 2632 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<NewResolversActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewResolversActorState();
		static_cast<NewResolversActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<ResolverInterface> const& newRecruits,int loopDepth) 
	{
		loopDepth = a_body1cont1(newRecruits, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<ResolverInterface> && newRecruits,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(newRecruits), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewResolversActor*>(this)->actor_wait_state > 0) static_cast<NewResolversActor*>(this)->actor_wait_state = 0;
		static_cast<NewResolversActor*>(this)->ActorCallback< NewResolversActor, 0, std::vector<ResolverInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< NewResolversActor, 0, std::vector<ResolverInterface> >*,std::vector<ResolverInterface> const& value) 
	{
		fdb_probe_actor_enter("newResolvers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newResolvers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewResolversActor, 0, std::vector<ResolverInterface> >*,std::vector<ResolverInterface> && value) 
	{
		fdb_probe_actor_enter("newResolvers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newResolvers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewResolversActor, 0, std::vector<ResolverInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("newResolvers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newResolvers", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 246 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 246 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitFromConfigurationReply recr;
															#line 2719 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via newResolvers()
															#line 246 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewResolversActor final : public Actor<Void>, public ActorCallback< NewResolversActor, 0, std::vector<ResolverInterface> >, public FastAllocated<NewResolversActor>, public NewResolversActorState<NewResolversActor> {
															#line 2724 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<NewResolversActor>::operator new;
	using FastAllocated<NewResolversActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2941050451726397440UL, 3425526406178345984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewResolversActor, 0, std::vector<ResolverInterface> >;
															#line 246 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewResolversActor(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recr) 
															#line 2741 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   NewResolversActorState<NewResolversActor>(self, recr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newResolvers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8367740995656328448UL, 13882773353061823744UL);
		ActorExecutionContextHelper __helper(static_cast<NewResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newResolvers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newResolvers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewResolversActor, 0, std::vector<ResolverInterface> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 246 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> newResolvers( Reference<ClusterRecoveryData> const& self, RecruitFromConfigurationReply const& recr ) {
															#line 246 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new NewResolversActor(self, recr));
															#line 2774 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 268 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 2779 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via newTLogServers()
															#line 269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class NewTLogServersActor>
															#line 269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewTLogServersActorState {
															#line 2786 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewTLogServersActorState(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recr,Reference<ILogSystem> const& oldLogSystem,std::vector<Standalone<CommitTransactionRef>>* const& initialConfChanges) 
															#line 269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   recr(recr),
															#line 269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   oldLogSystem(oldLogSystem),
															#line 269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   initialConfChanges(initialConfChanges)
															#line 2799 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("newTLogServers", reinterpret_cast<unsigned long>(this));

	}
	~NewTLogServersActorState() 
	{
		fdb_probe_actor_destroy("newTLogServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->configuration.usableRegions > 1)
															#line 2814 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 274 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				remoteDcId = self->remoteDcIds.size() ? self->remoteDcIds[0] : Optional<Key>();
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (!self->dcId_locality.contains(recr.dcId))
															#line 2820 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 276 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					int8_t loc = self->getNextLocality();
															#line 277 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					Standalone<CommitTransactionRef> tr;
															#line 278 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					tr.set(tr.arena(), tagLocalityListKeyFor(recr.dcId), tagLocalityListValue(loc));
															#line 279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					initialConfChanges->push_back(tr);
															#line 280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					self->dcId_locality[recr.dcId] = loc;
															#line 281 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent(SevWarn, "UnknownPrimaryDCID", self->dbgid).detail("PrimaryId", recr.dcId).detail("Loc", loc);
															#line 2834 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
															#line 284 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (!self->dcId_locality.contains(remoteDcId))
															#line 2838 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 285 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					int8_t loc = self->getNextLocality();
															#line 286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					Standalone<CommitTransactionRef> tr;
															#line 287 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					tr.set(tr.arena(), tagLocalityListKeyFor(remoteDcId), tagLocalityListValue(loc));
															#line 288 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					initialConfChanges->push_back(tr);
															#line 289 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					self->dcId_locality[remoteDcId] = loc;
															#line 290 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent(SevWarn, "UnknownRemoteDCID", self->dbgid).detail("RemoteId", remoteDcId).detail("Loc", loc);
															#line 2852 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
															#line 293 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				std::vector<UID> exclusionWorkerIds;
															#line 294 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				std::transform(recr.tLogs.begin(), recr.tLogs.end(), std::back_inserter(exclusionWorkerIds), [](const WorkerInterface& in) { return in.id(); });
															#line 298 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				std::transform(recr.satelliteTLogs.begin(), recr.satelliteTLogs.end(), std::back_inserter(exclusionWorkerIds), [](const WorkerInterface& in) { return in.id(); });
															#line 303 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				RecruitRemoteFromConfigurationRequest remoteRecruitReq( self->configuration, remoteDcId, recr.tLogs.size() * std::max<int>(1, self->configuration.desiredLogRouterCount / std::max<int>(1, recr.tLogs.size())), exclusionWorkerIds);
															#line 309 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				remoteRecruitReq.dbgId = self->dbgid;
															#line 310 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				recruitWorkersInfo = makeReference<RecruitRemoteWorkersInfo>(remoteRecruitReq);
															#line 312 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				recruitWorkersInfo->dbgId = self->dbgid;
															#line 313 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				Future<RecruitRemoteFromConfigurationReply> fRemoteWorkers = clusterRecruitRemoteFromConfiguration(self->controllerData, recruitWorkersInfo);
															#line 316 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->primaryLocality = self->dcId_locality[recr.dcId];
															#line 317 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->logSystem = Reference<ILogSystem>();
															#line 318 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Reference<ILogSystem>> __when_expr_0 = oldLogSystem->newEpoch(recr, fRemoteWorkers, self->configuration, self->cstate.myDBState.recoveryCount + 1, self->recoveryTransactionVersion, self->primaryLocality, self->dcId_locality[remoteDcId], self->allTags, self->recruitmentStalled);
															#line 318 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<NewTLogServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2878 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<NewTLogServersActor*>(this)->actor_wait_state = 1;
															#line 318 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewTLogServersActor, 0, Reference<ILogSystem> >*>(static_cast<NewTLogServersActor*>(this)));
															#line 2883 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 329 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->primaryLocality = tagLocalitySpecial;
															#line 330 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->logSystem = Reference<ILogSystem>();
															#line 331 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Reference<ILogSystem>> __when_expr_1 = oldLogSystem->newEpoch(recr, Never(), self->configuration, self->cstate.myDBState.recoveryCount + 1, self->recoveryTransactionVersion, self->primaryLocality, tagLocalitySpecial, self->allTags, self->recruitmentStalled);
															#line 331 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<NewTLogServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2896 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<NewTLogServersActor*>(this)->actor_wait_state = 2;
															#line 331 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NewTLogServersActor, 1, Reference<ILogSystem> >*>(static_cast<NewTLogServersActor*>(this)));
															#line 2901 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewTLogServersActorState();
		static_cast<NewTLogServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 342 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<NewTLogServersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewTLogServersActorState(); static_cast<NewTLogServersActor*>(this)->destroy(); return 0; }
															#line 2925 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<NewTLogServersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewTLogServersActorState();
		static_cast<NewTLogServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Reference<ILogSystem> const& newLogSystem,int loopDepth) 
	{
															#line 327 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem = newLogSystem;
															#line 2937 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Reference<ILogSystem> && newLogSystem,int loopDepth) 
	{
															#line 327 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem = newLogSystem;
															#line 2946 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<ILogSystem> const& newLogSystem,int loopDepth) 
	{
		loopDepth = a_body1cont2(newLogSystem, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<ILogSystem> && newLogSystem,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(newLogSystem), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewTLogServersActor*>(this)->actor_wait_state > 0) static_cast<NewTLogServersActor*>(this)->actor_wait_state = 0;
		static_cast<NewTLogServersActor*>(this)->ActorCallback< NewTLogServersActor, 0, Reference<ILogSystem> >::remove();

	}
	void a_callback_fire(ActorCallback< NewTLogServersActor, 0, Reference<ILogSystem> >*,Reference<ILogSystem> const& value) 
	{
		fdb_probe_actor_enter("newTLogServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewTLogServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newTLogServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewTLogServersActor, 0, Reference<ILogSystem> >*,Reference<ILogSystem> && value) 
	{
		fdb_probe_actor_enter("newTLogServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewTLogServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newTLogServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewTLogServersActor, 0, Reference<ILogSystem> >*,Error err) 
	{
		fdb_probe_actor_enter("newTLogServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewTLogServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newTLogServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(Reference<ILogSystem> const& newLogSystem,int loopDepth) 
	{
															#line 340 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem = newLogSystem;
															#line 3030 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Reference<ILogSystem> && newLogSystem,int loopDepth) 
	{
															#line 340 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem = newLogSystem;
															#line 3039 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Reference<ILogSystem> const& newLogSystem,int loopDepth) 
	{
		loopDepth = a_body1cont6(newLogSystem, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Reference<ILogSystem> && newLogSystem,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(newLogSystem), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<NewTLogServersActor*>(this)->actor_wait_state > 0) static_cast<NewTLogServersActor*>(this)->actor_wait_state = 0;
		static_cast<NewTLogServersActor*>(this)->ActorCallback< NewTLogServersActor, 1, Reference<ILogSystem> >::remove();

	}
	void a_callback_fire(ActorCallback< NewTLogServersActor, 1, Reference<ILogSystem> >*,Reference<ILogSystem> const& value) 
	{
		fdb_probe_actor_enter("newTLogServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewTLogServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newTLogServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< NewTLogServersActor, 1, Reference<ILogSystem> >*,Reference<ILogSystem> && value) 
	{
		fdb_probe_actor_enter("newTLogServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewTLogServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newTLogServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< NewTLogServersActor, 1, Reference<ILogSystem> >*,Error err) 
	{
		fdb_probe_actor_enter("newTLogServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewTLogServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newTLogServers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitFromConfigurationReply recr;
															#line 269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ILogSystem> oldLogSystem;
															#line 269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<Standalone<CommitTransactionRef>>* initialConfChanges;
															#line 274 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Optional<Key> remoteDcId;
															#line 310 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<RecruitRemoteWorkersInfo> recruitWorkersInfo;
															#line 3131 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via newTLogServers()
															#line 269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewTLogServersActor final : public Actor<Void>, public ActorCallback< NewTLogServersActor, 0, Reference<ILogSystem> >, public ActorCallback< NewTLogServersActor, 1, Reference<ILogSystem> >, public FastAllocated<NewTLogServersActor>, public NewTLogServersActorState<NewTLogServersActor> {
															#line 3136 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<NewTLogServersActor>::operator new;
	using FastAllocated<NewTLogServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10113817499670922752UL, 11507223855624910592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewTLogServersActor, 0, Reference<ILogSystem> >;
friend struct ActorCallback< NewTLogServersActor, 1, Reference<ILogSystem> >;
															#line 269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewTLogServersActor(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recr,Reference<ILogSystem> const& oldLogSystem,std::vector<Standalone<CommitTransactionRef>>* const& initialConfChanges) 
															#line 3154 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   NewTLogServersActorState<NewTLogServersActor>(self, recr, oldLogSystem, initialConfChanges),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newTLogServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12044362103626689536UL, 4721329108795407104UL);
		ActorExecutionContextHelper __helper(static_cast<NewTLogServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newTLogServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newTLogServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewTLogServersActor, 0, Reference<ILogSystem> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< NewTLogServersActor, 1, Reference<ILogSystem> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> newTLogServers( Reference<ClusterRecoveryData> const& self, RecruitFromConfigurationReply const& recr, Reference<ILogSystem> const& oldLogSystem, std::vector<Standalone<CommitTransactionRef>>* const& initialConfChanges ) {
															#line 269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new NewTLogServersActor(self, recr, oldLogSystem, initialConfChanges));
															#line 3188 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 344 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 3193 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via newSeedServers()
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class NewSeedServersActor>
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewSeedServersActorState {
															#line 3200 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewSeedServersActorState(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recruits,std::vector<StorageServerInterface>* const& servers) 
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   recruits(recruits),
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   servers(servers)
															#line 3211 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("newSeedServers", reinterpret_cast<unsigned long>(this));

	}
	~NewSeedServersActorState() 
	{
		fdb_probe_actor_destroy("newSeedServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 349 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			servers->clear();
															#line 350 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->lastEpochEnd)
															#line 3228 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 351 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (!static_cast<NewSeedServersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewSeedServersActorState(); static_cast<NewSeedServersActor*>(this)->destroy(); return 0; }
															#line 3232 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				new (&static_cast<NewSeedServersActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~NewSeedServersActorState();
				static_cast<NewSeedServersActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 353 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			idx = 0;
															#line 354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			dcId_tags = std::map<Optional<Value>, Tag>();
															#line 355 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			nextLocality = 0;
															#line 356 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 3246 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewSeedServersActorState();
		static_cast<NewSeedServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 394 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->dcId_locality.clear();
															#line 395 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& it : dcId_tags ) {
															#line 396 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->dcId_locality[it.first] = it.second.locality;
															#line 3273 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 399 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("ClusterRecoveryRecruitedInitialStorageServers", self->dbgid) .detail("TargetCount", self->configuration.storageTeamSize) .detail("Servers", describe(*servers));
															#line 403 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<NewSeedServersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewSeedServersActorState(); static_cast<NewSeedServersActor*>(this)->destroy(); return 0; }
															#line 3279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<NewSeedServersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewSeedServersActorState();
		static_cast<NewSeedServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 356 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!(idx < recruits.storageServers.size()))
															#line 3298 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_SS_RECRUITMENT_EVENT_NAME).c_str(), self->dbgid) .detail("CandidateWorker", recruits.storageServers[idx].locality.toString());
															#line 361 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		InitializeStorageRequest isr;
															#line 362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		isr.seedTag = dcId_tags.contains(recruits.storageServers[idx].locality.dcId()) ? dcId_tags[recruits.storageServers[idx].locality.dcId()] : Tag(nextLocality, 0);
															#line 365 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		isr.storeType = self->configuration.storageServerStoreType;
															#line 366 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		isr.reqId = deterministicRandom()->randomUniqueID();
															#line 367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		isr.interfaceId = deterministicRandom()->randomUniqueID();
															#line 368 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		isr.initialClusterVersion = self->recoveryTransactionVersion;
															#line 369 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		isr.encryptMode = self->configuration.encryptionAtRestMode;
															#line 371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<ErrorOr<InitializeStorageReply>> __when_expr_0 = recruits.storageServers[idx].storage.tryGetReply(isr);
															#line 371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<NewSeedServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<NewSeedServersActor*>(this)->actor_wait_state = 1;
															#line 371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewSeedServersActor, 0, ErrorOr<InitializeStorageReply> >*>(static_cast<NewSeedServersActor*>(this)));
															#line 3327 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(ErrorOr<InitializeStorageReply> const& newServer,int loopDepth) 
	{
															#line 373 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (newServer.isError())
															#line 3349 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 374 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!newServer.isError(error_code_recruitment_failed) && !newServer.isError(error_code_request_maybe_delivered))
															#line 3353 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 376 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				return a_body1Catch1(newServer.getError(), std::max(0, loopDepth - 1));
															#line 3357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 378 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "initial storage recuitment loop failed to get new server");
															#line 379 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->STORAGE_RECRUITMENT_DELAY);
															#line 379 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<NewSeedServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3365 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<NewSeedServersActor*>(this)->actor_wait_state = 2;
															#line 379 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NewSeedServersActor, 1, Void >*>(static_cast<NewSeedServersActor*>(this)));
															#line 3370 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 381 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!dcId_tags.contains(recruits.storageServers[idx].locality.dcId()))
															#line 3377 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				dcId_tags[recruits.storageServers[idx].locality.dcId()] = Tag(nextLocality, 0);
															#line 383 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				nextLocality++;
															#line 3383 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 386 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			Tag& tag = dcId_tags[recruits.storageServers[idx].locality.dcId()];
															#line 387 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tag.id++;
															#line 388 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			idx++;
															#line 390 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			servers->push_back(newServer.get().interf);
															#line 3393 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(ErrorOr<InitializeStorageReply> && newServer,int loopDepth) 
	{
															#line 373 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (newServer.isError())
															#line 3403 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 374 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!newServer.isError(error_code_recruitment_failed) && !newServer.isError(error_code_request_maybe_delivered))
															#line 3407 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 376 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				return a_body1Catch1(newServer.getError(), std::max(0, loopDepth - 1));
															#line 3411 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 378 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "initial storage recuitment loop failed to get new server");
															#line 379 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->STORAGE_RECRUITMENT_DELAY);
															#line 379 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<NewSeedServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3419 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<NewSeedServersActor*>(this)->actor_wait_state = 2;
															#line 379 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NewSeedServersActor, 1, Void >*>(static_cast<NewSeedServersActor*>(this)));
															#line 3424 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 381 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!dcId_tags.contains(recruits.storageServers[idx].locality.dcId()))
															#line 3431 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				dcId_tags[recruits.storageServers[idx].locality.dcId()] = Tag(nextLocality, 0);
															#line 383 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				nextLocality++;
															#line 3437 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 386 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			Tag& tag = dcId_tags[recruits.storageServers[idx].locality.dcId()];
															#line 387 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tag.id++;
															#line 388 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			idx++;
															#line 390 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			servers->push_back(newServer.get().interf);
															#line 3447 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<InitializeStorageReply> const& newServer,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(newServer, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<InitializeStorageReply> && newServer,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(newServer), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewSeedServersActor*>(this)->actor_wait_state > 0) static_cast<NewSeedServersActor*>(this)->actor_wait_state = 0;
		static_cast<NewSeedServersActor*>(this)->ActorCallback< NewSeedServersActor, 0, ErrorOr<InitializeStorageReply> >::remove();

	}
	void a_callback_fire(ActorCallback< NewSeedServersActor, 0, ErrorOr<InitializeStorageReply> >*,ErrorOr<InitializeStorageReply> const& value) 
	{
		fdb_probe_actor_enter("newSeedServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewSeedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newSeedServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewSeedServersActor, 0, ErrorOr<InitializeStorageReply> >*,ErrorOr<InitializeStorageReply> && value) 
	{
		fdb_probe_actor_enter("newSeedServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewSeedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newSeedServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewSeedServersActor, 0, ErrorOr<InitializeStorageReply> >*,Error err) 
	{
		fdb_probe_actor_enter("newSeedServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewSeedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newSeedServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<NewSeedServersActor*>(this)->actor_wait_state > 0) static_cast<NewSeedServersActor*>(this)->actor_wait_state = 0;
		static_cast<NewSeedServersActor*>(this)->ActorCallback< NewSeedServersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewSeedServersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newSeedServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewSeedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newSeedServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< NewSeedServersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newSeedServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewSeedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newSeedServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< NewSeedServersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newSeedServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewSeedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newSeedServers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitFromConfigurationReply recruits;
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<StorageServerInterface>* servers;
															#line 353 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	int idx;
															#line 354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::map<Optional<Value>, Tag> dcId_tags;
															#line 355 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	int8_t nextLocality;
															#line 3633 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via newSeedServers()
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class NewSeedServersActor final : public Actor<Void>, public ActorCallback< NewSeedServersActor, 0, ErrorOr<InitializeStorageReply> >, public ActorCallback< NewSeedServersActor, 1, Void >, public FastAllocated<NewSeedServersActor>, public NewSeedServersActorState<NewSeedServersActor> {
															#line 3638 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<NewSeedServersActor>::operator new;
	using FastAllocated<NewSeedServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12325941618732411904UL, 10743545538989822720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewSeedServersActor, 0, ErrorOr<InitializeStorageReply> >;
friend struct ActorCallback< NewSeedServersActor, 1, Void >;
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	NewSeedServersActor(Reference<ClusterRecoveryData> const& self,RecruitFromConfigurationReply const& recruits,std::vector<StorageServerInterface>* const& servers) 
															#line 3656 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   NewSeedServersActorState<NewSeedServersActor>(self, recruits, servers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newSeedServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7274580659293080832UL, 11591227406186479104UL);
		ActorExecutionContextHelper __helper(static_cast<NewSeedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newSeedServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newSeedServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewSeedServersActor, 0, ErrorOr<InitializeStorageReply> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< NewSeedServersActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> newSeedServers( Reference<ClusterRecoveryData> const& self, RecruitFromConfigurationReply const& recruits, std::vector<StorageServerInterface>* const& servers ) {
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new NewSeedServersActor(self, recruits, servers));
															#line 3690 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 405 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

Future<Void> waitCommitProxyFailure(std::vector<CommitProxyInterface> const& commitProxies) {
	std::vector<Future<Void>> failed;
	failed.reserve(commitProxies.size());
	for (auto commitProxy : commitProxies) {
		failed.push_back(waitFailureClient(commitProxy.waitFailure,
		                                   SERVER_KNOBS->TLOG_TIMEOUT,
		                                   -SERVER_KNOBS->TLOG_TIMEOUT / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY,
		                                   /*trace=*/true));
	}
	ASSERT(failed.size() >= 1);
	return tagError<Void>(quorum(failed, 1), commit_proxy_failed());
}

Future<Void> waitGrvProxyFailure(std::vector<GrvProxyInterface> const& grvProxies) {
	std::vector<Future<Void>> failed;
	failed.reserve(grvProxies.size());
	for (int i = 0; i < grvProxies.size(); i++)
		failed.push_back(waitFailureClient(grvProxies[i].waitFailure,
		                                   SERVER_KNOBS->TLOG_TIMEOUT,
		                                   -SERVER_KNOBS->TLOG_TIMEOUT / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY,
		                                   /*trace=*/true));
	ASSERT(failed.size() >= 1);
	return tagError<Void>(quorum(failed, 1), grv_proxy_failed());
}

Future<Void> waitResolverFailure(std::vector<ResolverInterface> const& resolvers) {
	std::vector<Future<Void>> failed;
	failed.reserve(resolvers.size());
	for (auto resolver : resolvers) {
		failed.push_back(waitFailureClient(resolver.waitFailure,
		                                   SERVER_KNOBS->TLOG_TIMEOUT,
		                                   -SERVER_KNOBS->TLOG_TIMEOUT / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY,
		                                   /*trace=*/true));
	}
	ASSERT(failed.size() >= 1);
	return tagError<Void>(quorum(failed, 1), resolver_failed());
}

															#line 3733 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via rejoinRequestHandler()
															#line 444 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class RejoinRequestHandlerActor>
															#line 444 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RejoinRequestHandlerActorState {
															#line 3740 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 444 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RejoinRequestHandlerActorState(Reference<ClusterRecoveryData> const& self) 
															#line 444 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 444 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self)
															#line 3747 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("rejoinRequestHandler", reinterpret_cast<unsigned long>(this));

	}
	~RejoinRequestHandlerActorState() 
	{
		fdb_probe_actor_destroy("rejoinRequestHandler", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 445 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 3762 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RejoinRequestHandlerActorState();
		static_cast<RejoinRequestHandlerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 446 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		FutureStream<TLogRejoinRequest> __when_expr_0 = self->clusterController.tlogRejoin.getFuture();
															#line 446 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RejoinRequestHandlerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3794 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<RejoinRequestHandlerActor*>(this)->actor_wait_state = 1;
															#line 446 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< RejoinRequestHandlerActor, 0, TLogRejoinRequest >*>(static_cast<RejoinRequestHandlerActor*>(this)));
															#line 3799 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(TLogRejoinRequest const& req,int loopDepth) 
	{
															#line 447 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(SevDebug, "TLogRejoinRequestHandler") .detail("MasterLifeTime", self->dbInfo->get().masterLifetime.toString());
															#line 449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.reply.send(true);
															#line 3810 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(TLogRejoinRequest && req,int loopDepth) 
	{
															#line 447 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(SevDebug, "TLogRejoinRequestHandler") .detail("MasterLifeTime", self->dbInfo->get().masterLifetime.toString());
															#line 449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.reply.send(true);
															#line 3821 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(TLogRejoinRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(TLogRejoinRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RejoinRequestHandlerActor*>(this)->actor_wait_state > 0) static_cast<RejoinRequestHandlerActor*>(this)->actor_wait_state = 0;
		static_cast<RejoinRequestHandlerActor*>(this)->ActorSingleCallback< RejoinRequestHandlerActor, 0, TLogRejoinRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< RejoinRequestHandlerActor, 0, TLogRejoinRequest >*,TLogRejoinRequest const& value) 
	{
		fdb_probe_actor_enter("rejoinRequestHandler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinRequestHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinRequestHandler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< RejoinRequestHandlerActor, 0, TLogRejoinRequest >*,TLogRejoinRequest && value) 
	{
		fdb_probe_actor_enter("rejoinRequestHandler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinRequestHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinRequestHandler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< RejoinRequestHandlerActor, 0, TLogRejoinRequest >*,Error err) 
	{
		fdb_probe_actor_enter("rejoinRequestHandler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinRequestHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinRequestHandler", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 444 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 3903 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via rejoinRequestHandler()
															#line 444 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RejoinRequestHandlerActor final : public Actor<Void>, public ActorSingleCallback< RejoinRequestHandlerActor, 0, TLogRejoinRequest >, public FastAllocated<RejoinRequestHandlerActor>, public RejoinRequestHandlerActorState<RejoinRequestHandlerActor> {
															#line 3908 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<RejoinRequestHandlerActor>::operator new;
	using FastAllocated<RejoinRequestHandlerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6724640658357901056UL, 10243898428453319424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< RejoinRequestHandlerActor, 0, TLogRejoinRequest >;
															#line 444 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RejoinRequestHandlerActor(Reference<ClusterRecoveryData> const& self) 
															#line 3925 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   RejoinRequestHandlerActorState<RejoinRequestHandlerActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rejoinRequestHandler", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15236639655740148224UL, 4543991541925031168UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinRequestHandlerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rejoinRequestHandler");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rejoinRequestHandler", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< RejoinRequestHandlerActor, 0, TLogRejoinRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 444 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> rejoinRequestHandler( Reference<ClusterRecoveryData> const& self ) {
															#line 444 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new RejoinRequestHandlerActor(self));
															#line 3958 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 452 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

// Keeps the coordinated state (cstate) updated as the set of recruited tlogs change through recovery.
															#line 3964 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via trackTlogRecovery()
															#line 454 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class TrackTlogRecoveryActor>
															#line 454 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class TrackTlogRecoveryActorState {
															#line 3971 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 454 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	TrackTlogRecoveryActorState(Reference<ClusterRecoveryData> const& self,Reference<AsyncVar<Reference<ILogSystem>>> const& oldLogSystems,Future<Void> const& minRecoveryDuration) 
															#line 454 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 454 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 454 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   oldLogSystems(oldLogSystems),
															#line 454 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   minRecoveryDuration(minRecoveryDuration),
															#line 457 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   rejoinRequests(Never()),
															#line 458 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   recoverCount(self->cstate.myDBState.recoveryCount + 1),
															#line 459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   encryptionAtRestMode(getEncryptionAtRest(self->configuration)),
															#line 460 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   configuration(self->configuration)
															#line 3990 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("trackTlogRecovery", reinterpret_cast<unsigned long>(this));

	}
	~TrackTlogRecoveryActorState() 
	{
		fdb_probe_actor_destroy("trackTlogRecovery", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 4005 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TrackTlogRecoveryActorState();
		static_cast<TrackTlogRecoveryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 463 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		newState = DBCoreState();
															#line 464 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem->toCoreState(newState);
															#line 468 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem->purgeOldRecoveredGenerationsCoreState(newState);
															#line 469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		newState.recoveryCount = recoverCount;
															#line 472 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		newState.encryptionAtRestMode = encryptionAtRestMode;
															#line 474 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		changed = self->logSystem->onCoreStateChanged();
															#line 476 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(newState.tLogs[0].tLogWriteAntiQuorum == configuration.tLogWriteAntiQuorum && newState.tLogs[0].tLogReplicationFactor == configuration.tLogReplicationFactor);
															#line 479 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		allLogs = newState.tLogs.size() == configuration.expectedLogSets(self->primaryDcId.size() ? self->primaryDcId[0] : Optional<Key>());
															#line 482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		finalUpdate = !newState.oldTLogData.size() && allLogs;
															#line 483 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("TrackTlogRecovery") .detail("FinalUpdate", finalUpdate) .detail("NewState.tlogs", newState.tLogs.size()) .detail("NewState.OldTLogs", newState.oldTLogData.size()) .detail("NewState.EncryptionAtRestMode", newState.encryptionAtRestMode.toString()) .detail("Expected.tlogs", configuration.expectedLogSets(self->primaryDcId.size() ? self->primaryDcId[0] : Optional<Key>())) .detail("RecoveryCount", newState.recoveryCount);
															#line 491 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->cstate.write(newState, finalUpdate);
															#line 491 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4057 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state = 1;
															#line 491 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TrackTlogRecoveryActor, 0, Void >*>(static_cast<TrackTlogRecoveryActor*>(this)));
															#line 4062 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 493 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem->purgeOldRecoveredGenerationsInMemory(newState);
															#line 494 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->cstateUpdated.canBeSet())
															#line 4073 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 495 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->cstateUpdated.send(Void());
															#line 4077 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 498 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = minRecoveryDuration;
															#line 498 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4083 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state = 2;
															#line 498 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackTlogRecoveryActor, 1, Void >*>(static_cast<TrackTlogRecoveryActor*>(this)));
															#line 4088 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 493 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem->purgeOldRecoveredGenerationsInMemory(newState);
															#line 494 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->cstateUpdated.canBeSet())
															#line 4099 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 495 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->cstateUpdated.send(Void());
															#line 4103 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 498 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = minRecoveryDuration;
															#line 498 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state = 2;
															#line 498 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackTlogRecoveryActor, 1, Void >*>(static_cast<TrackTlogRecoveryActor*>(this)));
															#line 4114 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state > 0) static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state = 0;
		static_cast<TrackTlogRecoveryActor*>(this)->ActorCallback< TrackTlogRecoveryActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackTlogRecoveryActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TrackTlogRecoveryActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TrackTlogRecoveryActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 499 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem->coreStateWritten(newState);
															#line 501 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->recoveryReadyForCommits.canBeSet())
															#line 4200 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 502 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->recoveryReadyForCommits.send(Void());
															#line 4204 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 505 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (finalUpdate)
															#line 4208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 506 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->recoveryState = RecoveryState::FULLY_RECOVERED;
															#line 507 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::fully_recovered) .detail("Status", RecoveryStatus::names[RecoveryStatus::fully_recovered]) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 513 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_GENERATION_EVENT_NAME).c_str(), self->dbgid) .detail("ActiveGenerations", 1) .trackLatest(self->clusterRecoveryGenerationsEventHolder->trackingKey);
															#line 4216 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 517 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!newState.oldTLogData.size() && self->recoveryState < RecoveryState::STORAGE_RECOVERED)
															#line 4222 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 518 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryState = RecoveryState::STORAGE_RECOVERED;
															#line 519 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::storage_recovered) .detail("Status", RecoveryStatus::names[RecoveryStatus::storage_recovered]) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 4228 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
			else
			{
															#line 524 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (allLogs && self->recoveryState < RecoveryState::ALL_LOGS_RECRUITED)
															#line 4234 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 525 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					self->recoveryState = RecoveryState::ALL_LOGS_RECRUITED;
															#line 526 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::all_logs_recruited) .detail("Status", RecoveryStatus::names[RecoveryStatus::all_logs_recruited]) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 4240 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
			}
		}
															#line 533 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->registrationTrigger.trigger();
															#line 535 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (finalUpdate)
															#line 4248 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 536 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			oldLogSystems->get()->stopRejoins();
															#line 537 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rejoinRequests = rejoinRequestHandler(self);
															#line 538 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<TrackTlogRecoveryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TrackTlogRecoveryActorState(); static_cast<TrackTlogRecoveryActor*>(this)->destroy(); return 0; }
															#line 4256 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<TrackTlogRecoveryActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TrackTlogRecoveryActorState();
			static_cast<TrackTlogRecoveryActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 541 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = changed;
															#line 541 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4266 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state = 3;
															#line 541 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TrackTlogRecoveryActor, 2, Void >*>(static_cast<TrackTlogRecoveryActor*>(this)));
															#line 4271 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 499 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem->coreStateWritten(newState);
															#line 501 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->recoveryReadyForCommits.canBeSet())
															#line 4282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 502 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->recoveryReadyForCommits.send(Void());
															#line 4286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 505 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (finalUpdate)
															#line 4290 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 506 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->recoveryState = RecoveryState::FULLY_RECOVERED;
															#line 507 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::fully_recovered) .detail("Status", RecoveryStatus::names[RecoveryStatus::fully_recovered]) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 513 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_GENERATION_EVENT_NAME).c_str(), self->dbgid) .detail("ActiveGenerations", 1) .trackLatest(self->clusterRecoveryGenerationsEventHolder->trackingKey);
															#line 4298 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 517 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!newState.oldTLogData.size() && self->recoveryState < RecoveryState::STORAGE_RECOVERED)
															#line 4304 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 518 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryState = RecoveryState::STORAGE_RECOVERED;
															#line 519 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::storage_recovered) .detail("Status", RecoveryStatus::names[RecoveryStatus::storage_recovered]) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 4310 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
			else
			{
															#line 524 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (allLogs && self->recoveryState < RecoveryState::ALL_LOGS_RECRUITED)
															#line 4316 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 525 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					self->recoveryState = RecoveryState::ALL_LOGS_RECRUITED;
															#line 526 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::all_logs_recruited) .detail("Status", RecoveryStatus::names[RecoveryStatus::all_logs_recruited]) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 4322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
			}
		}
															#line 533 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->registrationTrigger.trigger();
															#line 535 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (finalUpdate)
															#line 4330 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 536 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			oldLogSystems->get()->stopRejoins();
															#line 537 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rejoinRequests = rejoinRequestHandler(self);
															#line 538 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<TrackTlogRecoveryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TrackTlogRecoveryActorState(); static_cast<TrackTlogRecoveryActor*>(this)->destroy(); return 0; }
															#line 4338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<TrackTlogRecoveryActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TrackTlogRecoveryActorState();
			static_cast<TrackTlogRecoveryActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 541 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = changed;
															#line 541 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4348 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state = 3;
															#line 541 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TrackTlogRecoveryActor, 2, Void >*>(static_cast<TrackTlogRecoveryActor*>(this)));
															#line 4353 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state > 0) static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state = 0;
		static_cast<TrackTlogRecoveryActor*>(this)->ActorCallback< TrackTlogRecoveryActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackTlogRecoveryActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TrackTlogRecoveryActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TrackTlogRecoveryActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state > 0) static_cast<TrackTlogRecoveryActor*>(this)->actor_wait_state = 0;
		static_cast<TrackTlogRecoveryActor*>(this)->ActorCallback< TrackTlogRecoveryActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackTlogRecoveryActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TrackTlogRecoveryActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TrackTlogRecoveryActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 454 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 454 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<AsyncVar<Reference<ILogSystem>>> oldLogSystems;
															#line 454 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> minRecoveryDuration;
															#line 457 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> rejoinRequests;
															#line 458 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	DBRecoveryCount recoverCount;
															#line 459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	EncryptionAtRestMode encryptionAtRestMode;
															#line 460 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	DatabaseConfiguration configuration;
															#line 463 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	DBCoreState newState;
															#line 474 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> changed;
															#line 479 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	bool allLogs;
															#line 482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	bool finalUpdate;
															#line 4542 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via trackTlogRecovery()
															#line 454 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class TrackTlogRecoveryActor final : public Actor<Void>, public ActorCallback< TrackTlogRecoveryActor, 0, Void >, public ActorCallback< TrackTlogRecoveryActor, 1, Void >, public ActorCallback< TrackTlogRecoveryActor, 2, Void >, public FastAllocated<TrackTlogRecoveryActor>, public TrackTlogRecoveryActorState<TrackTlogRecoveryActor> {
															#line 4547 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<TrackTlogRecoveryActor>::operator new;
	using FastAllocated<TrackTlogRecoveryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1331138347466216448UL, 3796580786811323904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TrackTlogRecoveryActor, 0, Void >;
friend struct ActorCallback< TrackTlogRecoveryActor, 1, Void >;
friend struct ActorCallback< TrackTlogRecoveryActor, 2, Void >;
															#line 454 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	TrackTlogRecoveryActor(Reference<ClusterRecoveryData> const& self,Reference<AsyncVar<Reference<ILogSystem>>> const& oldLogSystems,Future<Void> const& minRecoveryDuration) 
															#line 4566 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   TrackTlogRecoveryActorState<TrackTlogRecoveryActor>(self, oldLogSystems, minRecoveryDuration),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trackTlogRecovery", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10869225822354720768UL, 5259300671006810112UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTlogRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trackTlogRecovery");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trackTlogRecovery", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TrackTlogRecoveryActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TrackTlogRecoveryActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TrackTlogRecoveryActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 454 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> trackTlogRecovery( Reference<ClusterRecoveryData> const& self, Reference<AsyncVar<Reference<ILogSystem>>> const& oldLogSystems, Future<Void> const& minRecoveryDuration ) {
															#line 454 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new TrackTlogRecoveryActor(self, oldLogSystems, minRecoveryDuration));
															#line 4601 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 544 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 4606 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via changeCoordinators()
															#line 545 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class ChangeCoordinatorsActor>
															#line 545 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ChangeCoordinatorsActorState {
															#line 4613 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 545 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ChangeCoordinatorsActorState(Reference<ClusterRecoveryData> const& self) 
															#line 545 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 545 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self)
															#line 4620 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("changeCoordinators", reinterpret_cast<unsigned long>(this));

	}
	~ChangeCoordinatorsActorState() 
	{
		fdb_probe_actor_destroy("changeCoordinators", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 546 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 4635 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeCoordinatorsActorState();
		static_cast<ChangeCoordinatorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 547 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		FutureStream<ChangeCoordinatorsRequest> __when_expr_0 = self->clusterController.changeCoordinators.getFuture();
															#line 547 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4667 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 1;
															#line 547 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ChangeCoordinatorsActor, 0, ChangeCoordinatorsRequest >*>(static_cast<ChangeCoordinatorsActor*>(this)));
															#line 4672 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(ChangeCoordinatorsRequest const& req,int loopDepth) 
	{
															#line 548 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("ChangeCoordinators", self->dbgid).log();
															#line 549 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		++self->changeCoordinatorsRequests;
															#line 550 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		changeCoordinatorsRequest = req;
															#line 551 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->masterInterface.id() != changeCoordinatorsRequest.masterId)
															#line 4687 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 562 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(coordinators_changed(), std::max(0, loopDepth - 1));
															#line 4691 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 566 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->controllerData->shouldCommitSuicide)
															#line 4695 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 567 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(restart_cluster_controller(), std::max(0, loopDepth - 1));
															#line 4699 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 569 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->controllerData->shouldCommitSuicide = true;
															#line 571 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		;
															#line 4705 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(ChangeCoordinatorsRequest && req,int loopDepth) 
	{
															#line 548 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("ChangeCoordinators", self->dbgid).log();
															#line 549 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		++self->changeCoordinatorsRequests;
															#line 550 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		changeCoordinatorsRequest = req;
															#line 551 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->masterInterface.id() != changeCoordinatorsRequest.masterId)
															#line 4720 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 562 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(coordinators_changed(), std::max(0, loopDepth - 1));
															#line 4724 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 566 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->controllerData->shouldCommitSuicide)
															#line 4728 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 567 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(restart_cluster_controller(), std::max(0, loopDepth - 1));
															#line 4732 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 569 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->controllerData->shouldCommitSuicide = true;
															#line 571 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		;
															#line 4738 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ChangeCoordinatorsRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ChangeCoordinatorsRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeCoordinatorsActor*>(this)->ActorSingleCallback< ChangeCoordinatorsActor, 0, ChangeCoordinatorsRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ChangeCoordinatorsActor, 0, ChangeCoordinatorsRequest >*,ChangeCoordinatorsRequest const& value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ChangeCoordinatorsActor, 0, ChangeCoordinatorsRequest >*,ChangeCoordinatorsRequest && value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ChangeCoordinatorsActor, 0, ChangeCoordinatorsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 577 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!self->cstate.fullyRecovered.isSet())
															#line 4822 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 578 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_3 = self->cstate.write(self->cstate.myDBState, true);
															#line 578 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4828 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
			static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 4;
															#line 578 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangeCoordinatorsActor, 3, Void >*>(static_cast<ChangeCoordinatorsActor*>(this)));
															#line 4833 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 571 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!(!self->cstate.previousWrite.isReady()))
															#line 4854 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 572 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->cstate.previousWrite;
															#line 572 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4862 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 2;
															#line 572 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeCoordinatorsActor, 1, Void >*>(static_cast<ChangeCoordinatorsActor*>(this)));
															#line 4867 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 573 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay( 0);
															#line 573 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4891 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 3;
															#line 573 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeCoordinatorsActor, 2, Void >*>(static_cast<ChangeCoordinatorsActor*>(this)));
															#line 4896 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 573 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay( 0);
															#line 573 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4907 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 3;
															#line 573 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeCoordinatorsActor, 2, Void >*>(static_cast<ChangeCoordinatorsActor*>(this)));
															#line 4912 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeCoordinatorsActor*>(this)->ActorCallback< ChangeCoordinatorsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeCoordinatorsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeCoordinatorsActor*>(this)->ActorCallback< ChangeCoordinatorsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangeCoordinatorsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
															#line 582 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			ClusterConnectionString conn(changeCoordinatorsRequest.newConnectionString.toString());
															#line 583 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_4 = self->cstate.move(conn);
															#line 583 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont5Catch1(actor_cancelled(), loopDepth);
															#line 5088 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont5Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
			static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 5;
															#line 583 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ChangeCoordinatorsActor, 4, Void >*>(static_cast<ChangeCoordinatorsActor*>(this)));
															#line 5093 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeCoordinatorsActor*>(this)->ActorCallback< ChangeCoordinatorsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ChangeCoordinatorsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
															#line 591 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 5195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1cont5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 585 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 5204 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 586 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				changeCoordinatorsRequest.reply.sendError(e);
															#line 5208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 588 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeCoordinatorsActor*>(this)->ActorCallback< ChangeCoordinatorsActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ChangeCoordinatorsActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 545 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 550 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ChangeCoordinatorsRequest changeCoordinatorsRequest;
															#line 5326 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via changeCoordinators()
															#line 545 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ChangeCoordinatorsActor final : public Actor<Void>, public ActorSingleCallback< ChangeCoordinatorsActor, 0, ChangeCoordinatorsRequest >, public ActorCallback< ChangeCoordinatorsActor, 1, Void >, public ActorCallback< ChangeCoordinatorsActor, 2, Void >, public ActorCallback< ChangeCoordinatorsActor, 3, Void >, public ActorCallback< ChangeCoordinatorsActor, 4, Void >, public FastAllocated<ChangeCoordinatorsActor>, public ChangeCoordinatorsActorState<ChangeCoordinatorsActor> {
															#line 5331 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<ChangeCoordinatorsActor>::operator new;
	using FastAllocated<ChangeCoordinatorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16870520670051376896UL, 6037779851244807424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ChangeCoordinatorsActor, 0, ChangeCoordinatorsRequest >;
friend struct ActorCallback< ChangeCoordinatorsActor, 1, Void >;
friend struct ActorCallback< ChangeCoordinatorsActor, 2, Void >;
friend struct ActorCallback< ChangeCoordinatorsActor, 3, Void >;
friend struct ActorCallback< ChangeCoordinatorsActor, 4, Void >;
															#line 545 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ChangeCoordinatorsActor(Reference<ClusterRecoveryData> const& self) 
															#line 5352 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   ChangeCoordinatorsActorState<ChangeCoordinatorsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3491648785959313408UL, 8764310282253397504UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeCoordinators");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ChangeCoordinatorsActor, 0, ChangeCoordinatorsRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeCoordinatorsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangeCoordinatorsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ChangeCoordinatorsActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ChangeCoordinatorsActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 545 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> changeCoordinators( Reference<ClusterRecoveryData> const& self ) {
															#line 545 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new ChangeCoordinatorsActor(self));
															#line 5389 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 594 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 5394 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via configurationMonitor()
															#line 595 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class ConfigurationMonitorActor>
															#line 595 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ConfigurationMonitorActorState {
															#line 5401 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 595 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ConfigurationMonitorActorState(Reference<ClusterRecoveryData> const& self,Database const& cx) 
															#line 595 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 595 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 595 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   cx(cx)
															#line 5410 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("configurationMonitor", reinterpret_cast<unsigned long>(this));

	}
	~ConfigurationMonitorActorState() 
	{
		fdb_probe_actor_destroy("configurationMonitor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 596 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 5425 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigurationMonitorActorState();
		static_cast<ConfigurationMonitorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 597 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 599 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		;
															#line 5457 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 601 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 602 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(configKeys, CLIENT_KNOBS->TOO_MANY);
															#line 602 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5484 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 1;
															#line 602 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigurationMonitorActor, 0, RangeResult >*>(static_cast<ConfigurationMonitorActor*>(this)));
															#line 5489 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 629 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 629 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5526 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 4;
															#line 629 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ConfigurationMonitorActor, 3, Void >*>(static_cast<ConfigurationMonitorActor*>(this)));
															#line 5531 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(RangeResult const& results,int loopDepth) 
	{
															#line 603 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(!results.more && results.size() < CLIENT_KNOBS->TOO_MANY);
															#line 605 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		DatabaseConfiguration conf;
															#line 606 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		conf.fromKeyValues((VectorRef<KeyValueRef>)results);
															#line 607 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("ConfigurationMonitor", self->dbgid) .detail(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->recoveryState);
															#line 610 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (conf != self->configuration)
															#line 5554 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 611 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->recoveryState != RecoveryState::ALL_LOGS_RECRUITED && self->recoveryState != RecoveryState::FULLY_RECOVERED)
															#line 5558 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 613 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->controllerData->shouldCommitSuicide = true;
															#line 614 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				return a_body1loopBody1loopBody1Catch1(restart_cluster_controller(), loopDepth);
															#line 5564 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 617 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->configuration = conf;
															#line 618 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->registrationTrigger.trigger();
															#line 5570 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 621 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		watchFuture = tr.watch(moveKeysLockOwnerKey) || tr.watch(excludedServersVersionKey) || tr.watch(failedServersVersionKey) || tr.watch(excludedLocalityVersionKey) || tr.watch(failedLocalityVersionKey);
															#line 625 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 625 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5578 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 2;
															#line 625 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigurationMonitorActor, 1, Void >*>(static_cast<ConfigurationMonitorActor*>(this)));
															#line 5583 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(RangeResult && results,int loopDepth) 
	{
															#line 603 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(!results.more && results.size() < CLIENT_KNOBS->TOO_MANY);
															#line 605 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		DatabaseConfiguration conf;
															#line 606 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		conf.fromKeyValues((VectorRef<KeyValueRef>)results);
															#line 607 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("ConfigurationMonitor", self->dbgid) .detail(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->recoveryState);
															#line 610 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (conf != self->configuration)
															#line 5600 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 611 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->recoveryState != RecoveryState::ALL_LOGS_RECRUITED && self->recoveryState != RecoveryState::FULLY_RECOVERED)
															#line 5604 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 613 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->controllerData->shouldCommitSuicide = true;
															#line 614 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				return a_body1loopBody1loopBody1Catch1(restart_cluster_controller(), loopDepth);
															#line 5610 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 617 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->configuration = conf;
															#line 618 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->registrationTrigger.trigger();
															#line 5616 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 621 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		watchFuture = tr.watch(moveKeysLockOwnerKey) || tr.watch(excludedServersVersionKey) || tr.watch(failedServersVersionKey) || tr.watch(excludedLocalityVersionKey) || tr.watch(failedLocalityVersionKey);
															#line 625 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 625 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5624 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 2;
															#line 625 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigurationMonitorActor, 1, Void >*>(static_cast<ConfigurationMonitorActor*>(this)));
															#line 5629 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult const& results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(results, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult && results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state > 0) static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigurationMonitorActor*>(this)->ActorCallback< ConfigurationMonitorActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigurationMonitorActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 626 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchFuture;
															#line 626 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5715 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 3;
															#line 626 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConfigurationMonitorActor, 2, Void >*>(static_cast<ConfigurationMonitorActor*>(this)));
															#line 5720 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 626 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchFuture;
															#line 626 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5731 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 3;
															#line 626 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConfigurationMonitorActor, 2, Void >*>(static_cast<ConfigurationMonitorActor*>(this)));
															#line 5736 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state > 0) static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigurationMonitorActor*>(this)->ActorCallback< ConfigurationMonitorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConfigurationMonitorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state > 0) static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigurationMonitorActor*>(this)->ActorCallback< ConfigurationMonitorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConfigurationMonitorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state > 0) static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigurationMonitorActor*>(this)->ActorCallback< ConfigurationMonitorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ConfigurationMonitorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 595 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 595 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Database cx;
															#line 597 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 621 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> watchFuture;
															#line 5998 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via configurationMonitor()
															#line 595 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ConfigurationMonitorActor final : public Actor<Void>, public ActorCallback< ConfigurationMonitorActor, 0, RangeResult >, public ActorCallback< ConfigurationMonitorActor, 1, Void >, public ActorCallback< ConfigurationMonitorActor, 2, Void >, public ActorCallback< ConfigurationMonitorActor, 3, Void >, public FastAllocated<ConfigurationMonitorActor>, public ConfigurationMonitorActorState<ConfigurationMonitorActor> {
															#line 6003 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<ConfigurationMonitorActor>::operator new;
	using FastAllocated<ConfigurationMonitorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2267840604196298496UL, 1828572014774597632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigurationMonitorActor, 0, RangeResult >;
friend struct ActorCallback< ConfigurationMonitorActor, 1, Void >;
friend struct ActorCallback< ConfigurationMonitorActor, 2, Void >;
friend struct ActorCallback< ConfigurationMonitorActor, 3, Void >;
															#line 595 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ConfigurationMonitorActor(Reference<ClusterRecoveryData> const& self,Database const& cx) 
															#line 6023 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   ConfigurationMonitorActorState<ConfigurationMonitorActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11255558610263663616UL, 7933841004617470208UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configurationMonitor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigurationMonitorActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConfigurationMonitorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConfigurationMonitorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ConfigurationMonitorActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 595 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> configurationMonitor( Reference<ClusterRecoveryData> const& self, Database const& cx ) {
															#line 595 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new ConfigurationMonitorActor(self, cx));
															#line 6059 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 634 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

// Returns the minimum backup version and the maximum backup worker noop version.
															#line 6065 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via getMinBackupVersion()
															#line 636 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class GetMinBackupVersionActor>
															#line 636 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class GetMinBackupVersionActorState {
															#line 6072 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 636 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	GetMinBackupVersionActorState(Reference<ClusterRecoveryData> const& self,Database const& cx) 
															#line 636 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 636 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 636 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   cx(cx)
															#line 6081 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("getMinBackupVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetMinBackupVersionActorState() 
	{
		fdb_probe_actor_destroy("getMinBackupVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 639 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 6096 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetMinBackupVersionActorState();
		static_cast<GetMinBackupVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 640 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 6126 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		try {
															#line 643 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 644 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 645 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			fValue = tr.get(backupStartedKey);
															#line 646 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			fNoopValue = tr.get(backupWorkerMaxNoopVersionKey);
															#line 647 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(fValue) && success(fNoopValue);
															#line 647 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<GetMinBackupVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6140 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetMinBackupVersionActor*>(this)->actor_wait_state = 1;
															#line 647 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetMinBackupVersionActor, 0, Void >*>(static_cast<GetMinBackupVersionActor*>(this)));
															#line 6145 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 669 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 669 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<GetMinBackupVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6169 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetMinBackupVersionActor*>(this)->actor_wait_state = 2;
															#line 669 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetMinBackupVersionActor, 1, Void >*>(static_cast<GetMinBackupVersionActor*>(this)));
															#line 6174 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 648 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Value> value = fValue.get();
															#line 649 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Value> noopValue = fNoopValue.get();
															#line 650 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Version> minVersion, noopVersion;
															#line 651 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (value.present())
															#line 6195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 652 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			auto uidVersions = decodeBackupStartedValue(value.get());
															#line 653 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent e("GotBackupStartKey", self->dbgid);
															#line 654 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			int i = 1;
															#line 655 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto [uid, version] : uidVersions ) {
															#line 656 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				e.detail(format("BackupID%d", i), uid).detail(format("Version%d", i), version);
															#line 657 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				i++;
															#line 658 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				minVersion = minVersion.present() ? std::min(version, minVersion.get()) : version;
															#line 6211 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
		else
		{
															#line 661 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("EmptyBackupStartKey", self->dbgid).log();
															#line 6218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 663 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (noopValue.present())
															#line 6222 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 664 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			noopVersion = BinaryReader::fromStringRef<Version>(noopValue.get(), Unversioned());
															#line 6226 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 666 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<GetMinBackupVersionActor*>(this)->SAV<std::pair<Optional<Version>, Optional<Version>>>::futures) { (void)(std::make_pair(minVersion, noopVersion)); this->~GetMinBackupVersionActorState(); static_cast<GetMinBackupVersionActor*>(this)->destroy(); return 0; }
															#line 6230 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<GetMinBackupVersionActor*>(this)->SAV< std::pair<Optional<Version>, Optional<Version>> >::value()) std::pair<Optional<Version>, Optional<Version>>(std::make_pair(minVersion, noopVersion));
		this->~GetMinBackupVersionActorState();
		static_cast<GetMinBackupVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 648 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Value> value = fValue.get();
															#line 649 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Value> noopValue = fNoopValue.get();
															#line 650 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Version> minVersion, noopVersion;
															#line 651 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (value.present())
															#line 6248 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 652 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			auto uidVersions = decodeBackupStartedValue(value.get());
															#line 653 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent e("GotBackupStartKey", self->dbgid);
															#line 654 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			int i = 1;
															#line 655 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto [uid, version] : uidVersions ) {
															#line 656 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				e.detail(format("BackupID%d", i), uid).detail(format("Version%d", i), version);
															#line 657 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				i++;
															#line 658 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				minVersion = minVersion.present() ? std::min(version, minVersion.get()) : version;
															#line 6264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
		else
		{
															#line 661 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("EmptyBackupStartKey", self->dbgid).log();
															#line 6271 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 663 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (noopValue.present())
															#line 6275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 664 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			noopVersion = BinaryReader::fromStringRef<Version>(noopValue.get(), Unversioned());
															#line 6279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 666 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<GetMinBackupVersionActor*>(this)->SAV<std::pair<Optional<Version>, Optional<Version>>>::futures) { (void)(std::make_pair(minVersion, noopVersion)); this->~GetMinBackupVersionActorState(); static_cast<GetMinBackupVersionActor*>(this)->destroy(); return 0; }
															#line 6283 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<GetMinBackupVersionActor*>(this)->SAV< std::pair<Optional<Version>, Optional<Version>> >::value()) std::pair<Optional<Version>, Optional<Version>>(std::make_pair(minVersion, noopVersion));
		this->~GetMinBackupVersionActorState();
		static_cast<GetMinBackupVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetMinBackupVersionActor*>(this)->actor_wait_state > 0) static_cast<GetMinBackupVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetMinBackupVersionActor*>(this)->ActorCallback< GetMinBackupVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetMinBackupVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinBackupVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetMinBackupVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinBackupVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetMinBackupVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinBackupVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetMinBackupVersionActor*>(this)->actor_wait_state > 0) static_cast<GetMinBackupVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetMinBackupVersionActor*>(this)->ActorCallback< GetMinBackupVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetMinBackupVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinBackupVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetMinBackupVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinBackupVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetMinBackupVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinBackupVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMinBackupVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 636 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 636 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Database cx;
															#line 640 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 645 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Optional<Value>> fValue;
															#line 646 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Optional<Value>> fNoopValue;
															#line 6463 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via getMinBackupVersion()
															#line 636 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class GetMinBackupVersionActor final : public Actor<std::pair<Optional<Version>, Optional<Version>>>, public ActorCallback< GetMinBackupVersionActor, 0, Void >, public ActorCallback< GetMinBackupVersionActor, 1, Void >, public FastAllocated<GetMinBackupVersionActor>, public GetMinBackupVersionActorState<GetMinBackupVersionActor> {
															#line 6468 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<GetMinBackupVersionActor>::operator new;
	using FastAllocated<GetMinBackupVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3356836057984729856UL, 8176035802194354688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<Optional<Version>, Optional<Version>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetMinBackupVersionActor, 0, Void >;
friend struct ActorCallback< GetMinBackupVersionActor, 1, Void >;
															#line 636 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	GetMinBackupVersionActor(Reference<ClusterRecoveryData> const& self,Database const& cx) 
															#line 6486 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<std::pair<Optional<Version>, Optional<Version>>>(),
		   GetMinBackupVersionActorState<GetMinBackupVersionActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getMinBackupVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15001475540261082112UL, 3363868253404307200UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinBackupVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getMinBackupVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getMinBackupVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetMinBackupVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetMinBackupVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 636 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] static Future<std::pair<Optional<Version>, Optional<Version>>> getMinBackupVersion( Reference<ClusterRecoveryData> const& self, Database const& cx ) {
															#line 636 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<std::pair<Optional<Version>, Optional<Version>>>(new GetMinBackupVersionActor(self, cx));
															#line 6520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 673 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 6525 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via recruitBackupWorkers()
															#line 674 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class RecruitBackupWorkersActor>
															#line 674 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecruitBackupWorkersActorState {
															#line 6532 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 674 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitBackupWorkersActorState(Reference<ClusterRecoveryData> const& self,Database const& cx) 
															#line 674 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 674 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 674 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   cx(cx)
															#line 6541 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("recruitBackupWorkers", reinterpret_cast<unsigned long>(this));

	}
	~RecruitBackupWorkersActorState() 
	{
		fdb_probe_actor_destroy("recruitBackupWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 675 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			ASSERT(self->backupWorkers.size() > 0);
															#line 678 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->SECONDS_BEFORE_RECRUIT_BACKUP_WORKER);
															#line 678 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6560 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state = 1;
															#line 678 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecruitBackupWorkersActor, 0, Void >*>(static_cast<RecruitBackupWorkersActor*>(this)));
															#line 6565 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecruitBackupWorkersActorState();
		static_cast<RecruitBackupWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 680 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		epoch = self->cstate.myDBState.recoveryCount;
															#line 681 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		backupProgress = Reference<BackupProgress>(new BackupProgress(self->dbgid, self->logSystem->getOldEpochTagsVersionsInfo()));
															#line 683 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		gotProgress = getBackupProgress(cx, self->dbgid, backupProgress, true);
															#line 684 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		initializationReplies = std::vector<Future<InitializeBackupReply>>();
															#line 686 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		idsTags = std::vector<std::pair<UID, Tag>>();
															#line 687 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		logRouterTags = self->logSystem->getLogRouterTags();
															#line 688 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		idsTags.reserve(logRouterTags);
															#line 689 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for(int i = 0;i < logRouterTags;i++) {
															#line 690 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			idsTags.emplace_back(deterministicRandom()->randomUniqueID(), Tag(tagLocalityLogRouter, i));
															#line 6604 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 693 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		const Version startVersion = self->logSystem->getBackupStartVersion();
															#line 694 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		i = 0;
															#line 695 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for(;i < logRouterTags;i++) {
															#line 696 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			const auto& worker = self->backupWorkers[i % self->backupWorkers.size()];
															#line 697 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			InitializeBackupRequest req(idsTags[i].first);
															#line 698 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.recruitedEpoch = epoch;
															#line 699 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.backupEpoch = epoch;
															#line 700 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.routerTag = idsTags[i].second;
															#line 701 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.totalTags = logRouterTags;
															#line 702 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.startVersion = startVersion;
															#line 703 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("BackupRecruitment", self->dbgid) .detail("RequestID", req.reqId) .detail("Tag", req.routerTag.toString()) .detail("Epoch", epoch) .detail("BackupEpoch", epoch) .detail("StartVersion", req.startVersion);
															#line 709 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			initializationReplies.push_back( transformErrors(throwErrorOr(worker.backup.getReplyUnlessFailedFor( req, SERVER_KNOBS->BACKUP_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), backup_worker_failed()));
															#line 6630 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 715 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		fMinVersion = getMinBackupVersion(self, cx);
															#line 716 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = gotProgress && success(fMinVersion);
															#line 716 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6638 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state = 2;
															#line 716 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RecruitBackupWorkersActor, 1, Void >*>(static_cast<RecruitBackupWorkersActor*>(this)));
															#line 6643 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 680 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		epoch = self->cstate.myDBState.recoveryCount;
															#line 681 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		backupProgress = Reference<BackupProgress>(new BackupProgress(self->dbgid, self->logSystem->getOldEpochTagsVersionsInfo()));
															#line 683 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		gotProgress = getBackupProgress(cx, self->dbgid, backupProgress, true);
															#line 684 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		initializationReplies = std::vector<Future<InitializeBackupReply>>();
															#line 686 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		idsTags = std::vector<std::pair<UID, Tag>>();
															#line 687 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		logRouterTags = self->logSystem->getLogRouterTags();
															#line 688 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		idsTags.reserve(logRouterTags);
															#line 689 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for(int i = 0;i < logRouterTags;i++) {
															#line 690 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			idsTags.emplace_back(deterministicRandom()->randomUniqueID(), Tag(tagLocalityLogRouter, i));
															#line 6668 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 693 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		const Version startVersion = self->logSystem->getBackupStartVersion();
															#line 694 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		i = 0;
															#line 695 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for(;i < logRouterTags;i++) {
															#line 696 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			const auto& worker = self->backupWorkers[i % self->backupWorkers.size()];
															#line 697 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			InitializeBackupRequest req(idsTags[i].first);
															#line 698 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.recruitedEpoch = epoch;
															#line 699 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.backupEpoch = epoch;
															#line 700 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.routerTag = idsTags[i].second;
															#line 701 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.totalTags = logRouterTags;
															#line 702 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.startVersion = startVersion;
															#line 703 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("BackupRecruitment", self->dbgid) .detail("RequestID", req.reqId) .detail("Tag", req.routerTag.toString()) .detail("Epoch", epoch) .detail("BackupEpoch", epoch) .detail("StartVersion", req.startVersion);
															#line 709 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			initializationReplies.push_back( transformErrors(throwErrorOr(worker.backup.getReplyUnlessFailedFor( req, SERVER_KNOBS->BACKUP_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), backup_worker_failed()));
															#line 6694 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 715 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		fMinVersion = getMinBackupVersion(self, cx);
															#line 716 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = gotProgress && success(fMinVersion);
															#line 716 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6702 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state = 2;
															#line 716 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RecruitBackupWorkersActor, 1, Void >*>(static_cast<RecruitBackupWorkersActor*>(this)));
															#line 6707 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state > 0) static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitBackupWorkersActor*>(this)->ActorCallback< RecruitBackupWorkersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitBackupWorkersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecruitBackupWorkersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecruitBackupWorkersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 717 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Version> minVersion = fMinVersion.get().first;
															#line 718 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Version> noopVersion = fMinVersion.get().second;
															#line 719 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("MinBackupVersion", self->dbgid) .detail("Version", minVersion.present() ? minVersion.get() : -1) .detail("NoopVersion", noopVersion.present() ? noopVersion.get() : -1);
															#line 723 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::map<std::tuple<LogEpoch, Version, int>, std::map<Tag, Version>> toRecruit = backupProgress->getUnfinishedBackup();
															#line 725 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( const auto& [epochVersionTags, tagVersions] : toRecruit ) {
															#line 726 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			const Version oldEpochEnd = std::get<1>(epochVersionTags);
															#line 727 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if ((!minVersion.present() || minVersion.get() + 1 >= oldEpochEnd) || (noopVersion.present() && noopVersion.get() >= oldEpochEnd))
															#line 6803 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 729 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent("SkipBackupRecruitment", self->dbgid) .detail("MinVersion", minVersion.present() ? minVersion.get() : -1) .detail("NoopVersion", noopVersion.present() ? noopVersion.get() : -1) .detail("Epoch", epoch) .detail("OldEpoch", std::get<0>(epochVersionTags)) .detail("OldEpochEnd", oldEpochEnd);
															#line 6807 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				continue;
			}
															#line 737 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( const auto& [tag, version] : tagVersions ) {
															#line 738 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				const auto& worker = self->backupWorkers[i % self->backupWorkers.size()];
															#line 739 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				i++;
															#line 740 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				InitializeBackupRequest req(deterministicRandom()->randomUniqueID());
															#line 741 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.recruitedEpoch = epoch;
															#line 742 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.backupEpoch = std::get<0>(epochVersionTags);
															#line 743 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.routerTag = tag;
															#line 744 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.totalTags = std::get<2>(epochVersionTags);
															#line 745 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.startVersion = version;
															#line 746 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.endVersion = std::get<1>(epochVersionTags) - 1;
															#line 747 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent("BackupRecruitment", self->dbgid) .detail("RequestID", req.reqId) .detail("Tag", req.routerTag.toString()) .detail("Epoch", epoch) .detail("BackupEpoch", req.backupEpoch) .detail("StartVersion", req.startVersion) .detail("EndVersion", req.endVersion.get());
															#line 754 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				initializationReplies.push_back(transformErrors( throwErrorOr(worker.backup.getReplyUnlessFailedFor( req, SERVER_KNOBS->BACKUP_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), backup_worker_failed()));
															#line 6834 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 761 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<std::vector<InitializeBackupReply>> __when_expr_2 = getAll(initializationReplies);
															#line 761 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6841 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state = 3;
															#line 761 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecruitBackupWorkersActor, 2, std::vector<InitializeBackupReply> >*>(static_cast<RecruitBackupWorkersActor*>(this)));
															#line 6846 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 717 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Version> minVersion = fMinVersion.get().first;
															#line 718 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Version> noopVersion = fMinVersion.get().second;
															#line 719 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("MinBackupVersion", self->dbgid) .detail("Version", minVersion.present() ? minVersion.get() : -1) .detail("NoopVersion", noopVersion.present() ? noopVersion.get() : -1);
															#line 723 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::map<std::tuple<LogEpoch, Version, int>, std::map<Tag, Version>> toRecruit = backupProgress->getUnfinishedBackup();
															#line 725 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( const auto& [epochVersionTags, tagVersions] : toRecruit ) {
															#line 726 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			const Version oldEpochEnd = std::get<1>(epochVersionTags);
															#line 727 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if ((!minVersion.present() || minVersion.get() + 1 >= oldEpochEnd) || (noopVersion.present() && noopVersion.get() >= oldEpochEnd))
															#line 6867 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 729 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent("SkipBackupRecruitment", self->dbgid) .detail("MinVersion", minVersion.present() ? minVersion.get() : -1) .detail("NoopVersion", noopVersion.present() ? noopVersion.get() : -1) .detail("Epoch", epoch) .detail("OldEpoch", std::get<0>(epochVersionTags)) .detail("OldEpochEnd", oldEpochEnd);
															#line 6871 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				continue;
			}
															#line 737 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( const auto& [tag, version] : tagVersions ) {
															#line 738 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				const auto& worker = self->backupWorkers[i % self->backupWorkers.size()];
															#line 739 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				i++;
															#line 740 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				InitializeBackupRequest req(deterministicRandom()->randomUniqueID());
															#line 741 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.recruitedEpoch = epoch;
															#line 742 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.backupEpoch = std::get<0>(epochVersionTags);
															#line 743 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.routerTag = tag;
															#line 744 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.totalTags = std::get<2>(epochVersionTags);
															#line 745 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.startVersion = version;
															#line 746 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				req.endVersion = std::get<1>(epochVersionTags) - 1;
															#line 747 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent("BackupRecruitment", self->dbgid) .detail("RequestID", req.reqId) .detail("Tag", req.routerTag.toString()) .detail("Epoch", epoch) .detail("BackupEpoch", req.backupEpoch) .detail("StartVersion", req.startVersion) .detail("EndVersion", req.endVersion.get());
															#line 754 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				initializationReplies.push_back(transformErrors( throwErrorOr(worker.backup.getReplyUnlessFailedFor( req, SERVER_KNOBS->BACKUP_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), backup_worker_failed()));
															#line 6898 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 761 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<std::vector<InitializeBackupReply>> __when_expr_2 = getAll(initializationReplies);
															#line 761 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6905 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state = 3;
															#line 761 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecruitBackupWorkersActor, 2, std::vector<InitializeBackupReply> >*>(static_cast<RecruitBackupWorkersActor*>(this)));
															#line 6910 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state > 0) static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitBackupWorkersActor*>(this)->ActorCallback< RecruitBackupWorkersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitBackupWorkersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RecruitBackupWorkersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RecruitBackupWorkersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(std::vector<InitializeBackupReply> const& newRecruits,int loopDepth) 
	{
															#line 762 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem->setBackupWorkers(newRecruits);
															#line 763 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("BackupRecruitmentDone", self->dbgid).log();
															#line 764 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->registrationTrigger.trigger();
															#line 765 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<RecruitBackupWorkersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecruitBackupWorkersActorState(); static_cast<RecruitBackupWorkersActor*>(this)->destroy(); return 0; }
															#line 7000 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<RecruitBackupWorkersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecruitBackupWorkersActorState();
		static_cast<RecruitBackupWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(std::vector<InitializeBackupReply> && newRecruits,int loopDepth) 
	{
															#line 762 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->logSystem->setBackupWorkers(newRecruits);
															#line 763 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("BackupRecruitmentDone", self->dbgid).log();
															#line 764 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->registrationTrigger.trigger();
															#line 765 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<RecruitBackupWorkersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecruitBackupWorkersActorState(); static_cast<RecruitBackupWorkersActor*>(this)->destroy(); return 0; }
															#line 7018 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<RecruitBackupWorkersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecruitBackupWorkersActorState();
		static_cast<RecruitBackupWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<InitializeBackupReply> const& newRecruits,int loopDepth) 
	{
		loopDepth = a_body1cont5(newRecruits, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<InitializeBackupReply> && newRecruits,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(newRecruits), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state > 0) static_cast<RecruitBackupWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitBackupWorkersActor*>(this)->ActorCallback< RecruitBackupWorkersActor, 2, std::vector<InitializeBackupReply> >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitBackupWorkersActor, 2, std::vector<InitializeBackupReply> >*,std::vector<InitializeBackupReply> const& value) 
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RecruitBackupWorkersActor, 2, std::vector<InitializeBackupReply> >*,std::vector<InitializeBackupReply> && value) 
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RecruitBackupWorkersActor, 2, std::vector<InitializeBackupReply> >*,Error err) 
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 674 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 674 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Database cx;
															#line 680 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	LogEpoch epoch;
															#line 681 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<BackupProgress> backupProgress;
															#line 683 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> gotProgress;
															#line 684 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<Future<InitializeBackupReply>> initializationReplies;
															#line 686 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<std::pair<UID, Tag>> idsTags;
															#line 687 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	int logRouterTags;
															#line 694 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	int i;
															#line 715 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<std::pair<Optional<Version>, Optional<Version>>> fMinVersion;
															#line 7121 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via recruitBackupWorkers()
															#line 674 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecruitBackupWorkersActor final : public Actor<Void>, public ActorCallback< RecruitBackupWorkersActor, 0, Void >, public ActorCallback< RecruitBackupWorkersActor, 1, Void >, public ActorCallback< RecruitBackupWorkersActor, 2, std::vector<InitializeBackupReply> >, public FastAllocated<RecruitBackupWorkersActor>, public RecruitBackupWorkersActorState<RecruitBackupWorkersActor> {
															#line 7126 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<RecruitBackupWorkersActor>::operator new;
	using FastAllocated<RecruitBackupWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15069863424158752768UL, 10842516113765171712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecruitBackupWorkersActor, 0, Void >;
friend struct ActorCallback< RecruitBackupWorkersActor, 1, Void >;
friend struct ActorCallback< RecruitBackupWorkersActor, 2, std::vector<InitializeBackupReply> >;
															#line 674 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitBackupWorkersActor(Reference<ClusterRecoveryData> const& self,Database const& cx) 
															#line 7145 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   RecruitBackupWorkersActorState<RecruitBackupWorkersActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3680272819488559360UL, 2489044161561874944UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recruitBackupWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recruitBackupWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecruitBackupWorkersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RecruitBackupWorkersActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RecruitBackupWorkersActor, 2, std::vector<InitializeBackupReply> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 674 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] static Future<Void> recruitBackupWorkers( Reference<ClusterRecoveryData> const& self, Database const& cx ) {
															#line 674 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new RecruitBackupWorkersActor(self, cx));
															#line 7180 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 767 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 7185 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via updateLogsValue()
															#line 768 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class UpdateLogsValueActor>
															#line 768 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class UpdateLogsValueActorState {
															#line 7192 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 768 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	UpdateLogsValueActorState(Reference<ClusterRecoveryData> const& self,Database const& cx) 
															#line 768 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 768 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 768 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   cx(cx),
															#line 769 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   tr(cx)
															#line 7203 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("updateLogsValue", reinterpret_cast<unsigned long>(this));

	}
	~UpdateLogsValueActorState() 
	{
		fdb_probe_actor_destroy("updateLogsValue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 770 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 7218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateLogsValueActorState();
		static_cast<UpdateLogsValueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 772 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Optional<Standalone<StringRef>>> __when_expr_0 = tr.get(logsKey);
															#line 772 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<UpdateLogsValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7251 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateLogsValueActor*>(this)->actor_wait_state = 1;
															#line 772 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateLogsValueActor, 0, Optional<Standalone<StringRef>> >*>(static_cast<UpdateLogsValueActor*>(this)));
															#line 7256 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 803 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 803 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<UpdateLogsValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<UpdateLogsValueActor*>(this)->actor_wait_state = 3;
															#line 803 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateLogsValueActor, 2, Void >*>(static_cast<UpdateLogsValueActor*>(this)));
															#line 7285 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Standalone<StringRef>> const& value,int loopDepth) 
	{
															#line 773 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(value.present());
															#line 774 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto logs = decodeLogsValue(value.get());
															#line 776 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::set<UID> logIds;
															#line 777 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& log : logs.first ) {
															#line 778 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			logIds.insert(log.first);
															#line 7308 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 781 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		bool found = false;
															#line 782 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& logSet : self->logSystem->getLogSystemConfig().tLogs ) {
															#line 783 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& log : logSet.tLogs ) {
															#line 784 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (logIds.contains(log.id()))
															#line 7318 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 785 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					found = true;
															#line 7322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					break;
				}
			}
															#line 789 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (found)
															#line 7328 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
				break;
			}
		}
															#line 794 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!found)
															#line 7335 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 795 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "old master attempted to change logsKey", probe::decoration::rare);
															#line 796 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<UpdateLogsValueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLogsValueActorState(); static_cast<UpdateLogsValueActor*>(this)->destroy(); return 0; }
															#line 7341 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<UpdateLogsValueActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~UpdateLogsValueActorState();
			static_cast<UpdateLogsValueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 799 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr.set(logsKey, self->logSystem->getLogsValue());
															#line 800 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 800 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<UpdateLogsValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7353 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateLogsValueActor*>(this)->actor_wait_state = 2;
															#line 800 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateLogsValueActor, 1, Void >*>(static_cast<UpdateLogsValueActor*>(this)));
															#line 7358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Standalone<StringRef>> && value,int loopDepth) 
	{
															#line 773 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(value.present());
															#line 774 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto logs = decodeLogsValue(value.get());
															#line 776 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::set<UID> logIds;
															#line 777 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& log : logs.first ) {
															#line 778 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			logIds.insert(log.first);
															#line 7375 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 781 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		bool found = false;
															#line 782 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& logSet : self->logSystem->getLogSystemConfig().tLogs ) {
															#line 783 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& log : logSet.tLogs ) {
															#line 784 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (logIds.contains(log.id()))
															#line 7385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 785 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					found = true;
															#line 7389 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					break;
				}
			}
															#line 789 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (found)
															#line 7395 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
				break;
			}
		}
															#line 794 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!found)
															#line 7402 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 795 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "old master attempted to change logsKey", probe::decoration::rare);
															#line 796 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<UpdateLogsValueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLogsValueActorState(); static_cast<UpdateLogsValueActor*>(this)->destroy(); return 0; }
															#line 7408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<UpdateLogsValueActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~UpdateLogsValueActorState();
			static_cast<UpdateLogsValueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 799 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr.set(logsKey, self->logSystem->getLogsValue());
															#line 800 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 800 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<UpdateLogsValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7420 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateLogsValueActor*>(this)->actor_wait_state = 2;
															#line 800 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateLogsValueActor, 1, Void >*>(static_cast<UpdateLogsValueActor*>(this)));
															#line 7425 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Standalone<StringRef>> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Standalone<StringRef>> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateLogsValueActor*>(this)->actor_wait_state > 0) static_cast<UpdateLogsValueActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLogsValueActor*>(this)->ActorCallback< UpdateLogsValueActor, 0, Optional<Standalone<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLogsValueActor, 0, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateLogsValueActor, 0, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> && value) 
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateLogsValueActor, 0, Optional<Standalone<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 801 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<UpdateLogsValueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLogsValueActorState(); static_cast<UpdateLogsValueActor*>(this)->destroy(); return 0; }
															#line 7509 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<UpdateLogsValueActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateLogsValueActorState();
		static_cast<UpdateLogsValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 801 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<UpdateLogsValueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLogsValueActorState(); static_cast<UpdateLogsValueActor*>(this)->destroy(); return 0; }
															#line 7521 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<UpdateLogsValueActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateLogsValueActorState();
		static_cast<UpdateLogsValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateLogsValueActor*>(this)->actor_wait_state > 0) static_cast<UpdateLogsValueActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLogsValueActor*>(this)->ActorCallback< UpdateLogsValueActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLogsValueActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateLogsValueActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateLogsValueActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdateLogsValueActor*>(this)->actor_wait_state > 0) static_cast<UpdateLogsValueActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLogsValueActor*>(this)->ActorCallback< UpdateLogsValueActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLogsValueActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateLogsValueActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateLogsValueActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 768 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 768 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Database cx;
															#line 769 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Transaction tr;
															#line 7697 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via updateLogsValue()
															#line 768 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class UpdateLogsValueActor final : public Actor<Void>, public ActorCallback< UpdateLogsValueActor, 0, Optional<Standalone<StringRef>> >, public ActorCallback< UpdateLogsValueActor, 1, Void >, public ActorCallback< UpdateLogsValueActor, 2, Void >, public FastAllocated<UpdateLogsValueActor>, public UpdateLogsValueActorState<UpdateLogsValueActor> {
															#line 7702 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<UpdateLogsValueActor>::operator new;
	using FastAllocated<UpdateLogsValueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12384039434893644800UL, 15068938829007595520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateLogsValueActor, 0, Optional<Standalone<StringRef>> >;
friend struct ActorCallback< UpdateLogsValueActor, 1, Void >;
friend struct ActorCallback< UpdateLogsValueActor, 2, Void >;
															#line 768 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	UpdateLogsValueActor(Reference<ClusterRecoveryData> const& self,Database const& cx) 
															#line 7721 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateLogsValueActorState<UpdateLogsValueActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateLogsValue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14887805552584892160UL, 15469785806168203264UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogsValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateLogsValue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateLogsValue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateLogsValueActor, 0, Optional<Standalone<StringRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateLogsValueActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdateLogsValueActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 768 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> updateLogsValue( Reference<ClusterRecoveryData> const& self, Database const& cx ) {
															#line 768 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new UpdateLogsValueActor(self, cx));
															#line 7756 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 807 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

// TODO(ahusain): ClusterController orchestrating recovery, self message can be avoided.
Future<Void> sendMasterRegistration(ClusterRecoveryData* self,
                                    LogSystemConfig const& logSystemConfig,
                                    std::vector<CommitProxyInterface> commitProxies,
                                    std::vector<GrvProxyInterface> grvProxies,
                                    std::vector<ResolverInterface> resolvers,
                                    DBRecoveryCount recoveryCount,
                                    std::vector<UID> priorCommittedLogServers) {
	RegisterMasterRequest masterReq;
	masterReq.id = self->masterInterface.id();
	masterReq.mi = self->masterInterface.locality;
	masterReq.logSystemConfig = logSystemConfig;
	masterReq.commitProxies = commitProxies;
	masterReq.grvProxies = grvProxies;
	masterReq.resolvers = resolvers;
	masterReq.recoveryCount = recoveryCount;
	if (self->hasConfiguration)
		masterReq.configuration = self->configuration;
	masterReq.registrationCount = ++self->registrationCount;
	masterReq.priorCommittedLogServers = priorCommittedLogServers;
	masterReq.recoveryState = self->recoveryState;
	masterReq.recoveryStalled = self->recruitmentStalled->get();
	return brokenPromiseToNever(self->clusterController.registerMaster.getReply(masterReq));
}

															#line 7786 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via updateRegistration()
															#line 833 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class UpdateRegistrationActor>
															#line 833 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class UpdateRegistrationActorState {
															#line 7793 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 833 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	UpdateRegistrationActorState(Reference<ClusterRecoveryData> const& self,Reference<ILogSystem> const& logSystem) 
															#line 833 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 833 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 833 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   logSystem(logSystem),
															#line 834 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   cx(openDBOnServer(self->dbInfo, TaskPriority::DefaultEndpoint, LockAware::True)),
															#line 835 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   trigger(self->registrationTrigger.onTrigger()),
															#line 836 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   updateLogsKey()
															#line 7808 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("updateRegistration", reinterpret_cast<unsigned long>(this));

	}
	~UpdateRegistrationActorState() 
	{
		fdb_probe_actor_destroy("updateRegistration", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 838 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 7823 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateRegistrationActorState();
		static_cast<UpdateRegistrationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 839 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_0 = trigger;
															#line 839 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7855 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 1;
															#line 839 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateRegistrationActor, 0, Void >*>(static_cast<UpdateRegistrationActor*>(this)));
															#line 7860 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 840 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(.001);
															#line 840 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7871 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 2;
															#line 840 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateRegistrationActor, 1, Void >*>(static_cast<UpdateRegistrationActor*>(this)));
															#line 7876 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 840 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(.001);
															#line 840 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7887 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 2;
															#line 840 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateRegistrationActor, 1, Void >*>(static_cast<UpdateRegistrationActor*>(this)));
															#line 7892 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state > 0) static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRegistrationActor*>(this)->ActorCallback< UpdateRegistrationActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRegistrationActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateRegistrationActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateRegistrationActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 842 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		trigger = self->registrationTrigger.onTrigger();
															#line 844 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto logSystemConfig = logSystem->getLogSystemConfig();
															#line 845 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("UpdateRegistration", self->dbgid) .detail("RecoveryCount", self->cstate.myDBState.recoveryCount) .detail("OldestBackupEpoch", logSystemConfig.oldestBackupEpoch) .detail("Logs", describe(logSystemConfig.tLogs)) .detail("OldGenerations", logSystemConfig.oldTLogs.size()) .detail("CStateUpdated", self->cstateUpdated.isSet()) .detail("RecoveryTxnVersion", self->recoveryTransactionVersion) .detail("LastEpochEnd", self->lastEpochEnd);
															#line 854 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!self->cstateUpdated.isSet())
															#line 7982 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 855 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_2 = sendMasterRegistration(self.getPtr(), logSystemConfig, self->provisionalCommitProxies, self->provisionalGrvProxies, self->resolvers, self->cstate.myDBState.recoveryCount, self->cstate.prevDBState.getPriorCommittedLogServers());
															#line 855 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7988 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 3;
															#line 855 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateRegistrationActor, 2, Void >*>(static_cast<UpdateRegistrationActor*>(this)));
															#line 7993 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 863 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->recoveryState >= RecoveryState::ACCEPTING_COMMITS)
															#line 8000 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 864 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				updateLogsKey = updateLogsValue(self, cx);
															#line 865 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Void> __when_expr_3 = sendMasterRegistration(self.getPtr(), logSystemConfig, self->commitProxies, self->grvProxies, self->resolvers, self->cstate.myDBState.recoveryCount, std::vector<UID>());
															#line 865 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8008 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when2(__when_expr_3.get(), loopDepth); };
				static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 4;
															#line 865 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateRegistrationActor, 3, Void >*>(static_cast<UpdateRegistrationActor*>(this)));
															#line 8013 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				CODE_PROBE(true, "cstate is updated but we aren't accepting commits yet", probe::decoration::rare);
															#line 8020 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = a_body1loopBody1cont5(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 842 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		trigger = self->registrationTrigger.onTrigger();
															#line 844 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto logSystemConfig = logSystem->getLogSystemConfig();
															#line 845 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("UpdateRegistration", self->dbgid) .detail("RecoveryCount", self->cstate.myDBState.recoveryCount) .detail("OldestBackupEpoch", logSystemConfig.oldestBackupEpoch) .detail("Logs", describe(logSystemConfig.tLogs)) .detail("OldGenerations", logSystemConfig.oldTLogs.size()) .detail("CStateUpdated", self->cstateUpdated.isSet()) .detail("RecoveryTxnVersion", self->recoveryTransactionVersion) .detail("LastEpochEnd", self->lastEpochEnd);
															#line 854 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!self->cstateUpdated.isSet())
															#line 8037 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 855 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_2 = sendMasterRegistration(self.getPtr(), logSystemConfig, self->provisionalCommitProxies, self->provisionalGrvProxies, self->resolvers, self->cstate.myDBState.recoveryCount, self->cstate.prevDBState.getPriorCommittedLogServers());
															#line 855 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8043 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 3;
															#line 855 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateRegistrationActor, 2, Void >*>(static_cast<UpdateRegistrationActor*>(this)));
															#line 8048 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 863 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->recoveryState >= RecoveryState::ACCEPTING_COMMITS)
															#line 8055 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 864 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				updateLogsKey = updateLogsValue(self, cx);
															#line 865 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Void> __when_expr_3 = sendMasterRegistration(self.getPtr(), logSystemConfig, self->commitProxies, self->grvProxies, self->resolvers, self->cstate.myDBState.recoveryCount, std::vector<UID>());
															#line 865 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8063 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when2(__when_expr_3.get(), loopDepth); };
				static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 4;
															#line 865 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateRegistrationActor, 3, Void >*>(static_cast<UpdateRegistrationActor*>(this)));
															#line 8068 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				CODE_PROBE(true, "cstate is updated but we aren't accepting commits yet", probe::decoration::rare);
															#line 8075 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = a_body1loopBody1cont5(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state > 0) static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRegistrationActor*>(this)->ActorCallback< UpdateRegistrationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRegistrationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateRegistrationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateRegistrationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state > 0) static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRegistrationActor*>(this)->ActorCallback< UpdateRegistrationActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRegistrationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateRegistrationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateRegistrationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<UpdateRegistrationActor*>(this)->actor_wait_state > 0) static_cast<UpdateRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRegistrationActor*>(this)->ActorCallback< UpdateRegistrationActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRegistrationActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< UpdateRegistrationActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< UpdateRegistrationActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 833 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 833 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ILogSystem> logSystem;
															#line 834 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Database cx;
															#line 835 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> trigger;
															#line 836 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> updateLogsKey;
															#line 8353 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via updateRegistration()
															#line 833 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class UpdateRegistrationActor final : public Actor<Void>, public ActorCallback< UpdateRegistrationActor, 0, Void >, public ActorCallback< UpdateRegistrationActor, 1, Void >, public ActorCallback< UpdateRegistrationActor, 2, Void >, public ActorCallback< UpdateRegistrationActor, 3, Void >, public FastAllocated<UpdateRegistrationActor>, public UpdateRegistrationActorState<UpdateRegistrationActor> {
															#line 8358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<UpdateRegistrationActor>::operator new;
	using FastAllocated<UpdateRegistrationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6763369228561921536UL, 6002030875208793856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateRegistrationActor, 0, Void >;
friend struct ActorCallback< UpdateRegistrationActor, 1, Void >;
friend struct ActorCallback< UpdateRegistrationActor, 2, Void >;
friend struct ActorCallback< UpdateRegistrationActor, 3, Void >;
															#line 833 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	UpdateRegistrationActor(Reference<ClusterRecoveryData> const& self,Reference<ILogSystem> const& logSystem) 
															#line 8378 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateRegistrationActorState<UpdateRegistrationActor>(self, logSystem),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateRegistration", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13255450057400323584UL, 112464096235605248UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateRegistration");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateRegistration", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateRegistrationActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateRegistrationActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdateRegistrationActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< UpdateRegistrationActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 833 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> updateRegistration( Reference<ClusterRecoveryData> const& self, Reference<ILogSystem> const& logSystem ) {
															#line 833 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new UpdateRegistrationActor(self, logSystem));
															#line 8414 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 878 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 8419 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via provisionalMaster()
															#line 879 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class ProvisionalMasterActor>
															#line 879 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ProvisionalMasterActorState {
															#line 8426 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 879 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ProvisionalMasterActorState(Reference<ClusterRecoveryData> const& parent,Future<Void> const& activate) 
															#line 879 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 879 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : parent(parent),
															#line 879 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   activate(activate)
															#line 8435 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("provisionalMaster", reinterpret_cast<unsigned long>(this));

	}
	~ProvisionalMasterActorState() 
	{
		fdb_probe_actor_destroy("provisionalMaster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 881 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = activate;
															#line 881 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<ProvisionalMasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8452 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ProvisionalMasterActor*>(this)->actor_wait_state = 1;
															#line 881 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProvisionalMasterActor, 0, Void >*>(static_cast<ProvisionalMasterActor*>(this)));
															#line 8457 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProvisionalMasterActorState();
		static_cast<ProvisionalMasterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 884 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalCommitProxies = std::vector<CommitProxyInterface>(1);
															#line 885 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalCommitProxies[0].provisional = true;
															#line 886 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalCommitProxies[0].initEndpoints();
															#line 887 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalGrvProxies = std::vector<GrvProxyInterface>(1);
															#line 888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalGrvProxies[0].provisional = true;
															#line 889 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalGrvProxies[0].initEndpoints();
															#line 890 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		waitCommitProxyFailure = waitFailureServer(parent->provisionalCommitProxies[0].waitFailure.getFuture());
															#line 892 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		waitGrvProxyFailure = waitFailureServer(parent->provisionalGrvProxies[0].waitFailure.getFuture());
															#line 894 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->registrationTrigger.trigger();
															#line 896 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto lockedKey = parent->txnStateStore->readValue(databaseLockedKey).get();
															#line 897 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		locked = lockedKey.present() && lockedKey.get().size();
															#line 899 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		metadataVersion = parent->txnStateStore->readValue(metadataVersionKey).get();
															#line 903 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		;
															#line 8504 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 884 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalCommitProxies = std::vector<CommitProxyInterface>(1);
															#line 885 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalCommitProxies[0].provisional = true;
															#line 886 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalCommitProxies[0].initEndpoints();
															#line 887 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalGrvProxies = std::vector<GrvProxyInterface>(1);
															#line 888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalGrvProxies[0].provisional = true;
															#line 889 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->provisionalGrvProxies[0].initEndpoints();
															#line 890 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		waitCommitProxyFailure = waitFailureServer(parent->provisionalCommitProxies[0].waitFailure.getFuture());
															#line 892 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		waitGrvProxyFailure = waitFailureServer(parent->provisionalGrvProxies[0].waitFailure.getFuture());
															#line 894 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		parent->registrationTrigger.trigger();
															#line 896 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto lockedKey = parent->txnStateStore->readValue(databaseLockedKey).get();
															#line 897 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		locked = lockedKey.present() && lockedKey.get().size();
															#line 899 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		metadataVersion = parent->txnStateStore->readValue(metadataVersionKey).get();
															#line 903 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		;
															#line 8537 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProvisionalMasterActor*>(this)->actor_wait_state > 0) static_cast<ProvisionalMasterActor*>(this)->actor_wait_state = 0;
		static_cast<ProvisionalMasterActor*>(this)->ActorCallback< ProvisionalMasterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProvisionalMasterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProvisionalMasterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProvisionalMasterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 904 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		FutureStream<GetReadVersionRequest> __when_expr_1 = parent->provisionalGrvProxies[0].getConsistentReadVersion.getFuture();
															#line 903 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ProvisionalMasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8630 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.pop(), loopDepth); };
															#line 917 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		FutureStream<CommitTransactionRequest> __when_expr_2 = parent->provisionalCommitProxies[0].commit.getFuture();
															#line 8634 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.pop(), loopDepth); };
															#line 947 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		FutureStream<GetKeyServerLocationsRequest> __when_expr_3 = parent->provisionalCommitProxies[0].getKeyServersLocations.getFuture();
															#line 8638 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when3(__when_expr_3.pop(), loopDepth); };
															#line 951 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		FutureStream<GetBlobGranuleLocationsRequest> __when_expr_4 = parent->provisionalCommitProxies[0].getBlobGranuleLocations.getFuture();
															#line 8642 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when4(__when_expr_4.pop(), loopDepth); };
															#line 955 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_5 = waitCommitProxyFailure;
															#line 8646 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when5(__when_expr_5.get(), loopDepth); };
															#line 958 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_6 = waitGrvProxyFailure;
															#line 8650 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when6(__when_expr_6.get(), loopDepth); };
		static_cast<ProvisionalMasterActor*>(this)->actor_wait_state = 2;
															#line 904 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< ProvisionalMasterActor, 1, GetReadVersionRequest >*>(static_cast<ProvisionalMasterActor*>(this)));
															#line 917 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< ProvisionalMasterActor, 2, CommitTransactionRequest >*>(static_cast<ProvisionalMasterActor*>(this)));
															#line 947 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< ProvisionalMasterActor, 3, GetKeyServerLocationsRequest >*>(static_cast<ProvisionalMasterActor*>(this)));
															#line 951 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< ProvisionalMasterActor, 4, GetBlobGranuleLocationsRequest >*>(static_cast<ProvisionalMasterActor*>(this)));
															#line 955 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ProvisionalMasterActor, 5, Void >*>(static_cast<ProvisionalMasterActor*>(this)));
															#line 958 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ProvisionalMasterActor, 6, Void >*>(static_cast<ProvisionalMasterActor*>(this)));
															#line 8665 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(GetReadVersionRequest const& req,int loopDepth) 
	{
															#line 906 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if ((req.flags & GetReadVersionRequest::FLAG_CAUSAL_READ_RISKY) && (req.flags & GetReadVersionRequest::FLAG_USE_PROVISIONAL_PROXIES) && parent->lastEpochEnd)
															#line 8680 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 908 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			GetReadVersionReply rep;
															#line 909 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rep.version = parent->lastEpochEnd;
															#line 910 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rep.locked = locked;
															#line 911 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rep.metadataVersion = metadataVersion;
															#line 912 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rep.proxyId = parent->provisionalGrvProxies[0].id();
															#line 913 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.reply.send(rep);
															#line 8694 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 915 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.reply.send(Never());
															#line 8700 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(GetReadVersionRequest && req,int loopDepth) 
	{
															#line 906 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if ((req.flags & GetReadVersionRequest::FLAG_CAUSAL_READ_RISKY) && (req.flags & GetReadVersionRequest::FLAG_USE_PROVISIONAL_PROXIES) && parent->lastEpochEnd)
															#line 8710 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 908 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			GetReadVersionReply rep;
															#line 909 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rep.version = parent->lastEpochEnd;
															#line 910 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rep.locked = locked;
															#line 911 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rep.metadataVersion = metadataVersion;
															#line 912 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			rep.proxyId = parent->provisionalGrvProxies[0].id();
															#line 913 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.reply.send(rep);
															#line 8724 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 915 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.reply.send(Never());
															#line 8730 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(CommitTransactionRequest const& req,int loopDepth) 
	{
															#line 918 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.reply.send(Never());
															#line 919 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto t = &req.transaction;
															#line 920 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (t->read_snapshot == parent->lastEpochEnd && !std::any_of(t->read_conflict_ranges.begin(), t->read_conflict_ranges.end(), [](KeyRangeRef const& r) { return r.contains(lastEpochEndKey); }))
															#line 8744 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 928 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for(auto m = t->mutations.begin();m != t->mutations.end();++m) {
															#line 929 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent("PM_CTM", parent->dbgid) .detail("MType", m->type) .detail("Param1", m->param1) .detail("Param2", m->param2);
															#line 934 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (parent->configuration.involveMutation(*m))
															#line 8752 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 937 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					Standalone<CommitTransactionRef> out;
															#line 938 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					out.read_snapshot = invalidVersion;
															#line 939 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					out.mutations.append_deep(out.arena(), t->mutations.begin(), t->mutations.size());
															#line 940 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					out.write_conflict_ranges.append_deep( out.arena(), t->write_conflict_ranges.begin(), t->write_conflict_ranges.size());
															#line 942 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					if (!static_cast<ProvisionalMasterActor*>(this)->SAV<Standalone<CommitTransactionRef>>::futures) { (void)(out); this->~ProvisionalMasterActorState(); static_cast<ProvisionalMasterActor*>(this)->destroy(); return 0; }
															#line 8764 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					new (&static_cast<ProvisionalMasterActor*>(this)->SAV< Standalone<CommitTransactionRef> >::value()) Standalone<CommitTransactionRef>(out);
					this->~ProvisionalMasterActorState();
					static_cast<ProvisionalMasterActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(CommitTransactionRequest && req,int loopDepth) 
	{
															#line 918 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.reply.send(Never());
															#line 919 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		auto t = &req.transaction;
															#line 920 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (t->read_snapshot == parent->lastEpochEnd && !std::any_of(t->read_conflict_ranges.begin(), t->read_conflict_ranges.end(), [](KeyRangeRef const& r) { return r.contains(lastEpochEndKey); }))
															#line 8784 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 928 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for(auto m = t->mutations.begin();m != t->mutations.end();++m) {
															#line 929 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent("PM_CTM", parent->dbgid) .detail("MType", m->type) .detail("Param1", m->param1) .detail("Param2", m->param2);
															#line 934 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (parent->configuration.involveMutation(*m))
															#line 8792 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 937 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					Standalone<CommitTransactionRef> out;
															#line 938 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					out.read_snapshot = invalidVersion;
															#line 939 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					out.mutations.append_deep(out.arena(), t->mutations.begin(), t->mutations.size());
															#line 940 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					out.write_conflict_ranges.append_deep( out.arena(), t->write_conflict_ranges.begin(), t->write_conflict_ranges.size());
															#line 942 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					if (!static_cast<ProvisionalMasterActor*>(this)->SAV<Standalone<CommitTransactionRef>>::futures) { (void)(out); this->~ProvisionalMasterActorState(); static_cast<ProvisionalMasterActor*>(this)->destroy(); return 0; }
															#line 8804 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					new (&static_cast<ProvisionalMasterActor*>(this)->SAV< Standalone<CommitTransactionRef> >::value()) Standalone<CommitTransactionRef>(out);
					this->~ProvisionalMasterActorState();
					static_cast<ProvisionalMasterActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(GetKeyServerLocationsRequest const& req,int loopDepth) 
	{
															#line 949 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.reply.send(Never());
															#line 8820 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(GetKeyServerLocationsRequest && req,int loopDepth) 
	{
															#line 949 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.reply.send(Never());
															#line 8829 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when4(GetBlobGranuleLocationsRequest const& req,int loopDepth) 
	{
															#line 953 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.reply.send(Never());
															#line 8838 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when4(GetBlobGranuleLocationsRequest && req,int loopDepth) 
	{
															#line 953 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.reply.send(Never());
															#line 8847 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when5(Void const& _,int loopDepth) 
	{
															#line 956 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(worker_removed(), std::max(0, loopDepth - 1));
															#line 8856 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1when5(Void && _,int loopDepth) 
	{
															#line 956 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(worker_removed(), std::max(0, loopDepth - 1));
															#line 8864 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1when6(Void const& _,int loopDepth) 
	{
															#line 959 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(worker_removed(), std::max(0, loopDepth - 1));
															#line 8872 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1when6(Void && _,int loopDepth) 
	{
															#line 959 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(worker_removed(), std::max(0, loopDepth - 1));
															#line 8880 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProvisionalMasterActor*>(this)->actor_wait_state > 0) static_cast<ProvisionalMasterActor*>(this)->actor_wait_state = 0;
		static_cast<ProvisionalMasterActor*>(this)->ActorSingleCallback< ProvisionalMasterActor, 1, GetReadVersionRequest >::remove();
		static_cast<ProvisionalMasterActor*>(this)->ActorSingleCallback< ProvisionalMasterActor, 2, CommitTransactionRequest >::remove();
		static_cast<ProvisionalMasterActor*>(this)->ActorSingleCallback< ProvisionalMasterActor, 3, GetKeyServerLocationsRequest >::remove();
		static_cast<ProvisionalMasterActor*>(this)->ActorSingleCallback< ProvisionalMasterActor, 4, GetBlobGranuleLocationsRequest >::remove();
		static_cast<ProvisionalMasterActor*>(this)->ActorCallback< ProvisionalMasterActor, 5, Void >::remove();
		static_cast<ProvisionalMasterActor*>(this)->ActorCallback< ProvisionalMasterActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ProvisionalMasterActor, 1, GetReadVersionRequest >*,GetReadVersionRequest const& value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ProvisionalMasterActor, 1, GetReadVersionRequest >*,GetReadVersionRequest && value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< ProvisionalMasterActor, 1, GetReadVersionRequest >*,Error err) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ProvisionalMasterActor, 2, CommitTransactionRequest >*,CommitTransactionRequest const& value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< ProvisionalMasterActor, 2, CommitTransactionRequest >*,CommitTransactionRequest && value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< ProvisionalMasterActor, 2, CommitTransactionRequest >*,Error err) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< ProvisionalMasterActor, 3, GetKeyServerLocationsRequest >*,GetKeyServerLocationsRequest const& value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< ProvisionalMasterActor, 3, GetKeyServerLocationsRequest >*,GetKeyServerLocationsRequest && value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< ProvisionalMasterActor, 3, GetKeyServerLocationsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< ProvisionalMasterActor, 4, GetBlobGranuleLocationsRequest >*,GetBlobGranuleLocationsRequest const& value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< ProvisionalMasterActor, 4, GetBlobGranuleLocationsRequest >*,GetBlobGranuleLocationsRequest && value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< ProvisionalMasterActor, 4, GetBlobGranuleLocationsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ProvisionalMasterActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ProvisionalMasterActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ProvisionalMasterActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ProvisionalMasterActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ProvisionalMasterActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ProvisionalMasterActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 879 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> parent;
															#line 879 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> activate;
															#line 890 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> waitCommitProxyFailure;
															#line 892 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> waitGrvProxyFailure;
															#line 897 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	bool locked;
															#line 899 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Optional<Value> metadataVersion;
															#line 9249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via provisionalMaster()
															#line 879 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ProvisionalMasterActor final : public Actor<Standalone<CommitTransactionRef>>, public ActorCallback< ProvisionalMasterActor, 0, Void >, public ActorSingleCallback< ProvisionalMasterActor, 1, GetReadVersionRequest >, public ActorSingleCallback< ProvisionalMasterActor, 2, CommitTransactionRequest >, public ActorSingleCallback< ProvisionalMasterActor, 3, GetKeyServerLocationsRequest >, public ActorSingleCallback< ProvisionalMasterActor, 4, GetBlobGranuleLocationsRequest >, public ActorCallback< ProvisionalMasterActor, 5, Void >, public ActorCallback< ProvisionalMasterActor, 6, Void >, public FastAllocated<ProvisionalMasterActor>, public ProvisionalMasterActorState<ProvisionalMasterActor> {
															#line 9254 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<ProvisionalMasterActor>::operator new;
	using FastAllocated<ProvisionalMasterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2652665348236441856UL, 3950037645502610944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<CommitTransactionRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProvisionalMasterActor, 0, Void >;
friend struct ActorSingleCallback< ProvisionalMasterActor, 1, GetReadVersionRequest >;
friend struct ActorSingleCallback< ProvisionalMasterActor, 2, CommitTransactionRequest >;
friend struct ActorSingleCallback< ProvisionalMasterActor, 3, GetKeyServerLocationsRequest >;
friend struct ActorSingleCallback< ProvisionalMasterActor, 4, GetBlobGranuleLocationsRequest >;
friend struct ActorCallback< ProvisionalMasterActor, 5, Void >;
friend struct ActorCallback< ProvisionalMasterActor, 6, Void >;
															#line 879 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ProvisionalMasterActor(Reference<ClusterRecoveryData> const& parent,Future<Void> const& activate) 
															#line 9277 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Standalone<CommitTransactionRef>>(),
		   ProvisionalMasterActorState<ProvisionalMasterActor>(parent, activate),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("provisionalMaster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9488506576048902144UL, 11989355939878536192UL);
		ActorExecutionContextHelper __helper(static_cast<ProvisionalMasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("provisionalMaster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("provisionalMaster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProvisionalMasterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< ProvisionalMasterActor, 1, GetReadVersionRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 879 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Standalone<CommitTransactionRef>> provisionalMaster( Reference<ClusterRecoveryData> const& parent, Future<Void> const& activate ) {
															#line 879 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Standalone<CommitTransactionRef>>(new ProvisionalMasterActor(parent, activate));
															#line 9311 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 963 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 9316 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via recruitEverything()
															#line 964 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class RecruitEverythingActor>
															#line 964 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecruitEverythingActorState {
															#line 9323 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 964 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitEverythingActorState(Reference<ClusterRecoveryData> const& self,std::vector<StorageServerInterface>* const& seedServers,Reference<ILogSystem> const& oldLogSystem) 
															#line 964 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 964 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 964 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   seedServers(seedServers),
															#line 964 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   oldLogSystem(oldLogSystem)
															#line 9334 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("recruitEverything", reinterpret_cast<unsigned long>(this));

	}
	~RecruitEverythingActorState() 
	{
		fdb_probe_actor_destroy("recruitEverything", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 968 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!self->configuration.isValid())
															#line 9349 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 969 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				RecoveryStatus::RecoveryStatus status;
															#line 970 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (self->configuration.initialized)
															#line 9355 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 971 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent( SevWarn, getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_INVALID_CONFIG_EVENT_NAME).c_str(), self->dbgid) .setMaxEventLength(11000) .setMaxFieldLength(10000) .detail("Conf", self->configuration.toString());
															#line 978 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					status = RecoveryStatus::configuration_invalid;
															#line 9361 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
				else
				{
															#line 979 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					if (!self->cstate.prevDBState.tLogs.size())
															#line 9367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					{
															#line 980 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
						status = RecoveryStatus::configuration_never_created;
															#line 981 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
						self->neverCreated = true;
															#line 9373 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					}
					else
					{
															#line 983 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
						status = RecoveryStatus::configuration_missing;
															#line 9379 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					}
				}
															#line 985 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", status) .detail("Status", RecoveryStatus::names[status]) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 990 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				this->~RecruitEverythingActorState();
															#line 9386 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				static_cast<RecruitEverythingActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
			else
			{
															#line 992 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .setMaxFieldLength(-1) .detail("StatusCode", RecoveryStatus::recruiting_transaction_servers) .detail("Status", RecoveryStatus::names[RecoveryStatus::recruiting_transaction_servers]) .detail("Conf", self->configuration.toString()) .detail("RequiredCommitProxies", 1) .detail("RequiredGrvProxies", 1) .detail("RequiredResolvers", 1) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1003 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (self->controllerData->encryptionAtRestMode.canBeSet())
															#line 9396 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 1004 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					self->controllerData->encryptionAtRestMode.send(getEncryptionAtRest(self->configuration));
															#line 9400 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
			}
															#line 1009 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			int maxLogRouters = self->cstate.prevDBState.logRouterTags;
															#line 1010 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& old : self->cstate.prevDBState.oldTLogData ) {
															#line 1011 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				maxLogRouters = std::max(maxLogRouters, old.logRouterTags);
															#line 9409 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1014 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			RecruitFromConfigurationRequest recruitReq(self->configuration, self->lastEpochEnd == 0, maxLogRouters);
															#line 1015 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			recruitWorkersInfo = makeReference<RecruitWorkersInfo>(recruitReq);
															#line 1016 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			recruitWorkersInfo->dbgId = self->dbgid;
															#line 1017 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = clusterRecruitFromConfiguration(self->controllerData, recruitWorkersInfo);
															#line 1017 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9421 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 1;
															#line 1017 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecruitEverythingActor, 0, Void >*>(static_cast<RecruitEverythingActor*>(this)));
															#line 9426 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecruitEverythingActorState();
		static_cast<RecruitEverythingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1018 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		recruits = recruitWorkersInfo->rep;
															#line 1020 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::string primaryDcIds, remoteDcIds;
															#line 1022 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->primaryDcId.clear();
															#line 1023 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->remoteDcIds.clear();
															#line 1024 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (recruits.dcId.present())
															#line 9457 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1025 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->primaryDcId.push_back(recruits.dcId);
															#line 1026 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!primaryDcIds.empty())
															#line 9463 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1027 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				primaryDcIds += ',';
															#line 9467 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1029 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			primaryDcIds += printable(recruits.dcId);
															#line 1030 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->configuration.regions.size() > 1)
															#line 9473 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1031 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				Key remoteDcId = recruits.dcId.get() == self->configuration.regions[0].dcId ? self->configuration.regions[1].dcId : self->configuration.regions[0].dcId;
															#line 1034 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->remoteDcIds.push_back(remoteDcId);
															#line 1035 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (!remoteDcIds.empty())
															#line 9481 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 1036 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					remoteDcIds += ',';
															#line 9485 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
															#line 1038 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				remoteDcIds += printable(remoteDcId);
															#line 9489 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1041 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->backupWorkers.swap(recruits.backupWorkers);
															#line 1045 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->primaryRecruitment = recruits;
															#line 1047 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::initializing_transaction_servers) .detail("Status", RecoveryStatus::names[RecoveryStatus::initializing_transaction_servers]) .detail("CommitProxies", recruits.commitProxies.size()) .detail("GrvProxies", recruits.grvProxies.size()) .detail("TLogs", recruits.tLogs.size()) .detail("Resolvers", recruits.resolvers.size()) .detail("SatelliteTLogs", recruits.satelliteTLogs.size()) .detail("OldLogRouters", recruits.oldLogRouters.size()) .detail("StorageServers", recruits.storageServers.size()) .detail("BackupWorkers", self->backupWorkers.size()) .detail("PrimaryDcIds", primaryDcIds) .detail("RemoteDcIds", remoteDcIds) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1065 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = newSeedServers(self, recruits, seedServers);
															#line 1065 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9502 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 2;
															#line 1065 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RecruitEverythingActor, 1, Void >*>(static_cast<RecruitEverythingActor*>(this)));
															#line 9507 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1018 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		recruits = recruitWorkersInfo->rep;
															#line 1020 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::string primaryDcIds, remoteDcIds;
															#line 1022 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->primaryDcId.clear();
															#line 1023 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->remoteDcIds.clear();
															#line 1024 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (recruits.dcId.present())
															#line 9524 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1025 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->primaryDcId.push_back(recruits.dcId);
															#line 1026 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!primaryDcIds.empty())
															#line 9530 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1027 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				primaryDcIds += ',';
															#line 9534 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1029 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			primaryDcIds += printable(recruits.dcId);
															#line 1030 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->configuration.regions.size() > 1)
															#line 9540 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1031 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				Key remoteDcId = recruits.dcId.get() == self->configuration.regions[0].dcId ? self->configuration.regions[1].dcId : self->configuration.regions[0].dcId;
															#line 1034 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->remoteDcIds.push_back(remoteDcId);
															#line 1035 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (!remoteDcIds.empty())
															#line 9548 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 1036 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					remoteDcIds += ',';
															#line 9552 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
															#line 1038 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				remoteDcIds += printable(remoteDcId);
															#line 9556 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1041 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->backupWorkers.swap(recruits.backupWorkers);
															#line 1045 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->primaryRecruitment = recruits;
															#line 1047 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::initializing_transaction_servers) .detail("Status", RecoveryStatus::names[RecoveryStatus::initializing_transaction_servers]) .detail("CommitProxies", recruits.commitProxies.size()) .detail("GrvProxies", recruits.grvProxies.size()) .detail("TLogs", recruits.tLogs.size()) .detail("Resolvers", recruits.resolvers.size()) .detail("SatelliteTLogs", recruits.satelliteTLogs.size()) .detail("OldLogRouters", recruits.oldLogRouters.size()) .detail("StorageServers", recruits.storageServers.size()) .detail("BackupWorkers", self->backupWorkers.size()) .detail("PrimaryDcIds", primaryDcIds) .detail("RemoteDcIds", remoteDcIds) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1065 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = newSeedServers(self, recruits, seedServers);
															#line 1065 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9569 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 2;
															#line 1065 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RecruitEverythingActor, 1, Void >*>(static_cast<RecruitEverythingActor*>(this)));
															#line 9574 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state > 0) static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitEverythingActor*>(this)->ActorCallback< RecruitEverythingActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitEverythingActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecruitEverythingActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecruitEverythingActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 1066 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		confChanges = std::vector<Standalone<CommitTransactionRef>>();
															#line 1067 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = newCommitProxies(self, recruits) && newGrvProxies(self, recruits) && newResolvers(self, recruits) && newTLogServers(self, recruits, oldLogSystem, &confChanges);
															#line 1067 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9662 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont10when1(__when_expr_2.get(), loopDepth); };
		static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 3;
															#line 1067 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecruitEverythingActor, 2, Void >*>(static_cast<RecruitEverythingActor*>(this)));
															#line 9667 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 1066 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		confChanges = std::vector<Standalone<CommitTransactionRef>>();
															#line 1067 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = newCommitProxies(self, recruits) && newGrvProxies(self, recruits) && newResolvers(self, recruits) && newTLogServers(self, recruits, oldLogSystem, &confChanges);
															#line 1067 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9680 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont10when1(__when_expr_2.get(), loopDepth); };
		static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 3;
															#line 1067 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecruitEverythingActor, 2, Void >*>(static_cast<RecruitEverythingActor*>(this)));
															#line 9685 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state > 0) static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitEverythingActor*>(this)->ActorCallback< RecruitEverythingActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitEverythingActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RecruitEverythingActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RecruitEverythingActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 1071 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_3 = brokenPromiseToNever( self->masterInterface.updateRecoveryData.getReply(UpdateRecoveryDataRequest(self->recoveryTransactionVersion, self->lastEpochEnd, self->commitProxies, self->resolvers, self->versionEpoch, self->primaryLocality)));
															#line 1071 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9771 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 4;
															#line 1071 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RecruitEverythingActor, 3, Void >*>(static_cast<RecruitEverythingActor*>(this)));
															#line 9776 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 1071 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_3 = brokenPromiseToNever( self->masterInterface.updateRecoveryData.getReply(UpdateRecoveryDataRequest(self->recoveryTransactionVersion, self->lastEpochEnd, self->commitProxies, self->resolvers, self->versionEpoch, self->primaryLocality)));
															#line 1071 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9787 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 4;
															#line 1071 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RecruitEverythingActor, 3, Void >*>(static_cast<RecruitEverythingActor*>(this)));
															#line 9792 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state > 0) static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitEverythingActor*>(this)->ActorCallback< RecruitEverythingActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitEverythingActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RecruitEverythingActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RecruitEverythingActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10cont2(Void const& _,int loopDepth) 
	{
															#line 1079 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<RecruitEverythingActor*>(this)->SAV<std::vector<Standalone<CommitTransactionRef>>>::futures) { (void)(confChanges); this->~RecruitEverythingActorState(); static_cast<RecruitEverythingActor*>(this)->destroy(); return 0; }
															#line 9876 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<RecruitEverythingActor*>(this)->SAV< std::vector<Standalone<CommitTransactionRef>> >::value()) std::vector<Standalone<CommitTransactionRef>>(std::move(confChanges)); // state_var_RVO
		this->~RecruitEverythingActorState();
		static_cast<RecruitEverythingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont2(Void && _,int loopDepth) 
	{
															#line 1079 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<RecruitEverythingActor*>(this)->SAV<std::vector<Standalone<CommitTransactionRef>>>::futures) { (void)(confChanges); this->~RecruitEverythingActorState(); static_cast<RecruitEverythingActor*>(this)->destroy(); return 0; }
															#line 9888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<RecruitEverythingActor*>(this)->SAV< std::vector<Standalone<CommitTransactionRef>> >::value()) std::vector<Standalone<CommitTransactionRef>>(std::move(confChanges)); // state_var_RVO
		this->~RecruitEverythingActorState();
		static_cast<RecruitEverythingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RecruitEverythingActor*>(this)->actor_wait_state > 0) static_cast<RecruitEverythingActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitEverythingActor*>(this)->ActorCallback< RecruitEverythingActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitEverythingActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RecruitEverythingActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RecruitEverythingActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 964 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 964 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<StorageServerInterface>* seedServers;
															#line 964 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ILogSystem> oldLogSystem;
															#line 1015 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<RecruitWorkersInfo> recruitWorkersInfo;
															#line 1018 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitFromConfigurationReply recruits;
															#line 1066 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<Standalone<CommitTransactionRef>> confChanges;
															#line 9983 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via recruitEverything()
															#line 964 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecruitEverythingActor final : public Actor<std::vector<Standalone<CommitTransactionRef>>>, public ActorCallback< RecruitEverythingActor, 0, Void >, public ActorCallback< RecruitEverythingActor, 1, Void >, public ActorCallback< RecruitEverythingActor, 2, Void >, public ActorCallback< RecruitEverythingActor, 3, Void >, public FastAllocated<RecruitEverythingActor>, public RecruitEverythingActorState<RecruitEverythingActor> {
															#line 9988 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<RecruitEverythingActor>::operator new;
	using FastAllocated<RecruitEverythingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7927661979278180096UL, 16835325358078750464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<Standalone<CommitTransactionRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecruitEverythingActor, 0, Void >;
friend struct ActorCallback< RecruitEverythingActor, 1, Void >;
friend struct ActorCallback< RecruitEverythingActor, 2, Void >;
friend struct ActorCallback< RecruitEverythingActor, 3, Void >;
															#line 964 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecruitEverythingActor(Reference<ClusterRecoveryData> const& self,std::vector<StorageServerInterface>* const& seedServers,Reference<ILogSystem> const& oldLogSystem) 
															#line 10008 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<std::vector<Standalone<CommitTransactionRef>>>(),
		   RecruitEverythingActorState<RecruitEverythingActor>(self, seedServers, oldLogSystem),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recruitEverything", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9272114927119600896UL, 817781714740981504UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitEverythingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recruitEverything");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recruitEverything", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecruitEverythingActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RecruitEverythingActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RecruitEverythingActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RecruitEverythingActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 964 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<std::vector<Standalone<CommitTransactionRef>>> recruitEverything( Reference<ClusterRecoveryData> const& self, std::vector<StorageServerInterface>* const& seedServers, Reference<ILogSystem> const& oldLogSystem ) {
															#line 964 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<std::vector<Standalone<CommitTransactionRef>>>(new RecruitEverythingActor(self, seedServers, oldLogSystem));
															#line 10044 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 1081 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 10049 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via updateLocalityForDcId()
															#line 1082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class UpdateLocalityForDcIdActor>
															#line 1082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class UpdateLocalityForDcIdActorState {
															#line 10056 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 1082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	UpdateLocalityForDcIdActorState(Optional<Key> const& dcId,Reference<ILogSystem> const& oldLogSystem,Reference<AsyncVar<PeekTxsInfo>> const& locality) 
															#line 1082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 1082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : dcId(dcId),
															#line 1082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   oldLogSystem(oldLogSystem),
															#line 1082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   locality(locality)
															#line 10067 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("updateLocalityForDcId", reinterpret_cast<unsigned long>(this));

	}
	~UpdateLocalityForDcIdActorState() 
	{
		fdb_probe_actor_destroy("updateLocalityForDcId", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1085 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 10082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateLocalityForDcIdActorState();
		static_cast<UpdateLocalityForDcIdActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1086 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::pair<int8_t, int8_t> loc = oldLogSystem->getLogSystemConfig().getLocalityForDcId(dcId);
															#line 1087 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Version ver = locality->get().knownCommittedVersion;
															#line 1088 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (ver == invalidVersion)
															#line 10116 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1089 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			ver = oldLogSystem->getKnownCommittedVersion();
															#line 10120 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1092 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		locality->set(PeekTxsInfo(loc.first, loc.second, ver));
															#line 1093 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("UpdatedLocalityForDcId") .detail("DcId", dcId) .detail("Locality0", loc.first) .detail("Locality1", loc.second) .detail("Version", ver);
															#line 1098 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_0 = oldLogSystem->onLogSystemConfigChange() || oldLogSystem->onKnownCommittedVersionChange();
															#line 1098 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<UpdateLocalityForDcIdActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10130 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<UpdateLocalityForDcIdActor*>(this)->actor_wait_state = 1;
															#line 1098 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateLocalityForDcIdActor, 0, Void >*>(static_cast<UpdateLocalityForDcIdActor*>(this)));
															#line 10135 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateLocalityForDcIdActor*>(this)->actor_wait_state > 0) static_cast<UpdateLocalityForDcIdActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLocalityForDcIdActor*>(this)->ActorCallback< UpdateLocalityForDcIdActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLocalityForDcIdActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLocalityForDcId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLocalityForDcIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLocalityForDcId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateLocalityForDcIdActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLocalityForDcId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLocalityForDcIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLocalityForDcId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateLocalityForDcIdActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLocalityForDcId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLocalityForDcIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLocalityForDcId", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Optional<Key> dcId;
															#line 1082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ILogSystem> oldLogSystem;
															#line 1082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<AsyncVar<PeekTxsInfo>> locality;
															#line 10233 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via updateLocalityForDcId()
															#line 1082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class UpdateLocalityForDcIdActor final : public Actor<Void>, public ActorCallback< UpdateLocalityForDcIdActor, 0, Void >, public FastAllocated<UpdateLocalityForDcIdActor>, public UpdateLocalityForDcIdActorState<UpdateLocalityForDcIdActor> {
															#line 10238 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<UpdateLocalityForDcIdActor>::operator new;
	using FastAllocated<UpdateLocalityForDcIdActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15871588497507102976UL, 10412161535420809984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateLocalityForDcIdActor, 0, Void >;
															#line 1082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	UpdateLocalityForDcIdActor(Optional<Key> const& dcId,Reference<ILogSystem> const& oldLogSystem,Reference<AsyncVar<PeekTxsInfo>> const& locality) 
															#line 10255 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateLocalityForDcIdActorState<UpdateLocalityForDcIdActor>(dcId, oldLogSystem, locality),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateLocalityForDcId", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11153092578858990848UL, 10071858602761177088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLocalityForDcIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateLocalityForDcId");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateLocalityForDcId", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateLocalityForDcIdActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> updateLocalityForDcId( Optional<Key> const& dcId, Reference<ILogSystem> const& oldLogSystem, Reference<AsyncVar<PeekTxsInfo>> const& locality ) {
															#line 1082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new UpdateLocalityForDcIdActor(dcId, oldLogSystem, locality));
															#line 10288 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 1101 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 10293 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via readTransactionSystemState()
															#line 1102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class ReadTransactionSystemStateActor>
															#line 1102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ReadTransactionSystemStateActorState {
															#line 10300 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 1102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ReadTransactionSystemStateActorState(Reference<ClusterRecoveryData> const& self,Reference<ILogSystem> const& oldLogSystem,Version const& txsPoppedVersion) 
															#line 1102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 1102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 1102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   oldLogSystem(oldLogSystem),
															#line 1102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   txsPoppedVersion(txsPoppedVersion),
															#line 1105 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   myLocality(Reference<AsyncVar<PeekTxsInfo>>( new AsyncVar<PeekTxsInfo>(PeekTxsInfo(tagLocalityInvalid, tagLocalityInvalid, invalidVersion)))),
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   localityUpdater(updateLocalityForDcId(self->masterInterface.locality.dcId(), oldLogSystem, myLocality)),
															#line 1120 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   enableEncryptionForTxnStateStore(false)
															#line 10317 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("readTransactionSystemState", reinterpret_cast<unsigned long>(this));

	}
	~ReadTransactionSystemStateActorState() 
	{
		fdb_probe_actor_destroy("readTransactionSystemState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1121 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->controllerData->encryptionAtRestMode.getFuture().isReady())
															#line 10332 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1122 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<EncryptionAtRestMode> __when_expr_0 = self->controllerData->encryptionAtRestMode.getFuture();
															#line 1122 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 1;
															#line 1122 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 0, EncryptionAtRestMode >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 10343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadTransactionSystemStateActorState();
		static_cast<ReadTransactionSystemStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1125 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		CODE_PROBE(enableEncryptionForTxnStateStore, "Enable encryption for txnStateStore", probe::decoration::rare);
															#line 1126 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->txnStateStore)
															#line 10373 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1127 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->txnStateStore->close();
															#line 10377 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1128 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->txnStateLogAdapter = openDiskQueueAdapter(oldLogSystem, myLocality, txsPoppedVersion);
															#line 1129 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->txnStateStore = keyValueStoreLogSystem(self->txnStateLogAdapter, self->dbInfo, self->dbgid, self->memoryLimit, false, false, true, enableEncryptionForTxnStateStore);
															#line 1140 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->versionEpoch.reset();
															#line 1141 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Optional<Standalone<StringRef>>> __when_expr_1 = self->txnStateStore->readValue(versionEpochKey);
															#line 1141 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10389 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 2;
															#line 1141 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 1, Optional<Standalone<StringRef>> >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 10394 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(EncryptionAtRestMode const& encryptMode,int loopDepth) 
	{
															#line 1123 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		enableEncryptionForTxnStateStore = encryptMode.isEncryptionEnabled();
															#line 10403 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(EncryptionAtRestMode && encryptMode,int loopDepth) 
	{
															#line 1123 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		enableEncryptionForTxnStateStore = encryptMode.isEncryptionEnabled();
															#line 10412 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(EncryptionAtRestMode const& encryptMode,int loopDepth) 
	{
		loopDepth = a_body1cont2(encryptMode, loopDepth);

		return loopDepth;
	}
	int a_body1when1(EncryptionAtRestMode && encryptMode,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(encryptMode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state > 0) static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTransactionSystemStateActor*>(this)->ActorCallback< ReadTransactionSystemStateActor, 0, EncryptionAtRestMode >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 0, EncryptionAtRestMode >*,EncryptionAtRestMode const& value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 0, EncryptionAtRestMode >*,EncryptionAtRestMode && value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadTransactionSystemStateActor, 0, EncryptionAtRestMode >*,Error err) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Optional<Standalone<StringRef>> const& versionEpochValue,int loopDepth) 
	{
															#line 1142 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (versionEpochValue.present())
															#line 10496 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1143 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->versionEpoch = BinaryReader::fromStringRef<int64_t>(versionEpochValue.get(), Unversioned());
															#line 10500 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1149 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Optional<Standalone<StringRef>>> __when_expr_2 = self->txnStateStore->readValue(minRequiredCommitVersionKey);
															#line 1149 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10506 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 3;
															#line 1149 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 2, Optional<Standalone<StringRef>> >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 10511 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Optional<Standalone<StringRef>> && versionEpochValue,int loopDepth) 
	{
															#line 1142 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (versionEpochValue.present())
															#line 10520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1143 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->versionEpoch = BinaryReader::fromStringRef<int64_t>(versionEpochValue.get(), Unversioned());
															#line 10524 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1149 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Optional<Standalone<StringRef>>> __when_expr_2 = self->txnStateStore->readValue(minRequiredCommitVersionKey);
															#line 1149 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10530 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 3;
															#line 1149 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 2, Optional<Standalone<StringRef>> >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 10535 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Standalone<StringRef>> const& versionEpochValue,int loopDepth) 
	{
		loopDepth = a_body1cont4(versionEpochValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Standalone<StringRef>> && versionEpochValue,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(versionEpochValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state > 0) static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTransactionSystemStateActor*>(this)->ActorCallback< ReadTransactionSystemStateActor, 1, Optional<Standalone<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 1, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 1, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> && value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadTransactionSystemStateActor, 1, Optional<Standalone<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(Optional<Standalone<StringRef>> const& requiredCommitVersion,int loopDepth) 
	{
															#line 1151 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Version minRequiredCommitVersion = -1;
															#line 1152 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (requiredCommitVersion.present())
															#line 10621 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1153 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			minRequiredCommitVersion = BinaryReader::fromStringRef<Version>(requiredCommitVersion.get(), Unversioned());
															#line 10625 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (g_network->isSimulated() && self->versionEpoch.present())
															#line 10629 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1156 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			minRequiredCommitVersion = std::max( minRequiredCommitVersion, static_cast<Version>(g_network->timer() * SERVER_KNOBS->VERSIONS_PER_SECOND - self->versionEpoch.get()));
															#line 10633 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1162 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->lastEpochEnd = oldLogSystem->getEnd() - 1;
															#line 1163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->lastEpochEnd == 0)
															#line 10639 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1164 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->recoveryTransactionVersion = 1;
															#line 10643 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 1166 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->forceRecovery)
															#line 10649 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1167 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryTransactionVersion = self->lastEpochEnd + SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT_FORCED;
															#line 10653 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
			else
			{
															#line 1169 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryTransactionVersion = self->lastEpochEnd + SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT;
															#line 10659 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1172 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->recoveryTransactionVersion < minRequiredCommitVersion)
															#line 10663 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryTransactionVersion = minRequiredCommitVersion;
															#line 10667 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1179 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (BUGGIFY)
															#line 10671 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1180 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryTransactionVersion += deterministicRandom()->randomInt64(0, 10000000);
															#line 10675 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1184 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_RECOVERING_EVENT_NAME).c_str(), self->dbgid) .detail("LastEpochEnd", self->lastEpochEnd) .detail("RecoveryTransactionVersion", self->recoveryTransactionVersion);
															#line 1189 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<RangeResult> __when_expr_3 = self->txnStateStore->readRange(configKeys);
															#line 1189 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10684 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 4;
															#line 1189 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 3, RangeResult >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 10689 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Optional<Standalone<StringRef>> && requiredCommitVersion,int loopDepth) 
	{
															#line 1151 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Version minRequiredCommitVersion = -1;
															#line 1152 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (requiredCommitVersion.present())
															#line 10700 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1153 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			minRequiredCommitVersion = BinaryReader::fromStringRef<Version>(requiredCommitVersion.get(), Unversioned());
															#line 10704 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (g_network->isSimulated() && self->versionEpoch.present())
															#line 10708 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1156 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			minRequiredCommitVersion = std::max( minRequiredCommitVersion, static_cast<Version>(g_network->timer() * SERVER_KNOBS->VERSIONS_PER_SECOND - self->versionEpoch.get()));
															#line 10712 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1162 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->lastEpochEnd = oldLogSystem->getEnd() - 1;
															#line 1163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->lastEpochEnd == 0)
															#line 10718 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1164 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->recoveryTransactionVersion = 1;
															#line 10722 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 1166 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->forceRecovery)
															#line 10728 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1167 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryTransactionVersion = self->lastEpochEnd + SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT_FORCED;
															#line 10732 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
			else
			{
															#line 1169 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryTransactionVersion = self->lastEpochEnd + SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT;
															#line 10738 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1172 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->recoveryTransactionVersion < minRequiredCommitVersion)
															#line 10742 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryTransactionVersion = minRequiredCommitVersion;
															#line 10746 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1179 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (BUGGIFY)
															#line 10750 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1180 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->recoveryTransactionVersion += deterministicRandom()->randomInt64(0, 10000000);
															#line 10754 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1184 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_RECOVERING_EVENT_NAME).c_str(), self->dbgid) .detail("LastEpochEnd", self->lastEpochEnd) .detail("RecoveryTransactionVersion", self->recoveryTransactionVersion);
															#line 1189 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<RangeResult> __when_expr_3 = self->txnStateStore->readRange(configKeys);
															#line 1189 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10763 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 4;
															#line 1189 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 3, RangeResult >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 10768 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Optional<Standalone<StringRef>> const& requiredCommitVersion,int loopDepth) 
	{
		loopDepth = a_body1cont6(requiredCommitVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Optional<Standalone<StringRef>> && requiredCommitVersion,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(requiredCommitVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state > 0) static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTransactionSystemStateActor*>(this)->ActorCallback< ReadTransactionSystemStateActor, 2, Optional<Standalone<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 2, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 2, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> && value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadTransactionSystemStateActor, 2, Optional<Standalone<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(RangeResult const& rawConf,int loopDepth) 
	{
															#line 1190 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->configuration.fromKeyValues(rawConf.castTo<VectorRef<KeyValueRef>>());
															#line 1191 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->originalConfiguration = self->configuration;
															#line 1192 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->hasConfiguration = true;
															#line 1194 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_RECOVERED_EVENT_NAME).c_str(), self->dbgid) .setMaxEventLength(11000) .setMaxFieldLength(10000) .detail("Conf", self->configuration.toString()) .trackLatest(self->recoveredConfigEventHolder->trackingKey);
															#line 1201 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<RangeResult> __when_expr_4 = self->txnStateStore->readRange(tagLocalityListKeys);
															#line 1201 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10862 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 5;
															#line 1201 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 4, RangeResult >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 10867 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(RangeResult && rawConf,int loopDepth) 
	{
															#line 1190 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->configuration.fromKeyValues(rawConf.castTo<VectorRef<KeyValueRef>>());
															#line 1191 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->originalConfiguration = self->configuration;
															#line 1192 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->hasConfiguration = true;
															#line 1194 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_RECOVERED_EVENT_NAME).c_str(), self->dbgid) .setMaxEventLength(11000) .setMaxFieldLength(10000) .detail("Conf", self->configuration.toString()) .trackLatest(self->recoveredConfigEventHolder->trackingKey);
															#line 1201 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<RangeResult> __when_expr_4 = self->txnStateStore->readRange(tagLocalityListKeys);
															#line 1201 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10886 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 5;
															#line 1201 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 4, RangeResult >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 10891 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(RangeResult const& rawConf,int loopDepth) 
	{
		loopDepth = a_body1cont8(rawConf, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(RangeResult && rawConf,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(rawConf), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state > 0) static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTransactionSystemStateActor*>(this)->ActorCallback< ReadTransactionSystemStateActor, 3, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 3, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 3, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ReadTransactionSystemStateActor, 3, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont17(RangeResult const& rawLocalities,int loopDepth) 
	{
															#line 1202 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->dcId_locality.clear();
															#line 1203 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& kv : rawLocalities ) {
															#line 1204 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->dcId_locality[decodeTagLocalityListKey(kv.key)] = decodeTagLocalityListValue(kv.value);
															#line 10979 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1207 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<RangeResult> __when_expr_5 = self->txnStateStore->readRange(serverTagKeys);
															#line 1207 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10985 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont17when1(__when_expr_5.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 6;
															#line 1207 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 5, RangeResult >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 10990 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont17(RangeResult && rawLocalities,int loopDepth) 
	{
															#line 1202 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->dcId_locality.clear();
															#line 1203 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& kv : rawLocalities ) {
															#line 1204 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->dcId_locality[decodeTagLocalityListKey(kv.key)] = decodeTagLocalityListValue(kv.value);
															#line 11003 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1207 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<RangeResult> __when_expr_5 = self->txnStateStore->readRange(serverTagKeys);
															#line 1207 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11009 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont17when1(__when_expr_5.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 6;
															#line 1207 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 5, RangeResult >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 11014 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(RangeResult const& rawLocalities,int loopDepth) 
	{
		loopDepth = a_body1cont17(rawLocalities, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(RangeResult && rawLocalities,int loopDepth) 
	{
		loopDepth = a_body1cont17(std::move(rawLocalities), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state > 0) static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTransactionSystemStateActor*>(this)->ActorCallback< ReadTransactionSystemStateActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ReadTransactionSystemStateActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont17cont1(RangeResult const& rawTags,int loopDepth) 
	{
															#line 1208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->allTags.clear();
															#line 1209 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->lastEpochEnd > 0)
															#line 11100 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1210 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->allTags.push_back(cacheTag);
															#line 11104 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1213 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->forceRecovery)
															#line 11108 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1214 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->safeLocality = oldLogSystem->getLogSystemConfig().tLogs[0].locality;
															#line 1215 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& kv : rawTags ) {
															#line 1216 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				Tag tag = decodeServerTagValue(kv.value);
															#line 1217 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (tag.locality == self->safeLocality)
															#line 11118 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					self->allTags.push_back(tag);
															#line 11122 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 1222 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& kv : rawTags ) {
															#line 1223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->allTags.push_back(decodeServerTagValue(kv.value));
															#line 11132 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1227 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = self->txnStateStore->readRange(serverTagHistoryKeys);
															#line 1227 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11139 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont17cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 7;
															#line 1227 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 6, RangeResult >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 11144 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont17cont1(RangeResult && rawTags,int loopDepth) 
	{
															#line 1208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->allTags.clear();
															#line 1209 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->lastEpochEnd > 0)
															#line 11155 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1210 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->allTags.push_back(cacheTag);
															#line 11159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1213 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->forceRecovery)
															#line 11163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1214 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->safeLocality = oldLogSystem->getLogSystemConfig().tLogs[0].locality;
															#line 1215 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& kv : rawTags ) {
															#line 1216 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				Tag tag = decodeServerTagValue(kv.value);
															#line 1217 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (tag.locality == self->safeLocality)
															#line 11173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 1218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					self->allTags.push_back(tag);
															#line 11177 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 1222 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& kv : rawTags ) {
															#line 1223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->allTags.push_back(decodeServerTagValue(kv.value));
															#line 11187 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1227 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = self->txnStateStore->readRange(serverTagHistoryKeys);
															#line 1227 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11194 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont17cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 7;
															#line 1227 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 6, RangeResult >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 11199 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont17when1(RangeResult const& rawTags,int loopDepth) 
	{
		loopDepth = a_body1cont17cont1(rawTags, loopDepth);

		return loopDepth;
	}
	int a_body1cont17when1(RangeResult && rawTags,int loopDepth) 
	{
		loopDepth = a_body1cont17cont1(std::move(rawTags), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state > 0) static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTransactionSystemStateActor*>(this)->ActorCallback< ReadTransactionSystemStateActor, 5, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 5, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont17when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 5, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont17when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ReadTransactionSystemStateActor, 5, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont17cont3(RangeResult const& rawHistoryTags,int loopDepth) 
	{
															#line 1228 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& kv : rawHistoryTags ) {
															#line 1229 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->allTags.push_back(decodeServerTagValue(kv.value));
															#line 11285 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1232 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_7 = self->txnStateStore->readValue(metacluster::metadata::metaclusterRegistration().key);
															#line 1232 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11291 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont17cont3when1(__when_expr_7.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 8;
															#line 1232 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 7, Optional<Value> >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 11296 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont17cont3(RangeResult && rawHistoryTags,int loopDepth) 
	{
															#line 1228 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& kv : rawHistoryTags ) {
															#line 1229 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->allTags.push_back(decodeServerTagValue(kv.value));
															#line 11307 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1232 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_7 = self->txnStateStore->readValue(metacluster::metadata::metaclusterRegistration().key);
															#line 1232 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11313 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont17cont3when1(__when_expr_7.get(), loopDepth); };
		static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 8;
															#line 1232 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ReadTransactionSystemStateActor, 7, Optional<Value> >*>(static_cast<ReadTransactionSystemStateActor*>(this)));
															#line 11318 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont17cont1when1(RangeResult const& rawHistoryTags,int loopDepth) 
	{
		loopDepth = a_body1cont17cont3(rawHistoryTags, loopDepth);

		return loopDepth;
	}
	int a_body1cont17cont1when1(RangeResult && rawHistoryTags,int loopDepth) 
	{
		loopDepth = a_body1cont17cont3(std::move(rawHistoryTags), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state > 0) static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTransactionSystemStateActor*>(this)->ActorCallback< ReadTransactionSystemStateActor, 6, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 6, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont17cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 6, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont17cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ReadTransactionSystemStateActor, 6, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont17cont10(Optional<Value> const& metaclusterRegistrationVal,int loopDepth) 
	{
															#line 1234 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<UnversionedMetaclusterRegistrationEntry> metaclusterRegistration = UnversionedMetaclusterRegistrationEntry::decode(metaclusterRegistrationVal);
															#line 1236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<ClusterName> metaclusterName;
															#line 1237 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<UID> metaclusterId;
															#line 1238 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<ClusterName> clusterName;
															#line 1239 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<UID> clusterId;
															#line 1240 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->controllerData->db.metaclusterRegistration = metaclusterRegistration;
															#line 1241 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (metaclusterRegistration.present())
															#line 11414 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1242 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->db.metaclusterName = metaclusterRegistration.get().metaclusterName;
															#line 1243 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->db.clusterType = metaclusterRegistration.get().clusterType;
															#line 1244 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			metaclusterName = metaclusterRegistration.get().metaclusterName;
															#line 1245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			metaclusterId = metaclusterRegistration.get().metaclusterId;
															#line 1246 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (metaclusterRegistration.get().clusterType == ClusterType::METACLUSTER_DATA)
															#line 11426 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1247 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				clusterName = metaclusterRegistration.get().name;
															#line 1248 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				clusterId = metaclusterRegistration.get().id;
															#line 11432 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
		else
		{
															#line 1251 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->db.metaclusterName = Optional<ClusterName>();
															#line 1252 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->db.clusterType = ClusterType::STANDALONE;
															#line 11441 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1255 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("MetaclusterMetadata") .detail("ClusterType", clusterTypeToString(self->controllerData->db.clusterType)) .detail("MetaclusterName", metaclusterName) .detail("MetaclusterId", metaclusterId) .detail("DataClusterName", clusterName) .detail("DataClusterId", clusterId) .trackLatest(self->metaclusterEventHolder->trackingKey);
															#line 1263 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		uniquify(self->allTags);
															#line 1269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->txnStateLogAdapter->setNextVersion( oldLogSystem->getEnd());
															#line 1274 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("RTSSComplete", self->dbgid).log();
															#line 1276 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<ReadTransactionSystemStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadTransactionSystemStateActorState(); static_cast<ReadTransactionSystemStateActor*>(this)->destroy(); return 0; }
															#line 11453 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<ReadTransactionSystemStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadTransactionSystemStateActorState();
		static_cast<ReadTransactionSystemStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont17cont10(Optional<Value> && metaclusterRegistrationVal,int loopDepth) 
	{
															#line 1234 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<UnversionedMetaclusterRegistrationEntry> metaclusterRegistration = UnversionedMetaclusterRegistrationEntry::decode(metaclusterRegistrationVal);
															#line 1236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<ClusterName> metaclusterName;
															#line 1237 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<UID> metaclusterId;
															#line 1238 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<ClusterName> clusterName;
															#line 1239 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<UID> clusterId;
															#line 1240 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->controllerData->db.metaclusterRegistration = metaclusterRegistration;
															#line 1241 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (metaclusterRegistration.present())
															#line 11477 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1242 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->db.metaclusterName = metaclusterRegistration.get().metaclusterName;
															#line 1243 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->db.clusterType = metaclusterRegistration.get().clusterType;
															#line 1244 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			metaclusterName = metaclusterRegistration.get().metaclusterName;
															#line 1245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			metaclusterId = metaclusterRegistration.get().metaclusterId;
															#line 1246 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (metaclusterRegistration.get().clusterType == ClusterType::METACLUSTER_DATA)
															#line 11489 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1247 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				clusterName = metaclusterRegistration.get().name;
															#line 1248 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				clusterId = metaclusterRegistration.get().id;
															#line 11495 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
		else
		{
															#line 1251 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->db.metaclusterName = Optional<ClusterName>();
															#line 1252 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->db.clusterType = ClusterType::STANDALONE;
															#line 11504 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1255 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("MetaclusterMetadata") .detail("ClusterType", clusterTypeToString(self->controllerData->db.clusterType)) .detail("MetaclusterName", metaclusterName) .detail("MetaclusterId", metaclusterId) .detail("DataClusterName", clusterName) .detail("DataClusterId", clusterId) .trackLatest(self->metaclusterEventHolder->trackingKey);
															#line 1263 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		uniquify(self->allTags);
															#line 1269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->txnStateLogAdapter->setNextVersion( oldLogSystem->getEnd());
															#line 1274 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("RTSSComplete", self->dbgid).log();
															#line 1276 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<ReadTransactionSystemStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadTransactionSystemStateActorState(); static_cast<ReadTransactionSystemStateActor*>(this)->destroy(); return 0; }
															#line 11516 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<ReadTransactionSystemStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadTransactionSystemStateActorState();
		static_cast<ReadTransactionSystemStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont17cont3when1(Optional<Value> const& metaclusterRegistrationVal,int loopDepth) 
	{
		loopDepth = a_body1cont17cont10(metaclusterRegistrationVal, loopDepth);

		return loopDepth;
	}
	int a_body1cont17cont3when1(Optional<Value> && metaclusterRegistrationVal,int loopDepth) 
	{
		loopDepth = a_body1cont17cont10(std::move(metaclusterRegistrationVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state > 0) static_cast<ReadTransactionSystemStateActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTransactionSystemStateActor*>(this)->ActorCallback< ReadTransactionSystemStateActor, 7, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 7, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont17cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ReadTransactionSystemStateActor, 7, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont17cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ReadTransactionSystemStateActor, 7, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 1102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 1102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ILogSystem> oldLogSystem;
															#line 1102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Version txsPoppedVersion;
															#line 1105 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<AsyncVar<PeekTxsInfo>> myLocality;
															#line 1107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> localityUpdater;
															#line 1120 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	bool enableEncryptionForTxnStateStore;
															#line 11611 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via readTransactionSystemState()
															#line 1102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ReadTransactionSystemStateActor final : public Actor<Void>, public ActorCallback< ReadTransactionSystemStateActor, 0, EncryptionAtRestMode >, public ActorCallback< ReadTransactionSystemStateActor, 1, Optional<Standalone<StringRef>> >, public ActorCallback< ReadTransactionSystemStateActor, 2, Optional<Standalone<StringRef>> >, public ActorCallback< ReadTransactionSystemStateActor, 3, RangeResult >, public ActorCallback< ReadTransactionSystemStateActor, 4, RangeResult >, public ActorCallback< ReadTransactionSystemStateActor, 5, RangeResult >, public ActorCallback< ReadTransactionSystemStateActor, 6, RangeResult >, public ActorCallback< ReadTransactionSystemStateActor, 7, Optional<Value> >, public FastAllocated<ReadTransactionSystemStateActor>, public ReadTransactionSystemStateActorState<ReadTransactionSystemStateActor> {
															#line 11616 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<ReadTransactionSystemStateActor>::operator new;
	using FastAllocated<ReadTransactionSystemStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8350590378723141376UL, 5719296472826520320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadTransactionSystemStateActor, 0, EncryptionAtRestMode >;
friend struct ActorCallback< ReadTransactionSystemStateActor, 1, Optional<Standalone<StringRef>> >;
friend struct ActorCallback< ReadTransactionSystemStateActor, 2, Optional<Standalone<StringRef>> >;
friend struct ActorCallback< ReadTransactionSystemStateActor, 3, RangeResult >;
friend struct ActorCallback< ReadTransactionSystemStateActor, 4, RangeResult >;
friend struct ActorCallback< ReadTransactionSystemStateActor, 5, RangeResult >;
friend struct ActorCallback< ReadTransactionSystemStateActor, 6, RangeResult >;
friend struct ActorCallback< ReadTransactionSystemStateActor, 7, Optional<Value> >;
															#line 1102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ReadTransactionSystemStateActor(Reference<ClusterRecoveryData> const& self,Reference<ILogSystem> const& oldLogSystem,Version const& txsPoppedVersion) 
															#line 11640 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   ReadTransactionSystemStateActorState<ReadTransactionSystemStateActor>(self, oldLogSystem, txsPoppedVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readTransactionSystemState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7841846366999263232UL, 14796013456903908864UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTransactionSystemStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readTransactionSystemState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readTransactionSystemState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadTransactionSystemStateActor, 0, EncryptionAtRestMode >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadTransactionSystemStateActor, 1, Optional<Standalone<StringRef>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReadTransactionSystemStateActor, 2, Optional<Standalone<StringRef>> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ReadTransactionSystemStateActor, 3, RangeResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ReadTransactionSystemStateActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ReadTransactionSystemStateActor, 5, RangeResult >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ReadTransactionSystemStateActor, 6, RangeResult >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ReadTransactionSystemStateActor, 7, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> readTransactionSystemState( Reference<ClusterRecoveryData> const& self, Reference<ILogSystem> const& oldLogSystem, Version const& txsPoppedVersion ) {
															#line 1102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new ReadTransactionSystemStateActor(self, oldLogSystem, txsPoppedVersion));
															#line 11680 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 1278 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 11685 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via sendInitialCommitToResolvers()
															#line 1279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class SendInitialCommitToResolversActor>
															#line 1279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class SendInitialCommitToResolversActorState {
															#line 11692 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 1279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	SendInitialCommitToResolversActorState(Reference<ClusterRecoveryData> const& self) 
															#line 1279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 1279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 1280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   txnKeys(allKeys),
															#line 1281 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   txnSequence(0)
															#line 11703 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this));

	}
	~SendInitialCommitToResolversActorState() 
	{
		fdb_probe_actor_destroy("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			ASSERT(self->recoveryTransactionVersion);
															#line 1284 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			data = self->txnStateStore ->readRange(txnKeys, BUGGIFY ? 3 : SERVER_KNOBS->DESIRED_TOTAL_BYTES, SERVER_KNOBS->DESIRED_TOTAL_BYTES) .get();
															#line 1288 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			txnReplies = std::vector<Future<Void>>();
															#line 1289 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			dataOutstanding = 0;
															#line 1291 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			endpoints = std::vector<Endpoint>();
															#line 1292 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& it : self->commitProxies ) {
															#line 1293 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				endpoints.push_back(it.txnState.getEndpoint());
															#line 11730 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1295 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS)
															#line 11734 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1297 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				for( auto& it : self->resolvers ) {
															#line 1298 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					endpoints.push_back(it.txnState.getEndpoint());
															#line 11740 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				}
			}
															#line 1301 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 11745 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SendInitialCommitToResolversActorState();
		static_cast<SendInitialCommitToResolversActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1329 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(txnReplies);
															#line 1329 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11770 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state = 3;
															#line 1329 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SendInitialCommitToResolversActor, 2, Void >*>(static_cast<SendInitialCommitToResolversActor*>(this)));
															#line 11775 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1302 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!data.size())
															#line 11791 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1304 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		((KeyRangeRef&)txnKeys) = KeyRangeRef(keyAfter(data.back().key, txnKeys.arena()), txnKeys.end);
															#line 1305 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		RangeResult nextData = self->txnStateStore ->readRange(txnKeys, BUGGIFY ? 3 : SERVER_KNOBS->DESIRED_TOTAL_BYTES, SERVER_KNOBS->DESIRED_TOTAL_BYTES) .get();
															#line 1310 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TxnStateRequest req;
															#line 1311 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.arena = data.arena();
															#line 1312 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.data = data;
															#line 1313 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.sequence = txnSequence;
															#line 1314 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.last = !nextData.size();
															#line 1315 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req.broadcastInfo = endpoints;
															#line 1316 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		txnReplies.push_back(broadcastTxnRequest(req, SERVER_KNOBS->TXN_STATE_SEND_AMOUNT, false));
															#line 1317 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		dataOutstanding += SERVER_KNOBS->TXN_STATE_SEND_AMOUNT * data.arena().getSize();
															#line 1318 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		data = nextData;
															#line 1319 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		txnSequence++;
															#line 1321 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (dataOutstanding > SERVER_KNOBS->MAX_TXS_SEND_MEMORY)
															#line 11821 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(txnReplies);
															#line 1322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11827 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state = 1;
															#line 1322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SendInitialCommitToResolversActor, 0, Void >*>(static_cast<SendInitialCommitToResolversActor*>(this)));
															#line 11832 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1327 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield();
															#line 1327 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11861 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state = 2;
															#line 1327 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SendInitialCommitToResolversActor, 1, Void >*>(static_cast<SendInitialCommitToResolversActor*>(this)));
															#line 11866 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1323 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		txnReplies = std::vector<Future<Void>>();
															#line 1324 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		dataOutstanding = 0;
															#line 11877 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1323 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		txnReplies = std::vector<Future<Void>>();
															#line 1324 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		dataOutstanding = 0;
															#line 11888 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state > 0) static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state = 0;
		static_cast<SendInitialCommitToResolversActor*>(this)->ActorCallback< SendInitialCommitToResolversActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SendInitialCommitToResolversActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SendInitialCommitToResolversActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SendInitialCommitToResolversActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state > 0) static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state = 0;
		static_cast<SendInitialCommitToResolversActor*>(this)->ActorCallback< SendInitialCommitToResolversActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SendInitialCommitToResolversActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SendInitialCommitToResolversActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SendInitialCommitToResolversActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1330 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("RecoveryInternal", self->dbgid) .detail("StatusCode", RecoveryStatus::recovery_transaction) .detail("Status", RecoveryStatus::names[RecoveryStatus::recovery_transaction]) .detail("RecoveryTxnVersion", self->recoveryTransactionVersion) .detail("LastEpochEnd", self->lastEpochEnd) .detail("Step", "SentTxnStateStoreToCommitProxies");
															#line 1337 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::vector<Future<ResolveTransactionBatchReply>> replies;
															#line 1338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& r : self->resolvers ) {
															#line 1339 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			ResolveTransactionBatchRequest req;
															#line 1340 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.prevVersion = -1;
															#line 1341 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.version = self->lastEpochEnd;
															#line 1342 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.lastReceivedVersion = -1;
															#line 1343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.lastShardMove = -1;
															#line 1344 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			replies.push_back(brokenPromiseToNever(r.resolve.getReply(req)));
															#line 12075 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1347 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(replies);
															#line 1347 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12081 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state = 4;
															#line 1347 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SendInitialCommitToResolversActor, 3, Void >*>(static_cast<SendInitialCommitToResolversActor*>(this)));
															#line 12086 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1330 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("RecoveryInternal", self->dbgid) .detail("StatusCode", RecoveryStatus::recovery_transaction) .detail("Status", RecoveryStatus::names[RecoveryStatus::recovery_transaction]) .detail("RecoveryTxnVersion", self->recoveryTransactionVersion) .detail("LastEpochEnd", self->lastEpochEnd) .detail("Step", "SentTxnStateStoreToCommitProxies");
															#line 1337 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		std::vector<Future<ResolveTransactionBatchReply>> replies;
															#line 1338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& r : self->resolvers ) {
															#line 1339 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			ResolveTransactionBatchRequest req;
															#line 1340 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.prevVersion = -1;
															#line 1341 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.version = self->lastEpochEnd;
															#line 1342 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.lastReceivedVersion = -1;
															#line 1343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			req.lastShardMove = -1;
															#line 1344 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			replies.push_back(brokenPromiseToNever(r.resolve.getReply(req)));
															#line 12111 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1347 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(replies);
															#line 1347 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12117 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state = 4;
															#line 1347 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SendInitialCommitToResolversActor, 3, Void >*>(static_cast<SendInitialCommitToResolversActor*>(this)));
															#line 12122 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state > 0) static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state = 0;
		static_cast<SendInitialCommitToResolversActor*>(this)->ActorCallback< SendInitialCommitToResolversActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SendInitialCommitToResolversActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SendInitialCommitToResolversActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SendInitialCommitToResolversActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1348 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("RecoveryInternal", self->dbgid) .detail("StatusCode", RecoveryStatus::recovery_transaction) .detail("Status", RecoveryStatus::names[RecoveryStatus::recovery_transaction]) .detail("RecoveryTxnVersion", self->recoveryTransactionVersion) .detail("LastEpochEnd", self->lastEpochEnd) .detail("Step", "InitializedAllResolvers");
															#line 1354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<SendInitialCommitToResolversActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SendInitialCommitToResolversActorState(); static_cast<SendInitialCommitToResolversActor*>(this)->destroy(); return 0; }
															#line 12208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<SendInitialCommitToResolversActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SendInitialCommitToResolversActorState();
		static_cast<SendInitialCommitToResolversActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1348 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("RecoveryInternal", self->dbgid) .detail("StatusCode", RecoveryStatus::recovery_transaction) .detail("Status", RecoveryStatus::names[RecoveryStatus::recovery_transaction]) .detail("RecoveryTxnVersion", self->recoveryTransactionVersion) .detail("LastEpochEnd", self->lastEpochEnd) .detail("Step", "InitializedAllResolvers");
															#line 1354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<SendInitialCommitToResolversActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SendInitialCommitToResolversActorState(); static_cast<SendInitialCommitToResolversActor*>(this)->destroy(); return 0; }
															#line 12222 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<SendInitialCommitToResolversActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SendInitialCommitToResolversActorState();
		static_cast<SendInitialCommitToResolversActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state > 0) static_cast<SendInitialCommitToResolversActor*>(this)->actor_wait_state = 0;
		static_cast<SendInitialCommitToResolversActor*>(this)->ActorCallback< SendInitialCommitToResolversActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SendInitialCommitToResolversActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SendInitialCommitToResolversActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SendInitialCommitToResolversActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 1280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	KeyRange txnKeys;
															#line 1281 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Sequence txnSequence;
															#line 1284 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RangeResult data;
															#line 1288 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<Future<Void>> txnReplies;
															#line 1289 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	int64_t dataOutstanding;
															#line 1291 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<Endpoint> endpoints;
															#line 12319 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via sendInitialCommitToResolvers()
															#line 1279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class SendInitialCommitToResolversActor final : public Actor<Void>, public ActorCallback< SendInitialCommitToResolversActor, 0, Void >, public ActorCallback< SendInitialCommitToResolversActor, 1, Void >, public ActorCallback< SendInitialCommitToResolversActor, 2, Void >, public ActorCallback< SendInitialCommitToResolversActor, 3, Void >, public FastAllocated<SendInitialCommitToResolversActor>, public SendInitialCommitToResolversActorState<SendInitialCommitToResolversActor> {
															#line 12324 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<SendInitialCommitToResolversActor>::operator new;
	using FastAllocated<SendInitialCommitToResolversActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16984514535706814464UL, 6649070033568765184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SendInitialCommitToResolversActor, 0, Void >;
friend struct ActorCallback< SendInitialCommitToResolversActor, 1, Void >;
friend struct ActorCallback< SendInitialCommitToResolversActor, 2, Void >;
friend struct ActorCallback< SendInitialCommitToResolversActor, 3, Void >;
															#line 1279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	SendInitialCommitToResolversActor(Reference<ClusterRecoveryData> const& self) 
															#line 12344 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   SendInitialCommitToResolversActorState<SendInitialCommitToResolversActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8619307040494944512UL, 12515564514269263616UL);
		ActorExecutionContextHelper __helper(static_cast<SendInitialCommitToResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sendInitialCommitToResolvers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sendInitialCommitToResolvers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SendInitialCommitToResolversActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SendInitialCommitToResolversActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SendInitialCommitToResolversActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SendInitialCommitToResolversActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> sendInitialCommitToResolvers( Reference<ClusterRecoveryData> const& self ) {
															#line 1279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new SendInitialCommitToResolversActor(self));
															#line 12380 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 1356 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 12385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via triggerUpdates()
															#line 1357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class TriggerUpdatesActor>
															#line 1357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class TriggerUpdatesActorState {
															#line 12392 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 1357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	TriggerUpdatesActorState(Reference<ClusterRecoveryData> const& self,Reference<ILogSystem> const& oldLogSystem) 
															#line 1357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 1357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 1357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   oldLogSystem(oldLogSystem)
															#line 12401 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("triggerUpdates", reinterpret_cast<unsigned long>(this));

	}
	~TriggerUpdatesActorState() 
	{
		fdb_probe_actor_destroy("triggerUpdates", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			;
															#line 12416 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TriggerUpdatesActorState();
		static_cast<TriggerUpdatesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1359 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_0 = oldLogSystem->onLogSystemConfigChange() || self->cstate.fullyRecovered.getFuture() || self->recruitmentStalled->onChange();
															#line 1359 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<TriggerUpdatesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12448 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TriggerUpdatesActor*>(this)->actor_wait_state = 1;
															#line 1359 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TriggerUpdatesActor, 0, Void >*>(static_cast<TriggerUpdatesActor*>(this)));
															#line 12453 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1361 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->cstate.fullyRecovered.isSet())
															#line 12462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<TriggerUpdatesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TriggerUpdatesActorState(); static_cast<TriggerUpdatesActor*>(this)->destroy(); return 0; }
															#line 12466 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<TriggerUpdatesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TriggerUpdatesActorState();
			static_cast<TriggerUpdatesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1364 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->registrationTrigger.trigger();
															#line 12474 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1361 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->cstate.fullyRecovered.isSet())
															#line 12483 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!static_cast<TriggerUpdatesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TriggerUpdatesActorState(); static_cast<TriggerUpdatesActor*>(this)->destroy(); return 0; }
															#line 12487 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			new (&static_cast<TriggerUpdatesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TriggerUpdatesActorState();
			static_cast<TriggerUpdatesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1364 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->registrationTrigger.trigger();
															#line 12495 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TriggerUpdatesActor*>(this)->actor_wait_state > 0) static_cast<TriggerUpdatesActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerUpdatesActor*>(this)->ActorCallback< TriggerUpdatesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerUpdatesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("triggerUpdates", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerUpdatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerUpdates", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TriggerUpdatesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("triggerUpdates", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerUpdatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerUpdates", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TriggerUpdatesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("triggerUpdates", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerUpdatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerUpdates", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 1357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ILogSystem> oldLogSystem;
															#line 12579 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via triggerUpdates()
															#line 1357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class TriggerUpdatesActor final : public Actor<Void>, public ActorCallback< TriggerUpdatesActor, 0, Void >, public FastAllocated<TriggerUpdatesActor>, public TriggerUpdatesActorState<TriggerUpdatesActor> {
															#line 12584 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<TriggerUpdatesActor>::operator new;
	using FastAllocated<TriggerUpdatesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13419288022173101312UL, 12802113902896212224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TriggerUpdatesActor, 0, Void >;
															#line 1357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	TriggerUpdatesActor(Reference<ClusterRecoveryData> const& self,Reference<ILogSystem> const& oldLogSystem) 
															#line 12601 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   TriggerUpdatesActorState<TriggerUpdatesActor>(self, oldLogSystem),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("triggerUpdates", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9654815222670740224UL, 9248498678420781568UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerUpdatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("triggerUpdates");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("triggerUpdates", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TriggerUpdatesActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> triggerUpdates( Reference<ClusterRecoveryData> const& self, Reference<ILogSystem> const& oldLogSystem ) {
															#line 1357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new TriggerUpdatesActor(self, oldLogSystem));
															#line 12634 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 1367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 12639 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via discardCommit()
															#line 1368 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class DiscardCommitActor>
															#line 1368 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class DiscardCommitActorState {
															#line 12646 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 1368 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	DiscardCommitActorState(IKeyValueStore* const& store,LogSystemDiskQueueAdapter* const& adapter) 
															#line 1368 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 1368 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : store(store),
															#line 1368 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   adapter(adapter),
															#line 1369 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   fcm(adapter->getCommitMessage()),
															#line 1370 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   committed(store->commit())
															#line 12659 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("discardCommit", reinterpret_cast<unsigned long>(this));

	}
	~DiscardCommitActorState() 
	{
		fdb_probe_actor_destroy("discardCommit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<LogSystemDiskQueueAdapter::CommitMessage> __when_expr_0 = fcm;
															#line 1371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<DiscardCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12676 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DiscardCommitActor*>(this)->actor_wait_state = 1;
															#line 1371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*>(static_cast<DiscardCommitActor*>(this)));
															#line 12681 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DiscardCommitActorState();
		static_cast<DiscardCommitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(LogSystemDiskQueueAdapter::CommitMessage const& cm,int loopDepth) 
	{
															#line 1372 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(!committed.isReady());
															#line 1373 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		cm.acknowledge.send(Void());
															#line 1374 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(committed.isReady());
															#line 1375 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<DiscardCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DiscardCommitActorState(); static_cast<DiscardCommitActor*>(this)->destroy(); return 0; }
															#line 12710 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<DiscardCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DiscardCommitActorState();
		static_cast<DiscardCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(LogSystemDiskQueueAdapter::CommitMessage && cm,int loopDepth) 
	{
															#line 1372 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(!committed.isReady());
															#line 1373 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		cm.acknowledge.send(Void());
															#line 1374 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(committed.isReady());
															#line 1375 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<DiscardCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DiscardCommitActorState(); static_cast<DiscardCommitActor*>(this)->destroy(); return 0; }
															#line 12728 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<DiscardCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DiscardCommitActorState();
		static_cast<DiscardCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(LogSystemDiskQueueAdapter::CommitMessage const& cm,int loopDepth) 
	{
		loopDepth = a_body1cont1(cm, loopDepth);

		return loopDepth;
	}
	int a_body1when1(LogSystemDiskQueueAdapter::CommitMessage && cm,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(cm), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DiscardCommitActor*>(this)->actor_wait_state > 0) static_cast<DiscardCommitActor*>(this)->actor_wait_state = 0;
		static_cast<DiscardCommitActor*>(this)->ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >::remove();

	}
	void a_callback_fire(ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*,LogSystemDiskQueueAdapter::CommitMessage const& value) 
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*,LogSystemDiskQueueAdapter::CommitMessage && value) 
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*,Error err) 
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1368 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	IKeyValueStore* store;
															#line 1368 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	LogSystemDiskQueueAdapter* adapter;
															#line 1369 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<LogSystemDiskQueueAdapter::CommitMessage> fcm;
															#line 1370 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> committed;
															#line 12819 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via discardCommit()
															#line 1368 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class DiscardCommitActor final : public Actor<Void>, public ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >, public FastAllocated<DiscardCommitActor>, public DiscardCommitActorState<DiscardCommitActor> {
															#line 12824 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<DiscardCommitActor>::operator new;
	using FastAllocated<DiscardCommitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16916364636033805056UL, 11942059956272720640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >;
															#line 1368 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	DiscardCommitActor(IKeyValueStore* const& store,LogSystemDiskQueueAdapter* const& adapter) 
															#line 12841 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   DiscardCommitActorState<DiscardCommitActor>(store, adapter),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7339418273539287808UL, 9304446022786112512UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("discardCommit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1368 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> discardCommit( IKeyValueStore* const& store, LogSystemDiskQueueAdapter* const& adapter ) {
															#line 1368 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new DiscardCommitActor(store, adapter));
															#line 12874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 1377 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

void updateConfigForForcedRecovery(Reference<ClusterRecoveryData> self,
                                   std::vector<Standalone<CommitTransactionRef>>* initialConfChanges) {
	bool regionsChanged = false;
	for (auto& it : self->configuration.regions) {
		if (it.dcId == self->controllerData->clusterControllerDcId.get() && it.priority < 0) {
			it.priority = 1;
			regionsChanged = true;
		} else if (it.dcId != self->controllerData->clusterControllerDcId.get() && it.priority >= 0) {
			it.priority = -1;
			regionsChanged = true;
		}
	}
	Standalone<CommitTransactionRef> regionCommit;
	regionCommit.mutations.push_back_deep(
	    regionCommit.arena(),
	    MutationRef(MutationRef::SetValue, configKeysPrefix.toString() + "usable_regions", "1"_sr));
	self->configuration.applyMutation(regionCommit.mutations.back());
	if (regionsChanged) {
		std::sort(
		    self->configuration.regions.begin(), self->configuration.regions.end(), RegionInfo::sort_by_priority());
		StatusObject regionJSON;
		regionJSON["regions"] = self->configuration.getRegionJSON();
		regionCommit.mutations.push_back_deep(
		    regionCommit.arena(),
		    MutationRef(MutationRef::SetValue,
		                configKeysPrefix.toString() + "regions",
		                BinaryWriter::toValue(regionJSON, IncludeVersion(ProtocolVersion::withRegionConfiguration()))
		                    .toString()));
		self->configuration.applyMutation(
		    regionCommit.mutations.back()); // modifying the configuration directly does not change the configuration
		                                    // when it is re-serialized unless we call applyMutation
		TraceEvent("ForcedRecoveryConfigChange", self->dbgid)
		    .setMaxEventLength(11000)
		    .setMaxFieldLength(10000)
		    .detail("Conf", self->configuration.toString());
	}
	initialConfChanges->push_back(regionCommit);
}

															#line 12918 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via recoverFrom()
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class RecoverFromActor>
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecoverFromActorState {
															#line 12925 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecoverFromActorState(Reference<ClusterRecoveryData> const& self,Reference<ILogSystem> const& oldLogSystem,std::vector<StorageServerInterface>* const& seedServers,std::vector<Standalone<CommitTransactionRef>>* const& initialConfChanges,Future<Version> const& poppedTxsVersion) 
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   oldLogSystem(oldLogSystem),
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   seedServers(seedServers),
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   initialConfChanges(initialConfChanges),
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   poppedTxsVersion(poppedTxsVersion)
															#line 12940 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("recoverFrom", reinterpret_cast<unsigned long>(this));

	}
	~RecoverFromActorState() 
	{
		fdb_probe_actor_destroy("recoverFrom", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::reading_transaction_system_state) .detail("Status", RecoveryStatus::names[RecoveryStatus::reading_transaction_system_state]) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1426 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->hasConfiguration = false;
															#line 1428 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (BUGGIFY)
															#line 12959 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1429 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(10.0);
															#line 1429 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<RecoverFromActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12965 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RecoverFromActor*>(this)->actor_wait_state = 1;
															#line 1429 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecoverFromActor, 0, Void >*>(static_cast<RecoverFromActor*>(this)));
															#line 12970 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecoverFromActorState();
		static_cast<RecoverFromActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1431 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Version> __when_expr_1 = poppedTxsVersion;
															#line 1431 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecoverFromActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13000 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RecoverFromActor*>(this)->actor_wait_state = 2;
															#line 1431 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RecoverFromActor, 1, Version >*>(static_cast<RecoverFromActor*>(this)));
															#line 13005 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecoverFromActor*>(this)->actor_wait_state > 0) static_cast<RecoverFromActor*>(this)->actor_wait_state = 0;
		static_cast<RecoverFromActor*>(this)->ActorCallback< RecoverFromActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecoverFromActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Version const& txsPoppedVersion,int loopDepth) 
	{
															#line 1432 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = readTransactionSystemState(self, oldLogSystem, txsPoppedVersion);
															#line 1432 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecoverFromActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13103 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<RecoverFromActor*>(this)->actor_wait_state = 3;
															#line 1432 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecoverFromActor, 2, Void >*>(static_cast<RecoverFromActor*>(this)));
															#line 13108 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Version && txsPoppedVersion,int loopDepth) 
	{
															#line 1432 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = readTransactionSystemState(self, oldLogSystem, txsPoppedVersion);
															#line 1432 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecoverFromActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13119 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<RecoverFromActor*>(this)->actor_wait_state = 3;
															#line 1432 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RecoverFromActor, 2, Void >*>(static_cast<RecoverFromActor*>(this)));
															#line 13124 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Version const& txsPoppedVersion,int loopDepth) 
	{
		loopDepth = a_body1cont3(txsPoppedVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Version && txsPoppedVersion,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(txsPoppedVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RecoverFromActor*>(this)->actor_wait_state > 0) static_cast<RecoverFromActor*>(this)->actor_wait_state = 0;
		static_cast<RecoverFromActor*>(this)->ActorCallback< RecoverFromActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RecoverFromActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1433 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& itr : *initialConfChanges ) {
															#line 1434 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& m : itr.mutations ) {
															#line 1435 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->configuration.applyMutation(m);
															#line 13212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->forceRecovery)
															#line 13217 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1440 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			updateConfigForForcedRecovery(self, initialConfChanges);
															#line 13221 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1443 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		debug_checkMaxRestoredVersion(UID(), self->lastEpochEnd, "DBRecovery");
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		originalLocalityMap = self->dcId_locality;
															#line 1450 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		recruitments = recruitEverything(self, seedServers, oldLogSystem);
															#line 1452 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		provisionalDelay = SERVER_KNOBS->PROVISIONAL_START_DELAY;
															#line 1453 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		;
															#line 13233 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1433 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& itr : *initialConfChanges ) {
															#line 1434 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& m : itr.mutations ) {
															#line 1435 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				self->configuration.applyMutation(m);
															#line 13246 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->forceRecovery)
															#line 13251 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1440 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			updateConfigForForcedRecovery(self, initialConfChanges);
															#line 13255 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1443 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		debug_checkMaxRestoredVersion(UID(), self->lastEpochEnd, "DBRecovery");
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		originalLocalityMap = self->dcId_locality;
															#line 1450 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		recruitments = recruitEverything(self, seedServers, oldLogSystem);
															#line 1452 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		provisionalDelay = SERVER_KNOBS->PROVISIONAL_START_DELAY;
															#line 1453 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		;
															#line 13267 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RecoverFromActor*>(this)->actor_wait_state > 0) static_cast<RecoverFromActor*>(this)->actor_wait_state = 0;
		static_cast<RecoverFromActor*>(this)->ActorCallback< RecoverFromActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RecoverFromActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 1500 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<RecoverFromActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecoverFromActorState(); static_cast<RecoverFromActor*>(this)->destroy(); return 0; }
															#line 13351 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<RecoverFromActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecoverFromActorState();
		static_cast<RecoverFromActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 1454 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		provisional = provisionalMaster(self, delay(provisionalDelay));
															#line 1455 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		provisionalDelay = std::min(SERVER_KNOBS->PROVISIONAL_MAX_DELAY, provisionalDelay * SERVER_KNOBS->PROVISIONAL_DELAY_GROWTH);
															#line 1458 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<std::vector<Standalone<CommitTransactionRef>>> __when_expr_3 = recruitments;
															#line 1457 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<RecoverFromActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13376 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_3.get(), loopDepth); };
															#line 1463 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Standalone<CommitTransactionRef>> __when_expr_4 = provisional;
															#line 13380 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when2(__when_expr_4.get(), loopDepth); };
		static_cast<RecoverFromActor*>(this)->actor_wait_state = 4;
															#line 1458 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RecoverFromActor, 3, std::vector<Standalone<CommitTransactionRef>> >*>(static_cast<RecoverFromActor*>(this)));
															#line 1463 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RecoverFromActor, 4, Standalone<CommitTransactionRef> >*>(static_cast<RecoverFromActor*>(this)));
															#line 13387 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
															#line 1497 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		provisional.cancel();
															#line 13409 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(std::vector<Standalone<CommitTransactionRef>> const& confChanges,int loopDepth) 
	{
															#line 1459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		initialConfChanges->insert(initialConfChanges->end(), confChanges.begin(), confChanges.end());
															#line 1460 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		provisional.cancel();
															#line 13420 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(std::vector<Standalone<CommitTransactionRef>> && confChanges,int loopDepth) 
	{
															#line 1459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		initialConfChanges->insert(initialConfChanges->end(), confChanges.begin(), confChanges.end());
															#line 1460 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		provisional.cancel();
															#line 13431 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont4loopBody1when2(Standalone<CommitTransactionRef> const& _req,int loopDepth) 
	{
															#line 1464 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req = _req;
															#line 1465 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		CODE_PROBE(true, "Emergency transaction processing during recovery");
															#line 1466 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("EmergencyTransaction", self->dbgid).log();
															#line 1467 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for(auto m = req.mutations.begin();m != req.mutations.end();++m) {
															#line 1468 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("EmergencyTransactionMutation", self->dbgid) .detail("MType", m->type) .detail("P1", m->param1) .detail("P2", m->param2);
															#line 13448 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1473 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		DatabaseConfiguration oldConf = self->configuration;
															#line 1474 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->configuration = self->originalConfiguration;
															#line 1475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& m : req.mutations ) {
															#line 1476 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->configuration.applyMutation(m);
															#line 13458 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1478 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		initialConfChanges->clear();
															#line 1479 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->originalConfiguration.isValid() && self->configuration.usableRegions != self->originalConfiguration.usableRegions)
															#line 13464 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1481 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(SevWarnAlways, "CannotChangeUsableRegions", self->dbgid).log();
															#line 1482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->configuration = self->originalConfiguration;
															#line 13470 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 1484 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			initialConfChanges->push_back(req);
															#line 13476 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1486 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->forceRecovery)
															#line 13480 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1487 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			updateConfigForForcedRecovery(self, initialConfChanges);
															#line 13484 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1490 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->configuration != oldConf)
															#line 13488 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1491 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->dcId_locality = originalLocalityMap;
															#line 1492 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			recruitments = recruitEverything(self, seedServers, oldLogSystem);
															#line 13494 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when2(Standalone<CommitTransactionRef> && _req,int loopDepth) 
	{
															#line 1464 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		req = _req;
															#line 1465 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		CODE_PROBE(true, "Emergency transaction processing during recovery");
															#line 1466 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("EmergencyTransaction", self->dbgid).log();
															#line 1467 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for(auto m = req.mutations.begin();m != req.mutations.end();++m) {
															#line 1468 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent("EmergencyTransactionMutation", self->dbgid) .detail("MType", m->type) .detail("P1", m->param1) .detail("P2", m->param2);
															#line 13512 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1473 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		DatabaseConfiguration oldConf = self->configuration;
															#line 1474 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->configuration = self->originalConfiguration;
															#line 1475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& m : req.mutations ) {
															#line 1476 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->configuration.applyMutation(m);
															#line 13522 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1478 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		initialConfChanges->clear();
															#line 1479 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->originalConfiguration.isValid() && self->configuration.usableRegions != self->originalConfiguration.usableRegions)
															#line 13528 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1481 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(SevWarnAlways, "CannotChangeUsableRegions", self->dbgid).log();
															#line 1482 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->configuration = self->originalConfiguration;
															#line 13534 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 1484 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			initialConfChanges->push_back(req);
															#line 13540 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1486 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->forceRecovery)
															#line 13544 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1487 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			updateConfigForForcedRecovery(self, initialConfChanges);
															#line 13548 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1490 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->configuration != oldConf)
															#line 13552 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1491 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->dcId_locality = originalLocalityMap;
															#line 1492 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			recruitments = recruitEverything(self, seedServers, oldLogSystem);
															#line 13558 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RecoverFromActor*>(this)->actor_wait_state > 0) static_cast<RecoverFromActor*>(this)->actor_wait_state = 0;
		static_cast<RecoverFromActor*>(this)->ActorCallback< RecoverFromActor, 3, std::vector<Standalone<CommitTransactionRef>> >::remove();
		static_cast<RecoverFromActor*>(this)->ActorCallback< RecoverFromActor, 4, Standalone<CommitTransactionRef> >::remove();

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 3, std::vector<Standalone<CommitTransactionRef>> >*,std::vector<Standalone<CommitTransactionRef>> const& value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 3, std::vector<Standalone<CommitTransactionRef>> >*,std::vector<Standalone<CommitTransactionRef>> && value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RecoverFromActor, 3, std::vector<Standalone<CommitTransactionRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 4, Standalone<CommitTransactionRef> >*,Standalone<CommitTransactionRef> const& value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RecoverFromActor, 4, Standalone<CommitTransactionRef> >*,Standalone<CommitTransactionRef> && value) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RecoverFromActor, 4, Standalone<CommitTransactionRef> >*,Error err) 
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ILogSystem> oldLogSystem;
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<StorageServerInterface>* seedServers;
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<Standalone<CommitTransactionRef>>* initialConfChanges;
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Version> poppedTxsVersion;
															#line 1449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::map<Optional<Value>, int8_t> originalLocalityMap;
															#line 1450 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<std::vector<Standalone<CommitTransactionRef>>> recruitments;
															#line 1452 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	double provisionalDelay;
															#line 1454 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Standalone<CommitTransactionRef>> provisional;
															#line 1464 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Standalone<CommitTransactionRef> req;
															#line 13705 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via recoverFrom()
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class RecoverFromActor final : public Actor<Void>, public ActorCallback< RecoverFromActor, 0, Void >, public ActorCallback< RecoverFromActor, 1, Version >, public ActorCallback< RecoverFromActor, 2, Void >, public ActorCallback< RecoverFromActor, 3, std::vector<Standalone<CommitTransactionRef>> >, public ActorCallback< RecoverFromActor, 4, Standalone<CommitTransactionRef> >, public FastAllocated<RecoverFromActor>, public RecoverFromActorState<RecoverFromActor> {
															#line 13710 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<RecoverFromActor>::operator new;
	using FastAllocated<RecoverFromActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5501223971297863680UL, 14234456903926090240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecoverFromActor, 0, Void >;
friend struct ActorCallback< RecoverFromActor, 1, Version >;
friend struct ActorCallback< RecoverFromActor, 2, Void >;
friend struct ActorCallback< RecoverFromActor, 3, std::vector<Standalone<CommitTransactionRef>> >;
friend struct ActorCallback< RecoverFromActor, 4, Standalone<CommitTransactionRef> >;
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	RecoverFromActor(Reference<ClusterRecoveryData> const& self,Reference<ILogSystem> const& oldLogSystem,std::vector<StorageServerInterface>* const& seedServers,std::vector<Standalone<CommitTransactionRef>>* const& initialConfChanges,Future<Version> const& poppedTxsVersion) 
															#line 13731 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   RecoverFromActorState<RecoverFromActor>(self, oldLogSystem, seedServers, initialConfChanges, poppedTxsVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recoverFrom", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11048513393176218368UL, 5213727738079110912UL);
		ActorExecutionContextHelper __helper(static_cast<RecoverFromActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recoverFrom");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recoverFrom", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecoverFromActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RecoverFromActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RecoverFromActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RecoverFromActor, 3, std::vector<Standalone<CommitTransactionRef>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> recoverFrom( Reference<ClusterRecoveryData> const& self, Reference<ILogSystem> const& oldLogSystem, std::vector<StorageServerInterface>* const& seedServers, std::vector<Standalone<CommitTransactionRef>>* const& initialConfChanges, Future<Version> const& poppedTxsVersion ) {
															#line 1417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new RecoverFromActor(self, oldLogSystem, seedServers, initialConfChanges, poppedTxsVersion));
															#line 13767 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 1502 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 13772 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via clusterRecoveryCore()
															#line 1503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class ClusterRecoveryCoreActor>
															#line 1503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ClusterRecoveryCoreActorState {
															#line 13779 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 1503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterRecoveryCoreActorState(Reference<ClusterRecoveryData> const& self) 
															#line 1503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 1503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 1504 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   recoveryInterval("ClusterRecovery"),
															#line 1505 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   recoverStartTime(now())
															#line 13790 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("clusterRecoveryCore", reinterpret_cast<unsigned long>(this));

	}
	~ClusterRecoveryCoreActorState() 
	{
		fdb_probe_actor_destroy("clusterRecoveryCore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1507 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->addActor.send(waitFailureServer(self->masterInterface.waitFailure.getFuture()));
															#line 1509 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(recoveryInterval.begin(), self->dbgid).log();
															#line 1511 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->recoveryState = RecoveryState::READING_CSTATE;
															#line 1512 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::reading_coordinated_state) .detail("Status", RecoveryStatus::names[RecoveryStatus::reading_coordinated_state]) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1517 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->cstate.read();
															#line 1517 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13815 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 1;
															#line 1517 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 0, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 13820 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterRecoveryCoreActorState();
		static_cast<ClusterRecoveryCoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1521 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!self->cstate.myDBState.tLogs.empty() && self->controllerData->encryptionAtRestMode.canBeSet())
															#line 13843 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1522 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->encryptionAtRestMode.send(self->cstate.myDBState.encryptionAtRestMode);
															#line 13847 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1525 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->cstate.prevDBState.lowestCompatibleProtocolVersion > currentProtocolVersion())
															#line 13851 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1526 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(SevWarnAlways, "IncompatibleProtocolVersion", self->dbgid).log();
															#line 1527 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(internal_error(), loopDepth);
															#line 13857 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1530 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->recoveryState = RecoveryState::LOCKING_CSTATE;
															#line 1531 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::locking_coordinated_state) .detail("Status", RecoveryStatus::names[RecoveryStatus::locking_coordinated_state]) .detail("TLogs", self->cstate.prevDBState.tLogs.size()) .detail("ActiveGenerations", self->cstate.myDBState.oldTLogData.size() + 1) .detail("MyRecoveryCount", self->cstate.prevDBState.recoveryCount + 2) .detail("ForceRecovery", self->forceRecovery) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1543 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_GENERATION_EVENT_NAME).c_str(), self->dbgid) .detail("ActiveGenerations", self->cstate.myDBState.oldTLogData.size() + 1) .trackLatest(self->clusterRecoveryGenerationsEventHolder->trackingKey);
															#line 1548 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->cstate.myDBState.oldTLogData.size() > CLIENT_KNOBS->MAX_GENERATIONS_OVERRIDE)
															#line 13867 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1549 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->cstate.myDBState.oldTLogData.size() >= CLIENT_KNOBS->MAX_GENERATIONS)
															#line 13871 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1550 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent(SevError, "RecoveryStoppedTooManyOldGenerations") .detail("OldGenerations", self->cstate.myDBState.oldTLogData.size()) .detail("Reason", "Recovery stopped because too many recoveries have happened since the last time the cluster " "was fully_recovered. Set --knob-max-generations-override on your server processes to a value " "larger than OldGenerations to resume recovery once the underlying problem has been fixed.");
															#line 1556 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Void> __when_expr_1 = Future<Void>(Never());
															#line 1556 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13879 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 2;
															#line 1556 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 1, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 13884 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1557 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (self->cstate.myDBState.oldTLogData.size() > CLIENT_KNOBS->RECOVERY_DELAY_START_GENERATION)
															#line 13891 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 1558 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent(SevError, "RecoveryDelayedTooManyOldGenerations") .detail("OldGenerations", self->cstate.myDBState.oldTLogData.size()) .detail("Reason", "Recovery is delayed because too many recoveries have happened since the last time the cluster " "was fully_recovered. Set --knob-max-generations-override on your server processes to a value " "larger than OldGenerations to resume recovery once the underlying problem has been fixed.");
															#line 1564 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					StrictFuture<Void> __when_expr_2 = delay(CLIENT_KNOBS->RECOVERY_DELAY_SECONDS_PER_GENERATION * (self->cstate.myDBState.oldTLogData.size() - CLIENT_KNOBS->RECOVERY_DELAY_START_GENERATION));
															#line 1564 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13899 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
					static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 3;
															#line 1564 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 2, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 13904 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont7(loopDepth);
				}
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1521 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!self->cstate.myDBState.tLogs.empty() && self->controllerData->encryptionAtRestMode.canBeSet())
															#line 13924 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1522 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->controllerData->encryptionAtRestMode.send(self->cstate.myDBState.encryptionAtRestMode);
															#line 13928 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1525 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->cstate.prevDBState.lowestCompatibleProtocolVersion > currentProtocolVersion())
															#line 13932 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1526 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(SevWarnAlways, "IncompatibleProtocolVersion", self->dbgid).log();
															#line 1527 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(internal_error(), loopDepth);
															#line 13938 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1530 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->recoveryState = RecoveryState::LOCKING_CSTATE;
															#line 1531 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::locking_coordinated_state) .detail("Status", RecoveryStatus::names[RecoveryStatus::locking_coordinated_state]) .detail("TLogs", self->cstate.prevDBState.tLogs.size()) .detail("ActiveGenerations", self->cstate.myDBState.oldTLogData.size() + 1) .detail("MyRecoveryCount", self->cstate.prevDBState.recoveryCount + 2) .detail("ForceRecovery", self->forceRecovery) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1543 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_GENERATION_EVENT_NAME).c_str(), self->dbgid) .detail("ActiveGenerations", self->cstate.myDBState.oldTLogData.size() + 1) .trackLatest(self->clusterRecoveryGenerationsEventHolder->trackingKey);
															#line 1548 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->cstate.myDBState.oldTLogData.size() > CLIENT_KNOBS->MAX_GENERATIONS_OVERRIDE)
															#line 13948 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1549 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->cstate.myDBState.oldTLogData.size() >= CLIENT_KNOBS->MAX_GENERATIONS)
															#line 13952 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1550 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent(SevError, "RecoveryStoppedTooManyOldGenerations") .detail("OldGenerations", self->cstate.myDBState.oldTLogData.size()) .detail("Reason", "Recovery stopped because too many recoveries have happened since the last time the cluster " "was fully_recovered. Set --knob-max-generations-override on your server processes to a value " "larger than OldGenerations to resume recovery once the underlying problem has been fixed.");
															#line 1556 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Void> __when_expr_1 = Future<Void>(Never());
															#line 1556 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13960 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 2;
															#line 1556 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 1, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 13965 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1557 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (self->cstate.myDBState.oldTLogData.size() > CLIENT_KNOBS->RECOVERY_DELAY_START_GENERATION)
															#line 13972 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				{
															#line 1558 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					TraceEvent(SevError, "RecoveryDelayedTooManyOldGenerations") .detail("OldGenerations", self->cstate.myDBState.oldTLogData.size()) .detail("Reason", "Recovery is delayed because too many recoveries have happened since the last time the cluster " "was fully_recovered. Set --knob-max-generations-override on your server processes to a value " "larger than OldGenerations to resume recovery once the underlying problem has been fixed.");
															#line 1564 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					StrictFuture<Void> __when_expr_2 = delay(CLIENT_KNOBS->RECOVERY_DELAY_SECONDS_PER_GENERATION * (self->cstate.myDBState.oldTLogData.size() - CLIENT_KNOBS->RECOVERY_DELAY_START_GENERATION));
															#line 1564 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13980 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
					static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 3;
															#line 1564 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 2, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 13985 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont7(loopDepth);
				}
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1572 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		oldLogSystems = Reference<AsyncVar<Reference<ILogSystem>>>(new AsyncVar<Reference<ILogSystem>>);
															#line 1573 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		recoverAndEndEpoch = ILogSystem::recoverAndEndEpoch(oldLogSystems, self->dbgid, self->cstate.prevDBState, self->clusterController.tlogRejoin.getFuture(), self->controllerData->db.serverInfo->get().myLocality, std::addressof(self->forceRecovery));
															#line 1581 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		DBCoreState newState = self->cstate.myDBState;
															#line 1582 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		newState.recoveryCount++;
															#line 1583 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->cstate.prevDBState.newestProtocolVersion.isInvalid() || self->cstate.prevDBState.newestProtocolVersion < currentProtocolVersion())
															#line 14088 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1585 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			ASSERT(self->cstate.myDBState.lowestCompatibleProtocolVersion.isInvalid() || !self->cstate.myDBState.newestProtocolVersion.isInvalid());
															#line 1587 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			newState.newestProtocolVersion = currentProtocolVersion();
															#line 1588 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			newState.lowestCompatibleProtocolVersion = minCompatibleProtocolVersion;
															#line 14096 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1590 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->cstate.write(newState) || recoverAndEndEpoch;
															#line 1590 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 4;
															#line 1590 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 3, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 14107 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 1567 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (g_network->isSimulated() && self->cstate.myDBState.oldTLogData.size() > CLIENT_KNOBS->MAX_GENERATIONS_SIM)
															#line 14116 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1568 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			disableConnectionFailures("TooManyGenerations");
															#line 14120 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 1592 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("ProtocolVersionCompatibilityChecked", self->dbgid) .detail("NewestProtocolVersion", self->cstate.myDBState.newestProtocolVersion) .detail("LowestCompatibleProtocolVersion", self->cstate.myDBState.lowestCompatibleProtocolVersion) .trackLatest(self->swVersionCheckedEventHolder->trackingKey);
															#line 1597 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->recoveryState = RecoveryState::RECRUITING;
															#line 1599 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		seedServers = std::vector<StorageServerInterface>();
															#line 1600 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		initialConfChanges = std::vector<Standalone<CommitTransactionRef>>();
															#line 1601 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		logChanges = Future<Void>();
															#line 1602 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		minRecoveryDuration = Future<Void>();
															#line 1603 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		poppedTxsVersion = Future<Version>();
															#line 1605 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		;
															#line 14324 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont11loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 1592 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent("ProtocolVersionCompatibilityChecked", self->dbgid) .detail("NewestProtocolVersion", self->cstate.myDBState.newestProtocolVersion) .detail("LowestCompatibleProtocolVersion", self->cstate.myDBState.lowestCompatibleProtocolVersion) .trackLatest(self->swVersionCheckedEventHolder->trackingKey);
															#line 1597 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->recoveryState = RecoveryState::RECRUITING;
															#line 1599 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		seedServers = std::vector<StorageServerInterface>();
															#line 1600 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		initialConfChanges = std::vector<Standalone<CommitTransactionRef>>();
															#line 1601 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		logChanges = Future<Void>();
															#line 1602 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		minRecoveryDuration = Future<Void>();
															#line 1603 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		poppedTxsVersion = Future<Version>();
															#line 1605 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		;
															#line 14347 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = a_body1cont11loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11cont1(int loopDepth) 
	{
															#line 1635 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->neverCreated)
															#line 14431 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1636 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			recoverStartTime = now();
															#line 14435 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1639 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		recoverAndEndEpoch.cancel();
															#line 1641 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT_LE(self->commitProxies.size(), self->configuration.getDesiredCommitProxies());
															#line 1642 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT_GE(self->commitProxies.size(), 1);
															#line 1643 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT_LE(self->grvProxies.size(), self->configuration.getDesiredGrvProxies());
															#line 1644 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT_GE(self->grvProxies.size(), 1);
															#line 1645 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT_LE(self->resolvers.size(), self->configuration.getDesiredResolvers());
															#line 1646 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT_GE(self->resolvers.size(), 1);
															#line 1648 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->recoveryState = RecoveryState::RECOVERY_TRANSACTION;
															#line 1649 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::recovery_transaction) .detail("Status", RecoveryStatus::names[RecoveryStatus::recovery_transaction]) .detail("PrimaryLocality", self->primaryLocality) .detail("DcId", self->masterInterface.locality.dcId()) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1657 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		debugResult = debug_checkMinRestoredVersion(UID(), self->lastEpochEnd, "DBRecovery", SevWarn);
															#line 1659 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		CommitTransactionRequest recoveryCommitRequest;
															#line 1660 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		recoveryCommitRequest.flags = recoveryCommitRequest.flags | CommitTransactionRequest::FLAG_IS_LOCK_AWARE;
															#line 1661 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		CommitTransactionRef& tr = recoveryCommitRequest.transaction;
															#line 1662 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		int mmApplied = 0;
															#line 1663 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->lastEpochEnd != 0)
															#line 14467 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1664 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			Optional<Value> snapRecoveryFlag = self->txnStateStore->readValue(writeRecoveryKey).get();
															#line 1665 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_SNAPSHOT_CHECK_EVENT_NAME).c_str()) .detail("SnapRecoveryFlag", snapRecoveryFlag.present() ? snapRecoveryFlag.get().toString() : "N/A") .detail("LastEpochEnd", self->lastEpochEnd);
															#line 1668 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (snapRecoveryFlag.present())
															#line 14475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1669 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				CODE_PROBE(true, "Recovering from snapshot, writing to snapShotEndVersionKey");
															#line 1670 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				BinaryWriter bw(Unversioned());
															#line 1671 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				tr.set(recoveryCommitRequest.arena, snapshotEndVersionKey, (bw << self->lastEpochEnd).toValue());
															#line 1674 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				TraceEvent( getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_PAUSE_AGENT_BACKUP_EVENT_NAME).c_str()) .log();
															#line 1677 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				Key backupPauseKey = FileBackupAgent::getPauseKey();
															#line 1678 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				tr.set(recoveryCommitRequest.arena, backupPauseKey, StringRef());
															#line 1680 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				tr.clear(recoveryCommitRequest.arena, singleKeyRange(writeRecoveryKey));
															#line 14491 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1682 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->forceRecovery)
															#line 14495 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1683 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				BinaryWriter bw(Unversioned());
															#line 1684 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				tr.set(recoveryCommitRequest.arena, killStorageKey, (bw << self->safeLocality).toValue());
															#line 14501 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
															#line 1694 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			BinaryWriter bw(Unversioned());
															#line 1695 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tr.set(recoveryCommitRequest.arena, lastEpochEndKey, (bw << self->lastEpochEnd).toValue());
															#line 1697 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self->forceRecovery)
															#line 14509 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1698 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				tr.set(recoveryCommitRequest.arena, rebootWhenDurableKey, StringRef());
															#line 1699 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				tr.set(recoveryCommitRequest.arena, moveKeysLockOwnerKey, BinaryWriter::toValue(deterministicRandom()->randomUniqueID(), Unversioned()));
															#line 14515 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
		else
		{
															#line 1706 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			seedShardServers(recoveryCommitRequest.arena, tr, seedServers);
															#line 14522 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1711 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& itr : initialConfChanges ) {
															#line 1712 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tr.mutations.append_deep(recoveryCommitRequest.arena, itr.mutations.begin(), itr.mutations.size());
															#line 1713 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tr.write_conflict_ranges.append_deep( recoveryCommitRequest.arena, itr.write_conflict_ranges.begin(), itr.write_conflict_ranges.size());
															#line 14530 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1717 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr.set( recoveryCommitRequest.arena, primaryLocalityKey, BinaryWriter::toValue(self->primaryLocality, Unversioned()));
															#line 1719 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr.set(recoveryCommitRequest.arena, backupVersionKey, backupVersionValue);
															#line 1720 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Optional<Value> txnStateStoreCoords = self->txnStateStore->readValue(coordinatorsKey).get();
															#line 1721 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (txnStateStoreCoords.present() && txnStateStoreCoords.get() != self->coordinators.ccr->getConnectionString().toString())
															#line 14540 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1723 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tr.set(recoveryCommitRequest.arena, previousCoordinatorsKey, txnStateStoreCoords.get());
															#line 14544 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1725 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr.set(recoveryCommitRequest.arena, coordinatorsKey, self->coordinators.ccr->getConnectionString().toString());
															#line 1726 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr.set(recoveryCommitRequest.arena, logsKey, self->logSystem->getLogsValue());
															#line 1727 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr.set(recoveryCommitRequest.arena, primaryDatacenterKey, self->controllerData->clusterControllerDcId.present() ? self->controllerData->clusterControllerDcId.get() : StringRef());
															#line 1732 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr.clear(recoveryCommitRequest.arena, tLogDatacentersKeys);
															#line 1733 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for( auto& dc : self->primaryDcId ) {
															#line 1734 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			tr.set(recoveryCommitRequest.arena, tLogDatacentersKeyFor(dc), StringRef());
															#line 14558 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1736 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->configuration.usableRegions > 1)
															#line 14562 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1737 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			for( auto& dc : self->remoteDcIds ) {
															#line 1738 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				tr.set(recoveryCommitRequest.arena, tLogDatacentersKeyFor(dc), StringRef());
															#line 14568 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1742 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		applyMetadataMutations(SpanContext(), self->dbgid, recoveryCommitRequest.arena, tr.mutations.slice(mmApplied, tr.mutations.size()), self->txnStateStore);
															#line 1747 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		mmApplied = tr.mutations.size();
															#line 1749 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		tr.read_snapshot = self->recoveryTransactionVersion;
															#line 1752 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_COMMIT_EVENT_NAME).c_str(), self->dbgid) .log();
															#line 1754 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		recoveryCommit = self->commitProxies[0].commit.tryGetReply(recoveryCommitRequest);
															#line 1755 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(self->logSystem->onError());
															#line 1756 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(waitResolverFailure(self->resolvers));
															#line 1757 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(waitCommitProxyFailure(self->commitProxies));
															#line 1758 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(waitGrvProxyFailure(self->grvProxies));
															#line 1759 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(reportErrors(updateRegistration(self, self->logSystem), "UpdateRegistration", self->dbgid));
															#line 1760 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->registrationTrigger.trigger();
															#line 1762 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_8 = discardCommit(self->txnStateStore, self->txnStateLogAdapter);
															#line 1762 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14597 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_8.get(), loopDepth); };
		static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 6;
															#line 1762 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 8, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 14602 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont11loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1(int loopDepth) 
	{
															#line 1606 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Reference<ILogSystem> oldLogSystem = oldLogSystems->get();
															#line 1607 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (oldLogSystem)
															#line 14620 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1608 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			logChanges = triggerUpdates(self, oldLogSystem);
															#line 1609 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (!minRecoveryDuration.isValid())
															#line 14626 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1610 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				minRecoveryDuration = delay(SERVER_KNOBS->ENFORCED_MIN_RECOVERY_DURATION);
															#line 1611 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				poppedTxsVersion = oldLogSystem->getTxsPoppedVersion();
															#line 14632 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			}
		}
															#line 1615 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		reg = oldLogSystem ? updateRegistration(self, oldLogSystem) : Never();
															#line 1616 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->registrationTrigger.trigger();
															#line 1619 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_4 = oldLogSystem ? recoverFrom(self, oldLogSystem, &seedServers, &initialConfChanges, poppedTxsVersion) : Never();
															#line 1618 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14643 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when1(__when_expr_4.get(), loopDepth); };
															#line 1625 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_5 = oldLogSystems->onChange();
															#line 14647 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when2(__when_expr_5.get(), loopDepth); };
															#line 1626 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_6 = reg;
															#line 14651 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when3(__when_expr_6.get(), loopDepth); };
															#line 1629 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_7 = recoverAndEndEpoch;
															#line 14655 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when4(__when_expr_7.get(), loopDepth); };
		static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 5;
															#line 1619 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 4, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 1625 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 5, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 1626 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 6, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 1629 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 7, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 14666 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11break1(int loopDepth) 
	{
		try {
			return a_body1cont11cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont11loopHead1(0);

		return loopDepth;
	}
	int a_body1cont11loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1622 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		reg.cancel();
															#line 14694 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		return a_body1cont11break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont11loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1622 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		reg.cancel();
															#line 14703 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		return a_body1cont11break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont11loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 1627 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 14724 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont11loopBody1when3(Void && _,int loopDepth) 
	{
															#line 1627 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 14732 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont11loopBody1when4(Void const& _,int loopDepth) 
	{
															#line 1630 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 14740 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont11loopBody1when4(Void && _,int loopDepth) 
	{
															#line 1630 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 14748 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 4, Void >::remove();
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 5, Void >::remove();
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 6, Void >::remove();
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont11cont2(Void const& _,int loopDepth) 
	{
															#line 1767 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_9 = (success(recoveryCommit) && sendInitialCommitToResolvers(self));
															#line 1767 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14995 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 7;
															#line 1767 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 9, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 15000 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont2(Void && _,int loopDepth) 
	{
															#line 1767 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_9 = (success(recoveryCommit) && sendInitialCommitToResolvers(self));
															#line 1767 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15011 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 7;
															#line 1767 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 9, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 15016 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont11cont14(Void const& _,int loopDepth) 
	{
															#line 1768 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (recoveryCommit.isReady() && recoveryCommit.get().isError())
															#line 15100 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1769 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "Cluster recovery failed because of the initial commit failed");
															#line 1770 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(cluster_recovery_failed(), loopDepth);
															#line 15106 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1773 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(self->recoveryTransactionVersion != 0);
															#line 1775 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->recoveryState = RecoveryState::WRITING_CSTATE;
															#line 1776 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::writing_coordinated_state) .detail("Status", RecoveryStatus::names[RecoveryStatus::writing_coordinated_state]) .detail("TLogList", self->logSystem->describe()) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1793 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(trackTlogRecovery(self, oldLogSystems, minRecoveryDuration));
															#line 1794 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		debug_advanceMaxCommittedVersion(UID(), self->recoveryTransactionVersion);
															#line 1795 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_10 = self->cstateUpdated.getFuture();
															#line 1795 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15122 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont14when1(__when_expr_10.get(), loopDepth); };
		static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 8;
															#line 1795 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 10, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 15127 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont14(Void && _,int loopDepth) 
	{
															#line 1768 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (recoveryCommit.isReady() && recoveryCommit.get().isError())
															#line 15136 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1769 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			CODE_PROBE(true, "Cluster recovery failed because of the initial commit failed");
															#line 1770 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			return a_body1Catch1(cluster_recovery_failed(), loopDepth);
															#line 15142 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1773 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		ASSERT(self->recoveryTransactionVersion != 0);
															#line 1775 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->recoveryState = RecoveryState::WRITING_CSTATE;
															#line 1776 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::writing_coordinated_state) .detail("Status", RecoveryStatus::names[RecoveryStatus::writing_coordinated_state]) .detail("TLogList", self->logSystem->describe()) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1793 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(trackTlogRecovery(self, oldLogSystems, minRecoveryDuration));
															#line 1794 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		debug_advanceMaxCommittedVersion(UID(), self->recoveryTransactionVersion);
															#line 1795 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_10 = self->cstateUpdated.getFuture();
															#line 1795 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15158 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont14when1(__when_expr_10.get(), loopDepth); };
		static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 8;
															#line 1795 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 10, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 15163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont11cont14cont1(Void const& _,int loopDepth) 
	{
															#line 1796 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		debug_advanceMinCommittedVersion(UID(), self->recoveryTransactionVersion);
															#line 1798 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (debugResult)
															#line 15249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1799 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(self->forceRecovery ? SevWarn : SevError, "DBRecoveryDurabilityError").log();
															#line 15253 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1802 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_COMMIT_EVENT_NAME).c_str(), self->dbgid) .detail("TLogs", self->logSystem->describe()) .detail("RecoveryCount", self->cstate.myDBState.recoveryCount) .detail("RecoveryTransactionVersion", self->recoveryTransactionVersion);
															#line 1807 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(recoveryInterval.end(), self->dbgid) .detail("RecoveryTransactionVersion", self->recoveryTransactionVersion);
															#line 1810 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->recoveryState = RecoveryState::ACCEPTING_COMMITS;
															#line 1811 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		double recoveryDuration = now() - recoverStartTime;
															#line 1813 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent((recoveryDuration > 4 && !g_network->isSimulated()) ? SevWarnAlways : SevInfo, getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_DURATION_EVENT_NAME).c_str(), self->dbgid) .detail("RecoveryDuration", recoveryDuration) .trackLatest(self->clusterRecoveryDurationEventHolder->trackingKey);
															#line 1819 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::accepting_commits) .detail("Status", RecoveryStatus::names[RecoveryStatus::accepting_commits]) .detail("StoreType", self->configuration.storageServerStoreType) .detail("RecoveryDuration", recoveryDuration) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1826 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_AVAILABLE_EVENT_NAME).c_str(), self->dbgid) .detail("NumOfOldGensOfLogs", self->cstate.myDBState.oldTLogData.size()) .detail("AvailableAtVersion", self->recoveryTransactionVersion) .trackLatest(self->clusterRecoveryAvailableEventHolder->trackingKey);
															#line 1832 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(changeCoordinators(self));
															#line 1833 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Database cx = openDBOnServer(self->dbInfo, TaskPriority::DefaultEndpoint, LockAware::True);
															#line 1834 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(configurationMonitor(self, cx));
															#line 1835 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->configuration.backupWorkerEnabled)
															#line 15277 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1836 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->addActor.send(recruitBackupWorkers(self, cx));
															#line 15281 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 1838 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->logSystem->setOldestBackupEpoch(self->cstate.myDBState.recoveryCount);
															#line 15287 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1841 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_11 = Future<Void>(Never());
															#line 1841 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15293 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont11cont14cont1when1(__when_expr_11.get(), loopDepth); };
		static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 9;
															#line 1841 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 11, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 15298 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont14cont1(Void && _,int loopDepth) 
	{
															#line 1796 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		debug_advanceMinCommittedVersion(UID(), self->recoveryTransactionVersion);
															#line 1798 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (debugResult)
															#line 15309 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1799 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			TraceEvent(self->forceRecovery ? SevWarn : SevError, "DBRecoveryDurabilityError").log();
															#line 15313 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1802 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_COMMIT_EVENT_NAME).c_str(), self->dbgid) .detail("TLogs", self->logSystem->describe()) .detail("RecoveryCount", self->cstate.myDBState.recoveryCount) .detail("RecoveryTransactionVersion", self->recoveryTransactionVersion);
															#line 1807 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(recoveryInterval.end(), self->dbgid) .detail("RecoveryTransactionVersion", self->recoveryTransactionVersion);
															#line 1810 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->recoveryState = RecoveryState::ACCEPTING_COMMITS;
															#line 1811 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		double recoveryDuration = now() - recoverStartTime;
															#line 1813 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent((recoveryDuration > 4 && !g_network->isSimulated()) ? SevWarnAlways : SevInfo, getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_DURATION_EVENT_NAME).c_str(), self->dbgid) .detail("RecoveryDuration", recoveryDuration) .trackLatest(self->clusterRecoveryDurationEventHolder->trackingKey);
															#line 1819 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME).c_str(), self->dbgid) .detail("StatusCode", RecoveryStatus::accepting_commits) .detail("Status", RecoveryStatus::names[RecoveryStatus::accepting_commits]) .detail("StoreType", self->configuration.storageServerStoreType) .detail("RecoveryDuration", recoveryDuration) .trackLatest(self->clusterRecoveryStateEventHolder->trackingKey);
															#line 1826 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		TraceEvent(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_AVAILABLE_EVENT_NAME).c_str(), self->dbgid) .detail("NumOfOldGensOfLogs", self->cstate.myDBState.oldTLogData.size()) .detail("AvailableAtVersion", self->recoveryTransactionVersion) .trackLatest(self->clusterRecoveryAvailableEventHolder->trackingKey);
															#line 1832 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(changeCoordinators(self));
															#line 1833 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		Database cx = openDBOnServer(self->dbInfo, TaskPriority::DefaultEndpoint, LockAware::True);
															#line 1834 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		self->addActor.send(configurationMonitor(self, cx));
															#line 1835 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (self->configuration.backupWorkerEnabled)
															#line 15337 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		{
															#line 1836 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->addActor.send(recruitBackupWorkers(self, cx));
															#line 15341 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		else
		{
															#line 1838 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->logSystem->setOldestBackupEpoch(self->cstate.myDBState.recoveryCount);
															#line 15347 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
															#line 1841 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_11 = Future<Void>(Never());
															#line 1841 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15353 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont11cont14cont1when1(__when_expr_11.get(), loopDepth); };
		static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 9;
															#line 1841 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< ClusterRecoveryCoreActor, 11, Void >*>(static_cast<ClusterRecoveryCoreActor*>(this)));
															#line 15358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont14when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont14cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont14when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont14cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont14when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont14when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont11cont14cont3(Void const& _,int loopDepth) 
	{
															#line 1842 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 15442 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont11cont14cont3(Void && _,int loopDepth) 
	{
															#line 1842 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 15450 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont11cont14cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont14cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont14cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont14cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state > 0) static_cast<ClusterRecoveryCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterRecoveryCoreActor*>(this)->ActorCallback< ClusterRecoveryCoreActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont14cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< ClusterRecoveryCoreActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont14cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< ClusterRecoveryCoreActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 1503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 1504 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	TraceInterval recoveryInterval;
															#line 1505 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	double recoverStartTime;
															#line 1572 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<AsyncVar<Reference<ILogSystem>>> oldLogSystems;
															#line 1573 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> recoverAndEndEpoch;
															#line 1599 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<StorageServerInterface> seedServers;
															#line 1600 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	std::vector<Standalone<CommitTransactionRef>> initialConfChanges;
															#line 1601 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> logChanges;
															#line 1602 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> minRecoveryDuration;
															#line 1603 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Version> poppedTxsVersion;
															#line 1615 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<Void> reg;
															#line 1657 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	bool debugResult;
															#line 1754 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Future<ErrorOr<CommitID>> recoveryCommit;
															#line 15555 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via clusterRecoveryCore()
															#line 1503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class ClusterRecoveryCoreActor final : public Actor<Void>, public ActorCallback< ClusterRecoveryCoreActor, 0, Void >, public ActorCallback< ClusterRecoveryCoreActor, 1, Void >, public ActorCallback< ClusterRecoveryCoreActor, 2, Void >, public ActorCallback< ClusterRecoveryCoreActor, 3, Void >, public ActorCallback< ClusterRecoveryCoreActor, 4, Void >, public ActorCallback< ClusterRecoveryCoreActor, 5, Void >, public ActorCallback< ClusterRecoveryCoreActor, 6, Void >, public ActorCallback< ClusterRecoveryCoreActor, 7, Void >, public ActorCallback< ClusterRecoveryCoreActor, 8, Void >, public ActorCallback< ClusterRecoveryCoreActor, 9, Void >, public ActorCallback< ClusterRecoveryCoreActor, 10, Void >, public ActorCallback< ClusterRecoveryCoreActor, 11, Void >, public FastAllocated<ClusterRecoveryCoreActor>, public ClusterRecoveryCoreActorState<ClusterRecoveryCoreActor> {
															#line 15560 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<ClusterRecoveryCoreActor>::operator new;
	using FastAllocated<ClusterRecoveryCoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10593018413220256768UL, 6763770717897214720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterRecoveryCoreActor, 0, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 1, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 2, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 3, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 4, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 5, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 6, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 7, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 8, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 9, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 10, Void >;
friend struct ActorCallback< ClusterRecoveryCoreActor, 11, Void >;
															#line 1503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	ClusterRecoveryCoreActor(Reference<ClusterRecoveryData> const& self) 
															#line 15588 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   ClusterRecoveryCoreActorState<ClusterRecoveryCoreActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6439010016757150976UL, 1216318683808140800UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterRecoveryCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterRecoveryCore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterRecoveryCore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterRecoveryCoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClusterRecoveryCoreActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClusterRecoveryCoreActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ClusterRecoveryCoreActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ClusterRecoveryCoreActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ClusterRecoveryCoreActor, 8, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ClusterRecoveryCoreActor, 9, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ClusterRecoveryCoreActor, 10, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ClusterRecoveryCoreActor, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> clusterRecoveryCore( Reference<ClusterRecoveryData> const& self ) {
															#line 1503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new ClusterRecoveryCoreActor(self));
															#line 15629 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 1844 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

															#line 15634 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
namespace {
// This generated class is to be used only via cleanupRecoveryActorCollection()
															#line 1845 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
template <class CleanupRecoveryActorCollectionActor>
															#line 1845 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class CleanupRecoveryActorCollectionActorState {
															#line 15641 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
															#line 1845 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	CleanupRecoveryActorCollectionActorState(Reference<ClusterRecoveryData> const& self,bool const& exThrown) 
															#line 1845 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
															#line 1845 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		 : self(self),
															#line 1845 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		   exThrown(exThrown)
															#line 15650 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this));

	}
	~CleanupRecoveryActorCollectionActorState() 
	{
		fdb_probe_actor_destroy("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1846 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			if (self.isValid())
															#line 15665 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
			{
															#line 1847 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(0.0);
															#line 1847 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				if (static_cast<CleanupRecoveryActorCollectionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15671 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CleanupRecoveryActorCollectionActor*>(this)->actor_wait_state = 1;
															#line 1847 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CleanupRecoveryActorCollectionActor, 0, Void >*>(static_cast<CleanupRecoveryActorCollectionActor*>(this)));
															#line 15676 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CleanupRecoveryActorCollectionActorState();
		static_cast<CleanupRecoveryActorCollectionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1854 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		if (!static_cast<CleanupRecoveryActorCollectionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanupRecoveryActorCollectionActorState(); static_cast<CleanupRecoveryActorCollectionActor*>(this)->destroy(); return 0; }
															#line 15704 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		new (&static_cast<CleanupRecoveryActorCollectionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CleanupRecoveryActorCollectionActorState();
		static_cast<CleanupRecoveryActorCollectionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1849 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for(;!self->addActor.isEmpty();) {
															#line 1850 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->addActor.getFuture().pop();
															#line 15718 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1849 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
		for(;!self->addActor.isEmpty();) {
															#line 1850 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
			self->addActor.getFuture().pop();
															#line 15730 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CleanupRecoveryActorCollectionActor*>(this)->actor_wait_state > 0) static_cast<CleanupRecoveryActorCollectionActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupRecoveryActorCollectionActor*>(this)->ActorCallback< CleanupRecoveryActorCollectionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupRecoveryActorCollectionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupRecoveryActorCollectionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CleanupRecoveryActorCollectionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupRecoveryActorCollectionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CleanupRecoveryActorCollectionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupRecoveryActorCollectionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1845 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	Reference<ClusterRecoveryData> self;
															#line 1845 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	bool exThrown;
															#line 15815 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
};
// This generated class is to be used only via cleanupRecoveryActorCollection()
															#line 1845 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
class CleanupRecoveryActorCollectionActor final : public Actor<Void>, public ActorCallback< CleanupRecoveryActorCollectionActor, 0, Void >, public FastAllocated<CleanupRecoveryActorCollectionActor>, public CleanupRecoveryActorCollectionActorState<CleanupRecoveryActorCollectionActor> {
															#line 15820 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
public:
	using FastAllocated<CleanupRecoveryActorCollectionActor>::operator new;
	using FastAllocated<CleanupRecoveryActorCollectionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11692498775163306240UL, 10388807138512701184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CleanupRecoveryActorCollectionActor, 0, Void >;
															#line 1845 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	CleanupRecoveryActorCollectionActor(Reference<ClusterRecoveryData> const& self,bool const& exThrown) 
															#line 15837 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   CleanupRecoveryActorCollectionActorState<CleanupRecoveryActorCollectionActor>(self, exThrown),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17904544212101105152UL, 12520490447510957056UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupRecoveryActorCollectionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cleanupRecoveryActorCollection");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cleanupRecoveryActorCollection", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CleanupRecoveryActorCollectionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1845 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
[[nodiscard]] Future<Void> cleanupRecoveryActorCollection( Reference<ClusterRecoveryData> const& self, bool const& exThrown ) {
															#line 1845 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"
	return Future<Void>(new CleanupRecoveryActorCollectionActor(self, exThrown));
															#line 15870 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterRecovery.actor.g.cpp"
}

#line 1856 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/ClusterRecovery.actor.cpp"

bool isNormalClusterRecoveryError(const Error& error) {
	return normalClusterRecoveryErrors().contains(error.code());
}

std::string& getRecoveryEventName(ClusterRecoveryEventType type) {
	ASSERT(type >= ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME &&
	       type < ClusterRecoveryEventType::CLUSTER_RECOVERY_LAST);

	// Cluster recovery state machine used to be driven from master/sequencer process, recovery state
	// tracking is used by test environment and tooling scripts. To ease the process of migration, prefix
	// is controlled by a ServerKnob for now.
	//
	// TODO: ServerKnob should be removed ones all tooling scripts and usage is identified and updated accordingly

	static std::map<ClusterRecoveryEventType, std::string> recoveryEventNameMap;
	if (recoveryEventNameMap.empty()) {
		// initialize the map
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryState" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_COMMIT_TLOG_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryCommittedTLogs" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_DURATION_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryDuration" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_GENERATION_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryGenerations" });
		recoveryEventNameMap.insert(
		    { ClusterRecoveryEventType::CLUSTER_RECOVERY_SS_RECRUITMENT_EVENT_NAME,
		      SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryRecruitingInitialStorageServer" });
		recoveryEventNameMap.insert(
		    { ClusterRecoveryEventType::CLUSTER_RECOVERY_INVALID_CONFIG_EVENT_NAME,
		      SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryInvalidConfiguration" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_RECOVERING_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "Recovering" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_RECOVERED_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveredConfig" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_SNAPSHOT_CHECK_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoverySnapshotCheck" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_SS_RECRUITMENT_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoverySnapshotCheck" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_PAUSE_AGENT_BACKUP_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryPauseBackupAgents" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_COMMIT_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryCommit" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_AVAILABLE_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryAvailable" });
		recoveryEventNameMap.insert({ ClusterRecoveryEventType::CLUSTER_RECOVERY_METRICS_EVENT_NAME,
		                              SERVER_KNOBS->CLUSTER_RECOVERY_EVENT_NAME_PREFIX + "RecoveryMetrics" });
	}

	auto iter = recoveryEventNameMap.find(type);
	ASSERT(iter != recoveryEventNameMap.end());
	return iter->second;
}