#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
/*
 * BulkLoadUtils.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/BulkLoading.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/S3Client.actor.h"
#include "fdbserver/BulkLoadUtil.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/RocksDBCheckpointUtils.actor.h"
#include "fdbserver/StorageMetrics.actor.h"
#include "flow/genericactors.actor.h"
#include "flow/actorcompiler.h" // has to be last include

															#line 34 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
namespace {
// This generated class is to be used only via readBulkFileBytes()
															#line 32 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class ReadBulkFileBytesActor>
															#line 32 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class ReadBulkFileBytesActorState {
															#line 41 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
															#line 32 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	ReadBulkFileBytesActorState(std::string const& path,int64_t const& maxLength,std::shared_ptr<std::string> const& output) 
															#line 32 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 32 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : path(path),
															#line 32 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   maxLength(maxLength),
															#line 32 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   output(output)
															#line 52 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
	{
		fdb_probe_actor_create("readBulkFileBytes", reinterpret_cast<unsigned long>(this));

	}
	~ReadBulkFileBytesActorState() 
	{
		fdb_probe_actor_destroy("readBulkFileBytes", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 34 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				output->clear();
															#line 35 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				chunkSize = SERVER_KNOBS->BULKLOAD_ASYNC_READ_WRITE_BLOCK_SIZE;
															#line 36 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( abspath(path), IAsyncFile::OPEN_NO_AIO | IAsyncFile::OPEN_READONLY | IAsyncFile::OPEN_UNCACHED, 0644);
															#line 36 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 74 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state = 1;
															#line 36 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadBulkFileBytesActor, 0, Reference<IAsyncFile> >*>(static_cast<ReadBulkFileBytesActor*>(this)));
															#line 79 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadBulkFileBytesActorState();
		static_cast<ReadBulkFileBytesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 68 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevWarn, "ReadBulkFileBytesError").error(e).detail("Path", path).detail("MaxLength", maxLength);
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 111 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 38 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = file->size();
															#line 38 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 127 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state = 2;
															#line 38 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadBulkFileBytesActor, 1, int64_t >*>(static_cast<ReadBulkFileBytesActor*>(this)));
															#line 132 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __file,int loopDepth) 
	{
															#line 36 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		file = __file;
															#line 141 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __file,int loopDepth) 
	{
		file = std::move(__file);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state > 0) static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadBulkFileBytesActor*>(this)->ActorCallback< ReadBulkFileBytesActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadBulkFileBytesActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadBulkFileBytesActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadBulkFileBytesActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 39 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (fileSize > maxLength)
															#line 220 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
															#line 40 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevError, "ReadBulkFileBytesTooLarge") .detail("FileSize", fileSize) .detail("MaxLength", maxLength);
															#line 43 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			return a_body1Catch2(file_too_large(), loopDepth);
															#line 226 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		}
															#line 45 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		output->reserve(fileSize);
															#line 48 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		offset = 0;
															#line 49 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		remaining = fileSize;
															#line 50 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		chunk = std::make_shared<std::string>();
															#line 51 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		;
															#line 238 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int64_t const& __fileSize,int loopDepth) 
	{
															#line 38 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		fileSize = __fileSize;
															#line 247 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int64_t && __fileSize,int loopDepth) 
	{
		fileSize = std::move(__fileSize);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state > 0) static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadBulkFileBytesActor*>(this)->ActorCallback< ReadBulkFileBytesActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< ReadBulkFileBytesActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadBulkFileBytesActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadBulkFileBytesActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 66 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<ReadBulkFileBytesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadBulkFileBytesActorState(); static_cast<ReadBulkFileBytesActor*>(this)->destroy(); return 0; }
															#line 326 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		new (&static_cast<ReadBulkFileBytesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadBulkFileBytesActorState();
		static_cast<ReadBulkFileBytesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 51 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!(remaining > 0))
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 52 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		bytesToRead = std::min(chunkSize, remaining);
															#line 53 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		chunk->clear();
															#line 54 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		chunk->resize(bytesToRead);
															#line 55 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<int> __when_expr_2 = uncancellable(holdWhile(chunk, file->read(chunk->data(), bytesToRead, offset)));
															#line 55 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 359 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state = 3;
															#line 55 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadBulkFileBytesActor, 2, int >*>(static_cast<ReadBulkFileBytesActor*>(this)));
															#line 364 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
															#line 56 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (bytesRead != bytesToRead)
															#line 386 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
															#line 57 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevError, "ReadBulkFileBytesError") .detail("BytesRead", bytesRead) .detail("BytesExpected", bytesToRead);
															#line 60 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			return a_body1Catch2(io_error(), std::max(0, loopDepth - 1));
															#line 392 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		}
															#line 62 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		output->append(*chunk);
															#line 63 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		offset += bytesRead;
															#line 64 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		remaining -= bytesRead;
															#line 400 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(int const& __bytesRead,int loopDepth) 
	{
															#line 55 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		bytesRead = __bytesRead;
															#line 409 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(int && __bytesRead,int loopDepth) 
	{
		bytesRead = std::move(__bytesRead);
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state > 0) static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadBulkFileBytesActor*>(this)->ActorCallback< ReadBulkFileBytesActor, 2, int >::remove();

	}
	void a_callback_fire(ActorCallback< ReadBulkFileBytesActor, 2, int >*,int const& value) 
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadBulkFileBytesActor, 2, int >*,int && value) 
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadBulkFileBytesActor, 2, int >*,Error err) 
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 32 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string path;
															#line 32 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t maxLength;
															#line 32 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::shared_ptr<std::string> output;
															#line 35 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t chunkSize;
															#line 36 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	Reference<IAsyncFile> file;
															#line 38 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t fileSize;
															#line 48 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t offset;
															#line 49 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t remaining;
															#line 50 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::shared_ptr<std::string> chunk;
															#line 52 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t bytesToRead;
															#line 55 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int bytesRead;
															#line 506 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
};
// This generated class is to be used only via readBulkFileBytes()
															#line 32 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class ReadBulkFileBytesActor final : public Actor<Void>, public ActorCallback< ReadBulkFileBytesActor, 0, Reference<IAsyncFile> >, public ActorCallback< ReadBulkFileBytesActor, 1, int64_t >, public ActorCallback< ReadBulkFileBytesActor, 2, int >, public FastAllocated<ReadBulkFileBytesActor>, public ReadBulkFileBytesActorState<ReadBulkFileBytesActor> {
															#line 511 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
	using FastAllocated<ReadBulkFileBytesActor>::operator new;
	using FastAllocated<ReadBulkFileBytesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17481486233189312256UL, 7636381012903712512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadBulkFileBytesActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< ReadBulkFileBytesActor, 1, int64_t >;
friend struct ActorCallback< ReadBulkFileBytesActor, 2, int >;
															#line 32 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	ReadBulkFileBytesActor(std::string const& path,int64_t const& maxLength,std::shared_ptr<std::string> const& output) 
															#line 530 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		 : Actor<Void>(),
		   ReadBulkFileBytesActorState<ReadBulkFileBytesActor>(path, maxLength, output),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9571244570997355520UL, 15750496131617490432UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readBulkFileBytes");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadBulkFileBytesActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadBulkFileBytesActor, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReadBulkFileBytesActor, 2, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 32 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<Void> readBulkFileBytes( std::string const& path, int64_t const& maxLength, std::shared_ptr<std::string> const& output ) {
															#line 32 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<Void>(new ReadBulkFileBytesActor(path, maxLength, output));
															#line 565 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
}

#line 72 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

															#line 570 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
namespace {
// This generated class is to be used only via writeBulkFileBytes()
															#line 73 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class WriteBulkFileBytesActor>
															#line 73 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class WriteBulkFileBytesActorState {
															#line 577 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
															#line 73 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	WriteBulkFileBytesActorState(std::string const& path,std::shared_ptr<std::string> const& content) 
															#line 73 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 73 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : path(path),
															#line 73 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   content(content)
															#line 586 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
	{
		fdb_probe_actor_create("writeBulkFileBytes", reinterpret_cast<unsigned long>(this));

	}
	~WriteBulkFileBytesActorState() 
	{
		fdb_probe_actor_destroy("writeBulkFileBytes", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 75 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				chunkSize = SERVER_KNOBS->BULKLOAD_ASYNC_READ_WRITE_BLOCK_SIZE;
															#line 76 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( abspath(path), IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_CREATE, 0644);
															#line 76 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 606 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state = 1;
															#line 76 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteBulkFileBytesActor, 0, Reference<IAsyncFile> >*>(static_cast<WriteBulkFileBytesActor*>(this)));
															#line 611 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteBulkFileBytesActorState();
		static_cast<WriteBulkFileBytesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 97 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevWarn, "WriteBulkFileBytesError").error(e).detail("Path", path);
															#line 98 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 643 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 82 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		offset = 0;
															#line 83 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		remaining = content->size();
															#line 85 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		;
															#line 661 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __file,int loopDepth) 
	{
															#line 76 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		file = __file;
															#line 670 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __file,int loopDepth) 
	{
		file = std::move(__file);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state > 0) static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state = 0;
		static_cast<WriteBulkFileBytesActor*>(this)->ActorCallback< WriteBulkFileBytesActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< WriteBulkFileBytesActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteBulkFileBytesActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteBulkFileBytesActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 93 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->truncate(content->size());
															#line 93 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 751 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state = 3;
															#line 93 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteBulkFileBytesActor, 2, Void >*>(static_cast<WriteBulkFileBytesActor*>(this)));
															#line 756 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 85 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!(remaining > 0))
															#line 772 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 86 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		bytesToWrite = std::min(chunkSize, remaining);
															#line 87 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_1 = uncancellable(holdWhile(content, file->write(content->data() + offset, bytesToWrite, offset)));
															#line 87 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 782 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state = 2;
															#line 87 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteBulkFileBytesActor, 1, Void >*>(static_cast<WriteBulkFileBytesActor*>(this)));
															#line 787 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		offset += bytesToWrite;
															#line 89 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		remaining -= bytesToWrite;
															#line 811 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		offset += bytesToWrite;
															#line 89 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		remaining -= bytesToWrite;
															#line 822 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state > 0) static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state = 0;
		static_cast<WriteBulkFileBytesActor*>(this)->ActorCallback< WriteBulkFileBytesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteBulkFileBytesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteBulkFileBytesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteBulkFileBytesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_3 = file->sync();
															#line 94 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 908 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state = 4;
															#line 94 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteBulkFileBytesActor, 3, Void >*>(static_cast<WriteBulkFileBytesActor*>(this)));
															#line 913 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_3 = file->sync();
															#line 94 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 924 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state = 4;
															#line 94 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteBulkFileBytesActor, 3, Void >*>(static_cast<WriteBulkFileBytesActor*>(this)));
															#line 929 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state > 0) static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state = 0;
		static_cast<WriteBulkFileBytesActor*>(this)->ActorCallback< WriteBulkFileBytesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteBulkFileBytesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteBulkFileBytesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteBulkFileBytesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 95 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<WriteBulkFileBytesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteBulkFileBytesActorState(); static_cast<WriteBulkFileBytesActor*>(this)->destroy(); return 0; }
															#line 1013 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		new (&static_cast<WriteBulkFileBytesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteBulkFileBytesActorState();
		static_cast<WriteBulkFileBytesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 95 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<WriteBulkFileBytesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteBulkFileBytesActorState(); static_cast<WriteBulkFileBytesActor*>(this)->destroy(); return 0; }
															#line 1025 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		new (&static_cast<WriteBulkFileBytesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteBulkFileBytesActorState();
		static_cast<WriteBulkFileBytesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state > 0) static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state = 0;
		static_cast<WriteBulkFileBytesActor*>(this)->ActorCallback< WriteBulkFileBytesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteBulkFileBytesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WriteBulkFileBytesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WriteBulkFileBytesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 73 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string path;
															#line 73 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::shared_ptr<std::string> content;
															#line 75 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t chunkSize;
															#line 76 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	Reference<IAsyncFile> file;
															#line 82 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t offset;
															#line 83 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t remaining;
															#line 86 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t bytesToWrite;
															#line 1122 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
};
// This generated class is to be used only via writeBulkFileBytes()
															#line 73 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class WriteBulkFileBytesActor final : public Actor<Void>, public ActorCallback< WriteBulkFileBytesActor, 0, Reference<IAsyncFile> >, public ActorCallback< WriteBulkFileBytesActor, 1, Void >, public ActorCallback< WriteBulkFileBytesActor, 2, Void >, public ActorCallback< WriteBulkFileBytesActor, 3, Void >, public FastAllocated<WriteBulkFileBytesActor>, public WriteBulkFileBytesActorState<WriteBulkFileBytesActor> {
															#line 1127 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
	using FastAllocated<WriteBulkFileBytesActor>::operator new;
	using FastAllocated<WriteBulkFileBytesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13606917244092859392UL, 14651320420692174080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteBulkFileBytesActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< WriteBulkFileBytesActor, 1, Void >;
friend struct ActorCallback< WriteBulkFileBytesActor, 2, Void >;
friend struct ActorCallback< WriteBulkFileBytesActor, 3, Void >;
															#line 73 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	WriteBulkFileBytesActor(std::string const& path,std::shared_ptr<std::string> const& content) 
															#line 1147 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		 : Actor<Void>(),
		   WriteBulkFileBytesActorState<WriteBulkFileBytesActor>(path, content),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17005299131570403328UL, 17577297949485139968UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeBulkFileBytes");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteBulkFileBytesActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteBulkFileBytesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteBulkFileBytesActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WriteBulkFileBytesActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 73 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<Void> writeBulkFileBytes( std::string const& path, std::shared_ptr<std::string> const& content ) {
															#line 73 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<Void>(new WriteBulkFileBytesActor(path, content));
															#line 1183 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
}

#line 101 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

															#line 1188 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
namespace {
// This generated class is to be used only via copyBulkFile()
															#line 102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class CopyBulkFileActor>
															#line 102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class CopyBulkFileActorState {
															#line 1195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
															#line 102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	CopyBulkFileActorState(std::string const& fromFile,std::string const& toFile,size_t const& fileBytesMax) 
															#line 102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : fromFile(fromFile),
															#line 102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   toFile(toFile),
															#line 102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   fileBytesMax(fileBytesMax),
															#line 103 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   content(std::make_shared<std::string>())
															#line 1208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
	{
		fdb_probe_actor_create("copyBulkFile", reinterpret_cast<unsigned long>(this));

	}
	~CopyBulkFileActorState() 
	{
		fdb_probe_actor_destroy("copyBulkFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 104 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_0 = readBulkFileBytes(abspath(fromFile), fileBytesMax, content);
															#line 104 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<CopyBulkFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1225 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyBulkFileActor*>(this)->actor_wait_state = 1;
															#line 104 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyBulkFileActor, 0, Void >*>(static_cast<CopyBulkFileActor*>(this)));
															#line 1230 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyBulkFileActorState();
		static_cast<CopyBulkFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 105 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_1 = writeBulkFileBytes(toFile, content);
															#line 105 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<CopyBulkFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1255 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyBulkFileActor*>(this)->actor_wait_state = 2;
															#line 105 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyBulkFileActor, 1, Void >*>(static_cast<CopyBulkFileActor*>(this)));
															#line 1260 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 105 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_1 = writeBulkFileBytes(toFile, content);
															#line 105 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<CopyBulkFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1271 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyBulkFileActor*>(this)->actor_wait_state = 2;
															#line 105 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyBulkFileActor, 1, Void >*>(static_cast<CopyBulkFileActor*>(this)));
															#line 1276 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyBulkFileActor*>(this)->actor_wait_state > 0) static_cast<CopyBulkFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyBulkFileActor*>(this)->ActorCallback< CopyBulkFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyBulkFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyBulkFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyBulkFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyBulkFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyBulkFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyBulkFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyBulkFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyBulkFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyBulkFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyBulkFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyBulkFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyBulkFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 106 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<CopyBulkFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyBulkFileActorState(); static_cast<CopyBulkFileActor*>(this)->destroy(); return 0; }
															#line 1360 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		new (&static_cast<CopyBulkFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyBulkFileActorState();
		static_cast<CopyBulkFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 106 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<CopyBulkFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyBulkFileActorState(); static_cast<CopyBulkFileActor*>(this)->destroy(); return 0; }
															#line 1372 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		new (&static_cast<CopyBulkFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyBulkFileActorState();
		static_cast<CopyBulkFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CopyBulkFileActor*>(this)->actor_wait_state > 0) static_cast<CopyBulkFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyBulkFileActor*>(this)->ActorCallback< CopyBulkFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyBulkFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyBulkFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyBulkFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyBulkFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CopyBulkFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyBulkFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyBulkFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyBulkFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CopyBulkFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyBulkFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyBulkFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyBulkFile", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string fromFile;
															#line 102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string toFile;
															#line 102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	size_t fileBytesMax;
															#line 103 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::shared_ptr<std::string> content;
															#line 1463 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
};
// This generated class is to be used only via copyBulkFile()
															#line 102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class CopyBulkFileActor final : public Actor<Void>, public ActorCallback< CopyBulkFileActor, 0, Void >, public ActorCallback< CopyBulkFileActor, 1, Void >, public FastAllocated<CopyBulkFileActor>, public CopyBulkFileActorState<CopyBulkFileActor> {
															#line 1468 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
	using FastAllocated<CopyBulkFileActor>::operator new;
	using FastAllocated<CopyBulkFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12599032168808266496UL, 8820301866203757568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyBulkFileActor, 0, Void >;
friend struct ActorCallback< CopyBulkFileActor, 1, Void >;
															#line 102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	CopyBulkFileActor(std::string const& fromFile,std::string const& toFile,size_t const& fileBytesMax) 
															#line 1486 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		 : Actor<Void>(),
		   CopyBulkFileActorState<CopyBulkFileActor>(fromFile, toFile, fileBytesMax),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyBulkFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(871025483483831552UL, 9209667149474841088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyBulkFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyBulkFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyBulkFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyBulkFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CopyBulkFileActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<Void> copyBulkFile( std::string const& fromFile, std::string const& toFile, size_t const& fileBytesMax ) {
															#line 102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<Void>(new CopyBulkFileActor(fromFile, toFile, fileBytesMax));
															#line 1520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
}

#line 108 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

															#line 1525 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
namespace {
// This generated class is to be used only via getBulkLoadTaskStateFromDataMove()
															#line 109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class GetBulkLoadTaskStateFromDataMoveActor>
															#line 109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class GetBulkLoadTaskStateFromDataMoveActorState {
															#line 1532 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
															#line 109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	GetBulkLoadTaskStateFromDataMoveActorState(Database const& cx,UID const& dataMoveId,Version const& atLeastVersion,UID const& logId) 
															#line 109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : cx(cx),
															#line 109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   dataMoveId(dataMoveId),
															#line 109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   atLeastVersion(atLeastVersion),
															#line 109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId),
															#line 113 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   tr(cx)
															#line 1547 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
	{
		fdb_probe_actor_create("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this));

	}
	~GetBulkLoadTaskStateFromDataMoveActorState() 
	{
		fdb_probe_actor_destroy("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 114 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 115 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 116 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			;
															#line 1566 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBulkLoadTaskStateFromDataMoveActorState();
		static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 118 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(dataMoveKeyFor(dataMoveId));
															#line 118 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1599 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 1;
															#line 118 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 0, Optional<Value> >*>(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)));
															#line 1604 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 152 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 152 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1628 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 5;
															#line 152 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 4, Void >*>(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)));
															#line 1633 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 119 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		ASSERT(tr.getReadVersion().isReady());
															#line 120 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (tr.getReadVersion().get() < atLeastVersion)
															#line 1650 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
															#line 121 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(0.1);
															#line 121 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1656 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 2;
															#line 121 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 1, Void >*>(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)));
															#line 1661 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& __val,int loopDepth) 
	{
															#line 118 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		val = __val;
															#line 1675 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && __val,int loopDepth) 
	{
		val = std::move(__val);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 127 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (val.present())
															#line 1754 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
															#line 128 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			dataMoveMetaData = decodeDataMoveValue(val.get());
															#line 129 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (dataMoveMetaData.bulkLoadTaskState.present())
															#line 1760 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			{
															#line 130 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (!static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->SAV<BulkLoadTaskState>::futures) { (void)(dataMoveMetaData.bulkLoadTaskState.get()); this->~GetBulkLoadTaskStateFromDataMoveActorState(); static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->destroy(); return 0; }
															#line 1764 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
				new (&static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->SAV< BulkLoadTaskState >::value()) BulkLoadTaskState(dataMoveMetaData.bulkLoadTaskState.get());
				this->~GetBulkLoadTaskStateFromDataMoveActorState();
				static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 132 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				StrictFuture<Void> __when_expr_2 = delay(0.1);
															#line 132 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1776 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
				static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 3;
															#line 132 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 2, Void >*>(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)));
															#line 1781 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
				loopDepth = 0;
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 122 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.reset();
															#line 123 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 124 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1800 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 122 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.reset();
															#line 123 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 124 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1813 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 144 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		TraceEvent(SevWarnAlways, "SSBulkLoadTaskDataMoveIdNotExist", logId) .detail("Message", "This fetchKey is blocked and will be cancelled later") .detail("DataMoveID", dataMoveId) .detail("ReadVersion", tr.getReadVersion().get()) .detail("AtLeastVersion", atLeastVersion);
															#line 149 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_3 = Never();
															#line 149 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1901 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 4;
															#line 149 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 3, Void >*>(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)));
															#line 1906 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 133 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.reset();
															#line 134 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 135 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1919 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 133 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.reset();
															#line 134 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 135 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1932 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
															#line 150 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		return a_body1loopBody1Catch1(internal_error(), loopDepth);
															#line 2016 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
															#line 150 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		return a_body1loopBody1Catch1(internal_error(), loopDepth);
															#line 2024 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	Database cx;
															#line 109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID dataMoveId;
															#line 109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	Version atLeastVersion;
															#line 109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 113 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	Transaction tr;
															#line 118 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	Optional<Value> val;
															#line 128 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	DataMoveMetaData dataMoveMetaData;
															#line 2204 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
};
// This generated class is to be used only via getBulkLoadTaskStateFromDataMove()
															#line 109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class GetBulkLoadTaskStateFromDataMoveActor final : public Actor<BulkLoadTaskState>, public ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 0, Optional<Value> >, public ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 1, Void >, public ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 2, Void >, public ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 3, Void >, public ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 4, Void >, public FastAllocated<GetBulkLoadTaskStateFromDataMoveActor>, public GetBulkLoadTaskStateFromDataMoveActorState<GetBulkLoadTaskStateFromDataMoveActor> {
															#line 2209 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
	using FastAllocated<GetBulkLoadTaskStateFromDataMoveActor>::operator new;
	using FastAllocated<GetBulkLoadTaskStateFromDataMoveActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7013209970586446080UL, 16637168377536183296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<BulkLoadTaskState>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 0, Optional<Value> >;
friend struct ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 1, Void >;
friend struct ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 2, Void >;
friend struct ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 3, Void >;
friend struct ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 4, Void >;
															#line 109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	GetBulkLoadTaskStateFromDataMoveActor(Database const& cx,UID const& dataMoveId,Version const& atLeastVersion,UID const& logId) 
															#line 2230 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		 : Actor<BulkLoadTaskState>(),
		   GetBulkLoadTaskStateFromDataMoveActorState<GetBulkLoadTaskStateFromDataMoveActor>(cx, dataMoveId, atLeastVersion, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12479688157220202496UL, 14588692596896574464UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBulkLoadTaskStateFromDataMove");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<BulkLoadTaskState> getBulkLoadTaskStateFromDataMove( Database const& cx, UID const& dataMoveId, Version const& atLeastVersion, UID const& logId ) {
															#line 109 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<BulkLoadTaskState>(new GetBulkLoadTaskStateFromDataMoveActor(cx, dataMoveId, atLeastVersion, logId));
															#line 2267 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
}

#line 156 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

// Return true if generated the byte sampling file. Otherwise, return false.
// TODO(BulkDump): directly read from special key space.
															#line 2274 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
namespace {
// This generated class is to be used only via doBytesSamplingOnDataFile()
															#line 159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class DoBytesSamplingOnDataFileActor>
															#line 159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class DoBytesSamplingOnDataFileActorState {
															#line 2281 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
															#line 159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	DoBytesSamplingOnDataFileActorState(std::string const& dataFileFullPath,std::string const& byteSampleFileFullPath,UID const& logId) 
															#line 159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : dataFileFullPath(dataFileFullPath),
															#line 159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   byteSampleFileFullPath(byteSampleFileFullPath),
															#line 159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId),
															#line 162 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   counter(0),
															#line 163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   res(false),
															#line 164 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   retryCount(0),
															#line 165 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   startTime(now())
															#line 2300 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
	{
		fdb_probe_actor_create("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this));

	}
	~DoBytesSamplingOnDataFileActorState() 
	{
		fdb_probe_actor_destroy("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 166 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			;
															#line 2315 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoBytesSamplingOnDataFileActorState();
		static_cast<DoBytesSamplingOnDataFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		TraceEvent(bulkLoadVerboseEventSev(), "SSBulkLoadTaskSamplingComplete", logId) .detail("DataFileFullPath", dataFileFullPath) .detail("ByteSampleFileFullPath", byteSampleFileFullPath) .detail("Duration", now() - startTime) .detail("RetryCount", retryCount);
															#line 217 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<DoBytesSamplingOnDataFileActor*>(this)->SAV<bool>::futures) { (void)(res); this->~DoBytesSamplingOnDataFileActorState(); static_cast<DoBytesSamplingOnDataFileActor*>(this)->destroy(); return 0; }
															#line 2340 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		new (&static_cast<DoBytesSamplingOnDataFileActor*>(this)->SAV< bool >::value()) bool(std::move(res)); // state_var_RVO
		this->~DoBytesSamplingOnDataFileActorState();
		static_cast<DoBytesSamplingOnDataFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 168 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			sstWriter = newRocksDBSstFileWriter();
															#line 169 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			sstWriter->open(abspath(byteSampleFileFullPath));
															#line 170 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			anySampled = false;
															#line 171 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			reader = newRocksDBSstFileReader();
															#line 172 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			reader->open(abspath(dataFileFullPath));
															#line 173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			;
															#line 2370 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 198 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 2405 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			{
															#line 199 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2409 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			}
															#line 201 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevWarn, "SSBulkLoadTaskSamplingError", logId) .errorUnsuppressed(e) .detail("DataFileFullPath", dataFileFullPath) .detail("ByteSampleFileFullPath", byteSampleFileFullPath) .detail("Duration", now() - startTime) .detail("RetryCount", retryCount);
															#line 207 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(5.0);
															#line 207 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<DoBytesSamplingOnDataFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2417 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoBytesSamplingOnDataFileActor*>(this)->actor_wait_state = 2;
															#line 207 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBytesSamplingOnDataFileActor, 1, Void >*>(static_cast<DoBytesSamplingOnDataFileActor*>(this)));
															#line 2422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 189 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (anySampled)
															#line 2437 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
															#line 190 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			ASSERT(sstWriter->finish());
															#line 191 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			res = true;
															#line 2443 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		}
		else
		{
															#line 193 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			ASSERT(!sstWriter->finish());
															#line 194 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			deleteFile(abspath(byteSampleFileFullPath));
															#line 2451 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 173 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!(reader->hasNext()))
															#line 2468 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 174 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		KeyValue kv = reader->next();
															#line 175 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		ByteSampleInfo sampleInfo = isKeyValueInSample(kv);
															#line 176 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (sampleInfo.inSample)
															#line 2478 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
															#line 177 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			sstWriter->write(kv.key, BinaryWriter::toValue(sampleInfo.sampledSize, Unversioned()));
															#line 178 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			anySampled = true;
															#line 179 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			counter++;
															#line 180 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (counter > SERVER_KNOBS->BULKLOAD_BYTE_SAMPLE_BATCH_KEY_COUNT)
															#line 2488 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			{
															#line 181 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				StrictFuture<Void> __when_expr_0 = yield();
															#line 181 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (static_cast<DoBytesSamplingOnDataFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2494 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DoBytesSamplingOnDataFileActor*>(this)->actor_wait_state = 1;
															#line 181 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoBytesSamplingOnDataFileActor, 0, Void >*>(static_cast<DoBytesSamplingOnDataFileActor*>(this)));
															#line 2499 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 182 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		counter = 0;
															#line 2543 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 182 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		counter = 0;
															#line 2552 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoBytesSamplingOnDataFileActor*>(this)->actor_wait_state > 0) static_cast<DoBytesSamplingOnDataFileActor*>(this)->actor_wait_state = 0;
		static_cast<DoBytesSamplingOnDataFileActor*>(this)->ActorCallback< DoBytesSamplingOnDataFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBytesSamplingOnDataFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBytesSamplingOnDataFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoBytesSamplingOnDataFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBytesSamplingOnDataFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoBytesSamplingOnDataFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBytesSamplingOnDataFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		deleteFile(abspath(byteSampleFileFullPath));
															#line 209 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		retryCount++;
															#line 2638 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		deleteFile(abspath(byteSampleFileFullPath));
															#line 209 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		retryCount++;
															#line 2649 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoBytesSamplingOnDataFileActor*>(this)->actor_wait_state > 0) static_cast<DoBytesSamplingOnDataFileActor*>(this)->actor_wait_state = 0;
		static_cast<DoBytesSamplingOnDataFileActor*>(this)->ActorCallback< DoBytesSamplingOnDataFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBytesSamplingOnDataFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBytesSamplingOnDataFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoBytesSamplingOnDataFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBytesSamplingOnDataFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoBytesSamplingOnDataFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBytesSamplingOnDataFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string dataFileFullPath;
															#line 159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string byteSampleFileFullPath;
															#line 159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 162 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int counter;
															#line 163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	bool res;
															#line 164 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int retryCount;
															#line 165 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	double startTime;
															#line 168 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::unique_ptr<IRocksDBSstFileWriter> sstWriter;
															#line 170 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	bool anySampled;
															#line 171 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::unique_ptr<IRocksDBSstFileReader> reader;
															#line 2749 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
};
// This generated class is to be used only via doBytesSamplingOnDataFile()
															#line 159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class DoBytesSamplingOnDataFileActor final : public Actor<bool>, public ActorCallback< DoBytesSamplingOnDataFileActor, 0, Void >, public ActorCallback< DoBytesSamplingOnDataFileActor, 1, Void >, public FastAllocated<DoBytesSamplingOnDataFileActor>, public DoBytesSamplingOnDataFileActorState<DoBytesSamplingOnDataFileActor> {
															#line 2754 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
	using FastAllocated<DoBytesSamplingOnDataFileActor>::operator new;
	using FastAllocated<DoBytesSamplingOnDataFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13622614438785791232UL, 6866201567454578176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoBytesSamplingOnDataFileActor, 0, Void >;
friend struct ActorCallback< DoBytesSamplingOnDataFileActor, 1, Void >;
															#line 159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	DoBytesSamplingOnDataFileActor(std::string const& dataFileFullPath,std::string const& byteSampleFileFullPath,UID const& logId) 
															#line 2772 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		 : Actor<bool>(),
		   DoBytesSamplingOnDataFileActorState<DoBytesSamplingOnDataFileActor>(dataFileFullPath, byteSampleFileFullPath, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6947520146366501888UL, 10722775557252509440UL);
		ActorExecutionContextHelper __helper(static_cast<DoBytesSamplingOnDataFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doBytesSamplingOnDataFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoBytesSamplingOnDataFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoBytesSamplingOnDataFileActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<bool> doBytesSamplingOnDataFile( std::string const& dataFileFullPath, std::string const& byteSampleFileFullPath, UID const& logId ) {
															#line 159 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<bool>(new DoBytesSamplingOnDataFileActor(dataFileFullPath, byteSampleFileFullPath, logId));
															#line 2806 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
}

#line 219 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

// TODO(BulkLoad): slow task
void clearFileFolder(const std::string& folderPath, const UID& logId, bool ignoreError) {
	try {
		platform::eraseDirectoryRecursive(abspath(folderPath));
	} catch (Error& e) {
		if (logId.isValid()) {
			TraceEvent(ignoreError ? SevWarn : SevWarnAlways, "ClearFileFolderError", logId)
			    .error(e)
			    .detail("FolderPath", folderPath);
		}
		if (ignoreError) {
			return;
		}
		throw e;
	}
	return;
}

// TODO(BulkLoad): slow task
void resetFileFolder(const std::string& folderPath) {
	clearFileFolder(abspath(folderPath));
	ASSERT(platform::createDirectory(abspath(folderPath)));
	return;
}

															#line 2836 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
namespace {
// This generated class is to be used only via bulkLoadTransportCP_impl()
															#line 245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class BulkLoadTransportCP_implActor>
															#line 245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class BulkLoadTransportCP_implActorState {
															#line 2843 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
															#line 245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadTransportCP_implActorState(BulkLoadFileSet const& fromRemoteFileSet,BulkLoadFileSet const& toLocalFileSet,size_t const& fileBytesMax,UID const& logId) 
															#line 245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : fromRemoteFileSet(fromRemoteFileSet),
															#line 245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   toLocalFileSet(toLocalFileSet),
															#line 245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   fileBytesMax(fileBytesMax),
															#line 245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId)
															#line 2856 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
	{
		fdb_probe_actor_create("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this));

	}
	~BulkLoadTransportCP_implActorState() 
	{
		fdb_probe_actor_destroy("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 250 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			resetFileFolder(abspath(toLocalFileSet.getFolder()));
															#line 252 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_0 = copyBulkFile( abspath(fromRemoteFileSet.getDataFileFullPath()), abspath(toLocalFileSet.getDataFileFullPath()), fileBytesMax);
															#line 252 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2875 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state = 1;
															#line 252 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BulkLoadTransportCP_implActor, 0, Void >*>(static_cast<BulkLoadTransportCP_implActor*>(this)));
															#line 2880 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BulkLoadTransportCP_implActorState();
		static_cast<BulkLoadTransportCP_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 255 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (fromRemoteFileSet.hasByteSampleFile())
															#line 2903 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
															#line 256 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_1 = copyBulkFile(abspath(fromRemoteFileSet.getBytesSampleFileFullPath()), abspath(toLocalFileSet.getBytesSampleFileFullPath()), fileBytesMax);
															#line 256 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2909 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state = 2;
															#line 256 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BulkLoadTransportCP_implActor, 1, Void >*>(static_cast<BulkLoadTransportCP_implActor*>(this)));
															#line 2914 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 255 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (fromRemoteFileSet.hasByteSampleFile())
															#line 2928 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
															#line 256 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_1 = copyBulkFile(abspath(fromRemoteFileSet.getBytesSampleFileFullPath()), abspath(toLocalFileSet.getBytesSampleFileFullPath()), fileBytesMax);
															#line 256 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2934 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state = 2;
															#line 256 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BulkLoadTransportCP_implActor, 1, Void >*>(static_cast<BulkLoadTransportCP_implActor*>(this)));
															#line 2939 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadTransportCP_implActor*>(this)->ActorCallback< BulkLoadTransportCP_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadTransportCP_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BulkLoadTransportCP_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BulkLoadTransportCP_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 261 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<BulkLoadTransportCP_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BulkLoadTransportCP_implActorState(); static_cast<BulkLoadTransportCP_implActor*>(this)->destroy(); return 0; }
															#line 3028 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		new (&static_cast<BulkLoadTransportCP_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BulkLoadTransportCP_implActorState();
		static_cast<BulkLoadTransportCP_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadTransportCP_implActor*>(this)->ActorCallback< BulkLoadTransportCP_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadTransportCP_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BulkLoadTransportCP_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BulkLoadTransportCP_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadFileSet fromRemoteFileSet;
															#line 245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadFileSet toLocalFileSet;
															#line 245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	size_t fileBytesMax;
															#line 245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 3131 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
};
// This generated class is to be used only via bulkLoadTransportCP_impl()
															#line 245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class BulkLoadTransportCP_implActor final : public Actor<Void>, public ActorCallback< BulkLoadTransportCP_implActor, 0, Void >, public ActorCallback< BulkLoadTransportCP_implActor, 1, Void >, public FastAllocated<BulkLoadTransportCP_implActor>, public BulkLoadTransportCP_implActorState<BulkLoadTransportCP_implActor> {
															#line 3136 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
	using FastAllocated<BulkLoadTransportCP_implActor>::operator new;
	using FastAllocated<BulkLoadTransportCP_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18134680267925192448UL, 1353851058592099328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BulkLoadTransportCP_implActor, 0, Void >;
friend struct ActorCallback< BulkLoadTransportCP_implActor, 1, Void >;
															#line 245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadTransportCP_implActor(BulkLoadFileSet const& fromRemoteFileSet,BulkLoadFileSet const& toLocalFileSet,size_t const& fileBytesMax,UID const& logId) 
															#line 3154 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		 : Actor<Void>(),
		   BulkLoadTransportCP_implActorState<BulkLoadTransportCP_implActor>(fromRemoteFileSet, toLocalFileSet, fileBytesMax, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5706731850230082304UL, 2932857527623400704UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bulkLoadTransportCP_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BulkLoadTransportCP_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BulkLoadTransportCP_implActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<Void> bulkLoadTransportCP_impl( BulkLoadFileSet const& fromRemoteFileSet, BulkLoadFileSet const& toLocalFileSet, size_t const& fileBytesMax, UID const& logId ) {
															#line 245 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<Void>(new BulkLoadTransportCP_implActor(fromRemoteFileSet, toLocalFileSet, fileBytesMax, logId));
															#line 3188 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
}

#line 263 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

															#line 3193 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
namespace {
// This generated class is to be used only via bulkLoadTransportBlobstore_impl()
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class BulkLoadTransportBlobstore_implActor>
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class BulkLoadTransportBlobstore_implActorState {
															#line 3200 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadTransportBlobstore_implActorState(BulkLoadFileSet const& fromRemoteFileSet,BulkLoadFileSet const& toLocalFileSet,size_t const& fileBytesMax,UID const& logId) 
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : fromRemoteFileSet(fromRemoteFileSet),
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   toLocalFileSet(toLocalFileSet),
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   fileBytesMax(fileBytesMax),
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId)
															#line 3213 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
	{
		fdb_probe_actor_create("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this));

	}
	~BulkLoadTransportBlobstore_implActorState() 
	{
		fdb_probe_actor_destroy("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 269 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			resetFileFolder(abspath(toLocalFileSet.getFolder()));
															#line 272 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_0 = copyDownFile(fromRemoteFileSet.getDataFileFullPath(), abspath(toLocalFileSet.getDataFileFullPath()));
															#line 272 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<BulkLoadTransportBlobstore_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3232 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BulkLoadTransportBlobstore_implActor*>(this)->actor_wait_state = 1;
															#line 272 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BulkLoadTransportBlobstore_implActor, 0, Void >*>(static_cast<BulkLoadTransportBlobstore_implActor*>(this)));
															#line 3237 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BulkLoadTransportBlobstore_implActorState();
		static_cast<BulkLoadTransportBlobstore_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 274 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (fromRemoteFileSet.hasByteSampleFile())
															#line 3260 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_1 = copyDownFile(fromRemoteFileSet.getBytesSampleFileFullPath(), abspath(toLocalFileSet.getBytesSampleFileFullPath()));
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<BulkLoadTransportBlobstore_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3266 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<BulkLoadTransportBlobstore_implActor*>(this)->actor_wait_state = 2;
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BulkLoadTransportBlobstore_implActor, 1, Void >*>(static_cast<BulkLoadTransportBlobstore_implActor*>(this)));
															#line 3271 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 274 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (fromRemoteFileSet.hasByteSampleFile())
															#line 3285 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_1 = copyDownFile(fromRemoteFileSet.getBytesSampleFileFullPath(), abspath(toLocalFileSet.getBytesSampleFileFullPath()));
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<BulkLoadTransportBlobstore_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3291 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<BulkLoadTransportBlobstore_implActor*>(this)->actor_wait_state = 2;
															#line 275 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BulkLoadTransportBlobstore_implActor, 1, Void >*>(static_cast<BulkLoadTransportBlobstore_implActor*>(this)));
															#line 3296 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BulkLoadTransportBlobstore_implActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadTransportBlobstore_implActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadTransportBlobstore_implActor*>(this)->ActorCallback< BulkLoadTransportBlobstore_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadTransportBlobstore_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportBlobstore_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BulkLoadTransportBlobstore_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportBlobstore_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BulkLoadTransportBlobstore_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportBlobstore_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<BulkLoadTransportBlobstore_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BulkLoadTransportBlobstore_implActorState(); static_cast<BulkLoadTransportBlobstore_implActor*>(this)->destroy(); return 0; }
															#line 3385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		new (&static_cast<BulkLoadTransportBlobstore_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BulkLoadTransportBlobstore_implActorState();
		static_cast<BulkLoadTransportBlobstore_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BulkLoadTransportBlobstore_implActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadTransportBlobstore_implActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadTransportBlobstore_implActor*>(this)->ActorCallback< BulkLoadTransportBlobstore_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadTransportBlobstore_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportBlobstore_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BulkLoadTransportBlobstore_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportBlobstore_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BulkLoadTransportBlobstore_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportBlobstore_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadFileSet fromRemoteFileSet;
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadFileSet toLocalFileSet;
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	size_t fileBytesMax;
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 3488 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
};
// This generated class is to be used only via bulkLoadTransportBlobstore_impl()
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class BulkLoadTransportBlobstore_implActor final : public Actor<Void>, public ActorCallback< BulkLoadTransportBlobstore_implActor, 0, Void >, public ActorCallback< BulkLoadTransportBlobstore_implActor, 1, Void >, public FastAllocated<BulkLoadTransportBlobstore_implActor>, public BulkLoadTransportBlobstore_implActorState<BulkLoadTransportBlobstore_implActor> {
															#line 3493 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
	using FastAllocated<BulkLoadTransportBlobstore_implActor>::operator new;
	using FastAllocated<BulkLoadTransportBlobstore_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3465477399476415744UL, 391699195559267328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BulkLoadTransportBlobstore_implActor, 0, Void >;
friend struct ActorCallback< BulkLoadTransportBlobstore_implActor, 1, Void >;
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadTransportBlobstore_implActor(BulkLoadFileSet const& fromRemoteFileSet,BulkLoadFileSet const& toLocalFileSet,size_t const& fileBytesMax,UID const& logId) 
															#line 3511 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		 : Actor<Void>(),
		   BulkLoadTransportBlobstore_implActorState<BulkLoadTransportBlobstore_implActor>(fromRemoteFileSet, toLocalFileSet, fileBytesMax, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8411043785109451008UL, 9533312045468678400UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportBlobstore_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bulkLoadTransportBlobstore_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BulkLoadTransportBlobstore_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BulkLoadTransportBlobstore_implActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<Void> bulkLoadTransportBlobstore_impl( BulkLoadFileSet const& fromRemoteFileSet, BulkLoadFileSet const& toLocalFileSet, size_t const& fileBytesMax, UID const& logId ) {
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<Void>(new BulkLoadTransportBlobstore_implActor(fromRemoteFileSet, toLocalFileSet, fileBytesMax, logId));
															#line 3545 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
}

#line 281 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

															#line 3550 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
namespace {
// This generated class is to be used only via bulkLoadDownloadTaskFileSet()
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class BulkLoadDownloadTaskFileSetActor>
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class BulkLoadDownloadTaskFileSetActorState {
															#line 3557 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadDownloadTaskFileSetActorState(BulkLoadTransportMethod const& transportMethod,BulkLoadFileSet const& fromRemoteFileSet,std::string const& toLocalRoot,UID const& logId) 
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : transportMethod(transportMethod),
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   fromRemoteFileSet(fromRemoteFileSet),
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   toLocalRoot(toLocalRoot),
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId),
															#line 286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   retryCount(0),
															#line 287 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   startTime(now())
															#line 3574 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
	{
		fdb_probe_actor_create("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this));

	}
	~BulkLoadDownloadTaskFileSetActorState() 
	{
		fdb_probe_actor_destroy("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 288 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			ASSERT(transportMethod != BulkLoadTransportMethod::Invalid);
															#line 289 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			;
															#line 3591 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BulkLoadDownloadTaskFileSetActorState();
		static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 292 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			toLocalFileSet = BulkLoadFileSet(toLocalRoot, fromRemoteFileSet.getRelativePath(), fromRemoteFileSet.getManifestFileName(), fromRemoteFileSet.getDataFileName(), fromRemoteFileSet.getByteSampleFileName(), BulkLoadChecksum());
															#line 300 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (transportMethod == BulkLoadTransportMethod::CP)
															#line 3624 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			{
															#line 301 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				ASSERT(fromRemoteFileSet.hasDataFile());
															#line 304 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				StrictFuture<Void> __when_expr_0 = bulkLoadTransportCP_impl( fromRemoteFileSet, toLocalFileSet, SERVER_KNOBS->BULKLOAD_FILE_BYTES_MAX, logId);
															#line 304 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3632 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state = 1;
															#line 304 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BulkLoadDownloadTaskFileSetActor, 0, Void >*>(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)));
															#line 3637 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (transportMethod == BulkLoadTransportMethod::BLOBSTORE)
															#line 3644 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
				{
															#line 309 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					StrictFuture<Void> __when_expr_1 = bulkLoadTransportBlobstore_impl( fromRemoteFileSet, toLocalFileSet, SERVER_KNOBS->BULKLOAD_FILE_BYTES_MAX, logId);
															#line 309 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					if (static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3650 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
					static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state = 2;
															#line 309 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BulkLoadDownloadTaskFileSetActor, 1, Void >*>(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)));
															#line 3655 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 312 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					UNREACHABLE();
															#line 3662 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
					loopDepth = a_body1loopBody1cont4(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 323 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3686 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			{
															#line 324 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 3690 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			}
															#line 326 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevWarn, "SSBulkLoadTaskDownloadFileSetError", logId) .errorUnsuppressed(e) .detail("FromRemoteFileSet", fromRemoteFileSet.toString()) .detail("ToLocalRoot", toLocalRoot) .detail("Duration", now() - startTime) .detail("RetryCount", retryCount);
															#line 332 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			retryCount++;
															#line 333 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(5.0);
															#line 333 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3700 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state = 3;
															#line 333 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BulkLoadDownloadTaskFileSetActor, 2, Void >*>(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)));
															#line 3705 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 314 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		TraceEvent(bulkLoadVerboseEventSev(), "SSBulkLoadTaskDownloadFileSet", logId) .detail("FromRemoteFileSet", fromRemoteFileSet.toString()) .detail("ToLocalRoot", toLocalRoot) .detail("Duration", now() - startTime) .detail("RetryCount", retryCount);
															#line 320 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->SAV<BulkLoadFileSet>::futures) { (void)(toLocalFileSet); this->~BulkLoadDownloadTaskFileSetActorState(); static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->destroy(); return 0; }
															#line 3722 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		new (&static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->SAV< BulkLoadFileSet >::value()) BulkLoadFileSet(std::move(toLocalFileSet)); // state_var_RVO
		this->~BulkLoadDownloadTaskFileSetActorState();
		static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->ActorCallback< BulkLoadDownloadTaskFileSetActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadDownloadTaskFileSetActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BulkLoadDownloadTaskFileSetActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BulkLoadDownloadTaskFileSetActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->ActorCallback< BulkLoadDownloadTaskFileSetActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadDownloadTaskFileSetActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BulkLoadDownloadTaskFileSetActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BulkLoadDownloadTaskFileSetActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->ActorCallback< BulkLoadDownloadTaskFileSetActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadDownloadTaskFileSetActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BulkLoadDownloadTaskFileSetActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BulkLoadDownloadTaskFileSetActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadTransportMethod transportMethod;
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadFileSet fromRemoteFileSet;
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string toLocalRoot;
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int retryCount;
															#line 287 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	double startTime;
															#line 292 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadFileSet toLocalFileSet;
															#line 4011 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
};
// This generated class is to be used only via bulkLoadDownloadTaskFileSet()
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class BulkLoadDownloadTaskFileSetActor final : public Actor<BulkLoadFileSet>, public ActorCallback< BulkLoadDownloadTaskFileSetActor, 0, Void >, public ActorCallback< BulkLoadDownloadTaskFileSetActor, 1, Void >, public ActorCallback< BulkLoadDownloadTaskFileSetActor, 2, Void >, public FastAllocated<BulkLoadDownloadTaskFileSetActor>, public BulkLoadDownloadTaskFileSetActorState<BulkLoadDownloadTaskFileSetActor> {
															#line 4016 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
	using FastAllocated<BulkLoadDownloadTaskFileSetActor>::operator new;
	using FastAllocated<BulkLoadDownloadTaskFileSetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(321805662661396224UL, 9564364449664680960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<BulkLoadFileSet>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BulkLoadDownloadTaskFileSetActor, 0, Void >;
friend struct ActorCallback< BulkLoadDownloadTaskFileSetActor, 1, Void >;
friend struct ActorCallback< BulkLoadDownloadTaskFileSetActor, 2, Void >;
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadDownloadTaskFileSetActor(BulkLoadTransportMethod const& transportMethod,BulkLoadFileSet const& fromRemoteFileSet,std::string const& toLocalRoot,UID const& logId) 
															#line 4035 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		 : Actor<BulkLoadFileSet>(),
		   BulkLoadDownloadTaskFileSetActorState<BulkLoadDownloadTaskFileSetActor>(transportMethod, fromRemoteFileSet, toLocalRoot, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12376239698328371968UL, 12469107969741322240UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bulkLoadDownloadTaskFileSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BulkLoadDownloadTaskFileSetActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BulkLoadDownloadTaskFileSetActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BulkLoadDownloadTaskFileSetActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<BulkLoadFileSet> bulkLoadDownloadTaskFileSet( BulkLoadTransportMethod const& transportMethod, BulkLoadFileSet const& fromRemoteFileSet, std::string const& toLocalRoot, UID const& logId ) {
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<BulkLoadFileSet>(new BulkLoadDownloadTaskFileSetActor(transportMethod, fromRemoteFileSet, toLocalRoot, logId));
															#line 4070 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
}

#line 337 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

															#line 4075 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
namespace {
// This generated class is to be used only via bulkLoadDownloadTaskFileSets()
															#line 338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class BulkLoadDownloadTaskFileSetsActor>
															#line 338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class BulkLoadDownloadTaskFileSetsActorState {
															#line 4082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
															#line 338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadDownloadTaskFileSetsActorState(BulkLoadTransportMethod const& transportMethod,std::shared_ptr<BulkLoadFileSetKeyMap> const& fromRemoteFileSets,std::shared_ptr<BulkLoadFileSetKeyMap> const& localFileSets,std::string const& toLocalRoot,UID const& logId) 
															#line 338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : transportMethod(transportMethod),
															#line 338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   fromRemoteFileSets(fromRemoteFileSets),
															#line 338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   localFileSets(localFileSets),
															#line 338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   toLocalRoot(toLocalRoot),
															#line 338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId),
															#line 343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   iter(fromRemoteFileSets->begin()),
															#line 344 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   keys()
															#line 4101 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
	{
		fdb_probe_actor_create("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this));

	}
	~BulkLoadDownloadTaskFileSetsActorState() 
	{
		fdb_probe_actor_destroy("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			;
															#line 4116 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BulkLoadDownloadTaskFileSetsActorState();
		static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 355 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BulkLoadDownloadTaskFileSetsActorState(); static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->destroy(); return 0; }
															#line 4139 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		new (&static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BulkLoadDownloadTaskFileSetsActorState();
		static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!(iter != fromRemoteFileSets->end()))
															#line 4158 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 346 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		keys = iter->first;
															#line 347 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!iter->second.hasDataFile())
															#line 4166 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
			return a_body1continue1(loopDepth); // continue
		}
															#line 351 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<BulkLoadFileSet> __when_expr_0 = bulkLoadDownloadTaskFileSet(transportMethod, iter->second, toLocalRoot, logId);
															#line 351 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4174 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->actor_wait_state = 1;
															#line 351 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BulkLoadDownloadTaskFileSetsActor, 0, BulkLoadFileSet >*>(static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)));
															#line 4179 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1continue1(int loopDepth) 
	{
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		iter++;
															#line 4201 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(BulkLoadFileSet const& localFileSet,int loopDepth) 
	{
															#line 353 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		localFileSets->push_back(std::make_pair(keys, localFileSet));
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		iter++;
															#line 4212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(BulkLoadFileSet && localFileSet,int loopDepth) 
	{
															#line 353 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		localFileSets->push_back(std::make_pair(keys, localFileSet));
															#line 345 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		iter++;
															#line 4223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(BulkLoadFileSet const& localFileSet,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(localFileSet, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(BulkLoadFileSet && localFileSet,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(localFileSet), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->ActorCallback< BulkLoadDownloadTaskFileSetsActor, 0, BulkLoadFileSet >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadDownloadTaskFileSetsActor, 0, BulkLoadFileSet >*,BulkLoadFileSet const& value) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BulkLoadDownloadTaskFileSetsActor, 0, BulkLoadFileSet >*,BulkLoadFileSet && value) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BulkLoadDownloadTaskFileSetsActor, 0, BulkLoadFileSet >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadTransportMethod transportMethod;
															#line 338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::shared_ptr<BulkLoadFileSetKeyMap> fromRemoteFileSets;
															#line 338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::shared_ptr<BulkLoadFileSetKeyMap> localFileSets;
															#line 338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string toLocalRoot;
															#line 338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadFileSetKeyMap::iterator iter;
															#line 344 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	KeyRange keys;
															#line 4317 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
};
// This generated class is to be used only via bulkLoadDownloadTaskFileSets()
															#line 338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class BulkLoadDownloadTaskFileSetsActor final : public Actor<Void>, public ActorCallback< BulkLoadDownloadTaskFileSetsActor, 0, BulkLoadFileSet >, public FastAllocated<BulkLoadDownloadTaskFileSetsActor>, public BulkLoadDownloadTaskFileSetsActorState<BulkLoadDownloadTaskFileSetsActor> {
															#line 4322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
	using FastAllocated<BulkLoadDownloadTaskFileSetsActor>::operator new;
	using FastAllocated<BulkLoadDownloadTaskFileSetsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1523764545927320320UL, 5124755007829256192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BulkLoadDownloadTaskFileSetsActor, 0, BulkLoadFileSet >;
															#line 338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadDownloadTaskFileSetsActor(BulkLoadTransportMethod const& transportMethod,std::shared_ptr<BulkLoadFileSetKeyMap> const& fromRemoteFileSets,std::shared_ptr<BulkLoadFileSetKeyMap> const& localFileSets,std::string const& toLocalRoot,UID const& logId) 
															#line 4339 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		 : Actor<Void>(),
		   BulkLoadDownloadTaskFileSetsActorState<BulkLoadDownloadTaskFileSetsActor>(transportMethod, fromRemoteFileSets, localFileSets, toLocalRoot, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10639990215071692288UL, 10496662531958648576UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bulkLoadDownloadTaskFileSets");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BulkLoadDownloadTaskFileSetsActor, 0, BulkLoadFileSet >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<Void> bulkLoadDownloadTaskFileSets( BulkLoadTransportMethod const& transportMethod, std::shared_ptr<BulkLoadFileSetKeyMap> const& fromRemoteFileSets, std::shared_ptr<BulkLoadFileSetKeyMap> const& localFileSets, std::string const& toLocalRoot, UID const& logId ) {
															#line 338 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<Void>(new BulkLoadDownloadTaskFileSetsActor(transportMethod, fromRemoteFileSets, localFileSets, toLocalRoot, logId));
															#line 4372 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
}

#line 357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

															#line 4377 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
namespace {
// This generated class is to be used only via downloadManifestFile()
															#line 358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class DownloadManifestFileActor>
															#line 358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class DownloadManifestFileActorState {
															#line 4384 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
															#line 358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	DownloadManifestFileActorState(BulkLoadTransportMethod const& transportMethod,std::string const& fromRemotePath,std::string const& toLocalPath,UID const& logId) 
															#line 358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : transportMethod(transportMethod),
															#line 358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   fromRemotePath(fromRemotePath),
															#line 358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   toLocalPath(toLocalPath),
															#line 358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId),
															#line 362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   retryCount(0),
															#line 363 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   startTime(now())
															#line 4401 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
	{
		fdb_probe_actor_create("downloadManifestFile", reinterpret_cast<unsigned long>(this));

	}
	~DownloadManifestFileActorState() 
	{
		fdb_probe_actor_destroy("downloadManifestFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 364 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			;
															#line 4416 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DownloadManifestFileActorState();
		static_cast<DownloadManifestFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 403 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<DownloadManifestFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DownloadManifestFileActorState(); static_cast<DownloadManifestFileActor*>(this)->destroy(); return 0; }
															#line 4439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		new (&static_cast<DownloadManifestFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DownloadManifestFileActorState();
		static_cast<DownloadManifestFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 366 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (transportMethod == BulkLoadTransportMethod::CP)
															#line 4459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			{
															#line 367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				StrictFuture<Void> __when_expr_0 = copyBulkFile(abspath(fromRemotePath), abspath(toLocalPath), SERVER_KNOBS->BULKLOAD_FILE_BYTES_MAX);
															#line 367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (static_cast<DownloadManifestFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4465 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DownloadManifestFileActor*>(this)->actor_wait_state = 1;
															#line 367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DownloadManifestFileActor, 0, Void >*>(static_cast<DownloadManifestFileActor*>(this)));
															#line 4470 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 370 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (transportMethod == BulkLoadTransportMethod::BLOBSTORE)
															#line 4477 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
				{
															#line 372 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					StrictFuture<Void> __when_expr_2 = copyDownFile(fromRemotePath, abspath(toLocalPath));
															#line 372 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					if (static_cast<DownloadManifestFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4483 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_2.get(), loopDepth); };
					static_cast<DownloadManifestFileActor*>(this)->actor_wait_state = 3;
															#line 372 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DownloadManifestFileActor, 2, Void >*>(static_cast<DownloadManifestFileActor*>(this)));
															#line 4488 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 374 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					UNREACHABLE();
															#line 4495 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
					loopDepth = a_body1loopBody1cont5(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 386 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 4532 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			{
															#line 387 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 4536 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			}
															#line 389 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevWarnAlways, "BulkLoadDownloadManifestFileError", logId) .errorUnsuppressed(e) .detail("TransportMethod", transportMethod) .detail("FromRemotePath", fromRemotePath) .detail("ToLocalPath", toLocalPath) .detail("RetryCount", retryCount) .detail("Duration", now() - startTime);
															#line 396 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			retryCount++;
															#line 397 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (retryCount > 10)
															#line 4544 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			{
															#line 398 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 4548 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			}
															#line 400 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(5.0);
															#line 400 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<DownloadManifestFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4554 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<DownloadManifestFileActor*>(this)->actor_wait_state = 4;
															#line 400 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DownloadManifestFileActor, 3, Void >*>(static_cast<DownloadManifestFileActor*>(this)));
															#line 4559 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 376 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!fileExists(abspath(toLocalPath)))
															#line 4574 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
															#line 377 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			return a_body1loopBody1Catch1(retry(), loopDepth);
															#line 4578 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		}
															#line 379 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		TraceEvent(bulkLoadVerboseEventSev(), "BulkLoadDownloadManifestFile", logId) .detail("FromRemotePath", fromRemotePath) .detail("ToLocalPath", toLocalPath) .detail("Duration", now() - startTime) .detail("RetryCount", retryCount);
															#line 4582 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 369 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.1);
															#line 369 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<DownloadManifestFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4593 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<DownloadManifestFileActor*>(this)->actor_wait_state = 2;
															#line 369 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DownloadManifestFileActor, 1, Void >*>(static_cast<DownloadManifestFileActor*>(this)));
															#line 4598 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 369 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.1);
															#line 369 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<DownloadManifestFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4609 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<DownloadManifestFileActor*>(this)->actor_wait_state = 2;
															#line 369 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DownloadManifestFileActor, 1, Void >*>(static_cast<DownloadManifestFileActor*>(this)));
															#line 4614 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DownloadManifestFileActor*>(this)->actor_wait_state > 0) static_cast<DownloadManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadManifestFileActor*>(this)->ActorCallback< DownloadManifestFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadManifestFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DownloadManifestFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DownloadManifestFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DownloadManifestFileActor*>(this)->actor_wait_state > 0) static_cast<DownloadManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadManifestFileActor*>(this)->ActorCallback< DownloadManifestFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadManifestFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DownloadManifestFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DownloadManifestFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DownloadManifestFileActor*>(this)->actor_wait_state > 0) static_cast<DownloadManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadManifestFileActor*>(this)->ActorCallback< DownloadManifestFileActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadManifestFileActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DownloadManifestFileActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DownloadManifestFileActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DownloadManifestFileActor*>(this)->actor_wait_state > 0) static_cast<DownloadManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadManifestFileActor*>(this)->ActorCallback< DownloadManifestFileActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadManifestFileActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DownloadManifestFileActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DownloadManifestFileActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadTransportMethod transportMethod;
															#line 358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string fromRemotePath;
															#line 358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string toLocalPath;
															#line 358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 362 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int retryCount;
															#line 363 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	double startTime;
															#line 4973 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
};
// This generated class is to be used only via downloadManifestFile()
															#line 358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class DownloadManifestFileActor final : public Actor<Void>, public ActorCallback< DownloadManifestFileActor, 0, Void >, public ActorCallback< DownloadManifestFileActor, 1, Void >, public ActorCallback< DownloadManifestFileActor, 2, Void >, public ActorCallback< DownloadManifestFileActor, 3, Void >, public FastAllocated<DownloadManifestFileActor>, public DownloadManifestFileActorState<DownloadManifestFileActor> {
															#line 4978 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
	using FastAllocated<DownloadManifestFileActor>::operator new;
	using FastAllocated<DownloadManifestFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17619010634989331456UL, 4220200302504582656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DownloadManifestFileActor, 0, Void >;
friend struct ActorCallback< DownloadManifestFileActor, 1, Void >;
friend struct ActorCallback< DownloadManifestFileActor, 2, Void >;
friend struct ActorCallback< DownloadManifestFileActor, 3, Void >;
															#line 358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	DownloadManifestFileActor(BulkLoadTransportMethod const& transportMethod,std::string const& fromRemotePath,std::string const& toLocalPath,UID const& logId) 
															#line 4998 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		 : Actor<Void>(),
		   DownloadManifestFileActorState<DownloadManifestFileActor>(transportMethod, fromRemotePath, toLocalPath, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16667635394163167232UL, 11775713213349071360UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("downloadManifestFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DownloadManifestFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DownloadManifestFileActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DownloadManifestFileActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DownloadManifestFileActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<Void> downloadManifestFile( BulkLoadTransportMethod const& transportMethod, std::string const& fromRemotePath, std::string const& toLocalPath, UID const& logId ) {
															#line 358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<Void>(new DownloadManifestFileActor(transportMethod, fromRemotePath, toLocalPath, logId));
															#line 5034 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
}

#line 405 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

// Download job manifest file
// Each job has one manifest file including manifest paths of all tasks
															#line 5041 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
namespace {
// This generated class is to be used only via downloadBulkLoadJobManifestFile()
															#line 408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class DownloadBulkLoadJobManifestFileActor>
															#line 408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class DownloadBulkLoadJobManifestFileActorState {
															#line 5048 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
															#line 408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	DownloadBulkLoadJobManifestFileActorState(BulkLoadTransportMethod const& transportMethod,std::string const& localJobManifestFilePath,std::string const& remoteJobManifestFilePath,UID const& logId) 
															#line 408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : transportMethod(transportMethod),
															#line 408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   localJobManifestFilePath(localJobManifestFilePath),
															#line 408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   remoteJobManifestFilePath(remoteJobManifestFilePath),
															#line 408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId)
															#line 5061 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
	{
		fdb_probe_actor_create("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this));

	}
	~DownloadBulkLoadJobManifestFileActorState() 
	{
		fdb_probe_actor_destroy("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 412 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_0 = downloadManifestFile(transportMethod, remoteJobManifestFilePath, localJobManifestFilePath, logId);
															#line 412 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5078 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->actor_wait_state = 1;
															#line 412 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DownloadBulkLoadJobManifestFileActor, 0, Void >*>(static_cast<DownloadBulkLoadJobManifestFileActor*>(this)));
															#line 5083 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DownloadBulkLoadJobManifestFileActorState();
		static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 413 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DownloadBulkLoadJobManifestFileActorState(); static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->destroy(); return 0; }
															#line 5106 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		new (&static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DownloadBulkLoadJobManifestFileActorState();
		static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 413 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DownloadBulkLoadJobManifestFileActorState(); static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->destroy(); return 0; }
															#line 5118 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		new (&static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DownloadBulkLoadJobManifestFileActorState();
		static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->actor_wait_state > 0) static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->ActorCallback< DownloadBulkLoadJobManifestFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadBulkLoadJobManifestFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DownloadBulkLoadJobManifestFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DownloadBulkLoadJobManifestFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadTransportMethod transportMethod;
															#line 408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string localJobManifestFilePath;
															#line 408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string remoteJobManifestFilePath;
															#line 408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 5209 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
};
// This generated class is to be used only via downloadBulkLoadJobManifestFile()
															#line 408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class DownloadBulkLoadJobManifestFileActor final : public Actor<Void>, public ActorCallback< DownloadBulkLoadJobManifestFileActor, 0, Void >, public FastAllocated<DownloadBulkLoadJobManifestFileActor>, public DownloadBulkLoadJobManifestFileActorState<DownloadBulkLoadJobManifestFileActor> {
															#line 5214 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
	using FastAllocated<DownloadBulkLoadJobManifestFileActor>::operator new;
	using FastAllocated<DownloadBulkLoadJobManifestFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17533081586783056384UL, 6918990013344356352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DownloadBulkLoadJobManifestFileActor, 0, Void >;
															#line 408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	DownloadBulkLoadJobManifestFileActor(BulkLoadTransportMethod const& transportMethod,std::string const& localJobManifestFilePath,std::string const& remoteJobManifestFilePath,UID const& logId) 
															#line 5231 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		 : Actor<Void>(),
		   DownloadBulkLoadJobManifestFileActorState<DownloadBulkLoadJobManifestFileActor>(transportMethod, localJobManifestFilePath, remoteJobManifestFilePath, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12086591436448585472UL, 14493210584460522496UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("downloadBulkLoadJobManifestFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DownloadBulkLoadJobManifestFileActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<Void> downloadBulkLoadJobManifestFile( BulkLoadTransportMethod const& transportMethod, std::string const& localJobManifestFilePath, std::string const& remoteJobManifestFilePath, UID const& logId ) {
															#line 408 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<Void>(new DownloadBulkLoadJobManifestFileActor(transportMethod, localJobManifestFilePath, remoteJobManifestFilePath, logId));
															#line 5264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
}

#line 415 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

// Get manifest within the input range.
// manifestEntryMap is the output
															#line 5271 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
namespace {
// This generated class is to be used only via getBulkLoadJobFileManifestEntryFromJobManifestFile()
															#line 418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class GetBulkLoadJobFileManifestEntryFromJobManifestFileActor>
															#line 418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class GetBulkLoadJobFileManifestEntryFromJobManifestFileActorState {
															#line 5278 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
															#line 418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	GetBulkLoadJobFileManifestEntryFromJobManifestFileActorState(std::string const& localJobManifestFilePath,KeyRange const& range,UID const& logId,std::shared_ptr<BulkLoadManifestFileMap> const& manifestEntryMap) 
															#line 418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : localJobManifestFilePath(localJobManifestFilePath),
															#line 418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   range(range),
															#line 418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId),
															#line 418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   manifestEntryMap(manifestEntryMap),
															#line 423 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   startTime(now())
															#line 5293 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
	{
		fdb_probe_actor_create("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this));

	}
	~GetBulkLoadJobFileManifestEntryFromJobManifestFileActorState() 
	{
		fdb_probe_actor_destroy("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 424 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			ASSERT(fileExists(abspath(localJobManifestFilePath)));
															#line 425 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			ASSERT(manifestEntryMap->empty());
															#line 427 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( abspath(localJobManifestFilePath), IAsyncFile::OPEN_NO_AIO | IAsyncFile::OPEN_READONLY | IAsyncFile::OPEN_UNCACHED, 0644);
															#line 427 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5314 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 1;
															#line 427 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 0, Reference<IAsyncFile> >*>(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)));
															#line 5319 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBulkLoadJobFileManifestEntryFromJobManifestFileActorState();
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 432 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = file->size();
															#line 432 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5344 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 2;
															#line 432 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 1, int64_t >*>(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)));
															#line 5349 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __file,int loopDepth) 
	{
															#line 427 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		file = __file;
															#line 5358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __file,int loopDepth) 
	{
		file = std::move(__file);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 433 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (fileSize > SERVER_KNOBS->BULKLOAD_FILE_BYTES_MAX)
															#line 5437 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
															#line 434 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevError, "ManifestFileTooBig", logId) .detail("FileSize", fileSize) .detail("MaxSize", SERVER_KNOBS->BULKLOAD_FILE_BYTES_MAX);
															#line 437 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			return a_body1Catch1(file_too_large(), loopDepth);
															#line 5443 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		}
															#line 440 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		chunkSize = 64 * 1024;
															#line 441 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		buffer = std::string();
															#line 442 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		offset = 0;
															#line 443 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		leftover = std::string();
															#line 444 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		headerProcessed = false;
															#line 5455 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		try {
															#line 447 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			;
															#line 5459 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = a_body1cont2loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(int64_t const& __fileSize,int loopDepth) 
	{
															#line 432 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		fileSize = __fileSize;
															#line 5474 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t && __fileSize,int loopDepth) 
	{
		fileSize = std::move(__fileSize);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 517 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetBulkLoadJobFileManifestEntryFromJobManifestFileActorState(); static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->destroy(); return 0; }
															#line 5553 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		new (&static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetBulkLoadJobFileManifestEntryFromJobManifestFileActorState();
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 509 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevWarnAlways, "BulkLoadJobFileManifestEntryError", logId) .errorUnsuppressed(e) .detail("LocalJobManifestFilePath", localJobManifestFilePath) .detail("Duration", now() - startTime) .detail("Offset", offset);
															#line 514 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 5568 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 495 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!leftover.empty())
															#line 5582 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
															#line 496 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (!headerProcessed)
															#line 5586 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			{
															#line 498 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				BulkLoadJobManifestFileHeader header(leftover);
															#line 5590 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			}
			else
			{
															#line 500 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				BulkLoadJobFileManifestEntry manifestEntry(leftover);
															#line 501 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				KeyRange overlappingRange = range & manifestEntry.getRange();
															#line 502 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (!overlappingRange.empty())
															#line 5600 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
				{
															#line 503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					auto returnV = manifestEntryMap->insert({ manifestEntry.getBeginKey(), manifestEntry });
															#line 504 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					ASSERT(returnV.second);
															#line 5606 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
				}
			}
		}
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 447 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!(offset < fileSize))
															#line 5625 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 448 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		bytesToRead = std::min(chunkSize, fileSize - offset);
															#line 449 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		buffer.resize(bytesToRead);
															#line 451 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<int> __when_expr_2 = file->read(&buffer[0], bytesToRead, offset);
															#line 451 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5637 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 3;
															#line 451 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 2, int >*>(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)));
															#line 5642 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 452 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (bytesRead != bytesToRead)
															#line 5664 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
															#line 453 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevError, "ReadFileError", logId) .detail("BytesRead", bytesRead) .detail("BytesExpected", bytesToRead);
															#line 456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			return a_body1cont2Catch1(io_error(), std::max(0, loopDepth - 1));
															#line 5670 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		}
															#line 460 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		chunk = leftover + buffer;
															#line 461 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		pos = 0;
															#line 462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		lineStart = 0;
															#line 464 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		;
															#line 5680 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(int const& __bytesRead,int loopDepth) 
	{
															#line 451 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		bytesRead = __bytesRead;
															#line 5689 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(int && __bytesRead,int loopDepth) 
	{
		bytesRead = std::move(__bytesRead);
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 2, int >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 2, int >*,int const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 2, int >*,int && value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 2, int >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1cont3(int loopDepth) 
	{
															#line 489 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		leftover = chunk.substr(lineStart);
															#line 490 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		offset += bytesRead;
															#line 491 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_4 = yield();
															#line 491 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5774 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 5;
															#line 491 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 4, Void >*>(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)));
															#line 5779 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 464 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!((pos = chunk.find(bulkLoadJobManifestLineTerminator, lineStart)) != std::string::npos))
															#line 5795 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
			return a_body1cont2loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 465 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		line = chunk.substr(lineStart, pos - lineStart);
															#line 466 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!line.empty())
															#line 5803 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
															#line 467 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (!headerProcessed)
															#line 5807 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			{
															#line 469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				BulkLoadJobManifestFileHeader header(line);
															#line 470 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				headerProcessed = true;
															#line 5813 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			}
			else
			{
															#line 472 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				BulkLoadJobFileManifestEntry manifestEntry(line);
															#line 473 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				KeyRange overlappingRange = range & manifestEntry.getRange();
															#line 474 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (!overlappingRange.empty())
															#line 5823 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
				{
															#line 475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					auto returnV = manifestEntryMap->insert({ manifestEntry.getBeginKey(), manifestEntry });
															#line 476 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					ASSERT(returnV.second);
															#line 5829 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
				}
			}
		}
															#line 480 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		lineStart = pos + 1;
															#line 483 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (manifestEntryMap->size() % 100 == 0)
															#line 5837 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
															#line 484 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_3 = yield();
															#line 484 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5843 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont2loopBody1cont1loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 4;
															#line 484 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 3, Void >*>(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)));
															#line 5848 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopBody1cont5(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string localJobManifestFilePath;
															#line 418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	KeyRange range;
															#line 418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::shared_ptr<BulkLoadManifestFileMap> manifestEntryMap;
															#line 423 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	double startTime;
															#line 427 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	Reference<IAsyncFile> file;
															#line 432 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t fileSize;
															#line 440 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t chunkSize;
															#line 441 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string buffer;
															#line 442 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t offset;
															#line 443 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string leftover;
															#line 444 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	bool headerProcessed;
															#line 448 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t bytesToRead;
															#line 451 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int bytesRead;
															#line 460 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string chunk;
															#line 461 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	size_t pos;
															#line 462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	size_t lineStart;
															#line 465 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string line;
															#line 6100 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
};
// This generated class is to be used only via getBulkLoadJobFileManifestEntryFromJobManifestFile()
															#line 418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class GetBulkLoadJobFileManifestEntryFromJobManifestFileActor final : public Actor<Void>, public ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 0, Reference<IAsyncFile> >, public ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 1, int64_t >, public ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 2, int >, public ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 3, Void >, public ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 4, Void >, public FastAllocated<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor>, public GetBulkLoadJobFileManifestEntryFromJobManifestFileActorState<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor> {
															#line 6105 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
	using FastAllocated<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor>::operator new;
	using FastAllocated<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(348094596662747136UL, 17704955159962217984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 1, int64_t >;
friend struct ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 2, int >;
friend struct ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 3, Void >;
friend struct ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 4, Void >;
															#line 418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	GetBulkLoadJobFileManifestEntryFromJobManifestFileActor(std::string const& localJobManifestFilePath,KeyRange const& range,UID const& logId,std::shared_ptr<BulkLoadManifestFileMap> const& manifestEntryMap) 
															#line 6126 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		 : Actor<Void>(),
		   GetBulkLoadJobFileManifestEntryFromJobManifestFileActorState<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor>(localJobManifestFilePath, range, logId, manifestEntryMap),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1022494047704527360UL, 5796357985251372288UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBulkLoadJobFileManifestEntryFromJobManifestFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 2, int >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<Void> getBulkLoadJobFileManifestEntryFromJobManifestFile( std::string const& localJobManifestFilePath, KeyRange const& range, UID const& logId, std::shared_ptr<BulkLoadManifestFileMap> const& manifestEntryMap ) {
															#line 418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<Void>(new GetBulkLoadJobFileManifestEntryFromJobManifestFileActor(localJobManifestFilePath, range, logId, manifestEntryMap));
															#line 6163 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
}

#line 519 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

															#line 6168 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
namespace {
// This generated class is to be used only via getBulkLoadManifestMetadataFromEntry()
															#line 520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class GetBulkLoadManifestMetadataFromEntryActor>
															#line 520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class GetBulkLoadManifestMetadataFromEntryActorState {
															#line 6175 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
															#line 520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	GetBulkLoadManifestMetadataFromEntryActorState(std::vector<BulkLoadJobFileManifestEntry> const& manifestEntries,std::string const& manifestLocalTempFolder,BulkLoadTransportMethod const& transportMethod,std::string const& jobRoot,UID const& logId) 
															#line 520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : manifestEntries(manifestEntries),
															#line 520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   manifestLocalTempFolder(manifestLocalTempFolder),
															#line 520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   transportMethod(transportMethod),
															#line 520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   jobRoot(jobRoot),
															#line 520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId),
															#line 526 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   manifests(SERVER_KNOBS->MANIFEST_COUNT_MAX_PER_BULKLOAD_TASK),
															#line 527 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   i(0)
															#line 6194 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
	{
		fdb_probe_actor_create("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this));

	}
	~GetBulkLoadManifestMetadataFromEntryActorState() 
	{
		fdb_probe_actor_destroy("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 528 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			;
															#line 6209 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBulkLoadManifestMetadataFromEntryActorState();
		static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 541 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->SAV<BulkLoadManifestSet>::futures) { (void)(manifests); this->~GetBulkLoadManifestMetadataFromEntryActorState(); static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->destroy(); return 0; }
															#line 6232 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		new (&static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->SAV< BulkLoadManifestSet >::value()) BulkLoadManifestSet(std::move(manifests)); // state_var_RVO
		this->~GetBulkLoadManifestMetadataFromEntryActorState();
		static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 528 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!(i < manifestEntries.size()))
															#line 6251 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 529 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		remoteManifestFilePath = appendToPath(jobRoot, manifestEntries[i].getManifestRelativePath());
															#line 530 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		localManifestFilePath = joinPath(manifestLocalTempFolder, deterministicRandom()->randomUniqueID().toString() + "-" + basename(getPath(remoteManifestFilePath)));
															#line 533 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_0 = downloadManifestFile(transportMethod, remoteManifestFilePath, localManifestFilePath, logId);
															#line 533 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6263 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state = 1;
															#line 533 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 0, Void >*>(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)));
															#line 6268 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 534 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		manifestRawString = std::make_shared<std::string>();
															#line 535 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_1 = readBulkFileBytes( abspath(localManifestFilePath), SERVER_KNOBS->BULKLOAD_FILE_BYTES_MAX, manifestRawString);
															#line 535 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6294 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state = 2;
															#line 535 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 1, Void >*>(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)));
															#line 6299 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 534 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		manifestRawString = std::make_shared<std::string>();
															#line 535 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_1 = readBulkFileBytes( abspath(localManifestFilePath), SERVER_KNOBS->BULKLOAD_FILE_BYTES_MAX, manifestRawString);
															#line 535 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6312 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state = 2;
															#line 535 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 1, Void >*>(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)));
															#line 6317 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 537 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		ASSERT(!manifestRawString->empty());
															#line 538 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		BulkLoadManifest manifest(*manifestRawString);
															#line 539 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		ASSERT(manifests.addManifest(manifest));
															#line 528 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		i++;
															#line 6407 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 537 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		ASSERT(!manifestRawString->empty());
															#line 538 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		BulkLoadManifest manifest(*manifestRawString);
															#line 539 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		ASSERT(manifests.addManifest(manifest));
															#line 528 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		i++;
															#line 6422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::vector<BulkLoadJobFileManifestEntry> manifestEntries;
															#line 520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string manifestLocalTempFolder;
															#line 520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadTransportMethod transportMethod;
															#line 520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string jobRoot;
															#line 520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 526 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadManifestSet manifests;
															#line 527 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int i;
															#line 529 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string remoteManifestFilePath;
															#line 530 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string localManifestFilePath;
															#line 534 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::shared_ptr<std::string> manifestRawString;
															#line 6522 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
};
// This generated class is to be used only via getBulkLoadManifestMetadataFromEntry()
															#line 520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class GetBulkLoadManifestMetadataFromEntryActor final : public Actor<BulkLoadManifestSet>, public ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 0, Void >, public ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 1, Void >, public FastAllocated<GetBulkLoadManifestMetadataFromEntryActor>, public GetBulkLoadManifestMetadataFromEntryActorState<GetBulkLoadManifestMetadataFromEntryActor> {
															#line 6527 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
public:
	using FastAllocated<GetBulkLoadManifestMetadataFromEntryActor>::operator new;
	using FastAllocated<GetBulkLoadManifestMetadataFromEntryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14996833820947507968UL, 7301549694365153792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<BulkLoadManifestSet>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 0, Void >;
friend struct ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 1, Void >;
															#line 520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	GetBulkLoadManifestMetadataFromEntryActor(std::vector<BulkLoadJobFileManifestEntry> const& manifestEntries,std::string const& manifestLocalTempFolder,BulkLoadTransportMethod const& transportMethod,std::string const& jobRoot,UID const& logId) 
															#line 6545 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
		 : Actor<BulkLoadManifestSet>(),
		   GetBulkLoadManifestMetadataFromEntryActorState<GetBulkLoadManifestMetadataFromEntryActor>(manifestEntries, manifestLocalTempFolder, transportMethod, jobRoot, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7741929640425726208UL, 7372106929495094016UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBulkLoadManifestMetadataFromEntry");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<BulkLoadManifestSet> getBulkLoadManifestMetadataFromEntry( std::vector<BulkLoadJobFileManifestEntry> const& manifestEntries, std::string const& manifestLocalTempFolder, BulkLoadTransportMethod const& transportMethod, std::string const& jobRoot, UID const& logId ) {
															#line 520 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<BulkLoadManifestSet>(new GetBulkLoadManifestMetadataFromEntryActor(manifestEntries, manifestLocalTempFolder, transportMethod, jobRoot, logId));
															#line 6579 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp"
}

#line 543 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
