#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
/*
 * BlobGranuleValidation.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/BlobGranuleValidation.actor.h"
#include "fdbclient/FDBOptions.h"
#include "fdbserver/Knobs.h"
#include "fdbclient/BlobGranuleRequest.actor.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbrpc/simulator.h"
#include "flow/actorcompiler.h" // has to be last include

															#line 31 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
namespace {
// This generated class is to be used only via readFromFDB()
															#line 29 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
template <class ReadFromFDBActor>
															#line 29 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
class ReadFromFDBActorState {
															#line 38 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
public:
															#line 29 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	ReadFromFDBActorState(Database const& cx,KeyRange const& range) 
															#line 29 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
															#line 29 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		 : cx(cx),
															#line 29 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   range(range),
															#line 30 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   first(true),
															#line 31 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   v(),
															#line 32 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   out(),
															#line 33 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   tr(cx),
															#line 34 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   currentRange(range)
															#line 57 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
	{
		fdb_probe_actor_create("readFromFDB", reinterpret_cast<unsigned long>(this));

	}
	~ReadFromFDBActorState() 
	{
		fdb_probe_actor_destroy("readFromFDB", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 35 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			;
															#line 72 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadFromFDBActorState();
		static_cast<ReadFromFDBActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 65 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (!static_cast<ReadFromFDBActor*>(this)->SAV<std::pair<RangeResult, Version>>::futures) { (void)(std::pair(out, v)); this->~ReadFromFDBActorState(); static_cast<ReadFromFDBActor*>(this)->destroy(); return 0; }
															#line 95 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		new (&static_cast<ReadFromFDBActor*>(this)->SAV< std::pair<RangeResult, Version> >::value()) std::pair<RangeResult, Version>(std::pair(out, v));
		this->~ReadFromFDBActorState();
		static_cast<ReadFromFDBActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 36 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 38 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SERVER_SIDE_CACHE_DISABLE);
															#line 116 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		try {
															#line 40 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(currentRange, CLIENT_KNOBS->TOO_MANY);
															#line 40 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<ReadFromFDBActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 122 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadFromFDBActor*>(this)->actor_wait_state = 1;
															#line 40 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadFromFDBActor, 0, RangeResult >*>(static_cast<ReadFromFDBActor*>(this)));
															#line 127 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 62 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 62 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<ReadFromFDBActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 164 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ReadFromFDBActor*>(this)->actor_wait_state = 3;
															#line 62 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadFromFDBActor, 2, Void >*>(static_cast<ReadFromFDBActor*>(this)));
															#line 169 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 41 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		StrictFuture<Version> __when_expr_1 = tr.getReadVersion();
															#line 41 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (static_cast<ReadFromFDBActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 186 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadFromFDBActor*>(this)->actor_wait_state = 2;
															#line 41 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadFromFDBActor, 1, Version >*>(static_cast<ReadFromFDBActor*>(this)));
															#line 191 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __r,int loopDepth) 
	{
															#line 40 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		r = __r;
															#line 200 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __r,int loopDepth) 
	{
		r = std::move(__r);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadFromFDBActor*>(this)->actor_wait_state > 0) static_cast<ReadFromFDBActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFromFDBActor*>(this)->ActorCallback< ReadFromFDBActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFromFDBActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("readFromFDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromFDB", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadFromFDBActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("readFromFDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromFDB", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadFromFDBActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("readFromFDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromFDB", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Version const& grv,int loopDepth) 
	{
															#line 43 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (first)
															#line 279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 44 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			v = grv;
															#line 45 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			first = false;
															#line 285 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		}
		else
		{
															#line 46 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (v != grv)
															#line 291 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 48 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				first = true;
															#line 49 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				out = RangeResult();
															#line 50 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				currentRange = range;
															#line 51 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				tr.reset();
															#line 301 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				return a_body1loopHead1(loopDepth); // continue
			}
		}
															#line 54 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		out.arena().dependsOn(r.arena());
															#line 55 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		out.append(out.arena(), r.begin(), r.size());
															#line 56 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (r.more)
															#line 311 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 57 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			currentRange = KeyRangeRef(keyAfter(r.back().key), currentRange.end);
															#line 315 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Version && grv,int loopDepth) 
	{
															#line 43 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (first)
															#line 329 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 44 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			v = grv;
															#line 45 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			first = false;
															#line 335 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		}
		else
		{
															#line 46 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (v != grv)
															#line 341 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 48 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				first = true;
															#line 49 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				out = RangeResult();
															#line 50 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				currentRange = range;
															#line 51 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				tr.reset();
															#line 351 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				return a_body1loopHead1(loopDepth); // continue
			}
		}
															#line 54 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		out.arena().dependsOn(r.arena());
															#line 55 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		out.append(out.arena(), r.begin(), r.size());
															#line 56 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (r.more)
															#line 361 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 57 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			currentRange = KeyRangeRef(keyAfter(r.back().key), currentRange.end);
															#line 365 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Version const& grv,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(grv, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Version && grv,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(grv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadFromFDBActor*>(this)->actor_wait_state > 0) static_cast<ReadFromFDBActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFromFDBActor*>(this)->ActorCallback< ReadFromFDBActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFromFDBActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("readFromFDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromFDB", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadFromFDBActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("readFromFDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromFDB", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadFromFDBActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("readFromFDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromFDB", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReadFromFDBActor*>(this)->actor_wait_state > 0) static_cast<ReadFromFDBActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFromFDBActor*>(this)->ActorCallback< ReadFromFDBActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFromFDBActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readFromFDB", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromFDB", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadFromFDBActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readFromFDB", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromFDB", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadFromFDBActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readFromFDB", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromFDB", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 29 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Database cx;
															#line 29 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	KeyRange range;
															#line 30 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	bool first;
															#line 31 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Version v;
															#line 32 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	RangeResult out;
															#line 33 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Transaction tr;
															#line 34 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	KeyRange currentRange;
															#line 40 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	RangeResult r;
															#line 566 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
};
// This generated class is to be used only via readFromFDB()
															#line 29 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
class ReadFromFDBActor final : public Actor<std::pair<RangeResult, Version>>, public ActorCallback< ReadFromFDBActor, 0, RangeResult >, public ActorCallback< ReadFromFDBActor, 1, Version >, public ActorCallback< ReadFromFDBActor, 2, Void >, public FastAllocated<ReadFromFDBActor>, public ReadFromFDBActorState<ReadFromFDBActor> {
															#line 571 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
public:
	using FastAllocated<ReadFromFDBActor>::operator new;
	using FastAllocated<ReadFromFDBActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3967318736455564032UL, 4822467923589254144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<RangeResult, Version>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadFromFDBActor, 0, RangeResult >;
friend struct ActorCallback< ReadFromFDBActor, 1, Version >;
friend struct ActorCallback< ReadFromFDBActor, 2, Void >;
															#line 29 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	ReadFromFDBActor(Database const& cx,KeyRange const& range) 
															#line 590 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		 : Actor<std::pair<RangeResult, Version>>(),
		   ReadFromFDBActorState<ReadFromFDBActor>(cx, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readFromFDB", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11959075558424299008UL, 5818835875544202496UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readFromFDB");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readFromFDB", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadFromFDBActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadFromFDBActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReadFromFDBActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 29 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
[[nodiscard]] Future<std::pair<RangeResult, Version>> readFromFDB( Database const& cx, KeyRange const& range ) {
															#line 29 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	return Future<std::pair<RangeResult, Version>>(new ReadFromFDBActor(cx, range));
															#line 625 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
}

#line 67 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"

// FIXME: typedef this pair type and/or chunk list
															#line 631 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
namespace {
// This generated class is to be used only via readFromBlob()
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
template <class ReadFromBlobActor>
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
class ReadFromBlobActorState {
															#line 638 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
public:
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	ReadFromBlobActorState(Database const& cx,Reference<BlobConnectionProvider> const& bstore,KeyRange const& range,Version const& beginVersion,Version const& readVersion,Optional<Reference<Tenant>> const& tenant) 
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		 : cx(cx),
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   bstore(bstore),
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   range(range),
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   beginVersion(beginVersion),
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   readVersion(readVersion),
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   tenant(tenant),
															#line 76 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   out(),
															#line 77 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   chunks(),
															#line 78 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   tr(cx, tenant)
															#line 661 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
	{
		fdb_probe_actor_create("readFromBlob", reinterpret_cast<unsigned long>(this));

	}
	~ReadFromBlobActorState() 
	{
		fdb_probe_actor_destroy("readFromBlob", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 80 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			;
															#line 676 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadFromBlobActorState();
		static_cast<ReadFromBlobActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 91 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		RangeForbody1cont1Iterator0 = std::begin(chunks);
															#line 699 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 82 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Standalone<VectorRef<BlobGranuleChunkRef>>> __when_expr_0 = tr.readBlobGranules(range, beginVersion, readVersion);
															#line 82 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<ReadFromBlobActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 718 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadFromBlobActor*>(this)->actor_wait_state = 1;
															#line 82 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadFromBlobActor, 0, Standalone<VectorRef<BlobGranuleChunkRef>> >*>(static_cast<ReadFromBlobActor*>(this)));
															#line 723 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 87 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 87 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<ReadFromBlobActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 760 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadFromBlobActor*>(this)->actor_wait_state = 2;
															#line 87 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadFromBlobActor, 1, Void >*>(static_cast<ReadFromBlobActor*>(this)));
															#line 765 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<VectorRef<BlobGranuleChunkRef>> const& chunks_,int loopDepth) 
	{
															#line 84 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		chunks = chunks_;
															#line 780 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<VectorRef<BlobGranuleChunkRef>> && chunks_,int loopDepth) 
	{
															#line 84 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		chunks = chunks_;
															#line 789 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<BlobGranuleChunkRef>> const& chunks_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(chunks_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<BlobGranuleChunkRef>> && chunks_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(chunks_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadFromBlobActor*>(this)->actor_wait_state > 0) static_cast<ReadFromBlobActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFromBlobActor*>(this)->ActorCallback< ReadFromBlobActor, 0, Standalone<VectorRef<BlobGranuleChunkRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFromBlobActor, 0, Standalone<VectorRef<BlobGranuleChunkRef>> >*,Standalone<VectorRef<BlobGranuleChunkRef>> const& value) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadFromBlobActor, 0, Standalone<VectorRef<BlobGranuleChunkRef>> >*,Standalone<VectorRef<BlobGranuleChunkRef>> && value) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadFromBlobActor, 0, Standalone<VectorRef<BlobGranuleChunkRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadFromBlobActor*>(this)->actor_wait_state > 0) static_cast<ReadFromBlobActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFromBlobActor*>(this)->ActorCallback< ReadFromBlobActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFromBlobActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadFromBlobActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadFromBlobActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 97 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (!static_cast<ReadFromBlobActor*>(this)->SAV<std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>>::futures) { (void)(std::pair(out, chunks)); this->~ReadFromBlobActorState(); static_cast<ReadFromBlobActor*>(this)->destroy(); return 0; }
															#line 960 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		new (&static_cast<ReadFromBlobActor*>(this)->SAV< std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >::value()) std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>(std::pair(out, chunks));
		this->~ReadFromBlobActorState();
		static_cast<ReadFromBlobActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 91 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (!(RangeForbody1cont1Iterator0 != std::end(chunks)))
															#line 979 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 91 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		const BlobGranuleChunkRef& chunk = *RangeForbody1cont1Iterator0;
															#line 985 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 92 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			ASSERT(chunk.tenantPrefix.present() == tenant.present());
															#line 93 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<RangeResult> __when_expr_2 = readBlobGranule(chunk, range, beginVersion, readVersion, bstore);
															#line 93 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<ReadFromBlobActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 993 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ReadFromBlobActor*>(this)->actor_wait_state = 3;
															#line 93 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadFromBlobActor, 2, RangeResult >*>(static_cast<ReadFromBlobActor*>(this)));
															#line 998 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 91 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		++RangeForbody1cont1Iterator0;
															#line 1021 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(RangeResult const& chunkRows,int loopDepth) 
	{
															#line 94 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		out.arena().dependsOn(chunkRows.arena());
															#line 95 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		out.append(out.arena(), chunkRows.begin(), chunkRows.size());
															#line 1032 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(RangeResult && chunkRows,int loopDepth) 
	{
															#line 94 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		out.arena().dependsOn(chunkRows.arena());
															#line 95 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		out.append(out.arena(), chunkRows.begin(), chunkRows.size());
															#line 1043 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(RangeResult const& chunkRows,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(chunkRows, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(RangeResult && chunkRows,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(chunkRows), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReadFromBlobActor*>(this)->actor_wait_state > 0) static_cast<ReadFromBlobActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFromBlobActor*>(this)->ActorCallback< ReadFromBlobActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFromBlobActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadFromBlobActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadFromBlobActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Database cx;
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Reference<BlobConnectionProvider> bstore;
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	KeyRange range;
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Version beginVersion;
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Version readVersion;
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Optional<Reference<Tenant>> tenant;
															#line 76 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	RangeResult out;
															#line 77 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Standalone<VectorRef<BlobGranuleChunkRef>> chunks;
															#line 78 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Transaction tr;
															#line 91 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	decltype(std::begin(std::declval<Standalone<VectorRef<BlobGranuleChunkRef>>>())) RangeForbody1cont1Iterator0;
															#line 1143 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
};
// This generated class is to be used only via readFromBlob()
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
class ReadFromBlobActor final : public Actor<std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>>, public ActorCallback< ReadFromBlobActor, 0, Standalone<VectorRef<BlobGranuleChunkRef>> >, public ActorCallback< ReadFromBlobActor, 1, Void >, public ActorCallback< ReadFromBlobActor, 2, RangeResult >, public FastAllocated<ReadFromBlobActor>, public ReadFromBlobActorState<ReadFromBlobActor> {
															#line 1148 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
public:
	using FastAllocated<ReadFromBlobActor>::operator new;
	using FastAllocated<ReadFromBlobActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10921907594891586560UL, 2056899772914541824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadFromBlobActor, 0, Standalone<VectorRef<BlobGranuleChunkRef>> >;
friend struct ActorCallback< ReadFromBlobActor, 1, Void >;
friend struct ActorCallback< ReadFromBlobActor, 2, RangeResult >;
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	ReadFromBlobActor(Database const& cx,Reference<BlobConnectionProvider> const& bstore,KeyRange const& range,Version const& beginVersion,Version const& readVersion,Optional<Reference<Tenant>> const& tenant) 
															#line 1167 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		 : Actor<std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>>(),
		   ReadFromBlobActorState<ReadFromBlobActor>(cx, bstore, range, beginVersion, readVersion, tenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6246917362517798400UL, 3517552783028558336UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readFromBlob");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadFromBlobActor, 0, Standalone<VectorRef<BlobGranuleChunkRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadFromBlobActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReadFromBlobActor, 2, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
[[nodiscard]] Future<std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>> readFromBlob( Database const& cx, Reference<BlobConnectionProvider> const& bstore, KeyRange const& range, Version const& beginVersion, Version const& readVersion, Optional<Reference<Tenant>> const& tenant ) {
															#line 69 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	return Future<std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>>(new ReadFromBlobActor(cx, bstore, range, beginVersion, readVersion, tenant));
															#line 1202 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
}

#line 99 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"

bool compareFDBAndBlob(RangeResult fdb,
                       std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> blob,
                       KeyRange range,
                       Version v,
                       bool debug) {
	bool correct = fdb == blob.first;
	if (!correct) {
		TraceEvent ev(SevError, "GranuleMismatch");
		ev.detail("RangeStart", range.begin)
		    .detail("RangeEnd", range.end)
		    .detail("Version", v)
		    .detail("FDBSize", fdb.size())
		    .detail("BlobSize", blob.first.size());

		if (debug) {
			fmt::print("\nMismatch for [{0} - {1}) @ {2}. F({3}) B({4}):\n",
			           range.begin.printable(),
			           range.end.printable(),
			           v,
			           fdb.size(),
			           blob.first.size());

			Optional<KeyValueRef> lastCorrect;
			for (int i = 0; i < std::max(fdb.size(), blob.first.size()); i++) {
				if (i >= fdb.size() || i >= blob.first.size() || fdb[i] != blob.first[i]) {
					TraceEvent ev("GranuleMismatchInfo");
					ev.detail("Idx", i);
					printf("  Found mismatch at %d.\n", i);
					if (lastCorrect.present()) {
						printf("    last correct: %s=%s\n",
						       lastCorrect.get().key.printable().c_str(),
						       lastCorrect.get().value.printable().c_str());
						ev.detail("LastCorrectKey", lastCorrect.get().key);
					}
					if (i < fdb.size()) {
						printf("    FDB: %s=%s\n", fdb[i].key.printable().c_str(), fdb[i].value.printable().c_str());
						ev.detail("FDBKey", fdb[i].key);
					} else {
						printf("    FDB: <missing>\n");
						ev.detail("FDBKey", "Missing");
					}
					if (i < blob.first.size()) {
						printf("    BLB: %s=%s\n",
						       blob.first[i].key.printable().c_str(),
						       blob.first[i].value.printable().c_str());
						ev.detail("BlobKey", blob.first[i].key);
					} else {
						printf("    BLB: <missing>\n");
						ev.detail("BlobKey", "Missing");
					}
					if (i < fdb.size() && i < blob.first.size() && fdb[i].key == blob.first[i].key) {
						// value mismatch
						ev.detail("FDBValue", fdb[i].value).detail("BlobValue", blob.first[i].value);
					}
					printf("\n");
					break;
				}
				if (i < fdb.size()) {
					lastCorrect = fdb[i];
				} else {
					lastCorrect = blob.first[i];
				}
			}

			printGranuleChunks(blob.second);
		}
	}
	return correct;
}

void printGranuleChunks(const Standalone<VectorRef<BlobGranuleChunkRef>>& chunks) {
	printf("Chunks:\n");
	for (auto& chunk : chunks) {
		printf("[%s - %s)\n", chunk.keyRange.begin.printable().c_str(), chunk.keyRange.end.printable().c_str());

		printf("  SnapshotFile:\n    %s\n",
		       chunk.snapshotFile.present() ? chunk.snapshotFile.get().toString().c_str() : "<none>");
		printf("  DeltaFiles:\n");
		for (auto& df : chunk.deltaFiles) {
			printf("    %s\n", df.toString().c_str());
		}
		printf("  Deltas: (%d)", chunk.newDeltas.size());
		if (chunk.newDeltas.size() > 0) {
			fmt::print(" with version [{0} - {1}]",
			           chunk.newDeltas[0].version,
			           chunk.newDeltas[chunk.newDeltas.size() - 1].version);
		}
		fmt::print("  IncludedVersion: {}\n", chunk.includedVersion);
	}
	printf("\n");
}

															#line 1299 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
namespace {
// This generated class is to be used only via clearAndAwaitMerge()
															#line 192 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
template <class ClearAndAwaitMergeActor>
															#line 192 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
class ClearAndAwaitMergeActorState {
															#line 1306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
public:
															#line 192 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	ClearAndAwaitMergeActorState(Database const& cx,KeyRange const& range) 
															#line 192 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
															#line 192 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		 : cx(cx),
															#line 192 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   range(range),
															#line 194 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   tr(cx),
															#line 195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   reClearCount(1),
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   reClearInterval(1)
															#line 1321 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
	{
		fdb_probe_actor_create("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this));

	}
	~ClearAndAwaitMergeActorState() 
	{
		fdb_probe_actor_destroy("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 197 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			;
															#line 1336 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearAndAwaitMergeActorState();
		static_cast<ClearAndAwaitMergeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 199 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRangeRef>>> __when_expr_0 = tr.getBlobGranuleRanges(range, 2);
															#line 199 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<ClearAndAwaitMergeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1369 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearAndAwaitMergeActor*>(this)->actor_wait_state = 1;
															#line 199 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearAndAwaitMergeActor, 0, Standalone<VectorRef<KeyRangeRef>> >*>(static_cast<ClearAndAwaitMergeActor*>(this)));
															#line 1374 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<ClearAndAwaitMergeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1398 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<ClearAndAwaitMergeActor*>(this)->actor_wait_state = 4;
															#line 218 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ClearAndAwaitMergeActor, 3, Void >*>(static_cast<ClearAndAwaitMergeActor*>(this)));
															#line 1403 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<VectorRef<KeyRangeRef>> const& ranges,int loopDepth) 
	{
															#line 200 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (ranges.size() == 1)
															#line 1418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 201 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (!static_cast<ClearAndAwaitMergeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearAndAwaitMergeActorState(); static_cast<ClearAndAwaitMergeActor*>(this)->destroy(); return 0; }
															#line 1422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			new (&static_cast<ClearAndAwaitMergeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ClearAndAwaitMergeActorState();
			static_cast<ClearAndAwaitMergeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 203 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		CODE_PROBE(true, "ClearAndAwaitMerge doing clear", probe::decoration::rare);
															#line 204 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		reClearCount--;
															#line 205 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (reClearCount <= 0)
															#line 1434 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 206 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			tr.clear(range);
															#line 207 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 207 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<ClearAndAwaitMergeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1442 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<ClearAndAwaitMergeActor*>(this)->actor_wait_state = 2;
															#line 207 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearAndAwaitMergeActor, 1, Void >*>(static_cast<ClearAndAwaitMergeActor*>(this)));
															#line 1447 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<VectorRef<KeyRangeRef>> && ranges,int loopDepth) 
	{
															#line 200 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (ranges.size() == 1)
															#line 1461 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 201 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (!static_cast<ClearAndAwaitMergeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearAndAwaitMergeActorState(); static_cast<ClearAndAwaitMergeActor*>(this)->destroy(); return 0; }
															#line 1465 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			new (&static_cast<ClearAndAwaitMergeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ClearAndAwaitMergeActorState();
			static_cast<ClearAndAwaitMergeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 203 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		CODE_PROBE(true, "ClearAndAwaitMerge doing clear", probe::decoration::rare);
															#line 204 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		reClearCount--;
															#line 205 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (reClearCount <= 0)
															#line 1477 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 206 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			tr.clear(range);
															#line 207 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 207 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<ClearAndAwaitMergeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1485 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<ClearAndAwaitMergeActor*>(this)->actor_wait_state = 2;
															#line 207 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearAndAwaitMergeActor, 1, Void >*>(static_cast<ClearAndAwaitMergeActor*>(this)));
															#line 1490 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<KeyRangeRef>> const& ranges,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(ranges, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<KeyRangeRef>> && ranges,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(ranges), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearAndAwaitMergeActor*>(this)->actor_wait_state > 0) static_cast<ClearAndAwaitMergeActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAndAwaitMergeActor*>(this)->ActorCallback< ClearAndAwaitMergeActor, 0, Standalone<VectorRef<KeyRangeRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAndAwaitMergeActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> const& value) 
	{
		fdb_probe_actor_enter("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndAwaitMergeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearAndAwaitMergeActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> && value) 
	{
		fdb_probe_actor_enter("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndAwaitMergeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearAndAwaitMergeActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndAwaitMergeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 215 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(30.0);
															#line 215 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (static_cast<ClearAndAwaitMergeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1581 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ClearAndAwaitMergeActor*>(this)->actor_wait_state = 3;
															#line 215 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClearAndAwaitMergeActor, 2, Void >*>(static_cast<ClearAndAwaitMergeActor*>(this)));
															#line 1586 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		fmt::print("ClearAndAwaitMerge cleared [{0} - {1}) @ {2}\n", range.begin.printable(), range.end.printable(), tr.getCommittedVersion());
															#line 212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		reClearCount = reClearInterval;
															#line 213 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		reClearInterval++;
															#line 1599 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 208 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		fmt::print("ClearAndAwaitMerge cleared [{0} - {1}) @ {2}\n", range.begin.printable(), range.end.printable(), tr.getCommittedVersion());
															#line 212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		reClearCount = reClearInterval;
															#line 213 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		reClearInterval++;
															#line 1612 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearAndAwaitMergeActor*>(this)->actor_wait_state > 0) static_cast<ClearAndAwaitMergeActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAndAwaitMergeActor*>(this)->ActorCallback< ClearAndAwaitMergeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAndAwaitMergeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndAwaitMergeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearAndAwaitMergeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndAwaitMergeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearAndAwaitMergeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndAwaitMergeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 216 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		tr.reset();
															#line 1696 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 216 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		tr.reset();
															#line 1705 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClearAndAwaitMergeActor*>(this)->actor_wait_state > 0) static_cast<ClearAndAwaitMergeActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAndAwaitMergeActor*>(this)->ActorCallback< ClearAndAwaitMergeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAndAwaitMergeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndAwaitMergeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClearAndAwaitMergeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndAwaitMergeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClearAndAwaitMergeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndAwaitMergeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ClearAndAwaitMergeActor*>(this)->actor_wait_state > 0) static_cast<ClearAndAwaitMergeActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAndAwaitMergeActor*>(this)->ActorCallback< ClearAndAwaitMergeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAndAwaitMergeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndAwaitMergeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ClearAndAwaitMergeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndAwaitMergeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ClearAndAwaitMergeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndAwaitMergeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 192 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Database cx;
															#line 192 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	KeyRange range;
															#line 194 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Transaction tr;
															#line 195 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	int reClearCount;
															#line 196 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	int reClearInterval;
															#line 1895 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
};
// This generated class is to be used only via clearAndAwaitMerge()
															#line 192 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
class ClearAndAwaitMergeActor final : public Actor<Void>, public ActorCallback< ClearAndAwaitMergeActor, 0, Standalone<VectorRef<KeyRangeRef>> >, public ActorCallback< ClearAndAwaitMergeActor, 1, Void >, public ActorCallback< ClearAndAwaitMergeActor, 2, Void >, public ActorCallback< ClearAndAwaitMergeActor, 3, Void >, public FastAllocated<ClearAndAwaitMergeActor>, public ClearAndAwaitMergeActorState<ClearAndAwaitMergeActor> {
															#line 1900 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
public:
	using FastAllocated<ClearAndAwaitMergeActor>::operator new;
	using FastAllocated<ClearAndAwaitMergeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8900922984956963840UL, 17866045114274437888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearAndAwaitMergeActor, 0, Standalone<VectorRef<KeyRangeRef>> >;
friend struct ActorCallback< ClearAndAwaitMergeActor, 1, Void >;
friend struct ActorCallback< ClearAndAwaitMergeActor, 2, Void >;
friend struct ActorCallback< ClearAndAwaitMergeActor, 3, Void >;
															#line 192 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	ClearAndAwaitMergeActor(Database const& cx,KeyRange const& range) 
															#line 1920 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		 : Actor<Void>(),
		   ClearAndAwaitMergeActorState<ClearAndAwaitMergeActor>(cx, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(39124871300603136UL, 10710097996521890816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndAwaitMergeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearAndAwaitMerge");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearAndAwaitMerge", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearAndAwaitMergeActor, 0, Standalone<VectorRef<KeyRangeRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearAndAwaitMergeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClearAndAwaitMergeActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ClearAndAwaitMergeActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 192 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
[[nodiscard]] Future<Void> clearAndAwaitMerge( Database const& cx, KeyRange const& range ) {
															#line 192 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	return Future<Void>(new ClearAndAwaitMergeActor(cx, range));
															#line 1956 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
}

#line 222 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"

															#line 1961 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
namespace {
// This generated class is to be used only via getSummaries()
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
template <class GetSummariesActor>
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
class GetSummariesActorState {
															#line 1968 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
public:
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	GetSummariesActorState(Database const& cx,KeyRange const& range,Version const& summaryVersion,Optional<Reference<Tenant>> const& tenant) 
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		 : cx(cx),
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   range(range),
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   summaryVersion(summaryVersion),
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   tenant(tenant),
															#line 227 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   tr(cx, tenant)
															#line 1983 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
	{
		fdb_probe_actor_create("getSummaries", reinterpret_cast<unsigned long>(this));

	}
	~GetSummariesActorState() 
	{
		fdb_probe_actor_destroy("getSummaries", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 228 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			;
															#line 1998 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetSummariesActorState();
		static_cast<GetSummariesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 230 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Standalone<VectorRef<BlobGranuleSummaryRef>>> __when_expr_0 = tr.summarizeBlobGranules(range, summaryVersion, 1000000);
															#line 230 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<GetSummariesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2031 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetSummariesActor*>(this)->actor_wait_state = 1;
															#line 230 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetSummariesActor, 0, Standalone<VectorRef<BlobGranuleSummaryRef>> >*>(static_cast<GetSummariesActor*>(this)));
															#line 2036 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 244 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 244 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<GetSummariesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2060 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetSummariesActor*>(this)->actor_wait_state = 2;
															#line 244 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetSummariesActor, 1, Void >*>(static_cast<GetSummariesActor*>(this)));
															#line 2065 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<VectorRef<BlobGranuleSummaryRef>> const& summaries,int loopDepth) 
	{
															#line 234 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		ASSERT(!summaries.empty());
															#line 235 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		ASSERT(summaries.front().keyRange.begin == range.begin);
															#line 236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		ASSERT(summaries.back().keyRange.end == range.end);
															#line 238 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		for(int i = 0;i < summaries.size() - 1;i++) {
															#line 239 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			ASSERT(summaries[i].keyRange.end == summaries[i + 1].keyRange.begin);
															#line 2088 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		}
															#line 242 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (!static_cast<GetSummariesActor*>(this)->SAV<Standalone<VectorRef<BlobGranuleSummaryRef>>>::futures) { (void)(summaries); this->~GetSummariesActorState(); static_cast<GetSummariesActor*>(this)->destroy(); return 0; }
															#line 2092 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		new (&static_cast<GetSummariesActor*>(this)->SAV< Standalone<VectorRef<BlobGranuleSummaryRef>> >::value()) Standalone<VectorRef<BlobGranuleSummaryRef>>(summaries);
		this->~GetSummariesActorState();
		static_cast<GetSummariesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<VectorRef<BlobGranuleSummaryRef>> && summaries,int loopDepth) 
	{
															#line 234 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		ASSERT(!summaries.empty());
															#line 235 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		ASSERT(summaries.front().keyRange.begin == range.begin);
															#line 236 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		ASSERT(summaries.back().keyRange.end == range.end);
															#line 238 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		for(int i = 0;i < summaries.size() - 1;i++) {
															#line 239 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			ASSERT(summaries[i].keyRange.end == summaries[i + 1].keyRange.begin);
															#line 2112 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		}
															#line 242 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (!static_cast<GetSummariesActor*>(this)->SAV<Standalone<VectorRef<BlobGranuleSummaryRef>>>::futures) { (void)(summaries); this->~GetSummariesActorState(); static_cast<GetSummariesActor*>(this)->destroy(); return 0; }
															#line 2116 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		new (&static_cast<GetSummariesActor*>(this)->SAV< Standalone<VectorRef<BlobGranuleSummaryRef>> >::value()) Standalone<VectorRef<BlobGranuleSummaryRef>>(summaries);
		this->~GetSummariesActorState();
		static_cast<GetSummariesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<BlobGranuleSummaryRef>> const& summaries,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(summaries, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<BlobGranuleSummaryRef>> && summaries,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(summaries), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetSummariesActor*>(this)->actor_wait_state > 0) static_cast<GetSummariesActor*>(this)->actor_wait_state = 0;
		static_cast<GetSummariesActor*>(this)->ActorCallback< GetSummariesActor, 0, Standalone<VectorRef<BlobGranuleSummaryRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetSummariesActor, 0, Standalone<VectorRef<BlobGranuleSummaryRef>> >*,Standalone<VectorRef<BlobGranuleSummaryRef>> const& value) 
	{
		fdb_probe_actor_enter("getSummaries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSummaries", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetSummariesActor, 0, Standalone<VectorRef<BlobGranuleSummaryRef>> >*,Standalone<VectorRef<BlobGranuleSummaryRef>> && value) 
	{
		fdb_probe_actor_enter("getSummaries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSummaries", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetSummariesActor, 0, Standalone<VectorRef<BlobGranuleSummaryRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("getSummaries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSummaries", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetSummariesActor*>(this)->actor_wait_state > 0) static_cast<GetSummariesActor*>(this)->actor_wait_state = 0;
		static_cast<GetSummariesActor*>(this)->ActorCallback< GetSummariesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSummariesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSummaries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSummaries", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetSummariesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSummaries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSummaries", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetSummariesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSummaries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSummaries", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Database cx;
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	KeyRange range;
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Version summaryVersion;
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Optional<Reference<Tenant>> tenant;
															#line 227 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Transaction tr;
															#line 2296 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
};
// This generated class is to be used only via getSummaries()
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
class GetSummariesActor final : public Actor<Standalone<VectorRef<BlobGranuleSummaryRef>>>, public ActorCallback< GetSummariesActor, 0, Standalone<VectorRef<BlobGranuleSummaryRef>> >, public ActorCallback< GetSummariesActor, 1, Void >, public FastAllocated<GetSummariesActor>, public GetSummariesActorState<GetSummariesActor> {
															#line 2301 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
public:
	using FastAllocated<GetSummariesActor>::operator new;
	using FastAllocated<GetSummariesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2133543593210837248UL, 15702341991923623936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<BlobGranuleSummaryRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetSummariesActor, 0, Standalone<VectorRef<BlobGranuleSummaryRef>> >;
friend struct ActorCallback< GetSummariesActor, 1, Void >;
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	GetSummariesActor(Database const& cx,KeyRange const& range,Version const& summaryVersion,Optional<Reference<Tenant>> const& tenant) 
															#line 2319 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		 : Actor<Standalone<VectorRef<BlobGranuleSummaryRef>>>(),
		   GetSummariesActorState<GetSummariesActor>(cx, range, summaryVersion, tenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getSummaries", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6298839618418302976UL, 14340861748830223872UL);
		ActorExecutionContextHelper __helper(static_cast<GetSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getSummaries");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getSummaries", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetSummariesActor, 0, Standalone<VectorRef<BlobGranuleSummaryRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetSummariesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<BlobGranuleSummaryRef>>> getSummaries( Database const& cx, KeyRange const& range, Version const& summaryVersion, Optional<Reference<Tenant>> const& tenant ) {
															#line 223 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	return Future<Standalone<VectorRef<BlobGranuleSummaryRef>>>(new GetSummariesActor(cx, range, summaryVersion, tenant));
															#line 2353 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
}

#line 248 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"

															#line 2358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
namespace {
// This generated class is to be used only via validateGranuleSummaries()
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
template <class ValidateGranuleSummariesActor>
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
class ValidateGranuleSummariesActorState {
															#line 2365 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
public:
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	ValidateGranuleSummariesActorState(Database const& cx,KeyRange const& range,Optional<Reference<Tenant>> const& tenant,Promise<Void> const& testComplete) 
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		 : cx(cx),
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   range(range),
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   tenant(tenant),
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   testComplete(testComplete),
															#line 253 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   lastSummaryArena(),
															#line 254 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   lastSummary(),
															#line 255 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   lastSummaryVersion(invalidVersion),
															#line 256 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   tr(cx, tenant)
															#line 2386 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
	{
		fdb_probe_actor_create("validateGranuleSummaries", reinterpret_cast<unsigned long>(this));

	}
	~ValidateGranuleSummariesActorState() 
	{
		fdb_probe_actor_destroy("validateGranuleSummaries", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 258 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				;
															#line 2402 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateGranuleSummariesActorState();
		static_cast<ValidateGranuleSummariesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 336 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (e.code() != error_code_operation_cancelled)
															#line 2432 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 337 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				TraceEvent(SevError, "UnexpectedErrorValidateGranuleSummaries").error(e);
															#line 2436 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			}
															#line 339 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 2440 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 260 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		nextSummaryVersion = Version();
															#line 261 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		tr.reset();
															#line 262 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		;
															#line 2465 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 272 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		nextSummary = Standalone<VectorRef<BlobGranuleSummaryRef>>();
															#line 2474 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		try {
															#line 274 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Void> __when_expr_2 = store(nextSummary, getSummaries(cx, range, nextSummaryVersion, tenant));
															#line 274 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2480 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state = 3;
															#line 274 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ValidateGranuleSummariesActor, 2, Void >*>(static_cast<ValidateGranuleSummariesActor*>(this)));
															#line 2485 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(nextSummaryVersion, tr.getReadVersion());
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2510 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state = 1;
															#line 264 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateGranuleSummariesActor, 0, Void >*>(static_cast<ValidateGranuleSummariesActor*>(this)));
															#line 2515 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 268 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 268 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2552 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state = 2;
															#line 268 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ValidateGranuleSummariesActor, 1, Void >*>(static_cast<ValidateGranuleSummariesActor*>(this)));
															#line 2557 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 265 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		ASSERT(nextSummaryVersion >= lastSummaryVersion);
															#line 2572 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 265 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		ASSERT(nextSummaryVersion >= lastSummaryVersion);
															#line 2581 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state > 0) static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateGranuleSummariesActor*>(this)->ActorCallback< ValidateGranuleSummariesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateGranuleSummariesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateGranuleSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateGranuleSummariesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateGranuleSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateGranuleSummariesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateGranuleSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state > 0) static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateGranuleSummariesActor*>(this)->ActorCallback< ValidateGranuleSummariesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateGranuleSummariesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateGranuleSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ValidateGranuleSummariesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateGranuleSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ValidateGranuleSummariesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateGranuleSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (lastSummaryVersion != invalidVersion)
															#line 2752 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 287 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			CODE_PROBE(true, "comparing multiple summaries", probe::decoration::rare);
															#line 289 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			for( auto& it : nextSummary ) {
															#line 290 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				auto lastSummaries = lastSummary.intersectingRanges(it.keyRange);
															#line 291 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				for( auto& itLast : lastSummaries ) {
															#line 293 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
					if (!itLast.cvalue().present())
															#line 2764 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
					{
															#line 294 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
						ASSERT(lastSummaryVersion == invalidVersion);
															#line 2768 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
						continue;
					}
															#line 297 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
					auto& last = itLast.cvalue().get();
															#line 299 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
					ASSERT(it.snapshotVersion >= last.snapshotVersion);
															#line 302 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
					if (it.keyRange == itLast.range())
															#line 2777 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
					{
															#line 303 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
						if (it.snapshotVersion == last.snapshotVersion)
															#line 2781 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
						{
															#line 304 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
							ASSERT(it.snapshotSize == last.snapshotSize);
															#line 2785 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
						}
															#line 306 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
						if (it.snapshotVersion == last.snapshotVersion && it.deltaVersion == last.deltaVersion)
															#line 2789 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
						{
															#line 307 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
							ASSERT(it.snapshotSize == last.snapshotSize);
															#line 308 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
							ASSERT(it.deltaSize == last.deltaSize);
															#line 2795 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
						}
						else
						{
															#line 309 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
							if (it.snapshotVersion == last.snapshotVersion)
															#line 2801 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
							{
															#line 312 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
								if (it.deltaVersion >= last.deltaVersion)
															#line 2805 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
								{
															#line 313 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
									ASSERT(it.deltaSize >= last.deltaSize);
															#line 2809 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
								}
							}
						}
						break;
					}
				}
			}
															#line 321 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (!testComplete.canBeSet())
															#line 2819 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 322 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				if (!static_cast<ValidateGranuleSummariesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateGranuleSummariesActorState(); static_cast<ValidateGranuleSummariesActor*>(this)->destroy(); return 0; }
															#line 2823 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				new (&static_cast<ValidateGranuleSummariesActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ValidateGranuleSummariesActorState();
				static_cast<ValidateGranuleSummariesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 326 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		lastSummaryArena = nextSummary.arena();
															#line 327 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		lastSummaryVersion = nextSummaryVersion;
															#line 328 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		lastSummary.insert(range, {});
															#line 329 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		for( auto& it : nextSummary ) {
															#line 330 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			lastSummary.insert(it.keyRange, it);
															#line 2840 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		}
															#line 333 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delayJittered(deterministicRandom()->randomInt(1, 10));
															#line 333 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2846 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state = 5;
															#line 333 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ValidateGranuleSummariesActor, 4, Void >*>(static_cast<ValidateGranuleSummariesActor*>(this)));
															#line 2851 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 276 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (e.code() == error_code_blob_granule_transaction_too_old)
															#line 2861 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 277 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				ASSERT(lastSummaryVersion == invalidVersion);
															#line 279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				StrictFuture<Void> __when_expr_3 = delay(1.0);
															#line 279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				if (static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2869 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1Catch1when1(__when_expr_3.get(), loopDepth); };
				static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state = 4;
															#line 279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ValidateGranuleSummariesActor, 3, Void >*>(static_cast<ValidateGranuleSummariesActor*>(this)));
															#line 2874 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 282 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				return a_body1Catch2(e, std::max(0, loopDepth - 1));
															#line 2881 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state > 0) static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateGranuleSummariesActor*>(this)->ActorCallback< ValidateGranuleSummariesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateGranuleSummariesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateGranuleSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ValidateGranuleSummariesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateGranuleSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ValidateGranuleSummariesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateGranuleSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state > 0) static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateGranuleSummariesActor*>(this)->ActorCallback< ValidateGranuleSummariesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateGranuleSummariesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateGranuleSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ValidateGranuleSummariesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateGranuleSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ValidateGranuleSummariesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateGranuleSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state > 0) static_cast<ValidateGranuleSummariesActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateGranuleSummariesActor*>(this)->ActorCallback< ValidateGranuleSummariesActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateGranuleSummariesActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateGranuleSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ValidateGranuleSummariesActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateGranuleSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ValidateGranuleSummariesActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateGranuleSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Database cx;
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	KeyRange range;
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Optional<Reference<Tenant>> tenant;
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Promise<Void> testComplete;
															#line 253 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Arena lastSummaryArena;
															#line 254 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	KeyRangeMap<Optional<BlobGranuleSummaryRef>> lastSummary;
															#line 255 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Version lastSummaryVersion;
															#line 256 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Transaction tr;
															#line 260 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Version nextSummaryVersion;
															#line 272 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Standalone<VectorRef<BlobGranuleSummaryRef>> nextSummary;
															#line 3186 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
};
// This generated class is to be used only via validateGranuleSummaries()
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
class ValidateGranuleSummariesActor final : public Actor<Void>, public ActorCallback< ValidateGranuleSummariesActor, 0, Void >, public ActorCallback< ValidateGranuleSummariesActor, 1, Void >, public ActorCallback< ValidateGranuleSummariesActor, 2, Void >, public ActorCallback< ValidateGranuleSummariesActor, 3, Void >, public ActorCallback< ValidateGranuleSummariesActor, 4, Void >, public FastAllocated<ValidateGranuleSummariesActor>, public ValidateGranuleSummariesActorState<ValidateGranuleSummariesActor> {
															#line 3191 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
public:
	using FastAllocated<ValidateGranuleSummariesActor>::operator new;
	using FastAllocated<ValidateGranuleSummariesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6818858958587942912UL, 446403159125854208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateGranuleSummariesActor, 0, Void >;
friend struct ActorCallback< ValidateGranuleSummariesActor, 1, Void >;
friend struct ActorCallback< ValidateGranuleSummariesActor, 2, Void >;
friend struct ActorCallback< ValidateGranuleSummariesActor, 3, Void >;
friend struct ActorCallback< ValidateGranuleSummariesActor, 4, Void >;
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	ValidateGranuleSummariesActor(Database const& cx,KeyRange const& range,Optional<Reference<Tenant>> const& tenant,Promise<Void> const& testComplete) 
															#line 3212 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		 : Actor<Void>(),
		   ValidateGranuleSummariesActorState<ValidateGranuleSummariesActor>(cx, range, tenant, testComplete),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12845194878451000320UL, 11974520174754187776UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateGranuleSummariesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validateGranuleSummaries");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validateGranuleSummaries", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateGranuleSummariesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ValidateGranuleSummariesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ValidateGranuleSummariesActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ValidateGranuleSummariesActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ValidateGranuleSummariesActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
[[nodiscard]] Future<Void> validateGranuleSummaries( Database const& cx, KeyRange const& range, Optional<Reference<Tenant>> const& tenant, Promise<Void> const& testComplete ) {
															#line 249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	return Future<Void>(new ValidateGranuleSummariesActor(cx, range, tenant, testComplete));
															#line 3249 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
}

#line 342 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"

															#line 3254 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
namespace {
// This generated class is to be used only via validateForceFlushing()
															#line 343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
template <class ValidateForceFlushingActor>
															#line 343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
class ValidateForceFlushingActorState {
															#line 3261 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
public:
															#line 343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	ValidateForceFlushingActorState(Database const& cx,KeyRange const& range,double const& testDuration,Promise<Void> const& testComplete) 
															#line 343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
															#line 343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		 : cx(cx),
															#line 343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   range(range),
															#line 343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   testDuration(testDuration),
															#line 343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   testComplete(testComplete)
															#line 3274 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
	{
		fdb_probe_actor_create("validateForceFlushing", reinterpret_cast<unsigned long>(this));

	}
	~ValidateForceFlushingActorState() 
	{
		fdb_probe_actor_destroy("validateForceFlushing", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 347 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			TraceEvent("ValidateForceFlushSleeping").detail("Range", range);
															#line 349 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(deterministicRandom()->random01() * testDuration);
															#line 349 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3293 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 1;
															#line 349 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateForceFlushingActor, 0, Void >*>(static_cast<ValidateForceFlushingActor*>(this)));
															#line 3298 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateForceFlushingActorState();
		static_cast<ValidateForceFlushingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 351 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		TraceEvent("ValidateForceFlushRunning").detail("Range", range);
															#line 354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		;
															#line 3323 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 351 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		TraceEvent("ValidateForceFlushRunning").detail("Range", range);
															#line 354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		;
															#line 3334 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state > 0) static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForceFlushingActor*>(this)->ActorCallback< ValidateForceFlushingActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateForceFlushingActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 363 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		toFlush = range;
															#line 364 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		flushVersion = invalidVersion;
															#line 366 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		tr = Transaction(cx);
															#line 367 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		;
															#line 3424 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 355 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		StrictFuture<Version> __when_expr_1 = cx->verifyBlobRange(range, {}, {});
															#line 355 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3442 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 2;
															#line 355 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ValidateForceFlushingActor, 1, Version >*>(static_cast<ValidateForceFlushingActor*>(this)));
															#line 3447 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Version const& v,int loopDepth) 
	{
															#line 356 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (v != invalidVersion)
															#line 3469 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			TraceEvent("ValidateForceFlushVerified").detail("Range", range).detail("Version", v);
															#line 3473 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 360 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(2.0);
															#line 360 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3480 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 3;
															#line 360 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ValidateForceFlushingActor, 2, Void >*>(static_cast<ValidateForceFlushingActor*>(this)));
															#line 3485 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Version && v,int loopDepth) 
	{
															#line 356 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (v != invalidVersion)
															#line 3494 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 357 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			TraceEvent("ValidateForceFlushVerified").detail("Range", range).detail("Version", v);
															#line 3498 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 360 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(2.0);
															#line 360 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3505 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 3;
															#line 360 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ValidateForceFlushingActor, 2, Void >*>(static_cast<ValidateForceFlushingActor*>(this)));
															#line 3510 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(v, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state > 0) static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForceFlushingActor*>(this)->ActorCallback< ValidateForceFlushingActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ValidateForceFlushingActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state > 0) static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForceFlushingActor*>(this)->ActorCallback< ValidateForceFlushingActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ValidateForceFlushingActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 404 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (BUGGIFY_WITH_PROB(0.1))
															#line 3681 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 405 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			flushVersion += deterministicRandom()->randomInt(0, 1000000);
															#line 406 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			TraceEvent("ValidateForceFlushAddingJitter") .detail("Range", range) .detail("ToFlush", toFlush) .detail("NewVersion", flushVersion);
															#line 3687 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		}
															#line 412 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		compact = deterministicRandom()->random01() < 0.25;
															#line 414 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		TraceEvent("ValidateForceFlushRequesting") .detail("Range", range) .detail("ToFlush", toFlush) .detail("Version", flushVersion) .detail("Compact", compact);
															#line 421 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		FlushGranuleRequest req(-1, toFlush, flushVersion, compact);
															#line 422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		StrictFuture<Void> __when_expr_6 = success(doBlobGranuleRequests(cx, toFlush, req, &BlobWorkerInterface::flushGranuleRequest));
															#line 422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3699 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 7;
															#line 422 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ValidateForceFlushingActor, 6, Void >*>(static_cast<ValidateForceFlushingActor*>(this)));
															#line 3704 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 368 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 3720 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		try {
															#line 370 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Void> __when_expr_3 = store(flushVersion, tr.getReadVersion());
															#line 370 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3726 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 4;
															#line 370 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ValidateForceFlushingActor, 3, Void >*>(static_cast<ValidateForceFlushingActor*>(this)));
															#line 3731 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 398 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr.onError(e);
															#line 398 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3768 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 6;
															#line 398 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ValidateForceFlushingActor, 5, Void >*>(static_cast<ValidateForceFlushingActor*>(this)));
															#line 3773 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyRangeRef>>> __when_expr_4 = tr.getBlobGranuleRanges(range, 1000);
															#line 371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3790 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 5;
															#line 371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ValidateForceFlushingActor, 4, Standalone<VectorRef<KeyRangeRef>> >*>(static_cast<ValidateForceFlushingActor*>(this)));
															#line 3795 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyRangeRef>>> __when_expr_4 = tr.getBlobGranuleRanges(range, 1000);
															#line 371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3806 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 5;
															#line 371 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ValidateForceFlushingActor, 4, Standalone<VectorRef<KeyRangeRef>> >*>(static_cast<ValidateForceFlushingActor*>(this)));
															#line 3811 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state > 0) static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForceFlushingActor*>(this)->ActorCallback< ValidateForceFlushingActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ValidateForceFlushingActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopBody1cont3(Standalone<VectorRef<KeyRangeRef>> const& granules,int loopDepth) 
	{
															#line 372 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		ASSERT(!granules.empty());
															#line 373 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (granules.size() > 2)
															#line 3897 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 375 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			int targetRanges = deterministicRandom()->randomInt(1, std::min(10, (int)granules.size()));
															#line 376 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			int targetStart = deterministicRandom()->randomInt(0, granules.size() - targetRanges);
															#line 378 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			Key startKey = granules[targetStart].begin;
															#line 379 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			Key endKey = granules[targetStart + targetRanges - 1].end;
															#line 382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (BUGGIFY_WITH_PROB(0.1))
															#line 3909 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 384 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				if (targetStart + targetRanges < granules.size() && deterministicRandom()->coinflip())
															#line 3913 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				{
															#line 385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
					endKey = keyAfter(endKey);
															#line 3917 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				}
															#line 387 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				if (deterministicRandom()->coinflip() && keyAfter(startKey) < endKey)
															#line 3921 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				{
															#line 388 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
					startKey = keyAfter(startKey);
															#line 3925 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				}
			}
															#line 392 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			toFlush = KeyRangeRef(startKey, endKey);
															#line 393 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			ASSERT(!toFlush.empty());
															#line 3932 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		}
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Standalone<VectorRef<KeyRangeRef>> && granules,int loopDepth) 
	{
															#line 372 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		ASSERT(!granules.empty());
															#line 373 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (granules.size() > 2)
															#line 3944 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 375 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			int targetRanges = deterministicRandom()->randomInt(1, std::min(10, (int)granules.size()));
															#line 376 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			int targetStart = deterministicRandom()->randomInt(0, granules.size() - targetRanges);
															#line 378 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			Key startKey = granules[targetStart].begin;
															#line 379 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			Key endKey = granules[targetStart + targetRanges - 1].end;
															#line 382 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (BUGGIFY_WITH_PROB(0.1))
															#line 3956 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 384 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				if (targetStart + targetRanges < granules.size() && deterministicRandom()->coinflip())
															#line 3960 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				{
															#line 385 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
					endKey = keyAfter(endKey);
															#line 3964 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				}
															#line 387 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				if (deterministicRandom()->coinflip() && keyAfter(startKey) < endKey)
															#line 3968 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				{
															#line 388 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
					startKey = keyAfter(startKey);
															#line 3972 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				}
			}
															#line 392 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			toFlush = KeyRangeRef(startKey, endKey);
															#line 393 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			ASSERT(!toFlush.empty());
															#line 3979 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		}
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Standalone<VectorRef<KeyRangeRef>> const& granules,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(granules, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Standalone<VectorRef<KeyRangeRef>> && granules,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(granules), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state > 0) static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForceFlushingActor*>(this)->ActorCallback< ValidateForceFlushingActor, 4, Standalone<VectorRef<KeyRangeRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 4, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> const& value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 4, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> && value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ValidateForceFlushingActor, 4, Standalone<VectorRef<KeyRangeRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state > 0) static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForceFlushingActor*>(this)->ActorCallback< ValidateForceFlushingActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ValidateForceFlushingActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 424 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		TraceEvent("ValidateForceFlushRequestComplete") .detail("Range", range) .detail("ToFlush", toFlush) .detail("Version", flushVersion) .detail("Compact", compact);
															#line 434 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		readVersion = Version();
															#line 435 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		tr.reset();
															#line 436 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		;
															#line 4157 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 424 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		TraceEvent("ValidateForceFlushRequestComplete") .detail("Range", range) .detail("ToFlush", toFlush) .detail("Version", flushVersion) .detail("Compact", compact);
															#line 434 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		readVersion = Version();
															#line 435 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		tr.reset();
															#line 436 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		;
															#line 4172 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state > 0) static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForceFlushingActor*>(this)->ActorCallback< ValidateForceFlushingActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ValidateForceFlushingActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 484 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		TraceEvent("ValidateForceFlushDone") .detail("Range", range) .detail("ToFlush", toFlush) .detail("Version", flushVersion);
															#line 489 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (!static_cast<ValidateForceFlushingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateForceFlushingActorState(); static_cast<ValidateForceFlushingActor*>(this)->destroy(); return 0; }
															#line 4258 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		new (&static_cast<ValidateForceFlushingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateForceFlushingActorState();
		static_cast<ValidateForceFlushingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
		try {
															#line 438 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 439 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (compact)
															#line 4280 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 441 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				StrictFuture<Void> __when_expr_7 = store(readVersion, tr.getReadVersion());
															#line 441 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state < 0) return a_body1cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4286 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont4loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont4loopBody1when1(__when_expr_7.get(), loopDepth); };
				static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 8;
															#line 441 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ValidateForceFlushingActor, 7, Void >*>(static_cast<ValidateForceFlushingActor*>(this)));
															#line 4291 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 443 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				readVersion = flushVersion;
															#line 4298 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				loopDepth = a_body1cont4loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont4loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont4loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 480 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Void> __when_expr_9 = tr.onError(e);
															#line 480 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4336 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1Catch1when1(__when_expr_9.get(), loopDepth); };
			static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 10;
															#line 480 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ValidateForceFlushingActor, 9, Void >*>(static_cast<ValidateForceFlushingActor*>(this)));
															#line 4341 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont2(int loopDepth) 
	{
															#line 445 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		StrictFuture<Standalone<VectorRef<BlobGranuleChunkRef>>> __when_expr_8 = tr.readBlobGranules(toFlush, 0, readVersion);
															#line 445 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state < 0) return a_body1cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont4loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont4loopBody1cont2when1(__when_expr_8.get(), loopDepth); };
		static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 9;
															#line 445 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ValidateForceFlushingActor, 8, Standalone<VectorRef<BlobGranuleChunkRef>> >*>(static_cast<ValidateForceFlushingActor*>(this)));
															#line 4363 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state > 0) static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForceFlushingActor*>(this)->ActorCallback< ValidateForceFlushingActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ValidateForceFlushingActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont4loopBody1cont5(Standalone<VectorRef<BlobGranuleChunkRef>> const& chunks,int loopDepth) 
	{
															#line 446 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		fmt::print("Chunks from force flush [{0} - {1}) @ {2}\n", toFlush.begin.printable(), toFlush.end.printable(), readVersion);
															#line 450 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		printGranuleChunks(chunks);
															#line 451 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		fmt::print("Processing\n");
															#line 452 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		for( auto& it : chunks ) {
															#line 454 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (compact)
															#line 4467 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 455 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				if (it.snapshotVersion < flushVersion)
															#line 4471 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				{
															#line 456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
					fmt::print("Chunk [{0} - {1}). SV={2}, FV={3}\n", it.keyRange.begin.printable(), it.keyRange.end.printable(), it.snapshotVersion, flushVersion);
															#line 4475 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				}
															#line 462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				ASSERT(it.snapshotVersion >= flushVersion);
															#line 4479 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			}
		}
		return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont4loopBody1cont5(Standalone<VectorRef<BlobGranuleChunkRef>> && chunks,int loopDepth) 
	{
															#line 446 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		fmt::print("Chunks from force flush [{0} - {1}) @ {2}\n", toFlush.begin.printable(), toFlush.end.printable(), readVersion);
															#line 450 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		printGranuleChunks(chunks);
															#line 451 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		fmt::print("Processing\n");
															#line 452 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		for( auto& it : chunks ) {
															#line 454 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (compact)
															#line 4498 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 455 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				if (it.snapshotVersion < flushVersion)
															#line 4502 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				{
															#line 456 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
					fmt::print("Chunk [{0} - {1}). SV={2}, FV={3}\n", it.keyRange.begin.printable(), it.keyRange.end.printable(), it.snapshotVersion, flushVersion);
															#line 4506 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				}
															#line 462 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				ASSERT(it.snapshotVersion >= flushVersion);
															#line 4510 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			}
		}
		return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont4loopBody1cont2when1(Standalone<VectorRef<BlobGranuleChunkRef>> const& chunks,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont5(chunks, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont2when1(Standalone<VectorRef<BlobGranuleChunkRef>> && chunks,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont5(std::move(chunks), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state > 0) static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForceFlushingActor*>(this)->ActorCallback< ValidateForceFlushingActor, 8, Standalone<VectorRef<BlobGranuleChunkRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 8, Standalone<VectorRef<BlobGranuleChunkRef>> >*,Standalone<VectorRef<BlobGranuleChunkRef>> const& value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont4loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 8, Standalone<VectorRef<BlobGranuleChunkRef>> >*,Standalone<VectorRef<BlobGranuleChunkRef>> && value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont4loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ValidateForceFlushingActor, 8, Standalone<VectorRef<BlobGranuleChunkRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont4loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state > 0) static_cast<ValidateForceFlushingActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForceFlushingActor*>(this)->ActorCallback< ValidateForceFlushingActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ValidateForceFlushingActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ValidateForceFlushingActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Database cx;
															#line 343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	KeyRange range;
															#line 343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	double testDuration;
															#line 343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Promise<Void> testComplete;
															#line 363 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	KeyRange toFlush;
															#line 364 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Version flushVersion;
															#line 366 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Transaction tr;
															#line 412 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	bool compact;
															#line 434 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Version readVersion;
															#line 4697 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
};
// This generated class is to be used only via validateForceFlushing()
															#line 343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
class ValidateForceFlushingActor final : public Actor<Void>, public ActorCallback< ValidateForceFlushingActor, 0, Void >, public ActorCallback< ValidateForceFlushingActor, 1, Version >, public ActorCallback< ValidateForceFlushingActor, 2, Void >, public ActorCallback< ValidateForceFlushingActor, 3, Void >, public ActorCallback< ValidateForceFlushingActor, 4, Standalone<VectorRef<KeyRangeRef>> >, public ActorCallback< ValidateForceFlushingActor, 5, Void >, public ActorCallback< ValidateForceFlushingActor, 6, Void >, public ActorCallback< ValidateForceFlushingActor, 7, Void >, public ActorCallback< ValidateForceFlushingActor, 8, Standalone<VectorRef<BlobGranuleChunkRef>> >, public ActorCallback< ValidateForceFlushingActor, 9, Void >, public FastAllocated<ValidateForceFlushingActor>, public ValidateForceFlushingActorState<ValidateForceFlushingActor> {
															#line 4702 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
public:
	using FastAllocated<ValidateForceFlushingActor>::operator new;
	using FastAllocated<ValidateForceFlushingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8324037454407640064UL, 15781849386361355520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateForceFlushingActor, 0, Void >;
friend struct ActorCallback< ValidateForceFlushingActor, 1, Version >;
friend struct ActorCallback< ValidateForceFlushingActor, 2, Void >;
friend struct ActorCallback< ValidateForceFlushingActor, 3, Void >;
friend struct ActorCallback< ValidateForceFlushingActor, 4, Standalone<VectorRef<KeyRangeRef>> >;
friend struct ActorCallback< ValidateForceFlushingActor, 5, Void >;
friend struct ActorCallback< ValidateForceFlushingActor, 6, Void >;
friend struct ActorCallback< ValidateForceFlushingActor, 7, Void >;
friend struct ActorCallback< ValidateForceFlushingActor, 8, Standalone<VectorRef<BlobGranuleChunkRef>> >;
friend struct ActorCallback< ValidateForceFlushingActor, 9, Void >;
															#line 343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	ValidateForceFlushingActor(Database const& cx,KeyRange const& range,double const& testDuration,Promise<Void> const& testComplete) 
															#line 4728 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		 : Actor<Void>(),
		   ValidateForceFlushingActorState<ValidateForceFlushingActor>(cx, range, testDuration, testComplete),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validateForceFlushing", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9590244756579182592UL, 364931782989846272UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForceFlushingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validateForceFlushing");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validateForceFlushing", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateForceFlushingActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ValidateForceFlushingActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ValidateForceFlushingActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ValidateForceFlushingActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ValidateForceFlushingActor, 4, Standalone<VectorRef<KeyRangeRef>> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ValidateForceFlushingActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ValidateForceFlushingActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ValidateForceFlushingActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ValidateForceFlushingActor, 8, Standalone<VectorRef<BlobGranuleChunkRef>> >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< ValidateForceFlushingActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
[[nodiscard]] Future<Void> validateForceFlushing( Database const& cx, KeyRange const& range, double const& testDuration, Promise<Void> const& testComplete ) {
															#line 343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	return Future<Void>(new ValidateForceFlushingActor(cx, range, testDuration, testComplete));
															#line 4770 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
}

#line 491 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"

struct feed_cmp_f {
	bool operator()(const std::pair<Key, KeyRange>& lhs, const std::pair<Key, KeyRange>& rhs) const {
		if (lhs.second.begin == rhs.second.begin) {
			return lhs.second.end < rhs.second.end;
		}
		return lhs.second.begin < rhs.second.begin;
	}
};

															#line 4784 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
namespace {
// This generated class is to be used only via getActiveFeeds()
															#line 501 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
template <class GetActiveFeedsActor>
															#line 501 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
class GetActiveFeedsActorState {
															#line 4791 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
public:
															#line 501 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	GetActiveFeedsActorState(Transaction* const& tr) 
															#line 501 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
															#line 501 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		 : tr(tr)
															#line 4798 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
	{
		fdb_probe_actor_create("getActiveFeeds", reinterpret_cast<unsigned long>(this));

	}
	~GetActiveFeedsActorState() 
	{
		fdb_probe_actor_destroy("getActiveFeeds", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 502 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(changeFeedKeys, CLIENT_KNOBS->BG_TOO_MANY_GRANULES);
															#line 502 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<GetActiveFeedsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4815 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetActiveFeedsActor*>(this)->actor_wait_state = 1;
															#line 502 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetActiveFeedsActor, 0, RangeResult >*>(static_cast<GetActiveFeedsActor*>(this)));
															#line 4820 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetActiveFeedsActorState();
		static_cast<GetActiveFeedsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& feedResult,int loopDepth) 
	{
															#line 503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		ASSERT(!feedResult.more);
															#line 504 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		std::vector<std::pair<Key, KeyRange>> results;
															#line 505 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		for( auto& it : feedResult ) {
															#line 506 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			Key feedKey = it.key.removePrefix(changeFeedPrefix);
															#line 507 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			KeyRange feedRange;
															#line 508 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			Version version;
															#line 509 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			ChangeFeedStatus status;
															#line 511 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			std::tie(feedRange, version, status) = decodeChangeFeedValue(it.value);
															#line 512 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			results.push_back({ feedKey, feedRange });
															#line 4859 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		}
															#line 515 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		std::sort(results.begin(), results.end(), feed_cmp_f());
															#line 517 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (!static_cast<GetActiveFeedsActor*>(this)->SAV<std::vector<std::pair<Key, KeyRange>>>::futures) { (void)(results); this->~GetActiveFeedsActorState(); static_cast<GetActiveFeedsActor*>(this)->destroy(); return 0; }
															#line 4865 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		new (&static_cast<GetActiveFeedsActor*>(this)->SAV< std::vector<std::pair<Key, KeyRange>> >::value()) std::vector<std::pair<Key, KeyRange>>(results);
		this->~GetActiveFeedsActorState();
		static_cast<GetActiveFeedsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && feedResult,int loopDepth) 
	{
															#line 503 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		ASSERT(!feedResult.more);
															#line 504 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		std::vector<std::pair<Key, KeyRange>> results;
															#line 505 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		for( auto& it : feedResult ) {
															#line 506 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			Key feedKey = it.key.removePrefix(changeFeedPrefix);
															#line 507 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			KeyRange feedRange;
															#line 508 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			Version version;
															#line 509 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			ChangeFeedStatus status;
															#line 511 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			std::tie(feedRange, version, status) = decodeChangeFeedValue(it.value);
															#line 512 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			results.push_back({ feedKey, feedRange });
															#line 4893 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		}
															#line 515 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		std::sort(results.begin(), results.end(), feed_cmp_f());
															#line 517 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (!static_cast<GetActiveFeedsActor*>(this)->SAV<std::vector<std::pair<Key, KeyRange>>>::futures) { (void)(results); this->~GetActiveFeedsActorState(); static_cast<GetActiveFeedsActor*>(this)->destroy(); return 0; }
															#line 4899 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		new (&static_cast<GetActiveFeedsActor*>(this)->SAV< std::vector<std::pair<Key, KeyRange>> >::value()) std::vector<std::pair<Key, KeyRange>>(results);
		this->~GetActiveFeedsActorState();
		static_cast<GetActiveFeedsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& feedResult,int loopDepth) 
	{
		loopDepth = a_body1cont1(feedResult, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && feedResult,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(feedResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetActiveFeedsActor*>(this)->actor_wait_state > 0) static_cast<GetActiveFeedsActor*>(this)->actor_wait_state = 0;
		static_cast<GetActiveFeedsActor*>(this)->ActorCallback< GetActiveFeedsActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetActiveFeedsActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getActiveFeeds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActiveFeedsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActiveFeeds", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetActiveFeedsActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getActiveFeeds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActiveFeedsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActiveFeeds", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetActiveFeedsActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getActiveFeeds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetActiveFeedsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActiveFeeds", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 501 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Transaction* tr;
															#line 4984 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
};
// This generated class is to be used only via getActiveFeeds()
															#line 501 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
class GetActiveFeedsActor final : public Actor<std::vector<std::pair<Key, KeyRange>>>, public ActorCallback< GetActiveFeedsActor, 0, RangeResult >, public FastAllocated<GetActiveFeedsActor>, public GetActiveFeedsActorState<GetActiveFeedsActor> {
															#line 4989 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
public:
	using FastAllocated<GetActiveFeedsActor>::operator new;
	using FastAllocated<GetActiveFeedsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5441236287595383296UL, 13256366346535106816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<Key, KeyRange>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetActiveFeedsActor, 0, RangeResult >;
															#line 501 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	GetActiveFeedsActor(Transaction* const& tr) 
															#line 5006 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		 : Actor<std::vector<std::pair<Key, KeyRange>>>(),
		   GetActiveFeedsActorState<GetActiveFeedsActor>(tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getActiveFeeds", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8324093594121271040UL, 11969549241492653056UL);
		ActorExecutionContextHelper __helper(static_cast<GetActiveFeedsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getActiveFeeds");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getActiveFeeds", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetActiveFeedsActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 501 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
[[nodiscard]] Future<std::vector<std::pair<Key, KeyRange>>> getActiveFeeds( Transaction* const& tr ) {
															#line 501 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	return Future<std::vector<std::pair<Key, KeyRange>>>(new GetActiveFeedsActor(tr));
															#line 5039 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
}

#line 519 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"

// TODO: add debug parameter
// FIXME: this check currently assumes blob granules are the only users of change feeds, and will fail if that is not
// the case
															#line 5047 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
namespace {
// This generated class is to be used only via checkFeedCleanup()
															#line 523 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
template <class CheckFeedCleanupActor>
															#line 523 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
class CheckFeedCleanupActorState {
															#line 5054 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
public:
															#line 523 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	CheckFeedCleanupActorState(Database const& cx,bool const& debug) 
															#line 523 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
															#line 523 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		 : cx(cx),
															#line 523 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   debug(debug)
															#line 5063 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
	{
		fdb_probe_actor_create("checkFeedCleanup", reinterpret_cast<unsigned long>(this));

	}
	~CheckFeedCleanupActorState() 
	{
		fdb_probe_actor_destroy("checkFeedCleanup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 524 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (SERVER_KNOBS->BLOB_WORKER_FORCE_FLUSH_CLEANUP_DELAY < 0)
															#line 5078 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 526 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				if (!static_cast<CheckFeedCleanupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckFeedCleanupActorState(); static_cast<CheckFeedCleanupActor*>(this)->destroy(); return 0; }
															#line 5082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				new (&static_cast<CheckFeedCleanupActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CheckFeedCleanupActorState();
				static_cast<CheckFeedCleanupActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 530 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			checkTimeoutSpeedupSim = 100.0 + 2 * SERVER_KNOBS->BLOB_WORKER_FORCE_FLUSH_CLEANUP_DELAY;
															#line 531 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			checkTimeoutOnceStable = 250.0 + checkTimeoutSpeedupSim;
															#line 532 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			stableTimestamp = Optional<double>();
															#line 533 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			speedUpSimTimestamp = Optional<double>();
															#line 534 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			lastGranules = Standalone<VectorRef<KeyRangeRef>>();
															#line 536 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			tr = Transaction(cx);
															#line 537 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			;
															#line 5102 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckFeedCleanupActorState();
		static_cast<CheckFeedCleanupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 540 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRangeRef>>> __when_expr_0 = tr.getBlobGranuleRanges(normalKeys, 10000);
															#line 540 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<CheckFeedCleanupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5135 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckFeedCleanupActor*>(this)->actor_wait_state = 1;
															#line 540 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckFeedCleanupActor, 0, Standalone<VectorRef<KeyRangeRef>> >*>(static_cast<CheckFeedCleanupActor*>(this)));
															#line 5140 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 609 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 609 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<CheckFeedCleanupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5164 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckFeedCleanupActor*>(this)->actor_wait_state = 4;
															#line 609 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckFeedCleanupActor, 3, Void >*>(static_cast<CheckFeedCleanupActor*>(this)));
															#line 5169 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 541 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		StrictFuture<std::vector<std::pair<Key, KeyRange>>> __when_expr_1 = getActiveFeeds(&tr);
															#line 541 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (static_cast<CheckFeedCleanupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5186 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckFeedCleanupActor*>(this)->actor_wait_state = 2;
															#line 541 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckFeedCleanupActor, 1, std::vector<std::pair<Key, KeyRange>> >*>(static_cast<CheckFeedCleanupActor*>(this)));
															#line 5191 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<KeyRangeRef>> const& __granules,int loopDepth) 
	{
															#line 540 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		granules = __granules;
															#line 5200 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<KeyRangeRef>> && __granules,int loopDepth) 
	{
		granules = std::move(__granules);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckFeedCleanupActor*>(this)->actor_wait_state > 0) static_cast<CheckFeedCleanupActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFeedCleanupActor*>(this)->ActorCallback< CheckFeedCleanupActor, 0, Standalone<VectorRef<KeyRangeRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFeedCleanupActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> const& value) 
	{
		fdb_probe_actor_enter("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedCleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckFeedCleanupActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> && value) 
	{
		fdb_probe_actor_enter("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedCleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckFeedCleanupActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedCleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 544 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (debug)
															#line 5279 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 545 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			fmt::print("{0} granules and {1} active feeds found @ {2}\n", granules.size(), activeFeeds.size(), tr.getReadVersion().get());
															#line 5283 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		}
															#line 551 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		bool allPresent = granules.size() == activeFeeds.size();
															#line 566 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		for(int i = 0;allPresent && i < granules.size();i++) {
															#line 567 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (granules[i] != activeFeeds[i].second)
															#line 5291 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 568 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				if (debug)
															#line 5295 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				{
															#line 569 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
					fmt::print("Feed {0} for [{1} - {2}) still exists despite no granule!\n", activeFeeds[i].first.printable(), activeFeeds[i].second.begin.printable(), activeFeeds[i].second.end.printable());
															#line 5299 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				}
															#line 574 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				allPresent = false;
															#line 5303 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
				break;
			}
		}
															#line 578 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (allPresent)
															#line 5309 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 579 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (debug)
															#line 5313 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 580 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				fmt::print("Feed Cleanup Check Complete\n");
															#line 5317 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			}
															#line 582 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (!static_cast<CheckFeedCleanupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckFeedCleanupActorState(); static_cast<CheckFeedCleanupActor*>(this)->destroy(); return 0; }
															#line 5321 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			new (&static_cast<CheckFeedCleanupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckFeedCleanupActorState();
			static_cast<CheckFeedCleanupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 584 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (granules != lastGranules)
															#line 5329 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 585 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			stableTimestamp.reset();
															#line 5333 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		}
		else
		{
															#line 586 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (!stableTimestamp.present())
															#line 5339 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 587 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				stableTimestamp = now();
															#line 5343 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			}
		}
															#line 589 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		lastGranules = granules;
															#line 590 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (g_network->isSimulated())
															#line 5350 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 591 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (g_simulator->speedUpSimulation && !speedUpSimTimestamp.present())
															#line 5354 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 592 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				speedUpSimTimestamp = now();
															#line 5358 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			}
		}
		else
		{
															#line 595 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			speedUpSimTimestamp = 0.0;
															#line 5365 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		}
															#line 599 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (stableTimestamp.present() && speedUpSimTimestamp.present())
															#line 5369 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 600 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			bool granulesStable = now() - stableTimestamp.get() > checkTimeoutOnceStable;
															#line 601 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			bool speedUpSimStable = now() - stableTimestamp.get() > checkTimeoutSpeedupSim;
															#line 602 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			ASSERT(!granulesStable || !speedUpSimStable);
															#line 5377 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		}
															#line 605 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(2.0);
															#line 605 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (static_cast<CheckFeedCleanupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5383 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckFeedCleanupActor*>(this)->actor_wait_state = 3;
															#line 605 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckFeedCleanupActor, 2, Void >*>(static_cast<CheckFeedCleanupActor*>(this)));
															#line 5388 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<std::pair<Key, KeyRange>> const& __activeFeeds,int loopDepth) 
	{
															#line 541 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		activeFeeds = __activeFeeds;
															#line 5397 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<std::pair<Key, KeyRange>> && __activeFeeds,int loopDepth) 
	{
		activeFeeds = std::move(__activeFeeds);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckFeedCleanupActor*>(this)->actor_wait_state > 0) static_cast<CheckFeedCleanupActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFeedCleanupActor*>(this)->ActorCallback< CheckFeedCleanupActor, 1, std::vector<std::pair<Key, KeyRange>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFeedCleanupActor, 1, std::vector<std::pair<Key, KeyRange>> >*,std::vector<std::pair<Key, KeyRange>> const& value) 
	{
		fdb_probe_actor_enter("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedCleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckFeedCleanupActor, 1, std::vector<std::pair<Key, KeyRange>> >*,std::vector<std::pair<Key, KeyRange>> && value) 
	{
		fdb_probe_actor_enter("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedCleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckFeedCleanupActor, 1, std::vector<std::pair<Key, KeyRange>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedCleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 607 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		tr.reset();
															#line 5476 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = a_body1loopBody1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 607 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		tr.reset();
															#line 5485 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = a_body1loopBody1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckFeedCleanupActor*>(this)->actor_wait_state > 0) static_cast<CheckFeedCleanupActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFeedCleanupActor*>(this)->ActorCallback< CheckFeedCleanupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFeedCleanupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedCleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckFeedCleanupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedCleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckFeedCleanupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedCleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont19(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckFeedCleanupActor*>(this)->actor_wait_state > 0) static_cast<CheckFeedCleanupActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFeedCleanupActor*>(this)->ActorCallback< CheckFeedCleanupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFeedCleanupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedCleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckFeedCleanupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedCleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckFeedCleanupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedCleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFeedCleanup", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 523 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Database cx;
															#line 523 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	bool debug;
															#line 530 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	double checkTimeoutSpeedupSim;
															#line 531 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	double checkTimeoutOnceStable;
															#line 532 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Optional<double> stableTimestamp;
															#line 533 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Optional<double> speedUpSimTimestamp;
															#line 534 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> lastGranules;
															#line 536 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Transaction tr;
															#line 540 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> granules;
															#line 541 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	std::vector<std::pair<Key, KeyRange>> activeFeeds;
															#line 5685 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
};
// This generated class is to be used only via checkFeedCleanup()
															#line 523 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
class CheckFeedCleanupActor final : public Actor<Void>, public ActorCallback< CheckFeedCleanupActor, 0, Standalone<VectorRef<KeyRangeRef>> >, public ActorCallback< CheckFeedCleanupActor, 1, std::vector<std::pair<Key, KeyRange>> >, public ActorCallback< CheckFeedCleanupActor, 2, Void >, public ActorCallback< CheckFeedCleanupActor, 3, Void >, public FastAllocated<CheckFeedCleanupActor>, public CheckFeedCleanupActorState<CheckFeedCleanupActor> {
															#line 5690 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
public:
	using FastAllocated<CheckFeedCleanupActor>::operator new;
	using FastAllocated<CheckFeedCleanupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6575026858702001408UL, 1088260723147763968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckFeedCleanupActor, 0, Standalone<VectorRef<KeyRangeRef>> >;
friend struct ActorCallback< CheckFeedCleanupActor, 1, std::vector<std::pair<Key, KeyRange>> >;
friend struct ActorCallback< CheckFeedCleanupActor, 2, Void >;
friend struct ActorCallback< CheckFeedCleanupActor, 3, Void >;
															#line 523 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	CheckFeedCleanupActor(Database const& cx,bool const& debug) 
															#line 5710 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		 : Actor<Void>(),
		   CheckFeedCleanupActorState<CheckFeedCleanupActor>(cx, debug),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkFeedCleanup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14141932498191150848UL, 16487266356794178560UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFeedCleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkFeedCleanup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkFeedCleanup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckFeedCleanupActor, 0, Standalone<VectorRef<KeyRangeRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckFeedCleanupActor, 1, std::vector<std::pair<Key, KeyRange>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckFeedCleanupActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckFeedCleanupActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 523 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
[[nodiscard]] Future<Void> checkFeedCleanup( Database const& cx, bool const& debug ) {
															#line 523 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	return Future<Void>(new CheckFeedCleanupActor(cx, debug));
															#line 5746 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
}

#line 613 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"

															#line 5751 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
namespace {
// This generated class is to be used only via killBlobWorkers()
															#line 614 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
template <class KillBlobWorkersActor>
															#line 614 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
class KillBlobWorkersActorState {
															#line 5758 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
public:
															#line 614 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	KillBlobWorkersActorState(Database const& cx) 
															#line 614 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
															#line 614 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		 : cx(cx),
															#line 615 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   tr(cx),
															#line 616 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   knownWorkers(),
															#line 617 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		   first(true)
															#line 5771 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
	{
		fdb_probe_actor_create("killBlobWorkers", reinterpret_cast<unsigned long>(this));

	}
	~KillBlobWorkersActorState() 
	{
		fdb_probe_actor_destroy("killBlobWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 618 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			;
															#line 5786 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~KillBlobWorkersActorState();
		static_cast<KillBlobWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 619 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 620 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 621 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 622 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 5822 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		try {
															#line 624 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(blobWorkerListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 624 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<KillBlobWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5828 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<KillBlobWorkersActor*>(this)->actor_wait_state = 1;
															#line 624 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< KillBlobWorkersActor, 0, RangeResult >*>(static_cast<KillBlobWorkersActor*>(this)));
															#line 5833 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 654 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 654 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<KillBlobWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5857 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<KillBlobWorkersActor*>(this)->actor_wait_state = 4;
															#line 654 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< KillBlobWorkersActor, 3, Void >*>(static_cast<KillBlobWorkersActor*>(this)));
															#line 5862 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& r,int loopDepth) 
	{
															#line 626 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		haltIds = std::vector<UID>();
															#line 627 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		haltRequests = std::vector<Future<ErrorOr<Void>>>();
															#line 628 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		for( auto& it : r ) {
															#line 629 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			BlobWorkerInterface interf = decodeBlobWorkerListValue(it.value);
															#line 630 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (first)
															#line 5885 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 631 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				knownWorkers.insert(interf.id());
															#line 5889 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			}
															#line 633 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (knownWorkers.contains(interf.id()))
															#line 5893 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 634 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				haltIds.push_back(interf.id());
															#line 635 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				haltRequests.push_back(interf.haltBlobWorker.tryGetReply(HaltBlobWorkerRequest(1e6, UID())));
															#line 5899 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			}
		}
															#line 638 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		first = false;
															#line 639 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(haltRequests);
															#line 639 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (static_cast<KillBlobWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5908 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<KillBlobWorkersActor*>(this)->actor_wait_state = 2;
															#line 639 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< KillBlobWorkersActor, 1, Void >*>(static_cast<KillBlobWorkersActor*>(this)));
															#line 5913 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && r,int loopDepth) 
	{
															#line 626 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		haltIds = std::vector<UID>();
															#line 627 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		haltRequests = std::vector<Future<ErrorOr<Void>>>();
															#line 628 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		for( auto& it : r ) {
															#line 629 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			BlobWorkerInterface interf = decodeBlobWorkerListValue(it.value);
															#line 630 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (first)
															#line 5930 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 631 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				knownWorkers.insert(interf.id());
															#line 5934 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			}
															#line 633 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (knownWorkers.contains(interf.id()))
															#line 5938 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 634 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				haltIds.push_back(interf.id());
															#line 635 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				haltRequests.push_back(interf.haltBlobWorker.tryGetReply(HaltBlobWorkerRequest(1e6, UID())));
															#line 5944 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			}
		}
															#line 638 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		first = false;
															#line 639 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(haltRequests);
															#line 639 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (static_cast<KillBlobWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5953 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<KillBlobWorkersActor*>(this)->actor_wait_state = 2;
															#line 639 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< KillBlobWorkersActor, 1, Void >*>(static_cast<KillBlobWorkersActor*>(this)));
															#line 5958 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& r,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(r, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && r,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<KillBlobWorkersActor*>(this)->actor_wait_state > 0) static_cast<KillBlobWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<KillBlobWorkersActor*>(this)->ActorCallback< KillBlobWorkersActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< KillBlobWorkersActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("killBlobWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killBlobWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< KillBlobWorkersActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("killBlobWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killBlobWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< KillBlobWorkersActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("killBlobWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killBlobWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 640 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		bool allPresent = true;
															#line 641 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		for(int i = 0;i < haltRequests.size();i++) {
															#line 642 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (haltRequests[i].get().present())
															#line 6046 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 643 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				knownWorkers.erase(haltIds[i]);
															#line 6050 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			}
			else
			{
															#line 645 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				allPresent = false;
															#line 6056 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			}
		}
															#line 648 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (allPresent)
															#line 6061 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 649 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (!static_cast<KillBlobWorkersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~KillBlobWorkersActorState(); static_cast<KillBlobWorkersActor*>(this)->destroy(); return 0; }
															#line 6065 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			new (&static_cast<KillBlobWorkersActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~KillBlobWorkersActorState();
			static_cast<KillBlobWorkersActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 651 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(1.0);
															#line 651 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<KillBlobWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6077 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<KillBlobWorkersActor*>(this)->actor_wait_state = 3;
															#line 651 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< KillBlobWorkersActor, 2, Void >*>(static_cast<KillBlobWorkersActor*>(this)));
															#line 6082 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 640 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		bool allPresent = true;
															#line 641 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		for(int i = 0;i < haltRequests.size();i++) {
															#line 642 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (haltRequests[i].get().present())
															#line 6096 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			{
															#line 643 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				knownWorkers.erase(haltIds[i]);
															#line 6100 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			}
			else
			{
															#line 645 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
				allPresent = false;
															#line 6106 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			}
		}
															#line 648 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
		if (allPresent)
															#line 6111 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		{
															#line 649 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (!static_cast<KillBlobWorkersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~KillBlobWorkersActorState(); static_cast<KillBlobWorkersActor*>(this)->destroy(); return 0; }
															#line 6115 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			new (&static_cast<KillBlobWorkersActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~KillBlobWorkersActorState();
			static_cast<KillBlobWorkersActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 651 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(1.0);
															#line 651 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			if (static_cast<KillBlobWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6127 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<KillBlobWorkersActor*>(this)->actor_wait_state = 3;
															#line 651 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< KillBlobWorkersActor, 2, Void >*>(static_cast<KillBlobWorkersActor*>(this)));
															#line 6132 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<KillBlobWorkersActor*>(this)->actor_wait_state > 0) static_cast<KillBlobWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<KillBlobWorkersActor*>(this)->ActorCallback< KillBlobWorkersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KillBlobWorkersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("killBlobWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killBlobWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< KillBlobWorkersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("killBlobWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killBlobWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< KillBlobWorkersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("killBlobWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killBlobWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<KillBlobWorkersActor*>(this)->actor_wait_state > 0) static_cast<KillBlobWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<KillBlobWorkersActor*>(this)->ActorCallback< KillBlobWorkersActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KillBlobWorkersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("killBlobWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killBlobWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< KillBlobWorkersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("killBlobWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killBlobWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< KillBlobWorkersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("killBlobWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killBlobWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont13(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<KillBlobWorkersActor*>(this)->actor_wait_state > 0) static_cast<KillBlobWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<KillBlobWorkersActor*>(this)->ActorCallback< KillBlobWorkersActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KillBlobWorkersActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("killBlobWorkers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killBlobWorkers", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< KillBlobWorkersActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("killBlobWorkers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killBlobWorkers", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< KillBlobWorkersActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("killBlobWorkers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killBlobWorkers", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 614 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Database cx;
															#line 615 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	Transaction tr;
															#line 616 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	std::set<UID> knownWorkers;
															#line 617 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	bool first;
															#line 626 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	std::vector<UID> haltIds;
															#line 627 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	std::vector<Future<ErrorOr<Void>>> haltRequests;
															#line 6418 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
};
// This generated class is to be used only via killBlobWorkers()
															#line 614 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
class KillBlobWorkersActor final : public Actor<Void>, public ActorCallback< KillBlobWorkersActor, 0, RangeResult >, public ActorCallback< KillBlobWorkersActor, 1, Void >, public ActorCallback< KillBlobWorkersActor, 2, Void >, public ActorCallback< KillBlobWorkersActor, 3, Void >, public FastAllocated<KillBlobWorkersActor>, public KillBlobWorkersActorState<KillBlobWorkersActor> {
															#line 6423 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
public:
	using FastAllocated<KillBlobWorkersActor>::operator new;
	using FastAllocated<KillBlobWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16718303782251340288UL, 6158199097635828736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< KillBlobWorkersActor, 0, RangeResult >;
friend struct ActorCallback< KillBlobWorkersActor, 1, Void >;
friend struct ActorCallback< KillBlobWorkersActor, 2, Void >;
friend struct ActorCallback< KillBlobWorkersActor, 3, Void >;
															#line 614 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	KillBlobWorkersActor(Database const& cx) 
															#line 6443 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
		 : Actor<Void>(),
		   KillBlobWorkersActorState<KillBlobWorkersActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("killBlobWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16414108302742818048UL, 11014779539997508608UL);
		ActorExecutionContextHelper __helper(static_cast<KillBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("killBlobWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("killBlobWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< KillBlobWorkersActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< KillBlobWorkersActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< KillBlobWorkersActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< KillBlobWorkersActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 614 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
[[nodiscard]] Future<Void> killBlobWorkers( Database const& cx ) {
															#line 614 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
	return Future<Void>(new KillBlobWorkersActor(cx));
															#line 6479 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleValidation.actor.g.cpp"
}

#line 658 "/codebuild/output/src530198565/src/github.com/apple/foundationdb/fdbserver/BlobGranuleValidation.actor.cpp"
