/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.FDBTransaction;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.CloseableAsyncIterator;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;

public class LocalityUtil {
    private static final Charset ASCII = Charset.forName("US-ASCII");

    public static CloseableAsyncIterator<byte[]> getBoundaryKeys(Database database, byte[] byArray, byte[] byArray2) {
        return LocalityUtil.getBoundaryKeys_internal(database.createTransaction(), byArray, byArray2);
    }

    public static CloseableAsyncIterator<byte[]> getBoundaryKeys(Transaction transaction, byte[] byArray, byte[] byArray2) {
        Transaction transaction2 = transaction.getDatabase().createTransaction(transaction.getExecutor());
        CompletableFuture<Long> completableFuture = transaction.getReadVersion();
        if (completableFuture.isDone() && !completableFuture.isCompletedExceptionally()) {
            transaction2.setReadVersion((Long)completableFuture.getNow(null));
        }
        return new BoundaryIterator(transaction2, byArray, byArray2);
    }

    public static CompletableFuture<String[]> getAddressesForKey(Transaction transaction, byte[] byArray) {
        if (!(transaction instanceof FDBTransaction)) {
            CompletableFuture<String[]> completableFuture = new CompletableFuture<String[]>();
            completableFuture.completeExceptionally(new FDBException("locality_information_unavailable", 1033));
            return completableFuture;
        }
        return ((FDBTransaction)transaction).getAddressesForKey(byArray);
    }

    private static CloseableAsyncIterator<byte[]> getBoundaryKeys_internal(Transaction transaction, byte[] byArray, byte[] byArray2) {
        return new BoundaryIterator(transaction, byArray, byArray2);
    }

    static byte[] keyServersForKey(byte[] byArray) {
        return ByteArrayUtil.join({-1}, "/keyServers/".getBytes(ASCII), byArray);
    }

    private LocalityUtil() {
    }

    static class BoundaryIterator
    implements CloseableAsyncIterator<byte[]> {
        Transaction tr;
        byte[] begin;
        byte[] lastBegin;
        final byte[] end;
        final AsyncIterable<KeyValue> firstGet;
        AsyncIterator<KeyValue> block;
        private CompletableFuture<Boolean> nextFuture;
        private boolean closed;
        BiFunction<Boolean, Throwable, CompletableFuture<Boolean>> handler = new BiFunction<Boolean, Throwable, CompletableFuture<Boolean>>(){

            @Override
            public CompletableFuture<Boolean> apply(Boolean bl, Throwable throwable) {
                Object object;
                if (bl != null) {
                    return CompletableFuture.completedFuture(bl);
                }
                if (throwable instanceof FDBException && ((FDBException)(object = (FDBException)throwable)).getCode() == 1007 && !Arrays.equals(begin, lastBegin)) {
                    Executor executor = tr.getExecutor();
                    tr.close();
                    tr = tr.getDatabase().createTransaction(executor);
                    return this.restartGet();
                }
                if (!(throwable instanceof RuntimeException)) {
                    throw new CompletionException(throwable);
                }
                object = tr.onError(throwable);
                return ((CompletableFuture)object).thenComposeAsync(transaction -> {
                    tr = transaction;
                    return this.restartGet();
                }, tr.getExecutor());
            }
        };

        BoundaryIterator(Transaction transaction, byte[] byArray, byte[] byArray2) {
            this.tr = transaction;
            this.begin = Arrays.copyOf(byArray, byArray.length);
            this.end = Arrays.copyOf(byArray2, byArray2.length);
            this.lastBegin = byArray;
            transaction.options().setReadSystemKeys();
            transaction.options().setLockAware();
            this.firstGet = transaction.getRange(LocalityUtil.keyServersForKey(byArray), LocalityUtil.keyServersForKey(byArray2));
            this.block = this.firstGet.iterator();
            this.nextFuture = AsyncUtil.composeHandleAsync(this.block.onHasNext(), this.handler, transaction.getExecutor());
            this.closed = false;
        }

        @Override
        public CompletableFuture<Boolean> onHasNext() {
            return this.nextFuture;
        }

        @Override
        public boolean hasNext() {
            return this.nextFuture.join();
        }

        CompletableFuture<Boolean> restartGet() {
            if (ByteArrayUtil.compareUnsigned(this.begin, this.end) >= 0) {
                return AsyncUtil.READY_FALSE;
            }
            this.lastBegin = this.begin;
            this.tr.options().setReadSystemKeys();
            this.block = this.tr.getRange(LocalityUtil.keyServersForKey(this.begin), LocalityUtil.keyServersForKey(this.end)).iterator();
            this.nextFuture = AsyncUtil.composeHandleAsync(this.block.onHasNext(), this.handler, this.tr.getExecutor());
            return this.nextFuture;
        }

        @Override
        public byte[] next() {
            if (!this.nextFuture.isDone()) {
                throw new IllegalStateException("Call to next without hasNext()=true");
            }
            KeyValue keyValue = this.block.next();
            byte[] byArray = keyValue.getKey();
            byte[] byArray2 = Arrays.copyOfRange(byArray, 13, byArray.length);
            this.begin = ByteArrayUtil.join(byArray2, {0});
            this.nextFuture = AsyncUtil.composeHandleAsync(this.block.onHasNext(), this.handler, this.tr.getExecutor());
            return byArray2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Boundary keys are read-only");
        }

        @Override
        public void close() {
            this.tr.close();
            this.closed = true;
        }

        protected void finalize() throws Throwable {
            try {
                if (FDB.instance().warnOnUnclosed && !this.closed) {
                    System.err.println("CloseableAsyncIterator not closed (getBoundaryKeys)");
                }
                if (!this.closed) {
                    this.close();
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

