/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.KeyRangeArrayResult;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.RequiresDatabase;
import com.apple.foundationdb.Tenant;
import com.apple.foundationdb.TenantManagement;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={RequiresDatabase.class})
class BlobGranuleIntegrationTest {
    private static final FDB fdb = FDB.selectAPIVersion((int)740);

    BlobGranuleIntegrationTest() {
    }

    @BeforeEach
    @AfterEach
    void clearDatabase() throws Exception {
        try (Database database = fdb.open();){
            database.run(transaction -> {
                transaction.clear(new byte[0], new byte[]{-1});
                return null;
            });
        }
    }

    @Test
    void blobManagementFunctionsTest() throws Exception {
        Random random = new Random();
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[8];
        random.nextBytes(byArray);
        byArray[0] = 48;
        random.nextBytes(byArray2);
        Range range = Range.startsWith((byte[])byArray);
        try (Database database = fdb.open();){
            boolean bl = (Boolean)database.blobbifyRangeBlocking(range.begin, range.end).join();
            Assertions.assertTrue((boolean)bl);
            Long l = (Long)database.verifyBlobRange(range.begin, range.end).join();
            Assertions.assertTrue((l >= 0L ? 1 : 0) != 0);
            KeyRangeArrayResult keyRangeArrayResult = (KeyRangeArrayResult)database.listBlobbifiedRanges(range.begin, range.end, 2).join();
            Assertions.assertEquals((int)1, (int)keyRangeArrayResult.getKeyRanges().size());
            Assertions.assertArrayEquals((byte[])range.begin, (byte[])((Range)keyRangeArrayResult.getKeyRanges().get((int)0)).begin);
            Assertions.assertArrayEquals((byte[])range.end, (byte[])((Range)keyRangeArrayResult.getKeyRanges().get((int)0)).end);
            boolean bl2 = (Boolean)database.flushBlobRange(range.begin, range.end, false).join();
            Assertions.assertTrue((boolean)bl2);
            Long l2 = (Long)database.verifyBlobRange(range.begin, range.end).join();
            Assertions.assertTrue((l2 >= 0L ? 1 : 0) != 0);
            Assertions.assertTrue((l2 >= l ? 1 : 0) != 0);
            boolean bl3 = (Boolean)database.flushBlobRange(range.begin, range.end, true).join();
            Assertions.assertTrue((boolean)bl3);
            Long l3 = (Long)database.verifyBlobRange(range.begin, range.end).join();
            Assertions.assertTrue((l3 >= 0L ? 1 : 0) != 0);
            Assertions.assertTrue((l3 >= l2 ? 1 : 0) != 0);
            byte[] byArray3 = (byte[])database.purgeBlobGranules(range.begin, range.end, -2L, false).join();
            database.waitPurgeGranulesComplete(byArray3).join();
            Long l4 = (Long)database.verifyBlobRange(range.begin, range.end).join();
            Assertions.assertTrue((l4 >= 0L ? 1 : 0) != 0);
            Assertions.assertTrue((l4 >= l3 ? 1 : 0) != 0);
            byte[] byArray4 = (byte[])database.purgeBlobGranules(range.begin, range.end, -2L, true).join();
            database.waitPurgeGranulesComplete(byArray4).join();
            Long l5 = (Long)database.verifyBlobRange(range.begin, range.end).join();
            Assertions.assertEquals((long)-1L, (Long)l5);
            boolean bl4 = (Boolean)database.unblobbifyRange(range.begin, range.end).join();
            Assertions.assertTrue((boolean)bl4);
            System.out.println("Blob granule management tests complete!");
        }
    }

    @Test
    void blobManagementFunctionsTenantTest() throws Exception {
        Random random = new Random();
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[8];
        random.nextBytes(byArray);
        byArray[0] = 48;
        random.nextBytes(byArray2);
        Range range = Range.startsWith((byte[])byArray);
        byte[] byArray3 = "BGManagementTenant".getBytes();
        try (Database database = fdb.open();){
            TenantManagement.createTenant((Database)database, (byte[])byArray3).join();
            System.out.println("Created tenant for test");
            try (Tenant tenant = database.openTenant(byArray3);){
                System.out.println("Opened tenant for test");
                boolean bl = (Boolean)tenant.blobbifyRangeBlocking(range.begin, range.end).join();
                Assertions.assertTrue((boolean)bl);
                Long l = (Long)tenant.verifyBlobRange(range.begin, range.end).join();
                Assertions.assertTrue((l >= 0L ? 1 : 0) != 0);
                KeyRangeArrayResult keyRangeArrayResult = (KeyRangeArrayResult)tenant.listBlobbifiedRanges(range.begin, range.end, 2).join();
                Assertions.assertEquals((int)1, (int)keyRangeArrayResult.getKeyRanges().size());
                Assertions.assertArrayEquals((byte[])range.begin, (byte[])((Range)keyRangeArrayResult.getKeyRanges().get((int)0)).begin);
                Assertions.assertArrayEquals((byte[])range.end, (byte[])((Range)keyRangeArrayResult.getKeyRanges().get((int)0)).end);
                boolean bl2 = (Boolean)tenant.flushBlobRange(range.begin, range.end, false).join();
                Assertions.assertTrue((boolean)bl2);
                Long l2 = (Long)tenant.verifyBlobRange(range.begin, range.end).join();
                Assertions.assertTrue((l2 >= 0L ? 1 : 0) != 0);
                Assertions.assertTrue((l2 >= l ? 1 : 0) != 0);
                boolean bl3 = (Boolean)tenant.flushBlobRange(range.begin, range.end, true).join();
                Assertions.assertTrue((boolean)bl3);
                Long l3 = (Long)tenant.verifyBlobRange(range.begin, range.end).join();
                Assertions.assertTrue((l3 >= 0L ? 1 : 0) != 0);
                Assertions.assertTrue((l3 >= l2 ? 1 : 0) != 0);
                byte[] byArray4 = (byte[])tenant.purgeBlobGranules(range.begin, range.end, -2L, false).join();
                database.waitPurgeGranulesComplete(byArray4).join();
                Long l4 = (Long)tenant.verifyBlobRange(range.begin, range.end).join();
                Assertions.assertTrue((l4 >= 0L ? 1 : 0) != 0);
                Assertions.assertTrue((l4 >= l3 ? 1 : 0) != 0);
                byte[] byArray5 = (byte[])tenant.purgeBlobGranules(range.begin, range.end, -2L, true).join();
                tenant.waitPurgeGranulesComplete(byArray5).join();
                Long l5 = (Long)tenant.verifyBlobRange(range.begin, range.end).join();
                Assertions.assertEquals((long)-1L, (Long)l5);
                boolean bl4 = (Boolean)tenant.unblobbifyRange(range.begin, range.end).join();
                Assertions.assertTrue((boolean)bl4);
                System.out.println("Blob granule management tenant tests complete!");
            }
        }
    }
}

