#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
/*
 * HighContentionPrefixAllocatorWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/HighContentionPrefixAllocator.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// This workload tests the basic contract of the high contention allocator
struct HighContentionPrefixAllocatorWorkload : TestWorkload {
	static constexpr auto NAME = "HighContentionPrefixAllocator";

	Subspace allocatorSubspace;
	HighContentionPrefixAllocator allocator;
	int numRounds;
	int maxTransactionsPerRound;
	int maxAllocationsPerTransaction;

	int expectedPrefixes = 0;
	std::set<Key> allocatedPrefixes;

	HighContentionPrefixAllocatorWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), allocatorSubspace("test_subspace"_sr), allocator(allocatorSubspace) {
		numRounds = getOption(options, "numRounds"_sr, 100);
		maxTransactionsPerRound = getOption(options, "maxTransactionsPerRound"_sr, 20);
		maxAllocationsPerTransaction = getOption(options, "maxAllocationsPerTransaction"_sr, 20);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

																#line 50 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
// This generated class is to be used only via runAllocationTransaction()
															#line 48 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
template <class RunAllocationTransactionActor>
															#line 48 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
class RunAllocationTransactionActorState {
															#line 56 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
public:
															#line 48 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	RunAllocationTransactionActorState(Database const& cx,HighContentionPrefixAllocatorWorkload* const& self) 
															#line 48 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
															#line 48 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		 : cx(cx),
															#line 48 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		   self(self),
															#line 49 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		   tr(cx->createTransaction()),
															#line 51 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		   numAllocations(deterministicRandom()->randomInt(1, self->maxAllocationsPerTransaction + 1))
															#line 69 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("runAllocationTransaction", reinterpret_cast<unsigned long>(this));

	}
	~RunAllocationTransactionActorState() 
	{
		fdb_probe_actor_destroy("runAllocationTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 52 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			self->expectedPrefixes += numAllocations;
															#line 54 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			;
															#line 86 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunAllocationTransactionActorState();
		static_cast<RunAllocationTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 102 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		if (!static_cast<RunAllocationTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunAllocationTransactionActorState(); static_cast<RunAllocationTransactionActor*>(this)->destroy(); return 0; }
															#line 109 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		new (&static_cast<RunAllocationTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunAllocationTransactionActorState();
		static_cast<RunAllocationTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 56 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			futures = std::vector<Future<Key>>();
															#line 57 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			for(int i = 0;i < numAllocations;++i) {
															#line 58 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
				futures.push_back(self->allocator.allocate(tr));
															#line 133 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			}
															#line 61 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(futures);
															#line 61 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			if (static_cast<RunAllocationTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 139 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunAllocationTransactionActor*>(this)->actor_wait_state = 1;
															#line 61 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunAllocationTransactionActor, 0, Void >*>(static_cast<RunAllocationTransactionActor*>(this)));
															#line 144 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 98 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 98 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			if (static_cast<RunAllocationTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 181 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunAllocationTransactionActor*>(this)->actor_wait_state = 3;
															#line 98 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunAllocationTransactionActor, 2, Void >*>(static_cast<RunAllocationTransactionActor*>(this)));
															#line 186 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 62 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 62 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		if (static_cast<RunAllocationTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 203 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunAllocationTransactionActor*>(this)->actor_wait_state = 2;
															#line 62 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunAllocationTransactionActor, 1, Void >*>(static_cast<RunAllocationTransactionActor*>(this)));
															#line 208 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 62 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 62 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		if (static_cast<RunAllocationTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 219 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunAllocationTransactionActor*>(this)->actor_wait_state = 2;
															#line 62 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunAllocationTransactionActor, 1, Void >*>(static_cast<RunAllocationTransactionActor*>(this)));
															#line 224 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunAllocationTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunAllocationTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunAllocationTransactionActor*>(this)->ActorCallback< RunAllocationTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunAllocationTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runAllocationTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunAllocationTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runAllocationTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunAllocationTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runAllocationTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunAllocationTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runAllocationTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunAllocationTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runAllocationTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunAllocationTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runAllocationTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 64 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		for( auto f : futures ) {
															#line 65 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			Key prefix = f.get();
															#line 68 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			auto itr = self->allocatedPrefixes.lower_bound(prefix);
															#line 69 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			if (itr != self->allocatedPrefixes.end() && itr->startsWith(prefix))
															#line 314 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			{
															#line 70 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
				TraceEvent(SevError, "HighContentionAllocationWorkloadFailure") .detail("Reason", "Prefix collision") .detail("AllocatedPrefix", prefix) .detail("PreviousPrefix", *itr);
															#line 75 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
				ASSERT(false);
															#line 320 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			}
															#line 79 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			if (itr != self->allocatedPrefixes.begin())
															#line 324 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			{
															#line 80 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
				--itr;
															#line 82 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
				if (prefix.startsWith(*itr))
															#line 330 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
				{
															#line 83 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
					TraceEvent(SevError, "HighContentionAllocationWorkloadFailure") .detail("Reason", "Prefix collision") .detail("AllocatedPrefix", prefix) .detail("PreviousPrefix", *itr);
															#line 88 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
					ASSERT(false);
															#line 336 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
				}
			}
															#line 93 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			ASSERT(self->allocatedPrefixes.insert(f.get()).second);
															#line 341 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 64 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		for( auto f : futures ) {
															#line 65 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			Key prefix = f.get();
															#line 68 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			auto itr = self->allocatedPrefixes.lower_bound(prefix);
															#line 69 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			if (itr != self->allocatedPrefixes.end() && itr->startsWith(prefix))
															#line 357 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			{
															#line 70 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
				TraceEvent(SevError, "HighContentionAllocationWorkloadFailure") .detail("Reason", "Prefix collision") .detail("AllocatedPrefix", prefix) .detail("PreviousPrefix", *itr);
															#line 75 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
				ASSERT(false);
															#line 363 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			}
															#line 79 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			if (itr != self->allocatedPrefixes.begin())
															#line 367 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			{
															#line 80 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
				--itr;
															#line 82 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
				if (prefix.startsWith(*itr))
															#line 373 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
				{
															#line 83 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
					TraceEvent(SevError, "HighContentionAllocationWorkloadFailure") .detail("Reason", "Prefix collision") .detail("AllocatedPrefix", prefix) .detail("PreviousPrefix", *itr);
															#line 88 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
					ASSERT(false);
															#line 379 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
				}
			}
															#line 93 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			ASSERT(self->allocatedPrefixes.insert(f.get()).second);
															#line 384 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunAllocationTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunAllocationTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunAllocationTransactionActor*>(this)->ActorCallback< RunAllocationTransactionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunAllocationTransactionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runAllocationTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunAllocationTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runAllocationTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunAllocationTransactionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runAllocationTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunAllocationTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runAllocationTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunAllocationTransactionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runAllocationTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunAllocationTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runAllocationTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunAllocationTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunAllocationTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunAllocationTransactionActor*>(this)->ActorCallback< RunAllocationTransactionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunAllocationTransactionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runAllocationTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunAllocationTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runAllocationTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunAllocationTransactionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runAllocationTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunAllocationTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runAllocationTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunAllocationTransactionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runAllocationTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunAllocationTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runAllocationTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 48 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	Database cx;
															#line 48 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	HighContentionPrefixAllocatorWorkload* self;
															#line 49 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 51 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	int numAllocations;
															#line 56 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	std::vector<Future<Key>> futures;
															#line 562 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
};
// This generated class is to be used only via runAllocationTransaction()
															#line 48 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
class RunAllocationTransactionActor final : public Actor<Void>, public ActorCallback< RunAllocationTransactionActor, 0, Void >, public ActorCallback< RunAllocationTransactionActor, 1, Void >, public ActorCallback< RunAllocationTransactionActor, 2, Void >, public FastAllocated<RunAllocationTransactionActor>, public RunAllocationTransactionActorState<RunAllocationTransactionActor> {
															#line 567 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
public:
	using FastAllocated<RunAllocationTransactionActor>::operator new;
	using FastAllocated<RunAllocationTransactionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3792712703424419328UL, 16019450938636682496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunAllocationTransactionActor, 0, Void >;
friend struct ActorCallback< RunAllocationTransactionActor, 1, Void >;
friend struct ActorCallback< RunAllocationTransactionActor, 2, Void >;
															#line 48 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	RunAllocationTransactionActor(Database const& cx,HighContentionPrefixAllocatorWorkload* const& self) 
															#line 586 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RunAllocationTransactionActorState<RunAllocationTransactionActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runAllocationTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(913128017088360192UL, 1634303810017039872UL);
		ActorExecutionContextHelper __helper(static_cast<RunAllocationTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runAllocationTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runAllocationTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunAllocationTransactionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunAllocationTransactionActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunAllocationTransactionActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 48 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
[[nodiscard]] static Future<Void> runAllocationTransaction( Database const& cx, HighContentionPrefixAllocatorWorkload* const& self ) {
															#line 48 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	return Future<Void>(new RunAllocationTransactionActor(cx, self));
															#line 620 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
}

#line 104 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"

																#line 625 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
// This generated class is to be used only via runTest()
															#line 105 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
template <class RunTestActor>
															#line 105 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
class RunTestActorState {
															#line 631 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
public:
															#line 105 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	RunTestActorState(Database const& cx,HighContentionPrefixAllocatorWorkload* const& self) 
															#line 105 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
															#line 105 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		 : cx(cx),
															#line 105 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		   self(self),
															#line 106 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		   roundNum(0)
															#line 642 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("runTest", reinterpret_cast<unsigned long>(this));

	}
	~RunTestActorState() 
	{
		fdb_probe_actor_destroy("runTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 107 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			;
															#line 657 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunTestActorState();
		static_cast<RunTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 117 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		if (!static_cast<RunTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunTestActorState(); static_cast<RunTestActor*>(this)->destroy(); return 0; }
															#line 680 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		new (&static_cast<RunTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunTestActorState();
		static_cast<RunTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 107 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		if (!(roundNum < self->numRounds))
															#line 699 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 108 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		std::vector<Future<Void>> futures;
															#line 109 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		int numTransactions = deterministicRandom()->randomInt(1, self->maxTransactionsPerRound + 1);
															#line 110 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		for(int i = 0;i < numTransactions;++i) {
															#line 111 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			futures.push_back(runAllocationTransaction(cx, self));
															#line 711 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		}
															#line 114 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_0 = waitForAll(futures);
															#line 114 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 717 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 1;
															#line 114 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 0, Void >*>(static_cast<RunTestActor*>(this)));
															#line 722 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 107 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		++roundNum;
															#line 744 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 107 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		++roundNum;
															#line 753 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunTestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 105 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	Database cx;
															#line 105 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	HighContentionPrefixAllocatorWorkload* self;
															#line 106 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	int roundNum;
															#line 839 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
};
// This generated class is to be used only via runTest()
															#line 105 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
class RunTestActor final : public Actor<Void>, public ActorCallback< RunTestActor, 0, Void >, public FastAllocated<RunTestActor>, public RunTestActorState<RunTestActor> {
															#line 844 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
public:
	using FastAllocated<RunTestActor>::operator new;
	using FastAllocated<RunTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12468253530972501248UL, 3302921789607793152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunTestActor, 0, Void >;
															#line 105 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	RunTestActor(Database const& cx,HighContentionPrefixAllocatorWorkload* const& self) 
															#line 861 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RunTestActorState<RunTestActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12013671372596341504UL, 10273208522725205248UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunTestActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 105 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
[[nodiscard]] static Future<Void> runTest( Database const& cx, HighContentionPrefixAllocatorWorkload* const& self ) {
															#line 105 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	return Future<Void>(new RunTestActor(cx, self));
															#line 893 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
}

#line 119 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"

	Future<Void> start(Database const& cx) override { return runTest(cx, this); }

																#line 900 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
// This generated class is to be used only via _check()
															#line 122 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
template <class _checkActor>
															#line 122 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
class _checkActorState {
															#line 906 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
public:
															#line 122 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	_checkActorState(Database const& cx,HighContentionPrefixAllocatorWorkload* const& self) 
															#line 122 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
															#line 122 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		 : cx(cx),
															#line 122 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		   self(self)
															#line 915 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 123 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			if (self->expectedPrefixes != self->allocatedPrefixes.size())
															#line 930 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			{
															#line 124 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
				TraceEvent(SevError, "HighContentionAllocationWorkloadFailure") .detail("Reason", "Incorrect Number of Prefixes Allocated") .detail("NumAllocated", self->allocatedPrefixes.size()) .detail("Expected", self->expectedPrefixes);
															#line 129 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
				if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 936 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
				new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
				this->~_checkActorState();
				static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 132 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			tr = cx->createTransaction();
															#line 133 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			;
															#line 946 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 151 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 969 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 135 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			StrictFuture<Key> __when_expr_0 = tr->getKey(firstGreaterOrEqual(""_sr));
															#line 135 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 991 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 135 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, Key >*>(static_cast<_checkActor*>(this)));
															#line 996 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 147 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 147 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1033 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 3;
															#line 147 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 2, Void >*>(static_cast<_checkActor*>(this)));
															#line 1038 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 136 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		StrictFuture<Key> __when_expr_1 = tr->getKey(lastLessThan("\xff"_sr));
															#line 136 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1055 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 136 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Key >*>(static_cast<_checkActor*>(this)));
															#line 1060 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Key const& __k1,int loopDepth) 
	{
															#line 135 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		k1 = __k1;
															#line 1069 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Key && __k1,int loopDepth) 
	{
		k1 = std::move(__k1);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Key const& k2,int loopDepth) 
	{
															#line 137 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		if (!k1.startsWith(self->allocatorSubspace.key()) || !k2.startsWith(self->allocatorSubspace.key()))
															#line 1148 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		{
															#line 138 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			TraceEvent(SevError, "HighContentionAllocationWorkloadFailure") .detail("Reason", "Keys written outside allocator subspace") .detail("MinKey", k1) .detail("MaxKey", k2);
															#line 143 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1154 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
			this->~_checkActorState();
			static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Key && k2,int loopDepth) 
	{
															#line 137 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
		if (!k1.startsWith(self->allocatorSubspace.key()) || !k2.startsWith(self->allocatorSubspace.key()))
															#line 1168 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		{
															#line 138 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			TraceEvent(SevError, "HighContentionAllocationWorkloadFailure") .detail("Reason", "Keys written outside allocator subspace") .detail("MinKey", k1) .detail("MaxKey", k2);
															#line 143 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
			if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1174 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
			new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
			this->~_checkActorState();
			static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Key const& k2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(k2, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Key && k2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(k2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, Key >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, Key >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _checkActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 122 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	Database cx;
															#line 122 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	HighContentionPrefixAllocatorWorkload* self;
															#line 132 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 135 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	Key k1;
															#line 1354 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
};
// This generated class is to be used only via _check()
															#line 122 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, Key >, public ActorCallback< _checkActor, 1, Key >, public ActorCallback< _checkActor, 2, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 1359 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12053820720389476096UL, 11542199998505335296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, Key >;
friend struct ActorCallback< _checkActor, 1, Key >;
friend struct ActorCallback< _checkActor, 2, Void >;
															#line 122 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	_checkActor(Database const& cx,HighContentionPrefixAllocatorWorkload* const& self) 
															#line 1378 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, Key >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 1, Key >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _checkActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 122 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
[[nodiscard]] static Future<bool> _check( Database const& cx, HighContentionPrefixAllocatorWorkload* const& self ) {
															#line 122 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 1412 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.g.cpp"
}

#line 153 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbserver/workloads/HighContentionPrefixAllocatorWorkload.actor.cpp"
	Future<bool> check(Database const& cx) override { return _check(cx, this); }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};
WorkloadFactory<HighContentionPrefixAllocatorWorkload> HighContentionPrefixAllocatorWorkload;
