#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
/*
 * SuspendCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "boost/algorithm/string.hpp"

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/Knobs.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

															#line 38 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
// This generated class is to be used only via suspendCommandActor()
															#line 36 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
template <class SuspendCommandActorActor>
															#line 36 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
class SuspendCommandActorActorState {
															#line 44 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
public:
															#line 36 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
	SuspendCommandActorActorState(Reference<IDatabase> const& db,Reference<ITransaction> const& tr,std::vector<StringRef> const& tokens,std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface) 
															#line 36 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
															#line 36 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
		 : db(db),
															#line 36 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
		   tr(tr),
															#line 36 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
		   tokens(tokens),
															#line 36 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
		   address_interface(address_interface)
															#line 57 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("suspendCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~SuspendCommandActorActorState() 
	{
		fdb_probe_actor_destroy("suspendCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 40 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
			ASSERT(tokens.size() >= 1);
															#line 41 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
			result = true;
															#line 42 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
			addressesStr = std::string();
															#line 43 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
			if (tokens.size() == 1)
															#line 78 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
			{
															#line 45 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
				address_interface->clear();
															#line 46 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
				StrictFuture<Void> __when_expr_0 = getWorkerInterfaces(tr, address_interface, true);
															#line 46 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
				if (static_cast<SuspendCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 86 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<SuspendCommandActorActor*>(this)->actor_wait_state = 1;
															#line 46 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SuspendCommandActorActor, 0, Void >*>(static_cast<SuspendCommandActorActor*>(this)));
															#line 91 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 58 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
				if (tokens.size() == 2)
															#line 98 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
				{
															#line 59 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
					printUsage(tokens[0]);
															#line 60 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
					result = false;
															#line 104 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
					loopDepth = a_body1cont9(loopDepth);
				}
				else
				{
															#line 62 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
					for(int i = 2;i < tokens.size();i++) {
															#line 63 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
						if (!address_interface->count(tokens[i]))
															#line 113 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
						{
															#line 64 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
							fprintf(stderr, "ERROR: process `%s' not recognized.\n", printable(tokens[i]).c_str());
															#line 65 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
							result = false;
															#line 119 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
							break;
						}
					}
															#line 70 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
					if (result)
															#line 125 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
					{
															#line 71 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
						seconds = double();
															#line 72 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
						int n = 0;
															#line 73 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
						i = int();
															#line 74 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
						auto secondsStr = tokens[1].toString();
															#line 75 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
						if (sscanf(secondsStr.c_str(), "%lf%n", &seconds, &n) != 1 || n != secondsStr.size())
															#line 137 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
						{
															#line 76 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
							printUsage(tokens[0]);
															#line 77 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
							result = false;
															#line 143 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
							loopDepth = a_body1cont14(loopDepth);
						}
						else
						{
															#line 79 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
							std::vector<std::string> addressesVec;
															#line 80 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
							for(i = 2;i < tokens.size();i++) {
															#line 81 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
								addressesVec.push_back(tokens[i].toString());
															#line 154 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
							}
															#line 83 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
							addressesStr = boost::algorithm::join(addressesVec, ",");
															#line 84 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
							StrictFuture<int64_t> __when_expr_1 = safeThreadFutureToFuture(db->rebootWorker(addressesStr, false, static_cast<int>(seconds)));
															#line 84 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
							if (static_cast<SuspendCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 162 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
							if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
							static_cast<SuspendCommandActorActor*>(this)->actor_wait_state = 2;
															#line 84 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
							__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SuspendCommandActorActor, 1, int64_t >*>(static_cast<SuspendCommandActorActor*>(this)));
															#line 167 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
							loopDepth = 0;
						}
					}
					else
					{
						loopDepth = a_body1cont11(loopDepth);
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SuspendCommandActorActorState();
		static_cast<SuspendCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 99 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
		if (!static_cast<SuspendCommandActorActor*>(this)->SAV<bool>::futures) { (void)(result); this->~SuspendCommandActorActorState(); static_cast<SuspendCommandActorActor*>(this)->destroy(); return 0; }
															#line 198 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
		new (&static_cast<SuspendCommandActorActor*>(this)->SAV< bool >::value()) bool(std::move(result)); // state_var_RVO
		this->~SuspendCommandActorActorState();
		static_cast<SuspendCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
		if (address_interface->size() == 0)
															#line 210 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
		{
															#line 48 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
			printf("\nNo addresses can be suspended.\n");
															#line 214 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
		}
		else
		{
															#line 49 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
			if (address_interface->size() == 1)
															#line 220 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
			{
															#line 50 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
				printf("\nThe following address can be suspended:\n");
															#line 224 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
			}
			else
			{
															#line 52 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
				printf("\nThe following %zu addresses can be suspended:\n", address_interface->size());
															#line 230 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
			}
		}
															#line 54 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
		for( auto it : *address_interface ) {
															#line 55 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
			printf("%s\n", printable(it.first).c_str());
															#line 237 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
		}
															#line 57 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
		printf("\n");
															#line 241 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
		if (address_interface->size() == 0)
															#line 250 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
		{
															#line 48 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
			printf("\nNo addresses can be suspended.\n");
															#line 254 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
		}
		else
		{
															#line 49 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
			if (address_interface->size() == 1)
															#line 260 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
			{
															#line 50 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
				printf("\nThe following address can be suspended:\n");
															#line 264 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
			}
			else
			{
															#line 52 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
				printf("\nThe following %zu addresses can be suspended:\n", address_interface->size());
															#line 270 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
			}
		}
															#line 54 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
		for( auto it : *address_interface ) {
															#line 55 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
			printf("%s\n", printable(it.first).c_str());
															#line 277 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
		}
															#line 57 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
		printf("\n");
															#line 281 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SuspendCommandActorActor*>(this)->actor_wait_state > 0) static_cast<SuspendCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<SuspendCommandActorActor*>(this)->ActorCallback< SuspendCommandActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SuspendCommandActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("suspendCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SuspendCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("suspendCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SuspendCommandActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("suspendCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SuspendCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("suspendCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SuspendCommandActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("suspendCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SuspendCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("suspendCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont9(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont16(int64_t const& suspendRequestSent,int loopDepth) 
	{
															#line 86 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
		if (!suspendRequestSent)
															#line 383 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
		{
															#line 87 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
			result = false;
															#line 88 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
			fprintf( stderr, "ERROR: failed to send requests to suspend processes `%s', please run the `suspend’ command " "to fetch latest addresses.\n", addressesStr.c_str());
															#line 389 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
		}
		else
		{
															#line 94 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
			printf("Attempted to suspend %zu processes\n", tokens.size() - 2);
															#line 395 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
		}
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont16(int64_t && suspendRequestSent,int loopDepth) 
	{
															#line 86 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
		if (!suspendRequestSent)
															#line 405 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
		{
															#line 87 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
			result = false;
															#line 88 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
			fprintf( stderr, "ERROR: failed to send requests to suspend processes `%s', please run the `suspend’ command " "to fetch latest addresses.\n", addressesStr.c_str());
															#line 411 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
		}
		else
		{
															#line 94 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
			printf("Attempted to suspend %zu processes\n", tokens.size() - 2);
															#line 417 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
		}
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1when2(int64_t const& suspendRequestSent,int loopDepth) 
	{
		loopDepth = a_body1cont16(suspendRequestSent, loopDepth);

		return loopDepth;
	}
	int a_body1when2(int64_t && suspendRequestSent,int loopDepth) 
	{
		loopDepth = a_body1cont16(std::move(suspendRequestSent), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SuspendCommandActorActor*>(this)->actor_wait_state > 0) static_cast<SuspendCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<SuspendCommandActorActor*>(this)->ActorCallback< SuspendCommandActorActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< SuspendCommandActorActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("suspendCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SuspendCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("suspendCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SuspendCommandActorActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("suspendCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SuspendCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("suspendCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SuspendCommandActorActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("suspendCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SuspendCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("suspendCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 36 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 36 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 36 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 36 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
	std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* address_interface;
															#line 41 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
	bool result;
															#line 42 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
	std::string addressesStr;
															#line 71 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
	double seconds;
															#line 73 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
	int i;
															#line 514 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
};
// This generated class is to be used only via suspendCommandActor()
															#line 36 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
class SuspendCommandActorActor final : public Actor<bool>, public ActorCallback< SuspendCommandActorActor, 0, Void >, public ActorCallback< SuspendCommandActorActor, 1, int64_t >, public FastAllocated<SuspendCommandActorActor>, public SuspendCommandActorActorState<SuspendCommandActorActor> {
															#line 519 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
public:
	using FastAllocated<SuspendCommandActorActor>::operator new;
	using FastAllocated<SuspendCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1950732114836858880UL, 13499292909474904064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SuspendCommandActorActor, 0, Void >;
friend struct ActorCallback< SuspendCommandActorActor, 1, int64_t >;
															#line 36 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
	SuspendCommandActorActor(Reference<IDatabase> const& db,Reference<ITransaction> const& tr,std::vector<StringRef> const& tokens,std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface) 
															#line 537 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
		 : Actor<bool>(),
		   SuspendCommandActorActorState<SuspendCommandActorActor>(db, tr, tokens, address_interface),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("suspendCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3607338236397282560UL, 13694274266075352576UL);
		ActorExecutionContextHelper __helper(static_cast<SuspendCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("suspendCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("suspendCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SuspendCommandActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SuspendCommandActorActor, 1, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
															#line 36 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
[[nodiscard]] Future<bool> suspendCommandActor( Reference<IDatabase> const& db, Reference<ITransaction> const& tr, std::vector<StringRef> const& tokens, std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface ) {
															#line 36 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"
	return Future<bool>(new SuspendCommandActorActor(db, tr, tokens, address_interface));
															#line 570 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/build_output/fdbcli/SuspendCommand.actor.g.cpp"
}

#line 101 "/codebuild/output/src1297194196/src/github.com/apple/foundationdb/fdbcli/SuspendCommand.actor.cpp"

CommandFactory suspendFactory(
    "suspend",
    CommandHelp(
        "suspend <SECONDS> <ADDRESS...>",
        "attempts to suspend one or more processes in the cluster",
        "If no parameters are specified, populates the list of processes which can be suspended. Processes cannot be "
        "suspended before this list has been populated.\n\nFor each IP:port pair in <ADDRESS...>, attempt to suspend "
        "the processes for the specified SECONDS after which the process will die."));
} // namespace fdb_cli
