#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
/*
 * StreamingRangeRead.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/Arena.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/Trace.h"
#include "flow/serialize.h"
#include <cstring>

#include "flow/actorcompiler.h" // This must be the last #include.

															#line 37 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
namespace {
// This generated class is to be used only via streamUsingGetRange()
															#line 35 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
template <class StreamUsingGetRangeActor>
															#line 35 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
class StreamUsingGetRangeActorState {
															#line 44 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
public:
															#line 35 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	StreamUsingGetRangeActorState(PromiseStream<RangeResult> const& results,Transaction* const& tr,KeyRange const& keys) 
															#line 35 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
															#line 35 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		 : results(results),
															#line 35 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		   tr(tr),
															#line 35 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		   keys(keys),
															#line 36 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		   begin(firstGreaterOrEqual(keys.begin)),
															#line 37 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		   end(firstGreaterOrEqual(keys.end))
															#line 59 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
	{
		fdb_probe_actor_create("streamUsingGetRange", reinterpret_cast<unsigned long>(this));

	}
	~StreamUsingGetRangeActorState() 
	{
		fdb_probe_actor_destroy("streamUsingGetRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 40 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
				;
															#line 75 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StreamUsingGetRangeActorState();
		static_cast<StreamUsingGetRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 55 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 105 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			{
															#line 56 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 109 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			}
															#line 58 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			results.sendError(e);
															#line 59 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 115 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 41 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		GetRangeLimits limits(GetRangeLimits::ROW_LIMIT_UNLIMITED, 1e6);
															#line 42 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		limits.minRows = 0;
															#line 43 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		StrictFuture<RangeResult> __when_expr_0 = tr->getRange(begin, end, limits, Snapshot::True);
															#line 43 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		if (static_cast<StreamUsingGetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 142 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<StreamUsingGetRangeActor*>(this)->actor_wait_state = 1;
															#line 43 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StreamUsingGetRangeActor, 0, RangeResult >*>(static_cast<StreamUsingGetRangeActor*>(this)));
															#line 147 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 45 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		results.send(rep);
															#line 47 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		if (!rep.more)
															#line 158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		{
															#line 48 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			results.sendError(end_of_stream());
															#line 49 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			if (!static_cast<StreamUsingGetRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StreamUsingGetRangeActorState(); static_cast<StreamUsingGetRangeActor*>(this)->destroy(); return 0; }
															#line 164 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			new (&static_cast<StreamUsingGetRangeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StreamUsingGetRangeActorState();
			static_cast<StreamUsingGetRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 52 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		begin = rep.nextBeginKeySelector();
															#line 172 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __rep,int loopDepth) 
	{
															#line 43 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		rep = __rep;
															#line 181 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __rep,int loopDepth) 
	{
		rep = std::move(__rep);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StreamUsingGetRangeActor*>(this)->actor_wait_state > 0) static_cast<StreamUsingGetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<StreamUsingGetRangeActor*>(this)->ActorCallback< StreamUsingGetRangeActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< StreamUsingGetRangeActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("streamUsingGetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StreamUsingGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamUsingGetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StreamUsingGetRangeActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("streamUsingGetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StreamUsingGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamUsingGetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StreamUsingGetRangeActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("streamUsingGetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StreamUsingGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamUsingGetRange", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 35 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	PromiseStream<RangeResult> results;
															#line 35 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	Transaction* tr;
															#line 35 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	KeyRange keys;
															#line 36 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	KeySelectorRef begin;
															#line 37 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	KeySelectorRef end;
															#line 43 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	RangeResult rep;
															#line 268 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
};
// This generated class is to be used only via streamUsingGetRange()
															#line 35 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
class StreamUsingGetRangeActor final : public Actor<Void>, public ActorCallback< StreamUsingGetRangeActor, 0, RangeResult >, public FastAllocated<StreamUsingGetRangeActor>, public StreamUsingGetRangeActorState<StreamUsingGetRangeActor> {
															#line 273 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
public:
	using FastAllocated<StreamUsingGetRangeActor>::operator new;
	using FastAllocated<StreamUsingGetRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13472228157306916864UL, 4675323650224403712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StreamUsingGetRangeActor, 0, RangeResult >;
															#line 35 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	StreamUsingGetRangeActor(PromiseStream<RangeResult> const& results,Transaction* const& tr,KeyRange const& keys) 
															#line 290 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		 : Actor<Void>(),
		   StreamUsingGetRangeActorState<StreamUsingGetRangeActor>(results, tr, keys),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("streamUsingGetRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7941300860238055424UL, 2823487748061404416UL);
		ActorExecutionContextHelper __helper(static_cast<StreamUsingGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("streamUsingGetRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("streamUsingGetRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StreamUsingGetRangeActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 35 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
[[nodiscard]] Future<Void> streamUsingGetRange( PromiseStream<RangeResult> const& results, Transaction* const& tr, KeyRange const& keys ) {
															#line 35 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	return Future<Void>(new StreamUsingGetRangeActor(results, tr, keys));
															#line 323 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
}

#line 62 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"

															#line 328 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
namespace {
// This generated class is to be used only via convertStream()
															#line 63 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
template <class ConvertStreamActor>
															#line 63 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
class ConvertStreamActorState {
															#line 335 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
public:
															#line 63 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	ConvertStreamActorState(PromiseStream<RangeResult> const& input,PromiseStream<KeyValue> const& output) 
															#line 63 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
															#line 63 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		 : input(input),
															#line 63 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		   output(output)
															#line 344 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
	{
		fdb_probe_actor_create("convertStream", reinterpret_cast<unsigned long>(this));

	}
	~ConvertStreamActorState() 
	{
		fdb_probe_actor_destroy("convertStream", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 65 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
				;
															#line 360 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConvertStreamActorState();
		static_cast<ConvertStreamActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		if (!static_cast<ConvertStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConvertStreamActorState(); static_cast<ConvertStreamActor*>(this)->destroy(); return 0; }
															#line 389 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		new (&static_cast<ConvertStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConvertStreamActorState();
		static_cast<ConvertStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 72 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 402 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			{
															#line 73 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 406 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			}
															#line 75 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			output.sendError(e);
															#line 410 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 66 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		auto __when_expr_0 = input.getFuture();
															#line 432 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<RangeResult>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<RangeResult>>::value, "invalid type");
															#line 66 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		if (static_cast<ConvertStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 436 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<ConvertStreamActor*>(this)->actor_wait_state = 1;
															#line 66 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ConvertStreamActor, 0, RangeResult >*>(static_cast<ConvertStreamActor*>(this)));
															#line 441 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult const& res,int loopDepth) 
	{
															#line 67 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		for( auto& kv : res ) {
															#line 68 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			output.send(kv);
															#line 452 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult && res,int loopDepth) 
	{
															#line 67 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		for( auto& kv : res ) {
															#line 68 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			output.send(kv);
															#line 464 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConvertStreamActor*>(this)->actor_wait_state > 0) static_cast<ConvertStreamActor*>(this)->actor_wait_state = 0;
		static_cast<ConvertStreamActor*>(this)->ActorSingleCallback< ConvertStreamActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ConvertStreamActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("convertStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConvertStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("convertStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ConvertStreamActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("convertStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConvertStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("convertStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ConvertStreamActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("convertStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConvertStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("convertStream", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 63 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	PromiseStream<RangeResult> input;
															#line 63 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	PromiseStream<KeyValue> output;
															#line 549 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
};
// This generated class is to be used only via convertStream()
															#line 63 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
class ConvertStreamActor final : public Actor<Void>, public ActorSingleCallback< ConvertStreamActor, 0, RangeResult >, public FastAllocated<ConvertStreamActor>, public ConvertStreamActorState<ConvertStreamActor> {
															#line 554 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
public:
	using FastAllocated<ConvertStreamActor>::operator new;
	using FastAllocated<ConvertStreamActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17434057289927469824UL, 9059568687132783872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ConvertStreamActor, 0, RangeResult >;
															#line 63 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	ConvertStreamActor(PromiseStream<RangeResult> const& input,PromiseStream<KeyValue> const& output) 
															#line 571 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		 : Actor<Void>(),
		   ConvertStreamActorState<ConvertStreamActor>(input, output),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("convertStream", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7041351208728667136UL, 2691132065397168128UL);
		ActorExecutionContextHelper __helper(static_cast<ConvertStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("convertStream");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("convertStream", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ConvertStreamActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 63 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
[[nodiscard]] Future<Void> convertStream( PromiseStream<RangeResult> const& input, PromiseStream<KeyValue> const& output ) {
															#line 63 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	return Future<Void>(new ConvertStreamActor(input, output));
															#line 604 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
}

#line 79 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"

struct StreamingRangeReadWorkload : KVWorkload {
	static constexpr auto NAME = "StreamingRangeRead";
	double testDuration;
	Future<Void> client;

	StreamingRangeReadWorkload(WorkloadContext const& wcx) : KVWorkload(wcx) {
		testDuration = getOption(options, "testDuration"_sr, 60.0);
	}

	Standalone<KeyValueRef> operator()(uint64_t n) { return KeyValueRef(keyForIndex(n, false), randomValue()); }

	Future<Void> setup(Database const& cx) override { return bulkSetup(cx, this, nodeCount, Promise<double>()); }
	Future<Void> start(Database const& cx) override {
		client = timeout(streamingClient(cx->clone(), this), testDuration, Void());
		return delay(testDuration);
	}

	Future<bool> check(Database const& cx) override {
		client = Void();
		return true;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {}

	// Reads the database using both the normal get range API and the streaming API and compares the results
																#line 634 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
// This generated class is to be used only via streamingClient()
															#line 105 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
template <class StreamingClientActor>
															#line 105 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
class StreamingClientActorState {
															#line 640 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
public:
															#line 105 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	StreamingClientActorState(Database const& cx,StreamingRangeReadWorkload* const& self) 
															#line 105 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
															#line 105 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		 : cx(cx),
															#line 105 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		   self(self),
															#line 106 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		   tr(cx),
															#line 107 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		   next(),
															#line 108 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		   rateLimit(delay(0.01))
															#line 655 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
	{
		fdb_probe_actor_create("streamingClient", reinterpret_cast<unsigned long>(this));

	}
	~StreamingClientActorState() 
	{
		fdb_probe_actor_destroy("streamingClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 109 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			;
															#line 670 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StreamingClientActorState();
		static_cast<StreamingClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		streamRaw = PromiseStream<RangeResult>();
															#line 111 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		compareRaw = PromiseStream<RangeResult>();
															#line 112 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		streamResults = PromiseStream<KeyValue>();
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		compareResults = PromiseStream<KeyValue>();
															#line 706 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		try {
															#line 116 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			compareConvert = convertStream(compareRaw, compareResults);
															#line 117 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			streamConvert = convertStream(streamRaw, streamResults);
															#line 118 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			compare = streamUsingGetRange(compareRaw, &tr, KeyRangeRef(next, normalKeys.end));
															#line 119 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			stream = tr.getRangeStream(streamRaw, KeySelector(firstGreaterOrEqual(next), next.arena()), KeySelector(firstGreaterOrEqual(normalKeys.end)), GetRangeLimits());
															#line 123 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			;
															#line 718 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		StrictFuture<Void> __when_expr_3 = rateLimit;
															#line 158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		if (static_cast<StreamingClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 735 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<StreamingClientActor*>(this)->actor_wait_state = 4;
															#line 158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StreamingClientActor, 3, Void >*>(static_cast<StreamingClientActor*>(this)));
															#line 740 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 156 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 156 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			if (static_cast<StreamingClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 752 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<StreamingClientActor*>(this)->actor_wait_state = 3;
															#line 156 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StreamingClientActor, 2, Void >*>(static_cast<StreamingClientActor*>(this)));
															#line 757 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 124 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		cmp = Optional<KeyValue>();
															#line 125 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		res = Optional<KeyValue>();
															#line 787 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		try {
															#line 127 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			auto __when_expr_0 = streamResults.getFuture();
															#line 791 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<KeyValue>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<KeyValue>>::value, "invalid type");
															#line 127 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			if (static_cast<StreamingClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 795 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<StreamingClientActor*>(this)->actor_wait_state = 1;
															#line 127 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< StreamingClientActor, 0, KeyValue >*>(static_cast<StreamingClientActor*>(this)));
															#line 800 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		try {
															#line 136 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			auto __when_expr_1 = compareResults.getFuture();
															#line 829 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_1), FutureStream<KeyValue>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<KeyValue>>::value, "invalid type");
															#line 136 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			if (static_cast<StreamingClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 833 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont1when1(__when_expr_1.pop(), loopDepth); };
			static_cast<StreamingClientActor*>(this)->actor_wait_state = 2;
															#line 136 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< StreamingClientActor, 1, KeyValue >*>(static_cast<StreamingClientActor*>(this)));
															#line 838 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 130 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			if (e.code() != error_code_end_of_stream)
															#line 854 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			{
															#line 131 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
				return a_body1loopBody1Catch1(e, std::max(0, loopDepth - 1));
															#line 858 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			}
															#line 133 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			cmp = Optional<KeyValue>();
															#line 862 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(KeyValue const& _cmp,int loopDepth) 
	{
															#line 128 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		cmp = _cmp;
															#line 877 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(KeyValue && _cmp,int loopDepth) 
	{
															#line 128 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		cmp = _cmp;
															#line 886 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(KeyValue const& _cmp,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_cmp, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(KeyValue && _cmp,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_cmp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StreamingClientActor*>(this)->actor_wait_state > 0) static_cast<StreamingClientActor*>(this)->actor_wait_state = 0;
		static_cast<StreamingClientActor*>(this)->ActorSingleCallback< StreamingClientActor, 0, KeyValue >::remove();

	}
	void a_callback_fire(ActorSingleCallback< StreamingClientActor, 0, KeyValue >*,KeyValue const& value) 
	{
		fdb_probe_actor_enter("streamingClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamingClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< StreamingClientActor, 0, KeyValue >*,KeyValue && value) 
	{
		fdb_probe_actor_enter("streamingClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamingClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< StreamingClientActor, 0, KeyValue >*,Error err) 
	{
		fdb_probe_actor_enter("streamingClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamingClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont5(int loopDepth) 
	{
															#line 144 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		if (cmp != res)
															#line 983 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		{
															#line 145 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			TraceEvent(SevError, "RangeStreamMismatch");
															#line 146 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			ASSERT(false);
															#line 989 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		}
															#line 148 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		if (cmp.present())
															#line 993 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		{
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			next = keyAfter(cmp.get().key);
															#line 997 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		}
		else
		{
															#line 151 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			next = Key();
															#line 1003 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 139 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			if (e.code() != error_code_end_of_stream)
															#line 1015 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			{
															#line 140 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
				return a_body1loopBody1Catch1(e, std::max(0, loopDepth - 1));
															#line 1019 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			}
															#line 142 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
			res = Optional<KeyValue>();
															#line 1023 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
			loopDepth = a_body1loopBody1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(KeyValue const& _res,int loopDepth) 
	{
															#line 137 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		res = _res;
															#line 1038 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(KeyValue && _res,int loopDepth) 
	{
															#line 137 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		res = _res;
															#line 1047 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1when1(KeyValue const& _res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(_res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1when1(KeyValue && _res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(std::move(_res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StreamingClientActor*>(this)->actor_wait_state > 0) static_cast<StreamingClientActor*>(this)->actor_wait_state = 0;
		static_cast<StreamingClientActor*>(this)->ActorSingleCallback< StreamingClientActor, 1, KeyValue >::remove();

	}
	void a_callback_fire(ActorSingleCallback< StreamingClientActor, 1, KeyValue >*,KeyValue const& value) 
	{
		fdb_probe_actor_enter("streamingClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamingClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< StreamingClientActor, 1, KeyValue >*,KeyValue && value) 
	{
		fdb_probe_actor_enter("streamingClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamingClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< StreamingClientActor, 1, KeyValue >*,Error err) 
	{
		fdb_probe_actor_enter("streamingClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamingClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StreamingClientActor*>(this)->actor_wait_state > 0) static_cast<StreamingClientActor*>(this)->actor_wait_state = 0;
		static_cast<StreamingClientActor*>(this)->ActorCallback< StreamingClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StreamingClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("streamingClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamingClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StreamingClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("streamingClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamingClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StreamingClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("streamingClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamingClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		rateLimit = delay(0.01);
															#line 1244 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
		rateLimit = delay(0.01);
															#line 1253 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StreamingClientActor*>(this)->actor_wait_state > 0) static_cast<StreamingClientActor*>(this)->actor_wait_state = 0;
		static_cast<StreamingClientActor*>(this)->ActorCallback< StreamingClientActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StreamingClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("streamingClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamingClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StreamingClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("streamingClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamingClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StreamingClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("streamingClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("streamingClient", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 105 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	Database cx;
															#line 105 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	StreamingRangeReadWorkload* self;
															#line 106 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	Transaction tr;
															#line 107 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	Key next;
															#line 108 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	Future<Void> rateLimit;
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	PromiseStream<RangeResult> streamRaw;
															#line 111 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	PromiseStream<RangeResult> compareRaw;
															#line 112 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	PromiseStream<KeyValue> streamResults;
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	PromiseStream<KeyValue> compareResults;
															#line 116 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	Future<Void> compareConvert;
															#line 117 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	Future<Void> streamConvert;
															#line 118 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	Future<Void> compare;
															#line 119 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	Future<Void> stream;
															#line 124 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	Optional<KeyValue> cmp;
															#line 125 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	Optional<KeyValue> res;
															#line 1363 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
};
// This generated class is to be used only via streamingClient()
															#line 105 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
class StreamingClientActor final : public Actor<Void>, public ActorSingleCallback< StreamingClientActor, 0, KeyValue >, public ActorSingleCallback< StreamingClientActor, 1, KeyValue >, public ActorCallback< StreamingClientActor, 2, Void >, public ActorCallback< StreamingClientActor, 3, Void >, public FastAllocated<StreamingClientActor>, public StreamingClientActorState<StreamingClientActor> {
															#line 1368 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
public:
	using FastAllocated<StreamingClientActor>::operator new;
	using FastAllocated<StreamingClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10436580828258560UL, 5337295767569981440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< StreamingClientActor, 0, KeyValue >;
friend struct ActorSingleCallback< StreamingClientActor, 1, KeyValue >;
friend struct ActorCallback< StreamingClientActor, 2, Void >;
friend struct ActorCallback< StreamingClientActor, 3, Void >;
															#line 105 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	StreamingClientActor(Database const& cx,StreamingRangeReadWorkload* const& self) 
															#line 1388 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
		 : Actor<Void>(),
		   StreamingClientActorState<StreamingClientActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("streamingClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9675058383426118400UL, 13244482058896835584UL);
		ActorExecutionContextHelper __helper(static_cast<StreamingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("streamingClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("streamingClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< StreamingClientActor, 0, KeyValue >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< StreamingClientActor, 1, KeyValue >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StreamingClientActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StreamingClientActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 105 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
[[nodiscard]] Future<Void> streamingClient( Database const& cx, StreamingRangeReadWorkload* const& self ) {
															#line 105 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
	return Future<Void>(new StreamingClientActor(cx, self));
															#line 1423 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StreamingRangeRead.actor.g.cpp"
}

#line 162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/StreamingRangeRead.actor.cpp"
};

WorkloadFactory<StreamingRangeReadWorkload> StreamingRangeReadWorkloadFactory;
