#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
/*
 * ExcludeIncludeStorageServersWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// This test creates a scenario that large number of SS join the cluster, by excluding and including a random
// SS consistently for many times.
// this test would quit early in two scenarios:
// 		1. QuitEarlyNoEligibleSSToExclude: All storage servers are running alongside with a TLog or LogRouter, thus we
//          cannot exclude a SS, otherwise DB would be unavailable. (this is due to simulation uses UNSET process class)
//		2. QuitEarlyNotCompleteServerExclude: Sometimes it takes too long for a SS exclusion to finish(disappear from
//			serverListKeys), there is a timeout_error when that happens, and we quit if it never succeeded( i.e.)
// It makes sense because the purpose of this test is to :
// 		1) create a scenario that large number of SS join/quit.
// 		2) then verify RateKeeper is only bookkeeping required processes. (delete the SS that has quit)
// it's okay to quit if we can't create such scenario in rare cases, as long as in most cases we can create the scenario
// we have seen the case RK bookkeeping large number of unnecessary SS:
// https://github.com/apple/foundationdb/issues/10260
struct ExcludeIncludeStorageServersWorkload : TestWorkload {
	static constexpr auto NAME = "ExcludeIncludeStorageServers";
	bool enabled;

	std::map<AddressExclusion, std::set<AddressExclusion>> machineProcesses; // ip -> ip:port

	ExcludeIncludeStorageServersWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		enabled =
		    !clientId && g_network->isSimulated(); // only do this on the "first" client, and only when in simulation
		if (g_network->isSimulated()) {
			g_simulator->allowLogSetKills = false;
		}
	}

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		// Failure injection workloads like Rollback, Attrition and so on are interfering with the test.
		// In particular, this test expects the storage server can be excluded and included in time
		// to test that ratekeeper's bookkeeping works fine.
		// Consequently, we disable all failure injection workloads in background for this test
		out.insert("all");
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (!enabled)
			return Void();
		return workloadMain(this, cx);
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>&) override {}

																#line 79 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
// This generated class is to be used only via workloadMain()
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
template <class WorkloadMainActor>
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
class WorkloadMainActorState {
															#line 85 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
public:
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
	WorkloadMainActorState(ExcludeIncludeStorageServersWorkload* const& self,Database const& cx) 
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		 : self(self),
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		   cx(cx),
															#line 78 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		   round(deterministicRandom()->randomInt(10, 80)),
															#line 79 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		   servers(),
															#line 80 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		   it(),
															#line 81 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		   tr(cx),
															#line 82 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		   timeout(100.0),
															#line 83 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		   timeoutCnt(0),
															#line 84 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		   maxTimeout(std::min(30, round))
															#line 108 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("workloadMain", reinterpret_cast<unsigned long>(this));

	}
	~WorkloadMainActorState() 
	{
		fdb_probe_actor_destroy("workloadMain", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 85 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
			TraceEvent("WorkloadStart").detail("Round", round).log();
															#line 86 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
			;
															#line 125 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkloadMainActorState();
		static_cast<WorkloadMainActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 155 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = includeServers(cx, std::vector<AddressExclusion>(1));
															#line 155 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		if (static_cast<WorkloadMainActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 150 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<WorkloadMainActor*>(this)->actor_wait_state = 7;
															#line 155 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< WorkloadMainActor, 6, Void >*>(static_cast<WorkloadMainActor*>(this)));
															#line 155 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 87 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		if (timeoutCnt > maxTimeout)
															#line 171 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		{
															#line 88 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
			TraceEvent("QuitEarlyNotCompleteServerExclude").log();
															#line 175 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 92 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
			servers.clear();
															#line 94 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = includeServers(cx, std::vector<AddressExclusion>(1));
															#line 94 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
			if (static_cast<WorkloadMainActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 185 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WorkloadMainActor*>(this)->actor_wait_state = 1;
															#line 94 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkloadMainActor, 0, Void >*>(static_cast<WorkloadMainActor*>(this)));
															#line 190 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 146 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 225 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
			{
															#line 148 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
				timeoutCnt++;
															#line 229 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
				return a_body1loopHead1(loopDepth); // continue
			}
															#line 151 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr.onError(e);
															#line 151 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
			if (static_cast<WorkloadMainActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 236 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<WorkloadMainActor*>(this)->actor_wait_state = 6;
															#line 151 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< WorkloadMainActor, 5, Void >*>(static_cast<WorkloadMainActor*>(this)));
															#line 241 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 96 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		tr = Transaction(cx);
															#line 97 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 98 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 99 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 102 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		StrictFuture<std::vector<std::pair<StorageServerInterface, ProcessClass>>> __when_expr_1 = NativeAPI::getServerListAndProcessClasses(&tr);
															#line 102 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		if (static_cast<WorkloadMainActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 266 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<WorkloadMainActor*>(this)->actor_wait_state = 2;
															#line 102 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkloadMainActor, 1, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*>(static_cast<WorkloadMainActor*>(this)));
															#line 271 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 96 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		tr = Transaction(cx);
															#line 97 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 98 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 99 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 102 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		StrictFuture<std::vector<std::pair<StorageServerInterface, ProcessClass>>> __when_expr_1 = NativeAPI::getServerListAndProcessClasses(&tr);
															#line 102 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		if (static_cast<WorkloadMainActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 290 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<WorkloadMainActor*>(this)->actor_wait_state = 2;
															#line 102 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkloadMainActor, 1, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*>(static_cast<WorkloadMainActor*>(this)));
															#line 295 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkloadMainActor*>(this)->actor_wait_state > 0) static_cast<WorkloadMainActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadMainActor*>(this)->ActorCallback< WorkloadMainActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadMainActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkloadMainActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkloadMainActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(std::vector<std::pair<StorageServerInterface, ProcessClass>> const& results,int loopDepth) 
	{
															#line 104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		for( auto& [ssi, p] : results ) {
															#line 105 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
			if (!g_simulator->protectedAddresses.contains(ssi.address()))
															#line 381 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
			{
															#line 106 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
				servers.insert(AddressExclusion(ssi.address().ip, ssi.address().port));
															#line 385 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
			}
		}
															#line 111 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		StrictFuture<Optional<Standalone<StringRef>>> __when_expr_2 = tr.get(logsKey);
															#line 111 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		if (static_cast<WorkloadMainActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 392 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<WorkloadMainActor*>(this)->actor_wait_state = 3;
															#line 111 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WorkloadMainActor, 2, Optional<Standalone<StringRef>> >*>(static_cast<WorkloadMainActor*>(this)));
															#line 397 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(std::vector<std::pair<StorageServerInterface, ProcessClass>> && results,int loopDepth) 
	{
															#line 104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		for( auto& [ssi, p] : results ) {
															#line 105 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
			if (!g_simulator->protectedAddresses.contains(ssi.address()))
															#line 408 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
			{
															#line 106 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
				servers.insert(AddressExclusion(ssi.address().ip, ssi.address().port));
															#line 412 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
			}
		}
															#line 111 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		StrictFuture<Optional<Standalone<StringRef>>> __when_expr_2 = tr.get(logsKey);
															#line 111 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		if (static_cast<WorkloadMainActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 419 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<WorkloadMainActor*>(this)->actor_wait_state = 3;
															#line 111 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WorkloadMainActor, 2, Optional<Standalone<StringRef>> >*>(static_cast<WorkloadMainActor*>(this)));
															#line 424 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(std::vector<std::pair<StorageServerInterface, ProcessClass>> const& results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(results, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(std::vector<std::pair<StorageServerInterface, ProcessClass>> && results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkloadMainActor*>(this)->actor_wait_state > 0) static_cast<WorkloadMainActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadMainActor*>(this)->ActorCallback< WorkloadMainActor, 1, std::vector<std::pair<StorageServerInterface, ProcessClass>> >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadMainActor, 1, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,std::vector<std::pair<StorageServerInterface, ProcessClass>> const& value) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkloadMainActor, 1, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,std::vector<std::pair<StorageServerInterface, ProcessClass>> && value) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkloadMainActor, 1, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,Error err) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Optional<Standalone<StringRef>> const& value,int loopDepth) 
	{
															#line 112 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		ASSERT(value.present());
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		auto logs = decodeLogsValue(value.get());
															#line 114 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		for( auto const& log : logs.first ) {
															#line 115 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
			servers.erase(AddressExclusion(log.second.ip, log.second.port));
															#line 514 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		}
															#line 119 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		for( const auto& tLogSet : self->dbInfo->get().logSystemConfig.tLogs ) {
															#line 120 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
			for( const auto& logRouter : tLogSet.logRouters ) {
															#line 121 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
				if (logRouter.present())
															#line 522 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
				{
															#line 122 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
					const auto& logRouterInterf = logRouter.interf();
															#line 123 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
					servers.erase( AddressExclusion(logRouterInterf.address().ip, logRouterInterf.address().port));
															#line 528 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
				}
			}
		}
															#line 129 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		if (servers.empty())
															#line 534 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		{
															#line 131 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
			TraceEvent("QuitEarlyNoEligibleSSToExclude").log();
															#line 538 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 136 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		it = std::next(servers.begin(), deterministicRandom()->randomInt(0, servers.size()));
															#line 137 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = excludeServers(cx, std::vector<AddressExclusion>{ *it });
															#line 137 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		if (static_cast<WorkloadMainActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 547 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<WorkloadMainActor*>(this)->actor_wait_state = 4;
															#line 137 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WorkloadMainActor, 3, Void >*>(static_cast<WorkloadMainActor*>(this)));
															#line 552 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Optional<Standalone<StringRef>> && value,int loopDepth) 
	{
															#line 112 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		ASSERT(value.present());
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		auto logs = decodeLogsValue(value.get());
															#line 114 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		for( auto const& log : logs.first ) {
															#line 115 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
			servers.erase(AddressExclusion(log.second.ip, log.second.port));
															#line 567 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		}
															#line 119 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		for( const auto& tLogSet : self->dbInfo->get().logSystemConfig.tLogs ) {
															#line 120 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
			for( const auto& logRouter : tLogSet.logRouters ) {
															#line 121 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
				if (logRouter.present())
															#line 575 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
				{
															#line 122 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
					const auto& logRouterInterf = logRouter.interf();
															#line 123 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
					servers.erase( AddressExclusion(logRouterInterf.address().ip, logRouterInterf.address().port));
															#line 581 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
				}
			}
		}
															#line 129 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		if (servers.empty())
															#line 587 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		{
															#line 131 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
			TraceEvent("QuitEarlyNoEligibleSSToExclude").log();
															#line 591 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 136 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		it = std::next(servers.begin(), deterministicRandom()->randomInt(0, servers.size()));
															#line 137 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = excludeServers(cx, std::vector<AddressExclusion>{ *it });
															#line 137 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		if (static_cast<WorkloadMainActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 600 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<WorkloadMainActor*>(this)->actor_wait_state = 4;
															#line 137 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WorkloadMainActor, 3, Void >*>(static_cast<WorkloadMainActor*>(this)));
															#line 605 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Optional<Standalone<StringRef>> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Optional<Standalone<StringRef>> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WorkloadMainActor*>(this)->actor_wait_state > 0) static_cast<WorkloadMainActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadMainActor*>(this)->ActorCallback< WorkloadMainActor, 2, Optional<Standalone<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadMainActor, 2, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WorkloadMainActor, 2, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> && value) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WorkloadMainActor, 2, Optional<Standalone<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 139 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		StrictFuture<std::set<NetworkAddress>> __when_expr_4 = timeoutError(checkForExcludingServers(cx, std::vector<AddressExclusion>{ *it }, true), timeout);
															#line 139 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		if (static_cast<WorkloadMainActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 691 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<WorkloadMainActor*>(this)->actor_wait_state = 5;
															#line 139 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WorkloadMainActor, 4, std::set<NetworkAddress> >*>(static_cast<WorkloadMainActor*>(this)));
															#line 696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 139 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		StrictFuture<std::set<NetworkAddress>> __when_expr_4 = timeoutError(checkForExcludingServers(cx, std::vector<AddressExclusion>{ *it }, true), timeout);
															#line 139 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		if (static_cast<WorkloadMainActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 707 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<WorkloadMainActor*>(this)->actor_wait_state = 5;
															#line 139 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WorkloadMainActor, 4, std::set<NetworkAddress> >*>(static_cast<WorkloadMainActor*>(this)));
															#line 712 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WorkloadMainActor*>(this)->actor_wait_state > 0) static_cast<WorkloadMainActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadMainActor*>(this)->ActorCallback< WorkloadMainActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadMainActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WorkloadMainActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WorkloadMainActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont14(std::set<NetworkAddress> const& inProgress,int loopDepth) 
	{
															#line 141 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		ASSERT(inProgress.empty());
															#line 142 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		if (--round <= 0)
															#line 798 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont14cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont14(std::set<NetworkAddress> && inProgress,int loopDepth) 
	{
															#line 141 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		ASSERT(inProgress.empty());
															#line 142 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		if (--round <= 0)
															#line 812 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont14cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(std::set<NetworkAddress> const& inProgress,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(inProgress, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(std::set<NetworkAddress> && inProgress,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(inProgress), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WorkloadMainActor*>(this)->actor_wait_state > 0) static_cast<WorkloadMainActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadMainActor*>(this)->ActorCallback< WorkloadMainActor, 4, std::set<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadMainActor, 4, std::set<NetworkAddress> >*,std::set<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< WorkloadMainActor, 4, std::set<NetworkAddress> >*,std::set<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< WorkloadMainActor, 4, std::set<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont14cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<WorkloadMainActor*>(this)->actor_wait_state > 0) static_cast<WorkloadMainActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadMainActor*>(this)->ActorCallback< WorkloadMainActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadMainActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< WorkloadMainActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< WorkloadMainActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 157 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		TraceEvent("WorkloadFinish").detail("QuitEarly", round > 0).detail("TimeoutCount", timeoutCnt).log();
															#line 158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		if (!static_cast<WorkloadMainActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkloadMainActorState(); static_cast<WorkloadMainActor*>(this)->destroy(); return 0; }
															#line 1001 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		new (&static_cast<WorkloadMainActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkloadMainActorState();
		static_cast<WorkloadMainActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 157 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		TraceEvent("WorkloadFinish").detail("QuitEarly", round > 0).detail("TimeoutCount", timeoutCnt).log();
															#line 158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
		if (!static_cast<WorkloadMainActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkloadMainActorState(); static_cast<WorkloadMainActor*>(this)->destroy(); return 0; }
															#line 1015 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		new (&static_cast<WorkloadMainActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkloadMainActorState();
		static_cast<WorkloadMainActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<WorkloadMainActor*>(this)->actor_wait_state > 0) static_cast<WorkloadMainActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadMainActor*>(this)->ActorCallback< WorkloadMainActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadMainActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< WorkloadMainActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< WorkloadMainActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
	ExcludeIncludeStorageServersWorkload* self;
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
	Database cx;
															#line 78 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
	int round;
															#line 79 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
	std::set<AddressExclusion> servers;
															#line 80 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
	std::set<AddressExclusion>::iterator it;
															#line 81 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
	Transaction tr;
															#line 82 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
	double timeout;
															#line 83 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
	int timeoutCnt;
															#line 84 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
	int maxTimeout;
															#line 1116 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
};
// This generated class is to be used only via workloadMain()
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
class WorkloadMainActor final : public Actor<Void>, public ActorCallback< WorkloadMainActor, 0, Void >, public ActorCallback< WorkloadMainActor, 1, std::vector<std::pair<StorageServerInterface, ProcessClass>> >, public ActorCallback< WorkloadMainActor, 2, Optional<Standalone<StringRef>> >, public ActorCallback< WorkloadMainActor, 3, Void >, public ActorCallback< WorkloadMainActor, 4, std::set<NetworkAddress> >, public ActorCallback< WorkloadMainActor, 5, Void >, public ActorCallback< WorkloadMainActor, 6, Void >, public FastAllocated<WorkloadMainActor>, public WorkloadMainActorState<WorkloadMainActor> {
															#line 1121 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
public:
	using FastAllocated<WorkloadMainActor>::operator new;
	using FastAllocated<WorkloadMainActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4641211081896081408UL, 7869993139923784192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkloadMainActor, 0, Void >;
friend struct ActorCallback< WorkloadMainActor, 1, std::vector<std::pair<StorageServerInterface, ProcessClass>> >;
friend struct ActorCallback< WorkloadMainActor, 2, Optional<Standalone<StringRef>> >;
friend struct ActorCallback< WorkloadMainActor, 3, Void >;
friend struct ActorCallback< WorkloadMainActor, 4, std::set<NetworkAddress> >;
friend struct ActorCallback< WorkloadMainActor, 5, Void >;
friend struct ActorCallback< WorkloadMainActor, 6, Void >;
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
	WorkloadMainActor(ExcludeIncludeStorageServersWorkload* const& self,Database const& cx) 
															#line 1144 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   WorkloadMainActorState<WorkloadMainActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workloadMain", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6473147158665632000UL, 16130932942585895168UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadMainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workloadMain");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workloadMain", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkloadMainActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkloadMainActor, 1, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WorkloadMainActor, 2, Optional<Standalone<StringRef>> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WorkloadMainActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WorkloadMainActor, 4, std::set<NetworkAddress> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< WorkloadMainActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< WorkloadMainActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
[[nodiscard]] static Future<Void> workloadMain( ExcludeIncludeStorageServersWorkload* const& self, Database const& cx ) {
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
	return Future<Void>(new WorkloadMainActor(self, cx));
															#line 1182 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.g.cpp"
}

#line 160 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ExcludeIncludeStorageServersWorkload.actor.cpp"
};

WorkloadFactory<ExcludeIncludeStorageServersWorkload> ExcludeIncludeStorageServersWorkloadFactory;
