#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
/*
 * BackupToDBUpgrade.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBOptions.g.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "flow/ApiVersion.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// A workload which test the correctness of upgrading DR from 5.1 to 5.2
struct BackupToDBUpgradeWorkload : TestWorkload {
	static constexpr auto NAME = "BackupToDBUpgrade";
	double backupAfter, stopDifferentialAfter;
	Key backupTag, restoreTag, backupPrefix, extraPrefix;
	int backupRangesCount, backupRangeLengthMax;
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
	Database extraDB;

	// This workload is not compatible with RandomRangeLock workload because they will race in locked range
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert({ "RandomRangeLock" });
	}

	BackupToDBUpgradeWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		backupAfter = getOption(options, "backupAfter"_sr, deterministicRandom()->random01() * 10.0);
		backupPrefix = getOption(options, "backupPrefix"_sr, StringRef());
		backupRangeLengthMax = getOption(options, "backupRangeLengthMax"_sr, 1);
		stopDifferentialAfter = getOption(options, "stopDifferentialAfter"_sr, 60.0);
		backupTag = getOption(options, "backupTag"_sr, BackupAgentBase::getDefaultTag());
		restoreTag = getOption(options, "restoreTag"_sr, "restore"_sr);
		backupRangesCount = getOption(options, "backupRangesCount"_sr, 5);
		extraPrefix = backupPrefix.withPrefix("\xfe\xff\xfe"_sr);
		backupPrefix = backupPrefix.withPrefix("\xfe\xff\xff"_sr);

		ASSERT(backupPrefix != StringRef());

		KeyRef beginRange;
		KeyRef endRange;

		if (backupRangesCount <= 0) {
			backupRanges.push_back_deep(backupRanges.arena(),
			                            KeyRangeRef(normalKeys.begin, std::min(backupPrefix, extraPrefix)));
		} else {
			// Add backup ranges
			for (int rangeLoop = 0; rangeLoop < backupRangesCount; rangeLoop++) {
				// Get a random range of a random sizes
				beginRange = KeyRef(backupRanges.arena(),
				                    deterministicRandom()->randomAlphaNumeric(
				                        deterministicRandom()->randomInt(1, backupRangeLengthMax + 1)));
				endRange = KeyRef(backupRanges.arena(),
				                  deterministicRandom()->randomAlphaNumeric(
				                      deterministicRandom()->randomInt(1, backupRangeLengthMax + 1)));

				// Add the range to the array
				backupRanges.push_back_deep(backupRanges.arena(),
				                            (beginRange < endRange) ? KeyRangeRef(beginRange, endRange)
				                                                    : KeyRangeRef(endRange, beginRange));

				// Track the added range
				TraceEvent("DRU_BackupRange")
				    .detail("RangeBegin", (beginRange < endRange) ? printable(beginRange) : printable(endRange))
				    .detail("RangeEnd", (beginRange < endRange) ? printable(endRange) : printable(beginRange));
			}
		}

		ASSERT(g_simulator->extraDatabases.size() == 1);
		extraDB = Database::createSimulatedExtraDatabase(g_simulator->extraDatabases[0], wcx.defaultTenant);

		TraceEvent("DRU_Start").log();
	}

	Future<Void> setup(Database const& cx) override {
		if (clientId != 0)
			return Void();
		return _setup(cx, this);
	}

	Future<Void> start(Database const& cx) override {
		if (clientId != 0)
			return Void();
		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 112 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
// This generated class is to be used only via doBackup()
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
template <class DoBackupActor>
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class DoBackupActorState {
															#line 118 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
public:
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	DoBackupActorState(BackupToDBUpgradeWorkload* const& self,DatabaseBackupAgent* const& backupAgent,Database const& cx,Key const& tag,Standalone<VectorRef<KeyRangeRef>> const& backupRanges) 
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		 : self(self),
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupAgent(backupAgent),
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   cx(cx),
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   tag(tag),
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupRanges(backupRanges)
															#line 133 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
	{
		fdb_probe_actor_create("doBackup", reinterpret_cast<unsigned long>(this));

	}
	~DoBackupActorState() 
	{
		fdb_probe_actor_destroy("doBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 116 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(self->extraDB));
															#line 117 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				;
															#line 151 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 144 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(backupAgent->waitBackup(self->extraDB, tag, StopWhenDone::False));
															#line 144 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 182 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 4;
															#line 144 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 3, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 187 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 138 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent("DRU_DoBackupSubmitBackupError").error(e).detail("Tag", printable(tag));
															#line 139 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 199 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			{
															#line 140 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 203 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 136 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_DoBackupInDifferentialMode").detail("Tag", printable(tag));
															#line 219 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 119 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			for( auto r : self->backupRanges ) {
															#line 120 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				if (!r.empty())
															#line 238 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
				{
															#line 121 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					auto targetRange = r.withPrefix(self->backupPrefix);
															#line 122 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					printf("Clearing %s in destination\n", printable(targetRange).c_str());
															#line 123 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					tr->addReadConflictRange(targetRange);
															#line 124 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					tr->clear(targetRange);
															#line 248 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
				}
			}
															#line 127 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_0 = backupAgent->submitBackup( tr, tag, backupRanges, StopWhenDone::False, self->backupPrefix, StringRef());
															#line 127 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 255 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 1;
															#line 127 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 0, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 260 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 132 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 132 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 297 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 3;
															#line 132 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 2, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 302 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 129 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 319 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 2;
															#line 129 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 1, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 324 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 129 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 335 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 2;
															#line 129 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 1, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 340 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 146 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!static_cast<DoBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBackupActorState(); static_cast<DoBackupActor*>(this)->destroy(); return 0; }
															#line 611 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		new (&static_cast<DoBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 146 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!static_cast<DoBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBackupActorState(); static_cast<DoBackupActor*>(this)->destroy(); return 0; }
															#line 623 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		new (&static_cast<DoBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	BackupToDBUpgradeWorkload* self;
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	DatabaseBackupAgent* backupAgent;
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Database cx;
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Key tag;
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 116 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 718 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
};
// This generated class is to be used only via doBackup()
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class DoBackupActor final : public Actor<Void>, public ActorCallback< DoBackupActor, 0, Void >, public ActorCallback< DoBackupActor, 1, Void >, public ActorCallback< DoBackupActor, 2, Void >, public ActorCallback< DoBackupActor, 3, Void >, public FastAllocated<DoBackupActor>, public DoBackupActorState<DoBackupActor> {
															#line 723 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
public:
	using FastAllocated<DoBackupActor>::operator new;
	using FastAllocated<DoBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(729490094777540352UL, 2427363889576685056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoBackupActor, 0, Void >;
friend struct ActorCallback< DoBackupActor, 1, Void >;
friend struct ActorCallback< DoBackupActor, 2, Void >;
friend struct ActorCallback< DoBackupActor, 3, Void >;
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	DoBackupActor(BackupToDBUpgradeWorkload* const& self,DatabaseBackupAgent* const& backupAgent,Database const& cx,Key const& tag,Standalone<VectorRef<KeyRangeRef>> const& backupRanges) 
															#line 743 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		 : Actor<Void>(),
		   DoBackupActorState<DoBackupActor>(self, backupAgent, cx, tag, backupRanges),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15925328432552866816UL, 11115638302355080704UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoBackupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoBackupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoBackupActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DoBackupActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
[[nodiscard]] static Future<Void> doBackup( BackupToDBUpgradeWorkload* const& self, DatabaseBackupAgent* const& backupAgent, Database const& cx, Key const& tag, Standalone<VectorRef<KeyRangeRef>> const& backupRanges ) {
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	return Future<Void>(new DoBackupActor(self, backupAgent, cx, tag, backupRanges));
															#line 778 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
}

#line 148 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"

																#line 783 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
// This generated class is to be used only via checkData()
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
template <class CheckDataActor>
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class CheckDataActorState {
															#line 789 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
public:
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	CheckDataActorState(Database const& cx,UID const& logUid,UID const& destUid,Key const& tag,DatabaseBackupAgent* const& backupAgent) 
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		 : cx(cx),
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   logUid(logUid),
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   destUid(destUid),
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   tag(tag),
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupAgent(backupAgent),
															#line 154 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupAgentKey(uidPrefixKey(logRangesRange.begin, logUid)),
															#line 155 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupLogValuesKey(uidPrefixKey(backupLogKeys.begin, destUid)),
															#line 156 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupLatestVersionsPath(uidPrefixKey(backupLatestVersionsPrefix, destUid)),
															#line 157 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupLatestVersionsKey(uidPrefixKey(backupLatestVersionsPath, logUid)),
															#line 158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   displaySystemKeys(0)
															#line 814 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
	{
		fdb_probe_actor_create("checkData", reinterpret_cast<unsigned long>(this));

	}
	~CheckDataActorState() 
	{
		fdb_probe_actor_destroy("checkData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 160 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			ASSERT(destUid.isValid());
															#line 163 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			;
															#line 831 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckDataActorState();
		static_cast<CheckDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 271 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (displaySystemKeys)
															#line 854 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
															#line 272 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_9 = TaskBucket::debugPrintRange(cx, "\xff"_sr, StringRef());
															#line 272 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 860 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont1when1(__when_expr_9.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 10;
															#line 272 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 9, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 865 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 164 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 166 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_CheckLeftoverkeys").detail("BackupTag", printable(tag));
															#line 888 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		try {
															#line 172 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent("DRU_CheckLeftovertasks").detail("BackupTag", printable(tag));
															#line 173 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<int64_t> __when_expr_0 = backupAgent->getTaskCount(tr);
															#line 173 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 896 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 1;
															#line 173 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 0, int64_t >*>(static_cast<CheckDataActor*>(this)));
															#line 901 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 266 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent("DRU_CheckError").error(e);
															#line 267 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_8 = tr->onError(e);
															#line 267 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 940 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_8.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 9;
															#line 267 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 8, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 945 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 174 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		waitCycles = 0;
															#line 176 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if ((taskCount) && false)
															#line 962 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
															#line 177 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent("DRU_EndingNonzeroTaskCount") .detail("BackupTag", printable(tag)) .detail("TaskCount", taskCount) .detail("WaitCycles", waitCycles);
															#line 181 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("EndingNonZeroTasks: %ld\n", (long)taskCount);
															#line 182 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_1 = TaskBucket::debugPrintRange(cx, "\xff"_sr, StringRef());
															#line 182 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 972 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 2;
															#line 182 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 1, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 977 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t const& __taskCount,int loopDepth) 
	{
															#line 173 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		taskCount = __taskCount;
															#line 991 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t && __taskCount,int loopDepth) 
	{
		taskCount = std::move(__taskCount);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 185 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		;
															#line 1070 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 199 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<RangeResult> __when_expr_4 = tr->getRange(KeyRange(KeyRangeRef(backupAgentKey, strinc(backupAgentKey))), 100);
															#line 199 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1168 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 5;
															#line 199 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 4, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 1173 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 185 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!(taskCount > 0))
															#line 1189 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
			return a_body1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 186 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		waitCycles++;
															#line 188 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_NonzeroTaskWait") .detail("BackupTag", printable(tag)) .detail("TaskCount", taskCount) .detail("WaitCycles", waitCycles);
															#line 192 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		printf("%.6f Wait #%4d for %lld tasks to end\n", now(), waitCycles, (long long)taskCount);
															#line 194 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(20.0);
															#line 194 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1203 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 3;
															#line 194 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 2, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 1208 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 195 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 196 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(taskCount, backupAgent->getTaskCount(tr));
															#line 196 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1234 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 4;
															#line 196 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 3, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 1239 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 195 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 196 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(taskCount, backupAgent->getTaskCount(tr));
															#line 196 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1252 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 4;
															#line 196 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 3, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 1257 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont6(RangeResult const& agentValues,int loopDepth) 
	{
															#line 203 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (agentValues.size() > 0)
															#line 1428 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
															#line 204 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			displaySystemKeys++;
															#line 205 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("BackupCorrectnessLeftoverMutationKeys: (%d) %s\n", agentValues.size(), printable(backupAgentKey).c_str());
															#line 208 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverMutationKeys") .detail("BackupTag", printable(tag)) .detail("LeftoverKeys", agentValues.size()) .detail("KeySpace", printable(backupAgentKey));
															#line 212 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			for( auto& s : agentValues ) {
															#line 213 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				TraceEvent("DRU_LeftoverKey") .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 216 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 1442 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			}
		}
		else
		{
															#line 221 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("No left over backup agent configuration keys\n");
															#line 1449 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
															#line 224 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = tr->get(backupLatestVersionsKey);
															#line 224 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1455 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 6;
															#line 224 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 5, Optional<Value> >*>(static_cast<CheckDataActor*>(this)));
															#line 1460 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(RangeResult && agentValues,int loopDepth) 
	{
															#line 203 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (agentValues.size() > 0)
															#line 1469 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
															#line 204 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			displaySystemKeys++;
															#line 205 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("BackupCorrectnessLeftoverMutationKeys: (%d) %s\n", agentValues.size(), printable(backupAgentKey).c_str());
															#line 208 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverMutationKeys") .detail("BackupTag", printable(tag)) .detail("LeftoverKeys", agentValues.size()) .detail("KeySpace", printable(backupAgentKey));
															#line 212 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			for( auto& s : agentValues ) {
															#line 213 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				TraceEvent("DRU_LeftoverKey") .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 216 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 1483 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			}
		}
		else
		{
															#line 221 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("No left over backup agent configuration keys\n");
															#line 1490 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
															#line 224 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = tr->get(backupLatestVersionsKey);
															#line 224 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1496 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 6;
															#line 224 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 5, Optional<Value> >*>(static_cast<CheckDataActor*>(this)));
															#line 1501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(RangeResult const& agentValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(agentValues, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(RangeResult && agentValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(agentValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont7(Optional<Value> const& latestVersion,int loopDepth) 
	{
															#line 225 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (latestVersion.present())
															#line 1585 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
															#line 226 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverVersionKey") .detail("BackupTag", printable(tag)) .detail("Key", backupLatestVersionsKey.printable()) .detail("Value", BinaryReader::fromStringRef<Version>(latestVersion.get(), Unversioned()));
															#line 1589 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
		else
		{
															#line 231 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("No left over backup version key\n");
															#line 1595 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
															#line 234 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = tr->getRange(KeyRange(KeyRangeRef(backupLatestVersionsPath, strinc(backupLatestVersionsPath))), 1);
															#line 234 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1601 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 7;
															#line 234 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 6, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 1606 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Optional<Value> && latestVersion,int loopDepth) 
	{
															#line 225 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (latestVersion.present())
															#line 1615 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
															#line 226 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverVersionKey") .detail("BackupTag", printable(tag)) .detail("Key", backupLatestVersionsKey.printable()) .detail("Value", BinaryReader::fromStringRef<Version>(latestVersion.get(), Unversioned()));
															#line 1619 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
		else
		{
															#line 231 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("No left over backup version key\n");
															#line 1625 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
															#line 234 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = tr->getRange(KeyRange(KeyRangeRef(backupLatestVersionsPath, strinc(backupLatestVersionsPath))), 1);
															#line 234 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1631 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 7;
															#line 234 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 6, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 1636 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Optional<Value> const& latestVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(latestVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Optional<Value> && latestVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(latestVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 5, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 5, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 5, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 5, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont11(RangeResult const& versions,int loopDepth) 
	{
															#line 236 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!versions.size())
															#line 1720 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
															#line 237 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<RangeResult> __when_expr_7 = tr->getRange(KeyRange(KeyRangeRef(backupLogValuesKey, strinc(backupLogValuesKey))), 100);
															#line 237 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1726 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont11when1(__when_expr_7.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 8;
															#line 237 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 7, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 1731 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont11(RangeResult && versions,int loopDepth) 
	{
															#line 236 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!versions.size())
															#line 1745 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
															#line 237 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<RangeResult> __when_expr_7 = tr->getRange(KeyRange(KeyRangeRef(backupLogValuesKey, strinc(backupLogValuesKey))), 100);
															#line 237 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1751 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont11when1(__when_expr_7.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 8;
															#line 237 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 7, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 1756 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(RangeResult const& versions,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(versions, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(RangeResult && versions,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(versions), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 6, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 6, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 6, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 6, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont11cont1(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont11cont2(RangeResult const& logValues,int loopDepth) 
	{
															#line 241 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (logValues.size() > 0)
															#line 1851 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
															#line 242 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			displaySystemKeys++;
															#line 243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("BackupCorrectnessLeftoverLogKeys: (%d) %s\n", logValues.size(), printable(backupLogValuesKey).c_str());
															#line 246 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverLogKeys") .detail("BackupTag", printable(tag)) .detail("LeftoverKeys", logValues.size()) .detail("KeySpace", printable(backupLogValuesKey)) .detail("Version", decodeBKMutationLogKey(logValues[0].key).first);
															#line 251 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			for( auto& s : logValues ) {
															#line 252 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				TraceEvent("DRU_LeftoverKey") .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 255 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 1865 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			}
		}
		else
		{
															#line 260 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("No left over backup log keys\n");
															#line 1872 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11cont2(RangeResult && logValues,int loopDepth) 
	{
															#line 241 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (logValues.size() > 0)
															#line 1882 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
															#line 242 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			displaySystemKeys++;
															#line 243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("BackupCorrectnessLeftoverLogKeys: (%d) %s\n", logValues.size(), printable(backupLogValuesKey).c_str());
															#line 246 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverLogKeys") .detail("BackupTag", printable(tag)) .detail("LeftoverKeys", logValues.size()) .detail("KeySpace", printable(backupLogValuesKey)) .detail("Version", decodeBKMutationLogKey(logValues[0].key).first);
															#line 251 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			for( auto& s : logValues ) {
															#line 252 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				TraceEvent("DRU_LeftoverKey") .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 255 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 1896 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			}
		}
		else
		{
															#line 260 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			printf("No left over backup log keys\n");
															#line 1903 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11when1(RangeResult const& logValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont2(logValues, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11when1(RangeResult && logValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont2(std::move(logValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 7, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 7, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 7, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 7, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 275 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!static_cast<CheckDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataActorState(); static_cast<CheckDataActor*>(this)->destroy(); return 0; }
															#line 2075 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		new (&static_cast<CheckDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckDataActorState();
		static_cast<CheckDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Database cx;
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	UID logUid;
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	UID destUid;
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Key tag;
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	DatabaseBackupAgent* backupAgent;
															#line 154 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Key backupAgentKey;
															#line 155 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Key backupLogValuesKey;
															#line 156 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Key backupLatestVersionsPath;
															#line 157 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Key backupLatestVersionsKey;
															#line 158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	int displaySystemKeys;
															#line 164 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 173 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	int64_t taskCount;
															#line 174 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	int waitCycles;
															#line 2196 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
};
// This generated class is to be used only via checkData()
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class CheckDataActor final : public Actor<Void>, public ActorCallback< CheckDataActor, 0, int64_t >, public ActorCallback< CheckDataActor, 1, Void >, public ActorCallback< CheckDataActor, 2, Void >, public ActorCallback< CheckDataActor, 3, Void >, public ActorCallback< CheckDataActor, 4, RangeResult >, public ActorCallback< CheckDataActor, 5, Optional<Value> >, public ActorCallback< CheckDataActor, 6, RangeResult >, public ActorCallback< CheckDataActor, 7, RangeResult >, public ActorCallback< CheckDataActor, 8, Void >, public ActorCallback< CheckDataActor, 9, Void >, public FastAllocated<CheckDataActor>, public CheckDataActorState<CheckDataActor> {
															#line 2201 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
public:
	using FastAllocated<CheckDataActor>::operator new;
	using FastAllocated<CheckDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14622190902321550080UL, 10805656926627095552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckDataActor, 0, int64_t >;
friend struct ActorCallback< CheckDataActor, 1, Void >;
friend struct ActorCallback< CheckDataActor, 2, Void >;
friend struct ActorCallback< CheckDataActor, 3, Void >;
friend struct ActorCallback< CheckDataActor, 4, RangeResult >;
friend struct ActorCallback< CheckDataActor, 5, Optional<Value> >;
friend struct ActorCallback< CheckDataActor, 6, RangeResult >;
friend struct ActorCallback< CheckDataActor, 7, RangeResult >;
friend struct ActorCallback< CheckDataActor, 8, Void >;
friend struct ActorCallback< CheckDataActor, 9, Void >;
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	CheckDataActor(Database const& cx,UID const& logUid,UID const& destUid,Key const& tag,DatabaseBackupAgent* const& backupAgent) 
															#line 2227 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		 : Actor<Void>(),
		   CheckDataActorState<CheckDataActor>(cx, logUid, destUid, tag, backupAgent),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12159733170968748032UL, 9261654583238461696UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckDataActor, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckDataActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckDataActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckDataActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckDataActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CheckDataActor, 5, Optional<Value> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CheckDataActor, 6, RangeResult >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CheckDataActor, 7, RangeResult >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< CheckDataActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< CheckDataActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
[[nodiscard]] static Future<Void> checkData( Database const& cx, UID const& logUid, UID const& destUid, Key const& tag, DatabaseBackupAgent* const& backupAgent ) {
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	return Future<Void>(new CheckDataActor(cx, logUid, destUid, tag, backupAgent));
															#line 2268 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
}

#line 277 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"

																#line 2273 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 278 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
template <class _setupActor>
															#line 278 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class _setupActorState {
															#line 2279 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
public:
															#line 278 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	_setupActorState(Database const& cx,BackupToDBUpgradeWorkload* const& self) 
															#line 278 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
															#line 278 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		 : cx(cx),
															#line 278 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   self(self),
															#line 279 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupAgent(cx)
															#line 2290 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 281 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (cx->defaultTenant.present() || BUGGIFY)
															#line 2305 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			{
															#line 282 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				if (cx->defaultTenant.present())
															#line 2309 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
				{
															#line 283 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					StrictFuture<TenantMapEntry> __when_expr_0 = TenantAPI::getTenant(cx.getReference(), cx->defaultTenant.get());
															#line 283 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2315 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 283 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, TenantMapEntry >*>(static_cast<_setupActor*>(this)));
															#line 2320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		try {
															#line 304 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(self->backupAfter);
															#line 304 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2356 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 304 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 2361 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 298 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		for( auto r : getSystemBackupRanges() ) {
															#line 299 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			self->backupRanges.push_back_deep(self->backupRanges.arena(), r);
															#line 2378 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(TenantMapEntry const& entry,int loopDepth) 
	{
															#line 287 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (self->backupRanges.size() != 1 || self->backupRanges[0] != normalKeys || deterministicRandom()->coinflip())
															#line 2388 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
															#line 289 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			Standalone<VectorRef<KeyRangeRef>> modifiedBackupRanges;
															#line 290 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			for(int i = 0;i < self->backupRanges.size();++i) {
															#line 291 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				modifiedBackupRanges.push_back_deep( modifiedBackupRanges.arena(), self->backupRanges[i].withPrefix(entry.prefix, self->backupRanges.arena()));
															#line 2396 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			}
															#line 295 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			self->backupRanges = modifiedBackupRanges;
															#line 2400 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(TenantMapEntry && entry,int loopDepth) 
	{
															#line 287 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (self->backupRanges.size() != 1 || self->backupRanges[0] != normalKeys || deterministicRandom()->coinflip())
															#line 2410 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
															#line 289 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			Standalone<VectorRef<KeyRangeRef>> modifiedBackupRanges;
															#line 290 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			for(int i = 0;i < self->backupRanges.size();++i) {
															#line 291 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				modifiedBackupRanges.push_back_deep( modifiedBackupRanges.arena(), self->backupRanges[i].withPrefix(entry.prefix, self->backupRanges.arena()));
															#line 2418 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			}
															#line 295 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			self->backupRanges = modifiedBackupRanges;
															#line 2422 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(TenantMapEntry const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont3(entry, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TenantMapEntry && entry,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, TenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, TenantMapEntry >*,TenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, TenantMapEntry >*,TenantMapEntry && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, TenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 317 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 2507 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 313 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "BackupToDBUpgradeSetupError").error(e);
															#line 314 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 2522 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 306 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_DoBackup").detail("Tag", printable(self->backupTag));
															#line 307 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		b = doBackup(self, &backupAgent, self->extraDB, self->backupTag, self->backupRanges);
															#line 309 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_DoBackupWait").detail("BackupTag", printable(self->backupTag));
															#line 310 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_2 = b;
															#line 310 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2544 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont10when1(__when_expr_2.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 310 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Void >*>(static_cast<_setupActor*>(this)));
															#line 2549 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 306 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_DoBackup").detail("Tag", printable(self->backupTag));
															#line 307 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		b = doBackup(self, &backupAgent, self->extraDB, self->backupTag, self->backupRanges);
															#line 309 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_DoBackupWait").detail("BackupTag", printable(self->backupTag));
															#line 310 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_2 = b;
															#line 310 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2566 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont10when1(__when_expr_2.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 310 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Void >*>(static_cast<_setupActor*>(this)));
															#line 2571 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 311 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_DoBackupWaitEnd").detail("BackupTag", printable(self->backupTag));
															#line 2655 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = a_body1cont10cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 311 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_DoBackupWaitEnd").detail("BackupTag", printable(self->backupTag));
															#line 2664 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = a_body1cont10cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _setupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 278 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Database cx;
															#line 278 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	BackupToDBUpgradeWorkload* self;
															#line 279 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	DatabaseBackupAgent backupAgent;
															#line 307 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Future<Void> b;
															#line 2765 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 278 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, TenantMapEntry >, public ActorCallback< _setupActor, 1, Void >, public ActorCallback< _setupActor, 2, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 2770 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9660069849848102912UL, 1175326213998152704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, TenantMapEntry >;
friend struct ActorCallback< _setupActor, 1, Void >;
friend struct ActorCallback< _setupActor, 2, Void >;
															#line 278 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	_setupActor(Database const& cx,BackupToDBUpgradeWorkload* const& self) 
															#line 2789 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, TenantMapEntry >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _setupActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 278 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
[[nodiscard]] static Future<Void> _setup( Database const& cx, BackupToDBUpgradeWorkload* const& self ) {
															#line 278 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 2823 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
}

#line 319 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"

																#line 2828 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
// This generated class is to be used only via diffRanges()
															#line 320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
template <class DiffRangesActor>
															#line 320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class DiffRangesActorState {
															#line 2834 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
public:
															#line 320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	DiffRangesActorState(Standalone<VectorRef<KeyRangeRef>> const& ranges,StringRef const& backupPrefix,Database const& src,Database const& dest) 
															#line 320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
															#line 320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		 : ranges(ranges),
															#line 320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupPrefix(backupPrefix),
															#line 320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   src(src),
															#line 320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   dest(dest),
															#line 324 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   rangeIndex()
															#line 2849 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
	{
		fdb_probe_actor_create("diffRanges", reinterpret_cast<unsigned long>(this));

	}
	~DiffRangesActorState() 
	{
		fdb_probe_actor_destroy("diffRanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 325 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			rangeIndex = 0;
															#line 2864 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DiffRangesActorState();
		static_cast<DiffRangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 408 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!static_cast<DiffRangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DiffRangesActorState(); static_cast<DiffRangesActor*>(this)->destroy(); return 0; }
															#line 2887 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		new (&static_cast<DiffRangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DiffRangesActorState();
		static_cast<DiffRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 325 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!(rangeIndex < ranges.size()))
															#line 2906 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 326 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		range = ranges[rangeIndex];
															#line 327 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		begin = range.begin;
															#line 328 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (range.empty())
															#line 2916 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
			return a_body1continue1(loopDepth); // continue
		}
															#line 331 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		;
															#line 2922 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1continue1(int loopDepth) 
	{
															#line 325 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		++rangeIndex;
															#line 2944 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 325 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		++rangeIndex;
															#line 2953 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 332 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr = Transaction(src);
															#line 333 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr2 = Transaction(dest);
															#line 2971 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		try {
															#line 335 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			;
															#line 2975 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = a_body1loopBody1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 403 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 403 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<DiffRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3012 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DiffRangesActor*>(this)->actor_wait_state = 2;
															#line 403 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DiffRangesActor, 1, Void >*>(static_cast<DiffRangesActor*>(this)));
															#line 3017 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1(int loopDepth) 
	{
															#line 336 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 337 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 338 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr2.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 339 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr2.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 340 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		srcFuture = tr.getRange(KeyRangeRef(begin, range.end), 1000);
															#line 341 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		bkpFuture = tr2.getRange(KeyRangeRef(begin, range.end).withPrefix(backupPrefix), 1000);
															#line 343 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_0 = success(srcFuture) && success(bkpFuture);
															#line 343 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<DiffRangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3059 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DiffRangesActor*>(this)->actor_wait_state = 1;
															#line 343 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DiffRangesActor, 0, Void >*>(static_cast<DiffRangesActor*>(this)));
															#line 3064 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 345 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		auto src = srcFuture.get().begin();
															#line 346 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		auto bkp = bkpFuture.get().begin();
															#line 348 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		for(;src != srcFuture.get().end() && bkp != bkpFuture.get().end();) {
															#line 349 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			KeyRef bkpKey = bkp->key.substr(backupPrefix.size());
															#line 350 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (src->key != bkpKey && src->value != bkp->value)
															#line 3094 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			{
															#line 351 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				TraceEvent(SevError, "MismatchKeyAndValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 3098 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			}
			else
			{
															#line 356 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				if (src->key != bkpKey)
															#line 3104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
				{
															#line 357 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					TraceEvent(SevError, "MismatchKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 3108 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
				}
				else
				{
															#line 362 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					if (src->value != bkp->value)
															#line 3114 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
					{
															#line 363 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
						TraceEvent(SevError, "MismatchValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 3118 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
					}
				}
			}
															#line 369 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			begin = std::min(src->key, bkpKey);
															#line 370 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (src->key == bkpKey)
															#line 3126 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			{
															#line 371 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				++src;
															#line 372 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				++bkp;
															#line 3132 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			}
			else
			{
															#line 373 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				if (src->key < bkpKey)
															#line 3138 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
				{
															#line 374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					++src;
															#line 3142 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
				}
				else
				{
															#line 376 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					++bkp;
															#line 3148 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
				}
			}
		}
															#line 379 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		for(;src != srcFuture.get().end() && !bkpFuture.get().more;) {
															#line 380 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "MissingBkpKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value));
															#line 383 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			begin = src->key;
															#line 384 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			++src;
															#line 3160 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
															#line 386 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		for(;bkp != bkpFuture.get().end() && !srcFuture.get().more;) {
															#line 387 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "MissingSrcKey") .detail("BkpKey", printable(bkp->key.substr(backupPrefix.size()))) .detail("BkpVal", printable(bkp->value));
															#line 390 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			begin = bkp->key;
															#line 391 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			++bkp;
															#line 3170 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
															#line 394 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!srcFuture.get().more && !bkpFuture.get().more)
															#line 3174 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
			return a_body1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 398 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		begin = keyAfter(begin);
															#line 3180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 345 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		auto src = srcFuture.get().begin();
															#line 346 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		auto bkp = bkpFuture.get().begin();
															#line 348 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		for(;src != srcFuture.get().end() && bkp != bkpFuture.get().end();) {
															#line 349 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			KeyRef bkpKey = bkp->key.substr(backupPrefix.size());
															#line 350 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (src->key != bkpKey && src->value != bkp->value)
															#line 3197 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			{
															#line 351 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				TraceEvent(SevError, "MismatchKeyAndValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 3201 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			}
			else
			{
															#line 356 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				if (src->key != bkpKey)
															#line 3207 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
				{
															#line 357 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					TraceEvent(SevError, "MismatchKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 3211 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
				}
				else
				{
															#line 362 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					if (src->value != bkp->value)
															#line 3217 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
					{
															#line 363 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
						TraceEvent(SevError, "MismatchValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 3221 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
					}
				}
			}
															#line 369 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			begin = std::min(src->key, bkpKey);
															#line 370 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (src->key == bkpKey)
															#line 3229 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			{
															#line 371 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				++src;
															#line 372 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				++bkp;
															#line 3235 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			}
			else
			{
															#line 373 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				if (src->key < bkpKey)
															#line 3241 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
				{
															#line 374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					++src;
															#line 3245 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
				}
				else
				{
															#line 376 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					++bkp;
															#line 3251 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
				}
			}
		}
															#line 379 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		for(;src != srcFuture.get().end() && !bkpFuture.get().more;) {
															#line 380 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "MissingBkpKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value));
															#line 383 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			begin = src->key;
															#line 384 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			++src;
															#line 3263 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
															#line 386 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		for(;bkp != bkpFuture.get().end() && !srcFuture.get().more;) {
															#line 387 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "MissingSrcKey") .detail("BkpKey", printable(bkp->key.substr(backupPrefix.size()))) .detail("BkpVal", printable(bkp->value));
															#line 390 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			begin = bkp->key;
															#line 391 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			++bkp;
															#line 3273 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
															#line 394 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!srcFuture.get().more && !bkpFuture.get().more)
															#line 3277 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
			return a_body1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 398 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		begin = keyAfter(begin);
															#line 3283 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DiffRangesActor*>(this)->actor_wait_state > 0) static_cast<DiffRangesActor*>(this)->actor_wait_state = 0;
		static_cast<DiffRangesActor*>(this)->ActorCallback< DiffRangesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DiffRangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DiffRangesActor*>(this)->actor_wait_state > 0) static_cast<DiffRangesActor*>(this)->actor_wait_state = 0;
		static_cast<DiffRangesActor*>(this)->ActorCallback< DiffRangesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DiffRangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> ranges;
															#line 320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	StringRef backupPrefix;
															#line 320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Database src;
															#line 320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Database dest;
															#line 324 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	int rangeIndex;
															#line 326 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	KeyRangeRef range;
															#line 327 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Key begin;
															#line 332 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Transaction tr;
															#line 333 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Transaction tr2;
															#line 340 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Future<RangeResult> srcFuture;
															#line 341 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Future<RangeResult> bkpFuture;
															#line 3472 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
};
// This generated class is to be used only via diffRanges()
															#line 320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class DiffRangesActor final : public Actor<Void>, public ActorCallback< DiffRangesActor, 0, Void >, public ActorCallback< DiffRangesActor, 1, Void >, public FastAllocated<DiffRangesActor>, public DiffRangesActorState<DiffRangesActor> {
															#line 3477 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
public:
	using FastAllocated<DiffRangesActor>::operator new;
	using FastAllocated<DiffRangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13035830482933114624UL, 16300770126231997184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DiffRangesActor, 0, Void >;
friend struct ActorCallback< DiffRangesActor, 1, Void >;
															#line 320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	DiffRangesActor(Standalone<VectorRef<KeyRangeRef>> const& ranges,StringRef const& backupPrefix,Database const& src,Database const& dest) 
															#line 3495 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		 : Actor<Void>(),
		   DiffRangesActorState<DiffRangesActor>(ranges, backupPrefix, src, dest),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14464715535444249600UL, 3030925669057132800UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("diffRanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DiffRangesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DiffRangesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
[[nodiscard]] static Future<Void> diffRanges( Standalone<VectorRef<KeyRangeRef>> const& ranges, StringRef const& backupPrefix, Database const& src, Database const& dest ) {
															#line 320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	return Future<Void>(new DiffRangesActor(ranges, backupPrefix, src, dest));
															#line 3528 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
}

#line 410 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"

																#line 3533 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 411 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
template <class _startActor>
															#line 411 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class _startActorState {
															#line 3539 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
public:
															#line 411 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	_startActorState(Database const& cx,BackupToDBUpgradeWorkload* const& self) 
															#line 411 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
															#line 411 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		 : cx(cx),
															#line 411 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   self(self),
															#line 412 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   backupAgent(cx),
															#line 413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   restoreTool(self->extraDB),
															#line 414 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   prevBackupRanges(),
															#line 415 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   logUid(),
															#line 416 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   commitVersion(),
															#line 418 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   stopDifferential(delay(self->stopDifferentialAfter)),
															#line 419 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		   waitUpgrade(backupAgent.waitUpgradeToLatestDrVersion(self->extraDB, self->backupTag))
															#line 3562 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 420 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(stopDifferential) && success(waitUpgrade);
															#line 420 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3579 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 420 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 3584 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 421 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_WaitDifferentialEnd").detail("Tag", printable(self->backupTag));
															#line 3607 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		try {
															#line 425 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(self->extraDB));
															#line 426 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			;
															#line 3613 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 421 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_WaitDifferentialEnd").detail("Tag", printable(self->backupTag));
															#line 3628 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		try {
															#line 425 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(self->extraDB));
															#line 426 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			;
															#line 3634 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 544 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 3724 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 540 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent(SevError, "BackupAndRestoreCorrectnessError").error(e);
															#line 541 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 3739 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 452 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_Locked").detail("LockedVersion", commitVersion);
															#line 455 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		versionCheckTr = ReadYourWritesTransaction(self->extraDB);
															#line 456 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		;
															#line 3757 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 429 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 430 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<UID> __when_expr_1 = backupAgent.getLogUid(tr, self->backupTag);
															#line 430 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3778 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 430 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, UID >*>(static_cast<_startActor*>(this)));
															#line 3783 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 447 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent("DRU_GetRestoreRangeError").error(e);
															#line 448 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr->onError(e);
															#line 448 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3822 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 448 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 3827 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(UID const& _logUid,int loopDepth) 
	{
															#line 431 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		logUid = _logUid;
															#line 433 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Optional<Key>> __when_expr_2 = tr->get(backupAgent.config.get(BinaryWriter::toValue(logUid, Unversioned())) .pack(BackupAgentBase::keyConfigBackupRanges));
															#line 433 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3846 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 433 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Optional<Key> >*>(static_cast<_startActor*>(this)));
															#line 3851 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(UID && _logUid,int loopDepth) 
	{
															#line 431 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		logUid = _logUid;
															#line 433 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Optional<Key>> __when_expr_2 = tr->get(backupAgent.config.get(BinaryWriter::toValue(logUid, Unversioned())) .pack(BackupAgentBase::keyConfigBackupRanges));
															#line 433 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3864 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 433 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Optional<Key> >*>(static_cast<_startActor*>(this)));
															#line 3869 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(UID const& _logUid,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_logUid, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(UID && _logUid,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_logUid), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Optional<Key> const& backupKeysPacked,int loopDepth) 
	{
															#line 436 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		ASSERT(backupKeysPacked.present());
															#line 438 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		BinaryReader br(backupKeysPacked.get(), IncludeVersion());
															#line 439 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		prevBackupRanges = Standalone<VectorRef<KeyRangeRef>>();
															#line 440 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		br >> prevBackupRanges;
															#line 441 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_3 = lockDatabase(tr, logUid);
															#line 441 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3963 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 441 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 3968 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Optional<Key> && backupKeysPacked,int loopDepth) 
	{
															#line 436 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		ASSERT(backupKeysPacked.present());
															#line 438 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		BinaryReader br(backupKeysPacked.get(), IncludeVersion());
															#line 439 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		prevBackupRanges = Standalone<VectorRef<KeyRangeRef>>();
															#line 440 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		br >> prevBackupRanges;
															#line 441 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_3 = lockDatabase(tr, logUid);
															#line 441 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3987 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 441 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 3992 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Optional<Key> const& backupKeysPacked,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(backupKeysPacked, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Optional<Key> && backupKeysPacked,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(backupKeysPacked), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Optional<Key> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Optional<Key> >*,Optional<Key> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Optional<Key> >*,Optional<Key> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Optional<Key> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 442 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr->addWriteConflictRange(singleKeyRange(StringRef()));
															#line 443 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr->commit();
															#line 443 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4080 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 443 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 4085 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 442 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr->addWriteConflictRange(singleKeyRange(StringRef()));
															#line 443 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr->commit();
															#line 443 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4098 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 443 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 4103 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 444 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		commitVersion = tr->getCommittedVersion();
															#line 4187 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 444 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		commitVersion = tr->getCommittedVersion();
															#line 4196 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 479 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_DiffRanges").log();
															#line 480 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_10 = diffRanges(prevBackupRanges, self->backupPrefix, cx, self->extraDB);
															#line 480 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4371 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont4when1(__when_expr_10.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 480 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 4376 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
		try {
															#line 458 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			versionCheckTr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 459 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			versionCheckTr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 460 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_6 = versionCheckTr.get( BinaryWriter::toValue(logUid, Unversioned()).withPrefix(applyMutationsBeginRange.begin));
															#line 460 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4399 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont3loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont3loopBody1when1(__when_expr_6.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 460 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 4404 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 474 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent("DRU_GetAppliedVersionError").error(e);
															#line 475 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_9 = versionCheckTr.onError(e);
															#line 475 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4443 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1Catch1when1(__when_expr_9.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 475 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 4448 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(Optional<Value> const& v,int loopDepth) 
	{
															#line 462 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_Applied") .detail("AppliedVersion", v.present() ? BinaryReader::fromStringRef<Version>(v.get(), Unversioned()) : -1);
															#line 465 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (v.present() && BinaryReader::fromStringRef<Version>(v.get(), Unversioned()) >= commitVersion)
															#line 4465 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		versionWatch = versionCheckTr.watch( BinaryWriter::toValue(logUid, Unversioned()).withPrefix(applyMutationsBeginRange.begin));
															#line 470 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_7 = versionCheckTr.commit();
															#line 470 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4475 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont3loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont3loopBody1cont2when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 470 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 4480 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(Optional<Value> && v,int loopDepth) 
	{
															#line 462 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_Applied") .detail("AppliedVersion", v.present() ? BinaryReader::fromStringRef<Version>(v.get(), Unversioned()) : -1);
															#line 465 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (v.present() && BinaryReader::fromStringRef<Version>(v.get(), Unversioned()) >= commitVersion)
															#line 4491 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		versionWatch = versionCheckTr.watch( BinaryWriter::toValue(logUid, Unversioned()).withPrefix(applyMutationsBeginRange.begin));
															#line 470 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_7 = versionCheckTr.commit();
															#line 470 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont3loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont3loopBody1cont2when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 470 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 4506 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont3loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 471 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_8 = versionWatch;
															#line 471 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4592 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont3loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont3loopBody1cont3when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 471 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 4597 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 471 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_8 = versionWatch;
															#line 471 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4608 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont3loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont3loopBody1cont3when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 471 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 4613 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont3loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont3loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont3loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 472 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		versionCheckTr.reset();
															#line 4697 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 472 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		versionCheckTr.reset();
															#line 4706 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont3loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont3loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont3loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont3loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont3loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 483 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_AbortBackup").detail("Tag", printable(self->backupTag));
															#line 484 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_11 = backupAgent.abortBackup(self->extraDB, self->backupTag);
															#line 484 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4894 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont5when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 484 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 4899 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 483 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_AbortBackup").detail("Tag", printable(self->backupTag));
															#line 484 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_11 = backupAgent.abortBackup(self->extraDB, self->backupTag);
															#line 484 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4912 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont5when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 484 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 4917 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 485 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_12 = unlockDatabase(self->extraDB, logUid);
															#line 485 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5003 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont6when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 485 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, Void >*>(static_cast<_startActor*>(this)));
															#line 5008 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 485 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_12 = unlockDatabase(self->extraDB, logUid);
															#line 485 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5019 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont6when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 485 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, Void >*>(static_cast<_startActor*>(this)));
															#line 5024 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 488 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_PrepareRestore").detail("RestoreTag", printable(self->restoreTag));
															#line 489 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr2 = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 490 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		;
															#line 5112 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = a_body1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 488 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_PrepareRestore").detail("RestoreTag", printable(self->restoreTag));
															#line 489 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		tr2 = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 490 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		;
															#line 5125 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = a_body1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _startActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _startActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 509 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		restoreRanges = Standalone<VectorRef<KeyRangeRef>>();
															#line 510 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		for( auto r : prevBackupRanges ) {
															#line 511 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			restoreRanges.push_back_deep( restoreRanges.arena(), KeyRangeRef(r.begin.withPrefix(self->backupPrefix), r.end.withPrefix(self->backupPrefix)));
															#line 5213 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
		try {
															#line 518 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent("DRU_RestoreDb").detail("RestoreTag", printable(self->restoreTag));
															#line 519 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_15 = restoreTool.submitBackup( cx, self->restoreTag, restoreRanges, StopWhenDone::True, StringRef(), self->backupPrefix);
															#line 519 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont8Catch1(actor_cancelled(), loopDepth);
															#line 5222 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont8Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont8when1(__when_expr_15.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 16;
															#line 519 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _startActor, 15, Void >*>(static_cast<_startActor*>(this)));
															#line 5227 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont8Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont8Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1(int loopDepth) 
	{
		try {
															#line 492 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			tr2->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 493 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			tr2->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 494 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			for( auto r : prevBackupRanges ) {
															#line 495 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				if (!r.empty())
															#line 5256 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
				{
															#line 496 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					std::cout << "r: " << r.begin.printable() << " - " << r.end.printable() << std::endl;
															#line 497 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					tr2->addReadConflictRange(r);
															#line 498 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
					tr2->clear(r);
															#line 5264 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
				}
			}
															#line 501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_13 = tr2->commit();
															#line 501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont7loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5271 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont7loopBody1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont7loopBody1when1(__when_expr_13.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 5276 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7break1(int loopDepth) 
	{
		try {
			return a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 504 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent("DRU_RestoreSetupError").errorUnsuppressed(e);
															#line 505 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			StrictFuture<Void> __when_expr_14 = tr2->onError(e);
															#line 505 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5315 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont1Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1Catch1when1(__when_expr_14.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 505 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, Void >*>(static_cast<_startActor*>(this)));
															#line 5320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont7break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont7loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont7break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _startActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont7loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont7loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont7loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< _startActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont7loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< _startActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 527 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_16 = success(restoreTool.waitBackup(cx, self->restoreTag));
															#line 527 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5511 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont9when1(__when_expr_16.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 17;
															#line 527 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< _startActor, 16, Void >*>(static_cast<_startActor*>(this)));
															#line 5516 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 522 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			TraceEvent("DRU_RestoreSubmitBackupError").error(e).detail("Tag", printable(self->restoreTag));
															#line 523 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 5528 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			{
															#line 524 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
				return a_body1cont1Catch1(e, loopDepth);
															#line 5532 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
			}
			loopDepth = a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< _startActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont8Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont11cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
															#line 528 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_17 = restoreTool.unlockBackup(cx, self->restoreTag);
															#line 528 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5650 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont1Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont12when1(__when_expr_17.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 18;
															#line 528 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< _startActor, 17, Void >*>(static_cast<_startActor*>(this)));
															#line 5655 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
															#line 528 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_17 = restoreTool.unlockBackup(cx, self->restoreTag);
															#line 528 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5666 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont1Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont12when1(__when_expr_17.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 18;
															#line 528 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< _startActor, 17, Void >*>(static_cast<_startActor*>(this)));
															#line 5671 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 16, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 16, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< _startActor, 16, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< _startActor, 16, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont12cont1(Void const& _,int loopDepth) 
	{
															#line 529 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_18 = checkData(self->extraDB, logUid, logUid, self->backupTag, &backupAgent);
															#line 529 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5757 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont12cont1when1(__when_expr_18.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 19;
															#line 529 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< _startActor, 18, Void >*>(static_cast<_startActor*>(this)));
															#line 5762 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1(Void && _,int loopDepth) 
	{
															#line 529 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_18 = checkData(self->extraDB, logUid, logUid, self->backupTag, &backupAgent);
															#line 529 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5773 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont12cont1when1(__when_expr_18.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 19;
															#line 529 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< _startActor, 18, Void >*>(static_cast<_startActor*>(this)));
															#line 5778 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 17, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 17, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< _startActor, 17, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< _startActor, 17, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont12cont2(Void const& _,int loopDepth) 
	{
															#line 531 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<UID> __when_expr_19 = restoreTool.getLogUid(cx, self->restoreTag);
															#line 531 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5864 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1cont1Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont12cont2when1(__when_expr_19.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 20;
															#line 531 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< _startActor, 19, UID >*>(static_cast<_startActor*>(this)));
															#line 5869 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2(Void && _,int loopDepth) 
	{
															#line 531 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<UID> __when_expr_19 = restoreTool.getLogUid(cx, self->restoreTag);
															#line 531 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5880 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1cont1Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont12cont2when1(__when_expr_19.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 20;
															#line 531 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< _startActor, 19, UID >*>(static_cast<_startActor*>(this)));
															#line 5885 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 18, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 18, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont12cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< _startActor, 18, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont12cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< _startActor, 18, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont12cont3(int loopDepth) 
	{
															#line 532 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		StrictFuture<Void> __when_expr_20 = checkData(cx, restoreUid, restoreUid, self->restoreTag, &restoreTool);
															#line 532 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5971 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1cont1Catch1(__when_expr_20.getError(), loopDepth); else return a_body1cont12cont3when1(__when_expr_20.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 21;
															#line 532 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		__when_expr_20.addCallbackAndClear(static_cast<ActorCallback< _startActor, 20, Void >*>(static_cast<_startActor*>(this)));
															#line 5976 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2when1(UID const& __restoreUid,int loopDepth) 
	{
															#line 531 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		restoreUid = __restoreUid;
															#line 5985 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		loopDepth = a_body1cont12cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2when1(UID && __restoreUid,int loopDepth) 
	{
		restoreUid = std::move(__restoreUid);
		loopDepth = a_body1cont12cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 19, UID >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 19, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont12cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< _startActor, 19, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont12cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< _startActor, 19, UID >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	int a_body1cont12cont4(Void const& _,int loopDepth) 
	{
															#line 534 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_Complete").detail("BackupTag", printable(self->backupTag));
															#line 536 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (g_simulator->drAgents == ISimulator::BackupAgentType::BackupToDB)
															#line 6066 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
															#line 537 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			g_simulator->drAgents = ISimulator::BackupAgentType::NoBackupAgents;
															#line 6070 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4(Void && _,int loopDepth) 
	{
															#line 534 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		TraceEvent("DRU_Complete").detail("BackupTag", printable(self->backupTag));
															#line 536 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
		if (g_simulator->drAgents == ISimulator::BackupAgentType::BackupToDB)
															#line 6082 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		{
															#line 537 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
			g_simulator->drAgents = ISimulator::BackupAgentType::NoBackupAgents;
															#line 6086 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose21() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 20, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 20, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont12cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorCallback< _startActor, 20, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont12cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorCallback< _startActor, 20, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 20);

	}
	int a_body1cont12cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 411 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Database cx;
															#line 411 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	BackupToDBUpgradeWorkload* self;
															#line 412 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	DatabaseBackupAgent backupAgent;
															#line 413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	DatabaseBackupAgent restoreTool;
															#line 414 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> prevBackupRanges;
															#line 415 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	UID logUid;
															#line 416 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Version commitVersion;
															#line 418 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Future<Void> stopDifferential;
															#line 419 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Future<Void> waitUpgrade;
															#line 425 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 455 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	ReadYourWritesTransaction versionCheckTr;
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Future<Void> versionWatch;
															#line 489 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Reference<ReadYourWritesTransaction> tr2;
															#line 509 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> restoreRanges;
															#line 531 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	UID restoreUid;
															#line 6210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 411 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, UID >, public ActorCallback< _startActor, 2, Optional<Key> >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Optional<Value> >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, Void >, public ActorCallback< _startActor, 10, Void >, public ActorCallback< _startActor, 11, Void >, public ActorCallback< _startActor, 12, Void >, public ActorCallback< _startActor, 13, Void >, public ActorCallback< _startActor, 14, Void >, public ActorCallback< _startActor, 15, Void >, public ActorCallback< _startActor, 16, Void >, public ActorCallback< _startActor, 17, Void >, public ActorCallback< _startActor, 18, Void >, public ActorCallback< _startActor, 19, UID >, public ActorCallback< _startActor, 20, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 6215 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12713489574460620032UL, 18012355227254692864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, UID >;
friend struct ActorCallback< _startActor, 2, Optional<Key> >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Optional<Value> >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, Void >;
friend struct ActorCallback< _startActor, 10, Void >;
friend struct ActorCallback< _startActor, 11, Void >;
friend struct ActorCallback< _startActor, 12, Void >;
friend struct ActorCallback< _startActor, 13, Void >;
friend struct ActorCallback< _startActor, 14, Void >;
friend struct ActorCallback< _startActor, 15, Void >;
friend struct ActorCallback< _startActor, 16, Void >;
friend struct ActorCallback< _startActor, 17, Void >;
friend struct ActorCallback< _startActor, 18, Void >;
friend struct ActorCallback< _startActor, 19, UID >;
friend struct ActorCallback< _startActor, 20, Void >;
															#line 411 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	_startActor(Database const& cx,BackupToDBUpgradeWorkload* const& self) 
															#line 6252 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, UID >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Optional<Key> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Optional<Value> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _startActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _startActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< _startActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< _startActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< _startActor, 16, Void >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< _startActor, 17, Void >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< _startActor, 18, Void >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< _startActor, 19, UID >*)0, actor_cancelled()); break;
		case 21: this->a_callback_error((ActorCallback< _startActor, 20, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 411 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, BackupToDBUpgradeWorkload* const& self ) {
															#line 411 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 6304 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBUpgrade.actor.g.cpp"
}

#line 546 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBUpgrade.actor.cpp"
};

WorkloadFactory<BackupToDBUpgradeWorkload> BackupToDBUpgradeWorkloadFactory;
