#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
/*
 * ApiCorrectness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBTypes.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbrpc/TenantInfo.h"
#include "fdbserver/QuietDatabase.h"

#include "fdbserver/MutationTracking.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/ApiWorkload.h"
#include "fdbserver/workloads/MemoryKeyValueStore.h"
#include "flow/IRandom.h"
#include "flow/actorcompiler.h" // This must be the last #include.
#include "flow/genericactors.actor.h"

// Valdiate at-rest encryption guarantees. If enabled, test injects a known 'marker' in Key and/or Values
// inserted into FDB by the workload. On shutdown, all test generated files (under simfdb/) can scanned to find if
// 'plaintext marker' is present.
const std::string ENCRYPTION_AT_REST_MARKER_STRING = "Expecto..Patronum...";

// An enum of API operation types used in the random test
enum OperationType { SET, GET, GET_RANGE, GET_RANGE_SELECTOR, GET_KEY, CLEAR, CLEAR_RANGE, UNINITIALIZED };

// A workload that executes the NativeAPIs functions and verifies that their outcomes are correct
struct ApiCorrectnessWorkload : ApiWorkload {
	static constexpr auto NAME = "ApiCorrectness";

private:
// Enable to track the activity on a particular key
#if CENABLED(0, NOT_IN_CLEAN)
#define targetKey "???"_sr

	void debugKey(KeyRef key, std::string context) {
		if (key == targetKey)
			TraceEvent("ApiCorrectnessDebugKey").detail("Context", context).detail("Key", printable(key));
	}

	void debugKey(KeyRangeRef keyRange, std::string context) {
		if (keyRange.contains(targetKey))
			TraceEvent("ApiCorrectnessDebugKey")
			    .detail("Context", context)
			    .detail("Key", printable(targetKey))
			    .detail("RangeBegin", printable(keyRange.begin))
			    .detail("RangeEnd", printable(keyRange.end));
	}

#else
	void debugKey(KeyRef key, std::string context) {}
	void debugKey(KeyRangeRef keyRange, std::string context) {}

#endif

public:
	// The number of gets that should be performed
	int numGets;

	// The number of getRanges that should be performed
	int numGetRanges;

	// The number of getRanges using key selectors that should be performed
	int numGetRangeSelectors;

	// The number of getKeys that should be performed
	int numGetKeys;

	// The number of clears that should be performed
	int numClears;

	// The number of clears using key ranges that should be performed
	int numClearRanges;

	// The smallest legal size of the database after a clear.  A smaller size will trigger a database reset
	int minSizeAfterClear;

	// The maximum number of keys that can be in this client's key space when performing the random test
	int maxRandomTestKeys;

	// The amount of time to run the random tests
	double randomTestDuration;

	// The maximum number of keys operated on in a transaction; used to prevent transaction_too_old errors
	int maxKeysPerTransaction;

	// The number of API calls made by the random test
	PerfIntCounter numRandomOperations;

	// The API being used by this client
	TransactionType transactionType;

	// Maximum time to reset DB to the original state
	double resetDBTimeout;

	// Validate data at-rest encryption guarantees
	int validateEncryptionAtRest;

	ApiCorrectnessWorkload(WorkloadContext const& wcx)
	  : ApiWorkload(wcx), numRandomOperations("Num Random Operations") {
		numGets = getOption(options, "numGets"_sr, 1000);
		numGetRanges = getOption(options, "numGetRanges"_sr, 100);
		numGetRangeSelectors = getOption(options, "numGetRangeSelectors"_sr, 100);
		numGetKeys = getOption(options, "numGetKeys"_sr, 100);
		numClears = getOption(options, "numClears"_sr, 100);
		numClearRanges = getOption(options, "numClearRanges"_sr, 100);
		minSizeAfterClear = getOption(options, "minSizeAfterClear"_sr, (int)(0.1 * numKeys));

		maxRandomTestKeys = getOption(options, "maxRandomTestKeys"_sr, numKeys);
		randomTestDuration = getOption(options, "randomTestDuration"_sr, 60.0);

		int maxTransactionBytes = getOption(options, "maxTransactionBytes"_sr, 500000);
		maxKeysPerTransaction = std::max(1, maxTransactionBytes / (maxValueLength + maxLongKeyLength));

		validateEncryptionAtRest =
		    g_network->isSimulated()
		        ? getOption(options, "validateEncryptionAtRest"_sr, deterministicRandom()->coinflip() ? 1 : 0)
		        : 0;

		resetDBTimeout = getOption(options, "resetDBTimeout"_sr, 1800.0);

		if (maxTransactionBytes > 500000) {
			TraceEvent("RemapEventSeverity")
			    .detail("TargetEvent", "LargePacketSent")
			    .detail("OriginalSeverity", SevWarnAlways)
			    .detail("NewSeverity", SevInfo);
			TraceEvent("RemapEventSeverity")
			    .detail("TargetEvent", "LargePacketReceived")
			    .detail("OriginalSeverity", SevWarnAlways)
			    .detail("NewSeverity", SevInfo);
			TraceEvent("RemapEventSeverity")
			    .detail("TargetEvent", "LargeTransaction")
			    .detail("OriginalSeverity", SevWarnAlways)
			    .detail("NewSeverity", SevInfo);
			TraceEvent("RemapEventSeverity")
			    .detail("TargetEvent", "DiskQueueMemoryWarning")
			    .detail("OriginalSeverity", SevWarnAlways)
			    .detail("NewSeverity", SevInfo);
		}
	}

	~ApiCorrectnessWorkload() override {}

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.emplace_back("Number of Random Operations Performed", numRandomOperations.getValue(), Averaged::False);
	}

																#line 167 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
// This generated class is to be used only via performSetup()
															#line 165 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class PerformSetupActor>
															#line 165 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class PerformSetupActorState {
															#line 173 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
															#line 165 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	PerformSetupActorState(Database const& cx,ApiCorrectnessWorkload* const& self) 
															#line 165 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 165 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 165 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   self(self)
															#line 182 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("performSetup", reinterpret_cast<unsigned long>(this));

	}
	~PerformSetupActorState() 
	{
		fdb_probe_actor_destroy("performSetup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 166 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_0 = getDatabaseConfiguration(cx);
															#line 166 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<PerformSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 199 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PerformSetupActor*>(this)->actor_wait_state = 1;
															#line 166 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PerformSetupActor, 0, DatabaseConfiguration >*>(static_cast<PerformSetupActor*>(this)));
															#line 204 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PerformSetupActorState();
		static_cast<PerformSetupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(DatabaseConfiguration const& dbConfig,int loopDepth) 
	{
															#line 167 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (g_network->isSimulated() && dbConfig.encryptionAtRestMode.isEncryptionEnabled() && self->validateEncryptionAtRest)
															#line 227 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 169 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			TraceEvent("EncryptionAtRestPlainTextMarkerCheckEnabled") .detail("EncryptionMode", dbConfig.encryptionAtRestMode.toString()) .detail("DataAtRestMarker", ENCRYPTION_AT_REST_MARKER_STRING);
															#line 172 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			g_simulator->dataAtRestPlaintextMarker = ENCRYPTION_AT_REST_MARKER_STRING;
															#line 233 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 176 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		std::vector<TransactionType> types;
															#line 177 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		types.push_back(NATIVE);
															#line 178 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		types.push_back(READ_YOUR_WRITES);
															#line 179 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		types.push_back(THREAD_SAFE);
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		types.push_back(MULTI_VERSION);
															#line 182 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->chooseTransactionFactory(cx, types);
															#line 182 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<PerformSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 249 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PerformSetupActor*>(this)->actor_wait_state = 2;
															#line 182 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PerformSetupActor, 1, Void >*>(static_cast<PerformSetupActor*>(this)));
															#line 254 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(DatabaseConfiguration && dbConfig,int loopDepth) 
	{
															#line 167 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (g_network->isSimulated() && dbConfig.encryptionAtRestMode.isEncryptionEnabled() && self->validateEncryptionAtRest)
															#line 263 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 169 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			TraceEvent("EncryptionAtRestPlainTextMarkerCheckEnabled") .detail("EncryptionMode", dbConfig.encryptionAtRestMode.toString()) .detail("DataAtRestMarker", ENCRYPTION_AT_REST_MARKER_STRING);
															#line 172 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			g_simulator->dataAtRestPlaintextMarker = ENCRYPTION_AT_REST_MARKER_STRING;
															#line 269 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 176 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		std::vector<TransactionType> types;
															#line 177 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		types.push_back(NATIVE);
															#line 178 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		types.push_back(READ_YOUR_WRITES);
															#line 179 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		types.push_back(THREAD_SAFE);
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		types.push_back(MULTI_VERSION);
															#line 182 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->chooseTransactionFactory(cx, types);
															#line 182 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<PerformSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 285 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PerformSetupActor*>(this)->actor_wait_state = 2;
															#line 182 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PerformSetupActor, 1, Void >*>(static_cast<PerformSetupActor*>(this)));
															#line 290 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration const& dbConfig,int loopDepth) 
	{
		loopDepth = a_body1cont1(dbConfig, loopDepth);

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration && dbConfig,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(dbConfig), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PerformSetupActor*>(this)->actor_wait_state > 0) static_cast<PerformSetupActor*>(this)->actor_wait_state = 0;
		static_cast<PerformSetupActor*>(this)->ActorCallback< PerformSetupActor, 0, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< PerformSetupActor, 0, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PerformSetupActor, 0, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PerformSetupActor, 0, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 184 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<PerformSetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerformSetupActorState(); static_cast<PerformSetupActor*>(this)->destroy(); return 0; }
															#line 374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		new (&static_cast<PerformSetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PerformSetupActorState();
		static_cast<PerformSetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 184 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<PerformSetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerformSetupActorState(); static_cast<PerformSetupActor*>(this)->destroy(); return 0; }
															#line 386 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		new (&static_cast<PerformSetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PerformSetupActorState();
		static_cast<PerformSetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PerformSetupActor*>(this)->actor_wait_state > 0) static_cast<PerformSetupActor*>(this)->actor_wait_state = 0;
		static_cast<PerformSetupActor*>(this)->ActorCallback< PerformSetupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerformSetupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PerformSetupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PerformSetupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 165 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Database cx;
															#line 165 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 473 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
};
// This generated class is to be used only via performSetup()
															#line 165 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class PerformSetupActor final : public Actor<Void>, public ActorCallback< PerformSetupActor, 0, DatabaseConfiguration >, public ActorCallback< PerformSetupActor, 1, Void >, public FastAllocated<PerformSetupActor>, public PerformSetupActorState<PerformSetupActor> {
															#line 478 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
	using FastAllocated<PerformSetupActor>::operator new;
	using FastAllocated<PerformSetupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8605244654980418048UL, 17147336206944265216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PerformSetupActor, 0, DatabaseConfiguration >;
friend struct ActorCallback< PerformSetupActor, 1, Void >;
															#line 165 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	PerformSetupActor(Database const& cx,ApiCorrectnessWorkload* const& self) 
															#line 496 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   PerformSetupActorState<PerformSetupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("performSetup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(908050500225728256UL, 2892666575110672640UL);
		ActorExecutionContextHelper __helper(static_cast<PerformSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("performSetup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("performSetup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PerformSetupActor, 0, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PerformSetupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 165 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> performSetup( Database const& cx, ApiCorrectnessWorkload* const& self ) {
															#line 165 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<Void>(new PerformSetupActor(cx, self));
															#line 529 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
}

#line 186 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	Future<Void> performSetup(Database const& cx) override { return performSetup(cx, this); }

																#line 536 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
// This generated class is to be used only via performTest()
															#line 189 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class PerformTestActor>
															#line 189 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class PerformTestActorState {
															#line 542 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
															#line 189 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	PerformTestActorState(Database const& cx,Standalone<VectorRef<KeyValueRef>> const& data,ApiCorrectnessWorkload* const& self) 
															#line 189 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 189 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 189 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   data(data),
															#line 189 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   self(self)
															#line 553 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("performTest", reinterpret_cast<unsigned long>(this));

	}
	~PerformTestActorState() 
	{
		fdb_probe_actor_destroy("performTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 191 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeout(self->runScriptedTest(self, data), 600, Void());
															#line 191 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<PerformTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PerformTestActor*>(this)->actor_wait_state = 1;
															#line 191 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PerformTestActor, 0, Void >*>(static_cast<PerformTestActor*>(this)));
															#line 575 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PerformTestActorState();
		static_cast<PerformTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 193 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!self->hasFailed())
															#line 598 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
			try {
															#line 196 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_1 = timeoutError(::success(self->runSet(data, self)), self->resetDBTimeout);
															#line 196 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				if (static_cast<PerformTestActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 605 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<PerformTestActor*>(this)->actor_wait_state = 2;
															#line 196 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PerformTestActor, 1, Void >*>(static_cast<PerformTestActor*>(this)));
															#line 610 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 193 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!self->hasFailed())
															#line 630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
			try {
															#line 196 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_1 = timeoutError(::success(self->runSet(data, self)), self->resetDBTimeout);
															#line 196 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				if (static_cast<PerformTestActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 637 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<PerformTestActor*>(this)->actor_wait_state = 2;
															#line 196 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PerformTestActor, 1, Void >*>(static_cast<PerformTestActor*>(this)));
															#line 642 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PerformTestActor*>(this)->actor_wait_state > 0) static_cast<PerformTestActor*>(this)->actor_wait_state = 0;
		static_cast<PerformTestActor*>(this)->ActorCallback< PerformTestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerformTestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PerformTestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PerformTestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 212 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<PerformTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerformTestActorState(); static_cast<PerformTestActor*>(this)->destroy(); return 0; }
															#line 737 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		new (&static_cast<PerformTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PerformTestActorState();
		static_cast<PerformTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 209 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = timeout(self->runRandomTest(self, data), self->randomTestDuration, Void());
															#line 209 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<PerformTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 751 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PerformTestActor*>(this)->actor_wait_state = 3;
															#line 209 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PerformTestActor, 2, Void >*>(static_cast<PerformTestActor*>(this)));
															#line 756 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 198 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 766 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			{
															#line 199 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				if (!self->hasFailed())
															#line 770 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
				{
															#line 200 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					self->testFailure("Timeout during database reset");
															#line 774 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
				}
															#line 202 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				if (!static_cast<PerformTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerformTestActorState(); static_cast<PerformTestActor*>(this)->destroy(); return 0; }
															#line 778 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
				new (&static_cast<PerformTestActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~PerformTestActorState();
				static_cast<PerformTestActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 205 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 786 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PerformTestActor*>(this)->actor_wait_state > 0) static_cast<PerformTestActor*>(this)->actor_wait_state = 0;
		static_cast<PerformTestActor*>(this)->ActorCallback< PerformTestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerformTestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PerformTestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PerformTestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PerformTestActor*>(this)->actor_wait_state > 0) static_cast<PerformTestActor*>(this)->actor_wait_state = 0;
		static_cast<PerformTestActor*>(this)->ActorCallback< PerformTestActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerformTestActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PerformTestActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PerformTestActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 189 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Database cx;
															#line 189 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> data;
															#line 189 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 989 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
};
// This generated class is to be used only via performTest()
															#line 189 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class PerformTestActor final : public Actor<Void>, public ActorCallback< PerformTestActor, 0, Void >, public ActorCallback< PerformTestActor, 1, Void >, public ActorCallback< PerformTestActor, 2, Void >, public FastAllocated<PerformTestActor>, public PerformTestActorState<PerformTestActor> {
															#line 994 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
	using FastAllocated<PerformTestActor>::operator new;
	using FastAllocated<PerformTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11567711545057324544UL, 1516208415991514112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PerformTestActor, 0, Void >;
friend struct ActorCallback< PerformTestActor, 1, Void >;
friend struct ActorCallback< PerformTestActor, 2, Void >;
															#line 189 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	PerformTestActor(Database const& cx,Standalone<VectorRef<KeyValueRef>> const& data,ApiCorrectnessWorkload* const& self) 
															#line 1013 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   PerformTestActorState<PerformTestActor>(cx, data, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("performTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6826498282132105984UL, 12962792935105555968UL);
		ActorExecutionContextHelper __helper(static_cast<PerformTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("performTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("performTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PerformTestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PerformTestActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PerformTestActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 189 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> performTest( Database const& cx, Standalone<VectorRef<KeyValueRef>> const& data, ApiCorrectnessWorkload* const& self ) {
															#line 189 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<Void>(new PerformTestActor(cx, data, self));
															#line 1047 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
}

#line 214 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	Future<Void> performTest(Database const& cx, Standalone<VectorRef<KeyValueRef>> const& data) override {
		return performTest(cx, data, this);
	}

	// Run a scripted set of API operations
																#line 1057 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
// This generated class is to be used only via runScriptedTest()
															#line 220 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class RunScriptedTestActor>
															#line 220 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunScriptedTestActorState {
															#line 1063 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
															#line 220 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunScriptedTestActorState(ApiCorrectnessWorkload* const& self,VectorRef<KeyValueRef> const& data) 
															#line 220 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 220 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : self(self),
															#line 220 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   data(data)
															#line 1072 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("runScriptedTest", reinterpret_cast<unsigned long>(this));

	}
	~RunScriptedTestActorState() 
	{
		fdb_probe_actor_destroy("runScriptedTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 222 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<bool> __when_expr_0 = self->runSet(data, self);
															#line 222 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1089 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 1;
															#line 222 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 0, bool >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1094 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunScriptedTestActorState();
		static_cast<RunScriptedTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& setResult,int loopDepth) 
	{
															#line 223 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!setResult)
															#line 1117 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 224 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunScriptedTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunScriptedTestActorState(); static_cast<RunScriptedTestActor*>(this)->destroy(); return 0; }
															#line 1121 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunScriptedTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunScriptedTestActorState();
			static_cast<RunScriptedTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 227 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = ::success(self->runGet(data, self->numGets, self));
															#line 227 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1131 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 2;
															#line 227 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 1, Void >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1136 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool && setResult,int loopDepth) 
	{
															#line 223 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!setResult)
															#line 1145 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 224 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunScriptedTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunScriptedTestActorState(); static_cast<RunScriptedTestActor*>(this)->destroy(); return 0; }
															#line 1149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunScriptedTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunScriptedTestActorState();
			static_cast<RunScriptedTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 227 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = ::success(self->runGet(data, self->numGets, self));
															#line 227 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1159 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 2;
															#line 227 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 1, Void >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1164 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(bool const& setResult,int loopDepth) 
	{
		loopDepth = a_body1cont1(setResult, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && setResult,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(setResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state > 0) static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunScriptedTestActor*>(this)->ActorCallback< RunScriptedTestActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunScriptedTestActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 230 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i = int();
															#line 231 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i = 0;
															#line 1250 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 230 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i = int();
															#line 231 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i = 0;
															#line 1261 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state > 0) static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunScriptedTestActor*>(this)->ActorCallback< RunScriptedTestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunScriptedTestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 235 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i = 0;
															#line 1345 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 231 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(i < self->numGetRanges))
															#line 1361 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 232 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = ::success(self->runGetRange(data, self));
															#line 232 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1369 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 3;
															#line 232 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 2, Void >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 231 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i++;
															#line 1396 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 231 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i++;
															#line 1405 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state > 0) static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunScriptedTestActor*>(this)->ActorCallback< RunScriptedTestActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunScriptedTestActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 239 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = ::success(self->runGetKey(data, self->numGetKeys, self));
															#line 239 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1491 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 5;
															#line 239 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 4, Void >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1496 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 235 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(i < self->numGetRangeSelectors))
															#line 1512 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 236 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = ::success(self->runGetRangeSelector(data, self));
															#line 236 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1520 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 4;
															#line 236 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 3, Void >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1525 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 235 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i++;
															#line 1547 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 235 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i++;
															#line 1556 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state > 0) static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunScriptedTestActor*>(this)->ActorCallback< RunScriptedTestActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunScriptedTestActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 242 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<bool> __when_expr_5 = self->runClear(data, self->numClears, self);
															#line 242 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1642 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 6;
															#line 242 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 5, bool >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1647 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 242 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<bool> __when_expr_5 = self->runClear(data, self->numClears, self);
															#line 242 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1658 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 6;
															#line 242 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 5, bool >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1663 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state > 0) static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunScriptedTestActor*>(this)->ActorCallback< RunScriptedTestActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunScriptedTestActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(bool const& clearResult,int loopDepth) 
	{
															#line 243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!clearResult)
															#line 1747 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 244 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunScriptedTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunScriptedTestActorState(); static_cast<RunScriptedTestActor*>(this)->destroy(); return 0; }
															#line 1751 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunScriptedTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunScriptedTestActorState();
			static_cast<RunScriptedTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 247 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i = 0;
															#line 1759 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = a_body1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(bool && clearResult,int loopDepth) 
	{
															#line 243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!clearResult)
															#line 1768 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 244 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunScriptedTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunScriptedTestActorState(); static_cast<RunScriptedTestActor*>(this)->destroy(); return 0; }
															#line 1772 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunScriptedTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunScriptedTestActorState();
			static_cast<RunScriptedTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 247 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i = 0;
															#line 1780 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = a_body1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(bool const& clearResult,int loopDepth) 
	{
		loopDepth = a_body1cont7(clearResult, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(bool && clearResult,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(clearResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state > 0) static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunScriptedTestActor*>(this)->ActorCallback< RunScriptedTestActor, 5, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 5, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 5, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunScriptedTestActor, 5, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 260 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunScriptedTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunScriptedTestActorState(); static_cast<RunScriptedTestActor*>(this)->destroy(); return 0; }
															#line 1864 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		new (&static_cast<RunScriptedTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunScriptedTestActorState();
		static_cast<RunScriptedTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1(int loopDepth) 
	{
															#line 247 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(i < self->numClearRanges))
															#line 1883 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
			return a_body1cont7break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 249 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (self->store.size() < self->minSizeAfterClear)
															#line 1889 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 250 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<bool> __when_expr_6 = self->runSet(data, self);
															#line 250 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1895 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1when1(__when_expr_6.get(), loopDepth); };
			static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 7;
															#line 250 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 6, bool >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1900 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7break1(int loopDepth) 
	{
		try {
			return a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(int loopDepth) 
	{
															#line 255 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<bool> __when_expr_7 = self->runClearRange(data, self);
															#line 255 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1929 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1cont1when1(__when_expr_7.get(), loopDepth); };
		static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 8;
															#line 255 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunScriptedTestActor, 7, bool >*>(static_cast<RunScriptedTestActor*>(this)));
															#line 1934 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7loopBody1cont3(bool const& resetResult,int loopDepth) 
	{
															#line 251 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!resetResult)
															#line 1943 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 252 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunScriptedTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunScriptedTestActorState(); static_cast<RunScriptedTestActor*>(this)->destroy(); return 0; }
															#line 1947 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunScriptedTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunScriptedTestActorState();
			static_cast<RunScriptedTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont3(bool && resetResult,int loopDepth) 
	{
															#line 251 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!resetResult)
															#line 1961 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 252 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunScriptedTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunScriptedTestActorState(); static_cast<RunScriptedTestActor*>(this)->destroy(); return 0; }
															#line 1965 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunScriptedTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunScriptedTestActorState();
			static_cast<RunScriptedTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(bool const& resetResult,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont3(resetResult, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(bool && resetResult,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont3(std::move(resetResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state > 0) static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunScriptedTestActor*>(this)->ActorCallback< RunScriptedTestActor, 6, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 6, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 6, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RunScriptedTestActor, 6, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont7loopBody1cont6(bool const& clearRangeResults,int loopDepth) 
	{
															#line 256 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!clearRangeResults)
															#line 2054 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 257 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunScriptedTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunScriptedTestActorState(); static_cast<RunScriptedTestActor*>(this)->destroy(); return 0; }
															#line 2058 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunScriptedTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunScriptedTestActorState();
			static_cast<RunScriptedTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 247 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i++;
															#line 2066 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont6(bool && clearRangeResults,int loopDepth) 
	{
															#line 256 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!clearRangeResults)
															#line 2075 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 257 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunScriptedTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunScriptedTestActorState(); static_cast<RunScriptedTestActor*>(this)->destroy(); return 0; }
															#line 2079 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunScriptedTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunScriptedTestActorState();
			static_cast<RunScriptedTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 247 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i++;
															#line 2087 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1when1(bool const& clearRangeResults,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont6(clearRangeResults, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1when1(bool && clearRangeResults,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont6(std::move(clearRangeResults), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<RunScriptedTestActor*>(this)->actor_wait_state > 0) static_cast<RunScriptedTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunScriptedTestActor*>(this)->ActorCallback< RunScriptedTestActor, 7, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 7, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RunScriptedTestActor, 7, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RunScriptedTestActor, 7, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 220 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 220 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	VectorRef<KeyValueRef> data;
															#line 230 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int i;
															#line 2173 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
};
// This generated class is to be used only via runScriptedTest()
															#line 220 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunScriptedTestActor final : public Actor<Void>, public ActorCallback< RunScriptedTestActor, 0, bool >, public ActorCallback< RunScriptedTestActor, 1, Void >, public ActorCallback< RunScriptedTestActor, 2, Void >, public ActorCallback< RunScriptedTestActor, 3, Void >, public ActorCallback< RunScriptedTestActor, 4, Void >, public ActorCallback< RunScriptedTestActor, 5, bool >, public ActorCallback< RunScriptedTestActor, 6, bool >, public ActorCallback< RunScriptedTestActor, 7, bool >, public FastAllocated<RunScriptedTestActor>, public RunScriptedTestActorState<RunScriptedTestActor> {
															#line 2178 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
	using FastAllocated<RunScriptedTestActor>::operator new;
	using FastAllocated<RunScriptedTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11307507070516042752UL, 9522456018489086976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunScriptedTestActor, 0, bool >;
friend struct ActorCallback< RunScriptedTestActor, 1, Void >;
friend struct ActorCallback< RunScriptedTestActor, 2, Void >;
friend struct ActorCallback< RunScriptedTestActor, 3, Void >;
friend struct ActorCallback< RunScriptedTestActor, 4, Void >;
friend struct ActorCallback< RunScriptedTestActor, 5, bool >;
friend struct ActorCallback< RunScriptedTestActor, 6, bool >;
friend struct ActorCallback< RunScriptedTestActor, 7, bool >;
															#line 220 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunScriptedTestActor(ApiCorrectnessWorkload* const& self,VectorRef<KeyValueRef> const& data) 
															#line 2202 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   RunScriptedTestActorState<RunScriptedTestActor>(self, data),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runScriptedTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6987836142697489664UL, 13927679211788957952UL);
		ActorExecutionContextHelper __helper(static_cast<RunScriptedTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runScriptedTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runScriptedTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunScriptedTestActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunScriptedTestActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunScriptedTestActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunScriptedTestActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunScriptedTestActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RunScriptedTestActor, 5, bool >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RunScriptedTestActor, 6, bool >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< RunScriptedTestActor, 7, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 220 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> runScriptedTest( ApiCorrectnessWorkload* const& self, VectorRef<KeyValueRef> const& data ) {
															#line 220 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<Void>(new RunScriptedTestActor(self, data));
															#line 2241 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
}

#line 262 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	// Generate and execute a sequence of random operations
																#line 2247 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
// This generated class is to be used only via runRandomTest()
															#line 264 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class RunRandomTestActor>
															#line 264 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunRandomTestActorState {
															#line 2253 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
															#line 264 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunRandomTestActorState(ApiCorrectnessWorkload* const& self,Standalone<VectorRef<KeyValueRef>> const& data) 
															#line 264 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 264 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : self(self),
															#line 264 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   data(data)
															#line 2262 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("runRandomTest", reinterpret_cast<unsigned long>(this));

	}
	~RunRandomTestActorState() 
	{
		fdb_probe_actor_destroy("runRandomTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 265 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			;
															#line 2277 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunRandomTestActorState();
		static_cast<RunRandomTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 266 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		double setProbability = 1 - ((double)self->store.size()) / self->maxRandomTestKeys;
															#line 267 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		int pdfArray[] = { 0, (int)(100 * setProbability), 100, 50, 50, 20, (int)(100 * (1 - setProbability)), (int)(10 * (1 - setProbability)) };
															#line 275 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		std::vector<int> pdf = std::vector<int>(pdfArray, pdfArray + 8);
															#line 277 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		OperationType operation = UNINITIALIZED;
															#line 280 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		int totalDensity = 0;
															#line 281 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = 0;i < pdf.size();i++) {
															#line 282 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			totalDensity += pdf[i];
															#line 2319 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 284 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		int cumulativeDensity = 0;
															#line 285 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		int random = deterministicRandom()->randomInt(0, totalDensity);
															#line 286 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = 0;i < pdf.size() - 1;i++) {
															#line 287 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (cumulativeDensity + pdf[i] <= random && random < cumulativeDensity + pdf[i] + pdf[i + 1])
															#line 2329 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			{
															#line 288 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				operation = (OperationType)i;
															#line 2333 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
				break;
			}
															#line 292 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			cumulativeDensity += pdf[i];
															#line 2338 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 294 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		ASSERT(operation != UNINITIALIZED);
															#line 296 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		++self->numRandomOperations;
															#line 299 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (operation == SET)
															#line 2346 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 300 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			bool useShortKeys = deterministicRandom()->randomInt(0, 2) == 1;
															#line 301 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			int minKeyLength = useShortKeys ? self->minShortKeyLength : self->minLongKeyLength;
															#line 302 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			int maxKeyLength = useShortKeys ? self->maxShortKeyLength : self->maxLongKeyLength;
															#line 304 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			newData = self->generateData(std::min((uint64_t)100, self->maxRandomTestKeys - self->store.size()), minKeyLength, maxKeyLength, self->minValueLength, self->maxValueLength, self->clientPrefix, true);
															#line 313 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			data.append_deep(data.arena(), newData.begin(), newData.size());
															#line 315 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<bool> __when_expr_0 = self->runSet(newData, self);
															#line 315 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunRandomTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2362 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunRandomTestActor*>(this)->actor_wait_state = 1;
															#line 315 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunRandomTestActor, 0, bool >*>(static_cast<RunRandomTestActor*>(this)));
															#line 2367 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 321 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (operation == GET)
															#line 2374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			{
															#line 322 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				StrictFuture<bool> __when_expr_1 = self->runGet(data, 10, self);
															#line 322 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				if (static_cast<RunRandomTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2380 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<RunRandomTestActor*>(this)->actor_wait_state = 2;
															#line 322 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunRandomTestActor, 1, bool >*>(static_cast<RunRandomTestActor*>(this)));
															#line 2385 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 328 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				if (operation == GET_RANGE)
															#line 2392 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
				{
															#line 329 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					StrictFuture<bool> __when_expr_2 = self->runGetRange(data, self);
															#line 329 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					if (static_cast<RunRandomTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2398 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
					static_cast<RunRandomTestActor*>(this)->actor_wait_state = 3;
															#line 329 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunRandomTestActor, 2, bool >*>(static_cast<RunRandomTestActor*>(this)));
															#line 2403 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 335 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					if (operation == GET_RANGE_SELECTOR)
															#line 2410 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
					{
															#line 336 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
						StrictFuture<bool> __when_expr_3 = self->runGetRangeSelector(data, self);
															#line 336 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
						if (static_cast<RunRandomTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2416 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
						if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.get(), loopDepth); };
						static_cast<RunRandomTestActor*>(this)->actor_wait_state = 4;
															#line 336 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
						__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunRandomTestActor, 3, bool >*>(static_cast<RunRandomTestActor*>(this)));
															#line 2421 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 342 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
						if (operation == GET_KEY)
															#line 2428 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
						{
															#line 343 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
							StrictFuture<bool> __when_expr_4 = self->runGetKey(data, 10, self);
															#line 343 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
							if (static_cast<RunRandomTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2434 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
							if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5(__when_expr_4.get(), loopDepth); };
							static_cast<RunRandomTestActor*>(this)->actor_wait_state = 5;
															#line 343 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
							__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunRandomTestActor, 4, bool >*>(static_cast<RunRandomTestActor*>(this)));
															#line 2439 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
							loopDepth = 0;
						}
						else
						{
															#line 349 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
							if (operation == CLEAR)
															#line 2446 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
							{
															#line 350 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
								StrictFuture<bool> __when_expr_5 = self->runClear(data, 10, self);
															#line 350 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
								if (static_cast<RunRandomTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2452 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
								if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when6(__when_expr_5.get(), loopDepth); };
								static_cast<RunRandomTestActor*>(this)->actor_wait_state = 6;
															#line 350 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
								__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunRandomTestActor, 5, bool >*>(static_cast<RunRandomTestActor*>(this)));
															#line 2457 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
								loopDepth = 0;
							}
							else
							{
															#line 356 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
								if (operation == CLEAR_RANGE)
															#line 2464 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
								{
															#line 357 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
									StrictFuture<bool> __when_expr_6 = self->runClearRange(data, self);
															#line 357 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
									if (static_cast<RunRandomTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2470 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
									if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when7(__when_expr_6.get(), loopDepth); };
									static_cast<RunRandomTestActor*>(this)->actor_wait_state = 7;
															#line 357 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
									__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunRandomTestActor, 6, bool >*>(static_cast<RunRandomTestActor*>(this)));
															#line 2475 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
									loopDepth = 0;
								}
								else
								{
									loopDepth = a_body1loopBody1cont20(loopDepth);
								}
							}
						}
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5(bool const& result,int loopDepth) 
	{
															#line 316 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 317 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2505 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(bool && result,int loopDepth) 
	{
															#line 316 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2519 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 317 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2523 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunRandomTestActor*>(this)->actor_wait_state > 0) static_cast<RunRandomTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunRandomTestActor*>(this)->ActorCallback< RunRandomTestActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunRandomTestActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(bool const& result,int loopDepth) 
	{
															#line 323 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2618 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 324 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2622 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(bool && result,int loopDepth) 
	{
															#line 323 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2636 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 324 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2640 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(bool && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunRandomTestActor*>(this)->actor_wait_state > 0) static_cast<RunRandomTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunRandomTestActor*>(this)->ActorCallback< RunRandomTestActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunRandomTestActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont12(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13(bool const& result,int loopDepth) 
	{
															#line 330 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2735 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 331 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2739 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13(bool && result,int loopDepth) 
	{
															#line 330 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 331 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2757 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(bool && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunRandomTestActor*>(this)->actor_wait_state > 0) static_cast<RunRandomTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunRandomTestActor*>(this)->ActorCallback< RunRandomTestActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunRandomTestActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont14(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont15(bool const& result,int loopDepth) 
	{
															#line 337 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2852 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 338 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2856 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont15(bool && result,int loopDepth) 
	{
															#line 337 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2870 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 338 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2874 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont15(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(bool && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont15(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunRandomTestActor*>(this)->actor_wait_state > 0) static_cast<RunRandomTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunRandomTestActor*>(this)->ActorCallback< RunRandomTestActor, 3, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 3, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 3, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunRandomTestActor, 3, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont16(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont17(bool const& result,int loopDepth) 
	{
															#line 344 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2969 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 345 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2973 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont17(bool && result,int loopDepth) 
	{
															#line 344 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 2987 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 345 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 2991 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(bool && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunRandomTestActor*>(this)->actor_wait_state > 0) static_cast<RunRandomTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunRandomTestActor*>(this)->ActorCallback< RunRandomTestActor, 4, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 4, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 4, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunRandomTestActor, 4, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont18(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19(bool const& result,int loopDepth) 
	{
															#line 351 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 3086 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 352 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 3090 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19(bool && result,int loopDepth) 
	{
															#line 351 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 3104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 352 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 3108 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(bool && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RunRandomTestActor*>(this)->actor_wait_state > 0) static_cast<RunRandomTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunRandomTestActor*>(this)->ActorCallback< RunRandomTestActor, 5, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 5, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 5, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunRandomTestActor, 5, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont20(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont21(bool const& result,int loopDepth) 
	{
															#line 358 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 3203 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 359 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 3207 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont21(bool && result,int loopDepth) 
	{
															#line 358 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 3221 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 359 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (!static_cast<RunRandomTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRandomTestActorState(); static_cast<RunRandomTestActor*>(this)->destroy(); return 0; }
															#line 3225 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			new (&static_cast<RunRandomTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RunRandomTestActorState();
			static_cast<RunRandomTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when7(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont21(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when7(bool && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont21(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RunRandomTestActor*>(this)->actor_wait_state > 0) static_cast<RunRandomTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunRandomTestActor*>(this)->ActorCallback< RunRandomTestActor, 6, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 6, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RunRandomTestActor, 6, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RunRandomTestActor, 6, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 264 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 264 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> data;
															#line 304 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> newData;
															#line 3316 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
};
// This generated class is to be used only via runRandomTest()
															#line 264 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunRandomTestActor final : public Actor<Void>, public ActorCallback< RunRandomTestActor, 0, bool >, public ActorCallback< RunRandomTestActor, 1, bool >, public ActorCallback< RunRandomTestActor, 2, bool >, public ActorCallback< RunRandomTestActor, 3, bool >, public ActorCallback< RunRandomTestActor, 4, bool >, public ActorCallback< RunRandomTestActor, 5, bool >, public ActorCallback< RunRandomTestActor, 6, bool >, public FastAllocated<RunRandomTestActor>, public RunRandomTestActorState<RunRandomTestActor> {
															#line 3321 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
	using FastAllocated<RunRandomTestActor>::operator new;
	using FastAllocated<RunRandomTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12969889117533298688UL, 15514861242302828544UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunRandomTestActor, 0, bool >;
friend struct ActorCallback< RunRandomTestActor, 1, bool >;
friend struct ActorCallback< RunRandomTestActor, 2, bool >;
friend struct ActorCallback< RunRandomTestActor, 3, bool >;
friend struct ActorCallback< RunRandomTestActor, 4, bool >;
friend struct ActorCallback< RunRandomTestActor, 5, bool >;
friend struct ActorCallback< RunRandomTestActor, 6, bool >;
															#line 264 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunRandomTestActor(ApiCorrectnessWorkload* const& self,Standalone<VectorRef<KeyValueRef>> const& data) 
															#line 3344 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   RunRandomTestActorState<RunRandomTestActor>(self, data),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runRandomTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2252403300957825792UL, 17587082903059536384UL);
		ActorExecutionContextHelper __helper(static_cast<RunRandomTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runRandomTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runRandomTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunRandomTestActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunRandomTestActor, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunRandomTestActor, 2, bool >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunRandomTestActor, 3, bool >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunRandomTestActor, 4, bool >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RunRandomTestActor, 5, bool >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RunRandomTestActor, 6, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 264 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> runRandomTest( ApiCorrectnessWorkload* const& self, Standalone<VectorRef<KeyValueRef>> const& data ) {
															#line 264 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<Void>(new RunRandomTestActor(self, data));
															#line 3382 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
}

#line 363 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	// Adds the key-value pairs in data to the database and memory store
																#line 3388 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
// This generated class is to be used only via runSet()
															#line 365 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class RunSetActor>
															#line 365 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunSetActorState {
															#line 3394 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
															#line 365 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunSetActorState(VectorRef<KeyValueRef> const& data,ApiCorrectnessWorkload* const& self) 
															#line 365 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 365 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : data(data),
															#line 365 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   self(self),
															#line 366 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   currentIndex(0)
															#line 3405 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("runSet", reinterpret_cast<unsigned long>(this));

	}
	~RunSetActorState() 
	{
		fdb_probe_actor_destroy("runSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 367 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			;
															#line 3420 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunSetActorState();
		static_cast<RunSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 398 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = 0;i < data.size();i++) {
															#line 399 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->store.set(data[i].key, data[i].value);
															#line 400 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->debugKey(data[i].key, "Set");
															#line 3447 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 404 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<bool> __when_expr_3 = self->compareDatabaseToMemory();
															#line 404 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3453 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<RunSetActor*>(this)->actor_wait_state = 4;
															#line 404 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunSetActor, 3, bool >*>(static_cast<RunSetActor*>(this)));
															#line 3458 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 367 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(currentIndex < data.size()))
															#line 3474 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 368 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		transaction = self->createTransaction();
															#line 371 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		;
															#line 3482 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = transaction->get(data[currentIndex].key);
															#line 374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunSetActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3520 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunSetActor*>(this)->actor_wait_state = 1;
															#line 374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunSetActor, 0, Optional<Value> >*>(static_cast<RunSetActor*>(this)));
															#line 3525 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 392 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = transaction->onError(e);
															#line 392 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3562 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunSetActor*>(this)->actor_wait_state = 3;
															#line 392 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunSetActor, 2, Void >*>(static_cast<RunSetActor*>(this)));
															#line 3567 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> const& value,int loopDepth) 
	{
															#line 376 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, data.size());i++) {
															#line 378 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->addReadConflictRange(singleKeyRange(data[i].key));
															#line 379 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->set(data[i].key, data[i].value);
															#line 3586 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 382 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = transaction->commit();
															#line 382 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunSetActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3592 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunSetActor*>(this)->actor_wait_state = 2;
															#line 382 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunSetActor, 1, Void >*>(static_cast<RunSetActor*>(this)));
															#line 3597 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> && value,int loopDepth) 
	{
															#line 376 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, data.size());i++) {
															#line 378 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->addReadConflictRange(singleKeyRange(data[i].key));
															#line 379 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->set(data[i].key, data[i].value);
															#line 3610 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 382 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = transaction->commit();
															#line 382 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunSetActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3616 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunSetActor*>(this)->actor_wait_state = 2;
															#line 382 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunSetActor, 1, Void >*>(static_cast<RunSetActor*>(this)));
															#line 3621 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunSetActor*>(this)->actor_wait_state > 0) static_cast<RunSetActor*>(this)->actor_wait_state = 0;
		static_cast<RunSetActor*>(this)->ActorCallback< RunSetActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< RunSetActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunSetActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunSetActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 383 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, data.size());i++) {
															#line 385 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			DEBUG_MUTATION("ApiCorrectnessSet", transaction->getCommittedVersion(), MutationRef(MutationRef::DebugKey, data[i].key, data[i].value));
															#line 3707 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 389 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		currentIndex += self->maxKeysPerTransaction;
															#line 3711 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 383 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, data.size());i++) {
															#line 385 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			DEBUG_MUTATION("ApiCorrectnessSet", transaction->getCommittedVersion(), MutationRef(MutationRef::DebugKey, data[i].key, data[i].value));
															#line 3722 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 389 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		currentIndex += self->maxKeysPerTransaction;
															#line 3726 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunSetActor*>(this)->actor_wait_state > 0) static_cast<RunSetActor*>(this)->actor_wait_state = 0;
		static_cast<RunSetActor*>(this)->ActorCallback< RunSetActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunSetActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunSetActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunSetActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunSetActor*>(this)->actor_wait_state > 0) static_cast<RunSetActor*>(this)->actor_wait_state = 0;
		static_cast<RunSetActor*>(this)->ActorCallback< RunSetActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunSetActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunSetActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunSetActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2(bool const& result,int loopDepth) 
	{
															#line 405 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 3897 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 406 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("Set resulted in incorrect database");
															#line 3901 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 408 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunSetActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunSetActorState(); static_cast<RunSetActor*>(this)->destroy(); return 0; }
															#line 3905 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		new (&static_cast<RunSetActor*>(this)->SAV< bool >::value()) bool(result);
		this->~RunSetActorState();
		static_cast<RunSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(bool && result,int loopDepth) 
	{
															#line 405 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 3917 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 406 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("Set resulted in incorrect database");
															#line 3921 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 408 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunSetActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunSetActorState(); static_cast<RunSetActor*>(this)->destroy(); return 0; }
															#line 3925 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		new (&static_cast<RunSetActor*>(this)->SAV< bool >::value()) bool(result);
		this->~RunSetActorState();
		static_cast<RunSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && result,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunSetActor*>(this)->actor_wait_state > 0) static_cast<RunSetActor*>(this)->actor_wait_state = 0;
		static_cast<RunSetActor*>(this)->ActorCallback< RunSetActor, 3, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunSetActor, 3, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunSetActor, 3, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunSetActor, 3, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 365 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	VectorRef<KeyValueRef> data;
															#line 365 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 366 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int currentIndex;
															#line 368 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reference<TransactionWrapper> transaction;
															#line 4016 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
};
// This generated class is to be used only via runSet()
															#line 365 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunSetActor final : public Actor<bool>, public ActorCallback< RunSetActor, 0, Optional<Value> >, public ActorCallback< RunSetActor, 1, Void >, public ActorCallback< RunSetActor, 2, Void >, public ActorCallback< RunSetActor, 3, bool >, public FastAllocated<RunSetActor>, public RunSetActorState<RunSetActor> {
															#line 4021 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
	using FastAllocated<RunSetActor>::operator new;
	using FastAllocated<RunSetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12242186500779094784UL, 9836177484924027648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunSetActor, 0, Optional<Value> >;
friend struct ActorCallback< RunSetActor, 1, Void >;
friend struct ActorCallback< RunSetActor, 2, Void >;
friend struct ActorCallback< RunSetActor, 3, bool >;
															#line 365 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunSetActor(VectorRef<KeyValueRef> const& data,ApiCorrectnessWorkload* const& self) 
															#line 4041 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		 : Actor<bool>(),
		   RunSetActorState<RunSetActor>(data, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10214455328005274624UL, 6148218280688426752UL);
		ActorExecutionContextHelper __helper(static_cast<RunSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunSetActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunSetActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunSetActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunSetActor, 3, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 365 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<bool> runSet( VectorRef<KeyValueRef> const& data, ApiCorrectnessWorkload* const& self ) {
															#line 365 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<bool>(new RunSetActor(data, self));
															#line 4076 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
}

#line 410 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	// Gets a specified number of values from the database and memory store and compares them, returning true if all
	// results were the same
																#line 4083 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
// This generated class is to be used only via runGet()
															#line 413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class RunGetActor>
															#line 413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunGetActorState {
															#line 4089 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
															#line 413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunGetActorState(VectorRef<KeyValueRef> const& data,int const& numReads,ApiCorrectnessWorkload* const& self) 
															#line 413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : data(data),
															#line 413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   numReads(numReads),
															#line 413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   self(self),
															#line 415 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   keys()
															#line 4102 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("runGet", reinterpret_cast<unsigned long>(this));

	}
	~RunGetActorState() 
	{
		fdb_probe_actor_destroy("runGet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 416 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			for(int i = 0;i < numReads;i++) {
															#line 417 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				keys.push_back_deep(keys.arena(), self->selectRandomKey(data, 0.9));
															#line 4119 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			}
															#line 419 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			values = std::vector<Optional<Value>>();
															#line 421 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			currentIndex = 0;
															#line 422 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			;
															#line 4127 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunGetActorState();
		static_cast<RunGetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 447 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		bool result = true;
															#line 450 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = 0;i < keys.size();i++) {
															#line 451 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (values[i] != self->store.get(keys[i]))
															#line 4154 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			{
															#line 452 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				result = false;
															#line 4158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
				break;
			}
		}
															#line 457 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 4164 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 458 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("Get returned incorrect results");
															#line 4168 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 460 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunGetActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunGetActorState(); static_cast<RunGetActor*>(this)->destroy(); return 0; }
															#line 4172 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		new (&static_cast<RunGetActor*>(this)->SAV< bool >::value()) bool(result);
		this->~RunGetActorState();
		static_cast<RunGetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 422 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(currentIndex < keys.size()))
															#line 4191 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 423 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		transaction = self->createTransaction();
															#line 426 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		;
															#line 4199 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 428 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			dbValueFutures = std::vector<Future<Optional<Value>>>();
															#line 429 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, keys.size());i++) {
															#line 431 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				dbValueFutures.push_back(transaction->get(keys[i]));
															#line 4239 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			}
															#line 433 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(dbValueFutures);
															#line 433 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4245 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunGetActor*>(this)->actor_wait_state = 1;
															#line 433 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunGetActor, 0, Void >*>(static_cast<RunGetActor*>(this)));
															#line 4250 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 442 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = transaction->onError(e);
															#line 442 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4287 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunGetActor*>(this)->actor_wait_state = 2;
															#line 442 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunGetActor, 1, Void >*>(static_cast<RunGetActor*>(this)));
															#line 4292 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 435 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = 0;i < dbValueFutures.size();i++) {
															#line 436 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			values.push_back(dbValueFutures[i].get());
															#line 4309 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 438 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		currentIndex += self->maxKeysPerTransaction;
															#line 4313 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 435 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = 0;i < dbValueFutures.size();i++) {
															#line 436 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			values.push_back(dbValueFutures[i].get());
															#line 4324 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 438 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		currentIndex += self->maxKeysPerTransaction;
															#line 4328 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunGetActor*>(this)->actor_wait_state > 0) static_cast<RunGetActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetActor*>(this)->ActorCallback< RunGetActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runGet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunGetActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runGet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunGetActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runGet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunGetActor*>(this)->actor_wait_state > 0) static_cast<RunGetActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetActor*>(this)->ActorCallback< RunGetActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runGet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunGetActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runGet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunGetActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runGet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGet", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	VectorRef<KeyValueRef> data;
															#line 413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int numReads;
															#line 413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 415 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Standalone<VectorRef<KeyRef>> keys;
															#line 419 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	std::vector<Optional<Value>> values;
															#line 421 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int currentIndex;
															#line 423 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reference<TransactionWrapper> transaction;
															#line 428 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	std::vector<Future<Optional<Value>>> dbValueFutures;
															#line 4511 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
};
// This generated class is to be used only via runGet()
															#line 413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunGetActor final : public Actor<bool>, public ActorCallback< RunGetActor, 0, Void >, public ActorCallback< RunGetActor, 1, Void >, public FastAllocated<RunGetActor>, public RunGetActorState<RunGetActor> {
															#line 4516 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
	using FastAllocated<RunGetActor>::operator new;
	using FastAllocated<RunGetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11302083047247675136UL, 10792661512497368576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunGetActor, 0, Void >;
friend struct ActorCallback< RunGetActor, 1, Void >;
															#line 413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunGetActor(VectorRef<KeyValueRef> const& data,int const& numReads,ApiCorrectnessWorkload* const& self) 
															#line 4534 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		 : Actor<bool>(),
		   RunGetActorState<RunGetActor>(data, numReads, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runGet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9817262855810077184UL, 4230406122534541568UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runGet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runGet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunGetActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunGetActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<bool> runGet( VectorRef<KeyValueRef> const& data, int const& numReads, ApiCorrectnessWorkload* const& self ) {
															#line 413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<bool>(new RunGetActor(data, numReads, self));
															#line 4567 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
}

#line 462 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	// Gets a single range of values from the database and memory stores and compares them, returning true if the
	// results were the same
																#line 4574 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
// This generated class is to be used only via runGetRange()
															#line 465 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class RunGetRangeActor>
															#line 465 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunGetRangeActorState {
															#line 4580 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
															#line 465 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunGetRangeActorState(VectorRef<KeyValueRef> const& data,ApiCorrectnessWorkload* const& self) 
															#line 465 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 465 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : data(data),
															#line 465 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   self(self),
															#line 466 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   reverse(deterministicRandom()->coinflip())
															#line 4591 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("runGetRange", reinterpret_cast<unsigned long>(this));

	}
	~RunGetRangeActorState() 
	{
		fdb_probe_actor_destroy("runGetRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 469 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			Key key = self->selectRandomKey(data, 0.5);
															#line 470 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			Key key2 = self->selectRandomKey(data, 0.5);
															#line 472 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			start = std::min(key, key2);
															#line 473 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			end = std::max(key, key2);
															#line 476 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			limit = deterministicRandom()->randomInt(0, 101);
															#line 479 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			storeResults = self->store.getRange(KeyRangeRef(start, end), limit, reverse);
															#line 482 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			dbResults = RangeResult();
															#line 483 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			readVersion = Version();
															#line 485 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction = self->createTransaction();
															#line 487 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			;
															#line 4624 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunGetRangeActorState();
		static_cast<RunGetRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 502 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		bool result = self->compareResults(dbResults, storeResults, readVersion);
															#line 503 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 4649 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 504 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("GetRange returned incorrect results");
															#line 4653 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 506 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunGetRangeActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunGetRangeActorState(); static_cast<RunGetRangeActor*>(this)->destroy(); return 0; }
															#line 4657 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		new (&static_cast<RunGetRangeActor*>(this)->SAV< bool >::value()) bool(result);
		this->~RunGetRangeActorState();
		static_cast<RunGetRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 489 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Version> __when_expr_0 = transaction->getReadVersion();
															#line 489 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4679 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunGetRangeActor*>(this)->actor_wait_state = 1;
															#line 489 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunGetRangeActor, 0, Version >*>(static_cast<RunGetRangeActor*>(this)));
															#line 4684 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 497 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = transaction->onError(e);
															#line 497 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4721 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunGetRangeActor*>(this)->actor_wait_state = 3;
															#line 497 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunGetRangeActor, 2, Void >*>(static_cast<RunGetRangeActor*>(this)));
															#line 4726 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& version,int loopDepth) 
	{
															#line 490 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		readVersion = version;
															#line 492 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		KeyRangeRef range(start, end);
															#line 493 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = transaction->getRange(range, limit, reverse);
															#line 493 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunGetRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4747 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunGetRangeActor*>(this)->actor_wait_state = 2;
															#line 493 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunGetRangeActor, 1, RangeResult >*>(static_cast<RunGetRangeActor*>(this)));
															#line 4752 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && version,int loopDepth) 
	{
															#line 490 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		readVersion = version;
															#line 492 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		KeyRangeRef range(start, end);
															#line 493 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = transaction->getRange(range, limit, reverse);
															#line 493 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunGetRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4767 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunGetRangeActor*>(this)->actor_wait_state = 2;
															#line 493 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunGetRangeActor, 1, RangeResult >*>(static_cast<RunGetRangeActor*>(this)));
															#line 4772 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(version, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunGetRangeActor*>(this)->actor_wait_state > 0) static_cast<RunGetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetRangeActor*>(this)->ActorCallback< RunGetRangeActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetRangeActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunGetRangeActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunGetRangeActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& rangeResults,int loopDepth) 
	{
															#line 494 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		dbResults = rangeResults;
															#line 4856 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && rangeResults,int loopDepth) 
	{
															#line 494 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		dbResults = rangeResults;
															#line 4865 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& rangeResults,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(rangeResults, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && rangeResults,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(rangeResults), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunGetRangeActor*>(this)->actor_wait_state > 0) static_cast<RunGetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetRangeActor*>(this)->ActorCallback< RunGetRangeActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetRangeActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunGetRangeActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunGetRangeActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunGetRangeActor*>(this)->actor_wait_state > 0) static_cast<RunGetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetRangeActor*>(this)->ActorCallback< RunGetRangeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetRangeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunGetRangeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunGetRangeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 465 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	VectorRef<KeyValueRef> data;
															#line 465 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 466 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reverse reverse;
															#line 472 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Key start;
															#line 473 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Key end;
															#line 476 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int limit;
															#line 479 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RangeResult storeResults;
															#line 482 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RangeResult dbResults;
															#line 483 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Version readVersion;
															#line 485 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reference<TransactionWrapper> transaction;
															#line 5052 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
};
// This generated class is to be used only via runGetRange()
															#line 465 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunGetRangeActor final : public Actor<bool>, public ActorCallback< RunGetRangeActor, 0, Version >, public ActorCallback< RunGetRangeActor, 1, RangeResult >, public ActorCallback< RunGetRangeActor, 2, Void >, public FastAllocated<RunGetRangeActor>, public RunGetRangeActorState<RunGetRangeActor> {
															#line 5057 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
	using FastAllocated<RunGetRangeActor>::operator new;
	using FastAllocated<RunGetRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16861114022304843264UL, 4449244893148053248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunGetRangeActor, 0, Version >;
friend struct ActorCallback< RunGetRangeActor, 1, RangeResult >;
friend struct ActorCallback< RunGetRangeActor, 2, Void >;
															#line 465 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunGetRangeActor(VectorRef<KeyValueRef> const& data,ApiCorrectnessWorkload* const& self) 
															#line 5076 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		 : Actor<bool>(),
		   RunGetRangeActorState<RunGetRangeActor>(data, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runGetRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14940957793025822720UL, 4248663186857621248UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runGetRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runGetRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunGetRangeActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunGetRangeActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunGetRangeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 465 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<bool> runGetRange( VectorRef<KeyValueRef> const& data, ApiCorrectnessWorkload* const& self ) {
															#line 465 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<bool>(new RunGetRangeActor(data, self));
															#line 5110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
}

#line 508 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	// Gets a single range of values using key selectors from the database and memory store and compares them, returning
	// true if the results were the same
																#line 5117 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
// This generated class is to be used only via runGetRangeSelector()
															#line 511 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class RunGetRangeSelectorActor>
															#line 511 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunGetRangeSelectorActorState {
															#line 5123 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
															#line 511 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunGetRangeSelectorActorState(VectorRef<KeyValueRef> const& data,ApiCorrectnessWorkload* const& self) 
															#line 511 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 511 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : data(data),
															#line 511 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   self(self),
															#line 512 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   reverse(deterministicRandom()->coinflip())
															#line 5134 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("runGetRangeSelector", reinterpret_cast<unsigned long>(this));

	}
	~RunGetRangeSelectorActorState() 
	{
		fdb_probe_actor_destroy("runGetRangeSelector", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 514 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			KeySelector selectors[2];
															#line 515 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			Key keys[2];
															#line 517 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			int maxSelectorAttempts = 100;
															#line 518 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			int currentSelectorAttempts = 0;
															#line 523 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			for(int i = 0;i < 2;i++) {
															#line 524 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				for(;;) {
															#line 527 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					selectors[i] = self->generateKeySelector(data, std::min(100, maxSelectorAttempts - currentSelectorAttempts));
															#line 529 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					keys[i] = self->store.getKey(selectors[i]);
															#line 531 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					if (keys[i].startsWith(StringRef(self->clientPrefix)) || (keys[i].size() == 0 && self->clientPrefixInt == 0) || (keys[i].startsWith("\xff"_sr) && self->clientPrefixInt == self->clientCount - 1))
															#line 5165 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
					{
						break;
					}
															#line 538 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					if (++currentSelectorAttempts == maxSelectorAttempts)
															#line 5171 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
					{
															#line 539 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
						if (!static_cast<RunGetRangeSelectorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~RunGetRangeSelectorActorState(); static_cast<RunGetRangeSelectorActor*>(this)->destroy(); return 0; }
															#line 5175 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
						new (&static_cast<RunGetRangeSelectorActor*>(this)->SAV< bool >::value()) bool(true);
						this->~RunGetRangeSelectorActorState();
						static_cast<RunGetRangeSelectorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
															#line 543 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			startSelector = KeySelector();
															#line 544 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			endSelector = KeySelector();
															#line 546 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			startKey = Key();
															#line 547 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			endKey = Key();
															#line 550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (keys[0] < keys[1])
															#line 5193 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			{
															#line 551 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				startSelector = selectors[0];
															#line 552 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				startKey = keys[0];
															#line 553 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				endSelector = selectors[1];
															#line 554 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				endKey = keys[1];
															#line 5203 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			}
			else
			{
															#line 556 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				startSelector = selectors[1];
															#line 557 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				startKey = keys[1];
															#line 558 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				endSelector = selectors[0];
															#line 559 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				endKey = keys[0];
															#line 5215 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			}
															#line 563 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			limit = deterministicRandom()->randomInt(0, 101);
															#line 566 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			storeResults = self->store.getRange(KeyRangeRef(startKey, endKey), limit, reverse);
															#line 569 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			dbResults = RangeResult();
															#line 571 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction = self->createTransaction();
															#line 572 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			readVersion = Version();
															#line 574 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			;
															#line 5229 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunGetRangeSelectorActorState();
		static_cast<RunGetRangeSelectorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 600 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		bool result = self->compareResults(dbResults, storeResults, readVersion);
															#line 602 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 5254 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 603 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("GetRange (KeySelector) returned incorrect results");
															#line 5258 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 605 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunGetRangeSelectorActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunGetRangeSelectorActorState(); static_cast<RunGetRangeSelectorActor*>(this)->destroy(); return 0; }
															#line 5262 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		new (&static_cast<RunGetRangeSelectorActor*>(this)->SAV< bool >::value()) bool(result);
		this->~RunGetRangeSelectorActorState();
		static_cast<RunGetRangeSelectorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 576 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Version> __when_expr_0 = transaction->getReadVersion();
															#line 576 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5284 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state = 1;
															#line 576 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunGetRangeSelectorActor, 0, Version >*>(static_cast<RunGetRangeSelectorActor*>(this)));
															#line 5289 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 595 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = transaction->onError(e);
															#line 595 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5326 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state = 3;
															#line 595 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunGetRangeSelectorActor, 2, Void >*>(static_cast<RunGetRangeSelectorActor*>(this)));
															#line 5331 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& version,int loopDepth) 
	{
															#line 577 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		readVersion = version;
															#line 579 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = transaction->getRange(startSelector, endSelector, limit, reverse);
															#line 579 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5350 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state = 2;
															#line 579 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunGetRangeSelectorActor, 1, RangeResult >*>(static_cast<RunGetRangeSelectorActor*>(this)));
															#line 5355 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && version,int loopDepth) 
	{
															#line 577 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		readVersion = version;
															#line 579 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = transaction->getRange(startSelector, endSelector, limit, reverse);
															#line 579 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5368 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state = 2;
															#line 579 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunGetRangeSelectorActor, 1, RangeResult >*>(static_cast<RunGetRangeSelectorActor*>(this)));
															#line 5373 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(version, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state > 0) static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetRangeSelectorActor*>(this)->ActorCallback< RunGetRangeSelectorActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetRangeSelectorActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunGetRangeSelectorActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunGetRangeSelectorActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& range,int loopDepth) 
	{
															#line 581 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (endKey == self->store.endKey())
															#line 5457 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 582 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			for(int i = 0;i < range.size();i++) {
															#line 584 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				if (!range[i].key.startsWith("\xff"_sr))
															#line 5463 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
				{
															#line 585 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					dbResults.push_back_deep(dbResults.arena(), range[i]);
															#line 5467 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
				}
			}
															#line 587 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (reverse && dbResults.size() < storeResults.size())
															#line 5472 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			{
															#line 588 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				storeResults.resize(storeResults.arena(), dbResults.size());
															#line 5476 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			}
		}
		else
		{
															#line 591 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			dbResults = range;
															#line 5483 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && range,int loopDepth) 
	{
															#line 581 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (endKey == self->store.endKey())
															#line 5493 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 582 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			for(int i = 0;i < range.size();i++) {
															#line 584 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				if (!range[i].key.startsWith("\xff"_sr))
															#line 5499 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
				{
															#line 585 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					dbResults.push_back_deep(dbResults.arena(), range[i]);
															#line 5503 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
				}
			}
															#line 587 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (reverse && dbResults.size() < storeResults.size())
															#line 5508 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			{
															#line 588 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				storeResults.resize(storeResults.arena(), dbResults.size());
															#line 5512 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			}
		}
		else
		{
															#line 591 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			dbResults = range;
															#line 5519 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(range, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state > 0) static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetRangeSelectorActor*>(this)->ActorCallback< RunGetRangeSelectorActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetRangeSelectorActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunGetRangeSelectorActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunGetRangeSelectorActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state > 0) static_cast<RunGetRangeSelectorActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetRangeSelectorActor*>(this)->ActorCallback< RunGetRangeSelectorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetRangeSelectorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunGetRangeSelectorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunGetRangeSelectorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 511 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	VectorRef<KeyValueRef> data;
															#line 511 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 512 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reverse reverse;
															#line 543 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	KeySelector startSelector;
															#line 544 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	KeySelector endSelector;
															#line 546 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Key startKey;
															#line 547 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Key endKey;
															#line 563 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int limit;
															#line 566 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RangeResult storeResults;
															#line 569 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RangeResult dbResults;
															#line 571 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reference<TransactionWrapper> transaction;
															#line 572 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Version readVersion;
															#line 5711 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
};
// This generated class is to be used only via runGetRangeSelector()
															#line 511 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunGetRangeSelectorActor final : public Actor<bool>, public ActorCallback< RunGetRangeSelectorActor, 0, Version >, public ActorCallback< RunGetRangeSelectorActor, 1, RangeResult >, public ActorCallback< RunGetRangeSelectorActor, 2, Void >, public FastAllocated<RunGetRangeSelectorActor>, public RunGetRangeSelectorActorState<RunGetRangeSelectorActor> {
															#line 5716 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
	using FastAllocated<RunGetRangeSelectorActor>::operator new;
	using FastAllocated<RunGetRangeSelectorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2689850046654821376UL, 6184424098379799296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunGetRangeSelectorActor, 0, Version >;
friend struct ActorCallback< RunGetRangeSelectorActor, 1, RangeResult >;
friend struct ActorCallback< RunGetRangeSelectorActor, 2, Void >;
															#line 511 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunGetRangeSelectorActor(VectorRef<KeyValueRef> const& data,ApiCorrectnessWorkload* const& self) 
															#line 5735 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		 : Actor<bool>(),
		   RunGetRangeSelectorActorState<RunGetRangeSelectorActor>(data, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runGetRangeSelector", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7526144586924790272UL, 15002562274698689792UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetRangeSelectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runGetRangeSelector");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runGetRangeSelector", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunGetRangeSelectorActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunGetRangeSelectorActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunGetRangeSelectorActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 511 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<bool> runGetRangeSelector( VectorRef<KeyValueRef> const& data, ApiCorrectnessWorkload* const& self ) {
															#line 511 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<bool>(new RunGetRangeSelectorActor(data, self));
															#line 5769 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
}

#line 607 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	// Gets a specified number of keys from the database and memory store and compares them, returning true if all
	// results were the same
																#line 5776 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
// This generated class is to be used only via runGetKey()
															#line 610 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class RunGetKeyActor>
															#line 610 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunGetKeyActorState {
															#line 5782 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
															#line 610 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunGetKeyActorState(VectorRef<KeyValueRef> const& data,int const& numGetKeys,ApiCorrectnessWorkload* const& self) 
															#line 610 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 610 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : data(data),
															#line 610 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   numGetKeys(numGetKeys),
															#line 610 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   self(self),
															#line 612 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   selectors()
															#line 5795 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("runGetKey", reinterpret_cast<unsigned long>(this));

	}
	~RunGetKeyActorState() 
	{
		fdb_probe_actor_destroy("runGetKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 613 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			for(int i = 0;i < numGetKeys;i++) {
															#line 614 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				selectors.push_back_deep(selectors.arena(), self->generateKeySelector(data, 100));
															#line 5812 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			}
															#line 616 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			keys = Standalone<VectorRef<KeyRef>>();
															#line 618 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			currentIndex = 0;
															#line 619 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			;
															#line 5820 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunGetKeyActorState();
		static_cast<RunGetKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 645 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		result = true;
															#line 648 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i = int();
															#line 649 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i = 0;
															#line 5847 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 619 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(currentIndex < selectors.size()))
															#line 5863 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 621 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		transaction = self->createTransaction();
															#line 623 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		;
															#line 5871 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 625 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			dbKeyFutures = std::vector<Future<Standalone<KeyRef>>>();
															#line 626 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, selectors.size());i++) {
															#line 629 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				dbKeyFutures.push_back(transaction->getKey(selectors[i]));
															#line 5911 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			}
															#line 631 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(dbKeyFutures);
															#line 631 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetKeyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5917 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunGetKeyActor*>(this)->actor_wait_state = 1;
															#line 631 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunGetKeyActor, 0, Void >*>(static_cast<RunGetKeyActor*>(this)));
															#line 5922 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 640 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = transaction->onError(e);
															#line 640 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5959 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunGetKeyActor*>(this)->actor_wait_state = 2;
															#line 640 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunGetKeyActor, 1, Void >*>(static_cast<RunGetKeyActor*>(this)));
															#line 5964 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = 0;i < dbKeyFutures.size();i++) {
															#line 634 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			keys.push_back_deep(keys.arena(), dbKeyFutures[i].get());
															#line 5981 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 636 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		currentIndex += self->maxKeysPerTransaction;
															#line 5985 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = 0;i < dbKeyFutures.size();i++) {
															#line 634 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			keys.push_back_deep(keys.arena(), dbKeyFutures[i].get());
															#line 5996 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 636 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		currentIndex += self->maxKeysPerTransaction;
															#line 6000 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunGetKeyActor*>(this)->actor_wait_state > 0) static_cast<RunGetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetKeyActor*>(this)->ActorCallback< RunGetKeyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetKeyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunGetKeyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunGetKeyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunGetKeyActor*>(this)->actor_wait_state > 0) static_cast<RunGetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetKeyActor*>(this)->ActorCallback< RunGetKeyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetKeyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunGetKeyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunGetKeyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 695 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 6171 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("GetKey returned incorrect results");
															#line 6175 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 698 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunGetKeyActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunGetKeyActorState(); static_cast<RunGetKeyActor*>(this)->destroy(); return 0; }
															#line 6179 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		new (&static_cast<RunGetKeyActor*>(this)->SAV< bool >::value()) bool(std::move(result)); // state_var_RVO
		this->~RunGetKeyActorState();
		static_cast<RunGetKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 649 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(i < selectors.size()))
															#line 6198 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 650 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		Key key = self->store.getKey(selectors[i]);
															#line 651 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (keys[i].startsWith(StringRef(self->clientPrefix)) && keys[i] != key)
															#line 6206 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 652 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			result = false;
															#line 6210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
		else
		{
															#line 653 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (keys[i] < StringRef(self->clientPrefix) && key != self->store.startKey())
															#line 6216 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			{
															#line 654 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				result = false;
															#line 6220 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			}
			else
			{
															#line 655 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				if (keys[i] > StringRef(self->clientPrefix + "\xff") && key != self->store.endKey())
															#line 6226 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
				{
															#line 656 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
					result = false;
															#line 6230 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
				}
			}
		}
															#line 659 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 6236 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 660 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			printf("Bad result for key selector %s: db=%s, mem=%s\n", selectors[i].toString().c_str(), printable(keys[i]).c_str(), printable(key).c_str());
															#line 664 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			dir = selectors[i].offset > 0 ? 1 : -1;
															#line 665 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			j = int();
															#line 666 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			j = 0;
															#line 6246 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 649 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		i++;
															#line 6273 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8(int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 666 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(j <= abs(selectors[i].offset)))
															#line 6295 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 667 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		sel = KeySelectorRef(selectors[i].getKey(), selectors[i].orEqual, j * dir);
															#line 668 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		storeKey = self->store.getKey(sel);
															#line 670 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		tr = self->createTransaction();
															#line 672 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		dbKey = Key();
															#line 673 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		;
															#line 6309 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 683 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(storeKey == self->store.startKey() && dbKey < StringRef(self->clientPrefix)) && !(storeKey == self->store.endKey() && dbKey > StringRef(self->clientPrefix + "\xff")))
															#line 6331 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 685 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			printf("Offset %d: db=%s, mem=%s\n", j * dir, printable(dbKey).c_str(), printable(storeKey).c_str());
															#line 6335 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 666 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		j++;
															#line 6339 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 675 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Key> __when_expr_2 = tr->getKey(sel);
															#line 675 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetKeyActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6358 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunGetKeyActor*>(this)->actor_wait_state = 3;
															#line 675 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunGetKeyActor, 2, Key >*>(static_cast<RunGetKeyActor*>(this)));
															#line 6363 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 679 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 679 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunGetKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 3));
															#line 6400 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 3)); else return a_body1cont1loopBody1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<RunGetKeyActor*>(this)->actor_wait_state = 4;
															#line 679 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunGetKeyActor, 3, Void >*>(static_cast<RunGetKeyActor*>(this)));
															#line 6405 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1cont2(Key const& key,int loopDepth) 
	{
															#line 676 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		dbKey = key;
															#line 6420 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		return a_body1cont1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1cont2(Key && key,int loopDepth) 
	{
															#line 676 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		dbKey = key;
															#line 6429 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		return a_body1cont1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1when1(Key const& key,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1loopBody1cont2(key, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1when1(Key && key,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1loopBody1cont2(std::move(key), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunGetKeyActor*>(this)->actor_wait_state > 0) static_cast<RunGetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetKeyActor*>(this)->ActorCallback< RunGetKeyActor, 2, Key >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetKeyActor, 2, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunGetKeyActor, 2, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunGetKeyActor, 2, Key >*,Error err) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunGetKeyActor*>(this)->actor_wait_state > 0) static_cast<RunGetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<RunGetKeyActor*>(this)->ActorCallback< RunGetKeyActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunGetKeyActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunGetKeyActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunGetKeyActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 610 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	VectorRef<KeyValueRef> data;
															#line 610 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int numGetKeys;
															#line 610 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 612 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Standalone<VectorRef<KeySelectorRef>> selectors;
															#line 616 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Standalone<VectorRef<KeyRef>> keys;
															#line 618 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int currentIndex;
															#line 621 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reference<TransactionWrapper> transaction;
															#line 625 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	std::vector<Future<Standalone<KeyRef>>> dbKeyFutures;
															#line 645 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	bool result;
															#line 648 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int i;
															#line 664 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int dir;
															#line 665 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int j;
															#line 667 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	KeySelector sel;
															#line 668 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Key storeKey;
															#line 670 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reference<TransactionWrapper> tr;
															#line 672 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Key dbKey;
															#line 6628 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
};
// This generated class is to be used only via runGetKey()
															#line 610 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunGetKeyActor final : public Actor<bool>, public ActorCallback< RunGetKeyActor, 0, Void >, public ActorCallback< RunGetKeyActor, 1, Void >, public ActorCallback< RunGetKeyActor, 2, Key >, public ActorCallback< RunGetKeyActor, 3, Void >, public FastAllocated<RunGetKeyActor>, public RunGetKeyActorState<RunGetKeyActor> {
															#line 6633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
	using FastAllocated<RunGetKeyActor>::operator new;
	using FastAllocated<RunGetKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1774691346610744320UL, 4842946156616207360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunGetKeyActor, 0, Void >;
friend struct ActorCallback< RunGetKeyActor, 1, Void >;
friend struct ActorCallback< RunGetKeyActor, 2, Key >;
friend struct ActorCallback< RunGetKeyActor, 3, Void >;
															#line 610 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunGetKeyActor(VectorRef<KeyValueRef> const& data,int const& numGetKeys,ApiCorrectnessWorkload* const& self) 
															#line 6653 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		 : Actor<bool>(),
		   RunGetKeyActorState<RunGetKeyActor>(data, numGetKeys, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runGetKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17881606683242620416UL, 12084576079300629504UL);
		ActorExecutionContextHelper __helper(static_cast<RunGetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runGetKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runGetKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunGetKeyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunGetKeyActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunGetKeyActor, 2, Key >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunGetKeyActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 610 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<bool> runGetKey( VectorRef<KeyValueRef> const& data, int const& numGetKeys, ApiCorrectnessWorkload* const& self ) {
															#line 610 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<bool>(new RunGetKeyActor(data, numGetKeys, self));
															#line 6688 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
}

#line 700 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	// Clears a specified number of keys from the database and memory store
																#line 6694 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
// This generated class is to be used only via runClear()
															#line 702 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class RunClearActor>
															#line 702 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunClearActorState {
															#line 6700 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
															#line 702 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunClearActorState(VectorRef<KeyValueRef> const& data,int const& numClears,ApiCorrectnessWorkload* const& self) 
															#line 702 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 702 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : data(data),
															#line 702 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   numClears(numClears),
															#line 702 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   self(self),
															#line 704 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   keys()
															#line 6713 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("runClear", reinterpret_cast<unsigned long>(this));

	}
	~RunClearActorState() 
	{
		fdb_probe_actor_destroy("runClear", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 705 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			for(int i = 0;i < numClears;i++) {
															#line 706 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
				keys.push_back_deep(keys.arena(), self->selectRandomKey(data, 0.9));
															#line 6730 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			}
															#line 708 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			currentIndex = 0;
															#line 709 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			;
															#line 6736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunClearActorState();
		static_cast<RunClearActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 739 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = 0;i < keys.size();i++) {
															#line 740 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->store.clear(keys[i]);
															#line 741 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->debugKey(keys[i], "Clear");
															#line 6763 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 745 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<bool> __when_expr_3 = self->compareDatabaseToMemory();
															#line 745 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6769 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<RunClearActor*>(this)->actor_wait_state = 4;
															#line 745 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunClearActor, 3, bool >*>(static_cast<RunClearActor*>(this)));
															#line 6774 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 709 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!(currentIndex < keys.size()))
															#line 6790 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 711 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		transaction = self->createTransaction();
															#line 712 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		;
															#line 6798 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 715 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = transaction->get(keys[0]);
															#line 715 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunClearActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6836 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunClearActor*>(this)->actor_wait_state = 1;
															#line 715 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunClearActor, 0, Optional<Value> >*>(static_cast<RunClearActor*>(this)));
															#line 6841 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 733 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = transaction->onError(e);
															#line 733 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6878 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunClearActor*>(this)->actor_wait_state = 3;
															#line 733 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunClearActor, 2, Void >*>(static_cast<RunClearActor*>(this)));
															#line 6883 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> const& value,int loopDepth) 
	{
															#line 717 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, keys.size());i++) {
															#line 719 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->addReadConflictRange(singleKeyRange(keys[i]));
															#line 720 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->clear(keys[i]);
															#line 6902 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 723 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = transaction->commit();
															#line 723 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunClearActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6908 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunClearActor*>(this)->actor_wait_state = 2;
															#line 723 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunClearActor, 1, Void >*>(static_cast<RunClearActor*>(this)));
															#line 6913 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> && value,int loopDepth) 
	{
															#line 717 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, keys.size());i++) {
															#line 719 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->addReadConflictRange(singleKeyRange(keys[i]));
															#line 720 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->clear(keys[i]);
															#line 6926 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 723 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = transaction->commit();
															#line 723 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunClearActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6932 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunClearActor*>(this)->actor_wait_state = 2;
															#line 723 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunClearActor, 1, Void >*>(static_cast<RunClearActor*>(this)));
															#line 6937 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunClearActor*>(this)->actor_wait_state > 0) static_cast<RunClearActor*>(this)->actor_wait_state = 0;
		static_cast<RunClearActor*>(this)->ActorCallback< RunClearActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< RunClearActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunClearActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunClearActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 724 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, keys.size());i++) {
															#line 726 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			DEBUG_MUTATION("ApiCorrectnessClear", transaction->getCommittedVersion(), MutationRef(MutationRef::DebugKey, keys[i], StringRef()));
															#line 7023 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 730 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		currentIndex += self->maxKeysPerTransaction;
															#line 7027 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 724 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		for(int i = currentIndex;i < std::min(currentIndex + self->maxKeysPerTransaction, keys.size());i++) {
															#line 726 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			DEBUG_MUTATION("ApiCorrectnessClear", transaction->getCommittedVersion(), MutationRef(MutationRef::DebugKey, keys[i], StringRef()));
															#line 7038 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 730 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		currentIndex += self->maxKeysPerTransaction;
															#line 7042 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunClearActor*>(this)->actor_wait_state > 0) static_cast<RunClearActor*>(this)->actor_wait_state = 0;
		static_cast<RunClearActor*>(this)->ActorCallback< RunClearActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunClearActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunClearActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunClearActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunClearActor*>(this)->actor_wait_state > 0) static_cast<RunClearActor*>(this)->actor_wait_state = 0;
		static_cast<RunClearActor*>(this)->ActorCallback< RunClearActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunClearActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunClearActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunClearActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(bool const& result,int loopDepth) 
	{
															#line 746 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 7213 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 747 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("Clear resulted in incorrect database");
															#line 7217 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 749 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunClearActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunClearActorState(); static_cast<RunClearActor*>(this)->destroy(); return 0; }
															#line 7221 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		new (&static_cast<RunClearActor*>(this)->SAV< bool >::value()) bool(result);
		this->~RunClearActorState();
		static_cast<RunClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(bool && result,int loopDepth) 
	{
															#line 746 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 7233 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 747 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("Clear resulted in incorrect database");
															#line 7237 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 749 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunClearActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunClearActorState(); static_cast<RunClearActor*>(this)->destroy(); return 0; }
															#line 7241 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		new (&static_cast<RunClearActor*>(this)->SAV< bool >::value()) bool(result);
		this->~RunClearActorState();
		static_cast<RunClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1cont3(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && result,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunClearActor*>(this)->actor_wait_state > 0) static_cast<RunClearActor*>(this)->actor_wait_state = 0;
		static_cast<RunClearActor*>(this)->ActorCallback< RunClearActor, 3, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunClearActor, 3, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunClearActor, 3, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunClearActor, 3, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 702 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	VectorRef<KeyValueRef> data;
															#line 702 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int numClears;
															#line 702 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 704 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Standalone<VectorRef<KeyRef>> keys;
															#line 708 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	int currentIndex;
															#line 711 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reference<TransactionWrapper> transaction;
															#line 7336 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
};
// This generated class is to be used only via runClear()
															#line 702 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunClearActor final : public Actor<bool>, public ActorCallback< RunClearActor, 0, Optional<Value> >, public ActorCallback< RunClearActor, 1, Void >, public ActorCallback< RunClearActor, 2, Void >, public ActorCallback< RunClearActor, 3, bool >, public FastAllocated<RunClearActor>, public RunClearActorState<RunClearActor> {
															#line 7341 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
	using FastAllocated<RunClearActor>::operator new;
	using FastAllocated<RunClearActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6853247673481968640UL, 4586420873782740480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunClearActor, 0, Optional<Value> >;
friend struct ActorCallback< RunClearActor, 1, Void >;
friend struct ActorCallback< RunClearActor, 2, Void >;
friend struct ActorCallback< RunClearActor, 3, bool >;
															#line 702 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunClearActor(VectorRef<KeyValueRef> const& data,int const& numClears,ApiCorrectnessWorkload* const& self) 
															#line 7361 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		 : Actor<bool>(),
		   RunClearActorState<RunClearActor>(data, numClears, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runClear", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10029780055165194752UL, 11590706061971697920UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runClear");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runClear", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunClearActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunClearActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunClearActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunClearActor, 3, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 702 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<bool> runClear( VectorRef<KeyValueRef> const& data, int const& numClears, ApiCorrectnessWorkload* const& self ) {
															#line 702 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<bool>(new RunClearActor(data, numClears, self));
															#line 7396 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
}

#line 751 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"

	// Clears a single range of keys from the database and memory store
																#line 7402 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
// This generated class is to be used only via runClearRange()
															#line 753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
template <class RunClearRangeActor>
															#line 753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunClearRangeActorState {
															#line 7408 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
															#line 753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunClearRangeActorState(VectorRef<KeyValueRef> const& data,ApiCorrectnessWorkload* const& self) 
															#line 753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
															#line 753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		 : data(data),
															#line 753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		   self(self)
															#line 7417 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("runClearRange", reinterpret_cast<unsigned long>(this));

	}
	~RunClearRangeActorState() 
	{
		fdb_probe_actor_destroy("runClearRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 755 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			Key key = self->selectRandomKey(data, 0.5);
															#line 756 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			Key key2 = self->selectRandomKey(data, 0.5);
															#line 758 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			start = std::min(key, key2);
															#line 759 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			end = std::max(key, key2);
															#line 762 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->store.clear(KeyRangeRef(start, end));
															#line 765 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction = self->createTransaction();
															#line 767 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			;
															#line 7444 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunClearRangeActorState();
		static_cast<RunClearRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 785 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		self->debugKey(KeyRangeRef(start, end), "ClearRange");
															#line 788 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<bool> __when_expr_3 = self->compareDatabaseToMemory();
															#line 788 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunClearRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7471 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<RunClearRangeActor*>(this)->actor_wait_state = 4;
															#line 788 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunClearRangeActor, 3, bool >*>(static_cast<RunClearRangeActor*>(this)));
															#line 7476 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 770 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = transaction->get(start);
															#line 770 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunClearRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7495 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunClearRangeActor*>(this)->actor_wait_state = 1;
															#line 770 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunClearRangeActor, 0, Optional<Value> >*>(static_cast<RunClearRangeActor*>(this)));
															#line 7500 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 781 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = transaction->onError(e);
															#line 781 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			if (static_cast<RunClearRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7537 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunClearRangeActor*>(this)->actor_wait_state = 3;
															#line 781 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunClearRangeActor, 2, Void >*>(static_cast<RunClearRangeActor*>(this)));
															#line 7542 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& value,int loopDepth) 
	{
															#line 772 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		range = KeyRangeRef(start, end);
															#line 773 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!range.empty())
															#line 7559 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 774 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->addReadConflictRange(range);
															#line 7563 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 776 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		transaction->clear(range);
															#line 777 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = transaction->commit();
															#line 777 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunClearRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7571 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunClearRangeActor*>(this)->actor_wait_state = 2;
															#line 777 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunClearRangeActor, 1, Void >*>(static_cast<RunClearRangeActor*>(this)));
															#line 7576 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && value,int loopDepth) 
	{
															#line 772 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		range = KeyRangeRef(start, end);
															#line 773 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!range.empty())
															#line 7587 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 774 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			transaction->addReadConflictRange(range);
															#line 7591 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 776 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		transaction->clear(range);
															#line 777 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = transaction->commit();
															#line 777 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (static_cast<RunClearRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7599 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunClearRangeActor*>(this)->actor_wait_state = 2;
															#line 777 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunClearRangeActor, 1, Void >*>(static_cast<RunClearRangeActor*>(this)));
															#line 7604 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunClearRangeActor*>(this)->actor_wait_state > 0) static_cast<RunClearRangeActor*>(this)->actor_wait_state = 0;
		static_cast<RunClearRangeActor*>(this)->ActorCallback< RunClearRangeActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< RunClearRangeActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunClearRangeActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunClearRangeActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 778 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		DEBUG_KEY_RANGE("ApiCorrectnessClear", transaction->getCommittedVersion(), range);
															#line 7688 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 778 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		DEBUG_KEY_RANGE("ApiCorrectnessClear", transaction->getCommittedVersion(), range);
															#line 7697 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunClearRangeActor*>(this)->actor_wait_state > 0) static_cast<RunClearRangeActor*>(this)->actor_wait_state = 0;
		static_cast<RunClearRangeActor*>(this)->ActorCallback< RunClearRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunClearRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunClearRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunClearRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunClearRangeActor*>(this)->actor_wait_state > 0) static_cast<RunClearRangeActor*>(this)->actor_wait_state = 0;
		static_cast<RunClearRangeActor*>(this)->ActorCallback< RunClearRangeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunClearRangeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunClearRangeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunClearRangeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2(bool const& result,int loopDepth) 
	{
															#line 789 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 7868 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 790 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("Clear (range) resulted in incorrect database");
															#line 7872 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 792 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunClearRangeActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunClearRangeActorState(); static_cast<RunClearRangeActor*>(this)->destroy(); return 0; }
															#line 7876 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		new (&static_cast<RunClearRangeActor*>(this)->SAV< bool >::value()) bool(result);
		this->~RunClearRangeActorState();
		static_cast<RunClearRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(bool && result,int loopDepth) 
	{
															#line 789 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!result)
															#line 7888 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		{
															#line 790 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
			self->testFailure("Clear (range) resulted in incorrect database");
															#line 7892 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		}
															#line 792 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
		if (!static_cast<RunClearRangeActor*>(this)->SAV<bool>::futures) { (void)(result); this->~RunClearRangeActorState(); static_cast<RunClearRangeActor*>(this)->destroy(); return 0; }
															#line 7896 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		new (&static_cast<RunClearRangeActor*>(this)->SAV< bool >::value()) bool(result);
		this->~RunClearRangeActorState();
		static_cast<RunClearRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && result,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunClearRangeActor*>(this)->actor_wait_state > 0) static_cast<RunClearRangeActor*>(this)->actor_wait_state = 0;
		static_cast<RunClearRangeActor*>(this)->ActorCallback< RunClearRangeActor, 3, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunClearRangeActor, 3, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunClearRangeActor, 3, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunClearRangeActor, 3, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	VectorRef<KeyValueRef> data;
															#line 753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	ApiCorrectnessWorkload* self;
															#line 758 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Key start;
															#line 759 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Key end;
															#line 765 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	Reference<TransactionWrapper> transaction;
															#line 772 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	KeyRangeRef range;
															#line 7991 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
};
// This generated class is to be used only via runClearRange()
															#line 753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
class RunClearRangeActor final : public Actor<bool>, public ActorCallback< RunClearRangeActor, 0, Optional<Value> >, public ActorCallback< RunClearRangeActor, 1, Void >, public ActorCallback< RunClearRangeActor, 2, Void >, public ActorCallback< RunClearRangeActor, 3, bool >, public FastAllocated<RunClearRangeActor>, public RunClearRangeActorState<RunClearRangeActor> {
															#line 7996 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
public:
	using FastAllocated<RunClearRangeActor>::operator new;
	using FastAllocated<RunClearRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6158689161144781568UL, 9998156370066062848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunClearRangeActor, 0, Optional<Value> >;
friend struct ActorCallback< RunClearRangeActor, 1, Void >;
friend struct ActorCallback< RunClearRangeActor, 2, Void >;
friend struct ActorCallback< RunClearRangeActor, 3, bool >;
															#line 753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	RunClearRangeActor(VectorRef<KeyValueRef> const& data,ApiCorrectnessWorkload* const& self) 
															#line 8016 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
		 : Actor<bool>(),
		   RunClearRangeActorState<RunClearRangeActor>(data, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runClearRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16937313940969349120UL, 12933814195253384704UL);
		ActorExecutionContextHelper __helper(static_cast<RunClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runClearRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runClearRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunClearRangeActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunClearRangeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunClearRangeActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunClearRangeActor, 3, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
[[nodiscard]] Future<bool> runClearRange( VectorRef<KeyValueRef> const& data, ApiCorrectnessWorkload* const& self ) {
															#line 753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
	return Future<bool>(new RunClearRangeActor(data, self));
															#line 8051 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiCorrectness.actor.g.cpp"
}

#line 794 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/workloads/ApiCorrectness.actor.cpp"
};

WorkloadFactory<ApiCorrectnessWorkload> ApiCorrectnessWorkloadFactory;
