#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
/*
 * LogSystemDiskQueueAdapter.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/IDiskQueue.h"
#include "fdbserver/LogSystem.h"
#include "fdbserver/LogSystemDiskQueueAdapter.h"
#include "fdbserver/Knobs.h"
#include "flow/actorcompiler.h" // has to be last include

class LogSystemDiskQueueAdapterImpl {
public:
																#line 31 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
// This generated class is to be used only via readNext()
															#line 29 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
template <class ReadNextActor>
															#line 29 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
class ReadNextActorState {
															#line 37 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
public:
															#line 29 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
	ReadNextActorState(LogSystemDiskQueueAdapter* const& self,int const& bytes) 
															#line 29 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
															#line 29 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		 : self(self),
															#line 29 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		   bytes(bytes)
															#line 46 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
	{
		fdb_probe_actor_create("readNext", reinterpret_cast<unsigned long>(this));

	}
	~ReadNextActorState() 
	{
		fdb_probe_actor_destroy("readNext", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 30 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			;
															#line 61 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadNextActorState();
		static_cast<ReadNextActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 160 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		if (self->recoveryQueue.size() > 1)
															#line 84 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		{
															#line 161 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			self->recoveryQueue[0] = concatenate(self->recoveryQueue.begin(), self->recoveryQueue.end());
															#line 162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			self->recoveryQueue.resize(1);
															#line 90 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		}
															#line 165 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		if (self->recoveryQueueDataSize == 0)
															#line 94 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		{
															#line 166 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			if (!static_cast<ReadNextActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(Standalone<StringRef>()); this->~ReadNextActorState(); static_cast<ReadNextActor*>(this)->destroy(); return 0; }
															#line 98 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
			new (&static_cast<ReadNextActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(Standalone<StringRef>());
			this->~ReadNextActorState();
			static_cast<ReadNextActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 168 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		ASSERT(self->recoveryQueue[0].size() == self->recoveryQueueDataSize);
															#line 171 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		bytes = std::min(bytes, self->recoveryQueue[0].size());
															#line 172 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		Standalone<StringRef> result(self->recoveryQueue[0].substr(0, bytes), self->recoveryQueue[0].arena());
															#line 173 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		self->recoveryQueue[0].contents() = self->recoveryQueue[0].substr(bytes);
															#line 174 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		self->recoveryQueueDataSize = self->recoveryQueue[0].size();
															#line 175 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		if (self->recoveryQueue[0].size() == 0)
															#line 116 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		{
															#line 176 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			self->recoveryQueue.clear();
															#line 120 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		}
															#line 178 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		if (!static_cast<ReadNextActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(result); this->~ReadNextActorState(); static_cast<ReadNextActor*>(this)->destroy(); return 0; }
															#line 124 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		new (&static_cast<ReadNextActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(result);
		this->~ReadNextActorState();
		static_cast<ReadNextActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 30 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		if (!(self->recoveryQueueDataSize < bytes))
															#line 143 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 31 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		if (self->recoveryLoc == self->logSystem->getEnd())
															#line 149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		{
															#line 34 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			TraceEvent("PeekNextEnd") .detail("Queue", self->recoveryQueue.size()) .detail("Bytes", bytes) .detail("Loc", self->recoveryLoc) .detail("End", self->logSystem->getEnd());
															#line 39 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			self->logSystem.clear();
															#line 155 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 43 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		if (!self->cursor->hasMessage())
															#line 160 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		{
															#line 44 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			;
															#line 164 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 151 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		self->recoveryQueue.push_back(Standalone<StringRef>(self->cursor->getMessage(), self->cursor->arena()));
															#line 152 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		self->recoveryQueueDataSize += self->recoveryQueue.back().size();
															#line 153 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		self->totalRecoveredBytes += self->recoveryQueue.back().size();
															#line 154 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		self->cursor->nextMessage();
															#line 155 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		if (!self->cursor->hasMessage())
															#line 199 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		{
															#line 156 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			self->recoveryLoc = self->cursor->version().version;
															#line 203 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 92 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		TraceEvent("PeekNextGetMore") .detail("Total", self->totalRecoveredBytes) .detail("Queue", self->recoveryQueue.size()) .detail("Bytes", bytes) .detail("Loc", self->recoveryLoc) .detail("End", self->logSystem->getEnd()) .detail("HasMessage", self->cursor->hasMessage()) .detail("Version", self->cursor->version().version);
															#line 101 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		bool buggify = !self->hasDiscardedData && BUGGIFY_WITH_PROB(0.01);
															#line 102 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		if (self->cursor->popped() != 0 || buggify)
															#line 217 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		{
															#line 103 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			TraceEvent(SevWarnAlways, "DiskQueueAdapterReset") .detail("Version", self->cursor->popped()) .detail("PeekTypeSwitch", self->peekTypeSwitches % 3);
															#line 106 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			CODE_PROBE(true, "disk adapter reset");
															#line 107 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			if (self->cursor->popped() != 0)
															#line 225 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
			{
															#line 108 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
				self->recoveryLoc = self->cursor->popped();
															#line 229 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
			}
			else
			{
															#line 110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
				self->recoveryLoc = self->startLoc;
															#line 235 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
			}
															#line 112 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			self->recoveryQueue.clear();
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			self->recoveryQueueDataSize = 0;
															#line 114 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			self->recoveryQueueLoc = self->recoveryLoc;
															#line 115 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			self->totalRecoveredBytes = 0;
															#line 116 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			if (self->peekTypeSwitches % 3 == 1)
															#line 247 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
			{
															#line 117 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
				self->cursor = self->logSystem->peekTxs( UID(), self->recoveryLoc, tagLocalityInvalid, invalidVersion, true);
															#line 119 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
				self->localityChanged = Never();
															#line 253 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
			}
			else
			{
															#line 120 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
				if (self->peekTypeSwitches % 3 == 2)
															#line 259 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
				{
															#line 121 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
					self->cursor = self->logSystem->peekTxs( UID(), self->recoveryLoc, self->peekLocality ? self->peekLocality->get().secondaryLocality : tagLocalityInvalid, self->peekLocality ? self->peekLocality->get().knownCommittedVersion : invalidVersion, true);
															#line 127 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
					self->localityChanged = self->peekLocality->onChange();
															#line 265 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
				}
				else
				{
															#line 129 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
					self->cursor = self->logSystem->peekTxs( UID(), self->recoveryLoc, self->peekLocality ? self->peekLocality->get().primaryLocality : tagLocalityInvalid, self->peekLocality ? self->peekLocality->get().knownCommittedVersion : invalidVersion, true);
															#line 135 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
					self->localityChanged = self->peekLocality->onChange();
															#line 273 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
				}
			}
															#line 137 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			self->hasDiscardedData = true;
															#line 138 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			return a_body1Catch1(disk_adapter_reset(), std::max(0, loopDepth - 1));
															#line 280 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		}
															#line 141 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		if (self->recoveryQueueDataSize == 0)
															#line 284 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		{
															#line 142 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			self->recoveryQueueLoc = self->recoveryLoc;
															#line 288 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		}
															#line 144 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		if (!self->cursor->hasMessage())
															#line 292 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		{
															#line 145 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			self->recoveryLoc = self->cursor->version().version;
															#line 146 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			StrictFuture<Void> __when_expr_3 = yield();
															#line 146 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			if (static_cast<ReadNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 300 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<ReadNextActor*>(this)->actor_wait_state = 2;
															#line 146 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ReadNextActor, 3, Void >*>(static_cast<ReadNextActor*>(this)));
															#line 305 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 46 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->cursor->getMore();
															#line 45 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		if (static_cast<ReadNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 328 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 49 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->localityChanged;
															#line 332 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 58 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(self->peekTypeSwitches == 0 ? SERVER_KNOBS->DISK_QUEUE_ADAPTER_MIN_SWITCH_TIME : SERVER_KNOBS->DISK_QUEUE_ADAPTER_MAX_SWITCH_TIME);
															#line 336 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when3(__when_expr_2.get(), loopDepth); };
		static_cast<ReadNextActor*>(this)->actor_wait_state = 1;
															#line 46 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadNextActor, 0, Void >*>(static_cast<ReadNextActor*>(this)));
															#line 49 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadNextActor, 1, Void >*>(static_cast<ReadNextActor*>(this)));
															#line 58 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadNextActor, 2, Void >*>(static_cast<ReadNextActor*>(this)));
															#line 345 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 50 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		self->cursor = self->logSystem->peekTxs( UID(), self->recoveryLoc, self->peekLocality ? self->peekLocality->get().primaryLocality : tagLocalityInvalid, self->peekLocality ? self->peekLocality->get().knownCommittedVersion : invalidVersion, self->totalRecoveredBytes == 0);
															#line 56 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		self->localityChanged = self->peekLocality->onChange();
															#line 387 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 50 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		self->cursor = self->logSystem->peekTxs( UID(), self->recoveryLoc, self->peekLocality ? self->peekLocality->get().primaryLocality : tagLocalityInvalid, self->peekLocality ? self->peekLocality->get().knownCommittedVersion : invalidVersion, self->totalRecoveredBytes == 0);
															#line 56 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		self->localityChanged = self->peekLocality->onChange();
															#line 398 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 61 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		self->peekTypeSwitches++;
															#line 62 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		if (self->peekTypeSwitches % 3 == 1)
															#line 409 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		{
															#line 63 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			self->cursor = self->logSystem->peekTxs(UID(), self->recoveryLoc, tagLocalityInvalid, invalidVersion, self->totalRecoveredBytes == 0);
															#line 68 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			self->localityChanged = Never();
															#line 415 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		}
		else
		{
															#line 69 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			if (self->peekTypeSwitches % 3 == 2)
															#line 421 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
			{
															#line 70 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
				self->cursor = self->logSystem->peekTxs( UID(), self->recoveryLoc, self->peekLocality ? self->peekLocality->get().secondaryLocality : tagLocalityInvalid, self->peekLocality ? self->peekLocality->get().knownCommittedVersion : invalidVersion, self->totalRecoveredBytes == 0);
															#line 78 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
				self->localityChanged = self->peekLocality->onChange();
															#line 427 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
			}
			else
			{
															#line 80 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
				self->cursor = self->logSystem->peekTxs( UID(), self->recoveryLoc, self->peekLocality ? self->peekLocality->get().primaryLocality : tagLocalityInvalid, self->peekLocality ? self->peekLocality->get().knownCommittedVersion : invalidVersion, self->totalRecoveredBytes == 0);
															#line 87 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
				self->localityChanged = self->peekLocality->onChange();
															#line 435 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 61 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		self->peekTypeSwitches++;
															#line 62 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
		if (self->peekTypeSwitches % 3 == 1)
															#line 448 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		{
															#line 63 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			self->cursor = self->logSystem->peekTxs(UID(), self->recoveryLoc, tagLocalityInvalid, invalidVersion, self->totalRecoveredBytes == 0);
															#line 68 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			self->localityChanged = Never();
															#line 454 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		}
		else
		{
															#line 69 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
			if (self->peekTypeSwitches % 3 == 2)
															#line 460 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
			{
															#line 70 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
				self->cursor = self->logSystem->peekTxs( UID(), self->recoveryLoc, self->peekLocality ? self->peekLocality->get().secondaryLocality : tagLocalityInvalid, self->peekLocality ? self->peekLocality->get().knownCommittedVersion : invalidVersion, self->totalRecoveredBytes == 0);
															#line 78 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
				self->localityChanged = self->peekLocality->onChange();
															#line 466 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
			}
			else
			{
															#line 80 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
				self->cursor = self->logSystem->peekTxs( UID(), self->recoveryLoc, self->peekLocality ? self->peekLocality->get().primaryLocality : tagLocalityInvalid, self->peekLocality ? self->peekLocality->get().knownCommittedVersion : invalidVersion, self->totalRecoveredBytes == 0);
															#line 87 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
				self->localityChanged = self->peekLocality->onChange();
															#line 474 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadNextActor*>(this)->actor_wait_state > 0) static_cast<ReadNextActor*>(this)->actor_wait_state = 0;
		static_cast<ReadNextActor*>(this)->ActorCallback< ReadNextActor, 0, Void >::remove();
		static_cast<ReadNextActor*>(this)->ActorCallback< ReadNextActor, 1, Void >::remove();
		static_cast<ReadNextActor*>(this)->ActorCallback< ReadNextActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadNextActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadNextActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadNextActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadNextActor*>(this)->actor_wait_state > 0) static_cast<ReadNextActor*>(this)->actor_wait_state = 0;
		static_cast<ReadNextActor*>(this)->ActorCallback< ReadNextActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ReadNextActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 29 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
	LogSystemDiskQueueAdapter* self;
															#line 29 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
	int bytes;
															#line 757 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
};
// This generated class is to be used only via readNext()
															#line 29 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
class ReadNextActor final : public Actor<Standalone<StringRef>>, public ActorCallback< ReadNextActor, 0, Void >, public ActorCallback< ReadNextActor, 1, Void >, public ActorCallback< ReadNextActor, 2, Void >, public ActorCallback< ReadNextActor, 3, Void >, public FastAllocated<ReadNextActor>, public ReadNextActorState<ReadNextActor> {
															#line 762 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
public:
	using FastAllocated<ReadNextActor>::operator new;
	using FastAllocated<ReadNextActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15402390556956475648UL, 14793605895886588928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<StringRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadNextActor, 0, Void >;
friend struct ActorCallback< ReadNextActor, 1, Void >;
friend struct ActorCallback< ReadNextActor, 2, Void >;
friend struct ActorCallback< ReadNextActor, 3, Void >;
															#line 29 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
	ReadNextActor(LogSystemDiskQueueAdapter* const& self,int const& bytes) 
															#line 782 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
		 : Actor<Standalone<StringRef>>(),
		   ReadNextActorState<ReadNextActor>(self, bytes),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8157539301062630144UL, 4791951039325370368UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readNext");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadNextActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadNextActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 29 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
[[nodiscard]] static Future<Standalone<StringRef>> readNext( LogSystemDiskQueueAdapter* const& self, int const& bytes ) {
															#line 29 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
	return Future<Standalone<StringRef>>(new ReadNextActor(self, bytes));
															#line 815 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemDiskQueueAdapter.actor.g.cpp"
}

#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbserver/LogSystemDiskQueueAdapter.actor.cpp"
};

Future<Standalone<StringRef>> LogSystemDiskQueueAdapter::readNext(int bytes) {
	if (!enableRecovery)
		return Standalone<StringRef>();
	return LogSystemDiskQueueAdapterImpl::readNext(this, bytes);
}

IDiskQueue::location LogSystemDiskQueueAdapter::getNextReadLocation() const {
	return IDiskQueue::location(0, recoveryQueueLoc);
}

IDiskQueue::location LogSystemDiskQueueAdapter::push(StringRef contents) {
	while (contents.size()) {
		int remainder = pushedData.size() == 0 ? 0 : pushedData.back().capacity() - pushedData.back().size();

		if (remainder == 0) {
			VectorRef<uint8_t> block;
			block.reserve(pushedData.arena(), SERVER_KNOBS->LOG_SYSTEM_PUSHED_DATA_BLOCK_SIZE);
			pushedData.push_back(pushedData.arena(), block);
			remainder = block.capacity();
		}

		pushedData.back().append(pushedData.arena(), contents.begin(), std::min(remainder, contents.size()));
		contents = contents.substr(std::min(remainder, contents.size()));
	}

	return IDiskQueue::location(0, nextCommit);
}

void LogSystemDiskQueueAdapter::pop(location upTo) {
	ASSERT(upTo.hi == 0);
	poppedUpTo = std::max(upTo.lo, poppedUpTo);
}

Future<Void> LogSystemDiskQueueAdapter::commit() {
	ASSERT(!commitMessages.empty());

	auto promise = commitMessages.front();
	commitMessages.pop_front();

	CommitMessage cm;
	cm.messages = this->pushedData;
	this->pushedData = Standalone<VectorRef<VectorRef<uint8_t>>>();
	cm.popTo = poppedUpTo;
	promise.send(cm);

	return cm.acknowledge.getFuture();
}

Future<Void> LogSystemDiskQueueAdapter::getError() const {
	return Void();
}

Future<Void> LogSystemDiskQueueAdapter::onClosed() const {
	return Void();
}

void LogSystemDiskQueueAdapter::dispose() {
	delete this;
}

void LogSystemDiskQueueAdapter::close() {
	delete this;
}

Future<LogSystemDiskQueueAdapter::CommitMessage> LogSystemDiskQueueAdapter::getCommitMessage() {
	Promise<CommitMessage> pcm;
	commitMessages.push_back(pcm);
	return pcm.getFuture();
}

LogSystemDiskQueueAdapter* openDiskQueueAdapter(Reference<ILogSystem> logSystem,
                                                Reference<AsyncVar<PeekTxsInfo>> peekLocality,
                                                Version txsPoppedVersion) {
	return new LogSystemDiskQueueAdapter(logSystem, peekLocality, txsPoppedVersion, true);
}
