#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
/*
 * DatabaseBackupAgent.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <iterator>
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/Status.h"
#include "fdbclient/StatusClient.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/NativeAPI.actor.h"
#include <ctime>
#include <climits>
#include "fdbrpc/simulator.h"
#include "flow/IAsyncFile.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"
#include "flow/Hash3.h"
#include <numeric>
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include <inttypes.h>
#include <map>

#include "flow/actorcompiler.h" // has to be last include

const Key DatabaseBackupAgent::keyAddPrefix = "add_prefix"_sr;
const Key DatabaseBackupAgent::keyRemovePrefix = "remove_prefix"_sr;
const Key DatabaseBackupAgent::keyRangeVersions = "range_versions"_sr;
const Key DatabaseBackupAgent::keyCopyStop = "copy_stop"_sr;
const Key DatabaseBackupAgent::keyDatabasesInSync = "databases_in_sync"_sr;
const int DatabaseBackupAgent::LATEST_DR_VERSION = 1;

DatabaseBackupAgent::DatabaseBackupAgent()
  : subspace(Subspace(databaseBackupPrefixRange.begin)), states(subspace.get(BackupAgentBase::keyStates)),
    config(subspace.get(BackupAgentBase::keyConfig)), errors(subspace.get(BackupAgentBase::keyErrors)),
    ranges(subspace.get(BackupAgentBase::keyRanges)), tagNames(subspace.get(BackupAgentBase::keyTagName)),
    sourceStates(subspace.get(BackupAgentBase::keySourceStates)),
    sourceTagNames(subspace.get(BackupAgentBase::keyTagName)),
    taskBucket(new TaskBucket(subspace.get(BackupAgentBase::keyTasks),
                              AccessSystemKeys::True,
                              PriorityBatch::False,
                              LockAware::True)),
    futureBucket(new FutureBucket(subspace.get(BackupAgentBase::keyFutures), AccessSystemKeys::True, LockAware::True)) {
}

DatabaseBackupAgent::DatabaseBackupAgent(Database src)
  : subspace(Subspace(databaseBackupPrefixRange.begin)), states(subspace.get(BackupAgentBase::keyStates)),
    config(subspace.get(BackupAgentBase::keyConfig)), errors(subspace.get(BackupAgentBase::keyErrors)),
    ranges(subspace.get(BackupAgentBase::keyRanges)), tagNames(subspace.get(BackupAgentBase::keyTagName)),
    sourceStates(subspace.get(BackupAgentBase::keySourceStates)),
    sourceTagNames(subspace.get(BackupAgentBase::keyTagName)),
    taskBucket(new TaskBucket(subspace.get(BackupAgentBase::keyTasks),
                              AccessSystemKeys::True,
                              PriorityBatch::False,
                              LockAware::True)),
    futureBucket(new FutureBucket(subspace.get(BackupAgentBase::keyFutures), AccessSystemKeys::True, LockAware::True)) {
	taskBucket->src = src;
}

// Any new per-DR properties should go here.
class DRConfig {
public:
	DRConfig(UID uid = UID())
	  : uid(uid), configSpace(uidPrefixKey("uid->config/"_sr.withPrefix(databaseBackupPrefixRange.begin), uid)) {}
	DRConfig(Reference<Task> task)
	  : DRConfig(BinaryReader::fromStringRef<UID>(task->params[BackupAgentBase::keyConfigLogUid], Unversioned())) {}

	KeyBackedBinaryValue<int64_t> rangeBytesWritten() { return configSpace.pack(__FUNCTION__sr); }

	KeyBackedBinaryValue<int64_t> logBytesWritten() { return configSpace.pack(__FUNCTION__sr); }

	void clear(Reference<ReadYourWritesTransaction> tr) { tr->clear(configSpace.range()); }

	UID getUid() { return uid; }

private:
	UID uid;
	Subspace configSpace;
};

namespace dbBackup {

bool copyDefaultParameters(Reference<Task> source, Reference<Task> dest) {
	if (source) {
		copyParameter(source, dest, BackupAgentBase::keyFolderId);
		copyParameter(source, dest, BackupAgentBase::keyConfigLogUid);
		copyParameter(source, dest, BackupAgentBase::destUid);

		copyParameter(source, dest, DatabaseBackupAgent::keyAddPrefix);
		copyParameter(source, dest, DatabaseBackupAgent::keyRemovePrefix);
		return true;
	}

	return false;
}

															#line 115 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via checkTaskVersion()
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class Tr, class CheckTaskVersionActor>
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class CheckTaskVersionActorState {
															#line 121 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	CheckTaskVersionActorState(Tr const& tr,Reference<Task> const& task,StringRef const& name,uint32_t const& version) 
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task),
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   name(name),
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   version(version)
															#line 134 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("checkTaskVersion", reinterpret_cast<unsigned long>(this));

	}
	~CheckTaskVersionActorState() 
	{
		fdb_probe_actor_destroy("checkTaskVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 115 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			uint32_t taskVersion = task->getVersion();
															#line 116 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (taskVersion > version)
															#line 151 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 117 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				TraceEvent(SevError, "BA_BackupRangeTaskFuncExecute") .detail("TaskVersion", taskVersion) .detail("Name", name) .detail("Version", version);
															#line 121 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = logError(tr, Subspace(databaseBackupPrefixRange.begin) .get(BackupAgentBase::keyErrors) .pack(task->params[BackupAgentBase::keyConfigLogUid]), format("ERROR: %s task version `%lu' is greater than supported version `%lu'", task->params[Task::reservedTaskParamKeyType].toString().c_str(), (unsigned long)taskVersion, (unsigned long)version));
															#line 121 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (static_cast<CheckTaskVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 159 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CheckTaskVersionActor*>(this)->actor_wait_state = 1;
															#line 121 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckTaskVersionActor, 0, Void >*>(static_cast<CheckTaskVersionActor*>(this)));
															#line 164 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckTaskVersionActorState();
		static_cast<CheckTaskVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 133 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<CheckTaskVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckTaskVersionActorState(); static_cast<CheckTaskVersionActor*>(this)->destroy(); return 0; }
															#line 192 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<CheckTaskVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckTaskVersionActorState();
		static_cast<CheckTaskVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 130 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		return a_body1Catch1(task_invalid_version(), loopDepth);
															#line 204 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 130 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		return a_body1Catch1(task_invalid_version(), loopDepth);
															#line 212 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckTaskVersionActor*>(this)->actor_wait_state > 0) static_cast<CheckTaskVersionActor*>(this)->actor_wait_state = 0;
		static_cast<CheckTaskVersionActor*>(this)->ActorCallback< CheckTaskVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckTaskVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckTaskVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckTaskVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Tr tr;
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	StringRef name;
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	uint32_t version;
															#line 299 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via checkTaskVersion()
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class Tr>
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class CheckTaskVersionActor final : public Actor<Void>, public ActorCallback< CheckTaskVersionActor<Tr>, 0, Void >, public FastAllocated<CheckTaskVersionActor<Tr>>, public CheckTaskVersionActorState<Tr, CheckTaskVersionActor<Tr>> {
															#line 306 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<CheckTaskVersionActor<Tr>>::operator new;
	using FastAllocated<CheckTaskVersionActor<Tr>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11068151573986780160UL, 4298655903204969216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckTaskVersionActor<Tr>, 0, Void >;
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	CheckTaskVersionActor(Tr const& tr,Reference<Task> const& task,StringRef const& name,uint32_t const& version) 
															#line 323 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   CheckTaskVersionActorState<Tr, CheckTaskVersionActor<Tr>>(tr, task, name, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3362756845853264896UL, 17854206522136534528UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkTaskVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckTaskVersionActor<Tr>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class Tr>
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] Future<Void> checkTaskVersion( Tr const& tr, Reference<Task> const& task, StringRef const& name, uint32_t const& version ) {
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Void>(new CheckTaskVersionActor<Tr>(tr, task, name, version));
															#line 357 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 135 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

struct BackupRangeTaskFunc : TaskFuncBase {
	static StringRef name;
	static constexpr uint32_t version = 1;

	static struct {
		static TaskParam<int64_t> bytesWritten() { return __FUNCTION__sr; }
	} Params;

	static const Key keyAddBackupRangeTasks;
	static const Key keyBackupRangeBeginKey;

	StringRef getName() const override { return name; };

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return _execute(cx, tb, fb, task);
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};

																#line 388 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via getBlockOfShards()
															#line 162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class GetBlockOfShardsActor>
															#line 162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class GetBlockOfShardsActorState {
															#line 394 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	GetBlockOfShardsActorState(Reference<ReadYourWritesTransaction> const& tr,Key const& beginKey,Key const& endKey,int const& limit) 
															#line 162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   beginKey(beginKey),
															#line 162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   endKey(endKey),
															#line 162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   limit(limit)
															#line 407 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("getBlockOfShards", reinterpret_cast<unsigned long>(this));

	}
	~GetBlockOfShardsActorState() 
	{
		fdb_probe_actor_destroy("getBlockOfShards", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 166 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 167 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 168 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			results = Standalone<VectorRef<KeyRef>>();
															#line 169 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange( KeyRangeRef(keyAfter(beginKey.withPrefix(keyServersPrefix)), endKey.withPrefix(keyServersPrefix)), limit);
															#line 169 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 430 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state = 1;
															#line 169 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*>(static_cast<GetBlockOfShardsActor*>(this)));
															#line 435 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBlockOfShardsActorState();
		static_cast<GetBlockOfShardsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& values,int loopDepth) 
	{
															#line 172 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		for( auto& s : values ) {
															#line 173 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			KeyRef k = s.key.removePrefix(keyServersPrefix);
															#line 174 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			results.push_back_deep(results.arena(), k);
															#line 462 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
															#line 177 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<GetBlockOfShardsActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(results); this->~GetBlockOfShardsActorState(); static_cast<GetBlockOfShardsActor*>(this)->destroy(); return 0; }
															#line 466 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<GetBlockOfShardsActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(std::move(results)); // state_var_RVO
		this->~GetBlockOfShardsActorState();
		static_cast<GetBlockOfShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && values,int loopDepth) 
	{
															#line 172 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		for( auto& s : values ) {
															#line 173 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			KeyRef k = s.key.removePrefix(keyServersPrefix);
															#line 174 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			results.push_back_deep(results.arena(), k);
															#line 482 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
															#line 177 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<GetBlockOfShardsActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(results); this->~GetBlockOfShardsActorState(); static_cast<GetBlockOfShardsActor*>(this)->destroy(); return 0; }
															#line 486 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<GetBlockOfShardsActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(std::move(results)); // state_var_RVO
		this->~GetBlockOfShardsActorState();
		static_cast<GetBlockOfShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& values,int loopDepth) 
	{
		loopDepth = a_body1cont1(values, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && values,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(values), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state > 0) static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state = 0;
		static_cast<GetBlockOfShardsActor*>(this)->ActorCallback< GetBlockOfShardsActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Key beginKey;
															#line 162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Key endKey;
															#line 162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	int limit;
															#line 168 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Standalone<VectorRef<KeyRef>> results;
															#line 579 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via getBlockOfShards()
															#line 162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class GetBlockOfShardsActor final : public Actor<Standalone<VectorRef<KeyRef>>>, public ActorCallback< GetBlockOfShardsActor, 0, RangeResult >, public FastAllocated<GetBlockOfShardsActor>, public GetBlockOfShardsActorState<GetBlockOfShardsActor> {
															#line 584 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<GetBlockOfShardsActor>::operator new;
	using FastAllocated<GetBlockOfShardsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13912726453072898048UL, 13242792678985109504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBlockOfShardsActor, 0, RangeResult >;
															#line 162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	GetBlockOfShardsActor(Reference<ReadYourWritesTransaction> const& tr,Key const& beginKey,Key const& endKey,int const& limit) 
															#line 601 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Standalone<VectorRef<KeyRef>>>(),
		   GetBlockOfShardsActorState<GetBlockOfShardsActor>(tr, beginKey, endKey, limit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13286161151181671680UL, 17379547947322064896UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBlockOfShards");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Standalone<VectorRef<KeyRef>>> getBlockOfShards( Reference<ReadYourWritesTransaction> const& tr, Key const& beginKey, Key const& endKey, int const& limit ) {
															#line 162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<KeyRef>>>(new GetBlockOfShardsActor(tr, beginKey, endKey, limit));
															#line 633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 179 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

																#line 638 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via addTask()
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class AddTaskActor>
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class AddTaskActorState {
															#line 644 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	AddTaskActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,Key const& begin,Key const& end,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>()) 
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   parentTask(parentTask),
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   begin(begin),
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   end(end),
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   completionKey(completionKey),
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   waitFor(waitFor)
															#line 663 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("addTask", reinterpret_cast<unsigned long>(this));

	}
	~AddTaskActorState() 
	{
		fdb_probe_actor_destroy("addTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 187 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Key> __when_expr_0 = completionKey.get(tr, taskBucket);
															#line 187 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<AddTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 680 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddTaskActor*>(this)->actor_wait_state = 1;
															#line 187 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor, 0, Key >*>(static_cast<AddTaskActor*>(this)));
															#line 685 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddTaskActorState();
		static_cast<AddTaskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key const& doneKey,int loopDepth) 
	{
															#line 188 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		auto task = makeReference<Task>(BackupRangeTaskFunc::name, BackupRangeTaskFunc::version, doneKey);
															#line 190 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		copyDefaultParameters(parentTask, task);
															#line 192 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[BackupAgentBase::keyBeginKey] = begin;
															#line 193 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[BackupAgentBase::keyEndKey] = end;
															#line 195 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!waitFor)
															#line 716 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 196 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<AddTaskActor*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId])); this->~AddTaskActorState(); static_cast<AddTaskActor*>(this)->destroy(); return 0; }
															#line 720 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<AddTaskActor*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]));
			this->~AddTaskActorState();
			static_cast<AddTaskActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 202 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitFor->onSetAddTask(tr, taskBucket, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]);
															#line 202 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<AddTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 730 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTaskActor*>(this)->actor_wait_state = 2;
															#line 202 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor, 1, Void >*>(static_cast<AddTaskActor*>(this)));
															#line 735 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key && doneKey,int loopDepth) 
	{
															#line 188 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		auto task = makeReference<Task>(BackupRangeTaskFunc::name, BackupRangeTaskFunc::version, doneKey);
															#line 190 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		copyDefaultParameters(parentTask, task);
															#line 192 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[BackupAgentBase::keyBeginKey] = begin;
															#line 193 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[BackupAgentBase::keyEndKey] = end;
															#line 195 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!waitFor)
															#line 752 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 196 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<AddTaskActor*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId])); this->~AddTaskActorState(); static_cast<AddTaskActor*>(this)->destroy(); return 0; }
															#line 756 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<AddTaskActor*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]));
			this->~AddTaskActorState();
			static_cast<AddTaskActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 202 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitFor->onSetAddTask(tr, taskBucket, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]);
															#line 202 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<AddTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 766 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTaskActor*>(this)->actor_wait_state = 2;
															#line 202 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor, 1, Void >*>(static_cast<AddTaskActor*>(this)));
															#line 771 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Key const& doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(doneKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(doneKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddTaskActor*>(this)->actor_wait_state > 0) static_cast<AddTaskActor*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor*>(this)->ActorCallback< AddTaskActor, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddTaskActor, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddTaskActor, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 207 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddTaskActorState(); static_cast<AddTaskActor*>(this)->destroy(); return 0; }
															#line 855 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddTaskActorState();
		static_cast<AddTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 207 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddTaskActorState(); static_cast<AddTaskActor*>(this)->destroy(); return 0; }
															#line 867 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddTaskActorState();
		static_cast<AddTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddTaskActor*>(this)->actor_wait_state > 0) static_cast<AddTaskActor*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor*>(this)->ActorCallback< AddTaskActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddTaskActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddTaskActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> parentTask;
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Key begin;
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Key end;
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	TaskCompletionKey completionKey;
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> waitFor;
															#line 964 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via addTask()
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class AddTaskActor final : public Actor<Key>, public ActorCallback< AddTaskActor, 0, Key >, public ActorCallback< AddTaskActor, 1, Void >, public FastAllocated<AddTaskActor>, public AddTaskActorState<AddTaskActor> {
															#line 969 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<AddTaskActor>::operator new;
	using FastAllocated<AddTaskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2537356427516845568UL, 7488682081184314112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddTaskActor, 0, Key >;
friend struct ActorCallback< AddTaskActor, 1, Void >;
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	AddTaskActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,Key const& begin,Key const& end,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>()) 
															#line 987 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Key>(),
		   AddTaskActorState<AddTaskActor>(tr, taskBucket, parentTask, begin, end, completionKey, waitFor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6060296532077720576UL, 16456885635641163264UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddTaskActor, 0, Key >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddTaskActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Key> addTask( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<Task> const& parentTask, Key const& begin, Key const& end, TaskCompletionKey const& completionKey, Reference<TaskFuture> const& waitFor = Reference<TaskFuture>() ) {
															#line 180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Key>(new AddTaskActor(tr, taskBucket, parentTask, begin, end, completionKey, waitFor));
															#line 1020 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 209 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

																#line 1025 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via _execute()
															#line 210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class _executeActor>
															#line 210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _executeActorState {
															#line 1031 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_executeActorState(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : cx(cx),
															#line 210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task),
															#line 214 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   lock(new FlowLock(CLIENT_KNOBS->BACKUP_LOCK_BYTES)),
															#line 215 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   conf(Subspace(databaseBackupPrefixRange.begin) .get(BackupAgentBase::keyConfig) .get(task->params[BackupAgentBase::keyConfigLogUid]))
															#line 1048 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_execute", reinterpret_cast<unsigned long>(this));

	}
	~_executeActorState() 
	{
		fdb_probe_actor_destroy("_execute", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 219 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = checkTaskVersion(cx, task, BackupRangeTaskFunc::name, BackupRangeTaskFunc::version);
															#line 219 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1065 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 1;
															#line 219 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 0, Void >*>(static_cast<_executeActor*>(this)));
															#line 1070 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_executeActorState();
		static_cast<_executeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 221 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_1 = runRYWTransaction(taskBucket->src, [=](Reference<ReadYourWritesTransaction> tr) { return getBlockOfShards(tr, task->params[DatabaseBackupAgent::keyBeginKey], task->params[DatabaseBackupAgent::keyEndKey], CLIENT_KNOBS->BACKUP_SHARD_TASK_LIMIT); });
															#line 221 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1095 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 2;
															#line 221 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*>(static_cast<_executeActor*>(this)));
															#line 1100 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 221 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_1 = runRYWTransaction(taskBucket->src, [=](Reference<ReadYourWritesTransaction> tr) { return getBlockOfShards(tr, task->params[DatabaseBackupAgent::keyBeginKey], task->params[DatabaseBackupAgent::keyEndKey], CLIENT_KNOBS->BACKUP_SHARD_TASK_LIMIT); });
															#line 221 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1111 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 2;
															#line 221 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*>(static_cast<_executeActor*>(this)));
															#line 1116 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _executeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _executeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Standalone<VectorRef<KeyRef>> const& keys,int loopDepth) 
	{
															#line 228 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (keys.size() > 0)
															#line 1200 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 229 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			task->params[BackupRangeTaskFunc::keyAddBackupRangeTasks] = BinaryWriter::toValue(keys, IncludeVersion());
															#line 230 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 1206 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 236 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		timeout = now() + CLIENT_KNOBS->BACKUP_RANGE_TIMEOUT;
															#line 237 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		addPrefix = task->params[DatabaseBackupAgent::keyAddPrefix];
															#line 238 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		removePrefix = task->params[DatabaseBackupAgent::keyRemovePrefix];
															#line 240 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		range = KeyRange(KeyRangeRef(task->params[BackupAgentBase::keyBeginKey], task->params[BackupAgentBase::keyEndKey]));
															#line 244 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		results = PromiseStream<RangeResultWithVersion>();
															#line 246 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		rc = readCommitted( taskBucket->src, results, lock, range, Terminator::True, AccessSystemKeys::True, LockAware::True);
															#line 248 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		rangeBegin = range.begin;
															#line 249 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		rangeEnd = Key();
															#line 250 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		endOfStream = false;
															#line 251 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		nextValues = RangeResultWithVersion();
															#line 252 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		nextValuesSize = 0;
															#line 253 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		nextValues.second = invalidVersion;
															#line 254 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		;
															#line 1238 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Standalone<VectorRef<KeyRef>> && keys,int loopDepth) 
	{
															#line 228 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (keys.size() > 0)
															#line 1247 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 229 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			task->params[BackupRangeTaskFunc::keyAddBackupRangeTasks] = BinaryWriter::toValue(keys, IncludeVersion());
															#line 230 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 1253 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 236 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		timeout = now() + CLIENT_KNOBS->BACKUP_RANGE_TIMEOUT;
															#line 237 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		addPrefix = task->params[DatabaseBackupAgent::keyAddPrefix];
															#line 238 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		removePrefix = task->params[DatabaseBackupAgent::keyRemovePrefix];
															#line 240 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		range = KeyRange(KeyRangeRef(task->params[BackupAgentBase::keyBeginKey], task->params[BackupAgentBase::keyEndKey]));
															#line 244 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		results = PromiseStream<RangeResultWithVersion>();
															#line 246 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		rc = readCommitted( taskBucket->src, results, lock, range, Terminator::True, AccessSystemKeys::True, LockAware::True);
															#line 248 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		rangeBegin = range.begin;
															#line 249 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		rangeEnd = Key();
															#line 250 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		endOfStream = false;
															#line 251 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		nextValues = RangeResultWithVersion();
															#line 252 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		nextValuesSize = 0;
															#line 253 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		nextValues.second = invalidVersion;
															#line 254 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		;
															#line 1285 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<KeyRef>> const& keys,int loopDepth) 
	{
		loopDepth = a_body1cont2(keys, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<KeyRef>> && keys,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(keys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 255 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (endOfStream && nextValues.second == invalidVersion)
															#line 1376 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 256 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 1380 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 258 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		values = std::move(nextValues);
															#line 259 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		valuesSize = nextValuesSize;
															#line 260 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		nextValues = RangeResultWithVersion();
															#line 261 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		nextValues.second = invalidVersion;
															#line 262 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		nextValuesSize = 0;
															#line 264 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!endOfStream)
															#line 1398 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 265 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			;
															#line 1402 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = a_body1cont2loopBody1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 308 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (now() >= timeout)
															#line 1416 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 309 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			task->params[BackupRangeTaskFunc::keyBackupRangeBeginKey] = rangeBegin;
															#line 310 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 1422 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 313 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		rangeEnd = values.first.more ? keyAfter(values.first.end()[-1].key) : range.end;
															#line 315 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		valueLoc = 0;
															#line 316 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		committedValueLoc = 0;
															#line 317 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 318 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		;
															#line 1438 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 267 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			auto __when_expr_2 = results.getFuture();
															#line 1461 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_2), FutureStream<RangeResultWithVersion>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<RangeResultWithVersion>>::value, "invalid type");
															#line 267 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1465 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1loopBody1when1(__when_expr_2.pop(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 3;
															#line 267 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< _executeActor, 2, RangeResultWithVersion >*>(static_cast<_executeActor*>(this)));
															#line 1470 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont2loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 286 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			err = e;
															#line 287 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (err.code() == error_code_actor_cancelled)
															#line 1507 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 288 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				return a_body1Catch1(err, std::max(0, loopDepth - 2));
															#line 1511 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
															#line 290 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (err.code() == error_code_end_of_stream)
															#line 1515 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 291 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				endOfStream = true;
															#line 292 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (values.second != invalidVersion)
															#line 1521 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				{
					return a_body1cont2loopBody1break1(loopDepth==0?0:loopDepth-1); // break
				}
															#line 294 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 1527 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_executeActorState();
				static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 297 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_3 = logError(cx, Subspace(databaseBackupPrefixRange.begin) .get(BackupAgentBase::keyErrors) .pack(task->params[BackupAgentBase::keyConfigLogUid]), format("ERROR: %s", err.what()));
															#line 297 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1537 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont2loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 4;
															#line 297 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 3, Void >*>(static_cast<_executeActor*>(this)));
															#line 1542 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont2(RangeResultWithVersion const& v,int loopDepth) 
	{
															#line 268 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		int64_t resultSize = v.first.expectedSize();
															#line 269 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		lock->release(resultSize);
															#line 271 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (values.second == invalidVersion)
															#line 1561 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 272 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			values = v;
															#line 1565 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
		else
		{
															#line 273 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if ((values.second != v.second) || (valuesSize > 0 && resultSize > 0 && valuesSize + resultSize > CLIENT_KNOBS->BACKUP_LOG_WRITE_BATCH_MAX_SIZE))
															#line 1571 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 276 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				nextValues = v;
															#line 277 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				nextValuesSize = resultSize;
															#line 1577 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				return a_body1cont2loopBody1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 280 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				values.first.append_deep(values.first.arena(), v.first.begin(), v.first.size());
															#line 281 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				values.first.more = v.first.more;
															#line 1586 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
		}
															#line 284 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		valuesSize += resultSize;
															#line 1591 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont2(RangeResultWithVersion && v,int loopDepth) 
	{
															#line 268 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		int64_t resultSize = v.first.expectedSize();
															#line 269 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		lock->release(resultSize);
															#line 271 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (values.second == invalidVersion)
															#line 1604 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 272 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			values = v;
															#line 1608 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
		else
		{
															#line 273 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if ((values.second != v.second) || (valuesSize > 0 && resultSize > 0 && valuesSize + resultSize > CLIENT_KNOBS->BACKUP_LOG_WRITE_BATCH_MAX_SIZE))
															#line 1614 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 276 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				nextValues = v;
															#line 277 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				nextValuesSize = resultSize;
															#line 1620 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				return a_body1cont2loopBody1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 280 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				values.first.append_deep(values.first.arena(), v.first.begin(), v.first.size());
															#line 281 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				values.first.more = v.first.more;
															#line 1629 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
		}
															#line 284 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		valuesSize += resultSize;
															#line 1634 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1when1(RangeResultWithVersion const& v,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1when1(RangeResultWithVersion && v,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorSingleCallback< _executeActor, 2, RangeResultWithVersion >::remove();

	}
	void a_callback_fire(ActorSingleCallback< _executeActor, 2, RangeResultWithVersion >*,RangeResultWithVersion const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< _executeActor, 2, RangeResultWithVersion >*,RangeResultWithVersion && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< _executeActor, 2, RangeResultWithVersion >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 303 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		return a_body1Catch1(err, std::max(0, loopDepth - 2));
															#line 1731 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 303 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		return a_body1Catch1(err, std::max(0, loopDepth - 2));
															#line 1739 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _executeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _executeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopBody1cont4(int loopDepth) 
	{
															#line 464 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		rangeBegin = rangeEnd;
															#line 1822 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr->reset();
															#line 321 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 322 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 323 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			prefix = task->params[BackupAgentBase::keyConfigLogUid].withPrefix( applyMutationsKeyVersionMapRange.begin);
															#line 325 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			rangeCountKey = task->params[BackupAgentBase::keyConfigLogUid].withPrefix( applyMutationsKeyVersionCountRange.begin);
															#line 327 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			backupVersions = krmGetRanges(tr, prefix, KeyRangeRef(rangeBegin, rangeEnd), BUGGIFY ? 2 : 2000, 1e5);
															#line 329 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			logVersionValue = tr->get(task->params[BackupAgentBase::keyConfigLogUid].withPrefix(applyMutationsEndRange.begin), Snapshot::True);
															#line 332 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			rangeCountValue = tr->get(rangeCountKey, Snapshot::True);
															#line 333 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			prevRange = tr->getRange(firstGreaterOrEqual(prefix), lastLessOrEqual(rangeBegin.withPrefix(prefix)), 1, Snapshot::True, Reverse::True);
															#line 338 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			nextRange = tr->getRange(firstGreaterOrEqual(rangeEnd.withPrefix(prefix)), firstGreaterOrEqual(strinc(prefix)), 1, Snapshot::True, Reverse::False);
															#line 343 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			verified = taskBucket->keepRunning(tr, task);
															#line 345 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_4 = checkDatabaseLock(tr, BinaryReader::fromStringRef<UID>( task->params[BackupAgentBase::keyConfigLogUid], Unversioned()));
															#line 345 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1863 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2loopBody1cont1loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 5;
															#line 345 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 4, Void >*>(static_cast<_executeActor*>(this)));
															#line 1868 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 459 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_9 = tr->onError(e);
															#line 459 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1905 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 2)); else return a_body1cont2loopBody1cont1loopBody1Catch1when1(__when_expr_9.get(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 10;
															#line 459 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 9, Void >*>(static_cast<_executeActor*>(this)));
															#line 1910 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 348 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_5 = success(backupVersions) && success(logVersionValue) && success(rangeCountValue) && success(prevRange) && success(nextRange) && success(verified);
															#line 348 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1927 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont2loopBody1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont2loopBody1cont1loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 6;
															#line 348 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 5, Void >*>(static_cast<_executeActor*>(this)));
															#line 1932 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 348 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_5 = success(backupVersions) && success(logVersionValue) && success(rangeCountValue) && success(prevRange) && success(nextRange) && success(verified);
															#line 348 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1943 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont2loopBody1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont2loopBody1cont1loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 6;
															#line 348 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 5, Void >*>(static_cast<_executeActor*>(this)));
															#line 1948 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _executeActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _executeActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont2loopBody1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 351 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		int64_t rangeCount = 0;
															#line 352 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (rangeCountValue.get().present())
															#line 2034 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 353 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			ASSERT(rangeCountValue.get().get().size() == sizeof(int64_t));
															#line 354 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			memcpy(&rangeCount, rangeCountValue.get().get().begin(), rangeCountValue.get().get().size());
															#line 2040 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
															#line 357 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		bool prevAdjacent = prevRange.get().size() && prevRange.get()[0].value.size() && BinaryReader::fromStringRef<Version>(prevRange.get()[0].value, Unversioned()) != invalidVersion;
															#line 360 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		bool nextAdjacent = nextRange.get().size() && nextRange.get()[0].value.size() && BinaryReader::fromStringRef<Version>(nextRange.get()[0].value, Unversioned()) != invalidVersion;
															#line 364 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if ((!prevAdjacent || !nextAdjacent) && rangeCount > ((prevAdjacent || nextAdjacent) ? CLIENT_KNOBS->BACKUP_MAP_KEY_UPPER_LIMIT : CLIENT_KNOBS->BACKUP_MAP_KEY_LOWER_LIMIT) && (!g_network->isSimulated() || (isGeneralBuggifyEnabled() && !g_simulator->speedUpSimulation)))
															#line 2048 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 368 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			CODE_PROBE(true, "range insert delayed because versionMap is too large");
															#line 370 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (rangeCount > CLIENT_KNOBS->BACKUP_MAP_KEY_UPPER_LIMIT)
															#line 2054 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 371 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				TraceEvent(SevWarnAlways, "DBA_KeyRangeMapTooLarge").log();
															#line 2058 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
															#line 373 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_6 = delay(1);
															#line 373 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2064 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont2loopBody1cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont2loopBody1cont1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 7;
															#line 373 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 6, Void >*>(static_cast<_executeActor*>(this)));
															#line 2069 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 351 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		int64_t rangeCount = 0;
															#line 352 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (rangeCountValue.get().present())
															#line 2085 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 353 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			ASSERT(rangeCountValue.get().get().size() == sizeof(int64_t));
															#line 354 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			memcpy(&rangeCount, rangeCountValue.get().get().begin(), rangeCountValue.get().get().size());
															#line 2091 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
															#line 357 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		bool prevAdjacent = prevRange.get().size() && prevRange.get()[0].value.size() && BinaryReader::fromStringRef<Version>(prevRange.get()[0].value, Unversioned()) != invalidVersion;
															#line 360 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		bool nextAdjacent = nextRange.get().size() && nextRange.get()[0].value.size() && BinaryReader::fromStringRef<Version>(nextRange.get()[0].value, Unversioned()) != invalidVersion;
															#line 364 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if ((!prevAdjacent || !nextAdjacent) && rangeCount > ((prevAdjacent || nextAdjacent) ? CLIENT_KNOBS->BACKUP_MAP_KEY_UPPER_LIMIT : CLIENT_KNOBS->BACKUP_MAP_KEY_LOWER_LIMIT) && (!g_network->isSimulated() || (isGeneralBuggifyEnabled() && !g_simulator->speedUpSimulation)))
															#line 2099 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 368 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			CODE_PROBE(true, "range insert delayed because versionMap is too large");
															#line 370 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (rangeCount > CLIENT_KNOBS->BACKUP_MAP_KEY_UPPER_LIMIT)
															#line 2105 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 371 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				TraceEvent(SevWarnAlways, "DBA_KeyRangeMapTooLarge").log();
															#line 2109 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
															#line 373 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_6 = delay(1);
															#line 373 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2115 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont2loopBody1cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont2loopBody1cont1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 7;
															#line 373 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 6, Void >*>(static_cast<_executeActor*>(this)));
															#line 2120 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _executeActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _executeActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont2loopBody1cont1loopBody1cont4(int loopDepth) 
	{
															#line 378 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Version logVersion = logVersionValue.get().present() ? BinaryReader::fromStringRef<Version>(logVersionValue.get().get(), Unversioned()) : ::invalidVersion;
															#line 382 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (logVersion >= values.second)
															#line 2211 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 383 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			task->params[BackupRangeTaskFunc::keyBackupRangeBeginKey] = rangeBegin;
															#line 384 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 2217 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 389 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Subspace krv(conf.get(DatabaseBackupAgent::keyRangeVersions));
															#line 390 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		versionRange = singleKeyRange(krv.pack(values.second));
															#line 391 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr->addReadConflictRange(versionRange);
															#line 392 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr->addWriteConflictRange(versionRange);
															#line 394 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		int versionLoc = 0;
															#line 395 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		std::vector<Future<Void>> setRanges;
															#line 396 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		bytesSet = 0;
															#line 398 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		for(;;) {
															#line 399 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			for(;versionLoc < backupVersions.get().size() - 1 && (backupVersions.get()[versionLoc].value.size() < sizeof(Version) || BinaryReader::fromStringRef<Version>(backupVersions.get()[versionLoc].value, Unversioned()) != invalidVersion);) {
															#line 403 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				versionLoc++;
															#line 2243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
															#line 406 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (versionLoc == backupVersions.get().size() - 1)
															#line 2247 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
				break;
			}
															#line 409 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (backupVersions.get()[versionLoc + 1].key == (removePrefix == StringRef() ? allKeys.end : strinc(removePrefix)))
															#line 2253 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 411 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				tr->clear(KeyRangeRef( backupVersions.get()[versionLoc].key.removePrefix(removePrefix).withPrefix(addPrefix), addPrefix == StringRef() ? allKeys.end : strinc(addPrefix)));
															#line 2257 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
			else
			{
															#line 415 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				tr->clear(KeyRangeRef(backupVersions.get()[versionLoc].key, backupVersions.get()[versionLoc + 1].key) .removePrefix(removePrefix) .withPrefix(addPrefix));
															#line 2263 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
															#line 421 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			setRanges.push_back(krmSetRange( tr, prefix, KeyRangeRef(backupVersions.get()[versionLoc].key, backupVersions.get()[versionLoc + 1].key), BinaryWriter::toValue(values.second, Unversioned())));
															#line 426 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			int64_t added = 1;
															#line 427 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr->atomicOp(rangeCountKey, StringRef((uint8_t*)&added, 8), MutationRef::AddValue);
															#line 429 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			for(;valueLoc < values.first.size();++valueLoc) {
															#line 430 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (values.first[valueLoc].key >= backupVersions.get()[versionLoc + 1].key)
															#line 2275 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				{
					break;
				}
															#line 433 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (values.first[valueLoc].key >= backupVersions.get()[versionLoc].key)
															#line 2281 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				{
															#line 435 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					tr->set(values.first[valueLoc].key.removePrefix(removePrefix).withPrefix(addPrefix), values.first[valueLoc].value);
															#line 437 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					bytesSet += values.first[valueLoc].expectedSize() - removePrefix.expectedSize() + addPrefix.expectedSize();
															#line 2287 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				}
			}
															#line 442 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			versionLoc++;
															#line 2292 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
															#line 445 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_7 = waitForAll(setRanges);
															#line 445 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2298 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont2loopBody1cont1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont2loopBody1cont1loopBody1cont4when1(__when_expr_7.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 8;
															#line 445 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 7, Void >*>(static_cast<_executeActor*>(this)));
															#line 2303 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[BackupRangeTaskFunc::keyBackupRangeBeginKey] = rangeBegin;
															#line 375 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 2314 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_executeActorState();
		static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[BackupRangeTaskFunc::keyBackupRangeBeginKey] = rangeBegin;
															#line 375 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 2328 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_executeActorState();
		static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _executeActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _executeActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont2loopBody1cont1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 447 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_8 = tr->commit();
															#line 447 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2417 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont2loopBody1cont1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont2loopBody1cont1loopBody1cont9when1(__when_expr_8.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 9;
															#line 447 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 8, Void >*>(static_cast<_executeActor*>(this)));
															#line 2422 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 447 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_8 = tr->commit();
															#line 447 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2433 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont2loopBody1cont1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont2loopBody1cont1loopBody1cont9when1(__when_expr_8.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 9;
															#line 447 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 8, Void >*>(static_cast<_executeActor*>(this)));
															#line 2438 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _executeActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _executeActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont2loopBody1cont1loopBody1cont19(Void const& _,int loopDepth) 
	{
															#line 448 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Params.bytesWritten().set(task, Params.bytesWritten().getOrDefault(task) + bytesSet);
															#line 451 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (backupVersions.get().more)
															#line 2524 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 452 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr->reset();
															#line 453 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			committedValueLoc = valueLoc;
															#line 454 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			rangeBegin = backupVersions.get().end()[-1].key;
															#line 2532 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
		else
		{
			return a_body1cont2loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont19cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont19(Void && _,int loopDepth) 
	{
															#line 448 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Params.bytesWritten().set(task, Params.bytesWritten().getOrDefault(task) + bytesSet);
															#line 451 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (backupVersions.get().more)
															#line 2548 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 452 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr->reset();
															#line 453 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			committedValueLoc = valueLoc;
															#line 454 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			rangeBegin = backupVersions.get().end()[-1].key;
															#line 2556 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
		else
		{
			return a_body1cont2loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont19cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont19(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont19(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont2loopBody1cont1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _executeActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont2loopBody1cont1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _executeActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont2loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont2loopBody1cont1loopBody1cont19cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 460 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		valueLoc = committedValueLoc;
															#line 2658 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 460 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		valueLoc = committedValueLoc;
															#line 2667 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont2loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _executeActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont2loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _executeActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Database cx;
															#line 210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 214 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<FlowLock> lock;
															#line 215 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Subspace conf;
															#line 236 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	double timeout;
															#line 237 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Key addPrefix;
															#line 238 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Key removePrefix;
															#line 240 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	KeyRange range;
															#line 244 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	PromiseStream<RangeResultWithVersion> results;
															#line 246 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Future<Void> rc;
															#line 248 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Key rangeBegin;
															#line 249 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Key rangeEnd;
															#line 250 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	bool endOfStream;
															#line 251 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	RangeResultWithVersion nextValues;
															#line 252 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	int64_t nextValuesSize;
															#line 258 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	RangeResultWithVersion values;
															#line 259 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	int64_t valuesSize;
															#line 286 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Error err;
															#line 315 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	int valueLoc;
															#line 316 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	int committedValueLoc;
															#line 317 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 323 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Key prefix;
															#line 325 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Key rangeCountKey;
															#line 327 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Future<RangeResult> backupVersions;
															#line 329 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Future<Optional<Value>> logVersionValue;
															#line 332 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Future<Optional<Value>> rangeCountValue;
															#line 333 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Future<RangeResult> prevRange;
															#line 338 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Future<RangeResult> nextRange;
															#line 343 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Future<Void> verified;
															#line 390 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	KeyRange versionRange;
															#line 396 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	int64_t bytesSet;
															#line 2813 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via _execute()
															#line 210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _executeActor final : public Actor<Void>, public ActorCallback< _executeActor, 0, Void >, public ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >, public ActorSingleCallback< _executeActor, 2, RangeResultWithVersion >, public ActorCallback< _executeActor, 3, Void >, public ActorCallback< _executeActor, 4, Void >, public ActorCallback< _executeActor, 5, Void >, public ActorCallback< _executeActor, 6, Void >, public ActorCallback< _executeActor, 7, Void >, public ActorCallback< _executeActor, 8, Void >, public ActorCallback< _executeActor, 9, Void >, public FastAllocated<_executeActor>, public _executeActorState<_executeActor> {
															#line 2818 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<_executeActor>::operator new;
	using FastAllocated<_executeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6069724760364112640UL, 11276186155056124160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _executeActor, 0, Void >;
friend struct ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >;
friend struct ActorSingleCallback< _executeActor, 2, RangeResultWithVersion >;
friend struct ActorCallback< _executeActor, 3, Void >;
friend struct ActorCallback< _executeActor, 4, Void >;
friend struct ActorCallback< _executeActor, 5, Void >;
friend struct ActorCallback< _executeActor, 6, Void >;
friend struct ActorCallback< _executeActor, 7, Void >;
friend struct ActorCallback< _executeActor, 8, Void >;
friend struct ActorCallback< _executeActor, 9, Void >;
															#line 210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_executeActor(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 2844 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   _executeActorState<_executeActor>(cx, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11570159100681900032UL, 1174875376554251520UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_execute");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _executeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorSingleCallback< _executeActor, 2, RangeResultWithVersion >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _executeActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _executeActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _executeActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _executeActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _executeActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _executeActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _executeActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _execute( Database const& cx, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Void>(new _executeActor(cx, taskBucket, futureBucket, task));
															#line 2885 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 467 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

																#line 2890 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via startBackupRangeInternal()
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class StartBackupRangeInternalActor>
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class StartBackupRangeInternalActorState {
															#line 2896 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	StartBackupRangeInternalActorState(Reference<ReadYourWritesTransaction> const& tr,Standalone<VectorRef<KeyRef>> const& keys,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task,Reference<TaskFuture> const& onDone) 
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   keys(keys),
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task),
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   onDone(onDone)
															#line 2913 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("startBackupRangeInternal", reinterpret_cast<unsigned long>(this));

	}
	~StartBackupRangeInternalActorState() 
	{
		fdb_probe_actor_destroy("startBackupRangeInternal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 474 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 475 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 476 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			nextKey = task->params[BackupAgentBase::keyBeginKey];
															#line 478 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			std::vector<Future<Key>> addTaskVector;
															#line 479 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			for(int idx = 0;idx < keys.size();++idx) {
															#line 480 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (nextKey != keys[idx])
															#line 2938 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				{
															#line 481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					addTaskVector.push_back( addTask(tr, taskBucket, task, nextKey, keys[idx], TaskCompletionKey::joinWith(onDone)));
															#line 2942 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				}
															#line 484 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				nextKey = keys[idx];
															#line 2946 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
															#line 487 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (nextKey != task->params[BackupAgentBase::keyEndKey])
															#line 2950 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 488 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				addTaskVector.push_back(addTask(tr, taskBucket, task, nextKey, task->params[BackupAgentBase::keyEndKey], TaskCompletionKey::joinWith(onDone)));
															#line 2954 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
															#line 496 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(addTaskVector);
															#line 496 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2960 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state = 1;
															#line 496 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartBackupRangeInternalActor, 0, Void >*>(static_cast<StartBackupRangeInternalActor*>(this)));
															#line 2965 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartBackupRangeInternalActorState();
		static_cast<StartBackupRangeInternalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 498 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<StartBackupRangeInternalActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartBackupRangeInternalActorState(); static_cast<StartBackupRangeInternalActor*>(this)->destroy(); return 0; }
															#line 2988 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<StartBackupRangeInternalActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartBackupRangeInternalActorState();
		static_cast<StartBackupRangeInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 498 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<StartBackupRangeInternalActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartBackupRangeInternalActorState(); static_cast<StartBackupRangeInternalActor*>(this)->destroy(); return 0; }
															#line 3000 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<StartBackupRangeInternalActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartBackupRangeInternalActorState();
		static_cast<StartBackupRangeInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state > 0) static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state = 0;
		static_cast<StartBackupRangeInternalActor*>(this)->ActorCallback< StartBackupRangeInternalActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartBackupRangeInternalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartBackupRangeInternalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartBackupRangeInternalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Standalone<VectorRef<KeyRef>> keys;
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> onDone;
															#line 476 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Key nextKey;
															#line 3097 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via startBackupRangeInternal()
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class StartBackupRangeInternalActor final : public Actor<Void>, public ActorCallback< StartBackupRangeInternalActor, 0, Void >, public FastAllocated<StartBackupRangeInternalActor>, public StartBackupRangeInternalActorState<StartBackupRangeInternalActor> {
															#line 3102 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<StartBackupRangeInternalActor>::operator new;
	using FastAllocated<StartBackupRangeInternalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11040201358471698944UL, 5246254092085687296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartBackupRangeInternalActor, 0, Void >;
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	StartBackupRangeInternalActor(Reference<ReadYourWritesTransaction> const& tr,Standalone<VectorRef<KeyRef>> const& keys,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task,Reference<TaskFuture> const& onDone) 
															#line 3119 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   StartBackupRangeInternalActorState<StartBackupRangeInternalActor>(tr, keys, taskBucket, futureBucket, task, onDone),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14943095139744488960UL, 2433527876298934528UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startBackupRangeInternal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartBackupRangeInternalActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> startBackupRangeInternal( Reference<ReadYourWritesTransaction> const& tr, Standalone<VectorRef<KeyRef>> const& keys, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task, Reference<TaskFuture> const& onDone ) {
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Void>(new StartBackupRangeInternalActor(tr, keys, taskBucket, futureBucket, task, onDone));
															#line 3151 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 500 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

																#line 3156 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via _finish()
															#line 501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class _finishActor>
															#line 501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActorState {
															#line 3162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task),
															#line 505 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskFuture(futureBucket->unpack(task->params[Task::reservedTaskParamKeyDone]))
															#line 3177 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActorState() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 509 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			DRConfig config(task);
															#line 510 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			int64_t bytesWritten = Params.bytesWritten().getOrDefault(task);
															#line 511 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			config.rangeBytesWritten().atomicOp(tr, bytesWritten, MutationRef::AddValue);
															#line 513 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (task->params.find(BackupRangeTaskFunc::keyAddBackupRangeTasks) != task->params.end())
															#line 3198 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 514 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = startBackupRangeInternal( tr, BinaryReader::fromStringRef<Standalone<VectorRef<KeyRef>>>( task->params[BackupRangeTaskFunc::keyAddBackupRangeTasks], IncludeVersion()), taskBucket, futureBucket, task, taskFuture) && taskBucket->finish(tr, task);
															#line 514 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3204 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_finishActor*>(this)->actor_wait_state = 1;
															#line 514 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 0, Void >*>(static_cast<_finishActor*>(this)));
															#line 3209 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 523 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (task->params.find(BackupRangeTaskFunc::keyBackupRangeBeginKey) != task->params.end() && task->params[BackupRangeTaskFunc::keyBackupRangeBeginKey] < task->params[BackupAgentBase::keyEndKey])
															#line 3216 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				{
															#line 526 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					ASSERT(taskFuture->key.size() > 0);
															#line 527 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					StrictFuture<Void> __when_expr_1 = success(BackupRangeTaskFunc::addTask(tr, taskBucket, task, task->params[BackupRangeTaskFunc::keyBackupRangeBeginKey], task->params[BackupAgentBase::keyEndKey], TaskCompletionKey::signal(taskFuture->key))) && taskBucket->finish(tr, task);
															#line 527 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3224 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<_finishActor*>(this)->actor_wait_state = 2;
															#line 527 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 1, Void >*>(static_cast<_finishActor*>(this)));
															#line 3229 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 535 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					StrictFuture<Void> __when_expr_2 = taskFuture->set(tr, taskBucket) && taskBucket->finish(tr, task);
															#line 535 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3238 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when3(__when_expr_2.get(), loopDepth); };
					static_cast<_finishActor*>(this)->actor_wait_state = 3;
															#line 535 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 2, Void >*>(static_cast<_finishActor*>(this)));
															#line 3243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
					loopDepth = 0;
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActorState();
		static_cast<_finishActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 538 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActorState(); static_cast<_finishActor*>(this)->destroy(); return 0; }
															#line 3268 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActorState();
		static_cast<_finishActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor*>(this)->actor_wait_state > 0) static_cast<_finishActor*>(this)->actor_wait_state = 0;
		static_cast<_finishActor*>(this)->ActorCallback< _finishActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_finishActor*>(this)->actor_wait_state > 0) static_cast<_finishActor*>(this)->actor_wait_state = 0;
		static_cast<_finishActor*>(this)->ActorCallback< _finishActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _finishActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _finishActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_finishActor*>(this)->actor_wait_state > 0) static_cast<_finishActor*>(this)->actor_wait_state = 0;
		static_cast<_finishActor*>(this)->ActorCallback< _finishActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _finishActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _finishActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 505 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> taskFuture;
															#line 3553 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via _finish()
															#line 501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActor final : public Actor<Void>, public ActorCallback< _finishActor, 0, Void >, public ActorCallback< _finishActor, 1, Void >, public ActorCallback< _finishActor, 2, Void >, public FastAllocated<_finishActor>, public _finishActorState<_finishActor> {
															#line 3558 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<_finishActor>::operator new;
	using FastAllocated<_finishActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(714272706477971712UL, 9764037908291827968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor, 0, Void >;
friend struct ActorCallback< _finishActor, 1, Void >;
friend struct ActorCallback< _finishActor, 2, Void >;
															#line 501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 3577 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   _finishActorState<_finishActor>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5805366160711900928UL, 534046083987129088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _finishActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _finishActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Void>(new _finishActor(tr, taskBucket, futureBucket, task));
															#line 3611 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 540 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
};
StringRef BackupRangeTaskFunc::name = "dr_backup_range"_sr;
const Key BackupRangeTaskFunc::keyAddBackupRangeTasks = "addBackupRangeTasks"_sr;
const Key BackupRangeTaskFunc::keyBackupRangeBeginKey = "backupRangeBeginKey"_sr;
REGISTER_TASKFUNC(BackupRangeTaskFunc);

struct FinishFullBackupTaskFunc : TaskFuncBase {
	static StringRef name;
	static constexpr uint32_t version = 1;

																#line 3625 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via _finish()
															#line 550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class _finishActor1>
															#line 550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActor1State {
															#line 3631 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActor1State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task),
															#line 554 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   states(Subspace(databaseBackupPrefixRange.begin) .get(BackupAgentBase::keyStates) .get(task->params[BackupAgentBase::keyConfigLogUid]))
															#line 3646 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActor1State() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 557 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = checkTaskVersion(tr, task, FinishFullBackupTaskFunc::name, FinishFullBackupTaskFunc::version);
															#line 557 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3663 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_finishActor1*>(this)->actor_wait_state = 1;
															#line 557 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 0, Void >*>(static_cast<_finishActor1*>(this)));
															#line 3668 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActor1State();
		static_cast<_finishActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 560 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Transaction srcTr(taskBucket->src);
															#line 561 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		srcTr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 562 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Version> __when_expr_1 = srcTr.getReadVersion();
															#line 562 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3697 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor1*>(this)->actor_wait_state = 2;
															#line 562 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 1, Version >*>(static_cast<_finishActor1*>(this)));
															#line 3702 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 560 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Transaction srcTr(taskBucket->src);
															#line 561 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		srcTr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 562 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Version> __when_expr_1 = srcTr.getReadVersion();
															#line 562 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3717 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor1*>(this)->actor_wait_state = 2;
															#line 562 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 1, Version >*>(static_cast<_finishActor1*>(this)));
															#line 3722 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor1*>(this)->actor_wait_state > 0) static_cast<_finishActor1*>(this)->actor_wait_state = 0;
		static_cast<_finishActor1*>(this)->ActorCallback< _finishActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Version const& readVersion,int loopDepth) 
	{
															#line 563 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr->set(states.pack(DatabaseBackupAgent::keyCopyStop), BinaryWriter::toValue(readVersion, Unversioned()));
															#line 564 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		TraceEvent("DBA_FinishFullBackup").detail("CopyStop", readVersion);
															#line 565 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = taskBucket->finish(tr, task);
															#line 565 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3812 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_finishActor1*>(this)->actor_wait_state = 3;
															#line 565 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 2, Void >*>(static_cast<_finishActor1*>(this)));
															#line 3817 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Version && readVersion,int loopDepth) 
	{
															#line 563 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr->set(states.pack(DatabaseBackupAgent::keyCopyStop), BinaryWriter::toValue(readVersion, Unversioned()));
															#line 564 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		TraceEvent("DBA_FinishFullBackup").detail("CopyStop", readVersion);
															#line 565 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = taskBucket->finish(tr, task);
															#line 565 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3832 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_finishActor1*>(this)->actor_wait_state = 3;
															#line 565 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 2, Void >*>(static_cast<_finishActor1*>(this)));
															#line 3837 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Version const& readVersion,int loopDepth) 
	{
		loopDepth = a_body1cont2(readVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Version && readVersion,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(readVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_finishActor1*>(this)->actor_wait_state > 0) static_cast<_finishActor1*>(this)->actor_wait_state = 0;
		static_cast<_finishActor1*>(this)->ActorCallback< _finishActor1, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor1, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _finishActor1, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _finishActor1, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 567 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor1State(); static_cast<_finishActor1*>(this)->destroy(); return 0; }
															#line 3921 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor1State();
		static_cast<_finishActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 567 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor1State(); static_cast<_finishActor1*>(this)->destroy(); return 0; }
															#line 3933 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor1State();
		static_cast<_finishActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_finishActor1*>(this)->actor_wait_state > 0) static_cast<_finishActor1*>(this)->actor_wait_state = 0;
		static_cast<_finishActor1*>(this)->ActorCallback< _finishActor1, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor1, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _finishActor1, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _finishActor1, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 554 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Subspace states;
															#line 4026 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via _finish()
															#line 550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActor1 final : public Actor<Void>, public ActorCallback< _finishActor1, 0, Void >, public ActorCallback< _finishActor1, 1, Version >, public ActorCallback< _finishActor1, 2, Void >, public FastAllocated<_finishActor1>, public _finishActor1State<_finishActor1> {
															#line 4031 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<_finishActor1>::operator new;
	using FastAllocated<_finishActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(714272706477971712UL, 9764037908291827968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor1, 0, Void >;
friend struct ActorCallback< _finishActor1, 1, Version >;
friend struct ActorCallback< _finishActor1, 2, Void >;
															#line 550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActor1(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 4050 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   _finishActor1State<_finishActor1>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9581808447337778176UL, 9167718057927325696UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor1, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _finishActor1, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _finishActor1, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Void>(new _finishActor1(tr, taskBucket, futureBucket, task));
															#line 4084 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 569 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

																#line 4089 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via addTask()
															#line 570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class AddTaskActor1>
															#line 570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class AddTaskActor1State {
															#line 4095 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	AddTaskActor1State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>()) 
															#line 570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   parentTask(parentTask),
															#line 570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   completionKey(completionKey),
															#line 570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   waitFor(waitFor)
															#line 4110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("addTask", reinterpret_cast<unsigned long>(this));

	}
	~AddTaskActor1State() 
	{
		fdb_probe_actor_destroy("addTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 576 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Key> __when_expr_0 = completionKey.get(tr, taskBucket);
															#line 576 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<AddTaskActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4127 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddTaskActor1*>(this)->actor_wait_state = 1;
															#line 576 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor1, 0, Key >*>(static_cast<AddTaskActor1*>(this)));
															#line 4132 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddTaskActor1State();
		static_cast<AddTaskActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key const& doneKey,int loopDepth) 
	{
															#line 577 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		auto task = makeReference<Task>(FinishFullBackupTaskFunc::name, FinishFullBackupTaskFunc::version, doneKey);
															#line 579 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		copyDefaultParameters(parentTask, task);
															#line 581 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!waitFor)
															#line 4159 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 582 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<AddTaskActor1*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId])); this->~AddTaskActor1State(); static_cast<AddTaskActor1*>(this)->destroy(); return 0; }
															#line 4163 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<AddTaskActor1*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]));
			this->~AddTaskActor1State();
			static_cast<AddTaskActor1*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 588 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitFor->onSetAddTask(tr, taskBucket, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]);
															#line 588 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<AddTaskActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4173 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTaskActor1*>(this)->actor_wait_state = 2;
															#line 588 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor1, 1, Void >*>(static_cast<AddTaskActor1*>(this)));
															#line 4178 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key && doneKey,int loopDepth) 
	{
															#line 577 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		auto task = makeReference<Task>(FinishFullBackupTaskFunc::name, FinishFullBackupTaskFunc::version, doneKey);
															#line 579 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		copyDefaultParameters(parentTask, task);
															#line 581 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!waitFor)
															#line 4191 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 582 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<AddTaskActor1*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId])); this->~AddTaskActor1State(); static_cast<AddTaskActor1*>(this)->destroy(); return 0; }
															#line 4195 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<AddTaskActor1*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]));
			this->~AddTaskActor1State();
			static_cast<AddTaskActor1*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 588 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitFor->onSetAddTask(tr, taskBucket, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]);
															#line 588 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<AddTaskActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4205 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTaskActor1*>(this)->actor_wait_state = 2;
															#line 588 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor1, 1, Void >*>(static_cast<AddTaskActor1*>(this)));
															#line 4210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Key const& doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(doneKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(doneKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddTaskActor1*>(this)->actor_wait_state > 0) static_cast<AddTaskActor1*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor1*>(this)->ActorCallback< AddTaskActor1, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor1, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddTaskActor1, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddTaskActor1, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 593 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor1*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddTaskActor1State(); static_cast<AddTaskActor1*>(this)->destroy(); return 0; }
															#line 4294 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor1*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddTaskActor1State();
		static_cast<AddTaskActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 593 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor1*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddTaskActor1State(); static_cast<AddTaskActor1*>(this)->destroy(); return 0; }
															#line 4306 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor1*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddTaskActor1State();
		static_cast<AddTaskActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddTaskActor1*>(this)->actor_wait_state > 0) static_cast<AddTaskActor1*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor1*>(this)->ActorCallback< AddTaskActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddTaskActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddTaskActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> parentTask;
															#line 570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	TaskCompletionKey completionKey;
															#line 570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> waitFor;
															#line 4399 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via addTask()
															#line 570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class AddTaskActor1 final : public Actor<Key>, public ActorCallback< AddTaskActor1, 0, Key >, public ActorCallback< AddTaskActor1, 1, Void >, public FastAllocated<AddTaskActor1>, public AddTaskActor1State<AddTaskActor1> {
															#line 4404 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<AddTaskActor1>::operator new;
	using FastAllocated<AddTaskActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2537356427516845568UL, 7488682081184314112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddTaskActor1, 0, Key >;
friend struct ActorCallback< AddTaskActor1, 1, Void >;
															#line 570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	AddTaskActor1(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>()) 
															#line 4422 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Key>(),
		   AddTaskActor1State<AddTaskActor1>(tr, taskBucket, parentTask, completionKey, waitFor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6317786373422371328UL, 9652383359500325376UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddTaskActor1, 0, Key >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddTaskActor1, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Key> addTask( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<Task> const& parentTask, TaskCompletionKey const& completionKey, Reference<TaskFuture> const& waitFor = Reference<TaskFuture>() ) {
															#line 570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Key>(new AddTaskActor1(tr, taskBucket, parentTask, completionKey, waitFor));
															#line 4455 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 595 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

	StringRef getName() const override { return name; };

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return Void();
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};
};
StringRef FinishFullBackupTaskFunc::name = "dr_finish_full_backup"_sr;
REGISTER_TASKFUNC(FinishFullBackupTaskFunc);

struct EraseLogRangeTaskFunc : TaskFuncBase {
	static StringRef name;
	static constexpr uint32_t version = 1;

	StringRef getName() const override { return name; };

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return _execute(cx, tb, fb, task);
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};

																#line 4497 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via _execute()
															#line 633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class _executeActor1>
															#line 633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _executeActor1State {
															#line 4503 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_executeActor1State(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : cx(cx),
															#line 633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task),
															#line 637 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   lock(CLIENT_KNOBS->BACKUP_LOCK_BYTES)
															#line 4518 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_execute", reinterpret_cast<unsigned long>(this));

	}
	~_executeActor1State() 
	{
		fdb_probe_actor_destroy("_execute", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 639 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = checkTaskVersion(cx, task, EraseLogRangeTaskFunc::name, EraseLogRangeTaskFunc::version);
															#line 639 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4535 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_executeActor1*>(this)->actor_wait_state = 1;
															#line 639 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _executeActor1, 0, Void >*>(static_cast<_executeActor1*>(this)));
															#line 4540 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_executeActor1State();
		static_cast<_executeActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 641 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(taskBucket->src));
															#line 642 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		;
															#line 4565 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 641 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(taskBucket->src));
															#line 642 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		;
															#line 4576 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_executeActor1*>(this)->actor_wait_state > 0) static_cast<_executeActor1*>(this)->actor_wait_state = 0;
		static_cast<_executeActor1*>(this)->ActorCallback< _executeActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _executeActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _executeActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 644 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			Version endVersion = BinaryReader::fromStringRef<Version>( task->params[DatabaseBackupAgent::keyEndVersion], Unversioned());
															#line 646 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_1 = eraseLogData( tr, task->params[BackupAgentBase::keyConfigLogUid], task->params[BackupAgentBase::destUid], Optional<Version>(endVersion), CheckBackupUID::True, BinaryReader::fromStringRef<Version>(task->params[BackupAgentBase::keyFolderId], Unversioned()));
															#line 646 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor1*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4672 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_executeActor1*>(this)->actor_wait_state = 2;
															#line 646 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _executeActor1, 1, Void >*>(static_cast<_executeActor1*>(this)));
															#line 4677 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 656 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 656 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4701 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<_executeActor1*>(this)->actor_wait_state = 4;
															#line 656 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _executeActor1, 3, Void >*>(static_cast<_executeActor1*>(this)));
															#line 4706 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 653 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 653 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor1*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4723 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_executeActor1*>(this)->actor_wait_state = 3;
															#line 653 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _executeActor1, 2, Void >*>(static_cast<_executeActor1*>(this)));
															#line 4728 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 653 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 653 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor1*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4739 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_executeActor1*>(this)->actor_wait_state = 3;
															#line 653 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _executeActor1, 2, Void >*>(static_cast<_executeActor1*>(this)));
															#line 4744 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_executeActor1*>(this)->actor_wait_state > 0) static_cast<_executeActor1*>(this)->actor_wait_state = 0;
		static_cast<_executeActor1*>(this)->ActorCallback< _executeActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _executeActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _executeActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 654 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_executeActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActor1State(); static_cast<_executeActor1*>(this)->destroy(); return 0; }
															#line 4828 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_executeActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~_executeActor1State();
		static_cast<_executeActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 654 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_executeActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActor1State(); static_cast<_executeActor1*>(this)->destroy(); return 0; }
															#line 4840 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_executeActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~_executeActor1State();
		static_cast<_executeActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_executeActor1*>(this)->actor_wait_state > 0) static_cast<_executeActor1*>(this)->actor_wait_state = 0;
		static_cast<_executeActor1*>(this)->ActorCallback< _executeActor1, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor1, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _executeActor1, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _executeActor1, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_executeActor1*>(this)->actor_wait_state > 0) static_cast<_executeActor1*>(this)->actor_wait_state = 0;
		static_cast<_executeActor1*>(this)->ActorCallback< _executeActor1, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor1, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _executeActor1, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _executeActor1, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Database cx;
															#line 633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 637 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	FlowLock lock;
															#line 641 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 5022 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via _execute()
															#line 633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _executeActor1 final : public Actor<Void>, public ActorCallback< _executeActor1, 0, Void >, public ActorCallback< _executeActor1, 1, Void >, public ActorCallback< _executeActor1, 2, Void >, public ActorCallback< _executeActor1, 3, Void >, public FastAllocated<_executeActor1>, public _executeActor1State<_executeActor1> {
															#line 5027 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<_executeActor1>::operator new;
	using FastAllocated<_executeActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6069724760364112640UL, 11276186155056124160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _executeActor1, 0, Void >;
friend struct ActorCallback< _executeActor1, 1, Void >;
friend struct ActorCallback< _executeActor1, 2, Void >;
friend struct ActorCallback< _executeActor1, 3, Void >;
															#line 633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_executeActor1(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 5047 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   _executeActor1State<_executeActor1>(cx, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15509093102278866688UL, 10864454770705269760UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_execute");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _executeActor1, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _executeActor1, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _executeActor1, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _executeActor1, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _execute( Database const& cx, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 633 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Void>(new _executeActor1(cx, taskBucket, futureBucket, task));
															#line 5082 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 660 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

																#line 5087 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via addTask()
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class AddTaskActor2>
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class AddTaskActor2State {
															#line 5093 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	AddTaskActor2State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,Version const& endVersion,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>()) 
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   parentTask(parentTask),
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   endVersion(endVersion),
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   completionKey(completionKey),
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   waitFor(waitFor)
															#line 5110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("addTask", reinterpret_cast<unsigned long>(this));

	}
	~AddTaskActor2State() 
	{
		fdb_probe_actor_destroy("addTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 667 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Key> __when_expr_0 = completionKey.get(tr, taskBucket);
															#line 667 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<AddTaskActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5127 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddTaskActor2*>(this)->actor_wait_state = 1;
															#line 667 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor2, 0, Key >*>(static_cast<AddTaskActor2*>(this)));
															#line 5132 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddTaskActor2State();
		static_cast<AddTaskActor2*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key const& doneKey,int loopDepth) 
	{
															#line 668 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		auto task = makeReference<Task>(EraseLogRangeTaskFunc::name, EraseLogRangeTaskFunc::version, doneKey, 1);
															#line 670 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		copyDefaultParameters(parentTask, task);
															#line 672 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[DatabaseBackupAgent::keyBeginVersion] = BinaryWriter::toValue(1, Unversioned());
															#line 674 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[DatabaseBackupAgent::keyEndVersion] = BinaryWriter::toValue(endVersion, Unversioned());
															#line 676 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!waitFor)
															#line 5163 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 677 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<AddTaskActor2*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId])); this->~AddTaskActor2State(); static_cast<AddTaskActor2*>(this)->destroy(); return 0; }
															#line 5167 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<AddTaskActor2*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]));
			this->~AddTaskActor2State();
			static_cast<AddTaskActor2*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 683 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitFor->onSetAddTask(tr, taskBucket, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]);
															#line 683 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<AddTaskActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5177 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTaskActor2*>(this)->actor_wait_state = 2;
															#line 683 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor2, 1, Void >*>(static_cast<AddTaskActor2*>(this)));
															#line 5182 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key && doneKey,int loopDepth) 
	{
															#line 668 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		auto task = makeReference<Task>(EraseLogRangeTaskFunc::name, EraseLogRangeTaskFunc::version, doneKey, 1);
															#line 670 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		copyDefaultParameters(parentTask, task);
															#line 672 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[DatabaseBackupAgent::keyBeginVersion] = BinaryWriter::toValue(1, Unversioned());
															#line 674 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[DatabaseBackupAgent::keyEndVersion] = BinaryWriter::toValue(endVersion, Unversioned());
															#line 676 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!waitFor)
															#line 5199 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 677 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<AddTaskActor2*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId])); this->~AddTaskActor2State(); static_cast<AddTaskActor2*>(this)->destroy(); return 0; }
															#line 5203 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<AddTaskActor2*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]));
			this->~AddTaskActor2State();
			static_cast<AddTaskActor2*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 683 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitFor->onSetAddTask(tr, taskBucket, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]);
															#line 683 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<AddTaskActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5213 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTaskActor2*>(this)->actor_wait_state = 2;
															#line 683 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor2, 1, Void >*>(static_cast<AddTaskActor2*>(this)));
															#line 5218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Key const& doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(doneKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(doneKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddTaskActor2*>(this)->actor_wait_state > 0) static_cast<AddTaskActor2*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor2*>(this)->ActorCallback< AddTaskActor2, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor2, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddTaskActor2, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddTaskActor2, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 688 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor2*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddTaskActor2State(); static_cast<AddTaskActor2*>(this)->destroy(); return 0; }
															#line 5302 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor2*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddTaskActor2State();
		static_cast<AddTaskActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 688 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor2*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddTaskActor2State(); static_cast<AddTaskActor2*>(this)->destroy(); return 0; }
															#line 5314 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor2*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddTaskActor2State();
		static_cast<AddTaskActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddTaskActor2*>(this)->actor_wait_state > 0) static_cast<AddTaskActor2*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor2*>(this)->ActorCallback< AddTaskActor2, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor2, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddTaskActor2, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddTaskActor2, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> parentTask;
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version endVersion;
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	TaskCompletionKey completionKey;
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> waitFor;
															#line 5409 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via addTask()
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class AddTaskActor2 final : public Actor<Key>, public ActorCallback< AddTaskActor2, 0, Key >, public ActorCallback< AddTaskActor2, 1, Void >, public FastAllocated<AddTaskActor2>, public AddTaskActor2State<AddTaskActor2> {
															#line 5414 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<AddTaskActor2>::operator new;
	using FastAllocated<AddTaskActor2>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2537356427516845568UL, 7488682081184314112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddTaskActor2, 0, Key >;
friend struct ActorCallback< AddTaskActor2, 1, Void >;
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	AddTaskActor2(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,Version const& endVersion,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>()) 
															#line 5432 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Key>(),
		   AddTaskActor2State<AddTaskActor2>(tr, taskBucket, parentTask, endVersion, completionKey, waitFor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10478593657003521024UL, 14894439600537872896UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddTaskActor2, 0, Key >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddTaskActor2, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Key> addTask( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<Task> const& parentTask, Version const& endVersion, TaskCompletionKey const& completionKey, Reference<TaskFuture> const& waitFor = Reference<TaskFuture>() ) {
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Key>(new AddTaskActor2(tr, taskBucket, parentTask, endVersion, completionKey, waitFor));
															#line 5465 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 690 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

																#line 5470 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via _finish()
															#line 691 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class _finishActor2>
															#line 691 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActor2State {
															#line 5476 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 691 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActor2State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 691 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 691 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 691 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 691 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 691 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task),
															#line 696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskFuture(futureBucket->unpack(task->params[Task::reservedTaskParamKeyDone]))
															#line 5491 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActor2State() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 698 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = taskFuture->set(tr, taskBucket) && taskBucket->finish(tr, task);
															#line 698 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_finishActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5508 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_finishActor2*>(this)->actor_wait_state = 1;
															#line 698 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor2, 0, Void >*>(static_cast<_finishActor2*>(this)));
															#line 5513 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActor2State();
		static_cast<_finishActor2*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 699 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor2State(); static_cast<_finishActor2*>(this)->destroy(); return 0; }
															#line 5536 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor2State();
		static_cast<_finishActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 699 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor2State(); static_cast<_finishActor2*>(this)->destroy(); return 0; }
															#line 5548 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor2State();
		static_cast<_finishActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor2*>(this)->actor_wait_state > 0) static_cast<_finishActor2*>(this)->actor_wait_state = 0;
		static_cast<_finishActor2*>(this)->ActorCallback< _finishActor2, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor2, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor2, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor2, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 691 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 691 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 691 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 691 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> taskFuture;
															#line 5641 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via _finish()
															#line 691 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActor2 final : public Actor<Void>, public ActorCallback< _finishActor2, 0, Void >, public FastAllocated<_finishActor2>, public _finishActor2State<_finishActor2> {
															#line 5646 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<_finishActor2>::operator new;
	using FastAllocated<_finishActor2>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(714272706477971712UL, 9764037908291827968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor2, 0, Void >;
															#line 691 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActor2(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 5663 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   _finishActor2State<_finishActor2>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16767394040870899712UL, 11388961073437408512UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor2, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 691 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 691 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Void>(new _finishActor2(tr, taskBucket, futureBucket, task));
															#line 5695 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 701 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
};
StringRef EraseLogRangeTaskFunc::name = "dr_erase_log_range"_sr;
REGISTER_TASKFUNC(EraseLogRangeTaskFunc);

struct CopyLogRangeTaskFunc : TaskFuncBase {
	static StringRef name;
	static constexpr uint32_t version = 1;

	static struct {
		static TaskParam<int64_t> bytesWritten() { return __FUNCTION__sr; }
	} Params;

	static const Key keyNextBeginVersion;

	StringRef getName() const override { return name; };

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return _execute(cx, tb, fb, task);
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};

	// store mutation data from results until the end of stream or the timeout. If breaks on timeout returns the first
	// uncopied version
																#line 5730 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via dumpData()
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class DumpDataActor>
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class DumpDataActorState {
															#line 5736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	DumpDataActorState(Database const& cx,Reference<Task> const& task,PromiseStream<RCGroup> const& results,FlowLock* const& lock,Reference<TaskBucket> const& tb,double const& breakTime) 
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : cx(cx),
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task),
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   results(results),
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   lock(lock),
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   tb(tb),
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   breakTime(breakTime),
															#line 738 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   endOfStream(false),
															#line 739 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   conf(Subspace(databaseBackupPrefixRange.begin) .get(BackupAgentBase::keyConfig) .get(task->params[BackupAgentBase::keyConfigLogUid])),
															#line 742 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   nextMutations(),
															#line 743 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   isTimeoutOccurred(false),
															#line 744 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   lastKey(),
															#line 745 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   lastVersion(),
															#line 746 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   nextMutationSize(0)
															#line 5767 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("dumpData", reinterpret_cast<unsigned long>(this));

	}
	~DumpDataActorState() 
	{
		fdb_probe_actor_destroy("dumpData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 747 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			;
															#line 5782 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DumpDataActorState();
		static_cast<DumpDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 749 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (endOfStream && !nextMutationSize)
															#line 5813 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 750 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (!static_cast<DumpDataActor*>(this)->SAV<Optional<Version>>::futures) { (void)(Optional<Version>()); this->~DumpDataActorState(); static_cast<DumpDataActor*>(this)->destroy(); return 0; }
															#line 5817 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				new (&static_cast<DumpDataActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(Optional<Version>());
				this->~DumpDataActorState();
				static_cast<DumpDataActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			mutations = std::move(nextMutations);
															#line 754 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			mutationSize = nextMutationSize;
															#line 755 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			nextMutations = std::vector<RangeResult>();
															#line 756 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			nextMutationSize = 0;
															#line 758 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!endOfStream)
															#line 5833 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 759 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				;
															#line 5837 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				loopDepth = a_body1loopBody1loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 843 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (e.code() == error_code_actor_cancelled || e.code() == error_code_backup_error)
															#line 5864 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 844 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5868 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
															#line 846 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			err = e;
															#line 847 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_4 = logError(cx, Subspace(databaseBackupPrefixRange.begin) .get(BackupAgentBase::keyErrors) .pack(task->params[BackupAgentBase::keyConfigLogUid]), format("ERROR: Failed to dump mutations because of error %s", err.what()));
															#line 847 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<DumpDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5876 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<DumpDataActor*>(this)->actor_wait_state = 5;
															#line 847 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DumpDataActor, 4, Void >*>(static_cast<DumpDataActor*>(this)));
															#line 5881 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 786 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		nextVersionAfterBreak = Optional<Version>();
															#line 787 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr = Transaction(cx);
															#line 789 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		;
															#line 5900 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 761 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			auto __when_expr_0 = results.getFuture();
															#line 5923 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<RCGroup>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<RCGroup>>::value, "invalid type");
															#line 761 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<DumpDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5927 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<DumpDataActor*>(this)->actor_wait_state = 1;
															#line 761 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< DumpDataActor, 0, RCGroup >*>(static_cast<DumpDataActor*>(this)));
															#line 5932 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 775 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			error = e;
															#line 776 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 5969 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 777 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				endOfStream = true;
															#line 5973 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 781 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			return a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
															#line 5978 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(RCGroup const& group,int loopDepth) 
	{
															#line 762 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		lock->release(group.items.expectedSize());
															#line 764 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		int vecSize = group.items.expectedSize();
															#line 765 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (mutationSize + vecSize >= CLIENT_KNOBS->BACKUP_LOG_WRITE_BATCH_MAX_SIZE)
															#line 5996 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 767 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			nextMutations.push_back(group.items);
															#line 768 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			nextMutationSize = vecSize;
															#line 6002 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 772 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		mutations.push_back(group.items);
															#line 773 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		mutationSize += vecSize;
															#line 6009 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(RCGroup && group,int loopDepth) 
	{
															#line 762 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		lock->release(group.items.expectedSize());
															#line 764 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		int vecSize = group.items.expectedSize();
															#line 765 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (mutationSize + vecSize >= CLIENT_KNOBS->BACKUP_LOG_WRITE_BATCH_MAX_SIZE)
															#line 6022 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 767 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			nextMutations.push_back(group.items);
															#line 768 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			nextMutationSize = vecSize;
															#line 6028 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 772 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		mutations.push_back(group.items);
															#line 773 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		mutationSize += vecSize;
															#line 6035 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RCGroup const& group,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(group, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RCGroup && group,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(group), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DumpDataActor*>(this)->actor_wait_state > 0) static_cast<DumpDataActor*>(this)->actor_wait_state = 0;
		static_cast<DumpDataActor*>(this)->ActorSingleCallback< DumpDataActor, 0, RCGroup >::remove();

	}
	void a_callback_fire(ActorSingleCallback< DumpDataActor, 0, RCGroup >*,RCGroup const& value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< DumpDataActor, 0, RCGroup >*,RCGroup && value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< DumpDataActor, 0, RCGroup >*,Error err) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 831 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (nextVersionAfterBreak.present())
															#line 6132 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 832 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<DumpDataActor*>(this)->SAV<Optional<Version>>::futures) { (void)(nextVersionAfterBreak); this->~DumpDataActorState(); static_cast<DumpDataActor*>(this)->destroy(); return 0; }
															#line 6136 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<DumpDataActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(std::move(nextVersionAfterBreak)); // state_var_RVO
			this->~DumpDataActorState();
			static_cast<DumpDataActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 834 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!isTimeoutOccurred && timer_monotonic() >= breakTime && lastKey.present())
															#line 6144 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 839 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			lastVersion = getLogKeyVersion(lastKey.get());
															#line 840 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			isTimeoutOccurred = true;
															#line 6150 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 791 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 792 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr.trState->options.sizeLimit = 2 * CLIENT_KNOBS->TRANSACTION_SIZE_LIMIT;
															#line 793 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_1 = checkDatabaseLock(&tr, BinaryReader::fromStringRef<UID>( task->params[BackupAgentBase::keyConfigLogUid], Unversioned()));
															#line 793 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<DumpDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6174 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont2loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DumpDataActor*>(this)->actor_wait_state = 2;
															#line 793 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DumpDataActor, 1, Void >*>(static_cast<DumpDataActor*>(this)));
															#line 6179 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 828 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 828 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<DumpDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6216 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<DumpDataActor*>(this)->actor_wait_state = 4;
															#line 828 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DumpDataActor, 3, Void >*>(static_cast<DumpDataActor*>(this)));
															#line 6221 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 796 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		bytesSet = 0;
															#line 798 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		bool first = true;
															#line 799 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		for( auto m : mutations ) {
															#line 800 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			for( auto kv : m ) {
															#line 801 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (isTimeoutOccurred)
															#line 6244 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				{
															#line 802 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					Version newVersion = getLogKeyVersion(kv.key);
															#line 804 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					if (newVersion > lastVersion)
															#line 6250 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
					{
															#line 805 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
						nextVersionAfterBreak = newVersion;
															#line 6254 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
						break;
					}
				}
															#line 809 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (first)
															#line 6260 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				{
															#line 810 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					tr.addReadConflictRange(singleKeyRange(kv.key));
															#line 811 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					first = false;
															#line 6266 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				}
															#line 813 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				tr.set(kv.key.removePrefix(backupLogKeys.begin) .removePrefix(task->params[BackupAgentBase::destUid]) .withPrefix(task->params[BackupAgentBase::keyConfigLogUid]) .withPrefix(applyLogKeys.begin), kv.value);
															#line 818 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				bytesSet += kv.expectedSize() - backupLogKeys.begin.expectedSize() + applyLogKeys.begin.expectedSize();
															#line 820 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				lastKey = kv.key;
															#line 6274 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
		}
															#line 824 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 824 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<DumpDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6281 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DumpDataActor*>(this)->actor_wait_state = 3;
															#line 824 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DumpDataActor, 2, Void >*>(static_cast<DumpDataActor*>(this)));
															#line 6286 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 796 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		bytesSet = 0;
															#line 798 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		bool first = true;
															#line 799 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		for( auto m : mutations ) {
															#line 800 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			for( auto kv : m ) {
															#line 801 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (isTimeoutOccurred)
															#line 6303 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				{
															#line 802 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					Version newVersion = getLogKeyVersion(kv.key);
															#line 804 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					if (newVersion > lastVersion)
															#line 6309 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
					{
															#line 805 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
						nextVersionAfterBreak = newVersion;
															#line 6313 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
						break;
					}
				}
															#line 809 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (first)
															#line 6319 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				{
															#line 810 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					tr.addReadConflictRange(singleKeyRange(kv.key));
															#line 811 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					first = false;
															#line 6325 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				}
															#line 813 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				tr.set(kv.key.removePrefix(backupLogKeys.begin) .removePrefix(task->params[BackupAgentBase::destUid]) .withPrefix(task->params[BackupAgentBase::keyConfigLogUid]) .withPrefix(applyLogKeys.begin), kv.value);
															#line 818 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				bytesSet += kv.expectedSize() - backupLogKeys.begin.expectedSize() + applyLogKeys.begin.expectedSize();
															#line 820 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				lastKey = kv.key;
															#line 6333 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
		}
															#line 824 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 824 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<DumpDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6340 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DumpDataActor*>(this)->actor_wait_state = 3;
															#line 824 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DumpDataActor, 2, Void >*>(static_cast<DumpDataActor*>(this)));
															#line 6345 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DumpDataActor*>(this)->actor_wait_state > 0) static_cast<DumpDataActor*>(this)->actor_wait_state = 0;
		static_cast<DumpDataActor*>(this)->ActorCallback< DumpDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DumpDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DumpDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 825 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Params.bytesWritten().set(task, Params.bytesWritten().getOrDefault(task) + bytesSet);
															#line 6429 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 825 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Params.bytesWritten().set(task, Params.bytesWritten().getOrDefault(task) + bytesSet);
															#line 6438 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DumpDataActor*>(this)->actor_wait_state > 0) static_cast<DumpDataActor*>(this)->actor_wait_state = 0;
		static_cast<DumpDataActor*>(this)->ActorCallback< DumpDataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpDataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DumpDataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DumpDataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DumpDataActor*>(this)->actor_wait_state > 0) static_cast<DumpDataActor*>(this)->actor_wait_state = 0;
		static_cast<DumpDataActor*>(this)->ActorCallback< DumpDataActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpDataActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DumpDataActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DumpDataActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 853 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 6622 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 853 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 6630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DumpDataActor*>(this)->actor_wait_state > 0) static_cast<DumpDataActor*>(this)->actor_wait_state = 0;
		static_cast<DumpDataActor*>(this)->ActorCallback< DumpDataActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpDataActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DumpDataActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DumpDataActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Database cx;
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	PromiseStream<RCGroup> results;
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	FlowLock* lock;
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> tb;
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	double breakTime;
															#line 738 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	bool endOfStream;
															#line 739 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Subspace conf;
															#line 742 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	std::vector<RangeResult> nextMutations;
															#line 743 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	bool isTimeoutOccurred;
															#line 744 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Optional<KeyRef> lastKey;
															#line 745 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version lastVersion;
															#line 746 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	int64_t nextMutationSize;
															#line 753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	std::vector<RangeResult> mutations;
															#line 754 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	int64_t mutationSize;
															#line 775 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Error error;
															#line 786 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Optional<Version> nextVersionAfterBreak;
															#line 787 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Transaction tr;
															#line 796 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	int64_t bytesSet;
															#line 846 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Error err;
															#line 6749 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via dumpData()
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class DumpDataActor final : public Actor<Optional<Version>>, public ActorSingleCallback< DumpDataActor, 0, RCGroup >, public ActorCallback< DumpDataActor, 1, Void >, public ActorCallback< DumpDataActor, 2, Void >, public ActorCallback< DumpDataActor, 3, Void >, public ActorCallback< DumpDataActor, 4, Void >, public FastAllocated<DumpDataActor>, public DumpDataActorState<DumpDataActor> {
															#line 6754 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<DumpDataActor>::operator new;
	using FastAllocated<DumpDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13333241290217181184UL, 4223515052577509632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Version>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< DumpDataActor, 0, RCGroup >;
friend struct ActorCallback< DumpDataActor, 1, Void >;
friend struct ActorCallback< DumpDataActor, 2, Void >;
friend struct ActorCallback< DumpDataActor, 3, Void >;
friend struct ActorCallback< DumpDataActor, 4, Void >;
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	DumpDataActor(Database const& cx,Reference<Task> const& task,PromiseStream<RCGroup> const& results,FlowLock* const& lock,Reference<TaskBucket> const& tb,double const& breakTime) 
															#line 6775 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Optional<Version>>(),
		   DumpDataActorState<DumpDataActor>(cx, task, results, lock, tb, breakTime),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3603451714950160896UL, 4830336867570731264UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dumpData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< DumpDataActor, 0, RCGroup >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DumpDataActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DumpDataActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DumpDataActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DumpDataActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Optional<Version>> dumpData( Database const& cx, Reference<Task> const& task, PromiseStream<RCGroup> const& results, FlowLock* const& lock, Reference<TaskBucket> const& tb, double const& breakTime ) {
															#line 732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Optional<Version>>(new DumpDataActor(cx, task, results, lock, tb, breakTime));
															#line 6811 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 857 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

																#line 6816 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via _execute()
															#line 858 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class _executeActor2>
															#line 858 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _executeActor2State {
															#line 6822 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 858 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_executeActor2State(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 858 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 858 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : cx(cx),
															#line 858 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 858 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 858 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task)
															#line 6835 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_execute", reinterpret_cast<unsigned long>(this));

	}
	~_executeActor2State() 
	{
		fdb_probe_actor_destroy("_execute", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 864 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = checkTaskVersion(cx, task, CopyLogRangeTaskFunc::name, CopyLogRangeTaskFunc::version);
															#line 864 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6852 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_executeActor2*>(this)->actor_wait_state = 1;
															#line 864 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _executeActor2, 0, Void >*>(static_cast<_executeActor2*>(this)));
															#line 6857 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_executeActor2State();
		static_cast<_executeActor2*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 866 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		beginVersion = BinaryReader::fromStringRef<Version>(task->params[DatabaseBackupAgent::keyBeginVersion], Unversioned());
															#line 868 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		endVersion = BinaryReader::fromStringRef<Version>(task->params[DatabaseBackupAgent::keyEndVersion], Unversioned());
															#line 871 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Version newEndVersion = std::min(endVersion, (((beginVersion - 1) / CLIENT_KNOBS->COPY_LOG_BLOCK_SIZE) + 1 + CLIENT_KNOBS->COPY_LOG_BLOCKS_PER_TASK + (g_network->isSimulated() ? CLIENT_KNOBS->BACKUP_SIM_COPY_LOG_RANGES : 0)) * CLIENT_KNOBS->COPY_LOG_BLOCK_SIZE);
															#line 877 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		ranges = getLogRanges( beginVersion, newEndVersion, task->params[BackupAgentBase::destUid], CLIENT_KNOBS->COPY_LOG_BLOCK_SIZE);
															#line 879 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		nRanges = ranges.size();
															#line 881 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		results = std::vector<PromiseStream<RCGroup>>();
															#line 882 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		rc = std::vector<Future<Void>>();
															#line 883 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		locks = std::vector<Reference<FlowLock>>();
															#line 884 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		nextVersion = beginVersion;
															#line 885 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		breakTime = timer_monotonic() + CLIENT_KNOBS->COPY_LOG_TASK_DURATION_NANOS;
															#line 886 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		rangeN = 0;
															#line 888 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		;
															#line 6902 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 866 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		beginVersion = BinaryReader::fromStringRef<Version>(task->params[DatabaseBackupAgent::keyBeginVersion], Unversioned());
															#line 868 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		endVersion = BinaryReader::fromStringRef<Version>(task->params[DatabaseBackupAgent::keyEndVersion], Unversioned());
															#line 871 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Version newEndVersion = std::min(endVersion, (((beginVersion - 1) / CLIENT_KNOBS->COPY_LOG_BLOCK_SIZE) + 1 + CLIENT_KNOBS->COPY_LOG_BLOCKS_PER_TASK + (g_network->isSimulated() ? CLIENT_KNOBS->BACKUP_SIM_COPY_LOG_RANGES : 0)) * CLIENT_KNOBS->COPY_LOG_BLOCK_SIZE);
															#line 877 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		ranges = getLogRanges( beginVersion, newEndVersion, task->params[BackupAgentBase::destUid], CLIENT_KNOBS->COPY_LOG_BLOCK_SIZE);
															#line 879 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		nRanges = ranges.size();
															#line 881 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		results = std::vector<PromiseStream<RCGroup>>();
															#line 882 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		rc = std::vector<Future<Void>>();
															#line 883 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		locks = std::vector<Reference<FlowLock>>();
															#line 884 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		nextVersion = beginVersion;
															#line 885 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		breakTime = timer_monotonic() + CLIENT_KNOBS->COPY_LOG_TASK_DURATION_NANOS;
															#line 886 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		rangeN = 0;
															#line 888 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		;
															#line 6933 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_executeActor2*>(this)->actor_wait_state > 0) static_cast<_executeActor2*>(this)->actor_wait_state = 0;
		static_cast<_executeActor2*>(this)->ActorCallback< _executeActor2, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor2, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _executeActor2, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _executeActor2, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 930 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (nextVersion < endVersion)
															#line 7017 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 931 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			task->params[CopyLogRangeTaskFunc::keyNextBeginVersion] = BinaryWriter::toValue(nextVersion, Unversioned());
															#line 7021 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
															#line 933 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_executeActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActor2State(); static_cast<_executeActor2*>(this)->destroy(); return 0; }
															#line 7025 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_executeActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~_executeActor2State();
		static_cast<_executeActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 889 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (rangeN >= nRanges)
															#line 7044 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 893 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		int prefetchTo = std::min(rangeN + CLIENT_KNOBS->COPY_LOG_PREFETCH_BLOCKS, nRanges);
															#line 895 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		for(int j = results.size();j < prefetchTo;j++) {
															#line 896 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			results.push_back(PromiseStream<RCGroup>());
															#line 897 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			locks.push_back(makeReference<FlowLock>(CLIENT_KNOBS->COPY_LOG_READ_AHEAD_BYTES));
															#line 898 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			rc.push_back(readCommitted(taskBucket->src, results[j], Future<Void>(Void()), locks[j], ranges[j], decodeBKMutationLogKey, Terminator::True, AccessSystemKeys::True, LockAware::True));
															#line 7058 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
															#line 910 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Optional<Version>> __when_expr_1 = dumpData(cx, task, results[rangeN], locks[rangeN].getPtr(), taskBucket, breakTime);
															#line 910 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7064 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_executeActor2*>(this)->actor_wait_state = 2;
															#line 910 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _executeActor2, 1, Optional<Version> >*>(static_cast<_executeActor2*>(this)));
															#line 7069 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Optional<Version> const& nextVersionBr,int loopDepth) 
	{
															#line 914 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (nextVersionBr.present())
															#line 7091 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 915 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			nextVersion = nextVersionBr.get();
															#line 917 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			TraceEvent(SevInfo, "CopyLogRangeTaskFuncAborted") .detail("DurationNanos", CLIENT_KNOBS->COPY_LOG_TASK_DURATION_NANOS) .detail("RangeN", rangeN) .detail("BytesWritten", Params.bytesWritten().getOrDefault(task));
															#line 921 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			for(int j = results.size();--j >= rangeN;) {
															#line 922 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				rc[j].cancel();
															#line 7101 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 926 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		nextVersion = getLogKeyVersion(ranges[rangeN].end);
															#line 927 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		rangeN++;
															#line 7109 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Optional<Version> && nextVersionBr,int loopDepth) 
	{
															#line 914 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (nextVersionBr.present())
															#line 7118 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 915 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			nextVersion = nextVersionBr.get();
															#line 917 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			TraceEvent(SevInfo, "CopyLogRangeTaskFuncAborted") .detail("DurationNanos", CLIENT_KNOBS->COPY_LOG_TASK_DURATION_NANOS) .detail("RangeN", rangeN) .detail("BytesWritten", Params.bytesWritten().getOrDefault(task));
															#line 921 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			for(int j = results.size();--j >= rangeN;) {
															#line 922 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				rc[j].cancel();
															#line 7128 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 926 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		nextVersion = getLogKeyVersion(ranges[rangeN].end);
															#line 927 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		rangeN++;
															#line 7136 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Version> const& nextVersionBr,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(nextVersionBr, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Version> && nextVersionBr,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(nextVersionBr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_executeActor2*>(this)->actor_wait_state > 0) static_cast<_executeActor2*>(this)->actor_wait_state = 0;
		static_cast<_executeActor2*>(this)->ActorCallback< _executeActor2, 1, Optional<Version> >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor2, 1, Optional<Version> >*,Optional<Version> const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _executeActor2, 1, Optional<Version> >*,Optional<Version> && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _executeActor2, 1, Optional<Version> >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 858 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Database cx;
															#line 858 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 858 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 858 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 866 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version beginVersion;
															#line 868 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version endVersion;
															#line 877 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> ranges;
															#line 879 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	int nRanges;
															#line 881 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	std::vector<PromiseStream<RCGroup>> results;
															#line 882 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	std::vector<Future<Void>> rc;
															#line 883 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	std::vector<Reference<FlowLock>> locks;
															#line 884 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version nextVersion;
															#line 885 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	double breakTime;
															#line 886 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	int rangeN;
															#line 7244 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via _execute()
															#line 858 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _executeActor2 final : public Actor<Void>, public ActorCallback< _executeActor2, 0, Void >, public ActorCallback< _executeActor2, 1, Optional<Version> >, public FastAllocated<_executeActor2>, public _executeActor2State<_executeActor2> {
															#line 7249 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<_executeActor2>::operator new;
	using FastAllocated<_executeActor2>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6069724760364112640UL, 11276186155056124160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _executeActor2, 0, Void >;
friend struct ActorCallback< _executeActor2, 1, Optional<Version> >;
															#line 858 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_executeActor2(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 7267 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   _executeActor2State<_executeActor2>(cx, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5230257357230586624UL, 12883295346259811584UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_execute");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _executeActor2, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _executeActor2, 1, Optional<Version> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 858 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _execute( Database const& cx, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 858 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Void>(new _executeActor2(cx, taskBucket, futureBucket, task));
															#line 7300 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 935 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

																#line 7305 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via addTask()
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class AddTaskActor3>
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class AddTaskActor3State {
															#line 7311 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	AddTaskActor3State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,Version const& beginVersion,Version const& endVersion,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>()) 
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   parentTask(parentTask),
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   beginVersion(beginVersion),
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   endVersion(endVersion),
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   completionKey(completionKey),
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   waitFor(waitFor)
															#line 7330 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("addTask", reinterpret_cast<unsigned long>(this));

	}
	~AddTaskActor3State() 
	{
		fdb_probe_actor_destroy("addTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 943 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Key> __when_expr_0 = completionKey.get(tr, taskBucket);
															#line 943 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<AddTaskActor3*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7347 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddTaskActor3*>(this)->actor_wait_state = 1;
															#line 943 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor3, 0, Key >*>(static_cast<AddTaskActor3*>(this)));
															#line 7352 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddTaskActor3State();
		static_cast<AddTaskActor3*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key const& doneKey,int loopDepth) 
	{
															#line 944 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		auto task = makeReference<Task>(CopyLogRangeTaskFunc::name, CopyLogRangeTaskFunc::version, doneKey, 1);
															#line 946 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		copyDefaultParameters(parentTask, task);
															#line 948 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[DatabaseBackupAgent::keyBeginVersion] = BinaryWriter::toValue(beginVersion, Unversioned());
															#line 949 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[DatabaseBackupAgent::keyEndVersion] = BinaryWriter::toValue(endVersion, Unversioned());
															#line 951 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!waitFor)
															#line 7383 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 952 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<AddTaskActor3*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId])); this->~AddTaskActor3State(); static_cast<AddTaskActor3*>(this)->destroy(); return 0; }
															#line 7387 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<AddTaskActor3*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]));
			this->~AddTaskActor3State();
			static_cast<AddTaskActor3*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 958 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitFor->onSetAddTask(tr, taskBucket, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]);
															#line 958 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<AddTaskActor3*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7397 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTaskActor3*>(this)->actor_wait_state = 2;
															#line 958 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor3, 1, Void >*>(static_cast<AddTaskActor3*>(this)));
															#line 7402 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key && doneKey,int loopDepth) 
	{
															#line 944 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		auto task = makeReference<Task>(CopyLogRangeTaskFunc::name, CopyLogRangeTaskFunc::version, doneKey, 1);
															#line 946 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		copyDefaultParameters(parentTask, task);
															#line 948 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[DatabaseBackupAgent::keyBeginVersion] = BinaryWriter::toValue(beginVersion, Unversioned());
															#line 949 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[DatabaseBackupAgent::keyEndVersion] = BinaryWriter::toValue(endVersion, Unversioned());
															#line 951 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!waitFor)
															#line 7419 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 952 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<AddTaskActor3*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId])); this->~AddTaskActor3State(); static_cast<AddTaskActor3*>(this)->destroy(); return 0; }
															#line 7423 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<AddTaskActor3*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]));
			this->~AddTaskActor3State();
			static_cast<AddTaskActor3*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 958 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitFor->onSetAddTask(tr, taskBucket, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]);
															#line 958 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<AddTaskActor3*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7433 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTaskActor3*>(this)->actor_wait_state = 2;
															#line 958 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor3, 1, Void >*>(static_cast<AddTaskActor3*>(this)));
															#line 7438 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Key const& doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(doneKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(doneKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddTaskActor3*>(this)->actor_wait_state > 0) static_cast<AddTaskActor3*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor3*>(this)->ActorCallback< AddTaskActor3, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor3, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddTaskActor3, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddTaskActor3, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 963 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor3*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddTaskActor3State(); static_cast<AddTaskActor3*>(this)->destroy(); return 0; }
															#line 7522 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor3*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddTaskActor3State();
		static_cast<AddTaskActor3*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 963 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor3*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddTaskActor3State(); static_cast<AddTaskActor3*>(this)->destroy(); return 0; }
															#line 7534 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor3*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddTaskActor3State();
		static_cast<AddTaskActor3*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddTaskActor3*>(this)->actor_wait_state > 0) static_cast<AddTaskActor3*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor3*>(this)->ActorCallback< AddTaskActor3, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor3, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddTaskActor3, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddTaskActor3, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> parentTask;
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version beginVersion;
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version endVersion;
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	TaskCompletionKey completionKey;
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> waitFor;
															#line 7631 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via addTask()
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class AddTaskActor3 final : public Actor<Key>, public ActorCallback< AddTaskActor3, 0, Key >, public ActorCallback< AddTaskActor3, 1, Void >, public FastAllocated<AddTaskActor3>, public AddTaskActor3State<AddTaskActor3> {
															#line 7636 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<AddTaskActor3>::operator new;
	using FastAllocated<AddTaskActor3>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2537356427516845568UL, 7488682081184314112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddTaskActor3, 0, Key >;
friend struct ActorCallback< AddTaskActor3, 1, Void >;
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	AddTaskActor3(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,Version const& beginVersion,Version const& endVersion,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>()) 
															#line 7654 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Key>(),
		   AddTaskActor3State<AddTaskActor3>(tr, taskBucket, parentTask, beginVersion, endVersion, completionKey, waitFor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2853636739688481024UL, 7103262029915876352UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddTaskActor3, 0, Key >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddTaskActor3, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Key> addTask( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<Task> const& parentTask, Version const& beginVersion, Version const& endVersion, TaskCompletionKey const& completionKey, Reference<TaskFuture> const& waitFor = Reference<TaskFuture>() ) {
															#line 936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Key>(new AddTaskActor3(tr, taskBucket, parentTask, beginVersion, endVersion, completionKey, waitFor));
															#line 7687 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 965 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

																#line 7692 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via _finish()
															#line 966 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class _finishActor3>
															#line 966 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActor3State {
															#line 7698 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 966 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActor3State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 966 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 966 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 966 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 966 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 966 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task),
															#line 971 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   endVersion(BinaryReader::fromStringRef<Version>(task->params[DatabaseBackupAgent::keyEndVersion], Unversioned())),
															#line 973 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskFuture(futureBucket->unpack(task->params[Task::reservedTaskParamKeyDone]))
															#line 7715 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActor3State() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 977 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			DRConfig config(task);
															#line 978 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			int64_t bytesWritten = Params.bytesWritten().getOrDefault(task);
															#line 979 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			config.logBytesWritten().atomicOp(tr, bytesWritten, MutationRef::AddValue);
															#line 981 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (task->params.find(CopyLogRangeTaskFunc::keyNextBeginVersion) != task->params.end())
															#line 7736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 982 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				nextVersion = BinaryReader::fromStringRef<Version>( task->params[CopyLogRangeTaskFunc::keyNextBeginVersion], Unversioned());
															#line 984 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = success(CopyLogRangeTaskFunc::addTask( tr, taskBucket, task, nextVersion, endVersion, TaskCompletionKey::signal(taskFuture->key))) && taskBucket->finish(tr, task);
															#line 984 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (static_cast<_finishActor3*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7744 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_finishActor3*>(this)->actor_wait_state = 1;
															#line 984 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor3, 0, Void >*>(static_cast<_finishActor3*>(this)));
															#line 7749 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 988 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_1 = taskFuture->set(tr, taskBucket) && taskBucket->finish(tr, task);
															#line 988 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (static_cast<_finishActor3*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7758 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<_finishActor3*>(this)->actor_wait_state = 2;
															#line 988 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor3, 1, Void >*>(static_cast<_finishActor3*>(this)));
															#line 7763 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActor3State();
		static_cast<_finishActor3*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 991 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor3*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor3State(); static_cast<_finishActor3*>(this)->destroy(); return 0; }
															#line 7787 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor3*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor3State();
		static_cast<_finishActor3*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor3*>(this)->actor_wait_state > 0) static_cast<_finishActor3*>(this)->actor_wait_state = 0;
		static_cast<_finishActor3*>(this)->ActorCallback< _finishActor3, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor3, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor3, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor3, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_finishActor3*>(this)->actor_wait_state > 0) static_cast<_finishActor3*>(this)->actor_wait_state = 0;
		static_cast<_finishActor3*>(this)->ActorCallback< _finishActor3, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor3, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _finishActor3, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _finishActor3, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 966 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 966 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 966 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 966 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 971 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version endVersion;
															#line 973 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> taskFuture;
															#line 982 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version nextVersion;
															#line 7983 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via _finish()
															#line 966 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActor3 final : public Actor<Void>, public ActorCallback< _finishActor3, 0, Void >, public ActorCallback< _finishActor3, 1, Void >, public FastAllocated<_finishActor3>, public _finishActor3State<_finishActor3> {
															#line 7988 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<_finishActor3>::operator new;
	using FastAllocated<_finishActor3>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(714272706477971712UL, 9764037908291827968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor3, 0, Void >;
friend struct ActorCallback< _finishActor3, 1, Void >;
															#line 966 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActor3(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 8006 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   _finishActor3State<_finishActor3>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13023540324773855744UL, 1960782794038386688UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor3, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _finishActor3, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 966 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 966 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Void>(new _finishActor3(tr, taskBucket, futureBucket, task));
															#line 8039 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 993 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
};
StringRef CopyLogRangeTaskFunc::name = "dr_copy_log_range"_sr;
const Key CopyLogRangeTaskFunc::keyNextBeginVersion = "nextBeginVersion"_sr;
REGISTER_TASKFUNC(CopyLogRangeTaskFunc);

struct CopyLogsTaskFunc : TaskFuncBase {
	static StringRef name;
	static constexpr uint32_t version = 1;

																#line 8052 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via _finish()
															#line 1002 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class _finishActor4>
															#line 1002 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActor4State {
															#line 8058 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 1002 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActor4State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 1002 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 1002 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 1002 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 1002 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 1002 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task),
															#line 1006 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   conf(Subspace(databaseBackupPrefixRange.begin) .get(BackupAgentBase::keyConfig) .get(task->params[BackupAgentBase::keyConfigLogUid])),
															#line 1009 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   states(Subspace(databaseBackupPrefixRange.begin) .get(BackupAgentBase::keyStates) .get(task->params[BackupAgentBase::keyConfigLogUid]))
															#line 8075 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActor4State() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1012 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = checkTaskVersion(tr, task, CopyLogsTaskFunc::name, CopyLogsTaskFunc::version);
															#line 1012 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8092 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_finishActor4*>(this)->actor_wait_state = 1;
															#line 1012 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 0, Void >*>(static_cast<_finishActor4*>(this)));
															#line 8097 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActor4State();
		static_cast<_finishActor4*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1014 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		beginVersion = BinaryReader::fromStringRef<Version>(task->params[DatabaseBackupAgent::keyBeginVersion], Unversioned());
															#line 1016 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		prevBeginVersion = BinaryReader::fromStringRef<Version>(task->params[DatabaseBackupAgent::keyPrevBeginVersion], Unversioned());
															#line 1018 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		fStopValue = tr->get(states.pack(DatabaseBackupAgent::keyCopyStop));
															#line 1019 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		fAppliedValue = tr->get(task->params[BackupAgentBase::keyConfigLogUid].withPrefix(applyMutationsBeginRange.begin));
															#line 1022 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Transaction srcTr(taskBucket->src);
															#line 1023 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		srcTr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1024 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Version> __when_expr_1 = srcTr.getReadVersion();
															#line 1024 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8134 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor4*>(this)->actor_wait_state = 2;
															#line 1024 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 1, Version >*>(static_cast<_finishActor4*>(this)));
															#line 8139 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1014 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		beginVersion = BinaryReader::fromStringRef<Version>(task->params[DatabaseBackupAgent::keyBeginVersion], Unversioned());
															#line 1016 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		prevBeginVersion = BinaryReader::fromStringRef<Version>(task->params[DatabaseBackupAgent::keyPrevBeginVersion], Unversioned());
															#line 1018 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		fStopValue = tr->get(states.pack(DatabaseBackupAgent::keyCopyStop));
															#line 1019 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		fAppliedValue = tr->get(task->params[BackupAgentBase::keyConfigLogUid].withPrefix(applyMutationsBeginRange.begin));
															#line 1022 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Transaction srcTr(taskBucket->src);
															#line 1023 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		srcTr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1024 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Version> __when_expr_1 = srcTr.getReadVersion();
															#line 1024 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor4*>(this)->actor_wait_state = 2;
															#line 1024 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 1, Version >*>(static_cast<_finishActor4*>(this)));
															#line 8167 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor4*>(this)->actor_wait_state > 0) static_cast<_finishActor4*>(this)->actor_wait_state = 0;
		static_cast<_finishActor4*>(this)->ActorCallback< _finishActor4, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor4, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor4, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor4, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1026 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		onDone = futureBucket->unpack(task->params[Task::reservedTaskParamKeyDone]);
															#line 1028 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (endVersion <= beginVersion)
															#line 8253 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1029 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 1029 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8259 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<_finishActor4*>(this)->actor_wait_state = 3;
															#line 1029 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 2, Void >*>(static_cast<_finishActor4*>(this)));
															#line 8264 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Version const& __endVersion,int loopDepth) 
	{
															#line 1024 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		endVersion = __endVersion;
															#line 8278 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Version && __endVersion,int loopDepth) 
	{
		endVersion = std::move(__endVersion);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_finishActor4*>(this)->actor_wait_state > 0) static_cast<_finishActor4*>(this)->actor_wait_state = 0;
		static_cast<_finishActor4*>(this)->ActorCallback< _finishActor4, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor4, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _finishActor4, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _finishActor4, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1036 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = fAppliedValue;
															#line 1036 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8359 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<_finishActor4*>(this)->actor_wait_state = 6;
															#line 1036 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 5, Optional<Value> >*>(static_cast<_finishActor4*>(this)));
															#line 8364 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1030 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(CopyLogsTaskFunc::addTask( tr, taskBucket, task, prevBeginVersion, beginVersion, TaskCompletionKey::signal(onDone)));
															#line 1030 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8375 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<_finishActor4*>(this)->actor_wait_state = 4;
															#line 1030 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 3, Void >*>(static_cast<_finishActor4*>(this)));
															#line 8380 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1030 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(CopyLogsTaskFunc::addTask( tr, taskBucket, task, prevBeginVersion, beginVersion, TaskCompletionKey::signal(onDone)));
															#line 1030 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8391 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<_finishActor4*>(this)->actor_wait_state = 4;
															#line 1030 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 3, Void >*>(static_cast<_finishActor4*>(this)));
															#line 8396 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_finishActor4*>(this)->actor_wait_state > 0) static_cast<_finishActor4*>(this)->actor_wait_state = 0;
		static_cast<_finishActor4*>(this)->ActorCallback< _finishActor4, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor4, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _finishActor4, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _finishActor4, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1032 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = taskBucket->finish(tr, task);
															#line 1032 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8482 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<_finishActor4*>(this)->actor_wait_state = 5;
															#line 1032 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 4, Void >*>(static_cast<_finishActor4*>(this)));
															#line 8487 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1032 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = taskBucket->finish(tr, task);
															#line 1032 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8498 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<_finishActor4*>(this)->actor_wait_state = 5;
															#line 1032 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 4, Void >*>(static_cast<_finishActor4*>(this)));
															#line 8503 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_finishActor4*>(this)->actor_wait_state > 0) static_cast<_finishActor4*>(this)->actor_wait_state = 0;
		static_cast<_finishActor4*>(this)->ActorCallback< _finishActor4, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor4, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _finishActor4, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _finishActor4, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1033 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor4*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor4State(); static_cast<_finishActor4*>(this)->destroy(); return 0; }
															#line 8587 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor4*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor4State();
		static_cast<_finishActor4*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1033 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor4*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor4State(); static_cast<_finishActor4*>(this)->destroy(); return 0; }
															#line 8599 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor4*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor4State();
		static_cast<_finishActor4*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_finishActor4*>(this)->actor_wait_state > 0) static_cast<_finishActor4*>(this)->actor_wait_state = 0;
		static_cast<_finishActor4*>(this)->ActorCallback< _finishActor4, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor4, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _finishActor4, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _finishActor4, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont8(Optional<Value> const& appliedValue,int loopDepth) 
	{
															#line 1037 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		appliedVersion = appliedValue.present() ? BinaryReader::fromStringRef<Version>(appliedValue.get(), Unversioned()) : 100;
															#line 1040 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		applyVersion = std::max<Version>(appliedVersion, beginVersion - CLIENT_KNOBS->BACKUP_VERSION_DELAY);
															#line 1042 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Subspace krv = conf.get(DatabaseBackupAgent::keyRangeVersions);
															#line 1043 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		KeyRange versionRange = KeyRangeRef(krv.pack(0), krv.pack(applyVersion + 1));
															#line 1044 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr->addReadConflictRange(versionRange);
															#line 1045 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr->addWriteConflictRange(versionRange);
															#line 1046 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr->set(task->params[BackupAgentBase::keyConfigLogUid].withPrefix(applyMutationsEndRange.begin), BinaryWriter::toValue(applyVersion, Unversioned()));
															#line 1049 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_6 = fStopValue;
															#line 1049 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8702 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont8when1(__when_expr_6.get(), loopDepth); };
		static_cast<_finishActor4*>(this)->actor_wait_state = 7;
															#line 1049 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 6, Optional<Value> >*>(static_cast<_finishActor4*>(this)));
															#line 8707 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Optional<Value> && appliedValue,int loopDepth) 
	{
															#line 1037 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		appliedVersion = appliedValue.present() ? BinaryReader::fromStringRef<Version>(appliedValue.get(), Unversioned()) : 100;
															#line 1040 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		applyVersion = std::max<Version>(appliedVersion, beginVersion - CLIENT_KNOBS->BACKUP_VERSION_DELAY);
															#line 1042 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Subspace krv = conf.get(DatabaseBackupAgent::keyRangeVersions);
															#line 1043 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		KeyRange versionRange = KeyRangeRef(krv.pack(0), krv.pack(applyVersion + 1));
															#line 1044 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr->addReadConflictRange(versionRange);
															#line 1045 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr->addWriteConflictRange(versionRange);
															#line 1046 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr->set(task->params[BackupAgentBase::keyConfigLogUid].withPrefix(applyMutationsEndRange.begin), BinaryWriter::toValue(applyVersion, Unversioned()));
															#line 1049 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_6 = fStopValue;
															#line 1049 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont8when1(__when_expr_6.get(), loopDepth); };
		static_cast<_finishActor4*>(this)->actor_wait_state = 7;
															#line 1049 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 6, Optional<Value> >*>(static_cast<_finishActor4*>(this)));
															#line 8737 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Optional<Value> const& appliedValue,int loopDepth) 
	{
		loopDepth = a_body1cont8(appliedValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Optional<Value> && appliedValue,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(appliedValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_finishActor4*>(this)->actor_wait_state > 0) static_cast<_finishActor4*>(this)->actor_wait_state = 0;
		static_cast<_finishActor4*>(this)->ActorCallback< _finishActor4, 5, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor4, 5, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _finishActor4, 5, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _finishActor4, 5, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont9(Optional<Value> const& stopValue,int loopDepth) 
	{
															#line 1050 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		stopVersionData = stopValue.present() ? BinaryReader::fromStringRef<Version>(stopValue.get(), Unversioned()) : -1;
															#line 1053 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (endVersion - beginVersion > deterministicRandom()->randomInt64(0, CLIENT_KNOBS->BACKUP_VERSION_DELAY))
															#line 8823 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1054 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			TraceEvent("DBA_CopyLogs") .detail("BeginVersion", beginVersion) .detail("ApplyVersion", applyVersion) .detail("EndVersion", endVersion) .detail("StopVersionData", stopVersionData) .detail("LogUID", task->params[BackupAgentBase::keyConfigLogUid]);
															#line 8827 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
															#line 1062 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if ((stopVersionData == -1) || (stopVersionData >= applyVersion))
															#line 8831 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1063 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			allPartsDone = futureBucket->future(tr);
															#line 1064 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			std::vector<Future<Key>> addTaskVector;
															#line 1065 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			addTaskVector.push_back(CopyLogsTaskFunc::addTask( tr, taskBucket, task, beginVersion, endVersion, TaskCompletionKey::signal(onDone), allPartsDone));
															#line 1067 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			int blockSize = std::max<int>( 1, ((endVersion - beginVersion) / CLIENT_KNOBS->BACKUP_COPY_TASKS) / CLIENT_KNOBS->BACKUP_BLOCK_SIZE);
															#line 1069 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			for(int64_t vblock = beginVersion / CLIENT_KNOBS->BACKUP_BLOCK_SIZE;vblock < (endVersion + CLIENT_KNOBS->BACKUP_BLOCK_SIZE - 1) / CLIENT_KNOBS->BACKUP_BLOCK_SIZE;vblock += blockSize) {
															#line 1072 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				addTaskVector.push_back(CopyLogRangeTaskFunc::addTask( tr, taskBucket, task, std::max(beginVersion, vblock * CLIENT_KNOBS->BACKUP_BLOCK_SIZE), std::min(endVersion, (vblock + blockSize) * CLIENT_KNOBS->BACKUP_BLOCK_SIZE), TaskCompletionKey::joinWith(allPartsDone)));
															#line 8845 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
															#line 1082 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (prevBeginVersion > 0)
															#line 8849 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 1083 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				addTaskVector.push_back(EraseLogRangeTaskFunc::addTask( tr, taskBucket, task, beginVersion, TaskCompletionKey::joinWith(allPartsDone)));
															#line 8853 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
															#line 1087 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_7 = waitForAll(addTaskVector) && taskBucket->finish(tr, task);
															#line 1087 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8859 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
			static_cast<_finishActor4*>(this)->actor_wait_state = 8;
															#line 1087 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 7, Void >*>(static_cast<_finishActor4*>(this)));
															#line 8864 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1089 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (appliedVersion < applyVersion)
															#line 8871 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 1090 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_8 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 1090 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8877 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont9when2(__when_expr_8.get(), loopDepth); };
				static_cast<_finishActor4*>(this)->actor_wait_state = 9;
															#line 1090 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 8, Void >*>(static_cast<_finishActor4*>(this)));
															#line 8882 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont15(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont9(Optional<Value> && stopValue,int loopDepth) 
	{
															#line 1050 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		stopVersionData = stopValue.present() ? BinaryReader::fromStringRef<Version>(stopValue.get(), Unversioned()) : -1;
															#line 1053 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (endVersion - beginVersion > deterministicRandom()->randomInt64(0, CLIENT_KNOBS->BACKUP_VERSION_DELAY))
															#line 8899 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1054 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			TraceEvent("DBA_CopyLogs") .detail("BeginVersion", beginVersion) .detail("ApplyVersion", applyVersion) .detail("EndVersion", endVersion) .detail("StopVersionData", stopVersionData) .detail("LogUID", task->params[BackupAgentBase::keyConfigLogUid]);
															#line 8903 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
															#line 1062 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if ((stopVersionData == -1) || (stopVersionData >= applyVersion))
															#line 8907 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1063 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			allPartsDone = futureBucket->future(tr);
															#line 1064 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			std::vector<Future<Key>> addTaskVector;
															#line 1065 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			addTaskVector.push_back(CopyLogsTaskFunc::addTask( tr, taskBucket, task, beginVersion, endVersion, TaskCompletionKey::signal(onDone), allPartsDone));
															#line 1067 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			int blockSize = std::max<int>( 1, ((endVersion - beginVersion) / CLIENT_KNOBS->BACKUP_COPY_TASKS) / CLIENT_KNOBS->BACKUP_BLOCK_SIZE);
															#line 1069 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			for(int64_t vblock = beginVersion / CLIENT_KNOBS->BACKUP_BLOCK_SIZE;vblock < (endVersion + CLIENT_KNOBS->BACKUP_BLOCK_SIZE - 1) / CLIENT_KNOBS->BACKUP_BLOCK_SIZE;vblock += blockSize) {
															#line 1072 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				addTaskVector.push_back(CopyLogRangeTaskFunc::addTask( tr, taskBucket, task, std::max(beginVersion, vblock * CLIENT_KNOBS->BACKUP_BLOCK_SIZE), std::min(endVersion, (vblock + blockSize) * CLIENT_KNOBS->BACKUP_BLOCK_SIZE), TaskCompletionKey::joinWith(allPartsDone)));
															#line 8921 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
															#line 1082 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (prevBeginVersion > 0)
															#line 8925 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 1083 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				addTaskVector.push_back(EraseLogRangeTaskFunc::addTask( tr, taskBucket, task, beginVersion, TaskCompletionKey::joinWith(allPartsDone)));
															#line 8929 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
															#line 1087 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_7 = waitForAll(addTaskVector) && taskBucket->finish(tr, task);
															#line 1087 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8935 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
			static_cast<_finishActor4*>(this)->actor_wait_state = 8;
															#line 1087 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 7, Void >*>(static_cast<_finishActor4*>(this)));
															#line 8940 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1089 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (appliedVersion < applyVersion)
															#line 8947 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 1090 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_8 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 1090 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8953 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont9when2(__when_expr_8.get(), loopDepth); };
				static_cast<_finishActor4*>(this)->actor_wait_state = 9;
															#line 1090 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 8, Void >*>(static_cast<_finishActor4*>(this)));
															#line 8958 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont15(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont8when1(Optional<Value> const& stopValue,int loopDepth) 
	{
		loopDepth = a_body1cont9(stopValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Optional<Value> && stopValue,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(stopValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_finishActor4*>(this)->actor_wait_state > 0) static_cast<_finishActor4*>(this)->actor_wait_state = 0;
		static_cast<_finishActor4*>(this)->ActorCallback< _finishActor4, 6, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor4, 6, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _finishActor4, 6, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _finishActor4, 6, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 1101 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor4*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor4State(); static_cast<_finishActor4*>(this)->destroy(); return 0; }
															#line 9048 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor4*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor4State();
		static_cast<_finishActor4*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_finishActor4*>(this)->actor_wait_state > 0) static_cast<_finishActor4*>(this)->actor_wait_state = 0;
		static_cast<_finishActor4*>(this)->ActorCallback< _finishActor4, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor4, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _finishActor4, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _finishActor4, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont15(int loopDepth) 
	{
															#line 1097 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_11 = onDone->set(tr, taskBucket) && taskBucket->finish(tr, task);
															#line 1097 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont15when1(__when_expr_11.get(), loopDepth); };
		static_cast<_finishActor4*>(this)->actor_wait_state = 12;
															#line 1097 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 11, Void >*>(static_cast<_finishActor4*>(this)));
															#line 9154 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont16(Void const& _,int loopDepth) 
	{
															#line 1091 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_9 = success(CopyLogsTaskFunc::addTask( tr, taskBucket, task, prevBeginVersion, beginVersion, TaskCompletionKey::signal(onDone)));
															#line 1091 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9165 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont16when1(__when_expr_9.get(), loopDepth); };
		static_cast<_finishActor4*>(this)->actor_wait_state = 10;
															#line 1091 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 9, Void >*>(static_cast<_finishActor4*>(this)));
															#line 9170 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont16(Void && _,int loopDepth) 
	{
															#line 1091 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_9 = success(CopyLogsTaskFunc::addTask( tr, taskBucket, task, prevBeginVersion, beginVersion, TaskCompletionKey::signal(onDone)));
															#line 1091 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9181 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont16when1(__when_expr_9.get(), loopDepth); };
		static_cast<_finishActor4*>(this)->actor_wait_state = 10;
															#line 1091 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 9, Void >*>(static_cast<_finishActor4*>(this)));
															#line 9186 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_finishActor4*>(this)->actor_wait_state > 0) static_cast<_finishActor4*>(this)->actor_wait_state = 0;
		static_cast<_finishActor4*>(this)->ActorCallback< _finishActor4, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor4, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont9when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _finishActor4, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont9when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _finishActor4, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont16cont1(Void const& _,int loopDepth) 
	{
															#line 1093 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_10 = taskBucket->finish(tr, task);
															#line 1093 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9272 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont16cont1when1(__when_expr_10.get(), loopDepth); };
		static_cast<_finishActor4*>(this)->actor_wait_state = 11;
															#line 1093 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 10, Void >*>(static_cast<_finishActor4*>(this)));
															#line 9277 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont16cont1(Void && _,int loopDepth) 
	{
															#line 1093 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_10 = taskBucket->finish(tr, task);
															#line 1093 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9288 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont16cont1when1(__when_expr_10.get(), loopDepth); };
		static_cast<_finishActor4*>(this)->actor_wait_state = 11;
															#line 1093 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _finishActor4, 10, Void >*>(static_cast<_finishActor4*>(this)));
															#line 9293 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont16when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont16when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_finishActor4*>(this)->actor_wait_state > 0) static_cast<_finishActor4*>(this)->actor_wait_state = 0;
		static_cast<_finishActor4*>(this)->ActorCallback< _finishActor4, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor4, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont16when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _finishActor4, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont16when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _finishActor4, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont16cont2(Void const& _,int loopDepth) 
	{
															#line 1094 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor4*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor4State(); static_cast<_finishActor4*>(this)->destroy(); return 0; }
															#line 9377 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor4*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor4State();
		static_cast<_finishActor4*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont16cont2(Void && _,int loopDepth) 
	{
															#line 1094 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor4*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor4State(); static_cast<_finishActor4*>(this)->destroy(); return 0; }
															#line 9389 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor4*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor4State();
		static_cast<_finishActor4*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont16cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_finishActor4*>(this)->actor_wait_state > 0) static_cast<_finishActor4*>(this)->actor_wait_state = 0;
		static_cast<_finishActor4*>(this)->ActorCallback< _finishActor4, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor4, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont16cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _finishActor4, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont16cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _finishActor4, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont15cont1(Void const& _,int loopDepth) 
	{
															#line 1098 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr->set(states.pack(DatabaseBackupAgent::keyStateStop), BinaryWriter::toValue(beginVersion, Unversioned()));
															#line 9476 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont1(Void && _,int loopDepth) 
	{
															#line 1098 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr->set(states.pack(DatabaseBackupAgent::keyStateStop), BinaryWriter::toValue(beginVersion, Unversioned()));
															#line 9485 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont15when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont15when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_finishActor4*>(this)->actor_wait_state > 0) static_cast<_finishActor4*>(this)->actor_wait_state = 0;
		static_cast<_finishActor4*>(this)->ActorCallback< _finishActor4, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor4, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont15when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _finishActor4, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont15when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _finishActor4, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 1002 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1002 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1002 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 1002 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 1006 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Subspace conf;
															#line 1009 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Subspace states;
															#line 1014 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version beginVersion;
															#line 1016 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version prevBeginVersion;
															#line 1018 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Future<Optional<Value>> fStopValue;
															#line 1019 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Future<Optional<Value>> fAppliedValue;
															#line 1024 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version endVersion;
															#line 1026 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> onDone;
															#line 1037 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version appliedVersion;
															#line 1040 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version applyVersion;
															#line 1050 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version stopVersionData;
															#line 1063 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> allPartsDone;
															#line 9597 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via _finish()
															#line 1002 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActor4 final : public Actor<Void>, public ActorCallback< _finishActor4, 0, Void >, public ActorCallback< _finishActor4, 1, Version >, public ActorCallback< _finishActor4, 2, Void >, public ActorCallback< _finishActor4, 3, Void >, public ActorCallback< _finishActor4, 4, Void >, public ActorCallback< _finishActor4, 5, Optional<Value> >, public ActorCallback< _finishActor4, 6, Optional<Value> >, public ActorCallback< _finishActor4, 7, Void >, public ActorCallback< _finishActor4, 8, Void >, public ActorCallback< _finishActor4, 9, Void >, public ActorCallback< _finishActor4, 10, Void >, public ActorCallback< _finishActor4, 11, Void >, public FastAllocated<_finishActor4>, public _finishActor4State<_finishActor4> {
															#line 9602 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<_finishActor4>::operator new;
	using FastAllocated<_finishActor4>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(714272706477971712UL, 9764037908291827968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor4, 0, Void >;
friend struct ActorCallback< _finishActor4, 1, Version >;
friend struct ActorCallback< _finishActor4, 2, Void >;
friend struct ActorCallback< _finishActor4, 3, Void >;
friend struct ActorCallback< _finishActor4, 4, Void >;
friend struct ActorCallback< _finishActor4, 5, Optional<Value> >;
friend struct ActorCallback< _finishActor4, 6, Optional<Value> >;
friend struct ActorCallback< _finishActor4, 7, Void >;
friend struct ActorCallback< _finishActor4, 8, Void >;
friend struct ActorCallback< _finishActor4, 9, Void >;
friend struct ActorCallback< _finishActor4, 10, Void >;
friend struct ActorCallback< _finishActor4, 11, Void >;
															#line 1002 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActor4(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 9630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   _finishActor4State<_finishActor4>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18141819013712028160UL, 3299558216207129600UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor4, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _finishActor4, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _finishActor4, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _finishActor4, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _finishActor4, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _finishActor4, 5, Optional<Value> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _finishActor4, 6, Optional<Value> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _finishActor4, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _finishActor4, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _finishActor4, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _finishActor4, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _finishActor4, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1002 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 1002 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Void>(new _finishActor4(tr, taskBucket, futureBucket, task));
															#line 9673 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 1103 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

																#line 9678 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via addTask()
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class AddTaskActor4>
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class AddTaskActor4State {
															#line 9684 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	AddTaskActor4State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,Version const& prevBeginVersion,Version const& beginVersion,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>()) 
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   parentTask(parentTask),
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   prevBeginVersion(prevBeginVersion),
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   beginVersion(beginVersion),
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   completionKey(completionKey),
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   waitFor(waitFor)
															#line 9703 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("addTask", reinterpret_cast<unsigned long>(this));

	}
	~AddTaskActor4State() 
	{
		fdb_probe_actor_destroy("addTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1111 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Key> __when_expr_0 = completionKey.get(tr, taskBucket);
															#line 1111 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<AddTaskActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9720 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddTaskActor4*>(this)->actor_wait_state = 1;
															#line 1111 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor4, 0, Key >*>(static_cast<AddTaskActor4*>(this)));
															#line 9725 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddTaskActor4State();
		static_cast<AddTaskActor4*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key const& doneKey,int loopDepth) 
	{
															#line 1112 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		auto task = makeReference<Task>(CopyLogsTaskFunc::name, CopyLogsTaskFunc::version, doneKey, 1);
															#line 1114 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		copyDefaultParameters(parentTask, task);
															#line 1115 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[BackupAgentBase::keyBeginVersion] = BinaryWriter::toValue(beginVersion, Unversioned());
															#line 1116 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[DatabaseBackupAgent::keyPrevBeginVersion] = BinaryWriter::toValue(prevBeginVersion, Unversioned());
															#line 1118 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!waitFor)
															#line 9756 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1119 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<AddTaskActor4*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId])); this->~AddTaskActor4State(); static_cast<AddTaskActor4*>(this)->destroy(); return 0; }
															#line 9760 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<AddTaskActor4*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]));
			this->~AddTaskActor4State();
			static_cast<AddTaskActor4*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1125 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitFor->onSetAddTask(tr, taskBucket, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]);
															#line 1125 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<AddTaskActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9770 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTaskActor4*>(this)->actor_wait_state = 2;
															#line 1125 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor4, 1, Void >*>(static_cast<AddTaskActor4*>(this)));
															#line 9775 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key && doneKey,int loopDepth) 
	{
															#line 1112 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		auto task = makeReference<Task>(CopyLogsTaskFunc::name, CopyLogsTaskFunc::version, doneKey, 1);
															#line 1114 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		copyDefaultParameters(parentTask, task);
															#line 1115 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[BackupAgentBase::keyBeginVersion] = BinaryWriter::toValue(beginVersion, Unversioned());
															#line 1116 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[DatabaseBackupAgent::keyPrevBeginVersion] = BinaryWriter::toValue(prevBeginVersion, Unversioned());
															#line 1118 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!waitFor)
															#line 9792 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1119 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<AddTaskActor4*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId])); this->~AddTaskActor4State(); static_cast<AddTaskActor4*>(this)->destroy(); return 0; }
															#line 9796 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<AddTaskActor4*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]));
			this->~AddTaskActor4State();
			static_cast<AddTaskActor4*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1125 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitFor->onSetAddTask(tr, taskBucket, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]);
															#line 1125 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<AddTaskActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9806 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTaskActor4*>(this)->actor_wait_state = 2;
															#line 1125 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor4, 1, Void >*>(static_cast<AddTaskActor4*>(this)));
															#line 9811 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Key const& doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(doneKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(doneKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddTaskActor4*>(this)->actor_wait_state > 0) static_cast<AddTaskActor4*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor4*>(this)->ActorCallback< AddTaskActor4, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor4, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddTaskActor4, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddTaskActor4, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1130 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor4*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddTaskActor4State(); static_cast<AddTaskActor4*>(this)->destroy(); return 0; }
															#line 9895 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor4*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddTaskActor4State();
		static_cast<AddTaskActor4*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1130 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor4*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddTaskActor4State(); static_cast<AddTaskActor4*>(this)->destroy(); return 0; }
															#line 9907 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor4*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddTaskActor4State();
		static_cast<AddTaskActor4*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddTaskActor4*>(this)->actor_wait_state > 0) static_cast<AddTaskActor4*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor4*>(this)->ActorCallback< AddTaskActor4, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor4, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddTaskActor4, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddTaskActor4, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> parentTask;
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version prevBeginVersion;
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version beginVersion;
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	TaskCompletionKey completionKey;
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> waitFor;
															#line 10004 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via addTask()
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class AddTaskActor4 final : public Actor<Key>, public ActorCallback< AddTaskActor4, 0, Key >, public ActorCallback< AddTaskActor4, 1, Void >, public FastAllocated<AddTaskActor4>, public AddTaskActor4State<AddTaskActor4> {
															#line 10009 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<AddTaskActor4>::operator new;
	using FastAllocated<AddTaskActor4>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2537356427516845568UL, 7488682081184314112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddTaskActor4, 0, Key >;
friend struct ActorCallback< AddTaskActor4, 1, Void >;
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	AddTaskActor4(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,Version const& prevBeginVersion,Version const& beginVersion,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>()) 
															#line 10027 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Key>(),
		   AddTaskActor4State<AddTaskActor4>(tr, taskBucket, parentTask, prevBeginVersion, beginVersion, completionKey, waitFor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2898826567203880448UL, 14265219774054370560UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddTaskActor4, 0, Key >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddTaskActor4, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Key> addTask( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<Task> const& parentTask, Version const& prevBeginVersion, Version const& beginVersion, TaskCompletionKey const& completionKey, Reference<TaskFuture> const& waitFor = Reference<TaskFuture>() ) {
															#line 1104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Key>(new AddTaskActor4(tr, taskBucket, parentTask, prevBeginVersion, beginVersion, completionKey, waitFor));
															#line 10060 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 1132 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

	StringRef getName() const override { return name; };

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return Void();
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};
};
StringRef CopyLogsTaskFunc::name = "dr_copy_logs"_sr;
REGISTER_TASKFUNC(CopyLogsTaskFunc);

struct FinishedFullBackupTaskFunc : TaskFuncBase {
	static StringRef name;
	static constexpr uint32_t version = 1;
	static const Key keyInsertTask;

	StringRef getName() const override { return name; };

																#line 10090 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via _execute()
															#line 1158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class _executeActor3>
															#line 1158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _executeActor3State {
															#line 10096 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 1158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_executeActor3State(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 1158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 1158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : cx(cx),
															#line 1158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 1158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 1158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task),
															#line 1162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   sourceStates(Subspace(databaseBackupPrefixRange.begin) .get(BackupAgentBase::keySourceStates) .get(task->params[BackupAgentBase::keyConfigLogUid]))
															#line 10111 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_execute", reinterpret_cast<unsigned long>(this));

	}
	~_executeActor3State() 
	{
		fdb_probe_actor_destroy("_execute", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1166 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = checkTaskVersion(cx, task, FinishedFullBackupTaskFunc::name, FinishedFullBackupTaskFunc::version);
															#line 1166 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor3*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10128 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_executeActor3*>(this)->actor_wait_state = 1;
															#line 1166 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _executeActor3, 0, Void >*>(static_cast<_executeActor3*>(this)));
															#line 10133 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_executeActor3State();
		static_cast<_executeActor3*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1168 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr2 = Transaction(cx);
															#line 1169 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		;
															#line 10158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1168 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr2 = Transaction(cx);
															#line 1169 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		;
															#line 10169 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_executeActor3*>(this)->actor_wait_state > 0) static_cast<_executeActor3*>(this)->actor_wait_state = 0;
		static_cast<_executeActor3*>(this)->ActorCallback< _executeActor3, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor3, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _executeActor3, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _executeActor3, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1193 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(taskBucket->src));
															#line 1194 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		logUidValue = task->params[DatabaseBackupAgent::keyConfigLogUid];
															#line 1195 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		destUidValue = task->params[BackupAgentBase::destUid];
															#line 1196 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		backupUid = BinaryReader::fromStringRef<Version>(task->params[BackupAgentBase::keyFolderId], Unversioned());
															#line 1199 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		;
															#line 10261 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 1171 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr2.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1172 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr2.get(task->params[BackupAgentBase::keyConfigLogUid].withPrefix(applyMutationsBeginRange.begin));
															#line 1172 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor3*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10282 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_executeActor3*>(this)->actor_wait_state = 2;
															#line 1172 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _executeActor3, 1, Optional<Value> >*>(static_cast<_executeActor3*>(this)));
															#line 10287 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1189 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr2.onError(e);
															#line 1189 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor3*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10324 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_executeActor3*>(this)->actor_wait_state = 5;
															#line 1189 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _executeActor3, 4, Void >*>(static_cast<_executeActor3*>(this)));
															#line 10329 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Value> const& beginValue,int loopDepth) 
	{
															#line 1174 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		appliedVersion = beginValue.present() ? BinaryReader::fromStringRef<Version>(beginValue.get(), Unversioned()) : -1;
															#line 1176 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr2.get(task->params[BackupAgentBase::keyConfigLogUid].withPrefix(applyMutationsEndRange.begin));
															#line 1176 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor3*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10348 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_executeActor3*>(this)->actor_wait_state = 3;
															#line 1176 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _executeActor3, 2, Optional<Value> >*>(static_cast<_executeActor3*>(this)));
															#line 10353 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Value> && beginValue,int loopDepth) 
	{
															#line 1174 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		appliedVersion = beginValue.present() ? BinaryReader::fromStringRef<Version>(beginValue.get(), Unversioned()) : -1;
															#line 1176 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr2.get(task->params[BackupAgentBase::keyConfigLogUid].withPrefix(applyMutationsEndRange.begin));
															#line 1176 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor3*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10366 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_executeActor3*>(this)->actor_wait_state = 3;
															#line 1176 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _executeActor3, 2, Optional<Value> >*>(static_cast<_executeActor3*>(this)));
															#line 10371 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> const& beginValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(beginValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> && beginValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(beginValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_executeActor3*>(this)->actor_wait_state > 0) static_cast<_executeActor3*>(this)->actor_wait_state = 0;
		static_cast<_executeActor3*>(this)->ActorCallback< _executeActor3, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor3, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _executeActor3, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _executeActor3, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Optional<Value> const& endValue,int loopDepth) 
	{
															#line 1178 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Version endVersion = endValue.present() ? BinaryReader::fromStringRef<Version>(endValue.get(), Unversioned()) : -1;
															#line 1182 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (appliedVersion < endVersion)
															#line 10457 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1183 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 1183 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor3*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10463 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<_executeActor3*>(this)->actor_wait_state = 4;
															#line 1183 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _executeActor3, 3, Void >*>(static_cast<_executeActor3*>(this)));
															#line 10468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Optional<Value> && endValue,int loopDepth) 
	{
															#line 1178 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Version endVersion = endValue.present() ? BinaryReader::fromStringRef<Version>(endValue.get(), Unversioned()) : -1;
															#line 1182 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (appliedVersion < endVersion)
															#line 10484 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1183 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 1183 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor3*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10490 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<_executeActor3*>(this)->actor_wait_state = 4;
															#line 1183 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _executeActor3, 3, Void >*>(static_cast<_executeActor3*>(this)));
															#line 10495 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Optional<Value> const& endValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(endValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Optional<Value> && endValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(endValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_executeActor3*>(this)->actor_wait_state > 0) static_cast<_executeActor3*>(this)->actor_wait_state = 0;
		static_cast<_executeActor3*>(this)->ActorCallback< _executeActor3, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor3, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _executeActor3, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _executeActor3, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1184 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[FinishedFullBackupTaskFunc::keyInsertTask] = StringRef();
															#line 1185 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_executeActor3*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActor3State(); static_cast<_executeActor3*>(this)->destroy(); return 0; }
															#line 10592 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_executeActor3*>(this)->SAV< Void >::value()) Void(Void());
		this->~_executeActor3State();
		static_cast<_executeActor3*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1184 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[FinishedFullBackupTaskFunc::keyInsertTask] = StringRef();
															#line 1185 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_executeActor3*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActor3State(); static_cast<_executeActor3*>(this)->destroy(); return 0; }
															#line 10606 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_executeActor3*>(this)->SAV< Void >::value()) Void(Void());
		this->~_executeActor3State();
		static_cast<_executeActor3*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_executeActor3*>(this)->actor_wait_state > 0) static_cast<_executeActor3*>(this)->actor_wait_state = 0;
		static_cast<_executeActor3*>(this)->ActorCallback< _executeActor3, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor3, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _executeActor3, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _executeActor3, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_executeActor3*>(this)->actor_wait_state > 0) static_cast<_executeActor3*>(this)->actor_wait_state = 0;
		static_cast<_executeActor3*>(this)->ActorCallback< _executeActor3, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor3, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _executeActor3, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _executeActor3, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 1201 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1202 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1203 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_5 = tr->get(sourceStates.pack(DatabaseBackupAgent::keyFolderId));
															#line 1203 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor3*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10794 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont2loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_5.get(), loopDepth); };
			static_cast<_executeActor3*>(this)->actor_wait_state = 6;
															#line 1203 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _executeActor3, 5, Optional<Value> >*>(static_cast<_executeActor3*>(this)));
															#line 10799 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1213 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_8 = tr->onError(e);
															#line 1213 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor3*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10823 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_8.get(), loopDepth); };
			static_cast<_executeActor3*>(this)->actor_wait_state = 9;
															#line 1213 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _executeActor3, 8, Void >*>(static_cast<_executeActor3*>(this)));
															#line 10828 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Optional<Value> const& v,int loopDepth) 
	{
															#line 1204 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (v.present() && BinaryReader::fromStringRef<Version>(v.get(), Unversioned()) > BinaryReader::fromStringRef<Version>( task->params[DatabaseBackupAgent::keyFolderId], Unversioned()))
															#line 10843 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1207 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<_executeActor3*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActor3State(); static_cast<_executeActor3*>(this)->destroy(); return 0; }
															#line 10847 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<_executeActor3*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActor3State();
			static_cast<_executeActor3*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1209 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_6 = eraseLogData(tr, logUidValue, destUidValue, Optional<Version>(), CheckBackupUID::True, backupUid);
															#line 1209 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor3*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10857 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont2loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<_executeActor3*>(this)->actor_wait_state = 7;
															#line 1209 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _executeActor3, 6, Void >*>(static_cast<_executeActor3*>(this)));
															#line 10862 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Optional<Value> && v,int loopDepth) 
	{
															#line 1204 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (v.present() && BinaryReader::fromStringRef<Version>(v.get(), Unversioned()) > BinaryReader::fromStringRef<Version>( task->params[DatabaseBackupAgent::keyFolderId], Unversioned()))
															#line 10871 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1207 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<_executeActor3*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActor3State(); static_cast<_executeActor3*>(this)->destroy(); return 0; }
															#line 10875 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<_executeActor3*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActor3State();
			static_cast<_executeActor3*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1209 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_6 = eraseLogData(tr, logUidValue, destUidValue, Optional<Version>(), CheckBackupUID::True, backupUid);
															#line 1209 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor3*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10885 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont2loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<_executeActor3*>(this)->actor_wait_state = 7;
															#line 1209 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _executeActor3, 6, Void >*>(static_cast<_executeActor3*>(this)));
															#line 10890 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_executeActor3*>(this)->actor_wait_state > 0) static_cast<_executeActor3*>(this)->actor_wait_state = 0;
		static_cast<_executeActor3*>(this)->ActorCallback< _executeActor3, 5, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor3, 5, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _executeActor3, 5, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _executeActor3, 5, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_7 = tr->commit();
															#line 1210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor3*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10976 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont2loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont2loopBody1cont3when1(__when_expr_7.get(), loopDepth); };
		static_cast<_executeActor3*>(this)->actor_wait_state = 8;
															#line 1210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _executeActor3, 7, Void >*>(static_cast<_executeActor3*>(this)));
															#line 10981 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_7 = tr->commit();
															#line 1210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor3*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10992 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont2loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont2loopBody1cont3when1(__when_expr_7.get(), loopDepth); };
		static_cast<_executeActor3*>(this)->actor_wait_state = 8;
															#line 1210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _executeActor3, 7, Void >*>(static_cast<_executeActor3*>(this)));
															#line 10997 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_executeActor3*>(this)->actor_wait_state > 0) static_cast<_executeActor3*>(this)->actor_wait_state = 0;
		static_cast<_executeActor3*>(this)->ActorCallback< _executeActor3, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor3, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _executeActor3, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _executeActor3, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont2loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1211 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_executeActor3*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActor3State(); static_cast<_executeActor3*>(this)->destroy(); return 0; }
															#line 11081 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_executeActor3*>(this)->SAV< Void >::value()) Void(Void());
		this->~_executeActor3State();
		static_cast<_executeActor3*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1211 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_executeActor3*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActor3State(); static_cast<_executeActor3*>(this)->destroy(); return 0; }
															#line 11093 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_executeActor3*>(this)->SAV< Void >::value()) Void(Void());
		this->~_executeActor3State();
		static_cast<_executeActor3*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_executeActor3*>(this)->actor_wait_state > 0) static_cast<_executeActor3*>(this)->actor_wait_state = 0;
		static_cast<_executeActor3*>(this)->ActorCallback< _executeActor3, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor3, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _executeActor3, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _executeActor3, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_executeActor3*>(this)->actor_wait_state > 0) static_cast<_executeActor3*>(this)->actor_wait_state = 0;
		static_cast<_executeActor3*>(this)->ActorCallback< _executeActor3, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor3, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _executeActor3, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _executeActor3, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 1158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Database cx;
															#line 1158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 1158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 1162 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Subspace sourceStates;
															#line 1168 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Transaction tr2;
															#line 1174 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version appliedVersion;
															#line 1193 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1194 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Key logUidValue;
															#line 1195 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Key destUidValue;
															#line 1196 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version backupUid;
															#line 11285 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via _execute()
															#line 1158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _executeActor3 final : public Actor<Void>, public ActorCallback< _executeActor3, 0, Void >, public ActorCallback< _executeActor3, 1, Optional<Value> >, public ActorCallback< _executeActor3, 2, Optional<Value> >, public ActorCallback< _executeActor3, 3, Void >, public ActorCallback< _executeActor3, 4, Void >, public ActorCallback< _executeActor3, 5, Optional<Value> >, public ActorCallback< _executeActor3, 6, Void >, public ActorCallback< _executeActor3, 7, Void >, public ActorCallback< _executeActor3, 8, Void >, public FastAllocated<_executeActor3>, public _executeActor3State<_executeActor3> {
															#line 11290 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<_executeActor3>::operator new;
	using FastAllocated<_executeActor3>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6069724760364112640UL, 11276186155056124160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _executeActor3, 0, Void >;
friend struct ActorCallback< _executeActor3, 1, Optional<Value> >;
friend struct ActorCallback< _executeActor3, 2, Optional<Value> >;
friend struct ActorCallback< _executeActor3, 3, Void >;
friend struct ActorCallback< _executeActor3, 4, Void >;
friend struct ActorCallback< _executeActor3, 5, Optional<Value> >;
friend struct ActorCallback< _executeActor3, 6, Void >;
friend struct ActorCallback< _executeActor3, 7, Void >;
friend struct ActorCallback< _executeActor3, 8, Void >;
															#line 1158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_executeActor3(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 11315 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   _executeActor3State<_executeActor3>(cx, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5841724799347138816UL, 12852335426516358912UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_execute");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _executeActor3, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _executeActor3, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _executeActor3, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _executeActor3, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _executeActor3, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _executeActor3, 5, Optional<Value> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _executeActor3, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _executeActor3, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _executeActor3, 8, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _execute( Database const& cx, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 1158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Void>(new _executeActor3(cx, taskBucket, futureBucket, task));
															#line 11355 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 1217 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

																#line 11360 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via addTask()
															#line 1218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class AddTaskActor5>
															#line 1218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class AddTaskActor5State {
															#line 11366 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 1218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	AddTaskActor5State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>()) 
															#line 1218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 1218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 1218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 1218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   parentTask(parentTask),
															#line 1218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   completionKey(completionKey),
															#line 1218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   waitFor(waitFor)
															#line 11381 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("addTask", reinterpret_cast<unsigned long>(this));

	}
	~AddTaskActor5State() 
	{
		fdb_probe_actor_destroy("addTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1223 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Key> __when_expr_0 = completionKey.get(tr, taskBucket);
															#line 1223 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<AddTaskActor5*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11398 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddTaskActor5*>(this)->actor_wait_state = 1;
															#line 1223 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor5, 0, Key >*>(static_cast<AddTaskActor5*>(this)));
															#line 11403 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddTaskActor5State();
		static_cast<AddTaskActor5*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key const& doneKey,int loopDepth) 
	{
															#line 1224 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		auto task = makeReference<Task>(FinishedFullBackupTaskFunc::name, FinishedFullBackupTaskFunc::version, doneKey);
															#line 1226 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		copyDefaultParameters(parentTask, task);
															#line 1228 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!waitFor)
															#line 11430 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1229 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<AddTaskActor5*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId])); this->~AddTaskActor5State(); static_cast<AddTaskActor5*>(this)->destroy(); return 0; }
															#line 11434 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<AddTaskActor5*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]));
			this->~AddTaskActor5State();
			static_cast<AddTaskActor5*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1235 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitFor->onSetAddTask(tr, taskBucket, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]);
															#line 1235 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<AddTaskActor5*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11444 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTaskActor5*>(this)->actor_wait_state = 2;
															#line 1235 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor5, 1, Void >*>(static_cast<AddTaskActor5*>(this)));
															#line 11449 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key && doneKey,int loopDepth) 
	{
															#line 1224 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		auto task = makeReference<Task>(FinishedFullBackupTaskFunc::name, FinishedFullBackupTaskFunc::version, doneKey);
															#line 1226 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		copyDefaultParameters(parentTask, task);
															#line 1228 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!waitFor)
															#line 11462 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1229 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<AddTaskActor5*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId])); this->~AddTaskActor5State(); static_cast<AddTaskActor5*>(this)->destroy(); return 0; }
															#line 11466 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<AddTaskActor5*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]));
			this->~AddTaskActor5State();
			static_cast<AddTaskActor5*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1235 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitFor->onSetAddTask(tr, taskBucket, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]);
															#line 1235 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<AddTaskActor5*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11476 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTaskActor5*>(this)->actor_wait_state = 2;
															#line 1235 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor5, 1, Void >*>(static_cast<AddTaskActor5*>(this)));
															#line 11481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Key const& doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(doneKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(doneKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddTaskActor5*>(this)->actor_wait_state > 0) static_cast<AddTaskActor5*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor5*>(this)->ActorCallback< AddTaskActor5, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor5, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddTaskActor5, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddTaskActor5, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1240 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor5*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddTaskActor5State(); static_cast<AddTaskActor5*>(this)->destroy(); return 0; }
															#line 11565 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor5*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddTaskActor5State();
		static_cast<AddTaskActor5*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1240 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor5*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddTaskActor5State(); static_cast<AddTaskActor5*>(this)->destroy(); return 0; }
															#line 11577 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor5*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddTaskActor5State();
		static_cast<AddTaskActor5*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddTaskActor5*>(this)->actor_wait_state > 0) static_cast<AddTaskActor5*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor5*>(this)->ActorCallback< AddTaskActor5, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor5, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddTaskActor5, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddTaskActor5, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> parentTask;
															#line 1218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	TaskCompletionKey completionKey;
															#line 1218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> waitFor;
															#line 11670 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via addTask()
															#line 1218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class AddTaskActor5 final : public Actor<Key>, public ActorCallback< AddTaskActor5, 0, Key >, public ActorCallback< AddTaskActor5, 1, Void >, public FastAllocated<AddTaskActor5>, public AddTaskActor5State<AddTaskActor5> {
															#line 11675 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<AddTaskActor5>::operator new;
	using FastAllocated<AddTaskActor5>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2537356427516845568UL, 7488682081184314112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddTaskActor5, 0, Key >;
friend struct ActorCallback< AddTaskActor5, 1, Void >;
															#line 1218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	AddTaskActor5(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>()) 
															#line 11693 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Key>(),
		   AddTaskActor5State<AddTaskActor5>(tr, taskBucket, parentTask, completionKey, waitFor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11909323438967946496UL, 18195819240103626752UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddTaskActor5, 0, Key >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddTaskActor5, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Key> addTask( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<Task> const& parentTask, TaskCompletionKey const& completionKey, Reference<TaskFuture> const& waitFor = Reference<TaskFuture>() ) {
															#line 1218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Key>(new AddTaskActor5(tr, taskBucket, parentTask, completionKey, waitFor));
															#line 11726 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 1242 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

																#line 11731 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via _finish()
															#line 1243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class _finishActor5>
															#line 1243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActor5State {
															#line 11737 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 1243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActor5State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 1243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 1243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 1243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 1243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 1243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task),
															#line 1247 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   conf(Subspace(databaseBackupPrefixRange.begin) .get(BackupAgentBase::keyConfig) .get(task->params[BackupAgentBase::keyConfigLogUid])),
															#line 1250 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   states(Subspace(databaseBackupPrefixRange.begin) .get(BackupAgentBase::keyStates) .get(task->params[BackupAgentBase::keyConfigLogUid]))
															#line 11754 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActor5State() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1254 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (task->params.find(FinishedFullBackupTaskFunc::keyInsertTask) != task->params.end())
															#line 11769 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 1255 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				onDone = futureBucket->unpack(task->params[Task::reservedTaskParamKeyDone]);
															#line 1256 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = success(FinishedFullBackupTaskFunc::addTask(tr, taskBucket, task, TaskCompletionKey::signal(onDone)));
															#line 1256 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (static_cast<_finishActor5*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11777 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_finishActor5*>(this)->actor_wait_state = 1;
															#line 1256 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor5, 0, Void >*>(static_cast<_finishActor5*>(this)));
															#line 11782 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActor5State();
		static_cast<_finishActor5*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1261 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr->setOption(FDBTransactionOptions::COMMIT_ON_FIRST_PROXY);
															#line 1262 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		UID logUid = BinaryReader::fromStringRef<UID>(task->params[DatabaseBackupAgent::keyConfigLogUid], Unversioned());
															#line 1264 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Key logsPath = uidPrefixKey(applyLogKeys.begin, logUid);
															#line 1265 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(logsPath, strinc(logsPath)));
															#line 1267 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr->clear(conf.range());
															#line 1268 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr->set(states.pack(DatabaseBackupAgent::keyStateStatus), StringRef(BackupAgentBase::getStateText(EBackupState::STATE_COMPLETED)));
															#line 1271 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = taskBucket->finish(tr, task);
															#line 1271 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor5*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11824 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_finishActor5*>(this)->actor_wait_state = 3;
															#line 1271 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _finishActor5, 2, Void >*>(static_cast<_finishActor5*>(this)));
															#line 11829 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1257 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = taskBucket->finish(tr, task);
															#line 1257 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor5*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11840 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor5*>(this)->actor_wait_state = 2;
															#line 1257 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor5, 1, Void >*>(static_cast<_finishActor5*>(this)));
															#line 11845 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1257 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = taskBucket->finish(tr, task);
															#line 1257 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor5*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11856 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor5*>(this)->actor_wait_state = 2;
															#line 1257 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor5, 1, Void >*>(static_cast<_finishActor5*>(this)));
															#line 11861 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor5*>(this)->actor_wait_state > 0) static_cast<_finishActor5*>(this)->actor_wait_state = 0;
		static_cast<_finishActor5*>(this)->ActorCallback< _finishActor5, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor5, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor5, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor5, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1258 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor5*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor5State(); static_cast<_finishActor5*>(this)->destroy(); return 0; }
															#line 11945 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor5*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor5State();
		static_cast<_finishActor5*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1258 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor5*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor5State(); static_cast<_finishActor5*>(this)->destroy(); return 0; }
															#line 11957 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor5*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor5State();
		static_cast<_finishActor5*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_finishActor5*>(this)->actor_wait_state > 0) static_cast<_finishActor5*>(this)->actor_wait_state = 0;
		static_cast<_finishActor5*>(this)->ActorCallback< _finishActor5, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor5, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _finishActor5, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _finishActor5, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1272 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor5*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor5State(); static_cast<_finishActor5*>(this)->destroy(); return 0; }
															#line 12044 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor5*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor5State();
		static_cast<_finishActor5*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1272 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor5*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor5State(); static_cast<_finishActor5*>(this)->destroy(); return 0; }
															#line 12056 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor5*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor5State();
		static_cast<_finishActor5*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_finishActor5*>(this)->actor_wait_state > 0) static_cast<_finishActor5*>(this)->actor_wait_state = 0;
		static_cast<_finishActor5*>(this)->ActorCallback< _finishActor5, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor5, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _finishActor5, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _finishActor5, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 1243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 1247 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Subspace conf;
															#line 1250 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Subspace states;
															#line 1255 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> onDone;
															#line 12153 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via _finish()
															#line 1243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActor5 final : public Actor<Void>, public ActorCallback< _finishActor5, 0, Void >, public ActorCallback< _finishActor5, 1, Void >, public ActorCallback< _finishActor5, 2, Void >, public FastAllocated<_finishActor5>, public _finishActor5State<_finishActor5> {
															#line 12158 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<_finishActor5>::operator new;
	using FastAllocated<_finishActor5>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(714272706477971712UL, 9764037908291827968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor5, 0, Void >;
friend struct ActorCallback< _finishActor5, 1, Void >;
friend struct ActorCallback< _finishActor5, 2, Void >;
															#line 1243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActor5(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 12177 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   _finishActor5State<_finishActor5>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12383083585874896896UL, 5898184437025346304UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor5, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _finishActor5, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _finishActor5, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 1243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Void>(new _finishActor5(tr, taskBucket, futureBucket, task));
															#line 12211 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 1274 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return _execute(cx, tb, fb, task);
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};
};
StringRef FinishedFullBackupTaskFunc::name = "dr_finished_full_backup"_sr;
const Key FinishedFullBackupTaskFunc::keyInsertTask = "insertTask"_sr;
REGISTER_TASKFUNC(FinishedFullBackupTaskFunc);

struct CopyDiffLogsTaskFunc : TaskFuncBase {
	static StringRef name;
	static constexpr uint32_t version = 1;

																#line 12237 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via _finish()
															#line 1296 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class _finishActor6>
															#line 1296 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActor6State {
															#line 12243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 1296 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActor6State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 1296 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 1296 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 1296 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 1296 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 1296 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task),
															#line 1300 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   conf(Subspace(databaseBackupPrefixRange.begin) .get(BackupAgentBase::keyConfig) .get(task->params[BackupAgentBase::keyConfigLogUid])),
															#line 1303 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   states(Subspace(databaseBackupPrefixRange.begin) .get(BackupAgentBase::keyStates) .get(task->params[BackupAgentBase::keyConfigLogUid]))
															#line 12260 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActor6State() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1306 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = checkTaskVersion(tr, task, CopyDiffLogsTaskFunc::name, CopyDiffLogsTaskFunc::version);
															#line 1306 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_finishActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12277 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_finishActor6*>(this)->actor_wait_state = 1;
															#line 1306 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor6, 0, Void >*>(static_cast<_finishActor6*>(this)));
															#line 12282 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActor6State();
		static_cast<_finishActor6*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1308 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		beginVersion = BinaryReader::fromStringRef<Version>(task->params[DatabaseBackupAgent::keyBeginVersion], Unversioned());
															#line 1310 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		prevBeginVersion = BinaryReader::fromStringRef<Version>(task->params[DatabaseBackupAgent::keyPrevBeginVersion], Unversioned());
															#line 1312 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		fStopWhenDone = tr->get(conf.pack(DatabaseBackupAgent::keyConfigStopWhenDoneKey));
															#line 1314 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Transaction srcTr(taskBucket->src);
															#line 1315 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		srcTr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1316 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Version> __when_expr_1 = srcTr.getReadVersion();
															#line 1316 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12317 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor6*>(this)->actor_wait_state = 2;
															#line 1316 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor6, 1, Version >*>(static_cast<_finishActor6*>(this)));
															#line 12322 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1308 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		beginVersion = BinaryReader::fromStringRef<Version>(task->params[DatabaseBackupAgent::keyBeginVersion], Unversioned());
															#line 1310 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		prevBeginVersion = BinaryReader::fromStringRef<Version>(task->params[DatabaseBackupAgent::keyPrevBeginVersion], Unversioned());
															#line 1312 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		fStopWhenDone = tr->get(conf.pack(DatabaseBackupAgent::keyConfigStopWhenDoneKey));
															#line 1314 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Transaction srcTr(taskBucket->src);
															#line 1315 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		srcTr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1316 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Version> __when_expr_1 = srcTr.getReadVersion();
															#line 1316 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12343 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor6*>(this)->actor_wait_state = 2;
															#line 1316 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor6, 1, Version >*>(static_cast<_finishActor6*>(this)));
															#line 12348 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor6*>(this)->actor_wait_state > 0) static_cast<_finishActor6*>(this)->actor_wait_state = 0;
		static_cast<_finishActor6*>(this)->ActorCallback< _finishActor6, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor6, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor6, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor6, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1318 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		onDone = futureBucket->unpack(task->params[Task::reservedTaskParamKeyDone]);
															#line 1320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (endVersion <= beginVersion)
															#line 12434 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1321 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 1321 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_finishActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12440 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<_finishActor6*>(this)->actor_wait_state = 3;
															#line 1321 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _finishActor6, 2, Void >*>(static_cast<_finishActor6*>(this)));
															#line 12445 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Version const& __endVersion,int loopDepth) 
	{
															#line 1316 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		endVersion = __endVersion;
															#line 12459 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Version && __endVersion,int loopDepth) 
	{
		endVersion = std::move(__endVersion);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_finishActor6*>(this)->actor_wait_state > 0) static_cast<_finishActor6*>(this)->actor_wait_state = 0;
		static_cast<_finishActor6*>(this)->ActorCallback< _finishActor6, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor6, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _finishActor6, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _finishActor6, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1328 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr->set(task->params[BackupAgentBase::keyConfigLogUid].withPrefix(applyMutationsEndRange.begin), BinaryWriter::toValue(beginVersion, Unversioned()));
															#line 1330 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = fStopWhenDone;
															#line 1330 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12542 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<_finishActor6*>(this)->actor_wait_state = 6;
															#line 1330 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _finishActor6, 5, Optional<Value> >*>(static_cast<_finishActor6*>(this)));
															#line 12547 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1322 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(CopyDiffLogsTaskFunc::addTask( tr, taskBucket, task, prevBeginVersion, beginVersion, TaskCompletionKey::signal(onDone)));
															#line 1322 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12558 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<_finishActor6*>(this)->actor_wait_state = 4;
															#line 1322 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _finishActor6, 3, Void >*>(static_cast<_finishActor6*>(this)));
															#line 12563 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1322 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(CopyDiffLogsTaskFunc::addTask( tr, taskBucket, task, prevBeginVersion, beginVersion, TaskCompletionKey::signal(onDone)));
															#line 1322 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12574 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<_finishActor6*>(this)->actor_wait_state = 4;
															#line 1322 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _finishActor6, 3, Void >*>(static_cast<_finishActor6*>(this)));
															#line 12579 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_finishActor6*>(this)->actor_wait_state > 0) static_cast<_finishActor6*>(this)->actor_wait_state = 0;
		static_cast<_finishActor6*>(this)->ActorCallback< _finishActor6, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor6, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _finishActor6, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _finishActor6, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1324 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = taskBucket->finish(tr, task);
															#line 1324 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12665 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<_finishActor6*>(this)->actor_wait_state = 5;
															#line 1324 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _finishActor6, 4, Void >*>(static_cast<_finishActor6*>(this)));
															#line 12670 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1324 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = taskBucket->finish(tr, task);
															#line 1324 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_finishActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12681 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<_finishActor6*>(this)->actor_wait_state = 5;
															#line 1324 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _finishActor6, 4, Void >*>(static_cast<_finishActor6*>(this)));
															#line 12686 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_finishActor6*>(this)->actor_wait_state > 0) static_cast<_finishActor6*>(this)->actor_wait_state = 0;
		static_cast<_finishActor6*>(this)->ActorCallback< _finishActor6, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor6, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _finishActor6, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _finishActor6, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1325 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor6*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor6State(); static_cast<_finishActor6*>(this)->destroy(); return 0; }
															#line 12770 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor6*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor6State();
		static_cast<_finishActor6*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1325 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor6*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor6State(); static_cast<_finishActor6*>(this)->destroy(); return 0; }
															#line 12782 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor6*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor6State();
		static_cast<_finishActor6*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_finishActor6*>(this)->actor_wait_state > 0) static_cast<_finishActor6*>(this)->actor_wait_state = 0;
		static_cast<_finishActor6*>(this)->ActorCallback< _finishActor6, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor6, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _finishActor6, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _finishActor6, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont8(Optional<Value> const& stopWhenDone,int loopDepth) 
	{
															#line 1332 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (endVersion - beginVersion > deterministicRandom()->randomInt64(0, CLIENT_KNOBS->BACKUP_VERSION_DELAY))
															#line 12869 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1333 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			TraceEvent("DBA_CopyDiffLogs") .detail("BeginVersion", beginVersion) .detail("EndVersion", endVersion) .detail("LogUID", task->params[BackupAgentBase::keyConfigLogUid]);
															#line 12873 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
															#line 1340 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr->set(StringRef(states.pack(DatabaseBackupAgent::keyStateLogBeginVersion)), BinaryWriter::toValue(beginVersion, Unversioned()));
															#line 1343 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!stopWhenDone.present())
															#line 12879 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1344 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			allPartsDone = futureBucket->future(tr);
															#line 1345 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			std::vector<Future<Key>> addTaskVector;
															#line 1346 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			addTaskVector.push_back(CopyDiffLogsTaskFunc::addTask( tr, taskBucket, task, beginVersion, endVersion, TaskCompletionKey::signal(onDone), allPartsDone));
															#line 1348 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			int blockSize = std::max<int>( 1, ((endVersion - beginVersion) / CLIENT_KNOBS->BACKUP_COPY_TASKS) / CLIENT_KNOBS->BACKUP_BLOCK_SIZE);
															#line 1350 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			for(int64_t vblock = beginVersion / CLIENT_KNOBS->BACKUP_BLOCK_SIZE;vblock < (endVersion + CLIENT_KNOBS->BACKUP_BLOCK_SIZE - 1) / CLIENT_KNOBS->BACKUP_BLOCK_SIZE;vblock += blockSize) {
															#line 1353 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				addTaskVector.push_back(CopyLogRangeTaskFunc::addTask( tr, taskBucket, task, std::max(beginVersion, vblock * CLIENT_KNOBS->BACKUP_BLOCK_SIZE), std::min(endVersion, (vblock + blockSize) * CLIENT_KNOBS->BACKUP_BLOCK_SIZE), TaskCompletionKey::joinWith(allPartsDone)));
															#line 12893 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
															#line 1362 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (prevBeginVersion > 0)
															#line 12897 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 1363 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				addTaskVector.push_back(EraseLogRangeTaskFunc::addTask( tr, taskBucket, task, beginVersion, TaskCompletionKey::joinWith(allPartsDone)));
															#line 12901 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
															#line 1367 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_6 = waitForAll(addTaskVector) && taskBucket->finish(tr, task);
															#line 1367 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_finishActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12907 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont8when1(__when_expr_6.get(), loopDepth); };
			static_cast<_finishActor6*>(this)->actor_wait_state = 7;
															#line 1367 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _finishActor6, 6, Void >*>(static_cast<_finishActor6*>(this)));
															#line 12912 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1369 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_7 = onDone->set(tr, taskBucket) && taskBucket->finish(tr, task);
															#line 1369 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_finishActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12921 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont8when2(__when_expr_7.get(), loopDepth); };
			static_cast<_finishActor6*>(this)->actor_wait_state = 8;
															#line 1369 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _finishActor6, 7, Void >*>(static_cast<_finishActor6*>(this)));
															#line 12926 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont8(Optional<Value> && stopWhenDone,int loopDepth) 
	{
															#line 1332 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (endVersion - beginVersion > deterministicRandom()->randomInt64(0, CLIENT_KNOBS->BACKUP_VERSION_DELAY))
															#line 12936 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1333 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			TraceEvent("DBA_CopyDiffLogs") .detail("BeginVersion", beginVersion) .detail("EndVersion", endVersion) .detail("LogUID", task->params[BackupAgentBase::keyConfigLogUid]);
															#line 12940 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
															#line 1340 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr->set(StringRef(states.pack(DatabaseBackupAgent::keyStateLogBeginVersion)), BinaryWriter::toValue(beginVersion, Unversioned()));
															#line 1343 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!stopWhenDone.present())
															#line 12946 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1344 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			allPartsDone = futureBucket->future(tr);
															#line 1345 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			std::vector<Future<Key>> addTaskVector;
															#line 1346 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			addTaskVector.push_back(CopyDiffLogsTaskFunc::addTask( tr, taskBucket, task, beginVersion, endVersion, TaskCompletionKey::signal(onDone), allPartsDone));
															#line 1348 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			int blockSize = std::max<int>( 1, ((endVersion - beginVersion) / CLIENT_KNOBS->BACKUP_COPY_TASKS) / CLIENT_KNOBS->BACKUP_BLOCK_SIZE);
															#line 1350 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			for(int64_t vblock = beginVersion / CLIENT_KNOBS->BACKUP_BLOCK_SIZE;vblock < (endVersion + CLIENT_KNOBS->BACKUP_BLOCK_SIZE - 1) / CLIENT_KNOBS->BACKUP_BLOCK_SIZE;vblock += blockSize) {
															#line 1353 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				addTaskVector.push_back(CopyLogRangeTaskFunc::addTask( tr, taskBucket, task, std::max(beginVersion, vblock * CLIENT_KNOBS->BACKUP_BLOCK_SIZE), std::min(endVersion, (vblock + blockSize) * CLIENT_KNOBS->BACKUP_BLOCK_SIZE), TaskCompletionKey::joinWith(allPartsDone)));
															#line 12960 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
															#line 1362 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (prevBeginVersion > 0)
															#line 12964 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 1363 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				addTaskVector.push_back(EraseLogRangeTaskFunc::addTask( tr, taskBucket, task, beginVersion, TaskCompletionKey::joinWith(allPartsDone)));
															#line 12968 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
															#line 1367 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_6 = waitForAll(addTaskVector) && taskBucket->finish(tr, task);
															#line 1367 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_finishActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12974 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont8when1(__when_expr_6.get(), loopDepth); };
			static_cast<_finishActor6*>(this)->actor_wait_state = 7;
															#line 1367 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _finishActor6, 6, Void >*>(static_cast<_finishActor6*>(this)));
															#line 12979 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1369 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_7 = onDone->set(tr, taskBucket) && taskBucket->finish(tr, task);
															#line 1369 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_finishActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12988 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont8when2(__when_expr_7.get(), loopDepth); };
			static_cast<_finishActor6*>(this)->actor_wait_state = 8;
															#line 1369 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _finishActor6, 7, Void >*>(static_cast<_finishActor6*>(this)));
															#line 12993 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont3when1(Optional<Value> const& stopWhenDone,int loopDepth) 
	{
		loopDepth = a_body1cont8(stopWhenDone, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Optional<Value> && stopWhenDone,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(stopWhenDone), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_finishActor6*>(this)->actor_wait_state > 0) static_cast<_finishActor6*>(this)->actor_wait_state = 0;
		static_cast<_finishActor6*>(this)->ActorCallback< _finishActor6, 5, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor6, 5, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _finishActor6, 5, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _finishActor6, 5, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 1371 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor6*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor6State(); static_cast<_finishActor6*>(this)->destroy(); return 0; }
															#line 13078 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor6*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor6State();
		static_cast<_finishActor6*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_finishActor6*>(this)->actor_wait_state > 0) static_cast<_finishActor6*>(this)->actor_wait_state = 0;
		static_cast<_finishActor6*>(this)->ActorCallback< _finishActor6, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor6, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _finishActor6, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _finishActor6, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_finishActor6*>(this)->actor_wait_state > 0) static_cast<_finishActor6*>(this)->actor_wait_state = 0;
		static_cast<_finishActor6*>(this)->ActorCallback< _finishActor6, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor6, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _finishActor6, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _finishActor6, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 1296 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1296 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1296 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 1296 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 1300 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Subspace conf;
															#line 1303 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Subspace states;
															#line 1308 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version beginVersion;
															#line 1310 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version prevBeginVersion;
															#line 1312 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Future<Optional<Value>> fStopWhenDone;
															#line 1316 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version endVersion;
															#line 1318 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> onDone;
															#line 1344 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> allPartsDone;
															#line 13284 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via _finish()
															#line 1296 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActor6 final : public Actor<Void>, public ActorCallback< _finishActor6, 0, Void >, public ActorCallback< _finishActor6, 1, Version >, public ActorCallback< _finishActor6, 2, Void >, public ActorCallback< _finishActor6, 3, Void >, public ActorCallback< _finishActor6, 4, Void >, public ActorCallback< _finishActor6, 5, Optional<Value> >, public ActorCallback< _finishActor6, 6, Void >, public ActorCallback< _finishActor6, 7, Void >, public FastAllocated<_finishActor6>, public _finishActor6State<_finishActor6> {
															#line 13289 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<_finishActor6>::operator new;
	using FastAllocated<_finishActor6>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(714272706477971712UL, 9764037908291827968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor6, 0, Void >;
friend struct ActorCallback< _finishActor6, 1, Version >;
friend struct ActorCallback< _finishActor6, 2, Void >;
friend struct ActorCallback< _finishActor6, 3, Void >;
friend struct ActorCallback< _finishActor6, 4, Void >;
friend struct ActorCallback< _finishActor6, 5, Optional<Value> >;
friend struct ActorCallback< _finishActor6, 6, Void >;
friend struct ActorCallback< _finishActor6, 7, Void >;
															#line 1296 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActor6(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 13313 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   _finishActor6State<_finishActor6>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9915380412900524544UL, 1823697738957731584UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor6, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _finishActor6, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _finishActor6, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _finishActor6, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _finishActor6, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _finishActor6, 5, Optional<Value> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _finishActor6, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _finishActor6, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1296 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 1296 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Void>(new _finishActor6(tr, taskBucket, futureBucket, task));
															#line 13352 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 1373 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

																#line 13357 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via addTask()
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class AddTaskActor6>
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class AddTaskActor6State {
															#line 13363 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	AddTaskActor6State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,Version const& prevBeginVersion,Version const& beginVersion,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>()) 
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   parentTask(parentTask),
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   prevBeginVersion(prevBeginVersion),
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   beginVersion(beginVersion),
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   completionKey(completionKey),
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   waitFor(waitFor)
															#line 13382 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("addTask", reinterpret_cast<unsigned long>(this));

	}
	~AddTaskActor6State() 
	{
		fdb_probe_actor_destroy("addTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1381 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Key> __when_expr_0 = completionKey.get(tr, taskBucket);
															#line 1381 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<AddTaskActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13399 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddTaskActor6*>(this)->actor_wait_state = 1;
															#line 1381 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor6, 0, Key >*>(static_cast<AddTaskActor6*>(this)));
															#line 13404 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddTaskActor6State();
		static_cast<AddTaskActor6*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key const& doneKey,int loopDepth) 
	{
															#line 1382 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		auto task = makeReference<Task>(CopyDiffLogsTaskFunc::name, CopyDiffLogsTaskFunc::version, doneKey, 1);
															#line 1384 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		copyDefaultParameters(parentTask, task);
															#line 1386 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[DatabaseBackupAgent::keyBeginVersion] = BinaryWriter::toValue(beginVersion, Unversioned());
															#line 1387 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[DatabaseBackupAgent::keyPrevBeginVersion] = BinaryWriter::toValue(prevBeginVersion, Unversioned());
															#line 1389 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!waitFor)
															#line 13435 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1390 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<AddTaskActor6*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId])); this->~AddTaskActor6State(); static_cast<AddTaskActor6*>(this)->destroy(); return 0; }
															#line 13439 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<AddTaskActor6*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]));
			this->~AddTaskActor6State();
			static_cast<AddTaskActor6*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1396 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitFor->onSetAddTask(tr, taskBucket, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]);
															#line 1396 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<AddTaskActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13449 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTaskActor6*>(this)->actor_wait_state = 2;
															#line 1396 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor6, 1, Void >*>(static_cast<AddTaskActor6*>(this)));
															#line 13454 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key && doneKey,int loopDepth) 
	{
															#line 1382 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		auto task = makeReference<Task>(CopyDiffLogsTaskFunc::name, CopyDiffLogsTaskFunc::version, doneKey, 1);
															#line 1384 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		copyDefaultParameters(parentTask, task);
															#line 1386 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[DatabaseBackupAgent::keyBeginVersion] = BinaryWriter::toValue(beginVersion, Unversioned());
															#line 1387 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[DatabaseBackupAgent::keyPrevBeginVersion] = BinaryWriter::toValue(prevBeginVersion, Unversioned());
															#line 1389 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!waitFor)
															#line 13471 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1390 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<AddTaskActor6*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId])); this->~AddTaskActor6State(); static_cast<AddTaskActor6*>(this)->destroy(); return 0; }
															#line 13475 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<AddTaskActor6*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]));
			this->~AddTaskActor6State();
			static_cast<AddTaskActor6*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1396 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitFor->onSetAddTask(tr, taskBucket, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]);
															#line 1396 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<AddTaskActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13485 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTaskActor6*>(this)->actor_wait_state = 2;
															#line 1396 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor6, 1, Void >*>(static_cast<AddTaskActor6*>(this)));
															#line 13490 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Key const& doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(doneKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(doneKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddTaskActor6*>(this)->actor_wait_state > 0) static_cast<AddTaskActor6*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor6*>(this)->ActorCallback< AddTaskActor6, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor6, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddTaskActor6, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddTaskActor6, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1401 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor6*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddTaskActor6State(); static_cast<AddTaskActor6*>(this)->destroy(); return 0; }
															#line 13574 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor6*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddTaskActor6State();
		static_cast<AddTaskActor6*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1401 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor6*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddTaskActor6State(); static_cast<AddTaskActor6*>(this)->destroy(); return 0; }
															#line 13586 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor6*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddTaskActor6State();
		static_cast<AddTaskActor6*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddTaskActor6*>(this)->actor_wait_state > 0) static_cast<AddTaskActor6*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor6*>(this)->ActorCallback< AddTaskActor6, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor6, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddTaskActor6, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddTaskActor6, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> parentTask;
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version prevBeginVersion;
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version beginVersion;
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	TaskCompletionKey completionKey;
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> waitFor;
															#line 13683 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via addTask()
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class AddTaskActor6 final : public Actor<Key>, public ActorCallback< AddTaskActor6, 0, Key >, public ActorCallback< AddTaskActor6, 1, Void >, public FastAllocated<AddTaskActor6>, public AddTaskActor6State<AddTaskActor6> {
															#line 13688 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<AddTaskActor6>::operator new;
	using FastAllocated<AddTaskActor6>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2537356427516845568UL, 7488682081184314112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddTaskActor6, 0, Key >;
friend struct ActorCallback< AddTaskActor6, 1, Void >;
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	AddTaskActor6(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,Version const& prevBeginVersion,Version const& beginVersion,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>()) 
															#line 13706 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Key>(),
		   AddTaskActor6State<AddTaskActor6>(tr, taskBucket, parentTask, prevBeginVersion, beginVersion, completionKey, waitFor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16509169080315354880UL, 9189403162641976320UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddTaskActor6, 0, Key >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddTaskActor6, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Key> addTask( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<Task> const& parentTask, Version const& prevBeginVersion, Version const& beginVersion, TaskCompletionKey const& completionKey, Reference<TaskFuture> const& waitFor = Reference<TaskFuture>() ) {
															#line 1374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Key>(new AddTaskActor6(tr, taskBucket, parentTask, prevBeginVersion, beginVersion, completionKey, waitFor));
															#line 13739 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 1403 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

	StringRef getName() const override { return name; };

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return Void();
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};
};
StringRef CopyDiffLogsTaskFunc::name = "dr_copy_diff_logs"_sr;
REGISTER_TASKFUNC(CopyDiffLogsTaskFunc);

// Skip unneeded EraseLogRangeTaskFunc in 5.1
struct SkipOldEraseLogRangeTaskFunc : TaskFuncBase {
	static StringRef name;
	static constexpr uint32_t version = 1;

																#line 13767 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via _finish()
															#line 1427 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class _finishActor7>
															#line 1427 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActor7State {
															#line 13773 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 1427 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActor7State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 1427 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 1427 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 1427 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 1427 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 1427 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task),
															#line 1431 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskFuture(futureBucket->unpack(task->params[Task::reservedTaskParamKeyDone]))
															#line 13788 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActor7State() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1432 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = taskFuture->set(tr, taskBucket) && taskBucket->finish(tr, task);
															#line 1432 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_finishActor7*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13805 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_finishActor7*>(this)->actor_wait_state = 1;
															#line 1432 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor7, 0, Void >*>(static_cast<_finishActor7*>(this)));
															#line 13810 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActor7State();
		static_cast<_finishActor7*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1433 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor7*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor7State(); static_cast<_finishActor7*>(this)->destroy(); return 0; }
															#line 13833 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor7*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor7State();
		static_cast<_finishActor7*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1433 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor7*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor7State(); static_cast<_finishActor7*>(this)->destroy(); return 0; }
															#line 13845 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor7*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor7State();
		static_cast<_finishActor7*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor7*>(this)->actor_wait_state > 0) static_cast<_finishActor7*>(this)->actor_wait_state = 0;
		static_cast<_finishActor7*>(this)->ActorCallback< _finishActor7, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor7, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor7, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor7, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1427 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1427 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1427 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 1427 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 1431 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> taskFuture;
															#line 13938 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via _finish()
															#line 1427 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActor7 final : public Actor<Void>, public ActorCallback< _finishActor7, 0, Void >, public FastAllocated<_finishActor7>, public _finishActor7State<_finishActor7> {
															#line 13943 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<_finishActor7>::operator new;
	using FastAllocated<_finishActor7>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(714272706477971712UL, 9764037908291827968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor7, 0, Void >;
															#line 1427 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActor7(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 13960 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   _finishActor7State<_finishActor7>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8520770983166069760UL, 14015181576641025024UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor7, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1427 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 1427 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Void>(new _finishActor7(tr, taskBucket, futureBucket, task));
															#line 13992 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 1435 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

	StringRef getName() const override { return name; };

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return Void();
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};
};
StringRef SkipOldEraseLogRangeTaskFunc::name = "dr_skip_legacy_task"_sr;
REGISTER_TASKFUNC(SkipOldEraseLogRangeTaskFunc);
REGISTER_TASKFUNC_ALIAS(SkipOldEraseLogRangeTaskFunc, db_erase_log_range);

// This is almost the same as CopyLogRangeTaskFunc in 5.1. The only purpose is to support DR upgrade
struct OldCopyLogRangeTaskFunc : TaskFuncBase {
	static StringRef name;
	static constexpr uint32_t version = 1;

	static struct {
		static TaskParam<int64_t> bytesWritten() { return __FUNCTION__sr; }
	} Params;

	static const Key keyNextBeginVersion;

	StringRef getName() const override { return name; };

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return _execute(cx, tb, fb, task);
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};

																#line 14042 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via dumpData()
															#line 1481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class DumpDataActor1>
															#line 1481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class DumpDataActor1State {
															#line 14048 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 1481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	DumpDataActor1State(Database const& cx,Reference<Task> const& task,PromiseStream<RCGroup> const& results,FlowLock* const& lock,Reference<TaskBucket> const& tb) 
															#line 1481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 1481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : cx(cx),
															#line 1481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task),
															#line 1481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   results(results),
															#line 1481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   lock(lock),
															#line 1481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   tb(tb),
															#line 1486 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   endOfStream(false),
															#line 1487 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   conf(Subspace(databaseBackupPrefixRange.begin) .get(BackupAgentBase::keyConfig) .get(task->params[BackupAgentBase::keyConfigLogUid])),
															#line 1491 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   nextMutations(),
															#line 1492 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   nextMutationSize(0)
															#line 14071 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("dumpData", reinterpret_cast<unsigned long>(this));

	}
	~DumpDataActor1State() 
	{
		fdb_probe_actor_destroy("dumpData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1493 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			;
															#line 14086 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DumpDataActor1State();
		static_cast<DumpDataActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1495 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (endOfStream && !nextMutationSize)
															#line 14117 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 1496 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (!static_cast<DumpDataActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DumpDataActor1State(); static_cast<DumpDataActor1*>(this)->destroy(); return 0; }
															#line 14121 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				new (&static_cast<DumpDataActor1*>(this)->SAV< Void >::value()) Void(Void());
				this->~DumpDataActor1State();
				static_cast<DumpDataActor1*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1499 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			mutations = std::move(nextMutations);
															#line 1500 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			mutationSize = nextMutationSize;
															#line 1501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			nextMutations = std::vector<RangeResult>();
															#line 1502 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			nextMutationSize = 0;
															#line 1504 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!endOfStream)
															#line 14137 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 1505 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				;
															#line 14141 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				loopDepth = a_body1loopBody1loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1565 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (e.code() == error_code_actor_cancelled || e.code() == error_code_backup_error)
															#line 14168 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 1566 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 14172 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
															#line 1568 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			err = e;
															#line 1569 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_4 = logError(cx, Subspace(databaseBackupPrefixRange.begin) .get(BackupAgentBase::keyErrors) .pack(task->params[BackupAgentBase::keyConfigLogUid]), format("ERROR: Failed to dump mutations because of error %s", err.what()));
															#line 1569 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<DumpDataActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<DumpDataActor1*>(this)->actor_wait_state = 5;
															#line 1569 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DumpDataActor1, 4, Void >*>(static_cast<DumpDataActor1*>(this)));
															#line 14185 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1532 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr = Transaction(cx);
															#line 1534 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		;
															#line 14202 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1507 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			auto __when_expr_0 = results.getFuture();
															#line 14225 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<RCGroup>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<RCGroup>>::value, "invalid type");
															#line 1507 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<DumpDataActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14229 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<DumpDataActor1*>(this)->actor_wait_state = 1;
															#line 1507 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< DumpDataActor1, 0, RCGroup >*>(static_cast<DumpDataActor1*>(this)));
															#line 14234 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1521 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			error = e;
															#line 1522 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 14271 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 1523 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				endOfStream = true;
															#line 14275 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 1527 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			return a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
															#line 14280 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(RCGroup const& group,int loopDepth) 
	{
															#line 1508 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		lock->release(group.items.expectedSize());
															#line 1510 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		int vecSize = group.items.expectedSize();
															#line 1511 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (mutationSize + vecSize >= CLIENT_KNOBS->BACKUP_LOG_WRITE_BATCH_MAX_SIZE)
															#line 14298 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1513 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			nextMutations.push_back(group.items);
															#line 1514 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			nextMutationSize = vecSize;
															#line 14304 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1518 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		mutations.push_back(group.items);
															#line 1519 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		mutationSize += vecSize;
															#line 14311 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(RCGroup && group,int loopDepth) 
	{
															#line 1508 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		lock->release(group.items.expectedSize());
															#line 1510 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		int vecSize = group.items.expectedSize();
															#line 1511 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (mutationSize + vecSize >= CLIENT_KNOBS->BACKUP_LOG_WRITE_BATCH_MAX_SIZE)
															#line 14324 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1513 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			nextMutations.push_back(group.items);
															#line 1514 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			nextMutationSize = vecSize;
															#line 14330 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1518 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		mutations.push_back(group.items);
															#line 1519 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		mutationSize += vecSize;
															#line 14337 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RCGroup const& group,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(group, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RCGroup && group,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(group), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DumpDataActor1*>(this)->actor_wait_state > 0) static_cast<DumpDataActor1*>(this)->actor_wait_state = 0;
		static_cast<DumpDataActor1*>(this)->ActorSingleCallback< DumpDataActor1, 0, RCGroup >::remove();

	}
	void a_callback_fire(ActorSingleCallback< DumpDataActor1, 0, RCGroup >*,RCGroup const& value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< DumpDataActor1, 0, RCGroup >*,RCGroup && value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< DumpDataActor1, 0, RCGroup >*,Error err) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 1536 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1537 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr.trState->options.sizeLimit = 2 * CLIENT_KNOBS->TRANSACTION_SIZE_LIMIT;
															#line 1538 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_1 = checkDatabaseLock(&tr, BinaryReader::fromStringRef<UID>( task->params[BackupAgentBase::keyConfigLogUid], Unversioned()));
															#line 1538 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<DumpDataActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14454 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont2loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DumpDataActor1*>(this)->actor_wait_state = 2;
															#line 1538 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DumpDataActor1, 1, Void >*>(static_cast<DumpDataActor1*>(this)));
															#line 14459 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1561 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 1561 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<DumpDataActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14496 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<DumpDataActor1*>(this)->actor_wait_state = 4;
															#line 1561 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DumpDataActor1, 3, Void >*>(static_cast<DumpDataActor1*>(this)));
															#line 14501 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1541 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		bytesSet = 0;
															#line 1543 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		bool first = true;
															#line 1544 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		for( auto m : mutations ) {
															#line 1545 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			for( auto kv : m ) {
															#line 1546 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (first)
															#line 14524 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				{
															#line 1547 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					tr.addReadConflictRange(singleKeyRange(kv.key));
															#line 1548 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					first = false;
															#line 14530 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				}
															#line 1550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				tr.set(kv.key.removePrefix(backupLogKeys.begin).withPrefix(applyLogKeys.begin), kv.value);
															#line 1552 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				bytesSet += kv.expectedSize() - backupLogKeys.begin.expectedSize() + applyLogKeys.begin.expectedSize();
															#line 14536 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
		}
															#line 1557 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 1557 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<DumpDataActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14543 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DumpDataActor1*>(this)->actor_wait_state = 3;
															#line 1557 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DumpDataActor1, 2, Void >*>(static_cast<DumpDataActor1*>(this)));
															#line 14548 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1541 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		bytesSet = 0;
															#line 1543 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		bool first = true;
															#line 1544 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		for( auto m : mutations ) {
															#line 1545 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			for( auto kv : m ) {
															#line 1546 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (first)
															#line 14565 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				{
															#line 1547 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					tr.addReadConflictRange(singleKeyRange(kv.key));
															#line 1548 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
					first = false;
															#line 14571 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				}
															#line 1550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				tr.set(kv.key.removePrefix(backupLogKeys.begin).withPrefix(applyLogKeys.begin), kv.value);
															#line 1552 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				bytesSet += kv.expectedSize() - backupLogKeys.begin.expectedSize() + applyLogKeys.begin.expectedSize();
															#line 14577 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			}
		}
															#line 1557 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 1557 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<DumpDataActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14584 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DumpDataActor1*>(this)->actor_wait_state = 3;
															#line 1557 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DumpDataActor1, 2, Void >*>(static_cast<DumpDataActor1*>(this)));
															#line 14589 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DumpDataActor1*>(this)->actor_wait_state > 0) static_cast<DumpDataActor1*>(this)->actor_wait_state = 0;
		static_cast<DumpDataActor1*>(this)->ActorCallback< DumpDataActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpDataActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DumpDataActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DumpDataActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1558 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Params.bytesWritten().set(task, Params.bytesWritten().getOrDefault(task) + bytesSet);
															#line 14673 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1558 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		Params.bytesWritten().set(task, Params.bytesWritten().getOrDefault(task) + bytesSet);
															#line 14682 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DumpDataActor1*>(this)->actor_wait_state > 0) static_cast<DumpDataActor1*>(this)->actor_wait_state = 0;
		static_cast<DumpDataActor1*>(this)->ActorCallback< DumpDataActor1, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpDataActor1, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DumpDataActor1, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DumpDataActor1, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DumpDataActor1*>(this)->actor_wait_state > 0) static_cast<DumpDataActor1*>(this)->actor_wait_state = 0;
		static_cast<DumpDataActor1*>(this)->ActorCallback< DumpDataActor1, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpDataActor1, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DumpDataActor1, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DumpDataActor1, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 1575 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 14866 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 1575 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 14874 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DumpDataActor1*>(this)->actor_wait_state > 0) static_cast<DumpDataActor1*>(this)->actor_wait_state = 0;
		static_cast<DumpDataActor1*>(this)->ActorCallback< DumpDataActor1, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpDataActor1, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DumpDataActor1, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DumpDataActor1, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Database cx;
															#line 1481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 1481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	PromiseStream<RCGroup> results;
															#line 1481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	FlowLock* lock;
															#line 1481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> tb;
															#line 1486 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	bool endOfStream;
															#line 1487 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Subspace conf;
															#line 1491 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	std::vector<RangeResult> nextMutations;
															#line 1492 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	int64_t nextMutationSize;
															#line 1499 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	std::vector<RangeResult> mutations;
															#line 1500 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	int64_t mutationSize;
															#line 1521 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Error error;
															#line 1532 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Transaction tr;
															#line 1541 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	int64_t bytesSet;
															#line 1568 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Error err;
															#line 14983 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via dumpData()
															#line 1481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class DumpDataActor1 final : public Actor<Void>, public ActorSingleCallback< DumpDataActor1, 0, RCGroup >, public ActorCallback< DumpDataActor1, 1, Void >, public ActorCallback< DumpDataActor1, 2, Void >, public ActorCallback< DumpDataActor1, 3, Void >, public ActorCallback< DumpDataActor1, 4, Void >, public FastAllocated<DumpDataActor1>, public DumpDataActor1State<DumpDataActor1> {
															#line 14988 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<DumpDataActor1>::operator new;
	using FastAllocated<DumpDataActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13333241290217181184UL, 4223515052577509632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< DumpDataActor1, 0, RCGroup >;
friend struct ActorCallback< DumpDataActor1, 1, Void >;
friend struct ActorCallback< DumpDataActor1, 2, Void >;
friend struct ActorCallback< DumpDataActor1, 3, Void >;
friend struct ActorCallback< DumpDataActor1, 4, Void >;
															#line 1481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	DumpDataActor1(Database const& cx,Reference<Task> const& task,PromiseStream<RCGroup> const& results,FlowLock* const& lock,Reference<TaskBucket> const& tb) 
															#line 15009 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   DumpDataActor1State<DumpDataActor1>(cx, task, results, lock, tb),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dumpData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8793127715100484608UL, 11706254244160057344UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dumpData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dumpData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< DumpDataActor1, 0, RCGroup >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DumpDataActor1, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DumpDataActor1, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DumpDataActor1, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DumpDataActor1, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> dumpData( Database const& cx, Reference<Task> const& task, PromiseStream<RCGroup> const& results, FlowLock* const& lock, Reference<TaskBucket> const& tb ) {
															#line 1481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Void>(new DumpDataActor1(cx, task, results, lock, tb));
															#line 15045 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 1579 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

																#line 15050 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via _execute()
															#line 1580 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class _executeActor4>
															#line 1580 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _executeActor4State {
															#line 15056 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 1580 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_executeActor4State(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 1580 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 1580 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : cx(cx),
															#line 1580 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 1580 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 1580 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task),
															#line 1584 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   lock(new FlowLock(CLIENT_KNOBS->BACKUP_LOCK_BYTES))
															#line 15071 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_execute", reinterpret_cast<unsigned long>(this));

	}
	~_executeActor4State() 
	{
		fdb_probe_actor_destroy("_execute", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1586 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = checkTaskVersion(cx, task, OldCopyLogRangeTaskFunc::name, OldCopyLogRangeTaskFunc::version);
															#line 1586 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15088 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_executeActor4*>(this)->actor_wait_state = 1;
															#line 1586 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _executeActor4, 0, Void >*>(static_cast<_executeActor4*>(this)));
															#line 15093 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_executeActor4State();
		static_cast<_executeActor4*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1588 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		beginVersion = BinaryReader::fromStringRef<Version>(task->params[DatabaseBackupAgent::keyBeginVersion], Unversioned());
															#line 1590 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		endVersion = BinaryReader::fromStringRef<Version>(task->params[DatabaseBackupAgent::keyEndVersion], Unversioned());
															#line 1592 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		newEndVersion = std::min(endVersion, (((beginVersion - 1) / CLIENT_KNOBS->BACKUP_BLOCK_SIZE) + 2 + (g_network->isSimulated() ? CLIENT_KNOBS->BACKUP_SIM_COPY_LOG_RANGES : 0)) * CLIENT_KNOBS->BACKUP_BLOCK_SIZE);
															#line 1598 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		ranges = getLogRanges(beginVersion, newEndVersion, task->params[BackupAgentBase::keyConfigLogUid], CLIENT_KNOBS->BACKUP_BLOCK_SIZE);
															#line 1602 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		results = std::vector<PromiseStream<RCGroup>>();
															#line 1603 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		rc = std::vector<Future<Void>>();
															#line 1604 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		dump = std::vector<Future<Void>>();
															#line 1606 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		for(int i = 0;i < ranges.size();++i) {
															#line 1607 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			results.push_back(PromiseStream<RCGroup>());
															#line 1608 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			rc.push_back(readCommitted(taskBucket->src, results[i], Future<Void>(Void()), lock, ranges[i], decodeBKMutationLogKey, Terminator::True, AccessSystemKeys::True, LockAware::True));
															#line 1617 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			dump.push_back(dumpData(cx, task, results[i], lock.getPtr(), taskBucket));
															#line 15136 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
															#line 1620 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(dump);
															#line 1620 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15142 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_executeActor4*>(this)->actor_wait_state = 2;
															#line 1620 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _executeActor4, 1, Void >*>(static_cast<_executeActor4*>(this)));
															#line 15147 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1588 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		beginVersion = BinaryReader::fromStringRef<Version>(task->params[DatabaseBackupAgent::keyBeginVersion], Unversioned());
															#line 1590 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		endVersion = BinaryReader::fromStringRef<Version>(task->params[DatabaseBackupAgent::keyEndVersion], Unversioned());
															#line 1592 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		newEndVersion = std::min(endVersion, (((beginVersion - 1) / CLIENT_KNOBS->BACKUP_BLOCK_SIZE) + 2 + (g_network->isSimulated() ? CLIENT_KNOBS->BACKUP_SIM_COPY_LOG_RANGES : 0)) * CLIENT_KNOBS->BACKUP_BLOCK_SIZE);
															#line 1598 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		ranges = getLogRanges(beginVersion, newEndVersion, task->params[BackupAgentBase::keyConfigLogUid], CLIENT_KNOBS->BACKUP_BLOCK_SIZE);
															#line 1602 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		results = std::vector<PromiseStream<RCGroup>>();
															#line 1603 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		rc = std::vector<Future<Void>>();
															#line 1604 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		dump = std::vector<Future<Void>>();
															#line 1606 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		for(int i = 0;i < ranges.size();++i) {
															#line 1607 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			results.push_back(PromiseStream<RCGroup>());
															#line 1608 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			rc.push_back(readCommitted(taskBucket->src, results[i], Future<Void>(Void()), lock, ranges[i], decodeBKMutationLogKey, Terminator::True, AccessSystemKeys::True, LockAware::True));
															#line 1617 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			dump.push_back(dumpData(cx, task, results[i], lock.getPtr(), taskBucket));
															#line 15176 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
															#line 1620 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(dump);
															#line 1620 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15182 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_executeActor4*>(this)->actor_wait_state = 2;
															#line 1620 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _executeActor4, 1, Void >*>(static_cast<_executeActor4*>(this)));
															#line 15187 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_executeActor4*>(this)->actor_wait_state > 0) static_cast<_executeActor4*>(this)->actor_wait_state = 0;
		static_cast<_executeActor4*>(this)->ActorCallback< _executeActor4, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor4, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _executeActor4, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _executeActor4, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1622 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (newEndVersion < endVersion)
															#line 15271 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1623 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			task->params[OldCopyLogRangeTaskFunc::keyNextBeginVersion] = BinaryWriter::toValue(newEndVersion, Unversioned());
															#line 15275 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
															#line 1627 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_executeActor4*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActor4State(); static_cast<_executeActor4*>(this)->destroy(); return 0; }
															#line 15279 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_executeActor4*>(this)->SAV< Void >::value()) Void(Void());
		this->~_executeActor4State();
		static_cast<_executeActor4*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1622 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (newEndVersion < endVersion)
															#line 15291 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1623 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			task->params[OldCopyLogRangeTaskFunc::keyNextBeginVersion] = BinaryWriter::toValue(newEndVersion, Unversioned());
															#line 15295 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		}
															#line 1627 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_executeActor4*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActor4State(); static_cast<_executeActor4*>(this)->destroy(); return 0; }
															#line 15299 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_executeActor4*>(this)->SAV< Void >::value()) Void(Void());
		this->~_executeActor4State();
		static_cast<_executeActor4*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_executeActor4*>(this)->actor_wait_state > 0) static_cast<_executeActor4*>(this)->actor_wait_state = 0;
		static_cast<_executeActor4*>(this)->ActorCallback< _executeActor4, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor4, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _executeActor4, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _executeActor4, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1580 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Database cx;
															#line 1580 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1580 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 1580 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 1584 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<FlowLock> lock;
															#line 1588 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version beginVersion;
															#line 1590 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version endVersion;
															#line 1592 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version newEndVersion;
															#line 1598 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> ranges;
															#line 1602 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	std::vector<PromiseStream<RCGroup>> results;
															#line 1603 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	std::vector<Future<Void>> rc;
															#line 1604 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	std::vector<Future<Void>> dump;
															#line 15406 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via _execute()
															#line 1580 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _executeActor4 final : public Actor<Void>, public ActorCallback< _executeActor4, 0, Void >, public ActorCallback< _executeActor4, 1, Void >, public FastAllocated<_executeActor4>, public _executeActor4State<_executeActor4> {
															#line 15411 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<_executeActor4>::operator new;
	using FastAllocated<_executeActor4>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6069724760364112640UL, 11276186155056124160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _executeActor4, 0, Void >;
friend struct ActorCallback< _executeActor4, 1, Void >;
															#line 1580 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_executeActor4(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 15429 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   _executeActor4State<_executeActor4>(cx, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3663548301291739648UL, 16569871102270706944UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_execute");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _executeActor4, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _executeActor4, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1580 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _execute( Database const& cx, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 1580 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Void>(new _executeActor4(cx, taskBucket, futureBucket, task));
															#line 15462 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 1629 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

																#line 15467 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via addTask()
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class AddTaskActor7>
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class AddTaskActor7State {
															#line 15473 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	AddTaskActor7State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,Version const& beginVersion,Version const& endVersion,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>()) 
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   parentTask(parentTask),
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   beginVersion(beginVersion),
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   endVersion(endVersion),
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   completionKey(completionKey),
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   waitFor(waitFor)
															#line 15492 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("addTask", reinterpret_cast<unsigned long>(this));

	}
	~AddTaskActor7State() 
	{
		fdb_probe_actor_destroy("addTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1637 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Key> __when_expr_0 = completionKey.get(tr, taskBucket);
															#line 1637 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<AddTaskActor7*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15509 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddTaskActor7*>(this)->actor_wait_state = 1;
															#line 1637 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor7, 0, Key >*>(static_cast<AddTaskActor7*>(this)));
															#line 15514 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddTaskActor7State();
		static_cast<AddTaskActor7*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key const& doneKey,int loopDepth) 
	{
															#line 1638 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		auto task = makeReference<Task>(OldCopyLogRangeTaskFunc::name, OldCopyLogRangeTaskFunc::version, doneKey, 1);
															#line 1640 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		copyDefaultParameters(parentTask, task);
															#line 1642 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[DatabaseBackupAgent::keyBeginVersion] = BinaryWriter::toValue(beginVersion, Unversioned());
															#line 1643 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[DatabaseBackupAgent::keyEndVersion] = BinaryWriter::toValue(endVersion, Unversioned());
															#line 1645 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!waitFor)
															#line 15545 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1646 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<AddTaskActor7*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId])); this->~AddTaskActor7State(); static_cast<AddTaskActor7*>(this)->destroy(); return 0; }
															#line 15549 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<AddTaskActor7*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]));
			this->~AddTaskActor7State();
			static_cast<AddTaskActor7*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1652 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitFor->onSetAddTask(tr, taskBucket, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]);
															#line 1652 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<AddTaskActor7*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15559 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTaskActor7*>(this)->actor_wait_state = 2;
															#line 1652 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor7, 1, Void >*>(static_cast<AddTaskActor7*>(this)));
															#line 15564 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key && doneKey,int loopDepth) 
	{
															#line 1638 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		auto task = makeReference<Task>(OldCopyLogRangeTaskFunc::name, OldCopyLogRangeTaskFunc::version, doneKey, 1);
															#line 1640 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		copyDefaultParameters(parentTask, task);
															#line 1642 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[DatabaseBackupAgent::keyBeginVersion] = BinaryWriter::toValue(beginVersion, Unversioned());
															#line 1643 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[DatabaseBackupAgent::keyEndVersion] = BinaryWriter::toValue(endVersion, Unversioned());
															#line 1645 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!waitFor)
															#line 15581 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1646 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<AddTaskActor7*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId])); this->~AddTaskActor7State(); static_cast<AddTaskActor7*>(this)->destroy(); return 0; }
															#line 15585 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<AddTaskActor7*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]));
			this->~AddTaskActor7State();
			static_cast<AddTaskActor7*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1652 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitFor->onSetAddTask(tr, taskBucket, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]);
															#line 1652 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<AddTaskActor7*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15595 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTaskActor7*>(this)->actor_wait_state = 2;
															#line 1652 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor7, 1, Void >*>(static_cast<AddTaskActor7*>(this)));
															#line 15600 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Key const& doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(doneKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(doneKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddTaskActor7*>(this)->actor_wait_state > 0) static_cast<AddTaskActor7*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor7*>(this)->ActorCallback< AddTaskActor7, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor7, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddTaskActor7, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddTaskActor7, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1657 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor7*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddTaskActor7State(); static_cast<AddTaskActor7*>(this)->destroy(); return 0; }
															#line 15684 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor7*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddTaskActor7State();
		static_cast<AddTaskActor7*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1657 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor7*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddTaskActor7State(); static_cast<AddTaskActor7*>(this)->destroy(); return 0; }
															#line 15696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor7*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddTaskActor7State();
		static_cast<AddTaskActor7*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddTaskActor7*>(this)->actor_wait_state > 0) static_cast<AddTaskActor7*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor7*>(this)->ActorCallback< AddTaskActor7, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor7, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddTaskActor7, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddTaskActor7, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> parentTask;
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version beginVersion;
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version endVersion;
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	TaskCompletionKey completionKey;
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> waitFor;
															#line 15793 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via addTask()
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class AddTaskActor7 final : public Actor<Key>, public ActorCallback< AddTaskActor7, 0, Key >, public ActorCallback< AddTaskActor7, 1, Void >, public FastAllocated<AddTaskActor7>, public AddTaskActor7State<AddTaskActor7> {
															#line 15798 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<AddTaskActor7>::operator new;
	using FastAllocated<AddTaskActor7>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2537356427516845568UL, 7488682081184314112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddTaskActor7, 0, Key >;
friend struct ActorCallback< AddTaskActor7, 1, Void >;
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	AddTaskActor7(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,Version const& beginVersion,Version const& endVersion,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>()) 
															#line 15816 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Key>(),
		   AddTaskActor7State<AddTaskActor7>(tr, taskBucket, parentTask, beginVersion, endVersion, completionKey, waitFor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12244656282581911040UL, 16409574877590993408UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddTaskActor7, 0, Key >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddTaskActor7, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Key> addTask( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<Task> const& parentTask, Version const& beginVersion, Version const& endVersion, TaskCompletionKey const& completionKey, Reference<TaskFuture> const& waitFor = Reference<TaskFuture>() ) {
															#line 1630 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Key>(new AddTaskActor7(tr, taskBucket, parentTask, beginVersion, endVersion, completionKey, waitFor));
															#line 15849 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 1659 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

																#line 15854 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via _finish()
															#line 1660 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class _finishActor8>
															#line 1660 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActor8State {
															#line 15860 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 1660 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActor8State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 1660 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 1660 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 1660 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 1660 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 1660 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task),
															#line 1665 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   endVersion(BinaryReader::fromStringRef<Version>(task->params[DatabaseBackupAgent::keyEndVersion], Unversioned())),
															#line 1667 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskFuture(futureBucket->unpack(task->params[Task::reservedTaskParamKeyDone]))
															#line 15877 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActor8State() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1671 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			DRConfig config(task);
															#line 1672 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			int64_t bytesWritten = Params.bytesWritten().getOrDefault(task);
															#line 1673 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			config.logBytesWritten().atomicOp(tr, bytesWritten, MutationRef::AddValue);
															#line 1675 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (task->params.find(OldCopyLogRangeTaskFunc::keyNextBeginVersion) != task->params.end())
															#line 15898 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			{
															#line 1676 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				nextVersion = BinaryReader::fromStringRef<Version>( task->params[OldCopyLogRangeTaskFunc::keyNextBeginVersion], Unversioned());
															#line 1678 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = success(OldCopyLogRangeTaskFunc::addTask( tr, taskBucket, task, nextVersion, endVersion, TaskCompletionKey::signal(taskFuture->key))) && taskBucket->finish(tr, task);
															#line 1678 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (static_cast<_finishActor8*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15906 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_finishActor8*>(this)->actor_wait_state = 1;
															#line 1678 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor8, 0, Void >*>(static_cast<_finishActor8*>(this)));
															#line 15911 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1682 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_1 = taskFuture->set(tr, taskBucket) && taskBucket->finish(tr, task);
															#line 1682 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				if (static_cast<_finishActor8*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15920 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<_finishActor8*>(this)->actor_wait_state = 2;
															#line 1682 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor8, 1, Void >*>(static_cast<_finishActor8*>(this)));
															#line 15925 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActor8State();
		static_cast<_finishActor8*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1685 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor8*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor8State(); static_cast<_finishActor8*>(this)->destroy(); return 0; }
															#line 15949 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor8*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor8State();
		static_cast<_finishActor8*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor8*>(this)->actor_wait_state > 0) static_cast<_finishActor8*>(this)->actor_wait_state = 0;
		static_cast<_finishActor8*>(this)->ActorCallback< _finishActor8, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor8, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor8, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor8, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_finishActor8*>(this)->actor_wait_state > 0) static_cast<_finishActor8*>(this)->actor_wait_state = 0;
		static_cast<_finishActor8*>(this)->ActorCallback< _finishActor8, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor8, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _finishActor8, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _finishActor8, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1660 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1660 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1660 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 1660 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 1665 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version endVersion;
															#line 1667 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> taskFuture;
															#line 1676 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Version nextVersion;
															#line 16145 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via _finish()
															#line 1660 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActor8 final : public Actor<Void>, public ActorCallback< _finishActor8, 0, Void >, public ActorCallback< _finishActor8, 1, Void >, public FastAllocated<_finishActor8>, public _finishActor8State<_finishActor8> {
															#line 16150 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<_finishActor8>::operator new;
	using FastAllocated<_finishActor8>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(714272706477971712UL, 9764037908291827968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor8, 0, Void >;
friend struct ActorCallback< _finishActor8, 1, Void >;
															#line 1660 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActor8(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 16168 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   _finishActor8State<_finishActor8>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2854775835373756928UL, 8178294853911902976UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor8, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _finishActor8, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1660 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 1660 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Void>(new _finishActor8(tr, taskBucket, futureBucket, task));
															#line 16201 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 1687 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
};
StringRef OldCopyLogRangeTaskFunc::name = "db_copy_log_range"_sr;
const Key OldCopyLogRangeTaskFunc::keyNextBeginVersion = "nextBeginVersion"_sr;
REGISTER_TASKFUNC(OldCopyLogRangeTaskFunc);

struct AbortOldBackupTaskFunc : TaskFuncBase {
	static StringRef name;
	static constexpr uint32_t version = 1;

																#line 16214 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via _execute()
															#line 1696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class _executeActor5>
															#line 1696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _executeActor5State {
															#line 16220 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 1696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_executeActor5State(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 1696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 1696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : cx(cx),
															#line 1696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 1696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 1696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task),
															#line 1700 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   srcDrAgent(taskBucket->src),
															#line 1701 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   tr(new ReadYourWritesTransaction(cx)),
															#line 1702 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   tagNameKey()
															#line 16239 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_execute", reinterpret_cast<unsigned long>(this));

	}
	~_executeActor5State() 
	{
		fdb_probe_actor_destroy("_execute", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1704 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			;
															#line 16254 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_executeActor5State();
		static_cast<_executeActor5*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1722 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		TraceEvent("DBA_AbortOldBackup").detail("TagName", tagNameKey.printable());
															#line 1723 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = srcDrAgent.abortBackup(cx, tagNameKey, PartialBackup::False, AbortOldBackup::True);
															#line 1723 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor5*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16281 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_executeActor5*>(this)->actor_wait_state = 3;
															#line 1723 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _executeActor5, 2, Void >*>(static_cast<_executeActor5*>(this)));
															#line 16286 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1706 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1707 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1708 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			Key tagPath = srcDrAgent.states.get(task->params[DatabaseBackupAgent::keyConfigLogUid]) .pack(BackupAgentBase::keyConfigBackupTag);
															#line 1710 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Optional<Key>> __when_expr_0 = tr->get(tagPath);
															#line 1710 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor5*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16311 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_executeActor5*>(this)->actor_wait_state = 1;
															#line 1710 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _executeActor5, 0, Optional<Key> >*>(static_cast<_executeActor5*>(this)));
															#line 16316 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1718 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 1718 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor5*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16353 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_executeActor5*>(this)->actor_wait_state = 2;
															#line 1718 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _executeActor5, 1, Void >*>(static_cast<_executeActor5*>(this)));
															#line 16358 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Key> const& tagName,int loopDepth) 
	{
															#line 1711 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!tagName.present())
															#line 16373 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1712 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<_executeActor5*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActor5State(); static_cast<_executeActor5*>(this)->destroy(); return 0; }
															#line 16377 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<_executeActor5*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActor5State();
			static_cast<_executeActor5*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1715 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tagNameKey = tagName.get();
															#line 16385 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Key> && tagName,int loopDepth) 
	{
															#line 1711 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!tagName.present())
															#line 16394 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1712 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<_executeActor5*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActor5State(); static_cast<_executeActor5*>(this)->destroy(); return 0; }
															#line 16398 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<_executeActor5*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActor5State();
			static_cast<_executeActor5*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1715 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tagNameKey = tagName.get();
															#line 16406 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Key> const& tagName,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(tagName, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Key> && tagName,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(tagName), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_executeActor5*>(this)->actor_wait_state > 0) static_cast<_executeActor5*>(this)->actor_wait_state = 0;
		static_cast<_executeActor5*>(this)->ActorCallback< _executeActor5, 0, Optional<Key> >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor5, 0, Optional<Key> >*,Optional<Key> const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _executeActor5, 0, Optional<Key> >*,Optional<Key> && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _executeActor5, 0, Optional<Key> >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_executeActor5*>(this)->actor_wait_state > 0) static_cast<_executeActor5*>(this)->actor_wait_state = 0;
		static_cast<_executeActor5*>(this)->ActorCallback< _executeActor5, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor5, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _executeActor5, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _executeActor5, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1725 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_executeActor5*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActor5State(); static_cast<_executeActor5*>(this)->destroy(); return 0; }
															#line 16577 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_executeActor5*>(this)->SAV< Void >::value()) Void(Void());
		this->~_executeActor5State();
		static_cast<_executeActor5*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1725 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_executeActor5*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActor5State(); static_cast<_executeActor5*>(this)->destroy(); return 0; }
															#line 16589 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_executeActor5*>(this)->SAV< Void >::value()) Void(Void());
		this->~_executeActor5State();
		static_cast<_executeActor5*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_executeActor5*>(this)->actor_wait_state > 0) static_cast<_executeActor5*>(this)->actor_wait_state = 0;
		static_cast<_executeActor5*>(this)->ActorCallback< _executeActor5, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor5, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _executeActor5, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _executeActor5, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Database cx;
															#line 1696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 1696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 1700 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	DatabaseBackupAgent srcDrAgent;
															#line 1701 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1702 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Key tagNameKey;
															#line 16686 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via _execute()
															#line 1696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _executeActor5 final : public Actor<Void>, public ActorCallback< _executeActor5, 0, Optional<Key> >, public ActorCallback< _executeActor5, 1, Void >, public ActorCallback< _executeActor5, 2, Void >, public FastAllocated<_executeActor5>, public _executeActor5State<_executeActor5> {
															#line 16691 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<_executeActor5>::operator new;
	using FastAllocated<_executeActor5>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6069724760364112640UL, 11276186155056124160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _executeActor5, 0, Optional<Key> >;
friend struct ActorCallback< _executeActor5, 1, Void >;
friend struct ActorCallback< _executeActor5, 2, Void >;
															#line 1696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_executeActor5(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 16710 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   _executeActor5State<_executeActor5>(cx, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17568771650999000320UL, 1640564339289206016UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_execute");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _executeActor5, 0, Optional<Key> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _executeActor5, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _executeActor5, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _execute( Database const& cx, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 1696 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Void>(new _executeActor5(cx, taskBucket, futureBucket, task));
															#line 16744 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 1727 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

																#line 16749 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via _finish()
															#line 1728 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class _finishActor9>
															#line 1728 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActor9State {
															#line 16755 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 1728 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActor9State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 1728 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 1728 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 1728 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 1728 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 1728 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task)
															#line 16768 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActor9State() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = taskBucket->finish(tr, task);
															#line 1732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_finishActor9*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16785 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_finishActor9*>(this)->actor_wait_state = 1;
															#line 1732 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor9, 0, Void >*>(static_cast<_finishActor9*>(this)));
															#line 16790 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActor9State();
		static_cast<_finishActor9*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1733 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor9*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor9State(); static_cast<_finishActor9*>(this)->destroy(); return 0; }
															#line 16813 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor9*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor9State();
		static_cast<_finishActor9*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1733 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_finishActor9*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor9State(); static_cast<_finishActor9*>(this)->destroy(); return 0; }
															#line 16825 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor9*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor9State();
		static_cast<_finishActor9*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor9*>(this)->actor_wait_state > 0) static_cast<_finishActor9*>(this)->actor_wait_state = 0;
		static_cast<_finishActor9*>(this)->ActorCallback< _finishActor9, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor9, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor9, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor9, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1728 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1728 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1728 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 1728 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 16916 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via _finish()
															#line 1728 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _finishActor9 final : public Actor<Void>, public ActorCallback< _finishActor9, 0, Void >, public FastAllocated<_finishActor9>, public _finishActor9State<_finishActor9> {
															#line 16921 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<_finishActor9>::operator new;
	using FastAllocated<_finishActor9>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(714272706477971712UL, 9764037908291827968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor9, 0, Void >;
															#line 1728 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_finishActor9(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 16938 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   _finishActor9State<_finishActor9>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13921703670622923264UL, 8440623587580901888UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor9, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1728 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 1728 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Void>(new _finishActor9(tr, taskBucket, futureBucket, task));
															#line 16970 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 1735 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

																#line 16975 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via addTask()
															#line 1736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class AddTaskActor8>
															#line 1736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class AddTaskActor8State {
															#line 16981 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 1736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	AddTaskActor8State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>()) 
															#line 1736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 1736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : tr(tr),
															#line 1736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 1736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   parentTask(parentTask),
															#line 1736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   completionKey(completionKey),
															#line 1736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   waitFor(waitFor)
															#line 16996 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("addTask", reinterpret_cast<unsigned long>(this));

	}
	~AddTaskActor8State() 
	{
		fdb_probe_actor_destroy("addTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1741 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Key> __when_expr_0 = completionKey.get(tr, taskBucket);
															#line 1741 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<AddTaskActor8*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17013 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddTaskActor8*>(this)->actor_wait_state = 1;
															#line 1741 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor8, 0, Key >*>(static_cast<AddTaskActor8*>(this)));
															#line 17018 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddTaskActor8State();
		static_cast<AddTaskActor8*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key const& doneKey,int loopDepth) 
	{
															#line 1742 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		auto task = makeReference<Task>(AbortOldBackupTaskFunc::name, AbortOldBackupTaskFunc::version, doneKey, 1);
															#line 1744 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		copyDefaultParameters(parentTask, task);
															#line 1746 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!waitFor)
															#line 17045 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1747 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<AddTaskActor8*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId])); this->~AddTaskActor8State(); static_cast<AddTaskActor8*>(this)->destroy(); return 0; }
															#line 17049 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<AddTaskActor8*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]));
			this->~AddTaskActor8State();
			static_cast<AddTaskActor8*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitFor->onSetAddTask(tr, taskBucket, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]);
															#line 1753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<AddTaskActor8*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17059 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTaskActor8*>(this)->actor_wait_state = 2;
															#line 1753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor8, 1, Void >*>(static_cast<AddTaskActor8*>(this)));
															#line 17064 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key && doneKey,int loopDepth) 
	{
															#line 1742 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		auto task = makeReference<Task>(AbortOldBackupTaskFunc::name, AbortOldBackupTaskFunc::version, doneKey, 1);
															#line 1744 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		copyDefaultParameters(parentTask, task);
															#line 1746 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!waitFor)
															#line 17077 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1747 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<AddTaskActor8*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId])); this->~AddTaskActor8State(); static_cast<AddTaskActor8*>(this)->destroy(); return 0; }
															#line 17081 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<AddTaskActor8*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]));
			this->~AddTaskActor8State();
			static_cast<AddTaskActor8*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitFor->onSetAddTask(tr, taskBucket, task, parentTask->params[Task::reservedTaskParamValidKey], task->params[BackupAgentBase::keyFolderId]);
															#line 1753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<AddTaskActor8*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17091 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddTaskActor8*>(this)->actor_wait_state = 2;
															#line 1753 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor8, 1, Void >*>(static_cast<AddTaskActor8*>(this)));
															#line 17096 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Key const& doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(doneKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(doneKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddTaskActor8*>(this)->actor_wait_state > 0) static_cast<AddTaskActor8*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor8*>(this)->ActorCallback< AddTaskActor8, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor8, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddTaskActor8, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddTaskActor8, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1758 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor8*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddTaskActor8State(); static_cast<AddTaskActor8*>(this)->destroy(); return 0; }
															#line 17180 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor8*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddTaskActor8State();
		static_cast<AddTaskActor8*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1758 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor8*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddTaskActor8State(); static_cast<AddTaskActor8*>(this)->destroy(); return 0; }
															#line 17192 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor8*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddTaskActor8State();
		static_cast<AddTaskActor8*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddTaskActor8*>(this)->actor_wait_state > 0) static_cast<AddTaskActor8*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor8*>(this)->ActorCallback< AddTaskActor8, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor8, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddTaskActor8, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddTaskActor8, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<Task> parentTask;
															#line 1736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	TaskCompletionKey completionKey;
															#line 1736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	Reference<TaskFuture> waitFor;
															#line 17285 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via addTask()
															#line 1736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class AddTaskActor8 final : public Actor<Key>, public ActorCallback< AddTaskActor8, 0, Key >, public ActorCallback< AddTaskActor8, 1, Void >, public FastAllocated<AddTaskActor8>, public AddTaskActor8State<AddTaskActor8> {
															#line 17290 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
	using FastAllocated<AddTaskActor8>::operator new;
	using FastAllocated<AddTaskActor8>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2537356427516845568UL, 7488682081184314112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddTaskActor8, 0, Key >;
friend struct ActorCallback< AddTaskActor8, 1, Void >;
															#line 1736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	AddTaskActor8(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>()) 
															#line 17308 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		 : Actor<Key>(),
		   AddTaskActor8State<AddTaskActor8>(tr, taskBucket, parentTask, completionKey, waitFor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12105085021759721984UL, 17631766687961754368UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddTaskActor8, 0, Key >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddTaskActor8, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
[[nodiscard]] static Future<Key> addTask( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<Task> const& parentTask, TaskCompletionKey const& completionKey, Reference<TaskFuture> const& waitFor = Reference<TaskFuture>() ) {
															#line 1736 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	return Future<Key>(new AddTaskActor8(tr, taskBucket, parentTask, completionKey, waitFor));
															#line 17341 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
}

#line 1760 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"

	StringRef getName() const override { return name; };

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return _execute(cx, tb, fb, task);
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};
};
StringRef AbortOldBackupTaskFunc::name = "dr_abort_legacy_backup"_sr;
REGISTER_TASKFUNC(AbortOldBackupTaskFunc);
REGISTER_TASKFUNC_ALIAS(AbortOldBackupTaskFunc, db_backup_range);
REGISTER_TASKFUNC_ALIAS(AbortOldBackupTaskFunc, db_finish_full_backup);
REGISTER_TASKFUNC_ALIAS(AbortOldBackupTaskFunc, db_copy_logs);
REGISTER_TASKFUNC_ALIAS(AbortOldBackupTaskFunc, db_finished_full_backup);
REGISTER_TASKFUNC_ALIAS(AbortOldBackupTaskFunc, db_backup_restorable);
REGISTER_TASKFUNC_ALIAS(AbortOldBackupTaskFunc, db_start_full_backup);

// Upgrade DR from 5.1
struct CopyDiffLogsUpgradeTaskFunc : TaskFuncBase {
	static StringRef name;
	static constexpr uint32_t version = 1;

																#line 17375 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
// This generated class is to be used only via _execute()
															#line 1790 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
template <class _executeActor6>
															#line 1790 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
class _executeActor6State {
															#line 17381 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
public:
															#line 1790 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
	_executeActor6State(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 1790 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
															#line 1790 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		 : cx(cx),
															#line 1790 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 1790 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 1790 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   task(task),
															#line 1794 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   logUidValue(task->params[DatabaseBackupAgent::keyConfigLogUid]),
															#line 1795 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   sourceStates(Subspace(databaseBackupPrefixRange.begin).get(BackupAgentBase::keySourceStates).get(logUidValue)),
															#line 1797 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		   config(Subspace(databaseBackupPrefixRange.begin).get(BackupAgentBase::keyConfig).get(logUidValue))
															#line 17400 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_execute", reinterpret_cast<unsigned long>(this));

	}
	~_executeActor6State() 
	{
		fdb_probe_actor_destroy("_execute", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1799 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = checkTaskVersion(cx, task, CopyDiffLogsUpgradeTaskFunc::name, CopyDiffLogsUpgradeTaskFunc::version);
															#line 1799 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17417 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_executeActor6*>(this)->actor_wait_state = 1;
															#line 1799 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _executeActor6, 0, Void >*>(static_cast<_executeActor6*>(this)));
															#line 17422 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_executeActor6State();
		static_cast<_executeActor6*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1802 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		backupRanges = Standalone<VectorRef<KeyRangeRef>>();
															#line 1803 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 1804 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		;
															#line 17449 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1802 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		backupRanges = Standalone<VectorRef<KeyRangeRef>>();
															#line 1803 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 1804 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		;
															#line 17462 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_executeActor6*>(this)->actor_wait_state > 0) static_cast<_executeActor6*>(this)->actor_wait_state = 0;
		static_cast<_executeActor6*>(this)->ActorCallback< _executeActor6, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor6, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _executeActor6, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _executeActor6, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1825 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		destUidValue = Key(logUidValue);
															#line 1826 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		srcTr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(taskBucket->src));
															#line 1827 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		;
															#line 17550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 1806 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1807 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1808 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			Future<Void> verified = taskBucket->keepRunning(tr, task);
															#line 1809 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_1 = verified;
															#line 1809 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor6*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17575 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_executeActor6*>(this)->actor_wait_state = 2;
															#line 1809 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _executeActor6, 1, Void >*>(static_cast<_executeActor6*>(this)));
															#line 17580 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1820 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 1820 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17617 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<_executeActor6*>(this)->actor_wait_state = 4;
															#line 1820 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _executeActor6, 3, Void >*>(static_cast<_executeActor6*>(this)));
															#line 17622 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1811 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Optional<Key>> __when_expr_2 = tr->get(config.pack(BackupAgentBase::keyConfigBackupRanges));
															#line 1811 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor6*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17639 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_executeActor6*>(this)->actor_wait_state = 3;
															#line 1811 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _executeActor6, 2, Optional<Key> >*>(static_cast<_executeActor6*>(this)));
															#line 17644 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1811 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		StrictFuture<Optional<Key>> __when_expr_2 = tr->get(config.pack(BackupAgentBase::keyConfigBackupRanges));
															#line 1811 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (static_cast<_executeActor6*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17655 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_executeActor6*>(this)->actor_wait_state = 3;
															#line 1811 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _executeActor6, 2, Optional<Key> >*>(static_cast<_executeActor6*>(this)));
															#line 17660 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_executeActor6*>(this)->actor_wait_state > 0) static_cast<_executeActor6*>(this)->actor_wait_state = 0;
		static_cast<_executeActor6*>(this)->ActorCallback< _executeActor6, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor6, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _executeActor6, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _executeActor6, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Optional<Key> const& backupKeysPacked,int loopDepth) 
	{
															#line 1812 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!backupKeysPacked.present())
															#line 17744 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1813 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<_executeActor6*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActor6State(); static_cast<_executeActor6*>(this)->destroy(); return 0; }
															#line 17748 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<_executeActor6*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActor6State();
			static_cast<_executeActor6*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1816 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		BinaryReader br(backupKeysPacked.get(), IncludeVersion());
															#line 1817 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		br >> backupRanges;
															#line 17758 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Optional<Key> && backupKeysPacked,int loopDepth) 
	{
															#line 1812 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!backupKeysPacked.present())
															#line 17767 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1813 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<_executeActor6*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActor6State(); static_cast<_executeActor6*>(this)->destroy(); return 0; }
															#line 17771 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<_executeActor6*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActor6State();
			static_cast<_executeActor6*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1816 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		BinaryReader br(backupKeysPacked.get(), IncludeVersion());
															#line 1817 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		br >> backupRanges;
															#line 17781 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Optional<Key> const& backupKeysPacked,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(backupKeysPacked, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Optional<Key> && backupKeysPacked,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(backupKeysPacked), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_executeActor6*>(this)->actor_wait_state > 0) static_cast<_executeActor6*>(this)->actor_wait_state = 0;
		static_cast<_executeActor6*>(this)->ActorCallback< _executeActor6, 2, Optional<Key> >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor6, 2, Optional<Key> >*,Optional<Key> const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _executeActor6, 2, Optional<Key> >*,Optional<Key> && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _executeActor6, 2, Optional<Key> >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_executeActor6*>(this)->actor_wait_state > 0) static_cast<_executeActor6*>(this)->actor_wait_state = 0;
		static_cast<_executeActor6*>(this)->ActorCallback< _executeActor6, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor6, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _executeActor6, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _executeActor6, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1878 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		task->params[BackupAgentBase::destUid] = destUidValue;
															#line 1879 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		ASSERT(destUidValue == logUidValue);
															#line 1881 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (!static_cast<_executeActor6*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActor6State(); static_cast<_executeActor6*>(this)->destroy(); return 0; }
															#line 17956 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		new (&static_cast<_executeActor6*>(this)->SAV< Void >::value()) Void(Void());
		this->~_executeActor6State();
		static_cast<_executeActor6*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 1829 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			srcTr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1830 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			srcTr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1832 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_4 = srcTr->get(sourceStates.pack(DatabaseBackupAgent::keyFolderId));
															#line 1832 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor6*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17982 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_executeActor6*>(this)->actor_wait_state = 5;
															#line 1832 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _executeActor6, 4, Optional<Value> >*>(static_cast<_executeActor6*>(this)));
															#line 17987 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1874 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_7 = srcTr->onError(e);
															#line 1874 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18024 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<_executeActor6*>(this)->actor_wait_state = 8;
															#line 1874 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _executeActor6, 7, Void >*>(static_cast<_executeActor6*>(this)));
															#line 18029 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(int loopDepth) 
	{
															#line 1833 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (v.present() && BinaryReader::fromStringRef<Version>(v.get(), Unversioned()) > BinaryReader::fromStringRef<Version>( task->params[DatabaseBackupAgent::keyFolderId], Unversioned()))
															#line 18044 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1836 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (!static_cast<_executeActor6*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActor6State(); static_cast<_executeActor6*>(this)->destroy(); return 0; }
															#line 18048 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			new (&static_cast<_executeActor6*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActor6State();
			static_cast<_executeActor6*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1839 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		if (backupRanges.size() == 1 || isDefaultBackup(backupRanges))
															#line 18056 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		{
															#line 1840 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			StrictFuture<RangeResult> __when_expr_5 = srcTr->getRange( KeyRangeRef(destUidLookupPrefix, strinc(destUidLookupPrefix)), CLIENT_KNOBS->TOO_MANY);
															#line 1840 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			if (static_cast<_executeActor6*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 18062 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont2loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
			static_cast<_executeActor6*>(this)->actor_wait_state = 6;
															#line 1840 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _executeActor6, 5, RangeResult >*>(static_cast<_executeActor6*>(this)));
															#line 18067 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Optional<Value> const& __v,int loopDepth) 
	{
															#line 1832 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/fdbclient/DatabaseBackupAgent.actor.cpp"
		v = __v;
															#line 18081 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/fdbclient/DatabaseBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Optional<Value> && __v,int loopDepth) 
	{
		v = std::move(__v);
		loopDepth = a_body1cont2loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_executeActor6*>(this)->actor_wait_state > 0) static_cast<_executeActor6*>(this)->actor_wait_state = 0;
		static_cast<_executeActor6*>(this)->ActorCallback< _executeActor6, 4, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor6, 4, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _executeActor6, 4, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_