#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
/*
* tutorial.actor.cpp

*
* This source file is part of the FoundationDB open source project
*
* Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include "fmt/format.h"
#include "flow/flow.h"
#include "flow/Platform.h"
#include "flow/DeterministicRandom.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "flow/TLSConfig.actor.h"
#include <functional>
#include <unordered_map>
#include <memory>
#include <iostream>
#include "flow/actorcompiler.h"

NetworkAddress serverAddress;

enum TutorialWellKnownEndpoints {
	WLTOKEN_SIMPLE_KV_SERVER = WLTOKEN_FIRST_AVAILABLE,
	WLTOKEN_ECHO_SERVER,
	WLTOKEN_COUNT_IN_TUTORIAL
};

// this is a simple actor that will report how long
// it is already running once a second.
															#line 47 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via simpleTimer()
															#line 45 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class SimpleTimerActor>
															#line 45 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class SimpleTimerActorState {
															#line 54 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 45 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	SimpleTimerActorState() 
															#line 45 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 54 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : start_time(g_network->now())
															#line 61 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("simpleTimer", reinterpret_cast<unsigned long>(this));

	}
	~SimpleTimerActorState() 
	{
		fdb_probe_actor_destroy("simpleTimer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 55 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 76 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SimpleTimerActorState();
		static_cast<SimpleTimerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 56 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(1.0);
															#line 56 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<SimpleTimerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 108 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<SimpleTimerActor*>(this)->actor_wait_state = 1;
															#line 56 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SimpleTimerActor, 0, Void >*>(static_cast<SimpleTimerActor*>(this)));
															#line 113 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("Time: %.2f\n", g_network->now() - start_time);
															#line 122 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("Time: %.2f\n", g_network->now() - start_time);
															#line 131 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SimpleTimerActor*>(this)->actor_wait_state > 0) static_cast<SimpleTimerActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTimerActor*>(this)->ActorCallback< SimpleTimerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTimerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("simpleTimer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTimerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTimer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SimpleTimerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("simpleTimer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTimerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTimer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SimpleTimerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTimer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTimerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTimer", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 54 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	double start_time;
															#line 213 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via simpleTimer()
															#line 45 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class SimpleTimerActor final : public Actor<Void>, public ActorCallback< SimpleTimerActor, 0, Void >, public FastAllocated<SimpleTimerActor>, public SimpleTimerActorState<SimpleTimerActor> {
															#line 218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<SimpleTimerActor>::operator new;
	using FastAllocated<SimpleTimerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14713424730801064448UL, 7957289668242356480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SimpleTimerActor, 0, Void >;
															#line 45 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	SimpleTimerActor() 
															#line 235 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   SimpleTimerActorState<SimpleTimerActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("simpleTimer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4019984202861845248UL, 8014861850264975872UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTimerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("simpleTimer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("simpleTimer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SimpleTimerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 45 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> simpleTimer(  ) {
															#line 45 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new SimpleTimerActor());
															#line 268 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 60 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

// A actor that demonstrates how choose-when blocks work.
															#line 274 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via someFuture()
															#line 62 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class SomeFutureActor>
															#line 62 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class SomeFutureActorState {
															#line 281 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 62 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	SomeFutureActorState(Future<int> const& ready) 
															#line 62 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 62 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : ready(ready)
															#line 288 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("someFuture", reinterpret_cast<unsigned long>(this));

	}
	~SomeFutureActorState() 
	{
		fdb_probe_actor_destroy("someFuture", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 64 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 303 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SomeFutureActorState();
		static_cast<SomeFutureActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 65 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(0.5);
															#line 64 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<SomeFutureActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 335 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 68 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<int> __when_expr_1 = ready;
															#line 339 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<SomeFutureActor*>(this)->actor_wait_state = 1;
															#line 65 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SomeFutureActor, 0, Void >*>(static_cast<SomeFutureActor*>(this)));
															#line 68 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SomeFutureActor, 1, int >*>(static_cast<SomeFutureActor*>(this)));
															#line 346 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 66 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Still waiting...\n";
															#line 361 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 66 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Still waiting...\n";
															#line 370 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(int const& r,int loopDepth) 
	{
															#line 69 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("Ready %d\n", r);
															#line 70 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(double(r));
															#line 70 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<SomeFutureActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 383 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<SomeFutureActor*>(this)->actor_wait_state = 2;
															#line 70 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SomeFutureActor, 2, Void >*>(static_cast<SomeFutureActor*>(this)));
															#line 388 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(int && r,int loopDepth) 
	{
															#line 69 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("Ready %d\n", r);
															#line 70 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(double(r));
															#line 70 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<SomeFutureActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 401 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<SomeFutureActor*>(this)->actor_wait_state = 2;
															#line 70 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SomeFutureActor, 2, Void >*>(static_cast<SomeFutureActor*>(this)));
															#line 406 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SomeFutureActor*>(this)->actor_wait_state > 0) static_cast<SomeFutureActor*>(this)->actor_wait_state = 0;
		static_cast<SomeFutureActor*>(this)->ActorCallback< SomeFutureActor, 0, Void >::remove();
		static_cast<SomeFutureActor*>(this)->ActorCallback< SomeFutureActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< SomeFutureActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SomeFutureActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SomeFutureActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(Void const& _,int loopDepth) 
	{
															#line 71 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Done\n";
															#line 72 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<SomeFutureActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SomeFutureActorState(); static_cast<SomeFutureActor*>(this)->destroy(); return 0; }
															#line 481 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<SomeFutureActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SomeFutureActorState();
		static_cast<SomeFutureActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2cont1(Void && _,int loopDepth) 
	{
															#line 71 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Done\n";
															#line 72 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<SomeFutureActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SomeFutureActorState(); static_cast<SomeFutureActor*>(this)->destroy(); return 0; }
															#line 495 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<SomeFutureActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SomeFutureActorState();
		static_cast<SomeFutureActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SomeFutureActor*>(this)->actor_wait_state > 0) static_cast<SomeFutureActor*>(this)->actor_wait_state = 0;
		static_cast<SomeFutureActor*>(this)->ActorCallback< SomeFutureActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SomeFutureActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SomeFutureActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SomeFutureActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SomeFutureActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SomeFutureActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SomeFutureActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 62 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Future<int> ready;
															#line 637 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via someFuture()
															#line 62 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class SomeFutureActor final : public Actor<Void>, public ActorCallback< SomeFutureActor, 0, Void >, public ActorCallback< SomeFutureActor, 1, int >, public ActorCallback< SomeFutureActor, 2, Void >, public FastAllocated<SomeFutureActor>, public SomeFutureActorState<SomeFutureActor> {
															#line 642 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<SomeFutureActor>::operator new;
	using FastAllocated<SomeFutureActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8120365345433775616UL, 643498998357787136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SomeFutureActor, 0, Void >;
friend struct ActorCallback< SomeFutureActor, 1, int >;
friend struct ActorCallback< SomeFutureActor, 2, Void >;
															#line 62 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	SomeFutureActor(Future<int> const& ready) 
															#line 661 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   SomeFutureActorState<SomeFutureActor>(ready),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14912416791482710528UL, 18035307320785303296UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("someFuture");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SomeFutureActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SomeFutureActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 62 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> someFuture( Future<int> const& ready ) {
															#line 62 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new SomeFutureActor(ready));
															#line 695 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 76 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 700 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via promiseDemo()
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class PromiseDemoActor>
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class PromiseDemoActorState {
															#line 707 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	PromiseDemoActorState() 
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 78 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : promise(),
															#line 79 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   f(someFuture(promise.getFuture()))
															#line 716 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("promiseDemo", reinterpret_cast<unsigned long>(this));

	}
	~PromiseDemoActorState() 
	{
		fdb_probe_actor_destroy("promiseDemo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 80 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(3.0);
															#line 80 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<PromiseDemoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 733 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PromiseDemoActor*>(this)->actor_wait_state = 1;
															#line 80 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PromiseDemoActor, 0, Void >*>(static_cast<PromiseDemoActor*>(this)));
															#line 738 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PromiseDemoActorState();
		static_cast<PromiseDemoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 81 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		promise.send(2);
															#line 82 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f;
															#line 82 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<PromiseDemoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 765 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PromiseDemoActor*>(this)->actor_wait_state = 2;
															#line 82 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PromiseDemoActor, 1, Void >*>(static_cast<PromiseDemoActor*>(this)));
															#line 770 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 81 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		promise.send(2);
															#line 82 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f;
															#line 82 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<PromiseDemoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 783 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PromiseDemoActor*>(this)->actor_wait_state = 2;
															#line 82 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PromiseDemoActor, 1, Void >*>(static_cast<PromiseDemoActor*>(this)));
															#line 788 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PromiseDemoActor*>(this)->actor_wait_state > 0) static_cast<PromiseDemoActor*>(this)->actor_wait_state = 0;
		static_cast<PromiseDemoActor*>(this)->ActorCallback< PromiseDemoActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PromiseDemoActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("promiseDemo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PromiseDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("promiseDemo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PromiseDemoActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("promiseDemo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PromiseDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("promiseDemo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PromiseDemoActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("promiseDemo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PromiseDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("promiseDemo", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 83 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<PromiseDemoActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PromiseDemoActorState(); static_cast<PromiseDemoActor*>(this)->destroy(); return 0; }
															#line 872 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<PromiseDemoActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PromiseDemoActorState();
		static_cast<PromiseDemoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 83 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<PromiseDemoActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PromiseDemoActorState(); static_cast<PromiseDemoActor*>(this)->destroy(); return 0; }
															#line 884 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<PromiseDemoActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PromiseDemoActorState();
		static_cast<PromiseDemoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PromiseDemoActor*>(this)->actor_wait_state > 0) static_cast<PromiseDemoActor*>(this)->actor_wait_state = 0;
		static_cast<PromiseDemoActor*>(this)->ActorCallback< PromiseDemoActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PromiseDemoActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("promiseDemo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PromiseDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("promiseDemo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PromiseDemoActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("promiseDemo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PromiseDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("promiseDemo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PromiseDemoActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("promiseDemo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PromiseDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("promiseDemo", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 78 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Promise<int> promise;
															#line 79 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Future<Void> f;
															#line 971 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via promiseDemo()
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class PromiseDemoActor final : public Actor<Void>, public ActorCallback< PromiseDemoActor, 0, Void >, public ActorCallback< PromiseDemoActor, 1, Void >, public FastAllocated<PromiseDemoActor>, public PromiseDemoActorState<PromiseDemoActor> {
															#line 976 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<PromiseDemoActor>::operator new;
	using FastAllocated<PromiseDemoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7633503608114245120UL, 13506287335533995520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PromiseDemoActor, 0, Void >;
friend struct ActorCallback< PromiseDemoActor, 1, Void >;
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	PromiseDemoActor() 
															#line 994 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   PromiseDemoActorState<PromiseDemoActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("promiseDemo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11135284205190497024UL, 16902754515898800128UL);
		ActorExecutionContextHelper __helper(static_cast<PromiseDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("promiseDemo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("promiseDemo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PromiseDemoActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PromiseDemoActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> promiseDemo(  ) {
															#line 77 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new PromiseDemoActor());
															#line 1028 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 85 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 1033 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via eventLoop()
															#line 86 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class EventLoopActor>
															#line 86 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class EventLoopActorState {
															#line 1040 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 86 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	EventLoopActorState(AsyncTrigger* const& trigger) 
															#line 86 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 86 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : trigger(trigger)
															#line 1047 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("eventLoop", reinterpret_cast<unsigned long>(this));

	}
	~EventLoopActorState() 
	{
		fdb_probe_actor_destroy("eventLoop", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 87 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 1062 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EventLoopActorState();
		static_cast<EventLoopActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 88 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(0.5);
															#line 87 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<EventLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1094 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 91 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_1 = trigger->onTrigger();
															#line 1098 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<EventLoopActor*>(this)->actor_wait_state = 1;
															#line 88 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< EventLoopActor, 0, Void >*>(static_cast<EventLoopActor*>(this)));
															#line 91 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< EventLoopActor, 1, Void >*>(static_cast<EventLoopActor*>(this)));
															#line 1105 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 89 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Still waiting...\n";
															#line 1120 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 89 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Still waiting...\n";
															#line 1129 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 92 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Triggered!\n";
															#line 1138 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 92 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Triggered!\n";
															#line 1147 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EventLoopActor*>(this)->actor_wait_state > 0) static_cast<EventLoopActor*>(this)->actor_wait_state = 0;
		static_cast<EventLoopActor*>(this)->ActorCallback< EventLoopActor, 0, Void >::remove();
		static_cast<EventLoopActor*>(this)->ActorCallback< EventLoopActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EventLoopActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("eventLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EventLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("eventLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EventLoopActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("eventLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EventLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("eventLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< EventLoopActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("eventLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EventLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("eventLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EventLoopActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("eventLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EventLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("eventLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< EventLoopActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("eventLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EventLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("eventLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< EventLoopActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("eventLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EventLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("eventLoop", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 86 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	AsyncTrigger* trigger;
															#line 1275 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via eventLoop()
															#line 86 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class EventLoopActor final : public Actor<Void>, public ActorCallback< EventLoopActor, 0, Void >, public ActorCallback< EventLoopActor, 1, Void >, public FastAllocated<EventLoopActor>, public EventLoopActorState<EventLoopActor> {
															#line 1280 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<EventLoopActor>::operator new;
	using FastAllocated<EventLoopActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5521246586646468864UL, 3871349918974447360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< EventLoopActor, 0, Void >;
friend struct ActorCallback< EventLoopActor, 1, Void >;
															#line 86 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	EventLoopActor(AsyncTrigger* const& trigger) 
															#line 1298 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   EventLoopActorState<EventLoopActor>(trigger),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("eventLoop", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9392263333227398400UL, 3043736473295405824UL);
		ActorExecutionContextHelper __helper(static_cast<EventLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("eventLoop");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("eventLoop", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< EventLoopActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 86 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> eventLoop( AsyncTrigger* const& trigger ) {
															#line 86 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new EventLoopActor(trigger));
															#line 1331 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 96 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 1336 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via triggerDemo()
															#line 97 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class TriggerDemoActor>
															#line 97 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class TriggerDemoActorState {
															#line 1343 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 97 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	TriggerDemoActorState() 
															#line 97 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 98 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : runs(1),
															#line 99 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   trigger(),
															#line 100 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   triggerLoop(eventLoop(&trigger))
															#line 1354 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("triggerDemo", reinterpret_cast<unsigned long>(this));

	}
	~TriggerDemoActorState() 
	{
		fdb_probe_actor_destroy("triggerDemo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 101 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 1369 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TriggerDemoActorState();
		static_cast<TriggerDemoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 106 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Done.";
															#line 107 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<TriggerDemoActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TriggerDemoActorState(); static_cast<TriggerDemoActor*>(this)->destroy(); return 0; }
															#line 1394 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<TriggerDemoActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TriggerDemoActorState();
		static_cast<TriggerDemoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 101 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!(++runs < 10))
															#line 1413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 102 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(1.0);
															#line 102 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<TriggerDemoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1421 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TriggerDemoActor*>(this)->actor_wait_state = 1;
															#line 102 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TriggerDemoActor, 0, Void >*>(static_cast<TriggerDemoActor*>(this)));
															#line 1426 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 103 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "trigger..";
															#line 104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		trigger.trigger();
															#line 1450 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 103 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "trigger..";
															#line 104 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		trigger.trigger();
															#line 1461 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TriggerDemoActor*>(this)->actor_wait_state > 0) static_cast<TriggerDemoActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerDemoActor*>(this)->ActorCallback< TriggerDemoActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerDemoActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("triggerDemo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerDemo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TriggerDemoActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("triggerDemo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerDemo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TriggerDemoActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("triggerDemo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerDemo", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 98 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	int runs;
															#line 99 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	AsyncTrigger trigger;
															#line 100 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Future<Void> triggerLoop;
															#line 1547 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via triggerDemo()
															#line 97 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class TriggerDemoActor final : public Actor<Void>, public ActorCallback< TriggerDemoActor, 0, Void >, public FastAllocated<TriggerDemoActor>, public TriggerDemoActorState<TriggerDemoActor> {
															#line 1552 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<TriggerDemoActor>::operator new;
	using FastAllocated<TriggerDemoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17068837697693780992UL, 3968488740294641664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TriggerDemoActor, 0, Void >;
															#line 97 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	TriggerDemoActor() 
															#line 1569 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   TriggerDemoActorState<TriggerDemoActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("triggerDemo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17053554698876546816UL, 16478459148624512768UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("triggerDemo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("triggerDemo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TriggerDemoActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 97 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> triggerDemo(  ) {
															#line 97 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new TriggerDemoActor());
															#line 1602 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 109 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

struct EchoServerInterface {
	constexpr static FileIdentifier file_identifier = 3152015;
	RequestStream<struct GetInterfaceRequest> getInterface;
	RequestStream<struct EchoRequest> echo;
	RequestStream<struct ReverseRequest> reverse;
	RequestStream<struct StreamRequest> stream;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, echo, reverse, stream);
	}
};

struct GetInterfaceRequest {
	constexpr static FileIdentifier file_identifier = 12004156;
	ReplyPromise<EchoServerInterface> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, reply);
	}
};

struct EchoRequest {
	constexpr static FileIdentifier file_identifier = 10624019;
	std::string message;

	// NOTES:
	// 1) This variable has to be called reply!
	// 2) Do not be mislead into thinking that just because we say
	//    ReplyPromise<std::string> below that you can also say
	//    ReplyPromise<int> elsewhere.
	// 3) There is no good documentation about this. You'll have to
	//    just read the code or ask your local team.
	ReplyPromise<std::string> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, message, reply);
	}
};

struct ReverseRequest {
	constexpr static FileIdentifier file_identifier = 10765955;
	std::string message;
	// this variable has to be called reply!
	ReplyPromise<std::string> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, message, reply);
	}
};

struct StreamReply : ReplyPromiseStreamReply {
	constexpr static FileIdentifier file_identifier = 440804;

	int index = 0;
	StreamReply() = default;
	explicit StreamReply(int index) : index(index) {}

	size_t expectedSize() const { return 2e6; }

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, ReplyPromiseStreamReply::acknowledgeToken, ReplyPromiseStreamReply::sequence, index);
	}
};

struct StreamRequest {
	constexpr static FileIdentifier file_identifier = 5410805;
	ReplyPromiseStream<StreamReply> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, reply);
	}
};

uint64_t tokenCounter = 1;

															#line 1688 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via echoServer()
															#line 191 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class EchoServerActor>
															#line 191 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class EchoServerActorState {
															#line 1695 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 191 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	EchoServerActorState() 
															#line 191 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 192 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : echoServer()
															#line 1702 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("echoServer", reinterpret_cast<unsigned long>(this));

	}
	~EchoServerActorState() 
	{
		fdb_probe_actor_destroy("echoServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 193 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			echoServer.getInterface.makeWellKnownEndpoint(WLTOKEN_ECHO_SERVER, TaskPriority::DefaultEndpoint);
															#line 194 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 1719 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EchoServerActorState();
		static_cast<EchoServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 197 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			auto __when_expr_0 = echoServer.getInterface.getFuture();
															#line 1750 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetInterfaceRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetInterfaceRequest>>::value, "invalid type");
															#line 196 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<EchoServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1754 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 200 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			auto __when_expr_1 = echoServer.echo.getFuture();
															#line 1758 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_1), FutureStream<EchoRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<EchoRequest>>::value, "invalid type");
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 203 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			auto __when_expr_2 = echoServer.reverse.getFuture();
															#line 1763 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_2), FutureStream<ReverseRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<ReverseRequest>>::value, "invalid type");
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
															#line 206 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			auto __when_expr_3 = echoServer.stream.getFuture();
															#line 1768 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_3), FutureStream<StreamRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<StreamRequest>>::value, "invalid type");
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1when4(__when_expr_3.pop(), loopDepth); };
			static_cast<EchoServerActor*>(this)->actor_wait_state = 1;
															#line 197 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >*>(static_cast<EchoServerActor*>(this)));
															#line 200 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< EchoServerActor, 1, EchoRequest >*>(static_cast<EchoServerActor*>(this)));
															#line 203 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< EchoServerActor, 2, ReverseRequest >*>(static_cast<EchoServerActor*>(this)));
															#line 206 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< EchoServerActor, 3, StreamRequest >*>(static_cast<EchoServerActor*>(this)));
															#line 1780 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 218 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (e.code() != error_code_operation_obsolete)
															#line 1802 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			{
															#line 219 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
				fprintf(stderr, "Error: %s\n", e.what());
															#line 220 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1808 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetInterfaceRequest const& req,int loopDepth) 
	{
															#line 198 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(echoServer);
															#line 1830 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetInterfaceRequest && req,int loopDepth) 
	{
															#line 198 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(echoServer);
															#line 1839 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(EchoRequest const& req,int loopDepth) 
	{
															#line 201 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(req.message);
															#line 1848 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(EchoRequest && req,int loopDepth) 
	{
															#line 201 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(req.message);
															#line 1857 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(ReverseRequest const& req,int loopDepth) 
	{
															#line 204 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(std::string(req.message.rbegin(), req.message.rend()));
															#line 1866 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(ReverseRequest && req,int loopDepth) 
	{
															#line 204 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(std::string(req.message.rbegin(), req.message.rend()));
															#line 1875 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(StreamRequest const& __req,int loopDepth) 
	{
															#line 206 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req = __req;
															#line 207 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.setByteLimit(1024);
															#line 208 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		i = 0;
															#line 209 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		;
															#line 1890 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1when4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(StreamRequest && __req,int loopDepth) 
	{
		req = std::move(__req);
															#line 207 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.setByteLimit(1024);
															#line 208 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		i = 0;
															#line 209 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		;
															#line 1904 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1when4loopHead1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EchoServerActor*>(this)->actor_wait_state > 0) static_cast<EchoServerActor*>(this)->actor_wait_state = 0;
		static_cast<EchoServerActor*>(this)->ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >::remove();
		static_cast<EchoServerActor*>(this)->ActorSingleCallback< EchoServerActor, 1, EchoRequest >::remove();
		static_cast<EchoServerActor*>(this)->ActorSingleCallback< EchoServerActor, 2, ReverseRequest >::remove();
		static_cast<EchoServerActor*>(this)->ActorSingleCallback< EchoServerActor, 3, StreamRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >*,GetInterfaceRequest const& value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >*,GetInterfaceRequest && value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >*,Error err) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 1, EchoRequest >*,EchoRequest const& value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 1, EchoRequest >*,EchoRequest && value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< EchoServerActor, 1, EchoRequest >*,Error err) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 2, ReverseRequest >*,ReverseRequest const& value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 2, ReverseRequest >*,ReverseRequest && value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< EchoServerActor, 2, ReverseRequest >*,Error err) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1when4cont1(int loopDepth) 
	{
															#line 214 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.sendError(end_of_stream());
															#line 2093 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1when4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4loopBody1(int loopDepth) 
	{
															#line 209 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!(i < 100))
															#line 2109 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
			return a_body1loopBody1when4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_4 = req.reply.onReady();
															#line 210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<EchoServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2117 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4loopBody1when1(__when_expr_4.get(), loopDepth); };
		static_cast<EchoServerActor*>(this)->actor_wait_state = 2;
															#line 210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< EchoServerActor, 4, Void >*>(static_cast<EchoServerActor*>(this)));
															#line 2122 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when4break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1when4cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when4loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 211 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Send " << i << std::endl;
															#line 212 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(StreamReply{ i });
															#line 209 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		++i;
															#line 2148 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1when4loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when4loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 211 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Send " << i << std::endl;
															#line 212 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(StreamReply{ i });
															#line 209 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		++i;
															#line 2161 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1when4loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when4loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when4loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<EchoServerActor*>(this)->actor_wait_state > 0) static_cast<EchoServerActor*>(this)->actor_wait_state = 0;
		static_cast<EchoServerActor*>(this)->ActorCallback< EchoServerActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EchoServerActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< EchoServerActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< EchoServerActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 3, StreamRequest >*,StreamRequest const& value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 3, StreamRequest >*,StreamRequest && value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< EchoServerActor, 3, StreamRequest >*,Error err) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 192 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	EchoServerInterface echoServer;
															#line 206 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	StreamRequest req;
															#line 208 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	int i;
															#line 2317 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via echoServer()
															#line 191 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class EchoServerActor final : public Actor<Void>, public ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >, public ActorSingleCallback< EchoServerActor, 1, EchoRequest >, public ActorSingleCallback< EchoServerActor, 2, ReverseRequest >, public ActorSingleCallback< EchoServerActor, 3, StreamRequest >, public ActorCallback< EchoServerActor, 4, Void >, public FastAllocated<EchoServerActor>, public EchoServerActorState<EchoServerActor> {
															#line 2322 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<EchoServerActor>::operator new;
	using FastAllocated<EchoServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12410190629077867520UL, 4886193727757609216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >;
friend struct ActorSingleCallback< EchoServerActor, 1, EchoRequest >;
friend struct ActorSingleCallback< EchoServerActor, 2, ReverseRequest >;
friend struct ActorSingleCallback< EchoServerActor, 3, StreamRequest >;
friend struct ActorCallback< EchoServerActor, 4, Void >;
															#line 191 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	EchoServerActor() 
															#line 2343 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   EchoServerActorState<EchoServerActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7060032109465747968UL, 10021521862504165120UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("echoServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< EchoServerActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 191 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> echoServer(  ) {
															#line 191 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new EchoServerActor());
															#line 2377 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 225 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 2382 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via echoClient()
															#line 226 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class EchoClientActor>
															#line 226 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class EchoClientActorState {
															#line 2389 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 226 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	EchoClientActorState() 
															#line 226 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 227 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : server()
															#line 2396 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("echoClient", reinterpret_cast<unsigned long>(this));

	}
	~EchoClientActorState() 
	{
		fdb_probe_actor_destroy("echoClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 228 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			server.getInterface = RequestStream<GetInterfaceRequest>(Endpoint::wellKnown({ serverAddress }, WLTOKEN_ECHO_SERVER));
															#line 230 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<EchoServerInterface> __when_expr_0 = server.getInterface.getReply(GetInterfaceRequest());
															#line 230 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<EchoClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2415 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<EchoClientActor*>(this)->actor_wait_state = 1;
															#line 230 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< EchoClientActor, 0, EchoServerInterface >*>(static_cast<EchoClientActor*>(this)));
															#line 2420 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EchoClientActorState();
		static_cast<EchoClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(EchoServerInterface const& s,int loopDepth) 
	{
															#line 231 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		server = s;
															#line 232 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		EchoRequest echoRequest;
															#line 233 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		echoRequest.message = "Hello World";
															#line 234 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = server.echo.getReply(echoRequest);
															#line 234 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<EchoClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2451 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<EchoClientActor*>(this)->actor_wait_state = 2;
															#line 234 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< EchoClientActor, 1, std::string >*>(static_cast<EchoClientActor*>(this)));
															#line 2456 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(EchoServerInterface && s,int loopDepth) 
	{
															#line 231 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		server = s;
															#line 232 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		EchoRequest echoRequest;
															#line 233 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		echoRequest.message = "Hello World";
															#line 234 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = server.echo.getReply(echoRequest);
															#line 234 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<EchoClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2473 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<EchoClientActor*>(this)->actor_wait_state = 2;
															#line 234 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< EchoClientActor, 1, std::string >*>(static_cast<EchoClientActor*>(this)));
															#line 2478 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(EchoServerInterface const& s,int loopDepth) 
	{
		loopDepth = a_body1cont1(s, loopDepth);

		return loopDepth;
	}
	int a_body1when1(EchoServerInterface && s,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EchoClientActor*>(this)->actor_wait_state > 0) static_cast<EchoClientActor*>(this)->actor_wait_state = 0;
		static_cast<EchoClientActor*>(this)->ActorCallback< EchoClientActor, 0, EchoServerInterface >::remove();

	}
	void a_callback_fire(ActorCallback< EchoClientActor, 0, EchoServerInterface >*,EchoServerInterface const& value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EchoClientActor, 0, EchoServerInterface >*,EchoServerInterface && value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< EchoClientActor, 0, EchoServerInterface >*,Error err) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(std::string const& echoMessage,int loopDepth) 
	{
															#line 235 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("Sent %s to echo, received %s\n", "Hello World", echoMessage.c_str());
															#line 236 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		ReverseRequest reverseRequest;
															#line 237 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		reverseRequest.message = "Hello World";
															#line 238 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = server.reverse.getReply(reverseRequest);
															#line 238 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<EchoClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2570 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<EchoClientActor*>(this)->actor_wait_state = 3;
															#line 238 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< EchoClientActor, 2, std::string >*>(static_cast<EchoClientActor*>(this)));
															#line 2575 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(std::string && echoMessage,int loopDepth) 
	{
															#line 235 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("Sent %s to echo, received %s\n", "Hello World", echoMessage.c_str());
															#line 236 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		ReverseRequest reverseRequest;
															#line 237 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		reverseRequest.message = "Hello World";
															#line 238 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = server.reverse.getReply(reverseRequest);
															#line 238 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<EchoClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2592 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<EchoClientActor*>(this)->actor_wait_state = 3;
															#line 238 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< EchoClientActor, 2, std::string >*>(static_cast<EchoClientActor*>(this)));
															#line 2597 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::string const& echoMessage,int loopDepth) 
	{
		loopDepth = a_body1cont2(echoMessage, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::string && echoMessage,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(echoMessage), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<EchoClientActor*>(this)->actor_wait_state > 0) static_cast<EchoClientActor*>(this)->actor_wait_state = 0;
		static_cast<EchoClientActor*>(this)->ActorCallback< EchoClientActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< EchoClientActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< EchoClientActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< EchoClientActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(std::string const& reverseString,int loopDepth) 
	{
															#line 239 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("Sent %s to reverse, received %s\n", "Hello World", reverseString.c_str());
															#line 241 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		stream = server.stream.getReplyStream(StreamRequest{});
															#line 242 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		j = 0;
															#line 2685 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		try {
															#line 244 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 2689 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1cont3loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont3Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(std::string && reverseString,int loopDepth) 
	{
															#line 239 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("Sent %s to reverse, received %s\n", "Hello World", reverseString.c_str());
															#line 241 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		stream = server.stream.getReplyStream(StreamRequest{});
															#line 242 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		j = 0;
															#line 2708 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		try {
															#line 244 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 2712 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1cont3loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont3Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(std::string const& reverseString,int loopDepth) 
	{
		loopDepth = a_body1cont3(reverseString, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::string && reverseString,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(reverseString), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<EchoClientActor*>(this)->actor_wait_state > 0) static_cast<EchoClientActor*>(this)->actor_wait_state = 0;
		static_cast<EchoClientActor*>(this)->ActorCallback< EchoClientActor, 2, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< EchoClientActor, 2, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< EchoClientActor, 2, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< EchoClientActor, 2, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 252 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<EchoClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EchoClientActorState(); static_cast<EchoClientActor*>(this)->destroy(); return 0; }
															#line 2802 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<EchoClientActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~EchoClientActorState();
		static_cast<EchoClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 250 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			ASSERT(e.code() == error_code_end_of_stream || e.code() == error_code_connection_failed);
															#line 2815 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 245 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto __when_expr_3 = stream.getFuture();
															#line 2837 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<StreamReply>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<StreamReply>>::value, "invalid type");
															#line 245 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<EchoClientActor*>(this)->actor_wait_state < 0) return a_body1cont3Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2841 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont3Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_3.pop(), loopDepth); };
		static_cast<EchoClientActor*>(this)->actor_wait_state = 4;
															#line 245 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< EchoClientActor, 3, StreamReply >*>(static_cast<EchoClientActor*>(this)));
															#line 2846 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(StreamReply const& rep,int loopDepth) 
	{
															#line 246 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Rep: " << rep.index << std::endl;
															#line 247 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		ASSERT(rep.index == j++);
															#line 2857 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(StreamReply && rep,int loopDepth) 
	{
															#line 246 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Rep: " << rep.index << std::endl;
															#line 247 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		ASSERT(rep.index == j++);
															#line 2868 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(StreamReply const& rep,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(rep, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(StreamReply && rep,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(std::move(rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<EchoClientActor*>(this)->actor_wait_state > 0) static_cast<EchoClientActor*>(this)->actor_wait_state = 0;
		static_cast<EchoClientActor*>(this)->ActorSingleCallback< EchoClientActor, 3, StreamReply >::remove();

	}
	void a_callback_fire(ActorSingleCallback< EchoClientActor, 3, StreamReply >*,StreamReply const& value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< EchoClientActor, 3, StreamReply >*,StreamReply && value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< EchoClientActor, 3, StreamReply >*,Error err) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 227 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	EchoServerInterface server;
															#line 241 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	ReplyPromiseStream<StreamReply> stream;
															#line 242 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	int j;
															#line 2954 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via echoClient()
															#line 226 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class EchoClientActor final : public Actor<Void>, public ActorCallback< EchoClientActor, 0, EchoServerInterface >, public ActorCallback< EchoClientActor, 1, std::string >, public ActorCallback< EchoClientActor, 2, std::string >, public ActorSingleCallback< EchoClientActor, 3, StreamReply >, public FastAllocated<EchoClientActor>, public EchoClientActorState<EchoClientActor> {
															#line 2959 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<EchoClientActor>::operator new;
	using FastAllocated<EchoClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6170378484294970624UL, 14008312817544311552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< EchoClientActor, 0, EchoServerInterface >;
friend struct ActorCallback< EchoClientActor, 1, std::string >;
friend struct ActorCallback< EchoClientActor, 2, std::string >;
friend struct ActorSingleCallback< EchoClientActor, 3, StreamReply >;
															#line 226 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	EchoClientActor() 
															#line 2979 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   EchoClientActorState<EchoClientActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9930685301966915072UL, 10766244735779810048UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("echoClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< EchoClientActor, 0, EchoServerInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< EchoClientActor, 1, std::string >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< EchoClientActor, 2, std::string >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorSingleCallback< EchoClientActor, 3, StreamReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 226 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> echoClient(  ) {
															#line 226 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new EchoClientActor());
															#line 3015 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 254 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

struct SimpleKeyValueStoreInterface {
	constexpr static FileIdentifier file_identifier = 8226647;
	RequestStream<struct GetKVInterface> connect;
	RequestStream<struct GetRequest> get;
	RequestStream<struct SetRequest> set;
	RequestStream<struct ClearRequest> clear;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, connect, get, set, clear);
	}
};

struct GetKVInterface {
	constexpr static FileIdentifier file_identifier = 8062308;
	ReplyPromise<SimpleKeyValueStoreInterface> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, reply);
	}
};

struct GetRequest {
	constexpr static FileIdentifier file_identifier = 6983506;
	std::string key;
	ReplyPromise<std::string> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, key, reply);
	}
};

struct SetRequest {
	constexpr static FileIdentifier file_identifier = 7554186;
	std::string key;
	std::string value;
	ReplyPromise<Void> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, key, value, reply);
	}
};

struct ClearRequest {
	constexpr static FileIdentifier file_identifier = 8500026;
	std::string from;
	std::string to;
	ReplyPromise<Void> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, from, to, reply);
	}
};

															#line 3078 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via kvStoreServer()
															#line 313 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class KvStoreServerActor>
															#line 313 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class KvStoreServerActorState {
															#line 3085 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 313 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	KvStoreServerActorState() 
															#line 313 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 314 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : inf(),
															#line 315 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   store()
															#line 3094 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("kvStoreServer", reinterpret_cast<unsigned long>(this));

	}
	~KvStoreServerActorState() 
	{
		fdb_probe_actor_destroy("kvStoreServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 316 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			inf.connect.makeWellKnownEndpoint(WLTOKEN_SIMPLE_KV_SERVER, TaskPriority::DefaultEndpoint);
															#line 317 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 3111 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~KvStoreServerActorState();
		static_cast<KvStoreServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 319 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto __when_expr_0 = inf.connect.getFuture();
															#line 3141 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetKVInterface>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetKVInterface>>::value, "invalid type");
															#line 318 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<KvStoreServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3145 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 323 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto __when_expr_1 = inf.get.getFuture();
															#line 3149 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<GetRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<GetRequest>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 331 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto __when_expr_2 = inf.set.getFuture();
															#line 3154 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<SetRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<SetRequest>>::value, "invalid type");
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
															#line 335 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto __when_expr_3 = inf.clear.getFuture();
															#line 3159 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<ClearRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<ClearRequest>>::value, "invalid type");
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.pop(), loopDepth); };
		static_cast<KvStoreServerActor*>(this)->actor_wait_state = 1;
															#line 319 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< KvStoreServerActor, 0, GetKVInterface >*>(static_cast<KvStoreServerActor*>(this)));
															#line 323 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< KvStoreServerActor, 1, GetRequest >*>(static_cast<KvStoreServerActor*>(this)));
															#line 331 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< KvStoreServerActor, 2, SetRequest >*>(static_cast<KvStoreServerActor*>(this)));
															#line 335 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< KvStoreServerActor, 3, ClearRequest >*>(static_cast<KvStoreServerActor*>(this)));
															#line 3171 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetKVInterface const& req,int loopDepth) 
	{
															#line 320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Received connection attempt\n";
															#line 321 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(inf);
															#line 3188 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetKVInterface && req,int loopDepth) 
	{
															#line 320 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Received connection attempt\n";
															#line 321 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(inf);
															#line 3199 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetRequest const& req,int loopDepth) 
	{
															#line 324 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto iter = store.find(req.key);
															#line 325 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (iter == store.end())
															#line 3210 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
															#line 326 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			req.reply.sendError(io_error());
															#line 3214 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
		else
		{
															#line 328 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			req.reply.send(iter->second);
															#line 3220 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetRequest && req,int loopDepth) 
	{
															#line 324 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto iter = store.find(req.key);
															#line 325 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (iter == store.end())
															#line 3232 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
															#line 326 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			req.reply.sendError(io_error());
															#line 3236 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
		else
		{
															#line 328 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			req.reply.send(iter->second);
															#line 3242 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(SetRequest const& req,int loopDepth) 
	{
															#line 332 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		store[req.key] = req.value;
															#line 333 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(Void());
															#line 3254 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(SetRequest && req,int loopDepth) 
	{
															#line 332 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		store[req.key] = req.value;
															#line 333 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(Void());
															#line 3265 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(ClearRequest const& req,int loopDepth) 
	{
															#line 336 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto from = store.lower_bound(req.from);
															#line 337 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto to = store.lower_bound(req.to);
															#line 338 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		for(;from != store.end() && from != to;) {
															#line 339 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			auto next = from;
															#line 340 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			++next;
															#line 341 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			store.erase(from);
															#line 342 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			from = next;
															#line 3286 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
															#line 344 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(Void());
															#line 3290 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(ClearRequest && req,int loopDepth) 
	{
															#line 336 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto from = store.lower_bound(req.from);
															#line 337 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto to = store.lower_bound(req.to);
															#line 338 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		for(;from != store.end() && from != to;) {
															#line 339 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			auto next = from;
															#line 340 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			++next;
															#line 341 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			store.erase(from);
															#line 342 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			from = next;
															#line 3311 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
															#line 344 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(Void());
															#line 3315 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<KvStoreServerActor*>(this)->actor_wait_state > 0) static_cast<KvStoreServerActor*>(this)->actor_wait_state = 0;
		static_cast<KvStoreServerActor*>(this)->ActorSingleCallback< KvStoreServerActor, 0, GetKVInterface >::remove();
		static_cast<KvStoreServerActor*>(this)->ActorSingleCallback< KvStoreServerActor, 1, GetRequest >::remove();
		static_cast<KvStoreServerActor*>(this)->ActorSingleCallback< KvStoreServerActor, 2, SetRequest >::remove();
		static_cast<KvStoreServerActor*>(this)->ActorSingleCallback< KvStoreServerActor, 3, ClearRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< KvStoreServerActor, 0, GetKVInterface >*,GetKVInterface const& value) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< KvStoreServerActor, 0, GetKVInterface >*,GetKVInterface && value) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< KvStoreServerActor, 0, GetKVInterface >*,Error err) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< KvStoreServerActor, 1, GetRequest >*,GetRequest const& value) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< KvStoreServerActor, 1, GetRequest >*,GetRequest && value) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< KvStoreServerActor, 1, GetRequest >*,Error err) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< KvStoreServerActor, 2, SetRequest >*,SetRequest const& value) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< KvStoreServerActor, 2, SetRequest >*,SetRequest && value) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< KvStoreServerActor, 2, SetRequest >*,Error err) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< KvStoreServerActor, 3, ClearRequest >*,ClearRequest const& value) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< KvStoreServerActor, 3, ClearRequest >*,ClearRequest && value) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< KvStoreServerActor, 3, ClearRequest >*,Error err) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 314 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	SimpleKeyValueStoreInterface inf;
															#line 315 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	std::map<std::string, std::string> store;
															#line 3561 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via kvStoreServer()
															#line 313 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class KvStoreServerActor final : public Actor<Void>, public ActorSingleCallback< KvStoreServerActor, 0, GetKVInterface >, public ActorSingleCallback< KvStoreServerActor, 1, GetRequest >, public ActorSingleCallback< KvStoreServerActor, 2, SetRequest >, public ActorSingleCallback< KvStoreServerActor, 3, ClearRequest >, public FastAllocated<KvStoreServerActor>, public KvStoreServerActorState<KvStoreServerActor> {
															#line 3566 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<KvStoreServerActor>::operator new;
	using FastAllocated<KvStoreServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(186950356840017408UL, 17960855402379522816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< KvStoreServerActor, 0, GetKVInterface >;
friend struct ActorSingleCallback< KvStoreServerActor, 1, GetRequest >;
friend struct ActorSingleCallback< KvStoreServerActor, 2, SetRequest >;
friend struct ActorSingleCallback< KvStoreServerActor, 3, ClearRequest >;
															#line 313 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	KvStoreServerActor() 
															#line 3586 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   KvStoreServerActorState<KvStoreServerActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5912263144271601152UL, 1978734525476857856UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("kvStoreServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< KvStoreServerActor, 0, GetKVInterface >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 313 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> kvStoreServer(  ) {
															#line 313 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new KvStoreServerActor());
															#line 3619 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 349 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 3624 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via connect()
															#line 350 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class ConnectActor>
															#line 350 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class ConnectActorState {
															#line 3631 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 350 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	ConnectActorState() 
															#line 350 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	{
															#line 3637 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		fdb_probe_actor_create("connect", reinterpret_cast<unsigned long>(this));

	}
	~ConnectActorState() 
	{
		fdb_probe_actor_destroy("connect", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 351 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			std::cout << format("%llu: Connect...\n", uint64_t(g_network->now()));
															#line 352 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			auto reqStream = RequestStream<GetKVInterface>(Endpoint::wellKnown({ serverAddress }, WLTOKEN_SIMPLE_KV_SERVER));
															#line 353 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<SimpleKeyValueStoreInterface> __when_expr_0 = reqStream.getReply(GetKVInterface());
															#line 353 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<ConnectActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3657 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConnectActor*>(this)->actor_wait_state = 1;
															#line 353 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConnectActor, 0, SimpleKeyValueStoreInterface >*>(static_cast<ConnectActor*>(this)));
															#line 3662 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConnectActorState();
		static_cast<ConnectActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(SimpleKeyValueStoreInterface const& result,int loopDepth) 
	{
															#line 354 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("%llu: done..\n", uint64_t(g_network->now()));
															#line 355 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<ConnectActor*>(this)->SAV<SimpleKeyValueStoreInterface>::futures) { (void)(result); this->~ConnectActorState(); static_cast<ConnectActor*>(this)->destroy(); return 0; }
															#line 3687 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<ConnectActor*>(this)->SAV< SimpleKeyValueStoreInterface >::value()) SimpleKeyValueStoreInterface(result);
		this->~ConnectActorState();
		static_cast<ConnectActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(SimpleKeyValueStoreInterface && result,int loopDepth) 
	{
															#line 354 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("%llu: done..\n", uint64_t(g_network->now()));
															#line 355 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<ConnectActor*>(this)->SAV<SimpleKeyValueStoreInterface>::futures) { (void)(result); this->~ConnectActorState(); static_cast<ConnectActor*>(this)->destroy(); return 0; }
															#line 3701 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<ConnectActor*>(this)->SAV< SimpleKeyValueStoreInterface >::value()) SimpleKeyValueStoreInterface(result);
		this->~ConnectActorState();
		static_cast<ConnectActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(SimpleKeyValueStoreInterface const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(SimpleKeyValueStoreInterface && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConnectActor*>(this)->actor_wait_state > 0) static_cast<ConnectActor*>(this)->actor_wait_state = 0;
		static_cast<ConnectActor*>(this)->ActorCallback< ConnectActor, 0, SimpleKeyValueStoreInterface >::remove();

	}
	void a_callback_fire(ActorCallback< ConnectActor, 0, SimpleKeyValueStoreInterface >*,SimpleKeyValueStoreInterface const& value) 
	{
		fdb_probe_actor_enter("connect", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connect", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConnectActor, 0, SimpleKeyValueStoreInterface >*,SimpleKeyValueStoreInterface && value) 
	{
		fdb_probe_actor_enter("connect", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connect", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConnectActor, 0, SimpleKeyValueStoreInterface >*,Error err) 
	{
		fdb_probe_actor_enter("connect", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connect", reinterpret_cast<unsigned long>(this), 0);

	}
};
// This generated class is to be used only via connect()
															#line 350 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class ConnectActor final : public Actor<SimpleKeyValueStoreInterface>, public ActorCallback< ConnectActor, 0, SimpleKeyValueStoreInterface >, public FastAllocated<ConnectActor>, public ConnectActorState<ConnectActor> {
															#line 3788 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<ConnectActor>::operator new;
	using FastAllocated<ConnectActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11616474015461907712UL, 2233266653867705856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<SimpleKeyValueStoreInterface>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConnectActor, 0, SimpleKeyValueStoreInterface >;
															#line 350 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	ConnectActor() 
															#line 3805 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<SimpleKeyValueStoreInterface>(),
		   ConnectActorState<ConnectActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("connect", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6918112119896711168UL, 6671612149293629184UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("connect");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("connect", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConnectActor, 0, SimpleKeyValueStoreInterface >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 350 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<SimpleKeyValueStoreInterface> connect(  ) {
															#line 350 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<SimpleKeyValueStoreInterface>(new ConnectActor());
															#line 3838 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 357 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 3843 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via kvSimpleClient()
															#line 358 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class KvSimpleClientActor>
															#line 358 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class KvSimpleClientActorState {
															#line 3850 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 358 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	KvSimpleClientActorState() 
															#line 358 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	{
															#line 3856 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		fdb_probe_actor_create("kvSimpleClient", reinterpret_cast<unsigned long>(this));

	}
	~KvSimpleClientActorState() 
	{
		fdb_probe_actor_destroy("kvSimpleClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 359 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<SimpleKeyValueStoreInterface> __when_expr_0 = connect();
															#line 359 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<KvSimpleClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3872 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<KvSimpleClientActor*>(this)->actor_wait_state = 1;
															#line 359 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< KvSimpleClientActor, 0, SimpleKeyValueStoreInterface >*>(static_cast<KvSimpleClientActor*>(this)));
															#line 3877 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~KvSimpleClientActorState();
		static_cast<KvSimpleClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 360 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("Set %s -> %s\n", "foo", "bar");
															#line 361 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		SetRequest setRequest;
															#line 362 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		setRequest.key = "foo";
															#line 363 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		setRequest.value = "bar";
															#line 364 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_1 = server.set.getReply(setRequest);
															#line 364 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<KvSimpleClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3910 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<KvSimpleClientActor*>(this)->actor_wait_state = 2;
															#line 364 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< KvSimpleClientActor, 1, Void >*>(static_cast<KvSimpleClientActor*>(this)));
															#line 3915 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(SimpleKeyValueStoreInterface const& __server,int loopDepth) 
	{
															#line 359 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		server = __server;
															#line 3924 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(SimpleKeyValueStoreInterface && __server,int loopDepth) 
	{
		server = std::move(__server);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<KvSimpleClientActor*>(this)->actor_wait_state > 0) static_cast<KvSimpleClientActor*>(this)->actor_wait_state = 0;
		static_cast<KvSimpleClientActor*>(this)->ActorCallback< KvSimpleClientActor, 0, SimpleKeyValueStoreInterface >::remove();

	}
	void a_callback_fire(ActorCallback< KvSimpleClientActor, 0, SimpleKeyValueStoreInterface >*,SimpleKeyValueStoreInterface const& value) 
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< KvSimpleClientActor, 0, SimpleKeyValueStoreInterface >*,SimpleKeyValueStoreInterface && value) 
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< KvSimpleClientActor, 0, SimpleKeyValueStoreInterface >*,Error err) 
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 365 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		GetRequest getRequest;
															#line 366 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		getRequest.key = "foo";
															#line 367 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = server.get.getReply(getRequest);
															#line 367 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<KvSimpleClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4009 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<KvSimpleClientActor*>(this)->actor_wait_state = 3;
															#line 367 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< KvSimpleClientActor, 2, std::string >*>(static_cast<KvSimpleClientActor*>(this)));
															#line 4014 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 365 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		GetRequest getRequest;
															#line 366 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		getRequest.key = "foo";
															#line 367 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = server.get.getReply(getRequest);
															#line 367 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<KvSimpleClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4029 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<KvSimpleClientActor*>(this)->actor_wait_state = 3;
															#line 367 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< KvSimpleClientActor, 2, std::string >*>(static_cast<KvSimpleClientActor*>(this)));
															#line 4034 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<KvSimpleClientActor*>(this)->actor_wait_state > 0) static_cast<KvSimpleClientActor*>(this)->actor_wait_state = 0;
		static_cast<KvSimpleClientActor*>(this)->ActorCallback< KvSimpleClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KvSimpleClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< KvSimpleClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< KvSimpleClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(std::string const& value,int loopDepth) 
	{
															#line 368 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("get(%s) -> %s\n", "foo", value.c_str());
															#line 369 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<KvSimpleClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~KvSimpleClientActorState(); static_cast<KvSimpleClientActor*>(this)->destroy(); return 0; }
															#line 4120 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<KvSimpleClientActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~KvSimpleClientActorState();
		static_cast<KvSimpleClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(std::string && value,int loopDepth) 
	{
															#line 368 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("get(%s) -> %s\n", "foo", value.c_str());
															#line 369 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<KvSimpleClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~KvSimpleClientActorState(); static_cast<KvSimpleClientActor*>(this)->destroy(); return 0; }
															#line 4134 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<KvSimpleClientActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~KvSimpleClientActorState();
		static_cast<KvSimpleClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::string const& value,int loopDepth) 
	{
		loopDepth = a_body1cont3(value, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::string && value,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<KvSimpleClientActor*>(this)->actor_wait_state > 0) static_cast<KvSimpleClientActor*>(this)->actor_wait_state = 0;
		static_cast<KvSimpleClientActor*>(this)->ActorCallback< KvSimpleClientActor, 2, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< KvSimpleClientActor, 2, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< KvSimpleClientActor, 2, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< KvSimpleClientActor, 2, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 359 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	SimpleKeyValueStoreInterface server;
															#line 4219 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via kvSimpleClient()
															#line 358 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class KvSimpleClientActor final : public Actor<Void>, public ActorCallback< KvSimpleClientActor, 0, SimpleKeyValueStoreInterface >, public ActorCallback< KvSimpleClientActor, 1, Void >, public ActorCallback< KvSimpleClientActor, 2, std::string >, public FastAllocated<KvSimpleClientActor>, public KvSimpleClientActorState<KvSimpleClientActor> {
															#line 4224 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<KvSimpleClientActor>::operator new;
	using FastAllocated<KvSimpleClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11263331866204781568UL, 3542784720535407872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< KvSimpleClientActor, 0, SimpleKeyValueStoreInterface >;
friend struct ActorCallback< KvSimpleClientActor, 1, Void >;
friend struct ActorCallback< KvSimpleClientActor, 2, std::string >;
															#line 358 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	KvSimpleClientActor() 
															#line 4243 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   KvSimpleClientActorState<KvSimpleClientActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8014170538980641792UL, 9511851362767628032UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("kvSimpleClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< KvSimpleClientActor, 0, SimpleKeyValueStoreInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< KvSimpleClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< KvSimpleClientActor, 2, std::string >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 358 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> kvSimpleClient(  ) {
															#line 358 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new KvSimpleClientActor());
															#line 4278 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 371 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 4283 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via kvClient()
															#line 372 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class KvClientActor>
															#line 372 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class KvClientActorState {
															#line 4290 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 372 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	KvClientActorState(SimpleKeyValueStoreInterface const& server,std::shared_ptr<uint64_t> const& ops) 
															#line 372 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 372 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : server(server),
															#line 372 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   ops(ops),
															#line 373 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   timeout(delay(20)),
															#line 374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   rangeSize(2 << 12)
															#line 4303 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("kvClient", reinterpret_cast<unsigned long>(this));

	}
	~KvClientActorState() 
	{
		fdb_probe_actor_destroy("kvClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 375 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 4318 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~KvClientActorState();
		static_cast<KvClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 376 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		SetRequest setRequest;
															#line 377 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		setRequest.key = std::to_string(deterministicRandom()->randomInt(0, rangeSize));
															#line 378 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		setRequest.value = "foo";
															#line 379 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_0 = server.set.getReply(setRequest);
															#line 379 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<KvClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4356 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<KvClientActor*>(this)->actor_wait_state = 1;
															#line 379 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< KvClientActor, 0, Void >*>(static_cast<KvClientActor*>(this)));
															#line 4361 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 380 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		++(*ops);
															#line 4370 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		try {
															#line 382 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			GetRequest getRequest;
															#line 383 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			getRequest.key = std::to_string(deterministicRandom()->randomInt(0, rangeSize));
															#line 384 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<std::string> __when_expr_1 = server.get.getReply(getRequest);
															#line 384 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<KvClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4380 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<KvClientActor*>(this)->actor_wait_state = 2;
															#line 384 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< KvClientActor, 1, std::string >*>(static_cast<KvClientActor*>(this)));
															#line 4385 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 380 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		++(*ops);
															#line 4400 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		try {
															#line 382 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			GetRequest getRequest;
															#line 383 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			getRequest.key = std::to_string(deterministicRandom()->randomInt(0, rangeSize));
															#line 384 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<std::string> __when_expr_1 = server.get.getReply(getRequest);
															#line 384 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<KvClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4410 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<KvClientActor*>(this)->actor_wait_state = 2;
															#line 384 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< KvClientActor, 1, std::string >*>(static_cast<KvClientActor*>(this)));
															#line 4415 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<KvClientActor*>(this)->actor_wait_state > 0) static_cast<KvClientActor*>(this)->actor_wait_state = 0;
		static_cast<KvClientActor*>(this)->ActorCallback< KvClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KvClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< KvClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< KvClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 391 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		int from = deterministicRandom()->randomInt(0, rangeSize);
															#line 392 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		ClearRequest clearRequest;
															#line 393 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		clearRequest.from = std::to_string(from);
															#line 394 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		clearRequest.to = std::to_string(from + 100);
															#line 395 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_2 = server.clear.getReply(clearRequest);
															#line 395 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<KvClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4515 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<KvClientActor*>(this)->actor_wait_state = 3;
															#line 395 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< KvClientActor, 2, Void >*>(static_cast<KvClientActor*>(this)));
															#line 4520 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 387 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (e.code() != error_code_io_error)
															#line 4530 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			{
															#line 388 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 4534 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(std::string const& _,int loopDepth) 
	{
															#line 385 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		++(*ops);
															#line 4550 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(std::string && _,int loopDepth) 
	{
															#line 385 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		++(*ops);
															#line 4559 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::string const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::string && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<KvClientActor*>(this)->actor_wait_state > 0) static_cast<KvClientActor*>(this)->actor_wait_state = 0;
		static_cast<KvClientActor*>(this)->ActorCallback< KvClientActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< KvClientActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< KvClientActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< KvClientActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 396 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		++(*ops);
															#line 397 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (timeout.isReady())
															#line 4658 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
															#line 399 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (!static_cast<KvClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~KvClientActorState(); static_cast<KvClientActor*>(this)->destroy(); return 0; }
															#line 4662 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			new (&static_cast<KvClientActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~KvClientActorState();
			static_cast<KvClientActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 396 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		++(*ops);
															#line 397 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (timeout.isReady())
															#line 4678 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
															#line 399 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (!static_cast<KvClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~KvClientActorState(); static_cast<KvClientActor*>(this)->destroy(); return 0; }
															#line 4682 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			new (&static_cast<KvClientActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~KvClientActorState();
			static_cast<KvClientActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<KvClientActor*>(this)->actor_wait_state > 0) static_cast<KvClientActor*>(this)->actor_wait_state = 0;
		static_cast<KvClientActor*>(this)->ActorCallback< KvClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KvClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< KvClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< KvClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 372 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	SimpleKeyValueStoreInterface server;
															#line 372 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	std::shared_ptr<uint64_t> ops;
															#line 373 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Future<Void> timeout;
															#line 374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	int rangeSize;
															#line 4775 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via kvClient()
															#line 372 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class KvClientActor final : public Actor<Void>, public ActorCallback< KvClientActor, 0, Void >, public ActorCallback< KvClientActor, 1, std::string >, public ActorCallback< KvClientActor, 2, Void >, public FastAllocated<KvClientActor>, public KvClientActorState<KvClientActor> {
															#line 4780 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<KvClientActor>::operator new;
	using FastAllocated<KvClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9891405481223930880UL, 4277825824262704896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< KvClientActor, 0, Void >;
friend struct ActorCallback< KvClientActor, 1, std::string >;
friend struct ActorCallback< KvClientActor, 2, Void >;
															#line 372 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	KvClientActor(SimpleKeyValueStoreInterface const& server,std::shared_ptr<uint64_t> const& ops) 
															#line 4799 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   KvClientActorState<KvClientActor>(server, ops),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13424801593058757120UL, 15667845603933868800UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("kvClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< KvClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< KvClientActor, 1, std::string >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< KvClientActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 372 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> kvClient( SimpleKeyValueStoreInterface const& server, std::shared_ptr<uint64_t> const& ops ) {
															#line 372 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new KvClientActor(server, ops));
															#line 4834 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 403 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 4839 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via throughputMeasurement()
															#line 404 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class ThroughputMeasurementActor>
															#line 404 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class ThroughputMeasurementActorState {
															#line 4846 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 404 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	ThroughputMeasurementActorState(std::shared_ptr<uint64_t> const& operations) 
															#line 404 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 404 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : operations(operations)
															#line 4853 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("throughputMeasurement", reinterpret_cast<unsigned long>(this));

	}
	~ThroughputMeasurementActorState() 
	{
		fdb_probe_actor_destroy("throughputMeasurement", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 405 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 4868 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ThroughputMeasurementActorState();
		static_cast<ThroughputMeasurementActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 406 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(1.0);
															#line 406 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<ThroughputMeasurementActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4900 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ThroughputMeasurementActor*>(this)->actor_wait_state = 1;
															#line 406 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ThroughputMeasurementActor, 0, Void >*>(static_cast<ThroughputMeasurementActor*>(this)));
															#line 4905 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 407 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("%llu op/s\n", *operations);
															#line 408 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		*operations = 0;
															#line 4916 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 407 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("%llu op/s\n", *operations);
															#line 408 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		*operations = 0;
															#line 4927 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ThroughputMeasurementActor*>(this)->actor_wait_state > 0) static_cast<ThroughputMeasurementActor*>(this)->actor_wait_state = 0;
		static_cast<ThroughputMeasurementActor*>(this)->ActorCallback< ThroughputMeasurementActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ThroughputMeasurementActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("throughputMeasurement", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThroughputMeasurementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throughputMeasurement", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ThroughputMeasurementActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("throughputMeasurement", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThroughputMeasurementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throughputMeasurement", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ThroughputMeasurementActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("throughputMeasurement", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ThroughputMeasurementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throughputMeasurement", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 404 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	std::shared_ptr<uint64_t> operations;
															#line 5009 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via throughputMeasurement()
															#line 404 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class ThroughputMeasurementActor final : public Actor<Void>, public ActorCallback< ThroughputMeasurementActor, 0, Void >, public FastAllocated<ThroughputMeasurementActor>, public ThroughputMeasurementActorState<ThroughputMeasurementActor> {
															#line 5014 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<ThroughputMeasurementActor>::operator new;
	using FastAllocated<ThroughputMeasurementActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5870880432270869248UL, 380412591501846272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ThroughputMeasurementActor, 0, Void >;
															#line 404 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	ThroughputMeasurementActor(std::shared_ptr<uint64_t> const& operations) 
															#line 5031 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   ThroughputMeasurementActorState<ThroughputMeasurementActor>(operations),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("throughputMeasurement", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9055920685224049152UL, 13522355584684806144UL);
		ActorExecutionContextHelper __helper(static_cast<ThroughputMeasurementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("throughputMeasurement");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("throughputMeasurement", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ThroughputMeasurementActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 404 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> throughputMeasurement( std::shared_ptr<uint64_t> const& operations ) {
															#line 404 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new ThroughputMeasurementActor(operations));
															#line 5064 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 411 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 5069 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via multipleClients()
															#line 412 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class MultipleClientsActor>
															#line 412 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class MultipleClientsActorState {
															#line 5076 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 412 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	MultipleClientsActorState() 
															#line 412 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	{
															#line 5082 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		fdb_probe_actor_create("multipleClients", reinterpret_cast<unsigned long>(this));

	}
	~MultipleClientsActorState() 
	{
		fdb_probe_actor_destroy("multipleClients", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<SimpleKeyValueStoreInterface> __when_expr_0 = connect();
															#line 413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<MultipleClientsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5098 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MultipleClientsActor*>(this)->actor_wait_state = 1;
															#line 413 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MultipleClientsActor, 0, SimpleKeyValueStoreInterface >*>(static_cast<MultipleClientsActor*>(this)));
															#line 5103 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MultipleClientsActorState();
		static_cast<MultipleClientsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(SimpleKeyValueStoreInterface const& server,int loopDepth) 
	{
															#line 414 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto ops = std::make_shared<uint64_t>(0);
															#line 415 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::vector<Future<Void>> clients(100);
															#line 416 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		for( auto& f : clients ) {
															#line 417 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			f = kvClient(server, ops);
															#line 5132 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
															#line 419 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto done = waitForAll(clients);
															#line 420 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_1 = done || throughputMeasurement(ops);
															#line 420 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<MultipleClientsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5140 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MultipleClientsActor*>(this)->actor_wait_state = 2;
															#line 420 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MultipleClientsActor, 1, Void >*>(static_cast<MultipleClientsActor*>(this)));
															#line 5145 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(SimpleKeyValueStoreInterface && server,int loopDepth) 
	{
															#line 414 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto ops = std::make_shared<uint64_t>(0);
															#line 415 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::vector<Future<Void>> clients(100);
															#line 416 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		for( auto& f : clients ) {
															#line 417 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			f = kvClient(server, ops);
															#line 5160 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
															#line 419 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto done = waitForAll(clients);
															#line 420 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_1 = done || throughputMeasurement(ops);
															#line 420 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<MultipleClientsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5168 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MultipleClientsActor*>(this)->actor_wait_state = 2;
															#line 420 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MultipleClientsActor, 1, Void >*>(static_cast<MultipleClientsActor*>(this)));
															#line 5173 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(SimpleKeyValueStoreInterface const& server,int loopDepth) 
	{
		loopDepth = a_body1cont1(server, loopDepth);

		return loopDepth;
	}
	int a_body1when1(SimpleKeyValueStoreInterface && server,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(server), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MultipleClientsActor*>(this)->actor_wait_state > 0) static_cast<MultipleClientsActor*>(this)->actor_wait_state = 0;
		static_cast<MultipleClientsActor*>(this)->ActorCallback< MultipleClientsActor, 0, SimpleKeyValueStoreInterface >::remove();

	}
	void a_callback_fire(ActorCallback< MultipleClientsActor, 0, SimpleKeyValueStoreInterface >*,SimpleKeyValueStoreInterface const& value) 
	{
		fdb_probe_actor_enter("multipleClients", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MultipleClientsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("multipleClients", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MultipleClientsActor, 0, SimpleKeyValueStoreInterface >*,SimpleKeyValueStoreInterface && value) 
	{
		fdb_probe_actor_enter("multipleClients", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MultipleClientsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("multipleClients", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MultipleClientsActor, 0, SimpleKeyValueStoreInterface >*,Error err) 
	{
		fdb_probe_actor_enter("multipleClients", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MultipleClientsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("multipleClients", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 421 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<MultipleClientsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MultipleClientsActorState(); static_cast<MultipleClientsActor*>(this)->destroy(); return 0; }
															#line 5257 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<MultipleClientsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MultipleClientsActorState();
		static_cast<MultipleClientsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 421 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<MultipleClientsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MultipleClientsActorState(); static_cast<MultipleClientsActor*>(this)->destroy(); return 0; }
															#line 5269 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<MultipleClientsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MultipleClientsActorState();
		static_cast<MultipleClientsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MultipleClientsActor*>(this)->actor_wait_state > 0) static_cast<MultipleClientsActor*>(this)->actor_wait_state = 0;
		static_cast<MultipleClientsActor*>(this)->ActorCallback< MultipleClientsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MultipleClientsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("multipleClients", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MultipleClientsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("multipleClients", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MultipleClientsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("multipleClients", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MultipleClientsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("multipleClients", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MultipleClientsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("multipleClients", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MultipleClientsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("multipleClients", reinterpret_cast<unsigned long>(this), 1);

	}
};
// This generated class is to be used only via multipleClients()
															#line 412 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class MultipleClientsActor final : public Actor<Void>, public ActorCallback< MultipleClientsActor, 0, SimpleKeyValueStoreInterface >, public ActorCallback< MultipleClientsActor, 1, Void >, public FastAllocated<MultipleClientsActor>, public MultipleClientsActorState<MultipleClientsActor> {
															#line 5356 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<MultipleClientsActor>::operator new;
	using FastAllocated<MultipleClientsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13505845186136161792UL, 10260895377035393792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MultipleClientsActor, 0, SimpleKeyValueStoreInterface >;
friend struct ActorCallback< MultipleClientsActor, 1, Void >;
															#line 412 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	MultipleClientsActor() 
															#line 5374 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   MultipleClientsActorState<MultipleClientsActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("multipleClients", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5890172071585402880UL, 17513529943277648384UL);
		ActorExecutionContextHelper __helper(static_cast<MultipleClientsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("multipleClients");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("multipleClients", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MultipleClientsActor, 0, SimpleKeyValueStoreInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MultipleClientsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 412 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> multipleClients(  ) {
															#line 412 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new MultipleClientsActor());
															#line 5408 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 423 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

std::string clusterFile = "fdb.cluster";

															#line 5415 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via logThroughput()
															#line 426 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class LogThroughputActor>
															#line 426 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class LogThroughputActorState {
															#line 5422 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 426 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	LogThroughputActorState(int64_t* const& v,Key* const& next) 
															#line 426 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 426 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : v(v),
															#line 426 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   next(next)
															#line 5431 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("logThroughput", reinterpret_cast<unsigned long>(this));

	}
	~LogThroughputActorState() 
	{
		fdb_probe_actor_destroy("logThroughput", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 427 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 5446 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LogThroughputActorState();
		static_cast<LogThroughputActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 428 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		last = *v;
															#line 429 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(1);
															#line 429 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<LogThroughputActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5480 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<LogThroughputActor*>(this)->actor_wait_state = 1;
															#line 429 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LogThroughputActor, 0, Void >*>(static_cast<LogThroughputActor*>(this)));
															#line 5485 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 430 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		fmt::print("throughput: {} bytes/s, next: {}\n", *v - last, printable(*next).c_str());
															#line 5494 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 430 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		fmt::print("throughput: {} bytes/s, next: {}\n", *v - last, printable(*next).c_str());
															#line 5503 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LogThroughputActor*>(this)->actor_wait_state > 0) static_cast<LogThroughputActor*>(this)->actor_wait_state = 0;
		static_cast<LogThroughputActor*>(this)->ActorCallback< LogThroughputActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogThroughputActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logThroughput", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogThroughputActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logThroughput", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LogThroughputActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logThroughput", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogThroughputActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logThroughput", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LogThroughputActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logThroughput", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogThroughputActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logThroughput", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 426 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	int64_t* v;
															#line 426 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Key* next;
															#line 428 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	int64_t last;
															#line 5589 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via logThroughput()
															#line 426 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class LogThroughputActor final : public Actor<Void>, public ActorCallback< LogThroughputActor, 0, Void >, public FastAllocated<LogThroughputActor>, public LogThroughputActorState<LogThroughputActor> {
															#line 5594 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<LogThroughputActor>::operator new;
	using FastAllocated<LogThroughputActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6753426030479551744UL, 16731031729197505024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LogThroughputActor, 0, Void >;
															#line 426 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	LogThroughputActor(int64_t* const& v,Key* const& next) 
															#line 5611 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   LogThroughputActorState<LogThroughputActor>(v, next),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("logThroughput", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2415456824429687552UL, 17289377887960322816UL);
		ActorExecutionContextHelper __helper(static_cast<LogThroughputActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("logThroughput");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("logThroughput", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LogThroughputActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 426 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> logThroughput( int64_t* const& v, Key* const& next ) {
															#line 426 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new LogThroughputActor(v, next));
															#line 5644 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 433 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 5649 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via fdbClientStream()
															#line 434 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class FdbClientStreamActor>
															#line 434 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class FdbClientStreamActorState {
															#line 5656 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 434 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	FdbClientStreamActorState() 
															#line 434 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 435 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : db(Database::createDatabase(clusterFile, 300)),
															#line 436 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   tx(db),
															#line 437 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   next(),
															#line 438 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   bytes(0),
															#line 439 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   logFuture(logThroughput(&bytes, &next))
															#line 5671 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("fdbClientStream", reinterpret_cast<unsigned long>(this));

	}
	~FdbClientStreamActorState() 
	{
		fdb_probe_actor_destroy("fdbClientStream", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 440 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 5686 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FdbClientStreamActorState();
		static_cast<FdbClientStreamActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 461 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<FdbClientStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FdbClientStreamActorState(); static_cast<FdbClientStreamActor*>(this)->destroy(); return 0; }
															#line 5709 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<FdbClientStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FdbClientStreamActorState();
		static_cast<FdbClientStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 441 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		results = PromiseStream<Standalone<RangeResultRef>>();
															#line 5728 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		try {
															#line 443 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			stream = tx.getRangeStream(results, KeySelector(firstGreaterOrEqual(next), next.arena()), KeySelector(firstGreaterOrEqual(normalKeys.end)), GetRangeLimits());
															#line 447 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 5734 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 455 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 5769 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 458 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tx.onError(e);
															#line 458 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<FdbClientStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5777 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FdbClientStreamActor*>(this)->actor_wait_state = 2;
															#line 458 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FdbClientStreamActor, 1, Void >*>(static_cast<FdbClientStreamActor*>(this)));
															#line 5782 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 448 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto __when_expr_0 = results.getFuture();
															#line 5804 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<Standalone<RangeResultRef>>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<Standalone<RangeResultRef>>>::value, "invalid type");
															#line 448 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<FdbClientStreamActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5808 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<FdbClientStreamActor*>(this)->actor_wait_state = 1;
															#line 448 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >*>(static_cast<FdbClientStreamActor*>(this)));
															#line 5813 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Standalone<RangeResultRef> const& range,int loopDepth) 
	{
															#line 449 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (range.size())
															#line 5822 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
															#line 450 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			bytes += range.expectedSize();
															#line 451 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			next = keyAfter(range.back().key);
															#line 5828 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Standalone<RangeResultRef> && range,int loopDepth) 
	{
															#line 449 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (range.size())
															#line 5838 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
															#line 450 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			bytes += range.expectedSize();
															#line 451 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			next = keyAfter(range.back().key);
															#line 5844 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Standalone<RangeResultRef> const& range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(range, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Standalone<RangeResultRef> && range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FdbClientStreamActor*>(this)->actor_wait_state > 0) static_cast<FdbClientStreamActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientStreamActor*>(this)->ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FdbClientStreamActor*>(this)->actor_wait_state > 0) static_cast<FdbClientStreamActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientStreamActor*>(this)->ActorCallback< FdbClientStreamActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientStreamActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FdbClientStreamActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FdbClientStreamActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 435 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Database db;
															#line 436 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Transaction tx;
															#line 437 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Key next;
															#line 438 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	int64_t bytes;
															#line 439 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Future<Void> logFuture;
															#line 441 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	PromiseStream<Standalone<RangeResultRef>> results;
															#line 443 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Future<Void> stream;
															#line 6026 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via fdbClientStream()
															#line 434 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class FdbClientStreamActor final : public Actor<Void>, public ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >, public ActorCallback< FdbClientStreamActor, 1, Void >, public FastAllocated<FdbClientStreamActor>, public FdbClientStreamActorState<FdbClientStreamActor> {
															#line 6031 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<FdbClientStreamActor>::operator new;
	using FastAllocated<FdbClientStreamActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12777979534606703872UL, 12938302624045387520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >;
friend struct ActorCallback< FdbClientStreamActor, 1, Void >;
															#line 434 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	FdbClientStreamActor() 
															#line 6049 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   FdbClientStreamActorState<FdbClientStreamActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11970803611283168000UL, 3665065125492980736UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fdbClientStream");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FdbClientStreamActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 434 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> fdbClientStream(  ) {
															#line 434 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new FdbClientStreamActor());
															#line 6083 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 463 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 6088 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via fdbClientGetRange()
															#line 464 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class FdbClientGetRangeActor>
															#line 464 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class FdbClientGetRangeActorState {
															#line 6095 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 464 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	FdbClientGetRangeActorState() 
															#line 464 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 465 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : db(Database::createDatabase(clusterFile, 300)),
															#line 466 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   tx(db),
															#line 467 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   next(),
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   bytes(0),
															#line 469 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   logFuture(logThroughput(&bytes, &next))
															#line 6110 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("fdbClientGetRange", reinterpret_cast<unsigned long>(this));

	}
	~FdbClientGetRangeActorState() 
	{
		fdb_probe_actor_destroy("fdbClientGetRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 470 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 6125 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FdbClientGetRangeActorState();
		static_cast<FdbClientGetRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 485 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<FdbClientGetRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FdbClientGetRangeActorState(); static_cast<FdbClientGetRangeActor*>(this)->destroy(); return 0; }
															#line 6148 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<FdbClientGetRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FdbClientGetRangeActorState();
		static_cast<FdbClientGetRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 472 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<Standalone<RangeResultRef>> __when_expr_0 = tx.getRange(KeySelector(firstGreaterOrEqual(next), next.arena()), KeySelector(firstGreaterOrEqual(normalKeys.end)), GetRangeLimits(GetRangeLimits::ROW_LIMIT_UNLIMITED, CLIENT_KNOBS->REPLY_BYTE_LIMIT));
															#line 472 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6170 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state = 1;
															#line 472 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >*>(static_cast<FdbClientGetRangeActor*>(this)));
															#line 6175 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 482 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tx.onError(e);
															#line 482 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6212 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state = 2;
															#line 482 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FdbClientGetRangeActor, 1, Void >*>(static_cast<FdbClientGetRangeActor*>(this)));
															#line 6217 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<RangeResultRef> const& range,int loopDepth) 
	{
															#line 476 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		bytes += range.expectedSize();
															#line 477 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!range.more)
															#line 6234 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 480 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		next = keyAfter(range.back().key);
															#line 6240 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<RangeResultRef> && range,int loopDepth) 
	{
															#line 476 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		bytes += range.expectedSize();
															#line 477 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!range.more)
															#line 6251 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 480 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		next = keyAfter(range.back().key);
															#line 6257 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<RangeResultRef> const& range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(range, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<RangeResultRef> && range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state > 0) static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientGetRangeActor*>(this)->ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state > 0) static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientGetRangeActor*>(this)->ActorCallback< FdbClientGetRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientGetRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FdbClientGetRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FdbClientGetRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 465 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Database db;
															#line 466 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Transaction tx;
															#line 467 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Key next;
															#line 468 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	int64_t bytes;
															#line 469 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Future<Void> logFuture;
															#line 6447 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via fdbClientGetRange()
															#line 464 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class FdbClientGetRangeActor final : public Actor<Void>, public ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >, public ActorCallback< FdbClientGetRangeActor, 1, Void >, public FastAllocated<FdbClientGetRangeActor>, public FdbClientGetRangeActorState<FdbClientGetRangeActor> {
															#line 6452 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<FdbClientGetRangeActor>::operator new;
	using FastAllocated<FdbClientGetRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12783731858380635136UL, 8928691394426499072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >;
friend struct ActorCallback< FdbClientGetRangeActor, 1, Void >;
															#line 464 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	FdbClientGetRangeActor() 
															#line 6470 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   FdbClientGetRangeActorState<FdbClientGetRangeActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(431275374245541632UL, 2355442063886276352UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fdbClientGetRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FdbClientGetRangeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 464 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> fdbClientGetRange(  ) {
															#line 464 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new FdbClientGetRangeActor());
															#line 6504 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 487 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 6509 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via fdbClient()
															#line 488 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class FdbClientActor>
															#line 488 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class FdbClientActorState {
															#line 6516 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 488 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	FdbClientActorState() 
															#line 488 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	{
															#line 6522 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		fdb_probe_actor_create("fdbClient", reinterpret_cast<unsigned long>(this));

	}
	~FdbClientActorState() 
	{
		fdb_probe_actor_destroy("fdbClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 489 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(30);
															#line 489 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<FdbClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6538 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FdbClientActor*>(this)->actor_wait_state = 1;
															#line 489 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FdbClientActor, 0, Void >*>(static_cast<FdbClientActor*>(this)));
															#line 6543 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FdbClientActorState();
		static_cast<FdbClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 490 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		db = Database::createDatabase(clusterFile, 300);
															#line 491 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		tx = Transaction(db);
															#line 492 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		keyPrefix = "/tut/";
															#line 493 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		startKey = Key();
															#line 494 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		endKey = "/tut0"_sr;
															#line 495 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		beginIdx = 0;
															#line 496 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		;
															#line 6578 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 490 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		db = Database::createDatabase(clusterFile, 300);
															#line 491 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		tx = Transaction(db);
															#line 492 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		keyPrefix = "/tut/";
															#line 493 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		startKey = Key();
															#line 494 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		endKey = "/tut0"_sr;
															#line 495 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		beginIdx = 0;
															#line 496 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		;
															#line 6599 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FdbClientActor*>(this)->actor_wait_state > 0) static_cast<FdbClientActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientActor*>(this)->ActorCallback< FdbClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FdbClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 498 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			tx.reset();
															#line 505 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			beginIdx = deterministicRandom()->randomInt(0, 1e8 - 100);
															#line 506 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			startKey = keyPrefix + std::to_string(beginIdx);
															#line 507 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<RangeResult> __when_expr_1 = tx.getRange(KeyRangeRef(startKey, endKey), 100);
															#line 507 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<FdbClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6699 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FdbClientActor*>(this)->actor_wait_state = 2;
															#line 507 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FdbClientActor, 1, RangeResult >*>(static_cast<FdbClientActor*>(this)));
															#line 6704 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 516 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tx.onError(e);
															#line 516 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<FdbClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6728 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<FdbClientActor*>(this)->actor_wait_state = 5;
															#line 516 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FdbClientActor, 4, Void >*>(static_cast<FdbClientActor*>(this)));
															#line 6733 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(RangeResult const& range,int loopDepth) 
	{
															#line 508 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		for(int i = 0;i < 10;++i) {
															#line 509 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			Key k = Key(keyPrefix + std::to_string(beginIdx + deterministicRandom()->randomInt(0, 100)));
															#line 510 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			tx.set(k, "foo"_sr);
															#line 6752 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
															#line 512 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tx.commit();
															#line 512 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<FdbClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6758 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FdbClientActor*>(this)->actor_wait_state = 3;
															#line 512 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FdbClientActor, 2, Void >*>(static_cast<FdbClientActor*>(this)));
															#line 6763 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(RangeResult && range,int loopDepth) 
	{
															#line 508 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		for(int i = 0;i < 10;++i) {
															#line 509 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			Key k = Key(keyPrefix + std::to_string(beginIdx + deterministicRandom()->randomInt(0, 100)));
															#line 510 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			tx.set(k, "foo"_sr);
															#line 6776 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
															#line 512 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tx.commit();
															#line 512 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<FdbClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6782 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FdbClientActor*>(this)->actor_wait_state = 3;
															#line 512 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FdbClientActor, 2, Void >*>(static_cast<FdbClientActor*>(this)));
															#line 6787 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(RangeResult const& range,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(range, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(RangeResult && range,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FdbClientActor*>(this)->actor_wait_state > 0) static_cast<FdbClientActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientActor*>(this)->ActorCallback< FdbClientActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FdbClientActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 513 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Committed\n";
															#line 514 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(2.0);
															#line 514 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<FdbClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6875 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FdbClientActor*>(this)->actor_wait_state = 4;
															#line 514 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FdbClientActor, 3, Void >*>(static_cast<FdbClientActor*>(this)));
															#line 6880 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 513 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Committed\n";
															#line 514 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(2.0);
															#line 514 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<FdbClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6893 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FdbClientActor*>(this)->actor_wait_state = 4;
															#line 514 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FdbClientActor, 3, Void >*>(static_cast<FdbClientActor*>(this)));
															#line 6898 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FdbClientActor*>(this)->actor_wait_state > 0) static_cast<FdbClientActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientActor*>(this)->ActorCallback< FdbClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FdbClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FdbClientActor*>(this)->actor_wait_state > 0) static_cast<FdbClientActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientActor*>(this)->ActorCallback< FdbClientActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FdbClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FdbClientActor*>(this)->actor_wait_state > 0) static_cast<FdbClientActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientActor*>(this)->ActorCallback< FdbClientActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FdbClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 490 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Database db;
															#line 491 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Transaction tx;
															#line 492 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	std::string keyPrefix;
															#line 493 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Key startKey;
															#line 494 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	KeyRef endKey;
															#line 495 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	int beginIdx;
															#line 7177 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via fdbClient()
															#line 488 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class FdbClientActor final : public Actor<Void>, public ActorCallback< FdbClientActor, 0, Void >, public ActorCallback< FdbClientActor, 1, RangeResult >, public ActorCallback< FdbClientActor, 2, Void >, public ActorCallback< FdbClientActor, 3, Void >, public ActorCallback< FdbClientActor, 4, Void >, public FastAllocated<FdbClientActor>, public FdbClientActorState<FdbClientActor> {
															#line 7182 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<FdbClientActor>::operator new;
	using FastAllocated<FdbClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10660622181228203264UL, 11013223879674653184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FdbClientActor, 0, Void >;
friend struct ActorCallback< FdbClientActor, 1, RangeResult >;
friend struct ActorCallback< FdbClientActor, 2, Void >;
friend struct ActorCallback< FdbClientActor, 3, Void >;
friend struct ActorCallback< FdbClientActor, 4, Void >;
															#line 488 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	FdbClientActor() 
															#line 7203 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   FdbClientActorState<FdbClientActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6395279393086184448UL, 2376111731338970624UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fdbClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FdbClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FdbClientActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FdbClientActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FdbClientActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FdbClientActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 488 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> fdbClient(  ) {
															#line 488 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new FdbClientActor());
															#line 7240 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 520 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 7245 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via fdbStatusStresser()
															#line 521 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class FdbStatusStresserActor>
															#line 521 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class FdbStatusStresserActorState {
															#line 7252 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 521 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	FdbStatusStresserActorState() 
															#line 521 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 522 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : db(Database::createDatabase(clusterFile, 300)),
															#line 523 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   tx(db),
															#line 524 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   statusJson(std::string("\xff\xff/status/json"))
															#line 7263 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("fdbStatusStresser", reinterpret_cast<unsigned long>(this));

	}
	~FdbStatusStresserActorState() 
	{
		fdb_probe_actor_destroy("fdbStatusStresser", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 525 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 7278 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FdbStatusStresserActorState();
		static_cast<FdbStatusStresserActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 527 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			tx.reset();
															#line 528 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tx.get(statusJson);
															#line 528 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<FdbStatusStresserActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7313 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FdbStatusStresserActor*>(this)->actor_wait_state = 1;
															#line 528 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FdbStatusStresserActor, 0, Optional<Value> >*>(static_cast<FdbStatusStresserActor*>(this)));
															#line 7318 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 530 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tx.onError(e);
															#line 530 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<FdbStatusStresserActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7342 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FdbStatusStresserActor*>(this)->actor_wait_state = 2;
															#line 530 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FdbStatusStresserActor, 1, Void >*>(static_cast<FdbStatusStresserActor*>(this)));
															#line 7347 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FdbStatusStresserActor*>(this)->actor_wait_state > 0) static_cast<FdbStatusStresserActor*>(this)->actor_wait_state = 0;
		static_cast<FdbStatusStresserActor*>(this)->ActorCallback< FdbStatusStresserActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FdbStatusStresserActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbStatusStresserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FdbStatusStresserActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbStatusStresserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FdbStatusStresserActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbStatusStresserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FdbStatusStresserActor*>(this)->actor_wait_state > 0) static_cast<FdbStatusStresserActor*>(this)->actor_wait_state = 0;
		static_cast<FdbStatusStresserActor*>(this)->ActorCallback< FdbStatusStresserActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FdbStatusStresserActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbStatusStresserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FdbStatusStresserActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbStatusStresserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FdbStatusStresserActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbStatusStresserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 522 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Database db;
															#line 523 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	ReadYourWritesTransaction tx;
															#line 524 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Key statusJson;
															#line 7551 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via fdbStatusStresser()
															#line 521 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class FdbStatusStresserActor final : public Actor<Void>, public ActorCallback< FdbStatusStresserActor, 0, Optional<Value> >, public ActorCallback< FdbStatusStresserActor, 1, Void >, public FastAllocated<FdbStatusStresserActor>, public FdbStatusStresserActorState<FdbStatusStresserActor> {
															#line 7556 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<FdbStatusStresserActor>::operator new;
	using FastAllocated<FdbStatusStresserActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13002367751008335104UL, 7517915900975683328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FdbStatusStresserActor, 0, Optional<Value> >;
friend struct ActorCallback< FdbStatusStresserActor, 1, Void >;
															#line 521 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	FdbStatusStresserActor() 
															#line 7574 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   FdbStatusStresserActorState<FdbStatusStresserActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fdbStatusStresser", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16978208003529881600UL, 843934910172209664UL);
		ActorExecutionContextHelper __helper(static_cast<FdbStatusStresserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fdbStatusStresser");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fdbStatusStresser", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FdbStatusStresserActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FdbStatusStresserActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 521 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> fdbStatusStresser(  ) {
															#line 521 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new FdbStatusStresserActor());
															#line 7608 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 534 "/codebuild/output/src4221181136/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

std::unordered_map<std::string, std::function<Future<Void>()>> actors = {
	{ "timer", &simpleTimer }, // ./tutorial timer
	{ "promiseDemo", &promiseDemo }, // ./tutorial promiseDemo
	{ "triggerDemo", &triggerDemo }, // ./tutorial triggerDemo
	{ "echoServer", &echoServer }, // ./tutorial -p 6666 echoServer
	{ "echoClient", &echoClient }, // ./tutorial -s 127.0.0.1:6666 echoClient
	{ "kvStoreServer", &kvStoreServer }, // ./tutorial -p 6666 kvStoreServer
	{ "kvSimpleClient", &kvSimpleClient }, // ./tutorial -s 127.0.0.1:6666 kvSimpleClient
	{ "multipleClients", &multipleClients }, // ./tutorial -s 127.0.0.1:6666 multipleClients
	{ "fdbClientStream", &fdbClientStream }, // ./tutorial -C $CLUSTER_FILE_PATH fdbClientStream
	{ "fdbClientGetRange", &fdbClientGetRange }, // ./tutorial -C $CLUSTER_FILE_PATH fdbClientGetRange
	{ "fdbClient", &fdbClient }, // ./tutorial -C $CLUSTER_FILE_PATH fdbClient
	{ "fdbStatusStresser", &fdbStatusStresser }
}; // ./tutorial -C $CLUSTER_FILE_PATH fdbStatusStresser

int main(int argc, char* argv[]) {
	bool isServer = false;
	std::string port;
	std::vector<std::function<Future<Void>()>> toRun;
	// parse arguments
	for (int i = 1; i < argc; ++i) {
		std::string arg(argv[i]);
		if (arg == "-p") {
			isServer = true;
			if (i + 1 >= argc) {
				std::cout << "Expecting an argument after -p\n";
				return 1;
			}
			port = std::string(argv[++i]);
			continue;
		} else if (arg == "-s") {
			if (i + 1 >= argc) {
				std::cout << "Expecting an argument after -s\n";
				return 1;
			}
			serverAddress = NetworkAddress::parse(argv[++i]);
			continue;
		} else if (arg == "-C") {
			clusterFile = argv[++i];
			std::cout << "Using cluster file " << clusterFile << std::endl;
			continue;
		}
		auto actor = actors.find(arg);
		if (actor == actors.end()) {
			std::cout << format("Error: actor %s does not exist\n", arg.c_str());
			return 1;
		}
		toRun.push_back(actor->second);
	}
	platformInit();
	g_network = newNet2(TLSConfig(), false, true);
	FlowTransport::createInstance(!isServer, 0, WLTOKEN_COUNT_IN_TUTORIAL);
	NetworkAddress publicAddress = NetworkAddress::parse("0.0.0.0:0");
	if (isServer) {
		publicAddress = NetworkAddress::parse("0.0.0.0:" + port);
	}
	// openTraceFile(publicAddress, TRACE_DEFAULT_ROLL_SIZE,
	//              TRACE_DEFAULT_MAX_LOGS_SIZE);
	try {
		if (isServer) {
			auto listenError = FlowTransport::transport().bind(publicAddress, publicAddress);
			if (listenError.isError()) {
				listenError.get();
			}
		}
	} catch (Error& e) {
		std::cout << format("Error while binding to address (%d): %s\n", e.code(), e.what());
	}
	// now we start the actors
	std::vector<Future<Void>> all;
	all.reserve(toRun.size());
	for (auto& f : toRun) {
		all.emplace_back(f());
	}
	auto f = stopAfter(waitForAll(all));
	g_network->run();
	return 0;
}
