/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.KeySelector;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.StreamingMode;
import com.apple.foundationdb.Tenant;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.test.Stack;
import com.apple.foundationdb.test.StackUtils;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

abstract class Context
implements Runnable,
AutoCloseable {
    final Stack stack = new Stack();
    final Database db;
    Optional<Tenant> tenant = Optional.empty();
    final String preStr;
    int instructionIndex = 0;
    KeySelector nextKey;
    KeySelector endKey;
    Long lastVersion = null;
    private String trName;
    private List<Thread> children = new LinkedList<Thread>();
    private static Map<String, TransactionState> transactionMap = new HashMap<String, TransactionState>();
    private static Map<Transaction, AtomicInteger> transactionRefCounts = new HashMap<Transaction, AtomicInteger>();
    private static Map<byte[], Tenant> tenantMap = new ConcurrentHashMap<byte[], Tenant>();

    Context(Database database, byte[] byArray) {
        this.db = database;
        Range range = Tuple.from((Object[])new Object[]{byArray}).range();
        this.nextKey = KeySelector.firstGreaterOrEqual((byte[])range.begin);
        this.endKey = KeySelector.firstGreaterOrEqual((byte[])range.end);
        this.trName = ByteArrayUtil.printable((byte[])byArray);
        this.preStr = ByteArrayUtil.printable((byte[])byArray);
        this.newTransaction();
    }

    @Override
    public void run() {
        try {
            this.executeOperations();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
        while (this.children.size() > 0) {
            Thread thread = this.children.get(0);
            while (thread.isAlive()) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.children.remove(0);
        }
    }

    public synchronized CompletableFuture<Long> setTenant(Optional<byte[]> optional) {
        if (optional.isPresent()) {
            this.tenant = Optional.of(tenantMap.computeIfAbsent(optional.get(), byArray -> this.db.openTenant((byte[])optional.get())));
            return this.tenant.get().getId();
        }
        this.tenant = Optional.empty();
        return CompletableFuture.completedFuture(-1L);
    }

    public static synchronized void addTransactionReference(Transaction transaction2) {
        transactionRefCounts.computeIfAbsent(transaction2, transaction -> new AtomicInteger(0)).incrementAndGet();
    }

    private static synchronized Transaction getTransaction(String string) {
        TransactionState transactionState = transactionMap.get(string);
        assert (transactionState != null) : "Null transaction";
        Context.addTransactionReference(transactionState.transaction);
        return transactionState.transaction;
    }

    public Transaction getCurrentTransaction() {
        return Context.getTransaction(this.trName);
    }

    public static synchronized void releaseTransaction(Transaction transaction) {
        AtomicInteger atomicInteger;
        if (transaction != null && (atomicInteger = transactionRefCounts.get(transaction)).decrementAndGet() == 0) {
            transactionRefCounts.remove(transaction);
            transaction.close();
        }
    }

    private static Transaction createTransaction(Database database, Optional<Tenant> optional) {
        if (optional.isPresent()) {
            return optional.get().createTransaction();
        }
        return database.createTransaction();
    }

    private static synchronized boolean newTransaction(Database database, Optional<Tenant> optional, String string, boolean bl) {
        TransactionState transactionState = transactionMap.get(string);
        if (transactionState != null) {
            if (bl) {
                Context.releaseTransaction(transactionState.transaction);
            } else {
                return false;
            }
        }
        TransactionState transactionState2 = new TransactionState(Context.createTransaction(database, optional), optional);
        transactionMap.put(string, transactionState2);
        Context.addTransactionReference(transactionState2.transaction);
        return true;
    }

    private static synchronized boolean replaceTransaction(Database database, String string, Transaction transaction, Transaction transaction2) {
        TransactionState transactionState = transactionMap.get(string);
        assert (transactionState != null) : "Null transaction";
        if (transaction == null || transactionState.transaction == transaction) {
            if (transaction2 == null) {
                transaction2 = Context.createTransaction(database, transactionState.tenant);
            }
            Context.releaseTransaction(transactionState.transaction);
            Context.addTransactionReference(transaction2);
            transactionState.transaction = transaction2;
            return true;
        }
        return false;
    }

    public void newTransaction() {
        Context.newTransaction(this.db, this.tenant, this.trName, true);
    }

    public void replaceTransaction(Transaction transaction) {
        Context.replaceTransaction(this.db, this.trName, null, transaction);
    }

    public boolean replaceTransaction(Transaction transaction, Transaction transaction2) {
        return Context.replaceTransaction(this.db, this.trName, transaction, transaction2);
    }

    public void resetTransaction() {
        Context.replaceTransaction(this.db, this.trName, null, null);
    }

    public boolean resetTransaction(Transaction transaction) {
        return Context.replaceTransaction(this.db, this.trName, transaction, null);
    }

    public void switchTransaction(byte[] byArray) {
        this.trName = ByteArrayUtil.printable((byte[])byArray);
        Context.newTransaction(this.db, this.tenant, this.trName, false);
    }

    abstract void executeOperations() throws Throwable;

    abstract Context createContext(byte[] var1);

    void addContext(byte[] byArray) {
        Thread thread = new Thread(this.createContext(byArray));
        thread.start();
        this.children.add(thread);
    }

    StreamingMode streamingModeFromCode(int n) {
        for (StreamingMode streamingMode : StreamingMode.values()) {
            if (streamingMode.code() != n) continue;
            return streamingMode;
        }
        throw new IllegalArgumentException("Invalid code: " + n);
    }

    private void popParams(int n, List<Object> list, CompletableFuture<Void> completableFuture) {
        while (n-- > 0) {
            Object object2 = this.stack.pop().value;
            if (object2 instanceof CompletableFuture) {
                CompletableFuture completableFuture2 = (CompletableFuture)object2;
                int n2 = n;
                completableFuture2.whenCompleteAsync((object, throwable) -> {
                    if (throwable != null) {
                        FDBException fDBException = StackUtils.getRootFDBException(throwable);
                        if (fDBException != null) {
                            list.add(StackUtils.getErrorBytes(fDBException));
                            this.popParams(n2, list, completableFuture);
                        } else {
                            completableFuture.completeExceptionally((Throwable)throwable);
                        }
                    } else {
                        if (object == null) {
                            list.add("RESULT_NOT_PRESENT".getBytes());
                        } else {
                            list.add(object);
                        }
                        this.popParams(n2, list, completableFuture);
                    }
                }, (Executor)FDB.DEFAULT_EXECUTOR);
                return;
            }
            list.add(object2);
        }
        completableFuture.complete(null);
    }

    CompletableFuture<List<Object>> popParams(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.popParams(n, arrayList, completableFuture);
        return completableFuture.thenApply(void_ -> arrayList);
    }

    @Override
    public void close() {
        for (TransactionState transactionState : transactionMap.values()) {
            transactionState.transaction.close();
        }
        for (Tenant tenant : tenantMap.values()) {
            tenant.close();
        }
    }

    private static class TransactionState {
        public Transaction transaction;
        public Optional<Tenant> tenant;

        public TransactionState(Transaction transaction, Optional<Tenant> optional) {
            this.transaction = transaction;
            this.tenant = optional;
        }
    }
}

