/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.StreamingMode;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.async.AsyncIterable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Random;

public class SerialIteration {
    private static final int ROWS = 1000000;
    private static final int RUNS = 25;
    private static final int THREAD_COUNT = 1;

    public static void main(String[] stringArray) throws InterruptedException {
        FDB fDB = FDB.selectAPIVersion((int)740);
        try (Database database = fDB.open(stringArray[0]);){
            for (int i = 1; i <= 1; ++i) {
                SerialIteration.runThreadedTest(database, i);
                Thread.sleep(1000L);
            }
        }
    }

    private static double runThreadedTest(Database database, int n) {
        ArrayList<IterationThread> arrayList = new ArrayList<IterationThread>(n);
        for (int i = 0; i < n; ++i) {
            IterationThread iterationThread = new IterationThread(database);
            iterationThread.start();
            arrayList.add(iterationThread);
        }
        double d = 0.0;
        for (IterationThread iterationThread : arrayList) {
            try {
                iterationThread.join();
                d += iterationThread.getAverageRowsPerSecond();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        System.out.println("\n====================");
        System.out.println("Global rows/sec (over " + n + " threads): " + d);
        return d;
    }

    private static int scanDatabase(Database database, int n) {
        try (Transaction transaction = database.createTransaction();){
            transaction.options().setReadYourWritesDisable();
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            byteBuffer.putInt(0, Integer.MAX_VALUE);
            AsyncIterable asyncIterable = transaction.getRange(new byte[0], byteBuffer.array(), 0, false, StreamingMode.WANT_ALL);
            int n2 = 0;
            try {
                for (KeyValue keyValue : asyncIterable) {
                    ++n2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            int n3 = n2;
            return n3;
        }
    }

    private SerialIteration() {
    }

    private static class IterationThread
    extends Thread {
        private static final Random r = new Random();
        private final Database db;
        private double averageRowsPerSecond;

        IterationThread(Database database) {
            this.db = database;
        }

        double getAverageRowsPerSecond() {
            return this.averageRowsPerSecond;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(r.nextInt(1000));
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            long l = 0L;
            int n = 0;
            for (int i = 0; i < 25; ++i) {
                long l2 = System.currentTimeMillis();
                int n2 = SerialIteration.scanDatabase(this.db, 1000000);
                long l3 = System.currentTimeMillis() - l2;
                System.out.print(".");
                System.out.flush();
                if (i == 0) continue;
                n += n2;
                l += l3;
            }
            this.averageRowsPerSecond = (double)n / (double)l * 1000.0;
            System.out.print("+");
            System.out.flush();
        }
    }
}

