#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
/*
 * PerpetualWiggleStorageMigrationWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/DDTeamCollection.h"
#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbserver/DDSharedContext.h"
#include "fdbserver/DDTxnProcessor.h"
#include "fdbserver/MoveKeys.actor.h"
#include "fdbclient/StorageServerInterface.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbclient/VersionedMap.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbrpc/SimulatorProcessInfo.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace {
															#line 38 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
// This generated class is to be used only via IssueConfigurationChange()
															#line 36 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
template <class IssueConfigurationChangeActor>
															#line 36 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
class IssueConfigurationChangeActorState {
															#line 44 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
public:
															#line 36 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	IssueConfigurationChangeActorState(Database const& cx,std::string const& config,bool const& force) 
															#line 36 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
															#line 36 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		 : cx(cx),
															#line 36 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		   config(config),
															#line 36 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		   force(force)
															#line 55 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("IssueConfigurationChange", reinterpret_cast<unsigned long>(this));

	}
	~IssueConfigurationChangeActorState() 
	{
		fdb_probe_actor_destroy("IssueConfigurationChange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 37 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			printf("Issuing configuration change: %s\n", config.c_str());
															#line 38 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			StrictFuture<ConfigurationResult> __when_expr_0 = ManagementAPI::changeConfig(cx.getReference(), config, force);
															#line 38 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			if (static_cast<IssueConfigurationChangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 74 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IssueConfigurationChangeActor*>(this)->actor_wait_state = 1;
															#line 38 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IssueConfigurationChangeActor, 0, ConfigurationResult >*>(static_cast<IssueConfigurationChangeActor*>(this)));
															#line 79 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IssueConfigurationChangeActorState();
		static_cast<IssueConfigurationChangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 39 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (res != ConfigurationResult::SUCCESS)
															#line 102 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		{
															#line 40 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			if (!static_cast<IssueConfigurationChangeActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IssueConfigurationChangeActorState(); static_cast<IssueConfigurationChangeActor*>(this)->destroy(); return 0; }
															#line 106 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			new (&static_cast<IssueConfigurationChangeActor*>(this)->SAV< bool >::value()) bool(false);
			this->~IssueConfigurationChangeActorState();
			static_cast<IssueConfigurationChangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 42 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(5.0);
															#line 42 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (static_cast<IssueConfigurationChangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 116 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<IssueConfigurationChangeActor*>(this)->actor_wait_state = 2;
															#line 42 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IssueConfigurationChangeActor, 1, Void >*>(static_cast<IssueConfigurationChangeActor*>(this)));
															#line 121 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(ConfigurationResult const& __res,int loopDepth) 
	{
															#line 38 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		res = __res;
															#line 130 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(ConfigurationResult && __res,int loopDepth) 
	{
		res = std::move(__res);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IssueConfigurationChangeActor*>(this)->actor_wait_state > 0) static_cast<IssueConfigurationChangeActor*>(this)->actor_wait_state = 0;
		static_cast<IssueConfigurationChangeActor*>(this)->ActorCallback< IssueConfigurationChangeActor, 0, ConfigurationResult >::remove();

	}
	void a_callback_fire(ActorCallback< IssueConfigurationChangeActor, 0, ConfigurationResult >*,ConfigurationResult const& value) 
	{
		fdb_probe_actor_enter("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IssueConfigurationChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IssueConfigurationChangeActor, 0, ConfigurationResult >*,ConfigurationResult && value) 
	{
		fdb_probe_actor_enter("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IssueConfigurationChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IssueConfigurationChangeActor, 0, ConfigurationResult >*,Error err) 
	{
		fdb_probe_actor_enter("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IssueConfigurationChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 43 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (!static_cast<IssueConfigurationChangeActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IssueConfigurationChangeActorState(); static_cast<IssueConfigurationChangeActor*>(this)->destroy(); return 0; }
															#line 209 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		new (&static_cast<IssueConfigurationChangeActor*>(this)->SAV< bool >::value()) bool(true);
		this->~IssueConfigurationChangeActorState();
		static_cast<IssueConfigurationChangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 43 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (!static_cast<IssueConfigurationChangeActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IssueConfigurationChangeActorState(); static_cast<IssueConfigurationChangeActor*>(this)->destroy(); return 0; }
															#line 221 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		new (&static_cast<IssueConfigurationChangeActor*>(this)->SAV< bool >::value()) bool(true);
		this->~IssueConfigurationChangeActorState();
		static_cast<IssueConfigurationChangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IssueConfigurationChangeActor*>(this)->actor_wait_state > 0) static_cast<IssueConfigurationChangeActor*>(this)->actor_wait_state = 0;
		static_cast<IssueConfigurationChangeActor*>(this)->ActorCallback< IssueConfigurationChangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IssueConfigurationChangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IssueConfigurationChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IssueConfigurationChangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IssueConfigurationChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IssueConfigurationChangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IssueConfigurationChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 36 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	Database cx;
															#line 36 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	std::string config;
															#line 36 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	bool force;
															#line 38 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	ConfigurationResult res;
															#line 312 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
};
// This generated class is to be used only via IssueConfigurationChange()
															#line 36 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
class IssueConfigurationChangeActor final : public Actor<bool>, public ActorCallback< IssueConfigurationChangeActor, 0, ConfigurationResult >, public ActorCallback< IssueConfigurationChangeActor, 1, Void >, public FastAllocated<IssueConfigurationChangeActor>, public IssueConfigurationChangeActorState<IssueConfigurationChangeActor> {
															#line 317 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
public:
	using FastAllocated<IssueConfigurationChangeActor>::operator new;
	using FastAllocated<IssueConfigurationChangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10232791790275538688UL, 16357522571787760640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IssueConfigurationChangeActor, 0, ConfigurationResult >;
friend struct ActorCallback< IssueConfigurationChangeActor, 1, Void >;
															#line 36 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	IssueConfigurationChangeActor(Database const& cx,std::string const& config,bool const& force) 
															#line 335 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		 : Actor<bool>(),
		   IssueConfigurationChangeActorState<IssueConfigurationChangeActor>(cx, config, force),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14752238108969034496UL, 12341728471573534720UL);
		ActorExecutionContextHelper __helper(static_cast<IssueConfigurationChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("IssueConfigurationChange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IssueConfigurationChangeActor, 0, ConfigurationResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IssueConfigurationChangeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 36 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
[[nodiscard]] Future<bool> IssueConfigurationChange( Database const& cx, std::string const& config, bool const& force ) {
															#line 36 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	return Future<bool>(new IssueConfigurationChangeActor(cx, config, force));
															#line 368 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
}

#line 45 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"

constexpr bool hasRocksDB =
#ifdef WITH_ROCKSDB
    true
#else
    false
#endif
    ;

} // namespace

struct PerpetualWiggleStorageMigrationWorkload : public TestWorkload {

	static constexpr auto NAME = "PerpetualWiggleStorageMigrationWorkload";

	PerpetualWiggleStorageMigrationWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {}

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		// This test requires exclude/include runs smoothly, so we disable all the failure injection workloads.
		out.insert("all");
	}

	Future<Void> start(Database const& cx) override {
		if (clientId == 0) {
			return _start(this, cx);
		}
		return Void();
	};

	Future<bool> check(Database const& cx) override { return true; };

																#line 403 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 76 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
template <class _startActor>
															#line 76 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
class _startActorState {
															#line 409 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
public:
															#line 76 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	_startActorState(PerpetualWiggleStorageMigrationWorkload* const& self,Database const& cx) 
															#line 76 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
															#line 76 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		 : self(self),
															#line 76 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		   cx(cx)
															#line 418 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 77 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			if (!hasRocksDB)
															#line 433 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			{
															#line 79 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
				if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 437 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
				new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_startActorState();
				static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 81 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			StrictFuture<std::vector<StorageServerInterface>> __when_expr_0 = getStorageServers(cx);
															#line 81 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 447 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 81 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, std::vector<StorageServerInterface> >*>(static_cast<_startActor*>(this)));
															#line 452 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 83 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		ASSERT(storageServers.size() > 3);
															#line 87 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		ssToExcludeInclude = storageServers[deterministicRandom()->randomInt(0, storageServers.size())];
															#line 89 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		p = g_simulator->getProcessByAddress(ssToExcludeInclude.address());
															#line 90 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		for(;!p->isReliable();) {
															#line 91 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			ssToExcludeInclude = storageServers[deterministicRandom()->randomInt(0, storageServers.size())];
															#line 92 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			p = g_simulator->getProcessByAddress(ssToExcludeInclude.address());
															#line 485 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		}
															#line 95 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		TraceEvent("Test_PickedProcessToExcludeInclude") .detail("ProcessID", ssToExcludeInclude.locality.processId()) .detail("Address", ssToExcludeInclude.address());
															#line 100 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		ssToWiggle = storageServers[deterministicRandom()->randomInt(0, storageServers.size())];
															#line 102 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		for(;ssToExcludeInclude.locality.processId() == ssToWiggle.locality.processId();) {
															#line 103 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			ssToWiggle = storageServers[deterministicRandom()->randomInt(0, storageServers.size())];
															#line 495 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		}
															#line 105 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		TraceEvent("Test_PickedProcessToMigrate") .detail("ProcessID", ssToWiggle.locality.processId()) .detail("Address", ssToWiggle.address());
															#line 110 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		std::string migrationLocality = LocalityData::keyProcessId.toString() + ":" + ssToWiggle.locality.processId()->toString();
															#line 112 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_1 = IssueConfigurationChange(cx, "perpetual_storage_wiggle_engine=ssd-rocksdb-v1 perpetual_storage_wiggle=1 " "storage_migration_type=gradual perpetual_storage_wiggle_locality=" + migrationLocality, true);
															#line 112 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 505 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 112 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, bool >*>(static_cast<_startActor*>(this)));
															#line 510 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<StorageServerInterface> const& __storageServers,int loopDepth) 
	{
															#line 81 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		storageServers = __storageServers;
															#line 519 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<StorageServerInterface> && __storageServers,int loopDepth) 
	{
		storageServers = std::move(__storageServers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(bool const& change,int loopDepth) 
	{
															#line 118 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		TraceEvent("Test_ConfigChangeDone").detail("Success", change);
															#line 119 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		ASSERT(change);
															#line 121 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = excludeIncludeServer(cx, ssToExcludeInclude);
															#line 121 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 604 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 121 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 609 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(bool && change,int loopDepth) 
	{
															#line 118 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		TraceEvent("Test_ConfigChangeDone").detail("Success", change);
															#line 119 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		ASSERT(change);
															#line 121 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = excludeIncludeServer(cx, ssToExcludeInclude);
															#line 121 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 624 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 121 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 629 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(bool const& change,int loopDepth) 
	{
		loopDepth = a_body1cont3(change, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && change,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(change), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = validateDatabase(cx, ssToExcludeInclude, ssToWiggle, "ssd-rocksdb-v1");
															#line 123 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 715 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 123 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 720 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = validateDatabase(cx, ssToExcludeInclude, ssToWiggle, "ssd-rocksdb-v1");
															#line 123 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 731 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 123 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 736 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 126 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 820 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		{
															#line 127 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			TraceEvent("Test_ClearPerpetualStorageWiggleEngine").log();
															#line 128 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_4 = IssueConfigurationChange(cx, "perpetual_storage_wiggle_engine=none", true);
															#line 128 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 828 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 128 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, bool >*>(static_cast<_startActor*>(this)));
															#line 833 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 126 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 847 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		{
															#line 127 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			TraceEvent("Test_ClearPerpetualStorageWiggleEngine").log();
															#line 128 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_4 = IssueConfigurationChange(cx, "perpetual_storage_wiggle_engine=none", true);
															#line 128 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 855 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 128 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, bool >*>(static_cast<_startActor*>(this)));
															#line 860 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 137 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 949 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(bool const& change,int loopDepth) 
	{
															#line 129 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		TraceEvent("Test_ClearPerpetualStorageWiggleEngineDone").detail("Success", change);
															#line 130 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		ASSERT(change);
															#line 134 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = excludeIncludeServer(cx, ssToWiggle);
															#line 134 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 967 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont9when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 134 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 972 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(bool && change,int loopDepth) 
	{
															#line 129 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		TraceEvent("Test_ClearPerpetualStorageWiggleEngineDone").detail("Success", change);
															#line 130 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		ASSERT(change);
															#line 134 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = excludeIncludeServer(cx, ssToWiggle);
															#line 134 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 987 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont9when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 134 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 992 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(bool const& change,int loopDepth) 
	{
		loopDepth = a_body1cont9(change, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(bool && change,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(change), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 135 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = validateDatabase(cx, ssToExcludeInclude, ssToWiggle, "ssd-2");
															#line 135 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1078 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 135 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 1083 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 135 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = validateDatabase(cx, ssToExcludeInclude, ssToWiggle, "ssd-2");
															#line 135 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1094 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 135 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 1099 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 76 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	PerpetualWiggleStorageMigrationWorkload* self;
															#line 76 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	Database cx;
															#line 81 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	std::vector<StorageServerInterface> storageServers;
															#line 87 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	StorageServerInterface ssToExcludeInclude;
															#line 89 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	ISimulator::ProcessInfo* p;
															#line 100 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	StorageServerInterface ssToWiggle;
															#line 1278 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 76 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, std::vector<StorageServerInterface> >, public ActorCallback< _startActor, 1, bool >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, bool >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1283 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14595047719511046144UL, 17496652844883311872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, std::vector<StorageServerInterface> >;
friend struct ActorCallback< _startActor, 1, bool >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, bool >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
															#line 76 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	_startActor(PerpetualWiggleStorageMigrationWorkload* const& self,Database const& cx) 
															#line 1306 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, bool >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 76 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _start( PerpetualWiggleStorageMigrationWorkload* const& self, Database const& cx ) {
															#line 76 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 1344 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
}

#line 139 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"

																#line 1349 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
// This generated class is to be used only via excludeIncludeServer()
															#line 140 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
template <class ExcludeIncludeServerActor>
															#line 140 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
class ExcludeIncludeServerActorState {
															#line 1355 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
public:
															#line 140 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	ExcludeIncludeServerActorState(Database const& cx,StorageServerInterface const& ssToExcludeInclude) 
															#line 140 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
															#line 140 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		 : cx(cx),
															#line 140 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		   ssToExcludeInclude(ssToExcludeInclude),
															#line 143 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		   servers()
															#line 1366 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("excludeIncludeServer", reinterpret_cast<unsigned long>(this));

	}
	~ExcludeIncludeServerActorState() 
	{
		fdb_probe_actor_destroy("excludeIncludeServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 144 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			servers.push_back(AddressExclusion(ssToExcludeInclude.address().ip, ssToExcludeInclude.address().port));
															#line 148 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = excludeServers(cx, servers, true);
															#line 148 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			if (static_cast<ExcludeIncludeServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1385 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ExcludeIncludeServerActor*>(this)->actor_wait_state = 1;
															#line 148 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExcludeIncludeServerActor, 0, Void >*>(static_cast<ExcludeIncludeServerActor*>(this)));
															#line 1390 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExcludeIncludeServerActorState();
		static_cast<ExcludeIncludeServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 149 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		TraceEvent("Test_DoneExcludeServer").log();
															#line 1413 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		try {
															#line 152 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			StrictFuture<std::set<NetworkAddress>> __when_expr_1 = checkForExcludingServers(cx, servers, true);
															#line 152 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			if (static_cast<ExcludeIncludeServerActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1419 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ExcludeIncludeServerActor*>(this)->actor_wait_state = 2;
															#line 152 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExcludeIncludeServerActor, 1, std::set<NetworkAddress> >*>(static_cast<ExcludeIncludeServerActor*>(this)));
															#line 1424 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 149 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		TraceEvent("Test_DoneExcludeServer").log();
															#line 1439 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		try {
															#line 152 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			StrictFuture<std::set<NetworkAddress>> __when_expr_1 = checkForExcludingServers(cx, servers, true);
															#line 152 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			if (static_cast<ExcludeIncludeServerActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1445 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ExcludeIncludeServerActor*>(this)->actor_wait_state = 2;
															#line 152 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExcludeIncludeServerActor, 1, std::set<NetworkAddress> >*>(static_cast<ExcludeIncludeServerActor*>(this)));
															#line 1450 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExcludeIncludeServerActor*>(this)->actor_wait_state > 0) static_cast<ExcludeIncludeServerActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeIncludeServerActor*>(this)->ActorCallback< ExcludeIncludeServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeIncludeServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("excludeIncludeServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeIncludeServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeIncludeServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExcludeIncludeServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("excludeIncludeServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeIncludeServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeIncludeServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExcludeIncludeServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("excludeIncludeServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeIncludeServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeIncludeServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 162 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		TraceEvent("Test_CheckingExcludeServerDone").log();
															#line 165 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = includeServers(cx, std::vector<AddressExclusion>(1));
															#line 165 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (static_cast<ExcludeIncludeServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1544 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ExcludeIncludeServerActor*>(this)->actor_wait_state = 3;
															#line 165 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExcludeIncludeServerActor, 2, Void >*>(static_cast<ExcludeIncludeServerActor*>(this)));
															#line 1549 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 155 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 1559 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			{
															#line 157 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
				TraceEvent(SevError, "Test_WaitingForExclusionTakeTooLong").log();
															#line 1563 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			}
															#line 159 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1567 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(std::set<NetworkAddress> const& inProgress,int loopDepth) 
	{
															#line 153 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		ASSERT(inProgress.empty());
															#line 1581 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(std::set<NetworkAddress> && inProgress,int loopDepth) 
	{
															#line 153 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		ASSERT(inProgress.empty());
															#line 1590 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::set<NetworkAddress> const& inProgress,int loopDepth) 
	{
		loopDepth = a_body1cont3(inProgress, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::set<NetworkAddress> && inProgress,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(inProgress), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExcludeIncludeServerActor*>(this)->actor_wait_state > 0) static_cast<ExcludeIncludeServerActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeIncludeServerActor*>(this)->ActorCallback< ExcludeIncludeServerActor, 1, std::set<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeIncludeServerActor, 1, std::set<NetworkAddress> >*,std::set<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("excludeIncludeServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeIncludeServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeIncludeServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExcludeIncludeServerActor, 1, std::set<NetworkAddress> >*,std::set<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("excludeIncludeServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeIncludeServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeIncludeServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExcludeIncludeServerActor, 1, std::set<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("excludeIncludeServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeIncludeServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeIncludeServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 166 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		TraceEvent("Test_IncludeServerDone").log();
															#line 168 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (!static_cast<ExcludeIncludeServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ExcludeIncludeServerActorState(); static_cast<ExcludeIncludeServerActor*>(this)->destroy(); return 0; }
															#line 1689 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		new (&static_cast<ExcludeIncludeServerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ExcludeIncludeServerActorState();
		static_cast<ExcludeIncludeServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 166 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		TraceEvent("Test_IncludeServerDone").log();
															#line 168 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (!static_cast<ExcludeIncludeServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ExcludeIncludeServerActorState(); static_cast<ExcludeIncludeServerActor*>(this)->destroy(); return 0; }
															#line 1703 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		new (&static_cast<ExcludeIncludeServerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ExcludeIncludeServerActorState();
		static_cast<ExcludeIncludeServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ExcludeIncludeServerActor*>(this)->actor_wait_state > 0) static_cast<ExcludeIncludeServerActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeIncludeServerActor*>(this)->ActorCallback< ExcludeIncludeServerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeIncludeServerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("excludeIncludeServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeIncludeServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeIncludeServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ExcludeIncludeServerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("excludeIncludeServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeIncludeServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeIncludeServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ExcludeIncludeServerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("excludeIncludeServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeIncludeServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeIncludeServer", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 140 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	Database cx;
															#line 140 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	StorageServerInterface ssToExcludeInclude;
															#line 143 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	std::vector<AddressExclusion> servers;
															#line 1792 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
};
// This generated class is to be used only via excludeIncludeServer()
															#line 140 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
class ExcludeIncludeServerActor final : public Actor<Void>, public ActorCallback< ExcludeIncludeServerActor, 0, Void >, public ActorCallback< ExcludeIncludeServerActor, 1, std::set<NetworkAddress> >, public ActorCallback< ExcludeIncludeServerActor, 2, Void >, public FastAllocated<ExcludeIncludeServerActor>, public ExcludeIncludeServerActorState<ExcludeIncludeServerActor> {
															#line 1797 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
public:
	using FastAllocated<ExcludeIncludeServerActor>::operator new;
	using FastAllocated<ExcludeIncludeServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2989932577578109184UL, 6288358044386003456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExcludeIncludeServerActor, 0, Void >;
friend struct ActorCallback< ExcludeIncludeServerActor, 1, std::set<NetworkAddress> >;
friend struct ActorCallback< ExcludeIncludeServerActor, 2, Void >;
															#line 140 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	ExcludeIncludeServerActor(Database const& cx,StorageServerInterface const& ssToExcludeInclude) 
															#line 1816 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ExcludeIncludeServerActorState<ExcludeIncludeServerActor>(cx, ssToExcludeInclude),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("excludeIncludeServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14552798244034201088UL, 17541397210656494592UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeIncludeServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("excludeIncludeServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("excludeIncludeServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExcludeIncludeServerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExcludeIncludeServerActor, 1, std::set<NetworkAddress> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ExcludeIncludeServerActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 140 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
[[nodiscard]] static Future<Void> excludeIncludeServer( Database const& cx, StorageServerInterface const& ssToExcludeInclude ) {
															#line 140 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	return Future<Void>(new ExcludeIncludeServerActor(cx, ssToExcludeInclude));
															#line 1850 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
}

#line 170 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"

																#line 1855 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
// This generated class is to be used only via validateDatabase()
															#line 171 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
template <class ValidateDatabaseActor>
															#line 171 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
class ValidateDatabaseActorState {
															#line 1861 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
public:
															#line 171 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	ValidateDatabaseActorState(Database const& cx,StorageServerInterface const& ssToExcludeInclude,StorageServerInterface const& ssToWiggle,std::string const& wiggleStorageType) 
															#line 171 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
															#line 171 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		 : cx(cx),
															#line 171 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		   ssToExcludeInclude(ssToExcludeInclude),
															#line 171 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		   ssToWiggle(ssToWiggle),
															#line 171 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		   wiggleStorageType(wiggleStorageType),
															#line 176 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		   missingTargetCount(0)
															#line 1876 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("validateDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ValidateDatabaseActorState() 
	{
		fdb_probe_actor_destroy("validateDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 177 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			;
															#line 1891 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateDatabaseActorState();
		static_cast<ValidateDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 199 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		missingWiggleStorageCount = 0;
															#line 200 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		allSSes = std::vector<StorageServerInterface>();
															#line 201 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		doneCheckingWiggleStorage = false;
															#line 202 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		containWiggleStorage = false;
															#line 203 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		;
															#line 1922 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 178 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		StrictFuture<std::vector<StorageServerInterface>> __when_expr_0 = getStorageServers(cx);
															#line 178 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (static_cast<ValidateDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1940 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ValidateDatabaseActor*>(this)->actor_wait_state = 1;
															#line 178 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateDatabaseActor, 0, std::vector<StorageServerInterface> >*>(static_cast<ValidateDatabaseActor*>(this)));
															#line 1945 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(std::vector<StorageServerInterface> const& allStorageServers,int loopDepth) 
	{
															#line 179 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		bool foundTarget = false;
															#line 180 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		for( auto& ss : allStorageServers ) {
															#line 181 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			if (ss.address() == ssToExcludeInclude.address())
															#line 1971 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			{
															#line 182 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
				foundTarget = true;
															#line 1975 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
				break;
			}
		}
															#line 186 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (foundTarget)
															#line 1981 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 189 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		++missingTargetCount;
															#line 190 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (missingTargetCount > 5)
															#line 1989 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 195 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(20);
															#line 195 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (static_cast<ValidateDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1997 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ValidateDatabaseActor*>(this)->actor_wait_state = 2;
															#line 195 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ValidateDatabaseActor, 1, Void >*>(static_cast<ValidateDatabaseActor*>(this)));
															#line 2002 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(std::vector<StorageServerInterface> && allStorageServers,int loopDepth) 
	{
															#line 179 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		bool foundTarget = false;
															#line 180 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		for( auto& ss : allStorageServers ) {
															#line 181 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			if (ss.address() == ssToExcludeInclude.address())
															#line 2015 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			{
															#line 182 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
				foundTarget = true;
															#line 2019 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
				break;
			}
		}
															#line 186 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (foundTarget)
															#line 2025 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 189 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		++missingTargetCount;
															#line 190 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (missingTargetCount > 5)
															#line 2033 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 195 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(20);
															#line 195 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (static_cast<ValidateDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2041 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ValidateDatabaseActor*>(this)->actor_wait_state = 2;
															#line 195 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ValidateDatabaseActor, 1, Void >*>(static_cast<ValidateDatabaseActor*>(this)));
															#line 2046 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<StorageServerInterface> const& allStorageServers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(allStorageServers, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<StorageServerInterface> && allStorageServers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(allStorageServers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ValidateDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateDatabaseActor*>(this)->ActorCallback< ValidateDatabaseActor, 0, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateDatabaseActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("validateDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateDatabaseActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("validateDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateDatabaseActor, 0, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("validateDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ValidateDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ValidateDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateDatabaseActor*>(this)->ActorCallback< ValidateDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ValidateDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ValidateDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 251 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (!doneCheckingWiggleStorage)
															#line 2217 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		{
															#line 255 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			ASSERT(!containWiggleStorage);
															#line 2221 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		}
															#line 257 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (!static_cast<ValidateDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateDatabaseActorState(); static_cast<ValidateDatabaseActor*>(this)->destroy(); return 0; }
															#line 2225 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		new (&static_cast<ValidateDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateDatabaseActorState();
		static_cast<ValidateDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 204 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		StrictFuture<std::vector<StorageServerInterface>> __when_expr_2 = getStorageServers(cx);
															#line 204 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (static_cast<ValidateDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2246 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ValidateDatabaseActor*>(this)->actor_wait_state = 3;
															#line 204 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ValidateDatabaseActor, 2, std::vector<StorageServerInterface> >*>(static_cast<ValidateDatabaseActor*>(this)));
															#line 2251 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(std::vector<StorageServerInterface> const& SSes,int loopDepth) 
	{
															#line 205 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		allSSes = SSes;
															#line 207 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		i = 0;
															#line 208 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		containWiggleStorage = false;
															#line 209 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		doneCheckingWiggleStorage = false;
															#line 210 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		i = 0;
															#line 2281 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(std::vector<StorageServerInterface> && SSes,int loopDepth) 
	{
															#line 205 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		allSSes = SSes;
															#line 207 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		i = 0;
															#line 208 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		containWiggleStorage = false;
															#line 209 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		doneCheckingWiggleStorage = false;
															#line 210 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		i = 0;
															#line 2298 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(std::vector<StorageServerInterface> const& SSes,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(SSes, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(std::vector<StorageServerInterface> && SSes,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(SSes), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ValidateDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ValidateDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateDatabaseActor*>(this)->ActorCallback< ValidateDatabaseActor, 2, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateDatabaseActor, 2, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("validateDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ValidateDatabaseActor, 2, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("validateDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ValidateDatabaseActor, 2, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("validateDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 238 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (doneCheckingWiggleStorage)
															#line 2382 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 241 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (!containWiggleStorage)
															#line 2388 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		{
															#line 242 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			++missingWiggleStorageCount;
															#line 243 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			if (missingWiggleStorageCount > 5)
															#line 2394 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			{
															#line 244 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
				TraceEvent("Test_TimeoutWaitingForWiggleStorageToShowUp").log();
															#line 2398 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
				return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
			}
		}
															#line 248 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(20);
															#line 248 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (static_cast<ValidateDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2406 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<ValidateDatabaseActor*>(this)->actor_wait_state = 5;
															#line 248 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ValidateDatabaseActor, 4, Void >*>(static_cast<ValidateDatabaseActor*>(this)));
															#line 2411 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 210 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (!(i < allSSes.size()))
															#line 2427 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		{
			return a_body1cont1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 211 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		ssInterface = allSSes[i];
															#line 212 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		typeReply = ReplyPromise<KeyValueStoreType>();
															#line 213 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		StrictFuture<ErrorOr<KeyValueStoreType>> __when_expr_3 = ssInterface.getKeyValueStoreType.getReplyUnlessFailedFor(typeReply, 2, 0);
															#line 213 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (static_cast<ValidateDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2439 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont1loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<ValidateDatabaseActor*>(this)->actor_wait_state = 4;
															#line 213 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ValidateDatabaseActor, 3, ErrorOr<KeyValueStoreType> >*>(static_cast<ValidateDatabaseActor*>(this)));
															#line 2444 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont1(ErrorOr<KeyValueStoreType> const& keyValueStoreType,int loopDepth) 
	{
															#line 215 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (keyValueStoreType.present())
															#line 2466 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		{
															#line 216 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			TraceEvent(SevDebug, "Test_KvStorageType") .detail("StorageServer", ssInterface.address()) .detail("StorageType", keyValueStoreType.get().toString());
															#line 220 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			if (ssInterface.address() == ssToExcludeInclude.address())
															#line 2472 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			{
															#line 222 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
				ASSERT(keyValueStoreType.get().toString() == "ssd-2");
															#line 2476 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			}
															#line 224 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			if (ssInterface.address() == ssToWiggle.address())
															#line 2480 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			{
															#line 226 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
				containWiggleStorage = true;
															#line 227 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
				if (keyValueStoreType.get().toString() == wiggleStorageType)
															#line 2486 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
				{
															#line 228 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
					doneCheckingWiggleStorage = true;
															#line 2490 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 232 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			TraceEvent(SevDebug, "Test_KvStorageType") .detail("StorageServer", ssInterface.address()) .detail("StorageType", "Unknown") .detail("Error", keyValueStoreType.getError().name());
															#line 2498 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		}
															#line 210 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		++i;
															#line 2502 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont1(ErrorOr<KeyValueStoreType> && keyValueStoreType,int loopDepth) 
	{
															#line 215 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		if (keyValueStoreType.present())
															#line 2511 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		{
															#line 216 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			TraceEvent(SevDebug, "Test_KvStorageType") .detail("StorageServer", ssInterface.address()) .detail("StorageType", keyValueStoreType.get().toString());
															#line 220 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			if (ssInterface.address() == ssToExcludeInclude.address())
															#line 2517 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			{
															#line 222 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
				ASSERT(keyValueStoreType.get().toString() == "ssd-2");
															#line 2521 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			}
															#line 224 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			if (ssInterface.address() == ssToWiggle.address())
															#line 2525 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
			{
															#line 226 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
				containWiggleStorage = true;
															#line 227 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
				if (keyValueStoreType.get().toString() == wiggleStorageType)
															#line 2531 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
				{
															#line 228 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
					doneCheckingWiggleStorage = true;
															#line 2535 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 232 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
			TraceEvent(SevDebug, "Test_KvStorageType") .detail("StorageServer", ssInterface.address()) .detail("StorageType", "Unknown") .detail("Error", keyValueStoreType.getError().name());
															#line 2543 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		}
															#line 210 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
		++i;
															#line 2547 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1when1(ErrorOr<KeyValueStoreType> const& keyValueStoreType,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont1(keyValueStoreType, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1when1(ErrorOr<KeyValueStoreType> && keyValueStoreType,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont1(std::move(keyValueStoreType), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ValidateDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ValidateDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateDatabaseActor*>(this)->ActorCallback< ValidateDatabaseActor, 3, ErrorOr<KeyValueStoreType> >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateDatabaseActor, 3, ErrorOr<KeyValueStoreType> >*,ErrorOr<KeyValueStoreType> const& value) 
	{
		fdb_probe_actor_enter("validateDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ValidateDatabaseActor, 3, ErrorOr<KeyValueStoreType> >*,ErrorOr<KeyValueStoreType> && value) 
	{
		fdb_probe_actor_enter("validateDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ValidateDatabaseActor, 3, ErrorOr<KeyValueStoreType> >*,Error err) 
	{
		fdb_probe_actor_enter("validateDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ValidateDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ValidateDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateDatabaseActor*>(this)->ActorCallback< ValidateDatabaseActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateDatabaseActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ValidateDatabaseActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ValidateDatabaseActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 171 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	Database cx;
															#line 171 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	StorageServerInterface ssToExcludeInclude;
															#line 171 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	StorageServerInterface ssToWiggle;
															#line 171 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	std::string wiggleStorageType;
															#line 176 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	int missingTargetCount;
															#line 199 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	int missingWiggleStorageCount;
															#line 200 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	std::vector<StorageServerInterface> allSSes;
															#line 201 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	bool doneCheckingWiggleStorage;
															#line 202 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	bool containWiggleStorage;
															#line 207 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	int i;
															#line 211 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	StorageServerInterface ssInterface;
															#line 212 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	ReplyPromise<KeyValueStoreType> typeReply;
															#line 2738 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
};
// This generated class is to be used only via validateDatabase()
															#line 171 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
class ValidateDatabaseActor final : public Actor<Void>, public ActorCallback< ValidateDatabaseActor, 0, std::vector<StorageServerInterface> >, public ActorCallback< ValidateDatabaseActor, 1, Void >, public ActorCallback< ValidateDatabaseActor, 2, std::vector<StorageServerInterface> >, public ActorCallback< ValidateDatabaseActor, 3, ErrorOr<KeyValueStoreType> >, public ActorCallback< ValidateDatabaseActor, 4, Void >, public FastAllocated<ValidateDatabaseActor>, public ValidateDatabaseActorState<ValidateDatabaseActor> {
															#line 2743 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
public:
	using FastAllocated<ValidateDatabaseActor>::operator new;
	using FastAllocated<ValidateDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16002197982146310144UL, 11286913397877738752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateDatabaseActor, 0, std::vector<StorageServerInterface> >;
friend struct ActorCallback< ValidateDatabaseActor, 1, Void >;
friend struct ActorCallback< ValidateDatabaseActor, 2, std::vector<StorageServerInterface> >;
friend struct ActorCallback< ValidateDatabaseActor, 3, ErrorOr<KeyValueStoreType> >;
friend struct ActorCallback< ValidateDatabaseActor, 4, Void >;
															#line 171 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	ValidateDatabaseActor(Database const& cx,StorageServerInterface const& ssToExcludeInclude,StorageServerInterface const& ssToWiggle,std::string const& wiggleStorageType) 
															#line 2764 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ValidateDatabaseActorState<ValidateDatabaseActor>(cx, ssToExcludeInclude, ssToWiggle, wiggleStorageType),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validateDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14811646927470085376UL, 15098456527210378240UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validateDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validateDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateDatabaseActor, 0, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ValidateDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ValidateDatabaseActor, 2, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ValidateDatabaseActor, 3, ErrorOr<KeyValueStoreType> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ValidateDatabaseActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 171 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
[[nodiscard]] static Future<Void> validateDatabase( Database const& cx, StorageServerInterface const& ssToExcludeInclude, StorageServerInterface const& ssToWiggle, std::string const& wiggleStorageType ) {
															#line 171 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"
	return Future<Void>(new ValidateDatabaseActor(cx, ssToExcludeInclude, ssToWiggle, wiggleStorageType));
															#line 2800 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.g.cpp"
}

#line 259 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStorageMigrationWorkload.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override { return; }
};

WorkloadFactory<PerpetualWiggleStorageMigrationWorkload> PerpetualWiggleStorageMigrationWorkload;
