#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
/*
 * BackgroundSelectors.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

KeySelector randomizedSelector(const KeyRef& key, bool orEqual, int offset) {
	if (orEqual && deterministicRandom()->random01() > 0.5)
		return KeySelectorRef(keyAfter(key), false, offset);
	return KeySelectorRef(key, orEqual, offset);
}

struct BackgroundSelectorWorkload : TestWorkload {
	static constexpr auto NAME = "BackgroundSelector";
	int actorsPerClient, maxDiff, minDrift, maxDrift, resultLimit;
	double testDuration, transactionsPerSecond;

	std::vector<Future<Void>> clients;
	PerfIntCounter operations, checks, retries;

	BackgroundSelectorWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), operations("Operations"), checks("Checks"), retries("Retries") {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		actorsPerClient = std::max(getOption(options, "actorsPerClient"_sr, 1), 1);
		maxDiff = std::max(getOption(options, "maxDiff"_sr, 100), 2);
		minDrift = getOption(options, "minDiff"_sr, -10);
		maxDrift = getOption(options, "minDiff"_sr, 100);
		transactionsPerSecond = getOption(options, "transactionsPerSecond"_sr, 10.0) / (clientCount * actorsPerClient);
		resultLimit = 10 * maxDiff;
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override { return _start(cx, this); }

																#line 57 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 55 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
template <class _startActor>
															#line 55 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
class _startActorState {
															#line 63 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
public:
															#line 55 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	_startActorState(Database const& cx,BackgroundSelectorWorkload* const& self) 
															#line 55 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
															#line 55 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		 : cx(cx),
															#line 55 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		   self(self)
															#line 72 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 56 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			for(int c = 0;c < self->actorsPerClient;c++) {
															#line 57 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
				self->clients.push_back(timeout(self->backgroundSelectorWorker(cx, self), self->testDuration, Void()));
															#line 89 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
			}
															#line 58 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(self->clients);
															#line 58 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 95 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 58 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 100 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 59 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 123 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 59 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 135 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 55 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	Database cx;
															#line 55 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	BackgroundSelectorWorkload* self;
															#line 222 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 55 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 227 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3957141986246428672UL, 3992890341509323776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 55 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	_startActor(Database const& cx,BackgroundSelectorWorkload* const& self) 
															#line 244 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 55 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, BackgroundSelectorWorkload* const& self ) {
															#line 55 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 276 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
}

#line 61 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"

	Future<bool> check(Database const& cx) override {
		bool ok = true;
		for (int i = 0; i < clients.size(); i++)
			if (clients[i].isError())
				ok = false;
		clients.clear();
		return ok;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		double duration = testDuration;
		m.emplace_back("Operations/sec", operations.getValue() / duration, Averaged::False);
		m.push_back(operations.getMetric());
		m.push_back(checks.getMetric());
		m.push_back(retries.getMetric());
	}

																#line 298 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
// This generated class is to be used only via backgroundSelectorWorker()
															#line 79 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
template <class BackgroundSelectorWorkerActor>
															#line 79 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
class BackgroundSelectorWorkerActorState {
															#line 304 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
public:
															#line 79 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	BackgroundSelectorWorkerActorState(Database const& cx,BackgroundSelectorWorkload* const& self) 
															#line 79 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
															#line 79 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		 : cx(cx),
															#line 79 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		   self(self),
															#line 80 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		   lastTime(now()),
															#line 81 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		   forward(),
															#line 82 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		   direction(),
															#line 83 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		   startKey(),
															#line 84 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		   endKey(),
															#line 85 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		   diff(),
															#line 86 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		   tr(cx),
															#line 87 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		   rangeResult(),
															#line 88 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		   startResult(),
															#line 89 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		   endResult(),
															#line 90 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		   startDrift(),
															#line 91 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		   endDrift(),
															#line 92 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		   restartProcess()
															#line 339 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
	{
		fdb_probe_actor_create("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this));

	}
	~BackgroundSelectorWorkerActorState() 
	{
		fdb_probe_actor_destroy("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 94 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			;
															#line 354 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BackgroundSelectorWorkerActorState();
		static_cast<BackgroundSelectorWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 95 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		forward = deterministicRandom()->randomInt(0, 2) != 0;
															#line 96 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		direction = forward ? 1 : -1;
															#line 97 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		diff = deterministicRandom()->randomInt(0, self->maxDiff);
															#line 100 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		;
															#line 390 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 129 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		;
															#line 399 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 102 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			if (forward)
															#line 416 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
			{
				{
															#line 104 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
					StrictFuture<Standalone<StringRef>> __when_expr_0 = tr.getKey(KeySelectorRef(allKeys.begin, false, 1));
															#line 104 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
					if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 423 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
					static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 1;
															#line 104 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BackgroundSelectorWorkerActor, 0, Standalone<StringRef> >*>(static_cast<BackgroundSelectorWorkerActor*>(this)));
															#line 428 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
					loopDepth = 0;
				}
			}
			else
			{
				{
															#line 114 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
					StrictFuture<Standalone<StringRef>> __when_expr_2 = tr.getKey(KeySelectorRef(allKeys.end, false, 0));
															#line 114 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
					if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 439 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1when2(__when_expr_2.get(), loopDepth); };
					static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 3;
															#line 114 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BackgroundSelectorWorkerActor, 2, Standalone<StringRef> >*>(static_cast<BackgroundSelectorWorkerActor*>(this)));
															#line 444 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
					loopDepth = 0;
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 125 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 125 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 483 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 5;
															#line 125 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BackgroundSelectorWorkerActor, 4, Void >*>(static_cast<BackgroundSelectorWorkerActor*>(this)));
															#line 488 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
		{
															#line 109 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_1 = tr.getKey(randomizedSelector(startKey, true, diff));
															#line 109 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 512 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
			static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 2;
															#line 109 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BackgroundSelectorWorkerActor, 1, Standalone<StringRef> >*>(static_cast<BackgroundSelectorWorkerActor*>(this)));
															#line 517 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Standalone<StringRef> const& res,int loopDepth) 
	{
															#line 105 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		startKey = res;
															#line 527 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Standalone<StringRef> && res,int loopDepth) 
	{
															#line 105 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		startKey = res;
															#line 536 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Standalone<StringRef> const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Standalone<StringRef> && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackgroundSelectorWorkerActor*>(this)->ActorCallback< BackgroundSelectorWorkerActor, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BackgroundSelectorWorkerActor, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont7(Standalone<StringRef> const& res,int loopDepth) 
	{
															#line 110 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		endKey = res;
															#line 626 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont7(Standalone<StringRef> && res,int loopDepth) 
	{
															#line 110 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		endKey = res;
															#line 635 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Standalone<StringRef> const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont7(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Standalone<StringRef> && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont7(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackgroundSelectorWorkerActor*>(this)->ActorCallback< BackgroundSelectorWorkerActor, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BackgroundSelectorWorkerActor, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont9(int loopDepth) 
	{
		{
															#line 119 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_3 = tr.getKey(randomizedSelector(endKey, true, -1 * diff));
															#line 119 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 722 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont9when1(__when_expr_3.get(), loopDepth); };
			static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 4;
															#line 119 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BackgroundSelectorWorkerActor, 3, Standalone<StringRef> >*>(static_cast<BackgroundSelectorWorkerActor*>(this)));
															#line 727 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont10(Standalone<StringRef> const& res,int loopDepth) 
	{
															#line 115 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		endKey = res;
															#line 737 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont10(Standalone<StringRef> && res,int loopDepth) 
	{
															#line 115 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		endKey = res;
															#line 746 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Standalone<StringRef> const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Standalone<StringRef> && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackgroundSelectorWorkerActor*>(this)->ActorCallback< BackgroundSelectorWorkerActor, 2, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 2, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 2, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BackgroundSelectorWorkerActor, 2, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1cont11(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont12(Standalone<StringRef> const& res,int loopDepth) 
	{
															#line 120 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		startKey = res;
															#line 836 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont12(Standalone<StringRef> && res,int loopDepth) 
	{
															#line 120 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		startKey = res;
															#line 845 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9when1(Standalone<StringRef> const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont12(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9when1(Standalone<StringRef> && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont12(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackgroundSelectorWorkerActor*>(this)->ActorCallback< BackgroundSelectorWorkerActor, 3, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 3, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 3, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< BackgroundSelectorWorkerActor, 3, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackgroundSelectorWorkerActor*>(this)->ActorCallback< BackgroundSelectorWorkerActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< BackgroundSelectorWorkerActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 130 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		StrictFuture<Void> __when_expr_5 = poisson(&lastTime, 1.0 / self->transactionsPerSecond);
															#line 130 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1031 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_5.get(), loopDepth); };
		static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 6;
															#line 130 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< BackgroundSelectorWorkerActor, 5, Void >*>(static_cast<BackgroundSelectorWorkerActor*>(this)));
															#line 1036 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		tr.reset();
															#line 132 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		startDrift = direction * deterministicRandom()->randomInt(self->minDrift, self->maxDrift);
															#line 133 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		endDrift = direction * deterministicRandom()->randomInt(self->minDrift, self->maxDrift);
															#line 136 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		endDrift = std::max(endDrift, startDrift - self->maxDiff - diff);
															#line 137 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		endDrift = std::min(endDrift, startDrift + self->maxDiff - diff);
															#line 139 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		diff = diff + endDrift - startDrift;
															#line 140 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		if (diff == 0)
															#line 1070 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		{
															#line 141 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			endDrift++;
															#line 142 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			diff++;
															#line 1076 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		}
															#line 145 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		;
															#line 1080 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		tr.reset();
															#line 132 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		startDrift = direction * deterministicRandom()->randomInt(self->minDrift, self->maxDrift);
															#line 133 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		endDrift = direction * deterministicRandom()->randomInt(self->minDrift, self->maxDrift);
															#line 136 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		endDrift = std::max(endDrift, startDrift - self->maxDiff - diff);
															#line 137 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		endDrift = std::min(endDrift, startDrift + self->maxDiff - diff);
															#line 139 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		diff = diff + endDrift - startDrift;
															#line 140 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		if (diff == 0)
															#line 1101 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		{
															#line 141 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			endDrift++;
															#line 142 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			diff++;
															#line 1107 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		}
															#line 145 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		;
															#line 1111 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackgroundSelectorWorkerActor*>(this)->ActorCallback< BackgroundSelectorWorkerActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< BackgroundSelectorWorkerActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont1loopBody1cont2(int loopDepth) 
	{
															#line 210 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		++self->operations;
															#line 211 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		if (restartProcess)
															#line 1197 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 213 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		++self->checks;
															#line 1203 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 147 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			if (diff < 0)
															#line 1220 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
			{
															#line 148 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
				StrictFuture<RangeResult> __when_expr_6 = tr.getRange(randomizedSelector(endKey, true, endDrift), randomizedSelector(startKey, true, startDrift + 1), self->resultLimit);
															#line 148 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
				if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1226 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont1loopBody1when1(__when_expr_6.get(), loopDepth); };
				static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 7;
															#line 148 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< BackgroundSelectorWorkerActor, 6, RangeResult >*>(static_cast<BackgroundSelectorWorkerActor*>(this)));
															#line 1231 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 160 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
				StrictFuture<RangeResult> __when_expr_9 = tr.getRange(randomizedSelector(startKey, true, startDrift), randomizedSelector(endKey, true, endDrift + 1), self->resultLimit);
															#line 160 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
				if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1240 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont1loopBody1when2(__when_expr_9.get(), loopDepth); };
				static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 10;
															#line 160 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< BackgroundSelectorWorkerActor, 9, RangeResult >*>(static_cast<BackgroundSelectorWorkerActor*>(this)));
															#line 1245 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 206 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			StrictFuture<Void> __when_expr_12 = tr.onError(e);
															#line 206 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 3));
															#line 1283 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
			if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 3)); else return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1when1(__when_expr_12.get(), loopDepth); };
			static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 13;
															#line 206 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< BackgroundSelectorWorkerActor, 12, Void >*>(static_cast<BackgroundSelectorWorkerActor*>(this)));
															#line 1288 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont2(int loopDepth) 
	{
															#line 172 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		restartProcess = false;
															#line 173 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		if (rangeResult.size() == 0)
															#line 1305 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		{
															#line 174 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			restartProcess = true;
															#line 1309 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
			return a_body1loopBody1cont1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 178 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		if (rangeResult.size() < self->resultLimit && startResult != allKeys.begin && startResult != allKeys.end)
															#line 1314 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		{
															#line 180 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			if (startResult != rangeResult[0].key)
															#line 1318 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
			{
															#line 181 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
				TraceEvent(SevError, "BackgroundSelectorError") .detail("Diff", diff) .detail("ResultSize", rangeResult.size()) .detail("StartResult", printable(startResult)) .detail("RangeResult", printable(rangeResult[0].key));
															#line 1322 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
			}
		}
		else
		{
															#line 187 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			restartProcess = true;
															#line 1329 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		}
															#line 189 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		if (rangeResult.size() < self->resultLimit && endResult != allKeys.begin && endResult != allKeys.end)
															#line 1333 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		{
															#line 191 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			if (endResult != rangeResult[rangeResult.size() - 1].key)
															#line 1337 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
			{
															#line 192 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
				TraceEvent(SevError, "BackgroundSelectorError") .detail("Diff", diff) .detail("ResultSize", rangeResult.size()) .detail("EndResult  ", printable(endResult)) .detail("RangeResult", printable(rangeResult[rangeResult.size() - 1].key));
															#line 1341 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
			}
		}
		else
		{
															#line 198 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
			restartProcess = true;
															#line 1348 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		}
															#line 200 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		diff = std::min(rangeResult.size() - 1, self->maxDiff);
															#line 201 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		startKey = rangeResult[0].key;
															#line 202 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		endKey = rangeResult[diff].key;
															#line 1356 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont3(RangeResult const& rangeResult_,int loopDepth) 
	{
															#line 152 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		rangeResult = rangeResult_;
															#line 153 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_7 = tr.getKey(randomizedSelector(startKey, true, startDrift));
															#line 153 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1369 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont1loopBody1cont3when1(__when_expr_7.get(), loopDepth); };
		static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 8;
															#line 153 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< BackgroundSelectorWorkerActor, 7, Standalone<StringRef> >*>(static_cast<BackgroundSelectorWorkerActor*>(this)));
															#line 1374 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont3(RangeResult && rangeResult_,int loopDepth) 
	{
															#line 152 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		rangeResult = rangeResult_;
															#line 153 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_7 = tr.getKey(randomizedSelector(startKey, true, startDrift));
															#line 153 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1387 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont1loopBody1cont3when1(__when_expr_7.get(), loopDepth); };
		static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 8;
															#line 153 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< BackgroundSelectorWorkerActor, 7, Standalone<StringRef> >*>(static_cast<BackgroundSelectorWorkerActor*>(this)));
															#line 1392 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1when1(RangeResult const& rangeResult_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1cont3(rangeResult_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1when1(RangeResult && rangeResult_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1cont3(std::move(rangeResult_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackgroundSelectorWorkerActor*>(this)->ActorCallback< BackgroundSelectorWorkerActor, 6, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 6, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 6, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< BackgroundSelectorWorkerActor, 6, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont4(Standalone<StringRef> const& endResult_,int loopDepth) 
	{
															#line 155 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		endResult = endResult_;
															#line 156 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_8 = tr.getKey(randomizedSelector(endKey, true, endDrift));
															#line 156 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1480 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont1loopBody1cont4when1(__when_expr_8.get(), loopDepth); };
		static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 9;
															#line 156 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< BackgroundSelectorWorkerActor, 8, Standalone<StringRef> >*>(static_cast<BackgroundSelectorWorkerActor*>(this)));
															#line 1485 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont4(Standalone<StringRef> && endResult_,int loopDepth) 
	{
															#line 155 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		endResult = endResult_;
															#line 156 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_8 = tr.getKey(randomizedSelector(endKey, true, endDrift));
															#line 156 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1498 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont1loopBody1cont4when1(__when_expr_8.get(), loopDepth); };
		static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 9;
															#line 156 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< BackgroundSelectorWorkerActor, 8, Standalone<StringRef> >*>(static_cast<BackgroundSelectorWorkerActor*>(this)));
															#line 1503 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont3when1(Standalone<StringRef> const& endResult_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1cont4(endResult_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont3when1(Standalone<StringRef> && endResult_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1cont4(std::move(endResult_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackgroundSelectorWorkerActor*>(this)->ActorCallback< BackgroundSelectorWorkerActor, 7, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 7, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 7, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< BackgroundSelectorWorkerActor, 7, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont5(Standalone<StringRef> const& startResult_,int loopDepth) 
	{
															#line 158 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		startResult = startResult_;
															#line 1587 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont5(Standalone<StringRef> && startResult_,int loopDepth) 
	{
															#line 158 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		startResult = startResult_;
															#line 1596 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont4when1(Standalone<StringRef> const& startResult_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1cont5(startResult_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont4when1(Standalone<StringRef> && startResult_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1cont5(std::move(startResult_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackgroundSelectorWorkerActor*>(this)->ActorCallback< BackgroundSelectorWorkerActor, 8, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 8, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 8, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< BackgroundSelectorWorkerActor, 8, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont7(RangeResult const& rangeResult_,int loopDepth) 
	{
															#line 163 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		rangeResult = rangeResult_;
															#line 164 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_10 = tr.getKey(randomizedSelector(startKey, true, startDrift));
															#line 164 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1684 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont1loopBody1cont7when1(__when_expr_10.get(), loopDepth); };
		static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 11;
															#line 164 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< BackgroundSelectorWorkerActor, 10, Standalone<StringRef> >*>(static_cast<BackgroundSelectorWorkerActor*>(this)));
															#line 1689 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont7(RangeResult && rangeResult_,int loopDepth) 
	{
															#line 163 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		rangeResult = rangeResult_;
															#line 164 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_10 = tr.getKey(randomizedSelector(startKey, true, startDrift));
															#line 164 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1702 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont1loopBody1cont7when1(__when_expr_10.get(), loopDepth); };
		static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 11;
															#line 164 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< BackgroundSelectorWorkerActor, 10, Standalone<StringRef> >*>(static_cast<BackgroundSelectorWorkerActor*>(this)));
															#line 1707 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1when2(RangeResult const& rangeResult_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1cont7(rangeResult_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1when2(RangeResult && rangeResult_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1cont7(std::move(rangeResult_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackgroundSelectorWorkerActor*>(this)->ActorCallback< BackgroundSelectorWorkerActor, 9, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 9, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 9, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< BackgroundSelectorWorkerActor, 9, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont8(Standalone<StringRef> const& startResult_,int loopDepth) 
	{
															#line 166 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		startResult = startResult_;
															#line 167 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_11 = tr.getKey(randomizedSelector(endKey, true, endDrift));
															#line 167 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1795 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont1loopBody1cont8when1(__when_expr_11.get(), loopDepth); };
		static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 12;
															#line 167 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< BackgroundSelectorWorkerActor, 11, Standalone<StringRef> >*>(static_cast<BackgroundSelectorWorkerActor*>(this)));
															#line 1800 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont8(Standalone<StringRef> && startResult_,int loopDepth) 
	{
															#line 166 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		startResult = startResult_;
															#line 167 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_11 = tr.getKey(randomizedSelector(endKey, true, endDrift));
															#line 167 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1813 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont1loopBody1cont8when1(__when_expr_11.get(), loopDepth); };
		static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 12;
															#line 167 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< BackgroundSelectorWorkerActor, 11, Standalone<StringRef> >*>(static_cast<BackgroundSelectorWorkerActor*>(this)));
															#line 1818 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont7when1(Standalone<StringRef> const& startResult_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1cont8(startResult_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont7when1(Standalone<StringRef> && startResult_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1cont8(std::move(startResult_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackgroundSelectorWorkerActor*>(this)->ActorCallback< BackgroundSelectorWorkerActor, 10, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 10, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 10, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< BackgroundSelectorWorkerActor, 10, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont9(Standalone<StringRef> const& endResult_,int loopDepth) 
	{
															#line 169 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		endResult = endResult_;
															#line 1902 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont9(Standalone<StringRef> && endResult_,int loopDepth) 
	{
															#line 169 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		endResult = endResult_;
															#line 1911 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont8when1(Standalone<StringRef> const& endResult_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1cont9(endResult_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1cont8when1(Standalone<StringRef> && endResult_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1cont9(std::move(endResult_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackgroundSelectorWorkerActor*>(this)->ActorCallback< BackgroundSelectorWorkerActor, 11, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 11, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 11, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< BackgroundSelectorWorkerActor, 11, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 207 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		++self->retries;
															#line 1995 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 207 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
		++self->retries;
															#line 2004 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackgroundSelectorWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackgroundSelectorWorkerActor*>(this)->ActorCallback< BackgroundSelectorWorkerActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< BackgroundSelectorWorkerActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1loopBody1cont1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< BackgroundSelectorWorkerActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), 12);

	}
															#line 79 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	Database cx;
															#line 79 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	BackgroundSelectorWorkload* self;
															#line 80 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	double lastTime;
															#line 81 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	bool forward;
															#line 82 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	int direction;
															#line 83 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	Key startKey;
															#line 84 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	Key endKey;
															#line 85 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	int diff;
															#line 86 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	Transaction tr;
															#line 87 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	RangeResult rangeResult;
															#line 88 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	Standalone<StringRef> startResult;
															#line 89 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	Standalone<StringRef> endResult;
															#line 90 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	int startDrift;
															#line 91 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	int endDrift;
															#line 92 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	bool restartProcess;
															#line 2114 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
};
// This generated class is to be used only via backgroundSelectorWorker()
															#line 79 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
class BackgroundSelectorWorkerActor final : public Actor<Void>, public ActorCallback< BackgroundSelectorWorkerActor, 0, Standalone<StringRef> >, public ActorCallback< BackgroundSelectorWorkerActor, 1, Standalone<StringRef> >, public ActorCallback< BackgroundSelectorWorkerActor, 2, Standalone<StringRef> >, public ActorCallback< BackgroundSelectorWorkerActor, 3, Standalone<StringRef> >, public ActorCallback< BackgroundSelectorWorkerActor, 4, Void >, public ActorCallback< BackgroundSelectorWorkerActor, 5, Void >, public ActorCallback< BackgroundSelectorWorkerActor, 6, RangeResult >, public ActorCallback< BackgroundSelectorWorkerActor, 7, Standalone<StringRef> >, public ActorCallback< BackgroundSelectorWorkerActor, 8, Standalone<StringRef> >, public ActorCallback< BackgroundSelectorWorkerActor, 9, RangeResult >, public ActorCallback< BackgroundSelectorWorkerActor, 10, Standalone<StringRef> >, public ActorCallback< BackgroundSelectorWorkerActor, 11, Standalone<StringRef> >, public ActorCallback< BackgroundSelectorWorkerActor, 12, Void >, public FastAllocated<BackgroundSelectorWorkerActor>, public BackgroundSelectorWorkerActorState<BackgroundSelectorWorkerActor> {
															#line 2119 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
public:
	using FastAllocated<BackgroundSelectorWorkerActor>::operator new;
	using FastAllocated<BackgroundSelectorWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12849480324015086336UL, 15776760330103420928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BackgroundSelectorWorkerActor, 0, Standalone<StringRef> >;
friend struct ActorCallback< BackgroundSelectorWorkerActor, 1, Standalone<StringRef> >;
friend struct ActorCallback< BackgroundSelectorWorkerActor, 2, Standalone<StringRef> >;
friend struct ActorCallback< BackgroundSelectorWorkerActor, 3, Standalone<StringRef> >;
friend struct ActorCallback< BackgroundSelectorWorkerActor, 4, Void >;
friend struct ActorCallback< BackgroundSelectorWorkerActor, 5, Void >;
friend struct ActorCallback< BackgroundSelectorWorkerActor, 6, RangeResult >;
friend struct ActorCallback< BackgroundSelectorWorkerActor, 7, Standalone<StringRef> >;
friend struct ActorCallback< BackgroundSelectorWorkerActor, 8, Standalone<StringRef> >;
friend struct ActorCallback< BackgroundSelectorWorkerActor, 9, RangeResult >;
friend struct ActorCallback< BackgroundSelectorWorkerActor, 10, Standalone<StringRef> >;
friend struct ActorCallback< BackgroundSelectorWorkerActor, 11, Standalone<StringRef> >;
friend struct ActorCallback< BackgroundSelectorWorkerActor, 12, Void >;
															#line 79 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	BackgroundSelectorWorkerActor(Database const& cx,BackgroundSelectorWorkload* const& self) 
															#line 2148 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
		 : Actor<Void>(),
		   BackgroundSelectorWorkerActorState<BackgroundSelectorWorkerActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5164838191316079360UL, 16441926090385434624UL);
		ActorExecutionContextHelper __helper(static_cast<BackgroundSelectorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("backgroundSelectorWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("backgroundSelectorWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BackgroundSelectorWorkerActor, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BackgroundSelectorWorkerActor, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BackgroundSelectorWorkerActor, 2, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< BackgroundSelectorWorkerActor, 3, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< BackgroundSelectorWorkerActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< BackgroundSelectorWorkerActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< BackgroundSelectorWorkerActor, 6, RangeResult >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< BackgroundSelectorWorkerActor, 7, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< BackgroundSelectorWorkerActor, 8, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< BackgroundSelectorWorkerActor, 9, RangeResult >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< BackgroundSelectorWorkerActor, 10, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< BackgroundSelectorWorkerActor, 11, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< BackgroundSelectorWorkerActor, 12, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 79 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
[[nodiscard]] Future<Void> backgroundSelectorWorker( Database const& cx, BackgroundSelectorWorkload* const& self ) {
															#line 79 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
	return Future<Void>(new BackgroundSelectorWorkerActor(cx, self));
															#line 2192 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackgroundSelectors.actor.g.cpp"
}

#line 217 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/BackgroundSelectors.actor.cpp"
};

WorkloadFactory<BackgroundSelectorWorkload> BackgroundSelectorWorkloadFactory;
