#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
/*
 * ApiWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/workloads/ApiWorkload.h"

#include "fdbclient/FDBTypes.h"
#include "fdbclient/MultiVersionTransaction.h"

#include "fdbrpc/simulator.h"
#include "fdbrpc/TenantInfo.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/IRandom.h"

#include <cinttypes>
#include "fmt/format.h"

#include "flow/actorcompiler.h" // This must be the last #include.

// Clears the keyspace used by this test
															#line 41 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
namespace {
// This generated class is to be used only via clearKeyspace()
															#line 39 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
template <class ClearKeyspaceActor>
															#line 39 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
class ClearKeyspaceActorState {
															#line 48 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
public:
															#line 39 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	ClearKeyspaceActorState(ApiWorkload* const& self) 
															#line 39 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
															#line 39 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		 : self(self)
															#line 55 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("clearKeyspace", reinterpret_cast<unsigned long>(this));

	}
	~ClearKeyspaceActorState() 
	{
		fdb_probe_actor_destroy("clearKeyspace", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 40 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			;
															#line 70 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearKeyspaceActorState();
		static_cast<ClearKeyspaceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 41 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		transaction = self->createTransaction();
															#line 100 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		try {
															#line 43 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			KeyRange range(KeyRangeRef(StringRef(format("%010d", self->clientPrefixInt)), StringRef(format("%010d", self->clientPrefixInt + 1))));
															#line 46 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			transaction->clear(range);
															#line 47 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = transaction->commit();
															#line 47 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			if (static_cast<ClearKeyspaceActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 110 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearKeyspaceActor*>(this)->actor_wait_state = 1;
															#line 47 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearKeyspaceActor, 0, Void >*>(static_cast<ClearKeyspaceActor*>(this)));
															#line 115 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 50 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = transaction->onError(e);
															#line 50 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			if (static_cast<ClearKeyspaceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 139 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ClearKeyspaceActor*>(this)->actor_wait_state = 2;
															#line 50 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearKeyspaceActor, 1, Void >*>(static_cast<ClearKeyspaceActor*>(this)));
															#line 144 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 48 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		if (!static_cast<ClearKeyspaceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearKeyspaceActorState(); static_cast<ClearKeyspaceActor*>(this)->destroy(); return 0; }
															#line 159 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		new (&static_cast<ClearKeyspaceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearKeyspaceActorState();
		static_cast<ClearKeyspaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 48 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		if (!static_cast<ClearKeyspaceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearKeyspaceActorState(); static_cast<ClearKeyspaceActor*>(this)->destroy(); return 0; }
															#line 171 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		new (&static_cast<ClearKeyspaceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearKeyspaceActorState();
		static_cast<ClearKeyspaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearKeyspaceActor*>(this)->actor_wait_state > 0) static_cast<ClearKeyspaceActor*>(this)->actor_wait_state = 0;
		static_cast<ClearKeyspaceActor*>(this)->ActorCallback< ClearKeyspaceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearKeyspaceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearKeyspace", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearKeyspaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearKeyspace", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearKeyspaceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearKeyspace", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearKeyspaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearKeyspace", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearKeyspaceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearKeyspace", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearKeyspaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearKeyspace", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearKeyspaceActor*>(this)->actor_wait_state > 0) static_cast<ClearKeyspaceActor*>(this)->actor_wait_state = 0;
		static_cast<ClearKeyspaceActor*>(this)->ActorCallback< ClearKeyspaceActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearKeyspaceActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearKeyspace", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearKeyspaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearKeyspace", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearKeyspaceActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearKeyspace", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearKeyspaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearKeyspace", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearKeyspaceActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearKeyspace", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearKeyspaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearKeyspace", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 39 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	ApiWorkload* self;
															#line 41 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	Reference<TransactionWrapper> transaction;
															#line 345 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
};
// This generated class is to be used only via clearKeyspace()
															#line 39 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
class ClearKeyspaceActor final : public Actor<Void>, public ActorCallback< ClearKeyspaceActor, 0, Void >, public ActorCallback< ClearKeyspaceActor, 1, Void >, public FastAllocated<ClearKeyspaceActor>, public ClearKeyspaceActorState<ClearKeyspaceActor> {
															#line 350 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
public:
	using FastAllocated<ClearKeyspaceActor>::operator new;
	using FastAllocated<ClearKeyspaceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8110765064695638528UL, 4738254240530256896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearKeyspaceActor, 0, Void >;
friend struct ActorCallback< ClearKeyspaceActor, 1, Void >;
															#line 39 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	ClearKeyspaceActor(ApiWorkload* const& self) 
															#line 368 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ClearKeyspaceActorState<ClearKeyspaceActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearKeyspace", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10321701373687518464UL, 8481082412837495296UL);
		ActorExecutionContextHelper __helper(static_cast<ClearKeyspaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearKeyspace");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearKeyspace", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearKeyspaceActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearKeyspaceActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 39 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
[[nodiscard]] Future<Void> clearKeyspace( ApiWorkload* const& self ) {
															#line 39 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	return Future<Void>(new ClearKeyspaceActor(self));
															#line 402 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
}

#line 54 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"

Future<Void> ApiWorkload::clearKeyspace() {
	return ::clearKeyspace(this);
}

															#line 411 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
namespace {
// This generated class is to be used only via setup()
															#line 59 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
template <class SetupActor>
															#line 59 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
class SetupActorState {
															#line 418 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
public:
															#line 59 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	SetupActorState(Database const& cx,ApiWorkload* const& self) 
															#line 59 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
															#line 59 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		 : cx(cx),
															#line 59 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		   self(self)
															#line 427 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("setup", reinterpret_cast<unsigned long>(this));

	}
	~SetupActorState() 
	{
		fdb_probe_actor_destroy("setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 60 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			self->transactionFactory = Reference<TransactionFactoryInterface>( new TransactionFactory<FlowTransactionWrapper<Transaction>, const Database>(cx, cx, false));
															#line 64 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeoutError(self->clearKeyspace(), 600);
															#line 64 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			if (static_cast<SetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 446 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetupActor*>(this)->actor_wait_state = 1;
															#line 64 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetupActor, 0, Void >*>(static_cast<SetupActor*>(this)));
															#line 451 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetupActorState();
		static_cast<SetupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 65 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->performSetup(cx);
															#line 65 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		if (static_cast<SetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 476 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SetupActor*>(this)->actor_wait_state = 2;
															#line 65 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetupActor, 1, Void >*>(static_cast<SetupActor*>(this)));
															#line 481 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 65 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->performSetup(cx);
															#line 65 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		if (static_cast<SetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 492 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SetupActor*>(this)->actor_wait_state = 2;
															#line 65 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetupActor, 1, Void >*>(static_cast<SetupActor*>(this)));
															#line 497 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetupActor*>(this)->actor_wait_state > 0) static_cast<SetupActor*>(this)->actor_wait_state = 0;
		static_cast<SetupActor*>(this)->ActorCallback< SetupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 67 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		if (!static_cast<SetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActorState(); static_cast<SetupActor*>(this)->destroy(); return 0; }
															#line 581 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		new (&static_cast<SetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActorState();
		static_cast<SetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 67 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		if (!static_cast<SetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActorState(); static_cast<SetupActor*>(this)->destroy(); return 0; }
															#line 593 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		new (&static_cast<SetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActorState();
		static_cast<SetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetupActor*>(this)->actor_wait_state > 0) static_cast<SetupActor*>(this)->actor_wait_state = 0;
		static_cast<SetupActor*>(this)->ActorCallback< SetupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 59 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	Database cx;
															#line 59 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	ApiWorkload* self;
															#line 680 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
};
// This generated class is to be used only via setup()
															#line 59 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
class SetupActor final : public Actor<Void>, public ActorCallback< SetupActor, 0, Void >, public ActorCallback< SetupActor, 1, Void >, public FastAllocated<SetupActor>, public SetupActorState<SetupActor> {
															#line 685 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
public:
	using FastAllocated<SetupActor>::operator new;
	using FastAllocated<SetupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1601754902005209856UL, 1504599505247046144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetupActor, 0, Void >;
friend struct ActorCallback< SetupActor, 1, Void >;
															#line 59 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	SetupActor(Database const& cx,ApiWorkload* const& self) 
															#line 703 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   SetupActorState<SetupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13998344965578828288UL, 688267501332814080UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 59 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
[[nodiscard]] Future<Void> setup( Database const& cx, ApiWorkload* const& self ) {
															#line 59 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	return Future<Void>(new SetupActor(cx, self));
															#line 737 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
}

#line 69 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"

Future<Void> ApiWorkload::setup(Database const& cx) {
	if (clientId < maxClients || maxClients < 0)
		return ::setup(cx, this);

	return Void();
}

															#line 749 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
namespace {
// This generated class is to be used only via start()
															#line 77 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
template <class StartActor>
															#line 77 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
class StartActorState {
															#line 756 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
public:
															#line 77 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	StartActorState(Database const& cx,ApiWorkload* const& self) 
															#line 77 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
															#line 77 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		 : cx(cx),
															#line 77 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		   self(self),
															#line 79 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		   data(self->generateData(self->numKeys * self->shortKeysRatio, self->minShortKeyLength, self->maxShortKeyLength, self->minValueLength, self->maxValueLength, self->clientPrefix))
															#line 767 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("start", reinterpret_cast<unsigned long>(this));

	}
	~StartActorState() 
	{
		fdb_probe_actor_destroy("start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 85 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			Standalone<VectorRef<KeyValueRef>> bigKeyData = self->generateData(self->numKeys * (1 - self->shortKeysRatio), self->minLongKeyLength, self->maxLongKeyLength, self->minValueLength, self->maxValueLength, self->clientPrefix);
															#line 92 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			data.append_deep(data.arena(), bigKeyData.begin(), bigKeyData.size());
															#line 784 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			try {
															#line 95 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->performTest(cx, data);
															#line 95 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
				if (static_cast<StartActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 790 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<StartActor*>(this)->actor_wait_state = 1;
															#line 95 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartActor, 0, Void >*>(static_cast<StartActor*>(this)));
															#line 795 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartActorState();
		static_cast<StartActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 101 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		if (!static_cast<StartActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartActorState(); static_cast<StartActor*>(this)->destroy(); return 0; }
															#line 824 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		new (&static_cast<StartActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartActorState();
		static_cast<StartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 97 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 837 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			{
															#line 98 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
				self->testFailure(format("Unhandled error %d: %s", e.code(), e.name()));
															#line 841 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartActor*>(this)->actor_wait_state > 0) static_cast<StartActor*>(this)->actor_wait_state = 0;
		static_cast<StartActor*>(this)->ActorCallback< StartActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 77 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	Database cx;
															#line 77 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	ApiWorkload* self;
															#line 79 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> data;
															#line 959 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
};
// This generated class is to be used only via start()
															#line 77 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
class StartActor final : public Actor<Void>, public ActorCallback< StartActor, 0, Void >, public FastAllocated<StartActor>, public StartActorState<StartActor> {
															#line 964 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
public:
	using FastAllocated<StartActor>::operator new;
	using FastAllocated<StartActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18058386271215649024UL, 801397940599545344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartActor, 0, Void >;
															#line 77 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	StartActor(Database const& cx,ApiWorkload* const& self) 
															#line 981 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   StartActorState<StartActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10219404671476595456UL, 16609373904378240000UL);
		ActorExecutionContextHelper __helper(static_cast<StartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 77 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
[[nodiscard]] Future<Void> start( Database const& cx, ApiWorkload* const& self ) {
															#line 77 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	return Future<Void>(new StartActor(cx, self));
															#line 1014 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
}

#line 103 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"

Future<Void> ApiWorkload::start(Database const& cx) {
	if (clientId < maxClients || maxClients < 0)
		return ::start(cx, this);

	return Void();
}

// Convenience function for reporting a test failure to trace log and stdout
void ApiWorkload::testFailure(std::string reason) {
	printf("test failure on client %d: %s\n", clientPrefixInt, reason.c_str());
	TraceEvent(SevError, "TestFailure")
	    .detail("Reason", description() + " " + reason)
	    .detail("Workload", "ApiCorrectness");
	success = false;
}

Future<bool> ApiWorkload::check(Database const& cx) {
	return success;
}

// Verifies that the results of a getRange are the same in the database and in memory
bool ApiWorkload::compareResults(VectorRef<KeyValueRef> dbResults,
                                 VectorRef<KeyValueRef> storeResults,
                                 Version readVersion) {
	if (dbResults.size() != storeResults.size()) {
		printf("%d. Size mismatch: %d - %d\n", clientPrefixInt, dbResults.size(), storeResults.size());
		printf("DB Range:\n");
		for (int j = 0; j < dbResults.size(); j++)
			printf("%d: %s %d\n", j, dbResults[j].key.toString().c_str(), dbResults[j].value.size());

		printf("Memory Range:\n");
		for (int j = 0; j < storeResults.size(); j++)
			printf("%d: %s %d\n", j, storeResults[j].key.toString().c_str(), storeResults[j].value.size());

		fmt::print("Read Version: {}\n", readVersion);

		TraceEvent(SevError, format("%s_CompareSizeMismatch", description().c_str()).c_str())
		    .detail("ReadVer", readVersion)
		    .detail("ResultSize", dbResults.size())
		    .detail("StoreResultSize", storeResults.size());

		return false;
	}

	for (int i = 0; i < dbResults.size(); i++) {
		if (dbResults[i].key != storeResults[i].key || dbResults[i].value != storeResults[i].value) {
			printf("%s mismatch at %d\n", dbResults[i].key != storeResults[i].key ? "Key" : "Value", i);
			printf("DB Range:\n");
			for (int j = 0; j < dbResults.size(); j++)
				printf("%d: %s %d\n", j, dbResults[j].key.toString().c_str(), dbResults[j].value.size());

			printf("Memory Range:\n");
			for (int j = 0; j < storeResults.size(); j++)
				printf("%d: %s %d\n", j, storeResults[j].key.toString().c_str(), storeResults[j].value.size());

			fmt::print("Read Version: {}\n", readVersion);

			TraceEvent(SevError, format("%s_CompareValueMismatch", description().c_str()).c_str())
			    .detail("ReadVer", readVersion)
			    .detail("ResultSize", dbResults.size())
			    .detail("DifferAt", i);

			return false;
		}
	}

	return true;
}

// Compares the contents of this client's key-space in the database with the in-memory key-value store
															#line 1089 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
namespace {
// This generated class is to be used only via compareDatabaseToMemory()
															#line 174 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
template <class CompareDatabaseToMemoryActor>
															#line 174 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
class CompareDatabaseToMemoryActorState {
															#line 1096 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
public:
															#line 174 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	CompareDatabaseToMemoryActorState(ApiWorkload* const& self) 
															#line 174 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
															#line 174 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		 : self(self),
															#line 175 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		   startKey(self->clientPrefix),
															#line 176 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		   endKey(self->clientPrefix + "\xff"),
															#line 177 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		   resultsPerRange(100),
															#line 178 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		   startTime(now())
															#line 1111 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this));

	}
	~CompareDatabaseToMemoryActorState() 
	{
		fdb_probe_actor_destroy("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 180 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			;
															#line 1126 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CompareDatabaseToMemoryActorState();
		static_cast<CompareDatabaseToMemoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 182 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		storeResults = self->store.getRange(KeyRangeRef(startKey, endKey), resultsPerRange, Reverse::False);
															#line 185 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		transaction = self->createTransaction();
															#line 186 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		range = KeyRangeRef(startKey, endKey);
															#line 188 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		;
															#line 1162 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 190 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = transaction->getRange(range, resultsPerRange, Reverse::False);
															#line 190 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			if (static_cast<CompareDatabaseToMemoryActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1187 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CompareDatabaseToMemoryActor*>(this)->actor_wait_state = 1;
															#line 190 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CompareDatabaseToMemoryActor, 0, RangeResult >*>(static_cast<CompareDatabaseToMemoryActor*>(this)));
															#line 1192 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 207 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = transaction->onError(e);
															#line 207 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			if (static_cast<CompareDatabaseToMemoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1229 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CompareDatabaseToMemoryActor*>(this)->actor_wait_state = 3;
															#line 207 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CompareDatabaseToMemoryActor, 2, Void >*>(static_cast<CompareDatabaseToMemoryActor*>(this)));
															#line 1234 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 193 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		StrictFuture<Version> __when_expr_1 = transaction->getReadVersion();
															#line 193 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		if (static_cast<CompareDatabaseToMemoryActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1251 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CompareDatabaseToMemoryActor*>(this)->actor_wait_state = 2;
															#line 193 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CompareDatabaseToMemoryActor, 1, Version >*>(static_cast<CompareDatabaseToMemoryActor*>(this)));
															#line 1256 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult const& __dbResults,int loopDepth) 
	{
															#line 190 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		dbResults = __dbResults;
															#line 1265 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult && __dbResults,int loopDepth) 
	{
		dbResults = std::move(__dbResults);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CompareDatabaseToMemoryActor*>(this)->actor_wait_state > 0) static_cast<CompareDatabaseToMemoryActor*>(this)->actor_wait_state = 0;
		static_cast<CompareDatabaseToMemoryActor*>(this)->ActorCallback< CompareDatabaseToMemoryActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CompareDatabaseToMemoryActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompareDatabaseToMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CompareDatabaseToMemoryActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompareDatabaseToMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CompareDatabaseToMemoryActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CompareDatabaseToMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Version const& v,int loopDepth) 
	{
															#line 194 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		if (!self->compareResults(dbResults, storeResults, v))
															#line 1344 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		{
															#line 195 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			TraceEvent(SevError, "FailedComparisonToMemory").detail("StartTime", startTime);
															#line 196 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			if (!static_cast<CompareDatabaseToMemoryActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CompareDatabaseToMemoryActorState(); static_cast<CompareDatabaseToMemoryActor*>(this)->destroy(); return 0; }
															#line 1350 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			new (&static_cast<CompareDatabaseToMemoryActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CompareDatabaseToMemoryActorState();
			static_cast<CompareDatabaseToMemoryActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 200 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		if (storeResults.size() < resultsPerRange)
															#line 1358 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		{
															#line 201 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			if (!static_cast<CompareDatabaseToMemoryActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CompareDatabaseToMemoryActorState(); static_cast<CompareDatabaseToMemoryActor*>(this)->destroy(); return 0; }
															#line 1362 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			new (&static_cast<CompareDatabaseToMemoryActor*>(this)->SAV< bool >::value()) bool(true);
			this->~CompareDatabaseToMemoryActorState();
			static_cast<CompareDatabaseToMemoryActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 203 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		startKey = dbResults[dbResults.size() - 1].key;
															#line 1370 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Version && v,int loopDepth) 
	{
															#line 194 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		if (!self->compareResults(dbResults, storeResults, v))
															#line 1379 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		{
															#line 195 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			TraceEvent(SevError, "FailedComparisonToMemory").detail("StartTime", startTime);
															#line 196 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			if (!static_cast<CompareDatabaseToMemoryActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CompareDatabaseToMemoryActorState(); static_cast<CompareDatabaseToMemoryActor*>(this)->destroy(); return 0; }
															#line 1385 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			new (&static_cast<CompareDatabaseToMemoryActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CompareDatabaseToMemoryActorState();
			static_cast<CompareDatabaseToMemoryActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 200 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		if (storeResults.size() < resultsPerRange)
															#line 1393 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		{
															#line 201 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			if (!static_cast<CompareDatabaseToMemoryActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CompareDatabaseToMemoryActorState(); static_cast<CompareDatabaseToMemoryActor*>(this)->destroy(); return 0; }
															#line 1397 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			new (&static_cast<CompareDatabaseToMemoryActor*>(this)->SAV< bool >::value()) bool(true);
			this->~CompareDatabaseToMemoryActorState();
			static_cast<CompareDatabaseToMemoryActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 203 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		startKey = dbResults[dbResults.size() - 1].key;
															#line 1405 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CompareDatabaseToMemoryActor*>(this)->actor_wait_state > 0) static_cast<CompareDatabaseToMemoryActor*>(this)->actor_wait_state = 0;
		static_cast<CompareDatabaseToMemoryActor*>(this)->ActorCallback< CompareDatabaseToMemoryActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< CompareDatabaseToMemoryActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompareDatabaseToMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CompareDatabaseToMemoryActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompareDatabaseToMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CompareDatabaseToMemoryActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CompareDatabaseToMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CompareDatabaseToMemoryActor*>(this)->actor_wait_state > 0) static_cast<CompareDatabaseToMemoryActor*>(this)->actor_wait_state = 0;
		static_cast<CompareDatabaseToMemoryActor*>(this)->ActorCallback< CompareDatabaseToMemoryActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CompareDatabaseToMemoryActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompareDatabaseToMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CompareDatabaseToMemoryActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompareDatabaseToMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CompareDatabaseToMemoryActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CompareDatabaseToMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 174 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	ApiWorkload* self;
															#line 175 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	Key startKey;
															#line 176 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	Key endKey;
															#line 177 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	int resultsPerRange;
															#line 178 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	double startTime;
															#line 182 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	RangeResult storeResults;
															#line 185 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	Reference<TransactionWrapper> transaction;
															#line 186 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	KeyRangeRef range;
															#line 190 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	RangeResult dbResults;
															#line 1590 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
};
// This generated class is to be used only via compareDatabaseToMemory()
															#line 174 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
class CompareDatabaseToMemoryActor final : public Actor<bool>, public ActorCallback< CompareDatabaseToMemoryActor, 0, RangeResult >, public ActorCallback< CompareDatabaseToMemoryActor, 1, Version >, public ActorCallback< CompareDatabaseToMemoryActor, 2, Void >, public FastAllocated<CompareDatabaseToMemoryActor>, public CompareDatabaseToMemoryActorState<CompareDatabaseToMemoryActor> {
															#line 1595 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
public:
	using FastAllocated<CompareDatabaseToMemoryActor>::operator new;
	using FastAllocated<CompareDatabaseToMemoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10710325717329852928UL, 9855773311505989632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CompareDatabaseToMemoryActor, 0, RangeResult >;
friend struct ActorCallback< CompareDatabaseToMemoryActor, 1, Version >;
friend struct ActorCallback< CompareDatabaseToMemoryActor, 2, Void >;
															#line 174 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	CompareDatabaseToMemoryActor(ApiWorkload* const& self) 
															#line 1614 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		 : Actor<bool>(),
		   CompareDatabaseToMemoryActorState<CompareDatabaseToMemoryActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8397587126795437056UL, 9938665255874012672UL);
		ActorExecutionContextHelper __helper(static_cast<CompareDatabaseToMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("compareDatabaseToMemory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("compareDatabaseToMemory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CompareDatabaseToMemoryActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CompareDatabaseToMemoryActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CompareDatabaseToMemoryActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 174 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
[[nodiscard]] Future<bool> compareDatabaseToMemory( ApiWorkload* const& self ) {
															#line 174 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	return Future<bool>(new CompareDatabaseToMemoryActor(self));
															#line 1649 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
}

#line 212 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"

Future<bool> ApiWorkload::compareDatabaseToMemory() {
	return ::compareDatabaseToMemory(this);
}

// Generates a set of random key-value pairs with an optional prefix
Standalone<VectorRef<KeyValueRef>> ApiWorkload::generateData(int numKeys,
                                                             int minKeyLength,
                                                             int maxKeyLength,
                                                             int minValueLength,
                                                             int maxValueLength,
                                                             std::string prefix,
                                                             bool allowDuplicates) {
	Standalone<VectorRef<KeyValueRef>> data;
	std::set<KeyRef> keys;

	while (data.size() < numKeys) {
		Key key = generateKey(data, minKeyLength, maxKeyLength, prefix);

		if (!allowDuplicates && !keys.insert(key).second)
			continue;

		ValueRef value(data.arena(), generateValue(minValueLength, maxValueLength + 1));
		data.push_back_deep(data.arena(), KeyValueRef(key, value));
	}

	return data;
}

// Generates a random key
Key ApiWorkload::generateKey(VectorRef<KeyValueRef> const& data,
                             int minKeyLength,
                             int maxKeyLength,
                             std::string prefix) {
	int keyLength = deterministicRandom()->randomInt(minKeyLength, maxKeyLength + 1);
	char* keyBuffer = new char[keyLength + 1];

	if (onlyLowerCase) {
		for (int i = 0; i < keyLength; i++)
			keyBuffer[i] = deterministicRandom()->randomInt('a', 'z' + 1);
	} else {
		for (int i = 0; i < keyLength; i += sizeof(uint32_t)) {
			uint32_t val = deterministicRandom()->randomUInt32();
			memcpy(&keyBuffer[i], &val, std::min(keyLength - i, (int)sizeof(uint32_t)));
		}

		// Don't allow the first character of the key to be 0xff
		if (keyBuffer[0] == '\xff')
			keyBuffer[0] = deterministicRandom()->randomInt(0, 255);
	}

	// If encryption validation is enabled; slip "marker pattern" at random location in generated key
	if (g_network->isSimulated() && g_simulator->dataAtRestPlaintextMarker.present() &&
	    keyLength + 1 > g_simulator->dataAtRestPlaintextMarker.get().size()) {
		int len = keyLength - g_simulator->dataAtRestPlaintextMarker.get().size();
		// Avoid updating the first byte of the key
		int idx = len > 1 ? deterministicRandom()->randomInt(1, len) : 1;
		memcpy(&keyBuffer[idx],
		       g_simulator->dataAtRestPlaintextMarker.get().c_str(),
		       g_simulator->dataAtRestPlaintextMarker.get().size());
		//TraceEvent(SevDebug, "ModifiedKey").suppressFor(5).detail("Key", keyBuffer);
	}

	keyBuffer[keyLength] = '\0';

	Key key(prefix + keyBuffer);
	delete[] keyBuffer;

	return key;
}

// Generates a random key selector with a specified maximum offset
KeySelector ApiWorkload::generateKeySelector(VectorRef<KeyValueRef> const& data, int maxOffset) {
	Key key = selectRandomKey(data, 0.5);
	return KeySelector(KeySelectorRef(
	    key, deterministicRandom()->randomInt(0, 2) == 1, deterministicRandom()->randomInt(-maxOffset, maxOffset + 1)));
}

// Selects a random key.  There is a <probabilityKeyExists> probability that the key will be chosen from the keyset in
// data, otherwise the key will be a randomly generated key
Key ApiWorkload::selectRandomKey(VectorRef<KeyValueRef> const& data, double probabilityKeyExists) {
	if (deterministicRandom()->random01() < probabilityKeyExists)
		return data[deterministicRandom()->randomInt(0, data.size())].key;
	else
		return generateKey(data, minLongKeyLength, maxLongKeyLength, clientPrefix);
}

// Generates a random value
Value ApiWorkload::generateValue(int minValueLength, int maxValueLength) {
	int valueLength = deterministicRandom()->randomInt(minValueLength, maxValueLength + 1);
	std::string ret(std::string(valueLength, 'x'));

	// If encryption validation is enabled; slip "marker pattern" at random location in generated key
	if (g_network->isSimulated() && g_simulator->dataAtRestPlaintextMarker.present() &&
	    valueLength > g_simulator->dataAtRestPlaintextMarker.get().size()) {
		int len = valueLength - g_simulator->dataAtRestPlaintextMarker.get().size();
		int idx = deterministicRandom()->randomInt(0, len);
		memcpy(&ret[idx],
		       g_simulator->dataAtRestPlaintextMarker.get().c_str(),
		       g_simulator->dataAtRestPlaintextMarker.get().size());
		//TraceEvent("ModifiedValue").suppressFor(5).detail("Value", ret);
	}
	return Value(ret);
}

// Generates a random value
Value ApiWorkload::generateValue() {
	return generateValue(minValueLength, maxValueLength);
}

// Creates a random transaction factory to produce transaction of one of the TransactionType choices
															#line 1764 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
namespace {
// This generated class is to be used only via chooseTransactionFactory()
															#line 323 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
template <class ChooseTransactionFactoryActor>
															#line 323 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
class ChooseTransactionFactoryActorState {
															#line 1771 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
public:
															#line 323 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	ChooseTransactionFactoryActorState(Database const& cx,std::vector<TransactionType> const& choices,ApiWorkload* const& self) 
															#line 323 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
															#line 323 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		 : cx(cx),
															#line 323 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		   choices(choices),
															#line 323 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		   self(self)
															#line 1782 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("chooseTransactionFactory", reinterpret_cast<unsigned long>(this));

	}
	~ChooseTransactionFactoryActorState() 
	{
		fdb_probe_actor_destroy("chooseTransactionFactory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 324 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			TransactionType transactionType = deterministicRandom()->randomChoice(choices);
															#line 325 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			self->transactionType = transactionType;
															#line 327 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
			if (transactionType == NATIVE)
															#line 1801 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
			{
															#line 328 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
				printf("client %d: Running NativeAPI Transactions\n", self->clientPrefixInt);
															#line 329 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
				self->transactionFactory = Reference<TransactionFactoryInterface>( new TransactionFactory<FlowTransactionWrapper<Transaction>, const Database>( cx, self->extraDB, self->useExtraDB));
															#line 1807 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
				loopDepth = a_body1cont1(loopDepth);
			}
			else
			{
															#line 332 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
				if (transactionType == READ_YOUR_WRITES)
															#line 1814 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
				{
															#line 333 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
					printf("client %d: Running ReadYourWrites Transactions\n", self->clientPrefixInt);
															#line 334 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
					self->transactionFactory = Reference<TransactionFactoryInterface>( new TransactionFactory<FlowTransactionWrapper<ReadYourWritesTransaction>, const Database>( cx, self->extraDB, self->useExtraDB));
															#line 1820 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
					loopDepth = a_body1cont3(loopDepth);
				}
				else
				{
															#line 337 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
					if (transactionType == THREAD_SAFE)
															#line 1827 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
					{
															#line 338 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
						printf("client %d: Running ThreadSafe Transactions\n", self->clientPrefixInt);
															#line 339 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
						StrictFuture<Reference<IDatabase>> __when_expr_0 = unsafeThreadFutureToFuture(ThreadSafeDatabase::createFromExistingDatabase(cx));
															#line 339 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
						if (static_cast<ChooseTransactionFactoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1835 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
						if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
						static_cast<ChooseTransactionFactoryActor*>(this)->actor_wait_state = 1;
															#line 339 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
						__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChooseTransactionFactoryActor, 0, Reference<IDatabase> >*>(static_cast<ChooseTransactionFactoryActor*>(this)));
															#line 1840 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 343 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
						if (transactionType == MULTI_VERSION)
															#line 1847 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
						{
															#line 344 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
							printf("client %d: Running Multi-Version Transactions\n", self->clientPrefixInt);
															#line 345 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
							MultiVersionApi::api->selectApiVersion(cx->apiVersion.version());
															#line 346 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
							StrictFuture<Reference<IDatabase>> __when_expr_1 = unsafeThreadFutureToFuture(ThreadSafeDatabase::createFromExistingDatabase(cx));
															#line 346 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
							if (static_cast<ChooseTransactionFactoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1857 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
							if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
							static_cast<ChooseTransactionFactoryActor*>(this)->actor_wait_state = 2;
															#line 346 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
							__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChooseTransactionFactoryActor, 1, Reference<IDatabase> >*>(static_cast<ChooseTransactionFactoryActor*>(this)));
															#line 1862 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
							loopDepth = 0;
						}
						else
						{
							loopDepth = a_body1cont8(loopDepth);
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChooseTransactionFactoryActorState();
		static_cast<ChooseTransactionFactoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 353 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		if (!static_cast<ChooseTransactionFactoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChooseTransactionFactoryActorState(); static_cast<ChooseTransactionFactoryActor*>(this)->destroy(); return 0; }
															#line 1893 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		new (&static_cast<ChooseTransactionFactoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChooseTransactionFactoryActorState();
		static_cast<ChooseTransactionFactoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Reference<IDatabase> const& dbHandle,int loopDepth) 
	{
															#line 341 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		self->transactionFactory = Reference<TransactionFactoryInterface>( new TransactionFactory<ThreadTransactionWrapper, Reference<IDatabase>>(dbHandle, dbHandle, false));
															#line 1917 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Reference<IDatabase> && dbHandle,int loopDepth) 
	{
															#line 341 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		self->transactionFactory = Reference<TransactionFactoryInterface>( new TransactionFactory<ThreadTransactionWrapper, Reference<IDatabase>>(dbHandle, dbHandle, false));
															#line 1926 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> const& dbHandle,int loopDepth) 
	{
		loopDepth = a_body1cont6(dbHandle, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> && dbHandle,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(dbHandle), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChooseTransactionFactoryActor*>(this)->actor_wait_state > 0) static_cast<ChooseTransactionFactoryActor*>(this)->actor_wait_state = 0;
		static_cast<ChooseTransactionFactoryActor*>(this)->ActorCallback< ChooseTransactionFactoryActor, 0, Reference<IDatabase> >::remove();

	}
	void a_callback_fire(ActorCallback< ChooseTransactionFactoryActor, 0, Reference<IDatabase> >*,Reference<IDatabase> const& value) 
	{
		fdb_probe_actor_enter("chooseTransactionFactory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTransactionFactoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTransactionFactory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChooseTransactionFactoryActor, 0, Reference<IDatabase> >*,Reference<IDatabase> && value) 
	{
		fdb_probe_actor_enter("chooseTransactionFactory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTransactionFactoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTransactionFactory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChooseTransactionFactoryActor, 0, Reference<IDatabase> >*,Error err) 
	{
		fdb_probe_actor_enter("chooseTransactionFactory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTransactionFactoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTransactionFactory", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Reference<IDatabase> const& threadSafeHandle,int loopDepth) 
	{
															#line 348 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		Reference<IDatabase> dbHandle = MultiVersionDatabase::debugCreateFromExistingDatabase(threadSafeHandle);
															#line 349 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		self->transactionFactory = Reference<TransactionFactoryInterface>( new TransactionFactory<ThreadTransactionWrapper, Reference<IDatabase>>(dbHandle, dbHandle, false));
															#line 2018 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Reference<IDatabase> && threadSafeHandle,int loopDepth) 
	{
															#line 348 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		Reference<IDatabase> dbHandle = MultiVersionDatabase::debugCreateFromExistingDatabase(threadSafeHandle);
															#line 349 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
		self->transactionFactory = Reference<TransactionFactoryInterface>( new TransactionFactory<ThreadTransactionWrapper, Reference<IDatabase>>(dbHandle, dbHandle, false));
															#line 2029 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Reference<IDatabase> const& threadSafeHandle,int loopDepth) 
	{
		loopDepth = a_body1cont9(threadSafeHandle, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Reference<IDatabase> && threadSafeHandle,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(threadSafeHandle), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChooseTransactionFactoryActor*>(this)->actor_wait_state > 0) static_cast<ChooseTransactionFactoryActor*>(this)->actor_wait_state = 0;
		static_cast<ChooseTransactionFactoryActor*>(this)->ActorCallback< ChooseTransactionFactoryActor, 1, Reference<IDatabase> >::remove();

	}
	void a_callback_fire(ActorCallback< ChooseTransactionFactoryActor, 1, Reference<IDatabase> >*,Reference<IDatabase> const& value) 
	{
		fdb_probe_actor_enter("chooseTransactionFactory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTransactionFactoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTransactionFactory", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChooseTransactionFactoryActor, 1, Reference<IDatabase> >*,Reference<IDatabase> && value) 
	{
		fdb_probe_actor_enter("chooseTransactionFactory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTransactionFactoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTransactionFactory", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChooseTransactionFactoryActor, 1, Reference<IDatabase> >*,Error err) 
	{
		fdb_probe_actor_enter("chooseTransactionFactory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTransactionFactoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTransactionFactory", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 323 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	Database cx;
															#line 323 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	std::vector<TransactionType> choices;
															#line 323 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	ApiWorkload* self;
															#line 2115 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
};
// This generated class is to be used only via chooseTransactionFactory()
															#line 323 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
class ChooseTransactionFactoryActor final : public Actor<Void>, public ActorCallback< ChooseTransactionFactoryActor, 0, Reference<IDatabase> >, public ActorCallback< ChooseTransactionFactoryActor, 1, Reference<IDatabase> >, public FastAllocated<ChooseTransactionFactoryActor>, public ChooseTransactionFactoryActorState<ChooseTransactionFactoryActor> {
															#line 2120 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
public:
	using FastAllocated<ChooseTransactionFactoryActor>::operator new;
	using FastAllocated<ChooseTransactionFactoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4959581612000296448UL, 8219544454494187520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChooseTransactionFactoryActor, 0, Reference<IDatabase> >;
friend struct ActorCallback< ChooseTransactionFactoryActor, 1, Reference<IDatabase> >;
															#line 323 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	ChooseTransactionFactoryActor(Database const& cx,std::vector<TransactionType> const& choices,ApiWorkload* const& self) 
															#line 2138 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ChooseTransactionFactoryActorState<ChooseTransactionFactoryActor>(cx, choices, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("chooseTransactionFactory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6135956295344847360UL, 13452651903558145792UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTransactionFactoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("chooseTransactionFactory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("chooseTransactionFactory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChooseTransactionFactoryActor, 0, Reference<IDatabase> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChooseTransactionFactoryActor, 1, Reference<IDatabase> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 323 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
[[nodiscard]] Future<Void> chooseTransactionFactory( Database const& cx, std::vector<TransactionType> const& choices, ApiWorkload* const& self ) {
															#line 323 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"
	return Future<Void>(new ChooseTransactionFactoryActor(cx, choices, self));
															#line 2172 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ApiWorkload.actor.g.cpp"
}

#line 355 "/codebuild/output/src517104744/src/github.com/apple/foundationdb/fdbserver/workloads/ApiWorkload.actor.cpp"

Future<Void> ApiWorkload::chooseTransactionFactory(Database const& cx, std::vector<TransactionType> const& choices) {
	return ::chooseTransactionFactory(cx, choices, this);
}

// Creates a new transaction using the current transaction factory
Reference<TransactionWrapper> ApiWorkload::createTransaction() {
	ASSERT(transactionFactory);
	return transactionFactory->createTransaction();
}

bool ApiWorkload::hasFailed() const {
	return !success;
}
