/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.Versionstamp;
import java.util.concurrent.CompletableFuture;

public class VersionstampSmokeTest {
    public static void main(String[] stringArray) {
        FDB fDB = FDB.selectAPIVersion((int)800);
        try (Database database = fDB.open();){
            database.run(transaction -> {
                transaction.clear(Tuple.from((Object[])new Object[]{"prefix"}).range());
                return null;
            });
            CompletableFuture completableFuture = (CompletableFuture)database.run(transaction -> {
                Tuple tuple = Tuple.from((Object[])new Object[]{"prefix", Versionstamp.incomplete()});
                transaction.mutate(MutationType.SET_VERSIONSTAMPED_KEY, tuple.packWithVersionstamp(), new byte[0]);
                return transaction.getVersionstamp();
            });
            byte[] byArray = (byte[])completableFuture.join();
            Versionstamp versionstamp = (Versionstamp)database.run(transaction -> {
                Subspace subspace = new Subspace(Tuple.from((Object[])new Object[]{"prefix"}));
                byte[] byArray = ((KeyValue)transaction.getRange(subspace.range(), 1).iterator().next()).getKey();
                Tuple tuple = subspace.unpack(byArray);
                return tuple.getVersionstamp(0);
            });
            System.out.println(versionstamp);
            System.out.println(Versionstamp.complete((byte[])byArray));
            assert (versionstamp.equals((Object)Versionstamp.complete((byte[])byArray)));
        }
    }

    private VersionstampSmokeTest() {
    }
}

