#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
/*
 * ThroughputQuota.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/TagThrottle.actor.h"
#include "fdbserver/workloads/workloads.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

// This workload sets the throughput quota of a tag during the setup phase
class ThroughputQuotaWorkload : public TestWorkload {
	TransactionTag transactionTag;
	int64_t reservedQuotaInPages{ 0 };
	int64_t totalQuotaInPages{ 0 };

	int64_t getReservedQuota() const { return reservedQuotaInPages * CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE; }

	int64_t getTotalQuota() const { return totalQuotaInPages * CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE; }

																#line 38 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThroughputQuota.actor.g.cpp"
// This generated class is to be used only via setup()
															#line 36 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
template <class SetupActor>
															#line 36 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
class SetupActorState {
															#line 44 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThroughputQuota.actor.g.cpp"
public:
															#line 36 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
	SetupActorState(ThroughputQuotaWorkload* const& self,Database const& cx) 
															#line 36 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
															#line 36 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
		 : self(self),
															#line 36 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
		   cx(cx),
															#line 37 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(cx))
															#line 55 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThroughputQuota.actor.g.cpp"
	{
		fdb_probe_actor_create("setup", reinterpret_cast<unsigned long>(this));

	}
	~SetupActorState() 
	{
		fdb_probe_actor_destroy("setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 38 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
			;
															#line 70 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThroughputQuota.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetupActorState();
		static_cast<SetupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 40 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 41 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
			TraceEvent("ThroughputQuotaWorkload_SettingTagQuota") .detail("Tag", printable(self->transactionTag)) .detail("ReservedQuota", self->getReservedQuota()) .detail("TotalQuota", self->getTotalQuota());
															#line 45 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
			ThrottleApi::setTagQuota(tr, self->transactionTag, self->getReservedQuota(), self->getTotalQuota());
															#line 46 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 46 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
			if (static_cast<SetupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 109 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThroughputQuota.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetupActor*>(this)->actor_wait_state = 1;
															#line 46 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetupActor, 0, Void >*>(static_cast<SetupActor*>(this)));
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThroughputQuota.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 49 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
			TraceEvent("ThroughputQuotaWorkload_SetupError").error(e);
															#line 50 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 50 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
			if (static_cast<SetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThroughputQuota.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SetupActor*>(this)->actor_wait_state = 2;
															#line 50 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetupActor, 1, Void >*>(static_cast<SetupActor*>(this)));
															#line 145 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThroughputQuota.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
		if (!static_cast<SetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActorState(); static_cast<SetupActor*>(this)->destroy(); return 0; }
															#line 160 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThroughputQuota.actor.g.cpp"
		new (&static_cast<SetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActorState();
		static_cast<SetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
		if (!static_cast<SetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActorState(); static_cast<SetupActor*>(this)->destroy(); return 0; }
															#line 172 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThroughputQuota.actor.g.cpp"
		new (&static_cast<SetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActorState();
		static_cast<SetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetupActor*>(this)->actor_wait_state > 0) static_cast<SetupActor*>(this)->actor_wait_state = 0;
		static_cast<SetupActor*>(this)->ActorCallback< SetupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetupActor*>(this)->actor_wait_state > 0) static_cast<SetupActor*>(this)->actor_wait_state = 0;
		static_cast<SetupActor*>(this)->ActorCallback< SetupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 36 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
	ThroughputQuotaWorkload* self;
															#line 36 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
	Database cx;
															#line 37 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 348 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThroughputQuota.actor.g.cpp"
};
// This generated class is to be used only via setup()
															#line 36 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
class SetupActor final : public Actor<Void>, public ActorCallback< SetupActor, 0, Void >, public ActorCallback< SetupActor, 1, Void >, public FastAllocated<SetupActor>, public SetupActorState<SetupActor> {
															#line 353 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThroughputQuota.actor.g.cpp"
public:
	using FastAllocated<SetupActor>::operator new;
	using FastAllocated<SetupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9303289401146707200UL, 15023737383056237312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetupActor, 0, Void >;
friend struct ActorCallback< SetupActor, 1, Void >;
															#line 36 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
	SetupActor(ThroughputQuotaWorkload* const& self,Database const& cx) 
															#line 371 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThroughputQuota.actor.g.cpp"
		 : Actor<Void>(),
		   SetupActorState<SetupActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13998344965578828288UL, 688267501332814080UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 36 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
[[nodiscard]] static Future<Void> setup( ThroughputQuotaWorkload* const& self, Database const& cx ) {
															#line 36 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"
	return Future<Void>(new SetupActor(self, cx));
															#line 404 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ThroughputQuota.actor.g.cpp"
}

#line 54 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/ThroughputQuota.actor.cpp"

public:
	static constexpr auto NAME = "ThroughputQuota";
	explicit ThroughputQuotaWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		transactionTag = getOption(options, "transactionTag"_sr, "sampleTag"_sr);
		reservedQuotaInPages = getOption(options, "reservedQuotaInPages"_sr, 0);
		totalQuotaInPages = getOption(options, "totalQuotaInPages"_sr, 0);
	}

	Future<Void> setup(Database const& cx) override { return clientId ? Void() : setup(this, cx); }
	Future<Void> start(Database const& cx) override { return Void(); }
	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<ThroughputQuotaWorkload> ThroughputQuotaWorkloadFactory;
