#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
/*
 * LockDatabase.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct LockDatabaseWorkload : TestWorkload {
	static constexpr auto NAME = "LockDatabase";

	double lockAfter, unlockAfter;
	bool ok;
	bool onlyCheckLocked;

	LockDatabaseWorkload(WorkloadContext const& wcx) : TestWorkload(wcx), ok(true) {
		lockAfter = getOption(options, "lockAfter"_sr, 0.0);
		unlockAfter = getOption(options, "unlockAfter"_sr, 10.0);
		onlyCheckLocked = getOption(options, "onlyCheckLocked"_sr, false);
		ASSERT(unlockAfter > lockAfter);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (clientId == 0)
			return onlyCheckLocked ? timeout(checkLocked(cx, this), 60, Void()) : lockWorker(cx, this);
		return Void();
	}

	Future<bool> check(Database const& cx) override { return ok; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 56 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
// This generated class is to be used only via lockAndSave()
															#line 54 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
template <class LockAndSaveActor>
															#line 54 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
class LockAndSaveActorState {
															#line 62 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
public:
															#line 54 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	LockAndSaveActorState(Database const& cx,LockDatabaseWorkload* const& self,UID const& lockID) 
															#line 54 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
															#line 54 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		 : cx(cx),
															#line 54 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		   self(self),
															#line 54 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		   lockID(lockID),
															#line 55 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		   tr(cx)
															#line 75 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("lockAndSave", reinterpret_cast<unsigned long>(this));

	}
	~LockAndSaveActorState() 
	{
		fdb_probe_actor_destroy("lockAndSave", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 56 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			;
															#line 90 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LockAndSaveActorState();
		static_cast<LockAndSaveActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 58 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 59 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_0 = lockDatabase(&tr, lockID);
															#line 59 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			if (static_cast<LockAndSaveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 125 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LockAndSaveActor*>(this)->actor_wait_state = 1;
															#line 59 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LockAndSaveActor, 0, Void >*>(static_cast<LockAndSaveActor*>(this)));
															#line 130 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 65 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 65 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			if (static_cast<LockAndSaveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 154 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<LockAndSaveActor*>(this)->actor_wait_state = 4;
															#line 65 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LockAndSaveActor, 3, Void >*>(static_cast<LockAndSaveActor*>(this)));
															#line 159 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 60 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(normalKeys, 50000);
															#line 60 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (static_cast<LockAndSaveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 176 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<LockAndSaveActor*>(this)->actor_wait_state = 2;
															#line 60 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LockAndSaveActor, 1, RangeResult >*>(static_cast<LockAndSaveActor*>(this)));
															#line 181 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 60 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(normalKeys, 50000);
															#line 60 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (static_cast<LockAndSaveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 192 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<LockAndSaveActor*>(this)->actor_wait_state = 2;
															#line 60 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LockAndSaveActor, 1, RangeResult >*>(static_cast<LockAndSaveActor*>(this)));
															#line 197 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LockAndSaveActor*>(this)->actor_wait_state > 0) static_cast<LockAndSaveActor*>(this)->actor_wait_state = 0;
		static_cast<LockAndSaveActor*>(this)->ActorCallback< LockAndSaveActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockAndSaveActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockAndSave", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndSaveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockAndSave", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LockAndSaveActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockAndSave", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndSaveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockAndSave", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LockAndSaveActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockAndSave", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndSaveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockAndSave", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 61 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		ASSERT(!data.more);
															#line 62 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 62 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (static_cast<LockAndSaveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 285 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<LockAndSaveActor*>(this)->actor_wait_state = 3;
															#line 62 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LockAndSaveActor, 2, Void >*>(static_cast<LockAndSaveActor*>(this)));
															#line 290 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& __data,int loopDepth) 
	{
															#line 60 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		data = __data;
															#line 299 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && __data,int loopDepth) 
	{
		data = std::move(__data);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LockAndSaveActor*>(this)->actor_wait_state > 0) static_cast<LockAndSaveActor*>(this)->actor_wait_state = 0;
		static_cast<LockAndSaveActor*>(this)->ActorCallback< LockAndSaveActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< LockAndSaveActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("lockAndSave", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndSaveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockAndSave", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LockAndSaveActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("lockAndSave", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndSaveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockAndSave", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LockAndSaveActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("lockAndSave", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndSaveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockAndSave", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 63 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (!static_cast<LockAndSaveActor*>(this)->SAV<RangeResult>::futures) { (void)(data); this->~LockAndSaveActorState(); static_cast<LockAndSaveActor*>(this)->destroy(); return 0; }
															#line 378 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		new (&static_cast<LockAndSaveActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(data)); // state_var_RVO
		this->~LockAndSaveActorState();
		static_cast<LockAndSaveActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 63 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (!static_cast<LockAndSaveActor*>(this)->SAV<RangeResult>::futures) { (void)(data); this->~LockAndSaveActorState(); static_cast<LockAndSaveActor*>(this)->destroy(); return 0; }
															#line 390 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		new (&static_cast<LockAndSaveActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(data)); // state_var_RVO
		this->~LockAndSaveActorState();
		static_cast<LockAndSaveActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LockAndSaveActor*>(this)->actor_wait_state > 0) static_cast<LockAndSaveActor*>(this)->actor_wait_state = 0;
		static_cast<LockAndSaveActor*>(this)->ActorCallback< LockAndSaveActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockAndSaveActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockAndSave", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndSaveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockAndSave", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LockAndSaveActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockAndSave", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndSaveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockAndSave", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LockAndSaveActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockAndSave", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndSaveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockAndSave", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<LockAndSaveActor*>(this)->actor_wait_state > 0) static_cast<LockAndSaveActor*>(this)->actor_wait_state = 0;
		static_cast<LockAndSaveActor*>(this)->ActorCallback< LockAndSaveActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockAndSaveActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockAndSave", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndSaveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockAndSave", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LockAndSaveActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockAndSave", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndSaveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockAndSave", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LockAndSaveActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockAndSave", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndSaveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockAndSave", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 54 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	Database cx;
															#line 54 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	LockDatabaseWorkload* self;
															#line 54 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	UID lockID;
															#line 55 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	Transaction tr;
															#line 60 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	RangeResult data;
															#line 570 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
};
// This generated class is to be used only via lockAndSave()
															#line 54 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
class LockAndSaveActor final : public Actor<RangeResult>, public ActorCallback< LockAndSaveActor, 0, Void >, public ActorCallback< LockAndSaveActor, 1, RangeResult >, public ActorCallback< LockAndSaveActor, 2, Void >, public ActorCallback< LockAndSaveActor, 3, Void >, public FastAllocated<LockAndSaveActor>, public LockAndSaveActorState<LockAndSaveActor> {
															#line 575 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
public:
	using FastAllocated<LockAndSaveActor>::operator new;
	using FastAllocated<LockAndSaveActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12981708824049970176UL, 15618796575644704512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LockAndSaveActor, 0, Void >;
friend struct ActorCallback< LockAndSaveActor, 1, RangeResult >;
friend struct ActorCallback< LockAndSaveActor, 2, Void >;
friend struct ActorCallback< LockAndSaveActor, 3, Void >;
															#line 54 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	LockAndSaveActor(Database const& cx,LockDatabaseWorkload* const& self,UID const& lockID) 
															#line 595 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		 : Actor<RangeResult>(),
		   LockAndSaveActorState<LockAndSaveActor>(cx, self, lockID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lockAndSave", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11501313245597760256UL, 6326063236099149568UL);
		ActorExecutionContextHelper __helper(static_cast<LockAndSaveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lockAndSave");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lockAndSave", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LockAndSaveActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LockAndSaveActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LockAndSaveActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< LockAndSaveActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 54 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
[[nodiscard]] static Future<RangeResult> lockAndSave( Database const& cx, LockDatabaseWorkload* const& self, UID const& lockID ) {
															#line 54 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	return Future<RangeResult>(new LockAndSaveActor(cx, self, lockID));
															#line 630 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
}

#line 69 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"

																#line 635 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
// This generated class is to be used only via unlockAndCheck()
															#line 70 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
template <class UnlockAndCheckActor>
															#line 70 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
class UnlockAndCheckActorState {
															#line 641 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
public:
															#line 70 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	UnlockAndCheckActorState(Database const& cx,LockDatabaseWorkload* const& self,UID const& lockID,RangeResult const& data) 
															#line 70 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
															#line 70 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		 : cx(cx),
															#line 70 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		   self(self),
															#line 70 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		   lockID(lockID),
															#line 70 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		   data(data),
															#line 71 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		   tr(cx)
															#line 656 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("unlockAndCheck", reinterpret_cast<unsigned long>(this));

	}
	~UnlockAndCheckActorState() 
	{
		fdb_probe_actor_destroy("unlockAndCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 72 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			;
															#line 671 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UnlockAndCheckActorState();
		static_cast<UnlockAndCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 74 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 75 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 76 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(databaseLockedKey);
															#line 76 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			if (static_cast<UnlockAndCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 708 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UnlockAndCheckActor*>(this)->actor_wait_state = 1;
															#line 76 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UnlockAndCheckActor, 0, Optional<Value> >*>(static_cast<UnlockAndCheckActor*>(this)));
															#line 713 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 102 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 102 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			if (static_cast<UnlockAndCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 737 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<UnlockAndCheckActor*>(this)->actor_wait_state = 5;
															#line 102 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< UnlockAndCheckActor, 4, Void >*>(static_cast<UnlockAndCheckActor*>(this)));
															#line 742 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 77 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (!val.present())
															#line 757 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		{
															#line 78 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			if (!static_cast<UnlockAndCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnlockAndCheckActorState(); static_cast<UnlockAndCheckActor*>(this)->destroy(); return 0; }
															#line 761 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			new (&static_cast<UnlockAndCheckActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~UnlockAndCheckActorState();
			static_cast<UnlockAndCheckActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 80 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = unlockDatabase(&tr, lockID);
															#line 80 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (static_cast<UnlockAndCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 771 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UnlockAndCheckActor*>(this)->actor_wait_state = 2;
															#line 80 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UnlockAndCheckActor, 1, Void >*>(static_cast<UnlockAndCheckActor*>(this)));
															#line 776 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 77 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (!val.present())
															#line 785 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		{
															#line 78 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			if (!static_cast<UnlockAndCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnlockAndCheckActorState(); static_cast<UnlockAndCheckActor*>(this)->destroy(); return 0; }
															#line 789 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			new (&static_cast<UnlockAndCheckActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~UnlockAndCheckActorState();
			static_cast<UnlockAndCheckActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 80 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = unlockDatabase(&tr, lockID);
															#line 80 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (static_cast<UnlockAndCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 799 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UnlockAndCheckActor*>(this)->actor_wait_state = 2;
															#line 80 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UnlockAndCheckActor, 1, Void >*>(static_cast<UnlockAndCheckActor*>(this)));
															#line 804 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UnlockAndCheckActor*>(this)->actor_wait_state > 0) static_cast<UnlockAndCheckActor*>(this)->actor_wait_state = 0;
		static_cast<UnlockAndCheckActor*>(this)->ActorCallback< UnlockAndCheckActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< UnlockAndCheckActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("unlockAndCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockAndCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UnlockAndCheckActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("unlockAndCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockAndCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UnlockAndCheckActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("unlockAndCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockAndCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 81 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		StrictFuture<RangeResult> __when_expr_2 = tr.getRange(normalKeys, 50000);
															#line 81 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (static_cast<UnlockAndCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 890 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<UnlockAndCheckActor*>(this)->actor_wait_state = 3;
															#line 81 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UnlockAndCheckActor, 2, RangeResult >*>(static_cast<UnlockAndCheckActor*>(this)));
															#line 895 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 81 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		StrictFuture<RangeResult> __when_expr_2 = tr.getRange(normalKeys, 50000);
															#line 81 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (static_cast<UnlockAndCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 906 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<UnlockAndCheckActor*>(this)->actor_wait_state = 3;
															#line 81 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UnlockAndCheckActor, 2, RangeResult >*>(static_cast<UnlockAndCheckActor*>(this)));
															#line 911 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UnlockAndCheckActor*>(this)->actor_wait_state > 0) static_cast<UnlockAndCheckActor*>(this)->actor_wait_state = 0;
		static_cast<UnlockAndCheckActor*>(this)->ActorCallback< UnlockAndCheckActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UnlockAndCheckActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("unlockAndCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockAndCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UnlockAndCheckActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("unlockAndCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockAndCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UnlockAndCheckActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("unlockAndCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockAndCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 82 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (data.size() != data2.size())
															#line 995 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		{
															#line 83 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			TraceEvent(SevError, "DataChangedWhileLocked") .detail("BeforeSize", data.size()) .detail("AfterSize", data2.size());
															#line 86 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			self->ok = false;
															#line 1001 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		}
		else
		{
															#line 87 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			if (data != data2)
															#line 1007 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			{
															#line 88 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
				TraceEvent(SevError, "DataChangedWhileLocked").detail("Size", data.size());
															#line 89 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
				for(int i = 0;i < data.size();i++) {
															#line 90 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
					if (data[i] != data2[i])
															#line 1015 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
					{
															#line 91 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
						TraceEvent(SevError, "DataChangedWhileLocked") .detail("I", i) .detail("Before", printable(data[i])) .detail("After", printable(data2[i]));
															#line 1019 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
					}
				}
															#line 97 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
				self->ok = false;
															#line 1024 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			}
		}
															#line 99 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr.commit();
															#line 99 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (static_cast<UnlockAndCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1031 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<UnlockAndCheckActor*>(this)->actor_wait_state = 4;
															#line 99 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UnlockAndCheckActor, 3, Void >*>(static_cast<UnlockAndCheckActor*>(this)));
															#line 1036 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(RangeResult const& __data2,int loopDepth) 
	{
															#line 81 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		data2 = __data2;
															#line 1045 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(RangeResult && __data2,int loopDepth) 
	{
		data2 = std::move(__data2);
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UnlockAndCheckActor*>(this)->actor_wait_state > 0) static_cast<UnlockAndCheckActor*>(this)->actor_wait_state = 0;
		static_cast<UnlockAndCheckActor*>(this)->ActorCallback< UnlockAndCheckActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< UnlockAndCheckActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("unlockAndCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockAndCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UnlockAndCheckActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("unlockAndCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockAndCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UnlockAndCheckActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("unlockAndCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockAndCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 100 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (!static_cast<UnlockAndCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnlockAndCheckActorState(); static_cast<UnlockAndCheckActor*>(this)->destroy(); return 0; }
															#line 1124 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		new (&static_cast<UnlockAndCheckActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnlockAndCheckActorState();
		static_cast<UnlockAndCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 100 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (!static_cast<UnlockAndCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UnlockAndCheckActorState(); static_cast<UnlockAndCheckActor*>(this)->destroy(); return 0; }
															#line 1136 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		new (&static_cast<UnlockAndCheckActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UnlockAndCheckActorState();
		static_cast<UnlockAndCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<UnlockAndCheckActor*>(this)->actor_wait_state > 0) static_cast<UnlockAndCheckActor*>(this)->actor_wait_state = 0;
		static_cast<UnlockAndCheckActor*>(this)->ActorCallback< UnlockAndCheckActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UnlockAndCheckActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("unlockAndCheck", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockAndCheck", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< UnlockAndCheckActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("unlockAndCheck", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockAndCheck", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< UnlockAndCheckActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("unlockAndCheck", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockAndCheck", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<UnlockAndCheckActor*>(this)->actor_wait_state > 0) static_cast<UnlockAndCheckActor*>(this)->actor_wait_state = 0;
		static_cast<UnlockAndCheckActor*>(this)->ActorCallback< UnlockAndCheckActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UnlockAndCheckActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("unlockAndCheck", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockAndCheck", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< UnlockAndCheckActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("unlockAndCheck", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockAndCheck", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< UnlockAndCheckActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("unlockAndCheck", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockAndCheck", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 70 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	Database cx;
															#line 70 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	LockDatabaseWorkload* self;
															#line 70 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	UID lockID;
															#line 70 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	RangeResult data;
															#line 71 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	Transaction tr;
															#line 81 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	RangeResult data2;
															#line 1318 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
};
// This generated class is to be used only via unlockAndCheck()
															#line 70 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
class UnlockAndCheckActor final : public Actor<Void>, public ActorCallback< UnlockAndCheckActor, 0, Optional<Value> >, public ActorCallback< UnlockAndCheckActor, 1, Void >, public ActorCallback< UnlockAndCheckActor, 2, RangeResult >, public ActorCallback< UnlockAndCheckActor, 3, Void >, public ActorCallback< UnlockAndCheckActor, 4, Void >, public FastAllocated<UnlockAndCheckActor>, public UnlockAndCheckActorState<UnlockAndCheckActor> {
															#line 1323 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
public:
	using FastAllocated<UnlockAndCheckActor>::operator new;
	using FastAllocated<UnlockAndCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2060034205686321664UL, 17164364916037096704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UnlockAndCheckActor, 0, Optional<Value> >;
friend struct ActorCallback< UnlockAndCheckActor, 1, Void >;
friend struct ActorCallback< UnlockAndCheckActor, 2, RangeResult >;
friend struct ActorCallback< UnlockAndCheckActor, 3, Void >;
friend struct ActorCallback< UnlockAndCheckActor, 4, Void >;
															#line 70 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	UnlockAndCheckActor(Database const& cx,LockDatabaseWorkload* const& self,UID const& lockID,RangeResult const& data) 
															#line 1344 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		 : Actor<Void>(),
		   UnlockAndCheckActorState<UnlockAndCheckActor>(cx, self, lockID, data),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("unlockAndCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12065802889011339264UL, 14362986962099267328UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("unlockAndCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("unlockAndCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UnlockAndCheckActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UnlockAndCheckActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UnlockAndCheckActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< UnlockAndCheckActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< UnlockAndCheckActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 70 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
[[nodiscard]] static Future<Void> unlockAndCheck( Database const& cx, LockDatabaseWorkload* const& self, UID const& lockID, RangeResult const& data ) {
															#line 70 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	return Future<Void>(new UnlockAndCheckActor(cx, self, lockID, data));
															#line 1380 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
}

#line 106 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"

																#line 1385 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
// This generated class is to be used only via checkLocked()
															#line 107 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
template <class CheckLockedActor>
															#line 107 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
class CheckLockedActorState {
															#line 1391 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
public:
															#line 107 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	CheckLockedActorState(Database const& cx,LockDatabaseWorkload* const& self) 
															#line 107 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
															#line 107 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		 : cx(cx),
															#line 107 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		   self(self),
															#line 108 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		   tr(cx)
															#line 1402 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("checkLocked", reinterpret_cast<unsigned long>(this));

	}
	~CheckLockedActorState() 
	{
		fdb_probe_actor_destroy("checkLocked", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 109 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			;
															#line 1417 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckLockedActorState();
		static_cast<CheckLockedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 111 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 111 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			if (static_cast<CheckLockedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1450 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckLockedActor*>(this)->actor_wait_state = 1;
															#line 111 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckLockedActor, 0, Version >*>(static_cast<CheckLockedActor*>(this)));
															#line 1455 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 116 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			CODE_PROBE(e.code() == error_code_database_locked, "Database confirmed locked");
															#line 117 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 117 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			if (static_cast<CheckLockedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1481 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckLockedActor*>(this)->actor_wait_state = 2;
															#line 117 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckLockedActor, 1, Void >*>(static_cast<CheckLockedActor*>(this)));
															#line 1486 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& v,int loopDepth) 
	{
															#line 112 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		TraceEvent(SevError, "GotVersionWhileLocked").detail("Version", v);
															#line 113 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		self->ok = false;
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (!static_cast<CheckLockedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckLockedActorState(); static_cast<CheckLockedActor*>(this)->destroy(); return 0; }
															#line 1505 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		new (&static_cast<CheckLockedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckLockedActorState();
		static_cast<CheckLockedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && v,int loopDepth) 
	{
															#line 112 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		TraceEvent(SevError, "GotVersionWhileLocked").detail("Version", v);
															#line 113 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		self->ok = false;
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (!static_cast<CheckLockedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckLockedActorState(); static_cast<CheckLockedActor*>(this)->destroy(); return 0; }
															#line 1521 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		new (&static_cast<CheckLockedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckLockedActorState();
		static_cast<CheckLockedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckLockedActor*>(this)->actor_wait_state > 0) static_cast<CheckLockedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckLockedActor*>(this)->ActorCallback< CheckLockedActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< CheckLockedActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("checkLocked", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkLocked", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckLockedActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("checkLocked", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkLocked", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckLockedActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("checkLocked", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkLocked", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckLockedActor*>(this)->actor_wait_state > 0) static_cast<CheckLockedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckLockedActor*>(this)->ActorCallback< CheckLockedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckLockedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkLocked", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkLocked", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckLockedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkLocked", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkLocked", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckLockedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkLocked", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkLocked", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 107 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	Database cx;
															#line 107 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	LockDatabaseWorkload* self;
															#line 108 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	Transaction tr;
															#line 1697 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
};
// This generated class is to be used only via checkLocked()
															#line 107 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
class CheckLockedActor final : public Actor<Void>, public ActorCallback< CheckLockedActor, 0, Version >, public ActorCallback< CheckLockedActor, 1, Void >, public FastAllocated<CheckLockedActor>, public CheckLockedActorState<CheckLockedActor> {
															#line 1702 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
public:
	using FastAllocated<CheckLockedActor>::operator new;
	using FastAllocated<CheckLockedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17293038752361047808UL, 3758566163422006016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckLockedActor, 0, Version >;
friend struct ActorCallback< CheckLockedActor, 1, Void >;
															#line 107 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	CheckLockedActor(Database const& cx,LockDatabaseWorkload* const& self) 
															#line 1720 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		 : Actor<Void>(),
		   CheckLockedActorState<CheckLockedActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkLocked", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8542154528362267904UL, 10617384298949945856UL);
		ActorExecutionContextHelper __helper(static_cast<CheckLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkLocked");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkLocked", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckLockedActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckLockedActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 107 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
[[nodiscard]] static Future<Void> checkLocked( Database const& cx, LockDatabaseWorkload* const& self ) {
															#line 107 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	return Future<Void>(new CheckLockedActor(cx, self));
															#line 1753 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
}

#line 121 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"

																#line 1758 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
// This generated class is to be used only via lockWorker()
															#line 122 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
template <class LockWorkerActor>
															#line 122 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
class LockWorkerActorState {
															#line 1764 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
public:
															#line 122 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	LockWorkerActorState(Database const& cx,LockDatabaseWorkload* const& self) 
															#line 122 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
															#line 122 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		 : cx(cx),
															#line 122 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		   self(self),
															#line 123 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		   lockID(deterministicRandom()->randomUniqueID())
															#line 1775 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("lockWorker", reinterpret_cast<unsigned long>(this));

	}
	~LockWorkerActorState() 
	{
		fdb_probe_actor_destroy("lockWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 124 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->lockAfter);
															#line 124 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			if (static_cast<LockWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1792 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LockWorkerActor*>(this)->actor_wait_state = 1;
															#line 124 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LockWorkerActor, 0, Void >*>(static_cast<LockWorkerActor*>(this)));
															#line 1797 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LockWorkerActorState();
		static_cast<LockWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 125 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = lockAndSave(cx, self, lockID);
															#line 125 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (static_cast<LockWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1822 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LockWorkerActor*>(this)->actor_wait_state = 2;
															#line 125 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LockWorkerActor, 1, RangeResult >*>(static_cast<LockWorkerActor*>(this)));
															#line 1827 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 125 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = lockAndSave(cx, self, lockID);
															#line 125 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (static_cast<LockWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1838 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LockWorkerActor*>(this)->actor_wait_state = 2;
															#line 125 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LockWorkerActor, 1, RangeResult >*>(static_cast<LockWorkerActor*>(this)));
															#line 1843 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LockWorkerActor*>(this)->actor_wait_state > 0) static_cast<LockWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<LockWorkerActor*>(this)->ActorCallback< LockWorkerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockWorkerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LockWorkerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LockWorkerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 126 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		checker = checkLocked(cx, self);
															#line 127 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(self->unlockAfter - self->lockAfter);
															#line 127 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (static_cast<LockWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1931 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<LockWorkerActor*>(this)->actor_wait_state = 3;
															#line 127 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LockWorkerActor, 2, Void >*>(static_cast<LockWorkerActor*>(this)));
															#line 1936 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult const& __data,int loopDepth) 
	{
															#line 125 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		data = __data;
															#line 1945 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult && __data,int loopDepth) 
	{
		data = std::move(__data);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LockWorkerActor*>(this)->actor_wait_state > 0) static_cast<LockWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<LockWorkerActor*>(this)->ActorCallback< LockWorkerActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< LockWorkerActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("lockWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LockWorkerActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("lockWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LockWorkerActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("lockWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		checker.cancel();
															#line 129 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_3 = unlockAndCheck(cx, self, lockID, data);
															#line 129 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (static_cast<LockWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2028 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<LockWorkerActor*>(this)->actor_wait_state = 4;
															#line 129 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LockWorkerActor, 3, Void >*>(static_cast<LockWorkerActor*>(this)));
															#line 2033 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		checker.cancel();
															#line 129 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_3 = unlockAndCheck(cx, self, lockID, data);
															#line 129 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (static_cast<LockWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2046 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<LockWorkerActor*>(this)->actor_wait_state = 4;
															#line 129 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LockWorkerActor, 3, Void >*>(static_cast<LockWorkerActor*>(this)));
															#line 2051 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LockWorkerActor*>(this)->actor_wait_state > 0) static_cast<LockWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<LockWorkerActor*>(this)->ActorCallback< LockWorkerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockWorkerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LockWorkerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LockWorkerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (!static_cast<LockWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LockWorkerActorState(); static_cast<LockWorkerActor*>(this)->destroy(); return 0; }
															#line 2135 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		new (&static_cast<LockWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LockWorkerActorState();
		static_cast<LockWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
		if (!static_cast<LockWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LockWorkerActorState(); static_cast<LockWorkerActor*>(this)->destroy(); return 0; }
															#line 2147 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		new (&static_cast<LockWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LockWorkerActorState();
		static_cast<LockWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<LockWorkerActor*>(this)->actor_wait_state > 0) static_cast<LockWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<LockWorkerActor*>(this)->ActorCallback< LockWorkerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockWorkerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LockWorkerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LockWorkerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockWorker", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 122 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	Database cx;
															#line 122 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	LockDatabaseWorkload* self;
															#line 123 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	UID lockID;
															#line 125 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	RangeResult data;
															#line 126 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	Future<Void> checker;
															#line 2240 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
};
// This generated class is to be used only via lockWorker()
															#line 122 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
class LockWorkerActor final : public Actor<Void>, public ActorCallback< LockWorkerActor, 0, Void >, public ActorCallback< LockWorkerActor, 1, RangeResult >, public ActorCallback< LockWorkerActor, 2, Void >, public ActorCallback< LockWorkerActor, 3, Void >, public FastAllocated<LockWorkerActor>, public LockWorkerActorState<LockWorkerActor> {
															#line 2245 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
public:
	using FastAllocated<LockWorkerActor>::operator new;
	using FastAllocated<LockWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1555919514084897024UL, 10358228928199555328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LockWorkerActor, 0, Void >;
friend struct ActorCallback< LockWorkerActor, 1, RangeResult >;
friend struct ActorCallback< LockWorkerActor, 2, Void >;
friend struct ActorCallback< LockWorkerActor, 3, Void >;
															#line 122 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	LockWorkerActor(Database const& cx,LockDatabaseWorkload* const& self) 
															#line 2265 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
		 : Actor<Void>(),
		   LockWorkerActorState<LockWorkerActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lockWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3073422133780123136UL, 17461286137793259008UL);
		ActorExecutionContextHelper __helper(static_cast<LockWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lockWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lockWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LockWorkerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LockWorkerActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LockWorkerActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< LockWorkerActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 122 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
[[nodiscard]] static Future<Void> lockWorker( Database const& cx, LockDatabaseWorkload* const& self ) {
															#line 122 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
	return Future<Void>(new LockWorkerActor(cx, self));
															#line 2300 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LockDatabase.actor.g.cpp"
}

#line 133 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/LockDatabase.actor.cpp"
};

WorkloadFactory<LockDatabaseWorkload> LockDatabaseWorkloadFactory;
