#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
/*
 * DataLossRecovery.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cstdint>
#include <limits>
#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbserver/MoveKeys.actor.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbserver/Knobs.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/flow.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace {
std::string printValue(const ErrorOr<Optional<Value>>& value) {
	if (value.isError()) {
		return value.getError().name();
	}
	return value.get().present() ? value.get().get().toString() : "Value Not Found.";
}
} // namespace

struct DataLossRecoveryWorkload : TestWorkload {
	static constexpr auto NAME = "DataLossRecovery";
	FlowLock startMoveKeysParallelismLock;
	FlowLock finishMoveKeysParallelismLock;
	const bool enabled;
	bool pass;
	NetworkAddress addr;

	DataLossRecoveryWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), startMoveKeysParallelismLock(5), finishMoveKeysParallelismLock(5), enabled(!clientId),
	    pass(true) {}

	void validationFailed(ErrorOr<Optional<Value>> expectedValue, ErrorOr<Optional<Value>> actualValue) {
		TraceEvent(SevError, "TestFailed")
		    .detail("ExpectedValue", printValue(expectedValue))
		    .detail("ActualValue", printValue(actualValue));
		pass = false;
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert({ "RandomMoveKeys", "Attrition" });
	}

	Future<Void> start(Database const& cx) override {
		if (!enabled) {
			return Void();
		}
		return _start(this, cx);
	}

																#line 80 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 78 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
template <class _startActor>
															#line 78 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
class _startActorState {
															#line 86 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
public:
															#line 78 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	_startActorState(DataLossRecoveryWorkload* const& self,Database const& cx) 
															#line 78 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
															#line 78 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		 : self(self),
															#line 78 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		   cx(cx),
															#line 79 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		   key("TestKey"_sr),
															#line 80 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		   endKey("TestKey0"_sr),
															#line 81 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		   oldValue("TestValue"_sr),
															#line 82 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		   newValue("TestNewValue"_sr)
															#line 103 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 84 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			TraceEvent("DataLossRecovery").detail("Phase", "Starting");
															#line 85 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->writeAndVerify(self, cx, key, oldValue);
															#line 85 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 122 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 85 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 127 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 87 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("DataLossRecovery").detail("Phase", "InitialWrites");
															#line 89 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<NetworkAddress> __when_expr_1 = self->disableDDAndMoveShard(self, cx, KeyRangeRef(key, endKey));
															#line 89 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 154 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 89 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, NetworkAddress >*>(static_cast<_startActor*>(this)));
															#line 159 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 87 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("DataLossRecovery").detail("Phase", "InitialWrites");
															#line 89 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<NetworkAddress> __when_expr_1 = self->disableDDAndMoveShard(self, cx, KeyRangeRef(key, endKey));
															#line 89 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 172 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 89 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, NetworkAddress >*>(static_cast<_startActor*>(this)));
															#line 177 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 90 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("DataLossRecovery").detail("Phase", "Moved");
															#line 91 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->readAndVerify(self, cx, key, oldValue);
															#line 91 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 265 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 91 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 270 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(NetworkAddress const& __address,int loopDepth) 
	{
															#line 89 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		address = __address;
															#line 279 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(NetworkAddress && __address,int loopDepth) 
	{
		address = std::move(__address);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, NetworkAddress >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, NetworkAddress >*,NetworkAddress const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, NetworkAddress >*,NetworkAddress && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, NetworkAddress >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 92 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("DataLossRecovery").detail("Phase", "ReadAfterMove");
															#line 95 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		self->killProcess(self, address);
															#line 96 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("DataLossRecovery").detail("Phase", "KilledProcess");
															#line 97 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->readAndVerify(self, cx, key, timed_out());
															#line 97 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 366 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 97 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 371 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 92 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("DataLossRecovery").detail("Phase", "ReadAfterMove");
															#line 95 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		self->killProcess(self, address);
															#line 96 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("DataLossRecovery").detail("Phase", "KilledProcess");
															#line 97 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->readAndVerify(self, cx, key, timed_out());
															#line 97 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 388 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 97 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 393 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 98 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("DataLossRecovery").detail("Phase", "VerifiedReadTimeout");
															#line 102 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_4 = success(setDDMode(cx, 1));
															#line 102 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 481 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 102 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 486 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 98 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("DataLossRecovery").detail("Phase", "VerifiedReadTimeout");
															#line 102 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_4 = success(setDDMode(cx, 1));
															#line 102 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 499 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 102 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 504 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 103 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->exclude(cx, address);
															#line 103 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 590 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 103 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 595 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 103 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->exclude(cx, address);
															#line 103 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 606 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 103 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 611 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("DataLossRecovery").detail("Phase", "Excluded");
															#line 105 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->readAndVerify(self, cx, key, Optional<Value>());
															#line 105 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 699 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 105 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 704 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("DataLossRecovery").detail("Phase", "Excluded");
															#line 105 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->readAndVerify(self, cx, key, Optional<Value>());
															#line 105 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 717 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 105 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 722 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 106 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("DataLossRecovery").detail("Phase", "VerifiedDataDropped");
															#line 109 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_7 = self->writeAndVerify(self, cx, key, newValue);
															#line 109 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 810 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 109 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 815 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 106 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("DataLossRecovery").detail("Phase", "VerifiedDataDropped");
															#line 109 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_7 = self->writeAndVerify(self, cx, key, newValue);
															#line 109 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 828 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 109 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 833 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 111 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 917 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 111 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 929 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 78 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	DataLossRecoveryWorkload* self;
															#line 78 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	Database cx;
															#line 79 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	Key key;
															#line 80 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	Key endKey;
															#line 81 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	Value oldValue;
															#line 82 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	Value newValue;
															#line 89 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	NetworkAddress address;
															#line 1026 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 78 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, NetworkAddress >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public ActorCallback< _startActor, 7, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1031 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(526702975102793216UL, 6388392729349826816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, NetworkAddress >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
friend struct ActorCallback< _startActor, 7, Void >;
															#line 78 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	_startActor(DataLossRecoveryWorkload* const& self,Database const& cx) 
															#line 1055 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, NetworkAddress >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 78 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
[[nodiscard]] Future<Void> _start( DataLossRecoveryWorkload* const& self, Database const& cx ) {
															#line 78 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 1094 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
}

#line 113 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"

																#line 1099 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
// This generated class is to be used only via readAndVerify()
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
template <class ReadAndVerifyActor>
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
class ReadAndVerifyActorState {
															#line 1105 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
public:
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	ReadAndVerifyActorState(DataLossRecoveryWorkload* const& self,Database const& cx,Key const& key,ErrorOr<Optional<Value>> const& expectedValue) 
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		 : self(self),
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		   cx(cx),
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		   key(key),
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		   expectedValue(expectedValue),
															#line 118 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		   tr(cx)
															#line 1120 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("readAndVerify", reinterpret_cast<unsigned long>(this));

	}
	~ReadAndVerifyActorState() 
	{
		fdb_probe_actor_destroy("readAndVerify", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 120 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			;
															#line 1135 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadAndVerifyActorState();
		static_cast<ReadAndVerifyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 137 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (!static_cast<ReadAndVerifyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadAndVerifyActorState(); static_cast<ReadAndVerifyActor*>(this)->destroy(); return 0; }
															#line 1158 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		new (&static_cast<ReadAndVerifyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadAndVerifyActorState();
		static_cast<ReadAndVerifyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 123 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = timeoutError(tr.get(key), 90.0);
															#line 123 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			if (static_cast<ReadAndVerifyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1180 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadAndVerifyActor*>(this)->actor_wait_state = 1;
															#line 123 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadAndVerifyActor, 0, Optional<Value> >*>(static_cast<ReadAndVerifyActor*>(this)));
															#line 1185 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 130 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			if (expectedValue.isError() && expectedValue.getError().code() == e.code())
															#line 1220 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 133 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 133 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			if (static_cast<ReadAndVerifyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1228 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadAndVerifyActor*>(this)->actor_wait_state = 2;
															#line 133 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadAndVerifyActor, 1, Void >*>(static_cast<ReadAndVerifyActor*>(this)));
															#line 1233 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 124 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		const bool equal = !expectedValue.isError() && res == expectedValue.get();
															#line 125 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (!equal)
															#line 1250 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		{
															#line 126 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			self->validationFailed(expectedValue, ErrorOr<Optional<Value>>(res));
															#line 1254 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& __res,int loopDepth) 
	{
															#line 123 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		res = __res;
															#line 1264 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && __res,int loopDepth) 
	{
		res = std::move(__res);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadAndVerifyActor*>(this)->actor_wait_state > 0) static_cast<ReadAndVerifyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadAndVerifyActor*>(this)->ActorCallback< ReadAndVerifyActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadAndVerifyActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadAndVerifyActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadAndVerifyActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadAndVerifyActor*>(this)->actor_wait_state > 0) static_cast<ReadAndVerifyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadAndVerifyActor*>(this)->ActorCallback< ReadAndVerifyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadAndVerifyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadAndVerifyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadAndVerifyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	DataLossRecoveryWorkload* self;
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	Database cx;
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	Key key;
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	ErrorOr<Optional<Value>> expectedValue;
															#line 118 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	Transaction tr;
															#line 123 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	Optional<Value> res;
															#line 1438 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
};
// This generated class is to be used only via readAndVerify()
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
class ReadAndVerifyActor final : public Actor<Void>, public ActorCallback< ReadAndVerifyActor, 0, Optional<Value> >, public ActorCallback< ReadAndVerifyActor, 1, Void >, public FastAllocated<ReadAndVerifyActor>, public ReadAndVerifyActorState<ReadAndVerifyActor> {
															#line 1443 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
public:
	using FastAllocated<ReadAndVerifyActor>::operator new;
	using FastAllocated<ReadAndVerifyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2118832397465610496UL, 11022642828734901248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadAndVerifyActor, 0, Optional<Value> >;
friend struct ActorCallback< ReadAndVerifyActor, 1, Void >;
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	ReadAndVerifyActor(DataLossRecoveryWorkload* const& self,Database const& cx,Key const& key,ErrorOr<Optional<Value>> const& expectedValue) 
															#line 1461 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   ReadAndVerifyActorState<ReadAndVerifyActor>(self, cx, key, expectedValue),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3184544065301379584UL, 344653789742809600UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readAndVerify");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadAndVerifyActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadAndVerifyActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
[[nodiscard]] Future<Void> readAndVerify( DataLossRecoveryWorkload* const& self, Database const& cx, Key const& key, ErrorOr<Optional<Value>> const& expectedValue ) {
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	return Future<Void>(new ReadAndVerifyActor(self, cx, key, expectedValue));
															#line 1494 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
}

#line 139 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"

																#line 1499 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
// This generated class is to be used only via writeAndVerify()
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
template <class WriteAndVerifyActor>
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
class WriteAndVerifyActorState {
															#line 1505 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
public:
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	WriteAndVerifyActorState(DataLossRecoveryWorkload* const& self,Database const& cx,Key const& key,Optional<Value> const& value) 
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		 : self(self),
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		   cx(cx),
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		   key(key),
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		   value(value),
															#line 141 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		   tr(cx)
															#line 1520 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("writeAndVerify", reinterpret_cast<unsigned long>(this));

	}
	~WriteAndVerifyActorState() 
	{
		fdb_probe_actor_destroy("writeAndVerify", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 142 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			;
															#line 1535 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteAndVerifyActorState();
		static_cast<WriteAndVerifyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 156 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->readAndVerify(self, cx, key, value);
															#line 156 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<WriteAndVerifyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1560 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteAndVerifyActor*>(this)->actor_wait_state = 3;
															#line 156 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyActor, 2, Void >*>(static_cast<WriteAndVerifyActor*>(this)));
															#line 1565 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 144 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			if (value.present())
															#line 1582 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			{
															#line 145 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
				tr.set(key, value.get());
															#line 1586 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			}
			else
			{
															#line 147 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
				tr.clear(key);
															#line 1592 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			}
															#line 149 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 149 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			if (static_cast<WriteAndVerifyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1598 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteAndVerifyActor*>(this)->actor_wait_state = 1;
															#line 149 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyActor, 0, Void >*>(static_cast<WriteAndVerifyActor*>(this)));
															#line 1603 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 152 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 152 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			if (static_cast<WriteAndVerifyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1640 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WriteAndVerifyActor*>(this)->actor_wait_state = 2;
															#line 152 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyActor, 1, Void >*>(static_cast<WriteAndVerifyActor*>(this)));
															#line 1645 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteAndVerifyActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyActor*>(this)->ActorCallback< WriteAndVerifyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteAndVerifyActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyActor*>(this)->ActorCallback< WriteAndVerifyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 158 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (!static_cast<WriteAndVerifyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteAndVerifyActorState(); static_cast<WriteAndVerifyActor*>(this)->destroy(); return 0; }
															#line 1834 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		new (&static_cast<WriteAndVerifyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteAndVerifyActorState();
		static_cast<WriteAndVerifyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 158 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (!static_cast<WriteAndVerifyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteAndVerifyActorState(); static_cast<WriteAndVerifyActor*>(this)->destroy(); return 0; }
															#line 1846 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		new (&static_cast<WriteAndVerifyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteAndVerifyActorState();
		static_cast<WriteAndVerifyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteAndVerifyActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyActor*>(this)->ActorCallback< WriteAndVerifyActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	DataLossRecoveryWorkload* self;
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	Database cx;
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	Key key;
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	Optional<Value> value;
															#line 141 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	Transaction tr;
															#line 1939 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
};
// This generated class is to be used only via writeAndVerify()
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
class WriteAndVerifyActor final : public Actor<Void>, public ActorCallback< WriteAndVerifyActor, 0, Void >, public ActorCallback< WriteAndVerifyActor, 1, Void >, public ActorCallback< WriteAndVerifyActor, 2, Void >, public FastAllocated<WriteAndVerifyActor>, public WriteAndVerifyActorState<WriteAndVerifyActor> {
															#line 1944 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
public:
	using FastAllocated<WriteAndVerifyActor>::operator new;
	using FastAllocated<WriteAndVerifyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8109438448691477504UL, 17143990087989658368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteAndVerifyActor, 0, Void >;
friend struct ActorCallback< WriteAndVerifyActor, 1, Void >;
friend struct ActorCallback< WriteAndVerifyActor, 2, Void >;
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	WriteAndVerifyActor(DataLossRecoveryWorkload* const& self,Database const& cx,Key const& key,Optional<Value> const& value) 
															#line 1963 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   WriteAndVerifyActorState<WriteAndVerifyActor>(self, cx, key, value),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3594513465819686400UL, 13554697269594140416UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeAndVerify");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteAndVerifyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteAndVerifyActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteAndVerifyActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
[[nodiscard]] Future<Void> writeAndVerify( DataLossRecoveryWorkload* const& self, Database const& cx, Key const& key, Optional<Value> const& value ) {
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	return Future<Void>(new WriteAndVerifyActor(self, cx, key, value));
															#line 1997 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
}

#line 160 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"

																#line 2002 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
// This generated class is to be used only via exclude()
															#line 161 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
template <class ExcludeActor>
															#line 161 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
class ExcludeActorState {
															#line 2008 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
public:
															#line 161 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	ExcludeActorState(Database const& cx,NetworkAddress const& addr) 
															#line 161 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
															#line 161 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		 : cx(cx),
															#line 161 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		   addr(addr),
															#line 162 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		   tr(cx),
															#line 163 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		   servers()
															#line 2021 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("exclude", reinterpret_cast<unsigned long>(this));

	}
	~ExcludeActorState() 
	{
		fdb_probe_actor_destroy("exclude", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 164 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			servers.push_back(AddressExclusion(addr.ip, addr.port));
															#line 165 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			;
															#line 2038 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExcludeActorState();
		static_cast<ExcludeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 176 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<std::set<NetworkAddress>> __when_expr_3 = checkForExcludingServers(cx, servers, true);
															#line 176 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<ExcludeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2063 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<ExcludeActor*>(this)->actor_wait_state = 4;
															#line 176 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ExcludeActor, 3, std::set<NetworkAddress> >*>(static_cast<ExcludeActor*>(this)));
															#line 2068 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 167 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = excludeServers(&tr, servers, true);
															#line 167 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			if (static_cast<ExcludeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2087 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ExcludeActor*>(this)->actor_wait_state = 1;
															#line 167 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExcludeActor, 0, Void >*>(static_cast<ExcludeActor*>(this)));
															#line 2092 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 171 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 171 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			if (static_cast<ExcludeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2129 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ExcludeActor*>(this)->actor_wait_state = 3;
															#line 171 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExcludeActor, 2, Void >*>(static_cast<ExcludeActor*>(this)));
															#line 2134 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 168 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 168 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<ExcludeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2151 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExcludeActor*>(this)->actor_wait_state = 2;
															#line 168 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExcludeActor, 1, Void >*>(static_cast<ExcludeActor*>(this)));
															#line 2156 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 168 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 168 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<ExcludeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2167 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExcludeActor*>(this)->actor_wait_state = 2;
															#line 168 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExcludeActor, 1, Void >*>(static_cast<ExcludeActor*>(this)));
															#line 2172 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExcludeActor*>(this)->actor_wait_state > 0) static_cast<ExcludeActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeActor*>(this)->ActorCallback< ExcludeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("exclude", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("exclude", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExcludeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("exclude", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("exclude", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExcludeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("exclude", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("exclude", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExcludeActor*>(this)->actor_wait_state > 0) static_cast<ExcludeActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeActor*>(this)->ActorCallback< ExcludeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("exclude", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("exclude", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExcludeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("exclude", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("exclude", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExcludeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("exclude", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("exclude", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ExcludeActor*>(this)->actor_wait_state > 0) static_cast<ExcludeActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeActor*>(this)->ActorCallback< ExcludeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("exclude", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("exclude", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ExcludeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("exclude", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("exclude", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ExcludeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("exclude", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("exclude", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2(std::set<NetworkAddress> const& inProgress,int loopDepth) 
	{
															#line 177 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		ASSERT(inProgress.empty());
															#line 179 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("ExcludedFailedServer").detail("Address", addr.toString());
															#line 180 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (!static_cast<ExcludeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ExcludeActorState(); static_cast<ExcludeActor*>(this)->destroy(); return 0; }
															#line 2434 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		new (&static_cast<ExcludeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ExcludeActorState();
		static_cast<ExcludeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(std::set<NetworkAddress> && inProgress,int loopDepth) 
	{
															#line 177 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		ASSERT(inProgress.empty());
															#line 179 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("ExcludedFailedServer").detail("Address", addr.toString());
															#line 180 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (!static_cast<ExcludeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ExcludeActorState(); static_cast<ExcludeActor*>(this)->destroy(); return 0; }
															#line 2450 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		new (&static_cast<ExcludeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ExcludeActorState();
		static_cast<ExcludeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::set<NetworkAddress> const& inProgress,int loopDepth) 
	{
		loopDepth = a_body1cont2(inProgress, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::set<NetworkAddress> && inProgress,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(inProgress), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ExcludeActor*>(this)->actor_wait_state > 0) static_cast<ExcludeActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeActor*>(this)->ActorCallback< ExcludeActor, 3, std::set<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeActor, 3, std::set<NetworkAddress> >*,std::set<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("exclude", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("exclude", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ExcludeActor, 3, std::set<NetworkAddress> >*,std::set<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("exclude", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("exclude", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ExcludeActor, 3, std::set<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("exclude", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("exclude", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 161 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	Database cx;
															#line 161 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	NetworkAddress addr;
															#line 162 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	Transaction tr;
															#line 163 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	std::vector<AddressExclusion> servers;
															#line 2541 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
};
// This generated class is to be used only via exclude()
															#line 161 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
class ExcludeActor final : public Actor<Void>, public ActorCallback< ExcludeActor, 0, Void >, public ActorCallback< ExcludeActor, 1, Void >, public ActorCallback< ExcludeActor, 2, Void >, public ActorCallback< ExcludeActor, 3, std::set<NetworkAddress> >, public FastAllocated<ExcludeActor>, public ExcludeActorState<ExcludeActor> {
															#line 2546 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
public:
	using FastAllocated<ExcludeActor>::operator new;
	using FastAllocated<ExcludeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8736248597098533120UL, 17053905220452787712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExcludeActor, 0, Void >;
friend struct ActorCallback< ExcludeActor, 1, Void >;
friend struct ActorCallback< ExcludeActor, 2, Void >;
friend struct ActorCallback< ExcludeActor, 3, std::set<NetworkAddress> >;
															#line 161 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	ExcludeActor(Database const& cx,NetworkAddress const& addr) 
															#line 2566 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   ExcludeActorState<ExcludeActor>(cx, addr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("exclude", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5032062106498793216UL, 8007848712098060288UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("exclude");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("exclude", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExcludeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExcludeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ExcludeActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ExcludeActor, 3, std::set<NetworkAddress> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 161 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
[[nodiscard]] Future<Void> exclude( Database const& cx, NetworkAddress const& addr ) {
															#line 161 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	return Future<Void>(new ExcludeActor(cx, addr));
															#line 2601 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
}

#line 182 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"

	// Move keys to a random selected team consisting of a single SS, after disabling DD, so that keys won't be
	// kept in the new team until DD is enabled.
	// Returns the address of the single SS of the new team.
																#line 2609 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
// This generated class is to be used only via disableDDAndMoveShard()
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
template <class DisableDDAndMoveShardActor>
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
class DisableDDAndMoveShardActorState {
															#line 2615 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
public:
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	DisableDDAndMoveShardActorState(DataLossRecoveryWorkload* const& self,Database const& cx,KeyRange const& keys) 
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		 : self(self),
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		   cx(cx),
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		   keys(keys)
															#line 2626 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this));

	}
	~DisableDDAndMoveShardActorState() 
	{
		fdb_probe_actor_destroy("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 188 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(setDDMode(cx, 0));
															#line 188 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			if (static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2643 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state = 1;
															#line 188 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DisableDDAndMoveShardActor, 0, Void >*>(static_cast<DisableDDAndMoveShardActor*>(this)));
															#line 2648 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DisableDDAndMoveShardActorState();
		static_cast<DisableDDAndMoveShardActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 189 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("DataLossRecovery").detail("Phase", "DisabledDD");
															#line 190 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		addr = NetworkAddress();
															#line 193 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		dest = std::vector<UID>();
															#line 194 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		;
															#line 2677 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 189 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("DataLossRecovery").detail("Phase", "DisabledDD");
															#line 190 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		addr = NetworkAddress();
															#line 193 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		dest = std::vector<UID>();
															#line 194 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		;
															#line 2692 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state > 0) static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state = 0;
		static_cast<DisableDDAndMoveShardActor*>(this)->ActorCallback< DisableDDAndMoveShardActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DisableDDAndMoveShardActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DisableDDAndMoveShardActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DisableDDAndMoveShardActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 218 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		owner = deterministicRandom()->randomUniqueID();
															#line 219 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		ddEnabledState = DDEnabledState();
															#line 221 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		tr = Transaction(cx);
															#line 223 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		;
															#line 2782 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 194 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (!(dest.empty()))
															#line 2798 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 195 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<std::vector<StorageServerInterface>> __when_expr_1 = getStorageServers(cx);
															#line 195 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2806 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state = 2;
															#line 195 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DisableDDAndMoveShardActor, 1, std::vector<StorageServerInterface> >*>(static_cast<DisableDDAndMoveShardActor*>(this)));
															#line 2811 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 196 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (!interfs.empty())
															#line 2833 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		{
															#line 197 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			interf = interfs[deterministicRandom()->randomInt(0, interfs.size())];
															#line 198 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			if (!g_simulator->protectedAddresses.contains(interf.address()))
															#line 2839 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			{
															#line 203 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
				metricsRequest = interf.getStorageMetrics.tryGetReply( GetStorageMetricsRequest(), TaskPriority::DataDistributionLaunch);
															#line 206 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
				StrictFuture<ErrorOr<GetStorageMetricsReply>> __when_expr_2 = metricsRequest;
															#line 206 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
				if (static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2847 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
				static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state = 3;
															#line 206 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DisableDDAndMoveShardActor, 2, ErrorOr<GetStorageMetricsReply> >*>(static_cast<DisableDDAndMoveShardActor*>(this)));
															#line 2852 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont4(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(std::vector<StorageServerInterface> const& __interfs,int loopDepth) 
	{
															#line 195 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		interfs = __interfs;
															#line 2871 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(std::vector<StorageServerInterface> && __interfs,int loopDepth) 
	{
		interfs = std::move(__interfs);
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state > 0) static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state = 0;
		static_cast<DisableDDAndMoveShardActor*>(this)->ActorCallback< DisableDDAndMoveShardActor, 1, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< DisableDDAndMoveShardActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DisableDDAndMoveShardActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DisableDDAndMoveShardActor, 1, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(int loopDepth) 
	{
															#line 207 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (rep.isError())
															#line 2962 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		{
															#line 209 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(1.0);
															#line 209 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			if (static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2968 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
			static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state = 4;
															#line 209 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DisableDDAndMoveShardActor, 3, Void >*>(static_cast<DisableDDAndMoveShardActor*>(this)));
															#line 2973 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(ErrorOr<GetStorageMetricsReply> const& __rep,int loopDepth) 
	{
															#line 206 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		rep = __rep;
															#line 2987 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(ErrorOr<GetStorageMetricsReply> && __rep,int loopDepth) 
	{
		rep = std::move(__rep);
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state > 0) static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state = 0;
		static_cast<DisableDDAndMoveShardActor*>(this)->ActorCallback< DisableDDAndMoveShardActor, 2, ErrorOr<GetStorageMetricsReply> >::remove();

	}
	void a_callback_fire(ActorCallback< DisableDDAndMoveShardActor, 2, ErrorOr<GetStorageMetricsReply> >*,ErrorOr<GetStorageMetricsReply> const& value) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DisableDDAndMoveShardActor, 2, ErrorOr<GetStorageMetricsReply> >*,ErrorOr<GetStorageMetricsReply> && value) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DisableDDAndMoveShardActor, 2, ErrorOr<GetStorageMetricsReply> >*,Error err) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
															#line 212 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		dest.push_back(interf.uniqueID);
															#line 213 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		addr = interf.address();
															#line 3068 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void && _,int loopDepth) 
	{
		return a_body1cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state > 0) static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state = 0;
		static_cast<DisableDDAndMoveShardActor*>(this)->ActorCallback< DisableDDAndMoveShardActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DisableDDAndMoveShardActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DisableDDAndMoveShardActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DisableDDAndMoveShardActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 291 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("TestKeyMoved").detail("NewTeam", describe(dest)).detail("Address", addr.toString());
															#line 293 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		validateTr = Transaction(cx);
															#line 294 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		;
															#line 3168 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 225 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 226 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			BinaryWriter wrMyOwner(Unversioned());
															#line 227 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			wrMyOwner << owner;
															#line 228 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			tr.set(moveKeysLockOwnerKey, wrMyOwner.toValue());
															#line 229 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.commit();
															#line 229 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			if (static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3195 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state = 5;
															#line 229 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DisableDDAndMoveShardActor, 4, Void >*>(static_cast<DisableDDAndMoveShardActor*>(this)));
															#line 3200 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 281 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			TraceEvent("DataLossRecovery").error(e).detail("Phase", "MoveRangeError");
															#line 282 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			if (e.code() == error_code_movekeys_conflict)
															#line 3237 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			{
															#line 284 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
				tr.reset();
															#line 3241 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
				loopDepth = a_body1cont2loopBody1Catch1cont1(loopDepth);
			}
			else
			{
															#line 286 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
				StrictFuture<Void> __when_expr_6 = tr.onError(e);
															#line 286 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
				if (static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3250 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
				static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state = 7;
															#line 286 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DisableDDAndMoveShardActor, 6, Void >*>(static_cast<DisableDDAndMoveShardActor*>(this)));
															#line 3255 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 231 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		MoveKeysLock moveKeysLock;
															#line 232 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		moveKeysLock.myOwner = owner;
															#line 234 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("DataLossRecovery").detail("Phase", "StartMoveKeys");
															#line 235 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		std::unique_ptr<MoveKeysParams> params;
															#line 236 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA)
															#line 3279 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		{
															#line 237 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			UID dataMoveId = newDataMoveId(deterministicRandom()->randomUInt64(), AssignEmptyRange(false), deterministicRandom()->random01() < SERVER_KNOBS->DD_PHYSICAL_SHARD_MOVE_PROBABILITY ? DataMoveType::PHYSICAL : DataMoveType::LOGICAL, DataMovementReason::TEAM_HEALTHY, UnassignShard(false));
															#line 245 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			params = std::make_unique<MoveKeysParams>(dataMoveId, std::vector<KeyRange>{ keys }, dest, dest, moveKeysLock, Promise<Void>(), &self->startMoveKeysParallelismLock, &self->finishMoveKeysParallelismLock, false, UID(), &ddEnabledState, CancelConflictingDataMoves::True, Optional<BulkLoadTaskState>());
															#line 3285 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		}
		else
		{
															#line 259 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			UID dataMoveId = newDataMoveId(deterministicRandom()->randomUInt64(), AssignEmptyRange(false), DataMoveType::LOGICAL, DataMovementReason::TEAM_HEALTHY, UnassignShard(false));
															#line 264 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			params = std::make_unique<MoveKeysParams>(dataMoveId, keys, dest, dest, moveKeysLock, Promise<Void>(), &self->startMoveKeysParallelismLock, &self->finishMoveKeysParallelismLock, false, UID(), &ddEnabledState, CancelConflictingDataMoves::True, Optional<BulkLoadTaskState>());
															#line 3293 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		}
															#line 278 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_5 = moveKeys(cx, *params);
															#line 278 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3299 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont2loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state = 6;
															#line 278 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DisableDDAndMoveShardActor, 5, Void >*>(static_cast<DisableDDAndMoveShardActor*>(this)));
															#line 3304 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 231 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		MoveKeysLock moveKeysLock;
															#line 232 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		moveKeysLock.myOwner = owner;
															#line 234 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		TraceEvent("DataLossRecovery").detail("Phase", "StartMoveKeys");
															#line 235 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		std::unique_ptr<MoveKeysParams> params;
															#line 236 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA)
															#line 3321 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		{
															#line 237 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			UID dataMoveId = newDataMoveId(deterministicRandom()->randomUInt64(), AssignEmptyRange(false), deterministicRandom()->random01() < SERVER_KNOBS->DD_PHYSICAL_SHARD_MOVE_PROBABILITY ? DataMoveType::PHYSICAL : DataMoveType::LOGICAL, DataMovementReason::TEAM_HEALTHY, UnassignShard(false));
															#line 245 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			params = std::make_unique<MoveKeysParams>(dataMoveId, std::vector<KeyRange>{ keys }, dest, dest, moveKeysLock, Promise<Void>(), &self->startMoveKeysParallelismLock, &self->finishMoveKeysParallelismLock, false, UID(), &ddEnabledState, CancelConflictingDataMoves::True, Optional<BulkLoadTaskState>());
															#line 3327 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		}
		else
		{
															#line 259 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			UID dataMoveId = newDataMoveId(deterministicRandom()->randomUInt64(), AssignEmptyRange(false), DataMoveType::LOGICAL, DataMovementReason::TEAM_HEALTHY, UnassignShard(false));
															#line 264 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			params = std::make_unique<MoveKeysParams>(dataMoveId, keys, dest, dest, moveKeysLock, Promise<Void>(), &self->startMoveKeysParallelismLock, &self->finishMoveKeysParallelismLock, false, UID(), &ddEnabledState, CancelConflictingDataMoves::True, Optional<BulkLoadTaskState>());
															#line 3335 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		}
															#line 278 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_5 = moveKeys(cx, *params);
															#line 278 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3341 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont2loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state = 6;
															#line 278 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DisableDDAndMoveShardActor, 5, Void >*>(static_cast<DisableDDAndMoveShardActor*>(this)));
															#line 3346 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state > 0) static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state = 0;
		static_cast<DisableDDAndMoveShardActor*>(this)->ActorCallback< DisableDDAndMoveShardActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DisableDDAndMoveShardActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DisableDDAndMoveShardActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DisableDDAndMoveShardActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state > 0) static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state = 0;
		static_cast<DisableDDAndMoveShardActor*>(this)->ActorCallback< DisableDDAndMoveShardActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DisableDDAndMoveShardActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DisableDDAndMoveShardActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DisableDDAndMoveShardActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont2loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state > 0) static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state = 0;
		static_cast<DisableDDAndMoveShardActor*>(this)->ActorCallback< DisableDDAndMoveShardActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DisableDDAndMoveShardActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DisableDDAndMoveShardActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DisableDDAndMoveShardActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 306 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		if (!static_cast<DisableDDAndMoveShardActor*>(this)->SAV<NetworkAddress>::futures) { (void)(addr); this->~DisableDDAndMoveShardActorState(); static_cast<DisableDDAndMoveShardActor*>(this)->destroy(); return 0; }
															#line 3610 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		new (&static_cast<DisableDDAndMoveShardActor*>(this)->SAV< NetworkAddress >::value()) NetworkAddress(std::move(addr)); // state_var_RVO
		this->~DisableDDAndMoveShardActorState();
		static_cast<DisableDDAndMoveShardActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
		try {
															#line 296 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			StrictFuture<Standalone<VectorRef<const char*>>> __when_expr_7 = validateTr.getAddressesForKey(keys.begin);
															#line 296 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			if (static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3632 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont3loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont3loopBody1when1(__when_expr_7.get(), loopDepth); };
			static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state = 8;
															#line 296 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< DisableDDAndMoveShardActor, 7, Standalone<VectorRef<const char*>> >*>(static_cast<DisableDDAndMoveShardActor*>(this)));
															#line 3637 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 302 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_8 = validateTr.onError(e);
															#line 302 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			if (static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3674 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1Catch1when1(__when_expr_8.get(), loopDepth); };
			static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state = 9;
															#line 302 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< DisableDDAndMoveShardActor, 8, Void >*>(static_cast<DisableDDAndMoveShardActor*>(this)));
															#line 3679 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(Standalone<VectorRef<const char*>> const& addresses,int loopDepth) 
	{
															#line 298 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		ASSERT(addresses.size() == 1);
															#line 299 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		ASSERT(std::string(addresses[0]) == addr.toString());
															#line 3696 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(Standalone<VectorRef<const char*>> && addresses,int loopDepth) 
	{
															#line 298 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		ASSERT(addresses.size() == 1);
															#line 299 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
		ASSERT(std::string(addresses[0]) == addr.toString());
															#line 3707 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Standalone<VectorRef<const char*>> const& addresses,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(addresses, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Standalone<VectorRef<const char*>> && addresses,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(std::move(addresses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state > 0) static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state = 0;
		static_cast<DisableDDAndMoveShardActor*>(this)->ActorCallback< DisableDDAndMoveShardActor, 7, Standalone<VectorRef<const char*>> >::remove();

	}
	void a_callback_fire(ActorCallback< DisableDDAndMoveShardActor, 7, Standalone<VectorRef<const char*>> >*,Standalone<VectorRef<const char*>> const& value) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< DisableDDAndMoveShardActor, 7, Standalone<VectorRef<const char*>> >*,Standalone<VectorRef<const char*>> && value) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< DisableDDAndMoveShardActor, 7, Standalone<VectorRef<const char*>> >*,Error err) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont3loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state > 0) static_cast<DisableDDAndMoveShardActor*>(this)->actor_wait_state = 0;
		static_cast<DisableDDAndMoveShardActor*>(this)->ActorCallback< DisableDDAndMoveShardActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DisableDDAndMoveShardActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont3loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< DisableDDAndMoveShardActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont3loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< DisableDDAndMoveShardActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	DataLossRecoveryWorkload* self;
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	Database cx;
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	KeyRange keys;
															#line 190 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	NetworkAddress addr;
															#line 193 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	std::vector<UID> dest;
															#line 195 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	std::vector<StorageServerInterface> interfs;
															#line 197 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	StorageServerInterface interf;
															#line 203 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	Future<ErrorOr<GetStorageMetricsReply>> metricsRequest;
															#line 206 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	ErrorOr<GetStorageMetricsReply> rep;
															#line 218 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	UID owner;
															#line 219 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	DDEnabledState ddEnabledState;
															#line 221 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	Transaction tr;
															#line 293 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	Transaction validateTr;
															#line 3900 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
};
// This generated class is to be used only via disableDDAndMoveShard()
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
class DisableDDAndMoveShardActor final : public Actor<NetworkAddress>, public ActorCallback< DisableDDAndMoveShardActor, 0, Void >, public ActorCallback< DisableDDAndMoveShardActor, 1, std::vector<StorageServerInterface> >, public ActorCallback< DisableDDAndMoveShardActor, 2, ErrorOr<GetStorageMetricsReply> >, public ActorCallback< DisableDDAndMoveShardActor, 3, Void >, public ActorCallback< DisableDDAndMoveShardActor, 4, Void >, public ActorCallback< DisableDDAndMoveShardActor, 5, Void >, public ActorCallback< DisableDDAndMoveShardActor, 6, Void >, public ActorCallback< DisableDDAndMoveShardActor, 7, Standalone<VectorRef<const char*>> >, public ActorCallback< DisableDDAndMoveShardActor, 8, Void >, public FastAllocated<DisableDDAndMoveShardActor>, public DisableDDAndMoveShardActorState<DisableDDAndMoveShardActor> {
															#line 3905 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
public:
	using FastAllocated<DisableDDAndMoveShardActor>::operator new;
	using FastAllocated<DisableDDAndMoveShardActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4253129746387927296UL, 2622185842922057728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<NetworkAddress>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DisableDDAndMoveShardActor, 0, Void >;
friend struct ActorCallback< DisableDDAndMoveShardActor, 1, std::vector<StorageServerInterface> >;
friend struct ActorCallback< DisableDDAndMoveShardActor, 2, ErrorOr<GetStorageMetricsReply> >;
friend struct ActorCallback< DisableDDAndMoveShardActor, 3, Void >;
friend struct ActorCallback< DisableDDAndMoveShardActor, 4, Void >;
friend struct ActorCallback< DisableDDAndMoveShardActor, 5, Void >;
friend struct ActorCallback< DisableDDAndMoveShardActor, 6, Void >;
friend struct ActorCallback< DisableDDAndMoveShardActor, 7, Standalone<VectorRef<const char*>> >;
friend struct ActorCallback< DisableDDAndMoveShardActor, 8, Void >;
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	DisableDDAndMoveShardActor(DataLossRecoveryWorkload* const& self,Database const& cx,KeyRange const& keys) 
															#line 3930 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
		 : Actor<NetworkAddress>(),
		   DisableDDAndMoveShardActorState<DisableDDAndMoveShardActor>(self, cx, keys),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10131133697167261952UL, 13627607667144739584UL);
		ActorExecutionContextHelper __helper(static_cast<DisableDDAndMoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("disableDDAndMoveShard");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("disableDDAndMoveShard", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DisableDDAndMoveShardActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DisableDDAndMoveShardActor, 1, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DisableDDAndMoveShardActor, 2, ErrorOr<GetStorageMetricsReply> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DisableDDAndMoveShardActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DisableDDAndMoveShardActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DisableDDAndMoveShardActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DisableDDAndMoveShardActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< DisableDDAndMoveShardActor, 7, Standalone<VectorRef<const char*>> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< DisableDDAndMoveShardActor, 8, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
[[nodiscard]] Future<NetworkAddress> disableDDAndMoveShard( DataLossRecoveryWorkload* const& self, Database const& cx, KeyRange const& keys ) {
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"
	return Future<NetworkAddress>(new DisableDDAndMoveShardActor(self, cx, keys));
															#line 3970 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DataLossRecovery.actor.g.cpp"
}

#line 308 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/DataLossRecovery.actor.cpp"

	void killProcess(DataLossRecoveryWorkload* self, const NetworkAddress& addr) {
		ISimulator::ProcessInfo* process = g_simulator->getProcessByAddress(addr);
		ASSERT(process->addresses.contains(addr));
		g_simulator->killProcess(process, ISimulator::KillType::KillInstantly);
		TraceEvent("TestTeamKilled").detail("Address", addr);
	}

	Future<bool> check(Database const& cx) override { return pass; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<DataLossRecoveryWorkload> DataLossRecoveryWorkloadFactory;
