#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
/*
 * BulkLoad.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbrpc/DDSketch.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct BulkLoadWorkload : TestWorkload {
	static constexpr auto NAME = "BulkLoad";
	int clientCount, actorCount, writesPerTransaction, valueBytes;
	double testDuration;
	Value value;
	uint64_t targetBytes;
	Key keyPrefix;

	std::vector<Future<Void>> clients;
	PerfIntCounter transactions, retries;
	DDSketch<double> latencies;

	BulkLoadWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), clientCount(wcx.clientCount), transactions("Transactions"), retries("Retries"), latencies() {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		actorCount = getOption(options, "actorCount"_sr, 20);
		writesPerTransaction = getOption(options, "writesPerTransaction"_sr, 10);
		valueBytes = std::max(getOption(options, "valueBytes"_sr, 96), 16);
		value = Value(deterministicRandom()->randomAlphaNumeric(valueBytes));
		targetBytes = getOption(options, "targetBytes"_sr, std::numeric_limits<uint64_t>::max());
		keyPrefix = getOption(options, "keyPrefix"_sr, ""_sr);
		keyPrefix = unprintable(keyPrefix.toString());
	}

	Future<Void> start(Database const& cx) override {
		for (int c = 0; c < actorCount; c++)
			clients.push_back(timeout(bulkLoadClient(cx, this, clientId, c), testDuration, Void()));
		return waitForAll(clients);
	}

	Future<bool> check(Database const& cx) override {
		clients.clear();
		return true;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.push_back(transactions.getMetric());
		m.push_back(retries.getMetric());
		m.emplace_back("Rows written", transactions.getValue() * writesPerTransaction, Averaged::False);
		m.emplace_back("Transactions/sec", transactions.getValue() / testDuration, Averaged::False);
		m.emplace_back(
		    "Write rows/sec", transactions.getValue() * writesPerTransaction / testDuration, Averaged::False);
		double keysPerSecond = transactions.getValue() * writesPerTransaction / testDuration;
		m.emplace_back("Keys written/sec", keysPerSecond, Averaged::False);
		m.emplace_back("Bytes written/sec", keysPerSecond * (valueBytes + 16), Averaged::False);

		m.emplace_back("Mean Latency (ms)", 1000 * latencies.mean(), Averaged::True);
		m.emplace_back("Median Latency (ms, averaged)", 1000 * latencies.median(), Averaged::True);
		m.emplace_back("90% Latency (ms, averaged)", 1000 * latencies.percentile(0.90), Averaged::True);
		m.emplace_back("98% Latency (ms, averaged)", 1000 * latencies.percentile(0.98), Averaged::True);
	}

																#line 81 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
// This generated class is to be used only via bulkLoadClient()
															#line 79 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
template <class BulkLoadClientActor>
															#line 79 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
class BulkLoadClientActorState {
															#line 87 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
public:
															#line 79 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
	BulkLoadClientActorState(Database const& cx,BulkLoadWorkload* const& self,int const& clientId,int const& actorId) 
															#line 79 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
															#line 79 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		 : cx(cx),
															#line 79 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		   self(self),
															#line 79 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		   clientId(clientId),
															#line 79 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		   actorId(actorId),
															#line 80 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		   totalBytes(0),
															#line 81 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		   idx(0)
															#line 104 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
	{
		fdb_probe_actor_create("bulkLoadClient", reinterpret_cast<unsigned long>(this));

	}
	~BulkLoadClientActorState() 
	{
		fdb_probe_actor_destroy("bulkLoadClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 82 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
			;
															#line 119 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BulkLoadClientActorState();
		static_cast<BulkLoadClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 83 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		tstart = now();
															#line 84 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		tr = Transaction(cx);
															#line 85 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		;
															#line 153 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 107 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		self->latencies.addSample(now() - tstart);
															#line 108 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		++self->transactions;
															#line 109 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		idx += self->writesPerTransaction;
															#line 110 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		if (totalBytes > self->targetBytes / self->clientCount / self->actorCount)
															#line 168 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
		{
															#line 111 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
			if (!static_cast<BulkLoadClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BulkLoadClientActorState(); static_cast<BulkLoadClientActor*>(this)->destroy(); return 0; }
															#line 172 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
			new (&static_cast<BulkLoadClientActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~BulkLoadClientActorState();
			static_cast<BulkLoadClientActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 86 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		txnBytes = 0;
															#line 193 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
		try {
															#line 88 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
			for(int i = 0;i < self->writesPerTransaction;i++) {
															#line 89 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
				std::string key = format("%s/bulkload/%04x/%04x/%08x", self->keyPrefix.toString().c_str(), self->clientId, actorId, idx + i);
															#line 94 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
				tr.set(key, self->value);
															#line 95 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
				txnBytes += key.size() + self->value.size();
															#line 203 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
			}
															#line 97 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
			tr.makeSelfConflicting();
															#line 98 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(tr.getReadVersion());
															#line 98 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
			if (static_cast<BulkLoadClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 211 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BulkLoadClientActor*>(this)->actor_wait_state = 1;
															#line 98 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BulkLoadClientActor, 0, Void >*>(static_cast<BulkLoadClientActor*>(this)));
															#line 216 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 103 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 103 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
			if (static_cast<BulkLoadClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 253 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<BulkLoadClientActor*>(this)->actor_wait_state = 3;
															#line 103 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BulkLoadClientActor, 2, Void >*>(static_cast<BulkLoadClientActor*>(this)));
															#line 258 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 99 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 99 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		if (static_cast<BulkLoadClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 275 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<BulkLoadClientActor*>(this)->actor_wait_state = 2;
															#line 99 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BulkLoadClientActor, 1, Void >*>(static_cast<BulkLoadClientActor*>(this)));
															#line 280 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 99 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 99 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		if (static_cast<BulkLoadClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 291 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<BulkLoadClientActor*>(this)->actor_wait_state = 2;
															#line 99 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BulkLoadClientActor, 1, Void >*>(static_cast<BulkLoadClientActor*>(this)));
															#line 296 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BulkLoadClientActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadClientActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadClientActor*>(this)->ActorCallback< BulkLoadClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BulkLoadClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BulkLoadClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 100 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		totalBytes += txnBytes;
															#line 380 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 100 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		totalBytes += txnBytes;
															#line 389 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BulkLoadClientActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadClientActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadClientActor*>(this)->ActorCallback< BulkLoadClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BulkLoadClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BulkLoadClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		++self->retries;
															#line 473 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
		++self->retries;
															#line 482 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BulkLoadClientActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadClientActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadClientActor*>(this)->ActorCallback< BulkLoadClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BulkLoadClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BulkLoadClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadClient", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 79 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
	Database cx;
															#line 79 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
	BulkLoadWorkload* self;
															#line 79 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
	int clientId;
															#line 79 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
	int actorId;
															#line 80 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
	uint64_t totalBytes;
															#line 81 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
	int idx;
															#line 83 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
	double tstart;
															#line 84 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
	Transaction tr;
															#line 86 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
	uint64_t txnBytes;
															#line 580 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
};
// This generated class is to be used only via bulkLoadClient()
															#line 79 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
class BulkLoadClientActor final : public Actor<Void>, public ActorCallback< BulkLoadClientActor, 0, Void >, public ActorCallback< BulkLoadClientActor, 1, Void >, public ActorCallback< BulkLoadClientActor, 2, Void >, public FastAllocated<BulkLoadClientActor>, public BulkLoadClientActorState<BulkLoadClientActor> {
															#line 585 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
public:
	using FastAllocated<BulkLoadClientActor>::operator new;
	using FastAllocated<BulkLoadClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5107295872713552896UL, 6080457624755125760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BulkLoadClientActor, 0, Void >;
friend struct ActorCallback< BulkLoadClientActor, 1, Void >;
friend struct ActorCallback< BulkLoadClientActor, 2, Void >;
															#line 79 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
	BulkLoadClientActor(Database const& cx,BulkLoadWorkload* const& self,int const& clientId,int const& actorId) 
															#line 604 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
		 : Actor<Void>(),
		   BulkLoadClientActorState<BulkLoadClientActor>(cx, self, clientId, actorId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bulkLoadClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2362946363708306432UL, 10217505291365845760UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bulkLoadClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bulkLoadClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BulkLoadClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BulkLoadClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BulkLoadClientActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 79 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
[[nodiscard]] Future<Void> bulkLoadClient( Database const& cx, BulkLoadWorkload* const& self, int const& clientId, int const& actorId ) {
															#line 79 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
	return Future<Void>(new BulkLoadClientActor(cx, self, clientId, actorId));
															#line 638 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkLoad.actor.g.cpp"
}

#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/workloads/BulkLoad.actor.cpp"
};

WorkloadFactory<BulkLoadWorkload> BulkLoadWorkloadFactory;
