#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
/*
 * ConfigNode.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <map>

#include "fdbclient/SystemData.h"
#include "fdbserver/ConfigNode.h"
#include "fdbserver/IKeyValueStore.h"
#include "fdbserver/OnDemandStore.h"
#include "flow/Arena.h"
#include "flow/genericactors.actor.h"
#include "flow/UnitTest.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace {

const KeyRef coordinatorsHashKey = "id"_sr;
const KeyRef lastCompactedVersionKey = "lastCompactedVersion"_sr;
const KeyRef currentGenerationKey = "currentGeneration"_sr;
const KeyRef registeredKey = "registered"_sr;
const KeyRef lockedKey = "locked"_sr;
const KeyRangeRef kvKeys = KeyRangeRef("kv/"_sr, "kv0"_sr);
const KeyRangeRef mutationKeys = KeyRangeRef("mutation/"_sr, "mutation0"_sr);
const KeyRangeRef annotationKeys = KeyRangeRef("annotation/"_sr, "annotation0"_sr);

Key versionedAnnotationKey(Version version) {
	ASSERT_GE(version, 0);
	return BinaryWriter::toValue(bigEndian64(version), IncludeVersion()).withPrefix(annotationKeys.begin);
}

Version getVersionFromVersionedAnnotationKey(KeyRef versionedAnnotationKey) {
	return fromBigEndian64(BinaryReader::fromStringRef<uint64_t>(
	    versionedAnnotationKey.removePrefix(annotationKeys.begin), IncludeVersion()));
}

Key versionedMutationKey(Version version, uint32_t index) {
	ASSERT_GE(version, 0);
	BinaryWriter bw(IncludeVersion());
	bw << bigEndian64(version);
	bw << bigEndian32(index);
	return bw.toValue().withPrefix(mutationKeys.begin);
}

Version getVersionFromVersionedMutationKey(KeyRef versionedMutationKey) {
	uint64_t bigEndianResult;
	ASSERT(versionedMutationKey.startsWith(mutationKeys.begin));
	BinaryReader br(versionedMutationKey.removePrefix(mutationKeys.begin), IncludeVersion());
	br >> bigEndianResult;
	return fromBigEndian64(bigEndianResult);
}

template <typename T>
void assertCommitted(RangeResult const& range, VectorRef<T> versionedConfigs, std::function<Version(KeyRef)> fn) {
	if (range.size() == 0) {
		return;
	}
	// Verify every versioned value read from disk (minus the last one which
	// may not be committed on a quorum) exists in the rollforward changes.
	for (auto it = range.begin(); it != std::prev(range.end()); ++it) {
		Version version = fn(it->key);
		auto resultIt = std::find_if(
		    versionedConfigs.begin(), versionedConfigs.end(), [version](T const& o) { return o.version == version; });
		ASSERT(resultIt != versionedConfigs.end());
	}
}

} // namespace

															#line 89 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase87()
															#line 87 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class FlowTestCase87Actor>
															#line 87 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class FlowTestCase87ActorState {
															#line 96 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 87 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	FlowTestCase87ActorState(UnitTestParameters const& params) 
															#line 87 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 87 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : params(params)
															#line 103 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase87", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase87ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase87", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 88 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			std::vector<Key> keys;
															#line 89 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			for(Version version = 0;version < 1000;++version) {
															#line 90 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				for(int index = 0;index < 5;++index) {
															#line 91 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
					keys.push_back(versionedMutationKey(version, index));
															#line 124 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				}
			}
															#line 94 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			for(int i = 0;i < 5000;++i) {
															#line 95 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				ASSERT(getVersionFromVersionedMutationKey(keys[i]) == i / 5);
															#line 131 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			}
															#line 97 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<FlowTestCase87Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase87ActorState(); static_cast<FlowTestCase87Actor*>(this)->destroy(); return 0; }
															#line 135 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<FlowTestCase87Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase87ActorState();
			static_cast<FlowTestCase87Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase87ActorState();
		static_cast<FlowTestCase87Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 87 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	UnitTestParameters params;
															#line 159 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase87()
															#line 87 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class FlowTestCase87Actor final : public Actor<Void>, public FastAllocated<FlowTestCase87Actor>, public FlowTestCase87ActorState<FlowTestCase87Actor> {
															#line 164 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase87Actor>::operator new;
	using FastAllocated<FlowTestCase87Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14592844613230501632UL, 767018665559681280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 87 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	FlowTestCase87Actor(UnitTestParameters const& params) 
															#line 180 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase87ActorState<FlowTestCase87Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase87", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4250082369217772544UL, 22910182183901952UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase87Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase87");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase87", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 87 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
static Future<Void> flowTestCase87( UnitTestParameters const& params ) {
															#line 87 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Void>(new FlowTestCase87Actor(params));
															#line 212 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase87, "/fdbserver/ConfigDB/ConfigNode/Internal/versionedMutationKeys")

#line 99 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

															#line 218 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase100()
															#line 100 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class FlowTestCase100Actor>
															#line 100 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class FlowTestCase100ActorState {
															#line 225 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 100 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	FlowTestCase100ActorState(UnitTestParameters const& params) 
															#line 100 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 100 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : params(params)
															#line 232 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase100", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase100ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase100", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 101 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			Standalone<VectorRef<KeyRef>> keys;
															#line 102 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			for(Version version = 0;version < 1000;++version) {
															#line 103 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				for(auto index = 0;index < 5;++index) {
															#line 104 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
					keys.push_back_deep(keys.arena(), versionedMutationKey(version, index));
															#line 253 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				}
			}
															#line 107 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			for(auto index = 0;index < 1000;++index) {
															#line 108 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				keys.push_back_deep(keys.arena(), versionedMutationKey(1000, index));
															#line 260 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			}
															#line 110 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			ASSERT(std::is_sorted(keys.begin(), keys.end()));
															#line 111 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<FlowTestCase100Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase100ActorState(); static_cast<FlowTestCase100Actor*>(this)->destroy(); return 0; }
															#line 266 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<FlowTestCase100Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase100ActorState();
			static_cast<FlowTestCase100Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase100ActorState();
		static_cast<FlowTestCase100Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 100 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	UnitTestParameters params;
															#line 290 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase100()
															#line 100 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class FlowTestCase100Actor final : public Actor<Void>, public FastAllocated<FlowTestCase100Actor>, public FlowTestCase100ActorState<FlowTestCase100Actor> {
															#line 295 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase100Actor>::operator new;
	using FastAllocated<FlowTestCase100Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10529282793176611584UL, 10543868578722475008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 100 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	FlowTestCase100Actor(UnitTestParameters const& params) 
															#line 311 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase100ActorState<FlowTestCase100Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase100", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7767623568397130752UL, 10142944152451360768UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase100Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase100");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase100", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 100 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
static Future<Void> flowTestCase100( UnitTestParameters const& params ) {
															#line 100 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Void>(new FlowTestCase100Actor(params));
															#line 343 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase100, "/fdbserver/ConfigDB/ConfigNode/Internal/versionedMutationKeyOrdering")

#line 113 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

class ConfigNodeImpl {
	UID id;
	FlowLock lock;
	OnDemandStore kvStore;
	CounterCollection cc;

	// Follower counters
	Counter compactRequests;
	Counter rollbackRequests;
	Counter rollforwardRequests;
	Counter successfulChangeRequests;
	Counter failedChangeRequests;
	Counter snapshotRequests;
	Counter getCommittedVersionRequests;
	Counter lockRequests;

	// Transaction counters
	Counter successfulCommits;
	Counter failedCommits;
	Counter setMutations;
	Counter clearMutations;
	Counter getValueRequests;
	Counter getGenerationRequests;
	Future<Void> logger;

																#line 374 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via getCoordinatorsHash()
															#line 139 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class GetCoordinatorsHashActor>
															#line 139 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetCoordinatorsHashActorState {
															#line 380 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 139 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetCoordinatorsHashActorState(ConfigNodeImpl* const& self) 
															#line 139 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 139 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   coordinatorsHash(0)
															#line 389 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("getCoordinatorsHash", reinterpret_cast<unsigned long>(this));

	}
	~GetCoordinatorsHashActorState() 
	{
		fdb_probe_actor_destroy("getCoordinatorsHash", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 141 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = self->kvStore->readValue(coordinatorsHashKey);
															#line 141 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetCoordinatorsHashActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 406 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetCoordinatorsHashActor*>(this)->actor_wait_state = 1;
															#line 141 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCoordinatorsHashActor, 0, Optional<Value> >*>(static_cast<GetCoordinatorsHashActor*>(this)));
															#line 411 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCoordinatorsHashActorState();
		static_cast<GetCoordinatorsHashActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& value,int loopDepth) 
	{
															#line 142 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (value.present())
															#line 434 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 143 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			coordinatorsHash = BinaryReader::fromStringRef<CoordinatorsHash>(value.get(), IncludeVersion());
															#line 438 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}
		else
		{
															#line 145 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			self->kvStore->set( KeyValueRef(coordinatorsHashKey, BinaryWriter::toValue(coordinatorsHash, IncludeVersion())));
															#line 147 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->kvStore->commit();
															#line 147 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetCoordinatorsHashActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 449 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetCoordinatorsHashActor*>(this)->actor_wait_state = 2;
															#line 147 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetCoordinatorsHashActor, 1, Void >*>(static_cast<GetCoordinatorsHashActor*>(this)));
															#line 454 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && value,int loopDepth) 
	{
															#line 142 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (value.present())
															#line 464 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 143 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			coordinatorsHash = BinaryReader::fromStringRef<CoordinatorsHash>(value.get(), IncludeVersion());
															#line 468 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}
		else
		{
															#line 145 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			self->kvStore->set( KeyValueRef(coordinatorsHashKey, BinaryWriter::toValue(coordinatorsHash, IncludeVersion())));
															#line 147 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->kvStore->commit();
															#line 147 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetCoordinatorsHashActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 479 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetCoordinatorsHashActor*>(this)->actor_wait_state = 2;
															#line 147 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetCoordinatorsHashActor, 1, Void >*>(static_cast<GetCoordinatorsHashActor*>(this)));
															#line 484 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1cont1(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCoordinatorsHashActor*>(this)->actor_wait_state > 0) static_cast<GetCoordinatorsHashActor*>(this)->actor_wait_state = 0;
		static_cast<GetCoordinatorsHashActor*>(this)->ActorCallback< GetCoordinatorsHashActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetCoordinatorsHashActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getCoordinatorsHash", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordinatorsHashActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordinatorsHash", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCoordinatorsHashActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getCoordinatorsHash", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordinatorsHashActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordinatorsHash", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCoordinatorsHashActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getCoordinatorsHash", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordinatorsHashActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordinatorsHash", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 149 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetCoordinatorsHashActor*>(this)->SAV<CoordinatorsHash>::futures) { (void)(coordinatorsHash); this->~GetCoordinatorsHashActorState(); static_cast<GetCoordinatorsHashActor*>(this)->destroy(); return 0; }
															#line 569 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetCoordinatorsHashActor*>(this)->SAV< CoordinatorsHash >::value()) CoordinatorsHash(std::move(coordinatorsHash)); // state_var_RVO
		this->~GetCoordinatorsHashActorState();
		static_cast<GetCoordinatorsHashActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetCoordinatorsHashActor*>(this)->actor_wait_state > 0) static_cast<GetCoordinatorsHashActor*>(this)->actor_wait_state = 0;
		static_cast<GetCoordinatorsHashActor*>(this)->ActorCallback< GetCoordinatorsHashActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCoordinatorsHashActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCoordinatorsHash", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordinatorsHashActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordinatorsHash", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetCoordinatorsHashActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCoordinatorsHash", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordinatorsHashActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordinatorsHash", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetCoordinatorsHashActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCoordinatorsHash", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordinatorsHashActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordinatorsHash", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 139 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	CoordinatorsHash coordinatorsHash;
															#line 668 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via getCoordinatorsHash()
															#line 139 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetCoordinatorsHashActor final : public Actor<CoordinatorsHash>, public ActorCallback< GetCoordinatorsHashActor, 0, Optional<Value> >, public ActorCallback< GetCoordinatorsHashActor, 1, Void >, public FastAllocated<GetCoordinatorsHashActor>, public GetCoordinatorsHashActorState<GetCoordinatorsHashActor> {
															#line 673 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<GetCoordinatorsHashActor>::operator new;
	using FastAllocated<GetCoordinatorsHashActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7890820315619309824UL, 17958450807603498240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<CoordinatorsHash>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCoordinatorsHashActor, 0, Optional<Value> >;
friend struct ActorCallback< GetCoordinatorsHashActor, 1, Void >;
															#line 139 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetCoordinatorsHashActor(ConfigNodeImpl* const& self) 
															#line 691 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<CoordinatorsHash>(),
		   GetCoordinatorsHashActorState<GetCoordinatorsHashActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCoordinatorsHash", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18016726812489010944UL, 3367458428040256256UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordinatorsHashActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCoordinatorsHash");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCoordinatorsHash", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCoordinatorsHashActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetCoordinatorsHashActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 139 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<CoordinatorsHash> getCoordinatorsHash( ConfigNodeImpl* const& self ) {
															#line 139 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<CoordinatorsHash>(new GetCoordinatorsHashActor(self));
															#line 724 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 151 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

																#line 729 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via getLocked()
															#line 152 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class GetLockedActor>
															#line 152 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetLockedActorState {
															#line 735 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 152 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetLockedActorState(ConfigNodeImpl* const& self) 
															#line 152 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 152 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self)
															#line 742 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("getLocked", reinterpret_cast<unsigned long>(this));

	}
	~GetLockedActorState() 
	{
		fdb_probe_actor_destroy("getLocked", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 153 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = self->kvStore->readValue(lockedKey);
															#line 153 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetLockedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 759 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetLockedActor*>(this)->actor_wait_state = 1;
															#line 153 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetLockedActor, 0, Optional<Value> >*>(static_cast<GetLockedActor*>(this)));
															#line 764 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetLockedActorState();
		static_cast<GetLockedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& value,int loopDepth) 
	{
															#line 154 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!value.present())
															#line 787 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 155 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetLockedActor*>(this)->SAV<Optional<CoordinatorsHash>>::futures) { (void)(Optional<CoordinatorsHash>()); this->~GetLockedActorState(); static_cast<GetLockedActor*>(this)->destroy(); return 0; }
															#line 791 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetLockedActor*>(this)->SAV< Optional<CoordinatorsHash> >::value()) Optional<CoordinatorsHash>(Optional<CoordinatorsHash>());
			this->~GetLockedActorState();
			static_cast<GetLockedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 157 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetLockedActor*>(this)->SAV<Optional<CoordinatorsHash>>::futures) { (void)(BinaryReader::fromStringRef<Optional<CoordinatorsHash>>(value.get(), IncludeVersion())); this->~GetLockedActorState(); static_cast<GetLockedActor*>(this)->destroy(); return 0; }
															#line 799 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetLockedActor*>(this)->SAV< Optional<CoordinatorsHash> >::value()) Optional<CoordinatorsHash>(BinaryReader::fromStringRef<Optional<CoordinatorsHash>>(value.get(), IncludeVersion()));
		this->~GetLockedActorState();
		static_cast<GetLockedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && value,int loopDepth) 
	{
															#line 154 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!value.present())
															#line 811 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 155 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetLockedActor*>(this)->SAV<Optional<CoordinatorsHash>>::futures) { (void)(Optional<CoordinatorsHash>()); this->~GetLockedActorState(); static_cast<GetLockedActor*>(this)->destroy(); return 0; }
															#line 815 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetLockedActor*>(this)->SAV< Optional<CoordinatorsHash> >::value()) Optional<CoordinatorsHash>(Optional<CoordinatorsHash>());
			this->~GetLockedActorState();
			static_cast<GetLockedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 157 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetLockedActor*>(this)->SAV<Optional<CoordinatorsHash>>::futures) { (void)(BinaryReader::fromStringRef<Optional<CoordinatorsHash>>(value.get(), IncludeVersion())); this->~GetLockedActorState(); static_cast<GetLockedActor*>(this)->destroy(); return 0; }
															#line 823 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetLockedActor*>(this)->SAV< Optional<CoordinatorsHash> >::value()) Optional<CoordinatorsHash>(BinaryReader::fromStringRef<Optional<CoordinatorsHash>>(value.get(), IncludeVersion()));
		this->~GetLockedActorState();
		static_cast<GetLockedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1cont1(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetLockedActor*>(this)->actor_wait_state > 0) static_cast<GetLockedActor*>(this)->actor_wait_state = 0;
		static_cast<GetLockedActor*>(this)->ActorCallback< GetLockedActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetLockedActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getLocked", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLocked", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetLockedActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getLocked", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLocked", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetLockedActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getLocked", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLocked", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 152 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 908 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via getLocked()
															#line 152 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetLockedActor final : public Actor<Optional<CoordinatorsHash>>, public ActorCallback< GetLockedActor, 0, Optional<Value> >, public FastAllocated<GetLockedActor>, public GetLockedActorState<GetLockedActor> {
															#line 913 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<GetLockedActor>::operator new;
	using FastAllocated<GetLockedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1143391513089462272UL, 12025720935464884992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<CoordinatorsHash>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetLockedActor, 0, Optional<Value> >;
															#line 152 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetLockedActor(ConfigNodeImpl* const& self) 
															#line 930 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Optional<CoordinatorsHash>>(),
		   GetLockedActorState<GetLockedActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getLocked", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17721421054047160320UL, 11072062696242353920UL);
		ActorExecutionContextHelper __helper(static_cast<GetLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getLocked");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getLocked", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetLockedActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 152 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Optional<CoordinatorsHash>> getLocked( ConfigNodeImpl* const& self ) {
															#line 152 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Optional<CoordinatorsHash>>(new GetLockedActor(self));
															#line 962 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 159 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

																#line 967 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via getGeneration()
															#line 160 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class GetGenerationActor>
															#line 160 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetGenerationActorState {
															#line 973 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 160 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetGenerationActorState(ConfigNodeImpl* const& self) 
															#line 160 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 160 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 161 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   generation()
															#line 982 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("getGeneration", reinterpret_cast<unsigned long>(this));

	}
	~GetGenerationActorState() 
	{
		fdb_probe_actor_destroy("getGeneration", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 162 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = self->kvStore->readValue(currentGenerationKey);
															#line 162 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetGenerationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 999 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetGenerationActor*>(this)->actor_wait_state = 1;
															#line 162 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetGenerationActor, 0, Optional<Value> >*>(static_cast<GetGenerationActor*>(this)));
															#line 1004 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetGenerationActorState();
		static_cast<GetGenerationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& value,int loopDepth) 
	{
															#line 163 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (value.present())
															#line 1027 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 164 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			generation = BinaryReader::fromStringRef<ConfigGeneration>(value.get(), IncludeVersion());
															#line 1031 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}
		else
		{
															#line 166 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			self->kvStore->set(KeyValueRef(currentGenerationKey, BinaryWriter::toValue(generation, IncludeVersion())));
															#line 167 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->kvStore->commit();
															#line 167 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetGenerationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1042 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetGenerationActor*>(this)->actor_wait_state = 2;
															#line 167 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetGenerationActor, 1, Void >*>(static_cast<GetGenerationActor*>(this)));
															#line 1047 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && value,int loopDepth) 
	{
															#line 163 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (value.present())
															#line 1057 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 164 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			generation = BinaryReader::fromStringRef<ConfigGeneration>(value.get(), IncludeVersion());
															#line 1061 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}
		else
		{
															#line 166 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			self->kvStore->set(KeyValueRef(currentGenerationKey, BinaryWriter::toValue(generation, IncludeVersion())));
															#line 167 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->kvStore->commit();
															#line 167 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetGenerationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1072 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetGenerationActor*>(this)->actor_wait_state = 2;
															#line 167 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetGenerationActor, 1, Void >*>(static_cast<GetGenerationActor*>(this)));
															#line 1077 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1cont1(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetGenerationActor*>(this)->actor_wait_state > 0) static_cast<GetGenerationActor*>(this)->actor_wait_state = 0;
		static_cast<GetGenerationActor*>(this)->ActorCallback< GetGenerationActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetGenerationActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getGeneration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetGenerationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGeneration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetGenerationActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getGeneration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetGenerationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGeneration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetGenerationActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getGeneration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetGenerationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGeneration", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 169 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetGenerationActor*>(this)->SAV<ConfigGeneration>::futures) { (void)(generation); this->~GetGenerationActorState(); static_cast<GetGenerationActor*>(this)->destroy(); return 0; }
															#line 1162 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetGenerationActor*>(this)->SAV< ConfigGeneration >::value()) ConfigGeneration(std::move(generation)); // state_var_RVO
		this->~GetGenerationActorState();
		static_cast<GetGenerationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetGenerationActor*>(this)->actor_wait_state > 0) static_cast<GetGenerationActor*>(this)->actor_wait_state = 0;
		static_cast<GetGenerationActor*>(this)->ActorCallback< GetGenerationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetGenerationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getGeneration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetGenerationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGeneration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetGenerationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getGeneration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetGenerationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGeneration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetGenerationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getGeneration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetGenerationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGeneration", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 160 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 161 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigGeneration generation;
															#line 1261 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via getGeneration()
															#line 160 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetGenerationActor final : public Actor<ConfigGeneration>, public ActorCallback< GetGenerationActor, 0, Optional<Value> >, public ActorCallback< GetGenerationActor, 1, Void >, public FastAllocated<GetGenerationActor>, public GetGenerationActorState<GetGenerationActor> {
															#line 1266 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<GetGenerationActor>::operator new;
	using FastAllocated<GetGenerationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2631436720772138496UL, 14666873586238577920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ConfigGeneration>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetGenerationActor, 0, Optional<Value> >;
friend struct ActorCallback< GetGenerationActor, 1, Void >;
															#line 160 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetGenerationActor(ConfigNodeImpl* const& self) 
															#line 1284 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<ConfigGeneration>(),
		   GetGenerationActorState<GetGenerationActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getGeneration", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11581383953863702784UL, 9468050620997055232UL);
		ActorExecutionContextHelper __helper(static_cast<GetGenerationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getGeneration");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getGeneration", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetGenerationActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetGenerationActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 160 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<ConfigGeneration> getGeneration( ConfigNodeImpl* const& self ) {
															#line 160 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<ConfigGeneration>(new GetGenerationActor(self));
															#line 1317 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 171 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

																#line 1322 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via getLastCompactedVersion()
															#line 172 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class GetLastCompactedVersionActor>
															#line 172 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetLastCompactedVersionActorState {
															#line 1328 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 172 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetLastCompactedVersionActorState(ConfigNodeImpl* const& self) 
															#line 172 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 172 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self)
															#line 1335 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("getLastCompactedVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetLastCompactedVersionActorState() 
	{
		fdb_probe_actor_destroy("getLastCompactedVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 173 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = self->kvStore->readValue(lastCompactedVersionKey);
															#line 173 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetLastCompactedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1352 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetLastCompactedVersionActor*>(this)->actor_wait_state = 1;
															#line 173 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetLastCompactedVersionActor, 0, Optional<Value> >*>(static_cast<GetLastCompactedVersionActor*>(this)));
															#line 1357 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetLastCompactedVersionActorState();
		static_cast<GetLastCompactedVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& value,int loopDepth) 
	{
															#line 174 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		lastCompactedVersion = 0;
															#line 175 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (value.present())
															#line 1382 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 176 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			lastCompactedVersion = BinaryReader::fromStringRef<Version>(value.get(), IncludeVersion());
															#line 1386 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}
		else
		{
															#line 178 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			self->kvStore->set( KeyValueRef(lastCompactedVersionKey, BinaryWriter::toValue(lastCompactedVersion, IncludeVersion())));
															#line 180 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->kvStore->commit();
															#line 180 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetLastCompactedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1397 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetLastCompactedVersionActor*>(this)->actor_wait_state = 2;
															#line 180 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetLastCompactedVersionActor, 1, Void >*>(static_cast<GetLastCompactedVersionActor*>(this)));
															#line 1402 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && value,int loopDepth) 
	{
															#line 174 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		lastCompactedVersion = 0;
															#line 175 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (value.present())
															#line 1414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 176 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			lastCompactedVersion = BinaryReader::fromStringRef<Version>(value.get(), IncludeVersion());
															#line 1418 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}
		else
		{
															#line 178 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			self->kvStore->set( KeyValueRef(lastCompactedVersionKey, BinaryWriter::toValue(lastCompactedVersion, IncludeVersion())));
															#line 180 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->kvStore->commit();
															#line 180 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetLastCompactedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1429 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetLastCompactedVersionActor*>(this)->actor_wait_state = 2;
															#line 180 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetLastCompactedVersionActor, 1, Void >*>(static_cast<GetLastCompactedVersionActor*>(this)));
															#line 1434 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1cont1(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetLastCompactedVersionActor*>(this)->actor_wait_state > 0) static_cast<GetLastCompactedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetLastCompactedVersionActor*>(this)->ActorCallback< GetLastCompactedVersionActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetLastCompactedVersionActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getLastCompactedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastCompactedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastCompactedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetLastCompactedVersionActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getLastCompactedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastCompactedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastCompactedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetLastCompactedVersionActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getLastCompactedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastCompactedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastCompactedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 182 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetLastCompactedVersionActor*>(this)->SAV<Version>::futures) { (void)(lastCompactedVersion); this->~GetLastCompactedVersionActorState(); static_cast<GetLastCompactedVersionActor*>(this)->destroy(); return 0; }
															#line 1519 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetLastCompactedVersionActor*>(this)->SAV< Version >::value()) Version(std::move(lastCompactedVersion)); // state_var_RVO
		this->~GetLastCompactedVersionActorState();
		static_cast<GetLastCompactedVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetLastCompactedVersionActor*>(this)->actor_wait_state > 0) static_cast<GetLastCompactedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetLastCompactedVersionActor*>(this)->ActorCallback< GetLastCompactedVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetLastCompactedVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getLastCompactedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastCompactedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastCompactedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetLastCompactedVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getLastCompactedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastCompactedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastCompactedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetLastCompactedVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getLastCompactedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastCompactedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastCompactedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 172 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 174 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Version lastCompactedVersion;
															#line 1618 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via getLastCompactedVersion()
															#line 172 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetLastCompactedVersionActor final : public Actor<Version>, public ActorCallback< GetLastCompactedVersionActor, 0, Optional<Value> >, public ActorCallback< GetLastCompactedVersionActor, 1, Void >, public FastAllocated<GetLastCompactedVersionActor>, public GetLastCompactedVersionActorState<GetLastCompactedVersionActor> {
															#line 1623 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<GetLastCompactedVersionActor>::operator new;
	using FastAllocated<GetLastCompactedVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(670411903326750208UL, 5037820248092532736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetLastCompactedVersionActor, 0, Optional<Value> >;
friend struct ActorCallback< GetLastCompactedVersionActor, 1, Void >;
															#line 172 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetLastCompactedVersionActor(ConfigNodeImpl* const& self) 
															#line 1641 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Version>(),
		   GetLastCompactedVersionActorState<GetLastCompactedVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getLastCompactedVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5179416313390651136UL, 178503970073555712UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastCompactedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getLastCompactedVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getLastCompactedVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetLastCompactedVersionActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetLastCompactedVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 172 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Version> getLastCompactedVersion( ConfigNodeImpl* const& self ) {
															#line 172 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Version>(new GetLastCompactedVersionActor(self));
															#line 1674 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 184 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

	// Returns all commit annotations between for commits with version in [startVersion, endVersion]
																#line 1680 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via getAnnotations()
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class GetAnnotationsActor>
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetAnnotationsActorState {
															#line 1686 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetAnnotationsActorState(ConfigNodeImpl* const& self,Version const& startVersion,Version const& endVersion) 
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   startVersion(startVersion),
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   endVersion(endVersion)
															#line 1697 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("getAnnotations", reinterpret_cast<unsigned long>(this));

	}
	~GetAnnotationsActorState() 
	{
		fdb_probe_actor_destroy("getAnnotations", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 189 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			Key startKey = versionedAnnotationKey(startVersion);
															#line 190 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			Key endKey = versionedAnnotationKey(endVersion + 1);
															#line 191 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			keys = KeyRangeRef(startKey, endKey);
															#line 192 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = self->kvStore->readRange(keys);
															#line 192 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetAnnotationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1720 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetAnnotationsActor*>(this)->actor_wait_state = 1;
															#line 192 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAnnotationsActor, 0, RangeResult >*>(static_cast<GetAnnotationsActor*>(this)));
															#line 1725 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAnnotationsActorState();
		static_cast<GetAnnotationsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& range,int loopDepth) 
	{
															#line 193 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> result;
															#line 194 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& kv : range ) {
															#line 195 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			auto version = getVersionFromVersionedAnnotationKey(kv.key);
															#line 196 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			ASSERT_LE(version, endVersion);
															#line 197 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			auto annotation = BinaryReader::fromStringRef<ConfigCommitAnnotation>(kv.value, IncludeVersion());
															#line 198 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			result.emplace_back_deep(result.arena(), version, annotation);
															#line 1758 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
															#line 200 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetAnnotationsActor*>(this)->SAV<Standalone<VectorRef<VersionedConfigCommitAnnotationRef>>>::futures) { (void)(result); this->~GetAnnotationsActorState(); static_cast<GetAnnotationsActor*>(this)->destroy(); return 0; }
															#line 1762 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetAnnotationsActor*>(this)->SAV< Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> >::value()) Standalone<VectorRef<VersionedConfigCommitAnnotationRef>>(result);
		this->~GetAnnotationsActorState();
		static_cast<GetAnnotationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && range,int loopDepth) 
	{
															#line 193 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> result;
															#line 194 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& kv : range ) {
															#line 195 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			auto version = getVersionFromVersionedAnnotationKey(kv.key);
															#line 196 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			ASSERT_LE(version, endVersion);
															#line 197 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			auto annotation = BinaryReader::fromStringRef<ConfigCommitAnnotation>(kv.value, IncludeVersion());
															#line 198 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			result.emplace_back_deep(result.arena(), version, annotation);
															#line 1784 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
															#line 200 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetAnnotationsActor*>(this)->SAV<Standalone<VectorRef<VersionedConfigCommitAnnotationRef>>>::futures) { (void)(result); this->~GetAnnotationsActorState(); static_cast<GetAnnotationsActor*>(this)->destroy(); return 0; }
															#line 1788 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetAnnotationsActor*>(this)->SAV< Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> >::value()) Standalone<VectorRef<VersionedConfigCommitAnnotationRef>>(result);
		this->~GetAnnotationsActorState();
		static_cast<GetAnnotationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& range,int loopDepth) 
	{
		loopDepth = a_body1cont1(range, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && range,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAnnotationsActor*>(this)->actor_wait_state > 0) static_cast<GetAnnotationsActor*>(this)->actor_wait_state = 0;
		static_cast<GetAnnotationsActor*>(this)->ActorCallback< GetAnnotationsActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetAnnotationsActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getAnnotations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAnnotationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAnnotations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAnnotationsActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getAnnotations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAnnotationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAnnotations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAnnotationsActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getAnnotations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAnnotationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAnnotations", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Version startVersion;
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Version endVersion;
															#line 191 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	KeyRangeRef keys;
															#line 1879 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via getAnnotations()
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetAnnotationsActor final : public Actor<Standalone<VectorRef<VersionedConfigCommitAnnotationRef>>>, public ActorCallback< GetAnnotationsActor, 0, RangeResult >, public FastAllocated<GetAnnotationsActor>, public GetAnnotationsActorState<GetAnnotationsActor> {
															#line 1884 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<GetAnnotationsActor>::operator new;
	using FastAllocated<GetAnnotationsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8773152208698401792UL, 10775758852126193152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<VersionedConfigCommitAnnotationRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAnnotationsActor, 0, RangeResult >;
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetAnnotationsActor(ConfigNodeImpl* const& self,Version const& startVersion,Version const& endVersion) 
															#line 1901 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Standalone<VectorRef<VersionedConfigCommitAnnotationRef>>>(),
		   GetAnnotationsActorState<GetAnnotationsActor>(self, startVersion, endVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAnnotations", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11073103611042708224UL, 7476572977380723712UL);
		ActorExecutionContextHelper __helper(static_cast<GetAnnotationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAnnotations");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAnnotations", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAnnotationsActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Standalone<VectorRef<VersionedConfigCommitAnnotationRef>>> getAnnotations( ConfigNodeImpl* const& self, Version const& startVersion, Version const& endVersion ) {
															#line 186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Standalone<VectorRef<VersionedConfigCommitAnnotationRef>>>(new GetAnnotationsActor(self, startVersion, endVersion));
															#line 1933 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 202 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

	// Returns all mutations with version in [startVersion, endVersion]
																#line 1939 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via getMutations()
															#line 204 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class GetMutationsActor>
															#line 204 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetMutationsActorState {
															#line 1945 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 204 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetMutationsActorState(ConfigNodeImpl* const& self,Version const& startVersion,Version const& endVersion) 
															#line 204 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 204 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 204 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   startVersion(startVersion),
															#line 204 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   endVersion(endVersion)
															#line 1956 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("getMutations", reinterpret_cast<unsigned long>(this));

	}
	~GetMutationsActorState() 
	{
		fdb_probe_actor_destroy("getMutations", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 207 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			Key startKey = versionedMutationKey(startVersion, 0);
															#line 208 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			Key endKey = versionedMutationKey(endVersion + 1, 0);
															#line 209 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			keys = KeyRangeRef(startKey, endKey);
															#line 210 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = self->kvStore->readRange(keys);
															#line 210 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetMutationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1979 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetMutationsActor*>(this)->actor_wait_state = 1;
															#line 210 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetMutationsActor, 0, RangeResult >*>(static_cast<GetMutationsActor*>(this)));
															#line 1984 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetMutationsActorState();
		static_cast<GetMutationsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& range,int loopDepth) 
	{
															#line 211 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		Standalone<VectorRef<VersionedConfigMutationRef>> result;
															#line 212 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& kv : range ) {
															#line 213 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			auto version = getVersionFromVersionedMutationKey(kv.key);
															#line 214 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			ASSERT_LE(version, endVersion);
															#line 215 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			auto mutation = ObjectReader::fromStringRef<ConfigMutation>(kv.value, IncludeVersion());
															#line 216 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			result.emplace_back_deep(result.arena(), version, mutation);
															#line 2017 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
															#line 218 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetMutationsActor*>(this)->SAV<Standalone<VectorRef<VersionedConfigMutationRef>>>::futures) { (void)(result); this->~GetMutationsActorState(); static_cast<GetMutationsActor*>(this)->destroy(); return 0; }
															#line 2021 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetMutationsActor*>(this)->SAV< Standalone<VectorRef<VersionedConfigMutationRef>> >::value()) Standalone<VectorRef<VersionedConfigMutationRef>>(result);
		this->~GetMutationsActorState();
		static_cast<GetMutationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && range,int loopDepth) 
	{
															#line 211 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		Standalone<VectorRef<VersionedConfigMutationRef>> result;
															#line 212 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& kv : range ) {
															#line 213 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			auto version = getVersionFromVersionedMutationKey(kv.key);
															#line 214 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			ASSERT_LE(version, endVersion);
															#line 215 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			auto mutation = ObjectReader::fromStringRef<ConfigMutation>(kv.value, IncludeVersion());
															#line 216 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			result.emplace_back_deep(result.arena(), version, mutation);
															#line 2043 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
															#line 218 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetMutationsActor*>(this)->SAV<Standalone<VectorRef<VersionedConfigMutationRef>>>::futures) { (void)(result); this->~GetMutationsActorState(); static_cast<GetMutationsActor*>(this)->destroy(); return 0; }
															#line 2047 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetMutationsActor*>(this)->SAV< Standalone<VectorRef<VersionedConfigMutationRef>> >::value()) Standalone<VectorRef<VersionedConfigMutationRef>>(result);
		this->~GetMutationsActorState();
		static_cast<GetMutationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& range,int loopDepth) 
	{
		loopDepth = a_body1cont1(range, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && range,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetMutationsActor*>(this)->actor_wait_state > 0) static_cast<GetMutationsActor*>(this)->actor_wait_state = 0;
		static_cast<GetMutationsActor*>(this)->ActorCallback< GetMutationsActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetMutationsActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetMutationsActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetMutationsActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMutations", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 204 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 204 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Version startVersion;
															#line 204 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Version endVersion;
															#line 209 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	KeyRangeRef keys;
															#line 2138 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via getMutations()
															#line 204 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetMutationsActor final : public Actor<Standalone<VectorRef<VersionedConfigMutationRef>>>, public ActorCallback< GetMutationsActor, 0, RangeResult >, public FastAllocated<GetMutationsActor>, public GetMutationsActorState<GetMutationsActor> {
															#line 2143 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<GetMutationsActor>::operator new;
	using FastAllocated<GetMutationsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(594961200586951936UL, 2624804601989452288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<VersionedConfigMutationRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetMutationsActor, 0, RangeResult >;
															#line 204 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetMutationsActor(ConfigNodeImpl* const& self,Version const& startVersion,Version const& endVersion) 
															#line 2160 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Standalone<VectorRef<VersionedConfigMutationRef>>>(),
		   GetMutationsActorState<GetMutationsActor>(self, startVersion, endVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getMutations", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1150212450758732544UL, 10029264348870618624UL);
		ActorExecutionContextHelper __helper(static_cast<GetMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getMutations");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getMutations", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetMutationsActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 204 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Standalone<VectorRef<VersionedConfigMutationRef>>> getMutations( ConfigNodeImpl* const& self, Version const& startVersion, Version const& endVersion ) {
															#line 204 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Standalone<VectorRef<VersionedConfigMutationRef>>>(new GetMutationsActor(self, startVersion, endVersion));
															#line 2192 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 220 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

																#line 2197 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via getChanges()
															#line 221 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class GetChangesActor>
															#line 221 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetChangesActorState {
															#line 2203 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 221 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetChangesActorState(ConfigNodeImpl* const& self,ConfigFollowerGetChangesRequest const& req) 
															#line 221 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 221 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 221 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   req(req)
															#line 2212 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("getChanges", reinterpret_cast<unsigned long>(this));

	}
	~GetChangesActorState() 
	{
		fdb_probe_actor_destroy("getChanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 222 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->lock.take();
															#line 222 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2229 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetChangesActor*>(this)->actor_wait_state = 1;
															#line 222 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetChangesActor, 0, Void >*>(static_cast<GetChangesActor*>(this)));
															#line 2234 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetChangesActorState();
		static_cast<GetChangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 223 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		releaser = FlowLock::Releaser(self->lock);
															#line 224 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Version> __when_expr_1 = getLastCompactedVersion(self);
															#line 224 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2261 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetChangesActor*>(this)->actor_wait_state = 2;
															#line 224 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetChangesActor, 1, Version >*>(static_cast<GetChangesActor*>(this)));
															#line 2266 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 223 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		releaser = FlowLock::Releaser(self->lock);
															#line 224 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Version> __when_expr_1 = getLastCompactedVersion(self);
															#line 224 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2279 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetChangesActor*>(this)->actor_wait_state = 2;
															#line 224 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetChangesActor, 1, Version >*>(static_cast<GetChangesActor*>(this)));
															#line 2284 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetChangesActor*>(this)->actor_wait_state > 0) static_cast<GetChangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetChangesActor*>(this)->ActorCallback< GetChangesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetChangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetChangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetChangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Version const& lastCompactedVersion,int loopDepth) 
	{
															#line 225 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.lastSeenVersion < lastCompactedVersion)
															#line 2368 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 226 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			++self->failedChangeRequests;
															#line 227 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(version_already_compacted());
															#line 228 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetChangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetChangesActorState(); static_cast<GetChangesActor*>(this)->destroy(); return 0; }
															#line 2376 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetChangesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetChangesActorState();
			static_cast<GetChangesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 230 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Version> __when_expr_2 = map(getGeneration(self), [](auto const& gen) { return gen.committedVersion; });
															#line 230 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2386 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetChangesActor*>(this)->actor_wait_state = 3;
															#line 230 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetChangesActor, 2, Version >*>(static_cast<GetChangesActor*>(this)));
															#line 2391 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Version && lastCompactedVersion,int loopDepth) 
	{
															#line 225 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.lastSeenVersion < lastCompactedVersion)
															#line 2400 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 226 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			++self->failedChangeRequests;
															#line 227 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(version_already_compacted());
															#line 228 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetChangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetChangesActorState(); static_cast<GetChangesActor*>(this)->destroy(); return 0; }
															#line 2408 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetChangesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetChangesActorState();
			static_cast<GetChangesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 230 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Version> __when_expr_2 = map(getGeneration(self), [](auto const& gen) { return gen.committedVersion; });
															#line 230 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2418 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetChangesActor*>(this)->actor_wait_state = 3;
															#line 230 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetChangesActor, 2, Version >*>(static_cast<GetChangesActor*>(this)));
															#line 2423 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Version const& lastCompactedVersion,int loopDepth) 
	{
		loopDepth = a_body1cont2(lastCompactedVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Version && lastCompactedVersion,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(lastCompactedVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetChangesActor*>(this)->actor_wait_state > 0) static_cast<GetChangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetChangesActor*>(this)->ActorCallback< GetChangesActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetChangesActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetChangesActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetChangesActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 232 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (committedVersion < req.mostRecentVersion)
															#line 2507 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 236 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			CODE_PROBE(true, "ConfigNode data loss occurred on a minority of coordinators", probe::decoration::rare);
															#line 237 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(process_behind());
															#line 238 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetChangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetChangesActorState(); static_cast<GetChangesActor*>(this)->destroy(); return 0; }
															#line 2515 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetChangesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetChangesActorState();
			static_cast<GetChangesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 240 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (BUGGIFY)
															#line 2523 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 241 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(deterministicRandom()->random01() * 2);
															#line 241 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2529 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<GetChangesActor*>(this)->actor_wait_state = 4;
															#line 241 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetChangesActor, 3, Void >*>(static_cast<GetChangesActor*>(this)));
															#line 2534 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(Version const& __committedVersion,int loopDepth) 
	{
															#line 230 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		committedVersion = __committedVersion;
															#line 2548 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Version && __committedVersion,int loopDepth) 
	{
		committedVersion = std::move(__committedVersion);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetChangesActor*>(this)->actor_wait_state > 0) static_cast<GetChangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetChangesActor*>(this)->ActorCallback< GetChangesActor, 2, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetChangesActor, 2, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetChangesActor, 2, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetChangesActor, 2, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 243 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Standalone<VectorRef<VersionedConfigMutationRef>>> __when_expr_4 = getMutations(self, req.lastSeenVersion + 1, req.mostRecentVersion);
															#line 243 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2629 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<GetChangesActor*>(this)->actor_wait_state = 5;
															#line 243 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetChangesActor, 4, Standalone<VectorRef<VersionedConfigMutationRef>> >*>(static_cast<GetChangesActor*>(this)));
															#line 2634 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetChangesActor*>(this)->actor_wait_state > 0) static_cast<GetChangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetChangesActor*>(this)->ActorCallback< GetChangesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetChangesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetChangesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetChangesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 245 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Standalone<VectorRef<VersionedConfigCommitAnnotationRef>>> __when_expr_5 = getAnnotations(self, req.lastSeenVersion + 1, req.mostRecentVersion);
															#line 245 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2732 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<GetChangesActor*>(this)->actor_wait_state = 6;
															#line 245 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GetChangesActor, 5, Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> >*>(static_cast<GetChangesActor*>(this)));
															#line 2737 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Standalone<VectorRef<VersionedConfigMutationRef>> const& __versionedMutations,int loopDepth) 
	{
															#line 243 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		versionedMutations = __versionedMutations;
															#line 2746 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Standalone<VectorRef<VersionedConfigMutationRef>> && __versionedMutations,int loopDepth) 
	{
		versionedMutations = std::move(__versionedMutations);
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetChangesActor*>(this)->actor_wait_state > 0) static_cast<GetChangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetChangesActor*>(this)->ActorCallback< GetChangesActor, 4, Standalone<VectorRef<VersionedConfigMutationRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetChangesActor, 4, Standalone<VectorRef<VersionedConfigMutationRef>> >*,Standalone<VectorRef<VersionedConfigMutationRef>> const& value) 
	{
		fdb_probe_actor_enter("getChanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getChanges", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetChangesActor, 4, Standalone<VectorRef<VersionedConfigMutationRef>> >*,Standalone<VectorRef<VersionedConfigMutationRef>> && value) 
	{
		fdb_probe_actor_enter("getChanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getChanges", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetChangesActor, 4, Standalone<VectorRef<VersionedConfigMutationRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("getChanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getChanges", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 247 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		TraceEvent(SevInfo, "ConfigNodeSendingChanges", self->id) .detail("ReqLastSeenVersion", req.lastSeenVersion) .detail("ReqMostRecentVersion", req.mostRecentVersion) .detail("CommittedVersion", committedVersion) .detail("NumMutations", versionedMutations.size()) .detail("NumCommits", versionedAnnotations.size());
															#line 253 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		++self->successfulChangeRequests;
															#line 254 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(ConfigFollowerGetChangesReply{ versionedMutations, versionedAnnotations });
															#line 255 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetChangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetChangesActorState(); static_cast<GetChangesActor*>(this)->destroy(); return 0; }
															#line 2831 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetChangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetChangesActorState();
		static_cast<GetChangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8when1(Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> const& __versionedAnnotations,int loopDepth) 
	{
															#line 245 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		versionedAnnotations = __versionedAnnotations;
															#line 2843 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> && __versionedAnnotations,int loopDepth) 
	{
		versionedAnnotations = std::move(__versionedAnnotations);
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GetChangesActor*>(this)->actor_wait_state > 0) static_cast<GetChangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetChangesActor*>(this)->ActorCallback< GetChangesActor, 5, Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetChangesActor, 5, Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> >*,Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> const& value) 
	{
		fdb_probe_actor_enter("getChanges", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getChanges", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< GetChangesActor, 5, Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> >*,Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> && value) 
	{
		fdb_probe_actor_enter("getChanges", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getChanges", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< GetChangesActor, 5, Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("getChanges", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getChanges", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 221 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 221 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigFollowerGetChangesRequest req;
															#line 223 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	FlowLock::Releaser releaser;
															#line 230 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Version committedVersion;
															#line 243 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Standalone<VectorRef<VersionedConfigMutationRef>> versionedMutations;
															#line 245 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> versionedAnnotations;
															#line 2930 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via getChanges()
															#line 221 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetChangesActor final : public Actor<Void>, public ActorCallback< GetChangesActor, 0, Void >, public ActorCallback< GetChangesActor, 1, Version >, public ActorCallback< GetChangesActor, 2, Version >, public ActorCallback< GetChangesActor, 3, Void >, public ActorCallback< GetChangesActor, 4, Standalone<VectorRef<VersionedConfigMutationRef>> >, public ActorCallback< GetChangesActor, 5, Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> >, public FastAllocated<GetChangesActor>, public GetChangesActorState<GetChangesActor> {
															#line 2935 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<GetChangesActor>::operator new;
	using FastAllocated<GetChangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13251999406940586496UL, 13326689516168009728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetChangesActor, 0, Void >;
friend struct ActorCallback< GetChangesActor, 1, Version >;
friend struct ActorCallback< GetChangesActor, 2, Version >;
friend struct ActorCallback< GetChangesActor, 3, Void >;
friend struct ActorCallback< GetChangesActor, 4, Standalone<VectorRef<VersionedConfigMutationRef>> >;
friend struct ActorCallback< GetChangesActor, 5, Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> >;
															#line 221 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetChangesActor(ConfigNodeImpl* const& self,ConfigFollowerGetChangesRequest const& req) 
															#line 2957 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Void>(),
		   GetChangesActorState<GetChangesActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getChanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8078308681288144128UL, 1017691229304363520UL);
		ActorExecutionContextHelper __helper(static_cast<GetChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getChanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getChanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetChangesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetChangesActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetChangesActor, 2, Version >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetChangesActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetChangesActor, 4, Standalone<VectorRef<VersionedConfigMutationRef>> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GetChangesActor, 5, Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 221 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Void> getChanges( ConfigNodeImpl* const& self, ConfigFollowerGetChangesRequest const& req ) {
															#line 221 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Void>(new GetChangesActor(self, req));
															#line 2994 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 257 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

	// New transactions increment the database's current live version. This effectively serves as a lock, providing
	// serializability
																#line 3001 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via getNewGeneration()
															#line 260 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class GetNewGenerationActor>
															#line 260 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetNewGenerationActorState {
															#line 3007 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 260 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetNewGenerationActorState(ConfigNodeImpl* const& self,ConfigTransactionGetGenerationRequest const& req) 
															#line 260 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 260 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 260 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   req(req)
															#line 3016 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("getNewGeneration", reinterpret_cast<unsigned long>(this));

	}
	~GetNewGenerationActorState() 
	{
		fdb_probe_actor_destroy("getNewGeneration", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 261 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<CoordinatorsHash> __when_expr_0 = getCoordinatorsHash(self);
															#line 261 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetNewGenerationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3033 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetNewGenerationActor*>(this)->actor_wait_state = 1;
															#line 261 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetNewGenerationActor, 0, CoordinatorsHash >*>(static_cast<GetNewGenerationActor*>(this)));
															#line 3038 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetNewGenerationActorState();
		static_cast<GetNewGenerationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 262 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.coordinatorsHash != coordinatorsHash)
															#line 3061 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 263 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(coordinators_changed());
															#line 264 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetNewGenerationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetNewGenerationActorState(); static_cast<GetNewGenerationActor*>(this)->destroy(); return 0; }
															#line 3067 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetNewGenerationActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetNewGenerationActorState();
			static_cast<GetNewGenerationActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 266 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<ConfigGeneration> __when_expr_1 = getGeneration(self);
															#line 266 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetNewGenerationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3077 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetNewGenerationActor*>(this)->actor_wait_state = 2;
															#line 266 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetNewGenerationActor, 1, ConfigGeneration >*>(static_cast<GetNewGenerationActor*>(this)));
															#line 3082 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(CoordinatorsHash const& __coordinatorsHash,int loopDepth) 
	{
															#line 261 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		coordinatorsHash = __coordinatorsHash;
															#line 3091 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(CoordinatorsHash && __coordinatorsHash,int loopDepth) 
	{
		coordinatorsHash = std::move(__coordinatorsHash);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetNewGenerationActor*>(this)->actor_wait_state > 0) static_cast<GetNewGenerationActor*>(this)->actor_wait_state = 0;
		static_cast<GetNewGenerationActor*>(this)->ActorCallback< GetNewGenerationActor, 0, CoordinatorsHash >::remove();

	}
	void a_callback_fire(ActorCallback< GetNewGenerationActor, 0, CoordinatorsHash >*,CoordinatorsHash const& value) 
	{
		fdb_probe_actor_enter("getNewGeneration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewGenerationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNewGeneration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetNewGenerationActor, 0, CoordinatorsHash >*,CoordinatorsHash && value) 
	{
		fdb_probe_actor_enter("getNewGeneration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewGenerationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNewGeneration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetNewGenerationActor, 0, CoordinatorsHash >*,Error err) 
	{
		fdb_probe_actor_enter("getNewGeneration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewGenerationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNewGeneration", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 267 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		++generation.liveVersion;
															#line 268 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.lastSeenLiveVersion.present())
															#line 3172 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 269 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			CODE_PROBE(req.lastSeenLiveVersion.get() >= generation.liveVersion, "Node is lagging behind some other node");
															#line 271 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			generation.liveVersion = std::max(generation.liveVersion, req.lastSeenLiveVersion.get() + 1);
															#line 3178 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
															#line 273 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		self->kvStore->set(KeyValueRef(currentGenerationKey, BinaryWriter::toValue(generation, IncludeVersion())));
															#line 274 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->kvStore->commit();
															#line 274 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetNewGenerationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3186 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetNewGenerationActor*>(this)->actor_wait_state = 3;
															#line 274 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetNewGenerationActor, 2, Void >*>(static_cast<GetNewGenerationActor*>(this)));
															#line 3191 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(ConfigGeneration const& __generation,int loopDepth) 
	{
															#line 266 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		generation = __generation;
															#line 3200 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(ConfigGeneration && __generation,int loopDepth) 
	{
		generation = std::move(__generation);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetNewGenerationActor*>(this)->actor_wait_state > 0) static_cast<GetNewGenerationActor*>(this)->actor_wait_state = 0;
		static_cast<GetNewGenerationActor*>(this)->ActorCallback< GetNewGenerationActor, 1, ConfigGeneration >::remove();

	}
	void a_callback_fire(ActorCallback< GetNewGenerationActor, 1, ConfigGeneration >*,ConfigGeneration const& value) 
	{
		fdb_probe_actor_enter("getNewGeneration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewGenerationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNewGeneration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetNewGenerationActor, 1, ConfigGeneration >*,ConfigGeneration && value) 
	{
		fdb_probe_actor_enter("getNewGeneration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewGenerationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNewGeneration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetNewGenerationActor, 1, ConfigGeneration >*,Error err) 
	{
		fdb_probe_actor_enter("getNewGeneration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewGenerationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNewGeneration", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 275 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(ConfigTransactionGetGenerationReply{ generation });
															#line 276 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetNewGenerationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetNewGenerationActorState(); static_cast<GetNewGenerationActor*>(this)->destroy(); return 0; }
															#line 3281 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetNewGenerationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetNewGenerationActorState();
		static_cast<GetNewGenerationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 275 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(ConfigTransactionGetGenerationReply{ generation });
															#line 276 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetNewGenerationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetNewGenerationActorState(); static_cast<GetNewGenerationActor*>(this)->destroy(); return 0; }
															#line 3295 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetNewGenerationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetNewGenerationActorState();
		static_cast<GetNewGenerationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetNewGenerationActor*>(this)->actor_wait_state > 0) static_cast<GetNewGenerationActor*>(this)->actor_wait_state = 0;
		static_cast<GetNewGenerationActor*>(this)->ActorCallback< GetNewGenerationActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetNewGenerationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getNewGeneration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewGenerationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNewGeneration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetNewGenerationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getNewGeneration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewGenerationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNewGeneration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetNewGenerationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getNewGeneration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewGenerationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNewGeneration", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 260 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 260 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigTransactionGetGenerationRequest req;
															#line 261 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	CoordinatorsHash coordinatorsHash;
															#line 266 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigGeneration generation;
															#line 3386 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via getNewGeneration()
															#line 260 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetNewGenerationActor final : public Actor<Void>, public ActorCallback< GetNewGenerationActor, 0, CoordinatorsHash >, public ActorCallback< GetNewGenerationActor, 1, ConfigGeneration >, public ActorCallback< GetNewGenerationActor, 2, Void >, public FastAllocated<GetNewGenerationActor>, public GetNewGenerationActorState<GetNewGenerationActor> {
															#line 3391 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<GetNewGenerationActor>::operator new;
	using FastAllocated<GetNewGenerationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1420338458044456192UL, 14012247530981483520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetNewGenerationActor, 0, CoordinatorsHash >;
friend struct ActorCallback< GetNewGenerationActor, 1, ConfigGeneration >;
friend struct ActorCallback< GetNewGenerationActor, 2, Void >;
															#line 260 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetNewGenerationActor(ConfigNodeImpl* const& self,ConfigTransactionGetGenerationRequest const& req) 
															#line 3410 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Void>(),
		   GetNewGenerationActorState<GetNewGenerationActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getNewGeneration", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5786138240138080256UL, 12741963764465706752UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewGenerationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getNewGeneration");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getNewGeneration", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetNewGenerationActor, 0, CoordinatorsHash >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetNewGenerationActor, 1, ConfigGeneration >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetNewGenerationActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 260 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Void> getNewGeneration( ConfigNodeImpl* const& self, ConfigTransactionGetGenerationRequest const& req ) {
															#line 260 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Void>(new GetNewGenerationActor(self, req));
															#line 3444 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 278 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

																#line 3449 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via get()
															#line 279 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class GetActor>
															#line 279 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetActorState {
															#line 3455 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 279 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetActorState(ConfigNodeImpl* const& self,ConfigTransactionGetRequest const& req) 
															#line 279 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 279 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 279 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   req(req)
															#line 3464 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("get", reinterpret_cast<unsigned long>(this));

	}
	~GetActorState() 
	{
		fdb_probe_actor_destroy("get", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 280 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Optional<CoordinatorsHash>> __when_expr_0 = getLocked(self);
															#line 280 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3481 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetActor*>(this)->actor_wait_state = 1;
															#line 280 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetActor, 0, Optional<CoordinatorsHash> >*>(static_cast<GetActor*>(this)));
															#line 3486 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetActorState();
		static_cast<GetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 281 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (locked.present())
															#line 3509 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 282 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			CODE_PROBE(true, "attempting to read from a locked ConfigNode");
															#line 283 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(coordinators_changed());
															#line 284 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetActorState(); static_cast<GetActor*>(this)->destroy(); return 0; }
															#line 3517 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetActorState();
			static_cast<GetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 286 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<CoordinatorsHash> __when_expr_1 = getCoordinatorsHash(self);
															#line 286 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3527 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetActor*>(this)->actor_wait_state = 2;
															#line 286 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetActor, 1, CoordinatorsHash >*>(static_cast<GetActor*>(this)));
															#line 3532 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<CoordinatorsHash> const& __locked,int loopDepth) 
	{
															#line 280 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		locked = __locked;
															#line 3541 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<CoordinatorsHash> && __locked,int loopDepth) 
	{
		locked = std::move(__locked);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetActor*>(this)->actor_wait_state > 0) static_cast<GetActor*>(this)->actor_wait_state = 0;
		static_cast<GetActor*>(this)->ActorCallback< GetActor, 0, Optional<CoordinatorsHash> >::remove();

	}
	void a_callback_fire(ActorCallback< GetActor, 0, Optional<CoordinatorsHash> >*,Optional<CoordinatorsHash> const& value) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetActor, 0, Optional<CoordinatorsHash> >*,Optional<CoordinatorsHash> && value) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetActor, 0, Optional<CoordinatorsHash> >*,Error err) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 287 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.coordinatorsHash != coordinatorsHash)
															#line 3620 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 288 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(coordinators_changed());
															#line 289 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetActorState(); static_cast<GetActor*>(this)->destroy(); return 0; }
															#line 3626 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetActorState();
			static_cast<GetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 291 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<ConfigGeneration> __when_expr_2 = getGeneration(self);
															#line 291 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3636 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetActor*>(this)->actor_wait_state = 3;
															#line 291 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetActor, 2, ConfigGeneration >*>(static_cast<GetActor*>(this)));
															#line 3641 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(CoordinatorsHash const& __coordinatorsHash,int loopDepth) 
	{
															#line 286 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		coordinatorsHash = __coordinatorsHash;
															#line 3650 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(CoordinatorsHash && __coordinatorsHash,int loopDepth) 
	{
		coordinatorsHash = std::move(__coordinatorsHash);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetActor*>(this)->actor_wait_state > 0) static_cast<GetActor*>(this)->actor_wait_state = 0;
		static_cast<GetActor*>(this)->ActorCallback< GetActor, 1, CoordinatorsHash >::remove();

	}
	void a_callback_fire(ActorCallback< GetActor, 1, CoordinatorsHash >*,CoordinatorsHash const& value) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetActor, 1, CoordinatorsHash >*,CoordinatorsHash && value) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetActor, 1, CoordinatorsHash >*,Error err) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(ConfigGeneration const& currentGeneration,int loopDepth) 
	{
															#line 292 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.generation != currentGeneration)
															#line 3729 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 294 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(transaction_too_old());
															#line 295 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetActorState(); static_cast<GetActor*>(this)->destroy(); return 0; }
															#line 3735 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetActorState();
			static_cast<GetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 297 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = self->kvStore->readValue(BinaryWriter::toValue(req.key, IncludeVersion()).withPrefix(kvKeys.begin));
															#line 297 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3745 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetActor*>(this)->actor_wait_state = 4;
															#line 297 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetActor, 3, Optional<Value> >*>(static_cast<GetActor*>(this)));
															#line 3750 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(ConfigGeneration && currentGeneration,int loopDepth) 
	{
															#line 292 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.generation != currentGeneration)
															#line 3759 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 294 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(transaction_too_old());
															#line 295 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetActorState(); static_cast<GetActor*>(this)->destroy(); return 0; }
															#line 3765 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetActorState();
			static_cast<GetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 297 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = self->kvStore->readValue(BinaryWriter::toValue(req.key, IncludeVersion()).withPrefix(kvKeys.begin));
															#line 297 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3775 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetActor*>(this)->actor_wait_state = 4;
															#line 297 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetActor, 3, Optional<Value> >*>(static_cast<GetActor*>(this)));
															#line 3780 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(ConfigGeneration const& currentGeneration,int loopDepth) 
	{
		loopDepth = a_body1cont4(currentGeneration, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(ConfigGeneration && currentGeneration,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(currentGeneration), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetActor*>(this)->actor_wait_state > 0) static_cast<GetActor*>(this)->actor_wait_state = 0;
		static_cast<GetActor*>(this)->ActorCallback< GetActor, 2, ConfigGeneration >::remove();

	}
	void a_callback_fire(ActorCallback< GetActor, 2, ConfigGeneration >*,ConfigGeneration const& value) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetActor, 2, ConfigGeneration >*,ConfigGeneration && value) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetActor, 2, ConfigGeneration >*,Error err) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 299 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		value = Optional<KnobValue>();
															#line 300 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (serializedValue.present())
															#line 3866 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 301 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			value = ObjectReader::fromStringRef<KnobValue>(serializedValue.get(), IncludeVersion());
															#line 3870 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
															#line 303 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Standalone<VectorRef<VersionedConfigMutationRef>>> __when_expr_4 = getMutations(self, 0, req.generation.committedVersion);
															#line 303 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3876 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<GetActor*>(this)->actor_wait_state = 5;
															#line 303 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetActor, 4, Standalone<VectorRef<VersionedConfigMutationRef>> >*>(static_cast<GetActor*>(this)));
															#line 3881 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Optional<Value> const& __serializedValue,int loopDepth) 
	{
															#line 297 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		serializedValue = __serializedValue;
															#line 3890 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Optional<Value> && __serializedValue,int loopDepth) 
	{
		serializedValue = std::move(__serializedValue);
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetActor*>(this)->actor_wait_state > 0) static_cast<GetActor*>(this)->actor_wait_state = 0;
		static_cast<GetActor*>(this)->ActorCallback< GetActor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetActor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetActor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetActor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(Standalone<VectorRef<VersionedConfigMutationRef>> const& versionedMutations,int loopDepth) 
	{
															#line 305 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& versionedMutation : versionedMutations ) {
															#line 306 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			const auto& mutation = versionedMutation.mutation;
															#line 307 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (mutation.getKey() == req.key)
															#line 3973 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			{
															#line 308 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				if (mutation.isSet())
															#line 3977 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				{
															#line 309 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
					value = mutation.getValue();
															#line 3981 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				}
				else
				{
															#line 311 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
					value = {};
															#line 3987 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				}
			}
		}
															#line 315 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(ConfigTransactionGetReply{ value });
															#line 316 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetActorState(); static_cast<GetActor*>(this)->destroy(); return 0; }
															#line 3995 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetActorState();
		static_cast<GetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Standalone<VectorRef<VersionedConfigMutationRef>> && versionedMutations,int loopDepth) 
	{
															#line 305 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& versionedMutation : versionedMutations ) {
															#line 306 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			const auto& mutation = versionedMutation.mutation;
															#line 307 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (mutation.getKey() == req.key)
															#line 4011 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			{
															#line 308 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				if (mutation.isSet())
															#line 4015 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				{
															#line 309 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
					value = mutation.getValue();
															#line 4019 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				}
				else
				{
															#line 311 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
					value = {};
															#line 4025 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				}
			}
		}
															#line 315 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(ConfigTransactionGetReply{ value });
															#line 316 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetActorState(); static_cast<GetActor*>(this)->destroy(); return 0; }
															#line 4033 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetActorState();
		static_cast<GetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6when1(Standalone<VectorRef<VersionedConfigMutationRef>> const& versionedMutations,int loopDepth) 
	{
		loopDepth = a_body1cont8(versionedMutations, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Standalone<VectorRef<VersionedConfigMutationRef>> && versionedMutations,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(versionedMutations), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetActor*>(this)->actor_wait_state > 0) static_cast<GetActor*>(this)->actor_wait_state = 0;
		static_cast<GetActor*>(this)->ActorCallback< GetActor, 4, Standalone<VectorRef<VersionedConfigMutationRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetActor, 4, Standalone<VectorRef<VersionedConfigMutationRef>> >*,Standalone<VectorRef<VersionedConfigMutationRef>> const& value) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetActor, 4, Standalone<VectorRef<VersionedConfigMutationRef>> >*,Standalone<VectorRef<VersionedConfigMutationRef>> && value) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetActor, 4, Standalone<VectorRef<VersionedConfigMutationRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 279 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 279 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigTransactionGetRequest req;
															#line 280 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Optional<CoordinatorsHash> locked;
															#line 286 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	CoordinatorsHash coordinatorsHash;
															#line 297 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Optional<Value> serializedValue;
															#line 299 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Optional<KnobValue> value;
															#line 4128 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via get()
															#line 279 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetActor final : public Actor<Void>, public ActorCallback< GetActor, 0, Optional<CoordinatorsHash> >, public ActorCallback< GetActor, 1, CoordinatorsHash >, public ActorCallback< GetActor, 2, ConfigGeneration >, public ActorCallback< GetActor, 3, Optional<Value> >, public ActorCallback< GetActor, 4, Standalone<VectorRef<VersionedConfigMutationRef>> >, public FastAllocated<GetActor>, public GetActorState<GetActor> {
															#line 4133 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<GetActor>::operator new;
	using FastAllocated<GetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7027476101040426496UL, 16125406700663641856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetActor, 0, Optional<CoordinatorsHash> >;
friend struct ActorCallback< GetActor, 1, CoordinatorsHash >;
friend struct ActorCallback< GetActor, 2, ConfigGeneration >;
friend struct ActorCallback< GetActor, 3, Optional<Value> >;
friend struct ActorCallback< GetActor, 4, Standalone<VectorRef<VersionedConfigMutationRef>> >;
															#line 279 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetActor(ConfigNodeImpl* const& self,ConfigTransactionGetRequest const& req) 
															#line 4154 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Void>(),
		   GetActorState<GetActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13305627610698362112UL, 12413557174276224768UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("get");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetActor, 0, Optional<CoordinatorsHash> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetActor, 1, CoordinatorsHash >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetActor, 2, ConfigGeneration >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetActor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetActor, 4, Standalone<VectorRef<VersionedConfigMutationRef>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 279 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Void> get( ConfigNodeImpl* const& self, ConfigTransactionGetRequest const& req ) {
															#line 279 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Void>(new GetActor(self, req));
															#line 4190 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 318 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

	// Retrieve all configuration classes that contain explicitly defined knobs
	// TODO: Currently it is possible that extra configuration classes may be returned, we
	// may want to fix this to clean up the contract
																#line 4198 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via getConfigClasses()
															#line 322 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class GetConfigClassesActor>
															#line 322 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetConfigClassesActorState {
															#line 4204 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 322 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetConfigClassesActorState(ConfigNodeImpl* const& self,ConfigTransactionGetConfigClassesRequest const& req) 
															#line 322 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 322 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 322 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   req(req)
															#line 4213 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("getConfigClasses", reinterpret_cast<unsigned long>(this));

	}
	~GetConfigClassesActorState() 
	{
		fdb_probe_actor_destroy("getConfigClasses", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 323 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Optional<CoordinatorsHash>> __when_expr_0 = getLocked(self);
															#line 323 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4230 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetConfigClassesActor*>(this)->actor_wait_state = 1;
															#line 323 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetConfigClassesActor, 0, Optional<CoordinatorsHash> >*>(static_cast<GetConfigClassesActor*>(this)));
															#line 4235 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetConfigClassesActorState();
		static_cast<GetConfigClassesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 324 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (locked.present())
															#line 4258 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 325 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			CODE_PROBE(true, "attempting to read config classes from locked ConfigNode", probe::decoration::rare);
															#line 326 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(coordinators_changed());
															#line 327 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetConfigClassesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetConfigClassesActorState(); static_cast<GetConfigClassesActor*>(this)->destroy(); return 0; }
															#line 4266 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetConfigClassesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetConfigClassesActorState();
			static_cast<GetConfigClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 329 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<CoordinatorsHash> __when_expr_1 = getCoordinatorsHash(self);
															#line 329 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4276 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetConfigClassesActor*>(this)->actor_wait_state = 2;
															#line 329 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetConfigClassesActor, 1, CoordinatorsHash >*>(static_cast<GetConfigClassesActor*>(this)));
															#line 4281 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<CoordinatorsHash> const& __locked,int loopDepth) 
	{
															#line 323 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		locked = __locked;
															#line 4290 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<CoordinatorsHash> && __locked,int loopDepth) 
	{
		locked = std::move(__locked);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetConfigClassesActor*>(this)->actor_wait_state > 0) static_cast<GetConfigClassesActor*>(this)->actor_wait_state = 0;
		static_cast<GetConfigClassesActor*>(this)->ActorCallback< GetConfigClassesActor, 0, Optional<CoordinatorsHash> >::remove();

	}
	void a_callback_fire(ActorCallback< GetConfigClassesActor, 0, Optional<CoordinatorsHash> >*,Optional<CoordinatorsHash> const& value) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetConfigClassesActor, 0, Optional<CoordinatorsHash> >*,Optional<CoordinatorsHash> && value) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetConfigClassesActor, 0, Optional<CoordinatorsHash> >*,Error err) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 330 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.coordinatorsHash != coordinatorsHash)
															#line 4369 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 331 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(coordinators_changed());
															#line 332 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetConfigClassesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetConfigClassesActorState(); static_cast<GetConfigClassesActor*>(this)->destroy(); return 0; }
															#line 4375 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetConfigClassesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetConfigClassesActorState();
			static_cast<GetConfigClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 334 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<ConfigGeneration> __when_expr_2 = getGeneration(self);
															#line 334 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4385 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetConfigClassesActor*>(this)->actor_wait_state = 3;
															#line 334 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetConfigClassesActor, 2, ConfigGeneration >*>(static_cast<GetConfigClassesActor*>(this)));
															#line 4390 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(CoordinatorsHash const& __coordinatorsHash,int loopDepth) 
	{
															#line 329 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		coordinatorsHash = __coordinatorsHash;
															#line 4399 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(CoordinatorsHash && __coordinatorsHash,int loopDepth) 
	{
		coordinatorsHash = std::move(__coordinatorsHash);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetConfigClassesActor*>(this)->actor_wait_state > 0) static_cast<GetConfigClassesActor*>(this)->actor_wait_state = 0;
		static_cast<GetConfigClassesActor*>(this)->ActorCallback< GetConfigClassesActor, 1, CoordinatorsHash >::remove();

	}
	void a_callback_fire(ActorCallback< GetConfigClassesActor, 1, CoordinatorsHash >*,CoordinatorsHash const& value) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetConfigClassesActor, 1, CoordinatorsHash >*,CoordinatorsHash && value) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetConfigClassesActor, 1, CoordinatorsHash >*,Error err) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(ConfigGeneration const& currentGeneration,int loopDepth) 
	{
															#line 335 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.generation != currentGeneration)
															#line 4478 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 336 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(transaction_too_old());
															#line 337 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetConfigClassesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetConfigClassesActorState(); static_cast<GetConfigClassesActor*>(this)->destroy(); return 0; }
															#line 4484 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetConfigClassesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetConfigClassesActorState();
			static_cast<GetConfigClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 339 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<RangeResult> __when_expr_3 = self->kvStore->readRange(kvKeys);
															#line 339 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4494 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetConfigClassesActor*>(this)->actor_wait_state = 4;
															#line 339 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetConfigClassesActor, 3, RangeResult >*>(static_cast<GetConfigClassesActor*>(this)));
															#line 4499 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(ConfigGeneration && currentGeneration,int loopDepth) 
	{
															#line 335 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.generation != currentGeneration)
															#line 4508 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 336 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(transaction_too_old());
															#line 337 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetConfigClassesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetConfigClassesActorState(); static_cast<GetConfigClassesActor*>(this)->destroy(); return 0; }
															#line 4514 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetConfigClassesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetConfigClassesActorState();
			static_cast<GetConfigClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 339 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<RangeResult> __when_expr_3 = self->kvStore->readRange(kvKeys);
															#line 339 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4524 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetConfigClassesActor*>(this)->actor_wait_state = 4;
															#line 339 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetConfigClassesActor, 3, RangeResult >*>(static_cast<GetConfigClassesActor*>(this)));
															#line 4529 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(ConfigGeneration const& currentGeneration,int loopDepth) 
	{
		loopDepth = a_body1cont4(currentGeneration, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(ConfigGeneration && currentGeneration,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(currentGeneration), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetConfigClassesActor*>(this)->actor_wait_state > 0) static_cast<GetConfigClassesActor*>(this)->actor_wait_state = 0;
		static_cast<GetConfigClassesActor*>(this)->ActorCallback< GetConfigClassesActor, 2, ConfigGeneration >::remove();

	}
	void a_callback_fire(ActorCallback< GetConfigClassesActor, 2, ConfigGeneration >*,ConfigGeneration const& value) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetConfigClassesActor, 2, ConfigGeneration >*,ConfigGeneration && value) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetConfigClassesActor, 2, ConfigGeneration >*,Error err) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 340 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		configClassesSet = std::set<Key>();
															#line 341 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& kv : snapshot ) {
															#line 342 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			auto configKey = BinaryReader::fromStringRef<ConfigKey>(kv.key.removePrefix(kvKeys.begin), IncludeVersion());
															#line 344 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (configKey.configClass.present())
															#line 4619 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			{
															#line 345 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				configClassesSet.insert(configKey.configClass.get());
															#line 4623 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			}
		}
															#line 348 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Version> __when_expr_4 = getLastCompactedVersion(self);
															#line 348 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4630 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<GetConfigClassesActor*>(this)->actor_wait_state = 5;
															#line 348 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetConfigClassesActor, 4, Version >*>(static_cast<GetConfigClassesActor*>(this)));
															#line 4635 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(RangeResult const& __snapshot,int loopDepth) 
	{
															#line 339 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		snapshot = __snapshot;
															#line 4644 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(RangeResult && __snapshot,int loopDepth) 
	{
		snapshot = std::move(__snapshot);
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetConfigClassesActor*>(this)->actor_wait_state > 0) static_cast<GetConfigClassesActor*>(this)->actor_wait_state = 0;
		static_cast<GetConfigClassesActor*>(this)->ActorCallback< GetConfigClassesActor, 3, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetConfigClassesActor, 3, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetConfigClassesActor, 3, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetConfigClassesActor, 3, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 349 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Standalone<VectorRef<VersionedConfigMutationRef>>> __when_expr_5 = getMutations(self, lastCompactedVersion + 1, req.generation.committedVersion);
															#line 349 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4725 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<GetConfigClassesActor*>(this)->actor_wait_state = 6;
															#line 349 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GetConfigClassesActor, 5, Standalone<VectorRef<VersionedConfigMutationRef>> >*>(static_cast<GetConfigClassesActor*>(this)));
															#line 4730 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Version const& __lastCompactedVersion,int loopDepth) 
	{
															#line 348 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		lastCompactedVersion = __lastCompactedVersion;
															#line 4739 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Version && __lastCompactedVersion,int loopDepth) 
	{
		lastCompactedVersion = std::move(__lastCompactedVersion);
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetConfigClassesActor*>(this)->actor_wait_state > 0) static_cast<GetConfigClassesActor*>(this)->actor_wait_state = 0;
		static_cast<GetConfigClassesActor*>(this)->ActorCallback< GetConfigClassesActor, 4, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetConfigClassesActor, 4, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetConfigClassesActor, 4, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetConfigClassesActor, 4, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11(int loopDepth) 
	{
															#line 351 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& versionedMutation : mutations ) {
															#line 352 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			auto configClass = versionedMutation.mutation.getConfigClass();
															#line 353 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (configClass.present())
															#line 4822 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			{
															#line 354 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				configClassesSet.insert(configClass.get());
															#line 4826 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			}
		}
															#line 357 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		Standalone<VectorRef<KeyRef>> configClasses;
															#line 358 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& configClass : configClassesSet ) {
															#line 359 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			configClasses.push_back_deep(configClasses.arena(), configClass);
															#line 4835 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
															#line 361 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(ConfigTransactionGetConfigClassesReply{ configClasses });
															#line 362 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetConfigClassesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetConfigClassesActorState(); static_cast<GetConfigClassesActor*>(this)->destroy(); return 0; }
															#line 4841 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetConfigClassesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetConfigClassesActorState();
		static_cast<GetConfigClassesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8when1(Standalone<VectorRef<VersionedConfigMutationRef>> const& __mutations,int loopDepth) 
	{
															#line 349 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		mutations = __mutations;
															#line 4853 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Standalone<VectorRef<VersionedConfigMutationRef>> && __mutations,int loopDepth) 
	{
		mutations = std::move(__mutations);
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GetConfigClassesActor*>(this)->actor_wait_state > 0) static_cast<GetConfigClassesActor*>(this)->actor_wait_state = 0;
		static_cast<GetConfigClassesActor*>(this)->ActorCallback< GetConfigClassesActor, 5, Standalone<VectorRef<VersionedConfigMutationRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetConfigClassesActor, 5, Standalone<VectorRef<VersionedConfigMutationRef>> >*,Standalone<VectorRef<VersionedConfigMutationRef>> const& value) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< GetConfigClassesActor, 5, Standalone<VectorRef<VersionedConfigMutationRef>> >*,Standalone<VectorRef<VersionedConfigMutationRef>> && value) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< GetConfigClassesActor, 5, Standalone<VectorRef<VersionedConfigMutationRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 322 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 322 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigTransactionGetConfigClassesRequest req;
															#line 323 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Optional<CoordinatorsHash> locked;
															#line 329 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	CoordinatorsHash coordinatorsHash;
															#line 339 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	RangeResult snapshot;
															#line 340 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	std::set<Key> configClassesSet;
															#line 348 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Version lastCompactedVersion;
															#line 349 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Standalone<VectorRef<VersionedConfigMutationRef>> mutations;
															#line 4944 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via getConfigClasses()
															#line 322 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetConfigClassesActor final : public Actor<Void>, public ActorCallback< GetConfigClassesActor, 0, Optional<CoordinatorsHash> >, public ActorCallback< GetConfigClassesActor, 1, CoordinatorsHash >, public ActorCallback< GetConfigClassesActor, 2, ConfigGeneration >, public ActorCallback< GetConfigClassesActor, 3, RangeResult >, public ActorCallback< GetConfigClassesActor, 4, Version >, public ActorCallback< GetConfigClassesActor, 5, Standalone<VectorRef<VersionedConfigMutationRef>> >, public FastAllocated<GetConfigClassesActor>, public GetConfigClassesActorState<GetConfigClassesActor> {
															#line 4949 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<GetConfigClassesActor>::operator new;
	using FastAllocated<GetConfigClassesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11477388445336602112UL, 13075214742900952064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetConfigClassesActor, 0, Optional<CoordinatorsHash> >;
friend struct ActorCallback< GetConfigClassesActor, 1, CoordinatorsHash >;
friend struct ActorCallback< GetConfigClassesActor, 2, ConfigGeneration >;
friend struct ActorCallback< GetConfigClassesActor, 3, RangeResult >;
friend struct ActorCallback< GetConfigClassesActor, 4, Version >;
friend struct ActorCallback< GetConfigClassesActor, 5, Standalone<VectorRef<VersionedConfigMutationRef>> >;
															#line 322 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetConfigClassesActor(ConfigNodeImpl* const& self,ConfigTransactionGetConfigClassesRequest const& req) 
															#line 4971 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Void>(),
		   GetConfigClassesActorState<GetConfigClassesActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14805324959998266368UL, 16789838799325584384UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getConfigClasses");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetConfigClassesActor, 0, Optional<CoordinatorsHash> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetConfigClassesActor, 1, CoordinatorsHash >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetConfigClassesActor, 2, ConfigGeneration >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetConfigClassesActor, 3, RangeResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetConfigClassesActor, 4, Version >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GetConfigClassesActor, 5, Standalone<VectorRef<VersionedConfigMutationRef>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 322 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Void> getConfigClasses( ConfigNodeImpl* const& self, ConfigTransactionGetConfigClassesRequest const& req ) {
															#line 322 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Void>(new GetConfigClassesActor(self, req));
															#line 5008 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 364 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

	// Retrieve all knobs explicitly defined for the specified configuration class
																#line 5014 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via getKnobs()
															#line 366 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class GetKnobsActor>
															#line 366 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetKnobsActorState {
															#line 5020 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 366 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetKnobsActorState(ConfigNodeImpl* const& self,ConfigTransactionGetKnobsRequest const& req) 
															#line 366 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 366 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 366 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   req(req)
															#line 5029 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("getKnobs", reinterpret_cast<unsigned long>(this));

	}
	~GetKnobsActorState() 
	{
		fdb_probe_actor_destroy("getKnobs", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 367 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Optional<CoordinatorsHash>> __when_expr_0 = getLocked(self);
															#line 367 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5046 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKnobsActor*>(this)->actor_wait_state = 1;
															#line 367 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKnobsActor, 0, Optional<CoordinatorsHash> >*>(static_cast<GetKnobsActor*>(this)));
															#line 5051 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKnobsActorState();
		static_cast<GetKnobsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 368 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (locked.present())
															#line 5074 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 369 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			CODE_PROBE(true, "attempting to read knobs from locked ConfigNode", probe::decoration::rare);
															#line 370 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(coordinators_changed());
															#line 371 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetKnobsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetKnobsActorState(); static_cast<GetKnobsActor*>(this)->destroy(); return 0; }
															#line 5082 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetKnobsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetKnobsActorState();
			static_cast<GetKnobsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 373 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<CoordinatorsHash> __when_expr_1 = getCoordinatorsHash(self);
															#line 373 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5092 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetKnobsActor*>(this)->actor_wait_state = 2;
															#line 373 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKnobsActor, 1, CoordinatorsHash >*>(static_cast<GetKnobsActor*>(this)));
															#line 5097 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<CoordinatorsHash> const& __locked,int loopDepth) 
	{
															#line 367 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		locked = __locked;
															#line 5106 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<CoordinatorsHash> && __locked,int loopDepth) 
	{
		locked = std::move(__locked);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKnobsActor*>(this)->actor_wait_state > 0) static_cast<GetKnobsActor*>(this)->actor_wait_state = 0;
		static_cast<GetKnobsActor*>(this)->ActorCallback< GetKnobsActor, 0, Optional<CoordinatorsHash> >::remove();

	}
	void a_callback_fire(ActorCallback< GetKnobsActor, 0, Optional<CoordinatorsHash> >*,Optional<CoordinatorsHash> const& value) 
	{
		fdb_probe_actor_enter("getKnobs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobs", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKnobsActor, 0, Optional<CoordinatorsHash> >*,Optional<CoordinatorsHash> && value) 
	{
		fdb_probe_actor_enter("getKnobs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobs", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKnobsActor, 0, Optional<CoordinatorsHash> >*,Error err) 
	{
		fdb_probe_actor_enter("getKnobs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobs", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 374 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.coordinatorsHash != coordinatorsHash)
															#line 5185 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 375 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(coordinators_changed());
															#line 376 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetKnobsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetKnobsActorState(); static_cast<GetKnobsActor*>(this)->destroy(); return 0; }
															#line 5191 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetKnobsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetKnobsActorState();
			static_cast<GetKnobsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 379 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<ConfigGeneration> __when_expr_2 = getGeneration(self);
															#line 379 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5201 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetKnobsActor*>(this)->actor_wait_state = 3;
															#line 379 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKnobsActor, 2, ConfigGeneration >*>(static_cast<GetKnobsActor*>(this)));
															#line 5206 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(CoordinatorsHash const& __coordinatorsHash,int loopDepth) 
	{
															#line 373 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		coordinatorsHash = __coordinatorsHash;
															#line 5215 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(CoordinatorsHash && __coordinatorsHash,int loopDepth) 
	{
		coordinatorsHash = std::move(__coordinatorsHash);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKnobsActor*>(this)->actor_wait_state > 0) static_cast<GetKnobsActor*>(this)->actor_wait_state = 0;
		static_cast<GetKnobsActor*>(this)->ActorCallback< GetKnobsActor, 1, CoordinatorsHash >::remove();

	}
	void a_callback_fire(ActorCallback< GetKnobsActor, 1, CoordinatorsHash >*,CoordinatorsHash const& value) 
	{
		fdb_probe_actor_enter("getKnobs", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobs", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKnobsActor, 1, CoordinatorsHash >*,CoordinatorsHash && value) 
	{
		fdb_probe_actor_enter("getKnobs", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobs", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKnobsActor, 1, CoordinatorsHash >*,Error err) 
	{
		fdb_probe_actor_enter("getKnobs", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobs", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(ConfigGeneration const& currentGeneration,int loopDepth) 
	{
															#line 380 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.generation != currentGeneration)
															#line 5294 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 381 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(transaction_too_old());
															#line 382 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetKnobsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetKnobsActorState(); static_cast<GetKnobsActor*>(this)->destroy(); return 0; }
															#line 5300 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetKnobsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetKnobsActorState();
			static_cast<GetKnobsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 385 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<RangeResult> __when_expr_3 = self->kvStore->readRange(kvKeys);
															#line 385 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5310 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetKnobsActor*>(this)->actor_wait_state = 4;
															#line 385 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetKnobsActor, 3, RangeResult >*>(static_cast<GetKnobsActor*>(this)));
															#line 5315 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(ConfigGeneration && currentGeneration,int loopDepth) 
	{
															#line 380 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.generation != currentGeneration)
															#line 5324 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 381 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(transaction_too_old());
															#line 382 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetKnobsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetKnobsActorState(); static_cast<GetKnobsActor*>(this)->destroy(); return 0; }
															#line 5330 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetKnobsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetKnobsActorState();
			static_cast<GetKnobsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 385 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<RangeResult> __when_expr_3 = self->kvStore->readRange(kvKeys);
															#line 385 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5340 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetKnobsActor*>(this)->actor_wait_state = 4;
															#line 385 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetKnobsActor, 3, RangeResult >*>(static_cast<GetKnobsActor*>(this)));
															#line 5345 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(ConfigGeneration const& currentGeneration,int loopDepth) 
	{
		loopDepth = a_body1cont4(currentGeneration, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(ConfigGeneration && currentGeneration,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(currentGeneration), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetKnobsActor*>(this)->actor_wait_state > 0) static_cast<GetKnobsActor*>(this)->actor_wait_state = 0;
		static_cast<GetKnobsActor*>(this)->ActorCallback< GetKnobsActor, 2, ConfigGeneration >::remove();

	}
	void a_callback_fire(ActorCallback< GetKnobsActor, 2, ConfigGeneration >*,ConfigGeneration const& value) 
	{
		fdb_probe_actor_enter("getKnobs", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobs", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetKnobsActor, 2, ConfigGeneration >*,ConfigGeneration && value) 
	{
		fdb_probe_actor_enter("getKnobs", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobs", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetKnobsActor, 2, ConfigGeneration >*,Error err) 
	{
		fdb_probe_actor_enter("getKnobs", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobs", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 386 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		knobSet = std::set<Key>();
															#line 387 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& kv : snapshot ) {
															#line 388 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			auto configKey = BinaryReader::fromStringRef<ConfigKey>(kv.key.removePrefix(kvKeys.begin), IncludeVersion());
															#line 390 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (configKey.configClass.template castTo<Key>() == req.configClass)
															#line 5435 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			{
															#line 391 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				knobSet.insert(configKey.knobName);
															#line 5439 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			}
		}
															#line 394 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Version> __when_expr_4 = getLastCompactedVersion(self);
															#line 394 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5446 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<GetKnobsActor*>(this)->actor_wait_state = 5;
															#line 394 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetKnobsActor, 4, Version >*>(static_cast<GetKnobsActor*>(this)));
															#line 5451 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(RangeResult const& __snapshot,int loopDepth) 
	{
															#line 385 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		snapshot = __snapshot;
															#line 5460 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(RangeResult && __snapshot,int loopDepth) 
	{
		snapshot = std::move(__snapshot);
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetKnobsActor*>(this)->actor_wait_state > 0) static_cast<GetKnobsActor*>(this)->actor_wait_state = 0;
		static_cast<GetKnobsActor*>(this)->ActorCallback< GetKnobsActor, 3, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetKnobsActor, 3, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getKnobs", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobs", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetKnobsActor, 3, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getKnobs", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobs", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetKnobsActor, 3, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getKnobs", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobs", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 395 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Standalone<VectorRef<VersionedConfigMutationRef>>> __when_expr_5 = getMutations(self, lastCompactedVersion + 1, req.generation.committedVersion);
															#line 395 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5541 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<GetKnobsActor*>(this)->actor_wait_state = 6;
															#line 395 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GetKnobsActor, 5, Standalone<VectorRef<VersionedConfigMutationRef>> >*>(static_cast<GetKnobsActor*>(this)));
															#line 5546 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Version const& __lastCompactedVersion,int loopDepth) 
	{
															#line 394 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		lastCompactedVersion = __lastCompactedVersion;
															#line 5555 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Version && __lastCompactedVersion,int loopDepth) 
	{
		lastCompactedVersion = std::move(__lastCompactedVersion);
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetKnobsActor*>(this)->actor_wait_state > 0) static_cast<GetKnobsActor*>(this)->actor_wait_state = 0;
		static_cast<GetKnobsActor*>(this)->ActorCallback< GetKnobsActor, 4, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetKnobsActor, 4, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getKnobs", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobs", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetKnobsActor, 4, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getKnobs", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobs", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetKnobsActor, 4, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getKnobs", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobs", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11(int loopDepth) 
	{
															#line 397 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& versionedMutation : mutations ) {
															#line 398 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (versionedMutation.mutation.getConfigClass().template castTo<Key>() == req.configClass)
															#line 5636 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			{
															#line 399 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				if (versionedMutation.mutation.isSet())
															#line 5640 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				{
															#line 400 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
					knobSet.insert(versionedMutation.mutation.getKnobName());
															#line 5644 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				}
				else
				{
															#line 402 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
					knobSet.erase(versionedMutation.mutation.getKnobName());
															#line 5650 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				}
			}
		}
															#line 406 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		Standalone<VectorRef<KeyRef>> knobNames;
															#line 407 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& knobName : knobSet ) {
															#line 408 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			knobNames.push_back_deep(knobNames.arena(), knobName);
															#line 5660 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
															#line 410 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(ConfigTransactionGetKnobsReply{ knobNames });
															#line 411 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetKnobsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetKnobsActorState(); static_cast<GetKnobsActor*>(this)->destroy(); return 0; }
															#line 5666 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetKnobsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetKnobsActorState();
		static_cast<GetKnobsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8when1(Standalone<VectorRef<VersionedConfigMutationRef>> const& __mutations,int loopDepth) 
	{
															#line 395 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		mutations = __mutations;
															#line 5678 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Standalone<VectorRef<VersionedConfigMutationRef>> && __mutations,int loopDepth) 
	{
		mutations = std::move(__mutations);
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GetKnobsActor*>(this)->actor_wait_state > 0) static_cast<GetKnobsActor*>(this)->actor_wait_state = 0;
		static_cast<GetKnobsActor*>(this)->ActorCallback< GetKnobsActor, 5, Standalone<VectorRef<VersionedConfigMutationRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetKnobsActor, 5, Standalone<VectorRef<VersionedConfigMutationRef>> >*,Standalone<VectorRef<VersionedConfigMutationRef>> const& value) 
	{
		fdb_probe_actor_enter("getKnobs", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobs", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< GetKnobsActor, 5, Standalone<VectorRef<VersionedConfigMutationRef>> >*,Standalone<VectorRef<VersionedConfigMutationRef>> && value) 
	{
		fdb_probe_actor_enter("getKnobs", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobs", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< GetKnobsActor, 5, Standalone<VectorRef<VersionedConfigMutationRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("getKnobs", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobs", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 366 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 366 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigTransactionGetKnobsRequest req;
															#line 367 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Optional<CoordinatorsHash> locked;
															#line 373 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	CoordinatorsHash coordinatorsHash;
															#line 385 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	RangeResult snapshot;
															#line 386 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	std::set<Key> knobSet;
															#line 394 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Version lastCompactedVersion;
															#line 395 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Standalone<VectorRef<VersionedConfigMutationRef>> mutations;
															#line 5769 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via getKnobs()
															#line 366 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetKnobsActor final : public Actor<Void>, public ActorCallback< GetKnobsActor, 0, Optional<CoordinatorsHash> >, public ActorCallback< GetKnobsActor, 1, CoordinatorsHash >, public ActorCallback< GetKnobsActor, 2, ConfigGeneration >, public ActorCallback< GetKnobsActor, 3, RangeResult >, public ActorCallback< GetKnobsActor, 4, Version >, public ActorCallback< GetKnobsActor, 5, Standalone<VectorRef<VersionedConfigMutationRef>> >, public FastAllocated<GetKnobsActor>, public GetKnobsActorState<GetKnobsActor> {
															#line 5774 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<GetKnobsActor>::operator new;
	using FastAllocated<GetKnobsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12086926939672666880UL, 3416921016608075776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKnobsActor, 0, Optional<CoordinatorsHash> >;
friend struct ActorCallback< GetKnobsActor, 1, CoordinatorsHash >;
friend struct ActorCallback< GetKnobsActor, 2, ConfigGeneration >;
friend struct ActorCallback< GetKnobsActor, 3, RangeResult >;
friend struct ActorCallback< GetKnobsActor, 4, Version >;
friend struct ActorCallback< GetKnobsActor, 5, Standalone<VectorRef<VersionedConfigMutationRef>> >;
															#line 366 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetKnobsActor(ConfigNodeImpl* const& self,ConfigTransactionGetKnobsRequest const& req) 
															#line 5796 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Void>(),
		   GetKnobsActorState<GetKnobsActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKnobs", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16400799140778695424UL, 340779060613940736UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKnobs");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKnobs", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKnobsActor, 0, Optional<CoordinatorsHash> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKnobsActor, 1, CoordinatorsHash >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetKnobsActor, 2, ConfigGeneration >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetKnobsActor, 3, RangeResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetKnobsActor, 4, Version >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GetKnobsActor, 5, Standalone<VectorRef<VersionedConfigMutationRef>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 366 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Void> getKnobs( ConfigNodeImpl* const& self, ConfigTransactionGetKnobsRequest const& req ) {
															#line 366 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Void>(new GetKnobsActor(self, req));
															#line 5833 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 413 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

																#line 5838 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via commitMutations()
															#line 414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class CommitMutationsActor>
															#line 414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class CommitMutationsActorState {
															#line 5844 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	CommitMutationsActorState(ConfigNodeImpl* const& self,Standalone<VectorRef<VersionedConfigMutationRef>> const& mutations,Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> const& annotations,Version const& commitVersion,Version const& liveVersion = ::invalidVersion) 
															#line 414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   mutations(mutations),
															#line 414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   annotations(annotations),
															#line 414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   commitVersion(commitVersion),
															#line 414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   liveVersion(liveVersion)
															#line 5859 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("commitMutations", reinterpret_cast<unsigned long>(this));

	}
	~CommitMutationsActorState() 
	{
		fdb_probe_actor_destroy("commitMutations", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 419 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->lock.take();
															#line 419 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<CommitMutationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5876 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CommitMutationsActor*>(this)->actor_wait_state = 1;
															#line 419 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitMutationsActor, 0, Void >*>(static_cast<CommitMutationsActor*>(this)));
															#line 5881 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitMutationsActorState();
		static_cast<CommitMutationsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 420 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		releaser = FlowLock::Releaser(self->lock);
															#line 421 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		Version latestVersion = 0;
															#line 422 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		int index = 0;
															#line 423 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& mutation : mutations ) {
															#line 424 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (mutation.version > commitVersion)
															#line 5912 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			{
				continue;
			}
															#line 428 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			ASSERT_GE(mutation.version, latestVersion);
															#line 429 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (mutation.version > latestVersion)
															#line 5920 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			{
															#line 430 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				latestVersion = mutation.version;
															#line 431 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				index = 0;
															#line 5926 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			}
															#line 433 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			Key key = versionedMutationKey(mutation.version, index++);
															#line 434 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			Value value = ObjectWriter::toValue(mutation.mutation, IncludeVersion());
															#line 435 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (mutation.mutation.isSet())
															#line 5934 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			{
															#line 436 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				TraceEvent("ConfigNodeSetting") .detail("ConfigClass", mutation.mutation.getConfigClass()) .detail("KnobName", mutation.mutation.getKnobName()) .detail("Value", mutation.mutation.getValue().toString()) .detail("Version", mutation.version);
															#line 441 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				++self->setMutations;
															#line 5940 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			}
			else
			{
															#line 443 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				++self->clearMutations;
															#line 5946 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			}
															#line 445 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			self->kvStore->set(KeyValueRef(key, value));
															#line 5950 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
															#line 447 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& annotation : annotations ) {
															#line 448 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			self->kvStore->set(KeyValueRef(versionedAnnotationKey(annotation.version), BinaryWriter::toValue(annotation.annotation, IncludeVersion())));
															#line 5956 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
															#line 451 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		ConfigGeneration newGeneration = { commitVersion, commitVersion };
															#line 452 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (liveVersion != ::invalidVersion)
															#line 5962 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 453 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			newGeneration.liveVersion = liveVersion;
															#line 5966 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
															#line 455 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		self->kvStore->set(KeyValueRef(currentGenerationKey, BinaryWriter::toValue(newGeneration, IncludeVersion())));
															#line 456 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->kvStore->commit();
															#line 456 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<CommitMutationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5974 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CommitMutationsActor*>(this)->actor_wait_state = 2;
															#line 456 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CommitMutationsActor, 1, Void >*>(static_cast<CommitMutationsActor*>(this)));
															#line 5979 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 420 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		releaser = FlowLock::Releaser(self->lock);
															#line 421 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		Version latestVersion = 0;
															#line 422 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		int index = 0;
															#line 423 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& mutation : mutations ) {
															#line 424 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (mutation.version > commitVersion)
															#line 5996 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			{
				continue;
			}
															#line 428 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			ASSERT_GE(mutation.version, latestVersion);
															#line 429 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (mutation.version > latestVersion)
															#line 6004 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			{
															#line 430 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				latestVersion = mutation.version;
															#line 431 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				index = 0;
															#line 6010 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			}
															#line 433 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			Key key = versionedMutationKey(mutation.version, index++);
															#line 434 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			Value value = ObjectWriter::toValue(mutation.mutation, IncludeVersion());
															#line 435 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (mutation.mutation.isSet())
															#line 6018 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			{
															#line 436 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				TraceEvent("ConfigNodeSetting") .detail("ConfigClass", mutation.mutation.getConfigClass()) .detail("KnobName", mutation.mutation.getKnobName()) .detail("Value", mutation.mutation.getValue().toString()) .detail("Version", mutation.version);
															#line 441 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				++self->setMutations;
															#line 6024 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			}
			else
			{
															#line 443 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				++self->clearMutations;
															#line 6030 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			}
															#line 445 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			self->kvStore->set(KeyValueRef(key, value));
															#line 6034 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
															#line 447 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& annotation : annotations ) {
															#line 448 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			self->kvStore->set(KeyValueRef(versionedAnnotationKey(annotation.version), BinaryWriter::toValue(annotation.annotation, IncludeVersion())));
															#line 6040 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
															#line 451 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		ConfigGeneration newGeneration = { commitVersion, commitVersion };
															#line 452 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (liveVersion != ::invalidVersion)
															#line 6046 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 453 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			newGeneration.liveVersion = liveVersion;
															#line 6050 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
															#line 455 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		self->kvStore->set(KeyValueRef(currentGenerationKey, BinaryWriter::toValue(newGeneration, IncludeVersion())));
															#line 456 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->kvStore->commit();
															#line 456 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<CommitMutationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6058 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CommitMutationsActor*>(this)->actor_wait_state = 2;
															#line 456 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CommitMutationsActor, 1, Void >*>(static_cast<CommitMutationsActor*>(this)));
															#line 6063 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitMutationsActor*>(this)->actor_wait_state > 0) static_cast<CommitMutationsActor*>(this)->actor_wait_state = 0;
		static_cast<CommitMutationsActor*>(this)->ActorCallback< CommitMutationsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitMutationsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitMutationsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitMutationsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 457 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		++self->successfulCommits;
															#line 458 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<CommitMutationsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitMutationsActorState(); static_cast<CommitMutationsActor*>(this)->destroy(); return 0; }
															#line 6149 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<CommitMutationsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitMutationsActorState();
		static_cast<CommitMutationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 457 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		++self->successfulCommits;
															#line 458 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<CommitMutationsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitMutationsActorState(); static_cast<CommitMutationsActor*>(this)->destroy(); return 0; }
															#line 6163 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<CommitMutationsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitMutationsActorState();
		static_cast<CommitMutationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CommitMutationsActor*>(this)->actor_wait_state > 0) static_cast<CommitMutationsActor*>(this)->actor_wait_state = 0;
		static_cast<CommitMutationsActor*>(this)->ActorCallback< CommitMutationsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitMutationsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitMutations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitMutations", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CommitMutationsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitMutations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitMutations", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CommitMutationsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitMutations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitMutations", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Standalone<VectorRef<VersionedConfigMutationRef>> mutations;
															#line 414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> annotations;
															#line 414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Version commitVersion;
															#line 414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Version liveVersion;
															#line 420 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	FlowLock::Releaser releaser;
															#line 6258 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via commitMutations()
															#line 414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class CommitMutationsActor final : public Actor<Void>, public ActorCallback< CommitMutationsActor, 0, Void >, public ActorCallback< CommitMutationsActor, 1, Void >, public FastAllocated<CommitMutationsActor>, public CommitMutationsActorState<CommitMutationsActor> {
															#line 6263 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<CommitMutationsActor>::operator new;
	using FastAllocated<CommitMutationsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3473926865840979712UL, 1114150076155255040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitMutationsActor, 0, Void >;
friend struct ActorCallback< CommitMutationsActor, 1, Void >;
															#line 414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	CommitMutationsActor(ConfigNodeImpl* const& self,Standalone<VectorRef<VersionedConfigMutationRef>> const& mutations,Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> const& annotations,Version const& commitVersion,Version const& liveVersion = ::invalidVersion) 
															#line 6281 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Void>(),
		   CommitMutationsActorState<CommitMutationsActor>(self, mutations, annotations, commitVersion, liveVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitMutations", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14925649339041249792UL, 6868396838402094592UL);
		ActorExecutionContextHelper __helper(static_cast<CommitMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitMutations");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitMutations", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitMutationsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CommitMutationsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Void> commitMutations( ConfigNodeImpl* const& self, Standalone<VectorRef<VersionedConfigMutationRef>> const& mutations, Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> const& annotations, Version const& commitVersion, Version const& liveVersion = ::invalidVersion ) {
															#line 414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Void>(new CommitMutationsActor(self, mutations, annotations, commitVersion, liveVersion));
															#line 6314 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 460 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

																#line 6319 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via commit()
															#line 461 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class CommitActor>
															#line 461 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class CommitActorState {
															#line 6325 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 461 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	CommitActorState(ConfigNodeImpl* const& self,ConfigTransactionCommitRequest const& req) 
															#line 461 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 461 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 461 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   req(req)
															#line 6334 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("commit", reinterpret_cast<unsigned long>(this));

	}
	~CommitActorState() 
	{
		fdb_probe_actor_destroy("commit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 462 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Optional<CoordinatorsHash>> __when_expr_0 = getLocked(self);
															#line 462 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<CommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6351 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CommitActor*>(this)->actor_wait_state = 1;
															#line 462 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitActor, 0, Optional<CoordinatorsHash> >*>(static_cast<CommitActor*>(this)));
															#line 6356 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitActorState();
		static_cast<CommitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 463 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (locked.present())
															#line 6379 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 464 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			CODE_PROBE(true, "attempting to write to locked ConfigNode");
															#line 465 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(coordinators_changed());
															#line 466 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<CommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitActorState(); static_cast<CommitActor*>(this)->destroy(); return 0; }
															#line 6387 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<CommitActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CommitActorState();
			static_cast<CommitActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 468 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<CoordinatorsHash> __when_expr_1 = getCoordinatorsHash(self);
															#line 468 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<CommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6397 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CommitActor*>(this)->actor_wait_state = 2;
															#line 468 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CommitActor, 1, CoordinatorsHash >*>(static_cast<CommitActor*>(this)));
															#line 6402 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<CoordinatorsHash> const& __locked,int loopDepth) 
	{
															#line 462 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		locked = __locked;
															#line 6411 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<CoordinatorsHash> && __locked,int loopDepth) 
	{
		locked = std::move(__locked);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitActor*>(this)->actor_wait_state > 0) static_cast<CommitActor*>(this)->actor_wait_state = 0;
		static_cast<CommitActor*>(this)->ActorCallback< CommitActor, 0, Optional<CoordinatorsHash> >::remove();

	}
	void a_callback_fire(ActorCallback< CommitActor, 0, Optional<CoordinatorsHash> >*,Optional<CoordinatorsHash> const& value) 
	{
		fdb_probe_actor_enter("commit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitActor, 0, Optional<CoordinatorsHash> >*,Optional<CoordinatorsHash> && value) 
	{
		fdb_probe_actor_enter("commit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitActor, 0, Optional<CoordinatorsHash> >*,Error err) 
	{
		fdb_probe_actor_enter("commit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 469 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.coordinatorsHash != coordinatorsHash)
															#line 6490 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 470 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(coordinators_changed());
															#line 471 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<CommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitActorState(); static_cast<CommitActor*>(this)->destroy(); return 0; }
															#line 6496 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<CommitActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CommitActorState();
			static_cast<CommitActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 474 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<ConfigGeneration> __when_expr_2 = getGeneration(self);
															#line 474 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<CommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6506 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CommitActor*>(this)->actor_wait_state = 3;
															#line 474 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CommitActor, 2, ConfigGeneration >*>(static_cast<CommitActor*>(this)));
															#line 6511 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(CoordinatorsHash const& __coordinatorsHash,int loopDepth) 
	{
															#line 468 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		coordinatorsHash = __coordinatorsHash;
															#line 6520 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(CoordinatorsHash && __coordinatorsHash,int loopDepth) 
	{
		coordinatorsHash = std::move(__coordinatorsHash);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CommitActor*>(this)->actor_wait_state > 0) static_cast<CommitActor*>(this)->actor_wait_state = 0;
		static_cast<CommitActor*>(this)->ActorCallback< CommitActor, 1, CoordinatorsHash >::remove();

	}
	void a_callback_fire(ActorCallback< CommitActor, 1, CoordinatorsHash >*,CoordinatorsHash const& value) 
	{
		fdb_probe_actor_enter("commit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CommitActor, 1, CoordinatorsHash >*,CoordinatorsHash && value) 
	{
		fdb_probe_actor_enter("commit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CommitActor, 1, CoordinatorsHash >*,Error err) 
	{
		fdb_probe_actor_enter("commit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commit", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(ConfigGeneration const& currentGeneration,int loopDepth) 
	{
															#line 475 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.generation.committedVersion != currentGeneration.committedVersion)
															#line 6599 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 476 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			++self->failedCommits;
															#line 477 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(commit_unknown_result());
															#line 478 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<CommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitActorState(); static_cast<CommitActor*>(this)->destroy(); return 0; }
															#line 6607 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<CommitActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CommitActorState();
			static_cast<CommitActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 479 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (req.generation.liveVersion != currentGeneration.liveVersion)
															#line 6617 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			{
															#line 480 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				++self->failedCommits;
															#line 481 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				req.reply.sendError(not_committed());
															#line 482 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				if (!static_cast<CommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitActorState(); static_cast<CommitActor*>(this)->destroy(); return 0; }
															#line 6625 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				new (&static_cast<CommitActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CommitActorState();
				static_cast<CommitActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 484 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		Standalone<VectorRef<VersionedConfigMutationRef>> mutations;
															#line 485 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& mutation : req.mutations ) {
															#line 486 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			mutations.emplace_back_deep(mutations.arena(), req.generation.liveVersion, mutation);
															#line 6638 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
															#line 488 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> annotations;
															#line 489 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		annotations.emplace_back_deep(annotations.arena(), req.generation.liveVersion, req.annotation);
															#line 491 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_3 = commitMutations(self, mutations, annotations, req.generation.liveVersion);
															#line 491 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<CommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6648 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CommitActor*>(this)->actor_wait_state = 4;
															#line 491 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CommitActor, 3, Void >*>(static_cast<CommitActor*>(this)));
															#line 6653 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(ConfigGeneration && currentGeneration,int loopDepth) 
	{
															#line 475 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.generation.committedVersion != currentGeneration.committedVersion)
															#line 6662 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 476 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			++self->failedCommits;
															#line 477 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(commit_unknown_result());
															#line 478 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<CommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitActorState(); static_cast<CommitActor*>(this)->destroy(); return 0; }
															#line 6670 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<CommitActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CommitActorState();
			static_cast<CommitActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 479 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (req.generation.liveVersion != currentGeneration.liveVersion)
															#line 6680 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			{
															#line 480 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				++self->failedCommits;
															#line 481 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				req.reply.sendError(not_committed());
															#line 482 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				if (!static_cast<CommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitActorState(); static_cast<CommitActor*>(this)->destroy(); return 0; }
															#line 6688 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				new (&static_cast<CommitActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CommitActorState();
				static_cast<CommitActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 484 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		Standalone<VectorRef<VersionedConfigMutationRef>> mutations;
															#line 485 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& mutation : req.mutations ) {
															#line 486 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			mutations.emplace_back_deep(mutations.arena(), req.generation.liveVersion, mutation);
															#line 6701 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
															#line 488 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> annotations;
															#line 489 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		annotations.emplace_back_deep(annotations.arena(), req.generation.liveVersion, req.annotation);
															#line 491 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_3 = commitMutations(self, mutations, annotations, req.generation.liveVersion);
															#line 491 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<CommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6711 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CommitActor*>(this)->actor_wait_state = 4;
															#line 491 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CommitActor, 3, Void >*>(static_cast<CommitActor*>(this)));
															#line 6716 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(ConfigGeneration const& currentGeneration,int loopDepth) 
	{
		loopDepth = a_body1cont4(currentGeneration, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(ConfigGeneration && currentGeneration,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(currentGeneration), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CommitActor*>(this)->actor_wait_state > 0) static_cast<CommitActor*>(this)->actor_wait_state = 0;
		static_cast<CommitActor*>(this)->ActorCallback< CommitActor, 2, ConfigGeneration >::remove();

	}
	void a_callback_fire(ActorCallback< CommitActor, 2, ConfigGeneration >*,ConfigGeneration const& value) 
	{
		fdb_probe_actor_enter("commit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CommitActor, 2, ConfigGeneration >*,ConfigGeneration && value) 
	{
		fdb_probe_actor_enter("commit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CommitActor, 2, ConfigGeneration >*,Error err) 
	{
		fdb_probe_actor_enter("commit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commit", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 492 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(Void());
															#line 493 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<CommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitActorState(); static_cast<CommitActor*>(this)->destroy(); return 0; }
															#line 6802 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<CommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitActorState();
		static_cast<CommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 492 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(Void());
															#line 493 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<CommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitActorState(); static_cast<CommitActor*>(this)->destroy(); return 0; }
															#line 6816 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<CommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitActorState();
		static_cast<CommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CommitActor*>(this)->actor_wait_state > 0) static_cast<CommitActor*>(this)->actor_wait_state = 0;
		static_cast<CommitActor*>(this)->ActorCallback< CommitActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CommitActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CommitActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commit", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 461 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 461 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigTransactionCommitRequest req;
															#line 462 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Optional<CoordinatorsHash> locked;
															#line 468 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	CoordinatorsHash coordinatorsHash;
															#line 6907 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via commit()
															#line 461 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class CommitActor final : public Actor<Void>, public ActorCallback< CommitActor, 0, Optional<CoordinatorsHash> >, public ActorCallback< CommitActor, 1, CoordinatorsHash >, public ActorCallback< CommitActor, 2, ConfigGeneration >, public ActorCallback< CommitActor, 3, Void >, public FastAllocated<CommitActor>, public CommitActorState<CommitActor> {
															#line 6912 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<CommitActor>::operator new;
	using FastAllocated<CommitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9619243734288569344UL, 3206618447121892864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitActor, 0, Optional<CoordinatorsHash> >;
friend struct ActorCallback< CommitActor, 1, CoordinatorsHash >;
friend struct ActorCallback< CommitActor, 2, ConfigGeneration >;
friend struct ActorCallback< CommitActor, 3, Void >;
															#line 461 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	CommitActor(ConfigNodeImpl* const& self,ConfigTransactionCommitRequest const& req) 
															#line 6932 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Void>(),
		   CommitActorState<CommitActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5783256204963666432UL, 4458479240597560576UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitActor, 0, Optional<CoordinatorsHash> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CommitActor, 1, CoordinatorsHash >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CommitActor, 2, ConfigGeneration >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CommitActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 461 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Void> commit( ConfigNodeImpl* const& self, ConfigTransactionCommitRequest const& req ) {
															#line 461 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Void>(new CommitActor(self, req));
															#line 6967 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 495 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

																#line 6972 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via serve()
															#line 496 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class ServeActor>
															#line 496 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class ServeActorState {
															#line 6978 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 496 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ServeActorState(ConfigNodeImpl* const& self,ConfigTransactionInterface const* const& cti) 
															#line 496 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 496 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 496 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   cti(cti)
															#line 6987 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("serve", reinterpret_cast<unsigned long>(this));

	}
	~ServeActorState() 
	{
		fdb_probe_actor_destroy("serve", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 497 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			;
															#line 7002 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServeActorState();
		static_cast<ServeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 499 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		auto __when_expr_0 = cti->getGeneration.getFuture();
															#line 7032 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ConfigTransactionGetGenerationRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ConfigTransactionGetGenerationRequest>>::value, "invalid type");
															#line 498 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7036 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 503 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		auto __when_expr_1 = cti->get.getFuture();
															#line 7040 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<ConfigTransactionGetRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<ConfigTransactionGetRequest>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 507 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		auto __when_expr_2 = cti->commit.getFuture();
															#line 7045 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<ConfigTransactionCommitRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<ConfigTransactionCommitRequest>>::value, "invalid type");
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
															#line 510 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		auto __when_expr_3 = cti->getClasses.getFuture();
															#line 7050 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<ConfigTransactionGetConfigClassesRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<ConfigTransactionGetConfigClassesRequest>>::value, "invalid type");
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.pop(), loopDepth); };
															#line 513 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		auto __when_expr_4 = cti->getKnobs.getFuture();
															#line 7055 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<ConfigTransactionGetKnobsRequest>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<ConfigTransactionGetKnobsRequest>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5(__when_expr_4.pop(), loopDepth); };
															#line 516 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->kvStore->getError();
															#line 7060 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when6(__when_expr_5.get(), loopDepth); };
		static_cast<ServeActor*>(this)->actor_wait_state = 1;
															#line 499 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ServeActor, 0, ConfigTransactionGetGenerationRequest >*>(static_cast<ServeActor*>(this)));
															#line 503 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< ServeActor, 1, ConfigTransactionGetRequest >*>(static_cast<ServeActor*>(this)));
															#line 507 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< ServeActor, 2, ConfigTransactionCommitRequest >*>(static_cast<ServeActor*>(this)));
															#line 510 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< ServeActor, 3, ConfigTransactionGetConfigClassesRequest >*>(static_cast<ServeActor*>(this)));
															#line 513 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< ServeActor, 4, ConfigTransactionGetKnobsRequest >*>(static_cast<ServeActor*>(this)));
															#line 516 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ServeActor, 5, Void >*>(static_cast<ServeActor*>(this)));
															#line 7075 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(ConfigTransactionGetGenerationRequest const& req,int loopDepth) 
	{
															#line 500 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		++self->getGenerationRequests;
															#line 501 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_6 = getNewGeneration(self, req);
															#line 501 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7094 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_6.get(), loopDepth); };
		static_cast<ServeActor*>(this)->actor_wait_state = 2;
															#line 501 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ServeActor, 6, Void >*>(static_cast<ServeActor*>(this)));
															#line 7099 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(ConfigTransactionGetGenerationRequest && req,int loopDepth) 
	{
															#line 500 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		++self->getGenerationRequests;
															#line 501 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_6 = getNewGeneration(self, req);
															#line 501 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7112 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_6.get(), loopDepth); };
		static_cast<ServeActor*>(this)->actor_wait_state = 2;
															#line 501 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ServeActor, 6, Void >*>(static_cast<ServeActor*>(this)));
															#line 7117 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(ConfigTransactionGetRequest const& req,int loopDepth) 
	{
															#line 504 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		++self->getValueRequests;
															#line 505 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_7 = get(self, req);
															#line 505 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7130 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_7.get(), loopDepth); };
		static_cast<ServeActor*>(this)->actor_wait_state = 3;
															#line 505 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ServeActor, 7, Void >*>(static_cast<ServeActor*>(this)));
															#line 7135 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(ConfigTransactionGetRequest && req,int loopDepth) 
	{
															#line 504 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		++self->getValueRequests;
															#line 505 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_7 = get(self, req);
															#line 505 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7148 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_7.get(), loopDepth); };
		static_cast<ServeActor*>(this)->actor_wait_state = 3;
															#line 505 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ServeActor, 7, Void >*>(static_cast<ServeActor*>(this)));
															#line 7153 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when3(ConfigTransactionCommitRequest const& req,int loopDepth) 
	{
															#line 508 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_8 = commit(self, req);
															#line 508 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7164 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3when1(__when_expr_8.get(), loopDepth); };
		static_cast<ServeActor*>(this)->actor_wait_state = 4;
															#line 508 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ServeActor, 8, Void >*>(static_cast<ServeActor*>(this)));
															#line 7169 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when3(ConfigTransactionCommitRequest && req,int loopDepth) 
	{
															#line 508 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_8 = commit(self, req);
															#line 508 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7180 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3when1(__when_expr_8.get(), loopDepth); };
		static_cast<ServeActor*>(this)->actor_wait_state = 4;
															#line 508 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ServeActor, 8, Void >*>(static_cast<ServeActor*>(this)));
															#line 7185 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when4(ConfigTransactionGetConfigClassesRequest const& req,int loopDepth) 
	{
															#line 511 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_9 = getConfigClasses(self, req);
															#line 511 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7196 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4when1(__when_expr_9.get(), loopDepth); };
		static_cast<ServeActor*>(this)->actor_wait_state = 5;
															#line 511 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ServeActor, 9, Void >*>(static_cast<ServeActor*>(this)));
															#line 7201 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when4(ConfigTransactionGetConfigClassesRequest && req,int loopDepth) 
	{
															#line 511 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_9 = getConfigClasses(self, req);
															#line 511 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7212 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4when1(__when_expr_9.get(), loopDepth); };
		static_cast<ServeActor*>(this)->actor_wait_state = 5;
															#line 511 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ServeActor, 9, Void >*>(static_cast<ServeActor*>(this)));
															#line 7217 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when5(ConfigTransactionGetKnobsRequest const& req,int loopDepth) 
	{
															#line 514 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_10 = getKnobs(self, req);
															#line 514 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7228 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5when1(__when_expr_10.get(), loopDepth); };
		static_cast<ServeActor*>(this)->actor_wait_state = 6;
															#line 514 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ServeActor, 10, Void >*>(static_cast<ServeActor*>(this)));
															#line 7233 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when5(ConfigTransactionGetKnobsRequest && req,int loopDepth) 
	{
															#line 514 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_10 = getKnobs(self, req);
															#line 514 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7244 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5when1(__when_expr_10.get(), loopDepth); };
		static_cast<ServeActor*>(this)->actor_wait_state = 6;
															#line 514 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ServeActor, 10, Void >*>(static_cast<ServeActor*>(this)));
															#line 7249 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when6(Void const& _,int loopDepth) 
	{
															#line 517 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		ASSERT(false);
															#line 7258 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(Void && _,int loopDepth) 
	{
															#line 517 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		ASSERT(false);
															#line 7267 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServeActor*>(this)->actor_wait_state > 0) static_cast<ServeActor*>(this)->actor_wait_state = 0;
		static_cast<ServeActor*>(this)->ActorSingleCallback< ServeActor, 0, ConfigTransactionGetGenerationRequest >::remove();
		static_cast<ServeActor*>(this)->ActorSingleCallback< ServeActor, 1, ConfigTransactionGetRequest >::remove();
		static_cast<ServeActor*>(this)->ActorSingleCallback< ServeActor, 2, ConfigTransactionCommitRequest >::remove();
		static_cast<ServeActor*>(this)->ActorSingleCallback< ServeActor, 3, ConfigTransactionGetConfigClassesRequest >::remove();
		static_cast<ServeActor*>(this)->ActorSingleCallback< ServeActor, 4, ConfigTransactionGetKnobsRequest >::remove();
		static_cast<ServeActor*>(this)->ActorCallback< ServeActor, 5, Void >::remove();

	}
	int a_body1loopBody1when1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ServeActor*>(this)->actor_wait_state > 0) static_cast<ServeActor*>(this)->actor_wait_state = 0;
		static_cast<ServeActor*>(this)->ActorCallback< ServeActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ServeActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ServeActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< ServeActor, 0, ConfigTransactionGetGenerationRequest >*,ConfigTransactionGetGenerationRequest const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ServeActor, 0, ConfigTransactionGetGenerationRequest >*,ConfigTransactionGetGenerationRequest && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ServeActor, 0, ConfigTransactionGetGenerationRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ServeActor*>(this)->actor_wait_state > 0) static_cast<ServeActor*>(this)->actor_wait_state = 0;
		static_cast<ServeActor*>(this)->ActorCallback< ServeActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ServeActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ServeActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< ServeActor, 1, ConfigTransactionGetRequest >*,ConfigTransactionGetRequest const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ServeActor, 1, ConfigTransactionGetRequest >*,ConfigTransactionGetRequest && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< ServeActor, 1, ConfigTransactionGetRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1when3cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when3cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when3cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ServeActor*>(this)->actor_wait_state > 0) static_cast<ServeActor*>(this)->actor_wait_state = 0;
		static_cast<ServeActor*>(this)->ActorCallback< ServeActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ServeActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ServeActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorSingleCallback< ServeActor, 2, ConfigTransactionCommitRequest >*,ConfigTransactionCommitRequest const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< ServeActor, 2, ConfigTransactionCommitRequest >*,ConfigTransactionCommitRequest && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< ServeActor, 2, ConfigTransactionCommitRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1when4cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when4cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when4cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ServeActor*>(this)->actor_wait_state > 0) static_cast<ServeActor*>(this)->actor_wait_state = 0;
		static_cast<ServeActor*>(this)->ActorCallback< ServeActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ServeActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ServeActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorSingleCallback< ServeActor, 3, ConfigTransactionGetConfigClassesRequest >*,ConfigTransactionGetConfigClassesRequest const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< ServeActor, 3, ConfigTransactionGetConfigClassesRequest >*,ConfigTransactionGetConfigClassesRequest && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< ServeActor, 3, ConfigTransactionGetConfigClassesRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1when5cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when5cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when5cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ServeActor*>(this)->actor_wait_state > 0) static_cast<ServeActor*>(this)->actor_wait_state = 0;
		static_cast<ServeActor*>(this)->ActorCallback< ServeActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1when5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ServeActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1when5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ServeActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorSingleCallback< ServeActor, 4, ConfigTransactionGetKnobsRequest >*,ConfigTransactionGetKnobsRequest const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< ServeActor, 4, ConfigTransactionGetKnobsRequest >*,ConfigTransactionGetKnobsRequest && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< ServeActor, 4, ConfigTransactionGetKnobsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ServeActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ServeActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ServeActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 496 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 496 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigTransactionInterface const* cti;
															#line 8064 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via serve()
															#line 496 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class ServeActor final : public Actor<Void>, public ActorSingleCallback< ServeActor, 0, ConfigTransactionGetGenerationRequest >, public ActorCallback< ServeActor, 6, Void >, public ActorSingleCallback< ServeActor, 1, ConfigTransactionGetRequest >, public ActorCallback< ServeActor, 7, Void >, public ActorSingleCallback< ServeActor, 2, ConfigTransactionCommitRequest >, public ActorCallback< ServeActor, 8, Void >, public ActorSingleCallback< ServeActor, 3, ConfigTransactionGetConfigClassesRequest >, public ActorCallback< ServeActor, 9, Void >, public ActorSingleCallback< ServeActor, 4, ConfigTransactionGetKnobsRequest >, public ActorCallback< ServeActor, 10, Void >, public ActorCallback< ServeActor, 5, Void >, public FastAllocated<ServeActor>, public ServeActorState<ServeActor> {
															#line 8069 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<ServeActor>::operator new;
	using FastAllocated<ServeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17335076387217348608UL, 15581730969420681728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ServeActor, 0, ConfigTransactionGetGenerationRequest >;
friend struct ActorCallback< ServeActor, 6, Void >;
friend struct ActorSingleCallback< ServeActor, 1, ConfigTransactionGetRequest >;
friend struct ActorCallback< ServeActor, 7, Void >;
friend struct ActorSingleCallback< ServeActor, 2, ConfigTransactionCommitRequest >;
friend struct ActorCallback< ServeActor, 8, Void >;
friend struct ActorSingleCallback< ServeActor, 3, ConfigTransactionGetConfigClassesRequest >;
friend struct ActorCallback< ServeActor, 9, Void >;
friend struct ActorSingleCallback< ServeActor, 4, ConfigTransactionGetKnobsRequest >;
friend struct ActorCallback< ServeActor, 10, Void >;
friend struct ActorCallback< ServeActor, 5, Void >;
															#line 496 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ServeActor(ConfigNodeImpl* const& self,ConfigTransactionInterface const* const& cti) 
															#line 8096 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Void>(),
		   ServeActorState<ServeActor>(self, cti),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6924154940913281280UL, 2717420985526338560UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serve");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ServeActor, 0, ConfigTransactionGetGenerationRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ServeActor, 6, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ServeActor, 7, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ServeActor, 8, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ServeActor, 9, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ServeActor, 10, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 496 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Void> serve( ConfigNodeImpl* const& self, ConfigTransactionInterface const* const& cti ) {
															#line 496 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Void>(new ServeActor(self, cti));
															#line 8133 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 522 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

																#line 8138 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via getSnapshotAndChanges()
															#line 523 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class GetSnapshotAndChangesActor>
															#line 523 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetSnapshotAndChangesActorState {
															#line 8144 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 523 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetSnapshotAndChangesActorState(ConfigNodeImpl* const& self,ConfigFollowerGetSnapshotAndChangesRequest const& req) 
															#line 523 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 523 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 523 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   req(req),
															#line 525 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   reply()
															#line 8155 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this));

	}
	~GetSnapshotAndChangesActorState() 
	{
		fdb_probe_actor_destroy("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 526 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = self->kvStore->readRange(kvKeys);
															#line 526 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8172 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 1;
															#line 526 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotAndChangesActor, 0, RangeResult >*>(static_cast<GetSnapshotAndChangesActor*>(this)));
															#line 8177 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetSnapshotAndChangesActorState();
		static_cast<GetSnapshotAndChangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& data,int loopDepth) 
	{
															#line 527 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& kv : data ) {
															#line 528 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			reply .snapshot[BinaryReader::fromStringRef<ConfigKey>(kv.key.removePrefix(kvKeys.begin), IncludeVersion())] = ObjectReader::fromStringRef<KnobValue>(kv.value, IncludeVersion());
															#line 8202 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
															#line 532 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(reply.snapshotVersion, getLastCompactedVersion(self));
															#line 532 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8208 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 2;
															#line 532 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotAndChangesActor, 1, Void >*>(static_cast<GetSnapshotAndChangesActor*>(this)));
															#line 8213 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && data,int loopDepth) 
	{
															#line 527 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& kv : data ) {
															#line 528 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			reply .snapshot[BinaryReader::fromStringRef<ConfigKey>(kv.key.removePrefix(kvKeys.begin), IncludeVersion())] = ObjectReader::fromStringRef<KnobValue>(kv.value, IncludeVersion());
															#line 8224 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
															#line 532 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(reply.snapshotVersion, getLastCompactedVersion(self));
															#line 532 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8230 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 2;
															#line 532 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotAndChangesActor, 1, Void >*>(static_cast<GetSnapshotAndChangesActor*>(this)));
															#line 8235 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& data,int loopDepth) 
	{
		loopDepth = a_body1cont1(data, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && data,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(data), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state > 0) static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetSnapshotAndChangesActor*>(this)->ActorCallback< GetSnapshotAndChangesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetSnapshotAndChangesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 533 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.mostRecentVersion < reply.snapshotVersion)
															#line 8319 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 541 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			CODE_PROBE(true, "ConfigNode ahead of consumer", probe::decoration::rare);
															#line 542 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(version_already_compacted());
															#line 543 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetSnapshotAndChangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetSnapshotAndChangesActorState(); static_cast<GetSnapshotAndChangesActor*>(this)->destroy(); return 0; }
															#line 8327 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetSnapshotAndChangesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetSnapshotAndChangesActorState();
			static_cast<GetSnapshotAndChangesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 545 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_2 = store(reply.changes, getMutations(self, reply.snapshotVersion + 1, req.mostRecentVersion));
															#line 545 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8337 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 3;
															#line 545 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotAndChangesActor, 2, Void >*>(static_cast<GetSnapshotAndChangesActor*>(this)));
															#line 8342 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 533 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.mostRecentVersion < reply.snapshotVersion)
															#line 8351 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 541 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			CODE_PROBE(true, "ConfigNode ahead of consumer", probe::decoration::rare);
															#line 542 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(version_already_compacted());
															#line 543 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<GetSnapshotAndChangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetSnapshotAndChangesActorState(); static_cast<GetSnapshotAndChangesActor*>(this)->destroy(); return 0; }
															#line 8359 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<GetSnapshotAndChangesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetSnapshotAndChangesActorState();
			static_cast<GetSnapshotAndChangesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 545 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_2 = store(reply.changes, getMutations(self, reply.snapshotVersion + 1, req.mostRecentVersion));
															#line 545 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8369 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 3;
															#line 545 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotAndChangesActor, 2, Void >*>(static_cast<GetSnapshotAndChangesActor*>(this)));
															#line 8374 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state > 0) static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetSnapshotAndChangesActor*>(this)->ActorCallback< GetSnapshotAndChangesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetSnapshotAndChangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 546 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(reply.annotations, getAnnotations(self, reply.snapshotVersion + 1, req.mostRecentVersion));
															#line 546 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8460 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 4;
															#line 546 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotAndChangesActor, 3, Void >*>(static_cast<GetSnapshotAndChangesActor*>(this)));
															#line 8465 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 546 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(reply.annotations, getAnnotations(self, reply.snapshotVersion + 1, req.mostRecentVersion));
															#line 546 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8476 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 4;
															#line 546 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotAndChangesActor, 3, Void >*>(static_cast<GetSnapshotAndChangesActor*>(this)));
															#line 8481 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state > 0) static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetSnapshotAndChangesActor*>(this)->ActorCallback< GetSnapshotAndChangesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetSnapshotAndChangesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 547 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		TraceEvent(SevInfo, "ConfigNodeGettingSnapshot", self->id) .detail("SnapshotVersion", reply.snapshotVersion) .detail("SnapshotSize", reply.snapshot.size()) .detail("ChangesSize", reply.changes.size()) .detail("AnnotationsSize", reply.annotations.size());
															#line 552 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(reply);
															#line 553 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetSnapshotAndChangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetSnapshotAndChangesActorState(); static_cast<GetSnapshotAndChangesActor*>(this)->destroy(); return 0; }
															#line 8569 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetSnapshotAndChangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetSnapshotAndChangesActorState();
		static_cast<GetSnapshotAndChangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 547 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		TraceEvent(SevInfo, "ConfigNodeGettingSnapshot", self->id) .detail("SnapshotVersion", reply.snapshotVersion) .detail("SnapshotSize", reply.snapshot.size()) .detail("ChangesSize", reply.changes.size()) .detail("AnnotationsSize", reply.annotations.size());
															#line 552 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(reply);
															#line 553 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetSnapshotAndChangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetSnapshotAndChangesActorState(); static_cast<GetSnapshotAndChangesActor*>(this)->destroy(); return 0; }
															#line 8585 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetSnapshotAndChangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetSnapshotAndChangesActorState();
		static_cast<GetSnapshotAndChangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state > 0) static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetSnapshotAndChangesActor*>(this)->ActorCallback< GetSnapshotAndChangesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetSnapshotAndChangesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 523 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 523 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigFollowerGetSnapshotAndChangesRequest req;
															#line 525 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigFollowerGetSnapshotAndChangesReply reply;
															#line 8674 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via getSnapshotAndChanges()
															#line 523 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetSnapshotAndChangesActor final : public Actor<Void>, public ActorCallback< GetSnapshotAndChangesActor, 0, RangeResult >, public ActorCallback< GetSnapshotAndChangesActor, 1, Void >, public ActorCallback< GetSnapshotAndChangesActor, 2, Void >, public ActorCallback< GetSnapshotAndChangesActor, 3, Void >, public FastAllocated<GetSnapshotAndChangesActor>, public GetSnapshotAndChangesActorState<GetSnapshotAndChangesActor> {
															#line 8679 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<GetSnapshotAndChangesActor>::operator new;
	using FastAllocated<GetSnapshotAndChangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18397595718215846656UL, 8850392758041157376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetSnapshotAndChangesActor, 0, RangeResult >;
friend struct ActorCallback< GetSnapshotAndChangesActor, 1, Void >;
friend struct ActorCallback< GetSnapshotAndChangesActor, 2, Void >;
friend struct ActorCallback< GetSnapshotAndChangesActor, 3, Void >;
															#line 523 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetSnapshotAndChangesActor(ConfigNodeImpl* const& self,ConfigFollowerGetSnapshotAndChangesRequest const& req) 
															#line 8699 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Void>(),
		   GetSnapshotAndChangesActorState<GetSnapshotAndChangesActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3162109226205960192UL, 17975068368386092544UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getSnapshotAndChanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetSnapshotAndChangesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetSnapshotAndChangesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetSnapshotAndChangesActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetSnapshotAndChangesActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 523 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Void> getSnapshotAndChanges( ConfigNodeImpl* const& self, ConfigFollowerGetSnapshotAndChangesRequest const& req ) {
															#line 523 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Void>(new GetSnapshotAndChangesActor(self, req));
															#line 8734 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 555 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

	// Apply mutations from the WAL in mutationKeys into the kvKeys key space.
	// Periodic compaction prevents the database from growing too large, and improve read performance.
	// However, commit annotations for compacted mutations are lost
																#line 8742 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via compact()
															#line 559 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class CompactActor>
															#line 559 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class CompactActorState {
															#line 8748 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 559 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	CompactActorState(ConfigNodeImpl* const& self,ConfigFollowerCompactRequest const& req) 
															#line 559 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 559 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 559 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   req(req)
															#line 8757 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("compact", reinterpret_cast<unsigned long>(this));

	}
	~CompactActorState() 
	{
		fdb_probe_actor_destroy("compact", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 560 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Version> __when_expr_0 = getLastCompactedVersion(self);
															#line 560 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<CompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8774 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CompactActor*>(this)->actor_wait_state = 1;
															#line 560 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CompactActor, 0, Version >*>(static_cast<CompactActor*>(this)));
															#line 8779 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CompactActorState();
		static_cast<CompactActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 561 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		TraceEvent(SevInfo, "ConfigNodeCompacting", self->id) .detail("Version", req.version) .detail("LastCompacted", lastCompactedVersion);
															#line 564 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.version <= lastCompactedVersion)
															#line 8804 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 565 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.send(Void());
															#line 566 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<CompactActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CompactActorState(); static_cast<CompactActor*>(this)->destroy(); return 0; }
															#line 8810 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<CompactActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CompactActorState();
			static_cast<CompactActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 568 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Standalone<VectorRef<VersionedConfigMutationRef>>> __when_expr_1 = getMutations(self, lastCompactedVersion + 1, req.version);
															#line 568 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<CompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8820 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CompactActor*>(this)->actor_wait_state = 2;
															#line 568 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CompactActor, 1, Standalone<VectorRef<VersionedConfigMutationRef>> >*>(static_cast<CompactActor*>(this)));
															#line 8825 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Version const& __lastCompactedVersion,int loopDepth) 
	{
															#line 560 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		lastCompactedVersion = __lastCompactedVersion;
															#line 8834 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __lastCompactedVersion,int loopDepth) 
	{
		lastCompactedVersion = std::move(__lastCompactedVersion);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CompactActor*>(this)->actor_wait_state > 0) static_cast<CompactActor*>(this)->actor_wait_state = 0;
		static_cast<CompactActor*>(this)->ActorCallback< CompactActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< CompactActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("compact", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compact", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CompactActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("compact", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compact", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CompactActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("compact", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compact", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Standalone<VectorRef<VersionedConfigMutationRef>> const& versionedMutations,int loopDepth) 
	{
															#line 570 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		self->kvStore->clear( KeyRangeRef(versionedMutationKey(lastCompactedVersion + 1, 0), versionedMutationKey(req.version + 1, 0)));
															#line 572 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		self->kvStore->clear( KeyRangeRef(versionedAnnotationKey(lastCompactedVersion + 1), versionedAnnotationKey(req.version + 1)));
															#line 574 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& versionedMutation : versionedMutations ) {
															#line 575 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			const auto& version = versionedMutation.version;
															#line 576 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			const auto& mutation = versionedMutation.mutation;
															#line 577 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (version > req.version)
															#line 8923 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			{
				break;
			}
			else
			{
															#line 580 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				TraceEvent(SevDebug, "ConfigNodeCompactionApplyingMutation", self->id) .detail("IsSet", mutation.isSet()) .detail("MutationVersion", version) .detail("LastCompactedVersion", lastCompactedVersion) .detail("ReqVersion", req.version);
															#line 585 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				auto serializedKey = BinaryWriter::toValue(mutation.getKey(), IncludeVersion());
															#line 586 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				if (mutation.isSet())
															#line 8935 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				{
															#line 587 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
					self->kvStore->set(KeyValueRef(serializedKey.withPrefix(kvKeys.begin), ObjectWriter::toValue(mutation.getValue(), IncludeVersion())));
															#line 8939 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				}
				else
				{
															#line 590 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
					self->kvStore->clear(singleKeyRange(serializedKey.withPrefix(kvKeys.begin)));
															#line 8945 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				}
															#line 592 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				lastCompactedVersion = version;
															#line 8949 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			}
		}
															#line 595 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		self->kvStore->set( KeyValueRef(lastCompactedVersionKey, BinaryWriter::toValue(lastCompactedVersion, IncludeVersion())));
															#line 597 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->kvStore->commit();
															#line 597 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<CompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8958 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CompactActor*>(this)->actor_wait_state = 3;
															#line 597 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CompactActor, 2, Void >*>(static_cast<CompactActor*>(this)));
															#line 8963 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Standalone<VectorRef<VersionedConfigMutationRef>> && versionedMutations,int loopDepth) 
	{
															#line 570 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		self->kvStore->clear( KeyRangeRef(versionedMutationKey(lastCompactedVersion + 1, 0), versionedMutationKey(req.version + 1, 0)));
															#line 572 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		self->kvStore->clear( KeyRangeRef(versionedAnnotationKey(lastCompactedVersion + 1), versionedAnnotationKey(req.version + 1)));
															#line 574 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		for( const auto& versionedMutation : versionedMutations ) {
															#line 575 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			const auto& version = versionedMutation.version;
															#line 576 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			const auto& mutation = versionedMutation.mutation;
															#line 577 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (version > req.version)
															#line 8982 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			{
				break;
			}
			else
			{
															#line 580 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				TraceEvent(SevDebug, "ConfigNodeCompactionApplyingMutation", self->id) .detail("IsSet", mutation.isSet()) .detail("MutationVersion", version) .detail("LastCompactedVersion", lastCompactedVersion) .detail("ReqVersion", req.version);
															#line 585 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				auto serializedKey = BinaryWriter::toValue(mutation.getKey(), IncludeVersion());
															#line 586 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				if (mutation.isSet())
															#line 8994 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				{
															#line 587 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
					self->kvStore->set(KeyValueRef(serializedKey.withPrefix(kvKeys.begin), ObjectWriter::toValue(mutation.getValue(), IncludeVersion())));
															#line 8998 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				}
				else
				{
															#line 590 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
					self->kvStore->clear(singleKeyRange(serializedKey.withPrefix(kvKeys.begin)));
															#line 9004 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				}
															#line 592 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				lastCompactedVersion = version;
															#line 9008 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			}
		}
															#line 595 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		self->kvStore->set( KeyValueRef(lastCompactedVersionKey, BinaryWriter::toValue(lastCompactedVersion, IncludeVersion())));
															#line 597 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->kvStore->commit();
															#line 597 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<CompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9017 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CompactActor*>(this)->actor_wait_state = 3;
															#line 597 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CompactActor, 2, Void >*>(static_cast<CompactActor*>(this)));
															#line 9022 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<VersionedConfigMutationRef>> const& versionedMutations,int loopDepth) 
	{
		loopDepth = a_body1cont2(versionedMutations, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<VersionedConfigMutationRef>> && versionedMutations,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(versionedMutations), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CompactActor*>(this)->actor_wait_state > 0) static_cast<CompactActor*>(this)->actor_wait_state = 0;
		static_cast<CompactActor*>(this)->ActorCallback< CompactActor, 1, Standalone<VectorRef<VersionedConfigMutationRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< CompactActor, 1, Standalone<VectorRef<VersionedConfigMutationRef>> >*,Standalone<VectorRef<VersionedConfigMutationRef>> const& value) 
	{
		fdb_probe_actor_enter("compact", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compact", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CompactActor, 1, Standalone<VectorRef<VersionedConfigMutationRef>> >*,Standalone<VectorRef<VersionedConfigMutationRef>> && value) 
	{
		fdb_probe_actor_enter("compact", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compact", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CompactActor, 1, Standalone<VectorRef<VersionedConfigMutationRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("compact", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compact", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 598 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(Void());
															#line 599 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<CompactActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CompactActorState(); static_cast<CompactActor*>(this)->destroy(); return 0; }
															#line 9108 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<CompactActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CompactActorState();
		static_cast<CompactActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 598 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(Void());
															#line 599 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<CompactActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CompactActorState(); static_cast<CompactActor*>(this)->destroy(); return 0; }
															#line 9122 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<CompactActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CompactActorState();
		static_cast<CompactActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CompactActor*>(this)->actor_wait_state > 0) static_cast<CompactActor*>(this)->actor_wait_state = 0;
		static_cast<CompactActor*>(this)->ActorCallback< CompactActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CompactActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("compact", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compact", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CompactActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("compact", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compact", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CompactActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("compact", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compact", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 559 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 559 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigFollowerCompactRequest req;
															#line 560 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Version lastCompactedVersion;
															#line 9211 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via compact()
															#line 559 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class CompactActor final : public Actor<Void>, public ActorCallback< CompactActor, 0, Version >, public ActorCallback< CompactActor, 1, Standalone<VectorRef<VersionedConfigMutationRef>> >, public ActorCallback< CompactActor, 2, Void >, public FastAllocated<CompactActor>, public CompactActorState<CompactActor> {
															#line 9216 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<CompactActor>::operator new;
	using FastAllocated<CompactActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12781058024923488000UL, 16765249943934922240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CompactActor, 0, Version >;
friend struct ActorCallback< CompactActor, 1, Standalone<VectorRef<VersionedConfigMutationRef>> >;
friend struct ActorCallback< CompactActor, 2, Void >;
															#line 559 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	CompactActor(ConfigNodeImpl* const& self,ConfigFollowerCompactRequest const& req) 
															#line 9235 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Void>(),
		   CompactActorState<CompactActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("compact", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3927277226688603392UL, 15590798909204935680UL);
		ActorExecutionContextHelper __helper(static_cast<CompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("compact");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("compact", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CompactActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CompactActor, 1, Standalone<VectorRef<VersionedConfigMutationRef>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CompactActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 559 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Void> compact( ConfigNodeImpl* const& self, ConfigFollowerCompactRequest const& req ) {
															#line 559 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Void>(new CompactActor(self, req));
															#line 9269 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 601 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

																#line 9274 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via rollforward()
															#line 602 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class RollforwardActor>
															#line 602 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class RollforwardActorState {
															#line 9280 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 602 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	RollforwardActorState(ConfigNodeImpl* const& self,ConfigFollowerRollforwardRequest const& req) 
															#line 602 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 602 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 602 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   req(req)
															#line 9289 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("rollforward", reinterpret_cast<unsigned long>(this));

	}
	~RollforwardActorState() 
	{
		fdb_probe_actor_destroy("rollforward", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 603 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Version> __when_expr_0 = getLastCompactedVersion(self);
															#line 603 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<RollforwardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9306 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RollforwardActor*>(this)->actor_wait_state = 1;
															#line 603 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RollforwardActor, 0, Version >*>(static_cast<RollforwardActor*>(this)));
															#line 9311 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RollforwardActorState();
		static_cast<RollforwardActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 604 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.lastKnownCommitted < lastCompactedVersion)
															#line 9334 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 605 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(version_already_compacted());
															#line 606 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<RollforwardActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RollforwardActorState(); static_cast<RollforwardActor*>(this)->destroy(); return 0; }
															#line 9340 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<RollforwardActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RollforwardActorState();
			static_cast<RollforwardActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 608 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<ConfigGeneration> __when_expr_1 = getGeneration(self);
															#line 608 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<RollforwardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9350 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RollforwardActor*>(this)->actor_wait_state = 2;
															#line 608 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RollforwardActor, 1, ConfigGeneration >*>(static_cast<RollforwardActor*>(this)));
															#line 9355 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Version const& __lastCompactedVersion,int loopDepth) 
	{
															#line 603 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		lastCompactedVersion = __lastCompactedVersion;
															#line 9364 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __lastCompactedVersion,int loopDepth) 
	{
		lastCompactedVersion = std::move(__lastCompactedVersion);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RollforwardActor*>(this)->actor_wait_state > 0) static_cast<RollforwardActor*>(this)->actor_wait_state = 0;
		static_cast<RollforwardActor*>(this)->ActorCallback< RollforwardActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< RollforwardActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("rollforward", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RollforwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollforward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RollforwardActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("rollforward", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RollforwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollforward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RollforwardActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("rollforward", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RollforwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollforward", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 609 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.lastKnownCommitted != currentGeneration.committedVersion)
															#line 9443 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 610 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			req.reply.sendError(transaction_too_old());
															#line 611 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<RollforwardActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RollforwardActorState(); static_cast<RollforwardActor*>(this)->destroy(); return 0; }
															#line 9449 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<RollforwardActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RollforwardActorState();
			static_cast<RollforwardActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 613 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		TraceEvent("ConfigNodeRollforward", self->id) .detail("RollbackTo", req.rollback) .detail("Target", req.target) .detail("LastKnownCommitted", req.lastKnownCommitted) .detail("Committed", currentGeneration.committedVersion) .detail("CurrentGeneration", currentGeneration.toString()) .detail("LastCompactedVersion", lastCompactedVersion) .detail("SpecialZeroQuorum", req.specialZeroQuorum);
															#line 623 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.rollback.present() && req.rollback.get() < currentGeneration.committedVersion)
															#line 9459 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 624 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (g_network->isSimulated())
															#line 9463 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			{
															#line 625 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				StrictFuture<RangeResult> __when_expr_2 = self->kvStore->readRange( KeyRangeRef(versionedMutationKey(req.rollback.get() + 1, 0), versionedMutationKey(currentGeneration.committedVersion + 1, 0)));
															#line 625 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				if (static_cast<RollforwardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9469 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
				static_cast<RollforwardActor*>(this)->actor_wait_state = 3;
															#line 625 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RollforwardActor, 2, RangeResult >*>(static_cast<RollforwardActor*>(this)));
															#line 9474 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont6(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(ConfigGeneration const& __currentGeneration,int loopDepth) 
	{
															#line 608 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		currentGeneration = __currentGeneration;
															#line 9493 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(ConfigGeneration && __currentGeneration,int loopDepth) 
	{
		currentGeneration = std::move(__currentGeneration);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RollforwardActor*>(this)->actor_wait_state > 0) static_cast<RollforwardActor*>(this)->actor_wait_state = 0;
		static_cast<RollforwardActor*>(this)->ActorCallback< RollforwardActor, 1, ConfigGeneration >::remove();

	}
	void a_callback_fire(ActorCallback< RollforwardActor, 1, ConfigGeneration >*,ConfigGeneration const& value) 
	{
		fdb_probe_actor_enter("rollforward", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RollforwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollforward", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RollforwardActor, 1, ConfigGeneration >*,ConfigGeneration && value) 
	{
		fdb_probe_actor_enter("rollforward", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RollforwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollforward", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RollforwardActor, 1, ConfigGeneration >*,Error err) 
	{
		fdb_probe_actor_enter("rollforward", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RollforwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollforward", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 649 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.mutations.size() > 0)
															#line 9572 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 650 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			ASSERT_GT(req.mutations.size(), 0);
															#line 651 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			ASSERT_GT(req.mutations[0].version, currentGeneration.committedVersion);
															#line 652 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Void> __when_expr_4 = commitMutations(self, req.mutations, req.annotations, req.target, req.specialZeroQuorum ? currentGeneration.liveVersion : ::invalidVersion);
															#line 652 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<RollforwardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9582 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
			static_cast<RollforwardActor*>(this)->actor_wait_state = 5;
															#line 652 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RollforwardActor, 4, Void >*>(static_cast<RollforwardActor*>(this)));
															#line 9587 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
															#line 634 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		self->kvStore->clear(KeyRangeRef(versionedMutationKey(req.rollback.get() + 1, 0), versionedMutationKey(currentGeneration.committedVersion + 1, 0)));
															#line 636 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		self->kvStore->clear(KeyRangeRef(versionedAnnotationKey(req.rollback.get() + 1), versionedAnnotationKey(currentGeneration.committedVersion + 1)));
															#line 639 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		currentGeneration.committedVersion = req.rollback.get();
															#line 640 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (req.rollback.get() < lastCompactedVersion)
															#line 9607 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 641 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			self->kvStore->set( KeyValueRef(lastCompactedVersionKey, BinaryWriter::toValue(req.rollback.get(), IncludeVersion())));
															#line 9611 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(RangeResult const& mutationRange,int loopDepth) 
	{
															#line 629 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<RangeResult> __when_expr_3 = self->kvStore->readRange( KeyRangeRef(versionedAnnotationKey(req.rollback.get() + 1), versionedAnnotationKey(currentGeneration.committedVersion + 1)));
															#line 629 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<RollforwardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9623 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont7when1(__when_expr_3.get(), loopDepth); };
		static_cast<RollforwardActor*>(this)->actor_wait_state = 4;
															#line 629 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RollforwardActor, 3, RangeResult >*>(static_cast<RollforwardActor*>(this)));
															#line 9628 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(RangeResult && mutationRange,int loopDepth) 
	{
															#line 629 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<RangeResult> __when_expr_3 = self->kvStore->readRange( KeyRangeRef(versionedAnnotationKey(req.rollback.get() + 1), versionedAnnotationKey(currentGeneration.committedVersion + 1)));
															#line 629 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<RollforwardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9639 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont7when1(__when_expr_3.get(), loopDepth); };
		static_cast<RollforwardActor*>(this)->actor_wait_state = 4;
															#line 629 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RollforwardActor, 3, RangeResult >*>(static_cast<RollforwardActor*>(this)));
															#line 9644 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(RangeResult const& mutationRange,int loopDepth) 
	{
		loopDepth = a_body1cont7(mutationRange, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(RangeResult && mutationRange,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(mutationRange), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RollforwardActor*>(this)->actor_wait_state > 0) static_cast<RollforwardActor*>(this)->actor_wait_state = 0;
		static_cast<RollforwardActor*>(this)->ActorCallback< RollforwardActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< RollforwardActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("rollforward", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RollforwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollforward", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RollforwardActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("rollforward", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RollforwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollforward", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RollforwardActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("rollforward", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RollforwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollforward", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(RangeResult const& annotationRange,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(RangeResult && annotationRange,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(RangeResult const& annotationRange,int loopDepth) 
	{
		loopDepth = a_body1cont8(annotationRange, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(RangeResult && annotationRange,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(annotationRange), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RollforwardActor*>(this)->actor_wait_state > 0) static_cast<RollforwardActor*>(this)->actor_wait_state = 0;
		static_cast<RollforwardActor*>(this)->ActorCallback< RollforwardActor, 3, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< RollforwardActor, 3, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("rollforward", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RollforwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollforward", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RollforwardActor, 3, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("rollforward", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RollforwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollforward", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RollforwardActor, 3, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("rollforward", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RollforwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollforward", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11(int loopDepth) 
	{
															#line 659 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(Void());
															#line 660 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<RollforwardActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RollforwardActorState(); static_cast<RollforwardActor*>(this)->destroy(); return 0; }
															#line 9817 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<RollforwardActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RollforwardActorState();
		static_cast<RollforwardActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RollforwardActor*>(this)->actor_wait_state > 0) static_cast<RollforwardActor*>(this)->actor_wait_state = 0;
		static_cast<RollforwardActor*>(this)->ActorCallback< RollforwardActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RollforwardActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rollforward", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RollforwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollforward", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RollforwardActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rollforward", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RollforwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollforward", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RollforwardActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rollforward", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RollforwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollforward", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 602 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 602 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigFollowerRollforwardRequest req;
															#line 603 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Version lastCompactedVersion;
															#line 608 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigGeneration currentGeneration;
															#line 9920 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via rollforward()
															#line 602 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class RollforwardActor final : public Actor<Void>, public ActorCallback< RollforwardActor, 0, Version >, public ActorCallback< RollforwardActor, 1, ConfigGeneration >, public ActorCallback< RollforwardActor, 2, RangeResult >, public ActorCallback< RollforwardActor, 3, RangeResult >, public ActorCallback< RollforwardActor, 4, Void >, public FastAllocated<RollforwardActor>, public RollforwardActorState<RollforwardActor> {
															#line 9925 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<RollforwardActor>::operator new;
	using FastAllocated<RollforwardActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4314860891556711424UL, 13506541431025318144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RollforwardActor, 0, Version >;
friend struct ActorCallback< RollforwardActor, 1, ConfigGeneration >;
friend struct ActorCallback< RollforwardActor, 2, RangeResult >;
friend struct ActorCallback< RollforwardActor, 3, RangeResult >;
friend struct ActorCallback< RollforwardActor, 4, Void >;
															#line 602 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	RollforwardActor(ConfigNodeImpl* const& self,ConfigFollowerRollforwardRequest const& req) 
															#line 9946 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Void>(),
		   RollforwardActorState<RollforwardActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rollforward", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8219436861435629568UL, 8700535673077520384UL);
		ActorExecutionContextHelper __helper(static_cast<RollforwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rollforward");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rollforward", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RollforwardActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RollforwardActor, 1, ConfigGeneration >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RollforwardActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RollforwardActor, 3, RangeResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RollforwardActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 602 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Void> rollforward( ConfigNodeImpl* const& self, ConfigFollowerRollforwardRequest const& req ) {
															#line 602 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Void>(new RollforwardActor(self, req));
															#line 9982 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 662 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

																#line 9987 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via getCommittedVersion()
															#line 663 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class GetCommittedVersionActor>
															#line 663 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetCommittedVersionActorState {
															#line 9993 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 663 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetCommittedVersionActorState(ConfigNodeImpl* const& self,ConfigFollowerGetCommittedVersionRequest const& req) 
															#line 663 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 663 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 663 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   req(req)
															#line 10002 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("getCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetCommittedVersionActorState() 
	{
		fdb_probe_actor_destroy("getCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 664 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Version> __when_expr_0 = getLastCompactedVersion(self);
															#line 664 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<GetCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10019 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetCommittedVersionActor*>(this)->actor_wait_state = 1;
															#line 664 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCommittedVersionActor, 0, Version >*>(static_cast<GetCommittedVersionActor*>(this)));
															#line 10024 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCommittedVersionActorState();
		static_cast<GetCommittedVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 665 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<ConfigGeneration> __when_expr_1 = getGeneration(self);
															#line 665 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10049 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetCommittedVersionActor*>(this)->actor_wait_state = 2;
															#line 665 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetCommittedVersionActor, 1, ConfigGeneration >*>(static_cast<GetCommittedVersionActor*>(this)));
															#line 10054 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Version const& __lastCompacted,int loopDepth) 
	{
															#line 664 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		lastCompacted = __lastCompacted;
															#line 10063 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __lastCompacted,int loopDepth) 
	{
		lastCompacted = std::move(__lastCompacted);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<GetCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommittedVersionActor*>(this)->ActorCallback< GetCommittedVersionActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCommittedVersionActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 666 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<bool> __when_expr_2 = registered(self);
															#line 666 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<GetCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10144 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetCommittedVersionActor*>(this)->actor_wait_state = 3;
															#line 666 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetCommittedVersionActor, 2, bool >*>(static_cast<GetCommittedVersionActor*>(this)));
															#line 10149 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(ConfigGeneration const& __generation,int loopDepth) 
	{
															#line 665 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		generation = __generation;
															#line 10158 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(ConfigGeneration && __generation,int loopDepth) 
	{
		generation = std::move(__generation);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<GetCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommittedVersionActor*>(this)->ActorCallback< GetCommittedVersionActor, 1, ConfigGeneration >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActor, 1, ConfigGeneration >*,ConfigGeneration const& value) 
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActor, 1, ConfigGeneration >*,ConfigGeneration && value) 
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetCommittedVersionActor, 1, ConfigGeneration >*,Error err) 
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(bool const& isRegistered,int loopDepth) 
	{
															#line 667 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(ConfigFollowerGetCommittedVersionReply{ isRegistered, lastCompacted, generation.liveVersion, generation.committedVersion });
															#line 669 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetCommittedVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetCommittedVersionActorState(); static_cast<GetCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 10239 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetCommittedVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetCommittedVersionActorState();
		static_cast<GetCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(bool && isRegistered,int loopDepth) 
	{
															#line 667 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(ConfigFollowerGetCommittedVersionReply{ isRegistered, lastCompacted, generation.liveVersion, generation.committedVersion });
															#line 669 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<GetCommittedVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetCommittedVersionActorState(); static_cast<GetCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 10253 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<GetCommittedVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetCommittedVersionActorState();
		static_cast<GetCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(bool const& isRegistered,int loopDepth) 
	{
		loopDepth = a_body1cont3(isRegistered, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(bool && isRegistered,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(isRegistered), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<GetCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommittedVersionActor*>(this)->ActorCallback< GetCommittedVersionActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetCommittedVersionActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 663 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 663 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigFollowerGetCommittedVersionRequest req;
															#line 664 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Version lastCompacted;
															#line 665 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigGeneration generation;
															#line 10344 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via getCommittedVersion()
															#line 663 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class GetCommittedVersionActor final : public Actor<Void>, public ActorCallback< GetCommittedVersionActor, 0, Version >, public ActorCallback< GetCommittedVersionActor, 1, ConfigGeneration >, public ActorCallback< GetCommittedVersionActor, 2, bool >, public FastAllocated<GetCommittedVersionActor>, public GetCommittedVersionActorState<GetCommittedVersionActor> {
															#line 10349 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<GetCommittedVersionActor>::operator new;
	using FastAllocated<GetCommittedVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9992393481871150080UL, 15553411876018506240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCommittedVersionActor, 0, Version >;
friend struct ActorCallback< GetCommittedVersionActor, 1, ConfigGeneration >;
friend struct ActorCallback< GetCommittedVersionActor, 2, bool >;
															#line 663 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	GetCommittedVersionActor(ConfigNodeImpl* const& self,ConfigFollowerGetCommittedVersionRequest const& req) 
															#line 10368 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Void>(),
		   GetCommittedVersionActorState<GetCommittedVersionActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8917899261172622336UL, 9522656687011892480UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCommittedVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCommittedVersionActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetCommittedVersionActor, 1, ConfigGeneration >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetCommittedVersionActor, 2, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 663 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Void> getCommittedVersion( ConfigNodeImpl* const& self, ConfigFollowerGetCommittedVersionRequest const& req ) {
															#line 663 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Void>(new GetCommittedVersionActor(self, req));
															#line 10402 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 671 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

	// Requires ConfigNodes to register with the ConfigBroadcaster before being
	// allowed to respond to most requests. The ConfigBroadcaster will first
	// ask the ConfigNode whether it is registered (kickstarted by the worker
	// registering with the cluster controller). Then, the ConfigBroadcaster
	// will send the ConfigNode a ready message, containing a snapshot if the
	// ConfigNode is a new coordinator and needs updated state, or empty
	// otherwise.
																#line 10414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via serve()
															#line 679 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class ServeActor1>
															#line 679 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class ServeActor1State {
															#line 10420 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 679 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ServeActor1State(ConfigNodeImpl* const& self,ConfigBroadcastInterface const* const& cbi,bool const& infinite) 
															#line 679 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 679 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 679 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   cbi(cbi),
															#line 679 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   infinite(infinite)
															#line 10431 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("serve", reinterpret_cast<unsigned long>(this));

	}
	~ServeActor1State() 
	{
		fdb_probe_actor_destroy("serve", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 680 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			;
															#line 10446 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServeActor1State();
		static_cast<ServeActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 690 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		auto __when_expr_0 = cbi->registered.getFuture();
															#line 10476 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ConfigBroadcastRegisteredRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ConfigBroadcastRegisteredRequest>>::value, "invalid type");
															#line 689 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10480 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 697 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		auto __when_expr_1 = cbi->ready.getFuture();
															#line 10484 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<ConfigBroadcastReadyRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<ConfigBroadcastReadyRequest>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
		static_cast<ServeActor1*>(this)->actor_wait_state = 1;
															#line 690 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ServeActor1, 0, ConfigBroadcastRegisteredRequest >*>(static_cast<ServeActor1*>(this)));
															#line 697 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< ServeActor1, 1, ConfigBroadcastReadyRequest >*>(static_cast<ServeActor1*>(this)));
															#line 10492 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(ConfigBroadcastRegisteredRequest const& __req,int loopDepth) 
	{
															#line 690 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req = __req;
															#line 691 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<bool> __when_expr_2 = registered(self);
															#line 691 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10511 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ServeActor1*>(this)->actor_wait_state = 2;
															#line 691 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ServeActor1, 2, bool >*>(static_cast<ServeActor1*>(this)));
															#line 10516 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(ConfigBroadcastRegisteredRequest && __req,int loopDepth) 
	{
		req = std::move(__req);
															#line 691 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<bool> __when_expr_2 = registered(self);
															#line 691 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10528 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ServeActor1*>(this)->actor_wait_state = 2;
															#line 691 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ServeActor1, 2, bool >*>(static_cast<ServeActor1*>(this)));
															#line 10533 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(ConfigBroadcastReadyRequest const& __readyReq,int loopDepth) 
	{
															#line 697 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		readyReq = __readyReq;
															#line 698 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Optional<CoordinatorsHash>> __when_expr_4 = getLocked(self);
															#line 698 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10546 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_4.get(), loopDepth); };
		static_cast<ServeActor1*>(this)->actor_wait_state = 4;
															#line 698 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ServeActor1, 4, Optional<CoordinatorsHash> >*>(static_cast<ServeActor1*>(this)));
															#line 10551 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(ConfigBroadcastReadyRequest && __readyReq,int loopDepth) 
	{
		readyReq = std::move(__readyReq);
															#line 698 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Optional<CoordinatorsHash>> __when_expr_4 = getLocked(self);
															#line 698 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10563 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_4.get(), loopDepth); };
		static_cast<ServeActor1*>(this)->actor_wait_state = 4;
															#line 698 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ServeActor1, 4, Optional<CoordinatorsHash> >*>(static_cast<ServeActor1*>(this)));
															#line 10568 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServeActor1*>(this)->actor_wait_state > 0) static_cast<ServeActor1*>(this)->actor_wait_state = 0;
		static_cast<ServeActor1*>(this)->ActorSingleCallback< ServeActor1, 0, ConfigBroadcastRegisteredRequest >::remove();
		static_cast<ServeActor1*>(this)->ActorSingleCallback< ServeActor1, 1, ConfigBroadcastReadyRequest >::remove();

	}
	int a_body1loopBody1when1cont1(int loopDepth) 
	{
															#line 692 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<ConfigGeneration> __when_expr_3 = getGeneration(self);
															#line 692 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10586 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<ServeActor1*>(this)->actor_wait_state = 3;
															#line 692 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ServeActor1, 3, ConfigGeneration >*>(static_cast<ServeActor1*>(this)));
															#line 10591 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1when1(bool const& __isRegistered,int loopDepth) 
	{
															#line 691 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		isRegistered = __isRegistered;
															#line 10600 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1when1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(bool && __isRegistered,int loopDepth) 
	{
		isRegistered = std::move(__isRegistered);
		loopDepth = a_body1loopBody1when1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ServeActor1*>(this)->actor_wait_state > 0) static_cast<ServeActor1*>(this)->actor_wait_state = 0;
		static_cast<ServeActor1*>(this)->ActorCallback< ServeActor1, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ServeActor1, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ServeActor1, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ServeActor1, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1when1cont2(ConfigGeneration const& generation,int loopDepth) 
	{
															#line 693 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		TraceEvent("ConfigNodeSendingRegisteredReply", self->id) .detail("Generation", generation.toString());
															#line 695 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(ConfigBroadcastRegisteredReply{ isRegistered, generation.committedVersion });
															#line 10681 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont2(ConfigGeneration && generation,int loopDepth) 
	{
															#line 693 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		TraceEvent("ConfigNodeSendingRegisteredReply", self->id) .detail("Generation", generation.toString());
															#line 695 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(ConfigBroadcastRegisteredReply{ isRegistered, generation.committedVersion });
															#line 10692 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont1when1(ConfigGeneration const& generation,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont2(generation, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont1when1(ConfigGeneration && generation,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont2(std::move(generation), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ServeActor1*>(this)->actor_wait_state > 0) static_cast<ServeActor1*>(this)->actor_wait_state = 0;
		static_cast<ServeActor1*>(this)->ActorCallback< ServeActor1, 3, ConfigGeneration >::remove();

	}
	void a_callback_fire(ActorCallback< ServeActor1, 3, ConfigGeneration >*,ConfigGeneration const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ServeActor1, 3, ConfigGeneration >*,ConfigGeneration && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ServeActor1, 3, ConfigGeneration >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< ServeActor1, 0, ConfigBroadcastRegisteredRequest >*,ConfigBroadcastRegisteredRequest const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ServeActor1, 0, ConfigBroadcastRegisteredRequest >*,ConfigBroadcastRegisteredRequest && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ServeActor1, 0, ConfigBroadcastRegisteredRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(int loopDepth) 
	{
															#line 706 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if ((!infinite && !locked.present()) || (locked.present() && locked.get() != readyReq.coordinatorsHash))
															#line 10833 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 709 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (readyReq.snapshot.size() > 0)
															#line 10837 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			{
															#line 710 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				for( const auto& [configKey, knobValue] : readyReq.snapshot ) {
															#line 711 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
					TraceEvent("ConfigNodeSettingFromSnapshot", self->id) .detail("ConfigClass", configKey.configClass) .detail("KnobName", configKey.knobName) .detail("Value", knobValue.toString()) .detail("Version", readyReq.snapshotVersion);
															#line 716 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
					self->kvStore->set(KeyValueRef( BinaryWriter::toValue(configKey, IncludeVersion()).withPrefix(kvKeys.begin), ObjectWriter::toValue(knobValue, IncludeVersion())));
															#line 10845 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
				}
															#line 720 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				ConfigGeneration newGeneration = { readyReq.snapshotVersion, readyReq.liveVersion };
															#line 721 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				self->kvStore->set(KeyValueRef(currentGenerationKey, BinaryWriter::toValue(newGeneration, IncludeVersion())));
															#line 726 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				self->kvStore->clear(KeyRangeRef(versionedMutationKey(0, 0), versionedMutationKey(readyReq.snapshotVersion + 1, 0)));
															#line 728 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				self->kvStore->clear(KeyRangeRef(versionedAnnotationKey(0), versionedAnnotationKey(readyReq.snapshotVersion + 1)));
															#line 731 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
				self->kvStore->set( KeyValueRef(lastCompactedVersionKey, BinaryWriter::toValue(readyReq.snapshotVersion, IncludeVersion())));
															#line 10857 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			}
															#line 738 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			self->kvStore->set(KeyValueRef( lockedKey, BinaryWriter::toValue(Optional<CoordinatorsHash>(), IncludeVersion())));
															#line 10861 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		}
															#line 741 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		self->kvStore->set(KeyValueRef(coordinatorsHashKey, BinaryWriter::toValue(readyReq.coordinatorsHash, IncludeVersion())));
															#line 743 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->kvStore->commit();
															#line 743 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10869 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<ServeActor1*>(this)->actor_wait_state = 5;
															#line 743 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ServeActor1, 5, Void >*>(static_cast<ServeActor1*>(this)));
															#line 10874 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Optional<CoordinatorsHash> const& __locked,int loopDepth) 
	{
															#line 698 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		locked = __locked;
															#line 10883 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1when2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Optional<CoordinatorsHash> && __locked,int loopDepth) 
	{
		locked = std::move(__locked);
		loopDepth = a_body1loopBody1when2cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ServeActor1*>(this)->actor_wait_state > 0) static_cast<ServeActor1*>(this)->actor_wait_state = 0;
		static_cast<ServeActor1*>(this)->ActorCallback< ServeActor1, 4, Optional<CoordinatorsHash> >::remove();

	}
	void a_callback_fire(ActorCallback< ServeActor1, 4, Optional<CoordinatorsHash> >*,Optional<CoordinatorsHash> const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ServeActor1, 4, Optional<CoordinatorsHash> >*,Optional<CoordinatorsHash> && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ServeActor1, 4, Optional<CoordinatorsHash> >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1when2cont2(Void const& _,int loopDepth) 
	{
															#line 745 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		TraceEvent("ConfigNodeReady", self->id).detail("WasLocked", locked.present());
															#line 746 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		readyReq.reply.send(ConfigBroadcastReadyReply{});
															#line 747 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!infinite)
															#line 10966 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 748 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<ServeActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServeActor1State(); static_cast<ServeActor1*>(this)->destroy(); return 0; }
															#line 10970 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<ServeActor1*>(this)->SAV< Void >::value()) Void(Void());
			this->~ServeActor1State();
			static_cast<ServeActor1*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont2(Void && _,int loopDepth) 
	{
															#line 745 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		TraceEvent("ConfigNodeReady", self->id).detail("WasLocked", locked.present());
															#line 746 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		readyReq.reply.send(ConfigBroadcastReadyReply{});
															#line 747 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!infinite)
															#line 10988 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 748 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (!static_cast<ServeActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServeActor1State(); static_cast<ServeActor1*>(this)->destroy(); return 0; }
															#line 10992 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			new (&static_cast<ServeActor1*>(this)->SAV< Void >::value()) Void(Void());
			this->~ServeActor1State();
			static_cast<ServeActor1*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ServeActor1*>(this)->actor_wait_state > 0) static_cast<ServeActor1*>(this)->actor_wait_state = 0;
		static_cast<ServeActor1*>(this)->ActorCallback< ServeActor1, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeActor1, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when2cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ServeActor1, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when2cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ServeActor1, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< ServeActor1, 1, ConfigBroadcastReadyRequest >*,ConfigBroadcastReadyRequest const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ServeActor1, 1, ConfigBroadcastReadyRequest >*,ConfigBroadcastReadyRequest && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< ServeActor1, 1, ConfigBroadcastReadyRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 679 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 679 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigBroadcastInterface const* cbi;
															#line 679 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	bool infinite;
															#line 690 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigBroadcastRegisteredRequest req;
															#line 691 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	bool isRegistered;
															#line 697 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigBroadcastReadyRequest readyReq;
															#line 698 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Optional<CoordinatorsHash> locked;
															#line 11148 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via serve()
															#line 679 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class ServeActor1 final : public Actor<Void>, public ActorSingleCallback< ServeActor1, 0, ConfigBroadcastRegisteredRequest >, public ActorCallback< ServeActor1, 2, bool >, public ActorCallback< ServeActor1, 3, ConfigGeneration >, public ActorSingleCallback< ServeActor1, 1, ConfigBroadcastReadyRequest >, public ActorCallback< ServeActor1, 4, Optional<CoordinatorsHash> >, public ActorCallback< ServeActor1, 5, Void >, public FastAllocated<ServeActor1>, public ServeActor1State<ServeActor1> {
															#line 11153 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<ServeActor1>::operator new;
	using FastAllocated<ServeActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17335076387217348608UL, 15581730969420681728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ServeActor1, 0, ConfigBroadcastRegisteredRequest >;
friend struct ActorCallback< ServeActor1, 2, bool >;
friend struct ActorCallback< ServeActor1, 3, ConfigGeneration >;
friend struct ActorSingleCallback< ServeActor1, 1, ConfigBroadcastReadyRequest >;
friend struct ActorCallback< ServeActor1, 4, Optional<CoordinatorsHash> >;
friend struct ActorCallback< ServeActor1, 5, Void >;
															#line 679 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ServeActor1(ConfigNodeImpl* const& self,ConfigBroadcastInterface const* const& cbi,bool const& infinite) 
															#line 11175 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Void>(),
		   ServeActor1State<ServeActor1>(self, cbi, infinite),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1925272116566065920UL, 5617264565327949568UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serve");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ServeActor1, 0, ConfigBroadcastRegisteredRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ServeActor1, 2, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ServeActor1, 3, ConfigGeneration >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ServeActor1, 4, Optional<CoordinatorsHash> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ServeActor1, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 679 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Void> serve( ConfigNodeImpl* const& self, ConfigBroadcastInterface const* const& cbi, bool const& infinite ) {
															#line 679 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Void>(new ServeActor1(self, cbi, infinite));
															#line 11211 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 754 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

																#line 11216 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via serveRegistered()
															#line 755 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class ServeRegisteredActor>
															#line 755 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class ServeRegisteredActorState {
															#line 11222 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 755 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ServeRegisteredActorState(ConfigNodeImpl* const& self,ConfigFollowerInterface const* const& cfi) 
															#line 755 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 755 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 755 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   cfi(cfi)
															#line 11231 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("serveRegistered", reinterpret_cast<unsigned long>(this));

	}
	~ServeRegisteredActorState() 
	{
		fdb_probe_actor_destroy("serveRegistered", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 756 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			;
															#line 11246 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServeRegisteredActorState();
		static_cast<ServeRegisteredActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 757 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		auto __when_expr_0 = cfi->compact.getFuture();
															#line 11276 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ConfigFollowerCompactRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ConfigFollowerCompactRequest>>::value, "invalid type");
															#line 757 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeRegisteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11280 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<ServeRegisteredActor*>(this)->actor_wait_state = 1;
															#line 757 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ServeRegisteredActor, 0, ConfigFollowerCompactRequest >*>(static_cast<ServeRegisteredActor*>(this)));
															#line 11285 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(ConfigFollowerCompactRequest const& req,int loopDepth) 
	{
															#line 758 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		++self->compactRequests;
															#line 759 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_1 = compact(self, req);
															#line 759 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeRegisteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11298 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ServeRegisteredActor*>(this)->actor_wait_state = 2;
															#line 759 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ServeRegisteredActor, 1, Void >*>(static_cast<ServeRegisteredActor*>(this)));
															#line 11303 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(ConfigFollowerCompactRequest && req,int loopDepth) 
	{
															#line 758 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		++self->compactRequests;
															#line 759 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_1 = compact(self, req);
															#line 759 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeRegisteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11316 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ServeRegisteredActor*>(this)->actor_wait_state = 2;
															#line 759 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ServeRegisteredActor, 1, Void >*>(static_cast<ServeRegisteredActor*>(this)));
															#line 11321 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(ConfigFollowerCompactRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ConfigFollowerCompactRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServeRegisteredActor*>(this)->actor_wait_state > 0) static_cast<ServeRegisteredActor*>(this)->actor_wait_state = 0;
		static_cast<ServeRegisteredActor*>(this)->ActorSingleCallback< ServeRegisteredActor, 0, ConfigFollowerCompactRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ServeRegisteredActor, 0, ConfigFollowerCompactRequest >*,ConfigFollowerCompactRequest const& value) 
	{
		fdb_probe_actor_enter("serveRegistered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeRegisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveRegistered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ServeRegisteredActor, 0, ConfigFollowerCompactRequest >*,ConfigFollowerCompactRequest && value) 
	{
		fdb_probe_actor_enter("serveRegistered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeRegisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveRegistered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ServeRegisteredActor, 0, ConfigFollowerCompactRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveRegistered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeRegisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveRegistered", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ServeRegisteredActor*>(this)->actor_wait_state > 0) static_cast<ServeRegisteredActor*>(this)->actor_wait_state = 0;
		static_cast<ServeRegisteredActor*>(this)->ActorCallback< ServeRegisteredActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeRegisteredActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serveRegistered", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeRegisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveRegistered", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ServeRegisteredActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serveRegistered", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeRegisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveRegistered", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ServeRegisteredActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serveRegistered", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeRegisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveRegistered", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 755 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 755 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigFollowerInterface const* cfi;
															#line 11492 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via serveRegistered()
															#line 755 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class ServeRegisteredActor final : public Actor<Void>, public ActorSingleCallback< ServeRegisteredActor, 0, ConfigFollowerCompactRequest >, public ActorCallback< ServeRegisteredActor, 1, Void >, public FastAllocated<ServeRegisteredActor>, public ServeRegisteredActorState<ServeRegisteredActor> {
															#line 11497 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<ServeRegisteredActor>::operator new;
	using FastAllocated<ServeRegisteredActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10454917497147164416UL, 7801469843877222656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ServeRegisteredActor, 0, ConfigFollowerCompactRequest >;
friend struct ActorCallback< ServeRegisteredActor, 1, Void >;
															#line 755 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ServeRegisteredActor(ConfigNodeImpl* const& self,ConfigFollowerInterface const* const& cfi) 
															#line 11515 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Void>(),
		   ServeRegisteredActorState<ServeRegisteredActor>(self, cfi),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serveRegistered", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11489146631383158272UL, 9504942816606463744UL);
		ActorExecutionContextHelper __helper(static_cast<ServeRegisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serveRegistered");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serveRegistered", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ServeRegisteredActor, 0, ConfigFollowerCompactRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ServeRegisteredActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 755 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Void> serveRegistered( ConfigNodeImpl* const& self, ConfigFollowerInterface const* const& cfi ) {
															#line 755 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Void>(new ServeRegisteredActor(self, cfi));
															#line 11548 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 762 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

	// Many of the ConfigNode interfaces need to be served before the
	// ConfigNode is officially registered with the ConfigBroadcaster. This is
	// necessary due to edge cases around coordinator changes. For example, a
	// ConfigNode that loses its coordinator status but then restarts before
	// serving its snapshot to the new coordinators needs to be able to
	// continue serving its snapshot interface when it restarts, even though it
	// is no longer a coordinator.
																#line 11560 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via serveUnregistered()
															#line 770 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class ServeUnregisteredActor>
															#line 770 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class ServeUnregisteredActorState {
															#line 11566 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 770 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ServeUnregisteredActorState(ConfigNodeImpl* const& self,ConfigFollowerInterface const* const& cfi) 
															#line 770 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 770 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 770 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   cfi(cfi)
															#line 11575 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("serveUnregistered", reinterpret_cast<unsigned long>(this));

	}
	~ServeUnregisteredActorState() 
	{
		fdb_probe_actor_destroy("serveUnregistered", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 771 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			;
															#line 11590 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServeUnregisteredActorState();
		static_cast<ServeUnregisteredActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 773 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		auto __when_expr_0 = cfi->getSnapshotAndChanges.getFuture();
															#line 11620 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ConfigFollowerGetSnapshotAndChangesRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ConfigFollowerGetSnapshotAndChangesRequest>>::value, "invalid type");
															#line 772 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11624 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 778 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		auto __when_expr_1 = cfi->getChanges.getFuture();
															#line 11628 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<ConfigFollowerGetChangesRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<ConfigFollowerGetChangesRequest>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 781 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		auto __when_expr_2 = cfi->rollforward.getFuture();
															#line 11633 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<ConfigFollowerRollforwardRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<ConfigFollowerRollforwardRequest>>::value, "invalid type");
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
															#line 785 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		auto __when_expr_3 = cfi->getCommittedVersion.getFuture();
															#line 11638 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<ConfigFollowerGetCommittedVersionRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<ConfigFollowerGetCommittedVersionRequest>>::value, "invalid type");
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.pop(), loopDepth); };
															#line 789 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		auto __when_expr_4 = cfi->lock.getFuture();
															#line 11643 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<ConfigFollowerLockRequest>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<ConfigFollowerLockRequest>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5(__when_expr_4.pop(), loopDepth); };
															#line 802 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->kvStore->getError();
															#line 11648 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when6(__when_expr_5.get(), loopDepth); };
		static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 1;
															#line 773 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ServeUnregisteredActor, 0, ConfigFollowerGetSnapshotAndChangesRequest >*>(static_cast<ServeUnregisteredActor*>(this)));
															#line 778 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< ServeUnregisteredActor, 1, ConfigFollowerGetChangesRequest >*>(static_cast<ServeUnregisteredActor*>(this)));
															#line 781 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< ServeUnregisteredActor, 2, ConfigFollowerRollforwardRequest >*>(static_cast<ServeUnregisteredActor*>(this)));
															#line 785 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< ServeUnregisteredActor, 3, ConfigFollowerGetCommittedVersionRequest >*>(static_cast<ServeUnregisteredActor*>(this)));
															#line 789 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< ServeUnregisteredActor, 4, ConfigFollowerLockRequest >*>(static_cast<ServeUnregisteredActor*>(this)));
															#line 802 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ServeUnregisteredActor, 5, Void >*>(static_cast<ServeUnregisteredActor*>(this)));
															#line 11663 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(ConfigFollowerGetSnapshotAndChangesRequest const& req,int loopDepth) 
	{
															#line 775 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		++self->snapshotRequests;
															#line 776 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_6 = getSnapshotAndChanges(self, req);
															#line 776 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11682 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_6.get(), loopDepth); };
		static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 2;
															#line 776 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ServeUnregisteredActor, 6, Void >*>(static_cast<ServeUnregisteredActor*>(this)));
															#line 11687 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(ConfigFollowerGetSnapshotAndChangesRequest && req,int loopDepth) 
	{
															#line 775 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		++self->snapshotRequests;
															#line 776 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_6 = getSnapshotAndChanges(self, req);
															#line 776 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11700 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_6.get(), loopDepth); };
		static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 2;
															#line 776 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ServeUnregisteredActor, 6, Void >*>(static_cast<ServeUnregisteredActor*>(this)));
															#line 11705 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(ConfigFollowerGetChangesRequest const& req,int loopDepth) 
	{
															#line 779 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_7 = getChanges(self, req);
															#line 779 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11716 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_7.get(), loopDepth); };
		static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 3;
															#line 779 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ServeUnregisteredActor, 7, Void >*>(static_cast<ServeUnregisteredActor*>(this)));
															#line 11721 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(ConfigFollowerGetChangesRequest && req,int loopDepth) 
	{
															#line 779 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_7 = getChanges(self, req);
															#line 779 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11732 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_7.get(), loopDepth); };
		static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 3;
															#line 779 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ServeUnregisteredActor, 7, Void >*>(static_cast<ServeUnregisteredActor*>(this)));
															#line 11737 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when3(ConfigFollowerRollforwardRequest const& req,int loopDepth) 
	{
															#line 782 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		++self->rollforwardRequests;
															#line 783 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_8 = rollforward(self, req);
															#line 783 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11750 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3when1(__when_expr_8.get(), loopDepth); };
		static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 4;
															#line 783 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ServeUnregisteredActor, 8, Void >*>(static_cast<ServeUnregisteredActor*>(this)));
															#line 11755 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when3(ConfigFollowerRollforwardRequest && req,int loopDepth) 
	{
															#line 782 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		++self->rollforwardRequests;
															#line 783 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_8 = rollforward(self, req);
															#line 783 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11768 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3when1(__when_expr_8.get(), loopDepth); };
		static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 4;
															#line 783 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ServeUnregisteredActor, 8, Void >*>(static_cast<ServeUnregisteredActor*>(this)));
															#line 11773 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when4(ConfigFollowerGetCommittedVersionRequest const& req,int loopDepth) 
	{
															#line 786 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		++self->getCommittedVersionRequests;
															#line 787 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_9 = getCommittedVersion(self, req);
															#line 787 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11786 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4when1(__when_expr_9.get(), loopDepth); };
		static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 5;
															#line 787 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ServeUnregisteredActor, 9, Void >*>(static_cast<ServeUnregisteredActor*>(this)));
															#line 11791 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when4(ConfigFollowerGetCommittedVersionRequest && req,int loopDepth) 
	{
															#line 786 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		++self->getCommittedVersionRequests;
															#line 787 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_9 = getCommittedVersion(self, req);
															#line 787 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11804 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4when1(__when_expr_9.get(), loopDepth); };
		static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 5;
															#line 787 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ServeUnregisteredActor, 9, Void >*>(static_cast<ServeUnregisteredActor*>(this)));
															#line 11809 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when5(ConfigFollowerLockRequest const& __req,int loopDepth) 
	{
															#line 789 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req = __req;
															#line 790 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		++self->lockRequests;
															#line 791 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<CoordinatorsHash> __when_expr_10 = getCoordinatorsHash(self);
															#line 791 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11824 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5when1(__when_expr_10.get(), loopDepth); };
		static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 6;
															#line 791 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ServeUnregisteredActor, 10, CoordinatorsHash >*>(static_cast<ServeUnregisteredActor*>(this)));
															#line 11829 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when5(ConfigFollowerLockRequest && __req,int loopDepth) 
	{
		req = std::move(__req);
															#line 790 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		++self->lockRequests;
															#line 791 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<CoordinatorsHash> __when_expr_10 = getCoordinatorsHash(self);
															#line 791 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11843 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5when1(__when_expr_10.get(), loopDepth); };
		static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 6;
															#line 791 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ServeUnregisteredActor, 10, CoordinatorsHash >*>(static_cast<ServeUnregisteredActor*>(this)));
															#line 11848 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when6(Void const& _,int loopDepth) 
	{
															#line 803 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		ASSERT(false);
															#line 11857 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(Void && _,int loopDepth) 
	{
															#line 803 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		ASSERT(false);
															#line 11866 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state > 0) static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 0;
		static_cast<ServeUnregisteredActor*>(this)->ActorSingleCallback< ServeUnregisteredActor, 0, ConfigFollowerGetSnapshotAndChangesRequest >::remove();
		static_cast<ServeUnregisteredActor*>(this)->ActorSingleCallback< ServeUnregisteredActor, 1, ConfigFollowerGetChangesRequest >::remove();
		static_cast<ServeUnregisteredActor*>(this)->ActorSingleCallback< ServeUnregisteredActor, 2, ConfigFollowerRollforwardRequest >::remove();
		static_cast<ServeUnregisteredActor*>(this)->ActorSingleCallback< ServeUnregisteredActor, 3, ConfigFollowerGetCommittedVersionRequest >::remove();
		static_cast<ServeUnregisteredActor*>(this)->ActorSingleCallback< ServeUnregisteredActor, 4, ConfigFollowerLockRequest >::remove();
		static_cast<ServeUnregisteredActor*>(this)->ActorCallback< ServeUnregisteredActor, 5, Void >::remove();

	}
	int a_body1loopBody1when1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state > 0) static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 0;
		static_cast<ServeUnregisteredActor*>(this)->ActorCallback< ServeUnregisteredActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeUnregisteredActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ServeUnregisteredActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ServeUnregisteredActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< ServeUnregisteredActor, 0, ConfigFollowerGetSnapshotAndChangesRequest >*,ConfigFollowerGetSnapshotAndChangesRequest const& value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ServeUnregisteredActor, 0, ConfigFollowerGetSnapshotAndChangesRequest >*,ConfigFollowerGetSnapshotAndChangesRequest && value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ServeUnregisteredActor, 0, ConfigFollowerGetSnapshotAndChangesRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state > 0) static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 0;
		static_cast<ServeUnregisteredActor*>(this)->ActorCallback< ServeUnregisteredActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeUnregisteredActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ServeUnregisteredActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ServeUnregisteredActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< ServeUnregisteredActor, 1, ConfigFollowerGetChangesRequest >*,ConfigFollowerGetChangesRequest const& value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ServeUnregisteredActor, 1, ConfigFollowerGetChangesRequest >*,ConfigFollowerGetChangesRequest && value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< ServeUnregisteredActor, 1, ConfigFollowerGetChangesRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1when3cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when3cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when3cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state > 0) static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 0;
		static_cast<ServeUnregisteredActor*>(this)->ActorCallback< ServeUnregisteredActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeUnregisteredActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ServeUnregisteredActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ServeUnregisteredActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorSingleCallback< ServeUnregisteredActor, 2, ConfigFollowerRollforwardRequest >*,ConfigFollowerRollforwardRequest const& value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< ServeUnregisteredActor, 2, ConfigFollowerRollforwardRequest >*,ConfigFollowerRollforwardRequest && value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< ServeUnregisteredActor, 2, ConfigFollowerRollforwardRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1when4cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when4cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when4cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state > 0) static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 0;
		static_cast<ServeUnregisteredActor*>(this)->ActorCallback< ServeUnregisteredActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeUnregisteredActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ServeUnregisteredActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ServeUnregisteredActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorSingleCallback< ServeUnregisteredActor, 3, ConfigFollowerGetCommittedVersionRequest >*,ConfigFollowerGetCommittedVersionRequest const& value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< ServeUnregisteredActor, 3, ConfigFollowerGetCommittedVersionRequest >*,ConfigFollowerGetCommittedVersionRequest && value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< ServeUnregisteredActor, 3, ConfigFollowerGetCommittedVersionRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1when5cont1(CoordinatorsHash const& coordinatorsHash,int loopDepth) 
	{
															#line 792 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (coordinatorsHash == 0 || coordinatorsHash == req.coordinatorsHash)
															#line 12462 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 793 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			TraceEvent("ConfigNodeLocking", self->id).log();
															#line 794 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			self->kvStore->set(KeyValueRef(registeredKey, BinaryWriter::toValue(false, IncludeVersion())));
															#line 795 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			self->kvStore->set(KeyValueRef( lockedKey, BinaryWriter::toValue(Optional<CoordinatorsHash>(req.coordinatorsHash), IncludeVersion())));
															#line 798 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Void> __when_expr_11 = self->kvStore->commit();
															#line 798 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12474 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5cont1when1(__when_expr_11.get(), loopDepth); };
			static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 7;
															#line 798 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< ServeUnregisteredActor, 11, Void >*>(static_cast<ServeUnregisteredActor*>(this)));
															#line 12479 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1when5cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when5cont1(CoordinatorsHash && coordinatorsHash,int loopDepth) 
	{
															#line 792 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (coordinatorsHash == 0 || coordinatorsHash == req.coordinatorsHash)
															#line 12493 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		{
															#line 793 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			TraceEvent("ConfigNodeLocking", self->id).log();
															#line 794 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			self->kvStore->set(KeyValueRef(registeredKey, BinaryWriter::toValue(false, IncludeVersion())));
															#line 795 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			self->kvStore->set(KeyValueRef( lockedKey, BinaryWriter::toValue(Optional<CoordinatorsHash>(req.coordinatorsHash), IncludeVersion())));
															#line 798 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Void> __when_expr_11 = self->kvStore->commit();
															#line 798 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12505 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5cont1when1(__when_expr_11.get(), loopDepth); };
			static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 7;
															#line 798 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< ServeUnregisteredActor, 11, Void >*>(static_cast<ServeUnregisteredActor*>(this)));
															#line 12510 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1when5cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when5when1(CoordinatorsHash const& coordinatorsHash,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when5cont1(coordinatorsHash, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5when1(CoordinatorsHash && coordinatorsHash,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when5cont1(std::move(coordinatorsHash), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state > 0) static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 0;
		static_cast<ServeUnregisteredActor*>(this)->ActorCallback< ServeUnregisteredActor, 10, CoordinatorsHash >::remove();

	}
	void a_callback_fire(ActorCallback< ServeUnregisteredActor, 10, CoordinatorsHash >*,CoordinatorsHash const& value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1when5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ServeUnregisteredActor, 10, CoordinatorsHash >*,CoordinatorsHash && value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1when5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ServeUnregisteredActor, 10, CoordinatorsHash >*,Error err) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1loopBody1when5cont2(int loopDepth) 
	{
															#line 800 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(Void());
															#line 12599 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when5cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when5cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when5cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when5cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ServeUnregisteredActor*>(this)->actor_wait_state > 0) static_cast<ServeUnregisteredActor*>(this)->actor_wait_state = 0;
		static_cast<ServeUnregisteredActor*>(this)->ActorCallback< ServeUnregisteredActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeUnregisteredActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1when5cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< ServeUnregisteredActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1when5cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< ServeUnregisteredActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorSingleCallback< ServeUnregisteredActor, 4, ConfigFollowerLockRequest >*,ConfigFollowerLockRequest const& value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< ServeUnregisteredActor, 4, ConfigFollowerLockRequest >*,ConfigFollowerLockRequest && value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< ServeUnregisteredActor, 4, ConfigFollowerLockRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ServeUnregisteredActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ServeUnregisteredActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ServeUnregisteredActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 770 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 770 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigFollowerInterface const* cfi;
															#line 789 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigFollowerLockRequest req;
															#line 12811 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via serveUnregistered()
															#line 770 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class ServeUnregisteredActor final : public Actor<Void>, public ActorSingleCallback< ServeUnregisteredActor, 0, ConfigFollowerGetSnapshotAndChangesRequest >, public ActorCallback< ServeUnregisteredActor, 6, Void >, public ActorSingleCallback< ServeUnregisteredActor, 1, ConfigFollowerGetChangesRequest >, public ActorCallback< ServeUnregisteredActor, 7, Void >, public ActorSingleCallback< ServeUnregisteredActor, 2, ConfigFollowerRollforwardRequest >, public ActorCallback< ServeUnregisteredActor, 8, Void >, public ActorSingleCallback< ServeUnregisteredActor, 3, ConfigFollowerGetCommittedVersionRequest >, public ActorCallback< ServeUnregisteredActor, 9, Void >, public ActorSingleCallback< ServeUnregisteredActor, 4, ConfigFollowerLockRequest >, public ActorCallback< ServeUnregisteredActor, 10, CoordinatorsHash >, public ActorCallback< ServeUnregisteredActor, 11, Void >, public ActorCallback< ServeUnregisteredActor, 5, Void >, public FastAllocated<ServeUnregisteredActor>, public ServeUnregisteredActorState<ServeUnregisteredActor> {
															#line 12816 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<ServeUnregisteredActor>::operator new;
	using FastAllocated<ServeUnregisteredActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1489561473509435136UL, 941020487060011520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ServeUnregisteredActor, 0, ConfigFollowerGetSnapshotAndChangesRequest >;
friend struct ActorCallback< ServeUnregisteredActor, 6, Void >;
friend struct ActorSingleCallback< ServeUnregisteredActor, 1, ConfigFollowerGetChangesRequest >;
friend struct ActorCallback< ServeUnregisteredActor, 7, Void >;
friend struct ActorSingleCallback< ServeUnregisteredActor, 2, ConfigFollowerRollforwardRequest >;
friend struct ActorCallback< ServeUnregisteredActor, 8, Void >;
friend struct ActorSingleCallback< ServeUnregisteredActor, 3, ConfigFollowerGetCommittedVersionRequest >;
friend struct ActorCallback< ServeUnregisteredActor, 9, Void >;
friend struct ActorSingleCallback< ServeUnregisteredActor, 4, ConfigFollowerLockRequest >;
friend struct ActorCallback< ServeUnregisteredActor, 10, CoordinatorsHash >;
friend struct ActorCallback< ServeUnregisteredActor, 11, Void >;
friend struct ActorCallback< ServeUnregisteredActor, 5, Void >;
															#line 770 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ServeUnregisteredActor(ConfigNodeImpl* const& self,ConfigFollowerInterface const* const& cfi) 
															#line 12844 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Void>(),
		   ServeUnregisteredActorState<ServeUnregisteredActor>(self, cfi),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serveUnregistered", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12803133974799923968UL, 11517361085022068224UL);
		ActorExecutionContextHelper __helper(static_cast<ServeUnregisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serveUnregistered");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serveUnregistered", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ServeUnregisteredActor, 0, ConfigFollowerGetSnapshotAndChangesRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ServeUnregisteredActor, 6, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ServeUnregisteredActor, 7, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ServeUnregisteredActor, 8, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ServeUnregisteredActor, 9, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ServeUnregisteredActor, 10, CoordinatorsHash >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ServeUnregisteredActor, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 770 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Void> serveUnregistered( ConfigNodeImpl* const& self, ConfigFollowerInterface const* const& cfi ) {
															#line 770 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Void>(new ServeUnregisteredActor(self, cfi));
															#line 12882 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 808 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

																#line 12887 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via serve()
															#line 809 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class ServeActor2>
															#line 809 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class ServeActor2State {
															#line 12893 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 809 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ServeActor2State(ConfigNodeImpl* const& self,ConfigBroadcastInterface const* const& cbi,ConfigTransactionInterface const* const& cti,ConfigFollowerInterface const* const& cfi) 
															#line 809 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 809 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 809 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   cbi(cbi),
															#line 809 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   cti(cti),
															#line 809 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   cfi(cfi),
															#line 813 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   serveUnregisteredFuture(serveUnregistered(self, cfi))
															#line 12908 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("serve", reinterpret_cast<unsigned long>(this));

	}
	~ServeActor2State() 
	{
		fdb_probe_actor_destroy("serve", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 814 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Void> __when_expr_0 = serve(self, cbi, false);
															#line 814 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<ServeActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12925 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ServeActor2*>(this)->actor_wait_state = 1;
															#line 814 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ServeActor2, 0, Void >*>(static_cast<ServeActor2*>(this)));
															#line 12930 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServeActor2State();
		static_cast<ServeActor2*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 816 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		self->kvStore->set(KeyValueRef(registeredKey, BinaryWriter::toValue(true, IncludeVersion())));
															#line 817 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->kvStore->commit();
															#line 817 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12957 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ServeActor2*>(this)->actor_wait_state = 2;
															#line 817 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ServeActor2, 1, Void >*>(static_cast<ServeActor2*>(this)));
															#line 12962 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 816 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		self->kvStore->set(KeyValueRef(registeredKey, BinaryWriter::toValue(true, IncludeVersion())));
															#line 817 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->kvStore->commit();
															#line 817 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12975 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ServeActor2*>(this)->actor_wait_state = 2;
															#line 817 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ServeActor2, 1, Void >*>(static_cast<ServeActor2*>(this)));
															#line 12980 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServeActor2*>(this)->actor_wait_state > 0) static_cast<ServeActor2*>(this)->actor_wait_state = 0;
		static_cast<ServeActor2*>(this)->ActorCallback< ServeActor2, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeActor2, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ServeActor2, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ServeActor2, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 820 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_2 = serve(self, cbi, true) || serve(self, cti) || serveRegistered(self, cfi) || serveUnregisteredFuture;
															#line 820 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13066 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ServeActor2*>(this)->actor_wait_state = 3;
															#line 820 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ServeActor2, 2, Void >*>(static_cast<ServeActor2*>(this)));
															#line 13071 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 820 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		StrictFuture<Void> __when_expr_2 = serve(self, cbi, true) || serve(self, cti) || serveRegistered(self, cfi) || serveUnregisteredFuture;
															#line 820 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13082 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ServeActor2*>(this)->actor_wait_state = 3;
															#line 820 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ServeActor2, 2, Void >*>(static_cast<ServeActor2*>(this)));
															#line 13087 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ServeActor2*>(this)->actor_wait_state > 0) static_cast<ServeActor2*>(this)->actor_wait_state = 0;
		static_cast<ServeActor2*>(this)->ActorCallback< ServeActor2, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeActor2, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ServeActor2, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ServeActor2, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 821 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<ServeActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServeActor2State(); static_cast<ServeActor2*>(this)->destroy(); return 0; }
															#line 13171 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<ServeActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServeActor2State();
		static_cast<ServeActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 821 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<ServeActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServeActor2State(); static_cast<ServeActor2*>(this)->destroy(); return 0; }
															#line 13183 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<ServeActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServeActor2State();
		static_cast<ServeActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ServeActor2*>(this)->actor_wait_state > 0) static_cast<ServeActor2*>(this)->actor_wait_state = 0;
		static_cast<ServeActor2*>(this)->ActorCallback< ServeActor2, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeActor2, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ServeActor2, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ServeActor2, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 809 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 809 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigBroadcastInterface const* cbi;
															#line 809 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigTransactionInterface const* cti;
															#line 809 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigFollowerInterface const* cfi;
															#line 813 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	Future<Void> serveUnregisteredFuture;
															#line 13276 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via serve()
															#line 809 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class ServeActor2 final : public Actor<Void>, public ActorCallback< ServeActor2, 0, Void >, public ActorCallback< ServeActor2, 1, Void >, public ActorCallback< ServeActor2, 2, Void >, public FastAllocated<ServeActor2>, public ServeActor2State<ServeActor2> {
															#line 13281 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<ServeActor2>::operator new;
	using FastAllocated<ServeActor2>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17335076387217348608UL, 15581730969420681728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ServeActor2, 0, Void >;
friend struct ActorCallback< ServeActor2, 1, Void >;
friend struct ActorCallback< ServeActor2, 2, Void >;
															#line 809 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ServeActor2(ConfigNodeImpl* const& self,ConfigBroadcastInterface const* const& cbi,ConfigTransactionInterface const* const& cti,ConfigFollowerInterface const* const& cfi) 
															#line 13300 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Void>(),
		   ServeActor2State<ServeActor2>(self, cbi, cti, cfi),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serve", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8193143223913706240UL, 712584914129289472UL);
		ActorExecutionContextHelper __helper(static_cast<ServeActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serve");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serve", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ServeActor2, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ServeActor2, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ServeActor2, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 809 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Void> serve( ConfigNodeImpl* const& self, ConfigBroadcastInterface const* const& cbi, ConfigTransactionInterface const* const& cti, ConfigFollowerInterface const* const& cfi ) {
															#line 809 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Void>(new ServeActor2(self, cbi, cti, cfi));
															#line 13334 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 823 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

																#line 13339 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via serveDisabled()
															#line 824 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class ServeDisabledActor>
															#line 824 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class ServeDisabledActorState {
															#line 13345 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 824 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ServeDisabledActorState(ConfigNodeImpl* const& self,ConfigTransactionInterface const* const& cti,ConfigFollowerInterface const* const& cfi) 
															#line 824 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 824 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self),
															#line 824 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   cti(cti),
															#line 824 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		   cfi(cfi)
															#line 13356 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("serveDisabled", reinterpret_cast<unsigned long>(this));

	}
	~ServeDisabledActorState() 
	{
		fdb_probe_actor_destroy("serveDisabled", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 827 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			;
															#line 13371 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServeDisabledActorState();
		static_cast<ServeDisabledActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 829 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		auto __when_expr_0 = cti->getGeneration.getFuture();
															#line 13401 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ConfigTransactionGetGenerationRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ConfigTransactionGetGenerationRequest>>::value, "invalid type");
															#line 828 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (static_cast<ServeDisabledActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13405 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 832 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		auto __when_expr_1 = cti->get.getFuture();
															#line 13409 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<ConfigTransactionGetRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<ConfigTransactionGetRequest>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 835 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		auto __when_expr_2 = cti->commit.getFuture();
															#line 13414 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<ConfigTransactionCommitRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<ConfigTransactionCommitRequest>>::value, "invalid type");
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
															#line 838 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		auto __when_expr_3 = cti->getClasses.getFuture();
															#line 13419 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<ConfigTransactionGetConfigClassesRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<ConfigTransactionGetConfigClassesRequest>>::value, "invalid type");
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.pop(), loopDepth); };
															#line 841 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		auto __when_expr_4 = cti->getKnobs.getFuture();
															#line 13424 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<ConfigTransactionGetKnobsRequest>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<ConfigTransactionGetKnobsRequest>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5(__when_expr_4.pop(), loopDepth); };
															#line 844 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		auto __when_expr_5 = cfi->lock.getFuture();
															#line 13429 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_5), FutureStream<ConfigFollowerLockRequest>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<ConfigFollowerLockRequest>>::value, "invalid type");
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when6(__when_expr_5.pop(), loopDepth); };
		static_cast<ServeDisabledActor*>(this)->actor_wait_state = 1;
															#line 829 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ServeDisabledActor, 0, ConfigTransactionGetGenerationRequest >*>(static_cast<ServeDisabledActor*>(this)));
															#line 832 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< ServeDisabledActor, 1, ConfigTransactionGetRequest >*>(static_cast<ServeDisabledActor*>(this)));
															#line 835 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< ServeDisabledActor, 2, ConfigTransactionCommitRequest >*>(static_cast<ServeDisabledActor*>(this)));
															#line 838 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< ServeDisabledActor, 3, ConfigTransactionGetConfigClassesRequest >*>(static_cast<ServeDisabledActor*>(this)));
															#line 841 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< ServeDisabledActor, 4, ConfigTransactionGetKnobsRequest >*>(static_cast<ServeDisabledActor*>(this)));
															#line 844 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< ServeDisabledActor, 5, ConfigFollowerLockRequest >*>(static_cast<ServeDisabledActor*>(this)));
															#line 13445 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(ConfigTransactionGetGenerationRequest const& req,int loopDepth) 
	{
															#line 830 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(ConfigTransactionGetGenerationReply{ ConfigGeneration() });
															#line 13460 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ConfigTransactionGetGenerationRequest && req,int loopDepth) 
	{
															#line 830 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(ConfigTransactionGetGenerationReply{ ConfigGeneration() });
															#line 13469 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ConfigTransactionGetRequest const& req,int loopDepth) 
	{
															#line 833 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(ConfigTransactionGetReply());
															#line 13478 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ConfigTransactionGetRequest && req,int loopDepth) 
	{
															#line 833 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(ConfigTransactionGetReply());
															#line 13487 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(ConfigTransactionCommitRequest const& req,int loopDepth) 
	{
															#line 836 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(Void());
															#line 13496 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(ConfigTransactionCommitRequest && req,int loopDepth) 
	{
															#line 836 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(Void());
															#line 13505 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(ConfigTransactionGetConfigClassesRequest const& req,int loopDepth) 
	{
															#line 839 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(ConfigTransactionGetConfigClassesReply());
															#line 13514 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(ConfigTransactionGetConfigClassesRequest && req,int loopDepth) 
	{
															#line 839 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(ConfigTransactionGetConfigClassesReply());
															#line 13523 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(ConfigTransactionGetKnobsRequest const& req,int loopDepth) 
	{
															#line 842 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(ConfigTransactionGetKnobsReply());
															#line 13532 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(ConfigTransactionGetKnobsRequest && req,int loopDepth) 
	{
															#line 842 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(ConfigTransactionGetKnobsReply());
															#line 13541 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(ConfigFollowerLockRequest const& __req,int loopDepth) 
	{
															#line 844 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req = __req;
															#line 845 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(Void());
															#line 13552 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(ConfigFollowerLockRequest && __req,int loopDepth) 
	{
		req = std::move(__req);
															#line 845 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		req.reply.send(Void());
															#line 13562 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServeDisabledActor*>(this)->actor_wait_state > 0) static_cast<ServeDisabledActor*>(this)->actor_wait_state = 0;
		static_cast<ServeDisabledActor*>(this)->ActorSingleCallback< ServeDisabledActor, 0, ConfigTransactionGetGenerationRequest >::remove();
		static_cast<ServeDisabledActor*>(this)->ActorSingleCallback< ServeDisabledActor, 1, ConfigTransactionGetRequest >::remove();
		static_cast<ServeDisabledActor*>(this)->ActorSingleCallback< ServeDisabledActor, 2, ConfigTransactionCommitRequest >::remove();
		static_cast<ServeDisabledActor*>(this)->ActorSingleCallback< ServeDisabledActor, 3, ConfigTransactionGetConfigClassesRequest >::remove();
		static_cast<ServeDisabledActor*>(this)->ActorSingleCallback< ServeDisabledActor, 4, ConfigTransactionGetKnobsRequest >::remove();
		static_cast<ServeDisabledActor*>(this)->ActorSingleCallback< ServeDisabledActor, 5, ConfigFollowerLockRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ServeDisabledActor, 0, ConfigTransactionGetGenerationRequest >*,ConfigTransactionGetGenerationRequest const& value) 
	{
		fdb_probe_actor_enter("serveDisabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveDisabled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ServeDisabledActor, 0, ConfigTransactionGetGenerationRequest >*,ConfigTransactionGetGenerationRequest && value) 
	{
		fdb_probe_actor_enter("serveDisabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveDisabled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ServeDisabledActor, 0, ConfigTransactionGetGenerationRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveDisabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveDisabled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ServeDisabledActor, 1, ConfigTransactionGetRequest >*,ConfigTransactionGetRequest const& value) 
	{
		fdb_probe_actor_enter("serveDisabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveDisabled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ServeDisabledActor, 1, ConfigTransactionGetRequest >*,ConfigTransactionGetRequest && value) 
	{
		fdb_probe_actor_enter("serveDisabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveDisabled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< ServeDisabledActor, 1, ConfigTransactionGetRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveDisabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveDisabled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ServeDisabledActor, 2, ConfigTransactionCommitRequest >*,ConfigTransactionCommitRequest const& value) 
	{
		fdb_probe_actor_enter("serveDisabled", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveDisabled", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< ServeDisabledActor, 2, ConfigTransactionCommitRequest >*,ConfigTransactionCommitRequest && value) 
	{
		fdb_probe_actor_enter("serveDisabled", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveDisabled", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< ServeDisabledActor, 2, ConfigTransactionCommitRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveDisabled", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveDisabled", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< ServeDisabledActor, 3, ConfigTransactionGetConfigClassesRequest >*,ConfigTransactionGetConfigClassesRequest const& value) 
	{
		fdb_probe_actor_enter("serveDisabled", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveDisabled", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< ServeDisabledActor, 3, ConfigTransactionGetConfigClassesRequest >*,ConfigTransactionGetConfigClassesRequest && value) 
	{
		fdb_probe_actor_enter("serveDisabled", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveDisabled", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< ServeDisabledActor, 3, ConfigTransactionGetConfigClassesRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveDisabled", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveDisabled", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< ServeDisabledActor, 4, ConfigTransactionGetKnobsRequest >*,ConfigTransactionGetKnobsRequest const& value) 
	{
		fdb_probe_actor_enter("serveDisabled", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveDisabled", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< ServeDisabledActor, 4, ConfigTransactionGetKnobsRequest >*,ConfigTransactionGetKnobsRequest && value) 
	{
		fdb_probe_actor_enter("serveDisabled", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveDisabled", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< ServeDisabledActor, 4, ConfigTransactionGetKnobsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveDisabled", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveDisabled", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< ServeDisabledActor, 5, ConfigFollowerLockRequest >*,ConfigFollowerLockRequest const& value) 
	{
		fdb_probe_actor_enter("serveDisabled", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveDisabled", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< ServeDisabledActor, 5, ConfigFollowerLockRequest >*,ConfigFollowerLockRequest && value) 
	{
		fdb_probe_actor_enter("serveDisabled", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveDisabled", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< ServeDisabledActor, 5, ConfigFollowerLockRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveDisabled", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveDisabled", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 824 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 824 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigTransactionInterface const* cti;
															#line 824 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigFollowerInterface const* cfi;
															#line 844 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigFollowerLockRequest req;
															#line 13928 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via serveDisabled()
															#line 824 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class ServeDisabledActor final : public Actor<Void>, public ActorSingleCallback< ServeDisabledActor, 0, ConfigTransactionGetGenerationRequest >, public ActorSingleCallback< ServeDisabledActor, 1, ConfigTransactionGetRequest >, public ActorSingleCallback< ServeDisabledActor, 2, ConfigTransactionCommitRequest >, public ActorSingleCallback< ServeDisabledActor, 3, ConfigTransactionGetConfigClassesRequest >, public ActorSingleCallback< ServeDisabledActor, 4, ConfigTransactionGetKnobsRequest >, public ActorSingleCallback< ServeDisabledActor, 5, ConfigFollowerLockRequest >, public FastAllocated<ServeDisabledActor>, public ServeDisabledActorState<ServeDisabledActor> {
															#line 13933 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<ServeDisabledActor>::operator new;
	using FastAllocated<ServeDisabledActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13996473674048501504UL, 3748172663132991744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ServeDisabledActor, 0, ConfigTransactionGetGenerationRequest >;
friend struct ActorSingleCallback< ServeDisabledActor, 1, ConfigTransactionGetRequest >;
friend struct ActorSingleCallback< ServeDisabledActor, 2, ConfigTransactionCommitRequest >;
friend struct ActorSingleCallback< ServeDisabledActor, 3, ConfigTransactionGetConfigClassesRequest >;
friend struct ActorSingleCallback< ServeDisabledActor, 4, ConfigTransactionGetKnobsRequest >;
friend struct ActorSingleCallback< ServeDisabledActor, 5, ConfigFollowerLockRequest >;
															#line 824 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ServeDisabledActor(ConfigNodeImpl* const& self,ConfigTransactionInterface const* const& cti,ConfigFollowerInterface const* const& cfi) 
															#line 13955 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<Void>(),
		   ServeDisabledActorState<ServeDisabledActor>(self, cti, cfi),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serveDisabled", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9198033425167990784UL, 10053297120392732672UL);
		ActorExecutionContextHelper __helper(static_cast<ServeDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serveDisabled");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serveDisabled", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ServeDisabledActor, 0, ConfigTransactionGetGenerationRequest >*)0, actor_cancelled()); break;
		}

	}
};
															#line 824 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<Void> serveDisabled( ConfigNodeImpl* const& self, ConfigTransactionInterface const* const& cti, ConfigFollowerInterface const* const& cfi ) {
															#line 824 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<Void>(new ServeDisabledActor(self, cti, cfi));
															#line 13987 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 850 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

																#line 13992 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
// This generated class is to be used only via registered()
															#line 851 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
template <class RegisteredActor>
															#line 851 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class RegisteredActorState {
															#line 13998 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
															#line 851 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	RegisteredActorState(ConfigNodeImpl* const& self) 
															#line 851 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
															#line 851 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		 : self(self)
															#line 14005 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
	{
		fdb_probe_actor_create("registered", reinterpret_cast<unsigned long>(this));

	}
	~RegisteredActorState() 
	{
		fdb_probe_actor_destroy("registered", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 852 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = self->kvStore->readValue(registeredKey);
															#line 852 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			if (static_cast<RegisteredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14022 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RegisteredActor*>(this)->actor_wait_state = 1;
															#line 852 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegisteredActor, 0, Optional<Value> >*>(static_cast<RegisteredActor*>(this)));
															#line 14027 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisteredActorState();
		static_cast<RegisteredActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& value,int loopDepth) 
	{
															#line 853 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<RegisteredActor*>(this)->SAV<bool>::futures) { (void)(value.present()); this->~RegisteredActorState(); static_cast<RegisteredActor*>(this)->destroy(); return 0; }
															#line 14050 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<RegisteredActor*>(this)->SAV< bool >::value()) bool(value.present());
		this->~RegisteredActorState();
		static_cast<RegisteredActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && value,int loopDepth) 
	{
															#line 853 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
		if (!static_cast<RegisteredActor*>(this)->SAV<bool>::futures) { (void)(value.present()); this->~RegisteredActorState(); static_cast<RegisteredActor*>(this)->destroy(); return 0; }
															#line 14062 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		new (&static_cast<RegisteredActor*>(this)->SAV< bool >::value()) bool(value.present());
		this->~RegisteredActorState();
		static_cast<RegisteredActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1cont1(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegisteredActor*>(this)->actor_wait_state > 0) static_cast<RegisteredActor*>(this)->actor_wait_state = 0;
		static_cast<RegisteredActor*>(this)->ActorCallback< RegisteredActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< RegisteredActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("registered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegisteredActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("registered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegisteredActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("registered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registered", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 851 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	ConfigNodeImpl* self;
															#line 14147 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
};
// This generated class is to be used only via registered()
															#line 851 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
class RegisteredActor final : public Actor<bool>, public ActorCallback< RegisteredActor, 0, Optional<Value> >, public FastAllocated<RegisteredActor>, public RegisteredActorState<RegisteredActor> {
															#line 14152 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
public:
	using FastAllocated<RegisteredActor>::operator new;
	using FastAllocated<RegisteredActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17425400355926988800UL, 13839135245081828864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegisteredActor, 0, Optional<Value> >;
															#line 851 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	RegisteredActor(ConfigNodeImpl* const& self) 
															#line 14169 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
		 : Actor<bool>(),
		   RegisteredActorState<RegisteredActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registered", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14642276349372772864UL, 14295224107833016832UL);
		ActorExecutionContextHelper __helper(static_cast<RegisteredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registered");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registered", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegisteredActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 851 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
[[nodiscard]] static Future<bool> registered( ConfigNodeImpl* const& self ) {
															#line 851 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"
	return Future<bool>(new RegisteredActor(self));
															#line 14201 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbserver/ConfigNode.actor.g.cpp"
}

#line 855 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbserver/ConfigNode.actor.cpp"

public:
	ConfigNodeImpl(std::string const& folder)
	  : id(deterministicRandom()->randomUniqueID()), kvStore(folder, id, "globalconf-"), cc("ConfigNode"),
	    compactRequests("CompactRequests", cc), rollbackRequests("RollbackRequests", cc),
	    rollforwardRequests("RollforwardRequests", cc), successfulChangeRequests("SuccessfulChangeRequests", cc),
	    failedChangeRequests("FailedChangeRequests", cc), snapshotRequests("SnapshotRequests", cc),
	    getCommittedVersionRequests("GetCommittedVersionRequests", cc), lockRequests("LockRequests", cc),
	    successfulCommits("SuccessfulCommits", cc), failedCommits("FailedCommits", cc),
	    setMutations("SetMutations", cc), clearMutations("ClearMutations", cc),
	    getValueRequests("GetValueRequests", cc), getGenerationRequests("GetGenerationRequests", cc) {
		logger = cc.traceCounters("ConfigNodeMetrics", id, SERVER_KNOBS->WORKER_LOGGING_INTERVAL, "ConfigNode");
		TraceEvent(SevInfo, "StartingConfigNode", id).detail("KVStoreAlreadyExists", kvStore.exists());
	}

	Future<Void> serve(ConfigBroadcastInterface const& cbi,
	                   ConfigTransactionInterface const& cti,
	                   ConfigFollowerInterface const& cfi) {
		return serve(this, &cbi, &cti, &cfi);
	}

	Future<Void> serveDisabled(ConfigTransactionInterface const& cti, ConfigFollowerInterface const& cfi) {
		return serveDisabled(this, &cti, &cfi);
	}

	Future<Void> serve(ConfigBroadcastInterface const& cbi) { return serve(this, &cbi, true); }

	Future<Void> serve(ConfigTransactionInterface const& cti) { return serve(this, &cti); }

	Future<Void> serve(ConfigFollowerInterface const& cfi) {
		return serveUnregistered(this, &cfi) && serveRegistered(this, &cfi);
	}

	void close() { kvStore.close(); }

	Future<Void> onClosed() { return kvStore.onClosed(); }
};

ConfigNode::ConfigNode(std::string const& folder) : impl(PImpl<ConfigNodeImpl>::create(folder)) {}

ConfigNode::~ConfigNode() = default;

Future<Void> ConfigNode::serve(ConfigBroadcastInterface const& cbi,
                               ConfigTransactionInterface const& cti,
                               ConfigFollowerInterface const& cfi) {
	return impl->serve(cbi, cti, cfi);
}

Future<Void> ConfigNode::serveDisabled(ConfigTransactionInterface const& cti, ConfigFollowerInterface const& cfi) {
	return impl->serveDisabled(cti, cfi);
}

Future<Void> ConfigNode::serve(ConfigBroadcastInterface const& cbi) {
	return impl->serve(cbi);
}

Future<Void> ConfigNode::serve(ConfigTransactionInterface const& cti) {
	return impl->serve(cti);
}

Future<Void> ConfigNode::serve(ConfigFollowerInterface const& cfi) {
	return impl->serve(cfi);
}

void ConfigNode::close() {
	impl->close();
}

Future<Void> ConfigNode::onClosed() {
	return impl->onClosed();
}
