#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
/*
 * GlobalConfig.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/DatabaseContext.h"
#include "fdbclient/GlobalConfig.actor.h"
#include "fdbclient/SpecialKeySpace.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/Tuple.h"
#include "flow/Error.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

const KeyRef fdbClientInfoTxnSampleRate = "config/fdb_client_info/client_txn_sample_rate"_sr;
const KeyRef fdbClientInfoTxnSizeLimit = "config/fdb_client_info/client_txn_size_limit"_sr;

const KeyRef transactionTagSampleRate = "config/transaction_tag_sample_rate"_sr;
const KeyRef transactionTagSampleCost = "config/transaction_tag_sample_cost"_sr;

const KeyRef samplingFrequency = "visibility/sampling/frequency"_sr;
const KeyRef samplingWindow = "visibility/sampling/window"_sr;

GlobalConfig::GlobalConfig(DatabaseContext* cx) : cx(cx), lastUpdate(0) {}

void GlobalConfig::applyChanges(Transaction& tr,
                                const VectorRef<KeyValueRef>& insertions,
                                const VectorRef<KeyRangeRef>& clears) {
	VersionHistory vh{ 0 };
	for (const auto& kv : insertions) {
		vh.mutations.emplace_back_deep(vh.mutations.arena(), MutationRef(MutationRef::SetValue, kv.key, kv.value));
		tr.set(kv.key.withPrefix(globalConfigKeysPrefix), kv.value);
	}
	for (const auto& range : clears) {
		vh.mutations.emplace_back_deep(vh.mutations.arena(),
		                               MutationRef(MutationRef::ClearRange, range.begin, range.end));
		tr.clear(
		    KeyRangeRef(range.begin.withPrefix(globalConfigKeysPrefix), range.end.withPrefix(globalConfigKeysPrefix)));
	}

	// Record the mutations in this commit into the global configuration history.
	Key historyKey = addVersionStampAtEnd(globalConfigHistoryPrefix);
	ObjectWriter historyWriter(IncludeVersion());
	historyWriter.serialize(vh);
	tr.atomicOp(historyKey, historyWriter.toStringRef(), MutationRef::SetVersionstampedKey);

	// Write version key to trigger update in cluster controller.
	tr.atomicOp(globalConfigVersionKey,
	            "0123456789\x00\x00\x00\x00"_sr, // versionstamp
	            MutationRef::SetVersionstampedValue);
}

Key GlobalConfig::prefixedKey(KeyRef key) {
	return key.withPrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::GLOBALCONFIG).begin);
}

const Reference<ConfigValue> GlobalConfig::get(KeyRef name) {
	auto it = data.find(name);
	if (it == data.end()) {
		return Reference<ConfigValue>();
	}
	return it->second;
}

const std::map<KeyRef, Reference<ConfigValue>> GlobalConfig::get(KeyRangeRef range) {
	std::map<KeyRef, Reference<ConfigValue>> results;
	for (const auto& [key, value] : data) {
		if (range.contains(key)) {
			results[key] = value;
		}
	}
	return results;
}

Future<Void> GlobalConfig::onInitialized() {
	return initialized.getFuture();
}

Future<Void> GlobalConfig::onChange() {
	return configChanged.onTrigger();
}

void GlobalConfig::trigger(KeyRef key, std::function<void(std::optional<std::any>)> fn) {
	callbacks.emplace(key, std::move(fn));
}

void GlobalConfig::insert(KeyRef key, ValueRef value) {
	// TraceEvent(SevInfo, "GlobalConfigInsert").detail("Key", key).detail("Value", value);
	data.erase(key);

	Arena arena(key.expectedSize() + value.expectedSize());
	KeyRef stableKey = KeyRef(arena, key);
	try {
		std::any any;
		Tuple t = Tuple::unpack(value);
		if (t.getType(0) == Tuple::ElementType::UTF8) {
			any = StringRef(arena, t.getString(0).contents());
		} else if (t.getType(0) == Tuple::ElementType::INT) {
			any = t.getInt(0);
		} else if (t.getType(0) == Tuple::ElementType::BOOL) {
			any = t.getBool(0);
		} else if (t.getType(0) == Tuple::ElementType::FLOAT) {
			any = t.getFloat(0);
		} else if (t.getType(0) == Tuple::ElementType::DOUBLE) {
			any = t.getDouble(0);
		} else if (t.getType(0) == Tuple::ElementType::VERSIONSTAMP) {
			any = t.getVersionstamp(0);
		} else {
			ASSERT(false);
		}
		data[stableKey] = makeReference<ConfigValue>(std::move(arena), std::move(any));

		if (callbacks.find(stableKey) != callbacks.end()) {
			callbacks[stableKey](data[stableKey]->value);
		}
	} catch (Error& e) {
		TraceEvent(SevWarn, "GlobalConfigTupleParseError").detail("What", e.what());
	}
}

void GlobalConfig::erase(Key key) {
	erase(KeyRangeRef(key, keyAfter(key)));
}

void GlobalConfig::erase(KeyRangeRef range) {
	// TraceEvent(SevInfo, "GlobalConfigErase").detail("Range", range);
	auto it = data.begin();
	while (it != data.end()) {
		if (range.contains(it->first)) {
			if (callbacks.find(it->first) != callbacks.end()) {
				callbacks[it->first](std::nullopt);
			}
			it = data.erase(it);
		} else {
			++it;
		}
	}
}

															#line 159 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
// This generated class is to be used only via refresh()
															#line 157 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
template <class GlobalConfig_RefreshActor>
															#line 157 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
class GlobalConfig_RefreshActorState {
															#line 165 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
public:
															#line 157 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
	GlobalConfig_RefreshActorState(GlobalConfig* const& self,Version const& lastKnown,Version const& largestSeen) 
															#line 157 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
															#line 157 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		 : self(self),
															#line 157 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		   lastKnown(lastKnown),
															#line 157 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		   largestSeen(largestSeen)
															#line 176 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
	{
		fdb_probe_actor_create("refresh", reinterpret_cast<unsigned long>(this));

	}
	~GlobalConfig_RefreshActorState() 
	{
		fdb_probe_actor_destroy("refresh", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 159 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			self->erase(KeyRangeRef(""_sr, "\xff"_sr));
															#line 161 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			backoff = Backoff(CLIENT_KNOBS->GLOBAL_CONFIG_REFRESH_BACKOFF, CLIENT_KNOBS->GLOBAL_CONFIG_REFRESH_MAX_BACKOFF);
															#line 162 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			;
															#line 195 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GlobalConfig_RefreshActorState();
		static_cast<GlobalConfig_RefreshActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 164 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			StrictFuture<GlobalConfigRefreshReply> __when_expr_0 = timeoutError(basicLoadBalance(self->cx->getGrvProxies(UseProvisionalProxies::False), &GrvProxyInterface::refreshGlobalConfig, GlobalConfigRefreshRequest{ lastKnown }), CLIENT_KNOBS->GLOBAL_CONFIG_REFRESH_TIMEOUT);
															#line 164 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			if (static_cast<GlobalConfig_RefreshActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 228 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GlobalConfig_RefreshActor*>(this)->actor_wait_state = 1;
															#line 164 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GlobalConfig_RefreshActor, 0, GlobalConfigRefreshReply >*>(static_cast<GlobalConfig_RefreshActor*>(this)));
															#line 233 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 179 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 255 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			{
															#line 180 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 259 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			}
															#line 183 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			StrictFuture<Void> __when_expr_2 = backoff.onError();
															#line 183 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			if (static_cast<GlobalConfig_RefreshActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 265 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GlobalConfig_RefreshActor*>(this)->actor_wait_state = 3;
															#line 183 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GlobalConfig_RefreshActor, 2, Void >*>(static_cast<GlobalConfig_RefreshActor*>(this)));
															#line 270 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(GlobalConfigRefreshReply const& reply,int loopDepth) 
	{
															#line 169 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		for( const auto& kv : reply.result ) {
															#line 170 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			KeyRef systemKey = kv.key.removePrefix(globalConfigKeysPrefix);
															#line 171 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			self->insert(systemKey, kv.value);
															#line 289 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		}
															#line 173 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		if (reply.version >= largestSeen || largestSeen == std::numeric_limits<Version>::max())
															#line 293 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		{
															#line 174 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			if (!static_cast<GlobalConfig_RefreshActor*>(this)->SAV<Version>::futures) { (void)(reply.version); this->~GlobalConfig_RefreshActorState(); static_cast<GlobalConfig_RefreshActor*>(this)->destroy(); return 0; }
															#line 297 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			new (&static_cast<GlobalConfig_RefreshActor*>(this)->SAV< Version >::value()) Version(reply.version);
			this->~GlobalConfig_RefreshActorState();
			static_cast<GlobalConfig_RefreshActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 176 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(0.25);
															#line 176 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			if (static_cast<GlobalConfig_RefreshActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 309 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<GlobalConfig_RefreshActor*>(this)->actor_wait_state = 2;
															#line 176 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GlobalConfig_RefreshActor, 1, Void >*>(static_cast<GlobalConfig_RefreshActor*>(this)));
															#line 314 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(GlobalConfigRefreshReply && reply,int loopDepth) 
	{
															#line 169 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		for( const auto& kv : reply.result ) {
															#line 170 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			KeyRef systemKey = kv.key.removePrefix(globalConfigKeysPrefix);
															#line 171 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			self->insert(systemKey, kv.value);
															#line 328 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		}
															#line 173 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		if (reply.version >= largestSeen || largestSeen == std::numeric_limits<Version>::max())
															#line 332 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		{
															#line 174 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			if (!static_cast<GlobalConfig_RefreshActor*>(this)->SAV<Version>::futures) { (void)(reply.version); this->~GlobalConfig_RefreshActorState(); static_cast<GlobalConfig_RefreshActor*>(this)->destroy(); return 0; }
															#line 336 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			new (&static_cast<GlobalConfig_RefreshActor*>(this)->SAV< Version >::value()) Version(reply.version);
			this->~GlobalConfig_RefreshActorState();
			static_cast<GlobalConfig_RefreshActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 176 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(0.25);
															#line 176 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			if (static_cast<GlobalConfig_RefreshActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 348 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<GlobalConfig_RefreshActor*>(this)->actor_wait_state = 2;
															#line 176 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GlobalConfig_RefreshActor, 1, Void >*>(static_cast<GlobalConfig_RefreshActor*>(this)));
															#line 353 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(GlobalConfigRefreshReply const& reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(reply, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GlobalConfigRefreshReply && reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GlobalConfig_RefreshActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfig_RefreshActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfig_RefreshActor*>(this)->ActorCallback< GlobalConfig_RefreshActor, 0, GlobalConfigRefreshReply >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfig_RefreshActor, 0, GlobalConfigRefreshReply >*,GlobalConfigRefreshReply const& value) 
	{
		fdb_probe_actor_enter("refresh", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_RefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refresh", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GlobalConfig_RefreshActor, 0, GlobalConfigRefreshReply >*,GlobalConfigRefreshReply && value) 
	{
		fdb_probe_actor_enter("refresh", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_RefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refresh", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GlobalConfig_RefreshActor, 0, GlobalConfigRefreshReply >*,Error err) 
	{
		fdb_probe_actor_enter("refresh", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_RefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refresh", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GlobalConfig_RefreshActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfig_RefreshActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfig_RefreshActor*>(this)->ActorCallback< GlobalConfig_RefreshActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfig_RefreshActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("refresh", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_RefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refresh", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GlobalConfig_RefreshActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("refresh", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_RefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refresh", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GlobalConfig_RefreshActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("refresh", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_RefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refresh", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GlobalConfig_RefreshActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfig_RefreshActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfig_RefreshActor*>(this)->ActorCallback< GlobalConfig_RefreshActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfig_RefreshActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("refresh", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_RefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refresh", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GlobalConfig_RefreshActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("refresh", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_RefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refresh", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GlobalConfig_RefreshActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("refresh", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_RefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refresh", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 157 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
	GlobalConfig* self;
															#line 157 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
	Version lastKnown;
															#line 157 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
	Version largestSeen;
															#line 161 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
	Backoff backoff;
															#line 635 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
};
// This generated class is to be used only via refresh()
															#line 157 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
class GlobalConfig_RefreshActor final : public Actor<Version>, public ActorCallback< GlobalConfig_RefreshActor, 0, GlobalConfigRefreshReply >, public ActorCallback< GlobalConfig_RefreshActor, 1, Void >, public ActorCallback< GlobalConfig_RefreshActor, 2, Void >, public FastAllocated<GlobalConfig_RefreshActor>, public GlobalConfig_RefreshActorState<GlobalConfig_RefreshActor> {
															#line 640 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
public:
	using FastAllocated<GlobalConfig_RefreshActor>::operator new;
	using FastAllocated<GlobalConfig_RefreshActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4264888457276456448UL, 1056194731768177152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GlobalConfig_RefreshActor, 0, GlobalConfigRefreshReply >;
friend struct ActorCallback< GlobalConfig_RefreshActor, 1, Void >;
friend struct ActorCallback< GlobalConfig_RefreshActor, 2, Void >;
															#line 157 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
	GlobalConfig_RefreshActor(GlobalConfig* const& self,Version const& lastKnown,Version const& largestSeen) 
															#line 659 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		 : Actor<Version>(),
		   GlobalConfig_RefreshActorState<GlobalConfig_RefreshActor>(self, lastKnown, largestSeen),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("refresh", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12345202533824263168UL, 9558918052261812736UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_RefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("refresh");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("refresh", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GlobalConfig_RefreshActor, 0, GlobalConfigRefreshReply >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GlobalConfig_RefreshActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GlobalConfig_RefreshActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 157 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
[[nodiscard]] Future<Version> GlobalConfig::refresh( GlobalConfig* const& self, Version const& lastKnown, Version const& largestSeen ) {
															#line 157 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
	return Future<Version>(new GlobalConfig_RefreshActor(self, lastKnown, largestSeen));
															#line 693 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
}

#line 187 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"

// Applies updates to the local copy of the global configuration when this
// process receives an updated history.
															#line 700 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
// This generated class is to be used only via updater()
															#line 190 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
template <class GlobalConfig_UpdaterActor>
															#line 190 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
class GlobalConfig_UpdaterActorState {
															#line 706 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
public:
															#line 190 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
	GlobalConfig_UpdaterActorState(GlobalConfig* const& self,const ClientDBInfo* const& dbInfo) 
															#line 190 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
															#line 190 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		 : self(self),
															#line 190 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		   dbInfo(dbInfo)
															#line 715 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
	{
		fdb_probe_actor_create("updater", reinterpret_cast<unsigned long>(this));

	}
	~GlobalConfig_UpdaterActorState() 
	{
		fdb_probe_actor_destroy("updater", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 191 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			;
															#line 730 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GlobalConfig_UpdaterActorState();
		static_cast<GlobalConfig_UpdaterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 193 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			if (self->initialized.canBeSet())
															#line 761 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			{
															#line 194 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->cx->onConnected();
															#line 194 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
				if (static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 767 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state = 1;
															#line 194 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GlobalConfig_UpdaterActor, 0, Void >*>(static_cast<GlobalConfig_UpdaterActor*>(this)));
															#line 772 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 256 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 799 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			{
															#line 257 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 803 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			}
															#line 262 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			TraceEvent("GlobalConfigUpdaterError").error(e);
															#line 263 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			StrictFuture<Void> __when_expr_6 = delay(1.0);
															#line 263 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			if (static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 811 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
			static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state = 7;
															#line 263 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< GlobalConfig_UpdaterActor, 6, Void >*>(static_cast<GlobalConfig_UpdaterActor*>(this)));
															#line 816 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 204 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		;
															#line 831 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 196 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		StrictFuture<Version> __when_expr_1 = self->refresh(self, -1, 0);
															#line 196 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		if (static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 842 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state = 2;
															#line 196 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GlobalConfig_UpdaterActor, 1, Version >*>(static_cast<GlobalConfig_UpdaterActor*>(this)));
															#line 847 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 196 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		StrictFuture<Version> __when_expr_1 = self->refresh(self, -1, 0);
															#line 196 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		if (static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 858 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state = 2;
															#line 196 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GlobalConfig_UpdaterActor, 1, Version >*>(static_cast<GlobalConfig_UpdaterActor*>(this)));
															#line 863 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfig_UpdaterActor*>(this)->ActorCallback< GlobalConfig_UpdaterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfig_UpdaterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GlobalConfig_UpdaterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GlobalConfig_UpdaterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Version const& version,int loopDepth) 
	{
															#line 197 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		self->lastUpdate = version;
															#line 199 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		self->cx->addref();
															#line 200 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		self->initialized.send(Void());
															#line 201 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		self->cx->delref();
															#line 953 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Version && version,int loopDepth) 
	{
															#line 197 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		self->lastUpdate = version;
															#line 199 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		self->cx->addref();
															#line 200 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		self->initialized.send(Void());
															#line 201 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		self->cx->delref();
															#line 968 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(version, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfig_UpdaterActor*>(this)->ActorCallback< GlobalConfig_UpdaterActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfig_UpdaterActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GlobalConfig_UpdaterActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GlobalConfig_UpdaterActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 207 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(0);
															#line 207 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			if (static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1062 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state = 3;
															#line 207 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GlobalConfig_UpdaterActor, 2, Void >*>(static_cast<GlobalConfig_UpdaterActor*>(this)));
															#line 1067 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 252 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			return a_body1loopBody1Catch1(e, std::max(0, loopDepth - 1));
															#line 1089 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 208 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		if (dbInfo->history.size() > 0)
															#line 1103 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		{
															#line 209 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			if (self->lastUpdate < dbInfo->history[0].version)
															#line 1107 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			{
															#line 213 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
				StrictFuture<Version> __when_expr_3 = self->refresh(self, self->lastUpdate, dbInfo->history.back().version);
															#line 213 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
				if (static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1113 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont2loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
				static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state = 4;
															#line 213 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GlobalConfig_UpdaterActor, 3, Version >*>(static_cast<GlobalConfig_UpdaterActor*>(this)));
															#line 1118 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 227 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
				for( const auto& vh : dbInfo->history ) {
															#line 228 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
					if (vh.version <= self->lastUpdate)
															#line 1127 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
					{
						continue;
					}
															#line 232 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
					for( const auto& mutation : vh.mutations.contents() ) {
															#line 233 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
						if (mutation.type == MutationRef::SetValue)
															#line 1135 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
						{
															#line 234 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
							self->insert(mutation.param1, mutation.param2);
															#line 1139 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
						}
						else
						{
															#line 235 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
							if (mutation.type == MutationRef::ClearRange)
															#line 1145 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
							{
															#line 236 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
								self->erase(KeyRangeRef(mutation.param1, mutation.param2));
															#line 1149 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
							}
							else
							{
															#line 238 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
								UNREACHABLE();
															#line 1155 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
							}
						}
					}
															#line 242 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
					ASSERT(vh.version > self->lastUpdate);
															#line 243 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
					self->lastUpdate = vh.version;
															#line 1163 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
				}
				loopDepth = a_body1loopBody1cont2loopBody1cont4(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont2loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 208 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		if (dbInfo->history.size() > 0)
															#line 1179 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		{
															#line 209 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
			if (self->lastUpdate < dbInfo->history[0].version)
															#line 1183 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
			{
															#line 213 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
				StrictFuture<Version> __when_expr_3 = self->refresh(self, self->lastUpdate, dbInfo->history.back().version);
															#line 213 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
				if (static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1189 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont2loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
				static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state = 4;
															#line 213 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GlobalConfig_UpdaterActor, 3, Version >*>(static_cast<GlobalConfig_UpdaterActor*>(this)));
															#line 1194 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 227 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
				for( const auto& vh : dbInfo->history ) {
															#line 228 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
					if (vh.version <= self->lastUpdate)
															#line 1203 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
					{
						continue;
					}
															#line 232 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
					for( const auto& mutation : vh.mutations.contents() ) {
															#line 233 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
						if (mutation.type == MutationRef::SetValue)
															#line 1211 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
						{
															#line 234 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
							self->insert(mutation.param1, mutation.param2);
															#line 1215 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
						}
						else
						{
															#line 235 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
							if (mutation.type == MutationRef::ClearRange)
															#line 1221 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
							{
															#line 236 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
								self->erase(KeyRangeRef(mutation.param1, mutation.param2));
															#line 1225 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
							}
							else
							{
															#line 238 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
								UNREACHABLE();
															#line 1231 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
							}
						}
					}
															#line 242 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
					ASSERT(vh.version > self->lastUpdate);
															#line 243 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
					self->lastUpdate = vh.version;
															#line 1239 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
				}
				loopDepth = a_body1loopBody1cont2loopBody1cont4(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont2loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfig_UpdaterActor*>(this)->ActorCallback< GlobalConfig_UpdaterActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfig_UpdaterActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GlobalConfig_UpdaterActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GlobalConfig_UpdaterActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont2loopBody1cont3(int loopDepth) 
	{
															#line 249 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(0);
															#line 249 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		if (static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1332 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state = 5;
															#line 249 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GlobalConfig_UpdaterActor, 4, Void >*>(static_cast<GlobalConfig_UpdaterActor*>(this)));
															#line 1337 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont4(int loopDepth) 
	{
															#line 246 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		self->configChanged.trigger();
															#line 1346 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont5(Version const& version,int loopDepth) 
	{
															#line 215 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		self->lastUpdate = version;
															#line 219 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		if (dbInfo->history.size() > 0 && dbInfo->history[0].version != std::numeric_limits<Version>::max())
															#line 1357 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		{
			return a_body1loopBody1cont2loopHead1(loopDepth); // continue
		}
		loopDepth = a_body1loopBody1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont5(Version && version,int loopDepth) 
	{
															#line 215 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		self->lastUpdate = version;
															#line 219 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		if (dbInfo->history.size() > 0 && dbInfo->history[0].version != std::numeric_limits<Version>::max())
															#line 1371 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		{
			return a_body1loopBody1cont2loopHead1(loopDepth); // continue
		}
		loopDepth = a_body1loopBody1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont2when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont5(version, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont2when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont5(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfig_UpdaterActor*>(this)->ActorCallback< GlobalConfig_UpdaterActor, 3, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfig_UpdaterActor, 3, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GlobalConfig_UpdaterActor, 3, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GlobalConfig_UpdaterActor, 3, Version >*,Error err) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont2loopBody1cont17(Void const& _,int loopDepth) 
	{
															#line 250 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->dbInfoChanged.onTrigger();
															#line 250 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		if (static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1460 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1cont2loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont17when1(__when_expr_5.get(), loopDepth); };
		static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state = 6;
															#line 250 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GlobalConfig_UpdaterActor, 5, Void >*>(static_cast<GlobalConfig_UpdaterActor*>(this)));
															#line 1465 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont17(Void && _,int loopDepth) 
	{
															#line 250 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->dbInfoChanged.onTrigger();
															#line 250 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		if (static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1476 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1cont2loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont17when1(__when_expr_5.get(), loopDepth); };
		static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state = 6;
															#line 250 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GlobalConfig_UpdaterActor, 5, Void >*>(static_cast<GlobalConfig_UpdaterActor*>(this)));
															#line 1481 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont17(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont17(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfig_UpdaterActor*>(this)->ActorCallback< GlobalConfig_UpdaterActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfig_UpdaterActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GlobalConfig_UpdaterActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GlobalConfig_UpdaterActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont2loopBody1cont17cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont17cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont17cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont17cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont17when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont17cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont17when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont17cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfig_UpdaterActor*>(this)->ActorCallback< GlobalConfig_UpdaterActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfig_UpdaterActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont2loopBody1cont17when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< GlobalConfig_UpdaterActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont2loopBody1cont17when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< GlobalConfig_UpdaterActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont2loopBody1cont17cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfig_UpdaterActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfig_UpdaterActor*>(this)->ActorCallback< GlobalConfig_UpdaterActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfig_UpdaterActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< GlobalConfig_UpdaterActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< GlobalConfig_UpdaterActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 190 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
	GlobalConfig* self;
															#line 190 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
	const ClientDBInfo* dbInfo;
															#line 1752 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
};
// This generated class is to be used only via updater()
															#line 190 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
class GlobalConfig_UpdaterActor final : public Actor<Void>, public ActorCallback< GlobalConfig_UpdaterActor, 0, Void >, public ActorCallback< GlobalConfig_UpdaterActor, 1, Version >, public ActorCallback< GlobalConfig_UpdaterActor, 2, Void >, public ActorCallback< GlobalConfig_UpdaterActor, 3, Version >, public ActorCallback< GlobalConfig_UpdaterActor, 4, Void >, public ActorCallback< GlobalConfig_UpdaterActor, 5, Void >, public ActorCallback< GlobalConfig_UpdaterActor, 6, Void >, public FastAllocated<GlobalConfig_UpdaterActor>, public GlobalConfig_UpdaterActorState<GlobalConfig_UpdaterActor> {
															#line 1757 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
public:
	using FastAllocated<GlobalConfig_UpdaterActor>::operator new;
	using FastAllocated<GlobalConfig_UpdaterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5377370917792908800UL, 15422220928014274048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GlobalConfig_UpdaterActor, 0, Void >;
friend struct ActorCallback< GlobalConfig_UpdaterActor, 1, Version >;
friend struct ActorCallback< GlobalConfig_UpdaterActor, 2, Void >;
friend struct ActorCallback< GlobalConfig_UpdaterActor, 3, Version >;
friend struct ActorCallback< GlobalConfig_UpdaterActor, 4, Void >;
friend struct ActorCallback< GlobalConfig_UpdaterActor, 5, Void >;
friend struct ActorCallback< GlobalConfig_UpdaterActor, 6, Void >;
															#line 190 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
	GlobalConfig_UpdaterActor(GlobalConfig* const& self,const ClientDBInfo* const& dbInfo) 
															#line 1780 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
		 : Actor<Void>(),
		   GlobalConfig_UpdaterActorState<GlobalConfig_UpdaterActor>(self, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updater", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5819616541626623488UL, 9965999146432387328UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfig_UpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updater");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updater", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GlobalConfig_UpdaterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GlobalConfig_UpdaterActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GlobalConfig_UpdaterActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GlobalConfig_UpdaterActor, 3, Version >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GlobalConfig_UpdaterActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GlobalConfig_UpdaterActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< GlobalConfig_UpdaterActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 190 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
[[nodiscard]] Future<Void> GlobalConfig::updater( GlobalConfig* const& self, const ClientDBInfo* const& dbInfo ) {
															#line 190 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
	return Future<Void>(new GlobalConfig_UpdaterActor(self, dbInfo));
															#line 1818 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbclient/GlobalConfig.actor.g.cpp"
}

#line 267 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbclient/GlobalConfig.actor.cpp"
