#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
/*
 * BulkDumpCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cstddef>
#include <fmt/core.h>
#include "fdbcli/fdbcli.actor.h"
#include "fdbclient/BulkDumping.h"
#include "fdbclient/BulkLoading.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "flow/Arena.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

static const char* BULK_DUMP_MODE_USAGE = "To set bulkdump mode: bulkdump mode [on|off]\n";
static const char* BULK_DUMP_DUMP_USAGE = "To dump a range of key/values: bulkdump dump <BEGINKEY> <ENDKEY> <DIR>\n"
                                          " where <BEGINKEY> to <ENDKEY> denotes the key/value range and <DIR> is\n"
                                          " a local directory OR blobstore url to dump SST files to.\n";
static const char* BULK_DUMP_STATUS_USAGE = "To get status: bulkdump status\n";
static const char* BULK_DUMP_CANCEL_USAGE = "To cancel current bulkdump job: bulkdump cancel <JOBID>\n";

static const std::string BULK_DUMP_HELP_MESSAGE =
    std::string(BULK_DUMP_MODE_USAGE) + std::string(BULK_DUMP_DUMP_USAGE) + std::string(BULK_DUMP_STATUS_USAGE) +
    std::string(BULK_DUMP_CANCEL_USAGE);

															#line 46 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
// This generated class is to be used only via getOngoingBulkDumpJob()
															#line 44 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
template <class GetOngoingBulkDumpJobActor>
															#line 44 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
class GetOngoingBulkDumpJobActorState {
															#line 52 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
public:
															#line 44 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
	GetOngoingBulkDumpJobActorState(Database const& cx) 
															#line 44 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
															#line 44 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		 : cx(cx),
															#line 45 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		   tr(cx)
															#line 61 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("getOngoingBulkDumpJob", reinterpret_cast<unsigned long>(this));

	}
	~GetOngoingBulkDumpJobActorState() 
	{
		fdb_probe_actor_destroy("getOngoingBulkDumpJob", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 46 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			;
															#line 76 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetOngoingBulkDumpJobActorState();
		static_cast<GetOngoingBulkDumpJobActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 48 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			StrictFuture<Optional<BulkDumpState>> __when_expr_0 = getSubmittedBulkDumpJob(&tr);
															#line 48 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (static_cast<GetOngoingBulkDumpJobActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 109 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetOngoingBulkDumpJobActor*>(this)->actor_wait_state = 1;
															#line 48 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetOngoingBulkDumpJobActor, 0, Optional<BulkDumpState> >*>(static_cast<GetOngoingBulkDumpJobActor*>(this)));
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 57 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 57 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (static_cast<GetOngoingBulkDumpJobActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 138 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetOngoingBulkDumpJobActor*>(this)->actor_wait_state = 2;
															#line 57 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetOngoingBulkDumpJobActor, 1, Void >*>(static_cast<GetOngoingBulkDumpJobActor*>(this)));
															#line 143 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<BulkDumpState> const& job,int loopDepth) 
	{
															#line 49 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (job.present())
															#line 158 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		{
															#line 50 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			fmt::println("Running bulk dumping job: {}", job.get().getJobId().toString());
															#line 51 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (!static_cast<GetOngoingBulkDumpJobActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetOngoingBulkDumpJobActorState(); static_cast<GetOngoingBulkDumpJobActor*>(this)->destroy(); return 0; }
															#line 164 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			new (&static_cast<GetOngoingBulkDumpJobActor*>(this)->SAV< bool >::value()) bool(true);
			this->~GetOngoingBulkDumpJobActorState();
			static_cast<GetOngoingBulkDumpJobActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 53 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			fmt::println("No bulk dumping job is running");
															#line 54 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (!static_cast<GetOngoingBulkDumpJobActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetOngoingBulkDumpJobActorState(); static_cast<GetOngoingBulkDumpJobActor*>(this)->destroy(); return 0; }
															#line 176 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			new (&static_cast<GetOngoingBulkDumpJobActor*>(this)->SAV< bool >::value()) bool(false);
			this->~GetOngoingBulkDumpJobActorState();
			static_cast<GetOngoingBulkDumpJobActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<BulkDumpState> && job,int loopDepth) 
	{
															#line 49 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (job.present())
															#line 189 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		{
															#line 50 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			fmt::println("Running bulk dumping job: {}", job.get().getJobId().toString());
															#line 51 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (!static_cast<GetOngoingBulkDumpJobActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetOngoingBulkDumpJobActorState(); static_cast<GetOngoingBulkDumpJobActor*>(this)->destroy(); return 0; }
															#line 195 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			new (&static_cast<GetOngoingBulkDumpJobActor*>(this)->SAV< bool >::value()) bool(true);
			this->~GetOngoingBulkDumpJobActorState();
			static_cast<GetOngoingBulkDumpJobActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 53 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			fmt::println("No bulk dumping job is running");
															#line 54 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (!static_cast<GetOngoingBulkDumpJobActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetOngoingBulkDumpJobActorState(); static_cast<GetOngoingBulkDumpJobActor*>(this)->destroy(); return 0; }
															#line 207 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			new (&static_cast<GetOngoingBulkDumpJobActor*>(this)->SAV< bool >::value()) bool(false);
			this->~GetOngoingBulkDumpJobActorState();
			static_cast<GetOngoingBulkDumpJobActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkDumpState> const& job,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(job, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkDumpState> && job,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(job), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetOngoingBulkDumpJobActor*>(this)->actor_wait_state > 0) static_cast<GetOngoingBulkDumpJobActor*>(this)->actor_wait_state = 0;
		static_cast<GetOngoingBulkDumpJobActor*>(this)->ActorCallback< GetOngoingBulkDumpJobActor, 0, Optional<BulkDumpState> >::remove();

	}
	void a_callback_fire(ActorCallback< GetOngoingBulkDumpJobActor, 0, Optional<BulkDumpState> >*,Optional<BulkDumpState> const& value) 
	{
		fdb_probe_actor_enter("getOngoingBulkDumpJob", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOngoingBulkDumpJobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOngoingBulkDumpJob", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetOngoingBulkDumpJobActor, 0, Optional<BulkDumpState> >*,Optional<BulkDumpState> && value) 
	{
		fdb_probe_actor_enter("getOngoingBulkDumpJob", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOngoingBulkDumpJobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOngoingBulkDumpJob", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetOngoingBulkDumpJobActor, 0, Optional<BulkDumpState> >*,Error err) 
	{
		fdb_probe_actor_enter("getOngoingBulkDumpJob", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetOngoingBulkDumpJobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOngoingBulkDumpJob", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetOngoingBulkDumpJobActor*>(this)->actor_wait_state > 0) static_cast<GetOngoingBulkDumpJobActor*>(this)->actor_wait_state = 0;
		static_cast<GetOngoingBulkDumpJobActor*>(this)->ActorCallback< GetOngoingBulkDumpJobActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetOngoingBulkDumpJobActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getOngoingBulkDumpJob", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOngoingBulkDumpJobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOngoingBulkDumpJob", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetOngoingBulkDumpJobActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getOngoingBulkDumpJob", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOngoingBulkDumpJobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOngoingBulkDumpJob", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetOngoingBulkDumpJobActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getOngoingBulkDumpJob", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetOngoingBulkDumpJobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOngoingBulkDumpJob", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 44 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
	Database cx;
															#line 45 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
	Transaction tr;
															#line 382 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
};
// This generated class is to be used only via getOngoingBulkDumpJob()
															#line 44 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
class GetOngoingBulkDumpJobActor final : public Actor<bool>, public ActorCallback< GetOngoingBulkDumpJobActor, 0, Optional<BulkDumpState> >, public ActorCallback< GetOngoingBulkDumpJobActor, 1, Void >, public FastAllocated<GetOngoingBulkDumpJobActor>, public GetOngoingBulkDumpJobActorState<GetOngoingBulkDumpJobActor> {
															#line 387 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
public:
	using FastAllocated<GetOngoingBulkDumpJobActor>::operator new;
	using FastAllocated<GetOngoingBulkDumpJobActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13472822034058733312UL, 5861625711590886400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetOngoingBulkDumpJobActor, 0, Optional<BulkDumpState> >;
friend struct ActorCallback< GetOngoingBulkDumpJobActor, 1, Void >;
															#line 44 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
	GetOngoingBulkDumpJobActor(Database const& cx) 
															#line 405 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		 : Actor<bool>(),
		   GetOngoingBulkDumpJobActorState<GetOngoingBulkDumpJobActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getOngoingBulkDumpJob", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15923630453378283264UL, 12277749279711140352UL);
		ActorExecutionContextHelper __helper(static_cast<GetOngoingBulkDumpJobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getOngoingBulkDumpJob");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getOngoingBulkDumpJob", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetOngoingBulkDumpJobActor, 0, Optional<BulkDumpState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetOngoingBulkDumpJobActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 44 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
[[nodiscard]] Future<bool> getOngoingBulkDumpJob( Database const& cx ) {
															#line 44 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
	return Future<bool>(new GetOngoingBulkDumpJobActor(cx));
															#line 438 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
}

#line 61 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"

															#line 443 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
// This generated class is to be used only via getBulkDumpCompleteRanges()
															#line 62 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
template <class GetBulkDumpCompleteRangesActor>
															#line 62 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
class GetBulkDumpCompleteRangesActorState {
															#line 449 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
public:
															#line 62 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
	GetBulkDumpCompleteRangesActorState(Database const& cx,KeyRange const& rangeToRead) 
															#line 62 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
															#line 62 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		 : cx(cx),
															#line 62 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		   rangeToRead(rangeToRead)
															#line 458 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("getBulkDumpCompleteRanges", reinterpret_cast<unsigned long>(this));

	}
	~GetBulkDumpCompleteRangesActorState() 
	{
		fdb_probe_actor_destroy("getBulkDumpCompleteRanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 64 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
				StrictFuture<size_t> __when_expr_0 = getBulkDumpCompleteTaskCount(cx, rangeToRead);
															#line 64 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
				if (static_cast<GetBulkDumpCompleteRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 476 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetBulkDumpCompleteRangesActor*>(this)->actor_wait_state = 1;
															#line 64 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBulkDumpCompleteRangesActor, 0, size_t >*>(static_cast<GetBulkDumpCompleteRangesActor*>(this)));
															#line 481 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBulkDumpCompleteRangesActorState();
		static_cast<GetBulkDumpCompleteRangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 71 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (!static_cast<GetBulkDumpCompleteRangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetBulkDumpCompleteRangesActorState(); static_cast<GetBulkDumpCompleteRangesActor*>(this)->destroy(); return 0; }
															#line 510 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		new (&static_cast<GetBulkDumpCompleteRangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetBulkDumpCompleteRangesActorState();
		static_cast<GetBulkDumpCompleteRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 67 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 523 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			{
															#line 68 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
				fmt::println("timed out");
															#line 527 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(size_t const& finishCount,int loopDepth) 
	{
															#line 65 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		fmt::println("Finished {} tasks", finishCount);
															#line 543 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(size_t && finishCount,int loopDepth) 
	{
															#line 65 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		fmt::println("Finished {} tasks", finishCount);
															#line 552 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(size_t const& finishCount,int loopDepth) 
	{
		loopDepth = a_body1cont2(finishCount, loopDepth);

		return loopDepth;
	}
	int a_body1when1(size_t && finishCount,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(finishCount), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBulkDumpCompleteRangesActor*>(this)->actor_wait_state > 0) static_cast<GetBulkDumpCompleteRangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkDumpCompleteRangesActor*>(this)->ActorCallback< GetBulkDumpCompleteRangesActor, 0, size_t >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkDumpCompleteRangesActor, 0, size_t >*,size_t const& value) 
	{
		fdb_probe_actor_enter("getBulkDumpCompleteRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkDumpCompleteRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkDumpCompleteRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBulkDumpCompleteRangesActor, 0, size_t >*,size_t && value) 
	{
		fdb_probe_actor_enter("getBulkDumpCompleteRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkDumpCompleteRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkDumpCompleteRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBulkDumpCompleteRangesActor, 0, size_t >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkDumpCompleteRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkDumpCompleteRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkDumpCompleteRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 62 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
	Database cx;
															#line 62 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
	KeyRange rangeToRead;
															#line 649 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
};
// This generated class is to be used only via getBulkDumpCompleteRanges()
															#line 62 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
class GetBulkDumpCompleteRangesActor final : public Actor<Void>, public ActorCallback< GetBulkDumpCompleteRangesActor, 0, size_t >, public FastAllocated<GetBulkDumpCompleteRangesActor>, public GetBulkDumpCompleteRangesActorState<GetBulkDumpCompleteRangesActor> {
															#line 654 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
public:
	using FastAllocated<GetBulkDumpCompleteRangesActor>::operator new;
	using FastAllocated<GetBulkDumpCompleteRangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(754182079112425216UL, 5071860950422250752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBulkDumpCompleteRangesActor, 0, size_t >;
															#line 62 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
	GetBulkDumpCompleteRangesActor(Database const& cx,KeyRange const& rangeToRead) 
															#line 671 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		 : Actor<Void>(),
		   GetBulkDumpCompleteRangesActorState<GetBulkDumpCompleteRangesActor>(cx, rangeToRead),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBulkDumpCompleteRanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15906799011430370560UL, 6544937756576615424UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkDumpCompleteRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBulkDumpCompleteRanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBulkDumpCompleteRanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBulkDumpCompleteRangesActor, 0, size_t >*)0, actor_cancelled()); break;
		}

	}
};
															#line 62 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
[[nodiscard]] Future<Void> getBulkDumpCompleteRanges( Database const& cx, KeyRange const& rangeToRead ) {
															#line 62 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
	return Future<Void>(new GetBulkDumpCompleteRangesActor(cx, rangeToRead));
															#line 703 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
}

#line 73 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"

															#line 708 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
// This generated class is to be used only via bulkDumpCommandActor()
															#line 74 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
template <class BulkDumpCommandActorActor>
															#line 74 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
class BulkDumpCommandActorActorState {
															#line 714 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
public:
															#line 74 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
	BulkDumpCommandActorActorState(Database const& cx,std::vector<StringRef> const& tokens) 
															#line 74 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
															#line 74 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		 : cx(cx),
															#line 74 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		   tokens(tokens),
															#line 75 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		   bulkDumpJob()
															#line 725 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~BulkDumpCommandActorActorState() 
	{
		fdb_probe_actor_destroy("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 76 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (tokencmp(tokens[1], "mode"))
															#line 740 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			{
															#line 77 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
				if (tokens.size() != 2 && tokens.size() != 3)
															#line 744 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
				{
															#line 78 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
					fmt::println("{}", BULK_DUMP_MODE_USAGE);
															#line 79 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
					if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 750 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
					new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
					this->~BulkDumpCommandActorActorState();
					static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 81 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
				if (tokens.size() == 2)
															#line 758 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
				{
															#line 82 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
					StrictFuture<int> __when_expr_0 = getBulkDumpMode(cx);
															#line 82 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
					if (static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 764 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state = 1;
															#line 82 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BulkDumpCommandActorActor, 0, int >*>(static_cast<BulkDumpCommandActorActor*>(this)));
															#line 769 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
															#line 107 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
				if (tokencmp(tokens[1], "dump"))
															#line 781 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
				{
															#line 108 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
					StrictFuture<int> __when_expr_3 = getBulkDumpMode(cx);
															#line 108 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
					if (static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 787 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
					if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1when2(__when_expr_3.get(), loopDepth); };
					static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state = 4;
															#line 108 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
					__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BulkDumpCommandActorActor, 3, int >*>(static_cast<BulkDumpCommandActorActor*>(this)));
															#line 792 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 135 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
					if (tokencmp(tokens[1], "cancel"))
															#line 799 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
					{
															#line 136 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
						if (tokens.size() != 3)
															#line 803 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
						{
															#line 137 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
							fmt::println("{}", BULK_DUMP_CANCEL_USAGE);
															#line 138 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
							if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 809 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
							new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
							this->~BulkDumpCommandActorActorState();
							static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
						jobId = UID::fromString(tokens[2].toString());
															#line 141 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
						StrictFuture<Void> __when_expr_5 = cancelBulkDumpJob(cx, jobId);
															#line 141 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
						if (static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 821 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
						if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1when3(__when_expr_5.get(), loopDepth); };
						static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state = 6;
															#line 141 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
						__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< BulkDumpCommandActorActor, 5, Void >*>(static_cast<BulkDumpCommandActorActor*>(this)));
															#line 826 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 145 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
						if (tokencmp(tokens[1], "status"))
															#line 833 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
						{
															#line 146 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
							if (tokens.size() != 2)
															#line 837 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
							{
															#line 147 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
								fmt::println("{}", BULK_DUMP_STATUS_USAGE);
															#line 148 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
								if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 843 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
								new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
								this->~BulkDumpCommandActorActorState();
								static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
															#line 150 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
							StrictFuture<bool> __when_expr_6 = getOngoingBulkDumpJob(cx);
															#line 150 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
							if (static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 853 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
							if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1when4(__when_expr_6.get(), loopDepth); };
							static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state = 7;
															#line 150 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
							__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< BulkDumpCommandActorActor, 6, bool >*>(static_cast<BulkDumpCommandActorActor*>(this)));
															#line 858 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
							loopDepth = 0;
						}
						else
						{
															#line 159 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
							printUsage(tokens[0]);
															#line 160 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
							printLongDesc(tokens[0]);
															#line 161 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
							if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 869 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
							new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
							this->~BulkDumpCommandActorActorState();
							static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BulkDumpCommandActorActorState();
		static_cast<BulkDumpCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 92 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		ASSERT(tokens.size() == 3);
															#line 93 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (tokencmp(tokens[2], "on"))
															#line 901 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		{
															#line 94 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			StrictFuture<int> __when_expr_1 = setBulkDumpMode(cx, 1);
															#line 94 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 907 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state = 2;
															#line 94 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BulkDumpCommandActorActor, 1, int >*>(static_cast<BulkDumpCommandActorActor*>(this)));
															#line 912 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 97 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (tokencmp(tokens[2], "off"))
															#line 919 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			{
															#line 98 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
				StrictFuture<int> __when_expr_2 = setBulkDumpMode(cx, 0);
															#line 98 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
				if (static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 925 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when2(__when_expr_2.get(), loopDepth); };
				static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state = 3;
															#line 98 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BulkDumpCommandActorActor, 2, int >*>(static_cast<BulkDumpCommandActorActor*>(this)));
															#line 930 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 102 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
				fmt::println("ERROR: Invalid bulkdump mode value {}", tokens[2].toString());
															#line 103 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
				fmt::println("{}", BULK_DUMP_MODE_USAGE);
															#line 104 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
				if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 941 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
				new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
				this->~BulkDumpCommandActorActorState();
				static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}

		return loopDepth;
	}
	int a_body1cont4(int const& mode,int loopDepth) 
	{
															#line 83 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (mode == 0)
															#line 955 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		{
															#line 84 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			fmt::println("Bulkdump mode is disabled");
															#line 959 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		}
		else
		{
															#line 85 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (mode == 1)
															#line 965 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			{
															#line 86 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
				fmt::println("Bulkdump mode is enabled");
															#line 969 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			}
			else
			{
															#line 88 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
				fmt::println("Invalid bulkload mode value {}", mode);
															#line 975 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			}
		}
															#line 90 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 980 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkDumpCommandActorActorState();
		static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(int && mode,int loopDepth) 
	{
															#line 83 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (mode == 0)
															#line 992 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		{
															#line 84 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			fmt::println("Bulkdump mode is disabled");
															#line 996 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		}
		else
		{
															#line 85 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (mode == 1)
															#line 1002 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			{
															#line 86 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
				fmt::println("Bulkdump mode is enabled");
															#line 1006 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			}
			else
			{
															#line 88 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
				fmt::println("Invalid bulkload mode value {}", mode);
															#line 1012 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			}
		}
															#line 90 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 1017 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkDumpCommandActorActorState();
		static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int const& mode,int loopDepth) 
	{
		loopDepth = a_body1cont4(mode, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && mode,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(mode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkDumpCommandActorActor*>(this)->ActorCallback< BulkDumpCommandActorActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< BulkDumpCommandActorActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BulkDumpCommandActorActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BulkDumpCommandActorActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont11(int const& old,int loopDepth) 
	{
															#line 95 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		TraceEvent("SetBulkDumpModeCommand").detail("OldValue", old).detail("NewValue", 1);
															#line 96 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 1106 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkDumpCommandActorActorState();
		static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11(int && old,int loopDepth) 
	{
															#line 95 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		TraceEvent("SetBulkDumpModeCommand").detail("OldValue", old).detail("NewValue", 1);
															#line 96 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 1120 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkDumpCommandActorActorState();
		static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(int const& old,int loopDepth) 
	{
		loopDepth = a_body1cont11(old, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int && old,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(old), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkDumpCommandActorActor*>(this)->ActorCallback< BulkDumpCommandActorActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< BulkDumpCommandActorActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BulkDumpCommandActorActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BulkDumpCommandActorActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont13(int const& old,int loopDepth) 
	{
															#line 99 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		TraceEvent("SetBulkDumpModeCommand").detail("OldValue", old).detail("NewValue", 0);
															#line 100 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 1209 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkDumpCommandActorActorState();
		static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont13(int && old,int loopDepth) 
	{
															#line 99 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		TraceEvent("SetBulkDumpModeCommand").detail("OldValue", old).detail("NewValue", 0);
															#line 100 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 1223 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkDumpCommandActorActorState();
		static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when2(int const& old,int loopDepth) 
	{
		loopDepth = a_body1cont13(old, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when2(int && old,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(old), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkDumpCommandActorActor*>(this)->ActorCallback< BulkDumpCommandActorActor, 2, int >::remove();

	}
	void a_callback_fire(ActorCallback< BulkDumpCommandActorActor, 2, int >*,int const& value) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BulkDumpCommandActorActor, 2, int >*,int && value) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BulkDumpCommandActorActor, 2, int >*,Error err) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont16(int const& mode,int loopDepth) 
	{
															#line 109 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (mode == 0)
															#line 1310 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		{
															#line 110 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			fmt::println("ERROR: Bulkdump mode must be enabled to dump data");
															#line 111 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 1316 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkDumpCommandActorActorState();
			static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 113 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (tokens.size() != 5)
															#line 1324 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		{
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			fmt::println("{}", BULK_DUMP_DUMP_USAGE);
															#line 115 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 1330 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkDumpCommandActorActorState();
			static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 117 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		Key rangeBegin = tokens[2];
															#line 118 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		Key rangeEnd = tokens[3];
															#line 120 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (rangeBegin >= rangeEnd || rangeEnd > normalKeys.end)
															#line 1342 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		{
															#line 121 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			fmt::println( "ERROR: Invalid range: {} to {}, normal key space only", rangeBegin.toString(), rangeEnd.toString());
															#line 123 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			fmt::println("{}", BULK_DUMP_DUMP_USAGE);
															#line 124 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 1350 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkDumpCommandActorActorState();
			static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 126 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		KeyRange range = Standalone(KeyRangeRef(rangeBegin, rangeEnd));
															#line 127 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		std::string jobRoot = tokens[4].toString();
															#line 128 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		bulkDumpJob = createBulkDumpJob(range, jobRoot, BulkLoadType::SST, jobRoot.find("blobstore://") == 0 ? BulkLoadTransportMethod::BLOBSTORE : BulkLoadTransportMethod::CP);
															#line 133 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		StrictFuture<Void> __when_expr_4 = submitBulkDumpJob(cx, bulkDumpJob);
															#line 133 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1366 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont16when1(__when_expr_4.get(), loopDepth); };
		static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state = 5;
															#line 133 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BulkDumpCommandActorActor, 4, Void >*>(static_cast<BulkDumpCommandActorActor*>(this)));
															#line 1371 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont16(int && mode,int loopDepth) 
	{
															#line 109 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (mode == 0)
															#line 1380 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		{
															#line 110 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			fmt::println("ERROR: Bulkdump mode must be enabled to dump data");
															#line 111 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 1386 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkDumpCommandActorActorState();
			static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 113 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (tokens.size() != 5)
															#line 1394 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		{
															#line 114 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			fmt::println("{}", BULK_DUMP_DUMP_USAGE);
															#line 115 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 1400 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkDumpCommandActorActorState();
			static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 117 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		Key rangeBegin = tokens[2];
															#line 118 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		Key rangeEnd = tokens[3];
															#line 120 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (rangeBegin >= rangeEnd || rangeEnd > normalKeys.end)
															#line 1412 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		{
															#line 121 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			fmt::println( "ERROR: Invalid range: {} to {}, normal key space only", rangeBegin.toString(), rangeEnd.toString());
															#line 123 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			fmt::println("{}", BULK_DUMP_DUMP_USAGE);
															#line 124 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 1420 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkDumpCommandActorActorState();
			static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 126 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		KeyRange range = Standalone(KeyRangeRef(rangeBegin, rangeEnd));
															#line 127 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		std::string jobRoot = tokens[4].toString();
															#line 128 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		bulkDumpJob = createBulkDumpJob(range, jobRoot, BulkLoadType::SST, jobRoot.find("blobstore://") == 0 ? BulkLoadTransportMethod::BLOBSTORE : BulkLoadTransportMethod::CP);
															#line 133 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		StrictFuture<Void> __when_expr_4 = submitBulkDumpJob(cx, bulkDumpJob);
															#line 133 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1436 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont16when1(__when_expr_4.get(), loopDepth); };
		static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state = 5;
															#line 133 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BulkDumpCommandActorActor, 4, Void >*>(static_cast<BulkDumpCommandActorActor*>(this)));
															#line 1441 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when2(int const& mode,int loopDepth) 
	{
		loopDepth = a_body1cont16(mode, loopDepth);

		return loopDepth;
	}
	int a_body1when2(int && mode,int loopDepth) 
	{
		loopDepth = a_body1cont16(std::move(mode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkDumpCommandActorActor*>(this)->ActorCallback< BulkDumpCommandActorActor, 3, int >::remove();

	}
	void a_callback_fire(ActorCallback< BulkDumpCommandActorActor, 3, int >*,int const& value) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< BulkDumpCommandActorActor, 3, int >*,int && value) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< BulkDumpCommandActorActor, 3, int >*,Error err) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont16cont1(Void const& _,int loopDepth) 
	{
															#line 134 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(bulkDumpJob.getJobId()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 1525 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(bulkDumpJob.getJobId());
		this->~BulkDumpCommandActorActorState();
		static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont16cont1(Void && _,int loopDepth) 
	{
															#line 134 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(bulkDumpJob.getJobId()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 1537 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(bulkDumpJob.getJobId());
		this->~BulkDumpCommandActorActorState();
		static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont16when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont16when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkDumpCommandActorActor*>(this)->ActorCallback< BulkDumpCommandActorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkDumpCommandActorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont16when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< BulkDumpCommandActorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont16when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< BulkDumpCommandActorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont18(Void const& _,int loopDepth) 
	{
															#line 142 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		fmt::println("Job {} has been cancelled. No new tasks will be spawned.", jobId.toString());
															#line 143 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 1626 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkDumpCommandActorActorState();
		static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont18(Void && _,int loopDepth) 
	{
															#line 142 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		fmt::println("Job {} has been cancelled. No new tasks will be spawned.", jobId.toString());
															#line 143 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 1640 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkDumpCommandActorActorState();
		static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont18(_, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont18(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkDumpCommandActorActor*>(this)->ActorCallback< BulkDumpCommandActorActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkDumpCommandActorActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< BulkDumpCommandActorActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< BulkDumpCommandActorActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont21(bool const& anyJob,int loopDepth) 
	{
															#line 151 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (!anyJob)
															#line 1727 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		{
															#line 152 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 1731 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkDumpCommandActorActorState();
			static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 154 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		KeyRange range = Standalone(KeyRangeRef(normalKeys.begin, normalKeys.end));
															#line 155 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		StrictFuture<Void> __when_expr_7 = getBulkDumpCompleteRanges(cx, range);
															#line 155 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1743 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont21when1(__when_expr_7.get(), loopDepth); };
		static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state = 8;
															#line 155 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< BulkDumpCommandActorActor, 7, Void >*>(static_cast<BulkDumpCommandActorActor*>(this)));
															#line 1748 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont21(bool && anyJob,int loopDepth) 
	{
															#line 151 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (!anyJob)
															#line 1757 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		{
															#line 152 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
			if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 1761 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
			new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkDumpCommandActorActorState();
			static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 154 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		KeyRange range = Standalone(KeyRangeRef(normalKeys.begin, normalKeys.end));
															#line 155 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		StrictFuture<Void> __when_expr_7 = getBulkDumpCompleteRanges(cx, range);
															#line 155 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1773 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont21when1(__when_expr_7.get(), loopDepth); };
		static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state = 8;
															#line 155 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< BulkDumpCommandActorActor, 7, Void >*>(static_cast<BulkDumpCommandActorActor*>(this)));
															#line 1778 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when4(bool const& anyJob,int loopDepth) 
	{
		loopDepth = a_body1cont21(anyJob, loopDepth);

		return loopDepth;
	}
	int a_body1when4(bool && anyJob,int loopDepth) 
	{
		loopDepth = a_body1cont21(std::move(anyJob), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkDumpCommandActorActor*>(this)->ActorCallback< BulkDumpCommandActorActor, 6, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BulkDumpCommandActorActor, 6, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< BulkDumpCommandActorActor, 6, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< BulkDumpCommandActorActor, 6, bool >*,Error err) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont21cont1(Void const& _,int loopDepth) 
	{
															#line 156 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 1862 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkDumpCommandActorActorState();
		static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont21cont1(Void && _,int loopDepth) 
	{
															#line 156 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
		if (!static_cast<BulkDumpCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkDumpCommandActorActorState(); static_cast<BulkDumpCommandActorActor*>(this)->destroy(); return 0; }
															#line 1874 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		new (&static_cast<BulkDumpCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkDumpCommandActorActorState();
		static_cast<BulkDumpCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont21when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont21cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont21when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont21cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkDumpCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkDumpCommandActorActor*>(this)->ActorCallback< BulkDumpCommandActorActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkDumpCommandActorActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont21when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< BulkDumpCommandActorActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont21when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< BulkDumpCommandActorActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 74 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
	Database cx;
															#line 74 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 75 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
	BulkDumpState bulkDumpJob;
															#line 140 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
	UID jobId;
															#line 1965 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
};
// This generated class is to be used only via bulkDumpCommandActor()
															#line 74 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
class BulkDumpCommandActorActor final : public Actor<UID>, public ActorCallback< BulkDumpCommandActorActor, 0, int >, public ActorCallback< BulkDumpCommandActorActor, 1, int >, public ActorCallback< BulkDumpCommandActorActor, 2, int >, public ActorCallback< BulkDumpCommandActorActor, 3, int >, public ActorCallback< BulkDumpCommandActorActor, 4, Void >, public ActorCallback< BulkDumpCommandActorActor, 5, Void >, public ActorCallback< BulkDumpCommandActorActor, 6, bool >, public ActorCallback< BulkDumpCommandActorActor, 7, Void >, public FastAllocated<BulkDumpCommandActorActor>, public BulkDumpCommandActorActorState<BulkDumpCommandActorActor> {
															#line 1970 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
public:
	using FastAllocated<BulkDumpCommandActorActor>::operator new;
	using FastAllocated<BulkDumpCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17252958935830540032UL, 5991787801836452608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<UID>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BulkDumpCommandActorActor, 0, int >;
friend struct ActorCallback< BulkDumpCommandActorActor, 1, int >;
friend struct ActorCallback< BulkDumpCommandActorActor, 2, int >;
friend struct ActorCallback< BulkDumpCommandActorActor, 3, int >;
friend struct ActorCallback< BulkDumpCommandActorActor, 4, Void >;
friend struct ActorCallback< BulkDumpCommandActorActor, 5, Void >;
friend struct ActorCallback< BulkDumpCommandActorActor, 6, bool >;
friend struct ActorCallback< BulkDumpCommandActorActor, 7, Void >;
															#line 74 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
	BulkDumpCommandActorActor(Database const& cx,std::vector<StringRef> const& tokens) 
															#line 1994 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
		 : Actor<UID>(),
		   BulkDumpCommandActorActorState<BulkDumpCommandActorActor>(cx, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8449557364556612864UL, 7791445713743684864UL);
		ActorExecutionContextHelper __helper(static_cast<BulkDumpCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bulkDumpCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bulkDumpCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BulkDumpCommandActorActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BulkDumpCommandActorActor, 1, int >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BulkDumpCommandActorActor, 2, int >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< BulkDumpCommandActorActor, 3, int >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< BulkDumpCommandActorActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< BulkDumpCommandActorActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< BulkDumpCommandActorActor, 6, bool >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< BulkDumpCommandActorActor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 74 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
[[nodiscard]] Future<UID> bulkDumpCommandActor( Database const& cx, std::vector<StringRef> const& tokens ) {
															#line 74 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"
	return Future<UID>(new BulkDumpCommandActorActor(cx, tokens));
															#line 2033 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/build_output/fdbcli/BulkDumpCommand.actor.g.cpp"
}

#line 164 "/codebuild/output/src1900875502/src/github.com/apple/foundationdb/fdbcli/BulkDumpCommand.actor.cpp"

CommandFactory bulkDumpFactory("bulkdump",
                               CommandHelp("bulkdump [mode|dump|status|cancel] [ARGs]",
                                           "bulkdump commands",
                                           BULK_DUMP_HELP_MESSAGE.c_str()));
} // namespace fdb_cli
