#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
/*
 * StatusWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbclient/StatusClient.h"
#include "flow/UnitTest.h"
#include "fdbclient/Schemas.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct StatusWorkload : TestWorkload {
	static constexpr auto NAME = "Status";

	double testDuration, requestsPerSecond;
	bool enableLatencyBands;

	Future<Void> latencyBandActor;

	PerfIntCounter requests, replies, errors, totalSize;
	Optional<StatusObject> parsedSchema;

	StatusWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), requests("Status requests issued"), replies("Status replies received"),
	    errors("Status Errors"), totalSize("Status reply size sum") {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		requestsPerSecond = getOption(options, "requestsPerSecond"_sr, 0.5);
		enableLatencyBands = getOption(options, "enableLatencyBands"_sr, deterministicRandom()->random01() < 0.5);
		auto statusSchemaStr = getOption(options, "schema"_sr, JSONSchemas::statusSchema);
		if (statusSchemaStr.size()) {
			json_spirit::mValue schema = readJSONStrictly(statusSchemaStr.toString());
			parsedSchema = schema.get_obj();

			// This is sort of a hack, but generate code coverage *requirements* for everything in schema
			schemaCoverageRequirements(parsedSchema.get());
		}
	}

	Future<Void> setup(Database const& cx) override {
		if (enableLatencyBands) {
			latencyBandActor = configureLatencyBands(this, cx);
		}

		return Void();
	}
	Future<Void> start(Database const& cx) override {
		if (clientId != 0)
			return Void();

		return success(timeout(fetcher(cx, this), testDuration));
	}
	Future<bool> check(Database const& cx) override { return errors.getValue() == 0; }

	void getMetrics(std::vector<PerfMetric>& m) override {
		if (clientId != 0)
			return;

		m.push_back(requests.getMetric());
		m.push_back(replies.getMetric());
		m.emplace_back(
		    "Average Reply Size", replies.getValue() ? totalSize.getValue() / replies.getValue() : 0, Averaged::False);
		m.push_back(errors.getMetric());
	}

	static void schemaCoverageRequirements(StatusObject const& schema, std::string schema_path = std::string()) {
		try {
			for (auto& skv : schema) {
				std::string spath = schema_path + "." + skv.first;

				schemaCoverage(spath, false);

				if (skv.second.type() == json_spirit::array_type && skv.second.get_array().size()) {
					if (skv.second.get_array()[0].type() != json_spirit::str_type)
						schemaCoverageRequirements(skv.second.get_array()[0].get_obj(), spath + "[0]");
				} else if (skv.second.type() == json_spirit::obj_type) {
					if (skv.second.get_obj().count("$enum")) {
						for (auto& enum_item : skv.second.get_obj().at("$enum").get_array())
							schemaCoverage(spath + ".$enum." + enum_item.get_str(), false);
					} else
						schemaCoverageRequirements(skv.second.get_obj(), spath);
				}
			}
		} catch (std::exception& e) {
			TraceEvent(SevError, "SchemaCoverageRequirementsException").detail("What", e.what());
			throw unknown_error();
		} catch (...) {
			TraceEvent(SevError, "SchemaCoverageRequirementsException").log();
			throw unknown_error();
		}
	}

	static std::string generateBands() {
		int numBands = deterministicRandom()->randomInt(0, 10);
		std::vector<double> bands;

		while (bands.size() < numBands) {
			bands.push_back(deterministicRandom()->random01() * pow(10, deterministicRandom()->randomInt(-5, 1)));
		}

		std::string result = "\"bands\":[";
		for (int i = 0; i < bands.size(); ++i) {
			if (i > 0) {
				result += ",";
			}

			result += format("%f", bands[i]);
		}

		return result + "]";
	}

																#line 132 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
// This generated class is to be used only via configureLatencyBands()
															#line 130 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
template <class ConfigureLatencyBandsActor>
															#line 130 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
class ConfigureLatencyBandsActorState {
															#line 138 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
public:
															#line 130 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
	ConfigureLatencyBandsActorState(StatusWorkload* const& self,Database const& cx) 
															#line 130 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
															#line 130 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		 : self(self),
															#line 130 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		   cx(cx)
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("configureLatencyBands", reinterpret_cast<unsigned long>(this));

	}
	~ConfigureLatencyBandsActorState() 
	{
		fdb_probe_actor_destroy("configureLatencyBands", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 131 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			;
															#line 162 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigureLatencyBandsActorState();
		static_cast<ConfigureLatencyBandsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 132 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		tr = Transaction(cx);
															#line 133 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		;
															#line 194 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 135 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 136 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 138 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			std::string config = "{" "\"get_read_version\":{" + generateBands() + "}," "\"read\":{" + generateBands() + format(", \"max_key_selector_offset\":%d, \"max_read_bytes\":%d},", deterministicRandom()->randomInt(0, 10000), deterministicRandom()->randomInt(0, 1000000)) + "" "\"commit\":{" + generateBands() + format(", \"max_commit_bytes\":%d", deterministicRandom()->randomInt(0, 1000000)) + "}" "}";
															#line 155 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			tr.set(latencyBandConfigKey, ValueRef(config));
															#line 156 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 156 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			if (static_cast<ConfigureLatencyBandsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 221 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConfigureLatencyBandsActor*>(this)->actor_wait_state = 1;
															#line 156 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigureLatencyBandsActor, 0, Void >*>(static_cast<ConfigureLatencyBandsActor*>(this)));
															#line 226 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 165 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 165 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			if (static_cast<ConfigureLatencyBandsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 250 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ConfigureLatencyBandsActor*>(this)->actor_wait_state = 3;
															#line 165 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConfigureLatencyBandsActor, 2, Void >*>(static_cast<ConfigureLatencyBandsActor*>(this)));
															#line 255 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 157 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		tr.reset();
															#line 159 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		if (deterministicRandom()->random01() < 0.3)
															#line 272 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
		{
															#line 160 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			if (!static_cast<ConfigureLatencyBandsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureLatencyBandsActorState(); static_cast<ConfigureLatencyBandsActor*>(this)->destroy(); return 0; }
															#line 276 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
			new (&static_cast<ConfigureLatencyBandsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ConfigureLatencyBandsActorState();
			static_cast<ConfigureLatencyBandsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 163 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(deterministicRandom()->random01() * 120);
															#line 163 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		if (static_cast<ConfigureLatencyBandsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 286 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ConfigureLatencyBandsActor*>(this)->actor_wait_state = 2;
															#line 163 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigureLatencyBandsActor, 1, Void >*>(static_cast<ConfigureLatencyBandsActor*>(this)));
															#line 291 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 157 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		tr.reset();
															#line 159 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		if (deterministicRandom()->random01() < 0.3)
															#line 302 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
		{
															#line 160 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			if (!static_cast<ConfigureLatencyBandsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureLatencyBandsActorState(); static_cast<ConfigureLatencyBandsActor*>(this)->destroy(); return 0; }
															#line 306 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
			new (&static_cast<ConfigureLatencyBandsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ConfigureLatencyBandsActorState();
			static_cast<ConfigureLatencyBandsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 163 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(deterministicRandom()->random01() * 120);
															#line 163 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		if (static_cast<ConfigureLatencyBandsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 316 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ConfigureLatencyBandsActor*>(this)->actor_wait_state = 2;
															#line 163 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigureLatencyBandsActor, 1, Void >*>(static_cast<ConfigureLatencyBandsActor*>(this)));
															#line 321 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigureLatencyBandsActor*>(this)->actor_wait_state > 0) static_cast<ConfigureLatencyBandsActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureLatencyBandsActor*>(this)->ActorCallback< ConfigureLatencyBandsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureLatencyBandsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureLatencyBands", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureLatencyBandsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureLatencyBands", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigureLatencyBandsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureLatencyBands", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureLatencyBandsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureLatencyBands", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigureLatencyBandsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureLatencyBands", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureLatencyBandsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureLatencyBands", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConfigureLatencyBandsActor*>(this)->actor_wait_state > 0) static_cast<ConfigureLatencyBandsActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureLatencyBandsActor*>(this)->ActorCallback< ConfigureLatencyBandsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureLatencyBandsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureLatencyBands", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureLatencyBandsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureLatencyBands", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConfigureLatencyBandsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureLatencyBands", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureLatencyBandsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureLatencyBands", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConfigureLatencyBandsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureLatencyBands", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureLatencyBandsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureLatencyBands", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConfigureLatencyBandsActor*>(this)->actor_wait_state > 0) static_cast<ConfigureLatencyBandsActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureLatencyBandsActor*>(this)->ActorCallback< ConfigureLatencyBandsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureLatencyBandsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureLatencyBands", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureLatencyBandsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureLatencyBands", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConfigureLatencyBandsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureLatencyBands", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureLatencyBandsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureLatencyBands", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConfigureLatencyBandsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureLatencyBands", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureLatencyBandsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureLatencyBands", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 130 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
	StatusWorkload* self;
															#line 130 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
	Database cx;
															#line 132 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
	Transaction tr;
															#line 594 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
};
// This generated class is to be used only via configureLatencyBands()
															#line 130 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
class ConfigureLatencyBandsActor final : public Actor<Void>, public ActorCallback< ConfigureLatencyBandsActor, 0, Void >, public ActorCallback< ConfigureLatencyBandsActor, 1, Void >, public ActorCallback< ConfigureLatencyBandsActor, 2, Void >, public FastAllocated<ConfigureLatencyBandsActor>, public ConfigureLatencyBandsActorState<ConfigureLatencyBandsActor> {
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
public:
	using FastAllocated<ConfigureLatencyBandsActor>::operator new;
	using FastAllocated<ConfigureLatencyBandsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2885022007304077824UL, 10723918341495505664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigureLatencyBandsActor, 0, Void >;
friend struct ActorCallback< ConfigureLatencyBandsActor, 1, Void >;
friend struct ActorCallback< ConfigureLatencyBandsActor, 2, Void >;
															#line 130 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
	ConfigureLatencyBandsActor(StatusWorkload* const& self,Database const& cx) 
															#line 618 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ConfigureLatencyBandsActorState<ConfigureLatencyBandsActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configureLatencyBands", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2336668866054850560UL, 4923025586775729920UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureLatencyBandsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configureLatencyBands");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configureLatencyBands", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigureLatencyBandsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConfigureLatencyBandsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConfigureLatencyBandsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 130 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
[[nodiscard]] Future<Void> configureLatencyBands( StatusWorkload* const& self, Database const& cx ) {
															#line 130 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
	return Future<Void>(new ConfigureLatencyBandsActor(self, cx));
															#line 652 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
}

#line 170 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"

																#line 657 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
// This generated class is to be used only via fetcher()
															#line 171 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
template <class FetcherActor>
															#line 171 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
class FetcherActorState {
															#line 663 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
public:
															#line 171 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
	FetcherActorState(Database const& cx,StatusWorkload* const& self) 
															#line 171 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
															#line 171 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		 : cx(cx),
															#line 171 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		   self(self),
															#line 172 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		   lastTime(now())
															#line 674 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("fetcher", reinterpret_cast<unsigned long>(this));

	}
	~FetcherActorState() 
	{
		fdb_probe_actor_destroy("fetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 174 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			;
															#line 689 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetcherActorState();
		static_cast<FetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 175 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, 1.0 / self->requestsPerSecond);
															#line 175 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		if (static_cast<FetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 721 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FetcherActor*>(this)->actor_wait_state = 1;
															#line 175 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetcherActor, 0, Void >*>(static_cast<FetcherActor*>(this)));
															#line 726 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		try {
															#line 178 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			++self->requests;
															#line 179 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			issued = now();
															#line 180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			StrictFuture<StatusObject> __when_expr_1 = StatusClient::statusFetcher(cx);
															#line 180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			if (static_cast<FetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 742 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FetcherActor*>(this)->actor_wait_state = 2;
															#line 180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetcherActor, 1, StatusObject >*>(static_cast<FetcherActor*>(this)));
															#line 747 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		try {
															#line 178 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			++self->requests;
															#line 179 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			issued = now();
															#line 180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			StrictFuture<StatusObject> __when_expr_1 = StatusClient::statusFetcher(cx);
															#line 180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			if (static_cast<FetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 769 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FetcherActor*>(this)->actor_wait_state = 2;
															#line 180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetcherActor, 1, StatusObject >*>(static_cast<FetcherActor*>(this)));
															#line 774 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetcherActor*>(this)->actor_wait_state > 0) static_cast<FetcherActor*>(this)->actor_wait_state = 0;
		static_cast<FetcherActor*>(this)->ActorCallback< FetcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 197 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 871 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
			{
															#line 198 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
				TraceEvent(SevError, "StatusWorkloadError").error(e);
															#line 199 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
				++self->errors;
															#line 877 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
			}
															#line 201 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 881 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(StatusObject const& result,int loopDepth) 
	{
															#line 181 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		++self->replies;
															#line 182 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		BinaryWriter br(AssumeVersion(g_network->protocolVersion()));
															#line 183 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		save(br, result);
															#line 184 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		self->totalSize += br.getLength();
															#line 185 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		TraceEvent("StatusWorkloadReply") .detail("ReplySize", br.getLength()) .detail("Latency", now() - issued);
															#line 189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		std::string errorStr;
															#line 190 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		if (self->parsedSchema.present() && !schemaMatch(self->parsedSchema.get(), result, errorStr, SevError, true))
															#line 907 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
		{
															#line 192 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			std::cout << errorStr << std::endl;
															#line 193 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			TraceEvent(SevError, "StatusWorkloadValidationFailed") .detail("JSON", json_spirit::write_string(json_spirit::mValue(result)));
															#line 913 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(StatusObject && result,int loopDepth) 
	{
															#line 181 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		++self->replies;
															#line 182 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		BinaryWriter br(AssumeVersion(g_network->protocolVersion()));
															#line 183 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		save(br, result);
															#line 184 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		self->totalSize += br.getLength();
															#line 185 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		TraceEvent("StatusWorkloadReply") .detail("ReplySize", br.getLength()) .detail("Latency", now() - issued);
															#line 189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		std::string errorStr;
															#line 190 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		if (self->parsedSchema.present() && !schemaMatch(self->parsedSchema.get(), result, errorStr, SevError, true))
															#line 935 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
		{
															#line 192 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			std::cout << errorStr << std::endl;
															#line 193 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			TraceEvent(SevError, "StatusWorkloadValidationFailed") .detail("JSON", json_spirit::write_string(json_spirit::mValue(result)));
															#line 941 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(StatusObject const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(StatusObject && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FetcherActor*>(this)->actor_wait_state > 0) static_cast<FetcherActor*>(this)->actor_wait_state = 0;
		static_cast<FetcherActor*>(this)->ActorCallback< FetcherActor, 1, StatusObject >::remove();

	}
	void a_callback_fire(ActorCallback< FetcherActor, 1, StatusObject >*,StatusObject const& value) 
	{
		fdb_probe_actor_enter("fetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetcherActor, 1, StatusObject >*,StatusObject && value) 
	{
		fdb_probe_actor_enter("fetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetcherActor, 1, StatusObject >*,Error err) 
	{
		fdb_probe_actor_enter("fetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 171 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
	Database cx;
															#line 171 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
	StatusWorkload* self;
															#line 172 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
	double lastTime;
															#line 179 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
	double issued;
															#line 1043 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
};
// This generated class is to be used only via fetcher()
															#line 171 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
class FetcherActor final : public Actor<Void>, public ActorCallback< FetcherActor, 0, Void >, public ActorCallback< FetcherActor, 1, StatusObject >, public FastAllocated<FetcherActor>, public FetcherActorState<FetcherActor> {
															#line 1048 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
public:
	using FastAllocated<FetcherActor>::operator new;
	using FastAllocated<FetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10450674821826505472UL, 1458288662324764928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetcherActor, 0, Void >;
friend struct ActorCallback< FetcherActor, 1, StatusObject >;
															#line 171 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
	FetcherActor(Database const& cx,StatusWorkload* const& self) 
															#line 1066 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FetcherActorState<FetcherActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6613507864560574976UL, 12983846502983084032UL);
		ActorExecutionContextHelper __helper(static_cast<FetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetcherActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FetcherActor, 1, StatusObject >*)0, actor_cancelled()); break;
		}

	}
};
															#line 171 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
[[nodiscard]] Future<Void> fetcher( Database const& cx, StatusWorkload* const& self ) {
															#line 171 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
	return Future<Void>(new FetcherActor(cx, self));
															#line 1099 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
}

#line 205 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
};

WorkloadFactory<StatusWorkload> StatusWorkloadFactory;

															#line 1107 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase209()
															#line 209 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
template <class FlowTestCase209Actor>
															#line 209 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
class FlowTestCase209ActorState {
															#line 1114 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
public:
															#line 209 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
	FlowTestCase209ActorState(UnitTestParameters const& params) 
															#line 209 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
															#line 209 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
		 : params(params)
															#line 1121 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase209", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase209ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase209", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 210 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			json_spirit::mValue schema = readJSONStrictly("{\"apple\":3,\"banana\":\"foo\",\"sub\":{\"thing\":true},\"arr\":[{\"a\":1,\"b\":2}],\"en\":{" "\"$enum\":[\"foo\",\"bar\"]},\"mapped\":{\"$map\":{\"x\":true}}}");
															#line 213 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			auto check = [&schema](bool expect_ok, std::string t) { json_spirit::mValue test = readJSONStrictly(t); TraceEvent("SchemaMatch") .detail("Schema", json_spirit::write_string(schema)) .detail("Value", json_spirit::write_string(test)) .detail("Expect", expect_ok); std::string errorStr; ASSERT(expect_ok == schemaMatch(schema.get_obj(), test.get_obj(), errorStr, expect_ok ? SevError : SevInfo, true)); };
															#line 223 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			check(true, "{}");
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			check(true, "{\"apple\":4}");
															#line 225 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			check(false, "{\"apple\":\"wrongtype\"}");
															#line 226 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			check(false, "{\"extrathingy\":1}");
															#line 227 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			check(true, "{\"banana\":\"b\",\"sub\":{\"thing\":false}}");
															#line 228 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			check(false, "{\"banana\":\"b\",\"sub\":{\"thing\":false, \"x\":0}}");
															#line 229 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			check(true, "{\"arr\":[{},{\"a\":0}]}");
															#line 230 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			check(false, "{\"arr\":[{\"a\":0},{\"c\":0}]}");
															#line 231 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			check(true, "{\"en\":\"bar\"}");
															#line 232 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			check(false, "{\"en\":\"baz\"}");
															#line 233 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			check(true, "{\"mapped\":{\"item1\":{\"x\":false},\"item2\":{}}}");
															#line 234 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			check(false, "{\"mapped\":{\"item1\":{\"x\":false},\"item2\":{\"y\":1}}}");
															#line 236 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
			if (!static_cast<FlowTestCase209Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase209ActorState(); static_cast<FlowTestCase209Actor*>(this)->destroy(); return 0; }
															#line 1164 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase209Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase209ActorState();
			static_cast<FlowTestCase209Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase209ActorState();
		static_cast<FlowTestCase209Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 209 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
	UnitTestParameters params;
															#line 1188 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase209()
															#line 209 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
class FlowTestCase209Actor final : public Actor<Void>, public FastAllocated<FlowTestCase209Actor>, public FlowTestCase209ActorState<FlowTestCase209Actor> {
															#line 1193 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase209Actor>::operator new;
	using FastAllocated<FlowTestCase209Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5879763090632829952UL, 17870462347669648384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 209 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
	FlowTestCase209Actor(UnitTestParameters const& params) 
															#line 1209 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase209ActorState<FlowTestCase209Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase209", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3158976635586191360UL, 1289054631544811520UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase209Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase209");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase209", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 209 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
static Future<Void> flowTestCase209( UnitTestParameters const& params ) {
															#line 209 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
	return Future<Void>(new FlowTestCase209Actor(params));
															#line 1241 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/StatusWorkload.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase209, "/fdbserver/status/schema/basic")

#line 238 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/StatusWorkload.actor.cpp"
